/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.reduction;

import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.predefined.PredefinedElkIri;
import org.semanticweb.elk.reasoner.ReasonerJob;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.reduction.SaturationJobForTransitiveReduction;
import org.semanticweb.elk.reasoner.reduction.SaturationJobRoot;
import org.semanticweb.elk.reasoner.reduction.SaturationJobSuperClass;
import org.semanticweb.elk.reasoner.reduction.SaturationJobVisitor;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionJob;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionListener;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionState;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationFactory;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

public class TransitiveReductionFactory<R extends IndexedClassExpression, J extends TransitiveReductionJob<R>>
extends SimpleInterrupter
implements InputProcessorFactory<J, Engine> {
    private static final Logger LOGGER_ = Logger.getLogger(TransitiveReductionFactory.class);
    private final TransitiveReductionListener<J> listener_;
    private final SaturationOutputProcessor saturationOutputProcessor_ = new SaturationOutputProcessor();
    private final Queue<SaturationJobSuperClass<R, J>> auxJobQueue_;
    private final Queue<J> jobsWithSaturatedRoot_;
    private final ClassExpressionSaturationFactory<SaturationJobForTransitiveReduction<R, ?, J>> saturationFactory_;
    private final TransitiveReductionOutputEquivalent<IndexedClass> defaultTopOutput_;

    public TransitiveReductionFactory(SaturationState saturationState, int maxWorkers, TransitiveReductionListener<J> listener) {
        this.listener_ = listener;
        this.auxJobQueue_ = new ConcurrentLinkedQueue<SaturationJobSuperClass<R, J>>();
        this.jobsWithSaturatedRoot_ = new ConcurrentLinkedQueue<J>();
        this.saturationFactory_ = new ClassExpressionSaturationFactory(saturationState, maxWorkers, new ThisClassExpressionSaturationListener());
        this.defaultTopOutput_ = new TransitiveReductionOutputEquivalent<IndexedClass>(saturationState.getOntologyIndex().getIndexedOwlThing());
        this.defaultTopOutput_.equivalent.add(PredefinedElkClass.OWL_THING);
    }

    @Override
    public Engine getEngine() {
        return new Engine();
    }

    @Override
    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.saturationFactory_.setInterrupt(flag);
    }

    @Override
    public void finish() {
        this.saturationFactory_.finish();
    }

    public void printStatistics() {
        this.saturationFactory_.printStatistics();
    }

    public SaturationStatistics getRuleAndConclusionStatistics() {
        return this.saturationFactory_.getRuleAndConclusionStatistics();
    }

    private boolean isTop(IndexedClass clazz) {
        return clazz.getElkClass().getIri() == PredefinedElkIri.OWL_THING.get();
    }

    public class Engine
    implements InputProcessor<J> {
        private final ClassExpressionSaturationFactory.Engine saturationEngine;

        private Engine() {
            this.saturationEngine = TransitiveReductionFactory.this.saturationFactory_.getEngine();
        }

        @Override
        public final void submit(J job) {
            Context context;
            IndexedClassExpression root = (IndexedClassExpression)((ReasonerJob)job).getInput();
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace(root + ": transitive reduction started");
            }
            if ((context = root.getContext()) != null && context.isSaturated()) {
                TransitiveReductionFactory.this.jobsWithSaturatedRoot_.add(job);
            } else {
                this.saturationEngine.submit(new SaturationJobRoot(job));
            }
        }

        @Override
        public final void process() throws InterruptedException {
            while (true) {
                if (TransitiveReductionFactory.this.isInterrupted()) {
                    return;
                }
                TransitiveReductionJob processedJob = (TransitiveReductionJob)TransitiveReductionFactory.this.jobsWithSaturatedRoot_.poll();
                if (processedJob != null) {
                    TransitiveReductionFactory.this.saturationOutputProcessor_.processRootSaturation(processedJob);
                    continue;
                }
                this.saturationEngine.process();
                SaturationJobForTransitiveReduction nextJob = (SaturationJobForTransitiveReduction)TransitiveReductionFactory.this.auxJobQueue_.poll();
                if (nextJob == null) break;
                this.saturationEngine.submit(nextJob);
            }
        }

        @Override
        public void finish() {
            this.saturationEngine.finish();
        }
    }

    private class SaturationOutputProcessor
    implements SaturationJobVisitor<R, J> {
        private SaturationOutputProcessor() {
        }

        @Override
        public void visit(SaturationJobRoot<R, J> saturationJob) throws InterruptedException {
            this.processRootSaturation(saturationJob.initiatorJob);
        }

        @Override
        public void visit(SaturationJobSuperClass<R, J> saturationJob) throws InterruptedException {
            IndexedClass candidate = (IndexedClass)saturationJob.getInput();
            TransitiveReductionState state = saturationJob.state;
            this.updateTransitiveReductionOutput(state.output, candidate, candidate.getContext());
            this.processTransitiveReductionState(state);
        }

        private void processRootSaturation(J initiatorJob) throws InterruptedException {
            IndexedClassExpression root = (IndexedClassExpression)((ReasonerJob)initiatorJob).getInput();
            Context saturation = root.getContext();
            if (saturation.isInconsistent()) {
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace(root + ": transitive reduction finished: inconsistent");
                }
                TransitiveReductionOutputUnsatisfiable<IndexedClassExpression> output = new TransitiveReductionOutputUnsatisfiable<IndexedClassExpression>(root);
                ((TransitiveReductionJob)initiatorJob).setOutput(output);
                TransitiveReductionFactory.this.listener_.notifyFinished(initiatorJob);
                return;
            }
            TransitiveReductionState state = new TransitiveReductionState(initiatorJob);
            this.processTransitiveReductionState(state);
        }

        private void processTransitiveReductionState(TransitiveReductionState<R, J> state) throws InterruptedException {
            Iterator<IndexedClassExpression> subsumerIterator = state.subsumerIterator;
            while (subsumerIterator.hasNext()) {
                IndexedClassExpression next = subsumerIterator.next();
                if (!(next instanceof IndexedClass)) continue;
                IndexedClass candidate = (IndexedClass)next;
                Context candidateSaturation = candidate.getContext();
                if (candidateSaturation == null || !candidateSaturation.isSaturated()) {
                    TransitiveReductionFactory.this.auxJobQueue_.add(new SaturationJobSuperClass(candidate, state));
                    return;
                }
                this.updateTransitiveReductionOutput(state.output, candidate, candidateSaturation);
            }
            TransitiveReductionOutputEquivalentDirect output = state.output;
            if (output.directSubsumers.isEmpty() && !output.getEquivalent().contains(PredefinedElkClass.OWL_THING)) {
                output.directSubsumers.add(TransitiveReductionFactory.this.defaultTopOutput_);
            }
            ((TransitiveReductionJob)state.initiatorJob).setOutput(output);
            TransitiveReductionFactory.this.listener_.notifyFinished(state.initiatorJob);
            if (LOGGER_.isTraceEnabled()) {
                Object root = output.getRoot();
                LOGGER_.trace(root + ": transitive reduction finished");
                for (ElkClass elkClass : output.equivalent) {
                    LOGGER_.trace(root + ": equivalent " + elkClass.getIri());
                }
                for (TransitiveReductionOutputEquivalent transitiveReductionOutputEquivalent : output.directSubsumers) {
                    String message = root + ": direct super class [" + transitiveReductionOutputEquivalent.getRoot();
                    for (ElkClass equivalent : transitiveReductionOutputEquivalent.equivalent) {
                        message = message + ", " + equivalent.getIri();
                    }
                    message = message + "]";
                    LOGGER_.trace(message);
                }
            }
        }

        private void updateTransitiveReductionOutput(TransitiveReductionOutputEquivalentDirect<R> output, IndexedClass candidate, Context candidateSaturation) {
            Object root = output.getRoot();
            if (candidate == root) {
                output.equivalent.add(candidate.getElkClass());
                return;
            }
            Set<IndexedClassExpression> candidateSupers = candidateSaturation.getSubsumers();
            if (candidateSupers.contains(root)) {
                output.equivalent.add(candidate.getElkClass());
                return;
            }
            boolean isCandidateTop = TransitiveReductionFactory.this.isTop(candidate);
            Iterator<TransitiveReductionOutputEquivalent<IndexedClass>> iteratorDirectSuperClasses = output.directSubsumers.iterator();
            while (iteratorDirectSuperClasses.hasNext()) {
                TransitiveReductionOutputEquivalent<IndexedClass> directSuperClassEquivalent = iteratorDirectSuperClasses.next();
                IndexedClass directSuperClass = (IndexedClass)directSuperClassEquivalent.getRoot();
                boolean isDirectSuperClassTop = TransitiveReductionFactory.this.isTop(directSuperClass);
                if (isCandidateTop || directSuperClass.getContext().getSubsumers().contains(candidate)) {
                    if (candidateSupers.contains(directSuperClass) || isDirectSuperClassTop) {
                        directSuperClassEquivalent.equivalent.add(candidate.getElkClass());
                    }
                    return;
                }
                if (!candidateSupers.contains(directSuperClass) && !isDirectSuperClassTop) continue;
                iteratorDirectSuperClasses.remove();
            }
            TransitiveReductionOutputEquivalent<IndexedClass> candidateOutput = new TransitiveReductionOutputEquivalent<IndexedClass>(candidate);
            candidateOutput.equivalent.add(candidate.getElkClass());
            output.directSubsumers.add(candidateOutput);
        }
    }

    private class ThisClassExpressionSaturationListener
    implements ClassExpressionSaturationListener<SaturationJobForTransitiveReduction<R, ?, J>> {
        private ThisClassExpressionSaturationListener() {
        }

        @Override
        public void notifyFinished(SaturationJobForTransitiveReduction<R, ?, J> output) throws InterruptedException {
            output.accept(TransitiveReductionFactory.this.saturationOutputProcessor_);
        }
    }
}

