/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.exceptions.ElkRuntimeException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.util.concurrent.computation.Interrupter;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

abstract class AbstractReasonerStage
extends SimpleInterrupter
implements ReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(AbstractReasonerStage.class);
    final AbstractReasonerState reasoner;
    boolean initialized = false;
    boolean isCompleted = false;
    int workerNo;
    ProgressMonitor progressMonitor;
    final Iterable<AbstractReasonerStage> preStages;
    final List<AbstractReasonerStage> postStages = new LinkedList<AbstractReasonerStage>();

    public AbstractReasonerStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        this.reasoner = reasoner;
        this.preStages = Arrays.asList(preStages);
        for (AbstractReasonerStage preStage : preStages) {
            preStage.postStages.add(this);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public Iterable<? extends ReasonerStage> getPreStages() {
        return this.preStages;
    }

    @Override
    public boolean preExecute() {
        if (this.initialized) {
            return false;
        }
        LOGGER_.trace(this.getName() + ": initialized");
        this.workerNo = this.reasoner.getNumberOfWorkers();
        this.progressMonitor = this.reasoner.getProgressMonitor();
        this.initialized = true;
        return true;
    }

    @Override
    public boolean postExecute() {
        if (!this.initialized) {
            return false;
        }
        LOGGER_.trace(this.getName() + ": done");
        return true;
    }

    @Override
    public boolean dispose() {
        if (!this.initialized) {
            return false;
        }
        this.workerNo = 0;
        this.progressMonitor = null;
        this.initialized = false;
        return true;
    }

    abstract void executeStage() throws ElkException;

    @Override
    public void execute() throws ElkException {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info(this.getName() + " using " + this.workerNo + " workers");
        }
        this.progressMonitor.start(this.getName());
        try {
            this.executeStage();
            this.checkInterrupt();
            this.isCompleted = true;
        }
        finally {
            this.progressMonitor.finish();
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean invalidate() {
        if (!this.isCompleted) {
            return false;
        }
        toInvalidate = new LinkedList<AbstractReasonerStage>();
        toInvalidate.add(this);
        block0: while (true) {
            if ((stage = (AbstractReasonerStage)toInvalidate.poll()) == null) {
                return true;
            }
            if (!stage.isCompleted) continue;
            if (AbstractReasonerStage.LOGGER_.isTraceEnabled()) {
                AbstractReasonerStage.LOGGER_.trace(stage.getName() + ": invalidated");
            }
            stage.isCompleted = false;
            var3_3 = stage.postStages.iterator();
            while (true) {
                if (var3_3.hasNext()) ** break;
                continue block0;
                postStage = var3_3.next();
                toInvalidate.add(postStage);
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean setCompleted() {
        if (this.isCompleted) {
            return false;
        }
        toMark = new LinkedList<AbstractReasonerStage>();
        toMark.add(this);
        block0: while (true) {
            if ((stage = (AbstractReasonerStage)toMark.poll()) == null) {
                return true;
            }
            if (stage.isCompleted) continue;
            if (AbstractReasonerStage.LOGGER_.isTraceEnabled()) {
                AbstractReasonerStage.LOGGER_.trace(stage.getName() + ": marked completed");
            }
            stage.isCompleted = true;
            var3_3 = stage.preStages.iterator();
            while (true) {
                if (var3_3.hasNext()) ** break;
                continue block0;
                preStage = var3_3.next();
                toMark.add(preStage);
            }
            break;
        }
    }

    void checkInterrupt() throws ElkInterruptedException {
        if (this.isInterrupted()) {
            if (LOGGER_.isInfoEnabled()) {
                LOGGER_.info(this.getName() + " interrupted");
            }
            throw new ElkInterruptedException(this.getName() + " interrupted");
        }
    }

    protected void setInterrupt(Interrupter interrupter, boolean flag) {
        if (interrupter == null) {
            if (!flag) {
                throw new ElkRuntimeException(this.getName() + ": cannot clear interrupt!");
            }
            return;
        }
        interrupter.setInterrupt(flag);
    }

    protected void markAllContextsAsSaturated() {
        for (IndexedClassExpression ice : this.reasoner.saturationState.getNotSaturatedContexts()) {
            if (ice.getContext() == null) continue;
            ice.getContext().setSaturated(true);
        }
    }

    protected SaturationStatistics getRuleAndConclusionStatistics() {
        return this.reasoner.ruleAndConclusionStats;
    }
}

