/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassEntityVisitor;
import org.semanticweb.elk.reasoner.stages.ClassTaxonomyState;
import org.semanticweb.elk.reasoner.stages.InstanceTaxonomyState;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTypeNode;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

class TaxonomyCleaningFactory
extends SimpleInterrupter
implements InputProcessorFactory<IndexedClassEntity, InputProcessor<IndexedClassEntity>> {
    private final ClassTaxonomyState classTaxonomyState_;
    private final InstanceTaxonomyState instanceTaxonomyState_;

    TaxonomyCleaningFactory(ClassTaxonomyState classTaxonomyState, InstanceTaxonomyState instanceTaxonomyState) {
        this.classTaxonomyState_ = classTaxonomyState;
        this.instanceTaxonomyState_ = instanceTaxonomyState;
    }

    @Override
    public InputProcessor<IndexedClassEntity> getEngine() {
        return new InputProcessor<IndexedClassEntity>(){
            private final IndexedClassEntityVisitor<?> submissionVisitor_ = new IndexedClassEntityVisitor<Object>(){

                @Override
                public Object visit(IndexedClass element) {
                    this.submitClass(element);
                    return null;
                }

                @Override
                public Object visit(IndexedIndividual element) {
                    this.submitIndividual(element);
                    return null;
                }
            };
            private final ClassTaxonomyState.Writer classStateWriter_ = TaxonomyCleaningFactory.access$200(TaxonomyCleaningFactory.this).getWriter();
            private final InstanceTaxonomyState.Writer instanceStateWriter_ = TaxonomyCleaningFactory.access$300(TaxonomyCleaningFactory.this).getWriter();
            private final Queue<UpdateableTaxonomyNode<ElkClass>> toRemove_ = new ConcurrentLinkedQueue<UpdateableTaxonomyNode<ElkClass>>();

            @Override
            public void submit(IndexedClassEntity entity) {
                entity.accept(this.submissionVisitor_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void submitClass(IndexedClass indexedClass) {
                ElkClass elkClass = indexedClass.getElkClass();
                UpdateableTaxonomy<ElkClass> classTaxonomy = TaxonomyCleaningFactory.this.classTaxonomyState_.getTaxonomy();
                UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> instanceTaxonomy = TaxonomyCleaningFactory.this.instanceTaxonomyState_.getTaxonomy();
                if (elkClass == PredefinedElkClass.OWL_NOTHING) {
                    return;
                }
                TaxonomyNode taxonomyNode = classTaxonomy.getBottomNode();
                synchronized (taxonomyNode) {
                    if (classTaxonomy.getBottomNode().getMembers().remove(elkClass)) {
                        this.classStateWriter_.markClassesForModifiedNode(classTaxonomy.getBottomNode());
                        this.classStateWriter_.markClassForModifiedNode(elkClass);
                        return;
                    }
                }
                UpdateableTaxonomyNode<ElkClass> node = classTaxonomy.getUpdateableNode(elkClass);
                if (node == null) {
                    this.classStateWriter_.markClassForModifiedNode(elkClass);
                    return;
                }
                if (node.trySetModified(true)) {
                    this.toRemove_.add(node);
                    this.classStateWriter_.markClassesForModifiedNode(node);
                }
                UpdateableTaxonomyNode<ElkClass> updateableTaxonomyNode = node;
                synchronized (updateableTaxonomyNode) {
                    for (UpdateableTaxonomyNode<ElkClass> subNode : node.getDirectUpdateableSubNodes()) {
                        if (!subNode.trySetModified(true)) continue;
                        this.toRemove_.add(subNode);
                        this.classStateWriter_.markClassesForModifiedNode(subNode);
                    }
                }
                if (instanceTaxonomy != null) {
                    UpdateableTypeNode<ElkClass, ElkNamedIndividual> typeNode = instanceTaxonomy.getUpdateableTypeNode(elkClass);
                    if (typeNode == null) {
                        return;
                    }
                    LinkedList<UpdateableInstanceNode<ElkClass, ElkNamedIndividual>> directInstances = null;
                    UpdateableTypeNode<ElkClass, ElkNamedIndividual> updateableTypeNode = typeNode;
                    synchronized (updateableTypeNode) {
                        directInstances = new LinkedList<UpdateableInstanceNode<ElkClass, ElkNamedIndividual>>(typeNode.getDirectInstanceNodes());
                    }
                    for (UpdateableInstanceNode updateableInstanceNode : directInstances) {
                        if (!updateableInstanceNode.trySetModified(true)) continue;
                        this.instanceStateWriter_.markModifiedIndividuals(updateableInstanceNode.getMembers());
                        instanceTaxonomy.removeInstanceNode((ElkNamedIndividual)updateableInstanceNode.getCanonicalMember());
                    }
                }
                classTaxonomy.removeNode(node);
                if (instanceTaxonomy != null) {
                    instanceTaxonomy.removeNode(node);
                }
            }

            private void submitIndividual(IndexedIndividual indexedIndividual) {
                if (TaxonomyCleaningFactory.this.instanceTaxonomyState_ != null && TaxonomyCleaningFactory.this.instanceTaxonomyState_.getTaxonomy() != null) {
                    ElkNamedIndividual individual;
                    UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = TaxonomyCleaningFactory.this.instanceTaxonomyState_.getTaxonomy();
                    UpdateableInstanceNode<ElkClass, ElkNamedIndividual> node = taxonomy.getInstanceNode(individual = indexedIndividual.getElkNamedIndividual());
                    if (node != null && node.trySetModified(true)) {
                        this.instanceStateWriter_.markModifiedIndividuals(node.getMembers());
                        taxonomy.removeInstanceNode(individual);
                    } else if (node == null) {
                        this.instanceStateWriter_.markModifiedIndividuals(Collections.singleton(individual));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process() {
                block6: while (!TaxonomyCleaningFactory.this.isInterrupted()) {
                    UpdateableTaxonomyNode<ElkClass> node = this.toRemove_.poll();
                    if (node == null) {
                        return;
                    }
                    LinkedList<UpdateableTaxonomyNode<ElkClass>> superNodes = null;
                    Object object = node;
                    synchronized (object) {
                        superNodes = new LinkedList<UpdateableTaxonomyNode<ElkClass>>(node.getDirectUpdateableSuperNodes());
                        for (UpdateableTaxonomyNode updateableTaxonomyNode : superNodes) {
                            node.removeDirectSuperNode(updateableTaxonomyNode);
                        }
                    }
                    object = superNodes.iterator();
                    while (true) {
                        UpdateableTaxonomyNode superNode;
                        if (!object.hasNext()) continue block6;
                        UpdateableTaxonomyNode updateableTaxonomyNode = superNode = (UpdateableTaxonomyNode)object.next();
                        synchronized (updateableTaxonomyNode) {
                            superNode.removeDirectSubNode(node);
                        }
                    }
                    break;
                }
                return;
            }

            @Override
            public void finish() {
            }
        };
    }

    @Override
    public void finish() {
    }
}

