/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import org.semanticweb.elk.util.concurrent.computation.InputProcessor;

public class DelegatingInputProcessor<J>
implements InputProcessor<J> {
    private final InputProcessor<J> processor_;

    public DelegatingInputProcessor(InputProcessor<J> p) {
        this.processor_ = p;
    }

    @Override
    public void submit(J job) {
        this.preSubmit(job);
        this.processor_.submit(job);
        this.postSubmit(job);
    }

    @Override
    public void process() throws InterruptedException {
        this.preProcess();
        this.processor_.process();
        this.postProcess();
    }

    @Override
    public void finish() {
        this.processor_.finish();
    }

    protected void preSubmit(J job) {
    }

    protected void postSubmit(J job) {
    }

    protected void preProcess() {
    }

    protected void postProcess() {
    }
}

