/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact.writer;

import java.util.Collection;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;

public class CompactOut {
    public static void compactQuotedString(IndentedWriter out, String param, String value) {
        out.print(param);
        out.print("=");
        CompactOut.printQuotedString(out, value);
    }

    public static void compactUnquotedString(IndentedWriter out, String param, String value) {
        out.print(param);
        out.print("=");
        out.print(value);
    }

    public static void compact(IndentedWriter out, String param, int value) {
        out.print(param);
        out.print("=");
        out.print(Integer.toString(value));
    }

    public static void compact(IndentedWriter out, NodeFormatter nodeFmt, String param, Node value) {
        out.print(param);
        out.print("=");
        nodeFmt.format((AWriter)out, value);
    }

    public static void compactArrayNodes(IndentedWriter out, NodeFormatter nodeFmt, String param, Collection<Node> values) {
        out.print(param);
        out.print("=");
        out.print("[ ");
        boolean first = true;
        for (Node n : values) {
            if (!first) {
                out.print(" ");
            }
            nodeFmt.format((AWriter)out, n);
            first = false;
        }
        out.print(" ]");
    }

    public static void compactArrayString(IndentedWriter out, NodeFormatter nodeFmt, String param, Collection<String> values) {
        out.print(param);
        out.print("=");
        out.print("(");
        boolean first = true;
        for (String str : values) {
            if (!first) {
                out.print(" ");
            }
            CompactOut.printQuotedString(out, str);
            first = false;
        }
        out.print(")");
    }

    private static void printQuotedString(IndentedWriter out, String str) {
        out.print('\"');
        EscapeStr.stringEsc((AWriter)out, (String)str, (char)'\"', (boolean)true, (CharSpace)CharSpace.UTF8);
        out.print('\"');
    }
}

