/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI0Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GCI0AxiomImpl
implements GCI0Axiom {
    private final int subClass;
    private final int superClass;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    GCI0AxiomImpl(int subClassId, int superClassId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.subClass = subClassId;
        this.superClass = superClassId;
        this.annotations = annotations;
        this.hashCode = this.subClass + 31 * (this.superClass + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GCI0Axiom)) {
            return false;
        }
        GCI0Axiom other = (GCI0Axiom)obj;
        return this.getSubClass() == other.getSubClass() && this.getSuperClass() == other.getSuperClass() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(this.subClass);
        ret.add(this.superClass);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public int getSubClass() {
        return this.subClass;
    }

    @Override
    public int getSuperClass() {
        return this.superClass;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubClassOf*");
        sbuf.append("(");
        sbuf.append(this.getSubClass());
        sbuf.append(" ");
        sbuf.append(this.getSuperClass());
        sbuf.append(")");
        return sbuf.toString();
    }
}

