/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

public class ConcurrentComputation<I, F extends InputProcessorFactory<I, ?>>
extends SimpleInterrupter {
    private final F inputProcessorFactory_;
    private final int maxWorkers_;
    private final ComputationExecutor executor_;
    private final BlockingQueue<I> buffer_;
    private final int bufferCapacity_;
    private final I poison_pill_ = new Object();
    private volatile boolean termination_;
    private final Runnable worker_;

    public ConcurrentComputation(F inputProcessorFactory, ComputationExecutor executor, int maxWorkers, int bufferCapacity) {
        this.inputProcessorFactory_ = inputProcessorFactory;
        if (bufferCapacity <= maxWorkers) {
            bufferCapacity = maxWorkers + 1;
        }
        this.buffer_ = new ArrayBlockingQueue<I>(bufferCapacity);
        this.bufferCapacity_ = bufferCapacity;
        this.termination_ = false;
        this.worker_ = new Worker();
        this.executor_ = executor;
        this.maxWorkers_ = maxWorkers;
    }

    public ConcurrentComputation(F inputProcessorFactory, ComputationExecutor executor, int maxWorkers) {
        this(inputProcessorFactory, executor, maxWorkers, 512 + 32 * maxWorkers);
    }

    public F getInputProcessorFactory() {
        return this.inputProcessorFactory_;
    }

    public synchronized boolean start() {
        return this.executor_.start(this.worker_, this.maxWorkers_);
    }

    public synchronized boolean submit(I input) throws InterruptedException {
        if (this.termination_) {
            return false;
        }
        this.buffer_.put(input);
        return true;
    }

    @Override
    public final void setInterrupt(boolean flag) {
        this.termination_ = flag;
        super.setInterrupt(flag);
        this.inputProcessorFactory_.setInterrupt(flag);
    }

    protected synchronized void waitWorkers() throws InterruptedException {
        if (this.buffer_.isEmpty()) {
            this.buffer_.offer(this.poison_pill_);
        }
        this.executor_.waitDone();
        while (this.buffer_.peek() == this.poison_pill_) {
            this.buffer_.remove();
        }
    }

    public synchronized void finish() throws InterruptedException {
        this.termination_ = true;
        this.waitWorkers();
        if (!this.isInterrupted()) {
            this.termination_ = false;
            this.inputProcessorFactory_.finish();
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object inputProcessor = ConcurrentComputation.this.inputProcessorFactory_.getEngine();
            try {
                boolean previousProcessed = false;
                while (true) {
                    Object nextInput;
                    if (!previousProcessed) {
                        inputProcessor.process();
                        if (!ConcurrentComputation.this.isInterrupted()) {
                            previousProcessed = true;
                        }
                    }
                    if ((nextInput = ConcurrentComputation.this.buffer_.take()) != ConcurrentComputation.this.poison_pill_) {
                        inputProcessor.submit(nextInput);
                        inputProcessor.process();
                    }
                    if (!ConcurrentComputation.this.termination_) continue;
                    if (ConcurrentComputation.this.buffer_.isEmpty()) {
                        ConcurrentComputation.this.buffer_.put(ConcurrentComputation.this.poison_pill_);
                    } else if (!ConcurrentComputation.this.isInterrupted() || ConcurrentComputation.this.buffer_.size() == ConcurrentComputation.this.bufferCapacity_) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                inputProcessor.finish();
            }
        }
    }
}

