/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.incremental.IncrementalProcessingStatistics;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.LinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.concurrent.computation.BaseInputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;
import org.semanticweb.elk.util.logging.CachedTimeThread;

class ContextInitializationFactory
extends SimpleInterrupter
implements InputProcessorFactory<ArrayList<Context>, InputProcessor<ArrayList<Context>>> {
    private static final Logger LOGGER_ = Logger.getLogger(ContextInitializationFactory.class);
    private final SaturationState saturationState_;
    private final Map<IndexedClassExpression, ? extends LinkRule<Context>> indexChanges_;
    private final IndexedClassExpression[] indexChangesKeys_;
    private final LinkRule<Context> changedGlobalRuleHead_;
    private AtomicInteger ruleHits = new AtomicInteger(0);
    private final SaturationStatistics stageStatistics_;

    public ContextInitializationFactory(SaturationState state, Map<IndexedClassExpression, ? extends LinkRule<Context>> indexChanges, LinkRule<Context> changedGlobalRuleHead, SaturationStatistics stageStats) {
        this.saturationState_ = state;
        this.indexChanges_ = indexChanges;
        this.indexChangesKeys_ = new IndexedClassExpression[indexChanges.keySet().size()];
        indexChanges.keySet().toArray(this.indexChangesKeys_);
        this.changedGlobalRuleHead_ = changedGlobalRuleHead;
        this.stageStatistics_ = stageStats;
    }

    @Override
    public InputProcessor<ArrayList<Context>> getEngine() {
        return this.getEngine(this.getBaseContextProcessor());
    }

    @Override
    public void finish() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)("Rule hits: " + this.ruleHits.get()));
        }
    }

    private ContextProcessor getBaseContextProcessor() {
        final SaturationStatistics localStatistics = new SaturationStatistics();
        ConclusionVisitor<?> conclusionVisitor = SaturationUtils.addStatsToConclusionVisitor(localStatistics.getConclusionStatistics());
        final RuleApplicationVisitor ruleAppVisitor = SaturationUtils.getStatsAwareCompositionRuleAppVisitor(localStatistics.getRuleStatistics());
        final BasicSaturationStateWriter saturationStateWriter = this.saturationState_.getWriter(ContextModificationListener.DUMMY, conclusionVisitor);
        localStatistics.getConclusionStatistics().startMeasurements();
        return new ContextProcessor(){
            int localRuleHits = 0;

            @Override
            public void process(Context context) {
                for (LinkRule nextGlobalRule = ContextInitializationFactory.this.changedGlobalRuleHead_; nextGlobalRule != null; nextGlobalRule = (LinkRule)nextGlobalRule.next()) {
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)(context + ": applying rule " + nextGlobalRule.getName()));
                    }
                    nextGlobalRule.accept(ruleAppVisitor, saturationStateWriter, context);
                }
                Set<IndexedClassExpression> subsumers = context.getSubsumers();
                if (subsumers.size() > ContextInitializationFactory.this.indexChangesKeys_.length >> 2) {
                    for (int j = 0; j < ContextInitializationFactory.this.indexChangesKeys_.length; ++j) {
                        IndexedClassExpression changedICE = ContextInitializationFactory.this.indexChangesKeys_[j];
                        if (!subsumers.contains(changedICE)) continue;
                        this.applyLocalRules(context, changedICE);
                    }
                } else {
                    for (IndexedClassExpression changedICE : subsumers) {
                        this.applyLocalRules(context, changedICE);
                    }
                }
            }

            @Override
            public void finish() {
                ContextInitializationFactory.this.stageStatistics_.add(localStatistics);
                ContextInitializationFactory.this.ruleHits.addAndGet(this.localRuleHits);
            }

            private void applyLocalRules(Context context, IndexedClassExpression changedICE) {
                LinkRule nextLocalRule = (LinkRule)ContextInitializationFactory.this.indexChanges_.get(changedICE);
                if (nextLocalRule != null) {
                    ++this.localRuleHits;
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)(context + ": applying rules for " + changedICE));
                    }
                }
                while (nextLocalRule != null) {
                    nextLocalRule.accept(ruleAppVisitor, saturationStateWriter, context);
                    nextLocalRule = (LinkRule)nextLocalRule.next();
                }
            }
        };
    }

    private InputProcessor<ArrayList<Context>> getEngine(ContextProcessor baseProcessor) {
        if (SaturationUtils.COLLECT_PROCESSING_TIMES) {
            return new TimedContextCollectionProcessor(baseProcessor, this.stageStatistics_.getIncrementalProcessingStatistics());
        }
        return new ContextCollectionProcessor(baseProcessor);
    }

    private static class TimedContextProcessor
    implements ContextProcessor {
        private final IncrementalProcessingStatistics localStats_;
        private final ContextProcessor processor_;

        TimedContextProcessor(ContextProcessor p, IncrementalProcessingStatistics localStats) {
            this.processor_ = p;
            this.localStats_ = localStats;
            this.localStats_.startMeasurements();
        }

        @Override
        public void process(Context context) {
            long ts = CachedTimeThread.getCurrentTimeMillis();
            this.processor_.process(context);
            this.localStats_.changeInitContextProcessingTime += CachedTimeThread.getCurrentTimeMillis() - ts;
        }

        @Override
        public void finish() {
            this.processor_.finish();
        }
    }

    private static interface ContextProcessor {
        public void process(Context var1);

        public void finish();
    }

    private class ContextCollectionProcessor
    extends BaseInputProcessor<ArrayList<Context>> {
        private final ContextProcessor contextProcessor_;

        ContextCollectionProcessor(ContextProcessor contextProcessor) {
            this.contextProcessor_ = contextProcessor;
        }

        @Override
        protected void process(ArrayList<Context> contexts) {
            for (Context context : contexts) {
                this.contextProcessor_.process(context);
            }
        }

        @Override
        public void finish() {
            super.finish();
            this.contextProcessor_.finish();
        }

        @Override
        protected boolean isInterrupted() {
            return ContextInitializationFactory.this.isInterrupted();
        }
    }

    private class TimedContextCollectionProcessor
    extends BaseInputProcessor<ArrayList<Context>> {
        private final ContextProcessor contextProcessor_;
        private final IncrementalProcessingStatistics stageStats_;
        private final IncrementalProcessingStatistics localStats_ = new IncrementalProcessingStatistics();
        private int procNumber_ = 0;

        TimedContextCollectionProcessor(ContextProcessor baseProcessor, IncrementalProcessingStatistics stageStats) {
            this.contextProcessor_ = new TimedContextProcessor(baseProcessor, this.localStats_);
            this.stageStats_ = stageStats;
            this.localStats_.startMeasurements();
        }

        @Override
        protected void process(ArrayList<Context> contexts) {
            long ts = CachedTimeThread.getCurrentTimeMillis();
            int contextCount = 0;
            int subsumerCount = 0;
            ++this.procNumber_;
            for (Context context : contexts) {
                this.contextProcessor_.process(context);
                ++contextCount;
                subsumerCount += context.getSubsumers().size();
            }
            this.localStats_.changeInitContextCollectionProcessingTime += CachedTimeThread.getCurrentTimeMillis() - ts;
            this.localStats_.countContexts += (long)contextCount;
            if (contextCount > 0) {
                this.localStats_.countContextSubsumers += (long)(subsumerCount / contextCount);
            }
        }

        @Override
        public void finish() {
            super.finish();
            this.contextProcessor_.finish();
            if (this.procNumber_ > 0) {
                this.localStats_.countContextSubsumers /= (long)this.procNumber_;
            }
            this.stageStats_.add(this.localStats_);
        }

        @Override
        protected boolean isInterrupted() {
            return ContextInitializationFactory.this.isInterrupted();
        }
    }
}

