/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.saturation.properties.CompositionClosure;
import org.semanticweb.elk.reasoner.saturation.properties.ReducingCompositionClosure;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.SubPropertyExplorer;
import org.semanticweb.elk.util.collections.AbstractHashMultimap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

public class PropertyHierarchyCompositionComputationFactory
extends SimpleInterrupter
implements InputProcessorFactory<IndexedPropertyChain, Engine> {
    private static final Logger LOGGER_ = Logger.getLogger(PropertyHierarchyCompositionComputationFactory.class);
    private static final IndexedPropertyChainVisitor<Void> PROCESSOR_ = new IndexedPropertyChainVisitor<Void>(){

        @Override
        public Void visit(IndexedObjectProperty element) {
            SubPropertyExplorer.getSetRelevantSubProperties(element);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visit(IndexedBinaryPropertyChain element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Computing compositions for " + element));
            }
            IndexedObjectProperty left = element.getLeftProperty();
            IndexedPropertyChain right = element.getRightProperty();
            Set<IndexedPropertyChain> leftSubProperties = SubPropertyExplorer.getSetRelevantSubProperties(left);
            if (leftSubProperties.isEmpty()) {
                return null;
            }
            Set<IndexedPropertyChain> rightSubProperties = SubPropertyExplorer.getSetRelevantSubProperties(right);
            if (rightSubProperties.isEmpty()) {
                return null;
            }
            ReducingCompositionClosure closure = new ReducingCompositionClosure(element);
            for (IndexedPropertyChain leftSubProperty : leftSubProperties) {
                SaturatedPropertyChain leftSaturation;
                SaturatedPropertyChain saturatedPropertyChain = leftSaturation = SaturatedPropertyChain.getCreate(leftSubProperty);
                synchronized (saturatedPropertyChain) {
                    if (leftSaturation.compositionsByRightSubProperty == null) {
                        leftSaturation.compositionsByRightSubProperty = new CompositionMultimap();
                    }
                }
                AbstractHashMultimap<IndexedPropertyChain, IndexedPropertyChain> compositionsByRight = leftSaturation.compositionsByRightSubProperty;
                for (IndexedPropertyChain rightSubProperty : rightSubProperties) {
                    Collection<IndexedPropertyChain> compositionsSoFar;
                    boolean newRecord = false;
                    Object object = compositionsByRight;
                    synchronized (object) {
                        compositionsSoFar = compositionsByRight.getOld(rightSubProperty);
                        if (compositionsSoFar == null) {
                            compositionsSoFar = new ArrayHashSet<IndexedPropertyChain>(2);
                            compositionsByRight.put(rightSubProperty, compositionsSoFar);
                            newRecord = true;
                        }
                    }
                    if (newRecord) {
                        AbstractHashMultimap<IndexedPropertyChain, IndexedPropertyChain> compositionsByLeft;
                        SaturatedPropertyChain rightSaturation;
                        SaturatedPropertyChain saturatedPropertyChain2 = rightSaturation = SaturatedPropertyChain.getCreate(rightSubProperty);
                        synchronized (saturatedPropertyChain2) {
                            if (rightSaturation.compositionsByLeftSubProperty == null) {
                                rightSaturation.compositionsByLeftSubProperty = new CompositionMultimap();
                            }
                        }
                        AbstractHashMultimap<IndexedPropertyChain, IndexedPropertyChain> abstractHashMultimap = compositionsByLeft = rightSaturation.compositionsByLeftSubProperty;
                        synchronized (abstractHashMultimap) {
                            compositionsByLeft.put(leftSubProperty, compositionsSoFar);
                        }
                    }
                    object = compositionsSoFar;
                    synchronized (object) {
                        ((CompositionClosure)closure).applyTo(compositionsSoFar);
                        if (LOGGER_.isTraceEnabled()) {
                            LOGGER_.trace((Object)("updated compositions: " + leftSubProperty + " o " + rightSubProperty + " => " + compositionsSoFar));
                        }
                    }
                }
            }
            return null;
        }
    };

    @Override
    public Engine getEngine() {
        return new Engine();
    }

    @Override
    public void finish() {
    }

    private static class CompositionMultimap
    extends AbstractHashMultimap<IndexedPropertyChain, IndexedPropertyChain> {
        private CompositionMultimap() {
        }

        @Override
        protected Collection<IndexedPropertyChain> newRecord() {
            return new ArrayHashSet<IndexedPropertyChain>(2);
        }
    }

    class Engine
    implements InputProcessor<IndexedPropertyChain> {
        Engine() {
        }

        @Override
        public void submit(IndexedPropertyChain job) {
            job.accept(PROCESSOR_);
        }

        @Override
        public void process() throws InterruptedException {
        }

        @Override
        public void finish() {
        }
    }
}

