/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.taxonomy.NonBottomClassNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableBottomNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomyNode;
import org.semanticweb.elk.util.collections.LazySetUnion;
import org.semanticweb.elk.util.collections.Operations;

public class ConcurrentClassTaxonomy
implements UpdateableTaxonomy<ElkClass> {
    private static final Logger LOGGER_ = Logger.getLogger(ConcurrentClassTaxonomy.class);
    private final ConcurrentMap<ElkIri, NonBottomClassNode> classNodeLookup_ = new ConcurrentHashMap<ElkIri, NonBottomClassNode>();
    private final Set<NonBottomClassNode> allSatisfiableClassNodes_ = Collections.newSetFromMap(new ConcurrentHashMap());
    final AtomicInteger countNodesWithSubClasses;
    private final Set<ElkClass> unsatisfiableClasses_;
    private final BottomClassNode bottomClassNode_ = new BottomClassNode();

    public ConcurrentClassTaxonomy() {
        this.countNodesWithSubClasses = new AtomicInteger(0);
        this.unsatisfiableClasses_ = Collections.synchronizedSet(new TreeSet<ElkClass>(Comparators.ELK_CLASS_COMPARATOR));
        this.unsatisfiableClasses_.add(PredefinedElkClass.OWL_NOTHING);
    }

    static ElkIri getKey(ElkEntity elkEntity) {
        return elkEntity.getIri();
    }

    @Override
    public TaxonomyNode<ElkClass> getNode(ElkClass elkClass) {
        TaxonomyNode result = (TaxonomyNode)this.classNodeLookup_.get(ConcurrentClassTaxonomy.getKey(elkClass));
        if (result == null && this.unsatisfiableClasses_.contains(elkClass)) {
            result = this.bottomClassNode_;
        }
        return result;
    }

    @Override
    public Set<? extends TaxonomyNode<ElkClass>> getNodes() {
        Set<NonBottomClassNode> allNodes = this.allSatisfiableClassNodes_;
        Set<BottomClassNode> bottom = Collections.singleton(this.bottomClassNode_);
        return new LazySetUnion<BottomClassNode>(allNodes, bottom);
    }

    public NonBottomClassNode getTopNode() {
        return (NonBottomClassNode)this.classNodeLookup_.get(ConcurrentClassTaxonomy.getKey(PredefinedElkClass.OWL_THING));
    }

    @Override
    public TaxonomyNode<ElkClass> getBottomNode() {
        return this.getUpdateableBottomNode();
    }

    @Override
    public UpdateableBottomNode<ElkClass> getUpdateableBottomNode() {
        return this.bottomClassNode_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NonBottomClassNode getCreateNonBottomClassNode(Collection<ElkClass> members) {
        NonBottomClassNode previous;
        if (members == null || members.isEmpty()) {
            throw new IllegalArgumentException("Empty class taxonomy nodes must not be created!");
        }
        for (ElkClass member : members) {
            previous = (NonBottomClassNode)this.classNodeLookup_.get(ConcurrentClassTaxonomy.getKey(member));
            if (previous == null) continue;
            NonBottomClassNode nonBottomClassNode = previous;
            synchronized (nonBottomClassNode) {
                if (previous.getMembers().size() >= members.size()) {
                    return previous;
                }
                previous.setMembers(members);
            }
            for (ElkClass newMember : members) {
                this.classNodeLookup_.put(ConcurrentClassTaxonomy.getKey(newMember), previous);
            }
            return previous;
        }
        NonBottomClassNode node = new NonBottomClassNode(this, members);
        ElkClass canonical = node.getCanonicalMember();
        previous = this.classNodeLookup_.putIfAbsent(ConcurrentClassTaxonomy.getKey(canonical), node);
        if (previous != null) {
            return previous;
        }
        this.allSatisfiableClassNodes_.add(node);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("node created: " + node));
        }
        for (ElkClass member : members) {
            if (member == canonical) continue;
            this.classNodeLookup_.put(ConcurrentClassTaxonomy.getKey(member), node);
        }
        return node;
    }

    @Override
    public boolean addToBottomNode(ElkClass elkClass) {
        return this.unsatisfiableClasses_.add(elkClass);
    }

    @Override
    public UpdateableTaxonomyNode<ElkClass> getCreateNode(Collection<ElkClass> members) {
        return this.getCreateNonBottomClassNode(members);
    }

    @Override
    public boolean removeNode(UpdateableTaxonomyNode<ElkClass> node) {
        boolean changed = false;
        if (this.allSatisfiableClassNodes_.remove(node)) {
            for (ElkClass member : node.getMembers()) {
                changed |= this.classNodeLookup_.remove(ConcurrentClassTaxonomy.getKey(member)) != null;
            }
            if (changed && LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(node + ": node removed"));
            }
        }
        return changed;
    }

    @Override
    public UpdateableTaxonomyNode<ElkClass> getUpdateableNode(ElkClass elkObject) {
        return (UpdateableTaxonomyNode)this.classNodeLookup_.get(ConcurrentClassTaxonomy.getKey(elkObject));
    }

    @Override
    public UpdateableTaxonomyNode<ElkClass> getUpdateableTopNode() {
        return this.getTopNode();
    }

    @Override
    public Set<? extends UpdateableTaxonomyNode<ElkClass>> getUpdateableNodes() {
        return Collections.unmodifiableSet(this.allSatisfiableClassNodes_);
    }

    protected class BottomClassNode
    implements UpdateableBottomNode<ElkClass> {
        protected BottomClassNode() {
        }

        @Override
        public Set<ElkClass> getMembers() {
            return ConcurrentClassTaxonomy.this.unsatisfiableClasses_;
        }

        @Override
        public ElkClass getCanonicalMember() {
            return PredefinedElkClass.OWL_NOTHING;
        }

        @Override
        public Set<NonBottomClassNode> getDirectSuperNodes() {
            return Operations.filter(ConcurrentClassTaxonomy.this.allSatisfiableClassNodes_, new Operations.Condition<NonBottomClassNode>(){

                @Override
                public boolean holds(NonBottomClassNode element) {
                    return element.getDirectSubNodes().contains(ConcurrentClassTaxonomy.this.bottomClassNode_);
                }
            }, ConcurrentClassTaxonomy.this.allSatisfiableClassNodes_.size() - ConcurrentClassTaxonomy.this.countNodesWithSubClasses.get());
        }

        @Override
        public Set<NonBottomClassNode> getAllSuperNodes() {
            return ConcurrentClassTaxonomy.this.allSatisfiableClassNodes_;
        }

        @Override
        public Set<TaxonomyNode<ElkClass>> getDirectSubNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<TaxonomyNode<ElkClass>> getAllSubNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<? extends UpdateableTaxonomyNode<ElkClass>> getDirectUpdateableSuperNodes() {
            return this.getDirectSuperNodes();
        }
    }
}

