/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.IndividualClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.IndividualNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNodeUtils;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableBottomNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTypeNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.LazySetUnion;
import org.semanticweb.elk.util.collections.Operations;

public class ConcurrentInstanceTaxonomy
implements IndividualClassTaxonomy {
    private static final Logger LOGGER_ = Logger.getLogger(ConcurrentInstanceTaxonomy.class);
    private final ConcurrentMap<ElkIri, IndividualNode> individualNodeLookup_;
    private final Set<InstanceNode<ElkClass, ElkNamedIndividual>> allIndividualNodes_;
    private final UpdateableTaxonomy<ElkClass> classTaxonomy_;
    private final ConcurrentMap<TaxonomyNode<ElkClass>, UpdateableTypeNodeWrapper> wrapperMap_;
    private final TypeNodeWrapper bottom_;
    private final Operations.FunctorEx<UpdateableTaxonomyNode<ElkClass>, UpdateableTypeNodeWrapper> functor_ = new Operations.FunctorEx<UpdateableTaxonomyNode<ElkClass>, UpdateableTypeNodeWrapper>(){

        @Override
        public UpdateableTypeNodeWrapper apply(UpdateableTaxonomyNode<ElkClass> node) {
            return ConcurrentInstanceTaxonomy.this.getCreateUpdateableTypeNode(node);
        }

        @Override
        public UpdateableTaxonomyNode<ElkClass> deapply(Object element) {
            if (element instanceof UpdateableTypeNodeWrapper) {
                return ((UpdateableTypeNodeWrapper)element).getNode();
            }
            return null;
        }
    };

    public ConcurrentInstanceTaxonomy() {
        this(new ConcurrentClassTaxonomy());
    }

    public ConcurrentInstanceTaxonomy(UpdateableTaxonomy<ElkClass> classTaxonomy) {
        this.classTaxonomy_ = classTaxonomy;
        this.individualNodeLookup_ = new ConcurrentHashMap<ElkIri, IndividualNode>();
        this.allIndividualNodes_ = Collections.newSetFromMap(new ConcurrentHashMap());
        this.wrapperMap_ = new ConcurrentHashMap<TaxonomyNode<ElkClass>, UpdateableTypeNodeWrapper>();
        this.bottom_ = new BottomTypeNodeWrapper(this.classTaxonomy_.getUpdateableBottomNode());
    }

    static ElkIri getKey(ElkEntity elkEntity) {
        return elkEntity.getIri();
    }

    @Override
    public TypeNode<ElkClass, ElkNamedIndividual> getTypeNode(ElkClass elkClass) {
        TaxonomyNode<ElkClass> node = this.classTaxonomy_.getNode(elkClass);
        if (node == this.classTaxonomy_.getBottomNode()) {
            return this.bottom_;
        }
        UpdateableTaxonomyNode<ElkClass> taxNode = this.classTaxonomy_.getUpdateableNode(elkClass);
        return this.getCreateUpdateableTypeNode(taxNode);
    }

    @Override
    public UpdateableInstanceNode<ElkClass, ElkNamedIndividual> getInstanceNode(ElkNamedIndividual individual) {
        return (UpdateableInstanceNode)this.individualNodeLookup_.get(ConcurrentInstanceTaxonomy.getKey(individual));
    }

    @Override
    public TaxonomyNode<ElkClass> getNode(ElkClass elkClass) {
        return this.getTypeNode(elkClass);
    }

    @Override
    public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getTypeNodes() {
        Set<UpdateableTypeNodeWrapper> updateableNodes = Operations.map(this.classTaxonomy_.getUpdateableNodes(), this.functor_);
        return new LazySetUnion<TypeNodeWrapper>(updateableNodes, Collections.singleton(this.bottom_));
    }

    @Override
    public Set<? extends InstanceNode<ElkClass, ElkNamedIndividual>> getInstanceNodes() {
        return Collections.unmodifiableSet(this.allIndividualNodes_);
    }

    @Override
    public Set<? extends TaxonomyNode<ElkClass>> getNodes() {
        return this.classTaxonomy_.getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndividualNode getCreateInstanceNode(Collection<ElkNamedIndividual> members) {
        IndividualNode previous = null;
        for (ElkNamedIndividual member : members) {
            previous = (IndividualNode)this.individualNodeLookup_.get(ConcurrentInstanceTaxonomy.getKey(member));
            if (previous == null) continue;
            IndividualNode individualNode = previous;
            synchronized (individualNode) {
                if (previous.getMembers().size() >= members.size()) {
                    return previous;
                }
                previous.setMembers(members);
            }
            for (ElkNamedIndividual newMember : members) {
                this.individualNodeLookup_.put(ConcurrentInstanceTaxonomy.getKey(newMember), previous);
            }
            return previous;
        }
        IndividualNode node = new IndividualNode(members);
        ElkNamedIndividual canonical = node.getCanonicalMember();
        previous = this.individualNodeLookup_.putIfAbsent(ConcurrentInstanceTaxonomy.getKey(canonical), node);
        if (previous != null) {
            return previous;
        }
        this.allIndividualNodes_.add(node);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(OwlFunctionalStylePrinter.toString(canonical) + ": node created"));
        }
        for (ElkNamedIndividual member : members) {
            if (member == canonical) continue;
            this.individualNodeLookup_.put(ConcurrentInstanceTaxonomy.getKey(member), node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInstanceNode(ElkNamedIndividual instance) {
        IndividualNode node = (IndividualNode)this.individualNodeLookup_.get(ConcurrentInstanceTaxonomy.getKey(instance));
        if (node != null) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing the instance node " + node));
            }
            LinkedList<UpdateableTypeNode<ElkClass, ElkNamedIndividual>> directTypes = new LinkedList<UpdateableTypeNode<ElkClass, ElkNamedIndividual>>();
            Object object = node;
            synchronized (object) {
                for (ElkNamedIndividual individual : node.getMembers()) {
                    this.individualNodeLookup_.remove(ConcurrentInstanceTaxonomy.getKey(individual));
                }
                this.allIndividualNodes_.remove(node);
                directTypes.addAll(node.getDirectTypeNodes());
            }
            object = directTypes.iterator();
            while (object.hasNext()) {
                UpdateableTypeNode typeNode;
                UpdateableTypeNode updateableTypeNode = typeNode = (UpdateableTypeNode)object.next();
                synchronized (updateableTypeNode) {
                    typeNode.removeDirectInstanceNode(node);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public UpdateableTypeNode<ElkClass, ElkNamedIndividual> getUpdateableTypeNode(ElkClass elkClass) {
        return this.getCreateUpdateableTypeNode(this.classTaxonomy_.getUpdateableNode(elkClass));
    }

    @Override
    public UpdateableTypeNode<ElkClass, ElkNamedIndividual> getCreateTypeNode(Collection<ElkClass> members) {
        UpdateableTaxonomyNode<ElkClass> taxNode = this.classTaxonomy_.getCreateNode(members);
        return this.getCreateUpdateableTypeNode(taxNode);
    }

    @Override
    public UpdateableTypeNode<ElkClass, ElkNamedIndividual> getTopNode() {
        return this.getUpdateableTopNode();
    }

    @Override
    public UpdateableTypeNode<ElkClass, ElkNamedIndividual> getUpdateableTopNode() {
        return this.getCreateUpdateableTypeNode(this.classTaxonomy_.getUpdateableTopNode());
    }

    @Override
    public TypeNode<ElkClass, ElkNamedIndividual> getBottomNode() {
        return this.bottom_;
    }

    @Override
    public UpdateableBottomNode<ElkClass> getUpdateableBottomNode() {
        return this.classTaxonomy_.getUpdateableBottomNode();
    }

    @Override
    public UpdateableTaxonomyNode<ElkClass> getCreateNode(Collection<ElkClass> members) {
        return this.classTaxonomy_.getCreateNode(members);
    }

    @Override
    public boolean addToBottomNode(ElkClass member) {
        return this.classTaxonomy_.addToBottomNode(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(UpdateableTaxonomyNode<ElkClass> node) {
        UpdateableTypeNodeWrapper wrapper = (UpdateableTypeNodeWrapper)this.wrapperMap_.get(node);
        if (wrapper != null && this.wrapperMap_.remove(node, wrapper)) {
            Iterator<? extends UpdateableInstanceNode<ElkClass, ElkNamedIndividual>> iterator = wrapper.getDirectInstanceNodes().iterator();
            while (iterator.hasNext()) {
                UpdateableInstanceNode<ElkClass, ElkNamedIndividual> instanceNode;
                UpdateableInstanceNode<ElkClass, ElkNamedIndividual> updateableInstanceNode = instanceNode = iterator.next();
                synchronized (updateableInstanceNode) {
                    instanceNode.removeDirectTypeNode(wrapper);
                }
            }
        }
        return this.classTaxonomy_.removeNode(node);
    }

    @Override
    public UpdateableTaxonomyNode<ElkClass> getUpdateableNode(ElkClass elkObject) {
        return this.classTaxonomy_.getUpdateableNode(elkObject);
    }

    @Override
    public Set<? extends UpdateableTaxonomyNode<ElkClass>> getUpdateableNodes() {
        return this.classTaxonomy_.getUpdateableNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateableTypeNodeWrapper getCreateUpdateableTypeNode(UpdateableTaxonomyNode<ElkClass> taxNode) {
        if (taxNode == null) {
            return null;
        }
        UpdateableTaxonomyNode<ElkClass> updateableTaxonomyNode = taxNode;
        synchronized (updateableTaxonomyNode) {
            UpdateableTypeNodeWrapper wrapper = (UpdateableTypeNodeWrapper)this.wrapperMap_.get(taxNode);
            if (wrapper == null) {
                wrapper = new UpdateableTypeNodeWrapper(taxNode);
                this.wrapperMap_.put(taxNode, wrapper);
            }
            return wrapper;
        }
    }

    private class BottomTypeNodeWrapper
    extends TypeNodeWrapper {
        BottomTypeNodeWrapper(UpdateableBottomNode<ElkClass> node) {
            super(node);
        }

        private UpdateableBottomNode<ElkClass> getNode() {
            return (UpdateableBottomNode)this.classNode_;
        }

        @Override
        public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getDirectSuperNodes() {
            return Operations.map(this.getNode().getDirectUpdateableSuperNodes(), ConcurrentInstanceTaxonomy.this.functor_);
        }

        @Override
        public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getAllSuperNodes() {
            return Operations.map(TaxonomyNodeUtils.getAllUpdateableSuperNodes(this.getNode()), ConcurrentInstanceTaxonomy.this.functor_);
        }

        @Override
        public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getDirectSubNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getAllSubNodes() {
            return Collections.emptySet();
        }
    }

    private class UpdateableTypeNodeWrapper
    extends TypeNodeWrapper
    implements UpdateableTypeNode<ElkClass, ElkNamedIndividual> {
        private final Set<UpdateableInstanceNode<ElkClass, ElkNamedIndividual>> directInstanceNodes_;

        UpdateableTypeNodeWrapper(UpdateableTaxonomyNode<ElkClass> node) {
            super(node);
            this.directInstanceNodes_ = Collections.newSetFromMap(new ConcurrentHashMap());
        }

        private UpdateableTaxonomyNode<ElkClass> getNode() {
            return (UpdateableTaxonomyNode)this.classNode_;
        }

        @Override
        public Set<? extends UpdateableInstanceNode<ElkClass, ElkNamedIndividual>> getDirectInstanceNodes() {
            return Collections.unmodifiableSet(this.directInstanceNodes_);
        }

        @Override
        public void addDirectSuperNode(UpdateableTaxonomyNode<ElkClass> superNode) {
            this.getNode().addDirectSuperNode(superNode);
        }

        @Override
        public void addDirectSubNode(UpdateableTaxonomyNode<ElkClass> subNode) {
            this.getNode().addDirectSubNode(subNode);
        }

        @Override
        public boolean removeDirectSubNode(UpdateableTaxonomyNode<ElkClass> subNode) {
            return this.getNode().removeDirectSubNode(subNode);
        }

        @Override
        public boolean removeDirectSuperNode(UpdateableTaxonomyNode<ElkClass> superNode) {
            return this.getNode().removeDirectSuperNode(superNode);
        }

        @Override
        public boolean trySetModified(boolean modified) {
            return this.getNode().trySetModified(modified);
        }

        @Override
        public boolean isModified() {
            return this.getNode().isModified();
        }

        @Override
        public Set<UpdateableTypeNodeWrapper> getDirectUpdateableSubNodes() {
            return Operations.map(this.getNode().getDirectUpdateableSubNodes(), ConcurrentInstanceTaxonomy.this.functor_);
        }

        @Override
        public Set<UpdateableTypeNodeWrapper> getDirectUpdateableSuperNodes() {
            return Operations.map(this.getNode().getDirectUpdateableSuperNodes(), ConcurrentInstanceTaxonomy.this.functor_);
        }

        @Override
        public Set<? extends TypeNodeWrapper> getDirectSuperNodes() {
            return this.getDirectUpdateableSuperNodes();
        }

        @Override
        public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getAllSuperNodes() {
            return this.getDirectUpdateableSuperNodes();
        }

        @Override
        public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getDirectSubNodes() {
            Set<UpdateableTypeNodeWrapper> directSubNodes = this.getDirectUpdateableSubNodes();
            return directSubNodes.isEmpty() ? Collections.singleton(ConcurrentInstanceTaxonomy.this.getBottomNode()) : directSubNodes;
        }

        @Override
        public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> getAllSubNodes() {
            Set<UpdateableTaxonomyNode<ElkClass>> subNodes = TaxonomyNodeUtils.getAllUpdateableSubNodes(this.getNode());
            return new LazySetUnion<TaxonomyNode>(Operations.map(subNodes, ConcurrentInstanceTaxonomy.this.functor_), Collections.singleton(ConcurrentInstanceTaxonomy.this.getBottomNode()));
        }

        @Override
        public void addDirectInstanceNode(UpdateableInstanceNode<ElkClass, ElkNamedIndividual> instanceNode) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(this.getNode() + ": new direct instance-node " + instanceNode));
            }
            this.directInstanceNodes_.add(instanceNode);
        }

        @Override
        public void removeDirectInstanceNode(UpdateableInstanceNode<ElkClass, ElkNamedIndividual> instanceNode) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(this.getNode() + ": direct instance node removed " + instanceNode));
            }
            this.directInstanceNodes_.remove(instanceNode);
        }
    }

    private abstract class TypeNodeWrapper
    implements TypeNode<ElkClass, ElkNamedIndividual> {
        protected final TaxonomyNode<ElkClass> classNode_;

        TypeNodeWrapper(TaxonomyNode<ElkClass> node) {
            this.classNode_ = node;
        }

        @Override
        public Set<ElkClass> getMembers() {
            return this.classNode_.getMembers();
        }

        @Override
        public ElkClass getCanonicalMember() {
            return (ElkClass)this.classNode_.getCanonicalMember();
        }

        @Override
        public Set<? extends InstanceNode<ElkClass, ElkNamedIndividual>> getDirectInstanceNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<? extends InstanceNode<ElkClass, ElkNamedIndividual>> getAllInstanceNodes() {
            if (!this.classNode_.getDirectSubNodes().isEmpty()) {
                ArrayHashSet result = new ArrayHashSet();
                LinkedList todo = new LinkedList();
                todo.add(this);
                while (!todo.isEmpty()) {
                    TypeNode next = (TypeNode)todo.poll();
                    result.addAll(next.getDirectInstanceNodes());
                    for (TypeNode nextSubNode : next.getDirectSubNodes()) {
                        todo.add(nextSubNode);
                    }
                }
                return Collections.unmodifiableSet(result);
            }
            return Collections.unmodifiableSet(this.getDirectInstanceNodes());
        }

        public String toString() {
            return this.classNode_.toString();
        }

        public int hashCode() {
            return this.classNode_.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeNodeWrapper) {
                return this.classNode_ == ((TypeNodeWrapper)obj).classNode_;
            }
            return false;
        }
    }
}

