/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTypeNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.hashing.HashGenerator;

public class IndividualNode
implements UpdateableInstanceNode<ElkClass, ElkNamedIndividual> {
    private static final Logger LOGGER_ = Logger.getLogger(IndividualNode.class);
    private final List<ElkNamedIndividual> members_;
    private final Set<UpdateableTypeNode<ElkClass, ElkNamedIndividual>> directTypeNodes_;
    private final AtomicBoolean modified_ = new AtomicBoolean(true);
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    protected IndividualNode(Collection<ElkNamedIndividual> members) {
        this.members_ = new ArrayList<ElkNamedIndividual>(members);
        this.directTypeNodes_ = new ArrayHashSet<UpdateableTypeNode<ElkClass, ElkNamedIndividual>>();
        Collections.sort(this.members_, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR);
    }

    @Override
    public void addDirectTypeNode(UpdateableTypeNode<ElkClass, ElkNamedIndividual> typeNode) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": new direct type-node " + typeNode));
        }
        this.directTypeNodes_.add(typeNode);
    }

    @Override
    public Set<ElkNamedIndividual> getMembers() {
        return new AbstractSet<ElkNamedIndividual>(){

            @Override
            public boolean contains(Object arg) {
                if (arg instanceof ElkNamedIndividual) {
                    return Collections.binarySearch(IndividualNode.this.members_, (ElkNamedIndividual)arg, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR) >= 0;
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                return IndividualNode.this.members_.isEmpty();
            }

            @Override
            public Iterator<ElkNamedIndividual> iterator() {
                return IndividualNode.this.members_.iterator();
            }

            @Override
            public int size() {
                return IndividualNode.this.members_.size();
            }
        };
    }

    public void setMembers(Collection<ElkNamedIndividual> members) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": updating members to " + members));
        }
        this.members_.clear();
        this.members_.addAll(members);
        Collections.sort(this.members_, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR);
    }

    @Override
    public ElkNamedIndividual getCanonicalMember() {
        return this.members_.get(0);
    }

    @Override
    public Set<UpdateableTypeNode<ElkClass, ElkNamedIndividual>> getDirectTypeNodes() {
        return Collections.unmodifiableSet(this.directTypeNodes_);
    }

    @Override
    public Set<UpdateableTypeNode<ElkClass, ElkNamedIndividual>> getAllTypeNodes() {
        ArrayHashSet<UpdateableTypeNode> result = new ArrayHashSet<UpdateableTypeNode>(this.directTypeNodes_.size());
        LinkedList todo = new LinkedList();
        todo.addAll(this.directTypeNodes_);
        while (!todo.isEmpty()) {
            UpdateableTypeNode next = (UpdateableTypeNode)todo.poll();
            if (!result.add(next)) continue;
            for (UpdateableTypeNode nextSuperNode : next.getDirectUpdateableSuperNodes()) {
                todo.add(nextSuperNode);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    public String toString() {
        return this.getCanonicalMember().getIri().getFullIriAsString();
    }

    @Override
    public boolean trySetModified(boolean modified) {
        boolean result = this.modified_.compareAndSet(!modified, modified);
        if (result && LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("node " + this + ": set " + (modified ? "modified" : "not modifiled")));
        }
        return result;
    }

    @Override
    public boolean isModified() {
        return this.modified_.get();
    }

    @Override
    public void removeDirectTypeNode(UpdateableTypeNode<ElkClass, ElkNamedIndividual> typeNode) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": removing direct type node: " + typeNode));
        }
        this.directTypeNodes_.remove(typeNode);
    }
}

