/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class LazySetUnion<E>
extends AbstractSet<E> {
    final Set<? extends E> firstSet;
    final Set<? extends E> secondSet;

    public LazySetUnion(Set<? extends E> firstSet, Set<? extends E> secondSet) {
        this.firstSet = firstSet;
        this.secondSet = secondSet;
    }

    @Override
    public Iterator<E> iterator() {
        return new SetUnionIterator<E>(this.firstSet, this.secondSet);
    }

    @Override
    public boolean contains(Object o) {
        return this.firstSet.contains(o) || this.secondSet.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.firstSet.size() + this.secondSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.firstSet.isEmpty() && this.secondSet.isEmpty();
    }

    static class SetUnionIterator<E>
    implements Iterator<E> {
        final Iterator<? extends E> firstIterator;
        final Iterator<? extends E> secondIterator;
        final Set<? extends E> secondChecker;

        SetUnionIterator(Set<? extends E> firstSet, Set<? extends E> secondSet) {
            this.firstIterator = firstSet.iterator();
            this.secondIterator = secondSet.iterator();
            this.secondChecker = secondSet;
        }

        @Override
        public boolean hasNext() {
            return this.firstIterator.hasNext() || this.secondIterator.hasNext();
        }

        @Override
        public E next() {
            while (this.firstIterator.hasNext()) {
                E next = this.firstIterator.next();
                if (this.secondChecker.contains(next)) continue;
                return next;
            }
            return this.secondIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

