/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.SelectProjection;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.base.FromItem;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelNodeBase;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlConstant;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;

public class SelectQuery
extends RdbmsQueryModelNodeBase
implements TupleExpr {
    private Map<String, SelectProjection> projections = new HashMap<String, SelectProjection>();
    private Map<String, String> bindingVars;
    private boolean distinct;
    private FromItem from;
    private List<OrderElem> order = new ArrayList<OrderElem>();
    private Long offset;
    private Long limit;

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public boolean isComplex() {
        if (this.offset != null || this.limit != null) {
            return true;
        }
        return this.isDistinct() || !this.order.isEmpty();
    }

    public FromItem getFrom() {
        return this.from;
    }

    public void setFrom(FromItem from) {
        this.from = from;
        from.setParentNode((QueryModelNode)this);
    }

    public List<OrderElem> getOrderElems() {
        return this.order;
    }

    public void addOrder(SqlExpr order, boolean isAscending) {
        if (order instanceof SqlNull) {
            return;
        }
        if (order instanceof SqlConstant) {
            return;
        }
        this.order.add(new OrderElem(order, isAscending));
        order.setParentNode((QueryModelNode)this);
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Collection<String> getBindingNames(ColumnVar var) {
        if (this.bindingVars == null) {
            return Collections.singleton(var.getName());
        }
        ArrayList<String> list = new ArrayList<String>(this.bindingVars.size());
        for (String name : this.bindingVars.keySet()) {
            if (!var.getName().equals(this.bindingVars.get(name))) continue;
            list.add(name);
        }
        return list;
    }

    public Set<String> getBindingNames() {
        if (this.bindingVars == null) {
            HashSet<String> names = new HashSet<String>();
            for (ColumnVar var : this.getVars()) {
                names.add(var.getName());
            }
            return names;
        }
        return new HashSet<String>(this.bindingVars.keySet());
    }

    public Set<String> getAssuredBindingNames() {
        return Collections.emptySet();
    }

    public void setBindingVars(Map<String, String> bindingVars) {
        this.bindingVars = bindingVars;
    }

    public Collection<SelectProjection> getSqlSelectVar() {
        return this.projections.values();
    }

    public void setSqlSelectVar(Collection<SelectProjection> projections) {
        this.projections.clear();
        for (SelectProjection p : projections) {
            this.addSqlSelectVar(p);
        }
    }

    public SelectProjection getSelectProjection(String name) {
        return this.projections.get(name);
    }

    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        for (String name : this.projections.keySet()) {
            if (this.projections.get(name) != current) continue;
            this.projections.put(name, (SelectProjection)replacement);
            replacement.setParentNode((QueryModelNode)this);
            return;
        }
        if (this.from == current) {
            this.from = (FromItem)replacement;
            replacement.setParentNode((QueryModelNode)this);
            return;
        }
        int n = this.order.size();
        for (int i = 0; i < n; ++i) {
            if (this.order.get((int)i).sqlExpr != current) continue;
            if (replacement instanceof SqlNull || this.order instanceof SqlConstant) {
                this.order.remove(i);
                return;
            }
            boolean asc = this.order.get((int)i).isAscending;
            this.order.set(i, new OrderElem((SqlExpr)replacement, asc));
            replacement.setParentNode((QueryModelNode)this);
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        super.visitChildren(visitor);
        this.from.visit(visitor);
        ArrayList<SelectProjection> list = new ArrayList<SelectProjection>(this.projections.values());
        for (SelectProjection expr : list) {
            ((RdbmsQueryModelNodeBase)expr).visit(visitor);
        }
        for (OrderElem by : new ArrayList<OrderElem>(this.order)) {
            by.sqlExpr.visit(visitor);
        }
    }

    public SelectQuery clone() {
        SelectQuery clone = (SelectQuery)super.clone();
        clone.distinct = this.distinct;
        clone.projections = new HashMap<String, SelectProjection>();
        for (SelectProjection expr : this.projections.values()) {
            clone.addSqlSelectVar(expr.clone());
        }
        clone.from = this.from.clone();
        clone.order = new ArrayList<OrderElem>(this.order);
        return clone;
    }

    @Override
    public <X extends Exception> void visit(RdbmsQueryModelVisitorBase<X> visitor) throws X {
        visitor.meet(this);
    }

    public boolean hasSqlSelectVar(SelectProjection node) {
        return this.projections.containsKey(node.getVar().getName());
    }

    public boolean hasSqlSelectVarName(String name) {
        return this.projections.containsKey(name);
    }

    public void addSqlSelectVar(SelectProjection node) {
        this.projections.put(node.getVar().getName(), node);
        node.setParentNode((QueryModelNode)this);
    }

    public Collection<ColumnVar> getProjections() {
        ArrayList<ColumnVar> vars = new ArrayList<ColumnVar>();
        for (SelectProjection proj : this.projections.values()) {
            ColumnVar var = proj.getVar();
            if (this.bindingVars == null) {
                vars.add(var);
                continue;
            }
            for (String name : this.bindingVars.keySet()) {
                if (!var.getName().equals(this.bindingVars.get(name))) continue;
                vars.add(var.as(name));
            }
        }
        return vars;
    }

    public Collection<ColumnVar> getVars() {
        ArrayList<ColumnVar> vars = new ArrayList<ColumnVar>();
        this.from.appendVars(vars);
        return vars;
    }

    public ColumnVar getVar(String varName) {
        return this.from.getVar(varName);
    }

    public void addFilter(SqlExpr sql) {
        this.from.addFilter(sql);
    }

    public void addJoin(SelectQuery right) {
        this.from.addJoin(right.getFrom());
    }

    public void addLeftJoin(SelectQuery right) {
        FromItem join = right.getFrom();
        join.setLeft(true);
        this.from.addJoin(join);
    }

    public FromItem getFromItem(String alias) {
        return this.from.getFromItemNotInUnion(alias);
    }

    public List<SqlExpr> getFilters() {
        return this.from.getFilters();
    }

    public void removeFilter(SqlExpr sqlExpr) {
        this.from.removeFilter(sqlExpr);
    }

    public Map<String, ColumnVar> getVarMap() {
        Collection<ColumnVar> vars = this.getVars();
        HashMap<String, ColumnVar> map = new HashMap<String, ColumnVar>(vars.size());
        for (ColumnVar var : vars) {
            if (map.containsKey(var.getName())) continue;
            map.put(var.getName(), var);
        }
        return map;
    }

    public static class OrderElem {
        public final SqlExpr sqlExpr;
        public final boolean isAscending;

        protected OrderElem(SqlExpr sqlExpr, boolean isAscending) {
            this.sqlExpr = sqlExpr;
            this.isAscending = isAscending;
        }
    }
}

