/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.model.impl.graph.elements;

import org.openrdf.model.URI;
import slib.graph.model.graph.elements.E;

public class Edge
implements E {
    private final URI source;
    private final URI target;
    private final URI predicate;

    public Edge(URI source, URI predicate, URI target) {
        this.source = source;
        this.predicate = predicate;
        this.target = target;
        if (source == null || predicate == null || target == null) {
            throw new IllegalArgumentException("Error creating edge, subject predicate and object must not be null, specified values " + this.toString());
        }
    }

    public URI getSource() {
        return this.source;
    }

    public URI getTarget() {
        return this.target;
    }

    public URI getURI() {
        return this.predicate;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.source != null ? this.source.hashCode() : 0);
        hash = 79 * hash + (this.target != null ? this.target.hashCode() : 0);
        hash = 79 * hash + (this.predicate != null ? this.predicate.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (!(this.source == other.source || this.source != null && this.source.equals((Object)other.source))) {
            return false;
        }
        if (!(this.target == other.target || this.target != null && this.target.equals((Object)other.target))) {
            return false;
        }
        return this.predicate == other.predicate || this.predicate != null && this.predicate.equals((Object)other.predicate);
    }

    public String toString() {
        return this.source.stringValue() + " -- " + this.predicate.stringValue() + " -- " + this.target.stringValue();
    }
}

