/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.model.impl.graph.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.model.impl.graph.elements.Edge;

public class GraphMemory
implements G {
    private Set<URI> uris;
    private Set<E> edges;
    private Map<URI, Set<E>> vertexOutEdges;
    private Map<URI, Set<E>> vertexInEdges;
    private URI uri;

    public GraphMemory(URI uri) {
        this.uri = uri;
        this.uris = new HashSet<URI>();
        this.edges = new HashSet<E>();
        this.vertexOutEdges = new HashMap<URI, Set<E>>();
        this.vertexInEdges = new HashMap<URI, Set<E>>();
    }

    public Set<E> getE() {
        return Collections.unmodifiableSet(this.edges);
    }

    public Set<E> getE(URI t) {
        if (t == null) {
            return this.getE();
        }
        HashSet<E> edgesCol = new HashSet<E>();
        for (E e : this.edges) {
            if (!e.getURI().equals((Object)t)) continue;
            edgesCol.add(e);
        }
        return Collections.unmodifiableSet(edgesCol);
    }

    public Set<E> getE(Set<URI> types, URI v, Direction dir) {
        HashSet<E> edgesCol = new HashSet<E>();
        if ((dir == Direction.IN || dir == Direction.BOTH) && this.vertexInEdges.containsKey(v)) {
            if (types == null) {
                edgesCol.addAll((Collection<E>)this.vertexInEdges.get(v));
            } else {
                for (E e : this.vertexInEdges.get(v)) {
                    if (!types.contains(e.getURI())) continue;
                    edgesCol.add(e);
                }
            }
        }
        if ((dir == Direction.OUT || dir == Direction.BOTH) && this.vertexOutEdges.containsKey(v)) {
            if (types == null) {
                edgesCol.addAll((Collection<E>)this.vertexOutEdges.get(v));
            } else {
                for (E e : this.vertexOutEdges.get(v)) {
                    if (!types.contains(e.getURI())) continue;
                    edgesCol.add(e);
                }
            }
        }
        return edgesCol;
    }

    public Set<E> getE(URI t, URI v, Direction dir) {
        if (v == null) {
            return this.getE(t);
        }
        HashSet<E> edgesCol = new HashSet<E>();
        if ((dir == Direction.IN || dir == Direction.BOTH || dir == null) && this.vertexInEdges.containsKey(v)) {
            if (t == null) {
                edgesCol.addAll((Collection)this.vertexInEdges.get(v));
            } else {
                for (E e : this.vertexInEdges.get(v)) {
                    if (!e.getURI().equals((Object)t)) continue;
                    edgesCol.add(e);
                }
            }
        }
        if ((dir == Direction.OUT || dir == Direction.BOTH || dir == null) && this.vertexOutEdges.containsKey(v)) {
            if (t == null) {
                edgesCol.addAll((Collection)this.vertexOutEdges.get(v));
            } else {
                for (E e : this.vertexOutEdges.get(v)) {
                    if (!e.getURI().equals((Object)t)) continue;
                    edgesCol.add(e);
                }
            }
        }
        return Collections.unmodifiableSet(edgesCol);
    }

    public Set<E> getE(URI v, Direction dir) {
        if (v == null) {
            return this.getE();
        }
        HashSet edgesCol = new HashSet();
        if ((dir == Direction.IN || dir == Direction.BOTH || dir == null) && this.vertexInEdges.containsKey(v)) {
            edgesCol.addAll(this.vertexInEdges.get(v));
        }
        if ((dir == Direction.OUT || dir == Direction.BOTH || dir == null) && this.vertexOutEdges.containsKey(v)) {
            edgesCol.addAll(this.vertexOutEdges.get(v));
        }
        return Collections.unmodifiableSet(edgesCol);
    }

    public void addE(E e) {
        if (!this.edges.contains(e)) {
            URI s = e.getSource();
            URI o = e.getTarget();
            this.addV(s);
            this.addV(o);
            this.edges.add(e);
            if (!this.vertexOutEdges.containsKey(s)) {
                this.vertexOutEdges.put(s, new HashSet());
            }
            if (!this.vertexInEdges.containsKey(o)) {
                this.vertexInEdges.put(o, new HashSet());
            }
            this.vertexOutEdges.get(s).add(e);
            this.vertexInEdges.get(o).add(e);
        }
    }

    public Set<URI> getV() {
        return Collections.unmodifiableSet(this.uris);
    }

    public void addE(URI src, URI predicate, URI target) {
        this.addE(new Edge(src, predicate, target));
    }

    public void addE(Set<E> edges) {
        if (edges == null) {
            return;
        }
        for (E e : edges) {
            this.addE(e);
        }
    }

    public void removeE(E e) {
        if (e == null) {
            return;
        }
        this.edges.remove(e);
        if (this.vertexOutEdges.containsKey(e.getSource())) {
            this.vertexOutEdges.get(e.getSource()).remove(e);
        }
        if (this.vertexInEdges.containsKey(e.getTarget())) {
            this.vertexInEdges.get(e.getTarget()).remove(e);
        }
    }

    public void removeE(URI t) {
        Iterator<E> iter = this.edges.iterator();
        while (iter.hasNext()) {
            E c = iter.next();
            if (!c.getURI().equals((Object)t)) continue;
            this.vertexOutEdges.get(c.getSource()).remove(c);
            this.vertexInEdges.get(c.getTarget()).remove(c);
            iter.remove();
        }
    }

    public void removeE(Set<E> e) {
        for (E edge : e) {
            this.removeE(edge);
        }
    }

    public void addV(URI v) {
        if (v == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        this.uris.add(v);
    }

    public void addV(Set<URI> vertices) {
        if (vertices == null) {
            return;
        }
        this.uris.addAll(vertices);
    }

    public void removeV(URI v) {
        if (v == null) {
            return;
        }
        HashSet<E> toRemove = new HashSet<E>();
        if (this.vertexOutEdges.containsKey(v)) {
            toRemove.addAll((Collection)this.vertexOutEdges.get(v));
            this.vertexOutEdges.remove(v);
        }
        if (this.vertexInEdges.containsKey(v)) {
            toRemove.addAll((Collection<E>)this.vertexInEdges.get(v));
            this.vertexInEdges.remove(v);
        }
        this.removeE(toRemove);
        this.uris.remove(v);
    }

    public void removeV(Set<URI> setV) {
        if (setV == null) {
            return;
        }
        for (URI v : setV) {
            this.removeV(v);
        }
    }

    public boolean containsVertex(URI v) {
        return this.uris.contains(v);
    }

    public boolean containsEdge(URI s, URI p, URI o) {
        for (E e : this.getE(p, s, Direction.OUT)) {
            if (!e.getTarget().equals((Object)o)) continue;
            return true;
        }
        return false;
    }

    public int getNumberVertices() {
        return this.uris.size();
    }

    public int getNumberEdges() {
        return this.edges.size();
    }

    public Set<E> getE(Set<URI> c) {
        if (c == null || c.isEmpty()) {
            return this.getE();
        }
        HashSet<E> edgesCol = new HashSet<E>();
        for (E e : this.edges) {
            if (!c.contains(e.getURI())) continue;
            edgesCol.add(e);
        }
        return edgesCol;
    }

    public void clear() {
        this.edges.clear();
        this.uris.clear();
        this.vertexInEdges.clear();
        this.vertexOutEdges.clear();
    }

    public URI getURI() {
        return this.uri;
    }

    public Set<URI> getV(URI v, URI buildUri, Direction dir) {
        HashSet<URI> vert = new HashSet<URI>();
        if ((dir == Direction.OUT || dir == Direction.BOTH) && this.vertexOutEdges.containsKey(v)) {
            for (E e : this.vertexOutEdges.get(v)) {
                if (buildUri != null && !buildUri.equals((Object)e.getURI())) continue;
                vert.add(e.getTarget());
            }
        }
        if ((dir == Direction.IN || dir == Direction.BOTH) && this.vertexInEdges.containsKey(v)) {
            for (E e : this.vertexInEdges.get(v)) {
                if (buildUri != null && !buildUri.equals((Object)e.getURI())) continue;
                vert.add(e.getSource());
            }
        }
        return vert;
    }

    public String toString() {
        String out = "";
        out = this.uri == null ? out + "Uri undefined\n" : out + this.uri.toString() + "\n";
        String exURiVertex = "";
        if (!this.uris.isEmpty()) {
            exURiVertex = "{e.g. " + this.uris.iterator().next().toString() + "}";
        }
        out = out + "Vertices\n";
        out = out + "\tTotal   : " + this.uris.size() + "  " + exURiVertex + "\n";
        out = out + "Edges \t  : " + this.edges.size() + "\n\n";
        return out;
    }

    public Set<E> getE(URI v, WalkConstraint wc) {
        Set ok;
        HashSet<E> valid = new HashSet<E>();
        if (wc.acceptOutWalks() && this.vertexOutEdges.containsKey(v)) {
            ok = wc.getAcceptedWalks_DIR_OUT();
            for (E e : this.vertexOutEdges.get(v)) {
                if (!ok.contains(e.getURI())) continue;
                valid.add(e);
            }
        }
        if (wc.acceptInWalks() && this.vertexInEdges.containsKey(v)) {
            ok = wc.getAcceptedWalks_DIR_IN();
            for (E e : this.getE(v, Direction.IN)) {
                if (!ok.contains(e.getURI())) continue;
                valid.add(e);
            }
        }
        return valid;
    }

    public Set<URI> getV(URI v, WalkConstraint wc) {
        HashSet<URI> valid = new HashSet<URI>();
        if (wc.acceptOutWalks() && this.vertexOutEdges.containsKey(v)) {
            Set ok = wc.getAcceptedWalks_DIR_OUT();
            for (E e : this.getE(v, Direction.OUT)) {
                if (!ok.contains(e.getURI())) continue;
                valid.add(e.getTarget());
            }
        }
        if (wc.acceptInWalks() && this.vertexInEdges.containsKey(v)) {
            for (E e : this.getE(v, Direction.IN)) {
                Set ok = wc.getAcceptedWalks_DIR_IN();
                if (!ok.contains(e.getURI())) continue;
                valid.add(e.getSource());
            }
        }
        return valid;
    }
}

