/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.model.impl.graph.weight;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.weight.GWS;

public class GWS_impl
implements GWS {
    double defaultWeight = 1.0;
    Map<URI, Double> eTypeWeights;
    Map<E, Double> eWeights;

    public GWS_impl() {
    }

    public GWS_impl(double defaultWeight) {
        this.defaultWeight = defaultWeight;
    }

    public double getDefaultWeight() {
        return this.defaultWeight;
    }

    public void setDefaultWeight(double w) {
        this.defaultWeight = w;
    }

    public boolean existsWeight(E e) {
        return this.eWeights != null && this.eWeights.containsKey(e);
    }

    public double getWeight(E e) {
        Double w;
        if (this.eWeights == null) {
            if (this.eTypeWeights == null) {
                return this.defaultWeight;
            }
            w = this.eTypeWeights.get(e.getURI());
            if (w == null) {
                return this.defaultWeight;
            }
        } else {
            w = this.eWeights.get(e);
        }
        if (w == null) {
            return this.defaultWeight;
        }
        return w;
    }

    public void setWeight(E e, double w) {
        if (this.eWeights == null) {
            this.eWeights = new HashMap<E, Double>();
        }
        this.eWeights.put(e, w);
    }

    public boolean existsWeight(URI e) {
        return this.eTypeWeights != null && this.eTypeWeights.containsKey(e);
    }

    public Double getWeight(URI e) {
        Double w = this.eTypeWeights.get(e);
        if (w == null) {
            return this.defaultWeight;
        }
        return w;
    }

    public void setWeight(URI e, double w) {
        if (this.eTypeWeights == null) {
            this.eTypeWeights = new HashMap<URI, Double>();
        }
        this.eTypeWeights.put(e, w);
    }

    public String toString() {
        String out = "WS: Configuration\ndefaultWeight " + this.defaultWeight;
        out = this.eWeights == null ? out + "\neWeights undefined" : out + "\neWeights size " + this.eWeights.size();
        out = this.eTypeWeights == null ? out + "\neTypeWeights undefined" : out + "\neTypeWeights size " + this.eTypeWeights.size();
        return out;
    }
}

