/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.model.impl.repo;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.openrdf.model.URI;
import org.openrdf.sail.memory.model.MemValueFactory;
import slib.graph.model.repo.URIFactory;
import slib.utils.ex.SLIB_Ex_Critic;

public final class URIFactoryMemory
implements URIFactory {
    MemValueFactory internalUriFactory;
    private static URIFactoryMemory repository;
    private Map<String, String> namespacePrefixes2namespaces;
    private Map<String, String> namespaces2namespacePrefixes;
    Pattern colon = Pattern.compile(":");

    public static URIFactoryMemory getSingleton() {
        if (repository == null) {
            repository = new URIFactoryMemory();
        }
        return repository;
    }

    private URIFactoryMemory() {
        this.internalUriFactory = new MemValueFactory();
        this.namespacePrefixes2namespaces = new HashMap<String, String>();
        this.namespaces2namespacePrefixes = new HashMap<String, String>();
        try {
            this.loadNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.loadNamespacePrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            this.loadNamespacePrefix("owl", "http://www.w3.org/2002/07/owl#");
            this.loadNamespacePrefix("owl", "http://www.w3.org/2004/02/skos/core#");
            this.loadNamespacePrefix("dc", "http://purl.org/dc/elements/1.1/");
            this.loadNamespacePrefix("dcterm", "http://purl.org/dc/terms/");
            this.loadNamespacePrefix("foaf", "http://xmlns.com/foaf/0.1/");
        }
        catch (SLIB_Ex_Critic sLIB_Ex_Critic) {
            // empty catch block
        }
    }

    public boolean loadNamespacePrefix(String prefix, String reference) throws SLIB_Ex_Critic {
        if (!this.namespacePrefixes2namespaces.containsKey(prefix.toLowerCase())) {
            this.namespacePrefixes2namespaces.put(prefix, reference);
            this.namespacePrefixes2namespaces.put(prefix.toLowerCase(), reference);
            this.namespacePrefixes2namespaces.put(prefix.toUpperCase(), reference);
            this.namespaces2namespacePrefixes.put(reference, prefix);
            return true;
        }
        if (this.namespacePrefixes2namespaces.containsKey(prefix) && !this.namespacePrefixes2namespaces.get(prefix).equals(reference)) {
            throw new SLIB_Ex_Critic("Cannot include namespace prefix " + prefix + " for namespace " + reference + "" + "\n prefix already linked to " + this.namespacePrefixes2namespaces.get(prefix));
        }
        return false;
    }

    public String getNamespace(String ns_prefix) {
        if (ns_prefix == null) {
            return null;
        }
        return this.namespacePrefixes2namespaces.get(ns_prefix);
    }

    public void clear() {
        this.namespacePrefixes2namespaces.clear();
    }

    public URI getURI(String sURI) {
        return this.internalUriFactory.createURI(sURI);
    }

    public URI getURI(String snamespace, String sURI) {
        return this.internalUriFactory.createURI(snamespace, sURI);
    }

    public URI getURI(String sURI, boolean useLoadedPrefix) {
        if (!useLoadedPrefix) {
            return this.getURI(sURI);
        }
        int idx = sURI.indexOf(":");
        if (idx != -1) {
            String prefix = sURI.substring(0, idx);
            if (this.namespacePrefixes2namespaces.containsKey(prefix)) {
                return this.getURI(this.namespacePrefixes2namespaces.get(prefix), sURI.substring(idx + 1));
            }
            return this.getURI(sURI);
        }
        return this.getURI(sURI);
    }

    public String shortURIasString(URI uri) {
        if (this.namespaces2namespacePrefixes.containsKey(uri.getNamespace())) {
            return this.namespaces2namespacePrefixes.get(uri.getNamespace()) + ":" + uri.getLocalName();
        }
        return uri.stringValue();
    }

    public Map<String, String> getURIPrefixes() {
        return this.namespacePrefixes2namespaces;
    }
}

