/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.index.bplustree;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.file.MetaFile;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.sys.Names;
import org.apache.jena.tdb.sys.SystemTDB;
import org.slf4j.Logger;

public final class BPlusTreeParams {
    public static boolean CheckingTree = SystemTDB.Checking;
    public static boolean CheckingNode = false;
    public static boolean CheckingConcurrency = SystemTDB.Checking;
    public static final String NS = Names.keyNSBPlusTree;
    public static final String ParamOrder = NS + ".order";
    public static final String ParamKeyLength = NS + ".keyLength";
    public static final String ParamValueLength = NS + ".valueLength";
    public static final String ParamBlockSize = NS + ".blockSize";
    public static boolean DumpTree = false;
    public static boolean Logging = false;
    private static final int Gap = 0;
    public static final int RootId = 0;
    public static final int RootParent = -2;
    public static final int NoParent = -99;
    final int order;
    final RecordFactory recordFactory;
    final RecordFactory keyFactory;
    final int MaxRec;
    final int MaxPtr;
    final int MinRec;
    final int MinPtr;
    final int SplitIndex;
    final int HighRec;
    final int HighPtr;
    static int BlockHeaderSize = 4;

    public static void checkAll() {
        CheckingTree = true;
        CheckingNode = true;
    }

    public static void infoAll() {
        DumpTree = true;
        Logging = true;
    }

    static final boolean logging(Logger log) {
        return Logging && log.isDebugEnabled();
    }

    public String toString() {
        return String.format("Order=%d : Records [key=%d, value=%d] : records=[%d,%d] : pointers=[%d,%d] : split=%d", this.order, this.keyFactory.keyLength(), this.recordFactory.valueLength(), this.MinRec, this.MaxRec, this.MinPtr, this.MaxPtr, this.SplitIndex);
    }

    public static BPlusTreeParams readMeta(MetaFile mf) {
        try {
            int pOrder = mf.getPropertyAsInteger(ParamOrder);
            int pKeyLen = mf.getPropertyAsInteger(ParamKeyLength);
            int pRecLen = mf.getPropertyAsInteger(ParamValueLength);
            return new BPlusTreeParams(pOrder, pKeyLen, pRecLen);
        }
        catch (NumberFormatException ex) {
            Log.error(BPlusTreeParams.class, (String)"Badly formed metadata for B+Tree");
            throw new TDBException("Failed to read metadata");
        }
    }

    public void addToMetaData(MetaFile mf) {
        mf.setProperty(ParamOrder, this.order);
        mf.setProperty(ParamKeyLength, this.recordFactory.keyLength());
        mf.setProperty(ParamValueLength, this.recordFactory.valueLength());
        mf.flush();
    }

    public BPlusTreeParams(int order, int keyLen, int valLen) {
        this(order, new RecordFactory(keyLen, valLen));
    }

    public BPlusTreeParams(int order, RecordFactory factory) {
        if (order < 2) {
            throw new IllegalArgumentException("BPTree: illegal order (min 2): " + order);
        }
        this.order = order;
        this.recordFactory = factory;
        this.keyFactory = factory.keyFactory();
        this.MaxRec = 2 * order - 1 + 0;
        this.MaxPtr = 2 * order + 0;
        this.MinRec = order - 1;
        this.MinPtr = order;
        this.SplitIndex = order - 1 + 0;
        this.HighPtr = this.MaxPtr - 1;
        this.HighRec = this.HighPtr - 1;
    }

    public int getOrder() {
        return this.order;
    }

    public int getPtrLength() {
        return 4;
    }

    public int getRecordLength() {
        return this.recordFactory.recordLength();
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public int getKeyLength() {
        return this.keyFactory.recordLength();
    }

    public RecordFactory getKeyFactory() {
        return this.keyFactory;
    }

    public int getCalcBlockSize() {
        return BPlusTreeParams.calcBlockSize(this.order, this.recordFactory);
    }

    public static int calcOrder(int blockSize, RecordFactory factory) {
        return BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
    }

    public static int calcOrder(int blockSize, int recordLength) {
        int X = ((blockSize -= BlockHeaderSize) - recordLength) / (recordLength + 4);
        int order = (X + 1 - 0) / 2;
        return order;
    }

    public static int calcBlockSize(int bpTreeOrder, RecordFactory factory) {
        BPlusTreeParams p = new BPlusTreeParams(bpTreeOrder, factory);
        int x = p.getMaxRec() * factory.recordLength() + p.getMaxPtr() * 4;
        return x += BlockHeaderSize;
    }

    public int getMaxRec() {
        return this.MaxRec;
    }

    public int getMaxPtr() {
        return this.MaxPtr;
    }

    public int getMinRec() {
        return this.MinRec;
    }

    public int getMinPtr() {
        return this.MinPtr;
    }
}

