/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail.helpers;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UpdateContext;

public class RDFSailInserter
extends RDFHandlerBase {
    private final SailConnection con;
    private final ValueFactory vf;
    private final UpdateContext uc;
    private Resource[] contexts = new Resource[0];
    private boolean preserveBNodeIDs;
    private final Map<String, String> namespaceMap;
    private final Map<String, BNode> bNodesMap;

    public RDFSailInserter(SailConnection con, ValueFactory vf, UpdateContext uc) {
        this.con = con;
        this.vf = vf;
        this.uc = uc;
        this.preserveBNodeIDs = true;
        this.namespaceMap = new HashMap<String, String>();
        this.bNodesMap = new HashMap<String, BNode>();
    }

    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.preserveBNodeIDs = preserveBNodeIDs;
    }

    public boolean preservesBNodeIDs() {
        return this.preserveBNodeIDs;
    }

    public void enforceContext(Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.contexts = contexts;
    }

    public boolean enforcesContext() {
        return this.contexts.length != 0;
    }

    public Resource[] getContexts() {
        return this.contexts;
    }

    public void endRDF() throws RDFHandlerException {
        for (Map.Entry<String, String> entry : this.namespaceMap.entrySet()) {
            String prefix = entry.getKey();
            String name = entry.getValue();
            try {
                if (this.con.getNamespace(prefix) != null) continue;
                this.con.setNamespace(prefix, name);
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
        this.namespaceMap.clear();
        this.bNodesMap.clear();
    }

    public void handleNamespace(String prefix, String name) {
        if (prefix != null && !this.namespaceMap.containsKey(prefix)) {
            this.namespaceMap.put(prefix, name);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subj = st.getSubject();
        URI pred = st.getPredicate();
        Value obj = st.getObject();
        Resource ctxt = st.getContext();
        if (!this.preserveBNodeIDs) {
            if (subj instanceof BNode) {
                subj = this.mapBNode((BNode)subj);
            }
            if (obj instanceof BNode) {
                obj = this.mapBNode((BNode)obj);
            }
            if (!this.enforcesContext() && ctxt instanceof BNode) {
                ctxt = this.mapBNode((BNode)ctxt);
            }
        }
        try {
            if (this.enforcesContext()) {
                this.con.addStatement(this.uc, subj, pred, obj, this.contexts);
            } else if (ctxt == null) {
                URI insertGraph = this.uc.getDataset().getDefaultInsertGraph();
                if (insertGraph != null) {
                    this.con.addStatement(this.uc, subj, pred, obj, new Resource[]{insertGraph});
                } else {
                    this.con.addStatement(this.uc, subj, pred, obj, new Resource[0]);
                }
            } else {
                this.con.addStatement(this.uc, subj, pred, obj, new Resource[]{ctxt});
            }
        }
        catch (SailException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private BNode mapBNode(BNode bNode) {
        BNode result = this.bNodesMap.get(bNode.getID());
        if (result == null) {
            result = this.vf.createBNode();
            this.bNodesMap.put(bNode.getID(), result);
        }
        return result;
    }
}

