/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.proxy;

import io.ray.api.BaseActorHandle;
import io.ray.api.Ray;
import io.ray.serve.api.Serve;
import io.ray.serve.exception.RayServeException;
import io.ray.serve.generated.EndpointInfo;
import io.ray.serve.generated.EndpointSet;
import io.ray.serve.poll.KeyListener;
import io.ray.serve.poll.KeyType;
import io.ray.serve.poll.LongPollClient;
import io.ray.serve.poll.LongPollNamespace;
import io.ray.serve.proxy.HttpProxy;
import io.ray.serve.proxy.ProxyRouter;
import io.ray.serve.proxy.ServeProxy;
import io.ray.serve.util.CollectionUtil;
import io.ray.serve.util.LogUtil;
import io.ray.serve.util.ReflectUtil;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyActor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyActor.class);
    private Map<String, String> config;
    private Map<String, ServeProxy> proxies = new ConcurrentHashMap<String, ServeProxy>();
    private volatile Map<String, EndpointInfo> routeInfo = new HashMap<String, EndpointInfo>();
    private LongPollClient longPollClient;
    private ProxyRouter proxyRouter = new ProxyRouter();

    public ProxyActor(String controllerName, Map<String, String> config) {
        this.config = config;
        Serve.setInternalReplicaContext(null, null, controllerName, null, config);
        Optional optional = Ray.getActor(controllerName, "serve");
        Preconditions.checkState(optional.isPresent(), "Controller does not exist");
        HashMap<KeyType, KeyListener> keyListeners = new HashMap<KeyType, KeyListener>();
        keyListeners.put(new KeyType(LongPollNamespace.ROUTE_TABLE, null), endpoints -> this.updateRoutes(endpoints));
        this.longPollClient = new LongPollClient((BaseActorHandle)optional.get(), keyListeners);
        this.run();
    }

    private void run() {
        this.startupProxy();
        this.registerServiceDiscovery();
    }

    private void startupProxy() {
        String proxyClassNames;
        List<ServeProxy> serveProxies = null;
        String string = proxyClassNames = this.config != null ? this.config.get("ray.serve.proxy.class") : null;
        if (StringUtils.isNotBlank(proxyClassNames)) {
            try {
                serveProxies = ReflectUtil.getInstancesByClassNames(proxyClassNames, ServeProxy.class);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                String errorMsg = LogUtil.format("Failed to initialize proxies by class names : {}", proxyClassNames);
                LOGGER.error(errorMsg, e);
                throw new RayServeException(errorMsg, e);
            }
        }
        if (CollectionUtil.isEmpty(serveProxies)) {
            ArrayList<ServeProxy> spiProxies = new ArrayList<ServeProxy>();
            ServiceLoader<ServeProxy> serviceLoader = ServiceLoader.load(ServeProxy.class);
            serviceLoader.forEach(serveProxy -> spiProxies.add((ServeProxy)serveProxy));
            serveProxies = spiProxies;
        }
        if (CollectionUtil.isEmpty(serveProxies)) {
            serveProxies = Lists.newArrayList(new HttpProxy());
        }
        if (!CollectionUtil.isEmpty(serveProxies)) {
            for (ServeProxy serveProxy2 : serveProxies) {
                if (this.proxies.containsKey(serveProxy2.getName())) {
                    String errorMsg = LogUtil.format("Proxy {} name {} is duplicate with proxy {} name {}", serveProxy2.getClass().getName(), serveProxy2.getName(), this.proxies.get(serveProxy2.getName()).getClass().getName(), this.proxies.get(serveProxy2.getName()).getName());
                    LOGGER.error(errorMsg);
                    throw new RayServeException(errorMsg);
                }
                this.proxies.put(serveProxy2.getName(), serveProxy2);
                serveProxy2.init(this.config, this.proxyRouter);
                LOGGER.info("Proxy actor initialized proxy: {}", (Object)serveProxy2.getName());
            }
        }
    }

    public void registerServiceDiscovery() {
        this.proxies.forEach((key, value) -> value.registerServiceDiscovery());
    }

    public void updateRoutes(Object endpoints) {
        Map<String, EndpointInfo> endpointInfos = ((EndpointSet)endpoints).getEndpointsMap();
        HashMap<String, EndpointInfo> routeInfo = new HashMap<String, EndpointInfo>();
        if (endpointInfos != null) {
            endpointInfos.forEach((key, value) -> routeInfo.put(StringUtils.isNotBlank(value.getRoute()) ? value.getRoute() : key, (EndpointInfo)value));
        }
        this.routeInfo = routeInfo;
        this.proxyRouter.updateRoutes(endpointInfos);
    }

    public boolean ready() {
        return true;
    }

    public boolean blockUntilEndpointExists(String endpoint, double timeoutS) {
        long timeoutMs = (long)(timeoutS * 1000.0);
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                throw new RayServeException(LogUtil.format("Waited {} for {} to propagate.", timeoutS, endpoint));
            }
            for (EndpointInfo endpointInfo : this.routeInfo.values()) {
                if (!StringUtils.equals(endpointInfo.getEndpointName(), endpoint)) continue;
                return true;
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("The sleeping was interrupted when waiting for the endpoint {} being existing.", (Object)endpoint, (Object)e);
                continue;
            }
            break;
        }
    }

    public ProxyRouter getProxyRouter() {
        return this.proxyRouter;
    }

    public Map<String, ServeProxy> getProxies() {
        return this.proxies;
    }
}

