# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import jsonfield.fields
import django.db.models.deletion
import repositories.custom_models


class Migration(migrations.Migration):

    dependencies = [
        ('configuracao', '0001_initial'),
        ('cliente', '0002_auto_20160708_1948'),
        ('catalogo', '0002_auto_20160708_1948'),
        ('plataforma', '0001_initial'),
        ('marketing', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Carrinho',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'carrinho_id')),
                ('token', models.CharField(max_length=64, db_column=b'carrinho_token')),
                ('data_criacao', models.DateTimeField(auto_now_add=True, db_column=b'carrinho_data_criacao')),
                ('data_modificacao', models.DateTimeField(auto_now=True, db_column=b'carrinho_data_modificacao')),
                ('cliente', models.ForeignKey(related_name='carrinhos', db_column=b'cliente_id', to='cliente.Cliente', null=True)),
                ('conta', models.ForeignKey(related_name='carrinhos', db_column=b'conta_id', to='plataforma.Conta')),
                ('contrato', models.ForeignKey(related_name='carrinhos', to='plataforma.Contrato')),
            ],
            options={
                'db_table': 'pedido"."tb_carrinho',
                'verbose_name': 'Carrinho',
                'verbose_name_plural': 'Carrinhos',
            },
        ),
        migrations.CreateModel(
            name='CarrinhoProduto',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'carrinho_produto_id')),
                ('quantidade', models.IntegerField(default=1, db_column=b'carrinho_produto_quantidade')),
                ('carrinho', models.ForeignKey(related_name='carrinho_produtos', db_column=b'carrinho_id', to='pedido.Carrinho')),
                ('conta', models.ForeignKey(related_name='carrinho_produtos', db_column=b'conta_id', to='plataforma.Conta')),
                ('contrato', models.ForeignKey(related_name='carrinho_produtos', to='plataforma.Contrato')),
                ('produto', models.ForeignKey(related_name='carrinhos_produto', db_column=b'produto_id', to='catalogo.Produto')),
            ],
            options={
                'db_table': 'pedido"."tb_carrinho_produto',
                'verbose_name': 'Produto no carrinho',
                'verbose_name_plural': 'Produtos no carrinho',
            },
        ),
        migrations.CreateModel(
            name='PedidoVenda',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_id')),
                ('numero', models.BigIntegerField(db_column=b'pedido_venda_numero', db_index=True)),
                ('consolidado', models.BooleanField(default=False, db_column=b'pedido_venda_consolidado')),
                ('telefone_principal', models.CharField(max_length=11, null=True, db_column=b'pedido_venda_telefone_principal')),
                ('telefone_comercial', models.CharField(max_length=11, null=True, db_column=b'pedido_venda_telefone_comercial')),
                ('telefone_celular', models.CharField(max_length=11, null=True, db_column=b'pedido_venda_telefone_celular')),
                ('valor_subtotal', models.DecimalField(null=True, decimal_places=4, max_digits=16, db_column=b'pedido_venda_valor_subtotal')),
                ('valor_envio', models.DecimalField(null=True, decimal_places=4, max_digits=16, db_column=b'pedido_venda_valor_envio')),
                ('valor_total', models.DecimalField(null=True, decimal_places=4, max_digits=16, db_column=b'pedido_venda_valor_total')),
                ('valor_desconto', models.DecimalField(null=True, decimal_places=4, max_digits=16, db_column=b'pedido_venda_valor_desconto')),
                ('peso_real', models.DecimalField(null=True, decimal_places=3, max_digits=16, db_column=b'pedido_venda_peso_real')),
                ('data_criacao', models.DateTimeField(auto_now_add=True, db_column=b'pedido_venda_data_criacao')),
                ('data_modificacao', models.DateTimeField(auto_now=True, db_column=b'pedido_venda_data_modificacao')),
                ('data_expiracao', models.DateTimeField(default=None, null=True, db_column=b'pedido_venda_data_expiracao')),
                ('cliente_obs', models.TextField(default=None, null=True, db_column=b'pedido_venda_cliente_obs')),
                ('conteudo_json', jsonfield.fields.JSONField(null=True, db_column=b'pedido_venda_conteudo_json')),
                ('numero_nota_fiscal', models.BigIntegerField(null=True, db_column=b'pedido_venda_numero_nota_fiscal')),
                ('referencia', models.TextField(default=None, null=True, db_column=b'pedido_venda_referencia')),
                ('utm_campaign', models.CharField(max_length=255, null=True, db_column=b'pedido_venda_utm_campaign')),
            ],
            options={
                'get_latest_by': 'id',
                'ordering': ['id'],
                'verbose_name_plural': 'Pedidos de Venda',
                'db_table': 'pedido"."tb_pedido_venda',
                'verbose_name': 'Pedido Venda',
            },
        ),
        migrations.CreateModel(
            name='PedidoVendaEndereco',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_endereco_id')),
                ('tipo', models.CharField(max_length=64, db_column=b'pedido_venda_endereco_tipo', choices=[(b'pf', 'Pessoa F\xedsica'), (b'pj', 'Pessoa Jur\xeddica')])),
                ('cpf', models.CharField(max_length=11, null=True, db_column=b'pedido_venda_endereco_cpf')),
                ('rg', models.CharField(max_length=20, null=True, db_column=b'pedido_venda_endereco_rg')),
                ('cnpj', models.CharField(max_length=14, null=True, db_column=b'pedido_venda_endereco_cnpj')),
                ('razao_social', models.CharField(max_length=255, null=True, db_column=b'pedido_venda_endereco_razao_social')),
                ('ie', models.CharField(max_length=20, null=True, db_column=b'pedido_venda_endereco_ie')),
                ('nome', models.CharField(max_length=255, db_column=b'pedido_venda_endereco_nome')),
                ('endereco', models.CharField(max_length=255, db_column=b'pedido_venda_endereco_endereco')),
                ('numero', models.CharField(max_length=10, db_column=b'pedido_venda_endereco_numero')),
                ('complemento', models.CharField(max_length=255, null=True, db_column=b'pedido_venda_endereco_complemento')),
                ('referencia', models.CharField(max_length=255, null=True, db_column=b'pedido_venda_endereco_referencia')),
                ('bairro', models.CharField(max_length=128, db_column=b'pedido_venda_endereco_bairro')),
                ('cidade', models.CharField(max_length=128, db_column=b'pedido_venda_endereco_cidade')),
                ('estado', models.CharField(max_length=2, db_column=b'pedido_venda_endereco_estado')),
                ('cep', models.CharField(max_length=8, db_column=b'pedido_venda_endereco_cep')),
                ('pais', models.CharField(max_length=128, null=True, db_column=b'pedido_venda_endereco_pais')),
                ('conta', models.ForeignKey(related_name='pedido_venda_enderecos', to='plataforma.Conta')),
                ('contrato', models.ForeignKey(related_name='pedido_venda_enderecos', to='plataforma.Contrato')),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'pedido"."tb_pedido_venda_endereco',
                'verbose_name': 'Endere\xe7o do pedido de venda',
                'verbose_name_plural': 'Endere\xe7os de pedidos de vendas',
            },
        ),
        migrations.CreateModel(
            name='PedidoVendaFormaEnvio',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_envio_id')),
                ('objeto', models.CharField(max_length=32, null=True, db_column=b'pedido_venda_envio_objeto', blank=True)),
                ('valor', models.DecimalField(null=True, decimal_places=2, max_digits=16, db_column=b'pedido_venda_envio_valor')),
                ('data_criacao', models.DateTimeField(auto_now_add=True, db_column=b'pedido_venda_envio_data_criacao')),
                ('data_modificacao', models.DateTimeField(auto_now=True, db_column=b'pedido_venda_envio_data_modificacao')),
                ('mensagem_correios', models.TextField(default=None, null=True, db_column=b'pedido_venda_envio_mensagem_correios')),
                ('prazo', models.IntegerField(default=None, null=True, db_column=b'pedido_venda_envio_prazo')),
                ('conta', models.ForeignKey(related_name='pedido_venda_envios', to='plataforma.Conta')),
                ('contrato', models.ForeignKey(related_name='pedido_venda_envios', to='plataforma.Contrato')),
                ('envio', models.ForeignKey(related_name='pedidos_envio', to='configuracao.Envio')),
                ('pedido', models.ForeignKey(related_name='pedido_envios', db_column=b'pedido_venda_id', to='pedido.PedidoVenda')),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'pedido"."tb_pedido_venda_envio',
                'verbose_name': 'Forma de envio de um pedido de venda',
                'verbose_name_plural': 'Formas de envios dos pedidos de vendas',
            },
        ),
        migrations.CreateModel(
            name='PedidoVendaFormaPagamento',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_pagamento_id')),
                ('valor', models.DecimalField(null=True, decimal_places=2, max_digits=16, db_column=b'pedido_venda_pagamento_valor')),
                ('valor_pago', models.DecimalField(null=True, decimal_places=2, max_digits=16, db_column=b'pedido_venda_pagamento_valor_pago')),
                ('transacao_id', models.CharField(max_length=64, null=True, db_column=b'pedido_venda_pagamento_transacao_id')),
                ('identificador_id', models.CharField(max_length=64, null=True, db_column=b'pedido_venda_pagamento_identificador_id')),
                ('conteudo', models.TextField(null=True, db_column=b'pedido_venda_pagamento_conteudo')),
                ('conteudo_json', jsonfield.fields.JSONField(null=True, db_column=b'pedido_venda_pagamento_conteudo_json')),
                ('data_criacao', models.DateTimeField(auto_now_add=True, db_column=b'pedido_venda_pagamento_data_criacao')),
                ('data_modificacao', models.DateTimeField(auto_now=True, db_column=b'pedido_venda_pagamento_data_modificacao')),
                ('pagamento_externo', models.BooleanField(default=False, db_column=b'pedido_venda_pagamento_pagamento_externo')),
                ('banco', models.ForeignKey(related_name='banco', db_column=b'banco_id', default=None, to='configuracao.Banco', null=True)),
                ('conta', models.ForeignKey(related_name='pedido_venda_pagamentos', to='plataforma.Conta')),
                ('contrato', models.ForeignKey(related_name='pedido_venda_pagamentos', to='plataforma.Contrato')),
                ('pagamento', models.ForeignKey(related_name='pedidos_pagamento', to='configuracao.FormaPagamento')),
                ('pagamento_banco', models.ForeignKey(related_name='pedidos_banco', db_column=b'pagamento_banco_id', default=None, to='configuracao.PagamentoBanco', null=True)),
                ('pedido', models.ForeignKey(related_name='pedido_pagamentos', db_column=b'pedido_venda_id', to='pedido.PedidoVenda')),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'pedido"."tb_pedido_venda_pagamento',
                'verbose_name': 'Forma de pagamento de um pedido de venda',
                'verbose_name_plural': 'Formas de pagamentos dos pedidos de vendas',
            },
        ),
        migrations.CreateModel(
            name='PedidoVendaItem',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_item_id')),
                ('linha', models.IntegerField(db_column=b'pedido_venda_item_linha')),
                ('quantidade', models.DecimalField(decimal_places=3, max_digits=16, db_column=b'pedido_venda_item_quantidade')),
                ('preco_cheio', models.DecimalField(decimal_places=4, max_digits=16, db_column=b'pedido_venda_item_preco_cheio')),
                ('preco_custo', models.DecimalField(null=True, decimal_places=4, max_digits=16, db_column=b'pedido_venda_item_preco_custo')),
                ('preco_promocional', models.DecimalField(null=True, decimal_places=4, max_digits=16, db_column=b'pedido_venda_item_preco_promocional')),
                ('preco_venda', models.DecimalField(decimal_places=4, max_digits=16, db_column=b'pedido_venda_item_preco_venda')),
                ('preco_subtotal', models.DecimalField(decimal_places=4, max_digits=16, db_column=b'pedido_venda_item_preco_subtotal')),
                ('tipo', models.CharField(max_length=255, null=True, db_column=b'pedido_venda_item_produto_tipo')),
                ('sku', models.CharField(max_length=255, db_column=b'pedido_venda_item_sku')),
                ('nome', models.CharField(max_length=255, db_column=b'pedido_venda_item_nome')),
                ('_variacao', models.TextField(null=True, db_column=b'pedido_venda_item_variacao')),
                ('peso', models.DecimalField(default=None, null=True, decimal_places=3, max_digits=16, db_column=b'pedido_venda_item_peso')),
                ('altura', models.IntegerField(default=None, null=True, db_column=b'pedido_venda_item_altura')),
                ('largura', models.IntegerField(default=None, null=True, db_column=b'pedido_venda_item_largura')),
                ('profundidade', models.IntegerField(default=None, null=True, db_column=b'pedido_venda_item_comprimento')),
                ('disponibilidade', models.IntegerField(null=True, db_column=b'pedido_venda_item_disponibilidade')),
                ('conta', models.ForeignKey(related_name='pedido_venda_itens', to='plataforma.Conta')),
                ('contrato', models.ForeignKey(related_name='pedido_venda_itens', to='plataforma.Contrato')),
                ('pedido', models.ForeignKey(related_name='itens', db_column=b'pedido_venda_id', to='pedido.PedidoVenda')),
                ('pedido_forma_envio', models.ForeignKey(related_name='pedido_venda_itens', db_column=b'pedido_venda_envio_id', to='pedido.PedidoVendaFormaEnvio', null=True)),
                ('produto', models.ForeignKey(related_name='pedido_venda_itens', on_delete=django.db.models.deletion.PROTECT, to='catalogo.Produto')),
                ('produto_pai', models.ForeignKey(related_name='filhos_pedido_venda_itens', on_delete=django.db.models.deletion.PROTECT, db_column=b'produto_id_pai', to='catalogo.Produto', null=True)),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'pedido"."tb_pedido_venda_item',
                'verbose_name': 'Itens de um pedido de venda',
                'verbose_name_plural': 'Itens dos pedidos de vendas',
            },
        ),
        migrations.CreateModel(
            name='PedidoVendaItemReserva',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_item_reserva_id')),
                ('quantidade', models.IntegerField(db_column=b'pedido_venda_item_reserva_quantidade')),
                ('conta', models.ForeignKey(related_name='pedido_venda_itens_reservas', db_column=b'conta_id', to='plataforma.Conta')),
                ('contrato', models.ForeignKey(related_name='pedido_venda_itens_reservas', db_column=b'contrato_id', to='plataforma.Contrato')),
                ('pedido', models.ForeignKey(related_name='reservas', db_column=b'pedido_venda_id', to='pedido.PedidoVenda')),
                ('pedido_item', models.ForeignKey(related_name='reservas', db_column=b'pedido_venda_item_id', to='pedido.PedidoVendaItem')),
                ('produto', models.ForeignKey(related_name='reservas', db_column=b'produto_id', on_delete=django.db.models.deletion.PROTECT, to='catalogo.Produto')),
                ('produto_pai', models.ForeignKey(related_name='filhos_reservas', on_delete=django.db.models.deletion.PROTECT, db_column=b'produto_id_pai', to='catalogo.Produto', null=True)),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'pedido"."tb_pedido_venda_item_reserva',
                'verbose_name': 'Item reservado para o pedido',
                'verbose_name_plural': 'Itens reservados para o pedido',
            },
        ),
        migrations.CreateModel(
            name='PedidoVendaSituacao',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_situacao_id')),
                ('nome', models.CharField(max_length=64, db_column=b'pedido_venda_situacao_nome')),
                ('codigo', models.CharField(max_length=64, db_column=b'pedido_venda_situacao_codigo')),
                ('aprovado', models.BooleanField(default=False, db_column=b'pedido_venda_situacao_aprovado')),
                ('cancelado', models.BooleanField(default=False, db_column=b'pedido_venda_situacao_cancelado')),
                ('final', models.BooleanField(default=False, db_column=b'pedido_venda_situacao_final')),
                ('padrao', models.BooleanField(default=False, db_column=b'pedido_venda_situacao_padrao')),
                ('notificar_comprador', models.BooleanField(default=False, db_column=b'pedido_venda_situacao_notificar_comprador')),
                ('ativo', models.BooleanField(default=False, db_column=b'pedido_venda_situacao_ativo')),
                ('data_criacao', models.DateTimeField(auto_now_add=True, db_column=b'pedido_venda_situacao_data_criacao')),
                ('data_modificacao', models.DateTimeField(auto_now=True, null=True, db_column=b'pedido_venda_situacao_data_modificacao')),
                ('conta', models.ForeignKey(related_name='pedido_venda_situacoes', default=None, to='plataforma.Conta', null=True)),
                ('contrato', models.ForeignKey(related_name='pedido_venda_situacoes', default=None, to='plataforma.Contrato', null=True)),
            ],
            options={
                'ordering': ['nome'],
                'db_table': 'pedido"."tb_pedido_venda_situacao',
                'verbose_name': 'Situa\xe7\xe3o do pedido de venda',
                'verbose_name_plural': 'Situa\xe7\xf5es de pedidos de vendas',
            },
        ),
        migrations.CreateModel(
            name='PedidoVendaSituacaoHistorico',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_situacao_historico_id')),
                ('data', models.DateTimeField(auto_now=True, db_column=b'pedido_venda_situacao_historico_data')),
                ('alterado_por', models.CharField(max_length=64, null=True, db_column=b'pedido_venda_situacao_historico_alterado_por', choices=[(b'cliente', 'Cliente'), (b'gateway', 'Gateway'), (b'usuario', 'Usu\xe1rio'), (b'sistema', 'Sistema')])),
                ('alterado_por_nome', models.CharField(max_length=128, null=True, db_column=b'pedido_venda_situacao_historico_alterado_por_nome')),
                ('obs', models.TextField(default=None, null=True, db_column=b'pedido_venda_situacao_historico_obs')),
                ('conta', models.ForeignKey(related_name='pedido_venda_situacao_historico', to='plataforma.Conta')),
                ('contrato', models.ForeignKey(related_name='pedido_venda_situacao_historico', to='plataforma.Contrato')),
                ('pedido', models.ForeignKey(related_name='historico', db_column=b'pedido_venda_id', to='pedido.PedidoVenda')),
                ('situacao_final', models.ForeignKey(related_name='pedido_venda_situacao_final_historico', db_column=b'pedido_venda_situacao_id_final', to='pedido.PedidoVendaSituacao')),
                ('situacao_inicial', models.ForeignKey(related_name='pedido_venda_situacao_inicial_historico', db_column=b'pedido_venda_situacao_id_inicial', to='pedido.PedidoVendaSituacao')),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'pedido"."tb_pedido_venda_situacao_historico',
                'verbose_name': 'Hist\xf3rico de situa\xe7\xf5es de um pedido de venda',
                'verbose_name_plural': 'Hist\xf3rico de situa\xe7\xf5es dos pedidos de vendas',
            },
        ),
        migrations.CreateModel(
            name='PedidoVendaTipo',
            fields=[
                ('id', repositories.custom_models.BigAutoField(serialize=False, primary_key=True, db_column=b'pedido_venda_tipo_id')),
                ('nome', models.CharField(max_length=64, db_column=b'pedido_venda_tipo_nome')),
            ],
            options={
                'ordering': ['nome'],
                'db_table': 'pedido"."tb_pedido_venda_tipo',
                'verbose_name': 'Tipo de pedido de venda',
                'verbose_name_plural': 'Tipos de pedidos de vendas',
            },
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='_endereco_entrega',
            field=models.OneToOneField(related_name='+', db_column=b'pedido_venda_endereco_entrega_id', to='pedido.PedidoVendaEndereco'),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='_endereco_pagamento',
            field=models.OneToOneField(related_name='+', db_column=b'pedido_venda_endereco_pagamento_id', to='pedido.PedidoVendaEndereco'),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='cliente',
            field=models.ForeignKey(related_name='pedidos', to='cliente.Cliente'),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='conta',
            field=models.ForeignKey(related_name='pedidos_vendas', to='plataforma.Conta'),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='contrato',
            field=models.ForeignKey(related_name='pedidos_vendas', to='plataforma.Contrato'),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='cupom',
            field=models.ForeignKey(related_name='pedidos', db_column=b'cupom_desconto_id', to='marketing.CupomDesconto', null=True),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='envios',
            field=models.ManyToManyField(related_name='pedidos', through='pedido.PedidoVendaFormaEnvio', to='configuracao.Envio'),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='pagamentos',
            field=models.ManyToManyField(related_name='pedidos', through='pedido.PedidoVendaFormaPagamento', to='configuracao.FormaPagamento'),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='situacao',
            field=models.ForeignKey(related_name='pedidos', db_column=b'pedido_venda_situacao_id', to='pedido.PedidoVendaSituacao'),
        ),
        migrations.AddField(
            model_name='pedidovenda',
            name='tipo',
            field=models.ForeignKey(related_name='pedidos', db_column=b'pedido_venda_tipo_id', to='pedido.PedidoVendaTipo'),
        ),
        migrations.AlterUniqueTogether(
            name='pedidovendasituacao',
            unique_together=set([('conta', 'nome')]),
        ),
        migrations.AlterUniqueTogether(
            name='pedidovendaformapagamento',
            unique_together=set([('transacao_id', 'identificador_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='pedidovenda',
            unique_together=set([('conta', 'numero')]),
        ),
        migrations.AlterUniqueTogether(
            name='carrinhoproduto',
            unique_together=set([('produto', 'carrinho', 'conta')]),
        ),
        migrations.AlterUniqueTogether(
            name='carrinho',
            unique_together=set([('token', 'conta', 'contrato')]),
        ),
    ]
