"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2023 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia common message definitions for gRPC API.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Audio(google.protobuf.message.Message):
    """ Contains audio data in the supported format and encoding.
     Supported formats are <code>WAV</code> (various encoding), <code>FLAC</code>
     and <code>OGG_OPUS</code>. For best results, the audio source should be
     captured and transmitted using a lossless encoding (<code>FLAC</code> or
     <code>LINEAR16</code>). The accuracy of the speech technologies can be
     reduced if lossy codecs are used to capture or transmit audio, particularly
     if background noise is present. Lossy codecs include <code>ALAW</code>,
    <code>MULAW</code> or <code>OGG_OPUS</code>.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    TIME_RANGE_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """The audio data bytes encoded in the supported format, including the header.
    <em>Note: as with all bytes fields, proto buffers use a pure binary
    representation.</em>
    """
    @property
    def time_range(self) -> global___TimeRange:
        """Time range of the audio to process. If omitted, the
        whole audio is processed. If <code>start</code> is omitted, the
        audio is process from the beginning. If <code>end</code> is omitted,
        the audio is processed to the end.
        """
    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
        time_range: global___TimeRange | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["time_range", b"time_range"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "time_range", b"time_range"]) -> None: ...

global___Audio = Audio

@typing_extensions.final
class Voiceprint(google.protobuf.message.Message):
    """Represents the result from voiceprint extraction."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """Voiceprint data bytes encoded in UBJSON format."""
    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content"]) -> None: ...

global___Voiceprint = Voiceprint

@typing_extensions.final
class Matrix(google.protobuf.message.Message):
    """Data type representing matrix of values. The matrix is represented as a
    linear array in row major format.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROWS_COUNT_FIELD_NUMBER: builtins.int
    COLUMNS_COUNT_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    rows_count: builtins.int
    """Number of rows in the matrix."""
    columns_count: builtins.int
    """Number of columns in the matrix."""
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Sequential list of matrix values in row major format."""
    def __init__(
        self,
        *,
        rows_count: builtins.int = ...,
        columns_count: builtins.int = ...,
        values: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["columns_count", b"columns_count", "rows_count", b"rows_count", "values", b"values"]) -> None: ...

global___Matrix = Matrix

@typing_extensions.final
class TimeRange(google.protobuf.message.Message):
    """Data type representing time range."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> google.protobuf.duration_pb2.Duration:
        """Start time of the time range."""
    @property
    def end(self) -> google.protobuf.duration_pb2.Duration:
        """End time of the time range."""
    def __init__(
        self,
        *,
        start: google.protobuf.duration_pb2.Duration | None = ...,
        end: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end", b"end", "start", b"start"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end", b"end", "start", b"start"]) -> None: ...

global___TimeRange = TimeRange
