"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2024 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Speech To Text Whisper Enhanced gRPC API.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class TranscribeRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Transcribe</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio data from which a transcription should be extracted.
        A variety of common audio formats are supported, including WAV, MP3, FLAC,
        and others.
        """
    @property
    def config(self) -> global___TranscribeConfig:
        """Speech to text transcription configuration."""
    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___TranscribeConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio", b"audio", "config", b"config"]) -> None: ...

global___TranscribeRequest = TranscribeRequest

@typing_extensions.final
class TranscribeConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGE_FIELD_NUMBER: builtins.int
    ENABLE_LANGUAGE_SWITCHING_FIELD_NUMBER: builtins.int
    language: builtins.str
    """The language of the audio data specified as an ISO-639-1 language tag.
    If not set, the language will be detected automatically.
    """
    enable_language_switching: builtins.bool
    """By default, the language of the speech is detected once at the beginning of
    the recording. Enabling this option allows for dynamic language switching
    in the recording, with the language being detected approximately every 30
    seconds.

    Note: This option is ignored if the language is enforced by setting the
    <code>language</code> option.
    """
    def __init__(
        self,
        *,
        language: builtins.str = ...,
        enable_language_switching: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enable_language_switching", b"enable_language_switching", "language", b"language"]) -> None: ...

global___TranscribeConfig = TranscribeConfig

@typing_extensions.final
class TranscribeResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Transcribe</code>
    method. It contains segments with transcription results.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___TranscribeResult:
        """The Speech to Text transcription result."""
    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total length of the processed audio.
        Set only if this is the last response in the stream.
        """
    def __init__(
        self,
        *,
        result: global___TranscribeResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...

global___TranscribeResponse = TranscribeResponse

@typing_extensions.final
class ListSupportedLanguagesRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the
    <code>ListSupportedLanguages</code> method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListSupportedLanguagesRequest = ListSupportedLanguagesRequest

@typing_extensions.final
class ListSupportedLanguagesResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the
    <code>ListSupportedLanguages</code>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LANGUAGES_FIELD_NUMBER: builtins.int
    @property
    def languages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of supported languages.
        The language is specified as an ISO-639-1 language tag.
        """
    def __init__(
        self,
        *,
        languages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["languages", b"languages"]) -> None: ...

global___ListSupportedLanguagesResponse = ListSupportedLanguagesResponse

@typing_extensions.final
class TranscribeResult(google.protobuf.message.Message):
    """The collection of all transcription result formats."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ONE_BEST_FIELD_NUMBER: builtins.int
    @property
    def one_best(self) -> global___OneBest:
        """Result in one-best format."""
    def __init__(
        self,
        *,
        one_best: global___OneBest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["one_best", b"one_best"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["one_best", b"one_best"]) -> None: ...

global___TranscribeResult = TranscribeResult

@typing_extensions.final
class OneBest(google.protobuf.message.Message):
    """The one-best output from Speech To Text."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEGMENTS_FIELD_NUMBER: builtins.int
    @property
    def segments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OneBestSegment]:
        """Sequential list of transcription segments corresponding to sequential
        portions of audio.
        """
    def __init__(
        self,
        *,
        segments: collections.abc.Iterable[global___OneBestSegment] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["segments", b"segments"]) -> None: ...

global___OneBest = OneBest

@typing_extensions.final
class OneBestSegment(google.protobuf.message.Message):
    """Segment of the one-best output."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Text content of the segment."""
    @property
    def start_time(self) -> google.protobuf.duration_pb2.Duration:
        """Start time of the segment."""
    @property
    def end_time(self) -> google.protobuf.duration_pb2.Duration:
        """End time of the segment."""
    language: builtins.str
    """Detected language of the segment.
    The language is specified as an ISO-639-1 language tag.

    Note: If a specific language was enforced in the request, the detected
    language is the same as the specified language.
    """
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        start_time: google.protobuf.duration_pb2.Duration | None = ...,
        end_time: google.protobuf.duration_pb2.Duration | None = ...,
        language: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end_time", b"end_time", "language", b"language", "start_time", b"start_time", "text", b"text"]) -> None: ...

global___OneBestSegment = OneBestSegment
