"""
Binance Crypto Loan REST API

OpenAPI Specification for the Binance Crypto Loan REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import CheckCollateralRepayRateStableRateResponse
from ..models import GetCryptoLoansIncomeHistoryResponse
from ..models import GetLoanBorrowHistoryResponse
from ..models import GetLoanLtvAdjustmentHistoryResponse
from ..models import GetLoanRepaymentHistoryResponse


class StableRateApi:
    """API Client for StableRateApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def check_collateral_repay_rate_stable_rate(
        self,
        loan_coin: Union[str, None],
        collateral_coin: Union[str, None],
        repay_amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CheckCollateralRepayRateStableRateResponse]:
        """
                Check Collateral Repay Rate(USER_DATA)
                GET /sapi/v1/loan/repay/collateral/rate
                https://developers.binance.com/docs/crypto_loan/stable-rate/market-data/Check-Collateral-Repay-Rate

                Get the the rate of collateral coin / loan coin when using collateral repay, the rate will be valid within 8 second.

        Weight: 6000

                Args:
                    loan_coin (Union[str, None]):
                    collateral_coin (Union[str, None]):
                    repay_amount (Union[float, None]): repay amount of loanCoin
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CheckCollateralRepayRateStableRateResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if loan_coin is None:
            raise RequiredError(
                field="loan_coin",
                error_message="Missing required parameter 'loan_coin'",
            )
        if collateral_coin is None:
            raise RequiredError(
                field="collateral_coin",
                error_message="Missing required parameter 'collateral_coin'",
            )
        if repay_amount is None:
            raise RequiredError(
                field="repay_amount",
                error_message="Missing required parameter 'repay_amount'",
            )

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "repay_amount": repay_amount,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/loan/repay/collateral/rate",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CheckCollateralRepayRateStableRateResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_crypto_loans_income_history(
        self,
        asset: Optional[str] = None,
        type: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetCryptoLoansIncomeHistoryResponse]:
        """
                Get Crypto Loans Income History(USER_DATA)
                GET /sapi/v1/loan/income
                https://developers.binance.com/docs/crypto_loan/stable-rate/market-data/Get-Crypto-Loans-Income-History

                Get Crypto Loans Income History

        * If startTime and endTime are not sent, the recent 7-day data will be returned.
        * The max interval between startTime and endTime is 30 days.

        Weight: 6000

                Args:
                    asset (Optional[str] = None):
                    type (Optional[str] = None): All types will be returned by default. Enum：`borrowIn` ,`collateralSpent`, `repayAmount`, `collateralReturn`(Collateral return after repayment), `addCollateral`, `removeCollateral`, `collateralReturnAfterLiquidation`
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default: 10; max: 100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetCryptoLoansIncomeHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "asset": asset,
            "type": type,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/loan/income",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetCryptoLoansIncomeHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_loan_borrow_history(
        self,
        order_id: Optional[int] = None,
        loan_coin: Optional[str] = None,
        collateral_coin: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLoanBorrowHistoryResponse]:
        """
                Get Loan Borrow History(USER_DATA)
                GET /sapi/v1/loan/borrow/history
                https://developers.binance.com/docs/crypto_loan/stable-rate/user-information/Get-Loan-Borrow-History

                Get Loan Borrow History

        * If startTime and endTime are not sent, the recent 90-day data will be returned.
        * The max interval between startTime and endTime is 180 days.

        Weight: 400

                Args:
                    order_id (Optional[int] = None): orderId in `POST /sapi/v1/loan/borrow`
                    loan_coin (Optional[str] = None):
                    collateral_coin (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Current querying page. Start from 1; default: 1; max: 1000
                    limit (Optional[int] = None): Default: 10; max: 100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLoanBorrowHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "order_id": order_id,
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/loan/borrow/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLoanBorrowHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_loan_ltv_adjustment_history(
        self,
        order_id: Optional[int] = None,
        loan_coin: Optional[str] = None,
        collateral_coin: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLoanLtvAdjustmentHistoryResponse]:
        """
                Get Loan LTV Adjustment History(USER_DATA)
                GET /sapi/v1/loan/ltv/adjustment/history
                https://developers.binance.com/docs/crypto_loan/stable-rate/user-information/Get-Loan-LTV-Adjustment-History

                Get Loan LTV Adjustment History

        * If startTime and endTime are not sent, the recent 90-day data will be returned.
        * The max interval between startTime and endTime is 180 days.

        Weight: 400

                Args:
                    order_id (Optional[int] = None): orderId in `POST /sapi/v1/loan/borrow`
                    loan_coin (Optional[str] = None):
                    collateral_coin (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Current querying page. Start from 1; default: 1; max: 1000
                    limit (Optional[int] = None): Default: 10; max: 100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLoanLtvAdjustmentHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "order_id": order_id,
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/loan/ltv/adjustment/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLoanLtvAdjustmentHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_loan_repayment_history(
        self,
        order_id: Optional[int] = None,
        loan_coin: Optional[str] = None,
        collateral_coin: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetLoanRepaymentHistoryResponse]:
        """
                Get Loan Repayment History(USER_DATA)
                GET /sapi/v1/loan/repay/history
                https://developers.binance.com/docs/crypto_loan/stable-rate/user-information/Get-Loan-Repayment-History

                Get Loan Repayment History

        * If startTime and endTime are not sent, the recent 90-day data will be returned.
        * The max interval between startTime and endTime is 180 days.

        Weight: 400

                Args:
                    order_id (Optional[int] = None): orderId in `POST /sapi/v1/loan/borrow`
                    loan_coin (Optional[str] = None):
                    collateral_coin (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    current (Optional[int] = None): Current querying page. Start from 1; default: 1; max: 1000
                    limit (Optional[int] = None): Default: 10; max: 100
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetLoanRepaymentHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "order_id": order_id,
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/loan/repay/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetLoanRepaymentHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )
