"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const physical_name_generator_1 = require("./private/physical-name-generator");
const token_1 = require("./token");
/**
 * Includes special markers for automatic generation of physical names.
 */
class PhysicalName {
    constructor() {
    }
}
exports.PhysicalName = PhysicalName;
/**
 * Use this to automatically generate a physical name for an AWS resource only
 * if the resource is referenced across environments (account/region).
 * Otherwise, the name will be allocated during deployment by CloudFormation.
 *
 * If you are certain that a resource will be referenced across environments,
 * you may also specify an explicit physical name for it. This option is
 * mostly designed for reusable constructs which may or may not be referenced
 * acrossed environments.
 */
PhysicalName.GENERATE_IF_NEEDED = token_1.Token.asString(new physical_name_generator_1.GeneratedWhenNeededMarker());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGh5c2ljYWwtbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBoeXNpY2FsLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSwrRUFBOEU7QUFDOUUsbUNBQWdDO0FBRWhDOztHQUVHO0FBQ0gsTUFBYSxZQUFZO0lBYXZCO0lBQXdCLENBQUM7O0FBYjNCLG9DQWNDO0FBYkM7Ozs7Ozs7OztHQVNHO0FBQ29CLCtCQUFrQixHQUFHLGFBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxtREFBeUIsRUFBRSxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBHZW5lcmF0ZWRXaGVuTmVlZGVkTWFya2VyIH0gZnJvbSAnLi9wcml2YXRlL3BoeXNpY2FsLW5hbWUtZ2VuZXJhdG9yJztcbmltcG9ydCB7IFRva2VuIH0gZnJvbSAnLi90b2tlbic7XG5cbi8qKlxuICogSW5jbHVkZXMgc3BlY2lhbCBtYXJrZXJzIGZvciBhdXRvbWF0aWMgZ2VuZXJhdGlvbiBvZiBwaHlzaWNhbCBuYW1lcy5cbiAqL1xuZXhwb3J0IGNsYXNzIFBoeXNpY2FsTmFtZSB7XG4gIC8qKlxuICAgKiBVc2UgdGhpcyB0byBhdXRvbWF0aWNhbGx5IGdlbmVyYXRlIGEgcGh5c2ljYWwgbmFtZSBmb3IgYW4gQVdTIHJlc291cmNlIG9ubHlcbiAgICogaWYgdGhlIHJlc291cmNlIGlzIHJlZmVyZW5jZWQgYWNyb3NzIGVudmlyb25tZW50cyAoYWNjb3VudC9yZWdpb24pLlxuICAgKiBPdGhlcndpc2UsIHRoZSBuYW1lIHdpbGwgYmUgYWxsb2NhdGVkIGR1cmluZyBkZXBsb3ltZW50IGJ5IENsb3VkRm9ybWF0aW9uLlxuICAgKlxuICAgKiBJZiB5b3UgYXJlIGNlcnRhaW4gdGhhdCBhIHJlc291cmNlIHdpbGwgYmUgcmVmZXJlbmNlZCBhY3Jvc3MgZW52aXJvbm1lbnRzLFxuICAgKiB5b3UgbWF5IGFsc28gc3BlY2lmeSBhbiBleHBsaWNpdCBwaHlzaWNhbCBuYW1lIGZvciBpdC4gVGhpcyBvcHRpb24gaXNcbiAgICogbW9zdGx5IGRlc2lnbmVkIGZvciByZXVzYWJsZSBjb25zdHJ1Y3RzIHdoaWNoIG1heSBvciBtYXkgbm90IGJlIHJlZmVyZW5jZWRcbiAgICogYWNyb3NzZWQgZW52aXJvbm1lbnRzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBHRU5FUkFURV9JRl9ORUVERUQgPSBUb2tlbi5hc1N0cmluZyhuZXcgR2VuZXJhdGVkV2hlbk5lZWRlZE1hcmtlcigpKTtcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKCkgeyB9XG59XG4iXX0=