import math
import numpy as np
# from scipy import interpolate

# Στοιχεία φατνώματος
l = 4.0           # [m] Το άνοιγμα του πλαισίου
h = 3.0           # [m] Το ύψος τους ορόφου



# Στοιχεία τοιχοποιίας
k = 0.4         # εμπειρικός συντελεστής που λαμβάνει υπόψη την ομάδα στην οποία κατατάσσονται τα
                # τοιχωσώματα και το είδος του κονιάματος δόμησης, παίρνει δε τιμές από 0,35 έως 0,55.
fbc = 4.0       # [MPa] η θλιπτική αντοχή του τοιχοσώματος (ενδεικτικές τιμές για υφιστάμενες τοιχοποιίες 3.1 -5.5 MPa)
fmc = 1.6       # [MPa] η θλιπτική αντοχή του κονιάματος (ενδεικτικές τιμές για υφιστάμενες τοιχοποιίες 1.5 -1.8  MPa)

t = 0.20        # Το πάχος t της θλιβόμενης διαγωνίου ή το πάχος του τοίχου;

# Συντελεστές
λΕ = 500.0     # Ο συντελεστής που θα μπεί στη σχέση Ew = λΕ * fcws. Παίρνει τιμές 500 - 1000
λγy = 1.25      # Ο συντελεστής που θα μπεί στη σχέση γy = (l/h+h/l)*(1-1.5)*10^-3. Τιμές από 1 - 1.5. Για το γu με παρεμβολή

# Γεωμετρικά στοιχεία
α = np.arctan(h/l)  # Η γωνία με την οριζόντιο
L = l / np.cos(α)   # Το καθαρό μήκος της διαγωνίου
λ = L / t           # Η λυγηρότητα της τοιχοπλήρωσης

print('l = {0:.2f}m'.format(l))
print('h = {0:.2f}m'.format(h))

print('α = {0:.3f}rad'.format(α))
print('L = {0:.2f}m'.format(L))
print('λ = {0:.2f}'.format(λ))


# Αντοχή της τοιχοπλήρωσης
fcws = 1.25 * k * math.pow(fbc, 0.7) * math.pow(fmc, 0.3)
Ew = λΕ * fcws    # 500 - 1000

if λ < 15:
    φ = 1.0
elif λ>30:
    φ =  0.0
else:
    φ500 = 0.9 * 1 / math.exp(math.pow((0.0447 * λ - 0.063), 2) / 0.9)
    φ1000 = 0.9 * 1 / math.exp(math.pow((0.0316 * λ - 0.063), 2) / 0.9)
    x_φ = [500, 1000]
    y_φ = [φ500, φ1000]
    φ = np.interp(λΕ, x_φ, y_φ)

print('fcws = {0:.3f}MPa'.format(fcws))
print('Ew = {0:.1f}MPa'.format(Ew))
#print('φ500 = {0:.3f}'.format(φ500))
#print('φ1000 = {0:.3f}'.format(φ1000))
print('φ = {0:.3f}'.format(φ))


# Διάγραμμα τ - γ
γy = (l / h + h / l) * λγy * 0.001
λγu = np.interp(λγy, [1.0, 1.5], [2.0, 3.5])
γu = (l / h + h / l) * λγu * 0.001

print('γy = {0:.5f}'.format(γy))
print('γu = {0:.5f}'.format(γu))




b = 0.15 * L






N = 1000.0 * t * b * fcws     # *1000 για να γίνει kNs
V = N * math.cos(α)














print('b = {0:.2f}m'.format(b))




print('N = {0:.3f}kN'.format(N))
print('V = {0:.3f}kN'.format(V))







