import math


def VRcalc(h, x, Ls, N, Ac, fc, μθpl, ρtot, αs, Vw):
    """ Διατµητική αντοχή δοµικού στοιχείου, όπως αυτή καθορίζεται από τη διαρροή των συνδετήρων.
    Μειώνεται συναρτήσει του μθ,pl
    Η σχέση θέλει MN και m. Αποτέλεσμα σε MN

    Args:
        h (float): ύψος διατοµής [m]
        x (float): ύψος της θλιβόµενης ζώνης [m]
        Ls (float): [m]
        N (float): Αξονικό φορτίο (θετικό για θλίψη, µηδενικό για εφελκυσµό) [ΜΝ]
        Ac (float):
        fc (float):
        μθpl (float):
        ρtot (float):
        αs (float):
        Vw (float):

    Returns:
        float: a

    """
    if N < 0:
        N = 0
    part1 = ((h - x) / (2 * Ls)) * min(N, 0.55 * Ac * fc)
    part2 = 1 - 0.05 * min(5.0, μθpl)
    part3 = 0.16 * max(0.5, 100*ρtot) * (1 - 0.16 * min(5.0, αs)) * math.pow(fc, 0.5) * Ac + Vw
    return part1 + part2 * part3


# Τέμνουσα που παραλαμβάνουν οι συνδετήρες
def Vw(ρw, bw, z, fyw):

    """ Συµβολή εγκάρσιου οπλισµού στη διατµητική αντοχή

    Args:
        ρw (float): το ποσοστό του εγκάρσιου οπλισµού.
        bw (float): το πλάτος της διατομής [m]
        z (float): ο µοχλοβραχίονας εσωτερικών δυνάµεων (ίσος µε d-d’ σε υποστυλώµατα, δοκούς
                    και τοιχώµατα διατοµής Τ ή Η, ή µε 0.8h σε τοιχώµατα ορθογωνικής διατοµής) [m]
        fyw (float): η τάση διαρροής του εγκάρσιου οπλισµού [MPa]

    Returns:
        float: a

    """
    return ρw * bw * z * fyw
