/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.metric;

import io.ray.runtime.metric.Count;
import io.ray.runtime.metric.Gauge;
import io.ray.runtime.metric.Histogram;
import io.ray.runtime.metric.Metric;
import io.ray.runtime.metric.MetricConfig;
import io.ray.runtime.metric.MetricRegistry;
import io.ray.runtime.metric.Sum;
import io.ray.runtime.metric.TagKey;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Metrics {
    private static MetricRegistry metricRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricRegistry init(MetricConfig metricConfig) {
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            metricRegistry = new MetricRegistry();
            metricRegistry.startup(metricConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return metricRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            if (metricRegistry != null) {
                metricRegistry.shutdown();
                metricRegistry = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static CountBuilder count() {
        return new CountBuilder();
    }

    public static GaugeBuilder gauge() {
        return new GaugeBuilder();
    }

    public static SumBuilder sum() {
        return new SumBuilder();
    }

    public static HistogramBuilder histogram() {
        return new HistogramBuilder();
    }

    private static Map<TagKey, String> generateTagKeysMap(Map<String, String> tags) {
        HashMap<TagKey, String> tagKeys = new HashMap<TagKey, String>(tags.size() * 2);
        tags.forEach((key, value) -> {
            TagKey tagKey = new TagKey((String)key);
            tagKeys.put(tagKey, (String)value);
        });
        return tagKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetricRegistry maybeInitRegistry() {
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            if (metricRegistry != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return metricRegistry;
            }
            metricRegistry = MetricRegistry.DEFAULT_REGISTRY;
            metricRegistry.startup();
            // ** MonitorExit[var0] (shouldn't be in output)
            return metricRegistry;
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder, M extends Metric> {
        protected String name;
        protected String description;
        protected String unit;
        protected Map<String, String> tags;

        public B name(String name) {
            this.name = Preconditions.checkNotNull(name);
            return (B)this;
        }

        public B description(String description) {
            this.description = Preconditions.checkNotNull(description);
            return (B)this;
        }

        public B unit(String unit) {
            this.unit = Preconditions.checkNotNull(unit);
            return (B)this;
        }

        public B tags(Map<String, String> tags) {
            this.tags = Preconditions.checkNotNull(tags);
            return (B)this;
        }

        protected abstract M create();

        public M register() {
            M m = this.create();
            Metrics.maybeInitRegistry();
            return (M)metricRegistry.register((Metric)m);
        }
    }

    public static class HistogramBuilder
    extends AbstractBuilder<HistogramBuilder, Histogram> {
        private List<Double> boundaries;

        public HistogramBuilder boundaries(List<Double> boundaries) {
            this.boundaries = boundaries;
            return this;
        }

        @Override
        protected Histogram create() {
            return new Histogram(this.name, this.description, this.unit, this.boundaries, Metrics.generateTagKeysMap(this.tags));
        }
    }

    public static class SumBuilder
    extends AbstractBuilder<SumBuilder, Sum> {
        @Override
        protected Sum create() {
            return new Sum(this.name, this.description, this.unit, Metrics.generateTagKeysMap(this.tags));
        }
    }

    public static class GaugeBuilder
    extends AbstractBuilder<GaugeBuilder, Gauge> {
        @Override
        protected Gauge create() {
            return new Gauge(this.name, this.description, this.unit, Metrics.generateTagKeysMap(this.tags));
        }
    }

    public static class CountBuilder
    extends AbstractBuilder<CountBuilder, Count> {
        @Override
        protected Count create() {
            return new Count(this.name, this.description, this.unit, Metrics.generateTagKeysMap(this.tags));
        }
    }
}

