from symphony.bdk.gen.agent_api.messages_api import MessagesApi
from symphony.bdk.gen.agent_model.v4_message import V4Message
from symphony.bdk.gen.agent_model.v4_message_blast_response import V4MessageBlastResponse
from symphony.bdk.gen.api_client import Endpoint
from symphony.bdk.gen.model_utils import (
    file_type
)


class MultiAttachmentsMessagesApi(MessagesApi):
    """Message Api inherited the MessagesApi generated by OpenAPI Generator
    which allows to send or blast a message with multiple attachments and previews
    """

    def __init__(self, api_client=None):
        super().__init__(api_client)

        def __v4_message_create_post(self, **kwargs):
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.v4_stream_sid_multi_attachment_message_create_post = Endpoint(
            settings={
                'response_type': (V4Message,),
                'auth': [],
                'endpoint_path': '/v4/stream/{sid}/message/create',
                'operation_id': 'v4_stream_sid_message_create_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'session_token',
                    'key_manager_token',
                    'message',
                    'data',
                    'version',
                    'attachment',
                    'preview',
                ],
                'required': [
                    'sid',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'message':
                        (str,),
                    'data':
                        (str,),
                    'version':
                        (str,),
                    'attachment':
                        ([file_type],),
                    'preview':
                        ([file_type],),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'message': 'message',
                    'data': 'data',
                    'version': 'version',
                    'attachment': 'attachment',
                    'preview': 'preview',
                },
                'location_map': {
                    'sid': 'path',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'message': 'form',
                    'data': 'form',
                    'version': 'form',
                    'attachment': 'form',
                    'preview': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__v4_message_create_post
        )

        self.v4_multi_attachment_message_blast_post = Endpoint(
            settings={
                'response_type': (V4MessageBlastResponse,),
                'auth': [],
                'endpoint_path': '/v4/message/blast',
                'operation_id': 'v4_message_blast_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'sids',
                    'key_manager_token',
                    'message',
                    'data',
                    'version',
                    'attachment',
                    'preview',
                ],
                'required': [
                    'session_token',
                    'sids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'sids':
                        ([str],),
                    'key_manager_token':
                        (str,),
                    'message':
                        (str,),
                    'data':
                        (str,),
                    'version':
                        (str,),
                    'attachment':
                        ([file_type],),
                    'preview':
                        ([file_type],),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'sids': 'sids',
                    'key_manager_token': 'keyManagerToken',
                    'message': 'message',
                    'data': 'data',
                    'version': 'version',
                    'attachment': 'attachment',
                    'preview': 'preview',
                },
                'location_map': {
                    'session_token': 'header',
                    'sids': 'form',
                    'key_manager_token': 'header',
                    'message': 'form',
                    'data': 'form',
                    'version': 'form',
                    'attachment': 'form',
                    'preview': 'form',
                },
                'collection_format_map': {
                    'sids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__v4_message_create_post
        )
