#!/usr/bin/env python3
"""
docstring
"""

CANDLES_DATA = [
    [1537257600000, 0.54261, 0.5378, 0.544, 0.536, 189016.74951287],
    [1537254000000, 0.54094, 0.54207, 0.5442, 0.53898, 260167.98412761],
    [1537250400000, 0.53768, 0.54087, 0.5415, 0.53554, 210281.85152699],
    [1537246800000, 0.5356, 0.53768, 0.54005, 0.53429, 221290.681295],
    [1537243200000, 0.52882, 0.53523, 0.5355, 0.52811, 96537.84008267],
    [1537239600000, 0.52932, 0.52761, 0.53003, 0.52685, 55455.3922136],
    [1537236000000, 0.53667, 0.53, 0.53667, 0.52783, 272302.38584385],
    [1537232400000, 0.5361, 0.53672, 0.53827, 0.53408, 91465.44434114],
    [1537228800000, 0.5328, 0.53647, 0.5431, 0.527, 685228.62972204],
    [1537225200000, 0.52887, 0.53307, 0.53771, 0.5278, 341327.12210684],
    [1537221600000, 0.53384, 0.52786, 0.53573, 0.52762, 433551.66971991],
    [1537218000000, 0.5278, 0.53392, 0.5398, 0.52751, 623865.27367453],
    [1537214400000, 0.5349, 0.5278, 0.5375, 0.52578078, 1687739.4740086],
    [1537210800000, 0.5419, 0.53573, 0.54217128, 0.53075, 615222.31888084],
    [1537207200000, 0.5401, 0.54079, 0.54556, 0.53753263, 544230.05373943],
    [1537203600000, 0.53781, 0.5398, 0.54508, 0.53769411, 347780.55739045],
    [1537200000000, 0.53996, 0.53811, 0.54688, 0.53769411, 664515.91513011],
    [1537196400000, 0.5496, 0.54, 0.5496, 0.53075, 2428252.64947074],
    [1537192800000, 0.56, 0.5504, 0.56, 0.54271, 2935747.87656993],
    [1537189200000, 0.5682, 0.56, 0.57231, 0.557, 941262.41363281],
    [1537185600000, 0.5735, 0.56877, 0.5739, 0.56731, 165236.41375607],
    [1537182000000, 0.57631, 0.5735, 0.57956, 0.57121, 158220.79397329],
    [1537178400000, 0.57568, 0.57631, 0.57999, 0.57355, 222484.18848635],
    [1537174800000, 0.57031, 0.5756, 0.57598, 0.5602, 580361.98689113],
    [1537171200000, 0.5712, 0.57108, 0.57144, 0.56662, 107487.02869795],
    [1537167600000, 0.573, 0.57199, 0.57424, 0.56599, 679950.83899881],
    [1537164000000, 0.5732, 0.57343, 0.57482, 0.57139, 57944.39771713],
    [1537160400000, 0.57148, 0.57299, 0.57616, 0.56859, 239802.25722546],
    [1537156800000, 0.5792, 0.57223, 0.58029, 0.57, 211527.28707936],
    [1537153200000, 0.58376, 0.5792, 0.584, 0.57784, 75784.9628314],
    [1537149600000, 0.5831, 0.58385, 0.58599, 0.5789, 118558.78674539],
    [1537146000000, 0.581, 0.58377, 0.58377, 0.57781, 117321.09186782],
    [1537142400000, 0.57745, 0.58102, 0.589, 0.57703, 574603.95626353],
    [1537138800000, 0.57723, 0.57851, 0.584, 0.57685, 163004.39497388],
    [1537135200000, 0.5779, 0.5773, 0.57834, 0.56973, 409169.76388769],
    [1537131600000, 0.5812, 0.577, 0.5834, 0.57565, 178757.91678251],
    [1537128000000, 0.58135, 0.57987, 0.58444, 0.57778, 213346.74817574],
    [1537124400000, 0.5744, 0.5807, 0.5849, 0.5737, 611413.22403218],
    [1537120800000, 0.572, 0.57361, 0.57773, 0.57199, 129356.99309026],
    [1537117200000, 0.5739, 0.57201, 0.57568, 0.568, 327057.13990962],
    [1537113600000, 0.57476, 0.57414, 0.5765, 0.57226, 180160.17591704],
    [1537110000000, 0.57081, 0.57351, 0.575, 0.56961, 175547.83989137],
    [1537106400000, 0.5697, 0.57109, 0.57109, 0.56614, 164630.69532373],
    [1537102800000, 0.57301, 0.57093, 0.57568, 0.56882, 323064.57165096],
    [1537099200000, 0.57611, 0.572, 0.57928, 0.572, 153057.9877704],
    [1537095600000, 0.577, 0.57604, 0.57886, 0.5725, 263561.7993596],
    [1537092000000, 0.5715, 0.577, 0.57749, 0.56998, 171281.43771094],
    [1537088400000, 0.56712, 0.5715, 0.5745, 0.56622, 128750.05732157],
    [1537084800000, 0.56093, 0.56712, 0.57729, 0.55994, 870369.2972002],
    [1537081200000, 0.56232, 0.5614, 0.56397, 0.55816, 232518.39758705],
    [1537077600000, 0.5623, 0.5626, 0.5643, 0.5588, 237336.36806488],
    [1537074000000, 0.56079, 0.5632, 0.56482, 0.55536, 198605.95698381],
    [1537070400000, 0.5675, 0.56053, 0.56764, 0.55122, 1240980.77755223],
    [1537066800000, 0.57458, 0.56789, 0.57458, 0.56625, 217242.52063169],
    [1537063200000, 0.57042, 0.57491, 0.5768, 0.56541, 409210.17101077],
    [1537059600000, 0.57276, 0.57047, 0.57544, 0.56696, 496560.8547152],
    [1537056000000, 0.56843, 0.5727, 0.57502, 0.567, 268695.45278699],
    [1537052400000, 0.56842, 0.5691, 0.57573, 0.56712, 152344.48193299],
    [1537048800000, 0.56851, 0.5694, 0.574, 0.567, 212587.99215213],
    [1537045200000, 0.57869, 0.56851, 0.57899, 0.56, 826537.76951425],
    [1537041600000, 0.57853, 0.5776, 0.57929, 0.5751, 153954.17348105],
    [1537038000000, 0.5752, 0.5793, 0.57942316, 0.57161, 288493.76421921],
    [1537034400000, 0.58227, 0.5743, 0.58275, 0.56974, 647263.49015046],
    [1537030800000, 0.5856, 0.58227, 0.586, 0.578, 231144.38947021],
    [1537027200000, 0.58198, 0.58651, 0.58699, 0.5793, 388028.44761815],
    [1537023600000, 0.58647, 0.58198, 0.58989, 0.58051, 256177.46471906],
    [1537020000000, 0.58531, 0.58735, 0.59164, 0.584, 321680.18293173],
    [1537016400000, 0.58387, 0.5854, 0.59195, 0.5807, 532400.52903413],
    [1537012800000, 0.57999, 0.58404, 0.58599, 0.57882, 295256.01431044],
    [1537009200000, 0.58295, 0.58, 0.583, 0.57587, 157212.83719254],
    [1537005600000, 0.5836, 0.58295, 0.5882, 0.58111, 203084.19499533],
    [1537002000000, 0.57951, 0.58355, 0.58423, 0.57704, 264830.26769864],
    [1536998400000, 0.578, 0.57893, 0.5851, 0.57604, 374214.37630411],
    [1536994800000, 0.56629, 0.57801, 0.58083094, 0.56581, 696717.57481234],
    [1536991200000, 0.57188, 0.56458, 0.57195, 0.55653, 721570.62694231],
    [1536987600000, 0.57455, 0.56996, 0.57576, 0.56676, 263036.20531009],
    [1536984000000, 0.57, 0.57455, 0.57619, 0.56831, 126228.67751565],
    [1536980400000, 0.5789, 0.57, 0.58124, 0.56511, 597420.01613763],
    [1536976800000, 0.58444, 0.58116, 0.58444, 0.57813, 32072.16928419],
    [1536973200000, 0.57887, 0.58471, 0.58608, 0.5779, 197493.09169735],
    [1536969600000, 0.56932, 0.57887, 0.57928, 0.5671, 106819.04388118],
    [1536966000000, 0.57868, 0.57101, 0.58158, 0.56542, 360961.30936306],
    [1536962400000, 0.58006, 0.57867, 0.58479, 0.578, 344528.57469251],
    [1536958800000, 0.585, 0.58111, 0.588, 0.5793, 84928.02545189],
    [1536955200000, 0.59092, 0.58614, 0.5944, 0.5775, 814667.10530369],
    [1536951600000, 0.57791, 0.59092, 0.59489, 0.5779, 657646.12779279],
    [1536948000000, 0.57429, 0.5776, 0.58061, 0.573, 232581.06611522],
    [1536944400000, 0.58541, 0.57429, 0.588, 0.57429, 710097.9589055],
    [1536940800000, 0.5768, 0.5858, 0.58847, 0.57488, 1365796.45735877],
    [1536937200000, 0.56144, 0.57675, 0.577, 0.56138, 581420.42463394],
    [1536933600000, 0.55841473, 0.56197, 0.56728, 0.55646, 527565.25336474],
    [1536930000000, 0.5731, 0.55841473, 0.57472, 0.55159, 1384012.48833558],
    [1536926400000, 0.57399, 0.5733, 0.57437, 0.57, 123780.69838568],
    [1536922800000, 0.5709, 0.57413051, 0.58, 0.56999, 460760.8193473],
    [1536919200000, 0.57223, 0.57188, 0.58499, 0.56704, 751987.89410868],
    [1536915600000, 0.566, 0.57223, 0.58012, 0.5638, 976485.79431373],
    [1536912000000, 0.5915, 0.5644, 0.5916, 0.5634, 1484103.22000341],
    [1536908400000, 0.596, 0.58872, 0.608, 0.58872, 1189997.41224017],
    [1536904800000, 0.591, 0.597, 0.59833, 0.58755, 239043.4322906],
    [1536901200000, 0.6024, 0.59121, 0.61, 0.58484, 971626.94710586],
    [1536897600000, 0.60223, 0.6025, 0.60973, 0.6006, 418454.36027977],
    [1536894000000, 0.60269, 0.603, 0.61747, 0.602, 1516538.6670001],
    [1536890400000, 0.57998, 0.602, 0.606, 0.57998, 1203896.36562441],
    [1536886800000, 0.57555, 0.57932, 0.58603, 0.57446, 293190.85216337],
    [1536883200000, 0.5759, 0.5732, 0.58, 0.5688, 453266.40384299],
    [1536879600000, 0.57877, 0.5754, 0.59013, 0.57, 644839.26605208],
    [1536876000000, 0.57806, 0.57875, 0.58887, 0.57606, 437054.44468309],
    [1536872400000, 0.57597, 0.5779, 0.58117, 0.57006, 484778.79240431],
    [1536868800000, 0.57289, 0.5758, 0.58103, 0.56734, 1011543.32357086],
    [1536865200000, 0.57856, 0.57292, 0.5829, 0.56759, 1158688.8381219],
    [1536861600000, 0.59, 0.5775, 0.59229, 0.57625, 822654.91402525],
    [1536858000000, 0.5933, 0.59029, 0.599, 0.583, 613451.41919156],
    [1536854400000, 0.58033, 0.5932, 0.60672, 0.57931, 1778615.02891577],
    [1536850800000, 0.57959, 0.5804, 0.58622, 0.57629, 655583.44734962],
    [1536847200000, 0.58541, 0.5795, 0.59041, 0.57799, 1464695.87133255],
    [1536843600000, 0.5687, 0.58366, 0.59223, 0.5687, 1814006.55702258],
    [1536840000000, 0.57021, 0.567, 0.577, 0.56651, 839763.91130418],
    [1536836400000, 0.56558, 0.57203, 0.57203, 0.5611, 364143.8627999],
    [1536832800000, 0.56578, 0.56558, 0.57462, 0.56313, 645469.67076993],
    [1536829200000, 0.56546784, 0.56547, 0.577, 0.561, 1023556.52328104]
]


ACTIVE_ORDERS = [
    {
        'id': 15556703943, 'cid': 19099487351, 'cid_date': '2018-08-17', 'gid': None,
        'symbol': 'iotusd', 'exchange': 'bitfinex', 'price': '0.41116',
        'avg_execution_price': '0.0', 'side': 'buy', 'type': 'limit',
        'timestamp': '1534483100.0',
        'is_live': True, 'is_cancelled': False, 'is_hidden': False, 'oco_order': None,
        'was_forced': False, 'original_amount': '2000.0', 'remaining_amount': '2000.0',
        'executed_amount': '0.0', 'src': 'api'
    },
    {
        'id': 15827923845, 'cid': 67633888436, 'cid_date': '2018-08-23', 'gid': None,
        'symbol': 'iotusd', 'exchange': 'bitfinex', 'price': '0.40161',
        'avg_execution_price': '0.0', 'side': 'buy', 'type': 'limit',
        'timestamp': '1535050034.0',
        'is_live': True, 'is_cancelled': False, 'is_hidden': False, 'oco_order': None,
        'was_forced': False, 'original_amount': '2000.0', 'remaining_amount': '2000.0',
        'executed_amount': '0.0', 'src': 'api'
    },
    {
        'id': 16355359550, 'cid': 36788795189, 'cid_date': '2018-09-05', 'gid': None,
        'symbol': 'iotusd', 'exchange': 'bitfinex', 'price': '0.75',
        'avg_execution_price': '0.0', 'side': 'sell', 'type': 'limit',
        'timestamp': '1536142389.0',
        'is_live': True, 'is_cancelled': False, 'is_hidden': False, 'oco_order': None,
        'was_forced': False, 'original_amount': '1000.0', 'remaining_amount': '1000.0',
        'executed_amount': '0.0', 'src': 'web'
    },
    {
        'id': 16355361841, 'cid': 36791910209, 'cid_date': '2018-09-05', 'gid': None,
        'symbol': 'iotusd', 'exchange': 'bitfinex', 'price': '0.77',
        'avg_execution_price': '0.0', 'side': 'sell', 'type': 'limit',
        'timestamp': '1536142392.0',
        'is_live': True, 'is_cancelled': False, 'is_hidden': False, 'oco_order': None,
        'was_forced': False, 'original_amount': '1000.0', 'remaining_amount': '1000.0',
        'executed_amount': '0.0', 'src': 'web'
    },
    {
        'id': 16400236186, 'cid': 18057132058, 'cid_date': '2018-09-06', 'gid': None,
        'symbol': 'iotusd', 'exchange': 'bitfinex', 'price': '0.67',
        'avg_execution_price': '0.0', 'side': 'sell', 'type': 'limit',
        'timestamp': '1536210057.0',
        'is_live': True, 'is_cancelled': False, 'is_hidden': False, 'oco_order': None,
        'was_forced': False, 'original_amount': '1000.0', 'remaining_amount': '1000.0',
        'executed_amount': '0.0', 'src': 'web'
    },
    {
        'id': 16400238455, 'cid': 18061246987, 'cid_date': '2018-09-06', 'gid': None,
        'symbol': 'iotusd', 'exchange': 'bitfinex', 'price': '0.68',
        'avg_execution_price': '0.0', 'side': 'sell', 'type': 'limit',
        'timestamp': '1536210061.0',
        'is_live': True, 'is_cancelled': False, 'is_hidden': False, 'oco_order': None,
        'was_forced': False, 'original_amount': '1000.0', 'remaining_amount': '1000.0',
        'executed_amount': '0.0', 'src': 'web'
    },
    {
        'id': 16402177113, 'cid': 21071887617, 'cid_date': '2018-09-06', 'gid': None,
        'symbol': 'iotusd', 'exchange': 'bitfinex', 'price': '0.47',
        'avg_execution_price': '0.0', 'side': 'buy', 'type': 'limit',
        'timestamp': '1536213072.0',
        'is_live': True, 'is_cancelled': False, 'is_hidden': False, 'oco_order': None,
        'was_forced': False, 'original_amount': '1000.0', 'remaining_amount': '1000.0',
        'executed_amount': '0.0', 'src': 'web'
    },
    {
        'id': 16404982749, 'cid': 25861885468, 'cid_date': '2018-09-06', 'gid': None,
        'symbol': 'iotusd', 'exchange': 'bitfinex', 'price': '0.64',
        'avg_execution_price': '0.0', 'side': 'sell', 'type': 'limit',
        'timestamp': '1536217862.0',
        'is_live': True, 'is_cancelled': False, 'is_hidden': False, 'oco_order': None,
        'was_forced': False, 'original_amount': '1000.0', 'remaining_amount': '1000.0',
        'executed_amount': '0.0', 'src': 'web'
    }
]

ORDERBOOK_DATA = [
    {'price': '0.5382', 'amount': '698.36501', 'timestamp': '1537259985.0'},
    {'price': '0.5386', 'amount': '5540', 'timestamp': '1537259985.0'},
    {'price': '0.53873', 'amount': '757.29590546', 'timestamp': '1537259985.0'},
    {'price': '0.53898', 'amount': '785.1837944', 'timestamp': '1537259985.0'},
    {'price': '0.53899', 'amount': '2583.32248026', 'timestamp': '1537259985.0'},
    {'price': '0.539', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.53904', 'amount': '400', 'timestamp': '1537259985.0'},
    {'price': '0.53906', 'amount': '800', 'timestamp': '1537259985.0'},
    {'price': '0.53912', 'amount': '1660', 'timestamp': '1537259985.0'},
    {'price': '0.53921', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.53926', 'amount': '232.82467396', 'timestamp': '1537259985.0'},
    {'price': '0.53949', 'amount': '10005.62816584', 'timestamp': '1537259985.0'},
    {'price': '0.5395', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.53969', 'amount': '700', 'timestamp': '1537259985.0'},
    {'price': '0.5397', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.53971', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.53972', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.53989', 'amount': '232.82310724', 'timestamp': '1537259985.0'},
    {'price': '0.5399', 'amount': '465.64568319', 'timestamp': '1537259985.0'},
    {'price': '0.53992', 'amount': '600.91148685', 'timestamp': '1537259985.0'},
    {'price': '0.54008', 'amount': '400', 'timestamp': '1537259985.0'},
    {'price': '0.54009', 'amount': '48.40385489', 'timestamp': '1537259985.0'},
    {'price': '0.5401', 'amount': '1200', 'timestamp': '1537259985.0'},
    {'price': '0.54016', 'amount': '525', 'timestamp': '1537259985.0'},
    {'price': '0.54018', 'amount': '651.45973514', 'timestamp': '1537259985.0'},
    {'price': '0.5402', 'amount': '461.38230138', 'timestamp': '1537259985.0'},
    {'price': '0.54028', 'amount': '782.35386125', 'timestamp': '1537259985.0'},
    {'price': '0.54036', 'amount': '600', 'timestamp': '1537259985.0'},
    {'price': '0.54046', 'amount': '3874.89476147', 'timestamp': '1537259985.0'},
    {'price': '0.54047', 'amount': '3000', 'timestamp': '1537259985.0'},
    {'price': '0.5405', 'amount': '67.50292824', 'timestamp': '1537259985.0'},
    {'price': '0.54056', 'amount': '651.45973514', 'timestamp': '1537259985.0'},
    {'price': '0.54067', 'amount': '6000', 'timestamp': '1537259985.0'},
    {'price': '0.54099', 'amount': '5000', 'timestamp': '1537259985.0'},
    {'price': '0.54101', 'amount': '700', 'timestamp': '1537259985.0'},
    {'price': '0.54105', 'amount': '1500', 'timestamp': '1537259985.0'},
    {'price': '0.5414', 'amount': '9000', 'timestamp': '1537259985.0'},
    {'price': '0.54146', 'amount': '1600', 'timestamp': '1537259985.0'},
    {'price': '0.5417', 'amount': '1202.00673211', 'timestamp': '1537259985.0'},
    {'price': '0.54174', 'amount': '2581.8346485', 'timestamp': '1537259985.0'},
    {'price': '0.54175', 'amount': '31067.33673985', 'timestamp': '1537259985.0'},
    {'price': '0.54176', 'amount': '5602.5', 'timestamp': '1537259985.0'},
    {'price': '0.542', 'amount': '39.46966021', 'timestamp': '1537259985.0'},
    {'price': '0.54218', 'amount': '12000', 'timestamp': '1537259985.0'},
    {'price': '0.5425', 'amount': '40', 'timestamp': '1537259985.0'},
    {'price': '0.54257', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.54287', 'amount': '29627.3', 'timestamp': '1537259985.0'},
    {'price': '0.54299', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.543', 'amount': '10040', 'timestamp': '1537259985.0'},
    {'price': '0.5431', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.54336', 'amount': '797.36615389', 'timestamp': '1537259985.0'},
    {'price': '0.5434', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.54361', 'amount': '737.92565463', 'timestamp': '1537259985.0'},
    {'price': '0.54387', 'amount': '555.40040799', 'timestamp': '1537259985.0'},
    {'price': '0.54396', 'amount': '1290.50165717', 'timestamp': '1537259985.0'},
    {'price': '0.54397', 'amount': '50000', 'timestamp': '1537259985.0'},
    {'price': '0.544', 'amount': '2717.62356212', 'timestamp': '1537259985.0'},
    {'price': '0.54408', 'amount': '22000', 'timestamp': '1537259985.0'},
    {'price': '0.5442', 'amount': '4073.31131103', 'timestamp': '1537259985.0'},
    {'price': '0.54442', 'amount': '1758', 'timestamp': '1537259985.0'},
    {'price': '0.54454', 'amount': '76.25213416', 'timestamp': '1537259985.0'},
    {'price': '0.54473', 'amount': '1964', 'timestamp': '1537259985.0'},
    {'price': '0.54486', 'amount': '2354', 'timestamp': '1537259985.0'},
    {'price': '0.54488', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5449', 'amount': '8042.10627', 'timestamp': '1537259985.0'},
    {'price': '0.54498', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.545', 'amount': '2300', 'timestamp': '1537259985.0'},
    {'price': '0.54504', 'amount': '10000', 'timestamp': '1537259985.0'},
    {'price': '0.54517', 'amount': '52213.3', 'timestamp': '1537259985.0'},
    {'price': '0.54529', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.54545', 'amount': '1080', 'timestamp': '1537259985.0'},
    {'price': '0.5455', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.54558', 'amount': '257.5524', 'timestamp': '1537259985.0'},
    {'price': '0.54566', 'amount': '80', 'timestamp': '1537259985.0'},
    {'price': '0.54569', 'amount': '269.68153', 'timestamp': '1537259985.0'},
    {'price': '0.54582', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.54586', 'amount': '223.8705', 'timestamp': '1537259985.0'},
    {'price': '0.54588', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.54599', 'amount': '1999.999', 'timestamp': '1537259985.0'},
    {'price': '0.546', 'amount': '5000', 'timestamp': '1537259985.0'},
    {'price': '0.54607', 'amount': '770.85130101', 'timestamp': '1537259985.0'},
    {'price': '0.54611', 'amount': '400', 'timestamp': '1537259985.0'},
    {'price': '0.54636', 'amount': '736.80545734', 'timestamp': '1537259985.0'},
    {'price': '0.5464', 'amount': '5000', 'timestamp': '1537259985.0'},
    {'price': '0.54644', 'amount': '300', 'timestamp': '1537259985.0'},
    {'price': '0.54665', 'amount': '84.48989934', 'timestamp': '1537259985.0'},
    {'price': '0.54681', 'amount': '3000', 'timestamp': '1537259985.0'},
    {'price': '0.54688', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.54698', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.54699', 'amount': '61433.2', 'timestamp': '1537259985.0'},
    {'price': '0.547', 'amount': '3720', 'timestamp': '1537259985.0'},
    {'price': '0.54715', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.54721', 'amount': '4512', 'timestamp': '1537259985.0'},
    {'price': '0.54742', 'amount': '11999', 'timestamp': '1537259985.0'},
    {'price': '0.5475', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.5478', 'amount': '10000', 'timestamp': '1537259985.0'},
    {'price': '0.54782', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.54788', 'amount': '724.29334859', 'timestamp': '1537259985.0'},
    {'price': '0.54799', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.548', 'amount': '61540', 'timestamp': '1537259985.0'},
    {'price': '0.54801', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.54802', 'amount': '350', 'timestamp': '1537259985.0'},
    {'price': '0.54826', 'amount': '1080', 'timestamp': '1537259985.0'},
    {'price': '0.54827', 'amount': '5489', 'timestamp': '1537259985.0'},
    {'price': '0.54829', 'amount': '26.74830305', 'timestamp': '1537259985.0'},
    {'price': '0.54851', 'amount': '1587.23417819', 'timestamp': '1537259985.0'},
    {'price': '0.54874', 'amount': '1234', 'timestamp': '1537259985.0'},
    {'price': '0.54879', 'amount': '9156', 'timestamp': '1537259985.0'},
    {'price': '0.5488', 'amount': '3000', 'timestamp': '1537259985.0'},
    {'price': '0.54888', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5489', 'amount': '2468.7647341', 'timestamp': '1537259985.0'},
    {'price': '0.54898', 'amount': '1509.08', 'timestamp': '1537259985.0'},
    {'price': '0.549', 'amount': '4049.5', 'timestamp': '1537259985.0'},
    {'price': '0.54912', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.54914', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.54923', 'amount': '1365', 'timestamp': '1537259985.0'},
    {'price': '0.5494', 'amount': '5000', 'timestamp': '1537259985.0'},
    {'price': '0.54946', 'amount': '1458', 'timestamp': '1537259985.0'},
    {'price': '0.54958', 'amount': '10000', 'timestamp': '1537259985.0'},
    {'price': '0.54963', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.54967', 'amount': '101539', 'timestamp': '1537259985.0'},
    {'price': '0.54978', 'amount': '1684', 'timestamp': '1537259985.0'},
    {'price': '0.5498', 'amount': '5500', 'timestamp': '1537259985.0'},
    {'price': '0.54983', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.54985', 'amount': '1759', 'timestamp': '1537259985.0'},
    {'price': '0.54988', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5499', 'amount': '2949.99', 'timestamp': '1537259985.0'},
    {'price': '0.54991', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.54993', 'amount': '1824', 'timestamp': '1537259985.0'},
    {'price': '0.54995', 'amount': '5000', 'timestamp': '1537259985.0'},
    {'price': '0.54998', 'amount': '4699.95801786', 'timestamp': '1537259985.0'},
    {'price': '0.55', 'amount': '34468.45084226', 'timestamp': '1537259985.0'},
    {'price': '0.55022', 'amount': '4512', 'timestamp': '1537259985.0'},
    {'price': '0.5503', 'amount': '300', 'timestamp': '1537259985.0'},
    {'price': '0.55034', 'amount': '1856', 'timestamp': '1537259985.0'},
    {'price': '0.55057', 'amount': '22999.99', 'timestamp': '1537259985.0'},
    {'price': '0.55076', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.55088', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.551', 'amount': '2270', 'timestamp': '1537259985.0'},
    {'price': '0.5511', 'amount': '1250', 'timestamp': '1537259985.0'},
    {'price': '0.55115', 'amount': '3611.8091732', 'timestamp': '1537259985.0'},
    {'price': '0.55118', 'amount': '1080', 'timestamp': '1537259985.0'},
    {'price': '0.5512', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.55128', 'amount': '16000', 'timestamp': '1537259985.0'},
    {'price': '0.55132', 'amount': '900', 'timestamp': '1537259985.0'},
    {'price': '0.55156', 'amount': '1967', 'timestamp': '1537259985.0'},
    {'price': '0.55183', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.55188', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.55194', 'amount': '4999.99', 'timestamp': '1537259985.0'},
    {'price': '0.552', 'amount': '53363.5349', 'timestamp': '1537259985.0'},
    {'price': '0.55203', 'amount': '2000', 'timestamp': '1537259985.0'},
    {'price': '0.5523', 'amount': '6000', 'timestamp': '1537259985.0'},
    {'price': '0.55233', 'amount': '2054', 'timestamp': '1537259985.0'},
    {'price': '0.55254', 'amount': '400', 'timestamp': '1537259985.0'},
    {'price': '0.5526', 'amount': '50000', 'timestamp': '1537259985.0'},
    {'price': '0.55288', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.55295', 'amount': '2000', 'timestamp': '1537259985.0'},
    {'price': '0.55298', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.553', 'amount': '5590', 'timestamp': '1537259985.0'},
    {'price': '0.5531', 'amount': '60', 'timestamp': '1537259985.0'},
    {'price': '0.5532', 'amount': '2311', 'timestamp': '1537259985.0'},
    {'price': '0.55332', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.5535', 'amount': '185.80246913', 'timestamp': '1537259985.0'},
    {'price': '0.55352', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.5536', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.55368', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55375', 'amount': '442.10627', 'timestamp': '1537259985.0'},
    {'price': '0.55383', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.55388', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.55397', 'amount': '237.65432099', 'timestamp': '1537259985.0'},
    {'price': '0.55399', 'amount': '5000', 'timestamp': '1537259985.0'},
    {'price': '0.554', 'amount': '2361', 'timestamp': '1537259985.0'},
    {'price': '0.55421', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55422', 'amount': '189.5663', 'timestamp': '1537259985.0'},
    {'price': '0.55427', 'amount': '140.21347009', 'timestamp': '1537259985.0'},
    {'price': '0.55428', 'amount': '100000', 'timestamp': '1537259985.0'},
    {'price': '0.55445', 'amount': '346.2962963', 'timestamp': '1537259985.0'},
    {'price': '0.5546', 'amount': '3500', 'timestamp': '1537259985.0'},
    {'price': '0.55474', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55488', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5549', 'amount': '3500', 'timestamp': '1537259985.0'},
    {'price': '0.55493', 'amount': '244.44444444', 'timestamp': '1537259985.0'},
    {'price': '0.55498', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.555', 'amount': '48050.05', 'timestamp': '1537259985.0'},
    {'price': '0.55509', 'amount': '1080', 'timestamp': '1537259985.0'},
    {'price': '0.55517', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.55521', 'amount': '126', 'timestamp': '1537259985.0'},
    {'price': '0.55526', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55529', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.55534', 'amount': '24.56228433', 'timestamp': '1537259985.0'},
    {'price': '0.5554', 'amount': '135.80246914', 'timestamp': '1537259985.0'},
    {'price': '0.5556', 'amount': '2001', 'timestamp': '1537259985.0'},
    {'price': '0.55579', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55583', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.55588', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.55598', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.556', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.55605', 'amount': '2000', 'timestamp': '1537259985.0'},
    {'price': '0.55628', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.55632', 'amount': '1539', 'timestamp': '1537259985.0'},
    {'price': '0.55658', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.55676', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.55684', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55688', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.557', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.55737', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55766', 'amount': '300', 'timestamp': '1537259985.0'},
    {'price': '0.5577', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.5578', 'amount': '1500', 'timestamp': '1537259985.0'},
    {'price': '0.55783', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.55785', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.55788', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.55789', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55798', 'amount': '1100', 'timestamp': '1537259985.0'},
    {'price': '0.558', 'amount': '8303.48941024', 'timestamp': '1537259985.0'},
    {'price': '0.55813', 'amount': '4000', 'timestamp': '1537259985.0'},
    {'price': '0.55839', 'amount': '50000', 'timestamp': '1537259985.0'},
    {'price': '0.55842', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55853', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.55862', 'amount': '79.87359541', 'timestamp': '1537259985.0'},
    {'price': '0.5587', 'amount': '202', 'timestamp': '1537259985.0'},
    {'price': '0.55888', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5589', 'amount': '4000', 'timestamp': '1537259985.0'},
    {'price': '0.55895', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.55896', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.55898', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.559', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.55904', 'amount': '1080', 'timestamp': '1537259985.0'},
    {'price': '0.55906', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.55922', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.55933', 'amount': '1400', 'timestamp': '1537259985.0'},
    {'price': '0.55947', 'amount': '579', 'timestamp': '1537259985.0'},
    {'price': '0.5595', 'amount': '3800', 'timestamp': '1537259985.0'},
    {'price': '0.5597', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.5598', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.55983', 'amount': '442.10627', 'timestamp': '1537259985.0'},
    {'price': '0.55984', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.55988', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5599', 'amount': '4694.504603', 'timestamp': '1537259985.0'},
    {'price': '0.55993', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.55998', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.56', 'amount': '17756.03255473', 'timestamp': '1537259985.0'},
    {'price': '0.56012', 'amount': '2234', 'timestamp': '1537259985.0'},
    {'price': '0.56022', 'amount': '400', 'timestamp': '1537259985.0'},
    {'price': '0.56027', 'amount': '1353.049', 'timestamp': '1537259985.0'},
    {'price': '0.5603', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.56047', 'amount': '22', 'timestamp': '1537259985.0'},
    {'price': '0.56068', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.56085', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.56088', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.56091', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.561', 'amount': '4725.44839358', 'timestamp': '1537259985.0'},
    {'price': '0.56105', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.5612', 'amount': '2500', 'timestamp': '1537259985.0'},
    {'price': '0.56161', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.5618', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.56184', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.56186', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.56188', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.56189', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.562', 'amount': '2361', 'timestamp': '1537259985.0'},
    {'price': '0.56247', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.56257', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.5627', 'amount': '906.91036373', 'timestamp': '1537259985.0'},
    {'price': '0.56287', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.56288', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.563', 'amount': '2090', 'timestamp': '1537259985.0'},
    {'price': '0.56339', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.56351', 'amount': '4000', 'timestamp': '1537259985.0'},
    {'price': '0.56384', 'amount': '120', 'timestamp': '1537259985.0'},
    {'price': '0.56388', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.56395', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.56398', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.564', 'amount': '2750', 'timestamp': '1537259985.0'},
    {'price': '0.56413', 'amount': '1500', 'timestamp': '1537259985.0'},
    {'price': '0.56424', 'amount': '2000', 'timestamp': '1537259985.0'},
    {'price': '0.56436', 'amount': '539', 'timestamp': '1537259985.0'},
    {'price': '0.5644', 'amount': '3000', 'timestamp': '1537259985.0'},
    {'price': '0.56466', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.56482', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.56483', 'amount': '101.89619756', 'timestamp': '1537259985.0'},
    {'price': '0.56488', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5649', 'amount': '2500', 'timestamp': '1537259985.0'},
    {'price': '0.56498', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.565', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.56541', 'amount': '3236.27648988', 'timestamp': '1537259985.0'},
    {'price': '0.5658', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.56584', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.56588', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5659', 'amount': '1780', 'timestamp': '1537259985.0'},
    {'price': '0.566', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.56603', 'amount': '1473.745593', 'timestamp': '1537259985.0'},
    {'price': '0.56615', 'amount': '300', 'timestamp': '1537259985.0'},
    {'price': '0.5662', 'amount': '997.002999', 'timestamp': '1537259985.0'},
    {'price': '0.56644', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.56669', 'amount': '442.10627', 'timestamp': '1537259985.0'},
    {'price': '0.56688', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.567', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.5673', 'amount': '5000', 'timestamp': '1537259985.0'},
    {'price': '0.56749', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.56767', 'amount': '2401.379', 'timestamp': '1537259985.0'},
    {'price': '0.5678', 'amount': '3000', 'timestamp': '1537259985.0'},
    {'price': '0.56784', 'amount': '65.34288813', 'timestamp': '1537259985.0'},
    {'price': '0.56788', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.56798', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.568', 'amount': '2517', 'timestamp': '1537259985.0'},
    {'price': '0.56807', 'amount': '184.9454', 'timestamp': '1537259985.0'},
    {'price': '0.5685', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.56888', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5689', 'amount': '3300', 'timestamp': '1537259985.0'},
    {'price': '0.56898', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.569', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.56908', 'amount': '300', 'timestamp': '1537259985.0'},
    {'price': '0.56915', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.56925', 'amount': '3145.04131657', 'timestamp': '1537259985.0'},
    {'price': '0.5698', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.56988', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5699', 'amount': '2500', 'timestamp': '1537259985.0'},
    {'price': '0.56998', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.57', 'amount': '13744.43201843', 'timestamp': '1537259985.0'},
    {'price': '0.57036', 'amount': '100000', 'timestamp': '1537259985.0'},
    {'price': '0.57088', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.571', 'amount': '80', 'timestamp': '1537259985.0'},
    {'price': '0.57103', 'amount': '123.9187997', 'timestamp': '1537259985.0'},
    {'price': '0.57115', 'amount': '140', 'timestamp': '1537259985.0'},
    {'price': '0.57128', 'amount': '156.67289275', 'timestamp': '1537259985.0'},
    {'price': '0.5717', 'amount': '197.5', 'timestamp': '1537259985.0'},
    {'price': '0.57188', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5719', 'amount': '22012.764943', 'timestamp': '1537259985.0'},
    {'price': '0.572', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.57238', 'amount': '18812.3462', 'timestamp': '1537259985.0'},
    {'price': '0.57288', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5729', 'amount': '187.34876651', 'timestamp': '1537259985.0'},
    {'price': '0.573', 'amount': '90', 'timestamp': '1537259985.0'},
    {'price': '0.5735', 'amount': '442.10627', 'timestamp': '1537259985.0'},
    {'price': '0.57388', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.574', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.57436', 'amount': '6053.63667915', 'timestamp': '1537259985.0'},
    {'price': '0.57442', 'amount': '50000', 'timestamp': '1537259985.0'},
    {'price': '0.5747', 'amount': '1994', 'timestamp': '1537259985.0'},
    {'price': '0.57488', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5749', 'amount': '2500', 'timestamp': '1537259985.0'},
    {'price': '0.575', 'amount': '85', 'timestamp': '1537259985.0'},
    {'price': '0.5754', 'amount': '79.84231663', 'timestamp': '1537259985.0'},
    {'price': '0.57588', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.576', 'amount': '8140.3390363', 'timestamp': '1537259985.0'},
    {'price': '0.5764', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.57688', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.577', 'amount': '2477.81471889', 'timestamp': '1537259985.0'},
    {'price': '0.57779', 'amount': '22', 'timestamp': '1537259985.0'},
    {'price': '0.57788', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.578', 'amount': '1127.24656907', 'timestamp': '1537259985.0'},
    {'price': '0.5785', 'amount': '199.8', 'timestamp': '1537259985.0'},
    {'price': '0.57866', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.57888', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.579', 'amount': '2583.33849097', 'timestamp': '1537259985.0'},
    {'price': '0.57921', 'amount': '20000', 'timestamp': '1537259985.0'},
    {'price': '0.5795', 'amount': '7000', 'timestamp': '1537259985.0'},
    {'price': '0.5798', 'amount': '400', 'timestamp': '1537259985.0'},
    {'price': '0.57988', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.58', 'amount': '46614.71437987', 'timestamp': '1537259985.0'},
    {'price': '0.58004', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.58088', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.581', 'amount': '5031.92204279', 'timestamp': '1537259985.0'},
    {'price': '0.58104', 'amount': '300', 'timestamp': '1537259985.0'},
    {'price': '0.58177', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.58188', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.58193', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.582', 'amount': '554.133', 'timestamp': '1537259985.0'},
    {'price': '0.58225', 'amount': '180.4403', 'timestamp': '1537259985.0'},
    {'price': '0.58227', 'amount': '4300', 'timestamp': '1537259985.0'},
    {'price': '0.5823', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.58258', 'amount': '442.10627', 'timestamp': '1537259985.0'},
    {'price': '0.58288', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5829', 'amount': '184.815', 'timestamp': '1537259985.0'},
    {'price': '0.583', 'amount': '5328.95989385', 'timestamp': '1537259985.0'},
    {'price': '0.58316', 'amount': '47.36858066', 'timestamp': '1537259985.0'},
    {'price': '0.58317', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.58319', 'amount': '83.70287584', 'timestamp': '1537259985.0'},
    {'price': '0.58345', 'amount': '167.96400399', 'timestamp': '1537259985.0'},
    {'price': '0.58352', 'amount': '4200', 'timestamp': '1537259985.0'},
    {'price': '0.58388', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.584', 'amount': '31048', 'timestamp': '1537259985.0'},
    {'price': '0.5841', 'amount': '7067.53159683', 'timestamp': '1537259985.0'},
    {'price': '0.58429', 'amount': '287.52058339', 'timestamp': '1537259985.0'},
    {'price': '0.58471', 'amount': '149.69999999', 'timestamp': '1537259985.0'},
    {'price': '0.58488', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.585', 'amount': '2980.22489577', 'timestamp': '1537259985.0'},
    {'price': '0.58522', 'amount': '4550', 'timestamp': '1537259985.0'},
    {'price': '0.5856', 'amount': '6000', 'timestamp': '1537259985.0'},
    {'price': '0.58577', 'amount': '916.09334722', 'timestamp': '1537259985.0'},
    {'price': '0.58588', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.58599', 'amount': '5436.40281962', 'timestamp': '1537259985.0'},
    {'price': '0.586', 'amount': '6713.07982586', 'timestamp': '1537259985.0'},
    {'price': '0.58604', 'amount': '500', 'timestamp': '1537259985.0'},
    {'price': '0.58636', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.58679', 'amount': '3300', 'timestamp': '1537259985.0'},
    {'price': '0.58688', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.58689', 'amount': '50000', 'timestamp': '1537259985.0'},
    {'price': '0.587', 'amount': '5050', 'timestamp': '1537259985.0'},
    {'price': '0.58745', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.5878', 'amount': '580', 'timestamp': '1537259985.0'},
    {'price': '0.58788', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.588', 'amount': '1088', 'timestamp': '1537259985.0'},
    {'price': '0.58811', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.5885', 'amount': '13937.55818234', 'timestamp': '1537259985.0'},
    {'price': '0.58851', 'amount': '4400', 'timestamp': '1537259985.0'},
    {'price': '0.58888', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.589', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.58913', 'amount': '48.17260794', 'timestamp': '1537259985.0'},
    {'price': '0.58933', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.5895', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.58952', 'amount': '106.28357272', 'timestamp': '1537259985.0'},
    {'price': '0.58955', 'amount': '900', 'timestamp': '1537259985.0'},
    {'price': '0.58963', 'amount': '523.4906089', 'timestamp': '1537259985.0'},
    {'price': '0.58966', 'amount': '189.98660614', 'timestamp': '1537259985.0'},
    {'price': '0.58977', 'amount': '5362', 'timestamp': '1537259985.0'},
    {'price': '0.58988', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5899', 'amount': '10324.7', 'timestamp': '1537259985.0'},
    {'price': '0.58999', 'amount': '2840.01589356', 'timestamp': '1537259985.0'},
    {'price': '0.59', 'amount': '37027.73455879', 'timestamp': '1537259985.0'},
    {'price': '0.59001', 'amount': '691.7993531', 'timestamp': '1537259985.0'},
    {'price': '0.59006', 'amount': '442.10627', 'timestamp': '1537259985.0'},
    {'price': '0.59019', 'amount': '733.04454508', 'timestamp': '1537259985.0'},
    {'price': '0.59024', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.5903', 'amount': '2000', 'timestamp': '1537259985.0'},
    {'price': '0.59088', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.591', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.59167', 'amount': '4600', 'timestamp': '1537259985.0'},
    {'price': '0.59188', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.592', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.59201', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.59208', 'amount': '90', 'timestamp': '1537259985.0'},
    {'price': '0.59218', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.5922', 'amount': '2737.808', 'timestamp': '1537259985.0'},
    {'price': '0.59221', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.5924', 'amount': '933', 'timestamp': '1537259985.0'},
    {'price': '0.5925', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.59288', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.593', 'amount': '4490', 'timestamp': '1537259985.0'},
    {'price': '0.5932', 'amount': '244.46325664', 'timestamp': '1537259985.0'},
    {'price': '0.59324', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.59331', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.59355', 'amount': '300', 'timestamp': '1537259985.0'},
    {'price': '0.59369', 'amount': '22.22586845', 'timestamp': '1537259985.0'},
    {'price': '0.59388', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.594', 'amount': '550', 'timestamp': '1537259985.0'},
    {'price': '0.5943', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.59488', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.595', 'amount': '11437.00553357', 'timestamp': '1537259985.0'},
    {'price': '0.59501', 'amount': '20', 'timestamp': '1537259985.0'},
    {'price': '0.59508', 'amount': '34.76319012', 'timestamp': '1537259985.0'},
    {'price': '0.5951', 'amount': '4400', 'timestamp': '1537259985.0'},
    {'price': '0.59511', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.59526', 'amount': '3000', 'timestamp': '1537259985.0'},
    {'price': '0.59586', 'amount': '212.00920828', 'timestamp': '1537259985.0'},
    {'price': '0.59588', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.59594', 'amount': '12784.78291363', 'timestamp': '1537259985.0'},
    {'price': '0.596', 'amount': '2250', 'timestamp': '1537259985.0'},
    {'price': '0.59616', 'amount': '800', 'timestamp': '1537259985.0'},
    {'price': '0.59628', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.59654', 'amount': '600', 'timestamp': '1537259985.0'},
    {'price': '0.59656', 'amount': '400', 'timestamp': '1537259985.0'},
    {'price': '0.59663', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.5967', 'amount': '550', 'timestamp': '1537259985.0'},
    {'price': '0.59688', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.597', 'amount': '2350', 'timestamp': '1537259985.0'},
    {'price': '0.5975', 'amount': '200', 'timestamp': '1537259985.0'},
    {'price': '0.5977', 'amount': '10000', 'timestamp': '1537259985.0'},
    {'price': '0.59771', 'amount': '418.36827403', 'timestamp': '1537259985.0'},
    {'price': '0.59788', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.598', 'amount': '3290', 'timestamp': '1537259985.0'},
    {'price': '0.59802', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.59804', 'amount': '442.10627', 'timestamp': '1537259985.0'},
    {'price': '0.5982', 'amount': '4600', 'timestamp': '1537259985.0'},
    {'price': '0.59888', 'amount': '100', 'timestamp': '1537259985.0'},
    {'price': '0.5989', 'amount': '1700', 'timestamp': '1537259985.0'},
    {'price': '0.599', 'amount': '50', 'timestamp': '1537259985.0'},
    {'price': '0.5995', 'amount': '25', 'timestamp': '1537259985.0'},
    {'price': '0.59963', 'amount': '150', 'timestamp': '1537259985.0'},
    {'price': '0.59969', 'amount': '1000', 'timestamp': '1537259985.0'},
    {'price': '0.59987', 'amount': '550', 'timestamp': '1537259985.0'},
    {'price': '0.59988', 'amount': '100', 'timestamp': '1537259985.0'}
]

SYMBOL = "iotusd"

BTFX_SYMBOLS = [
    'btcusd', 'ltcusd', 'ltcbtc', 'ethusd', 'ethbtc', 'etcbtc', 'etcusd', 'rrtusd', 'rrtbtc',
    'zecusd', 'zecbtc', 'xmrusd', 'xmrbtc', 'dshusd', 'dshbtc', 'btceur', 'btcjpy', 'xrpusd',
    'xrpbtc', 'iotusd', 'iotbtc', 'ioteth', 'eosusd', 'eosbtc', 'eoseth', 'sanusd', 'sanbtc',
    'saneth', 'omgusd', 'omgbtc', 'omgeth', 'bchusd', 'bchbtc', 'bcheth', 'neousd', 'neobtc',
    'neoeth', 'etpusd', 'etpbtc', 'etpeth', 'qtmusd', 'qtmbtc', 'qtmeth', 'avtusd', 'avtbtc',
    'avteth', 'edousd', 'edobtc', 'edoeth', 'btgusd', 'btgbtc', 'datusd', 'datbtc', 'dateth',
    'qshusd', 'qshbtc', 'qsheth', 'yywusd', 'yywbtc', 'yyweth', 'gntusd', 'gntbtc', 'gnteth',
    'sntusd', 'sntbtc', 'snteth', 'ioteur', 'batusd', 'batbtc', 'bateth', 'mnausd', 'mnabtc',
    'mnaeth', 'funusd', 'funbtc', 'funeth', 'zrxusd', 'zrxbtc', 'zrxeth', 'tnbusd', 'tnbbtc',
    'tnbeth', 'spkusd', 'spkbtc', 'spketh', 'trxusd', 'trxbtc', 'trxeth', 'rcnusd', 'rcnbtc',
    'rcneth', 'rlcusd', 'rlcbtc', 'rlceth', 'aidusd', 'aidbtc', 'aideth', 'sngusd', 'sngbtc',
    'sngeth', 'repusd', 'repbtc', 'repeth', 'elfusd', 'elfbtc', 'elfeth', 'btcgbp', 'etheur',
    'ethjpy', 'ethgbp', 'neoeur', 'neojpy', 'neogbp', 'eoseur', 'eosjpy', 'eosgbp', 'iotjpy',
    'iotgbp', 'iosusd', 'iosbtc', 'ioseth', 'aiousd', 'aiobtc', 'aioeth', 'requsd', 'reqbtc',
    'reqeth', 'rdnusd', 'rdnbtc', 'rdneth', 'lrcusd', 'lrcbtc', 'lrceth', 'waxusd', 'waxbtc',
    'waxeth', 'daiusd', 'daibtc', 'daieth', 'cfiusd', 'cfibtc', 'cfieth', 'agiusd', 'agibtc',
    'agieth', 'bftusd', 'bftbtc', 'bfteth', 'mtnusd', 'mtnbtc', 'mtneth', 'odeusd', 'odebtc',
    'odeeth', 'antusd', 'antbtc', 'anteth', 'dthusd', 'dthbtc', 'dtheth', 'mitusd', 'mitbtc',
    'miteth', 'stjusd', 'stjbtc', 'stjeth', 'xlmusd', 'xlmeur', 'xlmjpy', 'xlmgbp', 'xlmbtc',
    'xlmeth', 'xvgusd', 'xvgeur', 'xvgjpy', 'xvggbp', 'xvgbtc', 'xvgeth', 'bciusd', 'bcibtc',
    'mkrusd', 'mkrbtc', 'mkreth', 'kncusd', 'kncbtc', 'knceth', 'poausd', 'poabtc', 'poaeth',
    'lymusd', 'lymbtc', 'lymeth', 'utkusd', 'utkbtc', 'utketh', 'veeusd', 'veebtc', 'veeeth',
    'dadusd', 'dadbtc', 'dadeth', 'orsusd', 'orsbtc', 'orseth', 'aucusd', 'aucbtc', 'auceth',
    'poyusd', 'poybtc', 'poyeth', 'fsnusd', 'fsnbtc', 'fsneth', 'cbtusd', 'cbtbtc', 'cbteth',
    'zcnusd', 'zcnbtc', 'zcneth', 'senusd', 'senbtc', 'seneth', 'ncausd', 'ncabtc', 'ncaeth',
    'cndusd', 'cndbtc', 'cndeth', 'ctxusd', 'ctxbtc', 'ctxeth', 'paiusd', 'paibtc', 'seeusd',
    'seebtc', 'seeeth', 'essusd', 'essbtc', 'esseth', 'atmusd', 'atmbtc', 'atmeth', 'hotusd',
    'hotbtc', 'hoteth', 'dtausd', 'dtabtc', 'dtaeth', 'iqxusd', 'iqxbtc', 'iqxeos', 'wprusd',
    'wprbtc', 'wpreth', 'zilusd', 'zilbtc', 'zileth', 'bntusd', 'bntbtc', 'bnteth', 'absusd',
    'abseth', 'xrausd', 'xraeth', 'manusd', 'maneth', 'bbnusd', 'bbneth', 'niousd', 'nioeth',
    'dgxusd', 'dgxeth', 'vetusd', 'vetbtc', 'veteth', 'utnusd', 'utneth', 'tknusd', 'tkneth',
    'gotusd', 'goteur', 'goteth', 'xtzusd', 'xtzbtc', 'cnnusd', 'cnneth', 'boxusd', 'boxeth'
]

CURRENCIES = ['iot', 'usd', 'btc', 'eth']

BALANCES = [
    {'type': 'deposit', 'currency': 'bch', 'amount': '0.0', 'available': '0.0'},
    {'type': 'deposit', 'currency': 'btc', 'amount': '0.0', 'available': '0.0'},
    {'type': 'deposit', 'currency': 'iot', 'amount': '39776.75364495', 'available': '0.000001'},
    {'type': 'deposit', 'currency': 'omg', 'amount': '7.91095765', 'available': '7.91095765'},
    {'type': 'deposit', 'currency': 'usd', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'bat', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'bch', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'btc', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'etc', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'eth', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'eur', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'fun', 'amount': '7205.7515678', 'available': '7205.7515678'},
    {'type': 'exchange', 'currency': 'iot', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'ltc', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'mna', 'amount': '19.05314345', 'available': '19.05314345'},
    {'type': 'exchange', 'currency': 'omg', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'spk', 'amount': '100.0', 'available': '100.0'},
    {'type': 'exchange', 'currency': 'tnb', 'amount': '4006.8', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'usd', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'xrp', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'yyw', 'amount': '0.0', 'available': '0.0'},
    {'type': 'exchange', 'currency': 'zrx', 'amount': '0.0', 'available': '0.0'},
    {'type': 'trading', 'currency': 'bch', 'amount': '0.0', 'available': '0.0'},
    {'type': 'trading', 'currency': 'btc', 'amount': '0.0', 'available': '0.0'},
    {'type': 'trading', 'currency': 'eos', 'amount': '0.0', 'available': '0.0'},
    {'type': 'trading', 'currency': 'eth', 'amount': '0.0', 'available': '0.0'},
    {'type': 'trading', 'currency': 'etp', 'amount': '0.0', 'available': '0.0'},
    {'type': 'trading', 'currency': 'iot', 'amount': '0.0', 'available': '0.0'},
    {'type': 'trading', 'currency': 'omg', 'amount': '0.0', 'available': '0.0'},
    {'type': 'trading', 'currency': 'usd', 'amount': '0.0', 'available': '0.0'}
]
