# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
"""Add encrypted password field

Revision ID: 289ce07647b
Revises: 2929af7925ed
Create Date: 2015-11-21 11:18:00.650587

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy_utils import EncryptedType

# revision identifiers, used by Alembic.
revision = "289ce07647b"
down_revision = "2929af7925ed"


def upgrade():
    op.add_column(
        "dbs", sa.Column("password", EncryptedType(sa.String(1024)), nullable=True)
    )


def downgrade():
    op.drop_column("dbs", "password")
