/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import 'abortcontroller-polyfill/dist/abortcontroller-polyfill-only';
import { configure } from '@superset-ui/translation';
import setupClient from './setup/setupClient';
import setupColors from './setup/setupColors';
import setupFormatters from './setup/setupFormatters';

// Configure translation
if (typeof window !== 'undefined') {
  const root = document.getElementById('app');
  const bootstrapData = root ? JSON.parse(root.getAttribute('data-bootstrap')) : {};
  if (bootstrapData.common && bootstrapData.common.language_pack) {
    const languagePack = bootstrapData.common.language_pack;
    configure({ languagePack });
  } else {
    configure();
  }
} else {
  configure();
}

// Setup SupersetClient
setupClient();

// Setup color palettes
setupColors();

// Setup number formatters
setupFormatters();
