# Code generated by builder. DO NOT EDIT.
"""
Kelvin API Client.
"""

from __future__ import annotations

from collections.abc import Mapping, Sequence
from typing import Any, Optional, Union, cast

from typing_extensions import Literal

from kelvin.api.base.api_service_model import AsyncApiServiceModel
from kelvin.api.base.data_model import KList
from kelvin.api.base.http_client.base_client import AsyncBaseClient

from ..model import requests, response, responses, type


class AppParameters(AsyncApiServiceModel):
    @classmethod
    async def list_app_version_parameters_history(
        cls,
        sort_by: Optional[Sequence[str]] = None,
        pagination_type: Optional[Literal["limits", "cursor", "stream"]] = None,
        page_size: Optional[int] = 10000,
        page: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        direction: Optional[Literal["asc", "desc"]] = None,
        data: Optional[Union[requests.AppVersionParametersHistoryList, Mapping[str, object]]] = None,
        fetch: bool = True,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> Union[KList[type.AppVersionParameter], responses.AppVersionParametersHistoryListPaginatedResponseCursor]:
        """
        List App Version Parameters History

        **Permission Required:** `kelvin.permission.parameter.read`.

        ``listAppVersionParametersHistory``: ``POST`` ``/api/v4/apps/parameters/history/list``

        Parameters
        ----------
        sort_by : :obj:`Sequence[str]`
            Sort the results by one or more enumerators.
        pagination_type : :obj:`Literal['limits', 'cursor', 'stream']`
            Method of pagination to use for return results where `total_items` is
            greater than `page_size`. `cursor` and `limits` will return one `page`
            of results, `stream` will return all results. ('limits', 'cursor',
            'stream')
        page_size : :obj:`int`
            Number of objects to be returned in each page. Page size can range
            between 1 and 10000 objects.
        page : :obj:`int`
            An integer for the wanted page of results. Used only with
            `pagination_type` set as `limits`.
        next : :obj:`str`
            An alphanumeric string bookmark to indicate where to start for the
            next page. Used only with `pagination_type` set as `cursor`.
        previous : :obj:`str`
            An alphanumeric string bookmark to indicate where to end for the
            previous page. Used only with `pagination_type` set as `cursor`.
        direction : :obj:`Literal['asc', 'desc']`
            Sorting order according to the `sort_by` parameter. ('asc', 'desc')
        data: requests.AppVersionParametersHistoryList, optional
        **kwargs:
            Extra parameters for requests.AppVersionParametersHistoryList
              - list_app_version_parameters_history: dict

        """

        result = await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/parameters/history/list",
            values={},
            params={
                "sort_by": sort_by,
                "pagination_type": pagination_type,
                "page_size": page_size,
                "page": page,
                "next": next,
                "previous": previous,
                "direction": direction,
            },
            files={},
            headers={},
            data=data,
            body_type=requests.AppVersionParametersHistoryList,
            array_body=False,
            result_types={
                "200": responses.AppVersionParametersHistoryListPaginatedResponseCursor,
                "400": response.Error,
                "401": response.Error,
                "404": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

        return (
            cast(
                Union[
                    KList[type.AppVersionParameter], responses.AppVersionParametersHistoryListPaginatedResponseCursor
                ],
                await cls.fetch(_client, "/api/v4/apps/parameters/history/list", result, "POST", data),
            )
            if fetch and not _dry_run
            else result
        )

    @classmethod
    async def list_app_parameters(
        cls,
        sort_by: Optional[Sequence[str]] = None,
        pagination_type: Optional[Literal["limits", "cursor", "stream"]] = None,
        page_size: Optional[int] = 10000,
        page: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        direction: Optional[Literal["asc", "desc"]] = None,
        data: Optional[Union[requests.AppParametersList, Mapping[str, object]]] = None,
        fetch: bool = True,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> Union[KList[type.AppParameter], responses.AppParametersListPaginatedResponseCursor]:
        """
        List App Parameters

        **Permission Required:** `kelvin.permission.parameter.read`.

        ``listAppParameters``: ``POST`` ``/api/v4/apps/parameters/list``

        Parameters
        ----------
        sort_by : :obj:`Sequence[str]`
            Sort the results by one or more enumerators.
        pagination_type : :obj:`Literal['limits', 'cursor', 'stream']`
            Method of pagination to use for return results where `total_items` is
            greater than `page_size`. `cursor` and `limits` will return one `page`
            of results, `stream` will return all results. ('limits', 'cursor',
            'stream')
        page_size : :obj:`int`
            Number of objects to be returned in each page. Page size can range
            between 1 and 10000 objects.
        page : :obj:`int`
            An integer for the wanted page of results. Used only with
            `pagination_type` set as `limits`.
        next : :obj:`str`
            An alphanumeric string bookmark to indicate where to start for the
            next page. Used only with `pagination_type` set as `cursor`.
        previous : :obj:`str`
            An alphanumeric string bookmark to indicate where to end for the
            previous page. Used only with `pagination_type` set as `cursor`.
        direction : :obj:`Literal['asc', 'desc']`
            Sorting order according to the `sort_by` parameter. ('asc', 'desc')
        data: requests.AppParametersList, optional
        **kwargs:
            Extra parameters for requests.AppParametersList
              - list_app_parameters: dict

        """

        result = await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/parameters/list",
            values={},
            params={
                "sort_by": sort_by,
                "pagination_type": pagination_type,
                "page_size": page_size,
                "page": page,
                "next": next,
                "previous": previous,
                "direction": direction,
            },
            files={},
            headers={},
            data=data,
            body_type=requests.AppParametersList,
            array_body=False,
            result_types={
                "200": responses.AppParametersListPaginatedResponseCursor,
                "400": response.Error,
                "401": response.Error,
                "404": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

        return (
            cast(
                Union[KList[type.AppParameter], responses.AppParametersListPaginatedResponseCursor],
                await cls.fetch(_client, "/api/v4/apps/parameters/list", result, "POST", data),
            )
            if fetch and not _dry_run
            else result
        )

    @classmethod
    async def create_parameters_schedule(
        cls,
        data: Optional[Union[requests.ParametersScheduleCreate, Mapping[str, object]]] = None,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> responses.ParametersScheduleCreate:
        """
        Create a new schedule to apply parameters to an application.

        Schedules are sets of application parameter values that are applied to a
        group of assets at a given time.

        Optionally, those values can be reverted to the desired value. When doing
        so, parameter values are defined for each asset individually, and the
        assets and parameters must match the original schedule. For example, if 2
        parameters were changed for 2 assets and a revert operation is requested,
        then the revert parameters must have 2 assets and 2 parameters for each
        asset.

        The schedule must be created in the future and, if a revert operation is
        requested, the revert date must be after the scheduled date.

        Upon creation, the current values of the parameters are stored in the
        `original_resource_parameters` field.


        **Permission Required:** `kelvin.permission.parameter.update`.

        ``createParametersSchedule``: ``POST`` ``/api/v4/apps/parameters/schedules/create``

        Parameters
        ----------
        data: requests.ParametersScheduleCreate, optional
        **kwargs:
            Extra parameters for requests.ParametersScheduleCreate
              - create_parameters_schedule: str

        """

        result = await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/parameters/schedules/create",
            values={},
            params={},
            files={},
            headers={},
            data=data,
            body_type=requests.ParametersScheduleCreate,
            array_body=False,
            result_types={
                "201": responses.ParametersScheduleCreate,
                "400": response.Error,
                "401": response.Error,
                "409": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

        return result

    @classmethod
    async def list_parameters_schedule(
        cls,
        pagination_type: Optional[Literal["limits", "cursor", "stream"]] = None,
        page_size: Optional[int] = 10000,
        page: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        direction: Optional[Literal["asc", "desc"]] = None,
        sort_by: Optional[Sequence[str]] = None,
        data: Optional[Union[requests.ParametersScheduleList, Mapping[str, object]]] = None,
        fetch: bool = True,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> Union[KList[responses.ParametersScheduleGet], responses.ParametersScheduleListPaginatedResponseCursor]:
        """
        Returns a list of Parameter Schedules and its parameters. The Parameter Schedules can be optionally filtered and sorted on the server before being returned.

        **Permission Required:** `kelvin.permission.parameter.read`.

        ``listParametersSchedule``: ``POST`` ``/api/v4/apps/parameters/schedules/list``

        Parameters
        ----------
        pagination_type : :obj:`Literal['limits', 'cursor', 'stream']`
            Method of pagination to use for return results where `total_items` is
            greater than `page_size`. `cursor` and `limits` will return one `page`
            of results, `stream` will return all results. ('limits', 'cursor',
            'stream')
        page_size : :obj:`int`
            Number of objects to be returned in each page. Page size can range
            between 1 and 10000 objects.
        page : :obj:`int`
            An integer for the wanted page of results. Used only with
            `pagination_type` set as `limits`.
        next : :obj:`str`
            An alphanumeric string bookmark to indicate where to start for the
            next page. Used only with `pagination_type` set as `cursor`.
        previous : :obj:`str`
            An alphanumeric string bookmark to indicate where to end for the
            previous page. Used only with `pagination_type` set as `cursor`.
        direction : :obj:`Literal['asc', 'desc']`
            Sorting order according to the `sort_by` parameter. ('asc', 'desc')
        sort_by : :obj:`Sequence[str]`
            Sort the results by one or more enumerators.
        data: requests.ParametersScheduleList, optional
        **kwargs:
            Extra parameters for requests.ParametersScheduleList
              - list_parameters_schedule: dict

        """

        result = await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/parameters/schedules/list",
            values={},
            params={
                "pagination_type": pagination_type,
                "page_size": page_size,
                "page": page,
                "next": next,
                "previous": previous,
                "direction": direction,
                "sort_by": sort_by,
            },
            files={},
            headers={},
            data=data,
            body_type=requests.ParametersScheduleList,
            array_body=False,
            result_types={
                "200": responses.ParametersScheduleListPaginatedResponseCursor,
                "400": response.Error,
                "401": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

        return (
            cast(
                Union[KList[responses.ParametersScheduleGet], responses.ParametersScheduleListPaginatedResponseCursor],
                await cls.fetch(_client, "/api/v4/apps/parameters/schedules/list", result, "POST", data),
            )
            if fetch and not _dry_run
            else result
        )

    @classmethod
    async def apply_parameters_schedule(
        cls,
        schedule_id: str,
        data: Optional[Union[requests.ParametersScheduleApply, Mapping[str, object]]] = None,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> None:
        """
        Apply the scheduled or reverted parameters of a specific schedule.

        There are 2 types of the "apply" action:

        - `schedule`: Applies the scheduled parameters if the schedule is in the
        `scheduled` state.
        - `schedule-revert`: Applies the revert parameters if the schedule is in the
        `scheduled-revert` state.

        If the schedule is not in the supported state for the selected type, the
        API will return an error.

        Errors encountered when calling this API will not affect the schedule
        state.

        **Permission Required:** `kelvin.permission.parameter.update`.

        ``applyParametersSchedule``: ``POST`` ``/api/v4/apps/parameters/schedules/{schedule_id}/apply``

        Parameters
        ----------
        schedule_id : :obj:`str`, optional
            The parameter schedule key `id` to be applied immediately.
        data: requests.ParametersScheduleApply, optional
        **kwargs:
            Extra parameters for requests.ParametersScheduleApply
              - apply_parameters_schedule: dict

        """

        await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/parameters/schedules/{schedule_id}/apply",
            values={"schedule_id": schedule_id},
            params={},
            files={},
            headers={},
            data=data,
            body_type=requests.ParametersScheduleApply,
            array_body=False,
            result_types={"204": None, "400": response.Error, "401": response.Error, "404": response.Error},
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

    @classmethod
    async def delete_parameters_schedule(
        cls,
        schedule_id: str,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
    ) -> None:
        """
        Delete a specific schedule.

        **Permission Required:** `kelvin.permission.parameter.update`.

        ``deleteParametersSchedule``: ``POST`` ``/api/v4/apps/parameters/schedules/{schedule_id}/delete``

        Parameters
        ----------
        schedule_id : :obj:`str`, optional
            The parameter schedule key `id` to be delete.

        """

        await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/parameters/schedules/{schedule_id}/delete",
            values={"schedule_id": schedule_id},
            params={},
            files={},
            headers={},
            data=None,
            body_type=None,
            array_body=False,
            result_types={"204": None, "400": response.Error, "401": response.Error, "404": response.Error},
            stream=False,
            dry_run=_dry_run,
        )

    @classmethod
    async def get_parameters_schedule(
        cls,
        schedule_id: str,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
    ) -> responses.ParametersScheduleGet:
        """
        Get a specific schedule.

        **Permission Required:** `kelvin.permission.parameter.read`.

        ``getParametersSchedule``: ``GET`` ``/api/v4/apps/parameters/schedules/{schedule_id}/get``

        Parameters
        ----------
        schedule_id : :obj:`str`, optional
            The parameter schedule key `id` to be retrieved.

        """

        result = await cls._make_request(
            client=_client,
            method="get",
            path="/api/v4/apps/parameters/schedules/{schedule_id}/get",
            values={"schedule_id": schedule_id},
            params={},
            files={},
            headers={},
            data=None,
            body_type=None,
            array_body=False,
            result_types={
                "200": responses.ParametersScheduleGet,
                "400": response.Error,
                "401": response.Error,
                "404": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
        )

        return result

    @classmethod
    async def get_app_version_parameters_unique_values(
        cls,
        data: Optional[Union[requests.AppVersionParametersUniqueValuesGet, Mapping[str, object]]] = None,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> responses.AppVersionParametersUniqueValuesGet:
        """
        Get App Version Parameters Unique Values

        **Permission Required:** `kelvin.permission.parameter.read`.

        ``getAppVersionParametersUniqueValues``: ``POST`` ``/api/v4/apps/parameters/unique-values/get``

        Parameters
        ----------
        data: requests.AppVersionParametersUniqueValuesGet, optional
        **kwargs:
            Extra parameters for requests.AppVersionParametersUniqueValuesGet
              - get_app_version_parameters_unique_values: dict

        """

        result = await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/parameters/unique-values/get",
            values={},
            params={},
            files={},
            headers={},
            data=data,
            body_type=requests.AppVersionParametersUniqueValuesGet,
            array_body=False,
            result_types={
                "200": responses.AppVersionParametersUniqueValuesGet,
                "400": response.Error,
                "401": response.Error,
                "404": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

        return result

    @classmethod
    async def list_app_version_parameter_values(
        cls,
        sort_by: Optional[Sequence[str]] = None,
        pagination_type: Optional[Literal["limits", "cursor", "stream"]] = None,
        page_size: Optional[int] = 10000,
        page: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        direction: Optional[Literal["asc", "desc"]] = None,
        data: Optional[Union[requests.AppVersionParameterValuesList, Mapping[str, object]]] = None,
        fetch: bool = True,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> Union[KList[type.AppVersionParameter], responses.AppVersionParameterValuesListPaginatedResponseCursor]:
        """
        List App Version Parameter Values

        **Permission Required:** `kelvin.permission.parameter.read`.

        ``listAppVersionParameterValues``: ``POST`` ``/api/v4/apps/parameters/values/list``

        Parameters
        ----------
        sort_by : :obj:`Sequence[str]`
            Sort the results by one or more enumerators.
        pagination_type : :obj:`Literal['limits', 'cursor', 'stream']`
            Method of pagination to use for return results where `total_items` is
            greater than `page_size`. `cursor` and `limits` will return one `page`
            of results, `stream` will return all results. ('limits', 'cursor',
            'stream')
        page_size : :obj:`int`
            Number of objects to be returned in each page. Page size can range
            between 1 and 10000 objects.
        page : :obj:`int`
            An integer for the wanted page of results. Used only with
            `pagination_type` set as `limits`.
        next : :obj:`str`
            An alphanumeric string bookmark to indicate where to start for the
            next page. Used only with `pagination_type` set as `cursor`.
        previous : :obj:`str`
            An alphanumeric string bookmark to indicate where to end for the
            previous page. Used only with `pagination_type` set as `cursor`.
        direction : :obj:`Literal['asc', 'desc']`
            Sorting order according to the `sort_by` parameter. ('asc', 'desc')
        data: requests.AppVersionParameterValuesList, optional
        **kwargs:
            Extra parameters for requests.AppVersionParameterValuesList
              - list_app_version_parameter_values: str

        """

        result = await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/parameters/values/list",
            values={},
            params={
                "sort_by": sort_by,
                "pagination_type": pagination_type,
                "page_size": page_size,
                "page": page,
                "next": next,
                "previous": previous,
                "direction": direction,
            },
            files={},
            headers={},
            data=data,
            body_type=requests.AppVersionParameterValuesList,
            array_body=False,
            result_types={
                "200": responses.AppVersionParameterValuesListPaginatedResponseCursor,
                "400": response.Error,
                "401": response.Error,
                "404": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

        return (
            cast(
                Union[KList[type.AppVersionParameter], responses.AppVersionParameterValuesListPaginatedResponseCursor],
                await cls.fetch(_client, "/api/v4/apps/parameters/values/list", result, "POST", data),
            )
            if fetch and not _dry_run
            else result
        )

    @classmethod
    async def update_app_version_parameters_defaults(
        cls,
        app_name: str,
        app_version: str,
        patch: Optional[bool] = None,
        data: Optional[Union[requests.AppVersionParametersDefaultsUpdate, Mapping[str, object]]] = None,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> None:
        """
        Update App Version Parameters Defaults

        **Permission Required:** `kelvin.permission.app.update`.

        ``updateAppVersionParametersDefaults``: ``POST`` ``/api/v4/apps/{app_name}/v/{app_version}/parameters/defaults/update``

        Parameters
        ----------
        app_name : :obj:`str`, optional
        app_version : :obj:`str`, optional
        patch : :obj:`bool`
            If set to `true`, it only updates the parameters that are explicitly
            defined in the request.
        data: requests.AppVersionParametersDefaultsUpdate, optional
        **kwargs:
            Extra parameters for requests.AppVersionParametersDefaultsUpdate
              - update_app_version_parameters_defaults: dict

        """

        await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/{app_name}/v/{app_version}/parameters/defaults/update",
            values={"app_name": app_name, "app_version": app_version},
            params={"patch": patch},
            files={},
            headers={},
            data=data,
            body_type=requests.AppVersionParametersDefaultsUpdate,
            array_body=False,
            result_types={"204": None, "400": response.Error, "401": response.Error, "404": response.Error},
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

    @classmethod
    async def get_app_version_parameters_fallback_values(
        cls,
        app_name: str,
        app_version: str,
        data: Optional[Union[requests.AppVersionParametersFallbackValuesGet, Mapping[str, object]]] = None,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> responses.AppVersionParametersFallbackValuesGet:
        """
        Get App Version Parameters Fallback Values

        **Permission Required:** `kelvin.permission.parameter.read`.

        ``getAppVersionParametersFallbackValues``: ``POST`` ``/api/v4/apps/{app_name}/v/{app_version}/parameters/fallback-values/get``

        Parameters
        ----------
        app_name : :obj:`str`, optional
        app_version : :obj:`str`, optional
        data: requests.AppVersionParametersFallbackValuesGet, optional
        **kwargs:
            Extra parameters for requests.AppVersionParametersFallbackValuesGet
              - get_app_version_parameters_fallback_values: dict

        """

        result = await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/{app_name}/v/{app_version}/parameters/fallback-values/get",
            values={"app_name": app_name, "app_version": app_version},
            params={},
            files={},
            headers={},
            data=data,
            body_type=requests.AppVersionParametersFallbackValuesGet,
            array_body=False,
            result_types={
                "200": responses.AppVersionParametersFallbackValuesGet,
                "400": response.Error,
                "401": response.Error,
                "404": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

        return result

    @classmethod
    async def update_app_version_parameters(
        cls,
        app_name: str,
        app_version: str,
        patch: Optional[bool] = None,
        data: Optional[Union[requests.AppVersionParametersUpdate, Mapping[str, object]]] = None,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> None:
        """
        Update App Version Parameters

        **Permission Required:** `kelvin.permission.parameter.update`.

        ``updateAppVersionParameters``: ``POST`` ``/api/v4/apps/{app_name}/v/{app_version}/parameters/values/update``

        Parameters
        ----------
        app_name : :obj:`str`, optional
        app_version : :obj:`str`, optional
        patch : :obj:`bool`
            If set to `true`, it only updates the parameters that are explicitly
            defined in the request.
        data: requests.AppVersionParametersUpdate, optional
        **kwargs:
            Extra parameters for requests.AppVersionParametersUpdate
              - update_app_version_parameters: dict

        """

        await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/apps/{app_name}/v/{app_version}/parameters/values/update",
            values={"app_name": app_name, "app_version": app_version},
            params={"patch": patch},
            files={},
            headers={},
            data=data,
            body_type=requests.AppVersionParametersUpdate,
            array_body=False,
            result_types={"204": None, "400": response.Error, "401": response.Error, "404": response.Error},
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )
