from ck.pgm import PGM


class Pathfinder(PGM):
    """
    This implementation of the Pathfinder PGM has 93 states for the "Fault" random
    variable, and its factor has been normalised to be a CPT.
    """

    def __init__(self):
        super().__init__(self.__class__.__name__)

        pgm_rv0 = self.new_rv('Fault', (
            'AIDS early', 'AILD', 'ALIP', 'Cat scratch disease', 'Dermatopathic laden', 'Florid follic hyperp',
            'GLH hyaline vascular', 'GLH plasma cell', 'Granulomatous laden', 'Histiocytosis x', 'Infectious mono',
            'Leprosy-lepromatous', 'Lymphangiographic', 'Mantle zone hyperpla', 'Necrotizing Kikuchi',
            'Necrotiz non-Kikuchi', 'Rheumatoid arthritis', 'Sarcoidosis', 'SHML', 'Sinus histiocytosis', 'Syphilis',
            'Toxoplasmosis', 'Tuberculosis', 'Viral NOS', "Whipple's disease", 'L&H nodular HD', 'L&H diffuse HD',
            'Nodular sclerosis HD', 'Cellular phase NSHD', 'Syncytial NSHD', 'Mixed cellularity HD',
            'Interfollicular HD',
            'Diffuse fibrosis HD', 'Reticular-type HD', 'Small cleaved fol', 'Mixed fol', 'Large cell fol',
            'Small noncleaved fol', 'Small lymphocytic', 'Plasmacytoid lyctic', 'Mantle zone lymphoma',
            'Small cleaved dif',
            'Mixed FCC dif', 'Large cell dif', 'B-immunoblastic', 'T-immunob mixed', 'AILD-like T-cell lym',
            'Japanese ATL',
            'Lymphoblastic', 'Small noncleaved dif', 'True histiocytic', 'Ki-1 LC anaplas T', 'Multiple myeloma',
            'Mycosis fungoides', 'AML', 'Hairy cell leukemia', 'Carcinoma', 'Melanoma', 'EM plasmacytoma',
            "Kaposi's sarcoma", 'Mast-cell disease', 'AIDS involutionary', 'T-immunob large', 'Monocytoid B-cell',
            'Nasopharyngeal CA', 'Seminoma', 'SLE', 'Mycobact histiocytos', 'Mast-cell hyperplas', 'LGV',
            'Histoplasmosis',
            'Coccidioidomycosis', 'CMV', 'Brucellosis', 'Ki-1 LC anaplas B', 'Intermed lymphocytic'))
        pgm_rv1 = self.new_rv('ACID', ('Negative', 'Positive'))
        pgm_rv2 = self.new_rv('F_CSA', ('No follicles', 'Absent', 'Present'))
        pgm_rv3 = self.new_rv('F_ISL', ('No follicles', 'Absent', 'Present'))
        pgm_rv4 = self.new_rv('F_POL', ('No follicles', 'Absent', 'Present'))
        pgm_rv5 = self.new_rv('F_RPBV', ('No follicles', 'None', 'One', 'More than one'))
        pgm_rv6 = self.new_rv('BH_LANG', ('Absent', 'Slight', 'Moderate', 'Marked'))
        pgm_rv7 = self.new_rv('BH_FOAM', ('Absent', 'Rare', 'Focal', 'Multifocal', 'Extensive'))
        pgm_rv8 = self.new_rv('BH_NOS', ('Absent to slight [<5pc]', 'Moderate [5-50pc]', 'Marked [>50pc]'))
        pgm_rv9 = self.new_rv('BH_SS',
                              ('Absent', 'Rare', 'Focal SS pattern', 'Multifocal SS pattern', 'Extensive SS pattern'))
        pgm_rv10 = self.new_rv('CA', ('Absent', 'Present'))
        pgm_rv11 = self.new_rv('SR', ('Absent [0]', 'Rare [1-3]', 'Present [4-15]', 'Many [16-50]', 'Striking [>50]'))
        pgm_rv12 = self.new_rv('DVS', ('Absent', 'Present'))
        pgm_rv13 = self.new_rv('EMPERI', ('Absent [0]', 'Present [1-2]', 'Prominent [>2]'))
        pgm_rv14 = self.new_rv('MA_EOSIN', ('Absent', 'Present'))
        pgm_rv15 = self.new_rv('EMM', ('Absent', 'Present'))
        pgm_rv16 = self.new_rv('EOSIN', ('Absent', 'Present', 'Prominent'))
        pgm_rv17 = self.new_rv('EHC', ('Absent [0pc]', 'Present [<5pc]', 'Prominent [>5pc]'))
        pgm_rv18 = self.new_rv('EHC_ENC', ('No epithelial clusters/no follicles', 'Absent [no]', 'Some', 'Many'))
        pgm_rv19 = self.new_rv('EH_NC', ('Absent [0pc]', 'Present [<5pc]', 'Prominent [>5pc]'))
        pgm_rv20 = self.new_rv('ECCC', ('Absent [0pc]', 'Rare [1-10pc]', 'Present [11-50pc]', 'Many [51-70pc]'))
        pgm_rv21 = self.new_rv('FCB', ('Absent', 'Present', 'Prominent'))
        pgm_rv22 = self.new_rv('FCB_NOD', ('No collagenous bands', 'Absent', 'Present'))
        pgm_rv23 = self.new_rv('FIBROS', ('Absent', 'Present'))
        pgm_rv24 = self.new_rv('FITE', ('Negative', 'Positive'))
        pgm_rv25 = self.new_rv('FBODY', ('Absent [0]', 'Present [1-5]', 'Prominent [>5]'))
        pgm_rv26 = self.new_rv('GENE_TC', ('Absent', 'Present'))
        pgm_rv27 = self.new_rv('HAIRY', ('Absent', 'Present'))
        pgm_rv28 = self.new_rv('HTLV_I', ('Negative', 'Positive'))
        pgm_rv29 = self.new_rv('HIV', ('Negative', 'Positive'))
        pgm_rv30 = self.new_rv('INTFOL', ('No expansion', 'Mild-moderate expansion', 'Unif mrkd expan/no follicles'))
        pgm_rv31 = self.new_rv('ICLC', ('Absent', 'Present'))
        pgm_rv32 = self.new_rv('KARYO', ('Absent', 'Present', 'Prominent'))
        pgm_rv33 = self.new_rv('L_and_H',
                               ('Absent [0]', 'Rare [1-5]', 'Few [6-25]', 'Many [26-100]', 'Striking [>100]'))
        pgm_rv34 = self.new_rv('LH_NOD', ('Absent', 'Present'))
        pgm_rv35 = self.new_rv('LACUN', (
            'Absent [0]', 'Rare [1-5]', 'Few [6-25]', 'Many [26 - 100]', 'Striking [>100]',
            'Sheets [>50pc of section]'))
        pgm_rv36 = self.new_rv('LANG', ('Absent [0]', 'Present [1-5]', 'Prominent [>5]'))
        pgm_rv37 = self.new_rv('LEUK', ('Absent', 'Present'))
        pgm_rv38 = self.new_rv('LLC_CY', ('No LLCs', 'Scanty', 'Moderate-abundant clear', 'Moderate-abundant deep'))
        pgm_rv39 = self.new_rv('LLC_NS', (
            'No LLCs', 'Multilobated [some]', 'Cerebriform/Mulberry [some]', 'Convoluted [some]', 'Irregular [most]',
            'Round/slightly irregular [most]'))
        pgm_rv40 = self.new_rv('LLC', (
            'Absent [0pc]', 'Sparse [<10pc]', 'Moderate [11-50pc]', 'Numerous [51-90pc]', 'Striking [>90pc]'))
        pgm_rv41 = self.new_rv('F_POPU', (
            'No follicles', '>80pc 6-12u', '>50pc 13-20u with nucleoli', '>50pc >20u with nucleoli', 'Other'))
        pgm_rv42 = self.new_rv('MAST', ('Absent [0]', 'Present [1-50]', 'Prominent [>50]'))
        pgm_rv43 = self.new_rv('MLC', (
            'Absent [0pc]', 'Sparse [<10pc]', 'Moderate [11-50pc]', 'Numerous [51-90pc]', 'Striking [>90pc]'))
        pgm_rv44 = self.new_rv('MELANOMA', ('Absent', 'Present'))
        pgm_rv45 = self.new_rv('MF10HP', ('0-5', '6-15', '16-50', '>50'))
        pgm_rv46 = self.new_rv('MLC_CY', ('No MLCs', 'Scanty', 'Moderate-abundant clear', 'Moderate-abundant deep'))
        pgm_rv47 = self.new_rv('MLC_NS', (
            'No MLCs', 'Cerebriform [some]', 'Convoluted [some]', 'Irregular [most]',
            'Round/slightly irregular [most]'))
        pgm_rv48 = self.new_rv('MLC_NI', ('No MLCs', 'Absent to rare', 'Large central', 'Peripheral', 'Other'))
        pgm_rv49 = self.new_rv('MCC', ('Absent [0pc]', 'Present [<5pc]', 'Prominent [5-50pc]', 'Confluence [>50pc]'))
        pgm_rv50 = self.new_rv('MONO', ('Absent [0]', 'Rare [1-2]', 'Present [3-20]', 'Many [>20]'))
        pgm_rv51 = self.new_rv('MOT_HIST', ('Absent', 'Focal [nonextensive]', 'Multifocal [nonextensive]', 'Extensive'))
        pgm_rv52 = self.new_rv('MOT_LLC',
                               ('No mottling', 'Focal [nonextensive]', 'Multifocal [nonextensive]', 'Extensive'))
        pgm_rv53 = self.new_rv('MUMMY', ('Absent [0]', 'Rare [1-2]', 'Present [3-20]', 'Many [>20]'))
        pgm_rv54 = self.new_rv('NECR', ('Absent', 'Focal [nonextensive]', 'Multifocal [nonextensive]', 'Extensive'))
        pgm_rv55 = self.new_rv('MA_NEUT', ('Absent', 'Present'))
        pgm_rv56 = self.new_rv('NEUTRO', ('Absent', 'Present', 'Prominent'))
        pgm_rv57 = self.new_rv('PAS', ('No', 'Yes'))
        pgm_rv58 = self.new_rv('PI', ('Absent', 'Present', 'Prominent'))
        pgm_rv59 = self.new_rv('PLASMA', (
            'Absent [0pc]', 'Few [<5pc]', 'Moderate [6-20pc]', 'Marked [21-50pc]', 'Striking [51-90pc]',
            'Sheets [>90pc]'))
        pgm_rv60 = self.new_rv('PC_TP', ('No plasma cells', 'Mature', 'Immature', 'Blastic', 'Pleomorphic', 'Mixed'))
        pgm_rv61 = self.new_rv('PLEO', ('Absent [0]', 'Rare [1-5]', 'Few [6-25]', 'Many [26-100]', 'Striking [>100]'))
        pgm_rv62 = self.new_rv('PFP', ('Absent', 'Present'))
        pgm_rv63 = self.new_rv('PTGC_NOD', ('Absent', 'Present'))
        pgm_rv64 = self.new_rv('RD_BOD', ('Absent', 'Present'))
        pgm_rv65 = self.new_rv('SARCOMA', ('Absent', 'Present'))
        pgm_rv66 = self.new_rv('SCHAUM', ('Absent', 'Present'))
        pgm_rv67 = self.new_rv('S_RING', ('Absent', 'Present'))
        pgm_rv68 = self.new_rv('SLC_CY', ('No SLCs', 'Scanty', 'Moderate-abundant clear', 'Moderate-abundant deep'))
        pgm_rv69 = self.new_rv('SLC_NS', (
            'No SLCs', 'Cerebriform [some]', 'Convoluted [some]', 'Moderate-mark irregular [most]',
            'Round/slightly irregular [most]'))
        pgm_rv70 = self.new_rv('SLC', (
            'Absent [0pc]', 'Sparse [1-10pc]', 'Moderate [11-50pc]', 'Numerous [51-90pc]', 'Striking [>90pc]'))
        pgm_rv71 = self.new_rv('SINUSES', ('Distended', 'Patent', 'Part-greatly obliterated', 'Completely obliterated'))
        pgm_rv72 = self.new_rv('VASC_C', ('Absent', 'Present'))
        pgm_rv73 = self.new_rv('VASC_NS', ('Absent', 'Slight', 'Moderate', 'Marked', 'Pronounced'))
        pgm_rv74 = self.new_rv('VASC_S', ('Absent', 'Present'))
        pgm_rv75 = self.new_rv('F_HEM', ('No follicles', 'Absent', 'Present'))
        pgm_rv76 = self.new_rv('TAB', ('Absent', 'Present'))
        pgm_rv77 = self.new_rv('CT', ('Absent', 'Slight [<10]', 'Moderate [10-20]', 'Marked [>20]'))
        pgm_rv78 = self.new_rv('GENE_IG', ('Absent', 'Present'))
        pgm_rv79 = self.new_rv('HIV_ST', ('Negative', 'Positive/Asymptomatic', 'Positive/Symptomatic'))
        pgm_rv80 = self.new_rv('MLC_LLC', ('No', 'Yes'))
        pgm_rv81 = self.new_rv('LLC_NI', ('No LLCs', 'Absent to rare', 'Large central', 'Peripheral', 'Other'))
        pgm_rv82 = self.new_rv('SLC_CS', ('No SLCs', 'Clumped', 'Vesicular', 'Fine and delicate', 'Plasmacytoid'))
        pgm_rv83 = self.new_rv('LLC_ID', ('No LLCs', 'Other', 'Large cleaved', 'Large noncleaved'))
        pgm_rv84 = self.new_rv('FOLLICLE', ('Absent [0pc]', '1-25pc', '25-75pc', '75-90pc', '>90pc'))
        pgm_rv85 = self.new_rv('F_DEN', ('No follicles', 'Back to back', 'Closely packed', 'Separated', 'Far apart'))
        pgm_rv86 = self.new_rv('F_SS',
                               ('No follicles', 'Absent [0]', 'Slight [1-15]', 'Moderate [16-30]', 'Marked [>30]'))
        pgm_rv87 = self.new_rv('F_MZSTAT', (
            'No follicles/no mantle zones', 'Mantle zones absent in most follicles',
            'Most incompletely surround follicles',
            'Most completely surround fol not thick', 'Most thick [>10 lymphocytes]'))
        pgm_rv88 = self.new_rv('F_MZCM', ('No follicles/no mantle zones', 'Absent', 'Present'))
        pgm_rv89 = self.new_rv('F_DEF', (
            'No follicles', 'Almost all well defined', 'Both well and poor defined', 'Almost all poor defined'))
        pgm_rv90 = self.new_rv('F_MITO', ('No follicles', '0-20', '21-50', '>50'))
        pgm_rv91 = self.new_rv('F_MZ', ('No follicles', 'Absent', 'Present'))
        pgm_rv92 = self.new_rv('F_CIO', ('No follicles', 'Most similar', 'Some similar', 'None similar'))
        pgm_rv93 = self.new_rv('LLC_KL', ('No LLCs', 'Neither positive', 'Monoclonal', 'Polyclonal'))
        pgm_rv94 = self.new_rv('PLAS_KL', ('No plasma cells', 'Polyclonal', 'Monoclonal', 'Neither positive'))
        pgm_rv95 = self.new_rv('FCC_KL', ('No follicles', 'Polyclonal', 'Monoclonal', 'Neither positive'))
        pgm_rv96 = self.new_rv('MZL_KL', ('No mantle zones', 'Polyclonal', 'Monoclonal', 'Neither positive'))
        pgm_rv97 = self.new_rv('SR_LEU', ('No classic SRs', 'Both -', 'Leu-M1+ CLA-', 'Leu-M1- CLA+', 'Both +'))
        pgm_rv98 = self.new_rv('LAC_LEU', ('No Lacunar SRs', 'Both -', 'Leu-M1+ CLA-', 'Leu-M1- CLA+', 'Both+'))
        pgm_rv99 = self.new_rv('PLEO_LEU', ('No pleomorphic SRs', 'Both -', 'Leu-M1+ CLA-', 'Leu-M1- CLA+', 'Both +'))
        pgm_rv100 = self.new_rv('MONO_LEU', ('No mononuclear SRs', 'Both -', 'Leu-M1+ CLA-', 'Leu-M1- CLA+', 'Both +'))
        pgm_rv101 = self.new_rv('LH_LEU', ('No L&H SRs', 'Both -', 'Leu-M1+ CLA-', 'Leu-M1- CLA+', 'Both +'))
        pgm_rv102 = self.new_rv('CA_KER', ('Negative', 'Positive'))
        pgm_rv103 = self.new_rv('MLC_LEU9', ('No MLCs', 'Negative', 'Positive'))
        pgm_rv104 = self.new_rv('MLC_TDT', ('No MLCs', 'Negative', 'Positive'))
        pgm_rv105 = self.new_rv('CA_CHROM', ('Negative', 'Positive'))
        pgm_rv106 = self.new_rv('UCHL_1', ('Negative', 'Positive'))
        pgm_rv107 = self.new_rv('KI_AB', ('Negative', 'Positive'))
        pgm_rv108 = self.new_rv('L_26', ('Negative', 'Positive'))
        pgm_rv109 = self.new_rv('BER_H2', ('Negative', 'Positive'))
        pgm_rv110 = self.new_rv('SEMINOMA', ('Absent', 'Present'))
        pgm_rv111 = self.new_rv('AGE', ('0-20', '21-30', '31-70', '>70'))
        pgm_rv112 = self.new_rv('LYMPHADE', ('Localized [stage 1 or 2]', 'Generalized [stage 3 or 4]'))
        pgm_rv113 = self.new_rv('MED_MASS', ('Absent', 'Present'))
        pgm_rv114 = self.new_rv('HMB45', ('Negative', 'Positive'))
        pgm_rv115 = self.new_rv('MLC_LYZ', ('No MLCs', 'Negative', 'Positive'))
        pgm_rv116 = self.new_rv('MLC_I', ('Absent [no]', 'Present [yes]'))
        pgm_rv117 = self.new_rv('LLC_I', ('Absent [no]', 'Present [yes]'))
        pgm_rv118 = self.new_rv('LIPID', ('Absent to few', 'Prominent'))
        pgm_rv119 = self.new_rv('HX_LA', ('Absent', 'Present'))
        pgm_rv120 = self.new_rv('HEMATOX', ('Absent', 'Present'))
        pgm_rv121 = self.new_rv('CMV', ('Absent', 'Present'))
        pgm_rv122 = self.new_rv('BRUCELLA', ('No', 'Yes'))
        pgm_rv123 = self.new_rv('COCCIDIA', ('Absent', 'Present'))
        pgm_rv124 = self.new_rv('HISTOPLA', ('Absent', 'Present'))
        pgm_rv125 = self.new_rv('LGV', ('No', 'Yes'))
        pgm_rv126 = self.new_rv('VDRL', ('No', 'Yes'))
        pgm_rv127 = self.new_rv('PLASCY_T', ('Absent', 'Present', 'Prominent'))
        pgm_rv128 = self.new_rv('TB', ('Absent', 'Present', 'Prominent'))
        pgm_rv129 = self.new_rv('MELANIN', ('Absent to normal', 'Present', 'Prominent'))
        pgm_rv130 = self.new_rv('MC_SL_NS', (
            'No follicles/no mantle zones', 'Round', 'Slightly irregular', 'Moderately irregular',
            'Markedly irregular'))
        pgm_rv131 = self.new_rv('FMZ_FUS', (
            'No thick mantle zones', 'No nodules no fusion', 'Nodules but no fusion', 'Fusion with or without nodules'))
        pgm_rv132 = self.new_rv('BH_NOS_L', ('No NOS benign histiocytes', 'Mainly interfollicular', 'Mainly sinusoidal',
                                             'Both interfollicular and sinusoidal'))
        pgm_rv133 = self.new_rv('SLC_NI', (
            'No SLCs', 'None identifiable', '1 or more peripheral small', '1 central medium to large', 'Other'))
        pgm_rv134 = self.new_rv('HYALIN', ('Absent', 'Present', 'Prominent'))
        pgm_factor0 = self.new_factor(pgm_rv0)
        pgm_factor1 = self.new_factor(pgm_rv1, pgm_rv128)
        pgm_factor2 = self.new_factor(pgm_rv2, pgm_rv0, pgm_rv84)
        pgm_factor3 = self.new_factor(pgm_rv3, pgm_rv0, pgm_rv75)
        pgm_factor4 = self.new_factor(pgm_rv4, pgm_rv0, pgm_rv84)
        pgm_factor5 = self.new_factor(pgm_rv5, pgm_rv0, pgm_rv2)
        pgm_factor6 = self.new_factor(pgm_rv6, pgm_rv0)
        pgm_factor7 = self.new_factor(pgm_rv7, pgm_rv0)
        pgm_factor8 = self.new_factor(pgm_rv8, pgm_rv0, pgm_rv54)
        pgm_factor9 = self.new_factor(pgm_rv9, pgm_rv0)
        pgm_factor10 = self.new_factor(pgm_rv10, pgm_rv0)
        pgm_factor11 = self.new_factor(pgm_rv11, pgm_rv0, pgm_rv50)
        pgm_factor12 = self.new_factor(pgm_rv12, pgm_rv0)
        pgm_factor13 = self.new_factor(pgm_rv13, pgm_rv0, pgm_rv8)
        pgm_factor14 = self.new_factor(pgm_rv14, pgm_rv0)
        pgm_factor15 = self.new_factor(pgm_rv15, pgm_rv0)
        pgm_factor16 = self.new_factor(pgm_rv16, pgm_rv0, pgm_rv15)
        pgm_factor17 = self.new_factor(pgm_rv17, pgm_rv0)
        pgm_factor18 = self.new_factor(pgm_rv18, pgm_rv0, pgm_rv84, pgm_rv17)
        pgm_factor19 = self.new_factor(pgm_rv19, pgm_rv0)
        pgm_factor20 = self.new_factor(pgm_rv20, pgm_rv0, pgm_rv117, pgm_rv116)
        pgm_factor21 = self.new_factor(pgm_rv21, pgm_rv0, pgm_rv77)
        pgm_factor22 = self.new_factor(pgm_rv22, pgm_rv0, pgm_rv21)
        pgm_factor23 = self.new_factor(pgm_rv23, pgm_rv0)
        pgm_factor24 = self.new_factor(pgm_rv24, pgm_rv0)
        pgm_factor25 = self.new_factor(pgm_rv25, pgm_rv0)
        pgm_factor26 = self.new_factor(pgm_rv26, pgm_rv0)
        pgm_factor27 = self.new_factor(pgm_rv27, pgm_rv0)
        pgm_factor28 = self.new_factor(pgm_rv28, pgm_rv0)
        pgm_factor29 = self.new_factor(pgm_rv29, pgm_rv79)
        pgm_factor30 = self.new_factor(pgm_rv30, pgm_rv0, pgm_rv84)
        pgm_factor31 = self.new_factor(pgm_rv31, pgm_rv0, pgm_rv20, pgm_rv117, pgm_rv116)
        pgm_factor32 = self.new_factor(pgm_rv32, pgm_rv0, pgm_rv54)
        pgm_factor33 = self.new_factor(pgm_rv33, pgm_rv0, pgm_rv34)
        pgm_factor34 = self.new_factor(pgm_rv34, pgm_rv0)
        pgm_factor35 = self.new_factor(pgm_rv35, pgm_rv0)
        pgm_factor36 = self.new_factor(pgm_rv36, pgm_rv0)
        pgm_factor37 = self.new_factor(pgm_rv37, pgm_rv0)
        pgm_factor38 = self.new_factor(pgm_rv38, pgm_rv0, pgm_rv83)
        pgm_factor39 = self.new_factor(pgm_rv39, pgm_rv0, pgm_rv83)
        pgm_factor40 = self.new_factor(pgm_rv40, pgm_rv0)
        pgm_factor41 = self.new_factor(pgm_rv41, pgm_rv0, pgm_rv84)
        pgm_factor42 = self.new_factor(pgm_rv42, pgm_rv0)
        pgm_factor43 = self.new_factor(pgm_rv43, pgm_rv0)
        pgm_factor44 = self.new_factor(pgm_rv44, pgm_rv0)
        pgm_factor45 = self.new_factor(pgm_rv45, pgm_rv0)
        pgm_factor46 = self.new_factor(pgm_rv46, pgm_rv0, pgm_rv43)
        pgm_factor47 = self.new_factor(pgm_rv47, pgm_rv0, pgm_rv43)
        pgm_factor48 = self.new_factor(pgm_rv48, pgm_rv0, pgm_rv43)
        pgm_factor49 = self.new_factor(pgm_rv49, pgm_rv0)
        pgm_factor50 = self.new_factor(pgm_rv50, pgm_rv0, pgm_rv53)
        pgm_factor51 = self.new_factor(pgm_rv51, pgm_rv0)
        pgm_factor52 = self.new_factor(pgm_rv52, pgm_rv0, pgm_rv40)
        pgm_factor53 = self.new_factor(pgm_rv53, pgm_rv0)
        pgm_factor54 = self.new_factor(pgm_rv54, pgm_rv0)
        pgm_factor55 = self.new_factor(pgm_rv55, pgm_rv0)
        pgm_factor56 = self.new_factor(pgm_rv56, pgm_rv0)
        pgm_factor57 = self.new_factor(pgm_rv57, pgm_rv0)
        pgm_factor58 = self.new_factor(pgm_rv58, pgm_rv0)
        pgm_factor59 = self.new_factor(pgm_rv59, pgm_rv0, pgm_rv51)
        pgm_factor60 = self.new_factor(pgm_rv60, pgm_rv0, pgm_rv59)
        pgm_factor61 = self.new_factor(pgm_rv61, pgm_rv0)
        pgm_factor62 = self.new_factor(pgm_rv62, pgm_rv0)
        pgm_factor63 = self.new_factor(pgm_rv63, pgm_rv0)
        pgm_factor64 = self.new_factor(pgm_rv64, pgm_rv0, pgm_rv59)
        pgm_factor65 = self.new_factor(pgm_rv65, pgm_rv0)
        pgm_factor66 = self.new_factor(pgm_rv66, pgm_rv0)
        pgm_factor67 = self.new_factor(pgm_rv67, pgm_rv0)
        pgm_factor68 = self.new_factor(pgm_rv68, pgm_rv0, pgm_rv70)
        pgm_factor69 = self.new_factor(pgm_rv69, pgm_rv0, pgm_rv70)
        pgm_factor70 = self.new_factor(pgm_rv70, pgm_rv0)
        pgm_factor71 = self.new_factor(pgm_rv71, pgm_rv0, pgm_rv30, pgm_rv84)
        pgm_factor72 = self.new_factor(pgm_rv72, pgm_rv0)
        pgm_factor73 = self.new_factor(pgm_rv73, pgm_rv0)
        pgm_factor74 = self.new_factor(pgm_rv74, pgm_rv0)
        pgm_factor75 = self.new_factor(pgm_rv75, pgm_rv0, pgm_rv84)
        pgm_factor76 = self.new_factor(pgm_rv76, pgm_rv0)
        pgm_factor77 = self.new_factor(pgm_rv77, pgm_rv0)
        pgm_factor78 = self.new_factor(pgm_rv78, pgm_rv0)
        pgm_factor79 = self.new_factor(pgm_rv79, pgm_rv0)
        pgm_factor80 = self.new_factor(pgm_rv80, pgm_rv0, pgm_rv40, pgm_rv43)
        pgm_factor81 = self.new_factor(pgm_rv81, pgm_rv0, pgm_rv83)
        pgm_factor82 = self.new_factor(pgm_rv82, pgm_rv0, pgm_rv70)
        pgm_factor83 = self.new_factor(pgm_rv83, pgm_rv0, pgm_rv40)
        pgm_factor84 = self.new_factor(pgm_rv84, pgm_rv0)
        pgm_factor85 = self.new_factor(pgm_rv85, pgm_rv0, pgm_rv84)
        pgm_factor86 = self.new_factor(pgm_rv86, pgm_rv0, pgm_rv4)
        pgm_factor87 = self.new_factor(pgm_rv87, pgm_rv0, pgm_rv91)
        pgm_factor88 = self.new_factor(pgm_rv88, pgm_rv0, pgm_rv91)
        pgm_factor89 = self.new_factor(pgm_rv89, pgm_rv0, pgm_rv84)
        pgm_factor90 = self.new_factor(pgm_rv90, pgm_rv0, pgm_rv84)
        pgm_factor91 = self.new_factor(pgm_rv91, pgm_rv0, pgm_rv84)
        pgm_factor92 = self.new_factor(pgm_rv92, pgm_rv0, pgm_rv84)
        pgm_factor93 = self.new_factor(pgm_rv93, pgm_rv0, pgm_rv83)
        pgm_factor94 = self.new_factor(pgm_rv94, pgm_rv0, pgm_rv59)
        pgm_factor95 = self.new_factor(pgm_rv95, pgm_rv0, pgm_rv84)
        pgm_factor96 = self.new_factor(pgm_rv96, pgm_rv0, pgm_rv91)
        pgm_factor97 = self.new_factor(pgm_rv97, pgm_rv0, pgm_rv11)
        pgm_factor98 = self.new_factor(pgm_rv98, pgm_rv0, pgm_rv35)
        pgm_factor99 = self.new_factor(pgm_rv99, pgm_rv0, pgm_rv61)
        pgm_factor100 = self.new_factor(pgm_rv100, pgm_rv0, pgm_rv50)
        pgm_factor101 = self.new_factor(pgm_rv101, pgm_rv0, pgm_rv33)
        pgm_factor102 = self.new_factor(pgm_rv102, pgm_rv0)
        pgm_factor103 = self.new_factor(pgm_rv103, pgm_rv0, pgm_rv43)
        pgm_factor104 = self.new_factor(pgm_rv104, pgm_rv0, pgm_rv43)
        pgm_factor105 = self.new_factor(pgm_rv105, pgm_rv0)
        pgm_factor106 = self.new_factor(pgm_rv106, pgm_rv0)
        pgm_factor107 = self.new_factor(pgm_rv107, pgm_rv0)
        pgm_factor108 = self.new_factor(pgm_rv108, pgm_rv0)
        pgm_factor109 = self.new_factor(pgm_rv109, pgm_rv0)
        pgm_factor110 = self.new_factor(pgm_rv110, pgm_rv0)
        pgm_factor111 = self.new_factor(pgm_rv111, pgm_rv0)
        pgm_factor112 = self.new_factor(pgm_rv112, pgm_rv0)
        pgm_factor113 = self.new_factor(pgm_rv113, pgm_rv0)
        pgm_factor114 = self.new_factor(pgm_rv114, pgm_rv0)
        pgm_factor115 = self.new_factor(pgm_rv115, pgm_rv0, pgm_rv43)
        pgm_factor116 = self.new_factor(pgm_rv116, pgm_rv43)
        pgm_factor117 = self.new_factor(pgm_rv117, pgm_rv40)
        pgm_factor118 = self.new_factor(pgm_rv118, pgm_rv0)
        pgm_factor119 = self.new_factor(pgm_rv119, pgm_rv0)
        pgm_factor120 = self.new_factor(pgm_rv120, pgm_rv0)
        pgm_factor121 = self.new_factor(pgm_rv121, pgm_rv0)
        pgm_factor122 = self.new_factor(pgm_rv122, pgm_rv0)
        pgm_factor123 = self.new_factor(pgm_rv123, pgm_rv0)
        pgm_factor124 = self.new_factor(pgm_rv124, pgm_rv0)
        pgm_factor125 = self.new_factor(pgm_rv125, pgm_rv0)
        pgm_factor126 = self.new_factor(pgm_rv126, pgm_rv0)
        pgm_factor127 = self.new_factor(pgm_rv127, pgm_rv0)
        pgm_factor128 = self.new_factor(pgm_rv128, pgm_rv0, pgm_rv79)
        pgm_factor129 = self.new_factor(pgm_rv129, pgm_rv0)
        pgm_factor130 = self.new_factor(pgm_rv130, pgm_rv0, pgm_rv91)
        pgm_factor131 = self.new_factor(pgm_rv131, pgm_rv0, pgm_rv87)
        pgm_factor132 = self.new_factor(pgm_rv132, pgm_rv0, pgm_rv8)
        pgm_factor133 = self.new_factor(pgm_rv133, pgm_rv0, pgm_rv70)
        pgm_factor134 = self.new_factor(pgm_rv134, pgm_rv0)

        pgm_function0 = pgm_factor0.set_dense()
        pgm_function0.set_flat(
            0.018279029,
            0.001370927,
            0.004569757,
            0.004569757,
            0.022848787,
            0.022848787,
            0.004569757,
            0.004569757,
            0.013709272,
            0.003655806,
            0.001827903,
            0.001827903,
            0.004569757,
            0.011424393,
            0.007311612,
            0.011698579,
            0.001827903,
            0.001827903,
            0.002741854,
            0.018279029,
            0.001827903,
            0.004569757,
            0.003655806,
            0.013709272,
            0.000456976,
            0.013709272,
            0.002284879,
            0.082255632,
            0.007311612,
            0.007311612,
            0.063976603,
            0.004569757,
            0.002741854,
            0.002741854,
            0.100534662,
            0.050267331,
            0.018279029,
            0.004569757,
            0.036558059,
            0.007311612,
            0.009139515,
            0.004569757,
            0.005483709,
            0.100534662,
            0.018279029,
            0.018279029,
            0.010967418,
            0.001827903,
            0.009139515,
            0.073116118,
            0.000913951,
            0.013709272,
            0.001827903,
            0.002741854,
            0.004569757,
            9.13951E-05,
            0.018279029,
            0.007311612,
            0.004569757,
            0.007311612,
            0.001827903,
            0.018279029,
            0.022848787,
            0.018279029,
            0.004569757,
            0.001827903,
            0.001827903,
            0.001827903,
            0.001827903,
            0.001827903,
            0.001827903,
            0.001827903,
            0.004569757,
            0.000228488,
            0.003655806,
            0.007311612,
        )

        pgm_function1 = pgm_factor1.set_dense()
        pgm_function1.set_flat(
            1.0, 0.1, 0.0, 0.0, 0.9,
            1.0
        )

        pgm_function2 = pgm_factor2.set_sparse()
        pgm_function2[(0, 0, 0)] = 1.0
        pgm_function2[(0, 1, 0)] = 1.0
        pgm_function2[(0, 2, 0)] = 1.0
        pgm_function2[(0, 3, 0)] = 1.0
        pgm_function2[(0, 4, 0)] = 1.0
        pgm_function2[(0, 5, 0)] = 1.0
        pgm_function2[(0, 6, 0)] = 1.0
        pgm_function2[(0, 7, 0)] = 1.0
        pgm_function2[(0, 8, 0)] = 1.0
        pgm_function2[(0, 9, 0)] = 1.0
        pgm_function2[(0, 10, 0)] = 1.0
        pgm_function2[(0, 11, 0)] = 1.0
        pgm_function2[(0, 12, 0)] = 1.0
        pgm_function2[(0, 13, 0)] = 1.0
        pgm_function2[(0, 14, 0)] = 1.0
        pgm_function2[(0, 15, 0)] = 1.0
        pgm_function2[(0, 16, 0)] = 1.0
        pgm_function2[(0, 17, 0)] = 1.0
        pgm_function2[(0, 18, 0)] = 1.0
        pgm_function2[(0, 19, 0)] = 1.0
        pgm_function2[(0, 20, 0)] = 1.0
        pgm_function2[(0, 21, 0)] = 1.0
        pgm_function2[(0, 22, 0)] = 1.0
        pgm_function2[(0, 23, 0)] = 1.0
        pgm_function2[(0, 24, 0)] = 1.0
        pgm_function2[(0, 25, 0)] = 1.0
        pgm_function2[(0, 26, 0)] = 1.0
        pgm_function2[(0, 27, 0)] = 1.0
        pgm_function2[(0, 28, 0)] = 1.0
        pgm_function2[(0, 29, 0)] = 1.0
        pgm_function2[(0, 30, 0)] = 1.0
        pgm_function2[(0, 31, 0)] = 1.0
        pgm_function2[(0, 32, 0)] = 1.0
        pgm_function2[(0, 33, 0)] = 1.0
        pgm_function2[(0, 34, 0)] = 1.0
        pgm_function2[(0, 35, 0)] = 1.0
        pgm_function2[(0, 36, 0)] = 1.0
        pgm_function2[(0, 37, 0)] = 1.0
        pgm_function2[(0, 38, 0)] = 1.0
        pgm_function2[(0, 39, 0)] = 1.0
        pgm_function2[(0, 40, 0)] = 1.0
        pgm_function2[(0, 41, 0)] = 1.0
        pgm_function2[(0, 42, 0)] = 1.0
        pgm_function2[(0, 43, 0)] = 1.0
        pgm_function2[(0, 44, 0)] = 1.0
        pgm_function2[(0, 45, 0)] = 1.0
        pgm_function2[(0, 46, 0)] = 1.0
        pgm_function2[(0, 47, 0)] = 1.0
        pgm_function2[(0, 48, 0)] = 1.0
        pgm_function2[(0, 49, 0)] = 1.0
        pgm_function2[(0, 50, 0)] = 1.0
        pgm_function2[(0, 51, 0)] = 1.0
        pgm_function2[(0, 52, 0)] = 1.0
        pgm_function2[(0, 53, 0)] = 1.0
        pgm_function2[(0, 54, 0)] = 1.0
        pgm_function2[(0, 55, 0)] = 1.0
        pgm_function2[(0, 56, 0)] = 1.0
        pgm_function2[(0, 57, 0)] = 1.0
        pgm_function2[(0, 58, 0)] = 1.0
        pgm_function2[(0, 59, 0)] = 1.0
        pgm_function2[(0, 60, 0)] = 1.0
        pgm_function2[(0, 61, 0)] = 1.0
        pgm_function2[(0, 62, 0)] = 1.0
        pgm_function2[(0, 63, 0)] = 1.0
        pgm_function2[(0, 64, 0)] = 1.0
        pgm_function2[(0, 65, 0)] = 1.0
        pgm_function2[(0, 66, 0)] = 1.0
        pgm_function2[(0, 67, 0)] = 1.0
        pgm_function2[(0, 68, 0)] = 1.0
        pgm_function2[(0, 69, 0)] = 1.0
        pgm_function2[(0, 70, 0)] = 1.0
        pgm_function2[(0, 71, 0)] = 1.0
        pgm_function2[(0, 72, 0)] = 1.0
        pgm_function2[(0, 73, 0)] = 1.0
        pgm_function2[(0, 74, 0)] = 1.0
        pgm_function2[(0, 75, 0)] = 1.0
        pgm_function2[(1, 0, 1)] = 0.9
        pgm_function2[(1, 0, 2)] = 0.9
        pgm_function2[(1, 0, 3)] = 0.9
        pgm_function2[(1, 0, 4)] = 0.9
        pgm_function2[(1, 1, 1)] = 0.3
        pgm_function2[(1, 1, 2)] = 0.3
        pgm_function2[(1, 1, 3)] = 0.3
        pgm_function2[(1, 1, 4)] = 0.3
        pgm_function2[(1, 2, 1)] = 0.9
        pgm_function2[(1, 2, 2)] = 0.9
        pgm_function2[(1, 2, 3)] = 0.9
        pgm_function2[(1, 2, 4)] = 0.9
        pgm_function2[(1, 3, 1)] = 0.9
        pgm_function2[(1, 3, 2)] = 0.9
        pgm_function2[(1, 3, 3)] = 0.9
        pgm_function2[(1, 3, 4)] = 0.9
        pgm_function2[(1, 4, 1)] = 0.9
        pgm_function2[(1, 4, 2)] = 0.9
        pgm_function2[(1, 4, 3)] = 0.9
        pgm_function2[(1, 4, 4)] = 0.9
        pgm_function2[(1, 5, 1)] = 0.9
        pgm_function2[(1, 5, 2)] = 0.9
        pgm_function2[(1, 5, 3)] = 0.9
        pgm_function2[(1, 5, 4)] = 0.9
        pgm_function2[(1, 7, 1)] = 0.9
        pgm_function2[(1, 7, 2)] = 0.9
        pgm_function2[(1, 7, 3)] = 0.9
        pgm_function2[(1, 7, 4)] = 0.9
        pgm_function2[(1, 8, 1)] = 0.9
        pgm_function2[(1, 8, 2)] = 0.9
        pgm_function2[(1, 8, 3)] = 0.9
        pgm_function2[(1, 8, 4)] = 0.9
        pgm_function2[(1, 9, 1)] = 0.9
        pgm_function2[(1, 9, 2)] = 0.9
        pgm_function2[(1, 9, 3)] = 0.9
        pgm_function2[(1, 9, 4)] = 0.9
        pgm_function2[(1, 10, 1)] = 0.9
        pgm_function2[(1, 10, 2)] = 0.9
        pgm_function2[(1, 10, 3)] = 0.9
        pgm_function2[(1, 10, 4)] = 0.9
        pgm_function2[(1, 11, 1)] = 0.9
        pgm_function2[(1, 11, 2)] = 0.9
        pgm_function2[(1, 11, 3)] = 0.9
        pgm_function2[(1, 11, 4)] = 0.9
        pgm_function2[(1, 12, 1)] = 0.9
        pgm_function2[(1, 12, 2)] = 0.9
        pgm_function2[(1, 12, 3)] = 0.9
        pgm_function2[(1, 12, 4)] = 0.9
        pgm_function2[(1, 13, 1)] = 0.2
        pgm_function2[(1, 13, 2)] = 0.2
        pgm_function2[(1, 13, 3)] = 0.2
        pgm_function2[(1, 13, 4)] = 0.2
        pgm_function2[(1, 14, 1)] = 0.9
        pgm_function2[(1, 14, 2)] = 0.9
        pgm_function2[(1, 14, 3)] = 0.9
        pgm_function2[(1, 14, 4)] = 0.9
        pgm_function2[(1, 15, 1)] = 0.9
        pgm_function2[(1, 15, 2)] = 0.9
        pgm_function2[(1, 15, 3)] = 0.9
        pgm_function2[(1, 15, 4)] = 0.9
        pgm_function2[(1, 16, 1)] = 0.9
        pgm_function2[(1, 16, 2)] = 0.9
        pgm_function2[(1, 16, 3)] = 0.9
        pgm_function2[(1, 16, 4)] = 0.9
        pgm_function2[(1, 17, 1)] = 0.9
        pgm_function2[(1, 17, 2)] = 0.9
        pgm_function2[(1, 17, 3)] = 0.9
        pgm_function2[(1, 17, 4)] = 0.9
        pgm_function2[(1, 18, 1)] = 0.9
        pgm_function2[(1, 18, 2)] = 0.9
        pgm_function2[(1, 18, 3)] = 0.9
        pgm_function2[(1, 18, 4)] = 0.9
        pgm_function2[(1, 19, 1)] = 0.9
        pgm_function2[(1, 19, 2)] = 0.9
        pgm_function2[(1, 19, 3)] = 0.9
        pgm_function2[(1, 19, 4)] = 0.9
        pgm_function2[(1, 20, 1)] = 0.9
        pgm_function2[(1, 20, 2)] = 0.9
        pgm_function2[(1, 20, 3)] = 0.9
        pgm_function2[(1, 20, 4)] = 0.9
        pgm_function2[(1, 21, 1)] = 0.9
        pgm_function2[(1, 21, 2)] = 0.9
        pgm_function2[(1, 21, 3)] = 0.9
        pgm_function2[(1, 21, 4)] = 0.9
        pgm_function2[(1, 22, 1)] = 0.9
        pgm_function2[(1, 22, 2)] = 0.9
        pgm_function2[(1, 22, 3)] = 0.9
        pgm_function2[(1, 22, 4)] = 0.9
        pgm_function2[(1, 23, 1)] = 0.9
        pgm_function2[(1, 23, 2)] = 0.9
        pgm_function2[(1, 23, 3)] = 0.9
        pgm_function2[(1, 23, 4)] = 0.9
        pgm_function2[(1, 24, 1)] = 0.9
        pgm_function2[(1, 24, 2)] = 0.9
        pgm_function2[(1, 24, 3)] = 0.9
        pgm_function2[(1, 24, 4)] = 0.9
        pgm_function2[(1, 25, 1)] = 0.9
        pgm_function2[(1, 25, 2)] = 0.9
        pgm_function2[(1, 25, 3)] = 0.9
        pgm_function2[(1, 25, 4)] = 0.9
        pgm_function2[(1, 26, 1)] = 0.9
        pgm_function2[(1, 26, 2)] = 0.9
        pgm_function2[(1, 26, 3)] = 0.9
        pgm_function2[(1, 26, 4)] = 0.9
        pgm_function2[(1, 27, 1)] = 0.9
        pgm_function2[(1, 27, 2)] = 0.9
        pgm_function2[(1, 27, 3)] = 0.9
        pgm_function2[(1, 27, 4)] = 0.9
        pgm_function2[(1, 28, 1)] = 0.9
        pgm_function2[(1, 28, 2)] = 0.9
        pgm_function2[(1, 28, 3)] = 0.9
        pgm_function2[(1, 28, 4)] = 0.9
        pgm_function2[(1, 29, 1)] = 0.9
        pgm_function2[(1, 29, 2)] = 0.9
        pgm_function2[(1, 29, 3)] = 0.9
        pgm_function2[(1, 29, 4)] = 0.9
        pgm_function2[(1, 30, 1)] = 0.9
        pgm_function2[(1, 30, 2)] = 0.9
        pgm_function2[(1, 30, 3)] = 0.9
        pgm_function2[(1, 30, 4)] = 0.9
        pgm_function2[(1, 31, 1)] = 0.9
        pgm_function2[(1, 31, 2)] = 0.9
        pgm_function2[(1, 31, 3)] = 0.9
        pgm_function2[(1, 31, 4)] = 0.9
        pgm_function2[(1, 32, 1)] = 0.9
        pgm_function2[(1, 32, 2)] = 0.9
        pgm_function2[(1, 32, 3)] = 0.9
        pgm_function2[(1, 32, 4)] = 0.9
        pgm_function2[(1, 33, 1)] = 0.9
        pgm_function2[(1, 33, 2)] = 0.9
        pgm_function2[(1, 33, 3)] = 0.9
        pgm_function2[(1, 33, 4)] = 0.9
        pgm_function2[(1, 34, 1)] = 0.999
        pgm_function2[(1, 34, 2)] = 0.999
        pgm_function2[(1, 34, 3)] = 0.999
        pgm_function2[(1, 34, 4)] = 0.999
        pgm_function2[(1, 35, 1)] = 0.999
        pgm_function2[(1, 35, 2)] = 0.999
        pgm_function2[(1, 35, 3)] = 0.999
        pgm_function2[(1, 35, 4)] = 0.999
        pgm_function2[(1, 36, 1)] = 0.999
        pgm_function2[(1, 36, 2)] = 0.999
        pgm_function2[(1, 36, 3)] = 0.999
        pgm_function2[(1, 36, 4)] = 0.999
        pgm_function2[(1, 37, 1)] = 0.999
        pgm_function2[(1, 37, 2)] = 0.999
        pgm_function2[(1, 37, 3)] = 0.999
        pgm_function2[(1, 37, 4)] = 0.999
        pgm_function2[(1, 38, 1)] = 0.9
        pgm_function2[(1, 38, 2)] = 0.9
        pgm_function2[(1, 38, 3)] = 0.9
        pgm_function2[(1, 38, 4)] = 0.9
        pgm_function2[(1, 39, 1)] = 0.9
        pgm_function2[(1, 39, 2)] = 0.9
        pgm_function2[(1, 39, 3)] = 0.9
        pgm_function2[(1, 39, 4)] = 0.9
        pgm_function2[(1, 40, 1)] = 0.1
        pgm_function2[(1, 40, 2)] = 0.1
        pgm_function2[(1, 40, 3)] = 0.1
        pgm_function2[(1, 40, 4)] = 0.1
        pgm_function2[(1, 41, 1)] = 0.9
        pgm_function2[(1, 41, 2)] = 0.9
        pgm_function2[(1, 41, 3)] = 0.9
        pgm_function2[(1, 41, 4)] = 0.9
        pgm_function2[(1, 42, 1)] = 0.9
        pgm_function2[(1, 42, 2)] = 0.9
        pgm_function2[(1, 42, 3)] = 0.9
        pgm_function2[(1, 42, 4)] = 0.9
        pgm_function2[(1, 43, 1)] = 0.9
        pgm_function2[(1, 43, 2)] = 0.9
        pgm_function2[(1, 43, 3)] = 0.9
        pgm_function2[(1, 43, 4)] = 0.9
        pgm_function2[(1, 44, 1)] = 0.9
        pgm_function2[(1, 44, 2)] = 0.9
        pgm_function2[(1, 44, 3)] = 0.9
        pgm_function2[(1, 44, 4)] = 0.9
        pgm_function2[(1, 45, 1)] = 0.9
        pgm_function2[(1, 45, 2)] = 0.9
        pgm_function2[(1, 45, 3)] = 0.9
        pgm_function2[(1, 45, 4)] = 0.9
        pgm_function2[(1, 46, 1)] = 0.3
        pgm_function2[(1, 46, 2)] = 0.3
        pgm_function2[(1, 46, 3)] = 0.3
        pgm_function2[(1, 46, 4)] = 0.3
        pgm_function2[(1, 47, 1)] = 0.9
        pgm_function2[(1, 47, 2)] = 0.9
        pgm_function2[(1, 47, 3)] = 0.9
        pgm_function2[(1, 47, 4)] = 0.9
        pgm_function2[(1, 48, 1)] = 0.9
        pgm_function2[(1, 48, 2)] = 0.9
        pgm_function2[(1, 48, 3)] = 0.9
        pgm_function2[(1, 48, 4)] = 0.9
        pgm_function2[(1, 49, 1)] = 0.9
        pgm_function2[(1, 49, 2)] = 0.9
        pgm_function2[(1, 49, 3)] = 0.9
        pgm_function2[(1, 49, 4)] = 0.9
        pgm_function2[(1, 50, 1)] = 0.9
        pgm_function2[(1, 50, 2)] = 0.9
        pgm_function2[(1, 50, 3)] = 0.9
        pgm_function2[(1, 50, 4)] = 0.9
        pgm_function2[(1, 51, 1)] = 0.9
        pgm_function2[(1, 51, 2)] = 0.9
        pgm_function2[(1, 51, 3)] = 0.9
        pgm_function2[(1, 51, 4)] = 0.9
        pgm_function2[(1, 52, 1)] = 0.9
        pgm_function2[(1, 52, 2)] = 0.9
        pgm_function2[(1, 52, 3)] = 0.9
        pgm_function2[(1, 52, 4)] = 0.9
        pgm_function2[(1, 53, 1)] = 0.9
        pgm_function2[(1, 53, 2)] = 0.9
        pgm_function2[(1, 53, 3)] = 0.9
        pgm_function2[(1, 53, 4)] = 0.9
        pgm_function2[(1, 54, 1)] = 0.9
        pgm_function2[(1, 54, 2)] = 0.9
        pgm_function2[(1, 54, 3)] = 0.9
        pgm_function2[(1, 54, 4)] = 0.9
        pgm_function2[(1, 55, 1)] = 0.9
        pgm_function2[(1, 55, 2)] = 0.9
        pgm_function2[(1, 55, 3)] = 0.9
        pgm_function2[(1, 55, 4)] = 0.9
        pgm_function2[(1, 56, 1)] = 0.9
        pgm_function2[(1, 56, 2)] = 0.9
        pgm_function2[(1, 56, 3)] = 0.9
        pgm_function2[(1, 56, 4)] = 0.9
        pgm_function2[(1, 57, 1)] = 0.9
        pgm_function2[(1, 57, 2)] = 0.9
        pgm_function2[(1, 57, 3)] = 0.9
        pgm_function2[(1, 57, 4)] = 0.9
        pgm_function2[(1, 58, 1)] = 0.9
        pgm_function2[(1, 58, 2)] = 0.9
        pgm_function2[(1, 58, 3)] = 0.9
        pgm_function2[(1, 58, 4)] = 0.9
        pgm_function2[(1, 59, 1)] = 0.8
        pgm_function2[(1, 59, 2)] = 0.8
        pgm_function2[(1, 59, 3)] = 0.8
        pgm_function2[(1, 59, 4)] = 0.8
        pgm_function2[(1, 60, 1)] = 0.9
        pgm_function2[(1, 60, 2)] = 0.9
        pgm_function2[(1, 60, 3)] = 0.9
        pgm_function2[(1, 60, 4)] = 0.9
        pgm_function2[(1, 61, 1)] = 0.1
        pgm_function2[(1, 61, 2)] = 0.1
        pgm_function2[(1, 61, 3)] = 0.1
        pgm_function2[(1, 61, 4)] = 0.1
        pgm_function2[(1, 62, 1)] = 0.9
        pgm_function2[(1, 62, 2)] = 0.9
        pgm_function2[(1, 62, 3)] = 0.9
        pgm_function2[(1, 62, 4)] = 0.9
        pgm_function2[(1, 63, 1)] = 0.9
        pgm_function2[(1, 63, 2)] = 0.9
        pgm_function2[(1, 63, 3)] = 0.9
        pgm_function2[(1, 63, 4)] = 0.9
        pgm_function2[(1, 64, 1)] = 0.9
        pgm_function2[(1, 64, 2)] = 0.9
        pgm_function2[(1, 64, 3)] = 0.9
        pgm_function2[(1, 64, 4)] = 0.9
        pgm_function2[(1, 65, 1)] = 0.9
        pgm_function2[(1, 65, 2)] = 0.9
        pgm_function2[(1, 65, 3)] = 0.9
        pgm_function2[(1, 65, 4)] = 0.9
        pgm_function2[(1, 66, 1)] = 0.9
        pgm_function2[(1, 66, 2)] = 0.9
        pgm_function2[(1, 66, 3)] = 0.9
        pgm_function2[(1, 66, 4)] = 0.9
        pgm_function2[(1, 67, 1)] = 0.8
        pgm_function2[(1, 67, 2)] = 0.8
        pgm_function2[(1, 67, 3)] = 0.8
        pgm_function2[(1, 67, 4)] = 0.8
        pgm_function2[(1, 68, 1)] = 0.9
        pgm_function2[(1, 68, 2)] = 0.9
        pgm_function2[(1, 68, 3)] = 0.9
        pgm_function2[(1, 68, 4)] = 0.9
        pgm_function2[(1, 69, 1)] = 0.9
        pgm_function2[(1, 69, 2)] = 0.9
        pgm_function2[(1, 69, 3)] = 0.9
        pgm_function2[(1, 69, 4)] = 0.9
        pgm_function2[(1, 70, 1)] = 0.8
        pgm_function2[(1, 70, 2)] = 0.8
        pgm_function2[(1, 70, 3)] = 0.8
        pgm_function2[(1, 70, 4)] = 0.8
        pgm_function2[(1, 71, 1)] = 0.8
        pgm_function2[(1, 71, 2)] = 0.8
        pgm_function2[(1, 71, 3)] = 0.8
        pgm_function2[(1, 71, 4)] = 0.8
        pgm_function2[(1, 72, 1)] = 0.8
        pgm_function2[(1, 72, 2)] = 0.8
        pgm_function2[(1, 72, 3)] = 0.8
        pgm_function2[(1, 72, 4)] = 0.8
        pgm_function2[(1, 73, 1)] = 0.9
        pgm_function2[(1, 73, 2)] = 0.9
        pgm_function2[(1, 73, 3)] = 0.9
        pgm_function2[(1, 73, 4)] = 0.9
        pgm_function2[(1, 74, 1)] = 0.9
        pgm_function2[(1, 74, 2)] = 0.9
        pgm_function2[(1, 74, 3)] = 0.9
        pgm_function2[(1, 74, 4)] = 0.9
        pgm_function2[(1, 75, 1)] = 0.1
        pgm_function2[(1, 75, 2)] = 0.1
        pgm_function2[(1, 75, 3)] = 0.1
        pgm_function2[(1, 75, 4)] = 0.1
        pgm_function2[(2, 0, 1)] = 0.1
        pgm_function2[(2, 0, 2)] = 0.1
        pgm_function2[(2, 0, 3)] = 0.1
        pgm_function2[(2, 0, 4)] = 0.1
        pgm_function2[(2, 1, 1)] = 0.7
        pgm_function2[(2, 1, 2)] = 0.7
        pgm_function2[(2, 1, 3)] = 0.7
        pgm_function2[(2, 1, 4)] = 0.7
        pgm_function2[(2, 2, 1)] = 0.1
        pgm_function2[(2, 2, 2)] = 0.1
        pgm_function2[(2, 2, 3)] = 0.1
        pgm_function2[(2, 2, 4)] = 0.1
        pgm_function2[(2, 3, 1)] = 0.1
        pgm_function2[(2, 3, 2)] = 0.1
        pgm_function2[(2, 3, 3)] = 0.1
        pgm_function2[(2, 3, 4)] = 0.1
        pgm_function2[(2, 4, 1)] = 0.1
        pgm_function2[(2, 4, 2)] = 0.1
        pgm_function2[(2, 4, 3)] = 0.1
        pgm_function2[(2, 4, 4)] = 0.1
        pgm_function2[(2, 5, 1)] = 0.1
        pgm_function2[(2, 5, 2)] = 0.1
        pgm_function2[(2, 5, 3)] = 0.1
        pgm_function2[(2, 5, 4)] = 0.1
        pgm_function2[(2, 6, 1)] = 1.0
        pgm_function2[(2, 6, 2)] = 1.0
        pgm_function2[(2, 6, 3)] = 1.0
        pgm_function2[(2, 6, 4)] = 1.0
        pgm_function2[(2, 7, 1)] = 0.1
        pgm_function2[(2, 7, 2)] = 0.1
        pgm_function2[(2, 7, 3)] = 0.1
        pgm_function2[(2, 7, 4)] = 0.1
        pgm_function2[(2, 8, 1)] = 0.1
        pgm_function2[(2, 8, 2)] = 0.1
        pgm_function2[(2, 8, 3)] = 0.1
        pgm_function2[(2, 8, 4)] = 0.1
        pgm_function2[(2, 9, 1)] = 0.1
        pgm_function2[(2, 9, 2)] = 0.1
        pgm_function2[(2, 9, 3)] = 0.1
        pgm_function2[(2, 9, 4)] = 0.1
        pgm_function2[(2, 10, 1)] = 0.1
        pgm_function2[(2, 10, 2)] = 0.1
        pgm_function2[(2, 10, 3)] = 0.1
        pgm_function2[(2, 10, 4)] = 0.1
        pgm_function2[(2, 11, 1)] = 0.1
        pgm_function2[(2, 11, 2)] = 0.1
        pgm_function2[(2, 11, 3)] = 0.1
        pgm_function2[(2, 11, 4)] = 0.1
        pgm_function2[(2, 12, 1)] = 0.1
        pgm_function2[(2, 12, 2)] = 0.1
        pgm_function2[(2, 12, 3)] = 0.1
        pgm_function2[(2, 12, 4)] = 0.1
        pgm_function2[(2, 13, 1)] = 0.8
        pgm_function2[(2, 13, 2)] = 0.8
        pgm_function2[(2, 13, 3)] = 0.8
        pgm_function2[(2, 13, 4)] = 0.8
        pgm_function2[(2, 14, 1)] = 0.1
        pgm_function2[(2, 14, 2)] = 0.1
        pgm_function2[(2, 14, 3)] = 0.1
        pgm_function2[(2, 14, 4)] = 0.1
        pgm_function2[(2, 15, 1)] = 0.1
        pgm_function2[(2, 15, 2)] = 0.1
        pgm_function2[(2, 15, 3)] = 0.1
        pgm_function2[(2, 15, 4)] = 0.1
        pgm_function2[(2, 16, 1)] = 0.1
        pgm_function2[(2, 16, 2)] = 0.1
        pgm_function2[(2, 16, 3)] = 0.1
        pgm_function2[(2, 16, 4)] = 0.1
        pgm_function2[(2, 17, 1)] = 0.1
        pgm_function2[(2, 17, 2)] = 0.1
        pgm_function2[(2, 17, 3)] = 0.1
        pgm_function2[(2, 17, 4)] = 0.1
        pgm_function2[(2, 18, 1)] = 0.1
        pgm_function2[(2, 18, 2)] = 0.1
        pgm_function2[(2, 18, 3)] = 0.1
        pgm_function2[(2, 18, 4)] = 0.1
        pgm_function2[(2, 19, 1)] = 0.1
        pgm_function2[(2, 19, 2)] = 0.1
        pgm_function2[(2, 19, 3)] = 0.1
        pgm_function2[(2, 19, 4)] = 0.1
        pgm_function2[(2, 20, 1)] = 0.1
        pgm_function2[(2, 20, 2)] = 0.1
        pgm_function2[(2, 20, 3)] = 0.1
        pgm_function2[(2, 20, 4)] = 0.1
        pgm_function2[(2, 21, 1)] = 0.1
        pgm_function2[(2, 21, 2)] = 0.1
        pgm_function2[(2, 21, 3)] = 0.1
        pgm_function2[(2, 21, 4)] = 0.1
        pgm_function2[(2, 22, 1)] = 0.1
        pgm_function2[(2, 22, 2)] = 0.1
        pgm_function2[(2, 22, 3)] = 0.1
        pgm_function2[(2, 22, 4)] = 0.1
        pgm_function2[(2, 23, 1)] = 0.1
        pgm_function2[(2, 23, 2)] = 0.1
        pgm_function2[(2, 23, 3)] = 0.1
        pgm_function2[(2, 23, 4)] = 0.1
        pgm_function2[(2, 24, 1)] = 0.1
        pgm_function2[(2, 24, 2)] = 0.1
        pgm_function2[(2, 24, 3)] = 0.1
        pgm_function2[(2, 24, 4)] = 0.1
        pgm_function2[(2, 25, 1)] = 0.1
        pgm_function2[(2, 25, 2)] = 0.1
        pgm_function2[(2, 25, 3)] = 0.1
        pgm_function2[(2, 25, 4)] = 0.1
        pgm_function2[(2, 26, 1)] = 0.1
        pgm_function2[(2, 26, 2)] = 0.1
        pgm_function2[(2, 26, 3)] = 0.1
        pgm_function2[(2, 26, 4)] = 0.1
        pgm_function2[(2, 27, 1)] = 0.1
        pgm_function2[(2, 27, 2)] = 0.1
        pgm_function2[(2, 27, 3)] = 0.1
        pgm_function2[(2, 27, 4)] = 0.1
        pgm_function2[(2, 28, 1)] = 0.1
        pgm_function2[(2, 28, 2)] = 0.1
        pgm_function2[(2, 28, 3)] = 0.1
        pgm_function2[(2, 28, 4)] = 0.1
        pgm_function2[(2, 29, 1)] = 0.1
        pgm_function2[(2, 29, 2)] = 0.1
        pgm_function2[(2, 29, 3)] = 0.1
        pgm_function2[(2, 29, 4)] = 0.1
        pgm_function2[(2, 30, 1)] = 0.1
        pgm_function2[(2, 30, 2)] = 0.1
        pgm_function2[(2, 30, 3)] = 0.1
        pgm_function2[(2, 30, 4)] = 0.1
        pgm_function2[(2, 31, 1)] = 0.1
        pgm_function2[(2, 31, 2)] = 0.1
        pgm_function2[(2, 31, 3)] = 0.1
        pgm_function2[(2, 31, 4)] = 0.1
        pgm_function2[(2, 32, 1)] = 0.1
        pgm_function2[(2, 32, 2)] = 0.1
        pgm_function2[(2, 32, 3)] = 0.1
        pgm_function2[(2, 32, 4)] = 0.1
        pgm_function2[(2, 33, 1)] = 0.1
        pgm_function2[(2, 33, 2)] = 0.1
        pgm_function2[(2, 33, 3)] = 0.1
        pgm_function2[(2, 33, 4)] = 0.1
        pgm_function2[(2, 34, 1)] = 0.001
        pgm_function2[(2, 34, 2)] = 0.001
        pgm_function2[(2, 34, 3)] = 0.001
        pgm_function2[(2, 34, 4)] = 0.001
        pgm_function2[(2, 35, 1)] = 0.001
        pgm_function2[(2, 35, 2)] = 0.001
        pgm_function2[(2, 35, 3)] = 0.001
        pgm_function2[(2, 35, 4)] = 0.001
        pgm_function2[(2, 36, 1)] = 0.001
        pgm_function2[(2, 36, 2)] = 0.001
        pgm_function2[(2, 36, 3)] = 0.001
        pgm_function2[(2, 36, 4)] = 0.001
        pgm_function2[(2, 37, 1)] = 0.001
        pgm_function2[(2, 37, 2)] = 0.001
        pgm_function2[(2, 37, 3)] = 0.001
        pgm_function2[(2, 37, 4)] = 0.001
        pgm_function2[(2, 38, 1)] = 0.1
        pgm_function2[(2, 38, 2)] = 0.1
        pgm_function2[(2, 38, 3)] = 0.1
        pgm_function2[(2, 38, 4)] = 0.1
        pgm_function2[(2, 39, 1)] = 0.1
        pgm_function2[(2, 39, 2)] = 0.1
        pgm_function2[(2, 39, 3)] = 0.1
        pgm_function2[(2, 39, 4)] = 0.1
        pgm_function2[(2, 40, 1)] = 0.9
        pgm_function2[(2, 40, 2)] = 0.9
        pgm_function2[(2, 40, 3)] = 0.9
        pgm_function2[(2, 40, 4)] = 0.9
        pgm_function2[(2, 41, 1)] = 0.1
        pgm_function2[(2, 41, 2)] = 0.1
        pgm_function2[(2, 41, 3)] = 0.1
        pgm_function2[(2, 41, 4)] = 0.1
        pgm_function2[(2, 42, 1)] = 0.1
        pgm_function2[(2, 42, 2)] = 0.1
        pgm_function2[(2, 42, 3)] = 0.1
        pgm_function2[(2, 42, 4)] = 0.1
        pgm_function2[(2, 43, 1)] = 0.1
        pgm_function2[(2, 43, 2)] = 0.1
        pgm_function2[(2, 43, 3)] = 0.1
        pgm_function2[(2, 43, 4)] = 0.1
        pgm_function2[(2, 44, 1)] = 0.1
        pgm_function2[(2, 44, 2)] = 0.1
        pgm_function2[(2, 44, 3)] = 0.1
        pgm_function2[(2, 44, 4)] = 0.1
        pgm_function2[(2, 45, 1)] = 0.1
        pgm_function2[(2, 45, 2)] = 0.1
        pgm_function2[(2, 45, 3)] = 0.1
        pgm_function2[(2, 45, 4)] = 0.1
        pgm_function2[(2, 46, 1)] = 0.7
        pgm_function2[(2, 46, 2)] = 0.7
        pgm_function2[(2, 46, 3)] = 0.7
        pgm_function2[(2, 46, 4)] = 0.7
        pgm_function2[(2, 47, 1)] = 0.1
        pgm_function2[(2, 47, 2)] = 0.1
        pgm_function2[(2, 47, 3)] = 0.1
        pgm_function2[(2, 47, 4)] = 0.1
        pgm_function2[(2, 48, 1)] = 0.1
        pgm_function2[(2, 48, 2)] = 0.1
        pgm_function2[(2, 48, 3)] = 0.1
        pgm_function2[(2, 48, 4)] = 0.1
        pgm_function2[(2, 49, 1)] = 0.1
        pgm_function2[(2, 49, 2)] = 0.1
        pgm_function2[(2, 49, 3)] = 0.1
        pgm_function2[(2, 49, 4)] = 0.1
        pgm_function2[(2, 50, 1)] = 0.1
        pgm_function2[(2, 50, 2)] = 0.1
        pgm_function2[(2, 50, 3)] = 0.1
        pgm_function2[(2, 50, 4)] = 0.1
        pgm_function2[(2, 51, 1)] = 0.1
        pgm_function2[(2, 51, 2)] = 0.1
        pgm_function2[(2, 51, 3)] = 0.1
        pgm_function2[(2, 51, 4)] = 0.1
        pgm_function2[(2, 52, 1)] = 0.1
        pgm_function2[(2, 52, 2)] = 0.1
        pgm_function2[(2, 52, 3)] = 0.1
        pgm_function2[(2, 52, 4)] = 0.1
        pgm_function2[(2, 53, 1)] = 0.1
        pgm_function2[(2, 53, 2)] = 0.1
        pgm_function2[(2, 53, 3)] = 0.1
        pgm_function2[(2, 53, 4)] = 0.1
        pgm_function2[(2, 54, 1)] = 0.1
        pgm_function2[(2, 54, 2)] = 0.1
        pgm_function2[(2, 54, 3)] = 0.1
        pgm_function2[(2, 54, 4)] = 0.1
        pgm_function2[(2, 55, 1)] = 0.1
        pgm_function2[(2, 55, 2)] = 0.1
        pgm_function2[(2, 55, 3)] = 0.1
        pgm_function2[(2, 55, 4)] = 0.1
        pgm_function2[(2, 56, 1)] = 0.1
        pgm_function2[(2, 56, 2)] = 0.1
        pgm_function2[(2, 56, 3)] = 0.1
        pgm_function2[(2, 56, 4)] = 0.1
        pgm_function2[(2, 57, 1)] = 0.1
        pgm_function2[(2, 57, 2)] = 0.1
        pgm_function2[(2, 57, 3)] = 0.1
        pgm_function2[(2, 57, 4)] = 0.1
        pgm_function2[(2, 58, 1)] = 0.1
        pgm_function2[(2, 58, 2)] = 0.1
        pgm_function2[(2, 58, 3)] = 0.1
        pgm_function2[(2, 58, 4)] = 0.1
        pgm_function2[(2, 59, 1)] = 0.2
        pgm_function2[(2, 59, 2)] = 0.2
        pgm_function2[(2, 59, 3)] = 0.2
        pgm_function2[(2, 59, 4)] = 0.2
        pgm_function2[(2, 60, 1)] = 0.1
        pgm_function2[(2, 60, 2)] = 0.1
        pgm_function2[(2, 60, 3)] = 0.1
        pgm_function2[(2, 60, 4)] = 0.1
        pgm_function2[(2, 61, 1)] = 0.9
        pgm_function2[(2, 61, 2)] = 0.9
        pgm_function2[(2, 61, 3)] = 0.9
        pgm_function2[(2, 61, 4)] = 0.9
        pgm_function2[(2, 62, 1)] = 0.1
        pgm_function2[(2, 62, 2)] = 0.1
        pgm_function2[(2, 62, 3)] = 0.1
        pgm_function2[(2, 62, 4)] = 0.1
        pgm_function2[(2, 63, 1)] = 0.1
        pgm_function2[(2, 63, 2)] = 0.1
        pgm_function2[(2, 63, 3)] = 0.1
        pgm_function2[(2, 63, 4)] = 0.1
        pgm_function2[(2, 64, 1)] = 0.1
        pgm_function2[(2, 64, 2)] = 0.1
        pgm_function2[(2, 64, 3)] = 0.1
        pgm_function2[(2, 64, 4)] = 0.1
        pgm_function2[(2, 65, 1)] = 0.1
        pgm_function2[(2, 65, 2)] = 0.1
        pgm_function2[(2, 65, 3)] = 0.1
        pgm_function2[(2, 65, 4)] = 0.1
        pgm_function2[(2, 66, 1)] = 0.1
        pgm_function2[(2, 66, 2)] = 0.1
        pgm_function2[(2, 66, 3)] = 0.1
        pgm_function2[(2, 66, 4)] = 0.1
        pgm_function2[(2, 67, 1)] = 0.2
        pgm_function2[(2, 67, 2)] = 0.2
        pgm_function2[(2, 67, 3)] = 0.2
        pgm_function2[(2, 67, 4)] = 0.2
        pgm_function2[(2, 68, 1)] = 0.1
        pgm_function2[(2, 68, 2)] = 0.1
        pgm_function2[(2, 68, 3)] = 0.1
        pgm_function2[(2, 68, 4)] = 0.1
        pgm_function2[(2, 69, 1)] = 0.1
        pgm_function2[(2, 69, 2)] = 0.1
        pgm_function2[(2, 69, 3)] = 0.1
        pgm_function2[(2, 69, 4)] = 0.1
        pgm_function2[(2, 70, 1)] = 0.2
        pgm_function2[(2, 70, 2)] = 0.2
        pgm_function2[(2, 70, 3)] = 0.2
        pgm_function2[(2, 70, 4)] = 0.2
        pgm_function2[(2, 71, 1)] = 0.2
        pgm_function2[(2, 71, 2)] = 0.2
        pgm_function2[(2, 71, 3)] = 0.2
        pgm_function2[(2, 71, 4)] = 0.2
        pgm_function2[(2, 72, 1)] = 0.2
        pgm_function2[(2, 72, 2)] = 0.2
        pgm_function2[(2, 72, 3)] = 0.2
        pgm_function2[(2, 72, 4)] = 0.2
        pgm_function2[(2, 73, 1)] = 0.1
        pgm_function2[(2, 73, 2)] = 0.1
        pgm_function2[(2, 73, 3)] = 0.1
        pgm_function2[(2, 73, 4)] = 0.1
        pgm_function2[(2, 74, 1)] = 0.1
        pgm_function2[(2, 74, 2)] = 0.1
        pgm_function2[(2, 74, 3)] = 0.1
        pgm_function2[(2, 74, 4)] = 0.1
        pgm_function2[(2, 75, 1)] = 0.9
        pgm_function2[(2, 75, 2)] = 0.9
        pgm_function2[(2, 75, 3)] = 0.9
        pgm_function2[(2, 75, 4)] = 0.9

        pgm_function3 = pgm_factor3.set_sparse()
        pgm_function3[(0, 0, 0)] = 1.0
        pgm_function3[(0, 1, 0)] = 1.0
        pgm_function3[(0, 2, 0)] = 1.0
        pgm_function3[(0, 3, 0)] = 1.0
        pgm_function3[(0, 4, 0)] = 1.0
        pgm_function3[(0, 5, 0)] = 1.0
        pgm_function3[(0, 6, 0)] = 1.0
        pgm_function3[(0, 7, 0)] = 1.0
        pgm_function3[(0, 8, 0)] = 1.0
        pgm_function3[(0, 9, 0)] = 1.0
        pgm_function3[(0, 10, 0)] = 1.0
        pgm_function3[(0, 11, 0)] = 1.0
        pgm_function3[(0, 12, 0)] = 1.0
        pgm_function3[(0, 13, 0)] = 1.0
        pgm_function3[(0, 14, 0)] = 1.0
        pgm_function3[(0, 15, 0)] = 1.0
        pgm_function3[(0, 16, 0)] = 1.0
        pgm_function3[(0, 17, 0)] = 1.0
        pgm_function3[(0, 18, 0)] = 1.0
        pgm_function3[(0, 19, 0)] = 1.0
        pgm_function3[(0, 20, 0)] = 1.0
        pgm_function3[(0, 21, 0)] = 1.0
        pgm_function3[(0, 22, 0)] = 1.0
        pgm_function3[(0, 23, 0)] = 1.0
        pgm_function3[(0, 24, 0)] = 1.0
        pgm_function3[(0, 25, 0)] = 1.0
        pgm_function3[(0, 26, 0)] = 1.0
        pgm_function3[(0, 27, 0)] = 1.0
        pgm_function3[(0, 28, 0)] = 1.0
        pgm_function3[(0, 29, 0)] = 1.0
        pgm_function3[(0, 30, 0)] = 1.0
        pgm_function3[(0, 31, 0)] = 1.0
        pgm_function3[(0, 32, 0)] = 1.0
        pgm_function3[(0, 33, 0)] = 1.0
        pgm_function3[(0, 34, 0)] = 1.0
        pgm_function3[(0, 35, 0)] = 1.0
        pgm_function3[(0, 36, 0)] = 1.0
        pgm_function3[(0, 37, 0)] = 1.0
        pgm_function3[(0, 38, 0)] = 1.0
        pgm_function3[(0, 39, 0)] = 1.0
        pgm_function3[(0, 40, 0)] = 1.0
        pgm_function3[(0, 41, 0)] = 1.0
        pgm_function3[(0, 42, 0)] = 1.0
        pgm_function3[(0, 43, 0)] = 1.0
        pgm_function3[(0, 44, 0)] = 1.0
        pgm_function3[(0, 45, 0)] = 1.0
        pgm_function3[(0, 46, 0)] = 1.0
        pgm_function3[(0, 47, 0)] = 1.0
        pgm_function3[(0, 48, 0)] = 1.0
        pgm_function3[(0, 49, 0)] = 1.0
        pgm_function3[(0, 50, 0)] = 1.0
        pgm_function3[(0, 51, 0)] = 1.0
        pgm_function3[(0, 52, 0)] = 1.0
        pgm_function3[(0, 53, 0)] = 1.0
        pgm_function3[(0, 54, 0)] = 1.0
        pgm_function3[(0, 55, 0)] = 1.0
        pgm_function3[(0, 56, 0)] = 1.0
        pgm_function3[(0, 57, 0)] = 1.0
        pgm_function3[(0, 58, 0)] = 1.0
        pgm_function3[(0, 59, 0)] = 1.0
        pgm_function3[(0, 60, 0)] = 1.0
        pgm_function3[(0, 61, 0)] = 1.0
        pgm_function3[(0, 62, 0)] = 1.0
        pgm_function3[(0, 63, 0)] = 1.0
        pgm_function3[(0, 64, 0)] = 1.0
        pgm_function3[(0, 65, 0)] = 1.0
        pgm_function3[(0, 66, 0)] = 1.0
        pgm_function3[(0, 67, 0)] = 1.0
        pgm_function3[(0, 68, 0)] = 1.0
        pgm_function3[(0, 69, 0)] = 1.0
        pgm_function3[(0, 70, 0)] = 1.0
        pgm_function3[(0, 71, 0)] = 1.0
        pgm_function3[(0, 72, 0)] = 1.0
        pgm_function3[(0, 73, 0)] = 1.0
        pgm_function3[(0, 74, 0)] = 1.0
        pgm_function3[(0, 75, 0)] = 1.0
        pgm_function3[(1, 0, 1)] = 0.8
        pgm_function3[(1, 0, 2)] = 0.7
        pgm_function3[(1, 1, 1)] = 0.99
        pgm_function3[(1, 1, 2)] = 0.99
        pgm_function3[(1, 2, 1)] = 0.99
        pgm_function3[(1, 2, 2)] = 0.99
        pgm_function3[(1, 3, 1)] = 0.99
        pgm_function3[(1, 3, 2)] = 0.99
        pgm_function3[(1, 4, 1)] = 0.99
        pgm_function3[(1, 4, 2)] = 0.99
        pgm_function3[(1, 5, 1)] = 0.95
        pgm_function3[(1, 5, 2)] = 0.9
        pgm_function3[(1, 6, 1)] = 0.99
        pgm_function3[(1, 6, 2)] = 0.99
        pgm_function3[(1, 7, 1)] = 0.99
        pgm_function3[(1, 7, 2)] = 0.99
        pgm_function3[(1, 8, 1)] = 0.99
        pgm_function3[(1, 8, 2)] = 0.99
        pgm_function3[(1, 9, 1)] = 0.99
        pgm_function3[(1, 9, 2)] = 0.99
        pgm_function3[(1, 10, 1)] = 0.99
        pgm_function3[(1, 10, 2)] = 0.99
        pgm_function3[(1, 11, 1)] = 0.99
        pgm_function3[(1, 11, 2)] = 0.99
        pgm_function3[(1, 12, 1)] = 0.99
        pgm_function3[(1, 12, 2)] = 0.99
        pgm_function3[(1, 13, 1)] = 0.99
        pgm_function3[(1, 13, 2)] = 0.99
        pgm_function3[(1, 14, 1)] = 0.99
        pgm_function3[(1, 14, 2)] = 0.99
        pgm_function3[(1, 15, 1)] = 0.99
        pgm_function3[(1, 15, 2)] = 0.99
        pgm_function3[(1, 16, 1)] = 0.99
        pgm_function3[(1, 16, 2)] = 0.99
        pgm_function3[(1, 17, 1)] = 0.99
        pgm_function3[(1, 17, 2)] = 0.99
        pgm_function3[(1, 18, 1)] = 0.99
        pgm_function3[(1, 18, 2)] = 0.99
        pgm_function3[(1, 19, 1)] = 0.99
        pgm_function3[(1, 19, 2)] = 0.99
        pgm_function3[(1, 20, 1)] = 0.99
        pgm_function3[(1, 20, 2)] = 0.99
        pgm_function3[(1, 21, 1)] = 0.99
        pgm_function3[(1, 21, 2)] = 0.99
        pgm_function3[(1, 22, 1)] = 0.99
        pgm_function3[(1, 22, 2)] = 0.99
        pgm_function3[(1, 23, 1)] = 0.99
        pgm_function3[(1, 23, 2)] = 0.99
        pgm_function3[(1, 24, 1)] = 0.99
        pgm_function3[(1, 24, 2)] = 0.99
        pgm_function3[(1, 25, 1)] = 0.99
        pgm_function3[(1, 25, 2)] = 0.99
        pgm_function3[(1, 26, 1)] = 0.99
        pgm_function3[(1, 26, 2)] = 0.99
        pgm_function3[(1, 27, 1)] = 0.99
        pgm_function3[(1, 27, 2)] = 0.99
        pgm_function3[(1, 28, 1)] = 0.99
        pgm_function3[(1, 28, 2)] = 0.99
        pgm_function3[(1, 29, 1)] = 0.99
        pgm_function3[(1, 29, 2)] = 0.99
        pgm_function3[(1, 30, 1)] = 0.99
        pgm_function3[(1, 30, 2)] = 0.99
        pgm_function3[(1, 31, 1)] = 0.99
        pgm_function3[(1, 31, 2)] = 0.99
        pgm_function3[(1, 32, 1)] = 0.99
        pgm_function3[(1, 32, 2)] = 0.99
        pgm_function3[(1, 33, 1)] = 0.99
        pgm_function3[(1, 33, 2)] = 0.99
        pgm_function3[(1, 34, 1)] = 0.99
        pgm_function3[(1, 34, 2)] = 0.99
        pgm_function3[(1, 35, 1)] = 0.99
        pgm_function3[(1, 35, 2)] = 0.99
        pgm_function3[(1, 36, 1)] = 0.99
        pgm_function3[(1, 36, 2)] = 0.99
        pgm_function3[(1, 37, 1)] = 0.99
        pgm_function3[(1, 37, 2)] = 0.99
        pgm_function3[(1, 38, 1)] = 0.99
        pgm_function3[(1, 38, 2)] = 0.99
        pgm_function3[(1, 39, 1)] = 0.99
        pgm_function3[(1, 39, 2)] = 0.99
        pgm_function3[(1, 40, 1)] = 0.99
        pgm_function3[(1, 40, 2)] = 0.99
        pgm_function3[(1, 41, 1)] = 0.99
        pgm_function3[(1, 41, 2)] = 0.99
        pgm_function3[(1, 42, 1)] = 0.99
        pgm_function3[(1, 42, 2)] = 0.99
        pgm_function3[(1, 43, 1)] = 0.99
        pgm_function3[(1, 43, 2)] = 0.99
        pgm_function3[(1, 44, 1)] = 0.99
        pgm_function3[(1, 44, 2)] = 0.99
        pgm_function3[(1, 45, 1)] = 0.99
        pgm_function3[(1, 45, 2)] = 0.99
        pgm_function3[(1, 46, 1)] = 0.99
        pgm_function3[(1, 46, 2)] = 0.99
        pgm_function3[(1, 47, 1)] = 0.99
        pgm_function3[(1, 47, 2)] = 0.99
        pgm_function3[(1, 48, 1)] = 0.99
        pgm_function3[(1, 48, 2)] = 0.99
        pgm_function3[(1, 49, 1)] = 0.99
        pgm_function3[(1, 49, 2)] = 0.99
        pgm_function3[(1, 50, 1)] = 0.99
        pgm_function3[(1, 50, 2)] = 0.99
        pgm_function3[(1, 51, 1)] = 0.99
        pgm_function3[(1, 51, 2)] = 0.99
        pgm_function3[(1, 52, 1)] = 0.99
        pgm_function3[(1, 52, 2)] = 0.99
        pgm_function3[(1, 53, 1)] = 0.99
        pgm_function3[(1, 53, 2)] = 0.99
        pgm_function3[(1, 54, 1)] = 0.99
        pgm_function3[(1, 54, 2)] = 0.99
        pgm_function3[(1, 55, 1)] = 0.99
        pgm_function3[(1, 55, 2)] = 0.99
        pgm_function3[(1, 56, 1)] = 0.99
        pgm_function3[(1, 56, 2)] = 0.99
        pgm_function3[(1, 57, 1)] = 0.99
        pgm_function3[(1, 57, 2)] = 0.99
        pgm_function3[(1, 58, 1)] = 0.99
        pgm_function3[(1, 58, 2)] = 0.99
        pgm_function3[(1, 59, 1)] = 0.99
        pgm_function3[(1, 59, 2)] = 0.99
        pgm_function3[(1, 60, 1)] = 0.99
        pgm_function3[(1, 60, 2)] = 0.99
        pgm_function3[(1, 61, 1)] = 0.9
        pgm_function3[(1, 61, 2)] = 0.85
        pgm_function3[(1, 62, 1)] = 0.99
        pgm_function3[(1, 62, 2)] = 0.99
        pgm_function3[(1, 63, 1)] = 0.99
        pgm_function3[(1, 63, 2)] = 0.99
        pgm_function3[(1, 64, 1)] = 0.99
        pgm_function3[(1, 64, 2)] = 0.99
        pgm_function3[(1, 65, 1)] = 0.99
        pgm_function3[(1, 65, 2)] = 0.99
        pgm_function3[(1, 66, 1)] = 0.99
        pgm_function3[(1, 66, 2)] = 0.99
        pgm_function3[(1, 67, 1)] = 0.95
        pgm_function3[(1, 67, 2)] = 0.9
        pgm_function3[(1, 68, 1)] = 0.99
        pgm_function3[(1, 68, 2)] = 0.99
        pgm_function3[(1, 69, 1)] = 0.99
        pgm_function3[(1, 69, 2)] = 0.99
        pgm_function3[(1, 70, 1)] = 0.95
        pgm_function3[(1, 70, 2)] = 0.9
        pgm_function3[(1, 71, 1)] = 0.95
        pgm_function3[(1, 71, 2)] = 0.9
        pgm_function3[(1, 72, 1)] = 0.95
        pgm_function3[(1, 72, 2)] = 0.9
        pgm_function3[(1, 73, 1)] = 0.99
        pgm_function3[(1, 73, 2)] = 0.99
        pgm_function3[(1, 74, 1)] = 0.99
        pgm_function3[(1, 74, 2)] = 0.99
        pgm_function3[(1, 75, 1)] = 0.99
        pgm_function3[(1, 75, 2)] = 0.99
        pgm_function3[(2, 0, 1)] = 0.2
        pgm_function3[(2, 0, 2)] = 0.3
        pgm_function3[(2, 1, 1)] = 0.01
        pgm_function3[(2, 1, 2)] = 0.01
        pgm_function3[(2, 2, 1)] = 0.01
        pgm_function3[(2, 2, 2)] = 0.01
        pgm_function3[(2, 3, 1)] = 0.01
        pgm_function3[(2, 3, 2)] = 0.01
        pgm_function3[(2, 4, 1)] = 0.01
        pgm_function3[(2, 4, 2)] = 0.01
        pgm_function3[(2, 5, 1)] = 0.05
        pgm_function3[(2, 5, 2)] = 0.1
        pgm_function3[(2, 6, 1)] = 0.01
        pgm_function3[(2, 6, 2)] = 0.01
        pgm_function3[(2, 7, 1)] = 0.01
        pgm_function3[(2, 7, 2)] = 0.01
        pgm_function3[(2, 8, 1)] = 0.01
        pgm_function3[(2, 8, 2)] = 0.01
        pgm_function3[(2, 9, 1)] = 0.01
        pgm_function3[(2, 9, 2)] = 0.01
        pgm_function3[(2, 10, 1)] = 0.01
        pgm_function3[(2, 10, 2)] = 0.01
        pgm_function3[(2, 11, 1)] = 0.01
        pgm_function3[(2, 11, 2)] = 0.01
        pgm_function3[(2, 12, 1)] = 0.01
        pgm_function3[(2, 12, 2)] = 0.01
        pgm_function3[(2, 13, 1)] = 0.01
        pgm_function3[(2, 13, 2)] = 0.01
        pgm_function3[(2, 14, 1)] = 0.01
        pgm_function3[(2, 14, 2)] = 0.01
        pgm_function3[(2, 15, 1)] = 0.01
        pgm_function3[(2, 15, 2)] = 0.01
        pgm_function3[(2, 16, 1)] = 0.01
        pgm_function3[(2, 16, 2)] = 0.01
        pgm_function3[(2, 17, 1)] = 0.01
        pgm_function3[(2, 17, 2)] = 0.01
        pgm_function3[(2, 18, 1)] = 0.01
        pgm_function3[(2, 18, 2)] = 0.01
        pgm_function3[(2, 19, 1)] = 0.01
        pgm_function3[(2, 19, 2)] = 0.01
        pgm_function3[(2, 20, 1)] = 0.01
        pgm_function3[(2, 20, 2)] = 0.01
        pgm_function3[(2, 21, 1)] = 0.01
        pgm_function3[(2, 21, 2)] = 0.01
        pgm_function3[(2, 22, 1)] = 0.01
        pgm_function3[(2, 22, 2)] = 0.01
        pgm_function3[(2, 23, 1)] = 0.01
        pgm_function3[(2, 23, 2)] = 0.01
        pgm_function3[(2, 24, 1)] = 0.01
        pgm_function3[(2, 24, 2)] = 0.01
        pgm_function3[(2, 25, 1)] = 0.01
        pgm_function3[(2, 25, 2)] = 0.01
        pgm_function3[(2, 26, 1)] = 0.01
        pgm_function3[(2, 26, 2)] = 0.01
        pgm_function3[(2, 27, 1)] = 0.01
        pgm_function3[(2, 27, 2)] = 0.01
        pgm_function3[(2, 28, 1)] = 0.01
        pgm_function3[(2, 28, 2)] = 0.01
        pgm_function3[(2, 29, 1)] = 0.01
        pgm_function3[(2, 29, 2)] = 0.01
        pgm_function3[(2, 30, 1)] = 0.01
        pgm_function3[(2, 30, 2)] = 0.01
        pgm_function3[(2, 31, 1)] = 0.01
        pgm_function3[(2, 31, 2)] = 0.01
        pgm_function3[(2, 32, 1)] = 0.01
        pgm_function3[(2, 32, 2)] = 0.01
        pgm_function3[(2, 33, 1)] = 0.01
        pgm_function3[(2, 33, 2)] = 0.01
        pgm_function3[(2, 34, 1)] = 0.01
        pgm_function3[(2, 34, 2)] = 0.01
        pgm_function3[(2, 35, 1)] = 0.01
        pgm_function3[(2, 35, 2)] = 0.01
        pgm_function3[(2, 36, 1)] = 0.01
        pgm_function3[(2, 36, 2)] = 0.01
        pgm_function3[(2, 37, 1)] = 0.01
        pgm_function3[(2, 37, 2)] = 0.01
        pgm_function3[(2, 38, 1)] = 0.01
        pgm_function3[(2, 38, 2)] = 0.01
        pgm_function3[(2, 39, 1)] = 0.01
        pgm_function3[(2, 39, 2)] = 0.01
        pgm_function3[(2, 40, 1)] = 0.01
        pgm_function3[(2, 40, 2)] = 0.01
        pgm_function3[(2, 41, 1)] = 0.01
        pgm_function3[(2, 41, 2)] = 0.01
        pgm_function3[(2, 42, 1)] = 0.01
        pgm_function3[(2, 42, 2)] = 0.01
        pgm_function3[(2, 43, 1)] = 0.01
        pgm_function3[(2, 43, 2)] = 0.01
        pgm_function3[(2, 44, 1)] = 0.01
        pgm_function3[(2, 44, 2)] = 0.01
        pgm_function3[(2, 45, 1)] = 0.01
        pgm_function3[(2, 45, 2)] = 0.01
        pgm_function3[(2, 46, 1)] = 0.01
        pgm_function3[(2, 46, 2)] = 0.01
        pgm_function3[(2, 47, 1)] = 0.01
        pgm_function3[(2, 47, 2)] = 0.01
        pgm_function3[(2, 48, 1)] = 0.01
        pgm_function3[(2, 48, 2)] = 0.01
        pgm_function3[(2, 49, 1)] = 0.01
        pgm_function3[(2, 49, 2)] = 0.01
        pgm_function3[(2, 50, 1)] = 0.01
        pgm_function3[(2, 50, 2)] = 0.01
        pgm_function3[(2, 51, 1)] = 0.01
        pgm_function3[(2, 51, 2)] = 0.01
        pgm_function3[(2, 52, 1)] = 0.01
        pgm_function3[(2, 52, 2)] = 0.01
        pgm_function3[(2, 53, 1)] = 0.01
        pgm_function3[(2, 53, 2)] = 0.01
        pgm_function3[(2, 54, 1)] = 0.01
        pgm_function3[(2, 54, 2)] = 0.01
        pgm_function3[(2, 55, 1)] = 0.01
        pgm_function3[(2, 55, 2)] = 0.01
        pgm_function3[(2, 56, 1)] = 0.01
        pgm_function3[(2, 56, 2)] = 0.01
        pgm_function3[(2, 57, 1)] = 0.01
        pgm_function3[(2, 57, 2)] = 0.01
        pgm_function3[(2, 58, 1)] = 0.01
        pgm_function3[(2, 58, 2)] = 0.01
        pgm_function3[(2, 59, 1)] = 0.01
        pgm_function3[(2, 59, 2)] = 0.01
        pgm_function3[(2, 60, 1)] = 0.01
        pgm_function3[(2, 60, 2)] = 0.01
        pgm_function3[(2, 61, 1)] = 0.1
        pgm_function3[(2, 61, 2)] = 0.15
        pgm_function3[(2, 62, 1)] = 0.01
        pgm_function3[(2, 62, 2)] = 0.01
        pgm_function3[(2, 63, 1)] = 0.01
        pgm_function3[(2, 63, 2)] = 0.01
        pgm_function3[(2, 64, 1)] = 0.01
        pgm_function3[(2, 64, 2)] = 0.01
        pgm_function3[(2, 65, 1)] = 0.01
        pgm_function3[(2, 65, 2)] = 0.01
        pgm_function3[(2, 66, 1)] = 0.01
        pgm_function3[(2, 66, 2)] = 0.01
        pgm_function3[(2, 67, 1)] = 0.05
        pgm_function3[(2, 67, 2)] = 0.1
        pgm_function3[(2, 68, 1)] = 0.01
        pgm_function3[(2, 68, 2)] = 0.01
        pgm_function3[(2, 69, 1)] = 0.01
        pgm_function3[(2, 69, 2)] = 0.01
        pgm_function3[(2, 70, 1)] = 0.05
        pgm_function3[(2, 70, 2)] = 0.1
        pgm_function3[(2, 71, 1)] = 0.05
        pgm_function3[(2, 71, 2)] = 0.1
        pgm_function3[(2, 72, 1)] = 0.05
        pgm_function3[(2, 72, 2)] = 0.1
        pgm_function3[(2, 73, 1)] = 0.01
        pgm_function3[(2, 73, 2)] = 0.01
        pgm_function3[(2, 74, 1)] = 0.01
        pgm_function3[(2, 74, 2)] = 0.01
        pgm_function3[(2, 75, 1)] = 0.01
        pgm_function3[(2, 75, 2)] = 0.01

        pgm_function4 = pgm_factor4.set_sparse()
        pgm_function4[(0, 0, 0)] = 1.0
        pgm_function4[(0, 1, 0)] = 1.0
        pgm_function4[(0, 2, 0)] = 1.0
        pgm_function4[(0, 3, 0)] = 1.0
        pgm_function4[(0, 4, 0)] = 1.0
        pgm_function4[(0, 5, 0)] = 1.0
        pgm_function4[(0, 6, 0)] = 1.0
        pgm_function4[(0, 7, 0)] = 1.0
        pgm_function4[(0, 8, 0)] = 1.0
        pgm_function4[(0, 9, 0)] = 1.0
        pgm_function4[(0, 10, 0)] = 1.0
        pgm_function4[(0, 11, 0)] = 1.0
        pgm_function4[(0, 12, 0)] = 1.0
        pgm_function4[(0, 13, 0)] = 1.0
        pgm_function4[(0, 14, 0)] = 1.0
        pgm_function4[(0, 15, 0)] = 1.0
        pgm_function4[(0, 16, 0)] = 1.0
        pgm_function4[(0, 17, 0)] = 1.0
        pgm_function4[(0, 18, 0)] = 1.0
        pgm_function4[(0, 19, 0)] = 1.0
        pgm_function4[(0, 20, 0)] = 1.0
        pgm_function4[(0, 21, 0)] = 1.0
        pgm_function4[(0, 22, 0)] = 1.0
        pgm_function4[(0, 23, 0)] = 1.0
        pgm_function4[(0, 24, 0)] = 1.0
        pgm_function4[(0, 25, 0)] = 1.0
        pgm_function4[(0, 26, 0)] = 1.0
        pgm_function4[(0, 27, 0)] = 1.0
        pgm_function4[(0, 28, 0)] = 1.0
        pgm_function4[(0, 29, 0)] = 1.0
        pgm_function4[(0, 30, 0)] = 1.0
        pgm_function4[(0, 31, 0)] = 1.0
        pgm_function4[(0, 32, 0)] = 1.0
        pgm_function4[(0, 33, 0)] = 1.0
        pgm_function4[(0, 34, 0)] = 1.0
        pgm_function4[(0, 35, 0)] = 1.0
        pgm_function4[(0, 36, 0)] = 1.0
        pgm_function4[(0, 37, 0)] = 1.0
        pgm_function4[(0, 38, 0)] = 1.0
        pgm_function4[(0, 39, 0)] = 1.0
        pgm_function4[(0, 40, 0)] = 1.0
        pgm_function4[(0, 41, 0)] = 1.0
        pgm_function4[(0, 42, 0)] = 1.0
        pgm_function4[(0, 43, 0)] = 1.0
        pgm_function4[(0, 44, 0)] = 1.0
        pgm_function4[(0, 45, 0)] = 1.0
        pgm_function4[(0, 46, 0)] = 1.0
        pgm_function4[(0, 47, 0)] = 1.0
        pgm_function4[(0, 48, 0)] = 1.0
        pgm_function4[(0, 49, 0)] = 1.0
        pgm_function4[(0, 50, 0)] = 1.0
        pgm_function4[(0, 51, 0)] = 1.0
        pgm_function4[(0, 52, 0)] = 1.0
        pgm_function4[(0, 53, 0)] = 1.0
        pgm_function4[(0, 54, 0)] = 1.0
        pgm_function4[(0, 55, 0)] = 1.0
        pgm_function4[(0, 56, 0)] = 1.0
        pgm_function4[(0, 57, 0)] = 1.0
        pgm_function4[(0, 58, 0)] = 1.0
        pgm_function4[(0, 59, 0)] = 1.0
        pgm_function4[(0, 60, 0)] = 1.0
        pgm_function4[(0, 61, 0)] = 1.0
        pgm_function4[(0, 62, 0)] = 1.0
        pgm_function4[(0, 63, 0)] = 1.0
        pgm_function4[(0, 64, 0)] = 1.0
        pgm_function4[(0, 65, 0)] = 1.0
        pgm_function4[(0, 66, 0)] = 1.0
        pgm_function4[(0, 67, 0)] = 1.0
        pgm_function4[(0, 68, 0)] = 1.0
        pgm_function4[(0, 69, 0)] = 1.0
        pgm_function4[(0, 70, 0)] = 1.0
        pgm_function4[(0, 71, 0)] = 1.0
        pgm_function4[(0, 72, 0)] = 1.0
        pgm_function4[(0, 73, 0)] = 1.0
        pgm_function4[(0, 74, 0)] = 1.0
        pgm_function4[(0, 75, 0)] = 1.0
        pgm_function4[(1, 0, 1)] = 0.05
        pgm_function4[(1, 0, 2)] = 0.05
        pgm_function4[(1, 0, 3)] = 0.05
        pgm_function4[(1, 0, 4)] = 0.05
        pgm_function4[(1, 1, 1)] = 0.99
        pgm_function4[(1, 1, 2)] = 0.99
        pgm_function4[(1, 1, 3)] = 0.99
        pgm_function4[(1, 1, 4)] = 0.99
        pgm_function4[(1, 2, 1)] = 0.98
        pgm_function4[(1, 2, 2)] = 0.98
        pgm_function4[(1, 2, 3)] = 0.98
        pgm_function4[(1, 2, 4)] = 0.98
        pgm_function4[(1, 3, 1)] = 0.9
        pgm_function4[(1, 3, 2)] = 0.9
        pgm_function4[(1, 3, 3)] = 0.9
        pgm_function4[(1, 3, 4)] = 0.9
        pgm_function4[(1, 4, 1)] = 0.95
        pgm_function4[(1, 4, 2)] = 0.95
        pgm_function4[(1, 4, 3)] = 0.95
        pgm_function4[(1, 4, 4)] = 0.95
        pgm_function4[(1, 5, 1)] = 0.8
        pgm_function4[(1, 5, 2)] = 0.8
        pgm_function4[(1, 5, 3)] = 0.8
        pgm_function4[(1, 5, 4)] = 0.8
        pgm_function4[(1, 6, 1)] = 0.99
        pgm_function4[(1, 6, 2)] = 0.99
        pgm_function4[(1, 6, 3)] = 0.99
        pgm_function4[(1, 6, 4)] = 0.99
        pgm_function4[(1, 7, 1)] = 0.8
        pgm_function4[(1, 7, 2)] = 0.8
        pgm_function4[(1, 7, 3)] = 0.8
        pgm_function4[(1, 7, 4)] = 0.8
        pgm_function4[(1, 8, 1)] = 0.95
        pgm_function4[(1, 8, 2)] = 0.95
        pgm_function4[(1, 8, 3)] = 0.95
        pgm_function4[(1, 8, 4)] = 0.95
        pgm_function4[(1, 9, 1)] = 0.98
        pgm_function4[(1, 9, 2)] = 0.98
        pgm_function4[(1, 9, 3)] = 0.98
        pgm_function4[(1, 9, 4)] = 0.98
        pgm_function4[(1, 10, 1)] = 0.9
        pgm_function4[(1, 10, 2)] = 0.9
        pgm_function4[(1, 10, 3)] = 0.9
        pgm_function4[(1, 10, 4)] = 0.9
        pgm_function4[(1, 11, 1)] = 0.98
        pgm_function4[(1, 11, 2)] = 0.98
        pgm_function4[(1, 11, 3)] = 0.98
        pgm_function4[(1, 11, 4)] = 0.98
        pgm_function4[(1, 12, 1)] = 0.98
        pgm_function4[(1, 12, 2)] = 0.98
        pgm_function4[(1, 12, 3)] = 0.98
        pgm_function4[(1, 12, 4)] = 0.98
        pgm_function4[(1, 13, 1)] = 0.98
        pgm_function4[(1, 13, 2)] = 0.98
        pgm_function4[(1, 13, 3)] = 0.98
        pgm_function4[(1, 13, 4)] = 0.98
        pgm_function4[(1, 14, 1)] = 0.9
        pgm_function4[(1, 14, 2)] = 0.9
        pgm_function4[(1, 14, 3)] = 0.9
        pgm_function4[(1, 14, 4)] = 0.9
        pgm_function4[(1, 15, 1)] = 0.9
        pgm_function4[(1, 15, 2)] = 0.9
        pgm_function4[(1, 15, 3)] = 0.9
        pgm_function4[(1, 15, 4)] = 0.9
        pgm_function4[(1, 16, 1)] = 0.8
        pgm_function4[(1, 16, 2)] = 0.8
        pgm_function4[(1, 16, 3)] = 0.8
        pgm_function4[(1, 16, 4)] = 0.8
        pgm_function4[(1, 17, 1)] = 0.98
        pgm_function4[(1, 17, 2)] = 0.98
        pgm_function4[(1, 17, 3)] = 0.98
        pgm_function4[(1, 17, 4)] = 0.98
        pgm_function4[(1, 18, 1)] = 0.98
        pgm_function4[(1, 18, 2)] = 0.98
        pgm_function4[(1, 18, 3)] = 0.98
        pgm_function4[(1, 18, 4)] = 0.98
        pgm_function4[(1, 19, 1)] = 0.98
        pgm_function4[(1, 19, 2)] = 0.98
        pgm_function4[(1, 19, 3)] = 0.98
        pgm_function4[(1, 19, 4)] = 0.98
        pgm_function4[(1, 20, 1)] = 0.95
        pgm_function4[(1, 20, 2)] = 0.95
        pgm_function4[(1, 20, 3)] = 0.95
        pgm_function4[(1, 20, 4)] = 0.95
        pgm_function4[(1, 21, 1)] = 0.95
        pgm_function4[(1, 21, 2)] = 0.95
        pgm_function4[(1, 21, 3)] = 0.95
        pgm_function4[(1, 21, 4)] = 0.95
        pgm_function4[(1, 22, 1)] = 0.98
        pgm_function4[(1, 22, 2)] = 0.98
        pgm_function4[(1, 22, 3)] = 0.98
        pgm_function4[(1, 22, 4)] = 0.98
        pgm_function4[(1, 23, 1)] = 0.9
        pgm_function4[(1, 23, 2)] = 0.9
        pgm_function4[(1, 23, 3)] = 0.9
        pgm_function4[(1, 23, 4)] = 0.9
        pgm_function4[(1, 24, 1)] = 0.98
        pgm_function4[(1, 24, 2)] = 0.98
        pgm_function4[(1, 24, 3)] = 0.98
        pgm_function4[(1, 24, 4)] = 0.98
        pgm_function4[(1, 25, 1)] = 0.98
        pgm_function4[(1, 25, 2)] = 0.98
        pgm_function4[(1, 25, 3)] = 0.98
        pgm_function4[(1, 25, 4)] = 0.98
        pgm_function4[(1, 26, 1)] = 0.98
        pgm_function4[(1, 26, 2)] = 0.98
        pgm_function4[(1, 26, 3)] = 0.98
        pgm_function4[(1, 26, 4)] = 0.98
        pgm_function4[(1, 27, 1)] = 0.98
        pgm_function4[(1, 27, 2)] = 0.98
        pgm_function4[(1, 27, 3)] = 0.98
        pgm_function4[(1, 27, 4)] = 0.98
        pgm_function4[(1, 28, 1)] = 0.99
        pgm_function4[(1, 28, 2)] = 0.99
        pgm_function4[(1, 28, 3)] = 0.99
        pgm_function4[(1, 28, 4)] = 0.99
        pgm_function4[(1, 29, 1)] = 0.99
        pgm_function4[(1, 29, 2)] = 0.99
        pgm_function4[(1, 29, 3)] = 0.99
        pgm_function4[(1, 29, 4)] = 0.99
        pgm_function4[(1, 30, 1)] = 0.99
        pgm_function4[(1, 30, 2)] = 0.99
        pgm_function4[(1, 30, 3)] = 0.99
        pgm_function4[(1, 30, 4)] = 0.99
        pgm_function4[(1, 31, 1)] = 0.98
        pgm_function4[(1, 31, 2)] = 0.98
        pgm_function4[(1, 31, 3)] = 0.98
        pgm_function4[(1, 31, 4)] = 0.98
        pgm_function4[(1, 32, 1)] = 0.98
        pgm_function4[(1, 32, 2)] = 0.98
        pgm_function4[(1, 32, 3)] = 0.98
        pgm_function4[(1, 32, 4)] = 0.98
        pgm_function4[(1, 33, 1)] = 0.98
        pgm_function4[(1, 33, 2)] = 0.98
        pgm_function4[(1, 33, 3)] = 0.98
        pgm_function4[(1, 33, 4)] = 0.98
        pgm_function4[(1, 34, 1)] = 1.0
        pgm_function4[(1, 34, 2)] = 1.0
        pgm_function4[(1, 34, 3)] = 1.0
        pgm_function4[(1, 34, 4)] = 1.0
        pgm_function4[(1, 35, 1)] = 1.0
        pgm_function4[(1, 35, 2)] = 1.0
        pgm_function4[(1, 35, 3)] = 1.0
        pgm_function4[(1, 35, 4)] = 1.0
        pgm_function4[(1, 36, 1)] = 1.0
        pgm_function4[(1, 36, 2)] = 1.0
        pgm_function4[(1, 36, 3)] = 1.0
        pgm_function4[(1, 36, 4)] = 1.0
        pgm_function4[(1, 37, 1)] = 1.0
        pgm_function4[(1, 37, 2)] = 1.0
        pgm_function4[(1, 37, 3)] = 1.0
        pgm_function4[(1, 37, 4)] = 1.0
        pgm_function4[(1, 38, 1)] = 0.99
        pgm_function4[(1, 38, 2)] = 0.99
        pgm_function4[(1, 38, 3)] = 0.99
        pgm_function4[(1, 38, 4)] = 0.99
        pgm_function4[(1, 39, 1)] = 0.99
        pgm_function4[(1, 39, 2)] = 0.99
        pgm_function4[(1, 39, 3)] = 0.99
        pgm_function4[(1, 39, 4)] = 0.99
        pgm_function4[(1, 40, 1)] = 0.98
        pgm_function4[(1, 40, 2)] = 0.98
        pgm_function4[(1, 40, 3)] = 0.98
        pgm_function4[(1, 40, 4)] = 0.98
        pgm_function4[(1, 41, 1)] = 0.99
        pgm_function4[(1, 41, 2)] = 0.99
        pgm_function4[(1, 41, 3)] = 0.99
        pgm_function4[(1, 41, 4)] = 0.99
        pgm_function4[(1, 42, 1)] = 0.99
        pgm_function4[(1, 42, 2)] = 0.99
        pgm_function4[(1, 42, 3)] = 0.99
        pgm_function4[(1, 42, 4)] = 0.99
        pgm_function4[(1, 43, 1)] = 0.99
        pgm_function4[(1, 43, 2)] = 0.99
        pgm_function4[(1, 43, 3)] = 0.99
        pgm_function4[(1, 43, 4)] = 0.99
        pgm_function4[(1, 44, 1)] = 0.99
        pgm_function4[(1, 44, 2)] = 0.99
        pgm_function4[(1, 44, 3)] = 0.99
        pgm_function4[(1, 44, 4)] = 0.99
        pgm_function4[(1, 45, 1)] = 0.99
        pgm_function4[(1, 45, 2)] = 0.99
        pgm_function4[(1, 45, 3)] = 0.99
        pgm_function4[(1, 45, 4)] = 0.99
        pgm_function4[(1, 46, 1)] = 0.99
        pgm_function4[(1, 46, 2)] = 0.99
        pgm_function4[(1, 46, 3)] = 0.99
        pgm_function4[(1, 46, 4)] = 0.99
        pgm_function4[(1, 47, 1)] = 0.99
        pgm_function4[(1, 47, 2)] = 0.99
        pgm_function4[(1, 47, 3)] = 0.99
        pgm_function4[(1, 47, 4)] = 0.99
        pgm_function4[(1, 48, 1)] = 0.99
        pgm_function4[(1, 48, 2)] = 0.99
        pgm_function4[(1, 48, 3)] = 0.99
        pgm_function4[(1, 48, 4)] = 0.99
        pgm_function4[(1, 49, 1)] = 0.99
        pgm_function4[(1, 49, 2)] = 0.99
        pgm_function4[(1, 49, 3)] = 0.99
        pgm_function4[(1, 49, 4)] = 0.99
        pgm_function4[(1, 50, 1)] = 0.99
        pgm_function4[(1, 50, 2)] = 0.99
        pgm_function4[(1, 50, 3)] = 0.99
        pgm_function4[(1, 50, 4)] = 0.99
        pgm_function4[(1, 51, 1)] = 0.99
        pgm_function4[(1, 51, 2)] = 0.99
        pgm_function4[(1, 51, 3)] = 0.99
        pgm_function4[(1, 51, 4)] = 0.99
        pgm_function4[(1, 52, 1)] = 0.98
        pgm_function4[(1, 52, 2)] = 0.98
        pgm_function4[(1, 52, 3)] = 0.98
        pgm_function4[(1, 52, 4)] = 0.98
        pgm_function4[(1, 53, 1)] = 0.98
        pgm_function4[(1, 53, 2)] = 0.98
        pgm_function4[(1, 53, 3)] = 0.98
        pgm_function4[(1, 53, 4)] = 0.98
        pgm_function4[(1, 54, 1)] = 0.98
        pgm_function4[(1, 54, 2)] = 0.98
        pgm_function4[(1, 54, 3)] = 0.98
        pgm_function4[(1, 54, 4)] = 0.98
        pgm_function4[(1, 55, 1)] = 0.98
        pgm_function4[(1, 55, 2)] = 0.98
        pgm_function4[(1, 55, 3)] = 0.98
        pgm_function4[(1, 55, 4)] = 0.98
        pgm_function4[(1, 56, 1)] = 0.98
        pgm_function4[(1, 56, 2)] = 0.98
        pgm_function4[(1, 56, 3)] = 0.98
        pgm_function4[(1, 56, 4)] = 0.98
        pgm_function4[(1, 57, 1)] = 0.98
        pgm_function4[(1, 57, 2)] = 0.98
        pgm_function4[(1, 57, 3)] = 0.98
        pgm_function4[(1, 57, 4)] = 0.98
        pgm_function4[(1, 58, 1)] = 0.99
        pgm_function4[(1, 58, 2)] = 0.99
        pgm_function4[(1, 58, 3)] = 0.99
        pgm_function4[(1, 58, 4)] = 0.99
        pgm_function4[(1, 59, 1)] = 0.8
        pgm_function4[(1, 59, 2)] = 0.8
        pgm_function4[(1, 59, 3)] = 0.8
        pgm_function4[(1, 59, 4)] = 0.8
        pgm_function4[(1, 60, 1)] = 0.99
        pgm_function4[(1, 60, 2)] = 0.99
        pgm_function4[(1, 60, 3)] = 0.99
        pgm_function4[(1, 60, 4)] = 0.99
        pgm_function4[(1, 61, 1)] = 0.9
        pgm_function4[(1, 61, 2)] = 0.9
        pgm_function4[(1, 61, 3)] = 0.9
        pgm_function4[(1, 61, 4)] = 0.9
        pgm_function4[(1, 62, 1)] = 0.99
        pgm_function4[(1, 62, 2)] = 0.99
        pgm_function4[(1, 62, 3)] = 0.99
        pgm_function4[(1, 62, 4)] = 0.99
        pgm_function4[(1, 63, 1)] = 0.9
        pgm_function4[(1, 63, 2)] = 0.9
        pgm_function4[(1, 63, 3)] = 0.9
        pgm_function4[(1, 63, 4)] = 0.9
        pgm_function4[(1, 64, 1)] = 0.98
        pgm_function4[(1, 64, 2)] = 0.98
        pgm_function4[(1, 64, 3)] = 0.98
        pgm_function4[(1, 64, 4)] = 0.98
        pgm_function4[(1, 65, 1)] = 0.98
        pgm_function4[(1, 65, 2)] = 0.98
        pgm_function4[(1, 65, 3)] = 0.98
        pgm_function4[(1, 65, 4)] = 0.98
        pgm_function4[(1, 66, 1)] = 0.9
        pgm_function4[(1, 66, 2)] = 0.9
        pgm_function4[(1, 66, 3)] = 0.9
        pgm_function4[(1, 66, 4)] = 0.9
        pgm_function4[(1, 67, 1)] = 0.95
        pgm_function4[(1, 67, 2)] = 0.95
        pgm_function4[(1, 67, 3)] = 0.95
        pgm_function4[(1, 67, 4)] = 0.95
        pgm_function4[(1, 68, 1)] = 0.95
        pgm_function4[(1, 68, 2)] = 0.95
        pgm_function4[(1, 68, 3)] = 0.95
        pgm_function4[(1, 68, 4)] = 0.95
        pgm_function4[(1, 69, 1)] = 0.95
        pgm_function4[(1, 69, 2)] = 0.95
        pgm_function4[(1, 69, 3)] = 0.95
        pgm_function4[(1, 69, 4)] = 0.95
        pgm_function4[(1, 70, 1)] = 0.95
        pgm_function4[(1, 70, 2)] = 0.95
        pgm_function4[(1, 70, 3)] = 0.95
        pgm_function4[(1, 70, 4)] = 0.95
        pgm_function4[(1, 71, 1)] = 0.95
        pgm_function4[(1, 71, 2)] = 0.95
        pgm_function4[(1, 71, 3)] = 0.95
        pgm_function4[(1, 71, 4)] = 0.95
        pgm_function4[(1, 72, 1)] = 0.95
        pgm_function4[(1, 72, 2)] = 0.95
        pgm_function4[(1, 72, 3)] = 0.95
        pgm_function4[(1, 72, 4)] = 0.95
        pgm_function4[(1, 73, 1)] = 0.95
        pgm_function4[(1, 73, 2)] = 0.95
        pgm_function4[(1, 73, 3)] = 0.95
        pgm_function4[(1, 73, 4)] = 0.95
        pgm_function4[(1, 74, 1)] = 0.99
        pgm_function4[(1, 74, 2)] = 0.99
        pgm_function4[(1, 74, 3)] = 0.99
        pgm_function4[(1, 74, 4)] = 0.99
        pgm_function4[(1, 75, 1)] = 0.98
        pgm_function4[(1, 75, 2)] = 0.98
        pgm_function4[(1, 75, 3)] = 0.98
        pgm_function4[(1, 75, 4)] = 0.98
        pgm_function4[(2, 0, 1)] = 0.95
        pgm_function4[(2, 0, 2)] = 0.95
        pgm_function4[(2, 0, 3)] = 0.95
        pgm_function4[(2, 0, 4)] = 0.95
        pgm_function4[(2, 1, 1)] = 0.01
        pgm_function4[(2, 1, 2)] = 0.01
        pgm_function4[(2, 1, 3)] = 0.01
        pgm_function4[(2, 1, 4)] = 0.01
        pgm_function4[(2, 2, 1)] = 0.02
        pgm_function4[(2, 2, 2)] = 0.02
        pgm_function4[(2, 2, 3)] = 0.02
        pgm_function4[(2, 2, 4)] = 0.02
        pgm_function4[(2, 3, 1)] = 0.1
        pgm_function4[(2, 3, 2)] = 0.1
        pgm_function4[(2, 3, 3)] = 0.1
        pgm_function4[(2, 3, 4)] = 0.1
        pgm_function4[(2, 4, 1)] = 0.05
        pgm_function4[(2, 4, 2)] = 0.05
        pgm_function4[(2, 4, 3)] = 0.05
        pgm_function4[(2, 4, 4)] = 0.05
        pgm_function4[(2, 5, 1)] = 0.2
        pgm_function4[(2, 5, 2)] = 0.2
        pgm_function4[(2, 5, 3)] = 0.2
        pgm_function4[(2, 5, 4)] = 0.2
        pgm_function4[(2, 6, 1)] = 0.01
        pgm_function4[(2, 6, 2)] = 0.01
        pgm_function4[(2, 6, 3)] = 0.01
        pgm_function4[(2, 6, 4)] = 0.01
        pgm_function4[(2, 7, 1)] = 0.2
        pgm_function4[(2, 7, 2)] = 0.2
        pgm_function4[(2, 7, 3)] = 0.2
        pgm_function4[(2, 7, 4)] = 0.2
        pgm_function4[(2, 8, 1)] = 0.05
        pgm_function4[(2, 8, 2)] = 0.05
        pgm_function4[(2, 8, 3)] = 0.05
        pgm_function4[(2, 8, 4)] = 0.05
        pgm_function4[(2, 9, 1)] = 0.02
        pgm_function4[(2, 9, 2)] = 0.02
        pgm_function4[(2, 9, 3)] = 0.02
        pgm_function4[(2, 9, 4)] = 0.02
        pgm_function4[(2, 10, 1)] = 0.1
        pgm_function4[(2, 10, 2)] = 0.1
        pgm_function4[(2, 10, 3)] = 0.1
        pgm_function4[(2, 10, 4)] = 0.1
        pgm_function4[(2, 11, 1)] = 0.02
        pgm_function4[(2, 11, 2)] = 0.02
        pgm_function4[(2, 11, 3)] = 0.02
        pgm_function4[(2, 11, 4)] = 0.02
        pgm_function4[(2, 12, 1)] = 0.02
        pgm_function4[(2, 12, 2)] = 0.02
        pgm_function4[(2, 12, 3)] = 0.02
        pgm_function4[(2, 12, 4)] = 0.02
        pgm_function4[(2, 13, 1)] = 0.02
        pgm_function4[(2, 13, 2)] = 0.02
        pgm_function4[(2, 13, 3)] = 0.02
        pgm_function4[(2, 13, 4)] = 0.02
        pgm_function4[(2, 14, 1)] = 0.1
        pgm_function4[(2, 14, 2)] = 0.1
        pgm_function4[(2, 14, 3)] = 0.1
        pgm_function4[(2, 14, 4)] = 0.1
        pgm_function4[(2, 15, 1)] = 0.1
        pgm_function4[(2, 15, 2)] = 0.1
        pgm_function4[(2, 15, 3)] = 0.1
        pgm_function4[(2, 15, 4)] = 0.1
        pgm_function4[(2, 16, 1)] = 0.2
        pgm_function4[(2, 16, 2)] = 0.2
        pgm_function4[(2, 16, 3)] = 0.2
        pgm_function4[(2, 16, 4)] = 0.2
        pgm_function4[(2, 17, 1)] = 0.02
        pgm_function4[(2, 17, 2)] = 0.02
        pgm_function4[(2, 17, 3)] = 0.02
        pgm_function4[(2, 17, 4)] = 0.02
        pgm_function4[(2, 18, 1)] = 0.02
        pgm_function4[(2, 18, 2)] = 0.02
        pgm_function4[(2, 18, 3)] = 0.02
        pgm_function4[(2, 18, 4)] = 0.02
        pgm_function4[(2, 19, 1)] = 0.02
        pgm_function4[(2, 19, 2)] = 0.02
        pgm_function4[(2, 19, 3)] = 0.02
        pgm_function4[(2, 19, 4)] = 0.02
        pgm_function4[(2, 20, 1)] = 0.05
        pgm_function4[(2, 20, 2)] = 0.05
        pgm_function4[(2, 20, 3)] = 0.05
        pgm_function4[(2, 20, 4)] = 0.05
        pgm_function4[(2, 21, 1)] = 0.05
        pgm_function4[(2, 21, 2)] = 0.05
        pgm_function4[(2, 21, 3)] = 0.05
        pgm_function4[(2, 21, 4)] = 0.05
        pgm_function4[(2, 22, 1)] = 0.02
        pgm_function4[(2, 22, 2)] = 0.02
        pgm_function4[(2, 22, 3)] = 0.02
        pgm_function4[(2, 22, 4)] = 0.02
        pgm_function4[(2, 23, 1)] = 0.1
        pgm_function4[(2, 23, 2)] = 0.1
        pgm_function4[(2, 23, 3)] = 0.1
        pgm_function4[(2, 23, 4)] = 0.1
        pgm_function4[(2, 24, 1)] = 0.02
        pgm_function4[(2, 24, 2)] = 0.02
        pgm_function4[(2, 24, 3)] = 0.02
        pgm_function4[(2, 24, 4)] = 0.02
        pgm_function4[(2, 25, 1)] = 0.02
        pgm_function4[(2, 25, 2)] = 0.02
        pgm_function4[(2, 25, 3)] = 0.02
        pgm_function4[(2, 25, 4)] = 0.02
        pgm_function4[(2, 26, 1)] = 0.02
        pgm_function4[(2, 26, 2)] = 0.02
        pgm_function4[(2, 26, 3)] = 0.02
        pgm_function4[(2, 26, 4)] = 0.02
        pgm_function4[(2, 27, 1)] = 0.02
        pgm_function4[(2, 27, 2)] = 0.02
        pgm_function4[(2, 27, 3)] = 0.02
        pgm_function4[(2, 27, 4)] = 0.02
        pgm_function4[(2, 28, 1)] = 0.01
        pgm_function4[(2, 28, 2)] = 0.01
        pgm_function4[(2, 28, 3)] = 0.01
        pgm_function4[(2, 28, 4)] = 0.01
        pgm_function4[(2, 29, 1)] = 0.01
        pgm_function4[(2, 29, 2)] = 0.01
        pgm_function4[(2, 29, 3)] = 0.01
        pgm_function4[(2, 29, 4)] = 0.01
        pgm_function4[(2, 30, 1)] = 0.01
        pgm_function4[(2, 30, 2)] = 0.01
        pgm_function4[(2, 30, 3)] = 0.01
        pgm_function4[(2, 30, 4)] = 0.01
        pgm_function4[(2, 31, 1)] = 0.02
        pgm_function4[(2, 31, 2)] = 0.02
        pgm_function4[(2, 31, 3)] = 0.02
        pgm_function4[(2, 31, 4)] = 0.02
        pgm_function4[(2, 32, 1)] = 0.02
        pgm_function4[(2, 32, 2)] = 0.02
        pgm_function4[(2, 32, 3)] = 0.02
        pgm_function4[(2, 32, 4)] = 0.02
        pgm_function4[(2, 33, 1)] = 0.02
        pgm_function4[(2, 33, 2)] = 0.02
        pgm_function4[(2, 33, 3)] = 0.02
        pgm_function4[(2, 33, 4)] = 0.02
        pgm_function4[(2, 38, 1)] = 0.01
        pgm_function4[(2, 38, 2)] = 0.01
        pgm_function4[(2, 38, 3)] = 0.01
        pgm_function4[(2, 38, 4)] = 0.01
        pgm_function4[(2, 39, 1)] = 0.01
        pgm_function4[(2, 39, 2)] = 0.01
        pgm_function4[(2, 39, 3)] = 0.01
        pgm_function4[(2, 39, 4)] = 0.01
        pgm_function4[(2, 40, 1)] = 0.02
        pgm_function4[(2, 40, 2)] = 0.02
        pgm_function4[(2, 40, 3)] = 0.02
        pgm_function4[(2, 40, 4)] = 0.02
        pgm_function4[(2, 41, 1)] = 0.01
        pgm_function4[(2, 41, 2)] = 0.01
        pgm_function4[(2, 41, 3)] = 0.01
        pgm_function4[(2, 41, 4)] = 0.01
        pgm_function4[(2, 42, 1)] = 0.01
        pgm_function4[(2, 42, 2)] = 0.01
        pgm_function4[(2, 42, 3)] = 0.01
        pgm_function4[(2, 42, 4)] = 0.01
        pgm_function4[(2, 43, 1)] = 0.01
        pgm_function4[(2, 43, 2)] = 0.01
        pgm_function4[(2, 43, 3)] = 0.01
        pgm_function4[(2, 43, 4)] = 0.01
        pgm_function4[(2, 44, 1)] = 0.01
        pgm_function4[(2, 44, 2)] = 0.01
        pgm_function4[(2, 44, 3)] = 0.01
        pgm_function4[(2, 44, 4)] = 0.01
        pgm_function4[(2, 45, 1)] = 0.01
        pgm_function4[(2, 45, 2)] = 0.01
        pgm_function4[(2, 45, 3)] = 0.01
        pgm_function4[(2, 45, 4)] = 0.01
        pgm_function4[(2, 46, 1)] = 0.01
        pgm_function4[(2, 46, 2)] = 0.01
        pgm_function4[(2, 46, 3)] = 0.01
        pgm_function4[(2, 46, 4)] = 0.01
        pgm_function4[(2, 47, 1)] = 0.01
        pgm_function4[(2, 47, 2)] = 0.01
        pgm_function4[(2, 47, 3)] = 0.01
        pgm_function4[(2, 47, 4)] = 0.01
        pgm_function4[(2, 48, 1)] = 0.01
        pgm_function4[(2, 48, 2)] = 0.01
        pgm_function4[(2, 48, 3)] = 0.01
        pgm_function4[(2, 48, 4)] = 0.01
        pgm_function4[(2, 49, 1)] = 0.01
        pgm_function4[(2, 49, 2)] = 0.01
        pgm_function4[(2, 49, 3)] = 0.01
        pgm_function4[(2, 49, 4)] = 0.01
        pgm_function4[(2, 50, 1)] = 0.01
        pgm_function4[(2, 50, 2)] = 0.01
        pgm_function4[(2, 50, 3)] = 0.01
        pgm_function4[(2, 50, 4)] = 0.01
        pgm_function4[(2, 51, 1)] = 0.01
        pgm_function4[(2, 51, 2)] = 0.01
        pgm_function4[(2, 51, 3)] = 0.01
        pgm_function4[(2, 51, 4)] = 0.01
        pgm_function4[(2, 52, 1)] = 0.02
        pgm_function4[(2, 52, 2)] = 0.02
        pgm_function4[(2, 52, 3)] = 0.02
        pgm_function4[(2, 52, 4)] = 0.02
        pgm_function4[(2, 53, 1)] = 0.02
        pgm_function4[(2, 53, 2)] = 0.02
        pgm_function4[(2, 53, 3)] = 0.02
        pgm_function4[(2, 53, 4)] = 0.02
        pgm_function4[(2, 54, 1)] = 0.02
        pgm_function4[(2, 54, 2)] = 0.02
        pgm_function4[(2, 54, 3)] = 0.02
        pgm_function4[(2, 54, 4)] = 0.02
        pgm_function4[(2, 55, 1)] = 0.02
        pgm_function4[(2, 55, 2)] = 0.02
        pgm_function4[(2, 55, 3)] = 0.02
        pgm_function4[(2, 55, 4)] = 0.02
        pgm_function4[(2, 56, 1)] = 0.02
        pgm_function4[(2, 56, 2)] = 0.02
        pgm_function4[(2, 56, 3)] = 0.02
        pgm_function4[(2, 56, 4)] = 0.02
        pgm_function4[(2, 57, 1)] = 0.02
        pgm_function4[(2, 57, 2)] = 0.02
        pgm_function4[(2, 57, 3)] = 0.02
        pgm_function4[(2, 57, 4)] = 0.02
        pgm_function4[(2, 58, 1)] = 0.01
        pgm_function4[(2, 58, 2)] = 0.01
        pgm_function4[(2, 58, 3)] = 0.01
        pgm_function4[(2, 58, 4)] = 0.01
        pgm_function4[(2, 59, 1)] = 0.2
        pgm_function4[(2, 59, 2)] = 0.2
        pgm_function4[(2, 59, 3)] = 0.2
        pgm_function4[(2, 59, 4)] = 0.2
        pgm_function4[(2, 60, 1)] = 0.01
        pgm_function4[(2, 60, 2)] = 0.01
        pgm_function4[(2, 60, 3)] = 0.01
        pgm_function4[(2, 60, 4)] = 0.01
        pgm_function4[(2, 61, 1)] = 0.1
        pgm_function4[(2, 61, 2)] = 0.1
        pgm_function4[(2, 61, 3)] = 0.1
        pgm_function4[(2, 61, 4)] = 0.1
        pgm_function4[(2, 62, 1)] = 0.01
        pgm_function4[(2, 62, 2)] = 0.01
        pgm_function4[(2, 62, 3)] = 0.01
        pgm_function4[(2, 62, 4)] = 0.01
        pgm_function4[(2, 63, 1)] = 0.1
        pgm_function4[(2, 63, 2)] = 0.1
        pgm_function4[(2, 63, 3)] = 0.1
        pgm_function4[(2, 63, 4)] = 0.1
        pgm_function4[(2, 64, 1)] = 0.02
        pgm_function4[(2, 64, 2)] = 0.02
        pgm_function4[(2, 64, 3)] = 0.02
        pgm_function4[(2, 64, 4)] = 0.02
        pgm_function4[(2, 65, 1)] = 0.02
        pgm_function4[(2, 65, 2)] = 0.02
        pgm_function4[(2, 65, 3)] = 0.02
        pgm_function4[(2, 65, 4)] = 0.02
        pgm_function4[(2, 66, 1)] = 0.1
        pgm_function4[(2, 66, 2)] = 0.1
        pgm_function4[(2, 66, 3)] = 0.1
        pgm_function4[(2, 66, 4)] = 0.1
        pgm_function4[(2, 67, 1)] = 0.05
        pgm_function4[(2, 67, 2)] = 0.05
        pgm_function4[(2, 67, 3)] = 0.05
        pgm_function4[(2, 67, 4)] = 0.05
        pgm_function4[(2, 68, 1)] = 0.05
        pgm_function4[(2, 68, 2)] = 0.05
        pgm_function4[(2, 68, 3)] = 0.05
        pgm_function4[(2, 68, 4)] = 0.05
        pgm_function4[(2, 69, 1)] = 0.05
        pgm_function4[(2, 69, 2)] = 0.05
        pgm_function4[(2, 69, 3)] = 0.05
        pgm_function4[(2, 69, 4)] = 0.05
        pgm_function4[(2, 70, 1)] = 0.05
        pgm_function4[(2, 70, 2)] = 0.05
        pgm_function4[(2, 70, 3)] = 0.05
        pgm_function4[(2, 70, 4)] = 0.05
        pgm_function4[(2, 71, 1)] = 0.05
        pgm_function4[(2, 71, 2)] = 0.05
        pgm_function4[(2, 71, 3)] = 0.05
        pgm_function4[(2, 71, 4)] = 0.05
        pgm_function4[(2, 72, 1)] = 0.05
        pgm_function4[(2, 72, 2)] = 0.05
        pgm_function4[(2, 72, 3)] = 0.05
        pgm_function4[(2, 72, 4)] = 0.05
        pgm_function4[(2, 73, 1)] = 0.05
        pgm_function4[(2, 73, 2)] = 0.05
        pgm_function4[(2, 73, 3)] = 0.05
        pgm_function4[(2, 73, 4)] = 0.05
        pgm_function4[(2, 74, 1)] = 0.01
        pgm_function4[(2, 74, 2)] = 0.01
        pgm_function4[(2, 74, 3)] = 0.01
        pgm_function4[(2, 74, 4)] = 0.01
        pgm_function4[(2, 75, 1)] = 0.02
        pgm_function4[(2, 75, 2)] = 0.02
        pgm_function4[(2, 75, 3)] = 0.02
        pgm_function4[(2, 75, 4)] = 0.02

        pgm_function5 = pgm_factor5.set_sparse()
        pgm_function5[(0, 0, 0)] = 1.0
        pgm_function5[(0, 1, 0)] = 1.0
        pgm_function5[(0, 2, 0)] = 1.0
        pgm_function5[(0, 3, 0)] = 1.0
        pgm_function5[(0, 4, 0)] = 1.0
        pgm_function5[(0, 5, 0)] = 1.0
        pgm_function5[(0, 6, 0)] = 1.0
        pgm_function5[(0, 7, 0)] = 1.0
        pgm_function5[(0, 8, 0)] = 1.0
        pgm_function5[(0, 9, 0)] = 1.0
        pgm_function5[(0, 10, 0)] = 1.0
        pgm_function5[(0, 11, 0)] = 1.0
        pgm_function5[(0, 12, 0)] = 1.0
        pgm_function5[(0, 13, 0)] = 1.0
        pgm_function5[(0, 14, 0)] = 1.0
        pgm_function5[(0, 15, 0)] = 1.0
        pgm_function5[(0, 16, 0)] = 1.0
        pgm_function5[(0, 17, 0)] = 1.0
        pgm_function5[(0, 18, 0)] = 1.0
        pgm_function5[(0, 19, 0)] = 1.0
        pgm_function5[(0, 20, 0)] = 1.0
        pgm_function5[(0, 21, 0)] = 1.0
        pgm_function5[(0, 22, 0)] = 1.0
        pgm_function5[(0, 23, 0)] = 1.0
        pgm_function5[(0, 24, 0)] = 1.0
        pgm_function5[(0, 25, 0)] = 1.0
        pgm_function5[(0, 26, 0)] = 1.0
        pgm_function5[(0, 27, 0)] = 1.0
        pgm_function5[(0, 28, 0)] = 1.0
        pgm_function5[(0, 29, 0)] = 1.0
        pgm_function5[(0, 30, 0)] = 1.0
        pgm_function5[(0, 31, 0)] = 1.0
        pgm_function5[(0, 32, 0)] = 1.0
        pgm_function5[(0, 33, 0)] = 1.0
        pgm_function5[(0, 34, 0)] = 1.0
        pgm_function5[(0, 35, 0)] = 1.0
        pgm_function5[(0, 36, 0)] = 1.0
        pgm_function5[(0, 37, 0)] = 1.0
        pgm_function5[(0, 38, 0)] = 1.0
        pgm_function5[(0, 39, 0)] = 1.0
        pgm_function5[(0, 40, 0)] = 1.0
        pgm_function5[(0, 41, 0)] = 1.0
        pgm_function5[(0, 42, 0)] = 1.0
        pgm_function5[(0, 43, 0)] = 1.0
        pgm_function5[(0, 44, 0)] = 1.0
        pgm_function5[(0, 45, 0)] = 1.0
        pgm_function5[(0, 46, 0)] = 1.0
        pgm_function5[(0, 47, 0)] = 1.0
        pgm_function5[(0, 48, 0)] = 1.0
        pgm_function5[(0, 49, 0)] = 1.0
        pgm_function5[(0, 50, 0)] = 1.0
        pgm_function5[(0, 51, 0)] = 1.0
        pgm_function5[(0, 52, 0)] = 1.0
        pgm_function5[(0, 53, 0)] = 1.0
        pgm_function5[(0, 54, 0)] = 1.0
        pgm_function5[(0, 55, 0)] = 1.0
        pgm_function5[(0, 56, 0)] = 1.0
        pgm_function5[(0, 57, 0)] = 1.0
        pgm_function5[(0, 58, 0)] = 1.0
        pgm_function5[(0, 59, 0)] = 1.0
        pgm_function5[(0, 60, 0)] = 1.0
        pgm_function5[(0, 61, 0)] = 1.0
        pgm_function5[(0, 62, 0)] = 1.0
        pgm_function5[(0, 63, 0)] = 1.0
        pgm_function5[(0, 64, 0)] = 1.0
        pgm_function5[(0, 65, 0)] = 1.0
        pgm_function5[(0, 66, 0)] = 1.0
        pgm_function5[(0, 67, 0)] = 1.0
        pgm_function5[(0, 68, 0)] = 1.0
        pgm_function5[(0, 69, 0)] = 1.0
        pgm_function5[(0, 70, 0)] = 1.0
        pgm_function5[(0, 71, 0)] = 1.0
        pgm_function5[(0, 72, 0)] = 1.0
        pgm_function5[(0, 73, 0)] = 1.0
        pgm_function5[(0, 74, 0)] = 1.0
        pgm_function5[(0, 75, 0)] = 1.0
        pgm_function5[(1, 0, 1)] = 0.989
        pgm_function5[(1, 0, 2)] = 0.989
        pgm_function5[(1, 1, 1)] = 0.989
        pgm_function5[(1, 1, 2)] = 0.989
        pgm_function5[(1, 2, 1)] = 0.989
        pgm_function5[(1, 2, 2)] = 0.989
        pgm_function5[(1, 3, 1)] = 0.989
        pgm_function5[(1, 3, 2)] = 0.989
        pgm_function5[(1, 4, 1)] = 0.989
        pgm_function5[(1, 4, 2)] = 0.989
        pgm_function5[(1, 5, 1)] = 0.989
        pgm_function5[(1, 5, 2)] = 0.989
        pgm_function5[(1, 6, 1)] = 1e-05
        pgm_function5[(1, 6, 2)] = 1e-05
        pgm_function5[(1, 7, 1)] = 0.988
        pgm_function5[(1, 7, 2)] = 0.988
        pgm_function5[(1, 8, 1)] = 0.989
        pgm_function5[(1, 8, 2)] = 0.989
        pgm_function5[(1, 9, 1)] = 0.989
        pgm_function5[(1, 9, 2)] = 0.989
        pgm_function5[(1, 10, 1)] = 0.989
        pgm_function5[(1, 10, 2)] = 0.989
        pgm_function5[(1, 11, 1)] = 0.989
        pgm_function5[(1, 11, 2)] = 0.989
        pgm_function5[(1, 12, 1)] = 0.989
        pgm_function5[(1, 12, 2)] = 0.989
        pgm_function5[(1, 13, 1)] = 0.989
        pgm_function5[(1, 13, 2)] = 0.989
        pgm_function5[(1, 14, 1)] = 0.989
        pgm_function5[(1, 14, 2)] = 0.989
        pgm_function5[(1, 15, 1)] = 0.989
        pgm_function5[(1, 15, 2)] = 0.989
        pgm_function5[(1, 16, 1)] = 0.989
        pgm_function5[(1, 16, 2)] = 0.989
        pgm_function5[(1, 17, 1)] = 0.989
        pgm_function5[(1, 17, 2)] = 0.989
        pgm_function5[(1, 18, 1)] = 0.989
        pgm_function5[(1, 18, 2)] = 0.989
        pgm_function5[(1, 19, 1)] = 0.989
        pgm_function5[(1, 19, 2)] = 0.989
        pgm_function5[(1, 20, 1)] = 0.989
        pgm_function5[(1, 20, 2)] = 0.989
        pgm_function5[(1, 21, 1)] = 0.989
        pgm_function5[(1, 21, 2)] = 0.989
        pgm_function5[(1, 22, 1)] = 0.989
        pgm_function5[(1, 22, 2)] = 0.989
        pgm_function5[(1, 23, 1)] = 0.989
        pgm_function5[(1, 23, 2)] = 0.989
        pgm_function5[(1, 24, 1)] = 0.989
        pgm_function5[(1, 24, 2)] = 0.989
        pgm_function5[(1, 25, 1)] = 0.989
        pgm_function5[(1, 25, 2)] = 0.989
        pgm_function5[(1, 26, 1)] = 0.989
        pgm_function5[(1, 26, 2)] = 0.989
        pgm_function5[(1, 27, 1)] = 0.989
        pgm_function5[(1, 27, 2)] = 0.989
        pgm_function5[(1, 28, 1)] = 0.989
        pgm_function5[(1, 28, 2)] = 0.989
        pgm_function5[(1, 29, 1)] = 0.989
        pgm_function5[(1, 29, 2)] = 0.989
        pgm_function5[(1, 30, 1)] = 0.989
        pgm_function5[(1, 30, 2)] = 0.989
        pgm_function5[(1, 31, 1)] = 0.989
        pgm_function5[(1, 31, 2)] = 0.989
        pgm_function5[(1, 32, 1)] = 0.989
        pgm_function5[(1, 32, 2)] = 0.989
        pgm_function5[(1, 33, 1)] = 0.989
        pgm_function5[(1, 33, 2)] = 0.989
        pgm_function5[(1, 34, 1)] = 0.9998
        pgm_function5[(1, 34, 2)] = 0.9998
        pgm_function5[(1, 35, 1)] = 0.9998
        pgm_function5[(1, 35, 2)] = 0.9998
        pgm_function5[(1, 36, 1)] = 0.9998
        pgm_function5[(1, 36, 2)] = 0.9998
        pgm_function5[(1, 37, 1)] = 0.9998
        pgm_function5[(1, 37, 2)] = 0.9998
        pgm_function5[(1, 38, 1)] = 0.989
        pgm_function5[(1, 38, 2)] = 0.989
        pgm_function5[(1, 39, 1)] = 0.989
        pgm_function5[(1, 39, 2)] = 0.989
        pgm_function5[(1, 40, 1)] = 0.989
        pgm_function5[(1, 40, 2)] = 0.989
        pgm_function5[(1, 41, 1)] = 0.989
        pgm_function5[(1, 41, 2)] = 0.989
        pgm_function5[(1, 42, 1)] = 0.989
        pgm_function5[(1, 42, 2)] = 0.989
        pgm_function5[(1, 43, 1)] = 0.989
        pgm_function5[(1, 43, 2)] = 0.989
        pgm_function5[(1, 44, 1)] = 0.989
        pgm_function5[(1, 44, 2)] = 0.989
        pgm_function5[(1, 45, 1)] = 0.989
        pgm_function5[(1, 45, 2)] = 0.989
        pgm_function5[(1, 46, 1)] = 0.989
        pgm_function5[(1, 46, 2)] = 0.989
        pgm_function5[(1, 47, 1)] = 0.989
        pgm_function5[(1, 47, 2)] = 0.989
        pgm_function5[(1, 48, 1)] = 0.989
        pgm_function5[(1, 48, 2)] = 0.989
        pgm_function5[(1, 49, 1)] = 0.989
        pgm_function5[(1, 49, 2)] = 0.989
        pgm_function5[(1, 50, 1)] = 0.989
        pgm_function5[(1, 50, 2)] = 0.989
        pgm_function5[(1, 51, 1)] = 0.989
        pgm_function5[(1, 51, 2)] = 0.989
        pgm_function5[(1, 52, 1)] = 0.989
        pgm_function5[(1, 52, 2)] = 0.989
        pgm_function5[(1, 53, 1)] = 0.989
        pgm_function5[(1, 53, 2)] = 0.989
        pgm_function5[(1, 54, 1)] = 0.989
        pgm_function5[(1, 54, 2)] = 0.989
        pgm_function5[(1, 55, 1)] = 0.989
        pgm_function5[(1, 55, 2)] = 0.989
        pgm_function5[(1, 56, 1)] = 0.989
        pgm_function5[(1, 56, 2)] = 0.989
        pgm_function5[(1, 57, 1)] = 0.989
        pgm_function5[(1, 57, 2)] = 0.989
        pgm_function5[(1, 58, 1)] = 0.989
        pgm_function5[(1, 58, 2)] = 0.989
        pgm_function5[(1, 59, 1)] = 0.988
        pgm_function5[(1, 59, 2)] = 0.988
        pgm_function5[(1, 60, 1)] = 0.989
        pgm_function5[(1, 60, 2)] = 0.989
        pgm_function5[(1, 61, 1)] = 0.988
        pgm_function5[(1, 61, 2)] = 0.988
        pgm_function5[(1, 62, 1)] = 0.989
        pgm_function5[(1, 62, 2)] = 0.989
        pgm_function5[(1, 63, 1)] = 0.9989
        pgm_function5[(1, 63, 2)] = 0.9989
        pgm_function5[(1, 64, 1)] = 0.989
        pgm_function5[(1, 64, 2)] = 0.989
        pgm_function5[(1, 65, 1)] = 0.989
        pgm_function5[(1, 65, 2)] = 0.989
        pgm_function5[(1, 66, 1)] = 0.989
        pgm_function5[(1, 66, 2)] = 0.989
        pgm_function5[(1, 67, 1)] = 0.988
        pgm_function5[(1, 67, 2)] = 0.988
        pgm_function5[(1, 68, 1)] = 0.989
        pgm_function5[(1, 68, 2)] = 0.989
        pgm_function5[(1, 69, 1)] = 0.989
        pgm_function5[(1, 69, 2)] = 0.989
        pgm_function5[(1, 70, 1)] = 0.988
        pgm_function5[(1, 70, 2)] = 0.988
        pgm_function5[(1, 71, 1)] = 0.988
        pgm_function5[(1, 71, 2)] = 0.988
        pgm_function5[(1, 72, 1)] = 0.988
        pgm_function5[(1, 72, 2)] = 0.988
        pgm_function5[(1, 73, 1)] = 0.989
        pgm_function5[(1, 73, 2)] = 0.989
        pgm_function5[(1, 74, 1)] = 0.989
        pgm_function5[(1, 74, 2)] = 0.989
        pgm_function5[(1, 75, 1)] = 0.989
        pgm_function5[(1, 75, 2)] = 0.989
        pgm_function5[(2, 0, 1)] = 0.01
        pgm_function5[(2, 0, 2)] = 0.01
        pgm_function5[(2, 1, 1)] = 0.01
        pgm_function5[(2, 1, 2)] = 0.01
        pgm_function5[(2, 2, 1)] = 0.01
        pgm_function5[(2, 2, 2)] = 0.01
        pgm_function5[(2, 3, 1)] = 0.01
        pgm_function5[(2, 3, 2)] = 0.01
        pgm_function5[(2, 4, 1)] = 0.01
        pgm_function5[(2, 4, 2)] = 0.01
        pgm_function5[(2, 5, 1)] = 0.01
        pgm_function5[(2, 5, 2)] = 0.01
        pgm_function5[(2, 6, 1)] = 0.02
        pgm_function5[(2, 6, 2)] = 0.02
        pgm_function5[(2, 7, 1)] = 0.01
        pgm_function5[(2, 7, 2)] = 0.01
        pgm_function5[(2, 8, 1)] = 0.01
        pgm_function5[(2, 8, 2)] = 0.01
        pgm_function5[(2, 9, 1)] = 0.01
        pgm_function5[(2, 9, 2)] = 0.01
        pgm_function5[(2, 10, 1)] = 0.01
        pgm_function5[(2, 10, 2)] = 0.01
        pgm_function5[(2, 11, 1)] = 0.01
        pgm_function5[(2, 11, 2)] = 0.01
        pgm_function5[(2, 12, 1)] = 0.01
        pgm_function5[(2, 12, 2)] = 0.01
        pgm_function5[(2, 13, 1)] = 0.01
        pgm_function5[(2, 13, 2)] = 0.01
        pgm_function5[(2, 14, 1)] = 0.01
        pgm_function5[(2, 14, 2)] = 0.01
        pgm_function5[(2, 15, 1)] = 0.01
        pgm_function5[(2, 15, 2)] = 0.01
        pgm_function5[(2, 16, 1)] = 0.01
        pgm_function5[(2, 16, 2)] = 0.01
        pgm_function5[(2, 17, 1)] = 0.01
        pgm_function5[(2, 17, 2)] = 0.01
        pgm_function5[(2, 18, 1)] = 0.01
        pgm_function5[(2, 18, 2)] = 0.01
        pgm_function5[(2, 19, 1)] = 0.01
        pgm_function5[(2, 19, 2)] = 0.01
        pgm_function5[(2, 20, 1)] = 0.01
        pgm_function5[(2, 20, 2)] = 0.01
        pgm_function5[(2, 21, 1)] = 0.01
        pgm_function5[(2, 21, 2)] = 0.01
        pgm_function5[(2, 22, 1)] = 0.01
        pgm_function5[(2, 22, 2)] = 0.01
        pgm_function5[(2, 23, 1)] = 0.01
        pgm_function5[(2, 23, 2)] = 0.01
        pgm_function5[(2, 24, 1)] = 0.01
        pgm_function5[(2, 24, 2)] = 0.01
        pgm_function5[(2, 25, 1)] = 0.01
        pgm_function5[(2, 25, 2)] = 0.01
        pgm_function5[(2, 26, 1)] = 0.01
        pgm_function5[(2, 26, 2)] = 0.01
        pgm_function5[(2, 27, 1)] = 0.01
        pgm_function5[(2, 27, 2)] = 0.01
        pgm_function5[(2, 28, 1)] = 0.01
        pgm_function5[(2, 28, 2)] = 0.01
        pgm_function5[(2, 29, 1)] = 0.01
        pgm_function5[(2, 29, 2)] = 0.01
        pgm_function5[(2, 30, 1)] = 0.01
        pgm_function5[(2, 30, 2)] = 0.01
        pgm_function5[(2, 31, 1)] = 0.01
        pgm_function5[(2, 31, 2)] = 0.01
        pgm_function5[(2, 32, 1)] = 0.01
        pgm_function5[(2, 32, 2)] = 0.01
        pgm_function5[(2, 33, 1)] = 0.01
        pgm_function5[(2, 33, 2)] = 0.01
        pgm_function5[(2, 34, 1)] = 0.0001
        pgm_function5[(2, 34, 2)] = 0.0001
        pgm_function5[(2, 35, 1)] = 0.0001
        pgm_function5[(2, 35, 2)] = 0.0001
        pgm_function5[(2, 36, 1)] = 0.0001
        pgm_function5[(2, 36, 2)] = 0.0001
        pgm_function5[(2, 37, 1)] = 0.0001
        pgm_function5[(2, 37, 2)] = 0.0001
        pgm_function5[(2, 38, 1)] = 0.01
        pgm_function5[(2, 38, 2)] = 0.01
        pgm_function5[(2, 39, 1)] = 0.01
        pgm_function5[(2, 39, 2)] = 0.01
        pgm_function5[(2, 40, 1)] = 0.01
        pgm_function5[(2, 40, 2)] = 0.01
        pgm_function5[(2, 41, 1)] = 0.01
        pgm_function5[(2, 41, 2)] = 0.01
        pgm_function5[(2, 42, 1)] = 0.01
        pgm_function5[(2, 42, 2)] = 0.01
        pgm_function5[(2, 43, 1)] = 0.01
        pgm_function5[(2, 43, 2)] = 0.01
        pgm_function5[(2, 44, 1)] = 0.01
        pgm_function5[(2, 44, 2)] = 0.01
        pgm_function5[(2, 45, 1)] = 0.01
        pgm_function5[(2, 45, 2)] = 0.01
        pgm_function5[(2, 46, 1)] = 0.01
        pgm_function5[(2, 46, 2)] = 0.01
        pgm_function5[(2, 47, 1)] = 0.01
        pgm_function5[(2, 47, 2)] = 0.01
        pgm_function5[(2, 48, 1)] = 0.01
        pgm_function5[(2, 48, 2)] = 0.01
        pgm_function5[(2, 49, 1)] = 0.01
        pgm_function5[(2, 49, 2)] = 0.01
        pgm_function5[(2, 50, 1)] = 0.01
        pgm_function5[(2, 50, 2)] = 0.01
        pgm_function5[(2, 51, 1)] = 0.01
        pgm_function5[(2, 51, 2)] = 0.01
        pgm_function5[(2, 52, 1)] = 0.01
        pgm_function5[(2, 52, 2)] = 0.01
        pgm_function5[(2, 53, 1)] = 0.01
        pgm_function5[(2, 53, 2)] = 0.01
        pgm_function5[(2, 54, 1)] = 0.01
        pgm_function5[(2, 54, 2)] = 0.01
        pgm_function5[(2, 55, 1)] = 0.01
        pgm_function5[(2, 55, 2)] = 0.01
        pgm_function5[(2, 56, 1)] = 0.01
        pgm_function5[(2, 56, 2)] = 0.01
        pgm_function5[(2, 57, 1)] = 0.01
        pgm_function5[(2, 57, 2)] = 0.01
        pgm_function5[(2, 58, 1)] = 0.01
        pgm_function5[(2, 58, 2)] = 0.01
        pgm_function5[(2, 59, 1)] = 0.01
        pgm_function5[(2, 59, 2)] = 0.01
        pgm_function5[(2, 60, 1)] = 0.01
        pgm_function5[(2, 60, 2)] = 0.01
        pgm_function5[(2, 61, 1)] = 0.01
        pgm_function5[(2, 61, 2)] = 0.01
        pgm_function5[(2, 62, 1)] = 0.01
        pgm_function5[(2, 62, 2)] = 0.01
        pgm_function5[(2, 63, 1)] = 0.001
        pgm_function5[(2, 63, 2)] = 0.001
        pgm_function5[(2, 64, 1)] = 0.01
        pgm_function5[(2, 64, 2)] = 0.01
        pgm_function5[(2, 65, 1)] = 0.01
        pgm_function5[(2, 65, 2)] = 0.01
        pgm_function5[(2, 66, 1)] = 0.01
        pgm_function5[(2, 66, 2)] = 0.01
        pgm_function5[(2, 67, 1)] = 0.01
        pgm_function5[(2, 67, 2)] = 0.01
        pgm_function5[(2, 68, 1)] = 0.01
        pgm_function5[(2, 68, 2)] = 0.01
        pgm_function5[(2, 69, 1)] = 0.01
        pgm_function5[(2, 69, 2)] = 0.01
        pgm_function5[(2, 70, 1)] = 0.01
        pgm_function5[(2, 70, 2)] = 0.01
        pgm_function5[(2, 71, 1)] = 0.01
        pgm_function5[(2, 71, 2)] = 0.01
        pgm_function5[(2, 72, 1)] = 0.01
        pgm_function5[(2, 72, 2)] = 0.01
        pgm_function5[(2, 73, 1)] = 0.01
        pgm_function5[(2, 73, 2)] = 0.01
        pgm_function5[(2, 74, 1)] = 0.01
        pgm_function5[(2, 74, 2)] = 0.01
        pgm_function5[(2, 75, 1)] = 0.01
        pgm_function5[(2, 75, 2)] = 0.01
        pgm_function5[(3, 0, 1)] = 0.001
        pgm_function5[(3, 0, 2)] = 0.001
        pgm_function5[(3, 1, 1)] = 0.001
        pgm_function5[(3, 1, 2)] = 0.001
        pgm_function5[(3, 2, 1)] = 0.001
        pgm_function5[(3, 2, 2)] = 0.001
        pgm_function5[(3, 3, 1)] = 0.001
        pgm_function5[(3, 3, 2)] = 0.001
        pgm_function5[(3, 4, 1)] = 0.001
        pgm_function5[(3, 4, 2)] = 0.001
        pgm_function5[(3, 5, 1)] = 0.001
        pgm_function5[(3, 5, 2)] = 0.001
        pgm_function5[(3, 6, 1)] = 0.97999
        pgm_function5[(3, 6, 2)] = 0.97999
        pgm_function5[(3, 7, 1)] = 0.002
        pgm_function5[(3, 7, 2)] = 0.002
        pgm_function5[(3, 8, 1)] = 0.001
        pgm_function5[(3, 8, 2)] = 0.001
        pgm_function5[(3, 9, 1)] = 0.001
        pgm_function5[(3, 9, 2)] = 0.001
        pgm_function5[(3, 10, 1)] = 0.001
        pgm_function5[(3, 10, 2)] = 0.001
        pgm_function5[(3, 11, 1)] = 0.001
        pgm_function5[(3, 11, 2)] = 0.001
        pgm_function5[(3, 12, 1)] = 0.001
        pgm_function5[(3, 12, 2)] = 0.001
        pgm_function5[(3, 13, 1)] = 0.001
        pgm_function5[(3, 13, 2)] = 0.001
        pgm_function5[(3, 14, 1)] = 0.001
        pgm_function5[(3, 14, 2)] = 0.001
        pgm_function5[(3, 15, 1)] = 0.001
        pgm_function5[(3, 15, 2)] = 0.001
        pgm_function5[(3, 16, 1)] = 0.001
        pgm_function5[(3, 16, 2)] = 0.001
        pgm_function5[(3, 17, 1)] = 0.001
        pgm_function5[(3, 17, 2)] = 0.001
        pgm_function5[(3, 18, 1)] = 0.001
        pgm_function5[(3, 18, 2)] = 0.001
        pgm_function5[(3, 19, 1)] = 0.001
        pgm_function5[(3, 19, 2)] = 0.001
        pgm_function5[(3, 20, 1)] = 0.001
        pgm_function5[(3, 20, 2)] = 0.001
        pgm_function5[(3, 21, 1)] = 0.001
        pgm_function5[(3, 21, 2)] = 0.001
        pgm_function5[(3, 22, 1)] = 0.001
        pgm_function5[(3, 22, 2)] = 0.001
        pgm_function5[(3, 23, 1)] = 0.001
        pgm_function5[(3, 23, 2)] = 0.001
        pgm_function5[(3, 24, 1)] = 0.001
        pgm_function5[(3, 24, 2)] = 0.001
        pgm_function5[(3, 25, 1)] = 0.001
        pgm_function5[(3, 25, 2)] = 0.001
        pgm_function5[(3, 26, 1)] = 0.001
        pgm_function5[(3, 26, 2)] = 0.001
        pgm_function5[(3, 27, 1)] = 0.001
        pgm_function5[(3, 27, 2)] = 0.001
        pgm_function5[(3, 28, 1)] = 0.001
        pgm_function5[(3, 28, 2)] = 0.001
        pgm_function5[(3, 29, 1)] = 0.001
        pgm_function5[(3, 29, 2)] = 0.001
        pgm_function5[(3, 30, 1)] = 0.001
        pgm_function5[(3, 30, 2)] = 0.001
        pgm_function5[(3, 31, 1)] = 0.001
        pgm_function5[(3, 31, 2)] = 0.001
        pgm_function5[(3, 32, 1)] = 0.001
        pgm_function5[(3, 32, 2)] = 0.001
        pgm_function5[(3, 33, 1)] = 0.001
        pgm_function5[(3, 33, 2)] = 0.001
        pgm_function5[(3, 34, 1)] = 0.0001
        pgm_function5[(3, 34, 2)] = 0.0001
        pgm_function5[(3, 35, 1)] = 0.0001
        pgm_function5[(3, 35, 2)] = 0.0001
        pgm_function5[(3, 36, 1)] = 0.0001
        pgm_function5[(3, 36, 2)] = 0.0001
        pgm_function5[(3, 37, 1)] = 0.0001
        pgm_function5[(3, 37, 2)] = 0.0001
        pgm_function5[(3, 38, 1)] = 0.001
        pgm_function5[(3, 38, 2)] = 0.001
        pgm_function5[(3, 39, 1)] = 0.001
        pgm_function5[(3, 39, 2)] = 0.001
        pgm_function5[(3, 40, 1)] = 0.001
        pgm_function5[(3, 40, 2)] = 0.001
        pgm_function5[(3, 41, 1)] = 0.001
        pgm_function5[(3, 41, 2)] = 0.001
        pgm_function5[(3, 42, 1)] = 0.001
        pgm_function5[(3, 42, 2)] = 0.001
        pgm_function5[(3, 43, 1)] = 0.001
        pgm_function5[(3, 43, 2)] = 0.001
        pgm_function5[(3, 44, 1)] = 0.001
        pgm_function5[(3, 44, 2)] = 0.001
        pgm_function5[(3, 45, 1)] = 0.001
        pgm_function5[(3, 45, 2)] = 0.001
        pgm_function5[(3, 46, 1)] = 0.001
        pgm_function5[(3, 46, 2)] = 0.001
        pgm_function5[(3, 47, 1)] = 0.001
        pgm_function5[(3, 47, 2)] = 0.001
        pgm_function5[(3, 48, 1)] = 0.001
        pgm_function5[(3, 48, 2)] = 0.001
        pgm_function5[(3, 49, 1)] = 0.001
        pgm_function5[(3, 49, 2)] = 0.001
        pgm_function5[(3, 50, 1)] = 0.001
        pgm_function5[(3, 50, 2)] = 0.001
        pgm_function5[(3, 51, 1)] = 0.001
        pgm_function5[(3, 51, 2)] = 0.001
        pgm_function5[(3, 52, 1)] = 0.001
        pgm_function5[(3, 52, 2)] = 0.001
        pgm_function5[(3, 53, 1)] = 0.001
        pgm_function5[(3, 53, 2)] = 0.001
        pgm_function5[(3, 54, 1)] = 0.001
        pgm_function5[(3, 54, 2)] = 0.001
        pgm_function5[(3, 55, 1)] = 0.001
        pgm_function5[(3, 55, 2)] = 0.001
        pgm_function5[(3, 56, 1)] = 0.001
        pgm_function5[(3, 56, 2)] = 0.001
        pgm_function5[(3, 57, 1)] = 0.001
        pgm_function5[(3, 57, 2)] = 0.001
        pgm_function5[(3, 58, 1)] = 0.001
        pgm_function5[(3, 58, 2)] = 0.001
        pgm_function5[(3, 59, 1)] = 0.002
        pgm_function5[(3, 59, 2)] = 0.002
        pgm_function5[(3, 60, 1)] = 0.001
        pgm_function5[(3, 60, 2)] = 0.001
        pgm_function5[(3, 61, 1)] = 0.002
        pgm_function5[(3, 61, 2)] = 0.002
        pgm_function5[(3, 62, 1)] = 0.001
        pgm_function5[(3, 62, 2)] = 0.001
        pgm_function5[(3, 63, 1)] = 0.0001
        pgm_function5[(3, 63, 2)] = 0.0001
        pgm_function5[(3, 64, 1)] = 0.001
        pgm_function5[(3, 64, 2)] = 0.001
        pgm_function5[(3, 65, 1)] = 0.001
        pgm_function5[(3, 65, 2)] = 0.001
        pgm_function5[(3, 66, 1)] = 0.001
        pgm_function5[(3, 66, 2)] = 0.001
        pgm_function5[(3, 67, 1)] = 0.002
        pgm_function5[(3, 67, 2)] = 0.002
        pgm_function5[(3, 68, 1)] = 0.001
        pgm_function5[(3, 68, 2)] = 0.001
        pgm_function5[(3, 69, 1)] = 0.001
        pgm_function5[(3, 69, 2)] = 0.001
        pgm_function5[(3, 70, 1)] = 0.002
        pgm_function5[(3, 70, 2)] = 0.002
        pgm_function5[(3, 71, 1)] = 0.002
        pgm_function5[(3, 71, 2)] = 0.002
        pgm_function5[(3, 72, 1)] = 0.002
        pgm_function5[(3, 72, 2)] = 0.002
        pgm_function5[(3, 73, 1)] = 0.001
        pgm_function5[(3, 73, 2)] = 0.001
        pgm_function5[(3, 74, 1)] = 0.001
        pgm_function5[(3, 74, 2)] = 0.001
        pgm_function5[(3, 75, 1)] = 0.001
        pgm_function5[(3, 75, 2)] = 0.001

        pgm_function6 = pgm_factor6.set_sparse()
        pgm_function6[(0, 0)] = 0.989
        pgm_function6[(0, 1)] = 0.989
        pgm_function6[(0, 2)] = 0.989
        pgm_function6[(0, 3)] = 0.989
        pgm_function6[(0, 4)] = 0.83
        pgm_function6[(0, 5)] = 0.989
        pgm_function6[(0, 6)] = 0.989
        pgm_function6[(0, 7)] = 0.989
        pgm_function6[(0, 8)] = 0.989
        pgm_function6[(0, 10)] = 0.989
        pgm_function6[(0, 11)] = 0.989
        pgm_function6[(0, 12)] = 0.989
        pgm_function6[(0, 13)] = 0.989
        pgm_function6[(0, 14)] = 0.989
        pgm_function6[(0, 15)] = 0.989
        pgm_function6[(0, 16)] = 0.989
        pgm_function6[(0, 17)] = 0.989
        pgm_function6[(0, 18)] = 0.989
        pgm_function6[(0, 19)] = 0.989
        pgm_function6[(0, 20)] = 0.989
        pgm_function6[(0, 21)] = 0.989
        pgm_function6[(0, 22)] = 0.989
        pgm_function6[(0, 23)] = 0.989
        pgm_function6[(0, 24)] = 0.989
        pgm_function6[(0, 25)] = 0.989
        pgm_function6[(0, 26)] = 0.989
        pgm_function6[(0, 27)] = 0.989
        pgm_function6[(0, 28)] = 0.989
        pgm_function6[(0, 29)] = 0.989
        pgm_function6[(0, 30)] = 0.989
        pgm_function6[(0, 31)] = 0.989
        pgm_function6[(0, 32)] = 0.989
        pgm_function6[(0, 33)] = 0.989
        pgm_function6[(0, 34)] = 0.989
        pgm_function6[(0, 35)] = 0.989
        pgm_function6[(0, 36)] = 0.989
        pgm_function6[(0, 37)] = 0.989
        pgm_function6[(0, 38)] = 0.989
        pgm_function6[(0, 39)] = 0.989
        pgm_function6[(0, 40)] = 0.989
        pgm_function6[(0, 41)] = 0.989
        pgm_function6[(0, 42)] = 0.989
        pgm_function6[(0, 43)] = 0.989
        pgm_function6[(0, 44)] = 0.989
        pgm_function6[(0, 45)] = 0.989
        pgm_function6[(0, 46)] = 0.989
        pgm_function6[(0, 47)] = 0.989
        pgm_function6[(0, 48)] = 0.989
        pgm_function6[(0, 49)] = 0.989
        pgm_function6[(0, 50)] = 0.989
        pgm_function6[(0, 51)] = 0.989
        pgm_function6[(0, 52)] = 0.989
        pgm_function6[(0, 53)] = 0.989
        pgm_function6[(0, 54)] = 0.989
        pgm_function6[(0, 55)] = 0.989
        pgm_function6[(0, 56)] = 0.989
        pgm_function6[(0, 57)] = 0.989
        pgm_function6[(0, 58)] = 0.989
        pgm_function6[(0, 59)] = 0.989
        pgm_function6[(0, 60)] = 0.989
        pgm_function6[(0, 61)] = 0.989
        pgm_function6[(0, 62)] = 0.989
        pgm_function6[(0, 63)] = 0.989
        pgm_function6[(0, 64)] = 0.989
        pgm_function6[(0, 65)] = 0.989
        pgm_function6[(0, 66)] = 0.989
        pgm_function6[(0, 67)] = 0.989
        pgm_function6[(0, 68)] = 0.989
        pgm_function6[(0, 69)] = 0.989
        pgm_function6[(0, 70)] = 0.989
        pgm_function6[(0, 71)] = 0.989
        pgm_function6[(0, 72)] = 0.989
        pgm_function6[(0, 73)] = 0.989
        pgm_function6[(0, 74)] = 0.989
        pgm_function6[(0, 75)] = 0.989
        pgm_function6[(1, 0)] = 0.01
        pgm_function6[(1, 1)] = 0.01
        pgm_function6[(1, 2)] = 0.01
        pgm_function6[(1, 3)] = 0.01
        pgm_function6[(1, 4)] = 0.02
        pgm_function6[(1, 5)] = 0.01
        pgm_function6[(1, 6)] = 0.01
        pgm_function6[(1, 7)] = 0.01
        pgm_function6[(1, 8)] = 0.01
        pgm_function6[(1, 10)] = 0.01
        pgm_function6[(1, 11)] = 0.01
        pgm_function6[(1, 12)] = 0.01
        pgm_function6[(1, 13)] = 0.01
        pgm_function6[(1, 14)] = 0.01
        pgm_function6[(1, 15)] = 0.01
        pgm_function6[(1, 16)] = 0.01
        pgm_function6[(1, 17)] = 0.01
        pgm_function6[(1, 18)] = 0.01
        pgm_function6[(1, 19)] = 0.01
        pgm_function6[(1, 20)] = 0.01
        pgm_function6[(1, 21)] = 0.01
        pgm_function6[(1, 22)] = 0.01
        pgm_function6[(1, 23)] = 0.01
        pgm_function6[(1, 24)] = 0.01
        pgm_function6[(1, 25)] = 0.01
        pgm_function6[(1, 26)] = 0.01
        pgm_function6[(1, 27)] = 0.01
        pgm_function6[(1, 28)] = 0.01
        pgm_function6[(1, 29)] = 0.01
        pgm_function6[(1, 30)] = 0.01
        pgm_function6[(1, 31)] = 0.01
        pgm_function6[(1, 32)] = 0.01
        pgm_function6[(1, 33)] = 0.01
        pgm_function6[(1, 34)] = 0.01
        pgm_function6[(1, 35)] = 0.01
        pgm_function6[(1, 36)] = 0.01
        pgm_function6[(1, 37)] = 0.01
        pgm_function6[(1, 38)] = 0.01
        pgm_function6[(1, 39)] = 0.01
        pgm_function6[(1, 40)] = 0.01
        pgm_function6[(1, 41)] = 0.01
        pgm_function6[(1, 42)] = 0.01
        pgm_function6[(1, 43)] = 0.01
        pgm_function6[(1, 44)] = 0.01
        pgm_function6[(1, 45)] = 0.01
        pgm_function6[(1, 46)] = 0.01
        pgm_function6[(1, 47)] = 0.01
        pgm_function6[(1, 48)] = 0.01
        pgm_function6[(1, 49)] = 0.01
        pgm_function6[(1, 50)] = 0.01
        pgm_function6[(1, 51)] = 0.01
        pgm_function6[(1, 52)] = 0.01
        pgm_function6[(1, 53)] = 0.01
        pgm_function6[(1, 54)] = 0.01
        pgm_function6[(1, 55)] = 0.01
        pgm_function6[(1, 56)] = 0.01
        pgm_function6[(1, 57)] = 0.01
        pgm_function6[(1, 58)] = 0.01
        pgm_function6[(1, 59)] = 0.01
        pgm_function6[(1, 60)] = 0.01
        pgm_function6[(1, 61)] = 0.01
        pgm_function6[(1, 62)] = 0.01
        pgm_function6[(1, 63)] = 0.01
        pgm_function6[(1, 64)] = 0.01
        pgm_function6[(1, 65)] = 0.01
        pgm_function6[(1, 66)] = 0.01
        pgm_function6[(1, 67)] = 0.01
        pgm_function6[(1, 68)] = 0.01
        pgm_function6[(1, 69)] = 0.01
        pgm_function6[(1, 70)] = 0.01
        pgm_function6[(1, 71)] = 0.01
        pgm_function6[(1, 72)] = 0.01
        pgm_function6[(1, 73)] = 0.01
        pgm_function6[(1, 74)] = 0.01
        pgm_function6[(1, 75)] = 0.01
        pgm_function6[(2, 0)] = 0.001
        pgm_function6[(2, 1)] = 0.001
        pgm_function6[(2, 2)] = 0.001
        pgm_function6[(2, 3)] = 0.001
        pgm_function6[(2, 4)] = 0.1
        pgm_function6[(2, 5)] = 0.001
        pgm_function6[(2, 6)] = 0.001
        pgm_function6[(2, 7)] = 0.001
        pgm_function6[(2, 8)] = 0.001
        pgm_function6[(2, 9)] = 0.05
        pgm_function6[(2, 10)] = 0.001
        pgm_function6[(2, 11)] = 0.001
        pgm_function6[(2, 12)] = 0.001
        pgm_function6[(2, 13)] = 0.001
        pgm_function6[(2, 14)] = 0.001
        pgm_function6[(2, 15)] = 0.001
        pgm_function6[(2, 16)] = 0.001
        pgm_function6[(2, 17)] = 0.001
        pgm_function6[(2, 18)] = 0.001
        pgm_function6[(2, 19)] = 0.001
        pgm_function6[(2, 20)] = 0.001
        pgm_function6[(2, 21)] = 0.001
        pgm_function6[(2, 22)] = 0.001
        pgm_function6[(2, 23)] = 0.001
        pgm_function6[(2, 24)] = 0.001
        pgm_function6[(2, 25)] = 0.001
        pgm_function6[(2, 26)] = 0.001
        pgm_function6[(2, 27)] = 0.001
        pgm_function6[(2, 28)] = 0.001
        pgm_function6[(2, 29)] = 0.001
        pgm_function6[(2, 30)] = 0.001
        pgm_function6[(2, 31)] = 0.001
        pgm_function6[(2, 32)] = 0.001
        pgm_function6[(2, 33)] = 0.001
        pgm_function6[(2, 34)] = 0.001
        pgm_function6[(2, 35)] = 0.001
        pgm_function6[(2, 36)] = 0.001
        pgm_function6[(2, 37)] = 0.001
        pgm_function6[(2, 38)] = 0.001
        pgm_function6[(2, 39)] = 0.001
        pgm_function6[(2, 40)] = 0.001
        pgm_function6[(2, 41)] = 0.001
        pgm_function6[(2, 42)] = 0.001
        pgm_function6[(2, 43)] = 0.001
        pgm_function6[(2, 44)] = 0.001
        pgm_function6[(2, 45)] = 0.001
        pgm_function6[(2, 46)] = 0.001
        pgm_function6[(2, 47)] = 0.001
        pgm_function6[(2, 48)] = 0.001
        pgm_function6[(2, 49)] = 0.001
        pgm_function6[(2, 50)] = 0.001
        pgm_function6[(2, 51)] = 0.001
        pgm_function6[(2, 52)] = 0.001
        pgm_function6[(2, 53)] = 0.001
        pgm_function6[(2, 54)] = 0.001
        pgm_function6[(2, 55)] = 0.001
        pgm_function6[(2, 56)] = 0.001
        pgm_function6[(2, 57)] = 0.001
        pgm_function6[(2, 58)] = 0.001
        pgm_function6[(2, 59)] = 0.001
        pgm_function6[(2, 60)] = 0.001
        pgm_function6[(2, 61)] = 0.001
        pgm_function6[(2, 62)] = 0.001
        pgm_function6[(2, 63)] = 0.001
        pgm_function6[(2, 64)] = 0.001
        pgm_function6[(2, 65)] = 0.001
        pgm_function6[(2, 66)] = 0.001
        pgm_function6[(2, 67)] = 0.001
        pgm_function6[(2, 68)] = 0.001
        pgm_function6[(2, 69)] = 0.001
        pgm_function6[(2, 70)] = 0.001
        pgm_function6[(2, 71)] = 0.001
        pgm_function6[(2, 72)] = 0.001
        pgm_function6[(2, 73)] = 0.001
        pgm_function6[(2, 74)] = 0.001
        pgm_function6[(2, 75)] = 0.001
        pgm_function6[(3, 4)] = 0.05
        pgm_function6[(3, 9)] = 0.95

        pgm_function7 = pgm_factor7.set_sparse()
        pgm_function7[(0, 0)] = 0.979020979
        pgm_function7[(0, 1)] = 0.979020979
        pgm_function7[(0, 2)] = 0.979020979
        pgm_function7[(0, 3)] = 0.979020979
        pgm_function7[(0, 4)] = 0.28
        pgm_function7[(0, 5)] = 0.979020979
        pgm_function7[(0, 6)] = 0.979020979
        pgm_function7[(0, 7)] = 0.979020979
        pgm_function7[(0, 8)] = 0.699300699
        pgm_function7[(0, 9)] = 0.979020979
        pgm_function7[(0, 10)] = 0.979020979
        pgm_function7[(0, 11)] = 0.01
        pgm_function7[(0, 13)] = 0.979020979
        pgm_function7[(0, 14)] = 0.4899
        pgm_function7[(0, 15)] = 0.4899
        pgm_function7[(0, 16)] = 0.979020979
        pgm_function7[(0, 17)] = 0.979020979
        pgm_function7[(0, 18)] = 0.979020979
        pgm_function7[(0, 19)] = 0.969
        pgm_function7[(0, 20)] = 0.979020979
        pgm_function7[(0, 21)] = 0.979020979
        pgm_function7[(0, 22)] = 0.899100899
        pgm_function7[(0, 23)] = 0.979020979
        pgm_function7[(0, 25)] = 0.95
        pgm_function7[(0, 26)] = 0.95
        pgm_function7[(0, 27)] = 0.94
        pgm_function7[(0, 28)] = 0.94
        pgm_function7[(0, 29)] = 0.95
        pgm_function7[(0, 30)] = 0.95
        pgm_function7[(0, 31)] = 0.95
        pgm_function7[(0, 32)] = 0.95
        pgm_function7[(0, 33)] = 0.95
        pgm_function7[(0, 34)] = 0.95
        pgm_function7[(0, 35)] = 0.95
        pgm_function7[(0, 36)] = 0.95
        pgm_function7[(0, 37)] = 0.95
        pgm_function7[(0, 38)] = 0.95
        pgm_function7[(0, 39)] = 0.95
        pgm_function7[(0, 40)] = 0.95
        pgm_function7[(0, 41)] = 0.95
        pgm_function7[(0, 42)] = 0.95
        pgm_function7[(0, 43)] = 0.95
        pgm_function7[(0, 44)] = 0.95
        pgm_function7[(0, 45)] = 0.95
        pgm_function7[(0, 46)] = 0.95
        pgm_function7[(0, 47)] = 0.95
        pgm_function7[(0, 48)] = 0.95
        pgm_function7[(0, 49)] = 0.95
        pgm_function7[(0, 50)] = 0.95
        pgm_function7[(0, 51)] = 0.95
        pgm_function7[(0, 52)] = 0.95
        pgm_function7[(0, 53)] = 0.95
        pgm_function7[(0, 54)] = 0.95
        pgm_function7[(0, 55)] = 0.95
        pgm_function7[(0, 56)] = 0.95
        pgm_function7[(0, 57)] = 0.95
        pgm_function7[(0, 58)] = 0.979020979
        pgm_function7[(0, 59)] = 0.979020979
        pgm_function7[(0, 60)] = 0.979020979
        pgm_function7[(0, 61)] = 0.4899
        pgm_function7[(0, 62)] = 0.95
        pgm_function7[(0, 63)] = 0.95
        pgm_function7[(0, 64)] = 0.95
        pgm_function7[(0, 65)] = 0.95
        pgm_function7[(0, 66)] = 0.979020979
        pgm_function7[(0, 67)] = 0.2
        pgm_function7[(0, 68)] = 0.979020979
        pgm_function7[(0, 69)] = 0.979020979
        pgm_function7[(0, 70)] = 0.8999
        pgm_function7[(0, 71)] = 0.8999
        pgm_function7[(0, 72)] = 0.8999
        pgm_function7[(0, 73)] = 0.979020979
        pgm_function7[(0, 74)] = 0.95
        pgm_function7[(0, 75)] = 0.95
        pgm_function7[(1, 0)] = 0.01998002
        pgm_function7[(1, 1)] = 0.01998002
        pgm_function7[(1, 2)] = 0.01998002
        pgm_function7[(1, 3)] = 0.01998002
        pgm_function7[(1, 4)] = 0.4
        pgm_function7[(1, 5)] = 0.01998002
        pgm_function7[(1, 6)] = 0.01998002
        pgm_function7[(1, 7)] = 0.01998002
        pgm_function7[(1, 8)] = 0.1998002
        pgm_function7[(1, 9)] = 0.01998002
        pgm_function7[(1, 10)] = 0.01998002
        pgm_function7[(1, 11)] = 0.54
        pgm_function7[(1, 12)] = 0.01
        pgm_function7[(1, 13)] = 0.01998002
        pgm_function7[(1, 14)] = 0.4
        pgm_function7[(1, 15)] = 0.4
        pgm_function7[(1, 16)] = 0.01998002
        pgm_function7[(1, 17)] = 0.01998002
        pgm_function7[(1, 18)] = 0.01998002
        pgm_function7[(1, 19)] = 0.02
        pgm_function7[(1, 20)] = 0.01998002
        pgm_function7[(1, 21)] = 0.01998002
        pgm_function7[(1, 22)] = 0.08991009
        pgm_function7[(1, 23)] = 0.01998002
        pgm_function7[(1, 24)] = 0.01
        pgm_function7[(1, 25)] = 0.01
        pgm_function7[(1, 26)] = 0.01
        pgm_function7[(1, 27)] = 0.03
        pgm_function7[(1, 28)] = 0.03
        pgm_function7[(1, 29)] = 0.01
        pgm_function7[(1, 30)] = 0.01
        pgm_function7[(1, 31)] = 0.01
        pgm_function7[(1, 32)] = 0.01
        pgm_function7[(1, 33)] = 0.01
        pgm_function7[(1, 34)] = 0.01
        pgm_function7[(1, 35)] = 0.01
        pgm_function7[(1, 36)] = 0.01
        pgm_function7[(1, 37)] = 0.01
        pgm_function7[(1, 38)] = 0.01
        pgm_function7[(1, 39)] = 0.01
        pgm_function7[(1, 40)] = 0.01
        pgm_function7[(1, 41)] = 0.01
        pgm_function7[(1, 42)] = 0.01
        pgm_function7[(1, 43)] = 0.01
        pgm_function7[(1, 44)] = 0.01
        pgm_function7[(1, 45)] = 0.01
        pgm_function7[(1, 46)] = 0.01
        pgm_function7[(1, 47)] = 0.01
        pgm_function7[(1, 48)] = 0.01
        pgm_function7[(1, 49)] = 0.01
        pgm_function7[(1, 50)] = 0.01
        pgm_function7[(1, 51)] = 0.01
        pgm_function7[(1, 52)] = 0.01
        pgm_function7[(1, 53)] = 0.01
        pgm_function7[(1, 54)] = 0.01
        pgm_function7[(1, 55)] = 0.01
        pgm_function7[(1, 56)] = 0.01
        pgm_function7[(1, 57)] = 0.01
        pgm_function7[(1, 58)] = 0.01998002
        pgm_function7[(1, 59)] = 0.01998002
        pgm_function7[(1, 60)] = 0.01998002
        pgm_function7[(1, 61)] = 0.4
        pgm_function7[(1, 62)] = 0.01
        pgm_function7[(1, 63)] = 0.01
        pgm_function7[(1, 64)] = 0.01
        pgm_function7[(1, 65)] = 0.01
        pgm_function7[(1, 66)] = 0.01998002
        pgm_function7[(1, 67)] = 0.45
        pgm_function7[(1, 68)] = 0.01998002
        pgm_function7[(1, 69)] = 0.01998002
        pgm_function7[(1, 70)] = 0.05
        pgm_function7[(1, 71)] = 0.05
        pgm_function7[(1, 72)] = 0.05
        pgm_function7[(1, 73)] = 0.01998002
        pgm_function7[(1, 74)] = 0.01
        pgm_function7[(1, 75)] = 0.01
        pgm_function7[(2, 0)] = 0.000999001
        pgm_function7[(2, 1)] = 0.000999001
        pgm_function7[(2, 2)] = 0.000999001
        pgm_function7[(2, 3)] = 0.000999001
        pgm_function7[(2, 4)] = 0.2
        pgm_function7[(2, 5)] = 0.000999001
        pgm_function7[(2, 6)] = 0.000999001
        pgm_function7[(2, 7)] = 0.000999001
        pgm_function7[(2, 8)] = 0.0999001
        pgm_function7[(2, 9)] = 0.000999001
        pgm_function7[(2, 10)] = 0.000999001
        pgm_function7[(2, 11)] = 0.25
        pgm_function7[(2, 12)] = 0.09
        pgm_function7[(2, 13)] = 0.000999001
        pgm_function7[(2, 14)] = 0.1
        pgm_function7[(2, 15)] = 0.1
        pgm_function7[(2, 16)] = 0.000999001
        pgm_function7[(2, 17)] = 0.000999001
        pgm_function7[(2, 18)] = 0.000999001
        pgm_function7[(2, 19)] = 0.01
        pgm_function7[(2, 20)] = 0.000999001
        pgm_function7[(2, 21)] = 0.000999001
        pgm_function7[(2, 22)] = 0.00999001
        pgm_function7[(2, 23)] = 0.000999001
        pgm_function7[(2, 24)] = 0.09
        pgm_function7[(2, 25)] = 0.01
        pgm_function7[(2, 26)] = 0.01
        pgm_function7[(2, 27)] = 0.02
        pgm_function7[(2, 28)] = 0.02
        pgm_function7[(2, 29)] = 0.01
        pgm_function7[(2, 30)] = 0.01
        pgm_function7[(2, 31)] = 0.01
        pgm_function7[(2, 32)] = 0.01
        pgm_function7[(2, 33)] = 0.01
        pgm_function7[(2, 34)] = 0.01
        pgm_function7[(2, 35)] = 0.01
        pgm_function7[(2, 36)] = 0.01
        pgm_function7[(2, 37)] = 0.01
        pgm_function7[(2, 38)] = 0.01
        pgm_function7[(2, 39)] = 0.01
        pgm_function7[(2, 40)] = 0.01
        pgm_function7[(2, 41)] = 0.01
        pgm_function7[(2, 42)] = 0.01
        pgm_function7[(2, 43)] = 0.01
        pgm_function7[(2, 44)] = 0.01
        pgm_function7[(2, 45)] = 0.01
        pgm_function7[(2, 46)] = 0.01
        pgm_function7[(2, 47)] = 0.01
        pgm_function7[(2, 48)] = 0.01
        pgm_function7[(2, 49)] = 0.01
        pgm_function7[(2, 50)] = 0.01
        pgm_function7[(2, 51)] = 0.01
        pgm_function7[(2, 52)] = 0.01
        pgm_function7[(2, 53)] = 0.01
        pgm_function7[(2, 54)] = 0.01
        pgm_function7[(2, 55)] = 0.01
        pgm_function7[(2, 56)] = 0.01
        pgm_function7[(2, 57)] = 0.01
        pgm_function7[(2, 58)] = 0.000999001
        pgm_function7[(2, 59)] = 0.000999001
        pgm_function7[(2, 60)] = 0.000999001
        pgm_function7[(2, 61)] = 0.1
        pgm_function7[(2, 62)] = 0.01
        pgm_function7[(2, 63)] = 0.01
        pgm_function7[(2, 64)] = 0.01
        pgm_function7[(2, 65)] = 0.01
        pgm_function7[(2, 66)] = 0.000999001
        pgm_function7[(2, 67)] = 0.2
        pgm_function7[(2, 68)] = 0.000999001
        pgm_function7[(2, 69)] = 0.000999001
        pgm_function7[(2, 70)] = 0.03
        pgm_function7[(2, 71)] = 0.03
        pgm_function7[(2, 72)] = 0.03
        pgm_function7[(2, 73)] = 0.000999001
        pgm_function7[(2, 74)] = 0.01
        pgm_function7[(2, 75)] = 0.01
        pgm_function7[(3, 4)] = 0.1
        pgm_function7[(3, 8)] = 0.000999001
        pgm_function7[(3, 11)] = 0.15
        pgm_function7[(3, 12)] = 0.6
        pgm_function7[(3, 14)] = 0.01
        pgm_function7[(3, 15)] = 0.01
        pgm_function7[(3, 19)] = 0.001
        pgm_function7[(3, 22)] = 0.000999001
        pgm_function7[(3, 24)] = 0.6
        pgm_function7[(3, 25)] = 0.02
        pgm_function7[(3, 26)] = 0.02
        pgm_function7[(3, 27)] = 0.01
        pgm_function7[(3, 28)] = 0.01
        pgm_function7[(3, 29)] = 0.02
        pgm_function7[(3, 30)] = 0.02
        pgm_function7[(3, 31)] = 0.02
        pgm_function7[(3, 32)] = 0.02
        pgm_function7[(3, 33)] = 0.02
        pgm_function7[(3, 34)] = 0.02
        pgm_function7[(3, 35)] = 0.02
        pgm_function7[(3, 36)] = 0.02
        pgm_function7[(3, 37)] = 0.02
        pgm_function7[(3, 38)] = 0.02
        pgm_function7[(3, 39)] = 0.02
        pgm_function7[(3, 40)] = 0.02
        pgm_function7[(3, 41)] = 0.02
        pgm_function7[(3, 42)] = 0.02
        pgm_function7[(3, 43)] = 0.02
        pgm_function7[(3, 44)] = 0.02
        pgm_function7[(3, 45)] = 0.02
        pgm_function7[(3, 46)] = 0.02
        pgm_function7[(3, 47)] = 0.02
        pgm_function7[(3, 48)] = 0.02
        pgm_function7[(3, 49)] = 0.02
        pgm_function7[(3, 50)] = 0.02
        pgm_function7[(3, 51)] = 0.02
        pgm_function7[(3, 52)] = 0.02
        pgm_function7[(3, 53)] = 0.02
        pgm_function7[(3, 54)] = 0.02
        pgm_function7[(3, 55)] = 0.02
        pgm_function7[(3, 56)] = 0.02
        pgm_function7[(3, 57)] = 0.02
        pgm_function7[(3, 61)] = 0.01
        pgm_function7[(3, 62)] = 0.02
        pgm_function7[(3, 63)] = 0.02
        pgm_function7[(3, 64)] = 0.02
        pgm_function7[(3, 65)] = 0.02
        pgm_function7[(3, 67)] = 0.1
        pgm_function7[(3, 70)] = 0.02
        pgm_function7[(3, 71)] = 0.02
        pgm_function7[(3, 72)] = 0.02
        pgm_function7[(3, 74)] = 0.02
        pgm_function7[(3, 75)] = 0.02
        pgm_function7[(4, 4)] = 0.02
        pgm_function7[(4, 11)] = 0.05
        pgm_function7[(4, 12)] = 0.3
        pgm_function7[(4, 14)] = 0.0001
        pgm_function7[(4, 15)] = 0.0001
        pgm_function7[(4, 24)] = 0.3
        pgm_function7[(4, 25)] = 0.01
        pgm_function7[(4, 26)] = 0.01
        pgm_function7[(4, 29)] = 0.01
        pgm_function7[(4, 30)] = 0.01
        pgm_function7[(4, 31)] = 0.01
        pgm_function7[(4, 32)] = 0.01
        pgm_function7[(4, 33)] = 0.01
        pgm_function7[(4, 34)] = 0.01
        pgm_function7[(4, 35)] = 0.01
        pgm_function7[(4, 36)] = 0.01
        pgm_function7[(4, 37)] = 0.01
        pgm_function7[(4, 38)] = 0.01
        pgm_function7[(4, 39)] = 0.01
        pgm_function7[(4, 40)] = 0.01
        pgm_function7[(4, 41)] = 0.01
        pgm_function7[(4, 42)] = 0.01
        pgm_function7[(4, 43)] = 0.01
        pgm_function7[(4, 44)] = 0.01
        pgm_function7[(4, 45)] = 0.01
        pgm_function7[(4, 46)] = 0.01
        pgm_function7[(4, 47)] = 0.01
        pgm_function7[(4, 48)] = 0.01
        pgm_function7[(4, 49)] = 0.01
        pgm_function7[(4, 50)] = 0.01
        pgm_function7[(4, 51)] = 0.01
        pgm_function7[(4, 52)] = 0.01
        pgm_function7[(4, 53)] = 0.01
        pgm_function7[(4, 54)] = 0.01
        pgm_function7[(4, 55)] = 0.01
        pgm_function7[(4, 56)] = 0.01
        pgm_function7[(4, 57)] = 0.01
        pgm_function7[(4, 61)] = 0.0001
        pgm_function7[(4, 62)] = 0.01
        pgm_function7[(4, 63)] = 0.01
        pgm_function7[(4, 64)] = 0.01
        pgm_function7[(4, 65)] = 0.01
        pgm_function7[(4, 67)] = 0.05
        pgm_function7[(4, 70)] = 0.0001
        pgm_function7[(4, 71)] = 0.0001
        pgm_function7[(4, 72)] = 0.0001
        pgm_function7[(4, 74)] = 0.01
        pgm_function7[(4, 75)] = 0.01

        pgm_function8 = pgm_factor8.set_sparse()
        pgm_function8[(0, 0, 0)] = 0.99
        pgm_function8[(0, 0, 1)] = 0.97
        pgm_function8[(0, 0, 2)] = 0.95
        pgm_function8[(0, 0, 3)] = 0.95
        pgm_function8[(0, 1, 0)] = 0.95
        pgm_function8[(0, 1, 1)] = 0.93
        pgm_function8[(0, 1, 2)] = 0.91
        pgm_function8[(0, 1, 3)] = 0.91
        pgm_function8[(0, 2, 0)] = 0.95
        pgm_function8[(0, 2, 1)] = 0.93
        pgm_function8[(0, 2, 2)] = 0.91
        pgm_function8[(0, 2, 3)] = 0.91
        pgm_function8[(0, 3, 0)] = 0.7
        pgm_function8[(0, 3, 1)] = 0.68
        pgm_function8[(0, 3, 2)] = 0.66
        pgm_function8[(0, 3, 3)] = 0.66
        pgm_function8[(0, 4, 0)] = 0.91
        pgm_function8[(0, 4, 1)] = 0.89
        pgm_function8[(0, 4, 2)] = 0.87
        pgm_function8[(0, 4, 3)] = 0.87
        pgm_function8[(0, 5, 0)] = 0.99
        pgm_function8[(0, 5, 1)] = 0.97
        pgm_function8[(0, 5, 2)] = 0.95
        pgm_function8[(0, 5, 3)] = 0.95
        pgm_function8[(0, 6, 0)] = 0.99
        pgm_function8[(0, 6, 1)] = 0.97
        pgm_function8[(0, 6, 2)] = 0.95
        pgm_function8[(0, 6, 3)] = 0.95
        pgm_function8[(0, 7, 0)] = 0.99
        pgm_function8[(0, 7, 1)] = 0.97
        pgm_function8[(0, 7, 2)] = 0.95
        pgm_function8[(0, 7, 3)] = 0.95
        pgm_function8[(0, 8, 0)] = 0.45
        pgm_function8[(0, 8, 1)] = 0.43
        pgm_function8[(0, 8, 2)] = 0.41
        pgm_function8[(0, 8, 3)] = 0.41
        pgm_function8[(0, 9, 0)] = 0.99
        pgm_function8[(0, 9, 1)] = 0.97
        pgm_function8[(0, 9, 2)] = 0.95
        pgm_function8[(0, 9, 3)] = 0.95
        pgm_function8[(0, 10, 0)] = 0.9
        pgm_function8[(0, 10, 1)] = 0.85
        pgm_function8[(0, 10, 2)] = 0.85
        pgm_function8[(0, 10, 3)] = 0.85
        pgm_function8[(0, 11, 0)] = 0.01
        pgm_function8[(0, 11, 1)] = 0.01
        pgm_function8[(0, 11, 2)] = 0.01
        pgm_function8[(0, 11, 3)] = 0.01
        pgm_function8[(0, 12, 0)] = 0.75
        pgm_function8[(0, 12, 1)] = 0.7
        pgm_function8[(0, 12, 2)] = 0.7
        pgm_function8[(0, 12, 3)] = 0.7
        pgm_function8[(0, 13, 0)] = 0.99
        pgm_function8[(0, 13, 1)] = 0.97
        pgm_function8[(0, 13, 2)] = 0.95
        pgm_function8[(0, 13, 3)] = 0.95
        pgm_function8[(0, 14, 0)] = 0.02
        pgm_function8[(0, 14, 1)] = 0.02
        pgm_function8[(0, 14, 2)] = 0.02
        pgm_function8[(0, 14, 3)] = 0.02
        pgm_function8[(0, 15, 0)] = 0.3333333
        pgm_function8[(0, 15, 1)] = 0.03
        pgm_function8[(0, 15, 2)] = 0.03
        pgm_function8[(0, 15, 3)] = 0.03
        pgm_function8[(0, 16, 0)] = 0.99
        pgm_function8[(0, 16, 1)] = 0.97
        pgm_function8[(0, 16, 2)] = 0.95
        pgm_function8[(0, 16, 3)] = 0.95
        pgm_function8[(0, 17, 0)] = 0.99
        pgm_function8[(0, 17, 1)] = 0.97
        pgm_function8[(0, 17, 2)] = 0.95
        pgm_function8[(0, 17, 3)] = 0.95
        pgm_function8[(0, 20, 0)] = 0.79
        pgm_function8[(0, 20, 1)] = 0.77
        pgm_function8[(0, 20, 2)] = 0.75
        pgm_function8[(0, 20, 3)] = 0.75
        pgm_function8[(0, 21, 0)] = 0.99
        pgm_function8[(0, 21, 1)] = 0.97
        pgm_function8[(0, 21, 2)] = 0.95
        pgm_function8[(0, 21, 3)] = 0.95
        pgm_function8[(0, 22, 0)] = 0.899
        pgm_function8[(0, 22, 1)] = 0.879
        pgm_function8[(0, 22, 2)] = 0.859
        pgm_function8[(0, 22, 3)] = 0.859
        pgm_function8[(0, 23, 0)] = 0.9
        pgm_function8[(0, 23, 1)] = 0.85
        pgm_function8[(0, 23, 2)] = 0.85
        pgm_function8[(0, 23, 3)] = 0.85
        pgm_function8[(0, 24, 0)] = 0.75
        pgm_function8[(0, 24, 1)] = 0.7
        pgm_function8[(0, 24, 2)] = 0.7
        pgm_function8[(0, 24, 3)] = 0.7
        pgm_function8[(0, 25, 0)] = 0.99
        pgm_function8[(0, 25, 1)] = 0.97
        pgm_function8[(0, 25, 2)] = 0.95
        pgm_function8[(0, 25, 3)] = 0.95
        pgm_function8[(0, 26, 0)] = 0.99
        pgm_function8[(0, 26, 1)] = 0.97
        pgm_function8[(0, 26, 2)] = 0.95
        pgm_function8[(0, 26, 3)] = 0.95
        pgm_function8[(0, 27, 0)] = 0.99
        pgm_function8[(0, 27, 1)] = 0.97
        pgm_function8[(0, 27, 2)] = 0.95
        pgm_function8[(0, 27, 3)] = 0.95
        pgm_function8[(0, 28, 0)] = 0.99
        pgm_function8[(0, 28, 1)] = 0.97
        pgm_function8[(0, 28, 2)] = 0.95
        pgm_function8[(0, 28, 3)] = 0.95
        pgm_function8[(0, 29, 0)] = 0.99
        pgm_function8[(0, 29, 1)] = 0.97
        pgm_function8[(0, 29, 2)] = 0.95
        pgm_function8[(0, 29, 3)] = 0.95
        pgm_function8[(0, 30, 0)] = 0.99
        pgm_function8[(0, 30, 1)] = 0.97
        pgm_function8[(0, 30, 2)] = 0.95
        pgm_function8[(0, 30, 3)] = 0.95
        pgm_function8[(0, 31, 0)] = 0.99
        pgm_function8[(0, 31, 1)] = 0.97
        pgm_function8[(0, 31, 2)] = 0.95
        pgm_function8[(0, 31, 3)] = 0.95
        pgm_function8[(0, 32, 0)] = 0.99
        pgm_function8[(0, 32, 1)] = 0.97
        pgm_function8[(0, 32, 2)] = 0.95
        pgm_function8[(0, 32, 3)] = 0.95
        pgm_function8[(0, 33, 0)] = 0.99
        pgm_function8[(0, 33, 1)] = 0.97
        pgm_function8[(0, 33, 2)] = 0.95
        pgm_function8[(0, 33, 3)] = 0.95
        pgm_function8[(0, 34, 0)] = 0.99
        pgm_function8[(0, 34, 1)] = 0.97
        pgm_function8[(0, 34, 2)] = 0.95
        pgm_function8[(0, 34, 3)] = 0.95
        pgm_function8[(0, 35, 0)] = 0.99
        pgm_function8[(0, 35, 1)] = 0.97
        pgm_function8[(0, 35, 2)] = 0.95
        pgm_function8[(0, 35, 3)] = 0.95
        pgm_function8[(0, 36, 0)] = 0.99
        pgm_function8[(0, 36, 1)] = 0.97
        pgm_function8[(0, 36, 2)] = 0.95
        pgm_function8[(0, 36, 3)] = 0.95
        pgm_function8[(0, 37, 0)] = 0.99
        pgm_function8[(0, 37, 1)] = 0.97
        pgm_function8[(0, 37, 2)] = 0.95
        pgm_function8[(0, 37, 3)] = 0.95
        pgm_function8[(0, 38, 0)] = 0.99
        pgm_function8[(0, 38, 1)] = 0.97
        pgm_function8[(0, 38, 2)] = 0.95
        pgm_function8[(0, 38, 3)] = 0.95
        pgm_function8[(0, 39, 0)] = 0.99
        pgm_function8[(0, 39, 1)] = 0.97
        pgm_function8[(0, 39, 2)] = 0.95
        pgm_function8[(0, 39, 3)] = 0.95
        pgm_function8[(0, 40, 0)] = 0.99
        pgm_function8[(0, 40, 1)] = 0.97
        pgm_function8[(0, 40, 2)] = 0.95
        pgm_function8[(0, 40, 3)] = 0.95
        pgm_function8[(0, 41, 0)] = 0.99
        pgm_function8[(0, 41, 1)] = 0.97
        pgm_function8[(0, 41, 2)] = 0.95
        pgm_function8[(0, 41, 3)] = 0.95
        pgm_function8[(0, 42, 0)] = 0.94
        pgm_function8[(0, 42, 1)] = 0.92
        pgm_function8[(0, 42, 2)] = 0.9
        pgm_function8[(0, 42, 3)] = 0.9
        pgm_function8[(0, 43, 0)] = 0.99
        pgm_function8[(0, 43, 1)] = 0.97
        pgm_function8[(0, 43, 2)] = 0.95
        pgm_function8[(0, 43, 3)] = 0.95
        pgm_function8[(0, 44, 0)] = 0.99
        pgm_function8[(0, 44, 1)] = 0.97
        pgm_function8[(0, 44, 2)] = 0.95
        pgm_function8[(0, 44, 3)] = 0.95
        pgm_function8[(0, 45, 0)] = 0.76
        pgm_function8[(0, 45, 1)] = 0.74
        pgm_function8[(0, 45, 2)] = 0.72
        pgm_function8[(0, 45, 3)] = 0.72
        pgm_function8[(0, 46, 0)] = 0.95
        pgm_function8[(0, 46, 1)] = 0.93
        pgm_function8[(0, 46, 2)] = 0.91
        pgm_function8[(0, 46, 3)] = 0.91
        pgm_function8[(0, 47, 0)] = 0.95
        pgm_function8[(0, 47, 1)] = 0.93
        pgm_function8[(0, 47, 2)] = 0.91
        pgm_function8[(0, 47, 3)] = 0.91
        pgm_function8[(0, 48, 0)] = 0.99
        pgm_function8[(0, 48, 1)] = 0.97
        pgm_function8[(0, 48, 2)] = 0.95
        pgm_function8[(0, 48, 3)] = 0.95
        pgm_function8[(0, 49, 0)] = 0.99
        pgm_function8[(0, 49, 1)] = 0.97
        pgm_function8[(0, 49, 2)] = 0.95
        pgm_function8[(0, 49, 3)] = 0.95
        pgm_function8[(0, 50, 0)] = 0.99
        pgm_function8[(0, 50, 1)] = 0.97
        pgm_function8[(0, 50, 2)] = 0.95
        pgm_function8[(0, 50, 3)] = 0.95
        pgm_function8[(0, 51, 0)] = 0.99
        pgm_function8[(0, 51, 1)] = 0.97
        pgm_function8[(0, 51, 2)] = 0.95
        pgm_function8[(0, 51, 3)] = 0.95
        pgm_function8[(0, 52, 0)] = 0.99
        pgm_function8[(0, 52, 1)] = 0.97
        pgm_function8[(0, 52, 2)] = 0.95
        pgm_function8[(0, 52, 3)] = 0.95
        pgm_function8[(0, 53, 0)] = 0.99
        pgm_function8[(0, 53, 1)] = 0.97
        pgm_function8[(0, 53, 2)] = 0.95
        pgm_function8[(0, 53, 3)] = 0.95
        pgm_function8[(0, 54, 0)] = 0.99
        pgm_function8[(0, 54, 1)] = 0.97
        pgm_function8[(0, 54, 2)] = 0.95
        pgm_function8[(0, 54, 3)] = 0.95
        pgm_function8[(0, 55, 0)] = 0.99
        pgm_function8[(0, 55, 1)] = 0.97
        pgm_function8[(0, 55, 2)] = 0.95
        pgm_function8[(0, 55, 3)] = 0.95
        pgm_function8[(0, 56, 0)] = 0.99
        pgm_function8[(0, 56, 1)] = 0.97
        pgm_function8[(0, 56, 2)] = 0.95
        pgm_function8[(0, 56, 3)] = 0.95
        pgm_function8[(0, 57, 0)] = 0.95
        pgm_function8[(0, 57, 1)] = 0.93
        pgm_function8[(0, 57, 2)] = 0.91
        pgm_function8[(0, 57, 3)] = 0.91
        pgm_function8[(0, 58, 0)] = 0.99
        pgm_function8[(0, 58, 1)] = 0.97
        pgm_function8[(0, 58, 2)] = 0.95
        pgm_function8[(0, 58, 3)] = 0.95
        pgm_function8[(0, 59, 0)] = 0.95
        pgm_function8[(0, 59, 1)] = 0.93
        pgm_function8[(0, 59, 2)] = 0.91
        pgm_function8[(0, 59, 3)] = 0.91
        pgm_function8[(0, 60, 0)] = 0.99
        pgm_function8[(0, 60, 1)] = 0.97
        pgm_function8[(0, 60, 2)] = 0.95
        pgm_function8[(0, 60, 3)] = 0.95
        pgm_function8[(0, 61, 0)] = 0.9
        pgm_function8[(0, 61, 1)] = 0.85
        pgm_function8[(0, 61, 2)] = 0.85
        pgm_function8[(0, 61, 3)] = 0.85
        pgm_function8[(0, 62, 0)] = 0.985
        pgm_function8[(0, 62, 1)] = 0.965
        pgm_function8[(0, 62, 2)] = 0.925
        pgm_function8[(0, 62, 3)] = 0.925
        pgm_function8[(0, 63, 0)] = 0.99
        pgm_function8[(0, 63, 1)] = 0.97
        pgm_function8[(0, 63, 2)] = 0.95
        pgm_function8[(0, 63, 3)] = 0.95
        pgm_function8[(0, 64, 0)] = 0.99
        pgm_function8[(0, 64, 1)] = 0.97
        pgm_function8[(0, 64, 2)] = 0.95
        pgm_function8[(0, 64, 3)] = 0.95
        pgm_function8[(0, 65, 0)] = 0.99
        pgm_function8[(0, 65, 1)] = 0.97
        pgm_function8[(0, 65, 2)] = 0.95
        pgm_function8[(0, 65, 3)] = 0.95
        pgm_function8[(0, 66, 0)] = 0.95
        pgm_function8[(0, 66, 1)] = 0.93
        pgm_function8[(0, 66, 2)] = 0.91
        pgm_function8[(0, 66, 3)] = 0.91
        pgm_function8[(0, 68, 0)] = 0.99
        pgm_function8[(0, 68, 1)] = 0.97
        pgm_function8[(0, 68, 2)] = 0.95
        pgm_function8[(0, 68, 3)] = 0.95
        pgm_function8[(0, 69, 0)] = 0.7
        pgm_function8[(0, 69, 1)] = 0.68
        pgm_function8[(0, 69, 2)] = 0.66
        pgm_function8[(0, 69, 3)] = 0.66
        pgm_function8[(0, 70, 0)] = 0.7
        pgm_function8[(0, 70, 1)] = 0.68
        pgm_function8[(0, 70, 2)] = 0.66
        pgm_function8[(0, 70, 3)] = 0.66
        pgm_function8[(0, 71, 0)] = 0.7
        pgm_function8[(0, 71, 1)] = 0.68
        pgm_function8[(0, 71, 2)] = 0.66
        pgm_function8[(0, 71, 3)] = 0.66
        pgm_function8[(0, 72, 0)] = 0.95
        pgm_function8[(0, 72, 1)] = 0.93
        pgm_function8[(0, 72, 2)] = 0.91
        pgm_function8[(0, 72, 3)] = 0.91
        pgm_function8[(0, 73, 0)] = 0.99
        pgm_function8[(0, 73, 1)] = 0.97
        pgm_function8[(0, 73, 2)] = 0.95
        pgm_function8[(0, 73, 3)] = 0.95
        pgm_function8[(0, 74, 0)] = 0.99
        pgm_function8[(0, 74, 1)] = 0.97
        pgm_function8[(0, 74, 2)] = 0.95
        pgm_function8[(0, 74, 3)] = 0.95
        pgm_function8[(0, 75, 0)] = 0.99
        pgm_function8[(0, 75, 1)] = 0.97
        pgm_function8[(0, 75, 2)] = 0.95
        pgm_function8[(0, 75, 3)] = 0.95
        pgm_function8[(1, 0, 0)] = 0.01
        pgm_function8[(1, 0, 1)] = 0.03
        pgm_function8[(1, 0, 2)] = 0.05
        pgm_function8[(1, 0, 3)] = 0.05
        pgm_function8[(1, 1, 0)] = 0.05
        pgm_function8[(1, 1, 1)] = 0.07
        pgm_function8[(1, 1, 2)] = 0.09
        pgm_function8[(1, 1, 3)] = 0.09
        pgm_function8[(1, 2, 0)] = 0.05
        pgm_function8[(1, 2, 1)] = 0.07
        pgm_function8[(1, 2, 2)] = 0.09
        pgm_function8[(1, 2, 3)] = 0.09
        pgm_function8[(1, 3, 0)] = 0.25
        pgm_function8[(1, 3, 1)] = 0.27
        pgm_function8[(1, 3, 2)] = 0.29
        pgm_function8[(1, 3, 3)] = 0.29
        pgm_function8[(1, 4, 0)] = 0.05
        pgm_function8[(1, 4, 1)] = 0.07
        pgm_function8[(1, 4, 2)] = 0.09
        pgm_function8[(1, 4, 3)] = 0.09
        pgm_function8[(1, 5, 0)] = 0.01
        pgm_function8[(1, 5, 1)] = 0.03
        pgm_function8[(1, 5, 2)] = 0.05
        pgm_function8[(1, 5, 3)] = 0.05
        pgm_function8[(1, 6, 0)] = 0.01
        pgm_function8[(1, 6, 1)] = 0.03
        pgm_function8[(1, 6, 2)] = 0.05
        pgm_function8[(1, 6, 3)] = 0.05
        pgm_function8[(1, 7, 0)] = 0.01
        pgm_function8[(1, 7, 1)] = 0.03
        pgm_function8[(1, 7, 2)] = 0.05
        pgm_function8[(1, 7, 3)] = 0.05
        pgm_function8[(1, 8, 0)] = 0.5
        pgm_function8[(1, 8, 1)] = 0.52
        pgm_function8[(1, 8, 2)] = 0.54
        pgm_function8[(1, 8, 3)] = 0.54
        pgm_function8[(1, 9, 0)] = 0.01
        pgm_function8[(1, 9, 1)] = 0.03
        pgm_function8[(1, 9, 2)] = 0.05
        pgm_function8[(1, 9, 3)] = 0.05
        pgm_function8[(1, 10, 0)] = 0.1
        pgm_function8[(1, 10, 1)] = 0.15
        pgm_function8[(1, 10, 2)] = 0.15
        pgm_function8[(1, 10, 3)] = 0.15
        pgm_function8[(1, 11, 0)] = 0.74
        pgm_function8[(1, 11, 1)] = 0.74
        pgm_function8[(1, 11, 2)] = 0.74
        pgm_function8[(1, 11, 3)] = 0.74
        pgm_function8[(1, 12, 0)] = 0.25
        pgm_function8[(1, 12, 1)] = 0.3
        pgm_function8[(1, 12, 2)] = 0.3
        pgm_function8[(1, 12, 3)] = 0.3
        pgm_function8[(1, 13, 0)] = 0.01
        pgm_function8[(1, 13, 1)] = 0.03
        pgm_function8[(1, 13, 2)] = 0.05
        pgm_function8[(1, 13, 3)] = 0.05
        pgm_function8[(1, 14, 0)] = 0.93
        pgm_function8[(1, 14, 1)] = 0.93
        pgm_function8[(1, 14, 2)] = 0.93
        pgm_function8[(1, 14, 3)] = 0.93
        pgm_function8[(1, 15, 0)] = 0.3333333
        pgm_function8[(1, 15, 1)] = 0.96
        pgm_function8[(1, 15, 2)] = 0.96
        pgm_function8[(1, 15, 3)] = 0.96
        pgm_function8[(1, 16, 0)] = 0.01
        pgm_function8[(1, 16, 1)] = 0.03
        pgm_function8[(1, 16, 2)] = 0.05
        pgm_function8[(1, 16, 3)] = 0.05
        pgm_function8[(1, 17, 0)] = 0.01
        pgm_function8[(1, 17, 1)] = 0.03
        pgm_function8[(1, 17, 2)] = 0.05
        pgm_function8[(1, 17, 3)] = 0.05
        pgm_function8[(1, 18, 0)] = 0.1
        pgm_function8[(1, 18, 1)] = 0.1
        pgm_function8[(1, 18, 2)] = 0.1
        pgm_function8[(1, 18, 3)] = 0.1
        pgm_function8[(1, 19, 0)] = 0.8
        pgm_function8[(1, 19, 1)] = 0.8
        pgm_function8[(1, 19, 2)] = 0.8
        pgm_function8[(1, 19, 3)] = 0.8
        pgm_function8[(1, 20, 0)] = 0.2
        pgm_function8[(1, 20, 1)] = 0.22
        pgm_function8[(1, 20, 2)] = 0.24
        pgm_function8[(1, 20, 3)] = 0.24
        pgm_function8[(1, 21, 0)] = 0.01
        pgm_function8[(1, 21, 1)] = 0.03
        pgm_function8[(1, 21, 2)] = 0.05
        pgm_function8[(1, 21, 3)] = 0.05
        pgm_function8[(1, 22, 0)] = 0.1
        pgm_function8[(1, 22, 1)] = 0.12
        pgm_function8[(1, 22, 2)] = 0.14
        pgm_function8[(1, 22, 3)] = 0.14
        pgm_function8[(1, 23, 0)] = 0.1
        pgm_function8[(1, 23, 1)] = 0.15
        pgm_function8[(1, 23, 2)] = 0.15
        pgm_function8[(1, 23, 3)] = 0.15
        pgm_function8[(1, 24, 0)] = 0.25
        pgm_function8[(1, 24, 1)] = 0.3
        pgm_function8[(1, 24, 2)] = 0.3
        pgm_function8[(1, 24, 3)] = 0.3
        pgm_function8[(1, 25, 0)] = 0.01
        pgm_function8[(1, 25, 1)] = 0.03
        pgm_function8[(1, 25, 2)] = 0.05
        pgm_function8[(1, 25, 3)] = 0.05
        pgm_function8[(1, 26, 0)] = 0.01
        pgm_function8[(1, 26, 1)] = 0.03
        pgm_function8[(1, 26, 2)] = 0.05
        pgm_function8[(1, 26, 3)] = 0.05
        pgm_function8[(1, 27, 0)] = 0.01
        pgm_function8[(1, 27, 1)] = 0.03
        pgm_function8[(1, 27, 2)] = 0.05
        pgm_function8[(1, 27, 3)] = 0.05
        pgm_function8[(1, 28, 0)] = 0.01
        pgm_function8[(1, 28, 1)] = 0.03
        pgm_function8[(1, 28, 2)] = 0.05
        pgm_function8[(1, 28, 3)] = 0.05
        pgm_function8[(1, 29, 0)] = 0.01
        pgm_function8[(1, 29, 1)] = 0.03
        pgm_function8[(1, 29, 2)] = 0.05
        pgm_function8[(1, 29, 3)] = 0.05
        pgm_function8[(1, 30, 0)] = 0.01
        pgm_function8[(1, 30, 1)] = 0.03
        pgm_function8[(1, 30, 2)] = 0.05
        pgm_function8[(1, 30, 3)] = 0.05
        pgm_function8[(1, 31, 0)] = 0.01
        pgm_function8[(1, 31, 1)] = 0.03
        pgm_function8[(1, 31, 2)] = 0.05
        pgm_function8[(1, 31, 3)] = 0.05
        pgm_function8[(1, 32, 0)] = 0.01
        pgm_function8[(1, 32, 1)] = 0.03
        pgm_function8[(1, 32, 2)] = 0.05
        pgm_function8[(1, 32, 3)] = 0.05
        pgm_function8[(1, 33, 0)] = 0.01
        pgm_function8[(1, 33, 1)] = 0.03
        pgm_function8[(1, 33, 2)] = 0.05
        pgm_function8[(1, 33, 3)] = 0.05
        pgm_function8[(1, 34, 0)] = 0.01
        pgm_function8[(1, 34, 1)] = 0.03
        pgm_function8[(1, 34, 2)] = 0.05
        pgm_function8[(1, 34, 3)] = 0.05
        pgm_function8[(1, 35, 0)] = 0.01
        pgm_function8[(1, 35, 1)] = 0.03
        pgm_function8[(1, 35, 2)] = 0.05
        pgm_function8[(1, 35, 3)] = 0.05
        pgm_function8[(1, 36, 0)] = 0.01
        pgm_function8[(1, 36, 1)] = 0.03
        pgm_function8[(1, 36, 2)] = 0.05
        pgm_function8[(1, 36, 3)] = 0.05
        pgm_function8[(1, 37, 0)] = 0.01
        pgm_function8[(1, 37, 1)] = 0.03
        pgm_function8[(1, 37, 2)] = 0.05
        pgm_function8[(1, 37, 3)] = 0.05
        pgm_function8[(1, 38, 0)] = 0.01
        pgm_function8[(1, 38, 1)] = 0.03
        pgm_function8[(1, 38, 2)] = 0.05
        pgm_function8[(1, 38, 3)] = 0.05
        pgm_function8[(1, 39, 0)] = 0.01
        pgm_function8[(1, 39, 1)] = 0.03
        pgm_function8[(1, 39, 2)] = 0.05
        pgm_function8[(1, 39, 3)] = 0.05
        pgm_function8[(1, 40, 0)] = 0.01
        pgm_function8[(1, 40, 1)] = 0.03
        pgm_function8[(1, 40, 2)] = 0.05
        pgm_function8[(1, 40, 3)] = 0.05
        pgm_function8[(1, 41, 0)] = 0.01
        pgm_function8[(1, 41, 1)] = 0.03
        pgm_function8[(1, 41, 2)] = 0.05
        pgm_function8[(1, 41, 3)] = 0.05
        pgm_function8[(1, 42, 0)] = 0.05
        pgm_function8[(1, 42, 1)] = 0.07
        pgm_function8[(1, 42, 2)] = 0.09
        pgm_function8[(1, 42, 3)] = 0.09
        pgm_function8[(1, 43, 0)] = 0.01
        pgm_function8[(1, 43, 1)] = 0.03
        pgm_function8[(1, 43, 2)] = 0.05
        pgm_function8[(1, 43, 3)] = 0.05
        pgm_function8[(1, 44, 0)] = 0.01
        pgm_function8[(1, 44, 1)] = 0.03
        pgm_function8[(1, 44, 2)] = 0.05
        pgm_function8[(1, 44, 3)] = 0.05
        pgm_function8[(1, 45, 0)] = 0.2
        pgm_function8[(1, 45, 1)] = 0.22
        pgm_function8[(1, 45, 2)] = 0.24
        pgm_function8[(1, 45, 3)] = 0.24
        pgm_function8[(1, 46, 0)] = 0.05
        pgm_function8[(1, 46, 1)] = 0.07
        pgm_function8[(1, 46, 2)] = 0.09
        pgm_function8[(1, 46, 3)] = 0.09
        pgm_function8[(1, 47, 0)] = 0.05
        pgm_function8[(1, 47, 1)] = 0.07
        pgm_function8[(1, 47, 2)] = 0.09
        pgm_function8[(1, 47, 3)] = 0.09
        pgm_function8[(1, 48, 0)] = 0.01
        pgm_function8[(1, 48, 1)] = 0.03
        pgm_function8[(1, 48, 2)] = 0.05
        pgm_function8[(1, 48, 3)] = 0.05
        pgm_function8[(1, 49, 0)] = 0.01
        pgm_function8[(1, 49, 1)] = 0.03
        pgm_function8[(1, 49, 2)] = 0.05
        pgm_function8[(1, 49, 3)] = 0.05
        pgm_function8[(1, 50, 0)] = 0.01
        pgm_function8[(1, 50, 1)] = 0.03
        pgm_function8[(1, 50, 2)] = 0.05
        pgm_function8[(1, 50, 3)] = 0.05
        pgm_function8[(1, 51, 0)] = 0.01
        pgm_function8[(1, 51, 1)] = 0.03
        pgm_function8[(1, 51, 2)] = 0.05
        pgm_function8[(1, 51, 3)] = 0.05
        pgm_function8[(1, 52, 0)] = 0.01
        pgm_function8[(1, 52, 1)] = 0.03
        pgm_function8[(1, 52, 2)] = 0.05
        pgm_function8[(1, 52, 3)] = 0.05
        pgm_function8[(1, 53, 0)] = 0.01
        pgm_function8[(1, 53, 1)] = 0.03
        pgm_function8[(1, 53, 2)] = 0.05
        pgm_function8[(1, 53, 3)] = 0.05
        pgm_function8[(1, 54, 0)] = 0.01
        pgm_function8[(1, 54, 1)] = 0.03
        pgm_function8[(1, 54, 2)] = 0.05
        pgm_function8[(1, 54, 3)] = 0.05
        pgm_function8[(1, 55, 0)] = 0.01
        pgm_function8[(1, 55, 1)] = 0.03
        pgm_function8[(1, 55, 2)] = 0.05
        pgm_function8[(1, 55, 3)] = 0.05
        pgm_function8[(1, 56, 0)] = 0.01
        pgm_function8[(1, 56, 1)] = 0.03
        pgm_function8[(1, 56, 2)] = 0.05
        pgm_function8[(1, 56, 3)] = 0.05
        pgm_function8[(1, 57, 0)] = 0.05
        pgm_function8[(1, 57, 1)] = 0.07
        pgm_function8[(1, 57, 2)] = 0.09
        pgm_function8[(1, 57, 3)] = 0.09
        pgm_function8[(1, 58, 0)] = 0.01
        pgm_function8[(1, 58, 1)] = 0.03
        pgm_function8[(1, 58, 2)] = 0.05
        pgm_function8[(1, 58, 3)] = 0.05
        pgm_function8[(1, 59, 0)] = 0.05
        pgm_function8[(1, 59, 1)] = 0.07
        pgm_function8[(1, 59, 2)] = 0.09
        pgm_function8[(1, 59, 3)] = 0.09
        pgm_function8[(1, 60, 0)] = 0.01
        pgm_function8[(1, 60, 1)] = 0.03
        pgm_function8[(1, 60, 2)] = 0.05
        pgm_function8[(1, 60, 3)] = 0.05
        pgm_function8[(1, 61, 0)] = 0.1
        pgm_function8[(1, 61, 1)] = 0.15
        pgm_function8[(1, 61, 2)] = 0.15
        pgm_function8[(1, 61, 3)] = 0.15
        pgm_function8[(1, 62, 0)] = 0.01
        pgm_function8[(1, 62, 1)] = 0.03
        pgm_function8[(1, 62, 2)] = 0.07
        pgm_function8[(1, 62, 3)] = 0.07
        pgm_function8[(1, 63, 0)] = 0.01
        pgm_function8[(1, 63, 1)] = 0.03
        pgm_function8[(1, 63, 2)] = 0.05
        pgm_function8[(1, 63, 3)] = 0.05
        pgm_function8[(1, 64, 0)] = 0.01
        pgm_function8[(1, 64, 1)] = 0.03
        pgm_function8[(1, 64, 2)] = 0.05
        pgm_function8[(1, 64, 3)] = 0.05
        pgm_function8[(1, 65, 0)] = 0.01
        pgm_function8[(1, 65, 1)] = 0.03
        pgm_function8[(1, 65, 2)] = 0.05
        pgm_function8[(1, 65, 3)] = 0.05
        pgm_function8[(1, 66, 0)] = 0.05
        pgm_function8[(1, 66, 1)] = 0.07
        pgm_function8[(1, 66, 2)] = 0.09
        pgm_function8[(1, 66, 3)] = 0.09
        pgm_function8[(1, 67, 0)] = 0.1
        pgm_function8[(1, 67, 1)] = 0.1
        pgm_function8[(1, 67, 2)] = 0.1
        pgm_function8[(1, 67, 3)] = 0.1
        pgm_function8[(1, 68, 0)] = 0.01
        pgm_function8[(1, 68, 1)] = 0.03
        pgm_function8[(1, 68, 2)] = 0.05
        pgm_function8[(1, 68, 3)] = 0.05
        pgm_function8[(1, 69, 0)] = 0.25
        pgm_function8[(1, 69, 1)] = 0.27
        pgm_function8[(1, 69, 2)] = 0.29
        pgm_function8[(1, 69, 3)] = 0.29
        pgm_function8[(1, 70, 0)] = 0.25
        pgm_function8[(1, 70, 1)] = 0.27
        pgm_function8[(1, 70, 2)] = 0.29
        pgm_function8[(1, 70, 3)] = 0.29
        pgm_function8[(1, 71, 0)] = 0.25
        pgm_function8[(1, 71, 1)] = 0.27
        pgm_function8[(1, 71, 2)] = 0.29
        pgm_function8[(1, 71, 3)] = 0.29
        pgm_function8[(1, 72, 0)] = 0.05
        pgm_function8[(1, 72, 1)] = 0.07
        pgm_function8[(1, 72, 2)] = 0.09
        pgm_function8[(1, 72, 3)] = 0.09
        pgm_function8[(1, 73, 0)] = 0.01
        pgm_function8[(1, 73, 1)] = 0.03
        pgm_function8[(1, 73, 2)] = 0.05
        pgm_function8[(1, 73, 3)] = 0.05
        pgm_function8[(1, 74, 0)] = 0.01
        pgm_function8[(1, 74, 1)] = 0.03
        pgm_function8[(1, 74, 2)] = 0.05
        pgm_function8[(1, 74, 3)] = 0.05
        pgm_function8[(1, 75, 0)] = 0.01
        pgm_function8[(1, 75, 1)] = 0.03
        pgm_function8[(1, 75, 2)] = 0.05
        pgm_function8[(1, 75, 3)] = 0.05
        pgm_function8[(2, 3, 0)] = 0.05
        pgm_function8[(2, 3, 1)] = 0.05
        pgm_function8[(2, 3, 2)] = 0.05
        pgm_function8[(2, 3, 3)] = 0.05
        pgm_function8[(2, 4, 0)] = 0.04
        pgm_function8[(2, 4, 1)] = 0.04
        pgm_function8[(2, 4, 2)] = 0.04
        pgm_function8[(2, 4, 3)] = 0.04
        pgm_function8[(2, 8, 0)] = 0.05
        pgm_function8[(2, 8, 1)] = 0.05
        pgm_function8[(2, 8, 2)] = 0.05
        pgm_function8[(2, 8, 3)] = 0.05
        pgm_function8[(2, 11, 0)] = 0.25
        pgm_function8[(2, 11, 1)] = 0.25
        pgm_function8[(2, 11, 2)] = 0.25
        pgm_function8[(2, 11, 3)] = 0.25
        pgm_function8[(2, 14, 0)] = 0.05
        pgm_function8[(2, 14, 1)] = 0.05
        pgm_function8[(2, 14, 2)] = 0.05
        pgm_function8[(2, 14, 3)] = 0.05
        pgm_function8[(2, 15, 0)] = 0.3333333
        pgm_function8[(2, 15, 1)] = 0.01
        pgm_function8[(2, 15, 2)] = 0.01
        pgm_function8[(2, 15, 3)] = 0.01
        pgm_function8[(2, 18, 0)] = 0.9
        pgm_function8[(2, 18, 1)] = 0.9
        pgm_function8[(2, 18, 2)] = 0.9
        pgm_function8[(2, 18, 3)] = 0.9
        pgm_function8[(2, 19, 0)] = 0.2
        pgm_function8[(2, 19, 1)] = 0.2
        pgm_function8[(2, 19, 2)] = 0.2
        pgm_function8[(2, 19, 3)] = 0.2
        pgm_function8[(2, 20, 0)] = 0.01
        pgm_function8[(2, 20, 1)] = 0.01
        pgm_function8[(2, 20, 2)] = 0.01
        pgm_function8[(2, 20, 3)] = 0.01
        pgm_function8[(2, 22, 0)] = 0.001
        pgm_function8[(2, 22, 1)] = 0.001
        pgm_function8[(2, 22, 2)] = 0.001
        pgm_function8[(2, 22, 3)] = 0.001
        pgm_function8[(2, 42, 0)] = 0.01
        pgm_function8[(2, 42, 1)] = 0.01
        pgm_function8[(2, 42, 2)] = 0.01
        pgm_function8[(2, 42, 3)] = 0.01
        pgm_function8[(2, 45, 0)] = 0.04
        pgm_function8[(2, 45, 1)] = 0.04
        pgm_function8[(2, 45, 2)] = 0.04
        pgm_function8[(2, 45, 3)] = 0.04
        pgm_function8[(2, 62, 0)] = 0.005
        pgm_function8[(2, 62, 1)] = 0.005
        pgm_function8[(2, 62, 2)] = 0.005
        pgm_function8[(2, 62, 3)] = 0.005
        pgm_function8[(2, 67, 0)] = 0.9
        pgm_function8[(2, 67, 1)] = 0.9
        pgm_function8[(2, 67, 2)] = 0.9
        pgm_function8[(2, 67, 3)] = 0.9
        pgm_function8[(2, 69, 0)] = 0.05
        pgm_function8[(2, 69, 1)] = 0.05
        pgm_function8[(2, 69, 2)] = 0.05
        pgm_function8[(2, 69, 3)] = 0.05
        pgm_function8[(2, 70, 0)] = 0.05
        pgm_function8[(2, 70, 1)] = 0.05
        pgm_function8[(2, 70, 2)] = 0.05
        pgm_function8[(2, 70, 3)] = 0.05
        pgm_function8[(2, 71, 0)] = 0.05
        pgm_function8[(2, 71, 1)] = 0.05
        pgm_function8[(2, 71, 2)] = 0.05
        pgm_function8[(2, 71, 3)] = 0.05

        pgm_function9 = pgm_factor9.set_sparse()
        pgm_function9[(0, 0)] = 0.9
        pgm_function9[(0, 1)] = 0.694
        pgm_function9[(0, 2)] = 0.694
        pgm_function9[(0, 3)] = 0.739
        pgm_function9[(0, 4)] = 0.9
        pgm_function9[(0, 5)] = 0.9
        pgm_function9[(0, 6)] = 0.9
        pgm_function9[(0, 7)] = 0.9
        pgm_function9[(0, 8)] = 0.9
        pgm_function9[(0, 9)] = 0.9
        pgm_function9[(0, 10)] = 0.689
        pgm_function9[(0, 11)] = 0.9
        pgm_function9[(0, 12)] = 0.9
        pgm_function9[(0, 13)] = 0.9
        pgm_function9[(0, 14)] = 0.739
        pgm_function9[(0, 15)] = 0.739
        pgm_function9[(0, 16)] = 0.9
        pgm_function9[(0, 17)] = 0.9
        pgm_function9[(0, 18)] = 0.9
        pgm_function9[(0, 19)] = 0.9
        pgm_function9[(0, 20)] = 0.9
        pgm_function9[(0, 21)] = 0.9
        pgm_function9[(0, 22)] = 0.9
        pgm_function9[(0, 23)] = 0.739
        pgm_function9[(0, 24)] = 0.9
        pgm_function9[(0, 25)] = 0.9
        pgm_function9[(0, 26)] = 0.9
        pgm_function9[(0, 27)] = 0.9
        pgm_function9[(0, 28)] = 0.9
        pgm_function9[(0, 29)] = 0.9
        pgm_function9[(0, 30)] = 0.9
        pgm_function9[(0, 31)] = 0.9
        pgm_function9[(0, 32)] = 0.9
        pgm_function9[(0, 33)] = 0.9
        pgm_function9[(0, 34)] = 0.889
        pgm_function9[(0, 35)] = 0.889
        pgm_function9[(0, 36)] = 0.919
        pgm_function9[(0, 37)] = 0.919
        pgm_function9[(0, 38)] = 0.694
        pgm_function9[(0, 39)] = 0.694
        pgm_function9[(0, 40)] = 0.9
        pgm_function9[(0, 41)] = 0.874
        pgm_function9[(0, 42)] = 0.88
        pgm_function9[(0, 43)] = 0.65
        pgm_function9[(0, 44)] = 0.59
        pgm_function9[(0, 45)] = 0.68
        pgm_function9[(0, 46)] = 0.694
        pgm_function9[(0, 47)] = 0.68
        pgm_function9[(0, 48)] = 0.7
        pgm_function9[(0, 49)] = 0.000999001
        pgm_function9[(0, 50)] = 0.68
        pgm_function9[(0, 51)] = 0.8
        pgm_function9[(0, 52)] = 0.9
        pgm_function9[(0, 53)] = 0.9
        pgm_function9[(0, 54)] = 0.68
        pgm_function9[(0, 55)] = 0.9
        pgm_function9[(0, 56)] = 0.9
        pgm_function9[(0, 57)] = 0.9
        pgm_function9[(0, 58)] = 0.9
        pgm_function9[(0, 59)] = 0.9
        pgm_function9[(0, 60)] = 0.9
        pgm_function9[(0, 61)] = 0.9
        pgm_function9[(0, 62)] = 0.68
        pgm_function9[(0, 63)] = 0.694
        pgm_function9[(0, 64)] = 0.9
        pgm_function9[(0, 65)] = 0.9
        pgm_function9[(0, 66)] = 0.689
        pgm_function9[(0, 67)] = 0.9
        pgm_function9[(0, 68)] = 0.9
        pgm_function9[(0, 69)] = 0.739
        pgm_function9[(0, 70)] = 0.9
        pgm_function9[(0, 71)] = 0.9
        pgm_function9[(0, 72)] = 0.9
        pgm_function9[(0, 73)] = 0.9
        pgm_function9[(0, 74)] = 0.8
        pgm_function9[(0, 75)] = 0.89
        pgm_function9[(1, 0)] = 0.099
        pgm_function9[(1, 1)] = 0.3
        pgm_function9[(1, 2)] = 0.3
        pgm_function9[(1, 3)] = 0.25
        pgm_function9[(1, 4)] = 0.099
        pgm_function9[(1, 5)] = 0.099
        pgm_function9[(1, 6)] = 0.099
        pgm_function9[(1, 7)] = 0.099
        pgm_function9[(1, 8)] = 0.099
        pgm_function9[(1, 9)] = 0.099
        pgm_function9[(1, 10)] = 0.25
        pgm_function9[(1, 11)] = 0.099
        pgm_function9[(1, 12)] = 0.099
        pgm_function9[(1, 13)] = 0.099
        pgm_function9[(1, 14)] = 0.25
        pgm_function9[(1, 15)] = 0.25
        pgm_function9[(1, 16)] = 0.099
        pgm_function9[(1, 17)] = 0.099
        pgm_function9[(1, 18)] = 0.099
        pgm_function9[(1, 19)] = 0.099
        pgm_function9[(1, 20)] = 0.099
        pgm_function9[(1, 21)] = 0.099
        pgm_function9[(1, 22)] = 0.099
        pgm_function9[(1, 23)] = 0.25
        pgm_function9[(1, 24)] = 0.099
        pgm_function9[(1, 25)] = 0.099
        pgm_function9[(1, 26)] = 0.099
        pgm_function9[(1, 27)] = 0.099
        pgm_function9[(1, 28)] = 0.099
        pgm_function9[(1, 29)] = 0.099
        pgm_function9[(1, 30)] = 0.099
        pgm_function9[(1, 31)] = 0.099
        pgm_function9[(1, 32)] = 0.099
        pgm_function9[(1, 33)] = 0.099
        pgm_function9[(1, 34)] = 0.1
        pgm_function9[(1, 35)] = 0.1
        pgm_function9[(1, 36)] = 0.05
        pgm_function9[(1, 37)] = 0.05
        pgm_function9[(1, 38)] = 0.3
        pgm_function9[(1, 39)] = 0.3
        pgm_function9[(1, 40)] = 0.095
        pgm_function9[(1, 41)] = 0.07
        pgm_function9[(1, 42)] = 0.05
        pgm_function9[(1, 43)] = 0.15
        pgm_function9[(1, 44)] = 0.15
        pgm_function9[(1, 45)] = 0.1
        pgm_function9[(1, 46)] = 0.3
        pgm_function9[(1, 47)] = 0.1
        pgm_function9[(1, 48)] = 0.05
        pgm_function9[(1, 49)] = 0.00999001
        pgm_function9[(1, 50)] = 0.1
        pgm_function9[(1, 51)] = 0.1
        pgm_function9[(1, 52)] = 0.099
        pgm_function9[(1, 53)] = 0.099
        pgm_function9[(1, 54)] = 0.1
        pgm_function9[(1, 55)] = 0.099
        pgm_function9[(1, 56)] = 0.099
        pgm_function9[(1, 57)] = 0.099
        pgm_function9[(1, 58)] = 0.099
        pgm_function9[(1, 59)] = 0.099
        pgm_function9[(1, 60)] = 0.099
        pgm_function9[(1, 61)] = 0.099
        pgm_function9[(1, 62)] = 0.1
        pgm_function9[(1, 63)] = 0.3
        pgm_function9[(1, 64)] = 0.099
        pgm_function9[(1, 65)] = 0.099
        pgm_function9[(1, 66)] = 0.25
        pgm_function9[(1, 67)] = 0.099
        pgm_function9[(1, 68)] = 0.099
        pgm_function9[(1, 69)] = 0.25
        pgm_function9[(1, 70)] = 0.099
        pgm_function9[(1, 71)] = 0.099
        pgm_function9[(1, 72)] = 0.099
        pgm_function9[(1, 73)] = 0.099
        pgm_function9[(1, 74)] = 0.1
        pgm_function9[(1, 75)] = 0.1
        pgm_function9[(2, 0)] = 0.001
        pgm_function9[(2, 1)] = 0.005
        pgm_function9[(2, 2)] = 0.005
        pgm_function9[(2, 3)] = 0.01
        pgm_function9[(2, 4)] = 0.001
        pgm_function9[(2, 5)] = 0.001
        pgm_function9[(2, 6)] = 0.001
        pgm_function9[(2, 7)] = 0.001
        pgm_function9[(2, 8)] = 0.001
        pgm_function9[(2, 9)] = 0.001
        pgm_function9[(2, 10)] = 0.05
        pgm_function9[(2, 11)] = 0.001
        pgm_function9[(2, 12)] = 0.001
        pgm_function9[(2, 13)] = 0.001
        pgm_function9[(2, 14)] = 0.01
        pgm_function9[(2, 15)] = 0.01
        pgm_function9[(2, 16)] = 0.001
        pgm_function9[(2, 17)] = 0.001
        pgm_function9[(2, 18)] = 0.001
        pgm_function9[(2, 19)] = 0.001
        pgm_function9[(2, 20)] = 0.001
        pgm_function9[(2, 21)] = 0.001
        pgm_function9[(2, 22)] = 0.001
        pgm_function9[(2, 23)] = 0.01
        pgm_function9[(2, 24)] = 0.001
        pgm_function9[(2, 25)] = 0.001
        pgm_function9[(2, 26)] = 0.001
        pgm_function9[(2, 27)] = 0.001
        pgm_function9[(2, 28)] = 0.001
        pgm_function9[(2, 29)] = 0.001
        pgm_function9[(2, 30)] = 0.001
        pgm_function9[(2, 31)] = 0.001
        pgm_function9[(2, 32)] = 0.001
        pgm_function9[(2, 33)] = 0.001
        pgm_function9[(2, 34)] = 0.01
        pgm_function9[(2, 35)] = 0.01
        pgm_function9[(2, 36)] = 0.02
        pgm_function9[(2, 37)] = 0.02
        pgm_function9[(2, 38)] = 0.005
        pgm_function9[(2, 39)] = 0.005
        pgm_function9[(2, 40)] = 0.005
        pgm_function9[(2, 41)] = 0.05
        pgm_function9[(2, 42)] = 0.04
        pgm_function9[(2, 43)] = 0.1
        pgm_function9[(2, 44)] = 0.12
        pgm_function9[(2, 45)] = 0.1
        pgm_function9[(2, 46)] = 0.005
        pgm_function9[(2, 47)] = 0.1
        pgm_function9[(2, 48)] = 0.05
        pgm_function9[(2, 49)] = 0.04995005
        pgm_function9[(2, 50)] = 0.1
        pgm_function9[(2, 51)] = 0.05
        pgm_function9[(2, 52)] = 0.001
        pgm_function9[(2, 53)] = 0.001
        pgm_function9[(2, 54)] = 0.1
        pgm_function9[(2, 55)] = 0.001
        pgm_function9[(2, 56)] = 0.001
        pgm_function9[(2, 57)] = 0.001
        pgm_function9[(2, 58)] = 0.001
        pgm_function9[(2, 59)] = 0.001
        pgm_function9[(2, 60)] = 0.001
        pgm_function9[(2, 61)] = 0.001
        pgm_function9[(2, 62)] = 0.1
        pgm_function9[(2, 63)] = 0.005
        pgm_function9[(2, 64)] = 0.001
        pgm_function9[(2, 65)] = 0.001
        pgm_function9[(2, 66)] = 0.05
        pgm_function9[(2, 67)] = 0.001
        pgm_function9[(2, 68)] = 0.001
        pgm_function9[(2, 69)] = 0.01
        pgm_function9[(2, 70)] = 0.001
        pgm_function9[(2, 71)] = 0.001
        pgm_function9[(2, 72)] = 0.001
        pgm_function9[(2, 73)] = 0.001
        pgm_function9[(2, 74)] = 0.05
        pgm_function9[(2, 75)] = 0.01
        pgm_function9[(3, 1)] = 0.001
        pgm_function9[(3, 2)] = 0.001
        pgm_function9[(3, 3)] = 0.001
        pgm_function9[(3, 10)] = 0.01
        pgm_function9[(3, 14)] = 0.001
        pgm_function9[(3, 15)] = 0.001
        pgm_function9[(3, 23)] = 0.001
        pgm_function9[(3, 34)] = 0.001
        pgm_function9[(3, 35)] = 0.001
        pgm_function9[(3, 36)] = 0.01
        pgm_function9[(3, 37)] = 0.01
        pgm_function9[(3, 38)] = 0.001
        pgm_function9[(3, 39)] = 0.001
        pgm_function9[(3, 41)] = 0.005
        pgm_function9[(3, 42)] = 0.02
        pgm_function9[(3, 43)] = 0.05
        pgm_function9[(3, 44)] = 0.07
        pgm_function9[(3, 45)] = 0.07
        pgm_function9[(3, 46)] = 0.001
        pgm_function9[(3, 47)] = 0.07
        pgm_function9[(3, 48)] = 0.1
        pgm_function9[(3, 49)] = 0.1998002
        pgm_function9[(3, 50)] = 0.07
        pgm_function9[(3, 51)] = 0.03
        pgm_function9[(3, 54)] = 0.07
        pgm_function9[(3, 62)] = 0.07
        pgm_function9[(3, 63)] = 0.001
        pgm_function9[(3, 66)] = 0.01
        pgm_function9[(3, 69)] = 0.001
        pgm_function9[(3, 74)] = 0.03
        pgm_function9[(4, 10)] = 0.001
        pgm_function9[(4, 36)] = 0.001
        pgm_function9[(4, 37)] = 0.001
        pgm_function9[(4, 41)] = 0.001
        pgm_function9[(4, 42)] = 0.01
        pgm_function9[(4, 43)] = 0.05
        pgm_function9[(4, 44)] = 0.07
        pgm_function9[(4, 45)] = 0.05
        pgm_function9[(4, 47)] = 0.05
        pgm_function9[(4, 48)] = 0.1
        pgm_function9[(4, 49)] = 0.739260739
        pgm_function9[(4, 50)] = 0.05
        pgm_function9[(4, 51)] = 0.02
        pgm_function9[(4, 54)] = 0.05
        pgm_function9[(4, 62)] = 0.05
        pgm_function9[(4, 66)] = 0.001
        pgm_function9[(4, 74)] = 0.02

        pgm_function10 = pgm_factor10.set_sparse()
        pgm_function10[(0, 0)] = 1.0
        pgm_function10[(0, 1)] = 1.0
        pgm_function10[(0, 2)] = 1.0
        pgm_function10[(0, 3)] = 1.0
        pgm_function10[(0, 4)] = 1.0
        pgm_function10[(0, 5)] = 1.0
        pgm_function10[(0, 6)] = 1.0
        pgm_function10[(0, 7)] = 1.0
        pgm_function10[(0, 8)] = 1.0
        pgm_function10[(0, 9)] = 1.0
        pgm_function10[(0, 10)] = 1.0
        pgm_function10[(0, 11)] = 1.0
        pgm_function10[(0, 12)] = 1.0
        pgm_function10[(0, 13)] = 1.0
        pgm_function10[(0, 14)] = 1.0
        pgm_function10[(0, 15)] = 1.0
        pgm_function10[(0, 16)] = 1.0
        pgm_function10[(0, 17)] = 1.0
        pgm_function10[(0, 18)] = 1.0
        pgm_function10[(0, 19)] = 1.0
        pgm_function10[(0, 20)] = 1.0
        pgm_function10[(0, 21)] = 1.0
        pgm_function10[(0, 22)] = 1.0
        pgm_function10[(0, 23)] = 1.0
        pgm_function10[(0, 24)] = 1.0
        pgm_function10[(0, 25)] = 1.0
        pgm_function10[(0, 26)] = 1.0
        pgm_function10[(0, 27)] = 1.0
        pgm_function10[(0, 28)] = 1.0
        pgm_function10[(0, 29)] = 1.0
        pgm_function10[(0, 30)] = 1.0
        pgm_function10[(0, 31)] = 1.0
        pgm_function10[(0, 32)] = 1.0
        pgm_function10[(0, 33)] = 1.0
        pgm_function10[(0, 34)] = 1.0
        pgm_function10[(0, 35)] = 1.0
        pgm_function10[(0, 36)] = 1.0
        pgm_function10[(0, 37)] = 1.0
        pgm_function10[(0, 38)] = 1.0
        pgm_function10[(0, 39)] = 1.0
        pgm_function10[(0, 40)] = 1.0
        pgm_function10[(0, 41)] = 1.0
        pgm_function10[(0, 42)] = 1.0
        pgm_function10[(0, 43)] = 1.0
        pgm_function10[(0, 44)] = 1.0
        pgm_function10[(0, 45)] = 1.0
        pgm_function10[(0, 46)] = 1.0
        pgm_function10[(0, 47)] = 1.0
        pgm_function10[(0, 48)] = 1.0
        pgm_function10[(0, 49)] = 1.0
        pgm_function10[(0, 50)] = 1.0
        pgm_function10[(0, 51)] = 1.0
        pgm_function10[(0, 52)] = 1.0
        pgm_function10[(0, 53)] = 1.0
        pgm_function10[(0, 54)] = 1.0
        pgm_function10[(0, 55)] = 1.0
        pgm_function10[(0, 57)] = 1.0
        pgm_function10[(0, 58)] = 1.0
        pgm_function10[(0, 59)] = 1.0
        pgm_function10[(0, 60)] = 1.0
        pgm_function10[(0, 61)] = 1.0
        pgm_function10[(0, 62)] = 1.0
        pgm_function10[(0, 63)] = 1.0
        pgm_function10[(0, 65)] = 1.0
        pgm_function10[(0, 66)] = 1.0
        pgm_function10[(0, 67)] = 1.0
        pgm_function10[(0, 68)] = 1.0
        pgm_function10[(0, 69)] = 1.0
        pgm_function10[(0, 70)] = 1.0
        pgm_function10[(0, 71)] = 1.0
        pgm_function10[(0, 72)] = 1.0
        pgm_function10[(0, 73)] = 1.0
        pgm_function10[(0, 74)] = 1.0
        pgm_function10[(0, 75)] = 1.0
        pgm_function10[(1, 56)] = 1.0
        pgm_function10[(1, 64)] = 1.0

        pgm_function11 = pgm_factor11.set_sparse()
        pgm_function11[(0, 0, 0)] = 1.0
        pgm_function11[(0, 0, 1)] = 1.0
        pgm_function11[(0, 0, 2)] = 0.2
        pgm_function11[(0, 0, 3)] = 0.2
        pgm_function11[(0, 1, 0)] = 0.999
        pgm_function11[(0, 1, 1)] = 0.999
        pgm_function11[(0, 1, 2)] = 0.9979
        pgm_function11[(0, 1, 3)] = 0.989
        pgm_function11[(0, 2, 0)] = 1.0
        pgm_function11[(0, 2, 1)] = 1.0
        pgm_function11[(0, 2, 2)] = 0.2
        pgm_function11[(0, 2, 3)] = 0.2
        pgm_function11[(0, 3, 0)] = 1.0
        pgm_function11[(0, 3, 1)] = 1.0
        pgm_function11[(0, 3, 2)] = 0.2
        pgm_function11[(0, 3, 3)] = 0.2
        pgm_function11[(0, 4, 0)] = 1.0
        pgm_function11[(0, 4, 1)] = 1.0
        pgm_function11[(0, 4, 2)] = 0.2
        pgm_function11[(0, 4, 3)] = 0.2
        pgm_function11[(0, 5, 0)] = 1.0
        pgm_function11[(0, 5, 1)] = 1.0
        pgm_function11[(0, 5, 2)] = 0.2
        pgm_function11[(0, 5, 3)] = 0.2
        pgm_function11[(0, 6, 0)] = 1.0
        pgm_function11[(0, 6, 1)] = 1.0
        pgm_function11[(0, 6, 2)] = 0.2
        pgm_function11[(0, 6, 3)] = 0.2
        pgm_function11[(0, 7, 0)] = 1.0
        pgm_function11[(0, 7, 1)] = 1.0
        pgm_function11[(0, 7, 2)] = 0.2
        pgm_function11[(0, 7, 3)] = 0.2
        pgm_function11[(0, 8, 0)] = 1.0
        pgm_function11[(0, 8, 1)] = 1.0
        pgm_function11[(0, 8, 2)] = 0.2
        pgm_function11[(0, 8, 3)] = 0.2
        pgm_function11[(0, 9, 0)] = 1.0
        pgm_function11[(0, 9, 1)] = 1.0
        pgm_function11[(0, 9, 2)] = 0.2
        pgm_function11[(0, 9, 3)] = 0.2
        pgm_function11[(0, 10, 0)] = 0.99
        pgm_function11[(0, 10, 1)] = 0.99
        pgm_function11[(0, 10, 2)] = 0.98
        pgm_function11[(0, 10, 3)] = 0.98
        pgm_function11[(0, 11, 0)] = 1.0
        pgm_function11[(0, 11, 1)] = 1.0
        pgm_function11[(0, 11, 2)] = 0.2
        pgm_function11[(0, 11, 3)] = 0.2
        pgm_function11[(0, 12, 0)] = 1.0
        pgm_function11[(0, 12, 1)] = 1.0
        pgm_function11[(0, 12, 2)] = 0.2
        pgm_function11[(0, 12, 3)] = 0.2
        pgm_function11[(0, 13, 0)] = 1.0
        pgm_function11[(0, 13, 1)] = 1.0
        pgm_function11[(0, 13, 2)] = 0.2
        pgm_function11[(0, 13, 3)] = 0.2
        pgm_function11[(0, 14, 0)] = 1.0
        pgm_function11[(0, 14, 1)] = 1.0
        pgm_function11[(0, 14, 2)] = 0.2
        pgm_function11[(0, 14, 3)] = 0.2
        pgm_function11[(0, 15, 0)] = 1.0
        pgm_function11[(0, 15, 1)] = 1.0
        pgm_function11[(0, 15, 2)] = 0.2
        pgm_function11[(0, 15, 3)] = 0.2
        pgm_function11[(0, 16, 0)] = 1.0
        pgm_function11[(0, 16, 1)] = 1.0
        pgm_function11[(0, 16, 2)] = 0.2
        pgm_function11[(0, 16, 3)] = 0.2
        pgm_function11[(0, 17, 0)] = 1.0
        pgm_function11[(0, 17, 1)] = 1.0
        pgm_function11[(0, 17, 2)] = 0.2
        pgm_function11[(0, 17, 3)] = 0.2
        pgm_function11[(0, 18, 0)] = 1.0
        pgm_function11[(0, 18, 1)] = 1.0
        pgm_function11[(0, 18, 2)] = 0.2
        pgm_function11[(0, 18, 3)] = 0.2
        pgm_function11[(0, 19, 0)] = 1.0
        pgm_function11[(0, 19, 1)] = 1.0
        pgm_function11[(0, 19, 2)] = 0.2
        pgm_function11[(0, 19, 3)] = 0.2
        pgm_function11[(0, 20, 0)] = 1.0
        pgm_function11[(0, 20, 1)] = 1.0
        pgm_function11[(0, 20, 2)] = 0.2
        pgm_function11[(0, 20, 3)] = 0.2
        pgm_function11[(0, 21, 0)] = 1.0
        pgm_function11[(0, 21, 1)] = 1.0
        pgm_function11[(0, 21, 2)] = 0.2
        pgm_function11[(0, 21, 3)] = 0.2
        pgm_function11[(0, 22, 0)] = 1.0
        pgm_function11[(0, 22, 1)] = 1.0
        pgm_function11[(0, 22, 2)] = 0.2
        pgm_function11[(0, 22, 3)] = 0.2
        pgm_function11[(0, 23, 0)] = 0.999
        pgm_function11[(0, 23, 1)] = 0.995002998
        pgm_function11[(0, 23, 2)] = 0.995
        pgm_function11[(0, 23, 3)] = 0.2
        pgm_function11[(0, 24, 0)] = 1.0
        pgm_function11[(0, 24, 1)] = 1.0
        pgm_function11[(0, 24, 2)] = 0.2
        pgm_function11[(0, 24, 3)] = 0.2
        pgm_function11[(0, 25, 0)] = 0.95
        pgm_function11[(0, 25, 3)] = 0.2
        pgm_function11[(0, 26, 0)] = 0.95
        pgm_function11[(0, 26, 3)] = 0.2
        pgm_function11[(0, 30, 0)] = 0.2
        pgm_function11[(0, 32, 0)] = 0.2
        pgm_function11[(0, 33, 0)] = 0.2
        pgm_function11[(0, 34, 0)] = 1.0
        pgm_function11[(0, 34, 1)] = 1.0
        pgm_function11[(0, 34, 2)] = 0.2
        pgm_function11[(0, 34, 3)] = 0.2
        pgm_function11[(0, 35, 0)] = 1.0
        pgm_function11[(0, 35, 1)] = 1.0
        pgm_function11[(0, 35, 2)] = 0.2
        pgm_function11[(0, 35, 3)] = 0.2
        pgm_function11[(0, 36, 0)] = 1.0
        pgm_function11[(0, 36, 1)] = 1.0
        pgm_function11[(0, 36, 2)] = 0.2
        pgm_function11[(0, 36, 3)] = 0.2
        pgm_function11[(0, 37, 0)] = 1.0
        pgm_function11[(0, 37, 1)] = 1.0
        pgm_function11[(0, 37, 2)] = 0.2
        pgm_function11[(0, 37, 3)] = 0.2
        pgm_function11[(0, 38, 0)] = 0.999
        pgm_function11[(0, 38, 1)] = 0.999
        pgm_function11[(0, 38, 2)] = 0.999
        pgm_function11[(0, 38, 3)] = 0.999
        pgm_function11[(0, 39, 0)] = 0.999
        pgm_function11[(0, 39, 1)] = 0.999
        pgm_function11[(0, 39, 2)] = 0.999
        pgm_function11[(0, 39, 3)] = 0.999
        pgm_function11[(0, 40, 0)] = 1.0
        pgm_function11[(0, 40, 1)] = 1.0
        pgm_function11[(0, 40, 2)] = 0.9999
        pgm_function11[(0, 40, 3)] = 0.9999
        pgm_function11[(0, 41, 0)] = 1.0
        pgm_function11[(0, 41, 1)] = 1.0
        pgm_function11[(0, 41, 2)] = 0.9999
        pgm_function11[(0, 41, 3)] = 0.9999
        pgm_function11[(0, 42, 0)] = 0.99
        pgm_function11[(0, 42, 1)] = 0.99
        pgm_function11[(0, 42, 2)] = 0.99
        pgm_function11[(0, 42, 3)] = 1.0
        pgm_function11[(0, 43, 0)] = 0.9799
        pgm_function11[(0, 43, 1)] = 0.9889
        pgm_function11[(0, 43, 2)] = 0.9889
        pgm_function11[(0, 43, 3)] = 0.9889
        pgm_function11[(0, 44, 0)] = 0.9749
        pgm_function11[(0, 44, 1)] = 0.9749
        pgm_function11[(0, 44, 2)] = 0.9699
        pgm_function11[(0, 44, 3)] = 0.9699
        pgm_function11[(0, 45, 0)] = 0.99
        pgm_function11[(0, 45, 1)] = 0.99
        pgm_function11[(0, 45, 2)] = 0.99
        pgm_function11[(0, 45, 3)] = 0.9889
        pgm_function11[(0, 46, 0)] = 0.999
        pgm_function11[(0, 46, 1)] = 0.999
        pgm_function11[(0, 46, 2)] = 0.9979
        pgm_function11[(0, 46, 3)] = 0.989
        pgm_function11[(0, 47, 0)] = 0.94
        pgm_function11[(0, 47, 1)] = 0.92
        pgm_function11[(0, 47, 2)] = 0.92
        pgm_function11[(0, 47, 3)] = 0.92
        pgm_function11[(0, 48, 0)] = 1.0
        pgm_function11[(0, 48, 1)] = 1.0
        pgm_function11[(0, 48, 2)] = 0.9999
        pgm_function11[(0, 48, 3)] = 0.9999
        pgm_function11[(0, 49, 0)] = 1.0
        pgm_function11[(0, 49, 1)] = 1.0
        pgm_function11[(0, 49, 2)] = 0.9999
        pgm_function11[(0, 49, 3)] = 0.9999
        pgm_function11[(0, 50, 0)] = 0.9799
        pgm_function11[(0, 50, 1)] = 0.9889
        pgm_function11[(0, 50, 2)] = 0.9889
        pgm_function11[(0, 50, 3)] = 0.9889
        pgm_function11[(0, 51, 0)] = 0.9699
        pgm_function11[(0, 51, 1)] = 0.9699
        pgm_function11[(0, 51, 2)] = 0.9699
        pgm_function11[(0, 51, 3)] = 0.9699
        pgm_function11[(0, 52, 0)] = 0.9699
        pgm_function11[(0, 52, 1)] = 0.9699
        pgm_function11[(0, 52, 2)] = 0.9699
        pgm_function11[(0, 52, 3)] = 0.9699
        pgm_function11[(0, 53, 0)] = 0.989
        pgm_function11[(0, 53, 1)] = 0.989
        pgm_function11[(0, 53, 2)] = 0.989
        pgm_function11[(0, 53, 3)] = 0.98
        pgm_function11[(0, 54, 0)] = 1.0
        pgm_function11[(0, 54, 1)] = 1.0
        pgm_function11[(0, 54, 2)] = 0.2
        pgm_function11[(0, 54, 3)] = 0.2
        pgm_function11[(0, 55, 0)] = 1.0
        pgm_function11[(0, 55, 1)] = 1.0
        pgm_function11[(0, 55, 2)] = 0.2
        pgm_function11[(0, 55, 3)] = 0.2
        pgm_function11[(0, 56, 0)] = 0.969
        pgm_function11[(0, 56, 1)] = 0.97
        pgm_function11[(0, 56, 2)] = 0.96
        pgm_function11[(0, 56, 3)] = 0.94
        pgm_function11[(0, 57, 0)] = 0.969
        pgm_function11[(0, 57, 1)] = 0.97
        pgm_function11[(0, 57, 2)] = 0.96
        pgm_function11[(0, 57, 3)] = 0.94
        pgm_function11[(0, 58, 0)] = 0.979
        pgm_function11[(0, 58, 1)] = 0.979
        pgm_function11[(0, 58, 2)] = 0.969
        pgm_function11[(0, 58, 3)] = 0.95
        pgm_function11[(0, 59, 0)] = 1.0
        pgm_function11[(0, 59, 1)] = 1.0
        pgm_function11[(0, 59, 2)] = 0.2
        pgm_function11[(0, 59, 3)] = 0.2
        pgm_function11[(0, 60, 0)] = 1.0
        pgm_function11[(0, 60, 1)] = 1.0
        pgm_function11[(0, 60, 2)] = 0.2
        pgm_function11[(0, 60, 3)] = 0.2
        pgm_function11[(0, 61, 0)] = 1.0
        pgm_function11[(0, 61, 1)] = 1.0
        pgm_function11[(0, 61, 2)] = 0.2
        pgm_function11[(0, 61, 3)] = 0.2
        pgm_function11[(0, 62, 0)] = 0.9799
        pgm_function11[(0, 62, 1)] = 0.9889
        pgm_function11[(0, 62, 2)] = 0.9889
        pgm_function11[(0, 62, 3)] = 0.9889
        pgm_function11[(0, 63, 0)] = 1.0
        pgm_function11[(0, 63, 1)] = 1.0
        pgm_function11[(0, 63, 2)] = 0.9999
        pgm_function11[(0, 63, 3)] = 0.9999
        pgm_function11[(0, 64, 0)] = 0.969
        pgm_function11[(0, 64, 1)] = 0.97
        pgm_function11[(0, 64, 2)] = 0.96
        pgm_function11[(0, 64, 3)] = 0.96
        pgm_function11[(0, 65, 0)] = 0.999
        pgm_function11[(0, 65, 1)] = 0.999
        pgm_function11[(0, 65, 2)] = 0.998
        pgm_function11[(0, 65, 3)] = 0.998
        pgm_function11[(0, 66, 0)] = 0.99
        pgm_function11[(0, 66, 1)] = 0.99
        pgm_function11[(0, 66, 2)] = 0.98
        pgm_function11[(0, 66, 3)] = 0.98
        pgm_function11[(0, 67, 0)] = 1.0
        pgm_function11[(0, 67, 1)] = 1.0
        pgm_function11[(0, 67, 2)] = 0.2
        pgm_function11[(0, 67, 3)] = 0.2
        pgm_function11[(0, 68, 0)] = 1.0
        pgm_function11[(0, 68, 1)] = 1.0
        pgm_function11[(0, 68, 2)] = 0.2
        pgm_function11[(0, 68, 3)] = 0.2
        pgm_function11[(0, 69, 0)] = 1.0
        pgm_function11[(0, 69, 1)] = 1.0
        pgm_function11[(0, 69, 2)] = 0.2
        pgm_function11[(0, 69, 3)] = 0.2
        pgm_function11[(0, 70, 0)] = 1.0
        pgm_function11[(0, 70, 1)] = 1.0
        pgm_function11[(0, 70, 2)] = 0.2
        pgm_function11[(0, 70, 3)] = 0.2
        pgm_function11[(0, 71, 0)] = 1.0
        pgm_function11[(0, 71, 1)] = 1.0
        pgm_function11[(0, 71, 2)] = 0.2
        pgm_function11[(0, 71, 3)] = 0.2
        pgm_function11[(0, 72, 0)] = 0.979
        pgm_function11[(0, 72, 1)] = 0.969
        pgm_function11[(0, 72, 2)] = 0.959
        pgm_function11[(0, 72, 3)] = 0.949
        pgm_function11[(0, 73, 0)] = 1.0
        pgm_function11[(0, 73, 1)] = 1.0
        pgm_function11[(0, 73, 2)] = 0.2
        pgm_function11[(0, 73, 3)] = 0.2
        pgm_function11[(0, 74, 0)] = 0.9699
        pgm_function11[(0, 74, 1)] = 0.9699
        pgm_function11[(0, 74, 2)] = 0.9699
        pgm_function11[(0, 74, 3)] = 0.9699
        pgm_function11[(0, 75, 0)] = 1.0
        pgm_function11[(0, 75, 1)] = 1.0
        pgm_function11[(0, 75, 2)] = 0.9999
        pgm_function11[(0, 75, 3)] = 0.9999
        pgm_function11[(1, 0, 2)] = 0.2
        pgm_function11[(1, 0, 3)] = 0.2
        pgm_function11[(1, 1, 0)] = 0.001
        pgm_function11[(1, 1, 1)] = 0.001
        pgm_function11[(1, 1, 2)] = 0.002
        pgm_function11[(1, 1, 3)] = 0.01
        pgm_function11[(1, 2, 2)] = 0.2
        pgm_function11[(1, 2, 3)] = 0.2
        pgm_function11[(1, 3, 2)] = 0.2
        pgm_function11[(1, 3, 3)] = 0.2
        pgm_function11[(1, 4, 2)] = 0.2
        pgm_function11[(1, 4, 3)] = 0.2
        pgm_function11[(1, 5, 2)] = 0.2
        pgm_function11[(1, 5, 3)] = 0.2
        pgm_function11[(1, 6, 2)] = 0.2
        pgm_function11[(1, 6, 3)] = 0.2
        pgm_function11[(1, 7, 2)] = 0.2
        pgm_function11[(1, 7, 3)] = 0.2
        pgm_function11[(1, 8, 2)] = 0.2
        pgm_function11[(1, 8, 3)] = 0.2
        pgm_function11[(1, 9, 2)] = 0.2
        pgm_function11[(1, 9, 3)] = 0.2
        pgm_function11[(1, 10, 0)] = 0.01
        pgm_function11[(1, 10, 1)] = 0.01
        pgm_function11[(1, 10, 2)] = 0.02
        pgm_function11[(1, 10, 3)] = 0.02
        pgm_function11[(1, 11, 2)] = 0.2
        pgm_function11[(1, 11, 3)] = 0.2
        pgm_function11[(1, 12, 2)] = 0.2
        pgm_function11[(1, 12, 3)] = 0.2
        pgm_function11[(1, 13, 2)] = 0.2
        pgm_function11[(1, 13, 3)] = 0.2
        pgm_function11[(1, 14, 2)] = 0.2
        pgm_function11[(1, 14, 3)] = 0.2
        pgm_function11[(1, 15, 2)] = 0.2
        pgm_function11[(1, 15, 3)] = 0.2
        pgm_function11[(1, 16, 2)] = 0.2
        pgm_function11[(1, 16, 3)] = 0.2
        pgm_function11[(1, 17, 2)] = 0.2
        pgm_function11[(1, 17, 3)] = 0.2
        pgm_function11[(1, 18, 2)] = 0.2
        pgm_function11[(1, 18, 3)] = 0.2
        pgm_function11[(1, 19, 2)] = 0.2
        pgm_function11[(1, 19, 3)] = 0.2
        pgm_function11[(1, 20, 2)] = 0.2
        pgm_function11[(1, 20, 3)] = 0.2
        pgm_function11[(1, 21, 2)] = 0.2
        pgm_function11[(1, 21, 3)] = 0.2
        pgm_function11[(1, 22, 2)] = 0.2
        pgm_function11[(1, 22, 3)] = 0.2
        pgm_function11[(1, 23, 0)] = 0.001
        pgm_function11[(1, 23, 1)] = 0.004997002
        pgm_function11[(1, 23, 2)] = 0.005
        pgm_function11[(1, 23, 3)] = 0.2
        pgm_function11[(1, 24, 2)] = 0.2
        pgm_function11[(1, 24, 3)] = 0.2
        pgm_function11[(1, 25, 0)] = 0.05
        pgm_function11[(1, 25, 1)] = 1.0
        pgm_function11[(1, 25, 2)] = 1.0
        pgm_function11[(1, 25, 3)] = 0.2
        pgm_function11[(1, 26, 0)] = 0.05
        pgm_function11[(1, 26, 1)] = 1.0
        pgm_function11[(1, 26, 2)] = 1.0
        pgm_function11[(1, 26, 3)] = 0.2
        pgm_function11[(1, 27, 0)] = 0.02
        pgm_function11[(1, 27, 1)] = 0.02
        pgm_function11[(1, 27, 2)] = 0.01
        pgm_function11[(1, 27, 3)] = 0.01
        pgm_function11[(1, 28, 0)] = 0.02
        pgm_function11[(1, 28, 1)] = 0.02
        pgm_function11[(1, 28, 2)] = 0.01
        pgm_function11[(1, 28, 3)] = 0.01
        pgm_function11[(1, 29, 0)] = 0.01
        pgm_function11[(1, 29, 1)] = 0.01
        pgm_function11[(1, 29, 2)] = 0.01
        pgm_function11[(1, 29, 3)] = 0.01
        pgm_function11[(1, 30, 0)] = 0.2
        pgm_function11[(1, 30, 3)] = 0.01
        pgm_function11[(1, 31, 0)] = 0.3
        pgm_function11[(1, 31, 1)] = 0.3
        pgm_function11[(1, 31, 2)] = 0.3
        pgm_function11[(1, 31, 3)] = 0.01
        pgm_function11[(1, 32, 0)] = 0.2
        pgm_function11[(1, 32, 1)] = 0.02
        pgm_function11[(1, 32, 2)] = 0.02
        pgm_function11[(1, 33, 0)] = 0.2
        pgm_function11[(1, 34, 2)] = 0.2
        pgm_function11[(1, 34, 3)] = 0.2
        pgm_function11[(1, 35, 2)] = 0.2
        pgm_function11[(1, 35, 3)] = 0.2
        pgm_function11[(1, 36, 2)] = 0.2
        pgm_function11[(1, 36, 3)] = 0.2
        pgm_function11[(1, 37, 2)] = 0.2
        pgm_function11[(1, 37, 3)] = 0.2
        pgm_function11[(1, 38, 0)] = 0.001
        pgm_function11[(1, 38, 1)] = 0.001
        pgm_function11[(1, 38, 2)] = 0.001
        pgm_function11[(1, 38, 3)] = 0.001
        pgm_function11[(1, 39, 0)] = 0.001
        pgm_function11[(1, 39, 1)] = 0.001
        pgm_function11[(1, 39, 2)] = 0.001
        pgm_function11[(1, 39, 3)] = 0.001
        pgm_function11[(1, 40, 2)] = 0.0001
        pgm_function11[(1, 40, 3)] = 0.0001
        pgm_function11[(1, 41, 2)] = 0.0001
        pgm_function11[(1, 41, 3)] = 0.0001
        pgm_function11[(1, 42, 0)] = 0.01
        pgm_function11[(1, 42, 1)] = 0.01
        pgm_function11[(1, 42, 2)] = 0.01
        pgm_function11[(1, 43, 0)] = 0.01
        pgm_function11[(1, 43, 1)] = 0.01
        pgm_function11[(1, 43, 2)] = 0.01
        pgm_function11[(1, 43, 3)] = 0.01
        pgm_function11[(1, 44, 0)] = 0.02
        pgm_function11[(1, 44, 1)] = 0.02
        pgm_function11[(1, 44, 2)] = 0.02
        pgm_function11[(1, 44, 3)] = 0.02
        pgm_function11[(1, 45, 0)] = 0.01
        pgm_function11[(1, 45, 1)] = 0.01
        pgm_function11[(1, 45, 2)] = 0.01
        pgm_function11[(1, 45, 3)] = 0.01
        pgm_function11[(1, 46, 0)] = 0.001
        pgm_function11[(1, 46, 1)] = 0.001
        pgm_function11[(1, 46, 2)] = 0.002
        pgm_function11[(1, 46, 3)] = 0.01
        pgm_function11[(1, 47, 0)] = 0.03
        pgm_function11[(1, 47, 1)] = 0.05
        pgm_function11[(1, 47, 2)] = 0.05
        pgm_function11[(1, 47, 3)] = 0.05
        pgm_function11[(1, 48, 2)] = 0.0001
        pgm_function11[(1, 48, 3)] = 0.0001
        pgm_function11[(1, 49, 2)] = 0.0001
        pgm_function11[(1, 49, 3)] = 0.0001
        pgm_function11[(1, 50, 0)] = 0.01
        pgm_function11[(1, 50, 1)] = 0.01
        pgm_function11[(1, 50, 2)] = 0.01
        pgm_function11[(1, 50, 3)] = 0.01
        pgm_function11[(1, 51, 0)] = 0.02
        pgm_function11[(1, 51, 1)] = 0.02
        pgm_function11[(1, 51, 2)] = 0.02
        pgm_function11[(1, 51, 3)] = 0.02
        pgm_function11[(1, 52, 0)] = 0.02
        pgm_function11[(1, 52, 1)] = 0.02
        pgm_function11[(1, 52, 2)] = 0.02
        pgm_function11[(1, 52, 3)] = 0.02
        pgm_function11[(1, 53, 0)] = 0.01
        pgm_function11[(1, 53, 1)] = 0.01
        pgm_function11[(1, 53, 2)] = 0.01
        pgm_function11[(1, 53, 3)] = 0.02
        pgm_function11[(1, 54, 2)] = 0.2
        pgm_function11[(1, 54, 3)] = 0.2
        pgm_function11[(1, 55, 2)] = 0.2
        pgm_function11[(1, 55, 3)] = 0.2
        pgm_function11[(1, 56, 0)] = 0.02
        pgm_function11[(1, 56, 1)] = 0.02
        pgm_function11[(1, 56, 2)] = 0.01
        pgm_function11[(1, 56, 3)] = 0.03
        pgm_function11[(1, 57, 0)] = 0.02
        pgm_function11[(1, 57, 1)] = 0.02
        pgm_function11[(1, 57, 2)] = 0.01
        pgm_function11[(1, 57, 3)] = 0.03
        pgm_function11[(1, 58, 0)] = 0.02
        pgm_function11[(1, 58, 1)] = 0.02
        pgm_function11[(1, 58, 2)] = 0.03
        pgm_function11[(1, 58, 3)] = 0.04
        pgm_function11[(1, 59, 2)] = 0.2
        pgm_function11[(1, 59, 3)] = 0.2
        pgm_function11[(1, 60, 2)] = 0.2
        pgm_function11[(1, 60, 3)] = 0.2
        pgm_function11[(1, 61, 2)] = 0.2
        pgm_function11[(1, 61, 3)] = 0.2
        pgm_function11[(1, 62, 0)] = 0.01
        pgm_function11[(1, 62, 1)] = 0.01
        pgm_function11[(1, 62, 2)] = 0.01
        pgm_function11[(1, 62, 3)] = 0.01
        pgm_function11[(1, 63, 2)] = 0.0001
        pgm_function11[(1, 63, 3)] = 0.0001
        pgm_function11[(1, 64, 0)] = 0.02
        pgm_function11[(1, 64, 1)] = 0.02
        pgm_function11[(1, 64, 2)] = 0.01
        pgm_function11[(1, 64, 3)] = 0.02
        pgm_function11[(1, 65, 0)] = 0.001
        pgm_function11[(1, 65, 1)] = 0.001
        pgm_function11[(1, 65, 2)] = 0.002
        pgm_function11[(1, 65, 3)] = 0.002
        pgm_function11[(1, 66, 0)] = 0.01
        pgm_function11[(1, 66, 1)] = 0.01
        pgm_function11[(1, 66, 2)] = 0.02
        pgm_function11[(1, 66, 3)] = 0.02
        pgm_function11[(1, 67, 2)] = 0.2
        pgm_function11[(1, 67, 3)] = 0.2
        pgm_function11[(1, 68, 2)] = 0.2
        pgm_function11[(1, 68, 3)] = 0.2
        pgm_function11[(1, 69, 2)] = 0.2
        pgm_function11[(1, 69, 3)] = 0.2
        pgm_function11[(1, 70, 2)] = 0.2
        pgm_function11[(1, 70, 3)] = 0.2
        pgm_function11[(1, 71, 2)] = 0.2
        pgm_function11[(1, 71, 3)] = 0.2
        pgm_function11[(1, 72, 0)] = 0.02
        pgm_function11[(1, 72, 1)] = 0.03
        pgm_function11[(1, 72, 2)] = 0.04
        pgm_function11[(1, 72, 3)] = 0.05
        pgm_function11[(1, 73, 2)] = 0.2
        pgm_function11[(1, 73, 3)] = 0.2
        pgm_function11[(1, 74, 0)] = 0.02
        pgm_function11[(1, 74, 1)] = 0.02
        pgm_function11[(1, 74, 2)] = 0.02
        pgm_function11[(1, 74, 3)] = 0.02
        pgm_function11[(1, 75, 2)] = 0.0001
        pgm_function11[(1, 75, 3)] = 0.0001
        pgm_function11[(2, 0, 2)] = 0.2
        pgm_function11[(2, 0, 3)] = 0.2
        pgm_function11[(2, 1, 2)] = 0.0001
        pgm_function11[(2, 1, 3)] = 0.001
        pgm_function11[(2, 2, 2)] = 0.2
        pgm_function11[(2, 2, 3)] = 0.2
        pgm_function11[(2, 3, 2)] = 0.2
        pgm_function11[(2, 3, 3)] = 0.2
        pgm_function11[(2, 4, 2)] = 0.2
        pgm_function11[(2, 4, 3)] = 0.2
        pgm_function11[(2, 5, 2)] = 0.2
        pgm_function11[(2, 5, 3)] = 0.2
        pgm_function11[(2, 6, 2)] = 0.2
        pgm_function11[(2, 6, 3)] = 0.2
        pgm_function11[(2, 7, 2)] = 0.2
        pgm_function11[(2, 7, 3)] = 0.2
        pgm_function11[(2, 8, 2)] = 0.2
        pgm_function11[(2, 8, 3)] = 0.2
        pgm_function11[(2, 9, 2)] = 0.2
        pgm_function11[(2, 9, 3)] = 0.2
        pgm_function11[(2, 11, 2)] = 0.2
        pgm_function11[(2, 11, 3)] = 0.2
        pgm_function11[(2, 12, 2)] = 0.2
        pgm_function11[(2, 12, 3)] = 0.2
        pgm_function11[(2, 13, 2)] = 0.2
        pgm_function11[(2, 13, 3)] = 0.2
        pgm_function11[(2, 14, 2)] = 0.2
        pgm_function11[(2, 14, 3)] = 0.2
        pgm_function11[(2, 15, 2)] = 0.2
        pgm_function11[(2, 15, 3)] = 0.2
        pgm_function11[(2, 16, 2)] = 0.2
        pgm_function11[(2, 16, 3)] = 0.2
        pgm_function11[(2, 17, 2)] = 0.2
        pgm_function11[(2, 17, 3)] = 0.2
        pgm_function11[(2, 18, 2)] = 0.2
        pgm_function11[(2, 18, 3)] = 0.2
        pgm_function11[(2, 19, 2)] = 0.2
        pgm_function11[(2, 19, 3)] = 0.2
        pgm_function11[(2, 20, 2)] = 0.2
        pgm_function11[(2, 20, 3)] = 0.2
        pgm_function11[(2, 21, 2)] = 0.2
        pgm_function11[(2, 21, 3)] = 0.2
        pgm_function11[(2, 22, 2)] = 0.2
        pgm_function11[(2, 22, 3)] = 0.2
        pgm_function11[(2, 23, 3)] = 0.2
        pgm_function11[(2, 24, 2)] = 0.2
        pgm_function11[(2, 24, 3)] = 0.2
        pgm_function11[(2, 25, 3)] = 0.2
        pgm_function11[(2, 26, 3)] = 0.2
        pgm_function11[(2, 27, 0)] = 0.825
        pgm_function11[(2, 27, 1)] = 0.825
        pgm_function11[(2, 27, 2)] = 0.76
        pgm_function11[(2, 27, 3)] = 0.68
        pgm_function11[(2, 28, 0)] = 0.825
        pgm_function11[(2, 28, 1)] = 0.825
        pgm_function11[(2, 28, 2)] = 0.76
        pgm_function11[(2, 28, 3)] = 0.68
        pgm_function11[(2, 29, 0)] = 0.59
        pgm_function11[(2, 29, 1)] = 0.59
        pgm_function11[(2, 29, 2)] = 0.29
        pgm_function11[(2, 29, 3)] = 0.24
        pgm_function11[(2, 30, 0)] = 0.2
        pgm_function11[(2, 30, 1)] = 0.8
        pgm_function11[(2, 30, 2)] = 0.7
        pgm_function11[(2, 30, 3)] = 0.59
        pgm_function11[(2, 31, 0)] = 0.65
        pgm_function11[(2, 31, 1)] = 0.65
        pgm_function11[(2, 31, 2)] = 0.63
        pgm_function11[(2, 31, 3)] = 0.69
        pgm_function11[(2, 32, 0)] = 0.2
        pgm_function11[(2, 32, 1)] = 0.62
        pgm_function11[(2, 32, 2)] = 0.62
        pgm_function11[(2, 32, 3)] = 0.53
        pgm_function11[(2, 33, 0)] = 0.2
        pgm_function11[(2, 33, 1)] = 0.01
        pgm_function11[(2, 33, 2)] = 0.01
        pgm_function11[(2, 33, 3)] = 0.01
        pgm_function11[(2, 34, 2)] = 0.2
        pgm_function11[(2, 34, 3)] = 0.2
        pgm_function11[(2, 35, 2)] = 0.2
        pgm_function11[(2, 35, 3)] = 0.2
        pgm_function11[(2, 36, 2)] = 0.2
        pgm_function11[(2, 36, 3)] = 0.2
        pgm_function11[(2, 37, 2)] = 0.2
        pgm_function11[(2, 37, 3)] = 0.2
        pgm_function11[(2, 43, 0)] = 0.01
        pgm_function11[(2, 43, 1)] = 0.001
        pgm_function11[(2, 43, 2)] = 0.001
        pgm_function11[(2, 43, 3)] = 0.001
        pgm_function11[(2, 44, 0)] = 0.005
        pgm_function11[(2, 44, 1)] = 0.005
        pgm_function11[(2, 44, 2)] = 0.01
        pgm_function11[(2, 44, 3)] = 0.01
        pgm_function11[(2, 45, 3)] = 0.001
        pgm_function11[(2, 46, 2)] = 0.0001
        pgm_function11[(2, 46, 3)] = 0.001
        pgm_function11[(2, 47, 0)] = 0.02
        pgm_function11[(2, 47, 1)] = 0.02
        pgm_function11[(2, 47, 2)] = 0.02
        pgm_function11[(2, 47, 3)] = 0.02
        pgm_function11[(2, 50, 0)] = 0.01
        pgm_function11[(2, 50, 1)] = 0.001
        pgm_function11[(2, 50, 2)] = 0.001
        pgm_function11[(2, 50, 3)] = 0.001
        pgm_function11[(2, 51, 0)] = 0.01
        pgm_function11[(2, 51, 1)] = 0.01
        pgm_function11[(2, 51, 2)] = 0.01
        pgm_function11[(2, 51, 3)] = 0.01
        pgm_function11[(2, 52, 0)] = 0.01
        pgm_function11[(2, 52, 1)] = 0.01
        pgm_function11[(2, 52, 2)] = 0.01
        pgm_function11[(2, 52, 3)] = 0.01
        pgm_function11[(2, 53, 0)] = 0.001
        pgm_function11[(2, 53, 1)] = 0.001
        pgm_function11[(2, 53, 2)] = 0.001
        pgm_function11[(2, 54, 2)] = 0.2
        pgm_function11[(2, 54, 3)] = 0.2
        pgm_function11[(2, 55, 2)] = 0.2
        pgm_function11[(2, 55, 3)] = 0.2
        pgm_function11[(2, 56, 0)] = 0.01
        pgm_function11[(2, 56, 1)] = 0.01
        pgm_function11[(2, 56, 2)] = 0.02
        pgm_function11[(2, 56, 3)] = 0.02
        pgm_function11[(2, 57, 0)] = 0.01
        pgm_function11[(2, 57, 1)] = 0.01
        pgm_function11[(2, 57, 2)] = 0.02
        pgm_function11[(2, 57, 3)] = 0.02
        pgm_function11[(2, 58, 0)] = 0.001
        pgm_function11[(2, 58, 1)] = 0.001
        pgm_function11[(2, 58, 2)] = 0.001
        pgm_function11[(2, 58, 3)] = 0.01
        pgm_function11[(2, 59, 2)] = 0.2
        pgm_function11[(2, 59, 3)] = 0.2
        pgm_function11[(2, 60, 2)] = 0.2
        pgm_function11[(2, 60, 3)] = 0.2
        pgm_function11[(2, 61, 2)] = 0.2
        pgm_function11[(2, 61, 3)] = 0.2
        pgm_function11[(2, 62, 0)] = 0.01
        pgm_function11[(2, 62, 1)] = 0.001
        pgm_function11[(2, 62, 2)] = 0.001
        pgm_function11[(2, 62, 3)] = 0.001
        pgm_function11[(2, 64, 0)] = 0.01
        pgm_function11[(2, 64, 1)] = 0.01
        pgm_function11[(2, 64, 2)] = 0.02
        pgm_function11[(2, 64, 3)] = 0.01
        pgm_function11[(2, 67, 2)] = 0.2
        pgm_function11[(2, 67, 3)] = 0.2
        pgm_function11[(2, 68, 2)] = 0.2
        pgm_function11[(2, 68, 3)] = 0.2
        pgm_function11[(2, 69, 2)] = 0.2
        pgm_function11[(2, 69, 3)] = 0.2
        pgm_function11[(2, 70, 2)] = 0.2
        pgm_function11[(2, 70, 3)] = 0.2
        pgm_function11[(2, 71, 2)] = 0.2
        pgm_function11[(2, 71, 3)] = 0.2
        pgm_function11[(2, 72, 0)] = 0.001
        pgm_function11[(2, 72, 1)] = 0.001
        pgm_function11[(2, 72, 2)] = 0.001
        pgm_function11[(2, 72, 3)] = 0.001
        pgm_function11[(2, 73, 2)] = 0.2
        pgm_function11[(2, 73, 3)] = 0.2
        pgm_function11[(2, 74, 0)] = 0.01
        pgm_function11[(2, 74, 1)] = 0.01
        pgm_function11[(2, 74, 2)] = 0.01
        pgm_function11[(2, 74, 3)] = 0.01
        pgm_function11[(3, 0, 2)] = 0.2
        pgm_function11[(3, 0, 3)] = 0.2
        pgm_function11[(3, 2, 2)] = 0.2
        pgm_function11[(3, 2, 3)] = 0.2
        pgm_function11[(3, 3, 2)] = 0.2
        pgm_function11[(3, 3, 3)] = 0.2
        pgm_function11[(3, 4, 2)] = 0.2
        pgm_function11[(3, 4, 3)] = 0.2
        pgm_function11[(3, 5, 2)] = 0.2
        pgm_function11[(3, 5, 3)] = 0.2
        pgm_function11[(3, 6, 2)] = 0.2
        pgm_function11[(3, 6, 3)] = 0.2
        pgm_function11[(3, 7, 2)] = 0.2
        pgm_function11[(3, 7, 3)] = 0.2
        pgm_function11[(3, 8, 2)] = 0.2
        pgm_function11[(3, 8, 3)] = 0.2
        pgm_function11[(3, 9, 2)] = 0.2
        pgm_function11[(3, 9, 3)] = 0.2
        pgm_function11[(3, 11, 2)] = 0.2
        pgm_function11[(3, 11, 3)] = 0.2
        pgm_function11[(3, 12, 2)] = 0.2
        pgm_function11[(3, 12, 3)] = 0.2
        pgm_function11[(3, 13, 2)] = 0.2
        pgm_function11[(3, 13, 3)] = 0.2
        pgm_function11[(3, 14, 2)] = 0.2
        pgm_function11[(3, 14, 3)] = 0.2
        pgm_function11[(3, 15, 2)] = 0.2
        pgm_function11[(3, 15, 3)] = 0.2
        pgm_function11[(3, 16, 2)] = 0.2
        pgm_function11[(3, 16, 3)] = 0.2
        pgm_function11[(3, 17, 2)] = 0.2
        pgm_function11[(3, 17, 3)] = 0.2
        pgm_function11[(3, 18, 2)] = 0.2
        pgm_function11[(3, 18, 3)] = 0.2
        pgm_function11[(3, 19, 2)] = 0.2
        pgm_function11[(3, 19, 3)] = 0.2
        pgm_function11[(3, 20, 2)] = 0.2
        pgm_function11[(3, 20, 3)] = 0.2
        pgm_function11[(3, 21, 2)] = 0.2
        pgm_function11[(3, 21, 3)] = 0.2
        pgm_function11[(3, 22, 2)] = 0.2
        pgm_function11[(3, 22, 3)] = 0.2
        pgm_function11[(3, 23, 3)] = 0.2
        pgm_function11[(3, 24, 2)] = 0.2
        pgm_function11[(3, 24, 3)] = 0.2
        pgm_function11[(3, 25, 3)] = 0.2
        pgm_function11[(3, 26, 3)] = 0.2
        pgm_function11[(3, 27, 0)] = 0.15
        pgm_function11[(3, 27, 1)] = 0.15
        pgm_function11[(3, 27, 2)] = 0.22
        pgm_function11[(3, 27, 3)] = 0.3
        pgm_function11[(3, 28, 0)] = 0.15
        pgm_function11[(3, 28, 1)] = 0.15
        pgm_function11[(3, 28, 2)] = 0.22
        pgm_function11[(3, 28, 3)] = 0.3
        pgm_function11[(3, 29, 0)] = 0.35
        pgm_function11[(3, 29, 1)] = 0.35
        pgm_function11[(3, 29, 2)] = 0.6
        pgm_function11[(3, 29, 3)] = 0.65
        pgm_function11[(3, 30, 0)] = 0.2
        pgm_function11[(3, 30, 1)] = 0.2
        pgm_function11[(3, 30, 2)] = 0.3
        pgm_function11[(3, 30, 3)] = 0.4
        pgm_function11[(3, 31, 0)] = 0.05
        pgm_function11[(3, 31, 1)] = 0.05
        pgm_function11[(3, 31, 2)] = 0.07
        pgm_function11[(3, 31, 3)] = 0.3
        pgm_function11[(3, 32, 0)] = 0.2
        pgm_function11[(3, 32, 1)] = 0.35
        pgm_function11[(3, 32, 2)] = 0.35
        pgm_function11[(3, 32, 3)] = 0.45
        pgm_function11[(3, 33, 0)] = 0.2
        pgm_function11[(3, 33, 1)] = 0.59
        pgm_function11[(3, 33, 2)] = 0.4
        pgm_function11[(3, 33, 3)] = 0.25
        pgm_function11[(3, 34, 2)] = 0.2
        pgm_function11[(3, 34, 3)] = 0.2
        pgm_function11[(3, 35, 2)] = 0.2
        pgm_function11[(3, 35, 3)] = 0.2
        pgm_function11[(3, 36, 2)] = 0.2
        pgm_function11[(3, 36, 3)] = 0.2
        pgm_function11[(3, 37, 2)] = 0.2
        pgm_function11[(3, 37, 3)] = 0.2
        pgm_function11[(3, 43, 0)] = 0.0001
        pgm_function11[(3, 43, 1)] = 0.0001
        pgm_function11[(3, 43, 2)] = 0.0001
        pgm_function11[(3, 43, 3)] = 0.0001
        pgm_function11[(3, 44, 0)] = 0.0001
        pgm_function11[(3, 44, 1)] = 0.0001
        pgm_function11[(3, 44, 2)] = 0.0001
        pgm_function11[(3, 44, 3)] = 0.0001
        pgm_function11[(3, 45, 3)] = 0.0001
        pgm_function11[(3, 47, 0)] = 0.01
        pgm_function11[(3, 47, 1)] = 0.01
        pgm_function11[(3, 47, 2)] = 0.01
        pgm_function11[(3, 47, 3)] = 0.01
        pgm_function11[(3, 50, 0)] = 0.0001
        pgm_function11[(3, 50, 1)] = 0.0001
        pgm_function11[(3, 50, 2)] = 0.0001
        pgm_function11[(3, 50, 3)] = 0.0001
        pgm_function11[(3, 51, 0)] = 0.0001
        pgm_function11[(3, 51, 1)] = 0.0001
        pgm_function11[(3, 51, 2)] = 0.0001
        pgm_function11[(3, 51, 3)] = 0.0001
        pgm_function11[(3, 52, 0)] = 0.0001
        pgm_function11[(3, 52, 1)] = 0.0001
        pgm_function11[(3, 52, 2)] = 0.0001
        pgm_function11[(3, 52, 3)] = 0.0001
        pgm_function11[(3, 54, 2)] = 0.2
        pgm_function11[(3, 54, 3)] = 0.2
        pgm_function11[(3, 55, 2)] = 0.2
        pgm_function11[(3, 55, 3)] = 0.2
        pgm_function11[(3, 56, 0)] = 0.001
        pgm_function11[(3, 56, 2)] = 0.01
        pgm_function11[(3, 56, 3)] = 0.01
        pgm_function11[(3, 57, 0)] = 0.001
        pgm_function11[(3, 57, 2)] = 0.01
        pgm_function11[(3, 57, 3)] = 0.01
        pgm_function11[(3, 59, 2)] = 0.2
        pgm_function11[(3, 59, 3)] = 0.2
        pgm_function11[(3, 60, 2)] = 0.2
        pgm_function11[(3, 60, 3)] = 0.2
        pgm_function11[(3, 61, 2)] = 0.2
        pgm_function11[(3, 61, 3)] = 0.2
        pgm_function11[(3, 62, 0)] = 0.0001
        pgm_function11[(3, 62, 1)] = 0.0001
        pgm_function11[(3, 62, 2)] = 0.0001
        pgm_function11[(3, 62, 3)] = 0.0001
        pgm_function11[(3, 64, 0)] = 0.001
        pgm_function11[(3, 64, 2)] = 0.01
        pgm_function11[(3, 64, 3)] = 0.01
        pgm_function11[(3, 67, 2)] = 0.2
        pgm_function11[(3, 67, 3)] = 0.2
        pgm_function11[(3, 68, 2)] = 0.2
        pgm_function11[(3, 68, 3)] = 0.2
        pgm_function11[(3, 69, 2)] = 0.2
        pgm_function11[(3, 69, 3)] = 0.2
        pgm_function11[(3, 70, 2)] = 0.2
        pgm_function11[(3, 70, 3)] = 0.2
        pgm_function11[(3, 71, 2)] = 0.2
        pgm_function11[(3, 71, 3)] = 0.2
        pgm_function11[(3, 73, 2)] = 0.2
        pgm_function11[(3, 73, 3)] = 0.2
        pgm_function11[(3, 74, 0)] = 0.0001
        pgm_function11[(3, 74, 1)] = 0.0001
        pgm_function11[(3, 74, 2)] = 0.0001
        pgm_function11[(3, 74, 3)] = 0.0001
        pgm_function11[(4, 0, 2)] = 0.2
        pgm_function11[(4, 0, 3)] = 0.2
        pgm_function11[(4, 2, 2)] = 0.2
        pgm_function11[(4, 2, 3)] = 0.2
        pgm_function11[(4, 3, 2)] = 0.2
        pgm_function11[(4, 3, 3)] = 0.2
        pgm_function11[(4, 4, 2)] = 0.2
        pgm_function11[(4, 4, 3)] = 0.2
        pgm_function11[(4, 5, 2)] = 0.2
        pgm_function11[(4, 5, 3)] = 0.2
        pgm_function11[(4, 6, 2)] = 0.2
        pgm_function11[(4, 6, 3)] = 0.2
        pgm_function11[(4, 7, 2)] = 0.2
        pgm_function11[(4, 7, 3)] = 0.2
        pgm_function11[(4, 8, 2)] = 0.2
        pgm_function11[(4, 8, 3)] = 0.2
        pgm_function11[(4, 9, 2)] = 0.2
        pgm_function11[(4, 9, 3)] = 0.2
        pgm_function11[(4, 11, 2)] = 0.2
        pgm_function11[(4, 11, 3)] = 0.2
        pgm_function11[(4, 12, 2)] = 0.2
        pgm_function11[(4, 12, 3)] = 0.2
        pgm_function11[(4, 13, 2)] = 0.2
        pgm_function11[(4, 13, 3)] = 0.2
        pgm_function11[(4, 14, 2)] = 0.2
        pgm_function11[(4, 14, 3)] = 0.2
        pgm_function11[(4, 15, 2)] = 0.2
        pgm_function11[(4, 15, 3)] = 0.2
        pgm_function11[(4, 16, 2)] = 0.2
        pgm_function11[(4, 16, 3)] = 0.2
        pgm_function11[(4, 17, 2)] = 0.2
        pgm_function11[(4, 17, 3)] = 0.2
        pgm_function11[(4, 18, 2)] = 0.2
        pgm_function11[(4, 18, 3)] = 0.2
        pgm_function11[(4, 19, 2)] = 0.2
        pgm_function11[(4, 19, 3)] = 0.2
        pgm_function11[(4, 20, 2)] = 0.2
        pgm_function11[(4, 20, 3)] = 0.2
        pgm_function11[(4, 21, 2)] = 0.2
        pgm_function11[(4, 21, 3)] = 0.2
        pgm_function11[(4, 22, 2)] = 0.2
        pgm_function11[(4, 22, 3)] = 0.2
        pgm_function11[(4, 23, 3)] = 0.2
        pgm_function11[(4, 24, 2)] = 0.2
        pgm_function11[(4, 24, 3)] = 0.2
        pgm_function11[(4, 25, 3)] = 0.2
        pgm_function11[(4, 26, 3)] = 0.2
        pgm_function11[(4, 27, 0)] = 0.005
        pgm_function11[(4, 27, 1)] = 0.005
        pgm_function11[(4, 27, 2)] = 0.01
        pgm_function11[(4, 27, 3)] = 0.01
        pgm_function11[(4, 28, 0)] = 0.005
        pgm_function11[(4, 28, 1)] = 0.005
        pgm_function11[(4, 28, 2)] = 0.01
        pgm_function11[(4, 28, 3)] = 0.01
        pgm_function11[(4, 29, 0)] = 0.05
        pgm_function11[(4, 29, 1)] = 0.05
        pgm_function11[(4, 29, 2)] = 0.1
        pgm_function11[(4, 29, 3)] = 0.1
        pgm_function11[(4, 30, 0)] = 0.2
        pgm_function11[(4, 32, 0)] = 0.2
        pgm_function11[(4, 32, 1)] = 0.01
        pgm_function11[(4, 32, 2)] = 0.01
        pgm_function11[(4, 32, 3)] = 0.02
        pgm_function11[(4, 33, 0)] = 0.2
        pgm_function11[(4, 33, 1)] = 0.4
        pgm_function11[(4, 33, 2)] = 0.59
        pgm_function11[(4, 33, 3)] = 0.74
        pgm_function11[(4, 34, 2)] = 0.2
        pgm_function11[(4, 34, 3)] = 0.2
        pgm_function11[(4, 35, 2)] = 0.2
        pgm_function11[(4, 35, 3)] = 0.2
        pgm_function11[(4, 36, 2)] = 0.2
        pgm_function11[(4, 36, 3)] = 0.2
        pgm_function11[(4, 37, 2)] = 0.2
        pgm_function11[(4, 37, 3)] = 0.2
        pgm_function11[(4, 54, 2)] = 0.2
        pgm_function11[(4, 54, 3)] = 0.2
        pgm_function11[(4, 55, 2)] = 0.2
        pgm_function11[(4, 55, 3)] = 0.2
        pgm_function11[(4, 59, 2)] = 0.2
        pgm_function11[(4, 59, 3)] = 0.2
        pgm_function11[(4, 60, 2)] = 0.2
        pgm_function11[(4, 60, 3)] = 0.2
        pgm_function11[(4, 61, 2)] = 0.2
        pgm_function11[(4, 61, 3)] = 0.2
        pgm_function11[(4, 67, 2)] = 0.2
        pgm_function11[(4, 67, 3)] = 0.2
        pgm_function11[(4, 68, 2)] = 0.2
        pgm_function11[(4, 68, 3)] = 0.2
        pgm_function11[(4, 69, 2)] = 0.2
        pgm_function11[(4, 69, 3)] = 0.2
        pgm_function11[(4, 70, 2)] = 0.2
        pgm_function11[(4, 70, 3)] = 0.2
        pgm_function11[(4, 71, 2)] = 0.2
        pgm_function11[(4, 71, 3)] = 0.2
        pgm_function11[(4, 73, 2)] = 0.2
        pgm_function11[(4, 73, 3)] = 0.2

        pgm_function12 = pgm_factor12.set_dense()
        pgm_function12.set_flat(
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.25, 0.99999, 0.99999, 0.99999, 0.99,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 0.99999, 0.99999, 0.99999, 0.99999,
            0.99999, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 0.75, 1e-05, 1e-05, 1e-05,
            0.01, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05, 1e-05, 1e-05, 1e-05,
            1e-05, 1e-05
        )

        pgm_function13 = pgm_factor13.set_sparse()
        pgm_function13[(0, 0, 0)] = 1.0
        pgm_function13[(0, 0, 1)] = 0.99999
        pgm_function13[(0, 0, 2)] = 0.9999
        pgm_function13[(0, 1, 0)] = 1.0
        pgm_function13[(0, 1, 1)] = 0.99999
        pgm_function13[(0, 1, 2)] = 0.9999
        pgm_function13[(0, 2, 0)] = 1.0
        pgm_function13[(0, 2, 1)] = 0.99999
        pgm_function13[(0, 2, 2)] = 0.9999
        pgm_function13[(0, 3, 0)] = 1.0
        pgm_function13[(0, 3, 1)] = 0.99999
        pgm_function13[(0, 3, 2)] = 0.9999
        pgm_function13[(0, 4, 0)] = 1.0
        pgm_function13[(0, 4, 1)] = 0.99999
        pgm_function13[(0, 4, 2)] = 0.9999
        pgm_function13[(0, 5, 0)] = 1.0
        pgm_function13[(0, 5, 1)] = 0.99999
        pgm_function13[(0, 5, 2)] = 0.9999
        pgm_function13[(0, 6, 0)] = 1.0
        pgm_function13[(0, 6, 1)] = 0.99999
        pgm_function13[(0, 6, 2)] = 0.9999
        pgm_function13[(0, 7, 0)] = 1.0
        pgm_function13[(0, 7, 1)] = 0.99999
        pgm_function13[(0, 7, 2)] = 0.9999
        pgm_function13[(0, 8, 0)] = 1.0
        pgm_function13[(0, 8, 1)] = 0.99999
        pgm_function13[(0, 8, 2)] = 0.9999
        pgm_function13[(0, 9, 0)] = 1.0
        pgm_function13[(0, 9, 1)] = 0.99999
        pgm_function13[(0, 9, 2)] = 0.9999
        pgm_function13[(0, 10, 0)] = 1.0
        pgm_function13[(0, 10, 1)] = 0.99999
        pgm_function13[(0, 10, 2)] = 0.9999
        pgm_function13[(0, 11, 0)] = 1.0
        pgm_function13[(0, 11, 1)] = 0.99999
        pgm_function13[(0, 11, 2)] = 0.9999
        pgm_function13[(0, 12, 0)] = 1.0
        pgm_function13[(0, 12, 1)] = 0.99999
        pgm_function13[(0, 12, 2)] = 0.9999
        pgm_function13[(0, 13, 0)] = 1.0
        pgm_function13[(0, 13, 1)] = 0.99999
        pgm_function13[(0, 13, 2)] = 0.9999
        pgm_function13[(0, 14, 0)] = 1.0
        pgm_function13[(0, 14, 1)] = 0.99999
        pgm_function13[(0, 14, 2)] = 0.9999
        pgm_function13[(0, 15, 0)] = 1.0
        pgm_function13[(0, 15, 1)] = 0.99999
        pgm_function13[(0, 15, 2)] = 0.9999
        pgm_function13[(0, 16, 0)] = 1.0
        pgm_function13[(0, 16, 1)] = 0.99999
        pgm_function13[(0, 16, 2)] = 0.9999
        pgm_function13[(0, 17, 0)] = 1.0
        pgm_function13[(0, 17, 1)] = 0.99999
        pgm_function13[(0, 17, 2)] = 0.9999
        pgm_function13[(0, 18, 0)] = 0.5
        pgm_function13[(0, 18, 1)] = 9.9999e-06
        pgm_function13[(0, 19, 0)] = 1.0
        pgm_function13[(0, 19, 1)] = 0.99999
        pgm_function13[(0, 19, 2)] = 0.9999
        pgm_function13[(0, 20, 0)] = 1.0
        pgm_function13[(0, 20, 1)] = 0.99999
        pgm_function13[(0, 20, 2)] = 0.9999
        pgm_function13[(0, 21, 0)] = 1.0
        pgm_function13[(0, 21, 1)] = 0.99999
        pgm_function13[(0, 21, 2)] = 0.9999
        pgm_function13[(0, 22, 0)] = 1.0
        pgm_function13[(0, 22, 1)] = 0.99999
        pgm_function13[(0, 22, 2)] = 0.9999
        pgm_function13[(0, 23, 0)] = 1.0
        pgm_function13[(0, 23, 1)] = 0.99999
        pgm_function13[(0, 23, 2)] = 0.9999
        pgm_function13[(0, 24, 0)] = 1.0
        pgm_function13[(0, 24, 1)] = 0.99999
        pgm_function13[(0, 24, 2)] = 0.9999
        pgm_function13[(0, 25, 0)] = 1.0
        pgm_function13[(0, 25, 1)] = 0.99999
        pgm_function13[(0, 25, 2)] = 0.9999
        pgm_function13[(0, 26, 0)] = 1.0
        pgm_function13[(0, 26, 1)] = 0.99999
        pgm_function13[(0, 26, 2)] = 0.9999
        pgm_function13[(0, 27, 0)] = 1.0
        pgm_function13[(0, 27, 1)] = 0.99999
        pgm_function13[(0, 27, 2)] = 0.9999
        pgm_function13[(0, 28, 0)] = 1.0
        pgm_function13[(0, 28, 1)] = 0.99999
        pgm_function13[(0, 28, 2)] = 0.9999
        pgm_function13[(0, 29, 0)] = 1.0
        pgm_function13[(0, 29, 1)] = 0.99999
        pgm_function13[(0, 29, 2)] = 0.9999
        pgm_function13[(0, 30, 0)] = 1.0
        pgm_function13[(0, 30, 1)] = 0.99999
        pgm_function13[(0, 30, 2)] = 0.9999
        pgm_function13[(0, 31, 0)] = 1.0
        pgm_function13[(0, 31, 1)] = 0.99999
        pgm_function13[(0, 31, 2)] = 0.9999
        pgm_function13[(0, 32, 0)] = 1.0
        pgm_function13[(0, 32, 1)] = 0.99999
        pgm_function13[(0, 32, 2)] = 0.9999
        pgm_function13[(0, 33, 0)] = 1.0
        pgm_function13[(0, 33, 1)] = 0.99999
        pgm_function13[(0, 33, 2)] = 0.9999
        pgm_function13[(0, 34, 0)] = 1.0
        pgm_function13[(0, 34, 1)] = 0.99999
        pgm_function13[(0, 34, 2)] = 0.9999
        pgm_function13[(0, 35, 0)] = 1.0
        pgm_function13[(0, 35, 1)] = 0.99999
        pgm_function13[(0, 35, 2)] = 0.9999
        pgm_function13[(0, 36, 0)] = 1.0
        pgm_function13[(0, 36, 1)] = 0.99999
        pgm_function13[(0, 36, 2)] = 0.9999
        pgm_function13[(0, 37, 0)] = 1.0
        pgm_function13[(0, 37, 1)] = 0.99999
        pgm_function13[(0, 37, 2)] = 0.9999
        pgm_function13[(0, 38, 0)] = 1.0
        pgm_function13[(0, 38, 1)] = 0.99999
        pgm_function13[(0, 38, 2)] = 0.9999
        pgm_function13[(0, 39, 0)] = 1.0
        pgm_function13[(0, 39, 1)] = 0.99999
        pgm_function13[(0, 39, 2)] = 0.9999
        pgm_function13[(0, 40, 0)] = 1.0
        pgm_function13[(0, 40, 1)] = 0.99999
        pgm_function13[(0, 40, 2)] = 0.9999
        pgm_function13[(0, 41, 0)] = 1.0
        pgm_function13[(0, 41, 1)] = 0.99999
        pgm_function13[(0, 41, 2)] = 0.9999
        pgm_function13[(0, 42, 0)] = 1.0
        pgm_function13[(0, 42, 1)] = 0.99999
        pgm_function13[(0, 42, 2)] = 0.9999
        pgm_function13[(0, 43, 0)] = 1.0
        pgm_function13[(0, 43, 1)] = 0.99999
        pgm_function13[(0, 43, 2)] = 0.9999
        pgm_function13[(0, 44, 0)] = 1.0
        pgm_function13[(0, 44, 1)] = 0.99999
        pgm_function13[(0, 44, 2)] = 0.9999
        pgm_function13[(0, 45, 0)] = 1.0
        pgm_function13[(0, 45, 1)] = 0.99999
        pgm_function13[(0, 45, 2)] = 0.9999
        pgm_function13[(0, 46, 0)] = 1.0
        pgm_function13[(0, 46, 1)] = 0.99999
        pgm_function13[(0, 46, 2)] = 0.9999
        pgm_function13[(0, 47, 0)] = 1.0
        pgm_function13[(0, 47, 1)] = 0.99999
        pgm_function13[(0, 47, 2)] = 0.9999
        pgm_function13[(0, 48, 0)] = 1.0
        pgm_function13[(0, 48, 1)] = 0.99999
        pgm_function13[(0, 48, 2)] = 0.9999
        pgm_function13[(0, 49, 0)] = 1.0
        pgm_function13[(0, 49, 1)] = 0.99999
        pgm_function13[(0, 49, 2)] = 0.9999
        pgm_function13[(0, 50, 0)] = 1.0
        pgm_function13[(0, 50, 1)] = 0.99999
        pgm_function13[(0, 50, 2)] = 0.9999
        pgm_function13[(0, 51, 0)] = 1.0
        pgm_function13[(0, 51, 1)] = 0.99999
        pgm_function13[(0, 51, 2)] = 0.9999
        pgm_function13[(0, 52, 0)] = 1.0
        pgm_function13[(0, 52, 1)] = 0.99999
        pgm_function13[(0, 52, 2)] = 0.9999
        pgm_function13[(0, 53, 0)] = 1.0
        pgm_function13[(0, 53, 1)] = 0.99999
        pgm_function13[(0, 53, 2)] = 0.9999
        pgm_function13[(0, 54, 0)] = 1.0
        pgm_function13[(0, 54, 1)] = 0.99999
        pgm_function13[(0, 54, 2)] = 0.9999
        pgm_function13[(0, 55, 0)] = 1.0
        pgm_function13[(0, 55, 1)] = 0.99999
        pgm_function13[(0, 55, 2)] = 0.9999
        pgm_function13[(0, 56, 0)] = 1.0
        pgm_function13[(0, 56, 1)] = 0.99999
        pgm_function13[(0, 56, 2)] = 0.9999
        pgm_function13[(0, 57, 0)] = 1.0
        pgm_function13[(0, 57, 1)] = 0.99999
        pgm_function13[(0, 57, 2)] = 0.9999
        pgm_function13[(0, 58, 0)] = 1.0
        pgm_function13[(0, 58, 1)] = 0.99999
        pgm_function13[(0, 58, 2)] = 0.9999
        pgm_function13[(0, 59, 0)] = 1.0
        pgm_function13[(0, 59, 1)] = 0.99999
        pgm_function13[(0, 59, 2)] = 0.9999
        pgm_function13[(0, 60, 0)] = 1.0
        pgm_function13[(0, 60, 1)] = 0.99999
        pgm_function13[(0, 60, 2)] = 0.9999
        pgm_function13[(0, 61, 0)] = 1.0
        pgm_function13[(0, 61, 1)] = 0.99999
        pgm_function13[(0, 61, 2)] = 0.9999
        pgm_function13[(0, 62, 0)] = 1.0
        pgm_function13[(0, 62, 1)] = 0.99999
        pgm_function13[(0, 62, 2)] = 0.9999
        pgm_function13[(0, 63, 0)] = 1.0
        pgm_function13[(0, 63, 1)] = 0.99999
        pgm_function13[(0, 63, 2)] = 0.9999
        pgm_function13[(0, 64, 0)] = 1.0
        pgm_function13[(0, 64, 1)] = 0.99999
        pgm_function13[(0, 64, 2)] = 0.9999
        pgm_function13[(0, 65, 0)] = 1.0
        pgm_function13[(0, 65, 1)] = 0.99999
        pgm_function13[(0, 65, 2)] = 0.9999
        pgm_function13[(0, 66, 0)] = 1.0
        pgm_function13[(0, 66, 1)] = 0.99999
        pgm_function13[(0, 66, 2)] = 0.9999
        pgm_function13[(0, 67, 0)] = 1.0
        pgm_function13[(0, 67, 1)] = 0.99999
        pgm_function13[(0, 67, 2)] = 0.9999
        pgm_function13[(0, 68, 0)] = 1.0
        pgm_function13[(0, 68, 1)] = 0.99999
        pgm_function13[(0, 68, 2)] = 0.9999
        pgm_function13[(0, 69, 0)] = 1.0
        pgm_function13[(0, 69, 1)] = 0.99999
        pgm_function13[(0, 69, 2)] = 0.9999
        pgm_function13[(0, 70, 0)] = 1.0
        pgm_function13[(0, 70, 1)] = 0.99999
        pgm_function13[(0, 70, 2)] = 0.9999
        pgm_function13[(0, 71, 0)] = 1.0
        pgm_function13[(0, 71, 1)] = 0.99999
        pgm_function13[(0, 71, 2)] = 0.9999
        pgm_function13[(0, 72, 0)] = 1.0
        pgm_function13[(0, 72, 1)] = 0.99999
        pgm_function13[(0, 72, 2)] = 0.9999
        pgm_function13[(0, 73, 0)] = 1.0
        pgm_function13[(0, 73, 1)] = 0.99999
        pgm_function13[(0, 73, 2)] = 0.9999
        pgm_function13[(0, 74, 0)] = 1.0
        pgm_function13[(0, 74, 1)] = 0.99999
        pgm_function13[(0, 74, 2)] = 0.9999
        pgm_function13[(0, 75, 0)] = 1.0
        pgm_function13[(0, 75, 1)] = 0.99999
        pgm_function13[(0, 75, 2)] = 0.9999
        pgm_function13[(1, 0, 1)] = 9.9999e-06
        pgm_function13[(1, 0, 2)] = 9.999e-05
        pgm_function13[(1, 1, 1)] = 9.9999e-06
        pgm_function13[(1, 1, 2)] = 9.999e-05
        pgm_function13[(1, 2, 1)] = 9.9999e-06
        pgm_function13[(1, 2, 2)] = 9.999e-05
        pgm_function13[(1, 3, 1)] = 9.9999e-06
        pgm_function13[(1, 3, 2)] = 9.999e-05
        pgm_function13[(1, 4, 1)] = 9.9999e-06
        pgm_function13[(1, 4, 2)] = 9.999e-05
        pgm_function13[(1, 5, 1)] = 9.9999e-06
        pgm_function13[(1, 5, 2)] = 9.999e-05
        pgm_function13[(1, 6, 1)] = 9.9999e-06
        pgm_function13[(1, 6, 2)] = 9.999e-05
        pgm_function13[(1, 7, 1)] = 9.9999e-06
        pgm_function13[(1, 7, 2)] = 9.999e-05
        pgm_function13[(1, 8, 1)] = 9.9999e-06
        pgm_function13[(1, 8, 2)] = 9.999e-05
        pgm_function13[(1, 9, 1)] = 9.9999e-06
        pgm_function13[(1, 9, 2)] = 9.999e-05
        pgm_function13[(1, 10, 1)] = 9.9999e-06
        pgm_function13[(1, 10, 2)] = 9.999e-05
        pgm_function13[(1, 11, 1)] = 9.9999e-06
        pgm_function13[(1, 11, 2)] = 9.999e-05
        pgm_function13[(1, 12, 1)] = 9.9999e-06
        pgm_function13[(1, 12, 2)] = 9.999e-05
        pgm_function13[(1, 13, 1)] = 9.9999e-06
        pgm_function13[(1, 13, 2)] = 9.999e-05
        pgm_function13[(1, 14, 1)] = 9.9999e-06
        pgm_function13[(1, 14, 2)] = 9.999e-05
        pgm_function13[(1, 15, 1)] = 9.9999e-06
        pgm_function13[(1, 15, 2)] = 9.999e-05
        pgm_function13[(1, 16, 1)] = 9.9999e-06
        pgm_function13[(1, 16, 2)] = 9.999e-05
        pgm_function13[(1, 17, 1)] = 9.9999e-06
        pgm_function13[(1, 17, 2)] = 9.999e-05
        pgm_function13[(1, 18, 0)] = 0.4
        pgm_function13[(1, 18, 1)] = 0.499995
        pgm_function13[(1, 18, 2)] = 0.3
        pgm_function13[(1, 19, 1)] = 9.9999e-06
        pgm_function13[(1, 19, 2)] = 9.999e-05
        pgm_function13[(1, 20, 1)] = 9.9999e-06
        pgm_function13[(1, 20, 2)] = 9.999e-05
        pgm_function13[(1, 21, 1)] = 9.9999e-06
        pgm_function13[(1, 21, 2)] = 9.999e-05
        pgm_function13[(1, 22, 1)] = 9.9999e-06
        pgm_function13[(1, 22, 2)] = 9.999e-05
        pgm_function13[(1, 23, 1)] = 9.9999e-06
        pgm_function13[(1, 23, 2)] = 9.999e-05
        pgm_function13[(1, 24, 1)] = 9.9999e-06
        pgm_function13[(1, 24, 2)] = 9.999e-05
        pgm_function13[(1, 25, 1)] = 9.9999e-06
        pgm_function13[(1, 25, 2)] = 9.999e-05
        pgm_function13[(1, 26, 1)] = 9.9999e-06
        pgm_function13[(1, 26, 2)] = 9.999e-05
        pgm_function13[(1, 27, 1)] = 9.9999e-06
        pgm_function13[(1, 27, 2)] = 9.999e-05
        pgm_function13[(1, 28, 1)] = 9.9999e-06
        pgm_function13[(1, 28, 2)] = 9.999e-05
        pgm_function13[(1, 29, 1)] = 9.9999e-06
        pgm_function13[(1, 29, 2)] = 9.999e-05
        pgm_function13[(1, 30, 1)] = 9.9999e-06
        pgm_function13[(1, 30, 2)] = 9.999e-05
        pgm_function13[(1, 31, 1)] = 9.9999e-06
        pgm_function13[(1, 31, 2)] = 9.999e-05
        pgm_function13[(1, 32, 1)] = 9.9999e-06
        pgm_function13[(1, 32, 2)] = 9.999e-05
        pgm_function13[(1, 33, 1)] = 9.9999e-06
        pgm_function13[(1, 33, 2)] = 9.999e-05
        pgm_function13[(1, 34, 1)] = 9.9999e-06
        pgm_function13[(1, 34, 2)] = 9.999e-05
        pgm_function13[(1, 35, 1)] = 9.9999e-06
        pgm_function13[(1, 35, 2)] = 9.999e-05
        pgm_function13[(1, 36, 1)] = 9.9999e-06
        pgm_function13[(1, 36, 2)] = 9.999e-05
        pgm_function13[(1, 37, 1)] = 9.9999e-06
        pgm_function13[(1, 37, 2)] = 9.999e-05
        pgm_function13[(1, 38, 1)] = 9.9999e-06
        pgm_function13[(1, 38, 2)] = 9.999e-05
        pgm_function13[(1, 39, 1)] = 9.9999e-06
        pgm_function13[(1, 39, 2)] = 9.999e-05
        pgm_function13[(1, 40, 1)] = 9.9999e-06
        pgm_function13[(1, 40, 2)] = 9.999e-05
        pgm_function13[(1, 41, 1)] = 9.9999e-06
        pgm_function13[(1, 41, 2)] = 9.999e-05
        pgm_function13[(1, 42, 1)] = 9.9999e-06
        pgm_function13[(1, 42, 2)] = 9.999e-05
        pgm_function13[(1, 43, 1)] = 9.9999e-06
        pgm_function13[(1, 43, 2)] = 9.999e-05
        pgm_function13[(1, 44, 1)] = 9.9999e-06
        pgm_function13[(1, 44, 2)] = 9.999e-05
        pgm_function13[(1, 45, 1)] = 9.9999e-06
        pgm_function13[(1, 45, 2)] = 9.999e-05
        pgm_function13[(1, 46, 1)] = 9.9999e-06
        pgm_function13[(1, 46, 2)] = 9.999e-05
        pgm_function13[(1, 47, 1)] = 9.9999e-06
        pgm_function13[(1, 47, 2)] = 9.999e-05
        pgm_function13[(1, 48, 1)] = 9.9999e-06
        pgm_function13[(1, 48, 2)] = 9.999e-05
        pgm_function13[(1, 49, 1)] = 9.9999e-06
        pgm_function13[(1, 49, 2)] = 9.999e-05
        pgm_function13[(1, 50, 1)] = 9.9999e-06
        pgm_function13[(1, 50, 2)] = 9.999e-05
        pgm_function13[(1, 51, 1)] = 9.9999e-06
        pgm_function13[(1, 51, 2)] = 9.999e-05
        pgm_function13[(1, 52, 1)] = 9.9999e-06
        pgm_function13[(1, 52, 2)] = 9.999e-05
        pgm_function13[(1, 53, 1)] = 9.9999e-06
        pgm_function13[(1, 53, 2)] = 9.999e-05
        pgm_function13[(1, 54, 1)] = 9.9999e-06
        pgm_function13[(1, 54, 2)] = 9.999e-05
        pgm_function13[(1, 55, 1)] = 9.9999e-06
        pgm_function13[(1, 55, 2)] = 9.999e-05
        pgm_function13[(1, 56, 1)] = 9.9999e-06
        pgm_function13[(1, 56, 2)] = 9.999e-05
        pgm_function13[(1, 57, 1)] = 9.9999e-06
        pgm_function13[(1, 57, 2)] = 9.999e-05
        pgm_function13[(1, 58, 1)] = 9.9999e-06
        pgm_function13[(1, 58, 2)] = 9.999e-05
        pgm_function13[(1, 59, 1)] = 9.9999e-06
        pgm_function13[(1, 59, 2)] = 9.999e-05
        pgm_function13[(1, 60, 1)] = 9.9999e-06
        pgm_function13[(1, 60, 2)] = 9.999e-05
        pgm_function13[(1, 61, 1)] = 9.9999e-06
        pgm_function13[(1, 61, 2)] = 9.999e-05
        pgm_function13[(1, 62, 1)] = 9.9999e-06
        pgm_function13[(1, 62, 2)] = 9.999e-05
        pgm_function13[(1, 63, 1)] = 9.9999e-06
        pgm_function13[(1, 63, 2)] = 9.999e-05
        pgm_function13[(1, 64, 1)] = 9.9999e-06
        pgm_function13[(1, 64, 2)] = 9.999e-05
        pgm_function13[(1, 65, 1)] = 9.9999e-06
        pgm_function13[(1, 65, 2)] = 9.999e-05
        pgm_function13[(1, 66, 1)] = 9.9999e-06
        pgm_function13[(1, 66, 2)] = 9.999e-05
        pgm_function13[(1, 67, 1)] = 9.9999e-06
        pgm_function13[(1, 67, 2)] = 9.999e-05
        pgm_function13[(1, 68, 1)] = 9.9999e-06
        pgm_function13[(1, 68, 2)] = 9.999e-05
        pgm_function13[(1, 69, 1)] = 9.9999e-06
        pgm_function13[(1, 69, 2)] = 9.999e-05
        pgm_function13[(1, 70, 1)] = 9.9999e-06
        pgm_function13[(1, 70, 2)] = 9.999e-05
        pgm_function13[(1, 71, 1)] = 9.9999e-06
        pgm_function13[(1, 71, 2)] = 9.999e-05
        pgm_function13[(1, 72, 1)] = 9.9999e-06
        pgm_function13[(1, 72, 2)] = 9.999e-05
        pgm_function13[(1, 73, 1)] = 9.9999e-06
        pgm_function13[(1, 73, 2)] = 9.999e-05
        pgm_function13[(1, 74, 1)] = 9.9999e-06
        pgm_function13[(1, 74, 2)] = 9.999e-05
        pgm_function13[(1, 75, 1)] = 9.9999e-06
        pgm_function13[(1, 75, 2)] = 9.999e-05
        pgm_function13[(2, 18, 0)] = 0.1
        pgm_function13[(2, 18, 1)] = 0.499995
        pgm_function13[(2, 18, 2)] = 0.7

        pgm_function14 = pgm_factor14.set_sparse()
        pgm_function14[(0, 0)] = 1.0
        pgm_function14[(0, 1)] = 1.0
        pgm_function14[(0, 2)] = 1.0
        pgm_function14[(0, 3)] = 0.9999
        pgm_function14[(0, 4)] = 1.0
        pgm_function14[(0, 5)] = 1.0
        pgm_function14[(0, 6)] = 1.0
        pgm_function14[(0, 7)] = 1.0
        pgm_function14[(0, 8)] = 0.9999
        pgm_function14[(0, 9)] = 0.6
        pgm_function14[(0, 10)] = 1.0
        pgm_function14[(0, 11)] = 1.0
        pgm_function14[(0, 12)] = 1.0
        pgm_function14[(0, 13)] = 1.0
        pgm_function14[(0, 14)] = 1.0
        pgm_function14[(0, 15)] = 0.9999
        pgm_function14[(0, 16)] = 1.0
        pgm_function14[(0, 17)] = 1.0
        pgm_function14[(0, 18)] = 1.0
        pgm_function14[(0, 19)] = 1.0
        pgm_function14[(0, 20)] = 1.0
        pgm_function14[(0, 21)] = 1.0
        pgm_function14[(0, 22)] = 1.0
        pgm_function14[(0, 23)] = 1.0
        pgm_function14[(0, 24)] = 1.0
        pgm_function14[(0, 25)] = 1.0
        pgm_function14[(0, 26)] = 1.0
        pgm_function14[(0, 27)] = 0.99
        pgm_function14[(0, 28)] = 0.99
        pgm_function14[(0, 29)] = 0.99
        pgm_function14[(0, 30)] = 0.99
        pgm_function14[(0, 31)] = 0.99
        pgm_function14[(0, 32)] = 1.0
        pgm_function14[(0, 33)] = 1.0
        pgm_function14[(0, 34)] = 1.0
        pgm_function14[(0, 35)] = 1.0
        pgm_function14[(0, 36)] = 1.0
        pgm_function14[(0, 37)] = 1.0
        pgm_function14[(0, 38)] = 1.0
        pgm_function14[(0, 39)] = 1.0
        pgm_function14[(0, 40)] = 1.0
        pgm_function14[(0, 41)] = 1.0
        pgm_function14[(0, 42)] = 1.0
        pgm_function14[(0, 43)] = 1.0
        pgm_function14[(0, 44)] = 1.0
        pgm_function14[(0, 45)] = 1.0
        pgm_function14[(0, 46)] = 1.0
        pgm_function14[(0, 47)] = 1.0
        pgm_function14[(0, 48)] = 1.0
        pgm_function14[(0, 49)] = 1.0
        pgm_function14[(0, 50)] = 1.0
        pgm_function14[(0, 51)] = 1.0
        pgm_function14[(0, 52)] = 1.0
        pgm_function14[(0, 53)] = 1.0
        pgm_function14[(0, 54)] = 1.0
        pgm_function14[(0, 55)] = 1.0
        pgm_function14[(0, 56)] = 1.0
        pgm_function14[(0, 57)] = 1.0
        pgm_function14[(0, 58)] = 1.0
        pgm_function14[(0, 59)] = 1.0
        pgm_function14[(0, 60)] = 0.9999
        pgm_function14[(0, 61)] = 1.0
        pgm_function14[(0, 62)] = 1.0
        pgm_function14[(0, 63)] = 1.0
        pgm_function14[(0, 64)] = 0.99
        pgm_function14[(0, 65)] = 1.0
        pgm_function14[(0, 66)] = 1.0
        pgm_function14[(0, 67)] = 1.0
        pgm_function14[(0, 68)] = 1.0
        pgm_function14[(0, 69)] = 0.9999
        pgm_function14[(0, 70)] = 1.0
        pgm_function14[(0, 71)] = 1.0
        pgm_function14[(0, 72)] = 1.0
        pgm_function14[(0, 73)] = 1.0
        pgm_function14[(0, 74)] = 1.0
        pgm_function14[(0, 75)] = 1.0
        pgm_function14[(1, 3)] = 0.0001
        pgm_function14[(1, 8)] = 0.0001
        pgm_function14[(1, 9)] = 0.4
        pgm_function14[(1, 15)] = 0.0001
        pgm_function14[(1, 27)] = 0.01
        pgm_function14[(1, 28)] = 0.01
        pgm_function14[(1, 29)] = 0.01
        pgm_function14[(1, 30)] = 0.01
        pgm_function14[(1, 31)] = 0.01
        pgm_function14[(1, 60)] = 0.0001
        pgm_function14[(1, 64)] = 0.01
        pgm_function14[(1, 69)] = 0.0001

        pgm_function15 = pgm_factor15.set_sparse()
        pgm_function15[(0, 0)] = 1.0
        pgm_function15[(0, 1)] = 1.0
        pgm_function15[(0, 2)] = 1.0
        pgm_function15[(0, 3)] = 1.0
        pgm_function15[(0, 4)] = 1.0
        pgm_function15[(0, 5)] = 1.0
        pgm_function15[(0, 6)] = 1.0
        pgm_function15[(0, 7)] = 1.0
        pgm_function15[(0, 8)] = 1.0
        pgm_function15[(0, 9)] = 1.0
        pgm_function15[(0, 10)] = 1.0
        pgm_function15[(0, 11)] = 1.0
        pgm_function15[(0, 12)] = 1.0
        pgm_function15[(0, 13)] = 1.0
        pgm_function15[(0, 14)] = 1.0
        pgm_function15[(0, 15)] = 1.0
        pgm_function15[(0, 16)] = 1.0
        pgm_function15[(0, 17)] = 1.0
        pgm_function15[(0, 18)] = 1.0
        pgm_function15[(0, 19)] = 1.0
        pgm_function15[(0, 20)] = 1.0
        pgm_function15[(0, 21)] = 1.0
        pgm_function15[(0, 22)] = 1.0
        pgm_function15[(0, 23)] = 1.0
        pgm_function15[(0, 24)] = 1.0
        pgm_function15[(0, 25)] = 1.0
        pgm_function15[(0, 26)] = 1.0
        pgm_function15[(0, 27)] = 1.0
        pgm_function15[(0, 28)] = 1.0
        pgm_function15[(0, 29)] = 1.0
        pgm_function15[(0, 30)] = 1.0
        pgm_function15[(0, 31)] = 1.0
        pgm_function15[(0, 32)] = 1.0
        pgm_function15[(0, 33)] = 1.0
        pgm_function15[(0, 34)] = 1.0
        pgm_function15[(0, 35)] = 1.0
        pgm_function15[(0, 36)] = 1.0
        pgm_function15[(0, 37)] = 1.0
        pgm_function15[(0, 38)] = 1.0
        pgm_function15[(0, 39)] = 1.0
        pgm_function15[(0, 40)] = 1.0
        pgm_function15[(0, 41)] = 1.0
        pgm_function15[(0, 42)] = 1.0
        pgm_function15[(0, 43)] = 1.0
        pgm_function15[(0, 44)] = 1.0
        pgm_function15[(0, 45)] = 1.0
        pgm_function15[(0, 46)] = 1.0
        pgm_function15[(0, 47)] = 1.0
        pgm_function15[(0, 48)] = 1.0
        pgm_function15[(0, 49)] = 1.0
        pgm_function15[(0, 50)] = 1.0
        pgm_function15[(0, 51)] = 1.0
        pgm_function15[(0, 52)] = 1.0
        pgm_function15[(0, 53)] = 1.0
        pgm_function15[(0, 54)] = 0.5
        pgm_function15[(0, 55)] = 1.0
        pgm_function15[(0, 56)] = 1.0
        pgm_function15[(0, 57)] = 1.0
        pgm_function15[(0, 58)] = 1.0
        pgm_function15[(0, 59)] = 1.0
        pgm_function15[(0, 60)] = 1.0
        pgm_function15[(0, 61)] = 1.0
        pgm_function15[(0, 62)] = 1.0
        pgm_function15[(0, 63)] = 1.0
        pgm_function15[(0, 64)] = 1.0
        pgm_function15[(0, 65)] = 1.0
        pgm_function15[(0, 66)] = 1.0
        pgm_function15[(0, 67)] = 1.0
        pgm_function15[(0, 68)] = 1.0
        pgm_function15[(0, 69)] = 1.0
        pgm_function15[(0, 70)] = 1.0
        pgm_function15[(0, 71)] = 1.0
        pgm_function15[(0, 72)] = 1.0
        pgm_function15[(0, 73)] = 1.0
        pgm_function15[(0, 74)] = 1.0
        pgm_function15[(0, 75)] = 1.0
        pgm_function15[(1, 54)] = 0.5

        pgm_function16 = pgm_factor16.set_dense()
        pgm_function16.set_flat(
            0.599, 0.3333333, 0.2, 0.3333333, 0.2,
            0.3333333, 0.05, 0.3333333, 0.15, 0.3333333,
            0.599, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.05, 0.3333333, 0.01, 0.3333333,
            0.15, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.9799, 0.3333333,
            0.05, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.599, 0.3333333,
            0.15, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.15, 0.3333333, 0.599, 0.3333333,
            0.599, 0.3333333, 0.599, 0.3333333, 0.1,
            0.3333333, 0.1, 0.3333333, 0.1, 0.3333333,
            0.1, 0.3333333, 0.1, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.599, 0.3333333,
            0.599, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.599, 0.3333333,
            0.599, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.599, 0.3333333,
            0.35, 0.3333333, 0.2, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.599, 0.3333333,
            0.599, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.94990501, 0.01,
            0.599, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.599, 0.3333333,
            0.05, 0.3333333, 0.599, 0.3333333, 0.35,
            0.3333333, 0.599, 0.3333333, 0.1, 0.3333333,
            0.599, 0.3333333, 0.15, 0.3333333, 0.599,
            0.3333333, 0.05, 0.3333333, 0.599, 0.3333333,
            0.599, 0.3333333, 0.599, 0.3333333, 0.599,
            0.3333333, 0.599, 0.3333333, 0.599, 0.3333333,
            0.599, 0.3333333, 0.4, 0.3333333, 0.75,
            0.3333333, 0.75, 0.3333333, 0.9, 0.3333333,
            0.83, 0.3333333, 0.4, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.9, 0.3333333,
            0.2, 0.3333333, 0.83, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.02, 0.3333333, 0.9, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.4, 0.3333333, 0.83, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.83, 0.3333333,
            0.4, 0.3333333, 0.4, 0.3333333, 0.4,
            0.3333333, 0.75, 0.3333333, 0.75, 0.3333333,
            0.75, 0.3333333, 0.75, 0.3333333, 0.75,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.4, 0.3333333, 0.4, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.4, 0.3333333, 0.4, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.4, 0.3333333, 0.63, 0.3333333, 0.75,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.4, 0.3333333, 0.4, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.049995, 0.89, 0.4, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.4, 0.3333333, 0.9, 0.3333333, 0.4,
            0.3333333, 0.63, 0.3333333, 0.4, 0.3333333,
            0.75, 0.3333333, 0.4, 0.3333333, 0.83,
            0.3333333, 0.4, 0.3333333, 0.9, 0.3333333,
            0.4, 0.3333333, 0.4, 0.3333333, 0.4,
            0.3333333, 0.4, 0.3333333, 0.4, 0.3333333,
            0.4, 0.3333333, 0.4, 0.3333333, 0.001,
            0.3333333, 0.05, 0.3333333, 0.05, 0.3333333,
            0.05, 0.3333333, 0.02, 0.3333333, 0.001,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.05, 0.3333333, 0.79, 0.3333333, 0.02,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 0.0001, 0.3333333, 0.05,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 0.001, 0.3333333, 0.02,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.02, 0.3333333, 0.001, 0.3333333, 0.001,
            0.3333333, 0.001, 0.3333333, 0.15, 0.3333333,
            0.15, 0.3333333, 0.15, 0.3333333, 0.15,
            0.3333333, 0.15, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 0.001, 0.3333333, 0.001,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 0.001, 0.3333333, 0.001,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 0.001, 0.3333333, 0.02,
            0.3333333, 0.05, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 0.001, 0.3333333, 0.001,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 9.999e-05, 0.1, 0.001,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 0.001, 0.3333333, 0.05,
            0.3333333, 0.001, 0.3333333, 0.02, 0.3333333,
            0.001, 0.3333333, 0.15, 0.3333333, 0.001,
            0.3333333, 0.02, 0.3333333, 0.001, 0.3333333,
            0.05, 0.3333333, 0.001, 0.3333333, 0.001,
            0.3333333, 0.001, 0.3333333, 0.001, 0.3333333,
            0.001, 0.3333333, 0.001, 0.3333333, 0.001,
            0.3333333
        )

        pgm_function17 = pgm_factor17.set_sparse()
        pgm_function17[(0, 0)] = 0.98
        pgm_function17[(0, 1)] = 0.88
        pgm_function17[(0, 2)] = 0.98
        pgm_function17[(0, 3)] = 0.3
        pgm_function17[(0, 4)] = 0.79
        pgm_function17[(0, 5)] = 0.98
        pgm_function17[(0, 6)] = 0.98
        pgm_function17[(0, 7)] = 0.98
        pgm_function17[(0, 9)] = 0.98
        pgm_function17[(0, 10)] = 0.25
        pgm_function17[(0, 11)] = 0.02
        pgm_function17[(0, 12)] = 0.01
        pgm_function17[(0, 13)] = 0.98
        pgm_function17[(0, 14)] = 0.945
        pgm_function17[(0, 15)] = 0.5
        pgm_function17[(0, 16)] = 0.98
        pgm_function17[(0, 18)] = 0.98
        pgm_function17[(0, 19)] = 0.98
        pgm_function17[(0, 22)] = 0.02
        pgm_function17[(0, 23)] = 0.25
        pgm_function17[(0, 24)] = 0.01
        pgm_function17[(0, 25)] = 0.25
        pgm_function17[(0, 26)] = 0.25
        pgm_function17[(0, 27)] = 0.95
        pgm_function17[(0, 28)] = 0.95
        pgm_function17[(0, 29)] = 0.95
        pgm_function17[(0, 30)] = 0.2
        pgm_function17[(0, 31)] = 0.3
        pgm_function17[(0, 32)] = 0.98
        pgm_function17[(0, 33)] = 0.98
        pgm_function17[(0, 34)] = 0.98
        pgm_function17[(0, 35)] = 0.98
        pgm_function17[(0, 36)] = 0.98
        pgm_function17[(0, 37)] = 0.98
        pgm_function17[(0, 38)] = 0.98
        pgm_function17[(0, 39)] = 0.98
        pgm_function17[(0, 40)] = 0.98
        pgm_function17[(0, 41)] = 0.98
        pgm_function17[(0, 42)] = 0.88
        pgm_function17[(0, 43)] = 0.975
        pgm_function17[(0, 44)] = 0.98
        pgm_function17[(0, 45)] = 0.88
        pgm_function17[(0, 46)] = 0.89
        pgm_function17[(0, 47)] = 0.91
        pgm_function17[(0, 48)] = 0.98
        pgm_function17[(0, 49)] = 0.98
        pgm_function17[(0, 50)] = 0.975
        pgm_function17[(0, 51)] = 0.98
        pgm_function17[(0, 52)] = 0.98
        pgm_function17[(0, 53)] = 0.91
        pgm_function17[(0, 54)] = 0.98
        pgm_function17[(0, 55)] = 0.98
        pgm_function17[(0, 56)] = 0.98
        pgm_function17[(0, 57)] = 0.98
        pgm_function17[(0, 58)] = 0.98
        pgm_function17[(0, 59)] = 0.98
        pgm_function17[(0, 60)] = 0.3
        pgm_function17[(0, 61)] = 0.3
        pgm_function17[(0, 62)] = 0.91
        pgm_function17[(0, 63)] = 0.975
        pgm_function17[(0, 64)] = 0.98
        pgm_function17[(0, 65)] = 0.5
        pgm_function17[(0, 66)] = 0.25
        pgm_function17[(0, 67)] = 0.65
        pgm_function17[(0, 68)] = 0.3
        pgm_function17[(0, 69)] = 0.65
        pgm_function17[(0, 70)] = 0.3
        pgm_function17[(0, 71)] = 0.3
        pgm_function17[(0, 72)] = 0.3
        pgm_function17[(0, 74)] = 0.98
        pgm_function17[(0, 75)] = 0.98
        pgm_function17[(1, 0)] = 0.02
        pgm_function17[(1, 1)] = 0.1
        pgm_function17[(1, 2)] = 0.02
        pgm_function17[(1, 3)] = 0.6
        pgm_function17[(1, 4)] = 0.2
        pgm_function17[(1, 5)] = 0.02
        pgm_function17[(1, 6)] = 0.02
        pgm_function17[(1, 7)] = 0.02
        pgm_function17[(1, 8)] = 0.7
        pgm_function17[(1, 9)] = 0.02
        pgm_function17[(1, 10)] = 0.7
        pgm_function17[(1, 11)] = 0.88
        pgm_function17[(1, 12)] = 0.79
        pgm_function17[(1, 13)] = 0.02
        pgm_function17[(1, 14)] = 0.05
        pgm_function17[(1, 15)] = 0.45
        pgm_function17[(1, 16)] = 0.02
        pgm_function17[(1, 18)] = 0.02
        pgm_function17[(1, 19)] = 0.02
        pgm_function17[(1, 20)] = 0.7
        pgm_function17[(1, 21)] = 0.6
        pgm_function17[(1, 22)] = 0.88
        pgm_function17[(1, 23)] = 0.7
        pgm_function17[(1, 24)] = 0.79
        pgm_function17[(1, 25)] = 0.45
        pgm_function17[(1, 26)] = 0.45
        pgm_function17[(1, 27)] = 0.049
        pgm_function17[(1, 28)] = 0.049
        pgm_function17[(1, 29)] = 0.049
        pgm_function17[(1, 30)] = 0.3
        pgm_function17[(1, 31)] = 0.6
        pgm_function17[(1, 32)] = 0.02
        pgm_function17[(1, 33)] = 0.02
        pgm_function17[(1, 34)] = 0.02
        pgm_function17[(1, 35)] = 0.02
        pgm_function17[(1, 36)] = 0.02
        pgm_function17[(1, 37)] = 0.02
        pgm_function17[(1, 38)] = 0.02
        pgm_function17[(1, 39)] = 0.02
        pgm_function17[(1, 40)] = 0.02
        pgm_function17[(1, 41)] = 0.02
        pgm_function17[(1, 42)] = 0.1
        pgm_function17[(1, 43)] = 0.02
        pgm_function17[(1, 44)] = 0.02
        pgm_function17[(1, 45)] = 0.1
        pgm_function17[(1, 46)] = 0.1
        pgm_function17[(1, 47)] = 0.08
        pgm_function17[(1, 48)] = 0.02
        pgm_function17[(1, 49)] = 0.02
        pgm_function17[(1, 50)] = 0.02
        pgm_function17[(1, 51)] = 0.02
        pgm_function17[(1, 52)] = 0.02
        pgm_function17[(1, 53)] = 0.08
        pgm_function17[(1, 54)] = 0.02
        pgm_function17[(1, 55)] = 0.02
        pgm_function17[(1, 56)] = 0.02
        pgm_function17[(1, 57)] = 0.02
        pgm_function17[(1, 58)] = 0.02
        pgm_function17[(1, 59)] = 0.02
        pgm_function17[(1, 60)] = 0.6
        pgm_function17[(1, 61)] = 0.6
        pgm_function17[(1, 62)] = 0.08
        pgm_function17[(1, 63)] = 0.02
        pgm_function17[(1, 64)] = 0.02
        pgm_function17[(1, 65)] = 0.2
        pgm_function17[(1, 66)] = 0.7
        pgm_function17[(1, 67)] = 0.34
        pgm_function17[(1, 68)] = 0.6
        pgm_function17[(1, 69)] = 0.34
        pgm_function17[(1, 70)] = 0.6
        pgm_function17[(1, 71)] = 0.6
        pgm_function17[(1, 72)] = 0.6
        pgm_function17[(1, 73)] = 0.6
        pgm_function17[(1, 74)] = 0.02
        pgm_function17[(1, 75)] = 0.02
        pgm_function17[(2, 1)] = 0.02
        pgm_function17[(2, 3)] = 0.1
        pgm_function17[(2, 4)] = 0.01
        pgm_function17[(2, 8)] = 0.3
        pgm_function17[(2, 10)] = 0.05
        pgm_function17[(2, 11)] = 0.1
        pgm_function17[(2, 12)] = 0.2
        pgm_function17[(2, 14)] = 0.005
        pgm_function17[(2, 15)] = 0.05
        pgm_function17[(2, 17)] = 1.0
        pgm_function17[(2, 20)] = 0.3
        pgm_function17[(2, 21)] = 0.4
        pgm_function17[(2, 22)] = 0.1
        pgm_function17[(2, 23)] = 0.05
        pgm_function17[(2, 24)] = 0.2
        pgm_function17[(2, 25)] = 0.3
        pgm_function17[(2, 26)] = 0.3
        pgm_function17[(2, 27)] = 0.001
        pgm_function17[(2, 28)] = 0.001
        pgm_function17[(2, 29)] = 0.001
        pgm_function17[(2, 30)] = 0.5
        pgm_function17[(2, 31)] = 0.1
        pgm_function17[(2, 42)] = 0.02
        pgm_function17[(2, 43)] = 0.005
        pgm_function17[(2, 45)] = 0.02
        pgm_function17[(2, 46)] = 0.01
        pgm_function17[(2, 47)] = 0.01
        pgm_function17[(2, 50)] = 0.005
        pgm_function17[(2, 53)] = 0.01
        pgm_function17[(2, 60)] = 0.1
        pgm_function17[(2, 61)] = 0.1
        pgm_function17[(2, 62)] = 0.01
        pgm_function17[(2, 63)] = 0.005
        pgm_function17[(2, 65)] = 0.3
        pgm_function17[(2, 66)] = 0.05
        pgm_function17[(2, 67)] = 0.01
        pgm_function17[(2, 68)] = 0.1
        pgm_function17[(2, 69)] = 0.01
        pgm_function17[(2, 70)] = 0.1
        pgm_function17[(2, 71)] = 0.1
        pgm_function17[(2, 72)] = 0.1
        pgm_function17[(2, 73)] = 0.4

        pgm_function18 = pgm_factor18.set_sparse()
        pgm_function18[(0, 0, 0, 0)] = 1.0
        pgm_function18[(0, 0, 0, 1)] = 1.0
        pgm_function18[(0, 0, 0, 2)] = 1.0
        pgm_function18[(0, 0, 1, 0)] = 1.0
        pgm_function18[(0, 0, 2, 0)] = 1.0
        pgm_function18[(0, 0, 3, 0)] = 1.0
        pgm_function18[(0, 0, 4, 0)] = 1.0
        pgm_function18[(0, 1, 0, 0)] = 1.0
        pgm_function18[(0, 1, 0, 1)] = 1.0
        pgm_function18[(0, 1, 0, 2)] = 1.0
        pgm_function18[(0, 1, 1, 0)] = 1.0
        pgm_function18[(0, 1, 2, 0)] = 1.0
        pgm_function18[(0, 1, 3, 0)] = 1.0
        pgm_function18[(0, 1, 4, 0)] = 1.0
        pgm_function18[(0, 2, 0, 0)] = 1.0
        pgm_function18[(0, 2, 0, 1)] = 1.0
        pgm_function18[(0, 2, 0, 2)] = 1.0
        pgm_function18[(0, 2, 1, 0)] = 1.0
        pgm_function18[(0, 2, 1, 2)] = 1.0
        pgm_function18[(0, 2, 2, 0)] = 1.0
        pgm_function18[(0, 2, 2, 2)] = 1.0
        pgm_function18[(0, 2, 3, 0)] = 1.0
        pgm_function18[(0, 2, 3, 2)] = 1.0
        pgm_function18[(0, 2, 4, 0)] = 1.0
        pgm_function18[(0, 2, 4, 2)] = 1.0
        pgm_function18[(0, 3, 0, 0)] = 1.0
        pgm_function18[(0, 3, 0, 1)] = 1.0
        pgm_function18[(0, 3, 0, 2)] = 1.0
        pgm_function18[(0, 3, 1, 0)] = 1.0
        pgm_function18[(0, 3, 2, 0)] = 1.0
        pgm_function18[(0, 3, 3, 0)] = 1.0
        pgm_function18[(0, 3, 4, 0)] = 1.0
        pgm_function18[(0, 4, 0, 0)] = 1.0
        pgm_function18[(0, 4, 0, 1)] = 1.0
        pgm_function18[(0, 4, 0, 2)] = 1.0
        pgm_function18[(0, 4, 1, 0)] = 1.0
        pgm_function18[(0, 4, 2, 0)] = 1.0
        pgm_function18[(0, 4, 3, 0)] = 1.0
        pgm_function18[(0, 4, 4, 0)] = 1.0
        pgm_function18[(0, 5, 0, 0)] = 1.0
        pgm_function18[(0, 5, 0, 1)] = 1.0
        pgm_function18[(0, 5, 0, 2)] = 1.0
        pgm_function18[(0, 5, 1, 0)] = 1.0
        pgm_function18[(0, 5, 1, 2)] = 1.0
        pgm_function18[(0, 5, 2, 0)] = 1.0
        pgm_function18[(0, 5, 2, 2)] = 1.0
        pgm_function18[(0, 5, 3, 0)] = 1.0
        pgm_function18[(0, 5, 3, 2)] = 1.0
        pgm_function18[(0, 5, 4, 0)] = 1.0
        pgm_function18[(0, 5, 4, 2)] = 1.0
        pgm_function18[(0, 6, 0, 0)] = 1.0
        pgm_function18[(0, 6, 0, 1)] = 1.0
        pgm_function18[(0, 6, 0, 2)] = 1.0
        pgm_function18[(0, 6, 1, 0)] = 1.0
        pgm_function18[(0, 6, 1, 2)] = 1.0
        pgm_function18[(0, 6, 2, 0)] = 1.0
        pgm_function18[(0, 6, 2, 2)] = 1.0
        pgm_function18[(0, 6, 3, 0)] = 1.0
        pgm_function18[(0, 6, 3, 2)] = 1.0
        pgm_function18[(0, 6, 4, 0)] = 1.0
        pgm_function18[(0, 6, 4, 2)] = 1.0
        pgm_function18[(0, 7, 0, 0)] = 1.0
        pgm_function18[(0, 7, 0, 1)] = 1.0
        pgm_function18[(0, 7, 0, 2)] = 1.0
        pgm_function18[(0, 7, 1, 0)] = 1.0
        pgm_function18[(0, 7, 1, 2)] = 1.0
        pgm_function18[(0, 7, 2, 0)] = 1.0
        pgm_function18[(0, 7, 2, 2)] = 1.0
        pgm_function18[(0, 7, 3, 0)] = 1.0
        pgm_function18[(0, 7, 3, 2)] = 1.0
        pgm_function18[(0, 7, 4, 0)] = 1.0
        pgm_function18[(0, 7, 4, 2)] = 1.0
        pgm_function18[(0, 8, 0, 0)] = 1.0
        pgm_function18[(0, 8, 0, 1)] = 1.0
        pgm_function18[(0, 8, 0, 2)] = 1.0
        pgm_function18[(0, 8, 1, 0)] = 1.0
        pgm_function18[(0, 8, 2, 0)] = 1.0
        pgm_function18[(0, 8, 3, 0)] = 1.0
        pgm_function18[(0, 8, 4, 0)] = 1.0
        pgm_function18[(0, 9, 0, 0)] = 1.0
        pgm_function18[(0, 9, 0, 1)] = 1.0
        pgm_function18[(0, 9, 0, 2)] = 1.0
        pgm_function18[(0, 9, 1, 0)] = 1.0
        pgm_function18[(0, 9, 1, 2)] = 1.0
        pgm_function18[(0, 9, 2, 0)] = 1.0
        pgm_function18[(0, 9, 2, 2)] = 1.0
        pgm_function18[(0, 9, 3, 0)] = 1.0
        pgm_function18[(0, 9, 3, 2)] = 1.0
        pgm_function18[(0, 9, 4, 0)] = 1.0
        pgm_function18[(0, 9, 4, 2)] = 1.0
        pgm_function18[(0, 10, 0, 0)] = 1.0
        pgm_function18[(0, 10, 0, 1)] = 1.0
        pgm_function18[(0, 10, 0, 2)] = 1.0
        pgm_function18[(0, 10, 1, 0)] = 1.0
        pgm_function18[(0, 10, 2, 0)] = 1.0
        pgm_function18[(0, 10, 3, 0)] = 1.0
        pgm_function18[(0, 10, 4, 0)] = 1.0
        pgm_function18[(0, 11, 0, 0)] = 1.0
        pgm_function18[(0, 11, 0, 1)] = 1.0
        pgm_function18[(0, 11, 0, 2)] = 1.0
        pgm_function18[(0, 11, 1, 0)] = 1.0
        pgm_function18[(0, 11, 2, 0)] = 1.0
        pgm_function18[(0, 11, 3, 0)] = 1.0
        pgm_function18[(0, 11, 4, 0)] = 1.0
        pgm_function18[(0, 12, 0, 0)] = 1.0
        pgm_function18[(0, 12, 0, 1)] = 1.0
        pgm_function18[(0, 12, 0, 2)] = 1.0
        pgm_function18[(0, 12, 1, 0)] = 1.0
        pgm_function18[(0, 12, 2, 0)] = 1.0
        pgm_function18[(0, 12, 3, 0)] = 1.0
        pgm_function18[(0, 12, 4, 0)] = 1.0
        pgm_function18[(0, 13, 0, 0)] = 1.0
        pgm_function18[(0, 13, 0, 1)] = 1.0
        pgm_function18[(0, 13, 0, 2)] = 1.0
        pgm_function18[(0, 13, 1, 0)] = 1.0
        pgm_function18[(0, 13, 1, 2)] = 1.0
        pgm_function18[(0, 13, 2, 0)] = 1.0
        pgm_function18[(0, 13, 2, 2)] = 1.0
        pgm_function18[(0, 13, 3, 0)] = 1.0
        pgm_function18[(0, 13, 3, 2)] = 1.0
        pgm_function18[(0, 13, 4, 0)] = 1.0
        pgm_function18[(0, 13, 4, 2)] = 1.0
        pgm_function18[(0, 14, 0, 0)] = 1.0
        pgm_function18[(0, 14, 0, 1)] = 1.0
        pgm_function18[(0, 14, 0, 2)] = 1.0
        pgm_function18[(0, 14, 1, 0)] = 1.0
        pgm_function18[(0, 14, 2, 0)] = 1.0
        pgm_function18[(0, 14, 3, 0)] = 1.0
        pgm_function18[(0, 14, 4, 0)] = 1.0
        pgm_function18[(0, 15, 0, 0)] = 1.0
        pgm_function18[(0, 15, 0, 1)] = 1.0
        pgm_function18[(0, 15, 0, 2)] = 1.0
        pgm_function18[(0, 15, 1, 0)] = 1.0
        pgm_function18[(0, 15, 2, 0)] = 1.0
        pgm_function18[(0, 15, 3, 0)] = 1.0
        pgm_function18[(0, 15, 4, 0)] = 1.0
        pgm_function18[(0, 16, 0, 0)] = 1.0
        pgm_function18[(0, 16, 0, 1)] = 1.0
        pgm_function18[(0, 16, 0, 2)] = 1.0
        pgm_function18[(0, 16, 1, 0)] = 1.0
        pgm_function18[(0, 16, 1, 2)] = 1.0
        pgm_function18[(0, 16, 2, 0)] = 1.0
        pgm_function18[(0, 16, 2, 2)] = 1.0
        pgm_function18[(0, 16, 3, 0)] = 1.0
        pgm_function18[(0, 16, 3, 2)] = 1.0
        pgm_function18[(0, 16, 4, 0)] = 1.0
        pgm_function18[(0, 16, 4, 2)] = 1.0
        pgm_function18[(0, 17, 0, 0)] = 1.0
        pgm_function18[(0, 17, 0, 1)] = 1.0
        pgm_function18[(0, 17, 0, 2)] = 1.0
        pgm_function18[(0, 17, 1, 0)] = 1.0
        pgm_function18[(0, 17, 2, 0)] = 1.0
        pgm_function18[(0, 17, 3, 0)] = 1.0
        pgm_function18[(0, 17, 4, 0)] = 1.0
        pgm_function18[(0, 18, 0, 0)] = 1.0
        pgm_function18[(0, 18, 0, 1)] = 1.0
        pgm_function18[(0, 18, 0, 2)] = 1.0
        pgm_function18[(0, 18, 1, 0)] = 1.0
        pgm_function18[(0, 18, 1, 2)] = 1.0
        pgm_function18[(0, 18, 2, 0)] = 1.0
        pgm_function18[(0, 18, 2, 2)] = 1.0
        pgm_function18[(0, 18, 3, 0)] = 1.0
        pgm_function18[(0, 18, 3, 2)] = 1.0
        pgm_function18[(0, 18, 4, 0)] = 1.0
        pgm_function18[(0, 18, 4, 2)] = 1.0
        pgm_function18[(0, 19, 0, 0)] = 1.0
        pgm_function18[(0, 19, 0, 1)] = 1.0
        pgm_function18[(0, 19, 0, 2)] = 1.0
        pgm_function18[(0, 19, 1, 0)] = 1.0
        pgm_function18[(0, 19, 1, 2)] = 1.0
        pgm_function18[(0, 19, 2, 0)] = 1.0
        pgm_function18[(0, 19, 2, 2)] = 1.0
        pgm_function18[(0, 19, 3, 0)] = 1.0
        pgm_function18[(0, 19, 3, 2)] = 1.0
        pgm_function18[(0, 19, 4, 0)] = 1.0
        pgm_function18[(0, 19, 4, 2)] = 1.0
        pgm_function18[(0, 20, 0, 0)] = 1.0
        pgm_function18[(0, 20, 0, 1)] = 1.0
        pgm_function18[(0, 20, 0, 2)] = 1.0
        pgm_function18[(0, 20, 1, 0)] = 1.0
        pgm_function18[(0, 20, 2, 0)] = 1.0
        pgm_function18[(0, 20, 3, 0)] = 1.0
        pgm_function18[(0, 20, 4, 0)] = 1.0
        pgm_function18[(0, 21, 0, 0)] = 1.0
        pgm_function18[(0, 21, 0, 1)] = 1.0
        pgm_function18[(0, 21, 0, 2)] = 1.0
        pgm_function18[(0, 21, 1, 0)] = 1.0
        pgm_function18[(0, 21, 2, 0)] = 1.0
        pgm_function18[(0, 21, 3, 0)] = 1.0
        pgm_function18[(0, 21, 4, 0)] = 1.0
        pgm_function18[(0, 22, 0, 0)] = 1.0
        pgm_function18[(0, 22, 0, 1)] = 1.0
        pgm_function18[(0, 22, 0, 2)] = 1.0
        pgm_function18[(0, 22, 1, 0)] = 1.0
        pgm_function18[(0, 22, 2, 0)] = 1.0
        pgm_function18[(0, 22, 3, 0)] = 1.0
        pgm_function18[(0, 22, 4, 0)] = 1.0
        pgm_function18[(0, 23, 0, 0)] = 1.0
        pgm_function18[(0, 23, 0, 1)] = 1.0
        pgm_function18[(0, 23, 0, 2)] = 1.0
        pgm_function18[(0, 23, 1, 0)] = 1.0
        pgm_function18[(0, 23, 2, 0)] = 1.0
        pgm_function18[(0, 23, 3, 0)] = 1.0
        pgm_function18[(0, 23, 4, 0)] = 1.0
        pgm_function18[(0, 24, 0, 0)] = 1.0
        pgm_function18[(0, 24, 0, 1)] = 1.0
        pgm_function18[(0, 24, 0, 2)] = 1.0
        pgm_function18[(0, 24, 1, 0)] = 1.0
        pgm_function18[(0, 24, 2, 0)] = 1.0
        pgm_function18[(0, 24, 3, 0)] = 1.0
        pgm_function18[(0, 24, 4, 0)] = 1.0
        pgm_function18[(0, 25, 0, 0)] = 1.0
        pgm_function18[(0, 25, 0, 1)] = 1.0
        pgm_function18[(0, 25, 0, 2)] = 1.0
        pgm_function18[(0, 25, 1, 0)] = 1.0
        pgm_function18[(0, 25, 2, 0)] = 1.0
        pgm_function18[(0, 25, 3, 0)] = 1.0
        pgm_function18[(0, 25, 4, 0)] = 1.0
        pgm_function18[(0, 26, 0, 0)] = 1.0
        pgm_function18[(0, 26, 0, 1)] = 1.0
        pgm_function18[(0, 26, 0, 2)] = 1.0
        pgm_function18[(0, 26, 1, 0)] = 1.0
        pgm_function18[(0, 26, 2, 0)] = 1.0
        pgm_function18[(0, 26, 3, 0)] = 1.0
        pgm_function18[(0, 26, 4, 0)] = 1.0
        pgm_function18[(0, 27, 0, 0)] = 1.0
        pgm_function18[(0, 27, 0, 1)] = 1.0
        pgm_function18[(0, 27, 0, 2)] = 1.0
        pgm_function18[(0, 27, 1, 0)] = 1.0
        pgm_function18[(0, 27, 2, 0)] = 1.0
        pgm_function18[(0, 27, 3, 0)] = 1.0
        pgm_function18[(0, 27, 4, 0)] = 1.0
        pgm_function18[(0, 28, 0, 0)] = 1.0
        pgm_function18[(0, 28, 0, 1)] = 1.0
        pgm_function18[(0, 28, 0, 2)] = 1.0
        pgm_function18[(0, 28, 1, 0)] = 1.0
        pgm_function18[(0, 28, 2, 0)] = 1.0
        pgm_function18[(0, 28, 3, 0)] = 1.0
        pgm_function18[(0, 28, 4, 0)] = 1.0
        pgm_function18[(0, 29, 0, 0)] = 1.0
        pgm_function18[(0, 29, 0, 1)] = 1.0
        pgm_function18[(0, 29, 0, 2)] = 1.0
        pgm_function18[(0, 29, 1, 0)] = 1.0
        pgm_function18[(0, 29, 2, 0)] = 1.0
        pgm_function18[(0, 29, 3, 0)] = 1.0
        pgm_function18[(0, 29, 4, 0)] = 1.0
        pgm_function18[(0, 30, 0, 0)] = 1.0
        pgm_function18[(0, 30, 0, 1)] = 1.0
        pgm_function18[(0, 30, 0, 2)] = 1.0
        pgm_function18[(0, 30, 1, 0)] = 1.0
        pgm_function18[(0, 30, 2, 0)] = 1.0
        pgm_function18[(0, 30, 3, 0)] = 1.0
        pgm_function18[(0, 30, 4, 0)] = 1.0
        pgm_function18[(0, 31, 0, 0)] = 1.0
        pgm_function18[(0, 31, 0, 1)] = 1.0
        pgm_function18[(0, 31, 0, 2)] = 1.0
        pgm_function18[(0, 31, 1, 0)] = 1.0
        pgm_function18[(0, 31, 2, 0)] = 1.0
        pgm_function18[(0, 31, 3, 0)] = 1.0
        pgm_function18[(0, 31, 4, 0)] = 1.0
        pgm_function18[(0, 32, 0, 0)] = 1.0
        pgm_function18[(0, 32, 0, 1)] = 1.0
        pgm_function18[(0, 32, 0, 2)] = 1.0
        pgm_function18[(0, 32, 1, 0)] = 1.0
        pgm_function18[(0, 32, 1, 2)] = 1.0
        pgm_function18[(0, 32, 2, 0)] = 1.0
        pgm_function18[(0, 32, 2, 2)] = 1.0
        pgm_function18[(0, 32, 3, 0)] = 1.0
        pgm_function18[(0, 32, 3, 2)] = 1.0
        pgm_function18[(0, 32, 4, 0)] = 1.0
        pgm_function18[(0, 32, 4, 2)] = 1.0
        pgm_function18[(0, 33, 0, 0)] = 1.0
        pgm_function18[(0, 33, 0, 1)] = 1.0
        pgm_function18[(0, 33, 0, 2)] = 1.0
        pgm_function18[(0, 33, 1, 0)] = 1.0
        pgm_function18[(0, 33, 1, 2)] = 1.0
        pgm_function18[(0, 33, 2, 0)] = 1.0
        pgm_function18[(0, 33, 2, 2)] = 1.0
        pgm_function18[(0, 33, 3, 0)] = 1.0
        pgm_function18[(0, 33, 3, 2)] = 1.0
        pgm_function18[(0, 33, 4, 0)] = 1.0
        pgm_function18[(0, 33, 4, 2)] = 1.0
        pgm_function18[(0, 34, 0, 0)] = 1.0
        pgm_function18[(0, 34, 0, 1)] = 1.0
        pgm_function18[(0, 34, 0, 2)] = 1.0
        pgm_function18[(0, 34, 1, 0)] = 1.0
        pgm_function18[(0, 34, 1, 2)] = 1.0
        pgm_function18[(0, 34, 2, 0)] = 1.0
        pgm_function18[(0, 34, 2, 2)] = 1.0
        pgm_function18[(0, 34, 3, 0)] = 1.0
        pgm_function18[(0, 34, 3, 2)] = 1.0
        pgm_function18[(0, 34, 4, 0)] = 1.0
        pgm_function18[(0, 34, 4, 2)] = 1.0
        pgm_function18[(0, 35, 0, 0)] = 1.0
        pgm_function18[(0, 35, 0, 1)] = 1.0
        pgm_function18[(0, 35, 0, 2)] = 1.0
        pgm_function18[(0, 35, 1, 0)] = 1.0
        pgm_function18[(0, 35, 1, 2)] = 1.0
        pgm_function18[(0, 35, 2, 0)] = 1.0
        pgm_function18[(0, 35, 2, 2)] = 1.0
        pgm_function18[(0, 35, 3, 0)] = 1.0
        pgm_function18[(0, 35, 3, 2)] = 1.0
        pgm_function18[(0, 35, 4, 0)] = 1.0
        pgm_function18[(0, 35, 4, 2)] = 1.0
        pgm_function18[(0, 36, 0, 0)] = 1.0
        pgm_function18[(0, 36, 0, 1)] = 1.0
        pgm_function18[(0, 36, 0, 2)] = 1.0
        pgm_function18[(0, 36, 1, 0)] = 1.0
        pgm_function18[(0, 36, 1, 2)] = 1.0
        pgm_function18[(0, 36, 2, 0)] = 1.0
        pgm_function18[(0, 36, 2, 2)] = 1.0
        pgm_function18[(0, 36, 3, 0)] = 1.0
        pgm_function18[(0, 36, 3, 2)] = 1.0
        pgm_function18[(0, 36, 4, 0)] = 1.0
        pgm_function18[(0, 36, 4, 2)] = 1.0
        pgm_function18[(0, 37, 0, 0)] = 1.0
        pgm_function18[(0, 37, 0, 1)] = 1.0
        pgm_function18[(0, 37, 0, 2)] = 1.0
        pgm_function18[(0, 37, 1, 0)] = 1.0
        pgm_function18[(0, 37, 1, 2)] = 1.0
        pgm_function18[(0, 37, 2, 0)] = 1.0
        pgm_function18[(0, 37, 2, 2)] = 1.0
        pgm_function18[(0, 37, 3, 0)] = 1.0
        pgm_function18[(0, 37, 3, 2)] = 1.0
        pgm_function18[(0, 37, 4, 0)] = 1.0
        pgm_function18[(0, 37, 4, 2)] = 1.0
        pgm_function18[(0, 38, 0, 0)] = 1.0
        pgm_function18[(0, 38, 0, 1)] = 1.0
        pgm_function18[(0, 38, 0, 2)] = 1.0
        pgm_function18[(0, 38, 1, 0)] = 1.0
        pgm_function18[(0, 38, 1, 2)] = 1.0
        pgm_function18[(0, 38, 2, 0)] = 1.0
        pgm_function18[(0, 38, 2, 2)] = 1.0
        pgm_function18[(0, 38, 3, 0)] = 1.0
        pgm_function18[(0, 38, 3, 2)] = 1.0
        pgm_function18[(0, 38, 4, 0)] = 1.0
        pgm_function18[(0, 38, 4, 2)] = 1.0
        pgm_function18[(0, 39, 0, 0)] = 1.0
        pgm_function18[(0, 39, 0, 1)] = 1.0
        pgm_function18[(0, 39, 0, 2)] = 1.0
        pgm_function18[(0, 39, 1, 0)] = 1.0
        pgm_function18[(0, 39, 1, 2)] = 1.0
        pgm_function18[(0, 39, 2, 0)] = 1.0
        pgm_function18[(0, 39, 2, 2)] = 1.0
        pgm_function18[(0, 39, 3, 0)] = 1.0
        pgm_function18[(0, 39, 3, 2)] = 1.0
        pgm_function18[(0, 39, 4, 0)] = 1.0
        pgm_function18[(0, 39, 4, 2)] = 1.0
        pgm_function18[(0, 40, 0, 0)] = 1.0
        pgm_function18[(0, 40, 0, 1)] = 1.0
        pgm_function18[(0, 40, 0, 2)] = 1.0
        pgm_function18[(0, 40, 1, 0)] = 1.0
        pgm_function18[(0, 40, 1, 2)] = 1.0
        pgm_function18[(0, 40, 2, 0)] = 1.0
        pgm_function18[(0, 40, 2, 2)] = 1.0
        pgm_function18[(0, 40, 3, 0)] = 1.0
        pgm_function18[(0, 40, 3, 2)] = 1.0
        pgm_function18[(0, 40, 4, 0)] = 1.0
        pgm_function18[(0, 40, 4, 2)] = 1.0
        pgm_function18[(0, 41, 0, 0)] = 1.0
        pgm_function18[(0, 41, 0, 1)] = 1.0
        pgm_function18[(0, 41, 0, 2)] = 1.0
        pgm_function18[(0, 41, 1, 0)] = 1.0
        pgm_function18[(0, 41, 1, 2)] = 1.0
        pgm_function18[(0, 41, 2, 0)] = 1.0
        pgm_function18[(0, 41, 2, 2)] = 1.0
        pgm_function18[(0, 41, 3, 0)] = 1.0
        pgm_function18[(0, 41, 3, 2)] = 1.0
        pgm_function18[(0, 41, 4, 0)] = 1.0
        pgm_function18[(0, 41, 4, 2)] = 1.0
        pgm_function18[(0, 42, 0, 0)] = 1.0
        pgm_function18[(0, 42, 0, 1)] = 1.0
        pgm_function18[(0, 42, 0, 2)] = 1.0
        pgm_function18[(0, 42, 1, 0)] = 1.0
        pgm_function18[(0, 42, 1, 2)] = 1.0
        pgm_function18[(0, 42, 2, 0)] = 1.0
        pgm_function18[(0, 42, 2, 2)] = 1.0
        pgm_function18[(0, 42, 3, 0)] = 1.0
        pgm_function18[(0, 42, 3, 2)] = 1.0
        pgm_function18[(0, 42, 4, 0)] = 1.0
        pgm_function18[(0, 42, 4, 2)] = 1.0
        pgm_function18[(0, 43, 0, 0)] = 1.0
        pgm_function18[(0, 43, 0, 1)] = 1.0
        pgm_function18[(0, 43, 0, 2)] = 1.0
        pgm_function18[(0, 43, 1, 0)] = 1.0
        pgm_function18[(0, 43, 1, 2)] = 1.0
        pgm_function18[(0, 43, 2, 0)] = 1.0
        pgm_function18[(0, 43, 2, 2)] = 1.0
        pgm_function18[(0, 43, 3, 0)] = 1.0
        pgm_function18[(0, 43, 3, 2)] = 1.0
        pgm_function18[(0, 43, 4, 0)] = 1.0
        pgm_function18[(0, 43, 4, 2)] = 1.0
        pgm_function18[(0, 44, 0, 0)] = 1.0
        pgm_function18[(0, 44, 0, 1)] = 1.0
        pgm_function18[(0, 44, 0, 2)] = 1.0
        pgm_function18[(0, 44, 1, 0)] = 1.0
        pgm_function18[(0, 44, 1, 2)] = 1.0
        pgm_function18[(0, 44, 2, 0)] = 1.0
        pgm_function18[(0, 44, 2, 2)] = 1.0
        pgm_function18[(0, 44, 3, 0)] = 1.0
        pgm_function18[(0, 44, 3, 2)] = 1.0
        pgm_function18[(0, 44, 4, 0)] = 1.0
        pgm_function18[(0, 44, 4, 2)] = 1.0
        pgm_function18[(0, 45, 0, 0)] = 1.0
        pgm_function18[(0, 45, 0, 1)] = 1.0
        pgm_function18[(0, 45, 0, 2)] = 1.0
        pgm_function18[(0, 45, 1, 0)] = 1.0
        pgm_function18[(0, 45, 2, 0)] = 1.0
        pgm_function18[(0, 45, 3, 0)] = 1.0
        pgm_function18[(0, 45, 4, 0)] = 1.0
        pgm_function18[(0, 46, 0, 0)] = 1.0
        pgm_function18[(0, 46, 0, 1)] = 1.0
        pgm_function18[(0, 46, 0, 2)] = 1.0
        pgm_function18[(0, 46, 1, 0)] = 1.0
        pgm_function18[(0, 46, 2, 0)] = 1.0
        pgm_function18[(0, 46, 3, 0)] = 1.0
        pgm_function18[(0, 46, 4, 0)] = 1.0
        pgm_function18[(0, 47, 0, 0)] = 1.0
        pgm_function18[(0, 47, 0, 1)] = 1.0
        pgm_function18[(0, 47, 0, 2)] = 1.0
        pgm_function18[(0, 47, 1, 0)] = 1.0
        pgm_function18[(0, 47, 1, 2)] = 1.0
        pgm_function18[(0, 47, 2, 0)] = 1.0
        pgm_function18[(0, 47, 2, 2)] = 1.0
        pgm_function18[(0, 47, 3, 0)] = 1.0
        pgm_function18[(0, 47, 3, 2)] = 1.0
        pgm_function18[(0, 47, 4, 0)] = 1.0
        pgm_function18[(0, 47, 4, 2)] = 1.0
        pgm_function18[(0, 48, 0, 0)] = 1.0
        pgm_function18[(0, 48, 0, 1)] = 1.0
        pgm_function18[(0, 48, 0, 2)] = 1.0
        pgm_function18[(0, 48, 1, 0)] = 1.0
        pgm_function18[(0, 48, 1, 2)] = 1.0
        pgm_function18[(0, 48, 2, 0)] = 1.0
        pgm_function18[(0, 48, 2, 2)] = 1.0
        pgm_function18[(0, 48, 3, 0)] = 1.0
        pgm_function18[(0, 48, 3, 2)] = 1.0
        pgm_function18[(0, 48, 4, 0)] = 1.0
        pgm_function18[(0, 48, 4, 2)] = 1.0
        pgm_function18[(0, 49, 0, 0)] = 1.0
        pgm_function18[(0, 49, 0, 1)] = 1.0
        pgm_function18[(0, 49, 0, 2)] = 1.0
        pgm_function18[(0, 49, 1, 0)] = 1.0
        pgm_function18[(0, 49, 1, 2)] = 1.0
        pgm_function18[(0, 49, 2, 0)] = 1.0
        pgm_function18[(0, 49, 2, 2)] = 1.0
        pgm_function18[(0, 49, 3, 0)] = 1.0
        pgm_function18[(0, 49, 3, 2)] = 1.0
        pgm_function18[(0, 49, 4, 0)] = 1.0
        pgm_function18[(0, 49, 4, 2)] = 1.0
        pgm_function18[(0, 50, 0, 0)] = 1.0
        pgm_function18[(0, 50, 0, 1)] = 1.0
        pgm_function18[(0, 50, 0, 2)] = 1.0
        pgm_function18[(0, 50, 1, 0)] = 1.0
        pgm_function18[(0, 50, 1, 2)] = 1.0
        pgm_function18[(0, 50, 2, 0)] = 1.0
        pgm_function18[(0, 50, 2, 2)] = 1.0
        pgm_function18[(0, 50, 3, 0)] = 1.0
        pgm_function18[(0, 50, 3, 2)] = 1.0
        pgm_function18[(0, 50, 4, 0)] = 1.0
        pgm_function18[(0, 50, 4, 2)] = 1.0
        pgm_function18[(0, 51, 0, 0)] = 1.0
        pgm_function18[(0, 51, 0, 1)] = 1.0
        pgm_function18[(0, 51, 0, 2)] = 1.0
        pgm_function18[(0, 51, 1, 0)] = 1.0
        pgm_function18[(0, 51, 1, 2)] = 1.0
        pgm_function18[(0, 51, 2, 0)] = 1.0
        pgm_function18[(0, 51, 2, 2)] = 1.0
        pgm_function18[(0, 51, 3, 0)] = 1.0
        pgm_function18[(0, 51, 3, 2)] = 1.0
        pgm_function18[(0, 51, 4, 0)] = 1.0
        pgm_function18[(0, 51, 4, 2)] = 1.0
        pgm_function18[(0, 52, 0, 0)] = 1.0
        pgm_function18[(0, 52, 0, 1)] = 1.0
        pgm_function18[(0, 52, 0, 2)] = 1.0
        pgm_function18[(0, 52, 1, 0)] = 1.0
        pgm_function18[(0, 52, 1, 2)] = 1.0
        pgm_function18[(0, 52, 2, 0)] = 1.0
        pgm_function18[(0, 52, 2, 2)] = 1.0
        pgm_function18[(0, 52, 3, 0)] = 1.0
        pgm_function18[(0, 52, 3, 2)] = 1.0
        pgm_function18[(0, 52, 4, 0)] = 1.0
        pgm_function18[(0, 52, 4, 2)] = 1.0
        pgm_function18[(0, 53, 0, 0)] = 1.0
        pgm_function18[(0, 53, 0, 1)] = 1.0
        pgm_function18[(0, 53, 0, 2)] = 1.0
        pgm_function18[(0, 53, 1, 0)] = 1.0
        pgm_function18[(0, 53, 2, 0)] = 1.0
        pgm_function18[(0, 53, 3, 0)] = 1.0
        pgm_function18[(0, 53, 4, 0)] = 1.0
        pgm_function18[(0, 54, 0, 0)] = 1.0
        pgm_function18[(0, 54, 0, 1)] = 1.0
        pgm_function18[(0, 54, 0, 2)] = 1.0
        pgm_function18[(0, 54, 1, 0)] = 1.0
        pgm_function18[(0, 54, 1, 2)] = 1.0
        pgm_function18[(0, 54, 2, 0)] = 1.0
        pgm_function18[(0, 54, 2, 2)] = 1.0
        pgm_function18[(0, 54, 3, 0)] = 1.0
        pgm_function18[(0, 54, 3, 2)] = 1.0
        pgm_function18[(0, 54, 4, 0)] = 1.0
        pgm_function18[(0, 54, 4, 2)] = 1.0
        pgm_function18[(0, 55, 0, 0)] = 1.0
        pgm_function18[(0, 55, 0, 1)] = 1.0
        pgm_function18[(0, 55, 0, 2)] = 1.0
        pgm_function18[(0, 55, 1, 0)] = 1.0
        pgm_function18[(0, 55, 1, 2)] = 1.0
        pgm_function18[(0, 55, 2, 0)] = 1.0
        pgm_function18[(0, 55, 2, 2)] = 1.0
        pgm_function18[(0, 55, 3, 0)] = 1.0
        pgm_function18[(0, 55, 3, 2)] = 1.0
        pgm_function18[(0, 55, 4, 0)] = 1.0
        pgm_function18[(0, 55, 4, 2)] = 1.0
        pgm_function18[(0, 56, 0, 0)] = 1.0
        pgm_function18[(0, 56, 0, 1)] = 1.0
        pgm_function18[(0, 56, 0, 2)] = 1.0
        pgm_function18[(0, 56, 1, 0)] = 1.0
        pgm_function18[(0, 56, 1, 2)] = 1.0
        pgm_function18[(0, 56, 2, 0)] = 1.0
        pgm_function18[(0, 56, 2, 2)] = 1.0
        pgm_function18[(0, 56, 3, 0)] = 1.0
        pgm_function18[(0, 56, 3, 2)] = 1.0
        pgm_function18[(0, 56, 4, 0)] = 1.0
        pgm_function18[(0, 56, 4, 2)] = 1.0
        pgm_function18[(0, 57, 0, 0)] = 1.0
        pgm_function18[(0, 57, 0, 1)] = 1.0
        pgm_function18[(0, 57, 0, 2)] = 1.0
        pgm_function18[(0, 57, 1, 0)] = 1.0
        pgm_function18[(0, 57, 1, 2)] = 1.0
        pgm_function18[(0, 57, 2, 0)] = 1.0
        pgm_function18[(0, 57, 2, 2)] = 1.0
        pgm_function18[(0, 57, 3, 0)] = 1.0
        pgm_function18[(0, 57, 3, 2)] = 1.0
        pgm_function18[(0, 57, 4, 0)] = 1.0
        pgm_function18[(0, 57, 4, 2)] = 1.0
        pgm_function18[(0, 58, 0, 0)] = 1.0
        pgm_function18[(0, 58, 0, 1)] = 1.0
        pgm_function18[(0, 58, 0, 2)] = 1.0
        pgm_function18[(0, 58, 1, 0)] = 1.0
        pgm_function18[(0, 58, 1, 2)] = 1.0
        pgm_function18[(0, 58, 2, 0)] = 1.0
        pgm_function18[(0, 58, 2, 2)] = 1.0
        pgm_function18[(0, 58, 3, 0)] = 1.0
        pgm_function18[(0, 58, 3, 2)] = 1.0
        pgm_function18[(0, 58, 4, 0)] = 1.0
        pgm_function18[(0, 58, 4, 2)] = 1.0
        pgm_function18[(0, 59, 0, 0)] = 1.0
        pgm_function18[(0, 59, 0, 1)] = 1.0
        pgm_function18[(0, 59, 0, 2)] = 1.0
        pgm_function18[(0, 59, 1, 0)] = 1.0
        pgm_function18[(0, 59, 1, 2)] = 1.0
        pgm_function18[(0, 59, 2, 0)] = 1.0
        pgm_function18[(0, 59, 2, 2)] = 1.0
        pgm_function18[(0, 59, 3, 0)] = 1.0
        pgm_function18[(0, 59, 3, 2)] = 1.0
        pgm_function18[(0, 59, 4, 0)] = 1.0
        pgm_function18[(0, 59, 4, 2)] = 1.0
        pgm_function18[(0, 60, 0, 0)] = 1.0
        pgm_function18[(0, 60, 0, 1)] = 1.0
        pgm_function18[(0, 60, 0, 2)] = 1.0
        pgm_function18[(0, 60, 1, 0)] = 1.0
        pgm_function18[(0, 60, 2, 0)] = 1.0
        pgm_function18[(0, 60, 3, 0)] = 1.0
        pgm_function18[(0, 60, 4, 0)] = 1.0
        pgm_function18[(0, 61, 0, 0)] = 1.0
        pgm_function18[(0, 61, 0, 1)] = 1.0
        pgm_function18[(0, 61, 0, 2)] = 1.0
        pgm_function18[(0, 61, 1, 0)] = 1.0
        pgm_function18[(0, 61, 2, 0)] = 1.0
        pgm_function18[(0, 61, 3, 0)] = 1.0
        pgm_function18[(0, 61, 4, 0)] = 1.0
        pgm_function18[(0, 62, 0, 0)] = 1.0
        pgm_function18[(0, 62, 0, 1)] = 1.0
        pgm_function18[(0, 62, 0, 2)] = 1.0
        pgm_function18[(0, 62, 1, 0)] = 1.0
        pgm_function18[(0, 62, 1, 2)] = 1.0
        pgm_function18[(0, 62, 2, 0)] = 1.0
        pgm_function18[(0, 62, 2, 2)] = 1.0
        pgm_function18[(0, 62, 3, 0)] = 1.0
        pgm_function18[(0, 62, 3, 2)] = 1.0
        pgm_function18[(0, 62, 4, 0)] = 1.0
        pgm_function18[(0, 62, 4, 2)] = 1.0
        pgm_function18[(0, 63, 0, 0)] = 1.0
        pgm_function18[(0, 63, 0, 1)] = 1.0
        pgm_function18[(0, 63, 0, 2)] = 1.0
        pgm_function18[(0, 63, 1, 0)] = 1.0
        pgm_function18[(0, 63, 2, 0)] = 1.0
        pgm_function18[(0, 63, 3, 0)] = 1.0
        pgm_function18[(0, 63, 4, 0)] = 1.0
        pgm_function18[(0, 64, 0, 0)] = 1.0
        pgm_function18[(0, 64, 0, 1)] = 1.0
        pgm_function18[(0, 64, 0, 2)] = 1.0
        pgm_function18[(0, 64, 1, 0)] = 1.0
        pgm_function18[(0, 64, 2, 0)] = 1.0
        pgm_function18[(0, 64, 3, 0)] = 1.0
        pgm_function18[(0, 64, 4, 0)] = 1.0
        pgm_function18[(0, 65, 0, 0)] = 1.0
        pgm_function18[(0, 65, 0, 1)] = 1.0
        pgm_function18[(0, 65, 0, 2)] = 1.0
        pgm_function18[(0, 65, 1, 0)] = 1.0
        pgm_function18[(0, 65, 2, 0)] = 1.0
        pgm_function18[(0, 65, 3, 0)] = 1.0
        pgm_function18[(0, 65, 4, 0)] = 1.0
        pgm_function18[(0, 66, 0, 0)] = 1.0
        pgm_function18[(0, 66, 0, 1)] = 1.0
        pgm_function18[(0, 66, 0, 2)] = 1.0
        pgm_function18[(0, 66, 1, 0)] = 1.0
        pgm_function18[(0, 66, 2, 0)] = 1.0
        pgm_function18[(0, 66, 3, 0)] = 1.0
        pgm_function18[(0, 66, 4, 0)] = 1.0
        pgm_function18[(0, 67, 0, 0)] = 1.0
        pgm_function18[(0, 67, 0, 1)] = 1.0
        pgm_function18[(0, 67, 0, 2)] = 1.0
        pgm_function18[(0, 67, 1, 0)] = 1.0
        pgm_function18[(0, 67, 2, 0)] = 1.0
        pgm_function18[(0, 67, 3, 0)] = 1.0
        pgm_function18[(0, 67, 4, 0)] = 1.0
        pgm_function18[(0, 68, 0, 0)] = 1.0
        pgm_function18[(0, 68, 0, 1)] = 1.0
        pgm_function18[(0, 68, 0, 2)] = 1.0
        pgm_function18[(0, 68, 1, 0)] = 1.0
        pgm_function18[(0, 68, 2, 0)] = 1.0
        pgm_function18[(0, 68, 3, 0)] = 1.0
        pgm_function18[(0, 68, 4, 0)] = 1.0
        pgm_function18[(0, 69, 0, 0)] = 1.0
        pgm_function18[(0, 69, 0, 1)] = 1.0
        pgm_function18[(0, 69, 0, 2)] = 1.0
        pgm_function18[(0, 69, 1, 0)] = 1.0
        pgm_function18[(0, 69, 2, 0)] = 1.0
        pgm_function18[(0, 69, 3, 0)] = 1.0
        pgm_function18[(0, 69, 4, 0)] = 1.0
        pgm_function18[(0, 70, 0, 0)] = 1.0
        pgm_function18[(0, 70, 0, 1)] = 1.0
        pgm_function18[(0, 70, 0, 2)] = 1.0
        pgm_function18[(0, 70, 1, 0)] = 1.0
        pgm_function18[(0, 70, 2, 0)] = 1.0
        pgm_function18[(0, 70, 3, 0)] = 1.0
        pgm_function18[(0, 70, 4, 0)] = 1.0
        pgm_function18[(0, 71, 0, 0)] = 1.0
        pgm_function18[(0, 71, 0, 1)] = 1.0
        pgm_function18[(0, 71, 0, 2)] = 1.0
        pgm_function18[(0, 71, 1, 0)] = 1.0
        pgm_function18[(0, 71, 2, 0)] = 1.0
        pgm_function18[(0, 71, 3, 0)] = 1.0
        pgm_function18[(0, 71, 4, 0)] = 1.0
        pgm_function18[(0, 72, 0, 0)] = 1.0
        pgm_function18[(0, 72, 0, 1)] = 1.0
        pgm_function18[(0, 72, 0, 2)] = 1.0
        pgm_function18[(0, 72, 1, 0)] = 1.0
        pgm_function18[(0, 72, 2, 0)] = 1.0
        pgm_function18[(0, 72, 3, 0)] = 1.0
        pgm_function18[(0, 72, 4, 0)] = 1.0
        pgm_function18[(0, 73, 0, 0)] = 1.0
        pgm_function18[(0, 73, 0, 1)] = 1.0
        pgm_function18[(0, 73, 0, 2)] = 1.0
        pgm_function18[(0, 73, 1, 0)] = 1.0
        pgm_function18[(0, 73, 2, 0)] = 1.0
        pgm_function18[(0, 73, 3, 0)] = 1.0
        pgm_function18[(0, 73, 4, 0)] = 1.0
        pgm_function18[(0, 74, 0, 0)] = 1.0
        pgm_function18[(0, 74, 0, 1)] = 1.0
        pgm_function18[(0, 74, 0, 2)] = 1.0
        pgm_function18[(0, 74, 1, 0)] = 1.0
        pgm_function18[(0, 74, 1, 2)] = 1.0
        pgm_function18[(0, 74, 2, 0)] = 1.0
        pgm_function18[(0, 74, 2, 2)] = 1.0
        pgm_function18[(0, 74, 3, 0)] = 1.0
        pgm_function18[(0, 74, 3, 2)] = 1.0
        pgm_function18[(0, 74, 4, 0)] = 1.0
        pgm_function18[(0, 74, 4, 2)] = 1.0
        pgm_function18[(0, 75, 0, 0)] = 1.0
        pgm_function18[(0, 75, 0, 1)] = 1.0
        pgm_function18[(0, 75, 0, 2)] = 1.0
        pgm_function18[(0, 75, 1, 0)] = 1.0
        pgm_function18[(0, 75, 1, 2)] = 1.0
        pgm_function18[(0, 75, 2, 0)] = 1.0
        pgm_function18[(0, 75, 2, 2)] = 1.0
        pgm_function18[(0, 75, 3, 0)] = 1.0
        pgm_function18[(0, 75, 3, 2)] = 1.0
        pgm_function18[(0, 75, 4, 0)] = 1.0
        pgm_function18[(0, 75, 4, 2)] = 1.0
        pgm_function18[(1, 0, 1, 1)] = 0.999
        pgm_function18[(1, 0, 1, 2)] = 0.999
        pgm_function18[(1, 0, 2, 1)] = 0.999
        pgm_function18[(1, 0, 2, 2)] = 0.999
        pgm_function18[(1, 0, 3, 1)] = 0.999
        pgm_function18[(1, 0, 3, 2)] = 0.999
        pgm_function18[(1, 0, 4, 1)] = 0.999
        pgm_function18[(1, 0, 4, 2)] = 0.999
        pgm_function18[(1, 1, 1, 1)] = 0.9999
        pgm_function18[(1, 1, 1, 2)] = 0.999
        pgm_function18[(1, 1, 2, 1)] = 0.9999
        pgm_function18[(1, 1, 2, 2)] = 0.999
        pgm_function18[(1, 1, 3, 1)] = 0.9999
        pgm_function18[(1, 1, 3, 2)] = 0.999
        pgm_function18[(1, 1, 4, 1)] = 0.9999
        pgm_function18[(1, 1, 4, 2)] = 0.999
        pgm_function18[(1, 2, 1, 1)] = 0.9999
        pgm_function18[(1, 2, 2, 1)] = 0.9999
        pgm_function18[(1, 2, 3, 1)] = 0.9999
        pgm_function18[(1, 2, 4, 1)] = 0.9999
        pgm_function18[(1, 3, 1, 1)] = 0.999
        pgm_function18[(1, 3, 1, 2)] = 0.995
        pgm_function18[(1, 3, 2, 1)] = 0.999
        pgm_function18[(1, 3, 2, 2)] = 0.995
        pgm_function18[(1, 3, 3, 1)] = 0.999
        pgm_function18[(1, 3, 3, 2)] = 0.995
        pgm_function18[(1, 3, 4, 1)] = 0.999
        pgm_function18[(1, 3, 4, 2)] = 0.995
        pgm_function18[(1, 4, 1, 1)] = 0.999
        pgm_function18[(1, 4, 1, 2)] = 0.999
        pgm_function18[(1, 4, 2, 1)] = 0.999
        pgm_function18[(1, 4, 2, 2)] = 0.999
        pgm_function18[(1, 4, 3, 1)] = 0.999
        pgm_function18[(1, 4, 3, 2)] = 0.999
        pgm_function18[(1, 4, 4, 1)] = 0.999
        pgm_function18[(1, 4, 4, 2)] = 0.999
        pgm_function18[(1, 5, 1, 1)] = 0.9999
        pgm_function18[(1, 5, 2, 1)] = 0.9999
        pgm_function18[(1, 5, 3, 1)] = 0.9999
        pgm_function18[(1, 5, 4, 1)] = 0.9999
        pgm_function18[(1, 6, 1, 1)] = 0.9999
        pgm_function18[(1, 6, 2, 1)] = 0.9999
        pgm_function18[(1, 6, 3, 1)] = 0.9999
        pgm_function18[(1, 6, 4, 1)] = 0.9999
        pgm_function18[(1, 7, 1, 1)] = 0.9999
        pgm_function18[(1, 7, 2, 1)] = 0.9999
        pgm_function18[(1, 7, 3, 1)] = 0.9999
        pgm_function18[(1, 7, 4, 1)] = 0.9999
        pgm_function18[(1, 8, 1, 1)] = 0.95
        pgm_function18[(1, 8, 1, 2)] = 0.849
        pgm_function18[(1, 8, 2, 1)] = 0.95
        pgm_function18[(1, 8, 2, 2)] = 0.849
        pgm_function18[(1, 8, 3, 1)] = 0.95
        pgm_function18[(1, 8, 3, 2)] = 0.849
        pgm_function18[(1, 8, 4, 1)] = 0.95
        pgm_function18[(1, 8, 4, 2)] = 0.849
        pgm_function18[(1, 9, 1, 1)] = 0.9999
        pgm_function18[(1, 9, 2, 1)] = 0.9999
        pgm_function18[(1, 9, 3, 1)] = 0.9999
        pgm_function18[(1, 9, 4, 1)] = 0.9999
        pgm_function18[(1, 10, 1, 1)] = 0.999
        pgm_function18[(1, 10, 1, 2)] = 0.995
        pgm_function18[(1, 10, 2, 1)] = 0.999
        pgm_function18[(1, 10, 2, 2)] = 0.995
        pgm_function18[(1, 10, 3, 1)] = 0.999
        pgm_function18[(1, 10, 3, 2)] = 0.995
        pgm_function18[(1, 10, 4, 1)] = 0.999
        pgm_function18[(1, 10, 4, 2)] = 0.995
        pgm_function18[(1, 11, 1, 1)] = 0.999
        pgm_function18[(1, 11, 1, 2)] = 0.999
        pgm_function18[(1, 11, 2, 1)] = 0.999
        pgm_function18[(1, 11, 2, 2)] = 0.999
        pgm_function18[(1, 11, 3, 1)] = 0.999
        pgm_function18[(1, 11, 3, 2)] = 0.999
        pgm_function18[(1, 11, 4, 1)] = 0.999
        pgm_function18[(1, 11, 4, 2)] = 0.999
        pgm_function18[(1, 12, 1, 1)] = 0.999
        pgm_function18[(1, 12, 1, 2)] = 0.999
        pgm_function18[(1, 12, 2, 1)] = 0.999
        pgm_function18[(1, 12, 2, 2)] = 0.999
        pgm_function18[(1, 12, 3, 1)] = 0.999
        pgm_function18[(1, 12, 3, 2)] = 0.999
        pgm_function18[(1, 12, 4, 1)] = 0.999
        pgm_function18[(1, 12, 4, 2)] = 0.999
        pgm_function18[(1, 13, 1, 1)] = 0.9999
        pgm_function18[(1, 13, 2, 1)] = 0.9999
        pgm_function18[(1, 13, 3, 1)] = 0.9999
        pgm_function18[(1, 13, 4, 1)] = 0.9999
        pgm_function18[(1, 14, 1, 1)] = 0.999
        pgm_function18[(1, 14, 1, 2)] = 0.999
        pgm_function18[(1, 14, 2, 1)] = 0.999
        pgm_function18[(1, 14, 2, 2)] = 0.999
        pgm_function18[(1, 14, 3, 1)] = 0.999
        pgm_function18[(1, 14, 3, 2)] = 0.999
        pgm_function18[(1, 14, 4, 1)] = 0.999
        pgm_function18[(1, 14, 4, 2)] = 0.999
        pgm_function18[(1, 15, 1, 1)] = 0.999
        pgm_function18[(1, 15, 1, 2)] = 0.995
        pgm_function18[(1, 15, 2, 1)] = 0.999
        pgm_function18[(1, 15, 2, 2)] = 0.995
        pgm_function18[(1, 15, 3, 1)] = 0.999
        pgm_function18[(1, 15, 3, 2)] = 0.995
        pgm_function18[(1, 15, 4, 1)] = 0.999
        pgm_function18[(1, 15, 4, 2)] = 0.995
        pgm_function18[(1, 16, 1, 1)] = 0.9999
        pgm_function18[(1, 16, 2, 1)] = 0.9999
        pgm_function18[(1, 16, 3, 1)] = 0.9999
        pgm_function18[(1, 16, 4, 1)] = 0.9999
        pgm_function18[(1, 17, 1, 1)] = 0.999
        pgm_function18[(1, 17, 1, 2)] = 0.999
        pgm_function18[(1, 17, 2, 1)] = 0.999
        pgm_function18[(1, 17, 2, 2)] = 0.999
        pgm_function18[(1, 17, 3, 1)] = 0.999
        pgm_function18[(1, 17, 3, 2)] = 0.999
        pgm_function18[(1, 17, 4, 1)] = 0.999
        pgm_function18[(1, 17, 4, 2)] = 0.999
        pgm_function18[(1, 18, 1, 1)] = 0.9999
        pgm_function18[(1, 18, 2, 1)] = 0.9999
        pgm_function18[(1, 18, 3, 1)] = 0.9999
        pgm_function18[(1, 18, 4, 1)] = 0.9999
        pgm_function18[(1, 19, 1, 1)] = 0.9999
        pgm_function18[(1, 19, 2, 1)] = 0.9999
        pgm_function18[(1, 19, 3, 1)] = 0.9999
        pgm_function18[(1, 19, 4, 1)] = 0.9999
        pgm_function18[(1, 20, 1, 1)] = 0.95
        pgm_function18[(1, 20, 1, 2)] = 0.849
        pgm_function18[(1, 20, 2, 1)] = 0.95
        pgm_function18[(1, 20, 2, 2)] = 0.849
        pgm_function18[(1, 20, 3, 1)] = 0.95
        pgm_function18[(1, 20, 3, 2)] = 0.849
        pgm_function18[(1, 20, 4, 1)] = 0.95
        pgm_function18[(1, 20, 4, 2)] = 0.849
        pgm_function18[(1, 22, 1, 1)] = 0.999
        pgm_function18[(1, 22, 1, 2)] = 0.999
        pgm_function18[(1, 22, 2, 1)] = 0.999
        pgm_function18[(1, 22, 2, 2)] = 0.999
        pgm_function18[(1, 22, 3, 1)] = 0.999
        pgm_function18[(1, 22, 3, 2)] = 0.999
        pgm_function18[(1, 22, 4, 1)] = 0.999
        pgm_function18[(1, 22, 4, 2)] = 0.999
        pgm_function18[(1, 23, 1, 1)] = 0.999
        pgm_function18[(1, 23, 1, 2)] = 0.995
        pgm_function18[(1, 23, 2, 1)] = 0.999
        pgm_function18[(1, 23, 2, 2)] = 0.995
        pgm_function18[(1, 23, 3, 1)] = 0.999
        pgm_function18[(1, 23, 3, 2)] = 0.995
        pgm_function18[(1, 23, 4, 1)] = 0.999
        pgm_function18[(1, 23, 4, 2)] = 0.995
        pgm_function18[(1, 24, 1, 1)] = 0.999
        pgm_function18[(1, 24, 1, 2)] = 0.999
        pgm_function18[(1, 24, 2, 1)] = 0.999
        pgm_function18[(1, 24, 2, 2)] = 0.999
        pgm_function18[(1, 24, 3, 1)] = 0.999
        pgm_function18[(1, 24, 3, 2)] = 0.999
        pgm_function18[(1, 24, 4, 1)] = 0.999
        pgm_function18[(1, 24, 4, 2)] = 0.999
        pgm_function18[(1, 25, 1, 1)] = 0.999
        pgm_function18[(1, 25, 1, 2)] = 0.995
        pgm_function18[(1, 25, 2, 1)] = 0.999
        pgm_function18[(1, 25, 2, 2)] = 0.995
        pgm_function18[(1, 25, 3, 1)] = 0.999
        pgm_function18[(1, 25, 3, 2)] = 0.995
        pgm_function18[(1, 25, 4, 1)] = 0.999
        pgm_function18[(1, 25, 4, 2)] = 0.995
        pgm_function18[(1, 26, 1, 1)] = 0.999
        pgm_function18[(1, 26, 1, 2)] = 0.995
        pgm_function18[(1, 26, 2, 1)] = 0.999
        pgm_function18[(1, 26, 2, 2)] = 0.995
        pgm_function18[(1, 26, 3, 1)] = 0.999
        pgm_function18[(1, 26, 3, 2)] = 0.995
        pgm_function18[(1, 26, 4, 1)] = 0.999
        pgm_function18[(1, 26, 4, 2)] = 0.995
        pgm_function18[(1, 27, 1, 1)] = 0.999
        pgm_function18[(1, 27, 1, 2)] = 0.999
        pgm_function18[(1, 27, 2, 1)] = 0.999
        pgm_function18[(1, 27, 2, 2)] = 0.999
        pgm_function18[(1, 27, 3, 1)] = 0.999
        pgm_function18[(1, 27, 3, 2)] = 0.999
        pgm_function18[(1, 27, 4, 1)] = 0.999
        pgm_function18[(1, 27, 4, 2)] = 0.999
        pgm_function18[(1, 28, 1, 1)] = 0.999
        pgm_function18[(1, 28, 1, 2)] = 0.999
        pgm_function18[(1, 28, 2, 1)] = 0.999
        pgm_function18[(1, 28, 2, 2)] = 0.999
        pgm_function18[(1, 28, 3, 1)] = 0.999
        pgm_function18[(1, 28, 3, 2)] = 0.999
        pgm_function18[(1, 28, 4, 1)] = 0.999
        pgm_function18[(1, 28, 4, 2)] = 0.999
        pgm_function18[(1, 29, 1, 1)] = 0.999
        pgm_function18[(1, 29, 1, 2)] = 0.999
        pgm_function18[(1, 29, 2, 1)] = 0.999
        pgm_function18[(1, 29, 2, 2)] = 0.999
        pgm_function18[(1, 29, 3, 1)] = 0.999
        pgm_function18[(1, 29, 3, 2)] = 0.999
        pgm_function18[(1, 29, 4, 1)] = 0.999
        pgm_function18[(1, 29, 4, 2)] = 0.999
        pgm_function18[(1, 30, 1, 1)] = 0.99
        pgm_function18[(1, 30, 1, 2)] = 0.98
        pgm_function18[(1, 30, 2, 1)] = 0.99
        pgm_function18[(1, 30, 2, 2)] = 0.98
        pgm_function18[(1, 30, 3, 1)] = 0.99
        pgm_function18[(1, 30, 3, 2)] = 0.98
        pgm_function18[(1, 30, 4, 1)] = 0.99
        pgm_function18[(1, 30, 4, 2)] = 0.98
        pgm_function18[(1, 31, 1, 1)] = 0.999
        pgm_function18[(1, 31, 1, 2)] = 0.999
        pgm_function18[(1, 31, 2, 1)] = 0.999
        pgm_function18[(1, 31, 2, 2)] = 0.999
        pgm_function18[(1, 31, 3, 1)] = 0.999
        pgm_function18[(1, 31, 3, 2)] = 0.999
        pgm_function18[(1, 31, 4, 1)] = 0.999
        pgm_function18[(1, 31, 4, 2)] = 0.999
        pgm_function18[(1, 32, 1, 1)] = 0.9999
        pgm_function18[(1, 32, 2, 1)] = 0.9999
        pgm_function18[(1, 32, 3, 1)] = 0.9999
        pgm_function18[(1, 32, 4, 1)] = 0.9999
        pgm_function18[(1, 33, 1, 1)] = 0.9999
        pgm_function18[(1, 33, 2, 1)] = 0.9999
        pgm_function18[(1, 33, 3, 1)] = 0.9999
        pgm_function18[(1, 33, 4, 1)] = 0.9999
        pgm_function18[(1, 34, 1, 1)] = 1.0
        pgm_function18[(1, 34, 2, 1)] = 1.0
        pgm_function18[(1, 34, 3, 1)] = 1.0
        pgm_function18[(1, 34, 4, 1)] = 1.0
        pgm_function18[(1, 35, 1, 1)] = 1.0
        pgm_function18[(1, 35, 2, 1)] = 1.0
        pgm_function18[(1, 35, 3, 1)] = 1.0
        pgm_function18[(1, 35, 4, 1)] = 1.0
        pgm_function18[(1, 36, 1, 1)] = 1.0
        pgm_function18[(1, 36, 2, 1)] = 1.0
        pgm_function18[(1, 36, 3, 1)] = 1.0
        pgm_function18[(1, 36, 4, 1)] = 1.0
        pgm_function18[(1, 37, 1, 1)] = 1.0
        pgm_function18[(1, 37, 2, 1)] = 1.0
        pgm_function18[(1, 37, 3, 1)] = 1.0
        pgm_function18[(1, 37, 4, 1)] = 1.0
        pgm_function18[(1, 38, 1, 1)] = 0.9999
        pgm_function18[(1, 38, 2, 1)] = 0.9999
        pgm_function18[(1, 38, 3, 1)] = 0.9999
        pgm_function18[(1, 38, 4, 1)] = 0.9999
        pgm_function18[(1, 39, 1, 1)] = 0.9999
        pgm_function18[(1, 39, 2, 1)] = 0.9999
        pgm_function18[(1, 39, 3, 1)] = 0.9999
        pgm_function18[(1, 39, 4, 1)] = 0.9999
        pgm_function18[(1, 40, 1, 1)] = 0.9999
        pgm_function18[(1, 40, 2, 1)] = 0.9999
        pgm_function18[(1, 40, 3, 1)] = 0.9999
        pgm_function18[(1, 40, 4, 1)] = 0.9999
        pgm_function18[(1, 41, 1, 1)] = 0.9999
        pgm_function18[(1, 41, 2, 1)] = 0.9999
        pgm_function18[(1, 41, 3, 1)] = 0.9999
        pgm_function18[(1, 41, 4, 1)] = 0.9999
        pgm_function18[(1, 42, 1, 1)] = 0.9999
        pgm_function18[(1, 42, 2, 1)] = 0.9999
        pgm_function18[(1, 42, 3, 1)] = 0.9999
        pgm_function18[(1, 42, 4, 1)] = 0.9999
        pgm_function18[(1, 43, 1, 1)] = 0.9999
        pgm_function18[(1, 43, 2, 1)] = 0.9999
        pgm_function18[(1, 43, 3, 1)] = 0.9999
        pgm_function18[(1, 43, 4, 1)] = 0.9999
        pgm_function18[(1, 44, 1, 1)] = 0.9999
        pgm_function18[(1, 44, 2, 1)] = 0.9999
        pgm_function18[(1, 44, 3, 1)] = 0.9999
        pgm_function18[(1, 44, 4, 1)] = 0.9999
        pgm_function18[(1, 45, 1, 1)] = 0.9999
        pgm_function18[(1, 45, 1, 2)] = 0.999
        pgm_function18[(1, 45, 2, 1)] = 0.9999
        pgm_function18[(1, 45, 2, 2)] = 0.999
        pgm_function18[(1, 45, 3, 1)] = 0.9999
        pgm_function18[(1, 45, 3, 2)] = 0.999
        pgm_function18[(1, 45, 4, 1)] = 0.9999
        pgm_function18[(1, 45, 4, 2)] = 0.999
        pgm_function18[(1, 46, 1, 1)] = 0.9999
        pgm_function18[(1, 46, 1, 2)] = 0.999
        pgm_function18[(1, 46, 2, 1)] = 0.9999
        pgm_function18[(1, 46, 2, 2)] = 0.999
        pgm_function18[(1, 46, 3, 1)] = 0.9999
        pgm_function18[(1, 46, 3, 2)] = 0.999
        pgm_function18[(1, 46, 4, 1)] = 0.9999
        pgm_function18[(1, 46, 4, 2)] = 0.999
        pgm_function18[(1, 47, 1, 1)] = 0.9999
        pgm_function18[(1, 47, 2, 1)] = 0.9999
        pgm_function18[(1, 47, 3, 1)] = 0.9999
        pgm_function18[(1, 47, 4, 1)] = 0.9999
        pgm_function18[(1, 48, 1, 1)] = 0.9999
        pgm_function18[(1, 48, 2, 1)] = 0.9999
        pgm_function18[(1, 48, 3, 1)] = 0.9999
        pgm_function18[(1, 48, 4, 1)] = 0.9999
        pgm_function18[(1, 49, 1, 1)] = 0.9999
        pgm_function18[(1, 49, 2, 1)] = 0.9999
        pgm_function18[(1, 49, 3, 1)] = 0.9999
        pgm_function18[(1, 49, 4, 1)] = 0.9999
        pgm_function18[(1, 50, 1, 1)] = 0.9999
        pgm_function18[(1, 50, 2, 1)] = 0.9999
        pgm_function18[(1, 50, 3, 1)] = 0.9999
        pgm_function18[(1, 50, 4, 1)] = 0.9999
        pgm_function18[(1, 51, 1, 1)] = 0.9999
        pgm_function18[(1, 51, 2, 1)] = 0.9999
        pgm_function18[(1, 51, 3, 1)] = 0.9999
        pgm_function18[(1, 51, 4, 1)] = 0.9999
        pgm_function18[(1, 52, 1, 1)] = 0.9999
        pgm_function18[(1, 52, 2, 1)] = 0.9999
        pgm_function18[(1, 52, 3, 1)] = 0.9999
        pgm_function18[(1, 52, 4, 1)] = 0.9999
        pgm_function18[(1, 53, 1, 1)] = 0.999
        pgm_function18[(1, 53, 1, 2)] = 0.999
        pgm_function18[(1, 53, 2, 1)] = 0.999
        pgm_function18[(1, 53, 2, 2)] = 0.999
        pgm_function18[(1, 53, 3, 1)] = 0.999
        pgm_function18[(1, 53, 3, 2)] = 0.999
        pgm_function18[(1, 53, 4, 1)] = 0.999
        pgm_function18[(1, 53, 4, 2)] = 0.999
        pgm_function18[(1, 54, 1, 1)] = 0.9999
        pgm_function18[(1, 54, 2, 1)] = 0.9999
        pgm_function18[(1, 54, 3, 1)] = 0.9999
        pgm_function18[(1, 54, 4, 1)] = 0.9999
        pgm_function18[(1, 55, 1, 1)] = 0.9999
        pgm_function18[(1, 55, 2, 1)] = 0.9999
        pgm_function18[(1, 55, 3, 1)] = 0.9999
        pgm_function18[(1, 55, 4, 1)] = 0.9999
        pgm_function18[(1, 56, 1, 1)] = 0.9999
        pgm_function18[(1, 56, 2, 1)] = 0.9999
        pgm_function18[(1, 56, 3, 1)] = 0.9999
        pgm_function18[(1, 56, 4, 1)] = 0.9999
        pgm_function18[(1, 57, 1, 1)] = 0.9999
        pgm_function18[(1, 57, 2, 1)] = 0.9999
        pgm_function18[(1, 57, 3, 1)] = 0.9999
        pgm_function18[(1, 57, 4, 1)] = 0.9999
        pgm_function18[(1, 58, 1, 1)] = 0.9999
        pgm_function18[(1, 58, 2, 1)] = 0.9999
        pgm_function18[(1, 58, 3, 1)] = 0.9999
        pgm_function18[(1, 58, 4, 1)] = 0.9999
        pgm_function18[(1, 59, 1, 1)] = 0.9999
        pgm_function18[(1, 59, 2, 1)] = 0.9999
        pgm_function18[(1, 59, 3, 1)] = 0.9999
        pgm_function18[(1, 59, 4, 1)] = 0.9999
        pgm_function18[(1, 60, 1, 1)] = 0.999
        pgm_function18[(1, 60, 1, 2)] = 0.999
        pgm_function18[(1, 60, 2, 1)] = 0.999
        pgm_function18[(1, 60, 2, 2)] = 0.999
        pgm_function18[(1, 60, 3, 1)] = 0.999
        pgm_function18[(1, 60, 3, 2)] = 0.999
        pgm_function18[(1, 60, 4, 1)] = 0.999
        pgm_function18[(1, 60, 4, 2)] = 0.999
        pgm_function18[(1, 61, 1, 1)] = 0.999
        pgm_function18[(1, 61, 1, 2)] = 0.999
        pgm_function18[(1, 61, 2, 1)] = 0.999
        pgm_function18[(1, 61, 2, 2)] = 0.999
        pgm_function18[(1, 61, 3, 1)] = 0.999
        pgm_function18[(1, 61, 3, 2)] = 0.999
        pgm_function18[(1, 61, 4, 1)] = 0.999
        pgm_function18[(1, 61, 4, 2)] = 0.999
        pgm_function18[(1, 62, 1, 1)] = 0.9999
        pgm_function18[(1, 62, 2, 1)] = 0.9999
        pgm_function18[(1, 62, 3, 1)] = 0.9999
        pgm_function18[(1, 62, 4, 1)] = 0.9999
        pgm_function18[(1, 63, 1, 1)] = 0.999
        pgm_function18[(1, 63, 1, 2)] = 0.999
        pgm_function18[(1, 63, 2, 1)] = 0.999
        pgm_function18[(1, 63, 2, 2)] = 0.999
        pgm_function18[(1, 63, 3, 1)] = 0.999
        pgm_function18[(1, 63, 3, 2)] = 0.999
        pgm_function18[(1, 63, 4, 1)] = 0.999
        pgm_function18[(1, 63, 4, 2)] = 0.999
        pgm_function18[(1, 64, 1, 1)] = 0.999
        pgm_function18[(1, 64, 1, 2)] = 0.999
        pgm_function18[(1, 64, 2, 1)] = 0.999
        pgm_function18[(1, 64, 2, 2)] = 0.999
        pgm_function18[(1, 64, 3, 1)] = 0.999
        pgm_function18[(1, 64, 3, 2)] = 0.999
        pgm_function18[(1, 64, 4, 1)] = 0.999
        pgm_function18[(1, 64, 4, 2)] = 0.999
        pgm_function18[(1, 65, 1, 1)] = 0.999
        pgm_function18[(1, 65, 1, 2)] = 0.999
        pgm_function18[(1, 65, 2, 1)] = 0.999
        pgm_function18[(1, 65, 2, 2)] = 0.999
        pgm_function18[(1, 65, 3, 1)] = 0.999
        pgm_function18[(1, 65, 3, 2)] = 0.999
        pgm_function18[(1, 65, 4, 1)] = 0.999
        pgm_function18[(1, 65, 4, 2)] = 0.999
        pgm_function18[(1, 66, 1, 1)] = 0.999
        pgm_function18[(1, 66, 1, 2)] = 0.995
        pgm_function18[(1, 66, 2, 1)] = 0.999
        pgm_function18[(1, 66, 2, 2)] = 0.995
        pgm_function18[(1, 66, 3, 1)] = 0.999
        pgm_function18[(1, 66, 3, 2)] = 0.995
        pgm_function18[(1, 66, 4, 1)] = 0.999
        pgm_function18[(1, 66, 4, 2)] = 0.995
        pgm_function18[(1, 67, 1, 1)] = 0.999
        pgm_function18[(1, 67, 1, 2)] = 0.999
        pgm_function18[(1, 67, 2, 1)] = 0.999
        pgm_function18[(1, 67, 2, 2)] = 0.999
        pgm_function18[(1, 67, 3, 1)] = 0.999
        pgm_function18[(1, 67, 3, 2)] = 0.999
        pgm_function18[(1, 67, 4, 1)] = 0.999
        pgm_function18[(1, 67, 4, 2)] = 0.999
        pgm_function18[(1, 68, 1, 1)] = 0.999
        pgm_function18[(1, 68, 1, 2)] = 0.999
        pgm_function18[(1, 68, 2, 1)] = 0.999
        pgm_function18[(1, 68, 2, 2)] = 0.999
        pgm_function18[(1, 68, 3, 1)] = 0.999
        pgm_function18[(1, 68, 3, 2)] = 0.999
        pgm_function18[(1, 68, 4, 1)] = 0.999
        pgm_function18[(1, 68, 4, 2)] = 0.999
        pgm_function18[(1, 69, 1, 1)] = 0.999
        pgm_function18[(1, 69, 1, 2)] = 0.995
        pgm_function18[(1, 69, 2, 1)] = 0.999
        pgm_function18[(1, 69, 2, 2)] = 0.995
        pgm_function18[(1, 69, 3, 1)] = 0.999
        pgm_function18[(1, 69, 3, 2)] = 0.995
        pgm_function18[(1, 69, 4, 1)] = 0.999
        pgm_function18[(1, 69, 4, 2)] = 0.995
        pgm_function18[(1, 70, 1, 1)] = 0.999
        pgm_function18[(1, 70, 1, 2)] = 0.999
        pgm_function18[(1, 70, 2, 1)] = 0.999
        pgm_function18[(1, 70, 2, 2)] = 0.999
        pgm_function18[(1, 70, 3, 1)] = 0.999
        pgm_function18[(1, 70, 3, 2)] = 0.999
        pgm_function18[(1, 70, 4, 1)] = 0.999
        pgm_function18[(1, 70, 4, 2)] = 0.999
        pgm_function18[(1, 71, 1, 1)] = 0.999
        pgm_function18[(1, 71, 1, 2)] = 0.999
        pgm_function18[(1, 71, 2, 1)] = 0.999
        pgm_function18[(1, 71, 2, 2)] = 0.999
        pgm_function18[(1, 71, 3, 1)] = 0.999
        pgm_function18[(1, 71, 3, 2)] = 0.999
        pgm_function18[(1, 71, 4, 1)] = 0.999
        pgm_function18[(1, 71, 4, 2)] = 0.999
        pgm_function18[(1, 72, 1, 1)] = 0.999
        pgm_function18[(1, 72, 1, 2)] = 0.999
        pgm_function18[(1, 72, 2, 1)] = 0.999
        pgm_function18[(1, 72, 2, 2)] = 0.999
        pgm_function18[(1, 72, 3, 1)] = 0.999
        pgm_function18[(1, 72, 3, 2)] = 0.999
        pgm_function18[(1, 72, 4, 1)] = 0.999
        pgm_function18[(1, 72, 4, 2)] = 0.999
        pgm_function18[(1, 74, 1, 1)] = 0.9999
        pgm_function18[(1, 74, 2, 1)] = 0.9999
        pgm_function18[(1, 74, 3, 1)] = 0.9999
        pgm_function18[(1, 74, 4, 1)] = 0.9999
        pgm_function18[(1, 75, 1, 1)] = 0.9999
        pgm_function18[(1, 75, 2, 1)] = 0.9999
        pgm_function18[(1, 75, 3, 1)] = 0.9999
        pgm_function18[(1, 75, 4, 1)] = 0.9999
        pgm_function18[(2, 0, 1, 1)] = 0.001
        pgm_function18[(2, 0, 1, 2)] = 0.001
        pgm_function18[(2, 0, 2, 1)] = 0.001
        pgm_function18[(2, 0, 2, 2)] = 0.001
        pgm_function18[(2, 0, 3, 1)] = 0.001
        pgm_function18[(2, 0, 3, 2)] = 0.001
        pgm_function18[(2, 0, 4, 1)] = 0.001
        pgm_function18[(2, 0, 4, 2)] = 0.001
        pgm_function18[(2, 1, 1, 1)] = 0.0001
        pgm_function18[(2, 1, 1, 2)] = 0.001
        pgm_function18[(2, 1, 2, 1)] = 0.0001
        pgm_function18[(2, 1, 2, 2)] = 0.001
        pgm_function18[(2, 1, 3, 1)] = 0.0001
        pgm_function18[(2, 1, 3, 2)] = 0.001
        pgm_function18[(2, 1, 4, 1)] = 0.0001
        pgm_function18[(2, 1, 4, 2)] = 0.001
        pgm_function18[(2, 2, 1, 1)] = 0.0001
        pgm_function18[(2, 2, 2, 1)] = 0.0001
        pgm_function18[(2, 2, 3, 1)] = 0.0001
        pgm_function18[(2, 2, 4, 1)] = 0.0001
        pgm_function18[(2, 3, 1, 1)] = 0.001
        pgm_function18[(2, 3, 1, 2)] = 0.005
        pgm_function18[(2, 3, 2, 1)] = 0.001
        pgm_function18[(2, 3, 2, 2)] = 0.005
        pgm_function18[(2, 3, 3, 1)] = 0.001
        pgm_function18[(2, 3, 3, 2)] = 0.005
        pgm_function18[(2, 3, 4, 1)] = 0.001
        pgm_function18[(2, 3, 4, 2)] = 0.005
        pgm_function18[(2, 4, 1, 1)] = 0.001
        pgm_function18[(2, 4, 1, 2)] = 0.001
        pgm_function18[(2, 4, 2, 1)] = 0.001
        pgm_function18[(2, 4, 2, 2)] = 0.001
        pgm_function18[(2, 4, 3, 1)] = 0.001
        pgm_function18[(2, 4, 3, 2)] = 0.001
        pgm_function18[(2, 4, 4, 1)] = 0.001
        pgm_function18[(2, 4, 4, 2)] = 0.001
        pgm_function18[(2, 5, 1, 1)] = 0.0001
        pgm_function18[(2, 5, 2, 1)] = 0.0001
        pgm_function18[(2, 5, 3, 1)] = 0.0001
        pgm_function18[(2, 5, 4, 1)] = 0.0001
        pgm_function18[(2, 6, 1, 1)] = 0.0001
        pgm_function18[(2, 6, 2, 1)] = 0.0001
        pgm_function18[(2, 6, 3, 1)] = 0.0001
        pgm_function18[(2, 6, 4, 1)] = 0.0001
        pgm_function18[(2, 7, 1, 1)] = 0.0001
        pgm_function18[(2, 7, 2, 1)] = 0.0001
        pgm_function18[(2, 7, 3, 1)] = 0.0001
        pgm_function18[(2, 7, 4, 1)] = 0.0001
        pgm_function18[(2, 8, 1, 1)] = 0.05
        pgm_function18[(2, 8, 1, 2)] = 0.15
        pgm_function18[(2, 8, 2, 1)] = 0.05
        pgm_function18[(2, 8, 2, 2)] = 0.15
        pgm_function18[(2, 8, 3, 1)] = 0.05
        pgm_function18[(2, 8, 3, 2)] = 0.15
        pgm_function18[(2, 8, 4, 1)] = 0.05
        pgm_function18[(2, 8, 4, 2)] = 0.15
        pgm_function18[(2, 9, 1, 1)] = 0.0001
        pgm_function18[(2, 9, 2, 1)] = 0.0001
        pgm_function18[(2, 9, 3, 1)] = 0.0001
        pgm_function18[(2, 9, 4, 1)] = 0.0001
        pgm_function18[(2, 10, 1, 1)] = 0.001
        pgm_function18[(2, 10, 1, 2)] = 0.005
        pgm_function18[(2, 10, 2, 1)] = 0.001
        pgm_function18[(2, 10, 2, 2)] = 0.005
        pgm_function18[(2, 10, 3, 1)] = 0.001
        pgm_function18[(2, 10, 3, 2)] = 0.005
        pgm_function18[(2, 10, 4, 1)] = 0.001
        pgm_function18[(2, 10, 4, 2)] = 0.005
        pgm_function18[(2, 11, 1, 1)] = 0.001
        pgm_function18[(2, 11, 1, 2)] = 0.001
        pgm_function18[(2, 11, 2, 1)] = 0.001
        pgm_function18[(2, 11, 2, 2)] = 0.001
        pgm_function18[(2, 11, 3, 1)] = 0.001
        pgm_function18[(2, 11, 3, 2)] = 0.001
        pgm_function18[(2, 11, 4, 1)] = 0.001
        pgm_function18[(2, 11, 4, 2)] = 0.001
        pgm_function18[(2, 12, 1, 1)] = 0.001
        pgm_function18[(2, 12, 1, 2)] = 0.001
        pgm_function18[(2, 12, 2, 1)] = 0.001
        pgm_function18[(2, 12, 2, 2)] = 0.001
        pgm_function18[(2, 12, 3, 1)] = 0.001
        pgm_function18[(2, 12, 3, 2)] = 0.001
        pgm_function18[(2, 12, 4, 1)] = 0.001
        pgm_function18[(2, 12, 4, 2)] = 0.001
        pgm_function18[(2, 13, 1, 1)] = 0.0001
        pgm_function18[(2, 13, 2, 1)] = 0.0001
        pgm_function18[(2, 13, 3, 1)] = 0.0001
        pgm_function18[(2, 13, 4, 1)] = 0.0001
        pgm_function18[(2, 14, 1, 1)] = 0.001
        pgm_function18[(2, 14, 1, 2)] = 0.001
        pgm_function18[(2, 14, 2, 1)] = 0.001
        pgm_function18[(2, 14, 2, 2)] = 0.001
        pgm_function18[(2, 14, 3, 1)] = 0.001
        pgm_function18[(2, 14, 3, 2)] = 0.001
        pgm_function18[(2, 14, 4, 1)] = 0.001
        pgm_function18[(2, 14, 4, 2)] = 0.001
        pgm_function18[(2, 15, 1, 1)] = 0.001
        pgm_function18[(2, 15, 1, 2)] = 0.005
        pgm_function18[(2, 15, 2, 1)] = 0.001
        pgm_function18[(2, 15, 2, 2)] = 0.005
        pgm_function18[(2, 15, 3, 1)] = 0.001
        pgm_function18[(2, 15, 3, 2)] = 0.005
        pgm_function18[(2, 15, 4, 1)] = 0.001
        pgm_function18[(2, 15, 4, 2)] = 0.005
        pgm_function18[(2, 16, 1, 1)] = 0.0001
        pgm_function18[(2, 16, 2, 1)] = 0.0001
        pgm_function18[(2, 16, 3, 1)] = 0.0001
        pgm_function18[(2, 16, 4, 1)] = 0.0001
        pgm_function18[(2, 17, 1, 1)] = 0.001
        pgm_function18[(2, 17, 1, 2)] = 0.001
        pgm_function18[(2, 17, 2, 1)] = 0.001
        pgm_function18[(2, 17, 2, 2)] = 0.001
        pgm_function18[(2, 17, 3, 1)] = 0.001
        pgm_function18[(2, 17, 3, 2)] = 0.001
        pgm_function18[(2, 17, 4, 1)] = 0.001
        pgm_function18[(2, 17, 4, 2)] = 0.001
        pgm_function18[(2, 18, 1, 1)] = 0.0001
        pgm_function18[(2, 18, 2, 1)] = 0.0001
        pgm_function18[(2, 18, 3, 1)] = 0.0001
        pgm_function18[(2, 18, 4, 1)] = 0.0001
        pgm_function18[(2, 19, 1, 1)] = 0.0001
        pgm_function18[(2, 19, 2, 1)] = 0.0001
        pgm_function18[(2, 19, 3, 1)] = 0.0001
        pgm_function18[(2, 19, 4, 1)] = 0.0001
        pgm_function18[(2, 20, 1, 1)] = 0.05
        pgm_function18[(2, 20, 1, 2)] = 0.15
        pgm_function18[(2, 20, 2, 1)] = 0.05
        pgm_function18[(2, 20, 2, 2)] = 0.15
        pgm_function18[(2, 20, 3, 1)] = 0.05
        pgm_function18[(2, 20, 3, 2)] = 0.15
        pgm_function18[(2, 20, 4, 1)] = 0.05
        pgm_function18[(2, 20, 4, 2)] = 0.15
        pgm_function18[(2, 21, 1, 1)] = 0.8
        pgm_function18[(2, 21, 1, 2)] = 0.4
        pgm_function18[(2, 21, 2, 1)] = 0.8
        pgm_function18[(2, 21, 2, 2)] = 0.4
        pgm_function18[(2, 21, 3, 1)] = 0.8
        pgm_function18[(2, 21, 3, 2)] = 0.4
        pgm_function18[(2, 21, 4, 1)] = 0.8
        pgm_function18[(2, 21, 4, 2)] = 0.4
        pgm_function18[(2, 22, 1, 1)] = 0.001
        pgm_function18[(2, 22, 1, 2)] = 0.001
        pgm_function18[(2, 22, 2, 1)] = 0.001
        pgm_function18[(2, 22, 2, 2)] = 0.001
        pgm_function18[(2, 22, 3, 1)] = 0.001
        pgm_function18[(2, 22, 3, 2)] = 0.001
        pgm_function18[(2, 22, 4, 1)] = 0.001
        pgm_function18[(2, 22, 4, 2)] = 0.001
        pgm_function18[(2, 23, 1, 1)] = 0.001
        pgm_function18[(2, 23, 1, 2)] = 0.005
        pgm_function18[(2, 23, 2, 1)] = 0.001
        pgm_function18[(2, 23, 2, 2)] = 0.005
        pgm_function18[(2, 23, 3, 1)] = 0.001
        pgm_function18[(2, 23, 3, 2)] = 0.005
        pgm_function18[(2, 23, 4, 1)] = 0.001
        pgm_function18[(2, 23, 4, 2)] = 0.005
        pgm_function18[(2, 24, 1, 1)] = 0.001
        pgm_function18[(2, 24, 1, 2)] = 0.001
        pgm_function18[(2, 24, 2, 1)] = 0.001
        pgm_function18[(2, 24, 2, 2)] = 0.001
        pgm_function18[(2, 24, 3, 1)] = 0.001
        pgm_function18[(2, 24, 3, 2)] = 0.001
        pgm_function18[(2, 24, 4, 1)] = 0.001
        pgm_function18[(2, 24, 4, 2)] = 0.001
        pgm_function18[(2, 25, 1, 1)] = 0.001
        pgm_function18[(2, 25, 1, 2)] = 0.005
        pgm_function18[(2, 25, 2, 1)] = 0.001
        pgm_function18[(2, 25, 2, 2)] = 0.005
        pgm_function18[(2, 25, 3, 1)] = 0.001
        pgm_function18[(2, 25, 3, 2)] = 0.005
        pgm_function18[(2, 25, 4, 1)] = 0.001
        pgm_function18[(2, 25, 4, 2)] = 0.005
        pgm_function18[(2, 26, 1, 1)] = 0.001
        pgm_function18[(2, 26, 1, 2)] = 0.005
        pgm_function18[(2, 26, 2, 1)] = 0.001
        pgm_function18[(2, 26, 2, 2)] = 0.005
        pgm_function18[(2, 26, 3, 1)] = 0.001
        pgm_function18[(2, 26, 3, 2)] = 0.005
        pgm_function18[(2, 26, 4, 1)] = 0.001
        pgm_function18[(2, 26, 4, 2)] = 0.005
        pgm_function18[(2, 27, 1, 1)] = 0.001
        pgm_function18[(2, 27, 1, 2)] = 0.001
        pgm_function18[(2, 27, 2, 1)] = 0.001
        pgm_function18[(2, 27, 2, 2)] = 0.001
        pgm_function18[(2, 27, 3, 1)] = 0.001
        pgm_function18[(2, 27, 3, 2)] = 0.001
        pgm_function18[(2, 27, 4, 1)] = 0.001
        pgm_function18[(2, 27, 4, 2)] = 0.001
        pgm_function18[(2, 28, 1, 1)] = 0.001
        pgm_function18[(2, 28, 1, 2)] = 0.001
        pgm_function18[(2, 28, 2, 1)] = 0.001
        pgm_function18[(2, 28, 2, 2)] = 0.001
        pgm_function18[(2, 28, 3, 1)] = 0.001
        pgm_function18[(2, 28, 3, 2)] = 0.001
        pgm_function18[(2, 28, 4, 1)] = 0.001
        pgm_function18[(2, 28, 4, 2)] = 0.001
        pgm_function18[(2, 29, 1, 1)] = 0.001
        pgm_function18[(2, 29, 1, 2)] = 0.001
        pgm_function18[(2, 29, 2, 1)] = 0.001
        pgm_function18[(2, 29, 2, 2)] = 0.001
        pgm_function18[(2, 29, 3, 1)] = 0.001
        pgm_function18[(2, 29, 3, 2)] = 0.001
        pgm_function18[(2, 29, 4, 1)] = 0.001
        pgm_function18[(2, 29, 4, 2)] = 0.001
        pgm_function18[(2, 30, 1, 1)] = 0.01
        pgm_function18[(2, 30, 1, 2)] = 0.02
        pgm_function18[(2, 30, 2, 1)] = 0.01
        pgm_function18[(2, 30, 2, 2)] = 0.02
        pgm_function18[(2, 30, 3, 1)] = 0.01
        pgm_function18[(2, 30, 3, 2)] = 0.02
        pgm_function18[(2, 30, 4, 1)] = 0.01
        pgm_function18[(2, 30, 4, 2)] = 0.02
        pgm_function18[(2, 31, 1, 1)] = 0.001
        pgm_function18[(2, 31, 1, 2)] = 0.001
        pgm_function18[(2, 31, 2, 1)] = 0.001
        pgm_function18[(2, 31, 2, 2)] = 0.001
        pgm_function18[(2, 31, 3, 1)] = 0.001
        pgm_function18[(2, 31, 3, 2)] = 0.001
        pgm_function18[(2, 31, 4, 1)] = 0.001
        pgm_function18[(2, 31, 4, 2)] = 0.001
        pgm_function18[(2, 32, 1, 1)] = 0.0001
        pgm_function18[(2, 32, 2, 1)] = 0.0001
        pgm_function18[(2, 32, 3, 1)] = 0.0001
        pgm_function18[(2, 32, 4, 1)] = 0.0001
        pgm_function18[(2, 33, 1, 1)] = 0.0001
        pgm_function18[(2, 33, 2, 1)] = 0.0001
        pgm_function18[(2, 33, 3, 1)] = 0.0001
        pgm_function18[(2, 33, 4, 1)] = 0.0001
        pgm_function18[(2, 38, 1, 1)] = 0.0001
        pgm_function18[(2, 38, 2, 1)] = 0.0001
        pgm_function18[(2, 38, 3, 1)] = 0.0001
        pgm_function18[(2, 38, 4, 1)] = 0.0001
        pgm_function18[(2, 39, 1, 1)] = 0.0001
        pgm_function18[(2, 39, 2, 1)] = 0.0001
        pgm_function18[(2, 39, 3, 1)] = 0.0001
        pgm_function18[(2, 39, 4, 1)] = 0.0001
        pgm_function18[(2, 40, 1, 1)] = 0.0001
        pgm_function18[(2, 40, 2, 1)] = 0.0001
        pgm_function18[(2, 40, 3, 1)] = 0.0001
        pgm_function18[(2, 40, 4, 1)] = 0.0001
        pgm_function18[(2, 41, 1, 1)] = 0.0001
        pgm_function18[(2, 41, 2, 1)] = 0.0001
        pgm_function18[(2, 41, 3, 1)] = 0.0001
        pgm_function18[(2, 41, 4, 1)] = 0.0001
        pgm_function18[(2, 42, 1, 1)] = 0.0001
        pgm_function18[(2, 42, 2, 1)] = 0.0001
        pgm_function18[(2, 42, 3, 1)] = 0.0001
        pgm_function18[(2, 42, 4, 1)] = 0.0001
        pgm_function18[(2, 43, 1, 1)] = 0.0001
        pgm_function18[(2, 43, 2, 1)] = 0.0001
        pgm_function18[(2, 43, 3, 1)] = 0.0001
        pgm_function18[(2, 43, 4, 1)] = 0.0001
        pgm_function18[(2, 44, 1, 1)] = 0.0001
        pgm_function18[(2, 44, 2, 1)] = 0.0001
        pgm_function18[(2, 44, 3, 1)] = 0.0001
        pgm_function18[(2, 44, 4, 1)] = 0.0001
        pgm_function18[(2, 45, 1, 1)] = 0.0001
        pgm_function18[(2, 45, 1, 2)] = 0.001
        pgm_function18[(2, 45, 2, 1)] = 0.0001
        pgm_function18[(2, 45, 2, 2)] = 0.001
        pgm_function18[(2, 45, 3, 1)] = 0.0001
        pgm_function18[(2, 45, 3, 2)] = 0.001
        pgm_function18[(2, 45, 4, 1)] = 0.0001
        pgm_function18[(2, 45, 4, 2)] = 0.001
        pgm_function18[(2, 46, 1, 1)] = 0.0001
        pgm_function18[(2, 46, 1, 2)] = 0.001
        pgm_function18[(2, 46, 2, 1)] = 0.0001
        pgm_function18[(2, 46, 2, 2)] = 0.001
        pgm_function18[(2, 46, 3, 1)] = 0.0001
        pgm_function18[(2, 46, 3, 2)] = 0.001
        pgm_function18[(2, 46, 4, 1)] = 0.0001
        pgm_function18[(2, 46, 4, 2)] = 0.001
        pgm_function18[(2, 47, 1, 1)] = 0.0001
        pgm_function18[(2, 47, 2, 1)] = 0.0001
        pgm_function18[(2, 47, 3, 1)] = 0.0001
        pgm_function18[(2, 47, 4, 1)] = 0.0001
        pgm_function18[(2, 48, 1, 1)] = 0.0001
        pgm_function18[(2, 48, 2, 1)] = 0.0001
        pgm_function18[(2, 48, 3, 1)] = 0.0001
        pgm_function18[(2, 48, 4, 1)] = 0.0001
        pgm_function18[(2, 49, 1, 1)] = 0.0001
        pgm_function18[(2, 49, 2, 1)] = 0.0001
        pgm_function18[(2, 49, 3, 1)] = 0.0001
        pgm_function18[(2, 49, 4, 1)] = 0.0001
        pgm_function18[(2, 50, 1, 1)] = 0.0001
        pgm_function18[(2, 50, 2, 1)] = 0.0001
        pgm_function18[(2, 50, 3, 1)] = 0.0001
        pgm_function18[(2, 50, 4, 1)] = 0.0001
        pgm_function18[(2, 51, 1, 1)] = 0.0001
        pgm_function18[(2, 51, 2, 1)] = 0.0001
        pgm_function18[(2, 51, 3, 1)] = 0.0001
        pgm_function18[(2, 51, 4, 1)] = 0.0001
        pgm_function18[(2, 52, 1, 1)] = 0.0001
        pgm_function18[(2, 52, 2, 1)] = 0.0001
        pgm_function18[(2, 52, 3, 1)] = 0.0001
        pgm_function18[(2, 52, 4, 1)] = 0.0001
        pgm_function18[(2, 53, 1, 1)] = 0.001
        pgm_function18[(2, 53, 1, 2)] = 0.001
        pgm_function18[(2, 53, 2, 1)] = 0.001
        pgm_function18[(2, 53, 2, 2)] = 0.001
        pgm_function18[(2, 53, 3, 1)] = 0.001
        pgm_function18[(2, 53, 3, 2)] = 0.001
        pgm_function18[(2, 53, 4, 1)] = 0.001
        pgm_function18[(2, 53, 4, 2)] = 0.001
        pgm_function18[(2, 54, 1, 1)] = 0.0001
        pgm_function18[(2, 54, 2, 1)] = 0.0001
        pgm_function18[(2, 54, 3, 1)] = 0.0001
        pgm_function18[(2, 54, 4, 1)] = 0.0001
        pgm_function18[(2, 55, 1, 1)] = 0.0001
        pgm_function18[(2, 55, 2, 1)] = 0.0001
        pgm_function18[(2, 55, 3, 1)] = 0.0001
        pgm_function18[(2, 55, 4, 1)] = 0.0001
        pgm_function18[(2, 56, 1, 1)] = 0.0001
        pgm_function18[(2, 56, 2, 1)] = 0.0001
        pgm_function18[(2, 56, 3, 1)] = 0.0001
        pgm_function18[(2, 56, 4, 1)] = 0.0001
        pgm_function18[(2, 57, 1, 1)] = 0.0001
        pgm_function18[(2, 57, 2, 1)] = 0.0001
        pgm_function18[(2, 57, 3, 1)] = 0.0001
        pgm_function18[(2, 57, 4, 1)] = 0.0001
        pgm_function18[(2, 58, 1, 1)] = 0.0001
        pgm_function18[(2, 58, 2, 1)] = 0.0001
        pgm_function18[(2, 58, 3, 1)] = 0.0001
        pgm_function18[(2, 58, 4, 1)] = 0.0001
        pgm_function18[(2, 59, 1, 1)] = 0.0001
        pgm_function18[(2, 59, 2, 1)] = 0.0001
        pgm_function18[(2, 59, 3, 1)] = 0.0001
        pgm_function18[(2, 59, 4, 1)] = 0.0001
        pgm_function18[(2, 60, 1, 1)] = 0.001
        pgm_function18[(2, 60, 1, 2)] = 0.001
        pgm_function18[(2, 60, 2, 1)] = 0.001
        pgm_function18[(2, 60, 2, 2)] = 0.001
        pgm_function18[(2, 60, 3, 1)] = 0.001
        pgm_function18[(2, 60, 3, 2)] = 0.001
        pgm_function18[(2, 60, 4, 1)] = 0.001
        pgm_function18[(2, 60, 4, 2)] = 0.001
        pgm_function18[(2, 61, 1, 1)] = 0.001
        pgm_function18[(2, 61, 1, 2)] = 0.001
        pgm_function18[(2, 61, 2, 1)] = 0.001
        pgm_function18[(2, 61, 2, 2)] = 0.001
        pgm_function18[(2, 61, 3, 1)] = 0.001
        pgm_function18[(2, 61, 3, 2)] = 0.001
        pgm_function18[(2, 61, 4, 1)] = 0.001
        pgm_function18[(2, 61, 4, 2)] = 0.001
        pgm_function18[(2, 62, 1, 1)] = 0.0001
        pgm_function18[(2, 62, 2, 1)] = 0.0001
        pgm_function18[(2, 62, 3, 1)] = 0.0001
        pgm_function18[(2, 62, 4, 1)] = 0.0001
        pgm_function18[(2, 63, 1, 1)] = 0.001
        pgm_function18[(2, 63, 1, 2)] = 0.001
        pgm_function18[(2, 63, 2, 1)] = 0.001
        pgm_function18[(2, 63, 2, 2)] = 0.001
        pgm_function18[(2, 63, 3, 1)] = 0.001
        pgm_function18[(2, 63, 3, 2)] = 0.001
        pgm_function18[(2, 63, 4, 1)] = 0.001
        pgm_function18[(2, 63, 4, 2)] = 0.001
        pgm_function18[(2, 64, 1, 1)] = 0.001
        pgm_function18[(2, 64, 1, 2)] = 0.001
        pgm_function18[(2, 64, 2, 1)] = 0.001
        pgm_function18[(2, 64, 2, 2)] = 0.001
        pgm_function18[(2, 64, 3, 1)] = 0.001
        pgm_function18[(2, 64, 3, 2)] = 0.001
        pgm_function18[(2, 64, 4, 1)] = 0.001
        pgm_function18[(2, 64, 4, 2)] = 0.001
        pgm_function18[(2, 65, 1, 1)] = 0.001
        pgm_function18[(2, 65, 1, 2)] = 0.001
        pgm_function18[(2, 65, 2, 1)] = 0.001
        pgm_function18[(2, 65, 2, 2)] = 0.001
        pgm_function18[(2, 65, 3, 1)] = 0.001
        pgm_function18[(2, 65, 3, 2)] = 0.001
        pgm_function18[(2, 65, 4, 1)] = 0.001
        pgm_function18[(2, 65, 4, 2)] = 0.001
        pgm_function18[(2, 66, 1, 1)] = 0.001
        pgm_function18[(2, 66, 1, 2)] = 0.005
        pgm_function18[(2, 66, 2, 1)] = 0.001
        pgm_function18[(2, 66, 2, 2)] = 0.005
        pgm_function18[(2, 66, 3, 1)] = 0.001
        pgm_function18[(2, 66, 3, 2)] = 0.005
        pgm_function18[(2, 66, 4, 1)] = 0.001
        pgm_function18[(2, 66, 4, 2)] = 0.005
        pgm_function18[(2, 67, 1, 1)] = 0.001
        pgm_function18[(2, 67, 1, 2)] = 0.001
        pgm_function18[(2, 67, 2, 1)] = 0.001
        pgm_function18[(2, 67, 2, 2)] = 0.001
        pgm_function18[(2, 67, 3, 1)] = 0.001
        pgm_function18[(2, 67, 3, 2)] = 0.001
        pgm_function18[(2, 67, 4, 1)] = 0.001
        pgm_function18[(2, 67, 4, 2)] = 0.001
        pgm_function18[(2, 68, 1, 1)] = 0.001
        pgm_function18[(2, 68, 1, 2)] = 0.001
        pgm_function18[(2, 68, 2, 1)] = 0.001
        pgm_function18[(2, 68, 2, 2)] = 0.001
        pgm_function18[(2, 68, 3, 1)] = 0.001
        pgm_function18[(2, 68, 3, 2)] = 0.001
        pgm_function18[(2, 68, 4, 1)] = 0.001
        pgm_function18[(2, 68, 4, 2)] = 0.001
        pgm_function18[(2, 69, 1, 1)] = 0.001
        pgm_function18[(2, 69, 1, 2)] = 0.005
        pgm_function18[(2, 69, 2, 1)] = 0.001
        pgm_function18[(2, 69, 2, 2)] = 0.005
        pgm_function18[(2, 69, 3, 1)] = 0.001
        pgm_function18[(2, 69, 3, 2)] = 0.005
        pgm_function18[(2, 69, 4, 1)] = 0.001
        pgm_function18[(2, 69, 4, 2)] = 0.005
        pgm_function18[(2, 70, 1, 1)] = 0.001
        pgm_function18[(2, 70, 1, 2)] = 0.001
        pgm_function18[(2, 70, 2, 1)] = 0.001
        pgm_function18[(2, 70, 2, 2)] = 0.001
        pgm_function18[(2, 70, 3, 1)] = 0.001
        pgm_function18[(2, 70, 3, 2)] = 0.001
        pgm_function18[(2, 70, 4, 1)] = 0.001
        pgm_function18[(2, 70, 4, 2)] = 0.001
        pgm_function18[(2, 71, 1, 1)] = 0.001
        pgm_function18[(2, 71, 1, 2)] = 0.001
        pgm_function18[(2, 71, 2, 1)] = 0.001
        pgm_function18[(2, 71, 2, 2)] = 0.001
        pgm_function18[(2, 71, 3, 1)] = 0.001
        pgm_function18[(2, 71, 3, 2)] = 0.001
        pgm_function18[(2, 71, 4, 1)] = 0.001
        pgm_function18[(2, 71, 4, 2)] = 0.001
        pgm_function18[(2, 72, 1, 1)] = 0.001
        pgm_function18[(2, 72, 1, 2)] = 0.001
        pgm_function18[(2, 72, 2, 1)] = 0.001
        pgm_function18[(2, 72, 2, 2)] = 0.001
        pgm_function18[(2, 72, 3, 1)] = 0.001
        pgm_function18[(2, 72, 3, 2)] = 0.001
        pgm_function18[(2, 72, 4, 1)] = 0.001
        pgm_function18[(2, 72, 4, 2)] = 0.001
        pgm_function18[(2, 73, 1, 1)] = 0.8
        pgm_function18[(2, 73, 1, 2)] = 0.4
        pgm_function18[(2, 73, 2, 1)] = 0.8
        pgm_function18[(2, 73, 2, 2)] = 0.4
        pgm_function18[(2, 73, 3, 1)] = 0.8
        pgm_function18[(2, 73, 3, 2)] = 0.4
        pgm_function18[(2, 73, 4, 1)] = 0.8
        pgm_function18[(2, 73, 4, 2)] = 0.4
        pgm_function18[(2, 74, 1, 1)] = 0.0001
        pgm_function18[(2, 74, 2, 1)] = 0.0001
        pgm_function18[(2, 74, 3, 1)] = 0.0001
        pgm_function18[(2, 74, 4, 1)] = 0.0001
        pgm_function18[(2, 75, 1, 1)] = 0.0001
        pgm_function18[(2, 75, 2, 1)] = 0.0001
        pgm_function18[(2, 75, 3, 1)] = 0.0001
        pgm_function18[(2, 75, 4, 1)] = 0.0001
        pgm_function18[(3, 8, 1, 2)] = 0.001
        pgm_function18[(3, 8, 2, 2)] = 0.001
        pgm_function18[(3, 8, 3, 2)] = 0.001
        pgm_function18[(3, 8, 4, 2)] = 0.001
        pgm_function18[(3, 20, 1, 2)] = 0.001
        pgm_function18[(3, 20, 2, 2)] = 0.001
        pgm_function18[(3, 20, 3, 2)] = 0.001
        pgm_function18[(3, 20, 4, 2)] = 0.001
        pgm_function18[(3, 21, 1, 1)] = 0.2
        pgm_function18[(3, 21, 1, 2)] = 0.6
        pgm_function18[(3, 21, 2, 1)] = 0.2
        pgm_function18[(3, 21, 2, 2)] = 0.6
        pgm_function18[(3, 21, 3, 1)] = 0.2
        pgm_function18[(3, 21, 3, 2)] = 0.6
        pgm_function18[(3, 21, 4, 1)] = 0.2
        pgm_function18[(3, 21, 4, 2)] = 0.6
        pgm_function18[(3, 73, 1, 1)] = 0.2
        pgm_function18[(3, 73, 1, 2)] = 0.6
        pgm_function18[(3, 73, 2, 1)] = 0.2
        pgm_function18[(3, 73, 2, 2)] = 0.6
        pgm_function18[(3, 73, 3, 1)] = 0.2
        pgm_function18[(3, 73, 3, 2)] = 0.6
        pgm_function18[(3, 73, 4, 1)] = 0.2
        pgm_function18[(3, 73, 4, 2)] = 0.6

        pgm_function19 = pgm_factor19.set_dense()
        pgm_function19.set_flat(
            0.9, 0.8, 0.8999, 0.1, 0.05,
            0.8999, 0.8999, 0.8999, 0.1, 0.8999,
            0.899, 0.05, 0.01, 0.8999, 0.89,
            0.05, 0.8999, 0.8999, 0.8999, 0.8999,
            0.1, 0.899, 0.05, 0.899, 0.01,
            0.02, 0.02, 0.799, 0.799, 0.799,
            0.3, 0.2, 0.8999, 0.8999, 0.8999,
            0.8999, 0.8999, 0.8999, 0.949, 0.949,
            0.8999, 0.949, 0.75, 0.949, 0.949,
            0.5, 0.8, 0.949, 0.949, 0.949,
            0.949, 0.949, 0.8999, 0.05, 0.8999,
            0.8999, 0.8999, 0.8999, 0.8999, 0.3,
            0.2, 0.1, 0.68, 0.87, 0.8999,
            0.79, 0.899, 0.01, 0.2, 0.1,
            0.1, 0.1, 0.1, 0.899, 0.949,
            0.8999, 0.1, 0.15, 0.1, 0.8,
            0.8, 0.1, 0.1, 0.1, 0.8,
            0.1, 0.1, 0.85, 0.8, 0.1,
            0.1, 0.9, 0.1, 0.1, 0.1,
            0.1, 0.8, 0.1, 0.85, 0.1,
            0.8, 0.7, 0.7, 0.2, 0.2,
            0.2, 0.69, 0.79, 0.1, 0.1,
            0.1, 0.1, 0.1, 0.1, 0.05,
            0.05, 0.1, 0.05, 0.2, 0.05,
            0.05, 0.4, 0.15, 0.05, 0.05,
            0.05, 0.05, 0.05, 0.1, 0.8,
            0.1, 0.1, 0.1, 0.1, 0.1,
            0.69, 0.79, 0.88, 0.3, 0.1,
            0.1, 0.2, 0.1, 0.79, 0.79,
            0.8, 0.8, 0.8, 0.8, 0.1,
            0.05, 0.1, 0.0, 0.05, 0.0001,
            0.1, 0.15, 0.0001, 0.0001, 0.0001,
            0.1, 0.0001, 0.001, 0.1, 0.19,
            0.0001, 0.01, 0.05, 0.0001, 0.0001,
            0.0001, 0.0001, 0.1, 0.001, 0.1,
            0.001, 0.19, 0.28, 0.28, 0.001,
            0.001, 0.001, 0.01, 0.01, 0.0001,
            0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
            0.001, 0.001, 0.0001, 0.001, 0.05,
            0.001, 0.001, 0.1, 0.05, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.0001,
            0.15, 0.0001, 0.0001, 0.0001, 0.0001,
            0.0001, 0.01, 0.01, 0.02, 0.02,
            0.03, 0.0001, 0.01, 0.001, 0.2,
            0.01, 0.1, 0.1, 0.1, 0.1,
            0.001, 0.001, 0.0001
        )

        pgm_function20 = pgm_factor20.set_sparse()
        pgm_function20[(0, 0, 0, 0)] = 1.0
        pgm_function20[(0, 0, 0, 1)] = 1.0
        pgm_function20[(0, 0, 1, 0)] = 1.0
        pgm_function20[(0, 0, 1, 1)] = 1.0
        pgm_function20[(0, 1, 0, 0)] = 1.0
        pgm_function20[(0, 1, 0, 1)] = 1.0
        pgm_function20[(0, 1, 1, 0)] = 1.0
        pgm_function20[(0, 1, 1, 1)] = 1.0
        pgm_function20[(0, 2, 0, 0)] = 1.0
        pgm_function20[(0, 2, 0, 1)] = 1.0
        pgm_function20[(0, 2, 1, 0)] = 1.0
        pgm_function20[(0, 2, 1, 1)] = 1.0
        pgm_function20[(0, 3, 0, 0)] = 1.0
        pgm_function20[(0, 3, 0, 1)] = 1.0
        pgm_function20[(0, 3, 1, 0)] = 0.999
        pgm_function20[(0, 3, 1, 1)] = 0.995
        pgm_function20[(0, 4, 0, 0)] = 1.0
        pgm_function20[(0, 4, 0, 1)] = 1.0
        pgm_function20[(0, 4, 1, 0)] = 1.0
        pgm_function20[(0, 4, 1, 1)] = 1.0
        pgm_function20[(0, 5, 0, 0)] = 1.0
        pgm_function20[(0, 5, 0, 1)] = 1.0
        pgm_function20[(0, 5, 1, 0)] = 1.0
        pgm_function20[(0, 5, 1, 1)] = 1.0
        pgm_function20[(0, 6, 0, 0)] = 1.0
        pgm_function20[(0, 6, 0, 1)] = 1.0
        pgm_function20[(0, 6, 1, 0)] = 1.0
        pgm_function20[(0, 6, 1, 1)] = 1.0
        pgm_function20[(0, 7, 0, 0)] = 1.0
        pgm_function20[(0, 7, 0, 1)] = 1.0
        pgm_function20[(0, 7, 1, 0)] = 1.0
        pgm_function20[(0, 7, 1, 1)] = 1.0
        pgm_function20[(0, 8, 0, 0)] = 1.0
        pgm_function20[(0, 8, 0, 1)] = 1.0
        pgm_function20[(0, 8, 1, 0)] = 1.0
        pgm_function20[(0, 8, 1, 1)] = 1.0
        pgm_function20[(0, 9, 0, 0)] = 1.0
        pgm_function20[(0, 9, 0, 1)] = 1.0
        pgm_function20[(0, 9, 1, 0)] = 1.0
        pgm_function20[(0, 9, 1, 1)] = 1.0
        pgm_function20[(0, 10, 0, 0)] = 0.25
        pgm_function20[(0, 10, 0, 1)] = 0.25
        pgm_function20[(0, 10, 1, 0)] = 0.999
        pgm_function20[(0, 10, 1, 1)] = 0.995
        pgm_function20[(0, 11, 0, 0)] = 1.0
        pgm_function20[(0, 11, 0, 1)] = 1.0
        pgm_function20[(0, 11, 1, 0)] = 1.0
        pgm_function20[(0, 11, 1, 1)] = 1.0
        pgm_function20[(0, 12, 0, 0)] = 1.0
        pgm_function20[(0, 12, 0, 1)] = 1.0
        pgm_function20[(0, 12, 1, 0)] = 1.0
        pgm_function20[(0, 12, 1, 1)] = 1.0
        pgm_function20[(0, 13, 0, 0)] = 1.0
        pgm_function20[(0, 13, 0, 1)] = 1.0
        pgm_function20[(0, 13, 1, 0)] = 1.0
        pgm_function20[(0, 13, 1, 1)] = 1.0
        pgm_function20[(0, 14, 0, 0)] = 1.0
        pgm_function20[(0, 14, 0, 1)] = 1.0
        pgm_function20[(0, 14, 1, 0)] = 0.999
        pgm_function20[(0, 14, 1, 1)] = 0.995
        pgm_function20[(0, 15, 0, 0)] = 1.0
        pgm_function20[(0, 15, 0, 1)] = 1.0
        pgm_function20[(0, 15, 1, 0)] = 0.999
        pgm_function20[(0, 15, 1, 1)] = 0.995
        pgm_function20[(0, 16, 0, 0)] = 1.0
        pgm_function20[(0, 16, 0, 1)] = 1.0
        pgm_function20[(0, 16, 1, 0)] = 1.0
        pgm_function20[(0, 16, 1, 1)] = 1.0
        pgm_function20[(0, 17, 0, 0)] = 1.0
        pgm_function20[(0, 17, 0, 1)] = 1.0
        pgm_function20[(0, 17, 1, 0)] = 1.0
        pgm_function20[(0, 17, 1, 1)] = 1.0
        pgm_function20[(0, 18, 0, 0)] = 1.0
        pgm_function20[(0, 18, 0, 1)] = 1.0
        pgm_function20[(0, 18, 1, 0)] = 1.0
        pgm_function20[(0, 18, 1, 1)] = 1.0
        pgm_function20[(0, 19, 0, 0)] = 1.0
        pgm_function20[(0, 19, 0, 1)] = 1.0
        pgm_function20[(0, 19, 1, 0)] = 1.0
        pgm_function20[(0, 19, 1, 1)] = 1.0
        pgm_function20[(0, 20, 0, 0)] = 1.0
        pgm_function20[(0, 20, 0, 1)] = 1.0
        pgm_function20[(0, 20, 1, 0)] = 1.0
        pgm_function20[(0, 20, 1, 1)] = 1.0
        pgm_function20[(0, 21, 0, 0)] = 1.0
        pgm_function20[(0, 21, 0, 1)] = 1.0
        pgm_function20[(0, 21, 1, 0)] = 1.0
        pgm_function20[(0, 21, 1, 1)] = 1.0
        pgm_function20[(0, 22, 0, 0)] = 1.0
        pgm_function20[(0, 22, 0, 1)] = 1.0
        pgm_function20[(0, 22, 1, 0)] = 1.0
        pgm_function20[(0, 22, 1, 1)] = 1.0
        pgm_function20[(0, 23, 0, 0)] = 0.25
        pgm_function20[(0, 23, 0, 1)] = 0.25
        pgm_function20[(0, 23, 1, 0)] = 0.999
        pgm_function20[(0, 23, 1, 1)] = 0.995
        pgm_function20[(0, 24, 0, 0)] = 1.0
        pgm_function20[(0, 24, 0, 1)] = 1.0
        pgm_function20[(0, 24, 1, 0)] = 1.0
        pgm_function20[(0, 24, 1, 1)] = 1.0
        pgm_function20[(0, 25, 0, 0)] = 1.0
        pgm_function20[(0, 25, 0, 1)] = 1.0
        pgm_function20[(0, 25, 1, 0)] = 1.0
        pgm_function20[(0, 25, 1, 1)] = 1.0
        pgm_function20[(0, 26, 0, 0)] = 1.0
        pgm_function20[(0, 26, 0, 1)] = 1.0
        pgm_function20[(0, 26, 1, 0)] = 1.0
        pgm_function20[(0, 26, 1, 1)] = 1.0
        pgm_function20[(0, 27, 0, 0)] = 1.0
        pgm_function20[(0, 27, 0, 1)] = 1.0
        pgm_function20[(0, 27, 1, 0)] = 0.999
        pgm_function20[(0, 27, 1, 1)] = 0.9995
        pgm_function20[(0, 28, 0, 0)] = 1.0
        pgm_function20[(0, 28, 0, 1)] = 1.0
        pgm_function20[(0, 28, 1, 0)] = 0.999
        pgm_function20[(0, 28, 1, 1)] = 0.9995
        pgm_function20[(0, 29, 0, 0)] = 1.0
        pgm_function20[(0, 29, 0, 1)] = 1.0
        pgm_function20[(0, 29, 1, 0)] = 0.999
        pgm_function20[(0, 29, 1, 1)] = 0.9995
        pgm_function20[(0, 30, 0, 0)] = 1.0
        pgm_function20[(0, 30, 0, 1)] = 1.0
        pgm_function20[(0, 30, 1, 0)] = 1.0
        pgm_function20[(0, 30, 1, 1)] = 1.0
        pgm_function20[(0, 31, 0, 0)] = 1.0
        pgm_function20[(0, 31, 0, 1)] = 1.0
        pgm_function20[(0, 31, 1, 0)] = 1.0
        pgm_function20[(0, 31, 1, 1)] = 1.0
        pgm_function20[(0, 32, 0, 0)] = 1.0
        pgm_function20[(0, 32, 0, 1)] = 1.0
        pgm_function20[(0, 32, 1, 0)] = 1.0
        pgm_function20[(0, 32, 1, 1)] = 1.0
        pgm_function20[(0, 33, 0, 0)] = 1.0
        pgm_function20[(0, 33, 0, 1)] = 1.0
        pgm_function20[(0, 33, 1, 0)] = 1.0
        pgm_function20[(0, 33, 1, 1)] = 1.0
        pgm_function20[(0, 34, 0, 0)] = 1.0
        pgm_function20[(0, 34, 0, 1)] = 1.0
        pgm_function20[(0, 34, 1, 0)] = 1.0
        pgm_function20[(0, 34, 1, 1)] = 1.0
        pgm_function20[(0, 35, 0, 0)] = 1.0
        pgm_function20[(0, 35, 0, 1)] = 1.0
        pgm_function20[(0, 35, 1, 0)] = 1.0
        pgm_function20[(0, 35, 1, 1)] = 1.0
        pgm_function20[(0, 36, 0, 0)] = 1.0
        pgm_function20[(0, 36, 0, 1)] = 1.0
        pgm_function20[(0, 36, 1, 0)] = 1.0
        pgm_function20[(0, 36, 1, 1)] = 1.0
        pgm_function20[(0, 37, 0, 0)] = 1.0
        pgm_function20[(0, 37, 0, 1)] = 1.0
        pgm_function20[(0, 37, 1, 0)] = 1.0
        pgm_function20[(0, 37, 1, 1)] = 1.0
        pgm_function20[(0, 38, 0, 0)] = 1.0
        pgm_function20[(0, 38, 0, 1)] = 1.0
        pgm_function20[(0, 38, 1, 0)] = 1.0
        pgm_function20[(0, 38, 1, 1)] = 1.0
        pgm_function20[(0, 39, 0, 0)] = 1.0
        pgm_function20[(0, 39, 0, 1)] = 1.0
        pgm_function20[(0, 39, 1, 0)] = 1.0
        pgm_function20[(0, 39, 1, 1)] = 1.0
        pgm_function20[(0, 40, 0, 0)] = 1.0
        pgm_function20[(0, 40, 0, 1)] = 1.0
        pgm_function20[(0, 40, 1, 0)] = 1.0
        pgm_function20[(0, 40, 1, 1)] = 1.0
        pgm_function20[(0, 41, 0, 0)] = 1.0
        pgm_function20[(0, 41, 0, 1)] = 1.0
        pgm_function20[(0, 41, 1, 0)] = 1.0
        pgm_function20[(0, 41, 1, 1)] = 1.0
        pgm_function20[(0, 42, 0, 0)] = 1.0
        pgm_function20[(0, 42, 0, 1)] = 1.0
        pgm_function20[(0, 42, 1, 0)] = 1.0
        pgm_function20[(0, 42, 1, 1)] = 1.0
        pgm_function20[(0, 43, 0, 0)] = 0.25
        pgm_function20[(0, 43, 0, 1)] = 0.25
        pgm_function20[(0, 43, 1, 0)] = 0.98
        pgm_function20[(0, 43, 1, 1)] = 0.98
        pgm_function20[(0, 44, 0, 0)] = 0.25
        pgm_function20[(0, 44, 0, 1)] = 0.25
        pgm_function20[(0, 44, 1, 0)] = 1.0
        pgm_function20[(0, 44, 1, 1)] = 1.0
        pgm_function20[(0, 45, 0, 0)] = 0.25
        pgm_function20[(0, 45, 0, 1)] = 0.25
        pgm_function20[(0, 45, 1, 0)] = 0.96
        pgm_function20[(0, 45, 1, 1)] = 0.96
        pgm_function20[(0, 46, 0, 0)] = 0.25
        pgm_function20[(0, 46, 0, 1)] = 0.25
        pgm_function20[(0, 47, 0, 0)] = 1.0
        pgm_function20[(0, 47, 0, 1)] = 0.98
        pgm_function20[(0, 47, 1, 0)] = 0.97
        pgm_function20[(0, 47, 1, 1)] = 0.98
        pgm_function20[(0, 48, 0, 0)] = 1.0
        pgm_function20[(0, 48, 0, 1)] = 1.0
        pgm_function20[(0, 48, 1, 0)] = 1.0
        pgm_function20[(0, 48, 1, 1)] = 1.0
        pgm_function20[(0, 49, 0, 0)] = 1.0
        pgm_function20[(0, 49, 0, 1)] = 1.0
        pgm_function20[(0, 49, 1, 0)] = 0.25
        pgm_function20[(0, 49, 1, 1)] = 1.0
        pgm_function20[(0, 50, 0, 0)] = 0.25
        pgm_function20[(0, 50, 0, 1)] = 0.25
        pgm_function20[(0, 50, 1, 0)] = 0.97
        pgm_function20[(0, 50, 1, 1)] = 0.97
        pgm_function20[(0, 51, 0, 0)] = 0.25
        pgm_function20[(0, 51, 0, 1)] = 0.25
        pgm_function20[(0, 51, 1, 0)] = 1.0
        pgm_function20[(0, 51, 1, 1)] = 1.0
        pgm_function20[(0, 52, 0, 0)] = 1.0
        pgm_function20[(0, 52, 0, 1)] = 1.0
        pgm_function20[(0, 52, 1, 0)] = 1.0
        pgm_function20[(0, 52, 1, 1)] = 1.0
        pgm_function20[(0, 53, 0, 0)] = 1.0
        pgm_function20[(0, 53, 0, 1)] = 1.0
        pgm_function20[(0, 53, 1, 0)] = 1.0
        pgm_function20[(0, 53, 1, 1)] = 1.0
        pgm_function20[(0, 54, 0, 0)] = 1.0
        pgm_function20[(0, 54, 0, 1)] = 1.0
        pgm_function20[(0, 54, 1, 0)] = 1.0
        pgm_function20[(0, 54, 1, 1)] = 1.0
        pgm_function20[(0, 55, 0, 0)] = 1.0
        pgm_function20[(0, 55, 0, 1)] = 0.97
        pgm_function20[(0, 55, 1, 0)] = 1.0
        pgm_function20[(0, 55, 1, 1)] = 0.97
        pgm_function20[(0, 56, 0, 0)] = 1.0
        pgm_function20[(0, 56, 0, 1)] = 1.0
        pgm_function20[(0, 56, 1, 0)] = 0.999
        pgm_function20[(0, 56, 1, 1)] = 0.998
        pgm_function20[(0, 57, 0, 0)] = 1.0
        pgm_function20[(0, 57, 0, 1)] = 1.0
        pgm_function20[(0, 57, 1, 0)] = 1.0
        pgm_function20[(0, 57, 1, 1)] = 1.0
        pgm_function20[(0, 58, 0, 0)] = 1.0
        pgm_function20[(0, 58, 0, 1)] = 1.0
        pgm_function20[(0, 58, 1, 0)] = 1.0
        pgm_function20[(0, 58, 1, 1)] = 1.0
        pgm_function20[(0, 59, 0, 0)] = 1.0
        pgm_function20[(0, 59, 0, 1)] = 1.0
        pgm_function20[(0, 59, 1, 0)] = 1.0
        pgm_function20[(0, 59, 1, 1)] = 1.0
        pgm_function20[(0, 60, 0, 0)] = 1.0
        pgm_function20[(0, 60, 0, 1)] = 0.97
        pgm_function20[(0, 60, 1, 0)] = 1.0
        pgm_function20[(0, 60, 1, 1)] = 0.97
        pgm_function20[(0, 61, 0, 0)] = 1.0
        pgm_function20[(0, 61, 0, 1)] = 1.0
        pgm_function20[(0, 61, 1, 0)] = 1.0
        pgm_function20[(0, 61, 1, 1)] = 1.0
        pgm_function20[(0, 62, 0, 0)] = 0.25
        pgm_function20[(0, 62, 0, 1)] = 0.25
        pgm_function20[(0, 62, 1, 0)] = 0.96
        pgm_function20[(0, 62, 1, 1)] = 0.94
        pgm_function20[(0, 63, 0, 0)] = 1.0
        pgm_function20[(0, 63, 0, 1)] = 0.97
        pgm_function20[(0, 63, 1, 0)] = 1.0
        pgm_function20[(0, 63, 1, 1)] = 0.97
        pgm_function20[(0, 64, 0, 0)] = 1.0
        pgm_function20[(0, 64, 0, 1)] = 1.0
        pgm_function20[(0, 64, 1, 0)] = 0.999
        pgm_function20[(0, 64, 1, 1)] = 0.998
        pgm_function20[(0, 65, 0, 0)] = 1.0
        pgm_function20[(0, 65, 0, 1)] = 1.0
        pgm_function20[(0, 65, 1, 0)] = 0.999
        pgm_function20[(0, 65, 1, 1)] = 0.998
        pgm_function20[(0, 66, 0, 0)] = 0.25
        pgm_function20[(0, 66, 0, 1)] = 0.25
        pgm_function20[(0, 66, 1, 0)] = 0.999
        pgm_function20[(0, 66, 1, 1)] = 0.995
        pgm_function20[(0, 67, 0, 0)] = 1.0
        pgm_function20[(0, 67, 0, 1)] = 1.0
        pgm_function20[(0, 67, 1, 0)] = 1.0
        pgm_function20[(0, 67, 1, 1)] = 1.0
        pgm_function20[(0, 68, 0, 0)] = 1.0
        pgm_function20[(0, 68, 0, 1)] = 0.97
        pgm_function20[(0, 68, 1, 0)] = 1.0
        pgm_function20[(0, 68, 1, 1)] = 0.97
        pgm_function20[(0, 69, 0, 0)] = 1.0
        pgm_function20[(0, 69, 0, 1)] = 1.0
        pgm_function20[(0, 69, 1, 0)] = 0.999
        pgm_function20[(0, 69, 1, 1)] = 0.995
        pgm_function20[(0, 70, 0, 0)] = 1.0
        pgm_function20[(0, 70, 0, 1)] = 1.0
        pgm_function20[(0, 70, 1, 0)] = 1.0
        pgm_function20[(0, 70, 1, 1)] = 1.0
        pgm_function20[(0, 71, 0, 0)] = 1.0
        pgm_function20[(0, 71, 0, 1)] = 1.0
        pgm_function20[(0, 71, 1, 0)] = 1.0
        pgm_function20[(0, 71, 1, 1)] = 1.0
        pgm_function20[(0, 72, 0, 0)] = 1.0
        pgm_function20[(0, 72, 0, 1)] = 1.0
        pgm_function20[(0, 72, 1, 0)] = 1.0
        pgm_function20[(0, 72, 1, 1)] = 1.0
        pgm_function20[(0, 73, 0, 0)] = 1.0
        pgm_function20[(0, 73, 0, 1)] = 1.0
        pgm_function20[(0, 73, 1, 0)] = 1.0
        pgm_function20[(0, 73, 1, 1)] = 1.0
        pgm_function20[(0, 74, 0, 0)] = 0.25
        pgm_function20[(0, 74, 0, 1)] = 0.25
        pgm_function20[(0, 74, 1, 0)] = 1.0
        pgm_function20[(0, 74, 1, 1)] = 1.0
        pgm_function20[(0, 75, 0, 0)] = 1.0
        pgm_function20[(0, 75, 0, 1)] = 1.0
        pgm_function20[(0, 75, 1, 0)] = 1.0
        pgm_function20[(0, 75, 1, 1)] = 1.0
        pgm_function20[(1, 3, 1, 0)] = 0.001
        pgm_function20[(1, 3, 1, 1)] = 0.005
        pgm_function20[(1, 10, 0, 0)] = 0.25
        pgm_function20[(1, 10, 0, 1)] = 0.25
        pgm_function20[(1, 10, 1, 0)] = 0.001
        pgm_function20[(1, 10, 1, 1)] = 0.005
        pgm_function20[(1, 14, 1, 0)] = 0.001
        pgm_function20[(1, 14, 1, 1)] = 0.005
        pgm_function20[(1, 15, 1, 0)] = 0.001
        pgm_function20[(1, 15, 1, 1)] = 0.005
        pgm_function20[(1, 23, 0, 0)] = 0.25
        pgm_function20[(1, 23, 0, 1)] = 0.25
        pgm_function20[(1, 23, 1, 0)] = 0.001
        pgm_function20[(1, 23, 1, 1)] = 0.005
        pgm_function20[(1, 27, 1, 0)] = 0.001
        pgm_function20[(1, 27, 1, 1)] = 0.0005
        pgm_function20[(1, 28, 1, 0)] = 0.001
        pgm_function20[(1, 28, 1, 1)] = 0.0005
        pgm_function20[(1, 29, 1, 0)] = 0.001
        pgm_function20[(1, 29, 1, 1)] = 0.0005
        pgm_function20[(1, 43, 0, 0)] = 0.25
        pgm_function20[(1, 43, 0, 1)] = 0.25
        pgm_function20[(1, 43, 1, 0)] = 0.02
        pgm_function20[(1, 43, 1, 1)] = 0.02
        pgm_function20[(1, 44, 0, 0)] = 0.25
        pgm_function20[(1, 44, 0, 1)] = 0.25
        pgm_function20[(1, 45, 0, 0)] = 0.25
        pgm_function20[(1, 45, 0, 1)] = 0.25
        pgm_function20[(1, 45, 1, 0)] = 0.02
        pgm_function20[(1, 45, 1, 1)] = 0.02
        pgm_function20[(1, 46, 0, 0)] = 0.25
        pgm_function20[(1, 46, 0, 1)] = 0.25
        pgm_function20[(1, 46, 1, 0)] = 0.05
        pgm_function20[(1, 46, 1, 1)] = 0.05
        pgm_function20[(1, 47, 0, 1)] = 0.01
        pgm_function20[(1, 47, 1, 0)] = 0.02
        pgm_function20[(1, 47, 1, 1)] = 0.01
        pgm_function20[(1, 49, 1, 0)] = 0.25
        pgm_function20[(1, 50, 0, 0)] = 0.25
        pgm_function20[(1, 50, 0, 1)] = 0.25
        pgm_function20[(1, 50, 1, 0)] = 0.02
        pgm_function20[(1, 50, 1, 1)] = 0.02
        pgm_function20[(1, 51, 0, 0)] = 0.25
        pgm_function20[(1, 51, 0, 1)] = 0.25
        pgm_function20[(1, 55, 0, 1)] = 0.02
        pgm_function20[(1, 55, 1, 1)] = 0.02
        pgm_function20[(1, 56, 1, 0)] = 0.001
        pgm_function20[(1, 56, 1, 1)] = 0.001
        pgm_function20[(1, 60, 0, 1)] = 0.02
        pgm_function20[(1, 60, 1, 1)] = 0.02
        pgm_function20[(1, 62, 0, 0)] = 0.25
        pgm_function20[(1, 62, 0, 1)] = 0.25
        pgm_function20[(1, 62, 1, 0)] = 0.02
        pgm_function20[(1, 62, 1, 1)] = 0.04
        pgm_function20[(1, 63, 0, 1)] = 0.02
        pgm_function20[(1, 63, 1, 1)] = 0.02
        pgm_function20[(1, 64, 1, 0)] = 0.001
        pgm_function20[(1, 64, 1, 1)] = 0.001
        pgm_function20[(1, 65, 1, 0)] = 0.001
        pgm_function20[(1, 65, 1, 1)] = 0.001
        pgm_function20[(1, 66, 0, 0)] = 0.25
        pgm_function20[(1, 66, 0, 1)] = 0.25
        pgm_function20[(1, 66, 1, 0)] = 0.001
        pgm_function20[(1, 66, 1, 1)] = 0.005
        pgm_function20[(1, 68, 0, 1)] = 0.02
        pgm_function20[(1, 68, 1, 1)] = 0.02
        pgm_function20[(1, 69, 1, 0)] = 0.001
        pgm_function20[(1, 69, 1, 1)] = 0.005
        pgm_function20[(1, 74, 0, 0)] = 0.25
        pgm_function20[(1, 74, 0, 1)] = 0.25
        pgm_function20[(2, 10, 0, 0)] = 0.25
        pgm_function20[(2, 10, 0, 1)] = 0.25
        pgm_function20[(2, 23, 0, 0)] = 0.25
        pgm_function20[(2, 23, 0, 1)] = 0.25
        pgm_function20[(2, 43, 0, 0)] = 0.25
        pgm_function20[(2, 43, 0, 1)] = 0.25
        pgm_function20[(2, 44, 0, 0)] = 0.25
        pgm_function20[(2, 44, 0, 1)] = 0.25
        pgm_function20[(2, 45, 0, 0)] = 0.25
        pgm_function20[(2, 45, 0, 1)] = 0.25
        pgm_function20[(2, 45, 1, 0)] = 0.01
        pgm_function20[(2, 45, 1, 1)] = 0.01
        pgm_function20[(2, 46, 0, 0)] = 0.25
        pgm_function20[(2, 46, 0, 1)] = 0.25
        pgm_function20[(2, 46, 1, 0)] = 0.5
        pgm_function20[(2, 46, 1, 1)] = 0.45
        pgm_function20[(2, 47, 0, 1)] = 0.01
        pgm_function20[(2, 47, 1, 0)] = 0.01
        pgm_function20[(2, 47, 1, 1)] = 0.01
        pgm_function20[(2, 49, 1, 0)] = 0.25
        pgm_function20[(2, 50, 0, 0)] = 0.25
        pgm_function20[(2, 50, 0, 1)] = 0.25
        pgm_function20[(2, 50, 1, 0)] = 0.01
        pgm_function20[(2, 50, 1, 1)] = 0.01
        pgm_function20[(2, 51, 0, 0)] = 0.25
        pgm_function20[(2, 51, 0, 1)] = 0.25
        pgm_function20[(2, 55, 0, 1)] = 0.01
        pgm_function20[(2, 55, 1, 1)] = 0.01
        pgm_function20[(2, 56, 1, 1)] = 0.001
        pgm_function20[(2, 60, 0, 1)] = 0.01
        pgm_function20[(2, 60, 1, 1)] = 0.01
        pgm_function20[(2, 62, 0, 0)] = 0.25
        pgm_function20[(2, 62, 0, 1)] = 0.25
        pgm_function20[(2, 62, 1, 0)] = 0.01
        pgm_function20[(2, 62, 1, 1)] = 0.01
        pgm_function20[(2, 63, 0, 1)] = 0.01
        pgm_function20[(2, 63, 1, 1)] = 0.01
        pgm_function20[(2, 64, 1, 1)] = 0.001
        pgm_function20[(2, 65, 1, 1)] = 0.001
        pgm_function20[(2, 66, 0, 0)] = 0.25
        pgm_function20[(2, 66, 0, 1)] = 0.25
        pgm_function20[(2, 68, 0, 1)] = 0.01
        pgm_function20[(2, 68, 1, 1)] = 0.01
        pgm_function20[(2, 74, 0, 0)] = 0.25
        pgm_function20[(2, 74, 0, 1)] = 0.25
        pgm_function20[(3, 10, 0, 0)] = 0.25
        pgm_function20[(3, 10, 0, 1)] = 0.25
        pgm_function20[(3, 23, 0, 0)] = 0.25
        pgm_function20[(3, 23, 0, 1)] = 0.25
        pgm_function20[(3, 43, 0, 0)] = 0.25
        pgm_function20[(3, 43, 0, 1)] = 0.25
        pgm_function20[(3, 44, 0, 0)] = 0.25
        pgm_function20[(3, 44, 0, 1)] = 0.25
        pgm_function20[(3, 45, 0, 0)] = 0.25
        pgm_function20[(3, 45, 0, 1)] = 0.25
        pgm_function20[(3, 45, 1, 0)] = 0.01
        pgm_function20[(3, 45, 1, 1)] = 0.01
        pgm_function20[(3, 46, 0, 0)] = 0.25
        pgm_function20[(3, 46, 0, 1)] = 0.25
        pgm_function20[(3, 46, 1, 0)] = 0.45
        pgm_function20[(3, 46, 1, 1)] = 0.5
        pgm_function20[(3, 49, 1, 0)] = 0.25
        pgm_function20[(3, 50, 0, 0)] = 0.25
        pgm_function20[(3, 50, 0, 1)] = 0.25
        pgm_function20[(3, 51, 0, 0)] = 0.25
        pgm_function20[(3, 51, 0, 1)] = 0.25
        pgm_function20[(3, 62, 0, 0)] = 0.25
        pgm_function20[(3, 62, 0, 1)] = 0.25
        pgm_function20[(3, 62, 1, 0)] = 0.01
        pgm_function20[(3, 62, 1, 1)] = 0.01
        pgm_function20[(3, 66, 0, 0)] = 0.25
        pgm_function20[(3, 66, 0, 1)] = 0.25
        pgm_function20[(3, 74, 0, 0)] = 0.25
        pgm_function20[(3, 74, 0, 1)] = 0.25

        pgm_function21 = pgm_factor21.set_dense()
        pgm_function21.set_flat(
            0.94, 0.94, 0.9, 0.9, 0.8,
            0.8, 0.8, 0.8, 0.94, 0.94,
            0.9, 0.9, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.01,
            0.01, 0.01, 0.01, 0.94, 0.94,
            0.9, 0.9, 0.78, 0.78, 0.4,
            0.4, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.94,
            0.94, 0.9, 0.9, 0.94, 0.94,
            0.9, 0.9, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.78,
            0.78, 0.4, 0.4, 0.84, 0.84,
            0.8, 0.8, 0.01, 0.01, 0.01,
            0.01, 0.94, 0.94, 0.9, 0.9,
            0.78, 0.78, 0.4, 0.4, 0.94,
            0.94, 0.9, 0.9, 0.78, 0.78,
            0.4, 0.4, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.94,
            0.94, 0.9, 0.9, 0.0, 0.0,
            0.0, 0.0, 0.949, 0.95, 0.95,
            0.95, 0.0, 0.0, 0.0, 0.0,
            0.97, 0.975, 0.94, 0.94, 0.94,
            0.94, 0.9, 0.9, 0.1, 0.1,
            0.1, 0.1, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.94,
            0.94, 0.9, 0.9, 0.94, 0.94,
            0.9, 0.9, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.8,
            0.8, 0.8, 0.8, 0.8, 0.8,
            0.8, 0.8, 0.8, 0.8, 0.8,
            0.8, 0.94, 0.94, 0.9, 0.9,
            0.55, 0.55, 0.48, 0.48, 0.8,
            0.8, 0.8, 0.8, 0.94, 0.94,
            0.9, 0.9, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.94,
            0.94, 0.9, 0.9, 0.94, 0.94,
            0.9, 0.9, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.94,
            0.94, 0.9, 0.9, 0.94, 0.94,
            0.9, 0.9, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.1, 0.1, 0.1, 0.1, 0.94,
            0.94, 0.9, 0.9, 0.8, 0.8,
            0.8, 0.8, 0.94, 0.94, 0.9,
            0.9, 0.0, 0.0, 0.0, 0.0,
            0.94, 0.94, 0.9, 0.9, 0.94,
            0.94, 0.9, 0.9, 0.94, 0.94,
            0.9, 0.9, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.94,
            0.94, 0.9, 0.9, 0.94, 0.94,
            0.9, 0.9, 0.94, 0.94, 0.9,
            0.9, 0.94, 0.94, 0.9, 0.9,
            0.94, 0.94, 0.9, 0.9, 0.05,
            0.05, 0.08, 0.08, 0.15, 0.15,
            0.15, 0.15, 0.05, 0.05, 0.08,
            0.08, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.64, 0.64,
            0.64, 0.64, 0.05, 0.05, 0.08,
            0.08, 0.15, 0.15, 0.45, 0.45,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.05, 0.05,
            0.08, 0.08, 0.05, 0.05, 0.08,
            0.08, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.15, 0.15,
            0.45, 0.45, 0.15, 0.15, 0.18,
            0.18, 0.94, 0.89, 0.94, 0.94,
            0.05, 0.05, 0.08, 0.08, 0.15,
            0.15, 0.45, 0.45, 0.05, 0.05,
            0.08, 0.08, 0.15, 0.15, 0.45,
            0.45, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.05, 0.05,
            0.08, 0.08, 0.8, 0.7, 0.8,
            0.8, 0.05, 0.05, 0.05, 0.05,
            0.96, 0.85, 0.94, 0.94, 0.02,
            0.02, 0.05, 0.05, 0.05, 0.05,
            0.08, 0.08, 0.7, 0.7, 0.7,
            0.7, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.05, 0.05,
            0.08, 0.08, 0.05, 0.05, 0.08,
            0.08, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.15, 0.15,
            0.15, 0.15, 0.15, 0.15, 0.15,
            0.15, 0.15, 0.15, 0.15, 0.15,
            0.05, 0.05, 0.08, 0.08, 0.4,
            0.4, 0.45, 0.45, 0.15, 0.15,
            0.15, 0.15, 0.05, 0.05, 0.08,
            0.08, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.05, 0.05,
            0.08, 0.08, 0.05, 0.05, 0.08,
            0.08, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.05, 0.05,
            0.08, 0.08, 0.05, 0.05, 0.08,
            0.08, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.8,
            0.8, 0.8, 0.8, 0.05, 0.05,
            0.08, 0.08, 0.15, 0.15, 0.15,
            0.15, 0.05, 0.05, 0.08, 0.08,
            0.8, 0.7, 0.8, 0.8, 0.05,
            0.05, 0.08, 0.08, 0.05, 0.05,
            0.08, 0.08, 0.05, 0.05, 0.08,
            0.08, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.05, 0.05,
            0.08, 0.08, 0.05, 0.05, 0.08,
            0.08, 0.05, 0.05, 0.08, 0.08,
            0.05, 0.05, 0.08, 0.08, 0.05,
            0.05, 0.08, 0.08, 0.01, 0.01,
            0.02, 0.02, 0.05, 0.05, 0.05,
            0.05, 0.01, 0.01, 0.02, 0.02,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.35, 0.35, 0.35,
            0.35, 0.01, 0.01, 0.02, 0.02,
            0.07, 0.07, 0.15, 0.15, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.01, 0.01, 0.02,
            0.02, 0.01, 0.01, 0.02, 0.02,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.07, 0.07, 0.15,
            0.15, 0.01, 0.01, 0.02, 0.02,
            0.05, 0.1, 0.05, 0.05, 0.01,
            0.01, 0.02, 0.02, 0.07, 0.07,
            0.15, 0.15, 0.01, 0.01, 0.02,
            0.02, 0.07, 0.07, 0.15, 0.15,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.01, 0.01, 0.02,
            0.02, 0.2, 0.3, 0.2, 0.2,
            0.001, 0.0, 0.0, 0.0, 0.04,
            0.15, 0.06, 0.06, 0.01, 0.005,
            0.01, 0.01, 0.01, 0.01, 0.02,
            0.02, 0.2, 0.2, 0.2, 0.2,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.01, 0.01, 0.02,
            0.02, 0.01, 0.01, 0.02, 0.02,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.05, 0.05, 0.05,
            0.05, 0.05, 0.05, 0.05, 0.05,
            0.05, 0.05, 0.05, 0.05, 0.01,
            0.01, 0.02, 0.02, 0.05, 0.05,
            0.07, 0.07, 0.05, 0.05, 0.05,
            0.05, 0.01, 0.01, 0.02, 0.02,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.01, 0.01, 0.02,
            0.02, 0.01, 0.01, 0.02, 0.02,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.01, 0.01, 0.02,
            0.02, 0.01, 0.01, 0.02, 0.02,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.1, 0.1,
            0.1, 0.1, 0.01, 0.01, 0.02,
            0.02, 0.05, 0.05, 0.05, 0.05,
            0.01, 0.01, 0.02, 0.02, 0.2,
            0.3, 0.2, 0.2, 0.01, 0.01,
            0.02, 0.02, 0.01, 0.01, 0.02,
            0.02, 0.01, 0.01, 0.02, 0.02,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02, 0.01, 0.01, 0.02,
            0.02, 0.01, 0.01, 0.02, 0.02,
            0.01, 0.01, 0.02, 0.02, 0.01,
            0.01, 0.02, 0.02, 0.01, 0.01,
            0.02, 0.02
        )

        pgm_function22 = pgm_factor22.set_sparse()
        pgm_function22[(0, 0, 0)] = 1.0
        pgm_function22[(0, 1, 0)] = 1.0
        pgm_function22[(0, 2, 0)] = 1.0
        pgm_function22[(0, 3, 0)] = 1.0
        pgm_function22[(0, 4, 0)] = 1.0
        pgm_function22[(0, 5, 0)] = 1.0
        pgm_function22[(0, 6, 0)] = 1.0
        pgm_function22[(0, 7, 0)] = 1.0
        pgm_function22[(0, 8, 0)] = 1.0
        pgm_function22[(0, 9, 0)] = 1.0
        pgm_function22[(0, 10, 0)] = 1.0
        pgm_function22[(0, 11, 0)] = 1.0
        pgm_function22[(0, 12, 0)] = 1.0
        pgm_function22[(0, 13, 0)] = 1.0
        pgm_function22[(0, 14, 0)] = 1.0
        pgm_function22[(0, 15, 0)] = 1.0
        pgm_function22[(0, 16, 0)] = 1.0
        pgm_function22[(0, 17, 0)] = 1.0
        pgm_function22[(0, 18, 0)] = 1.0
        pgm_function22[(0, 19, 0)] = 1.0
        pgm_function22[(0, 20, 0)] = 1.0
        pgm_function22[(0, 21, 0)] = 1.0
        pgm_function22[(0, 22, 0)] = 1.0
        pgm_function22[(0, 23, 0)] = 1.0
        pgm_function22[(0, 24, 0)] = 1.0
        pgm_function22[(0, 25, 0)] = 1.0
        pgm_function22[(0, 26, 0)] = 1.0
        pgm_function22[(0, 27, 0)] = 1.0
        pgm_function22[(0, 28, 0)] = 1.0
        pgm_function22[(0, 29, 0)] = 1.0
        pgm_function22[(0, 30, 0)] = 1.0
        pgm_function22[(0, 31, 0)] = 1.0
        pgm_function22[(0, 32, 0)] = 1.0
        pgm_function22[(0, 33, 0)] = 1.0
        pgm_function22[(0, 34, 0)] = 1.0
        pgm_function22[(0, 35, 0)] = 1.0
        pgm_function22[(0, 36, 0)] = 1.0
        pgm_function22[(0, 37, 0)] = 1.0
        pgm_function22[(0, 38, 0)] = 1.0
        pgm_function22[(0, 39, 0)] = 1.0
        pgm_function22[(0, 40, 0)] = 1.0
        pgm_function22[(0, 41, 0)] = 1.0
        pgm_function22[(0, 42, 0)] = 1.0
        pgm_function22[(0, 43, 0)] = 1.0
        pgm_function22[(0, 44, 0)] = 1.0
        pgm_function22[(0, 45, 0)] = 1.0
        pgm_function22[(0, 46, 0)] = 1.0
        pgm_function22[(0, 47, 0)] = 1.0
        pgm_function22[(0, 48, 0)] = 1.0
        pgm_function22[(0, 49, 0)] = 1.0
        pgm_function22[(0, 50, 0)] = 1.0
        pgm_function22[(0, 51, 0)] = 1.0
        pgm_function22[(0, 52, 0)] = 1.0
        pgm_function22[(0, 53, 0)] = 1.0
        pgm_function22[(0, 54, 0)] = 1.0
        pgm_function22[(0, 55, 0)] = 1.0
        pgm_function22[(0, 56, 0)] = 1.0
        pgm_function22[(0, 57, 0)] = 1.0
        pgm_function22[(0, 58, 0)] = 1.0
        pgm_function22[(0, 59, 0)] = 1.0
        pgm_function22[(0, 60, 0)] = 1.0
        pgm_function22[(0, 61, 0)] = 1.0
        pgm_function22[(0, 62, 0)] = 1.0
        pgm_function22[(0, 63, 0)] = 1.0
        pgm_function22[(0, 64, 0)] = 1.0
        pgm_function22[(0, 65, 0)] = 1.0
        pgm_function22[(0, 66, 0)] = 1.0
        pgm_function22[(0, 67, 0)] = 1.0
        pgm_function22[(0, 68, 0)] = 1.0
        pgm_function22[(0, 69, 0)] = 1.0
        pgm_function22[(0, 70, 0)] = 1.0
        pgm_function22[(0, 71, 0)] = 1.0
        pgm_function22[(0, 72, 0)] = 1.0
        pgm_function22[(0, 73, 0)] = 1.0
        pgm_function22[(0, 74, 0)] = 1.0
        pgm_function22[(0, 75, 0)] = 1.0
        pgm_function22[(1, 0, 1)] = 0.995
        pgm_function22[(1, 0, 2)] = 0.99
        pgm_function22[(1, 1, 1)] = 0.995
        pgm_function22[(1, 1, 2)] = 0.99
        pgm_function22[(1, 2, 1)] = 0.995
        pgm_function22[(1, 2, 2)] = 0.99
        pgm_function22[(1, 3, 1)] = 0.995
        pgm_function22[(1, 3, 2)] = 0.99
        pgm_function22[(1, 4, 1)] = 0.995
        pgm_function22[(1, 4, 2)] = 0.99
        pgm_function22[(1, 5, 1)] = 0.995
        pgm_function22[(1, 5, 2)] = 0.99
        pgm_function22[(1, 6, 1)] = 0.95
        pgm_function22[(1, 6, 2)] = 0.8
        pgm_function22[(1, 7, 1)] = 0.995
        pgm_function22[(1, 7, 2)] = 0.99
        pgm_function22[(1, 8, 1)] = 0.98
        pgm_function22[(1, 8, 2)] = 0.95
        pgm_function22[(1, 9, 1)] = 0.995
        pgm_function22[(1, 9, 2)] = 0.99
        pgm_function22[(1, 10, 1)] = 0.995
        pgm_function22[(1, 10, 2)] = 0.99
        pgm_function22[(1, 11, 1)] = 0.995
        pgm_function22[(1, 11, 2)] = 0.99
        pgm_function22[(1, 12, 1)] = 0.995
        pgm_function22[(1, 12, 2)] = 0.99
        pgm_function22[(1, 13, 1)] = 0.995
        pgm_function22[(1, 13, 2)] = 0.99
        pgm_function22[(1, 14, 1)] = 0.995
        pgm_function22[(1, 14, 2)] = 0.99
        pgm_function22[(1, 15, 1)] = 0.995
        pgm_function22[(1, 15, 2)] = 0.99
        pgm_function22[(1, 16, 1)] = 0.98
        pgm_function22[(1, 16, 2)] = 0.95
        pgm_function22[(1, 17, 1)] = 0.995
        pgm_function22[(1, 17, 2)] = 0.99
        pgm_function22[(1, 18, 1)] = 0.95
        pgm_function22[(1, 18, 2)] = 0.9
        pgm_function22[(1, 19, 1)] = 0.995
        pgm_function22[(1, 19, 2)] = 0.99
        pgm_function22[(1, 20, 1)] = 0.98
        pgm_function22[(1, 20, 2)] = 0.95
        pgm_function22[(1, 21, 1)] = 0.995
        pgm_function22[(1, 21, 2)] = 0.99
        pgm_function22[(1, 22, 1)] = 0.98
        pgm_function22[(1, 22, 2)] = 0.95
        pgm_function22[(1, 23, 1)] = 0.995
        pgm_function22[(1, 23, 2)] = 0.99
        pgm_function22[(1, 24, 1)] = 0.995
        pgm_function22[(1, 24, 2)] = 0.99
        pgm_function22[(1, 25, 1)] = 0.995
        pgm_function22[(1, 25, 2)] = 0.99
        pgm_function22[(1, 26, 1)] = 0.995
        pgm_function22[(1, 26, 2)] = 0.99
        pgm_function22[(1, 28, 1)] = 1.0
        pgm_function22[(1, 28, 2)] = 1.0
        pgm_function22[(1, 30, 1)] = 0.99
        pgm_function22[(1, 30, 2)] = 0.98
        pgm_function22[(1, 31, 1)] = 0.995
        pgm_function22[(1, 31, 2)] = 0.99
        pgm_function22[(1, 32, 1)] = 0.9
        pgm_function22[(1, 32, 2)] = 0.8
        pgm_function22[(1, 33, 1)] = 0.995
        pgm_function22[(1, 33, 2)] = 0.99
        pgm_function22[(1, 34, 1)] = 0.995
        pgm_function22[(1, 34, 2)] = 0.99
        pgm_function22[(1, 35, 1)] = 0.995
        pgm_function22[(1, 35, 2)] = 0.99
        pgm_function22[(1, 36, 1)] = 0.995
        pgm_function22[(1, 36, 2)] = 0.99
        pgm_function22[(1, 37, 1)] = 0.995
        pgm_function22[(1, 37, 2)] = 0.99
        pgm_function22[(1, 38, 1)] = 0.995
        pgm_function22[(1, 38, 2)] = 0.99
        pgm_function22[(1, 39, 1)] = 0.995
        pgm_function22[(1, 39, 2)] = 0.99
        pgm_function22[(1, 40, 1)] = 0.995
        pgm_function22[(1, 40, 2)] = 0.99
        pgm_function22[(1, 41, 1)] = 0.9
        pgm_function22[(1, 41, 2)] = 0.9
        pgm_function22[(1, 42, 1)] = 0.9
        pgm_function22[(1, 42, 2)] = 0.9
        pgm_function22[(1, 43, 1)] = 0.9
        pgm_function22[(1, 43, 2)] = 0.9
        pgm_function22[(1, 44, 1)] = 0.995
        pgm_function22[(1, 44, 2)] = 0.99
        pgm_function22[(1, 45, 1)] = 0.9
        pgm_function22[(1, 45, 2)] = 0.9
        pgm_function22[(1, 46, 1)] = 0.97
        pgm_function22[(1, 46, 2)] = 0.9
        pgm_function22[(1, 47, 1)] = 0.995
        pgm_function22[(1, 47, 2)] = 0.99
        pgm_function22[(1, 48, 1)] = 0.995
        pgm_function22[(1, 48, 2)] = 0.99
        pgm_function22[(1, 49, 1)] = 0.995
        pgm_function22[(1, 49, 2)] = 0.99
        pgm_function22[(1, 50, 1)] = 0.995
        pgm_function22[(1, 50, 2)] = 0.99
        pgm_function22[(1, 51, 1)] = 0.995
        pgm_function22[(1, 51, 2)] = 0.99
        pgm_function22[(1, 52, 1)] = 0.995
        pgm_function22[(1, 52, 2)] = 0.99
        pgm_function22[(1, 53, 1)] = 0.995
        pgm_function22[(1, 53, 2)] = 0.99
        pgm_function22[(1, 54, 1)] = 0.995
        pgm_function22[(1, 54, 2)] = 0.99
        pgm_function22[(1, 55, 1)] = 0.995
        pgm_function22[(1, 55, 2)] = 0.99
        pgm_function22[(1, 56, 1)] = 0.995
        pgm_function22[(1, 56, 2)] = 0.99
        pgm_function22[(1, 57, 1)] = 0.995
        pgm_function22[(1, 57, 2)] = 0.99
        pgm_function22[(1, 58, 1)] = 0.995
        pgm_function22[(1, 58, 2)] = 0.99
        pgm_function22[(1, 59, 1)] = 0.995
        pgm_function22[(1, 59, 2)] = 0.99
        pgm_function22[(1, 60, 1)] = 0.95
        pgm_function22[(1, 60, 2)] = 0.9
        pgm_function22[(1, 61, 1)] = 0.995
        pgm_function22[(1, 61, 2)] = 0.99
        pgm_function22[(1, 62, 1)] = 0.97
        pgm_function22[(1, 62, 2)] = 0.95
        pgm_function22[(1, 63, 1)] = 0.995
        pgm_function22[(1, 63, 2)] = 0.99
        pgm_function22[(1, 65, 1)] = 0.995
        pgm_function22[(1, 65, 2)] = 0.99
        pgm_function22[(1, 66, 1)] = 0.995
        pgm_function22[(1, 66, 2)] = 0.99
        pgm_function22[(1, 67, 1)] = 0.995
        pgm_function22[(1, 67, 2)] = 0.99
        pgm_function22[(1, 68, 1)] = 0.995
        pgm_function22[(1, 68, 2)] = 0.99
        pgm_function22[(1, 69, 1)] = 0.995
        pgm_function22[(1, 69, 2)] = 0.99
        pgm_function22[(1, 70, 1)] = 0.995
        pgm_function22[(1, 70, 2)] = 0.99
        pgm_function22[(1, 71, 1)] = 0.995
        pgm_function22[(1, 71, 2)] = 0.99
        pgm_function22[(1, 72, 1)] = 0.995
        pgm_function22[(1, 72, 2)] = 0.99
        pgm_function22[(1, 73, 1)] = 0.995
        pgm_function22[(1, 73, 2)] = 0.99
        pgm_function22[(1, 74, 1)] = 0.995
        pgm_function22[(1, 74, 2)] = 0.99
        pgm_function22[(1, 75, 1)] = 0.995
        pgm_function22[(1, 75, 2)] = 0.99
        pgm_function22[(2, 0, 1)] = 0.005
        pgm_function22[(2, 0, 2)] = 0.01
        pgm_function22[(2, 1, 1)] = 0.005
        pgm_function22[(2, 1, 2)] = 0.01
        pgm_function22[(2, 2, 1)] = 0.005
        pgm_function22[(2, 2, 2)] = 0.01
        pgm_function22[(2, 3, 1)] = 0.005
        pgm_function22[(2, 3, 2)] = 0.01
        pgm_function22[(2, 4, 1)] = 0.005
        pgm_function22[(2, 4, 2)] = 0.01
        pgm_function22[(2, 5, 1)] = 0.005
        pgm_function22[(2, 5, 2)] = 0.01
        pgm_function22[(2, 6, 1)] = 0.05
        pgm_function22[(2, 6, 2)] = 0.2
        pgm_function22[(2, 7, 1)] = 0.005
        pgm_function22[(2, 7, 2)] = 0.01
        pgm_function22[(2, 8, 1)] = 0.02
        pgm_function22[(2, 8, 2)] = 0.05
        pgm_function22[(2, 9, 1)] = 0.005
        pgm_function22[(2, 9, 2)] = 0.01
        pgm_function22[(2, 10, 1)] = 0.005
        pgm_function22[(2, 10, 2)] = 0.01
        pgm_function22[(2, 11, 1)] = 0.005
        pgm_function22[(2, 11, 2)] = 0.01
        pgm_function22[(2, 12, 1)] = 0.005
        pgm_function22[(2, 12, 2)] = 0.01
        pgm_function22[(2, 13, 1)] = 0.005
        pgm_function22[(2, 13, 2)] = 0.01
        pgm_function22[(2, 14, 1)] = 0.005
        pgm_function22[(2, 14, 2)] = 0.01
        pgm_function22[(2, 15, 1)] = 0.005
        pgm_function22[(2, 15, 2)] = 0.01
        pgm_function22[(2, 16, 1)] = 0.02
        pgm_function22[(2, 16, 2)] = 0.05
        pgm_function22[(2, 17, 1)] = 0.005
        pgm_function22[(2, 17, 2)] = 0.01
        pgm_function22[(2, 18, 1)] = 0.05
        pgm_function22[(2, 18, 2)] = 0.1
        pgm_function22[(2, 19, 1)] = 0.005
        pgm_function22[(2, 19, 2)] = 0.01
        pgm_function22[(2, 20, 1)] = 0.02
        pgm_function22[(2, 20, 2)] = 0.05
        pgm_function22[(2, 21, 1)] = 0.005
        pgm_function22[(2, 21, 2)] = 0.01
        pgm_function22[(2, 22, 1)] = 0.02
        pgm_function22[(2, 22, 2)] = 0.05
        pgm_function22[(2, 23, 1)] = 0.005
        pgm_function22[(2, 23, 2)] = 0.01
        pgm_function22[(2, 24, 1)] = 0.005
        pgm_function22[(2, 24, 2)] = 0.01
        pgm_function22[(2, 25, 1)] = 0.005
        pgm_function22[(2, 25, 2)] = 0.01
        pgm_function22[(2, 26, 1)] = 0.005
        pgm_function22[(2, 26, 2)] = 0.01
        pgm_function22[(2, 27, 1)] = 1.0
        pgm_function22[(2, 27, 2)] = 1.0
        pgm_function22[(2, 29, 1)] = 1.0
        pgm_function22[(2, 29, 2)] = 1.0
        pgm_function22[(2, 30, 1)] = 0.01
        pgm_function22[(2, 30, 2)] = 0.02
        pgm_function22[(2, 31, 1)] = 0.005
        pgm_function22[(2, 31, 2)] = 0.01
        pgm_function22[(2, 32, 1)] = 0.1
        pgm_function22[(2, 32, 2)] = 0.2
        pgm_function22[(2, 33, 1)] = 0.005
        pgm_function22[(2, 33, 2)] = 0.01
        pgm_function22[(2, 34, 1)] = 0.005
        pgm_function22[(2, 34, 2)] = 0.01
        pgm_function22[(2, 35, 1)] = 0.005
        pgm_function22[(2, 35, 2)] = 0.01
        pgm_function22[(2, 36, 1)] = 0.005
        pgm_function22[(2, 36, 2)] = 0.01
        pgm_function22[(2, 37, 1)] = 0.005
        pgm_function22[(2, 37, 2)] = 0.01
        pgm_function22[(2, 38, 1)] = 0.005
        pgm_function22[(2, 38, 2)] = 0.01
        pgm_function22[(2, 39, 1)] = 0.005
        pgm_function22[(2, 39, 2)] = 0.01
        pgm_function22[(2, 40, 1)] = 0.005
        pgm_function22[(2, 40, 2)] = 0.01
        pgm_function22[(2, 41, 1)] = 0.1
        pgm_function22[(2, 41, 2)] = 0.1
        pgm_function22[(2, 42, 1)] = 0.1
        pgm_function22[(2, 42, 2)] = 0.1
        pgm_function22[(2, 43, 1)] = 0.1
        pgm_function22[(2, 43, 2)] = 0.1
        pgm_function22[(2, 44, 1)] = 0.005
        pgm_function22[(2, 44, 2)] = 0.01
        pgm_function22[(2, 45, 1)] = 0.1
        pgm_function22[(2, 45, 2)] = 0.1
        pgm_function22[(2, 46, 1)] = 0.03
        pgm_function22[(2, 46, 2)] = 0.1
        pgm_function22[(2, 47, 1)] = 0.005
        pgm_function22[(2, 47, 2)] = 0.01
        pgm_function22[(2, 48, 1)] = 0.005
        pgm_function22[(2, 48, 2)] = 0.01
        pgm_function22[(2, 49, 1)] = 0.005
        pgm_function22[(2, 49, 2)] = 0.01
        pgm_function22[(2, 50, 1)] = 0.005
        pgm_function22[(2, 50, 2)] = 0.01
        pgm_function22[(2, 51, 1)] = 0.005
        pgm_function22[(2, 51, 2)] = 0.01
        pgm_function22[(2, 52, 1)] = 0.005
        pgm_function22[(2, 52, 2)] = 0.01
        pgm_function22[(2, 53, 1)] = 0.005
        pgm_function22[(2, 53, 2)] = 0.01
        pgm_function22[(2, 54, 1)] = 0.005
        pgm_function22[(2, 54, 2)] = 0.01
        pgm_function22[(2, 55, 1)] = 0.005
        pgm_function22[(2, 55, 2)] = 0.01
        pgm_function22[(2, 56, 1)] = 0.005
        pgm_function22[(2, 56, 2)] = 0.01
        pgm_function22[(2, 57, 1)] = 0.005
        pgm_function22[(2, 57, 2)] = 0.01
        pgm_function22[(2, 58, 1)] = 0.005
        pgm_function22[(2, 58, 2)] = 0.01
        pgm_function22[(2, 59, 1)] = 0.005
        pgm_function22[(2, 59, 2)] = 0.01
        pgm_function22[(2, 60, 1)] = 0.05
        pgm_function22[(2, 60, 2)] = 0.1
        pgm_function22[(2, 61, 1)] = 0.005
        pgm_function22[(2, 61, 2)] = 0.01
        pgm_function22[(2, 62, 1)] = 0.03
        pgm_function22[(2, 62, 2)] = 0.05
        pgm_function22[(2, 63, 1)] = 0.005
        pgm_function22[(2, 63, 2)] = 0.01
        pgm_function22[(2, 64, 1)] = 1.0
        pgm_function22[(2, 64, 2)] = 1.0
        pgm_function22[(2, 65, 1)] = 0.005
        pgm_function22[(2, 65, 2)] = 0.01
        pgm_function22[(2, 66, 1)] = 0.005
        pgm_function22[(2, 66, 2)] = 0.01
        pgm_function22[(2, 67, 1)] = 0.005
        pgm_function22[(2, 67, 2)] = 0.01
        pgm_function22[(2, 68, 1)] = 0.005
        pgm_function22[(2, 68, 2)] = 0.01
        pgm_function22[(2, 69, 1)] = 0.005
        pgm_function22[(2, 69, 2)] = 0.01
        pgm_function22[(2, 70, 1)] = 0.005
        pgm_function22[(2, 70, 2)] = 0.01
        pgm_function22[(2, 71, 1)] = 0.005
        pgm_function22[(2, 71, 2)] = 0.01
        pgm_function22[(2, 72, 1)] = 0.005
        pgm_function22[(2, 72, 2)] = 0.01
        pgm_function22[(2, 73, 1)] = 0.005
        pgm_function22[(2, 73, 2)] = 0.01
        pgm_function22[(2, 74, 1)] = 0.005
        pgm_function22[(2, 74, 2)] = 0.01
        pgm_function22[(2, 75, 1)] = 0.005
        pgm_function22[(2, 75, 2)] = 0.01

        pgm_function23 = pgm_factor23.set_sparse()
        pgm_function23[(0, 0)] = 1.0
        pgm_function23[(0, 1)] = 1.0
        pgm_function23[(0, 2)] = 1.0
        pgm_function23[(0, 3)] = 1.0
        pgm_function23[(0, 4)] = 1.0
        pgm_function23[(0, 5)] = 1.0
        pgm_function23[(0, 6)] = 1.0
        pgm_function23[(0, 7)] = 1.0
        pgm_function23[(0, 8)] = 0.95
        pgm_function23[(0, 9)] = 1.0
        pgm_function23[(0, 10)] = 1.0
        pgm_function23[(0, 11)] = 1.0
        pgm_function23[(0, 12)] = 1.0
        pgm_function23[(0, 13)] = 1.0
        pgm_function23[(0, 14)] = 1.0
        pgm_function23[(0, 15)] = 1.0
        pgm_function23[(0, 16)] = 1.0
        pgm_function23[(0, 17)] = 1.0
        pgm_function23[(0, 18)] = 1.0
        pgm_function23[(0, 19)] = 1.0
        pgm_function23[(0, 20)] = 0.95
        pgm_function23[(0, 21)] = 1.0
        pgm_function23[(0, 22)] = 0.99
        pgm_function23[(0, 23)] = 1.0
        pgm_function23[(0, 24)] = 1.0
        pgm_function23[(0, 25)] = 1.0
        pgm_function23[(0, 26)] = 1.0
        pgm_function23[(0, 27)] = 0.95
        pgm_function23[(0, 28)] = 1.0
        pgm_function23[(0, 29)] = 1.0
        pgm_function23[(0, 30)] = 0.999
        pgm_function23[(0, 31)] = 1.0
        pgm_function23[(0, 33)] = 0.999
        pgm_function23[(0, 34)] = 1.0
        pgm_function23[(0, 35)] = 1.0
        pgm_function23[(0, 36)] = 1.0
        pgm_function23[(0, 37)] = 1.0
        pgm_function23[(0, 38)] = 1.0
        pgm_function23[(0, 39)] = 1.0
        pgm_function23[(0, 40)] = 1.0
        pgm_function23[(0, 41)] = 1.0
        pgm_function23[(0, 42)] = 1.0
        pgm_function23[(0, 43)] = 1.0
        pgm_function23[(0, 44)] = 1.0
        pgm_function23[(0, 45)] = 1.0
        pgm_function23[(0, 46)] = 1.0
        pgm_function23[(0, 47)] = 1.0
        pgm_function23[(0, 48)] = 1.0
        pgm_function23[(0, 49)] = 1.0
        pgm_function23[(0, 50)] = 1.0
        pgm_function23[(0, 51)] = 1.0
        pgm_function23[(0, 52)] = 1.0
        pgm_function23[(0, 53)] = 1.0
        pgm_function23[(0, 54)] = 1.0
        pgm_function23[(0, 55)] = 1.0
        pgm_function23[(0, 56)] = 1.0
        pgm_function23[(0, 57)] = 1.0
        pgm_function23[(0, 58)] = 1.0
        pgm_function23[(0, 59)] = 0.95
        pgm_function23[(0, 60)] = 0.8
        pgm_function23[(0, 61)] = 1.0
        pgm_function23[(0, 62)] = 1.0
        pgm_function23[(0, 63)] = 1.0
        pgm_function23[(0, 64)] = 0.999
        pgm_function23[(0, 65)] = 1.0
        pgm_function23[(0, 66)] = 1.0
        pgm_function23[(0, 67)] = 1.0
        pgm_function23[(0, 68)] = 0.9
        pgm_function23[(0, 69)] = 1.0
        pgm_function23[(0, 70)] = 1.0
        pgm_function23[(0, 71)] = 1.0
        pgm_function23[(0, 72)] = 1.0
        pgm_function23[(0, 73)] = 1.0
        pgm_function23[(0, 74)] = 1.0
        pgm_function23[(0, 75)] = 1.0
        pgm_function23[(1, 8)] = 0.05
        pgm_function23[(1, 20)] = 0.05
        pgm_function23[(1, 22)] = 0.01
        pgm_function23[(1, 27)] = 0.05
        pgm_function23[(1, 30)] = 0.001
        pgm_function23[(1, 32)] = 1.0
        pgm_function23[(1, 33)] = 0.001
        pgm_function23[(1, 59)] = 0.05
        pgm_function23[(1, 60)] = 0.2
        pgm_function23[(1, 64)] = 0.001
        pgm_function23[(1, 68)] = 0.1

        pgm_function24 = pgm_factor24.set_sparse()
        pgm_function24[(0, 0)] = 1.0
        pgm_function24[(0, 1)] = 1.0
        pgm_function24[(0, 2)] = 1.0
        pgm_function24[(0, 3)] = 1.0
        pgm_function24[(0, 4)] = 1.0
        pgm_function24[(0, 5)] = 1.0
        pgm_function24[(0, 6)] = 1.0
        pgm_function24[(0, 7)] = 1.0
        pgm_function24[(0, 8)] = 1.0
        pgm_function24[(0, 9)] = 1.0
        pgm_function24[(0, 10)] = 1.0
        pgm_function24[(0, 11)] = 0.01
        pgm_function24[(0, 12)] = 1.0
        pgm_function24[(0, 13)] = 1.0
        pgm_function24[(0, 14)] = 1.0
        pgm_function24[(0, 15)] = 1.0
        pgm_function24[(0, 16)] = 1.0
        pgm_function24[(0, 17)] = 1.0
        pgm_function24[(0, 18)] = 1.0
        pgm_function24[(0, 19)] = 1.0
        pgm_function24[(0, 20)] = 1.0
        pgm_function24[(0, 21)] = 1.0
        pgm_function24[(0, 22)] = 1.0
        pgm_function24[(0, 23)] = 1.0
        pgm_function24[(0, 24)] = 1.0
        pgm_function24[(0, 25)] = 1.0
        pgm_function24[(0, 26)] = 1.0
        pgm_function24[(0, 27)] = 1.0
        pgm_function24[(0, 28)] = 1.0
        pgm_function24[(0, 29)] = 1.0
        pgm_function24[(0, 30)] = 1.0
        pgm_function24[(0, 31)] = 1.0
        pgm_function24[(0, 32)] = 1.0
        pgm_function24[(0, 33)] = 1.0
        pgm_function24[(0, 34)] = 1.0
        pgm_function24[(0, 35)] = 1.0
        pgm_function24[(0, 36)] = 1.0
        pgm_function24[(0, 37)] = 1.0
        pgm_function24[(0, 38)] = 1.0
        pgm_function24[(0, 39)] = 1.0
        pgm_function24[(0, 40)] = 1.0
        pgm_function24[(0, 41)] = 1.0
        pgm_function24[(0, 42)] = 1.0
        pgm_function24[(0, 43)] = 1.0
        pgm_function24[(0, 44)] = 1.0
        pgm_function24[(0, 45)] = 1.0
        pgm_function24[(0, 46)] = 1.0
        pgm_function24[(0, 47)] = 1.0
        pgm_function24[(0, 48)] = 1.0
        pgm_function24[(0, 49)] = 1.0
        pgm_function24[(0, 50)] = 1.0
        pgm_function24[(0, 51)] = 1.0
        pgm_function24[(0, 52)] = 1.0
        pgm_function24[(0, 53)] = 1.0
        pgm_function24[(0, 54)] = 1.0
        pgm_function24[(0, 55)] = 1.0
        pgm_function24[(0, 56)] = 1.0
        pgm_function24[(0, 57)] = 1.0
        pgm_function24[(0, 58)] = 1.0
        pgm_function24[(0, 59)] = 1.0
        pgm_function24[(0, 60)] = 1.0
        pgm_function24[(0, 61)] = 1.0
        pgm_function24[(0, 62)] = 1.0
        pgm_function24[(0, 63)] = 1.0
        pgm_function24[(0, 64)] = 1.0
        pgm_function24[(0, 65)] = 1.0
        pgm_function24[(0, 66)] = 1.0
        pgm_function24[(0, 67)] = 1.0
        pgm_function24[(0, 68)] = 1.0
        pgm_function24[(0, 69)] = 1.0
        pgm_function24[(0, 70)] = 1.0
        pgm_function24[(0, 71)] = 1.0
        pgm_function24[(0, 72)] = 1.0
        pgm_function24[(0, 73)] = 1.0
        pgm_function24[(0, 74)] = 1.0
        pgm_function24[(0, 75)] = 1.0
        pgm_function24[(1, 11)] = 0.99

        pgm_function25 = pgm_factor25.set_sparse()
        pgm_function25[(0, 0)] = 0.999
        pgm_function25[(0, 1)] = 0.99
        pgm_function25[(0, 2)] = 0.999
        pgm_function25[(0, 3)] = 0.88
        pgm_function25[(0, 4)] = 0.999
        pgm_function25[(0, 5)] = 0.999
        pgm_function25[(0, 6)] = 0.999
        pgm_function25[(0, 7)] = 0.999
        pgm_function25[(0, 8)] = 0.4
        pgm_function25[(0, 9)] = 0.93
        pgm_function25[(0, 10)] = 0.999
        pgm_function25[(0, 11)] = 0.87
        pgm_function25[(0, 12)] = 0.01
        pgm_function25[(0, 13)] = 0.999
        pgm_function25[(0, 14)] = 0.999
        pgm_function25[(0, 15)] = 0.94
        pgm_function25[(0, 16)] = 0.999
        pgm_function25[(0, 17)] = 0.9
        pgm_function25[(0, 18)] = 0.999
        pgm_function25[(0, 19)] = 0.999
        pgm_function25[(0, 20)] = 0.88
        pgm_function25[(0, 21)] = 0.999
        pgm_function25[(0, 22)] = 0.87
        pgm_function25[(0, 23)] = 0.999
        pgm_function25[(0, 24)] = 0.01
        pgm_function25[(0, 25)] = 0.999
        pgm_function25[(0, 26)] = 0.999
        pgm_function25[(0, 27)] = 0.999
        pgm_function25[(0, 28)] = 0.999
        pgm_function25[(0, 29)] = 0.999
        pgm_function25[(0, 30)] = 0.95
        pgm_function25[(0, 31)] = 0.999
        pgm_function25[(0, 32)] = 0.999
        pgm_function25[(0, 33)] = 0.999
        pgm_function25[(0, 34)] = 0.999
        pgm_function25[(0, 35)] = 0.999
        pgm_function25[(0, 36)] = 0.999
        pgm_function25[(0, 37)] = 0.999
        pgm_function25[(0, 38)] = 0.999
        pgm_function25[(0, 39)] = 0.999
        pgm_function25[(0, 40)] = 0.999
        pgm_function25[(0, 41)] = 0.999
        pgm_function25[(0, 42)] = 0.999
        pgm_function25[(0, 43)] = 0.999
        pgm_function25[(0, 44)] = 0.999
        pgm_function25[(0, 45)] = 0.999
        pgm_function25[(0, 46)] = 0.99
        pgm_function25[(0, 47)] = 0.999
        pgm_function25[(0, 48)] = 0.999
        pgm_function25[(0, 49)] = 0.999
        pgm_function25[(0, 50)] = 0.999
        pgm_function25[(0, 51)] = 0.999
        pgm_function25[(0, 52)] = 0.999
        pgm_function25[(0, 53)] = 0.999
        pgm_function25[(0, 54)] = 0.999
        pgm_function25[(0, 55)] = 0.999
        pgm_function25[(0, 56)] = 0.999
        pgm_function25[(0, 57)] = 0.999
        pgm_function25[(0, 58)] = 0.999
        pgm_function25[(0, 59)] = 0.999
        pgm_function25[(0, 60)] = 0.97
        pgm_function25[(0, 61)] = 0.999
        pgm_function25[(0, 62)] = 0.999
        pgm_function25[(0, 63)] = 0.999
        pgm_function25[(0, 64)] = 0.999
        pgm_function25[(0, 65)] = 0.999
        pgm_function25[(0, 66)] = 0.999
        pgm_function25[(0, 67)] = 0.88
        pgm_function25[(0, 68)] = 0.97
        pgm_function25[(0, 69)] = 0.88
        pgm_function25[(0, 70)] = 0.88
        pgm_function25[(0, 71)] = 0.88
        pgm_function25[(0, 72)] = 0.88
        pgm_function25[(0, 73)] = 0.999
        pgm_function25[(0, 74)] = 0.999
        pgm_function25[(0, 75)] = 0.999
        pgm_function25[(1, 0)] = 0.001
        pgm_function25[(1, 1)] = 0.01
        pgm_function25[(1, 2)] = 0.001
        pgm_function25[(1, 3)] = 0.1
        pgm_function25[(1, 4)] = 0.001
        pgm_function25[(1, 5)] = 0.001
        pgm_function25[(1, 6)] = 0.001
        pgm_function25[(1, 7)] = 0.001
        pgm_function25[(1, 8)] = 0.35
        pgm_function25[(1, 9)] = 0.05
        pgm_function25[(1, 10)] = 0.001
        pgm_function25[(1, 11)] = 0.1
        pgm_function25[(1, 12)] = 0.29
        pgm_function25[(1, 13)] = 0.001
        pgm_function25[(1, 14)] = 0.001
        pgm_function25[(1, 15)] = 0.05
        pgm_function25[(1, 16)] = 0.001
        pgm_function25[(1, 17)] = 0.09
        pgm_function25[(1, 18)] = 0.001
        pgm_function25[(1, 19)] = 0.001
        pgm_function25[(1, 20)] = 0.1
        pgm_function25[(1, 21)] = 0.001
        pgm_function25[(1, 22)] = 0.1
        pgm_function25[(1, 23)] = 0.001
        pgm_function25[(1, 24)] = 0.29
        pgm_function25[(1, 25)] = 0.001
        pgm_function25[(1, 26)] = 0.001
        pgm_function25[(1, 27)] = 0.001
        pgm_function25[(1, 28)] = 0.001
        pgm_function25[(1, 29)] = 0.001
        pgm_function25[(1, 30)] = 0.04
        pgm_function25[(1, 31)] = 0.001
        pgm_function25[(1, 32)] = 0.001
        pgm_function25[(1, 33)] = 0.001
        pgm_function25[(1, 34)] = 0.001
        pgm_function25[(1, 35)] = 0.001
        pgm_function25[(1, 36)] = 0.001
        pgm_function25[(1, 37)] = 0.001
        pgm_function25[(1, 38)] = 0.001
        pgm_function25[(1, 39)] = 0.001
        pgm_function25[(1, 40)] = 0.001
        pgm_function25[(1, 41)] = 0.001
        pgm_function25[(1, 42)] = 0.001
        pgm_function25[(1, 43)] = 0.001
        pgm_function25[(1, 44)] = 0.001
        pgm_function25[(1, 45)] = 0.001
        pgm_function25[(1, 46)] = 0.01
        pgm_function25[(1, 47)] = 0.001
        pgm_function25[(1, 48)] = 0.001
        pgm_function25[(1, 49)] = 0.001
        pgm_function25[(1, 50)] = 0.001
        pgm_function25[(1, 51)] = 0.001
        pgm_function25[(1, 52)] = 0.001
        pgm_function25[(1, 53)] = 0.001
        pgm_function25[(1, 54)] = 0.001
        pgm_function25[(1, 55)] = 0.001
        pgm_function25[(1, 56)] = 0.001
        pgm_function25[(1, 57)] = 0.001
        pgm_function25[(1, 58)] = 0.001
        pgm_function25[(1, 59)] = 0.001
        pgm_function25[(1, 60)] = 0.02
        pgm_function25[(1, 61)] = 0.001
        pgm_function25[(1, 62)] = 0.001
        pgm_function25[(1, 63)] = 0.001
        pgm_function25[(1, 64)] = 0.001
        pgm_function25[(1, 65)] = 0.001
        pgm_function25[(1, 66)] = 0.001
        pgm_function25[(1, 67)] = 0.1
        pgm_function25[(1, 68)] = 0.02
        pgm_function25[(1, 69)] = 0.1
        pgm_function25[(1, 70)] = 0.1
        pgm_function25[(1, 71)] = 0.1
        pgm_function25[(1, 72)] = 0.1
        pgm_function25[(1, 73)] = 0.001
        pgm_function25[(1, 74)] = 0.001
        pgm_function25[(1, 75)] = 0.001
        pgm_function25[(2, 3)] = 0.02
        pgm_function25[(2, 8)] = 0.25
        pgm_function25[(2, 9)] = 0.02
        pgm_function25[(2, 11)] = 0.03
        pgm_function25[(2, 12)] = 0.7
        pgm_function25[(2, 15)] = 0.01
        pgm_function25[(2, 17)] = 0.01
        pgm_function25[(2, 20)] = 0.02
        pgm_function25[(2, 22)] = 0.03
        pgm_function25[(2, 24)] = 0.7
        pgm_function25[(2, 30)] = 0.01
        pgm_function25[(2, 60)] = 0.01
        pgm_function25[(2, 67)] = 0.02
        pgm_function25[(2, 68)] = 0.01
        pgm_function25[(2, 69)] = 0.02
        pgm_function25[(2, 70)] = 0.02
        pgm_function25[(2, 71)] = 0.02
        pgm_function25[(2, 72)] = 0.02

        pgm_function26 = pgm_factor26.set_sparse()
        pgm_function26[(0, 0)] = 1.0
        pgm_function26[(0, 1)] = 0.4
        pgm_function26[(0, 2)] = 1.0
        pgm_function26[(0, 3)] = 1.0
        pgm_function26[(0, 4)] = 1.0
        pgm_function26[(0, 5)] = 1.0
        pgm_function26[(0, 6)] = 1.0
        pgm_function26[(0, 7)] = 1.0
        pgm_function26[(0, 8)] = 1.0
        pgm_function26[(0, 9)] = 1.0
        pgm_function26[(0, 10)] = 1.0
        pgm_function26[(0, 11)] = 1.0
        pgm_function26[(0, 12)] = 1.0
        pgm_function26[(0, 13)] = 1.0
        pgm_function26[(0, 14)] = 1.0
        pgm_function26[(0, 15)] = 1.0
        pgm_function26[(0, 16)] = 1.0
        pgm_function26[(0, 17)] = 1.0
        pgm_function26[(0, 18)] = 1.0
        pgm_function26[(0, 19)] = 1.0
        pgm_function26[(0, 20)] = 1.0
        pgm_function26[(0, 21)] = 1.0
        pgm_function26[(0, 22)] = 1.0
        pgm_function26[(0, 23)] = 1.0
        pgm_function26[(0, 24)] = 1.0
        pgm_function26[(0, 25)] = 1.0
        pgm_function26[(0, 26)] = 0.95
        pgm_function26[(0, 27)] = 0.95
        pgm_function26[(0, 28)] = 0.95
        pgm_function26[(0, 29)] = 0.95
        pgm_function26[(0, 30)] = 0.95
        pgm_function26[(0, 31)] = 0.95
        pgm_function26[(0, 32)] = 0.95
        pgm_function26[(0, 33)] = 0.95
        pgm_function26[(0, 34)] = 1.0
        pgm_function26[(0, 35)] = 1.0
        pgm_function26[(0, 36)] = 1.0
        pgm_function26[(0, 37)] = 1.0
        pgm_function26[(0, 38)] = 1.0
        pgm_function26[(0, 39)] = 1.0
        pgm_function26[(0, 40)] = 1.0
        pgm_function26[(0, 41)] = 1.0
        pgm_function26[(0, 42)] = 1.0
        pgm_function26[(0, 43)] = 1.0
        pgm_function26[(0, 44)] = 1.0
        pgm_function26[(0, 49)] = 1.0
        pgm_function26[(0, 50)] = 1.0
        pgm_function26[(0, 52)] = 1.0
        pgm_function26[(0, 54)] = 1.0
        pgm_function26[(0, 55)] = 1.0
        pgm_function26[(0, 56)] = 1.0
        pgm_function26[(0, 57)] = 1.0
        pgm_function26[(0, 58)] = 1.0
        pgm_function26[(0, 59)] = 1.0
        pgm_function26[(0, 60)] = 1.0
        pgm_function26[(0, 61)] = 1.0
        pgm_function26[(0, 63)] = 1.0
        pgm_function26[(0, 64)] = 1.0
        pgm_function26[(0, 65)] = 1.0
        pgm_function26[(0, 66)] = 1.0
        pgm_function26[(0, 67)] = 1.0
        pgm_function26[(0, 68)] = 1.0
        pgm_function26[(0, 69)] = 1.0
        pgm_function26[(0, 70)] = 1.0
        pgm_function26[(0, 71)] = 1.0
        pgm_function26[(0, 72)] = 1.0
        pgm_function26[(0, 73)] = 1.0
        pgm_function26[(0, 74)] = 1.0
        pgm_function26[(0, 75)] = 1.0
        pgm_function26[(1, 1)] = 0.6
        pgm_function26[(1, 26)] = 0.05
        pgm_function26[(1, 27)] = 0.05
        pgm_function26[(1, 28)] = 0.05
        pgm_function26[(1, 29)] = 0.05
        pgm_function26[(1, 30)] = 0.05
        pgm_function26[(1, 31)] = 0.05
        pgm_function26[(1, 32)] = 0.05
        pgm_function26[(1, 33)] = 0.05
        pgm_function26[(1, 45)] = 1.0
        pgm_function26[(1, 46)] = 1.0
        pgm_function26[(1, 47)] = 1.0
        pgm_function26[(1, 48)] = 1.0
        pgm_function26[(1, 51)] = 1.0
        pgm_function26[(1, 53)] = 1.0
        pgm_function26[(1, 62)] = 1.0

        pgm_function27 = pgm_factor27.set_sparse()
        pgm_function27[(0, 0)] = 1.0
        pgm_function27[(0, 1)] = 1.0
        pgm_function27[(0, 2)] = 1.0
        pgm_function27[(0, 3)] = 1.0
        pgm_function27[(0, 4)] = 1.0
        pgm_function27[(0, 5)] = 1.0
        pgm_function27[(0, 6)] = 1.0
        pgm_function27[(0, 7)] = 1.0
        pgm_function27[(0, 8)] = 1.0
        pgm_function27[(0, 9)] = 1.0
        pgm_function27[(0, 10)] = 1.0
        pgm_function27[(0, 11)] = 1.0
        pgm_function27[(0, 12)] = 1.0
        pgm_function27[(0, 13)] = 1.0
        pgm_function27[(0, 14)] = 1.0
        pgm_function27[(0, 15)] = 1.0
        pgm_function27[(0, 16)] = 1.0
        pgm_function27[(0, 17)] = 1.0
        pgm_function27[(0, 18)] = 1.0
        pgm_function27[(0, 19)] = 1.0
        pgm_function27[(0, 20)] = 1.0
        pgm_function27[(0, 21)] = 1.0
        pgm_function27[(0, 22)] = 1.0
        pgm_function27[(0, 23)] = 1.0
        pgm_function27[(0, 24)] = 1.0
        pgm_function27[(0, 25)] = 1.0
        pgm_function27[(0, 26)] = 1.0
        pgm_function27[(0, 27)] = 1.0
        pgm_function27[(0, 28)] = 1.0
        pgm_function27[(0, 29)] = 1.0
        pgm_function27[(0, 30)] = 1.0
        pgm_function27[(0, 31)] = 1.0
        pgm_function27[(0, 32)] = 1.0
        pgm_function27[(0, 33)] = 1.0
        pgm_function27[(0, 34)] = 1.0
        pgm_function27[(0, 35)] = 1.0
        pgm_function27[(0, 36)] = 1.0
        pgm_function27[(0, 37)] = 1.0
        pgm_function27[(0, 38)] = 1.0
        pgm_function27[(0, 39)] = 1.0
        pgm_function27[(0, 40)] = 1.0
        pgm_function27[(0, 41)] = 1.0
        pgm_function27[(0, 42)] = 1.0
        pgm_function27[(0, 43)] = 1.0
        pgm_function27[(0, 44)] = 1.0
        pgm_function27[(0, 45)] = 1.0
        pgm_function27[(0, 46)] = 1.0
        pgm_function27[(0, 47)] = 1.0
        pgm_function27[(0, 48)] = 1.0
        pgm_function27[(0, 49)] = 1.0
        pgm_function27[(0, 50)] = 1.0
        pgm_function27[(0, 51)] = 1.0
        pgm_function27[(0, 52)] = 1.0
        pgm_function27[(0, 53)] = 1.0
        pgm_function27[(0, 54)] = 1.0
        pgm_function27[(0, 56)] = 1.0
        pgm_function27[(0, 57)] = 1.0
        pgm_function27[(0, 58)] = 1.0
        pgm_function27[(0, 59)] = 1.0
        pgm_function27[(0, 60)] = 1.0
        pgm_function27[(0, 61)] = 1.0
        pgm_function27[(0, 62)] = 1.0
        pgm_function27[(0, 63)] = 1.0
        pgm_function27[(0, 64)] = 1.0
        pgm_function27[(0, 65)] = 1.0
        pgm_function27[(0, 66)] = 1.0
        pgm_function27[(0, 67)] = 1.0
        pgm_function27[(0, 68)] = 1.0
        pgm_function27[(0, 69)] = 1.0
        pgm_function27[(0, 70)] = 1.0
        pgm_function27[(0, 71)] = 1.0
        pgm_function27[(0, 72)] = 1.0
        pgm_function27[(0, 73)] = 1.0
        pgm_function27[(0, 74)] = 1.0
        pgm_function27[(0, 75)] = 1.0
        pgm_function27[(1, 55)] = 1.0

        pgm_function28 = pgm_factor28.set_dense()
        pgm_function28.set_flat(
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.001, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.999, 0.999, 0.999, 0.999,
            0.999, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.999, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001, 0.001, 0.001, 0.001,
            0.001, 0.001
        )

        pgm_function29 = pgm_factor29.set_dense()
        pgm_function29.set_flat(
            0.9999, 0.0001, 0.0001, 0.0001, 0.9999,
            0.9999
        )

        pgm_function30 = pgm_factor30.set_sparse()
        pgm_function30[(0, 0, 1)] = 0.3333333
        pgm_function30[(0, 0, 2)] = 0.6
        pgm_function30[(0, 0, 3)] = 0.99
        pgm_function30[(0, 0, 4)] = 0.999
        pgm_function30[(0, 1, 2)] = 0.3333333
        pgm_function30[(0, 1, 3)] = 0.3333333
        pgm_function30[(0, 1, 4)] = 0.3333333
        pgm_function30[(0, 2, 2)] = 0.3333333
        pgm_function30[(0, 2, 3)] = 0.3333333
        pgm_function30[(0, 2, 4)] = 0.3333333
        pgm_function30[(0, 3, 1)] = 0.01
        pgm_function30[(0, 3, 2)] = 0.5
        pgm_function30[(0, 3, 3)] = 0.3333333
        pgm_function30[(0, 3, 4)] = 0.3333333
        pgm_function30[(0, 4, 1)] = 0.01
        pgm_function30[(0, 4, 2)] = 0.5
        pgm_function30[(0, 4, 3)] = 0.95
        pgm_function30[(0, 4, 4)] = 0.3333333
        pgm_function30[(0, 5, 1)] = 0.3333333
        pgm_function30[(0, 5, 2)] = 0.6
        pgm_function30[(0, 5, 3)] = 0.99
        pgm_function30[(0, 5, 4)] = 0.999
        pgm_function30[(0, 6, 1)] = 0.01
        pgm_function30[(0, 6, 2)] = 0.5
        pgm_function30[(0, 6, 3)] = 0.95
        pgm_function30[(0, 6, 4)] = 0.3333333
        pgm_function30[(0, 7, 1)] = 0.01
        pgm_function30[(0, 7, 2)] = 0.5
        pgm_function30[(0, 7, 3)] = 0.95
        pgm_function30[(0, 7, 4)] = 0.999
        pgm_function30[(0, 8, 1)] = 0.01
        pgm_function30[(0, 8, 2)] = 0.5
        pgm_function30[(0, 8, 3)] = 0.3333333
        pgm_function30[(0, 8, 4)] = 0.3333333
        pgm_function30[(0, 9, 1)] = 0.02
        pgm_function30[(0, 9, 2)] = 0.5
        pgm_function30[(0, 9, 3)] = 0.3333333
        pgm_function30[(0, 9, 4)] = 0.3333333
        pgm_function30[(0, 10, 1)] = 0.05
        pgm_function30[(0, 10, 2)] = 0.15
        pgm_function30[(0, 10, 3)] = 0.95
        pgm_function30[(0, 10, 4)] = 0.3333333
        pgm_function30[(0, 11, 1)] = 0.02
        pgm_function30[(0, 11, 2)] = 0.1
        pgm_function30[(0, 11, 3)] = 0.3333333
        pgm_function30[(0, 11, 4)] = 0.3333333
        pgm_function30[(0, 12, 1)] = 0.01
        pgm_function30[(0, 12, 2)] = 0.5
        pgm_function30[(0, 12, 3)] = 0.95
        pgm_function30[(0, 12, 4)] = 0.3333333
        pgm_function30[(0, 13, 1)] = 0.9
        pgm_function30[(0, 13, 2)] = 0.95
        pgm_function30[(0, 13, 3)] = 0.99
        pgm_function30[(0, 13, 4)] = 0.999
        pgm_function30[(0, 14, 1)] = 0.01
        pgm_function30[(0, 14, 2)] = 0.5
        pgm_function30[(0, 14, 3)] = 0.3333333
        pgm_function30[(0, 14, 4)] = 0.3333333
        pgm_function30[(0, 15, 1)] = 0.01
        pgm_function30[(0, 15, 2)] = 0.5
        pgm_function30[(0, 15, 3)] = 0.3333333
        pgm_function30[(0, 15, 4)] = 0.3333333
        pgm_function30[(0, 16, 1)] = 0.01
        pgm_function30[(0, 16, 2)] = 0.5
        pgm_function30[(0, 16, 3)] = 0.95
        pgm_function30[(0, 16, 4)] = 0.999
        pgm_function30[(0, 17, 1)] = 0.02
        pgm_function30[(0, 17, 2)] = 0.1
        pgm_function30[(0, 17, 3)] = 0.3333333
        pgm_function30[(0, 17, 4)] = 0.3333333
        pgm_function30[(0, 18, 1)] = 0.969
        pgm_function30[(0, 18, 2)] = 0.99
        pgm_function30[(0, 18, 3)] = 0.3333333
        pgm_function30[(0, 18, 4)] = 0.3333333
        pgm_function30[(0, 19, 1)] = 0.969
        pgm_function30[(0, 19, 2)] = 0.99
        pgm_function30[(0, 19, 3)] = 0.3333333
        pgm_function30[(0, 19, 4)] = 0.3333333
        pgm_function30[(0, 20, 1)] = 0.01
        pgm_function30[(0, 20, 2)] = 0.5
        pgm_function30[(0, 20, 3)] = 0.3333333
        pgm_function30[(0, 20, 4)] = 0.3333333
        pgm_function30[(0, 21, 1)] = 0.01
        pgm_function30[(0, 21, 2)] = 0.5
        pgm_function30[(0, 21, 3)] = 0.3333333
        pgm_function30[(0, 21, 4)] = 0.3333333
        pgm_function30[(0, 22, 1)] = 0.02
        pgm_function30[(0, 22, 2)] = 0.1
        pgm_function30[(0, 22, 3)] = 0.3333333
        pgm_function30[(0, 22, 4)] = 0.3333333
        pgm_function30[(0, 23, 1)] = 0.05
        pgm_function30[(0, 23, 2)] = 0.15
        pgm_function30[(0, 23, 3)] = 0.3333333
        pgm_function30[(0, 23, 4)] = 0.3333333
        pgm_function30[(0, 24, 1)] = 0.01
        pgm_function30[(0, 24, 2)] = 0.5
        pgm_function30[(0, 24, 3)] = 0.3333333
        pgm_function30[(0, 24, 4)] = 0.3333333
        pgm_function30[(0, 25, 1)] = 0.05
        pgm_function30[(0, 25, 2)] = 0.3333333
        pgm_function30[(0, 25, 3)] = 0.3333333
        pgm_function30[(0, 25, 4)] = 0.3333333
        pgm_function30[(0, 26, 1)] = 0.05
        pgm_function30[(0, 26, 2)] = 0.3333333
        pgm_function30[(0, 26, 3)] = 0.3333333
        pgm_function30[(0, 26, 4)] = 0.3333333
        pgm_function30[(0, 27, 1)] = 0.01
        pgm_function30[(0, 27, 2)] = 0.01
        pgm_function30[(0, 27, 3)] = 0.3333333
        pgm_function30[(0, 27, 4)] = 0.3333333
        pgm_function30[(0, 28, 1)] = 0.01
        pgm_function30[(0, 28, 2)] = 0.01
        pgm_function30[(0, 28, 3)] = 0.3333333
        pgm_function30[(0, 28, 4)] = 0.3333333
        pgm_function30[(0, 29, 1)] = 0.01
        pgm_function30[(0, 29, 2)] = 0.01
        pgm_function30[(0, 29, 3)] = 0.3333333
        pgm_function30[(0, 29, 4)] = 0.3333333
        pgm_function30[(0, 30, 1)] = 0.01
        pgm_function30[(0, 30, 2)] = 0.01
        pgm_function30[(0, 30, 3)] = 0.3333333
        pgm_function30[(0, 30, 4)] = 0.3333333
        pgm_function30[(0, 31, 1)] = 0.1
        pgm_function30[(0, 31, 2)] = 0.1
        pgm_function30[(0, 31, 3)] = 0.95
        pgm_function30[(0, 31, 4)] = 0.3333333
        pgm_function30[(0, 32, 2)] = 0.3333333
        pgm_function30[(0, 32, 3)] = 0.3333333
        pgm_function30[(0, 32, 4)] = 0.3333333
        pgm_function30[(0, 33, 2)] = 0.3333333
        pgm_function30[(0, 33, 3)] = 0.3333333
        pgm_function30[(0, 33, 4)] = 0.3333333
        pgm_function30[(0, 34, 1)] = 0.45
        pgm_function30[(0, 34, 2)] = 0.5
        pgm_function30[(0, 34, 3)] = 0.99
        pgm_function30[(0, 34, 4)] = 0.999
        pgm_function30[(0, 35, 1)] = 0.45
        pgm_function30[(0, 35, 2)] = 0.5
        pgm_function30[(0, 35, 3)] = 0.99
        pgm_function30[(0, 35, 4)] = 0.999
        pgm_function30[(0, 36, 1)] = 0.45
        pgm_function30[(0, 36, 2)] = 0.5
        pgm_function30[(0, 36, 3)] = 0.99
        pgm_function30[(0, 36, 4)] = 0.999
        pgm_function30[(0, 37, 1)] = 0.45
        pgm_function30[(0, 37, 2)] = 0.5
        pgm_function30[(0, 37, 3)] = 0.99
        pgm_function30[(0, 37, 4)] = 0.999
        pgm_function30[(0, 38, 3)] = 0.3333333
        pgm_function30[(0, 38, 4)] = 0.3333333
        pgm_function30[(0, 39, 3)] = 0.3333333
        pgm_function30[(0, 39, 4)] = 0.3333333
        pgm_function30[(0, 40, 1)] = 0.01
        pgm_function30[(0, 40, 2)] = 0.25
        pgm_function30[(0, 40, 3)] = 0.75
        pgm_function30[(0, 40, 4)] = 0.3333333
        pgm_function30[(0, 41, 2)] = 0.3333333
        pgm_function30[(0, 41, 3)] = 0.3333333
        pgm_function30[(0, 41, 4)] = 0.3333333
        pgm_function30[(0, 42, 2)] = 0.3333333
        pgm_function30[(0, 42, 3)] = 0.3333333
        pgm_function30[(0, 42, 4)] = 0.3333333
        pgm_function30[(0, 43, 2)] = 0.3333333
        pgm_function30[(0, 43, 3)] = 0.3333333
        pgm_function30[(0, 43, 4)] = 0.3333333
        pgm_function30[(0, 44, 2)] = 0.3333333
        pgm_function30[(0, 44, 3)] = 0.3333333
        pgm_function30[(0, 44, 4)] = 0.3333333
        pgm_function30[(0, 45, 2)] = 0.3333333
        pgm_function30[(0, 45, 3)] = 0.3333333
        pgm_function30[(0, 45, 4)] = 0.3333333
        pgm_function30[(0, 46, 2)] = 0.3333333
        pgm_function30[(0, 46, 3)] = 0.3333333
        pgm_function30[(0, 46, 4)] = 0.3333333
        pgm_function30[(0, 47, 2)] = 0.3333333
        pgm_function30[(0, 47, 3)] = 0.3333333
        pgm_function30[(0, 47, 4)] = 0.3333333
        pgm_function30[(0, 48, 3)] = 0.3333333
        pgm_function30[(0, 48, 4)] = 0.3333333
        pgm_function30[(0, 49, 2)] = 0.3333333
        pgm_function30[(0, 49, 3)] = 0.3333333
        pgm_function30[(0, 49, 4)] = 0.3333333
        pgm_function30[(0, 50, 2)] = 0.3333333
        pgm_function30[(0, 50, 3)] = 0.3333333
        pgm_function30[(0, 50, 4)] = 0.3333333
        pgm_function30[(0, 51, 1)] = 0.001
        pgm_function30[(0, 51, 2)] = 0.01
        pgm_function30[(0, 51, 3)] = 0.3333333
        pgm_function30[(0, 51, 4)] = 0.3333333
        pgm_function30[(0, 52, 1)] = 0.45
        pgm_function30[(0, 52, 2)] = 0.55
        pgm_function30[(0, 52, 3)] = 0.99
        pgm_function30[(0, 52, 4)] = 0.3333333
        pgm_function30[(0, 53, 1)] = 0.45
        pgm_function30[(0, 53, 2)] = 0.55
        pgm_function30[(0, 53, 3)] = 0.99
        pgm_function30[(0, 53, 4)] = 0.3333333
        pgm_function30[(0, 54, 1)] = 0.45
        pgm_function30[(0, 54, 2)] = 0.55
        pgm_function30[(0, 54, 3)] = 0.99
        pgm_function30[(0, 54, 4)] = 0.3333333
        pgm_function30[(0, 55, 1)] = 0.45
        pgm_function30[(0, 55, 2)] = 0.55
        pgm_function30[(0, 55, 3)] = 0.99
        pgm_function30[(0, 55, 4)] = 0.3333333
        pgm_function30[(0, 56, 1)] = 0.45
        pgm_function30[(0, 56, 2)] = 0.55
        pgm_function30[(0, 56, 3)] = 0.99
        pgm_function30[(0, 56, 4)] = 0.3333333
        pgm_function30[(0, 57, 1)] = 0.45
        pgm_function30[(0, 57, 2)] = 0.55
        pgm_function30[(0, 57, 3)] = 0.99
        pgm_function30[(0, 57, 4)] = 0.3333333
        pgm_function30[(0, 58, 2)] = 0.01
        pgm_function30[(0, 58, 3)] = 0.3333333
        pgm_function30[(0, 58, 4)] = 0.3333333
        pgm_function30[(0, 59, 1)] = 0.2
        pgm_function30[(0, 59, 2)] = 0.4
        pgm_function30[(0, 59, 3)] = 0.95
        pgm_function30[(0, 59, 4)] = 0.3333333
        pgm_function30[(0, 60, 2)] = 0.05
        pgm_function30[(0, 60, 3)] = 0.3333333
        pgm_function30[(0, 60, 4)] = 0.3333333
        pgm_function30[(0, 61, 1)] = 0.01
        pgm_function30[(0, 61, 2)] = 0.5
        pgm_function30[(0, 61, 3)] = 0.3333333
        pgm_function30[(0, 61, 4)] = 0.3333333
        pgm_function30[(0, 62, 2)] = 0.3333333
        pgm_function30[(0, 62, 3)] = 0.3333333
        pgm_function30[(0, 62, 4)] = 0.3333333
        pgm_function30[(0, 63, 2)] = 0.01
        pgm_function30[(0, 63, 3)] = 0.95
        pgm_function30[(0, 63, 4)] = 0.999
        pgm_function30[(0, 64, 1)] = 0.45
        pgm_function30[(0, 64, 2)] = 0.55
        pgm_function30[(0, 64, 3)] = 0.3333333
        pgm_function30[(0, 64, 4)] = 0.3333333
        pgm_function30[(0, 65, 1)] = 0.45
        pgm_function30[(0, 65, 2)] = 0.55
        pgm_function30[(0, 65, 3)] = 0.99
        pgm_function30[(0, 65, 4)] = 0.3333333
        pgm_function30[(0, 66, 1)] = 0.05
        pgm_function30[(0, 66, 2)] = 0.15
        pgm_function30[(0, 66, 3)] = 0.3333333
        pgm_function30[(0, 66, 4)] = 0.3333333
        pgm_function30[(0, 67, 1)] = 0.01
        pgm_function30[(0, 67, 2)] = 0.5
        pgm_function30[(0, 67, 3)] = 0.3333333
        pgm_function30[(0, 67, 4)] = 0.3333333
        pgm_function30[(0, 68, 1)] = 0.01
        pgm_function30[(0, 68, 2)] = 0.5
        pgm_function30[(0, 68, 3)] = 0.95
        pgm_function30[(0, 68, 4)] = 0.3333333
        pgm_function30[(0, 69, 1)] = 0.01
        pgm_function30[(0, 69, 2)] = 0.5
        pgm_function30[(0, 69, 3)] = 0.3333333
        pgm_function30[(0, 69, 4)] = 0.3333333
        pgm_function30[(0, 70, 1)] = 0.01
        pgm_function30[(0, 70, 2)] = 0.5
        pgm_function30[(0, 70, 3)] = 0.95
        pgm_function30[(0, 70, 4)] = 0.3333333
        pgm_function30[(0, 71, 1)] = 0.01
        pgm_function30[(0, 71, 2)] = 0.5
        pgm_function30[(0, 71, 3)] = 0.95
        pgm_function30[(0, 71, 4)] = 0.3333333
        pgm_function30[(0, 72, 1)] = 0.01
        pgm_function30[(0, 72, 2)] = 0.5
        pgm_function30[(0, 72, 3)] = 0.95
        pgm_function30[(0, 72, 4)] = 0.3333333
        pgm_function30[(0, 73, 1)] = 0.01
        pgm_function30[(0, 73, 2)] = 0.5
        pgm_function30[(0, 73, 3)] = 0.3333333
        pgm_function30[(0, 73, 4)] = 0.3333333
        pgm_function30[(0, 74, 1)] = 0.001
        pgm_function30[(0, 74, 2)] = 0.01
        pgm_function30[(0, 74, 3)] = 0.3333333
        pgm_function30[(0, 74, 4)] = 0.3333333
        pgm_function30[(0, 75, 1)] = 0.01
        pgm_function30[(0, 75, 2)] = 0.3333333
        pgm_function30[(0, 75, 3)] = 0.3333333
        pgm_function30[(0, 75, 4)] = 0.3333333
        pgm_function30[(1, 0, 1)] = 0.3333333
        pgm_function30[(1, 0, 2)] = 0.39
        pgm_function30[(1, 0, 3)] = 0.01
        pgm_function30[(1, 0, 4)] = 0.001
        pgm_function30[(1, 1, 2)] = 0.3333333
        pgm_function30[(1, 1, 3)] = 0.3333333
        pgm_function30[(1, 1, 4)] = 0.3333333
        pgm_function30[(1, 2, 2)] = 0.3333333
        pgm_function30[(1, 2, 3)] = 0.3333333
        pgm_function30[(1, 2, 4)] = 0.3333333
        pgm_function30[(1, 3, 1)] = 0.74
        pgm_function30[(1, 3, 2)] = 0.49
        pgm_function30[(1, 3, 3)] = 0.3333333
        pgm_function30[(1, 3, 4)] = 0.3333333
        pgm_function30[(1, 4, 1)] = 0.84
        pgm_function30[(1, 4, 2)] = 0.49
        pgm_function30[(1, 4, 3)] = 0.05
        pgm_function30[(1, 4, 4)] = 0.3333333
        pgm_function30[(1, 5, 1)] = 0.3333333
        pgm_function30[(1, 5, 2)] = 0.39
        pgm_function30[(1, 5, 3)] = 0.01
        pgm_function30[(1, 5, 4)] = 0.001
        pgm_function30[(1, 6, 1)] = 0.84
        pgm_function30[(1, 6, 2)] = 0.49
        pgm_function30[(1, 6, 3)] = 0.05
        pgm_function30[(1, 6, 4)] = 0.3333333
        pgm_function30[(1, 7, 1)] = 0.84
        pgm_function30[(1, 7, 2)] = 0.49
        pgm_function30[(1, 7, 3)] = 0.05
        pgm_function30[(1, 7, 4)] = 0.001
        pgm_function30[(1, 8, 1)] = 0.74
        pgm_function30[(1, 8, 2)] = 0.49
        pgm_function30[(1, 8, 3)] = 0.3333333
        pgm_function30[(1, 8, 4)] = 0.3333333
        pgm_function30[(1, 9, 1)] = 0.78
        pgm_function30[(1, 9, 2)] = 0.49
        pgm_function30[(1, 9, 3)] = 0.3333333
        pgm_function30[(1, 9, 4)] = 0.3333333
        pgm_function30[(1, 10, 1)] = 0.65
        pgm_function30[(1, 10, 2)] = 0.75
        pgm_function30[(1, 10, 3)] = 0.05
        pgm_function30[(1, 10, 4)] = 0.3333333
        pgm_function30[(1, 11, 1)] = 0.68
        pgm_function30[(1, 11, 2)] = 0.75
        pgm_function30[(1, 11, 3)] = 0.3333333
        pgm_function30[(1, 11, 4)] = 0.3333333
        pgm_function30[(1, 12, 1)] = 0.59
        pgm_function30[(1, 12, 2)] = 0.49
        pgm_function30[(1, 12, 3)] = 0.05
        pgm_function30[(1, 12, 4)] = 0.3333333
        pgm_function30[(1, 13, 1)] = 0.1
        pgm_function30[(1, 13, 2)] = 0.05
        pgm_function30[(1, 13, 3)] = 0.01
        pgm_function30[(1, 13, 4)] = 0.001
        pgm_function30[(1, 14, 1)] = 0.74
        pgm_function30[(1, 14, 2)] = 0.49
        pgm_function30[(1, 14, 3)] = 0.3333333
        pgm_function30[(1, 14, 4)] = 0.3333333
        pgm_function30[(1, 15, 1)] = 0.74
        pgm_function30[(1, 15, 2)] = 0.49
        pgm_function30[(1, 15, 3)] = 0.3333333
        pgm_function30[(1, 15, 4)] = 0.3333333
        pgm_function30[(1, 16, 1)] = 0.84
        pgm_function30[(1, 16, 2)] = 0.49
        pgm_function30[(1, 16, 3)] = 0.05
        pgm_function30[(1, 16, 4)] = 0.001
        pgm_function30[(1, 17, 1)] = 0.68
        pgm_function30[(1, 17, 2)] = 0.75
        pgm_function30[(1, 17, 3)] = 0.3333333
        pgm_function30[(1, 17, 4)] = 0.3333333
        pgm_function30[(1, 18, 1)] = 0.03
        pgm_function30[(1, 18, 2)] = 0.009
        pgm_function30[(1, 18, 3)] = 0.3333333
        pgm_function30[(1, 18, 4)] = 0.3333333
        pgm_function30[(1, 19, 1)] = 0.03
        pgm_function30[(1, 19, 2)] = 0.009
        pgm_function30[(1, 19, 3)] = 0.3333333
        pgm_function30[(1, 19, 4)] = 0.3333333
        pgm_function30[(1, 20, 1)] = 0.84
        pgm_function30[(1, 20, 2)] = 0.49
        pgm_function30[(1, 20, 3)] = 0.3333333
        pgm_function30[(1, 20, 4)] = 0.3333333
        pgm_function30[(1, 21, 1)] = 0.84
        pgm_function30[(1, 21, 2)] = 0.49
        pgm_function30[(1, 21, 3)] = 0.3333333
        pgm_function30[(1, 21, 4)] = 0.3333333
        pgm_function30[(1, 22, 1)] = 0.68
        pgm_function30[(1, 22, 2)] = 0.75
        pgm_function30[(1, 22, 3)] = 0.3333333
        pgm_function30[(1, 22, 4)] = 0.3333333
        pgm_function30[(1, 23, 1)] = 0.65
        pgm_function30[(1, 23, 2)] = 0.75
        pgm_function30[(1, 23, 3)] = 0.3333333
        pgm_function30[(1, 23, 4)] = 0.3333333
        pgm_function30[(1, 24, 1)] = 0.59
        pgm_function30[(1, 24, 2)] = 0.49
        pgm_function30[(1, 24, 3)] = 0.3333333
        pgm_function30[(1, 24, 4)] = 0.3333333
        pgm_function30[(1, 25, 1)] = 0.05
        pgm_function30[(1, 25, 2)] = 0.3333333
        pgm_function30[(1, 25, 3)] = 0.3333333
        pgm_function30[(1, 25, 4)] = 0.3333333
        pgm_function30[(1, 26, 1)] = 0.05
        pgm_function30[(1, 26, 2)] = 0.3333333
        pgm_function30[(1, 26, 3)] = 0.3333333
        pgm_function30[(1, 26, 4)] = 0.3333333
        pgm_function30[(1, 27, 1)] = 0.31
        pgm_function30[(1, 27, 2)] = 0.31
        pgm_function30[(1, 27, 3)] = 0.3333333
        pgm_function30[(1, 27, 4)] = 0.3333333
        pgm_function30[(1, 28, 1)] = 0.31
        pgm_function30[(1, 28, 2)] = 0.31
        pgm_function30[(1, 28, 3)] = 0.3333333
        pgm_function30[(1, 28, 4)] = 0.3333333
        pgm_function30[(1, 29, 1)] = 0.31
        pgm_function30[(1, 29, 2)] = 0.31
        pgm_function30[(1, 29, 3)] = 0.3333333
        pgm_function30[(1, 29, 4)] = 0.3333333
        pgm_function30[(1, 30, 1)] = 0.31
        pgm_function30[(1, 30, 2)] = 0.31
        pgm_function30[(1, 30, 3)] = 0.3333333
        pgm_function30[(1, 30, 4)] = 0.3333333
        pgm_function30[(1, 31, 1)] = 0.4
        pgm_function30[(1, 31, 2)] = 0.4
        pgm_function30[(1, 31, 3)] = 0.05
        pgm_function30[(1, 31, 4)] = 0.3333333
        pgm_function30[(1, 32, 1)] = 0.01
        pgm_function30[(1, 32, 2)] = 0.3333333
        pgm_function30[(1, 32, 3)] = 0.3333333
        pgm_function30[(1, 32, 4)] = 0.3333333
        pgm_function30[(1, 33, 1)] = 0.01
        pgm_function30[(1, 33, 2)] = 0.3333333
        pgm_function30[(1, 33, 3)] = 0.3333333
        pgm_function30[(1, 33, 4)] = 0.3333333
        pgm_function30[(1, 34, 1)] = 0.1
        pgm_function30[(1, 34, 2)] = 0.05
        pgm_function30[(1, 34, 3)] = 0.01
        pgm_function30[(1, 34, 4)] = 0.001
        pgm_function30[(1, 35, 1)] = 0.1
        pgm_function30[(1, 35, 2)] = 0.05
        pgm_function30[(1, 35, 3)] = 0.01
        pgm_function30[(1, 35, 4)] = 0.001
        pgm_function30[(1, 36, 1)] = 0.1
        pgm_function30[(1, 36, 2)] = 0.05
        pgm_function30[(1, 36, 3)] = 0.01
        pgm_function30[(1, 36, 4)] = 0.001
        pgm_function30[(1, 37, 1)] = 0.1
        pgm_function30[(1, 37, 2)] = 0.05
        pgm_function30[(1, 37, 3)] = 0.01
        pgm_function30[(1, 37, 4)] = 0.001
        pgm_function30[(1, 38, 1)] = 0.06
        pgm_function30[(1, 38, 2)] = 0.06
        pgm_function30[(1, 38, 3)] = 0.3333333
        pgm_function30[(1, 38, 4)] = 0.3333333
        pgm_function30[(1, 39, 1)] = 0.06
        pgm_function30[(1, 39, 2)] = 0.06
        pgm_function30[(1, 39, 3)] = 0.3333333
        pgm_function30[(1, 39, 4)] = 0.3333333
        pgm_function30[(1, 40, 1)] = 0.05
        pgm_function30[(1, 40, 2)] = 0.25
        pgm_function30[(1, 40, 3)] = 0.2
        pgm_function30[(1, 40, 4)] = 0.3333333
        pgm_function30[(1, 41, 1)] = 0.02
        pgm_function30[(1, 41, 2)] = 0.3333333
        pgm_function30[(1, 41, 3)] = 0.3333333
        pgm_function30[(1, 41, 4)] = 0.3333333
        pgm_function30[(1, 42, 1)] = 0.02
        pgm_function30[(1, 42, 2)] = 0.3333333
        pgm_function30[(1, 42, 3)] = 0.3333333
        pgm_function30[(1, 42, 4)] = 0.3333333
        pgm_function30[(1, 43, 1)] = 0.02
        pgm_function30[(1, 43, 2)] = 0.3333333
        pgm_function30[(1, 43, 3)] = 0.3333333
        pgm_function30[(1, 43, 4)] = 0.3333333
        pgm_function30[(1, 44, 1)] = 0.02
        pgm_function30[(1, 44, 2)] = 0.3333333
        pgm_function30[(1, 44, 3)] = 0.3333333
        pgm_function30[(1, 44, 4)] = 0.3333333
        pgm_function30[(1, 45, 1)] = 0.02
        pgm_function30[(1, 45, 2)] = 0.3333333
        pgm_function30[(1, 45, 3)] = 0.3333333
        pgm_function30[(1, 45, 4)] = 0.3333333
        pgm_function30[(1, 46, 1)] = 0.02
        pgm_function30[(1, 46, 2)] = 0.3333333
        pgm_function30[(1, 46, 3)] = 0.3333333
        pgm_function30[(1, 46, 4)] = 0.3333333
        pgm_function30[(1, 47, 1)] = 0.02
        pgm_function30[(1, 47, 2)] = 0.3333333
        pgm_function30[(1, 47, 3)] = 0.3333333
        pgm_function30[(1, 47, 4)] = 0.3333333
        pgm_function30[(1, 48, 1)] = 0.03
        pgm_function30[(1, 48, 2)] = 0.03
        pgm_function30[(1, 48, 3)] = 0.3333333
        pgm_function30[(1, 48, 4)] = 0.3333333
        pgm_function30[(1, 49, 1)] = 0.02
        pgm_function30[(1, 49, 2)] = 0.3333333
        pgm_function30[(1, 49, 3)] = 0.3333333
        pgm_function30[(1, 49, 4)] = 0.3333333
        pgm_function30[(1, 50, 1)] = 0.02
        pgm_function30[(1, 50, 2)] = 0.3333333
        pgm_function30[(1, 50, 3)] = 0.3333333
        pgm_function30[(1, 50, 4)] = 0.3333333
        pgm_function30[(1, 51, 1)] = 0.2
        pgm_function30[(1, 51, 2)] = 0.25
        pgm_function30[(1, 51, 3)] = 0.3333333
        pgm_function30[(1, 51, 4)] = 0.3333333
        pgm_function30[(1, 52, 1)] = 0.1
        pgm_function30[(1, 52, 2)] = 0.1
        pgm_function30[(1, 52, 3)] = 0.01
        pgm_function30[(1, 52, 4)] = 0.3333333
        pgm_function30[(1, 53, 1)] = 0.1
        pgm_function30[(1, 53, 2)] = 0.1
        pgm_function30[(1, 53, 3)] = 0.01
        pgm_function30[(1, 53, 4)] = 0.3333333
        pgm_function30[(1, 54, 1)] = 0.1
        pgm_function30[(1, 54, 2)] = 0.1
        pgm_function30[(1, 54, 3)] = 0.01
        pgm_function30[(1, 54, 4)] = 0.3333333
        pgm_function30[(1, 55, 1)] = 0.1
        pgm_function30[(1, 55, 2)] = 0.1
        pgm_function30[(1, 55, 3)] = 0.01
        pgm_function30[(1, 55, 4)] = 0.3333333
        pgm_function30[(1, 56, 1)] = 0.1
        pgm_function30[(1, 56, 2)] = 0.1
        pgm_function30[(1, 56, 3)] = 0.01
        pgm_function30[(1, 56, 4)] = 0.3333333
        pgm_function30[(1, 57, 1)] = 0.1
        pgm_function30[(1, 57, 2)] = 0.1
        pgm_function30[(1, 57, 3)] = 0.01
        pgm_function30[(1, 57, 4)] = 0.3333333
        pgm_function30[(1, 58, 1)] = 0.1
        pgm_function30[(1, 58, 2)] = 0.4
        pgm_function30[(1, 58, 3)] = 0.3333333
        pgm_function30[(1, 58, 4)] = 0.3333333
        pgm_function30[(1, 59, 1)] = 0.4
        pgm_function30[(1, 59, 2)] = 0.4
        pgm_function30[(1, 59, 3)] = 0.05
        pgm_function30[(1, 59, 4)] = 0.3333333
        pgm_function30[(1, 60, 1)] = 0.3
        pgm_function30[(1, 60, 2)] = 0.45
        pgm_function30[(1, 60, 3)] = 0.3333333
        pgm_function30[(1, 60, 4)] = 0.3333333
        pgm_function30[(1, 61, 1)] = 0.84
        pgm_function30[(1, 61, 2)] = 0.49
        pgm_function30[(1, 61, 3)] = 0.3333333
        pgm_function30[(1, 61, 4)] = 0.3333333
        pgm_function30[(1, 62, 1)] = 0.02
        pgm_function30[(1, 62, 2)] = 0.3333333
        pgm_function30[(1, 62, 3)] = 0.3333333
        pgm_function30[(1, 62, 4)] = 0.3333333
        pgm_function30[(1, 63, 1)] = 0.05
        pgm_function30[(1, 63, 2)] = 0.1
        pgm_function30[(1, 63, 3)] = 0.05
        pgm_function30[(1, 63, 4)] = 0.001
        pgm_function30[(1, 64, 1)] = 0.1
        pgm_function30[(1, 64, 2)] = 0.1
        pgm_function30[(1, 64, 3)] = 0.3333333
        pgm_function30[(1, 64, 4)] = 0.3333333
        pgm_function30[(1, 65, 1)] = 0.1
        pgm_function30[(1, 65, 2)] = 0.1
        pgm_function30[(1, 65, 3)] = 0.01
        pgm_function30[(1, 65, 4)] = 0.3333333
        pgm_function30[(1, 66, 1)] = 0.65
        pgm_function30[(1, 66, 2)] = 0.75
        pgm_function30[(1, 66, 3)] = 0.3333333
        pgm_function30[(1, 66, 4)] = 0.3333333
        pgm_function30[(1, 67, 1)] = 0.84
        pgm_function30[(1, 67, 2)] = 0.49
        pgm_function30[(1, 67, 3)] = 0.3333333
        pgm_function30[(1, 67, 4)] = 0.3333333
        pgm_function30[(1, 68, 1)] = 0.84
        pgm_function30[(1, 68, 2)] = 0.49
        pgm_function30[(1, 68, 3)] = 0.05
        pgm_function30[(1, 68, 4)] = 0.3333333
        pgm_function30[(1, 69, 1)] = 0.74
        pgm_function30[(1, 69, 2)] = 0.49
        pgm_function30[(1, 69, 3)] = 0.3333333
        pgm_function30[(1, 69, 4)] = 0.3333333
        pgm_function30[(1, 70, 1)] = 0.84
        pgm_function30[(1, 70, 2)] = 0.49
        pgm_function30[(1, 70, 3)] = 0.05
        pgm_function30[(1, 70, 4)] = 0.3333333
        pgm_function30[(1, 71, 1)] = 0.84
        pgm_function30[(1, 71, 2)] = 0.49
        pgm_function30[(1, 71, 3)] = 0.05
        pgm_function30[(1, 71, 4)] = 0.3333333
        pgm_function30[(1, 72, 1)] = 0.84
        pgm_function30[(1, 72, 2)] = 0.49
        pgm_function30[(1, 72, 3)] = 0.05
        pgm_function30[(1, 72, 4)] = 0.3333333
        pgm_function30[(1, 73, 1)] = 0.84
        pgm_function30[(1, 73, 2)] = 0.49
        pgm_function30[(1, 73, 3)] = 0.3333333
        pgm_function30[(1, 73, 4)] = 0.3333333
        pgm_function30[(1, 74, 1)] = 0.2
        pgm_function30[(1, 74, 2)] = 0.25
        pgm_function30[(1, 74, 3)] = 0.3333333
        pgm_function30[(1, 74, 4)] = 0.3333333
        pgm_function30[(1, 75, 1)] = 0.03
        pgm_function30[(1, 75, 2)] = 0.3333333
        pgm_function30[(1, 75, 3)] = 0.3333333
        pgm_function30[(1, 75, 4)] = 0.3333333
        pgm_function30[(2, 0, 0)] = 1.0
        pgm_function30[(2, 0, 1)] = 0.3333333
        pgm_function30[(2, 0, 2)] = 0.01
        pgm_function30[(2, 1, 0)] = 1.0
        pgm_function30[(2, 1, 1)] = 1.0
        pgm_function30[(2, 1, 2)] = 0.3333333
        pgm_function30[(2, 1, 3)] = 0.3333333
        pgm_function30[(2, 1, 4)] = 0.3333333
        pgm_function30[(2, 2, 0)] = 1.0
        pgm_function30[(2, 2, 1)] = 1.0
        pgm_function30[(2, 2, 2)] = 0.3333333
        pgm_function30[(2, 2, 3)] = 0.3333333
        pgm_function30[(2, 2, 4)] = 0.3333333
        pgm_function30[(2, 3, 0)] = 1.0
        pgm_function30[(2, 3, 1)] = 0.25
        pgm_function30[(2, 3, 2)] = 0.01
        pgm_function30[(2, 3, 3)] = 0.3333333
        pgm_function30[(2, 3, 4)] = 0.3333333
        pgm_function30[(2, 4, 0)] = 1.0
        pgm_function30[(2, 4, 1)] = 0.15
        pgm_function30[(2, 4, 2)] = 0.01
        pgm_function30[(2, 4, 4)] = 0.3333333
        pgm_function30[(2, 5, 0)] = 1.0
        pgm_function30[(2, 5, 1)] = 0.3333333
        pgm_function30[(2, 5, 2)] = 0.01
        pgm_function30[(2, 6, 0)] = 1.0
        pgm_function30[(2, 6, 1)] = 0.15
        pgm_function30[(2, 6, 2)] = 0.01
        pgm_function30[(2, 6, 4)] = 0.3333333
        pgm_function30[(2, 7, 0)] = 1.0
        pgm_function30[(2, 7, 1)] = 0.15
        pgm_function30[(2, 7, 2)] = 0.01
        pgm_function30[(2, 8, 0)] = 1.0
        pgm_function30[(2, 8, 1)] = 0.25
        pgm_function30[(2, 8, 2)] = 0.01
        pgm_function30[(2, 8, 3)] = 0.3333333
        pgm_function30[(2, 8, 4)] = 0.3333333
        pgm_function30[(2, 9, 0)] = 1.0
        pgm_function30[(2, 9, 1)] = 0.2
        pgm_function30[(2, 9, 2)] = 0.01
        pgm_function30[(2, 9, 3)] = 0.3333333
        pgm_function30[(2, 9, 4)] = 0.3333333
        pgm_function30[(2, 10, 0)] = 1.0
        pgm_function30[(2, 10, 1)] = 0.3
        pgm_function30[(2, 10, 2)] = 0.1
        pgm_function30[(2, 10, 4)] = 0.3333333
        pgm_function30[(2, 11, 0)] = 1.0
        pgm_function30[(2, 11, 1)] = 0.3
        pgm_function30[(2, 11, 2)] = 0.15
        pgm_function30[(2, 11, 3)] = 0.3333333
        pgm_function30[(2, 11, 4)] = 0.3333333
        pgm_function30[(2, 12, 0)] = 1.0
        pgm_function30[(2, 12, 1)] = 0.4
        pgm_function30[(2, 12, 2)] = 0.01
        pgm_function30[(2, 12, 4)] = 0.3333333
        pgm_function30[(2, 13, 0)] = 1.0
        pgm_function30[(2, 14, 0)] = 1.0
        pgm_function30[(2, 14, 1)] = 0.25
        pgm_function30[(2, 14, 2)] = 0.01
        pgm_function30[(2, 14, 3)] = 0.3333333
        pgm_function30[(2, 14, 4)] = 0.3333333
        pgm_function30[(2, 15, 0)] = 1.0
        pgm_function30[(2, 15, 1)] = 0.25
        pgm_function30[(2, 15, 2)] = 0.01
        pgm_function30[(2, 15, 3)] = 0.3333333
        pgm_function30[(2, 15, 4)] = 0.3333333
        pgm_function30[(2, 16, 0)] = 1.0
        pgm_function30[(2, 16, 1)] = 0.15
        pgm_function30[(2, 16, 2)] = 0.01
        pgm_function30[(2, 17, 0)] = 1.0
        pgm_function30[(2, 17, 1)] = 0.3
        pgm_function30[(2, 17, 2)] = 0.15
        pgm_function30[(2, 17, 3)] = 0.3333333
        pgm_function30[(2, 17, 4)] = 0.3333333
        pgm_function30[(2, 18, 0)] = 1.0
        pgm_function30[(2, 18, 1)] = 0.001
        pgm_function30[(2, 18, 2)] = 0.001
        pgm_function30[(2, 18, 3)] = 0.3333333
        pgm_function30[(2, 18, 4)] = 0.3333333
        pgm_function30[(2, 19, 0)] = 1.0
        pgm_function30[(2, 19, 1)] = 0.001
        pgm_function30[(2, 19, 2)] = 0.001
        pgm_function30[(2, 19, 3)] = 0.3333333
        pgm_function30[(2, 19, 4)] = 0.3333333
        pgm_function30[(2, 20, 0)] = 1.0
        pgm_function30[(2, 20, 1)] = 0.15
        pgm_function30[(2, 20, 2)] = 0.01
        pgm_function30[(2, 20, 3)] = 0.3333333
        pgm_function30[(2, 20, 4)] = 0.3333333
        pgm_function30[(2, 21, 0)] = 1.0
        pgm_function30[(2, 21, 1)] = 0.15
        pgm_function30[(2, 21, 2)] = 0.01
        pgm_function30[(2, 21, 3)] = 0.3333333
        pgm_function30[(2, 21, 4)] = 0.3333333
        pgm_function30[(2, 22, 0)] = 1.0
        pgm_function30[(2, 22, 1)] = 0.3
        pgm_function30[(2, 22, 2)] = 0.15
        pgm_function30[(2, 22, 3)] = 0.3333333
        pgm_function30[(2, 22, 4)] = 0.3333333
        pgm_function30[(2, 23, 0)] = 1.0
        pgm_function30[(2, 23, 1)] = 0.3
        pgm_function30[(2, 23, 2)] = 0.1
        pgm_function30[(2, 23, 3)] = 0.3333333
        pgm_function30[(2, 23, 4)] = 0.3333333
        pgm_function30[(2, 24, 0)] = 1.0
        pgm_function30[(2, 24, 1)] = 0.4
        pgm_function30[(2, 24, 2)] = 0.01
        pgm_function30[(2, 24, 3)] = 0.3333333
        pgm_function30[(2, 24, 4)] = 0.3333333
        pgm_function30[(2, 25, 0)] = 1.0
        pgm_function30[(2, 25, 1)] = 0.9
        pgm_function30[(2, 25, 2)] = 0.3333333
        pgm_function30[(2, 25, 3)] = 0.3333333
        pgm_function30[(2, 25, 4)] = 0.3333333
        pgm_function30[(2, 26, 0)] = 1.0
        pgm_function30[(2, 26, 1)] = 0.9
        pgm_function30[(2, 26, 2)] = 0.3333333
        pgm_function30[(2, 26, 3)] = 0.3333333
        pgm_function30[(2, 26, 4)] = 0.3333333
        pgm_function30[(2, 27, 0)] = 1.0
        pgm_function30[(2, 27, 1)] = 0.68
        pgm_function30[(2, 27, 2)] = 0.68
        pgm_function30[(2, 27, 3)] = 0.3333333
        pgm_function30[(2, 27, 4)] = 0.3333333
        pgm_function30[(2, 28, 0)] = 1.0
        pgm_function30[(2, 28, 1)] = 0.68
        pgm_function30[(2, 28, 2)] = 0.68
        pgm_function30[(2, 28, 3)] = 0.3333333
        pgm_function30[(2, 28, 4)] = 0.3333333
        pgm_function30[(2, 29, 0)] = 1.0
        pgm_function30[(2, 29, 1)] = 0.68
        pgm_function30[(2, 29, 2)] = 0.68
        pgm_function30[(2, 29, 3)] = 0.3333333
        pgm_function30[(2, 29, 4)] = 0.3333333
        pgm_function30[(2, 30, 0)] = 1.0
        pgm_function30[(2, 30, 1)] = 0.68
        pgm_function30[(2, 30, 2)] = 0.68
        pgm_function30[(2, 30, 3)] = 0.3333333
        pgm_function30[(2, 30, 4)] = 0.3333333
        pgm_function30[(2, 31, 0)] = 1.0
        pgm_function30[(2, 31, 1)] = 0.5
        pgm_function30[(2, 31, 2)] = 0.5
        pgm_function30[(2, 31, 4)] = 0.3333333
        pgm_function30[(2, 32, 0)] = 1.0
        pgm_function30[(2, 32, 1)] = 0.99
        pgm_function30[(2, 32, 2)] = 0.3333333
        pgm_function30[(2, 32, 3)] = 0.3333333
        pgm_function30[(2, 32, 4)] = 0.3333333
        pgm_function30[(2, 33, 0)] = 1.0
        pgm_function30[(2, 33, 1)] = 0.99
        pgm_function30[(2, 33, 2)] = 0.3333333
        pgm_function30[(2, 33, 3)] = 0.3333333
        pgm_function30[(2, 33, 4)] = 0.3333333
        pgm_function30[(2, 34, 0)] = 1.0
        pgm_function30[(2, 34, 1)] = 0.45
        pgm_function30[(2, 34, 2)] = 0.45
        pgm_function30[(2, 35, 0)] = 1.0
        pgm_function30[(2, 35, 1)] = 0.45
        pgm_function30[(2, 35, 2)] = 0.45
        pgm_function30[(2, 36, 0)] = 1.0
        pgm_function30[(2, 36, 1)] = 0.45
        pgm_function30[(2, 36, 2)] = 0.45
        pgm_function30[(2, 37, 0)] = 1.0
        pgm_function30[(2, 37, 1)] = 0.45
        pgm_function30[(2, 37, 2)] = 0.45
        pgm_function30[(2, 38, 0)] = 1.0
        pgm_function30[(2, 38, 1)] = 0.94
        pgm_function30[(2, 38, 2)] = 0.94
        pgm_function30[(2, 38, 3)] = 0.3333333
        pgm_function30[(2, 38, 4)] = 0.3333333
        pgm_function30[(2, 39, 0)] = 1.0
        pgm_function30[(2, 39, 1)] = 0.94
        pgm_function30[(2, 39, 2)] = 0.94
        pgm_function30[(2, 39, 3)] = 0.3333333
        pgm_function30[(2, 39, 4)] = 0.3333333
        pgm_function30[(2, 40, 0)] = 1.0
        pgm_function30[(2, 40, 1)] = 0.94
        pgm_function30[(2, 40, 2)] = 0.5
        pgm_function30[(2, 40, 3)] = 0.05
        pgm_function30[(2, 40, 4)] = 0.3333333
        pgm_function30[(2, 41, 0)] = 1.0
        pgm_function30[(2, 41, 1)] = 0.98
        pgm_function30[(2, 41, 2)] = 0.3333333
        pgm_function30[(2, 41, 3)] = 0.3333333
        pgm_function30[(2, 41, 4)] = 0.3333333
        pgm_function30[(2, 42, 0)] = 1.0
        pgm_function30[(2, 42, 1)] = 0.98
        pgm_function30[(2, 42, 2)] = 0.3333333
        pgm_function30[(2, 42, 3)] = 0.3333333
        pgm_function30[(2, 42, 4)] = 0.3333333
        pgm_function30[(2, 43, 0)] = 1.0
        pgm_function30[(2, 43, 1)] = 0.98
        pgm_function30[(2, 43, 2)] = 0.3333333
        pgm_function30[(2, 43, 3)] = 0.3333333
        pgm_function30[(2, 43, 4)] = 0.3333333
        pgm_function30[(2, 44, 0)] = 1.0
        pgm_function30[(2, 44, 1)] = 0.98
        pgm_function30[(2, 44, 2)] = 0.3333333
        pgm_function30[(2, 44, 3)] = 0.3333333
        pgm_function30[(2, 44, 4)] = 0.3333333
        pgm_function30[(2, 45, 0)] = 1.0
        pgm_function30[(2, 45, 1)] = 0.98
        pgm_function30[(2, 45, 2)] = 0.3333333
        pgm_function30[(2, 45, 3)] = 0.3333333
        pgm_function30[(2, 45, 4)] = 0.3333333
        pgm_function30[(2, 46, 0)] = 1.0
        pgm_function30[(2, 46, 1)] = 0.98
        pgm_function30[(2, 46, 2)] = 0.3333333
        pgm_function30[(2, 46, 3)] = 0.3333333
        pgm_function30[(2, 46, 4)] = 0.3333333
        pgm_function30[(2, 47, 0)] = 1.0
        pgm_function30[(2, 47, 1)] = 0.98
        pgm_function30[(2, 47, 2)] = 0.3333333
        pgm_function30[(2, 47, 3)] = 0.3333333
        pgm_function30[(2, 47, 4)] = 0.3333333
        pgm_function30[(2, 48, 0)] = 1.0
        pgm_function30[(2, 48, 1)] = 0.97
        pgm_function30[(2, 48, 2)] = 0.97
        pgm_function30[(2, 48, 3)] = 0.3333333
        pgm_function30[(2, 48, 4)] = 0.3333333
        pgm_function30[(2, 49, 0)] = 1.0
        pgm_function30[(2, 49, 1)] = 0.98
        pgm_function30[(2, 49, 2)] = 0.3333333
        pgm_function30[(2, 49, 3)] = 0.3333333
        pgm_function30[(2, 49, 4)] = 0.3333333
        pgm_function30[(2, 50, 0)] = 1.0
        pgm_function30[(2, 50, 1)] = 0.98
        pgm_function30[(2, 50, 2)] = 0.3333333
        pgm_function30[(2, 50, 3)] = 0.3333333
        pgm_function30[(2, 50, 4)] = 0.3333333
        pgm_function30[(2, 51, 0)] = 1.0
        pgm_function30[(2, 51, 1)] = 0.799
        pgm_function30[(2, 51, 2)] = 0.74
        pgm_function30[(2, 51, 3)] = 0.3333333
        pgm_function30[(2, 51, 4)] = 0.3333333
        pgm_function30[(2, 52, 0)] = 1.0
        pgm_function30[(2, 52, 1)] = 0.45
        pgm_function30[(2, 52, 2)] = 0.35
        pgm_function30[(2, 52, 4)] = 0.3333333
        pgm_function30[(2, 53, 0)] = 1.0
        pgm_function30[(2, 53, 1)] = 0.45
        pgm_function30[(2, 53, 2)] = 0.35
        pgm_function30[(2, 53, 4)] = 0.3333333
        pgm_function30[(2, 54, 0)] = 1.0
        pgm_function30[(2, 54, 1)] = 0.45
        pgm_function30[(2, 54, 2)] = 0.35
        pgm_function30[(2, 54, 4)] = 0.3333333
        pgm_function30[(2, 55, 0)] = 1.0
        pgm_function30[(2, 55, 1)] = 0.45
        pgm_function30[(2, 55, 2)] = 0.35
        pgm_function30[(2, 55, 4)] = 0.3333333
        pgm_function30[(2, 56, 0)] = 1.0
        pgm_function30[(2, 56, 1)] = 0.45
        pgm_function30[(2, 56, 2)] = 0.35
        pgm_function30[(2, 56, 4)] = 0.3333333
        pgm_function30[(2, 57, 0)] = 1.0
        pgm_function30[(2, 57, 1)] = 0.45
        pgm_function30[(2, 57, 2)] = 0.35
        pgm_function30[(2, 57, 4)] = 0.3333333
        pgm_function30[(2, 58, 0)] = 1.0
        pgm_function30[(2, 58, 1)] = 0.9
        pgm_function30[(2, 58, 2)] = 0.59
        pgm_function30[(2, 58, 3)] = 0.3333333
        pgm_function30[(2, 58, 4)] = 0.3333333
        pgm_function30[(2, 59, 0)] = 1.0
        pgm_function30[(2, 59, 1)] = 0.4
        pgm_function30[(2, 59, 2)] = 0.2
        pgm_function30[(2, 59, 4)] = 0.3333333
        pgm_function30[(2, 60, 0)] = 1.0
        pgm_function30[(2, 60, 1)] = 0.7
        pgm_function30[(2, 60, 2)] = 0.5
        pgm_function30[(2, 60, 3)] = 0.3333333
        pgm_function30[(2, 60, 4)] = 0.3333333
        pgm_function30[(2, 61, 0)] = 1.0
        pgm_function30[(2, 61, 1)] = 0.15
        pgm_function30[(2, 61, 2)] = 0.01
        pgm_function30[(2, 61, 3)] = 0.3333333
        pgm_function30[(2, 61, 4)] = 0.3333333
        pgm_function30[(2, 62, 0)] = 1.0
        pgm_function30[(2, 62, 1)] = 0.98
        pgm_function30[(2, 62, 2)] = 0.3333333
        pgm_function30[(2, 62, 3)] = 0.3333333
        pgm_function30[(2, 62, 4)] = 0.3333333
        pgm_function30[(2, 63, 0)] = 1.0
        pgm_function30[(2, 63, 1)] = 0.95
        pgm_function30[(2, 63, 2)] = 0.89
        pgm_function30[(2, 64, 0)] = 1.0
        pgm_function30[(2, 64, 1)] = 0.45
        pgm_function30[(2, 64, 2)] = 0.35
        pgm_function30[(2, 64, 3)] = 0.3333333
        pgm_function30[(2, 64, 4)] = 0.3333333
        pgm_function30[(2, 65, 0)] = 1.0
        pgm_function30[(2, 65, 1)] = 0.45
        pgm_function30[(2, 65, 2)] = 0.35
        pgm_function30[(2, 65, 4)] = 0.3333333
        pgm_function30[(2, 66, 0)] = 1.0
        pgm_function30[(2, 66, 1)] = 0.3
        pgm_function30[(2, 66, 2)] = 0.1
        pgm_function30[(2, 66, 3)] = 0.3333333
        pgm_function30[(2, 66, 4)] = 0.3333333
        pgm_function30[(2, 67, 0)] = 1.0
        pgm_function30[(2, 67, 1)] = 0.15
        pgm_function30[(2, 67, 2)] = 0.01
        pgm_function30[(2, 67, 3)] = 0.3333333
        pgm_function30[(2, 67, 4)] = 0.3333333
        pgm_function30[(2, 68, 0)] = 1.0
        pgm_function30[(2, 68, 1)] = 0.15
        pgm_function30[(2, 68, 2)] = 0.01
        pgm_function30[(2, 68, 4)] = 0.3333333
        pgm_function30[(2, 69, 0)] = 1.0
        pgm_function30[(2, 69, 1)] = 0.25
        pgm_function30[(2, 69, 2)] = 0.01
        pgm_function30[(2, 69, 3)] = 0.3333333
        pgm_function30[(2, 69, 4)] = 0.3333333
        pgm_function30[(2, 70, 0)] = 1.0
        pgm_function30[(2, 70, 1)] = 0.15
        pgm_function30[(2, 70, 2)] = 0.01
        pgm_function30[(2, 70, 4)] = 0.3333333
        pgm_function30[(2, 71, 0)] = 1.0
        pgm_function30[(2, 71, 1)] = 0.15
        pgm_function30[(2, 71, 2)] = 0.01
        pgm_function30[(2, 71, 4)] = 0.3333333
        pgm_function30[(2, 72, 0)] = 1.0
        pgm_function30[(2, 72, 1)] = 0.15
        pgm_function30[(2, 72, 2)] = 0.01
        pgm_function30[(2, 72, 4)] = 0.3333333
        pgm_function30[(2, 73, 0)] = 1.0
        pgm_function30[(2, 73, 1)] = 0.15
        pgm_function30[(2, 73, 2)] = 0.01
        pgm_function30[(2, 73, 3)] = 0.3333333
        pgm_function30[(2, 73, 4)] = 0.3333333
        pgm_function30[(2, 74, 0)] = 1.0
        pgm_function30[(2, 74, 1)] = 0.799
        pgm_function30[(2, 74, 2)] = 0.74
        pgm_function30[(2, 74, 3)] = 0.3333333
        pgm_function30[(2, 74, 4)] = 0.3333333
        pgm_function30[(2, 75, 0)] = 1.0
        pgm_function30[(2, 75, 1)] = 0.96
        pgm_function30[(2, 75, 2)] = 0.3333333
        pgm_function30[(2, 75, 3)] = 0.3333333
        pgm_function30[(2, 75, 4)] = 0.3333333

        pgm_function31 = pgm_factor31.set_dense()
        pgm_function31.set_flat(
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.99,
            0.99, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.99, 0.98, 0.5,
            0.5, 0.99, 0.98, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.99, 0.98, 0.5, 0.5,
            0.99, 0.98, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.99, 0.98, 0.5,
            0.5, 0.99, 0.98, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.99, 0.98, 0.5, 0.5, 0.99,
            0.98, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.999, 0.99,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.999,
            0.99, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.999, 0.99, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.99, 0.99, 0.5, 0.5, 0.995,
            0.99, 0.5, 0.5, 0.5, 0.99,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.99, 0.99, 0.5, 0.5,
            0.99, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.99, 0.99, 0.5,
            0.5, 0.99, 0.99, 0.5, 0.5,
            0.98, 0.98, 0.5, 0.5, 0.99,
            0.9, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.9, 0.9, 0.5,
            0.5, 0.8, 0.8, 0.5, 0.5,
            0.3, 0.3, 1.0, 0.999, 0.99,
            0.99, 0.5, 0.999, 0.99, 0.96,
            0.5, 0.99, 0.98, 0.98, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.99,
            0.99, 0.95, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 0.5, 0.99, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.99, 0.99, 0.5,
            0.5, 0.99, 0.97, 0.5, 0.5,
            0.98, 0.98, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.7, 0.7,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 0.999, 0.99, 0.99, 0.5,
            0.99, 0.5, 0.99, 0.5, 0.99,
            0.5, 0.99, 0.5, 0.5, 0.5,
            0.5, 1.0, 0.999, 0.9, 0.9,
            0.5, 0.5, 0.999, 0.999, 0.5,
            0.5, 0.5, 0.999, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 0.999, 0.9999, 0.999, 0.5,
            0.999, 0.5, 0.999, 0.5, 0.999,
            0.5, 0.999, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.99,
            0.99, 0.5, 0.5, 0.99, 0.97,
            0.5, 0.5, 0.98, 0.98, 0.5,
            0.5, 0.99, 0.98, 1.0, 0.999,
            0.9999, 0.999, 0.5, 0.999, 0.5,
            0.999, 0.5, 0.999, 0.5, 0.999,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.999, 0.999, 0.5, 0.5, 0.5,
            0.999, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.999, 0.999, 0.5, 0.5,
            0.5, 0.999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.99, 0.98,
            0.5, 0.5, 0.99, 0.98, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 0.999,
            0.9999, 0.999, 0.5, 0.999, 0.5,
            0.999, 0.5, 0.999, 0.5, 0.999,
            0.5, 0.5, 0.5, 0.5, 1.0,
            1.0, 0.9999, 0.9999, 0.5, 0.5,
            0.99, 0.99, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 1.0, 1.0, 0.9999, 0.9999,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 1.0, 1.0, 0.9999,
            0.9999, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 1.0, 1.0,
            0.9999, 0.9999, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.7, 0.7, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            1.0, 1.0, 0.9999, 0.9999, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.01, 0.01, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.01, 0.02,
            0.5, 0.5, 0.01, 0.02, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.01, 0.02, 0.5,
            0.5, 0.01, 0.02, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.01, 0.02,
            0.5, 0.5, 0.01, 0.02, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.01, 0.02, 0.5, 0.5,
            0.01, 0.02, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.001,
            0.01, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.001, 0.01, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.001, 0.01, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.01, 0.01, 0.5, 0.5,
            0.005, 0.01, 0.5, 0.5, 0.5,
            0.01, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.01, 0.01, 0.5,
            0.5, 0.01, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.01, 0.01,
            0.5, 0.5, 0.01, 0.01, 0.5,
            0.5, 0.02, 0.02, 0.5, 0.5,
            0.01, 0.1, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.1, 0.1,
            0.5, 0.5, 0.2, 0.2, 0.5,
            0.5, 0.7, 0.7, 0.0, 0.001,
            0.01, 0.01, 0.5, 0.001, 0.01,
            0.04, 0.5, 0.01, 0.02, 0.02,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.01, 0.01, 0.05, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.5, 0.01, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.01, 0.01,
            0.5, 0.5, 0.01, 0.03, 0.5,
            0.5, 0.02, 0.02, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.3,
            0.3, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.001, 0.01, 0.01,
            0.5, 0.01, 0.5, 0.01, 0.5,
            0.01, 0.5, 0.01, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.001, 0.1,
            0.1, 0.5, 0.5, 0.001, 0.001,
            0.5, 0.5, 0.5, 0.001, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.001, 0.0001, 0.001,
            0.5, 0.001, 0.5, 0.001, 0.5,
            0.001, 0.5, 0.001, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.01, 0.01, 0.5, 0.5, 0.01,
            0.03, 0.5, 0.5, 0.02, 0.02,
            0.5, 0.5, 0.01, 0.02, 0.0,
            0.001, 0.0001, 0.001, 0.5, 0.001,
            0.5, 0.001, 0.5, 0.001, 0.5,
            0.001, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.001, 0.001, 0.5, 0.5,
            0.5, 0.001, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.001, 0.001, 0.5,
            0.5, 0.5, 0.001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.01,
            0.02, 0.5, 0.5, 0.01, 0.02,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.001, 0.0001, 0.001, 0.5, 0.001,
            0.5, 0.001, 0.5, 0.001, 0.5,
            0.001, 0.5, 0.5, 0.5, 0.5,
            0.0, 0.0, 0.0001, 0.0001, 0.5,
            0.5, 0.01, 0.01, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.0, 0.0, 0.0001,
            0.0001, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.0, 0.0,
            0.0001, 0.0001, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.0,
            0.0, 0.0001, 0.0001, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.3, 0.3, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.0, 0.0, 0.0001, 0.0001,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5, 0.5, 0.5, 0.5,
            0.5, 0.5
        )

        pgm_function32 = pgm_factor32.set_dense()
        pgm_function32.set_flat(
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.38, 0.25, 0.01,
            0.01, 0.999, 0.9, 0.8, 0.75,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.89, 0.5, 0.01,
            0.05, 0.9999, 0.97, 0.93, 0.89,
            0.95, 0.95, 0.01, 0.05, 0.89,
            0.88, 0.85, 0.5, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.38, 0.25, 0.01, 0.01,
            0.38, 0.25, 0.01, 0.01, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.999, 0.9, 0.8, 0.75,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.89, 0.88,
            0.85, 0.5, 0.95, 0.95, 0.01,
            0.05, 0.999, 0.9, 0.8, 0.75,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.95, 0.89,
            0.86, 0.55, 0.95, 0.89, 0.86,
            0.55, 0.95, 0.89, 0.86, 0.55,
            0.95, 0.89, 0.86, 0.55, 0.95,
            0.89, 0.86, 0.55, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.999, 0.9, 0.8, 0.75,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.999, 0.9, 0.8, 0.75,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.999, 0.9, 0.8, 0.75,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.8, 0.8, 0.75, 0.25,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.999, 0.9, 0.8, 0.75,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.999, 0.9, 0.8, 0.75,
            0.95, 0.89, 0.86, 0.55, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.95, 0.89, 0.86, 0.55,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.95, 0.89, 0.86,
            0.55, 0.38, 0.25, 0.01, 0.01,
            0.999, 0.9, 0.8, 0.75, 0.999,
            0.9, 0.8, 0.75, 0.999, 0.9,
            0.8, 0.75, 0.999, 0.9, 0.8,
            0.75, 0.999, 0.9, 0.8, 0.75,
            0.999, 0.9, 0.8, 0.75, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.6, 0.6, 0.74, 0.49,
            0.001, 0.09, 0.18, 0.2, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.1, 0.4, 0.79, 0.7,
            0.0001, 0.02, 0.05, 0.08, 0.05,
            0.04, 0.9, 0.75, 0.1, 0.1,
            0.12, 0.45, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.6, 0.6, 0.74, 0.49, 0.6,
            0.6, 0.74, 0.49, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.001, 0.09, 0.18, 0.2, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.1, 0.1, 0.12,
            0.45, 0.05, 0.04, 0.9, 0.75,
            0.001, 0.09, 0.18, 0.2, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.05, 0.1, 0.12,
            0.4, 0.05, 0.1, 0.12, 0.4,
            0.05, 0.1, 0.12, 0.4, 0.05,
            0.1, 0.12, 0.4, 0.05, 0.1,
            0.12, 0.4, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.001, 0.09, 0.18, 0.2, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.001, 0.09, 0.18, 0.2, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.001, 0.09, 0.18, 0.2, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.19, 0.18, 0.2, 0.6, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.001, 0.09, 0.18, 0.2, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.001, 0.09, 0.18, 0.2, 0.05,
            0.1, 0.12, 0.4, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.05, 0.1, 0.12, 0.4, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.05, 0.1, 0.12, 0.4,
            0.6, 0.6, 0.74, 0.49, 0.001,
            0.09, 0.18, 0.2, 0.001, 0.09,
            0.18, 0.2, 0.001, 0.09, 0.18,
            0.2, 0.001, 0.09, 0.18, 0.2,
            0.001, 0.09, 0.18, 0.2, 0.001,
            0.09, 0.18, 0.2, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.02, 0.15, 0.25, 0.5, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.01, 0.1, 0.2, 0.25, 0.0,
            0.01, 0.02, 0.03, 0.0, 0.01,
            0.09, 0.2, 0.01, 0.02, 0.03,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.02,
            0.15, 0.25, 0.5, 0.02, 0.15,
            0.25, 0.5, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.01, 0.02, 0.03, 0.05,
            0.0, 0.01, 0.09, 0.2, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.01,
            0.02, 0.05, 0.15, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.02,
            0.15, 0.25, 0.5, 0.0, 0.01,
            0.02, 0.05, 0.0, 0.01, 0.02,
            0.05, 0.0, 0.01, 0.02, 0.05,
            0.0, 0.01, 0.02, 0.05, 0.0,
            0.01, 0.02, 0.05, 0.0, 0.01,
            0.02, 0.05
        )

        pgm_function33 = pgm_factor33.set_sparse()
        pgm_function33[(0, 0, 0)] = 0.999
        pgm_function33[(0, 0, 1)] = 0.999
        pgm_function33[(0, 1, 0)] = 1.0
        pgm_function33[(0, 1, 1)] = 1.0
        pgm_function33[(0, 2, 0)] = 0.999
        pgm_function33[(0, 2, 1)] = 0.999
        pgm_function33[(0, 3, 0)] = 0.999
        pgm_function33[(0, 3, 1)] = 0.999
        pgm_function33[(0, 4, 0)] = 0.999
        pgm_function33[(0, 4, 1)] = 0.999
        pgm_function33[(0, 5, 0)] = 0.999
        pgm_function33[(0, 5, 1)] = 0.999
        pgm_function33[(0, 6, 0)] = 0.999
        pgm_function33[(0, 6, 1)] = 0.999
        pgm_function33[(0, 7, 0)] = 0.999
        pgm_function33[(0, 7, 1)] = 0.999
        pgm_function33[(0, 8, 0)] = 0.999
        pgm_function33[(0, 8, 1)] = 0.999
        pgm_function33[(0, 9, 0)] = 0.999
        pgm_function33[(0, 9, 1)] = 0.999
        pgm_function33[(0, 10, 0)] = 0.99
        pgm_function33[(0, 10, 1)] = 0.99
        pgm_function33[(0, 11, 0)] = 0.999
        pgm_function33[(0, 11, 1)] = 0.999
        pgm_function33[(0, 12, 0)] = 0.999
        pgm_function33[(0, 12, 1)] = 0.999
        pgm_function33[(0, 13, 0)] = 0.999
        pgm_function33[(0, 13, 1)] = 0.999
        pgm_function33[(0, 14, 0)] = 0.999
        pgm_function33[(0, 14, 1)] = 0.999
        pgm_function33[(0, 15, 0)] = 0.999
        pgm_function33[(0, 15, 1)] = 0.999
        pgm_function33[(0, 16, 0)] = 0.999
        pgm_function33[(0, 16, 1)] = 0.999
        pgm_function33[(0, 17, 0)] = 0.999
        pgm_function33[(0, 17, 1)] = 0.999
        pgm_function33[(0, 18, 0)] = 0.999
        pgm_function33[(0, 18, 1)] = 0.999
        pgm_function33[(0, 19, 0)] = 0.999
        pgm_function33[(0, 19, 1)] = 0.999
        pgm_function33[(0, 20, 0)] = 0.999
        pgm_function33[(0, 20, 1)] = 0.999
        pgm_function33[(0, 21, 0)] = 0.999
        pgm_function33[(0, 21, 1)] = 0.999
        pgm_function33[(0, 22, 0)] = 0.999
        pgm_function33[(0, 22, 1)] = 0.999
        pgm_function33[(0, 23, 0)] = 0.99
        pgm_function33[(0, 23, 1)] = 0.99
        pgm_function33[(0, 24, 0)] = 0.999
        pgm_function33[(0, 24, 1)] = 0.999
        pgm_function33[(0, 25, 0)] = 0.2
        pgm_function33[(0, 27, 0)] = 0.95
        pgm_function33[(0, 27, 1)] = 0.849
        pgm_function33[(0, 28, 0)] = 0.95
        pgm_function33[(0, 28, 1)] = 0.95
        pgm_function33[(0, 29, 0)] = 0.95
        pgm_function33[(0, 29, 1)] = 0.95
        pgm_function33[(0, 30, 0)] = 0.95
        pgm_function33[(0, 30, 1)] = 0.849
        pgm_function33[(0, 31, 0)] = 0.95
        pgm_function33[(0, 31, 1)] = 0.95
        pgm_function33[(0, 32, 0)] = 1.0
        pgm_function33[(0, 32, 1)] = 1.0
        pgm_function33[(0, 33, 0)] = 1.0
        pgm_function33[(0, 33, 1)] = 1.0
        pgm_function33[(0, 34, 0)] = 0.999
        pgm_function33[(0, 34, 1)] = 0.999
        pgm_function33[(0, 35, 0)] = 0.999
        pgm_function33[(0, 35, 1)] = 0.999
        pgm_function33[(0, 36, 0)] = 0.999
        pgm_function33[(0, 36, 1)] = 0.999
        pgm_function33[(0, 37, 0)] = 0.999
        pgm_function33[(0, 37, 1)] = 0.999
        pgm_function33[(0, 38, 0)] = 0.999
        pgm_function33[(0, 38, 1)] = 0.999
        pgm_function33[(0, 39, 0)] = 0.999
        pgm_function33[(0, 39, 1)] = 0.999
        pgm_function33[(0, 40, 0)] = 0.999
        pgm_function33[(0, 40, 1)] = 0.999
        pgm_function33[(0, 41, 0)] = 0.999
        pgm_function33[(0, 41, 1)] = 0.999
        pgm_function33[(0, 42, 0)] = 0.999
        pgm_function33[(0, 42, 1)] = 0.999
        pgm_function33[(0, 43, 0)] = 0.9889
        pgm_function33[(0, 43, 1)] = 0.9889
        pgm_function33[(0, 44, 0)] = 0.999
        pgm_function33[(0, 44, 1)] = 0.999
        pgm_function33[(0, 45, 0)] = 0.9889
        pgm_function33[(0, 45, 1)] = 0.9889
        pgm_function33[(0, 46, 0)] = 1.0
        pgm_function33[(0, 46, 1)] = 1.0
        pgm_function33[(0, 47, 0)] = 0.9889
        pgm_function33[(0, 47, 1)] = 0.9889
        pgm_function33[(0, 48, 0)] = 0.999
        pgm_function33[(0, 48, 1)] = 0.999
        pgm_function33[(0, 49, 0)] = 0.999
        pgm_function33[(0, 49, 1)] = 0.999
        pgm_function33[(0, 50, 0)] = 0.9889
        pgm_function33[(0, 50, 1)] = 0.9889
        pgm_function33[(0, 51, 0)] = 0.9889
        pgm_function33[(0, 51, 1)] = 0.9889
        pgm_function33[(0, 52, 0)] = 0.999
        pgm_function33[(0, 52, 1)] = 0.999
        pgm_function33[(0, 53, 0)] = 0.999
        pgm_function33[(0, 53, 1)] = 0.999
        pgm_function33[(0, 54, 0)] = 0.999
        pgm_function33[(0, 54, 1)] = 0.999
        pgm_function33[(0, 55, 0)] = 0.999
        pgm_function33[(0, 55, 1)] = 0.999
        pgm_function33[(0, 56, 0)] = 0.999
        pgm_function33[(0, 56, 1)] = 0.999
        pgm_function33[(0, 57, 0)] = 0.999
        pgm_function33[(0, 57, 1)] = 0.999
        pgm_function33[(0, 58, 0)] = 0.999
        pgm_function33[(0, 58, 1)] = 0.999
        pgm_function33[(0, 59, 0)] = 0.999
        pgm_function33[(0, 59, 1)] = 0.999
        pgm_function33[(0, 60, 0)] = 0.999
        pgm_function33[(0, 60, 1)] = 0.999
        pgm_function33[(0, 61, 0)] = 0.999
        pgm_function33[(0, 61, 1)] = 0.999
        pgm_function33[(0, 62, 0)] = 0.9889
        pgm_function33[(0, 62, 1)] = 0.9889
        pgm_function33[(0, 63, 0)] = 0.999
        pgm_function33[(0, 63, 1)] = 0.999
        pgm_function33[(0, 64, 0)] = 0.999
        pgm_function33[(0, 64, 1)] = 0.999
        pgm_function33[(0, 65, 0)] = 0.999
        pgm_function33[(0, 65, 1)] = 0.999
        pgm_function33[(0, 66, 0)] = 0.99
        pgm_function33[(0, 66, 1)] = 0.99
        pgm_function33[(0, 67, 0)] = 0.999
        pgm_function33[(0, 67, 1)] = 0.999
        pgm_function33[(0, 68, 0)] = 0.999
        pgm_function33[(0, 68, 1)] = 0.999
        pgm_function33[(0, 69, 0)] = 0.999
        pgm_function33[(0, 69, 1)] = 0.999
        pgm_function33[(0, 70, 0)] = 0.999
        pgm_function33[(0, 70, 1)] = 0.999
        pgm_function33[(0, 71, 0)] = 0.999
        pgm_function33[(0, 71, 1)] = 0.999
        pgm_function33[(0, 72, 0)] = 0.999
        pgm_function33[(0, 72, 1)] = 0.999
        pgm_function33[(0, 73, 0)] = 0.999
        pgm_function33[(0, 73, 1)] = 0.999
        pgm_function33[(0, 74, 0)] = 0.9889
        pgm_function33[(0, 74, 1)] = 0.9889
        pgm_function33[(0, 75, 0)] = 0.999
        pgm_function33[(0, 75, 1)] = 0.999
        pgm_function33[(1, 0, 0)] = 0.001
        pgm_function33[(1, 0, 1)] = 0.001
        pgm_function33[(1, 2, 0)] = 0.001
        pgm_function33[(1, 2, 1)] = 0.001
        pgm_function33[(1, 3, 0)] = 0.001
        pgm_function33[(1, 3, 1)] = 0.001
        pgm_function33[(1, 4, 0)] = 0.001
        pgm_function33[(1, 4, 1)] = 0.001
        pgm_function33[(1, 5, 0)] = 0.001
        pgm_function33[(1, 5, 1)] = 0.001
        pgm_function33[(1, 6, 0)] = 0.001
        pgm_function33[(1, 6, 1)] = 0.001
        pgm_function33[(1, 7, 0)] = 0.001
        pgm_function33[(1, 7, 1)] = 0.001
        pgm_function33[(1, 8, 0)] = 0.001
        pgm_function33[(1, 8, 1)] = 0.001
        pgm_function33[(1, 9, 0)] = 0.001
        pgm_function33[(1, 9, 1)] = 0.001
        pgm_function33[(1, 10, 0)] = 0.01
        pgm_function33[(1, 10, 1)] = 0.01
        pgm_function33[(1, 11, 0)] = 0.001
        pgm_function33[(1, 11, 1)] = 0.001
        pgm_function33[(1, 12, 0)] = 0.001
        pgm_function33[(1, 12, 1)] = 0.001
        pgm_function33[(1, 13, 0)] = 0.001
        pgm_function33[(1, 13, 1)] = 0.001
        pgm_function33[(1, 14, 0)] = 0.001
        pgm_function33[(1, 14, 1)] = 0.001
        pgm_function33[(1, 15, 0)] = 0.001
        pgm_function33[(1, 15, 1)] = 0.001
        pgm_function33[(1, 16, 0)] = 0.001
        pgm_function33[(1, 16, 1)] = 0.001
        pgm_function33[(1, 17, 0)] = 0.001
        pgm_function33[(1, 17, 1)] = 0.001
        pgm_function33[(1, 18, 0)] = 0.001
        pgm_function33[(1, 18, 1)] = 0.001
        pgm_function33[(1, 19, 0)] = 0.001
        pgm_function33[(1, 19, 1)] = 0.001
        pgm_function33[(1, 20, 0)] = 0.001
        pgm_function33[(1, 20, 1)] = 0.001
        pgm_function33[(1, 21, 0)] = 0.001
        pgm_function33[(1, 21, 1)] = 0.001
        pgm_function33[(1, 22, 0)] = 0.001
        pgm_function33[(1, 22, 1)] = 0.001
        pgm_function33[(1, 23, 0)] = 0.01
        pgm_function33[(1, 23, 1)] = 0.01
        pgm_function33[(1, 24, 0)] = 0.001
        pgm_function33[(1, 24, 1)] = 0.001
        pgm_function33[(1, 25, 0)] = 0.2
        pgm_function33[(1, 25, 1)] = 0.01
        pgm_function33[(1, 26, 0)] = 0.01
        pgm_function33[(1, 26, 1)] = 0.01
        pgm_function33[(1, 27, 0)] = 0.04
        pgm_function33[(1, 27, 1)] = 0.1
        pgm_function33[(1, 28, 0)] = 0.04
        pgm_function33[(1, 28, 1)] = 0.04
        pgm_function33[(1, 29, 0)] = 0.04
        pgm_function33[(1, 29, 1)] = 0.04
        pgm_function33[(1, 30, 0)] = 0.04
        pgm_function33[(1, 30, 1)] = 0.1
        pgm_function33[(1, 31, 0)] = 0.04
        pgm_function33[(1, 31, 1)] = 0.04
        pgm_function33[(1, 34, 0)] = 0.001
        pgm_function33[(1, 34, 1)] = 0.001
        pgm_function33[(1, 35, 0)] = 0.001
        pgm_function33[(1, 35, 1)] = 0.001
        pgm_function33[(1, 36, 0)] = 0.001
        pgm_function33[(1, 36, 1)] = 0.001
        pgm_function33[(1, 37, 0)] = 0.001
        pgm_function33[(1, 37, 1)] = 0.001
        pgm_function33[(1, 38, 0)] = 0.001
        pgm_function33[(1, 38, 1)] = 0.001
        pgm_function33[(1, 39, 0)] = 0.001
        pgm_function33[(1, 39, 1)] = 0.001
        pgm_function33[(1, 40, 0)] = 0.001
        pgm_function33[(1, 40, 1)] = 0.001
        pgm_function33[(1, 41, 0)] = 0.001
        pgm_function33[(1, 41, 1)] = 0.001
        pgm_function33[(1, 42, 0)] = 0.001
        pgm_function33[(1, 42, 1)] = 0.001
        pgm_function33[(1, 43, 0)] = 0.01
        pgm_function33[(1, 43, 1)] = 0.01
        pgm_function33[(1, 44, 0)] = 0.001
        pgm_function33[(1, 44, 1)] = 0.001
        pgm_function33[(1, 45, 0)] = 0.01
        pgm_function33[(1, 45, 1)] = 0.01
        pgm_function33[(1, 47, 0)] = 0.01
        pgm_function33[(1, 47, 1)] = 0.01
        pgm_function33[(1, 48, 0)] = 0.001
        pgm_function33[(1, 48, 1)] = 0.001
        pgm_function33[(1, 49, 0)] = 0.001
        pgm_function33[(1, 49, 1)] = 0.001
        pgm_function33[(1, 50, 0)] = 0.01
        pgm_function33[(1, 50, 1)] = 0.01
        pgm_function33[(1, 51, 0)] = 0.01
        pgm_function33[(1, 51, 1)] = 0.01
        pgm_function33[(1, 52, 0)] = 0.001
        pgm_function33[(1, 52, 1)] = 0.001
        pgm_function33[(1, 53, 0)] = 0.001
        pgm_function33[(1, 53, 1)] = 0.001
        pgm_function33[(1, 54, 0)] = 0.001
        pgm_function33[(1, 54, 1)] = 0.001
        pgm_function33[(1, 55, 0)] = 0.001
        pgm_function33[(1, 55, 1)] = 0.001
        pgm_function33[(1, 56, 0)] = 0.001
        pgm_function33[(1, 56, 1)] = 0.001
        pgm_function33[(1, 57, 0)] = 0.001
        pgm_function33[(1, 57, 1)] = 0.001
        pgm_function33[(1, 58, 0)] = 0.001
        pgm_function33[(1, 58, 1)] = 0.001
        pgm_function33[(1, 59, 0)] = 0.001
        pgm_function33[(1, 59, 1)] = 0.001
        pgm_function33[(1, 60, 0)] = 0.001
        pgm_function33[(1, 60, 1)] = 0.001
        pgm_function33[(1, 61, 0)] = 0.001
        pgm_function33[(1, 61, 1)] = 0.001
        pgm_function33[(1, 62, 0)] = 0.01
        pgm_function33[(1, 62, 1)] = 0.01
        pgm_function33[(1, 63, 0)] = 0.001
        pgm_function33[(1, 63, 1)] = 0.001
        pgm_function33[(1, 64, 0)] = 0.001
        pgm_function33[(1, 64, 1)] = 0.001
        pgm_function33[(1, 65, 0)] = 0.001
        pgm_function33[(1, 65, 1)] = 0.001
        pgm_function33[(1, 66, 0)] = 0.01
        pgm_function33[(1, 66, 1)] = 0.01
        pgm_function33[(1, 67, 0)] = 0.001
        pgm_function33[(1, 67, 1)] = 0.001
        pgm_function33[(1, 68, 0)] = 0.001
        pgm_function33[(1, 68, 1)] = 0.001
        pgm_function33[(1, 69, 0)] = 0.001
        pgm_function33[(1, 69, 1)] = 0.001
        pgm_function33[(1, 70, 0)] = 0.001
        pgm_function33[(1, 70, 1)] = 0.001
        pgm_function33[(1, 71, 0)] = 0.001
        pgm_function33[(1, 71, 1)] = 0.001
        pgm_function33[(1, 72, 0)] = 0.001
        pgm_function33[(1, 72, 1)] = 0.001
        pgm_function33[(1, 73, 0)] = 0.001
        pgm_function33[(1, 73, 1)] = 0.001
        pgm_function33[(1, 74, 0)] = 0.01
        pgm_function33[(1, 74, 1)] = 0.01
        pgm_function33[(1, 75, 0)] = 0.001
        pgm_function33[(1, 75, 1)] = 0.001
        pgm_function33[(2, 25, 0)] = 0.2
        pgm_function33[(2, 25, 1)] = 0.2
        pgm_function33[(2, 26, 0)] = 0.2
        pgm_function33[(2, 26, 1)] = 0.2
        pgm_function33[(2, 27, 0)] = 0.01
        pgm_function33[(2, 27, 1)] = 0.05
        pgm_function33[(2, 28, 0)] = 0.01
        pgm_function33[(2, 28, 1)] = 0.01
        pgm_function33[(2, 29, 0)] = 0.01
        pgm_function33[(2, 29, 1)] = 0.01
        pgm_function33[(2, 30, 0)] = 0.01
        pgm_function33[(2, 30, 1)] = 0.05
        pgm_function33[(2, 31, 0)] = 0.01
        pgm_function33[(2, 31, 1)] = 0.01
        pgm_function33[(2, 43, 0)] = 0.001
        pgm_function33[(2, 43, 1)] = 0.001
        pgm_function33[(2, 45, 0)] = 0.001
        pgm_function33[(2, 45, 1)] = 0.001
        pgm_function33[(2, 47, 0)] = 0.001
        pgm_function33[(2, 47, 1)] = 0.001
        pgm_function33[(2, 50, 0)] = 0.001
        pgm_function33[(2, 50, 1)] = 0.001
        pgm_function33[(2, 51, 0)] = 0.001
        pgm_function33[(2, 51, 1)] = 0.001
        pgm_function33[(2, 62, 0)] = 0.001
        pgm_function33[(2, 62, 1)] = 0.001
        pgm_function33[(2, 74, 0)] = 0.001
        pgm_function33[(2, 74, 1)] = 0.001
        pgm_function33[(3, 25, 0)] = 0.2
        pgm_function33[(3, 25, 1)] = 0.69
        pgm_function33[(3, 26, 0)] = 0.69
        pgm_function33[(3, 26, 1)] = 0.69
        pgm_function33[(3, 27, 1)] = 0.001
        pgm_function33[(3, 30, 1)] = 0.001
        pgm_function33[(3, 43, 0)] = 0.0001
        pgm_function33[(3, 43, 1)] = 0.0001
        pgm_function33[(3, 45, 0)] = 0.0001
        pgm_function33[(3, 45, 1)] = 0.0001
        pgm_function33[(3, 47, 0)] = 0.0001
        pgm_function33[(3, 47, 1)] = 0.0001
        pgm_function33[(3, 50, 0)] = 0.0001
        pgm_function33[(3, 50, 1)] = 0.0001
        pgm_function33[(3, 51, 0)] = 0.0001
        pgm_function33[(3, 51, 1)] = 0.0001
        pgm_function33[(3, 62, 0)] = 0.0001
        pgm_function33[(3, 62, 1)] = 0.0001
        pgm_function33[(3, 74, 0)] = 0.0001
        pgm_function33[(3, 74, 1)] = 0.0001
        pgm_function33[(4, 25, 0)] = 0.2
        pgm_function33[(4, 25, 1)] = 0.1
        pgm_function33[(4, 26, 0)] = 0.1
        pgm_function33[(4, 26, 1)] = 0.1

        pgm_function34 = pgm_factor34.set_sparse()
        pgm_function34[(0, 0)] = 1.0
        pgm_function34[(0, 1)] = 1.0
        pgm_function34[(0, 2)] = 1.0
        pgm_function34[(0, 3)] = 1.0
        pgm_function34[(0, 4)] = 1.0
        pgm_function34[(0, 5)] = 1.0
        pgm_function34[(0, 6)] = 1.0
        pgm_function34[(0, 7)] = 1.0
        pgm_function34[(0, 8)] = 1.0
        pgm_function34[(0, 9)] = 1.0
        pgm_function34[(0, 10)] = 1.0
        pgm_function34[(0, 11)] = 1.0
        pgm_function34[(0, 12)] = 1.0
        pgm_function34[(0, 13)] = 1.0
        pgm_function34[(0, 14)] = 1.0
        pgm_function34[(0, 15)] = 1.0
        pgm_function34[(0, 16)] = 1.0
        pgm_function34[(0, 17)] = 1.0
        pgm_function34[(0, 18)] = 1.0
        pgm_function34[(0, 19)] = 1.0
        pgm_function34[(0, 20)] = 1.0
        pgm_function34[(0, 21)] = 1.0
        pgm_function34[(0, 22)] = 1.0
        pgm_function34[(0, 23)] = 1.0
        pgm_function34[(0, 24)] = 1.0
        pgm_function34[(0, 26)] = 1.0
        pgm_function34[(0, 27)] = 0.995
        pgm_function34[(0, 28)] = 1.0
        pgm_function34[(0, 29)] = 1.0
        pgm_function34[(0, 30)] = 0.995
        pgm_function34[(0, 31)] = 1.0
        pgm_function34[(0, 32)] = 1.0
        pgm_function34[(0, 33)] = 1.0
        pgm_function34[(0, 34)] = 1.0
        pgm_function34[(0, 35)] = 1.0
        pgm_function34[(0, 36)] = 1.0
        pgm_function34[(0, 37)] = 1.0
        pgm_function34[(0, 38)] = 1.0
        pgm_function34[(0, 39)] = 1.0
        pgm_function34[(0, 40)] = 1.0
        pgm_function34[(0, 41)] = 1.0
        pgm_function34[(0, 42)] = 1.0
        pgm_function34[(0, 43)] = 1.0
        pgm_function34[(0, 44)] = 1.0
        pgm_function34[(0, 45)] = 1.0
        pgm_function34[(0, 46)] = 1.0
        pgm_function34[(0, 47)] = 1.0
        pgm_function34[(0, 48)] = 1.0
        pgm_function34[(0, 49)] = 1.0
        pgm_function34[(0, 50)] = 1.0
        pgm_function34[(0, 51)] = 1.0
        pgm_function34[(0, 52)] = 1.0
        pgm_function34[(0, 53)] = 1.0
        pgm_function34[(0, 54)] = 1.0
        pgm_function34[(0, 55)] = 1.0
        pgm_function34[(0, 56)] = 1.0
        pgm_function34[(0, 57)] = 1.0
        pgm_function34[(0, 58)] = 1.0
        pgm_function34[(0, 59)] = 1.0
        pgm_function34[(0, 60)] = 1.0
        pgm_function34[(0, 61)] = 1.0
        pgm_function34[(0, 62)] = 1.0
        pgm_function34[(0, 63)] = 1.0
        pgm_function34[(0, 64)] = 1.0
        pgm_function34[(0, 65)] = 1.0
        pgm_function34[(0, 66)] = 1.0
        pgm_function34[(0, 67)] = 1.0
        pgm_function34[(0, 68)] = 1.0
        pgm_function34[(0, 69)] = 1.0
        pgm_function34[(0, 70)] = 1.0
        pgm_function34[(0, 71)] = 1.0
        pgm_function34[(0, 72)] = 1.0
        pgm_function34[(0, 73)] = 1.0
        pgm_function34[(0, 74)] = 1.0
        pgm_function34[(0, 75)] = 1.0
        pgm_function34[(1, 25)] = 1.0
        pgm_function34[(1, 27)] = 0.005
        pgm_function34[(1, 30)] = 0.005

        pgm_function35 = pgm_factor35.set_sparse()
        pgm_function35[(0, 0)] = 0.999
        pgm_function35[(0, 1)] = 0.999
        pgm_function35[(0, 2)] = 0.999
        pgm_function35[(0, 3)] = 0.999
        pgm_function35[(0, 4)] = 0.999
        pgm_function35[(0, 5)] = 0.999
        pgm_function35[(0, 6)] = 0.999
        pgm_function35[(0, 7)] = 0.999
        pgm_function35[(0, 8)] = 0.999
        pgm_function35[(0, 9)] = 0.999
        pgm_function35[(0, 10)] = 0.99
        pgm_function35[(0, 11)] = 0.999
        pgm_function35[(0, 12)] = 0.999
        pgm_function35[(0, 13)] = 0.999
        pgm_function35[(0, 14)] = 0.999
        pgm_function35[(0, 15)] = 0.999
        pgm_function35[(0, 16)] = 0.999
        pgm_function35[(0, 17)] = 0.999
        pgm_function35[(0, 18)] = 0.999
        pgm_function35[(0, 19)] = 0.999
        pgm_function35[(0, 20)] = 0.999
        pgm_function35[(0, 21)] = 0.999
        pgm_function35[(0, 22)] = 0.999
        pgm_function35[(0, 23)] = 0.99
        pgm_function35[(0, 24)] = 0.999
        pgm_function35[(0, 25)] = 0.94
        pgm_function35[(0, 26)] = 0.94
        pgm_function35[(0, 30)] = 0.989
        pgm_function35[(0, 31)] = 0.989
        pgm_function35[(0, 32)] = 0.9
        pgm_function35[(0, 33)] = 0.9
        pgm_function35[(0, 34)] = 0.999
        pgm_function35[(0, 35)] = 0.999
        pgm_function35[(0, 36)] = 0.999
        pgm_function35[(0, 37)] = 0.999
        pgm_function35[(0, 38)] = 0.999
        pgm_function35[(0, 39)] = 0.999
        pgm_function35[(0, 40)] = 0.999
        pgm_function35[(0, 41)] = 0.999
        pgm_function35[(0, 42)] = 0.999
        pgm_function35[(0, 43)] = 0.8389
        pgm_function35[(0, 44)] = 0.999
        pgm_function35[(0, 45)] = 0.84
        pgm_function35[(0, 46)] = 0.999
        pgm_function35[(0, 47)] = 0.84
        pgm_function35[(0, 48)] = 0.999
        pgm_function35[(0, 49)] = 0.999
        pgm_function35[(0, 50)] = 0.8389
        pgm_function35[(0, 51)] = 0.8389
        pgm_function35[(0, 52)] = 0.999
        pgm_function35[(0, 53)] = 0.999
        pgm_function35[(0, 54)] = 0.999
        pgm_function35[(0, 55)] = 0.999
        pgm_function35[(0, 56)] = 0.919
        pgm_function35[(0, 57)] = 0.999
        pgm_function35[(0, 58)] = 0.999
        pgm_function35[(0, 59)] = 0.999
        pgm_function35[(0, 60)] = 0.999
        pgm_function35[(0, 61)] = 0.999
        pgm_function35[(0, 62)] = 0.8389
        pgm_function35[(0, 63)] = 0.999
        pgm_function35[(0, 64)] = 0.919
        pgm_function35[(0, 65)] = 0.999
        pgm_function35[(0, 66)] = 0.99
        pgm_function35[(0, 67)] = 0.999
        pgm_function35[(0, 68)] = 0.999
        pgm_function35[(0, 69)] = 0.999
        pgm_function35[(0, 70)] = 0.999
        pgm_function35[(0, 71)] = 0.999
        pgm_function35[(0, 72)] = 0.999
        pgm_function35[(0, 73)] = 0.999
        pgm_function35[(0, 74)] = 0.8389
        pgm_function35[(0, 75)] = 0.999
        pgm_function35[(1, 0)] = 0.001
        pgm_function35[(1, 1)] = 0.001
        pgm_function35[(1, 2)] = 0.001
        pgm_function35[(1, 3)] = 0.001
        pgm_function35[(1, 4)] = 0.001
        pgm_function35[(1, 5)] = 0.001
        pgm_function35[(1, 6)] = 0.001
        pgm_function35[(1, 7)] = 0.001
        pgm_function35[(1, 8)] = 0.001
        pgm_function35[(1, 9)] = 0.001
        pgm_function35[(1, 10)] = 0.01
        pgm_function35[(1, 11)] = 0.001
        pgm_function35[(1, 12)] = 0.001
        pgm_function35[(1, 13)] = 0.001
        pgm_function35[(1, 14)] = 0.001
        pgm_function35[(1, 15)] = 0.001
        pgm_function35[(1, 16)] = 0.001
        pgm_function35[(1, 17)] = 0.001
        pgm_function35[(1, 18)] = 0.001
        pgm_function35[(1, 19)] = 0.001
        pgm_function35[(1, 20)] = 0.001
        pgm_function35[(1, 21)] = 0.001
        pgm_function35[(1, 22)] = 0.001
        pgm_function35[(1, 23)] = 0.01
        pgm_function35[(1, 24)] = 0.001
        pgm_function35[(1, 25)] = 0.05
        pgm_function35[(1, 26)] = 0.05
        pgm_function35[(1, 27)] = 0.01
        pgm_function35[(1, 28)] = 0.01
        pgm_function35[(1, 30)] = 0.01
        pgm_function35[(1, 31)] = 0.01
        pgm_function35[(1, 32)] = 0.09
        pgm_function35[(1, 33)] = 0.09
        pgm_function35[(1, 34)] = 0.001
        pgm_function35[(1, 35)] = 0.001
        pgm_function35[(1, 36)] = 0.001
        pgm_function35[(1, 37)] = 0.001
        pgm_function35[(1, 38)] = 0.001
        pgm_function35[(1, 39)] = 0.001
        pgm_function35[(1, 40)] = 0.001
        pgm_function35[(1, 41)] = 0.001
        pgm_function35[(1, 42)] = 0.001
        pgm_function35[(1, 43)] = 0.1
        pgm_function35[(1, 44)] = 0.001
        pgm_function35[(1, 45)] = 0.1
        pgm_function35[(1, 46)] = 0.001
        pgm_function35[(1, 47)] = 0.1
        pgm_function35[(1, 48)] = 0.001
        pgm_function35[(1, 49)] = 0.001
        pgm_function35[(1, 50)] = 0.1
        pgm_function35[(1, 51)] = 0.1
        pgm_function35[(1, 52)] = 0.001
        pgm_function35[(1, 53)] = 0.001
        pgm_function35[(1, 54)] = 0.001
        pgm_function35[(1, 55)] = 0.001
        pgm_function35[(1, 56)] = 0.05
        pgm_function35[(1, 57)] = 0.001
        pgm_function35[(1, 58)] = 0.001
        pgm_function35[(1, 59)] = 0.001
        pgm_function35[(1, 60)] = 0.001
        pgm_function35[(1, 61)] = 0.001
        pgm_function35[(1, 62)] = 0.1
        pgm_function35[(1, 63)] = 0.001
        pgm_function35[(1, 64)] = 0.05
        pgm_function35[(1, 65)] = 0.001
        pgm_function35[(1, 66)] = 0.01
        pgm_function35[(1, 67)] = 0.001
        pgm_function35[(1, 68)] = 0.001
        pgm_function35[(1, 69)] = 0.001
        pgm_function35[(1, 70)] = 0.001
        pgm_function35[(1, 71)] = 0.001
        pgm_function35[(1, 72)] = 0.001
        pgm_function35[(1, 73)] = 0.001
        pgm_function35[(1, 74)] = 0.1
        pgm_function35[(1, 75)] = 0.001
        pgm_function35[(2, 25)] = 0.01
        pgm_function35[(2, 26)] = 0.01
        pgm_function35[(2, 27)] = 0.4
        pgm_function35[(2, 28)] = 0.4
        pgm_function35[(2, 30)] = 0.001
        pgm_function35[(2, 31)] = 0.001
        pgm_function35[(2, 32)] = 0.01
        pgm_function35[(2, 33)] = 0.01
        pgm_function35[(2, 43)] = 0.05
        pgm_function35[(2, 45)] = 0.05
        pgm_function35[(2, 47)] = 0.05
        pgm_function35[(2, 50)] = 0.05
        pgm_function35[(2, 51)] = 0.05
        pgm_function35[(2, 56)] = 0.02
        pgm_function35[(2, 62)] = 0.05
        pgm_function35[(2, 64)] = 0.02
        pgm_function35[(2, 74)] = 0.05
        pgm_function35[(3, 27)] = 0.58
        pgm_function35[(3, 28)] = 0.58
        pgm_function35[(3, 43)] = 0.01
        pgm_function35[(3, 45)] = 0.01
        pgm_function35[(3, 47)] = 0.01
        pgm_function35[(3, 50)] = 0.01
        pgm_function35[(3, 51)] = 0.01
        pgm_function35[(3, 56)] = 0.01
        pgm_function35[(3, 62)] = 0.01
        pgm_function35[(3, 64)] = 0.01
        pgm_function35[(3, 74)] = 0.01
        pgm_function35[(4, 27)] = 0.01
        pgm_function35[(4, 28)] = 0.01
        pgm_function35[(4, 29)] = 0.2
        pgm_function35[(4, 43)] = 0.001
        pgm_function35[(4, 50)] = 0.001
        pgm_function35[(4, 51)] = 0.001
        pgm_function35[(4, 56)] = 0.001
        pgm_function35[(4, 62)] = 0.001
        pgm_function35[(4, 64)] = 0.001
        pgm_function35[(4, 74)] = 0.001
        pgm_function35[(5, 29)] = 0.8
        pgm_function35[(5, 43)] = 0.0001
        pgm_function35[(5, 50)] = 0.0001
        pgm_function35[(5, 51)] = 0.0001
        pgm_function35[(5, 62)] = 0.0001
        pgm_function35[(5, 74)] = 0.0001

        pgm_function36 = pgm_factor36.set_sparse()
        pgm_function36[(0, 0)] = 0.9999
        pgm_function36[(0, 1)] = 0.999
        pgm_function36[(0, 2)] = 0.9999
        pgm_function36[(0, 3)] = 0.8
        pgm_function36[(0, 4)] = 0.9999
        pgm_function36[(0, 5)] = 0.9999
        pgm_function36[(0, 6)] = 0.9999
        pgm_function36[(0, 7)] = 0.9999
        pgm_function36[(0, 8)] = 0.8
        pgm_function36[(0, 9)] = 0.9999
        pgm_function36[(0, 10)] = 0.9999
        pgm_function36[(0, 11)] = 0.4
        pgm_function36[(0, 12)] = 0.7
        pgm_function36[(0, 13)] = 0.9999
        pgm_function36[(0, 14)] = 0.9999
        pgm_function36[(0, 15)] = 0.97
        pgm_function36[(0, 16)] = 0.9999
        pgm_function36[(0, 17)] = 0.9
        pgm_function36[(0, 18)] = 0.9999
        pgm_function36[(0, 19)] = 0.9999
        pgm_function36[(0, 20)] = 0.97
        pgm_function36[(0, 21)] = 0.9999
        pgm_function36[(0, 22)] = 0.05
        pgm_function36[(0, 23)] = 0.9999
        pgm_function36[(0, 24)] = 0.7
        pgm_function36[(0, 25)] = 0.9999
        pgm_function36[(0, 26)] = 0.9999
        pgm_function36[(0, 27)] = 0.9999
        pgm_function36[(0, 28)] = 0.9999
        pgm_function36[(0, 29)] = 0.9999
        pgm_function36[(0, 30)] = 0.975
        pgm_function36[(0, 31)] = 0.9999
        pgm_function36[(0, 32)] = 0.9999
        pgm_function36[(0, 33)] = 0.9999
        pgm_function36[(0, 34)] = 0.9999
        pgm_function36[(0, 35)] = 0.9999
        pgm_function36[(0, 36)] = 0.9999
        pgm_function36[(0, 37)] = 0.9999
        pgm_function36[(0, 38)] = 0.9999
        pgm_function36[(0, 39)] = 0.9999
        pgm_function36[(0, 40)] = 0.9999
        pgm_function36[(0, 41)] = 0.9999
        pgm_function36[(0, 42)] = 0.9999
        pgm_function36[(0, 43)] = 0.9999
        pgm_function36[(0, 44)] = 0.9999
        pgm_function36[(0, 45)] = 0.9999
        pgm_function36[(0, 46)] = 0.999
        pgm_function36[(0, 47)] = 0.9999
        pgm_function36[(0, 48)] = 0.9999
        pgm_function36[(0, 49)] = 0.9999
        pgm_function36[(0, 50)] = 0.9999
        pgm_function36[(0, 51)] = 0.9999
        pgm_function36[(0, 52)] = 0.9999
        pgm_function36[(0, 53)] = 0.9999
        pgm_function36[(0, 54)] = 0.9999
        pgm_function36[(0, 55)] = 0.9999
        pgm_function36[(0, 56)] = 0.9999
        pgm_function36[(0, 57)] = 0.9999
        pgm_function36[(0, 58)] = 0.9999
        pgm_function36[(0, 59)] = 0.9999
        pgm_function36[(0, 60)] = 0.9999
        pgm_function36[(0, 61)] = 0.9999
        pgm_function36[(0, 62)] = 0.9999
        pgm_function36[(0, 63)] = 0.9999
        pgm_function36[(0, 64)] = 0.9999
        pgm_function36[(0, 65)] = 0.9999
        pgm_function36[(0, 66)] = 0.9999
        pgm_function36[(0, 67)] = 0.9
        pgm_function36[(0, 68)] = 0.9999
        pgm_function36[(0, 69)] = 0.8
        pgm_function36[(0, 70)] = 0.8
        pgm_function36[(0, 71)] = 0.8
        pgm_function36[(0, 72)] = 0.8
        pgm_function36[(0, 73)] = 0.9999
        pgm_function36[(0, 74)] = 0.9999
        pgm_function36[(0, 75)] = 0.9999
        pgm_function36[(1, 0)] = 0.0001
        pgm_function36[(1, 1)] = 0.001
        pgm_function36[(1, 2)] = 0.0001
        pgm_function36[(1, 3)] = 0.17
        pgm_function36[(1, 4)] = 0.0001
        pgm_function36[(1, 5)] = 0.0001
        pgm_function36[(1, 6)] = 0.0001
        pgm_function36[(1, 7)] = 0.0001
        pgm_function36[(1, 8)] = 0.15
        pgm_function36[(1, 9)] = 0.0001
        pgm_function36[(1, 10)] = 0.0001
        pgm_function36[(1, 11)] = 0.5
        pgm_function36[(1, 12)] = 0.25
        pgm_function36[(1, 13)] = 0.0001
        pgm_function36[(1, 14)] = 0.0001
        pgm_function36[(1, 15)] = 0.02
        pgm_function36[(1, 16)] = 0.0001
        pgm_function36[(1, 17)] = 0.09
        pgm_function36[(1, 18)] = 0.0001
        pgm_function36[(1, 19)] = 0.0001
        pgm_function36[(1, 20)] = 0.02
        pgm_function36[(1, 21)] = 0.0001
        pgm_function36[(1, 22)] = 0.6
        pgm_function36[(1, 23)] = 0.0001
        pgm_function36[(1, 24)] = 0.25
        pgm_function36[(1, 25)] = 0.0001
        pgm_function36[(1, 26)] = 0.0001
        pgm_function36[(1, 27)] = 0.0001
        pgm_function36[(1, 28)] = 0.0001
        pgm_function36[(1, 29)] = 0.0001
        pgm_function36[(1, 30)] = 0.02
        pgm_function36[(1, 31)] = 0.0001
        pgm_function36[(1, 32)] = 0.0001
        pgm_function36[(1, 33)] = 0.0001
        pgm_function36[(1, 34)] = 0.0001
        pgm_function36[(1, 35)] = 0.0001
        pgm_function36[(1, 36)] = 0.0001
        pgm_function36[(1, 37)] = 0.0001
        pgm_function36[(1, 38)] = 0.0001
        pgm_function36[(1, 39)] = 0.0001
        pgm_function36[(1, 40)] = 0.0001
        pgm_function36[(1, 41)] = 0.0001
        pgm_function36[(1, 42)] = 0.0001
        pgm_function36[(1, 43)] = 0.0001
        pgm_function36[(1, 44)] = 0.0001
        pgm_function36[(1, 45)] = 0.0001
        pgm_function36[(1, 46)] = 0.001
        pgm_function36[(1, 47)] = 0.0001
        pgm_function36[(1, 48)] = 0.0001
        pgm_function36[(1, 49)] = 0.0001
        pgm_function36[(1, 50)] = 0.0001
        pgm_function36[(1, 51)] = 0.0001
        pgm_function36[(1, 52)] = 0.0001
        pgm_function36[(1, 53)] = 0.0001
        pgm_function36[(1, 54)] = 0.0001
        pgm_function36[(1, 55)] = 0.0001
        pgm_function36[(1, 56)] = 0.0001
        pgm_function36[(1, 57)] = 0.0001
        pgm_function36[(1, 58)] = 0.0001
        pgm_function36[(1, 59)] = 0.0001
        pgm_function36[(1, 60)] = 0.0001
        pgm_function36[(1, 61)] = 0.0001
        pgm_function36[(1, 62)] = 0.0001
        pgm_function36[(1, 63)] = 0.0001
        pgm_function36[(1, 64)] = 0.0001
        pgm_function36[(1, 65)] = 0.0001
        pgm_function36[(1, 66)] = 0.0001
        pgm_function36[(1, 67)] = 0.08
        pgm_function36[(1, 68)] = 0.0001
        pgm_function36[(1, 69)] = 0.17
        pgm_function36[(1, 70)] = 0.15
        pgm_function36[(1, 71)] = 0.15
        pgm_function36[(1, 72)] = 0.15
        pgm_function36[(1, 73)] = 0.0001
        pgm_function36[(1, 74)] = 0.0001
        pgm_function36[(1, 75)] = 0.0001
        pgm_function36[(2, 3)] = 0.03
        pgm_function36[(2, 8)] = 0.05
        pgm_function36[(2, 11)] = 0.1
        pgm_function36[(2, 12)] = 0.05
        pgm_function36[(2, 15)] = 0.01
        pgm_function36[(2, 17)] = 0.01
        pgm_function36[(2, 20)] = 0.01
        pgm_function36[(2, 22)] = 0.35
        pgm_function36[(2, 24)] = 0.05
        pgm_function36[(2, 30)] = 0.005
        pgm_function36[(2, 67)] = 0.02
        pgm_function36[(2, 69)] = 0.03
        pgm_function36[(2, 70)] = 0.05
        pgm_function36[(2, 71)] = 0.05
        pgm_function36[(2, 72)] = 0.05

        pgm_function37 = pgm_factor37.set_sparse()
        pgm_function37[(0, 0)] = 1.0
        pgm_function37[(0, 1)] = 1.0
        pgm_function37[(0, 2)] = 1.0
        pgm_function37[(0, 3)] = 1.0
        pgm_function37[(0, 4)] = 1.0
        pgm_function37[(0, 5)] = 1.0
        pgm_function37[(0, 6)] = 1.0
        pgm_function37[(0, 7)] = 1.0
        pgm_function37[(0, 8)] = 1.0
        pgm_function37[(0, 9)] = 1.0
        pgm_function37[(0, 10)] = 1.0
        pgm_function37[(0, 11)] = 1.0
        pgm_function37[(0, 12)] = 1.0
        pgm_function37[(0, 13)] = 1.0
        pgm_function37[(0, 14)] = 1.0
        pgm_function37[(0, 15)] = 1.0
        pgm_function37[(0, 16)] = 1.0
        pgm_function37[(0, 17)] = 1.0
        pgm_function37[(0, 18)] = 1.0
        pgm_function37[(0, 19)] = 1.0
        pgm_function37[(0, 20)] = 1.0
        pgm_function37[(0, 21)] = 1.0
        pgm_function37[(0, 22)] = 1.0
        pgm_function37[(0, 23)] = 1.0
        pgm_function37[(0, 24)] = 1.0
        pgm_function37[(0, 25)] = 1.0
        pgm_function37[(0, 26)] = 1.0
        pgm_function37[(0, 27)] = 1.0
        pgm_function37[(0, 28)] = 1.0
        pgm_function37[(0, 29)] = 1.0
        pgm_function37[(0, 30)] = 1.0
        pgm_function37[(0, 31)] = 1.0
        pgm_function37[(0, 32)] = 1.0
        pgm_function37[(0, 33)] = 1.0
        pgm_function37[(0, 34)] = 1.0
        pgm_function37[(0, 35)] = 1.0
        pgm_function37[(0, 36)] = 1.0
        pgm_function37[(0, 37)] = 1.0
        pgm_function37[(0, 38)] = 1.0
        pgm_function37[(0, 39)] = 1.0
        pgm_function37[(0, 40)] = 1.0
        pgm_function37[(0, 41)] = 1.0
        pgm_function37[(0, 42)] = 1.0
        pgm_function37[(0, 43)] = 1.0
        pgm_function37[(0, 44)] = 1.0
        pgm_function37[(0, 45)] = 1.0
        pgm_function37[(0, 46)] = 1.0
        pgm_function37[(0, 47)] = 1.0
        pgm_function37[(0, 48)] = 1.0
        pgm_function37[(0, 49)] = 1.0
        pgm_function37[(0, 50)] = 1.0
        pgm_function37[(0, 51)] = 1.0
        pgm_function37[(0, 52)] = 1.0
        pgm_function37[(0, 53)] = 1.0
        pgm_function37[(0, 55)] = 0.1
        pgm_function37[(0, 56)] = 1.0
        pgm_function37[(0, 57)] = 1.0
        pgm_function37[(0, 58)] = 1.0
        pgm_function37[(0, 59)] = 1.0
        pgm_function37[(0, 60)] = 1.0
        pgm_function37[(0, 61)] = 1.0
        pgm_function37[(0, 62)] = 1.0
        pgm_function37[(0, 63)] = 1.0
        pgm_function37[(0, 64)] = 1.0
        pgm_function37[(0, 65)] = 1.0
        pgm_function37[(0, 66)] = 1.0
        pgm_function37[(0, 67)] = 1.0
        pgm_function37[(0, 68)] = 1.0
        pgm_function37[(0, 69)] = 1.0
        pgm_function37[(0, 70)] = 1.0
        pgm_function37[(0, 71)] = 1.0
        pgm_function37[(0, 72)] = 1.0
        pgm_function37[(0, 73)] = 1.0
        pgm_function37[(0, 74)] = 1.0
        pgm_function37[(0, 75)] = 1.0
        pgm_function37[(1, 54)] = 1.0
        pgm_function37[(1, 55)] = 0.9

        pgm_function38 = pgm_factor38.set_sparse()
        pgm_function38[(0, 0, 0)] = 1.0
        pgm_function38[(0, 1, 0)] = 1.0
        pgm_function38[(0, 2, 0)] = 1.0
        pgm_function38[(0, 3, 0)] = 1.0
        pgm_function38[(0, 4, 0)] = 1.0
        pgm_function38[(0, 5, 0)] = 1.0
        pgm_function38[(0, 6, 0)] = 1.0
        pgm_function38[(0, 7, 0)] = 1.0
        pgm_function38[(0, 8, 0)] = 1.0
        pgm_function38[(0, 9, 0)] = 1.0
        pgm_function38[(0, 10, 0)] = 1.0
        pgm_function38[(0, 11, 0)] = 1.0
        pgm_function38[(0, 12, 0)] = 1.0
        pgm_function38[(0, 13, 0)] = 1.0
        pgm_function38[(0, 14, 0)] = 1.0
        pgm_function38[(0, 15, 0)] = 1.0
        pgm_function38[(0, 16, 0)] = 1.0
        pgm_function38[(0, 17, 0)] = 1.0
        pgm_function38[(0, 18, 0)] = 1.0
        pgm_function38[(0, 19, 0)] = 1.0
        pgm_function38[(0, 20, 0)] = 1.0
        pgm_function38[(0, 21, 0)] = 1.0
        pgm_function38[(0, 22, 0)] = 1.0
        pgm_function38[(0, 23, 0)] = 1.0
        pgm_function38[(0, 24, 0)] = 1.0
        pgm_function38[(0, 25, 0)] = 1.0
        pgm_function38[(0, 26, 0)] = 1.0
        pgm_function38[(0, 27, 0)] = 1.0
        pgm_function38[(0, 28, 0)] = 1.0
        pgm_function38[(0, 29, 0)] = 1.0
        pgm_function38[(0, 30, 0)] = 1.0
        pgm_function38[(0, 31, 0)] = 1.0
        pgm_function38[(0, 32, 0)] = 1.0
        pgm_function38[(0, 33, 0)] = 1.0
        pgm_function38[(0, 34, 0)] = 1.0
        pgm_function38[(0, 35, 0)] = 1.0
        pgm_function38[(0, 36, 0)] = 1.0
        pgm_function38[(0, 37, 0)] = 1.0
        pgm_function38[(0, 38, 0)] = 1.0
        pgm_function38[(0, 39, 0)] = 1.0
        pgm_function38[(0, 40, 0)] = 1.0
        pgm_function38[(0, 41, 0)] = 1.0
        pgm_function38[(0, 42, 0)] = 1.0
        pgm_function38[(0, 43, 0)] = 1.0
        pgm_function38[(0, 44, 0)] = 1.0
        pgm_function38[(0, 45, 0)] = 1.0
        pgm_function38[(0, 46, 0)] = 1.0
        pgm_function38[(0, 47, 0)] = 1.0
        pgm_function38[(0, 48, 0)] = 1.0
        pgm_function38[(0, 49, 0)] = 1.0
        pgm_function38[(0, 50, 0)] = 1.0
        pgm_function38[(0, 51, 0)] = 1.0
        pgm_function38[(0, 52, 0)] = 1.0
        pgm_function38[(0, 53, 0)] = 1.0
        pgm_function38[(0, 54, 0)] = 1.0
        pgm_function38[(0, 55, 0)] = 1.0
        pgm_function38[(0, 56, 0)] = 1.0
        pgm_function38[(0, 57, 0)] = 1.0
        pgm_function38[(0, 58, 0)] = 1.0
        pgm_function38[(0, 59, 0)] = 1.0
        pgm_function38[(0, 60, 0)] = 1.0
        pgm_function38[(0, 61, 0)] = 1.0
        pgm_function38[(0, 62, 0)] = 1.0
        pgm_function38[(0, 63, 0)] = 1.0
        pgm_function38[(0, 64, 0)] = 1.0
        pgm_function38[(0, 65, 0)] = 1.0
        pgm_function38[(0, 66, 0)] = 1.0
        pgm_function38[(0, 67, 0)] = 1.0
        pgm_function38[(0, 68, 0)] = 1.0
        pgm_function38[(0, 69, 0)] = 1.0
        pgm_function38[(0, 70, 0)] = 1.0
        pgm_function38[(0, 71, 0)] = 1.0
        pgm_function38[(0, 72, 0)] = 1.0
        pgm_function38[(0, 73, 0)] = 1.0
        pgm_function38[(0, 74, 0)] = 1.0
        pgm_function38[(0, 75, 0)] = 1.0
        pgm_function38[(1, 0, 1)] = 0.6
        pgm_function38[(1, 0, 2)] = 0.998
        pgm_function38[(1, 0, 3)] = 0.99
        pgm_function38[(1, 1, 1)] = 0.6
        pgm_function38[(1, 1, 2)] = 0.998
        pgm_function38[(1, 1, 3)] = 0.99
        pgm_function38[(1, 2, 1)] = 0.6
        pgm_function38[(1, 2, 2)] = 0.998
        pgm_function38[(1, 2, 3)] = 0.99
        pgm_function38[(1, 3, 1)] = 0.7
        pgm_function38[(1, 3, 2)] = 0.998
        pgm_function38[(1, 3, 3)] = 0.99
        pgm_function38[(1, 4, 1)] = 0.6
        pgm_function38[(1, 4, 2)] = 0.998
        pgm_function38[(1, 4, 3)] = 0.99
        pgm_function38[(1, 5, 1)] = 0.6
        pgm_function38[(1, 5, 2)] = 0.998
        pgm_function38[(1, 5, 3)] = 0.99
        pgm_function38[(1, 6, 1)] = 0.6
        pgm_function38[(1, 6, 2)] = 0.998
        pgm_function38[(1, 6, 3)] = 0.99
        pgm_function38[(1, 7, 1)] = 0.7
        pgm_function38[(1, 7, 2)] = 0.998
        pgm_function38[(1, 7, 3)] = 0.99
        pgm_function38[(1, 8, 1)] = 0.7
        pgm_function38[(1, 8, 2)] = 0.998
        pgm_function38[(1, 8, 3)] = 0.99
        pgm_function38[(1, 9, 1)] = 0.6
        pgm_function38[(1, 9, 2)] = 0.998
        pgm_function38[(1, 9, 3)] = 0.99
        pgm_function38[(1, 10, 1)] = 0.7
        pgm_function38[(1, 10, 2)] = 0.998
        pgm_function38[(1, 10, 3)] = 0.99
        pgm_function38[(1, 11, 1)] = 0.6
        pgm_function38[(1, 11, 2)] = 0.998
        pgm_function38[(1, 11, 3)] = 0.99
        pgm_function38[(1, 12, 1)] = 0.6
        pgm_function38[(1, 12, 2)] = 0.998
        pgm_function38[(1, 12, 3)] = 0.99
        pgm_function38[(1, 13, 1)] = 0.6
        pgm_function38[(1, 13, 2)] = 0.998
        pgm_function38[(1, 13, 3)] = 0.99
        pgm_function38[(1, 14, 1)] = 0.7
        pgm_function38[(1, 14, 2)] = 0.998
        pgm_function38[(1, 14, 3)] = 0.99
        pgm_function38[(1, 15, 1)] = 0.7
        pgm_function38[(1, 15, 2)] = 0.998
        pgm_function38[(1, 15, 3)] = 0.99
        pgm_function38[(1, 16, 1)] = 0.6
        pgm_function38[(1, 16, 2)] = 0.998
        pgm_function38[(1, 16, 3)] = 0.99
        pgm_function38[(1, 17, 1)] = 0.6
        pgm_function38[(1, 17, 2)] = 0.998
        pgm_function38[(1, 17, 3)] = 0.99
        pgm_function38[(1, 18, 1)] = 0.6
        pgm_function38[(1, 18, 2)] = 0.998
        pgm_function38[(1, 18, 3)] = 0.99
        pgm_function38[(1, 19, 1)] = 0.6
        pgm_function38[(1, 19, 2)] = 0.998
        pgm_function38[(1, 19, 3)] = 0.99
        pgm_function38[(1, 20, 1)] = 0.6
        pgm_function38[(1, 20, 2)] = 0.998
        pgm_function38[(1, 20, 3)] = 0.99
        pgm_function38[(1, 21, 1)] = 0.6
        pgm_function38[(1, 21, 2)] = 0.998
        pgm_function38[(1, 21, 3)] = 0.99
        pgm_function38[(1, 22, 1)] = 0.6
        pgm_function38[(1, 22, 2)] = 0.998
        pgm_function38[(1, 22, 3)] = 0.99
        pgm_function38[(1, 23, 1)] = 0.7
        pgm_function38[(1, 23, 2)] = 0.998
        pgm_function38[(1, 23, 3)] = 0.99
        pgm_function38[(1, 24, 1)] = 0.6
        pgm_function38[(1, 24, 2)] = 0.998
        pgm_function38[(1, 24, 3)] = 0.99
        pgm_function38[(1, 25, 1)] = 0.8
        pgm_function38[(1, 25, 2)] = 0.998
        pgm_function38[(1, 25, 3)] = 0.99
        pgm_function38[(1, 26, 1)] = 0.8
        pgm_function38[(1, 26, 2)] = 0.998
        pgm_function38[(1, 26, 3)] = 0.99
        pgm_function38[(1, 27, 1)] = 0.8
        pgm_function38[(1, 27, 2)] = 0.998
        pgm_function38[(1, 27, 3)] = 0.99
        pgm_function38[(1, 28, 1)] = 0.8
        pgm_function38[(1, 28, 2)] = 0.998
        pgm_function38[(1, 28, 3)] = 0.99
        pgm_function38[(1, 29, 1)] = 0.8
        pgm_function38[(1, 29, 2)] = 0.998
        pgm_function38[(1, 29, 3)] = 0.99
        pgm_function38[(1, 30, 1)] = 0.8
        pgm_function38[(1, 30, 2)] = 0.998
        pgm_function38[(1, 30, 3)] = 0.99
        pgm_function38[(1, 31, 1)] = 0.8
        pgm_function38[(1, 31, 2)] = 0.998
        pgm_function38[(1, 31, 3)] = 0.99
        pgm_function38[(1, 32, 1)] = 0.8
        pgm_function38[(1, 32, 2)] = 0.998
        pgm_function38[(1, 32, 3)] = 0.99
        pgm_function38[(1, 33, 1)] = 0.8
        pgm_function38[(1, 33, 2)] = 0.998
        pgm_function38[(1, 33, 3)] = 0.99
        pgm_function38[(1, 34, 1)] = 0.975
        pgm_function38[(1, 34, 2)] = 0.998
        pgm_function38[(1, 34, 3)] = 0.99
        pgm_function38[(1, 35, 1)] = 0.96
        pgm_function38[(1, 35, 2)] = 0.998
        pgm_function38[(1, 35, 3)] = 0.99
        pgm_function38[(1, 36, 1)] = 0.94
        pgm_function38[(1, 36, 2)] = 0.998
        pgm_function38[(1, 36, 3)] = 0.99
        pgm_function38[(1, 37, 1)] = 0.96
        pgm_function38[(1, 37, 2)] = 0.998
        pgm_function38[(1, 37, 3)] = 0.99
        pgm_function38[(1, 38, 1)] = 0.79
        pgm_function38[(1, 38, 2)] = 0.998
        pgm_function38[(1, 38, 3)] = 0.99
        pgm_function38[(1, 39, 1)] = 0.89
        pgm_function38[(1, 39, 2)] = 0.998
        pgm_function38[(1, 39, 3)] = 0.99
        pgm_function38[(1, 40, 1)] = 0.6
        pgm_function38[(1, 40, 2)] = 0.998
        pgm_function38[(1, 40, 3)] = 0.99
        pgm_function38[(1, 41, 1)] = 0.975
        pgm_function38[(1, 41, 2)] = 0.998
        pgm_function38[(1, 41, 3)] = 0.99
        pgm_function38[(1, 42, 1)] = 0.96
        pgm_function38[(1, 42, 2)] = 0.998
        pgm_function38[(1, 42, 3)] = 0.99
        pgm_function38[(1, 43, 1)] = 0.94
        pgm_function38[(1, 43, 2)] = 0.998
        pgm_function38[(1, 43, 3)] = 0.99
        pgm_function38[(1, 44, 1)] = 0.2
        pgm_function38[(1, 44, 2)] = 0.998
        pgm_function38[(1, 44, 3)] = 0.99
        pgm_function38[(1, 45, 1)] = 0.5
        pgm_function38[(1, 45, 2)] = 0.998
        pgm_function38[(1, 45, 3)] = 0.99
        pgm_function38[(1, 46, 1)] = 0.1
        pgm_function38[(1, 46, 2)] = 0.998
        pgm_function38[(1, 46, 3)] = 0.99
        pgm_function38[(1, 47, 1)] = 0.5
        pgm_function38[(1, 47, 2)] = 0.998
        pgm_function38[(1, 47, 3)] = 0.99
        pgm_function38[(1, 48, 1)] = 1.0
        pgm_function38[(1, 48, 2)] = 0.998
        pgm_function38[(1, 48, 3)] = 0.99
        pgm_function38[(1, 49, 1)] = 0.96
        pgm_function38[(1, 49, 2)] = 0.998
        pgm_function38[(1, 49, 3)] = 0.99
        pgm_function38[(1, 50, 1)] = 0.01
        pgm_function38[(1, 50, 2)] = 0.998
        pgm_function38[(1, 50, 3)] = 0.99
        pgm_function38[(1, 51, 1)] = 0.2
        pgm_function38[(1, 51, 2)] = 0.998
        pgm_function38[(1, 51, 3)] = 0.99
        pgm_function38[(1, 52, 1)] = 0.2
        pgm_function38[(1, 52, 2)] = 0.998
        pgm_function38[(1, 52, 3)] = 0.99
        pgm_function38[(1, 53, 1)] = 0.55
        pgm_function38[(1, 53, 2)] = 0.998
        pgm_function38[(1, 53, 3)] = 0.99
        pgm_function38[(1, 54, 1)] = 0.98
        pgm_function38[(1, 54, 2)] = 0.998
        pgm_function38[(1, 54, 3)] = 0.99
        pgm_function38[(1, 55, 1)] = 0.7
        pgm_function38[(1, 55, 2)] = 0.998
        pgm_function38[(1, 55, 3)] = 0.99
        pgm_function38[(1, 56, 1)] = 0.3
        pgm_function38[(1, 56, 2)] = 0.998
        pgm_function38[(1, 56, 3)] = 0.99
        pgm_function38[(1, 57, 1)] = 0.1
        pgm_function38[(1, 57, 2)] = 0.998
        pgm_function38[(1, 57, 3)] = 0.99
        pgm_function38[(1, 58, 1)] = 0.3
        pgm_function38[(1, 58, 2)] = 0.998
        pgm_function38[(1, 58, 3)] = 0.99
        pgm_function38[(1, 59, 1)] = 0.6
        pgm_function38[(1, 59, 2)] = 0.998
        pgm_function38[(1, 59, 3)] = 0.99
        pgm_function38[(1, 60, 1)] = 0.7
        pgm_function38[(1, 60, 2)] = 0.998
        pgm_function38[(1, 60, 3)] = 0.99
        pgm_function38[(1, 61, 1)] = 0.6
        pgm_function38[(1, 61, 2)] = 0.998
        pgm_function38[(1, 61, 3)] = 0.99
        pgm_function38[(1, 62, 1)] = 0.4
        pgm_function38[(1, 62, 2)] = 0.998
        pgm_function38[(1, 62, 3)] = 0.99
        pgm_function38[(1, 63, 1)] = 0.5
        pgm_function38[(1, 63, 2)] = 0.998
        pgm_function38[(1, 63, 3)] = 0.99
        pgm_function38[(1, 64, 1)] = 0.3
        pgm_function38[(1, 64, 2)] = 0.998
        pgm_function38[(1, 64, 3)] = 0.99
        pgm_function38[(1, 65, 1)] = 0.02
        pgm_function38[(1, 65, 2)] = 0.998
        pgm_function38[(1, 65, 3)] = 0.99
        pgm_function38[(1, 66, 1)] = 0.7
        pgm_function38[(1, 66, 2)] = 0.998
        pgm_function38[(1, 66, 3)] = 0.99
        pgm_function38[(1, 67, 1)] = 0.6
        pgm_function38[(1, 67, 2)] = 0.998
        pgm_function38[(1, 67, 3)] = 0.99
        pgm_function38[(1, 68, 1)] = 0.7
        pgm_function38[(1, 68, 2)] = 0.998
        pgm_function38[(1, 68, 3)] = 0.99
        pgm_function38[(1, 69, 1)] = 0.7
        pgm_function38[(1, 69, 2)] = 0.998
        pgm_function38[(1, 69, 3)] = 0.99
        pgm_function38[(1, 70, 1)] = 0.6
        pgm_function38[(1, 70, 2)] = 0.998
        pgm_function38[(1, 70, 3)] = 0.99
        pgm_function38[(1, 71, 1)] = 0.6
        pgm_function38[(1, 71, 2)] = 0.998
        pgm_function38[(1, 71, 3)] = 0.99
        pgm_function38[(1, 72, 1)] = 0.6
        pgm_function38[(1, 72, 2)] = 0.998
        pgm_function38[(1, 72, 3)] = 0.99
        pgm_function38[(1, 73, 1)] = 0.6
        pgm_function38[(1, 73, 2)] = 0.998
        pgm_function38[(1, 73, 3)] = 0.99
        pgm_function38[(1, 74, 1)] = 0.2
        pgm_function38[(1, 74, 2)] = 0.998
        pgm_function38[(1, 74, 3)] = 0.99
        pgm_function38[(1, 75, 1)] = 0.6
        pgm_function38[(1, 75, 2)] = 0.998
        pgm_function38[(1, 75, 3)] = 0.99
        pgm_function38[(2, 0, 1)] = 0.2
        pgm_function38[(2, 0, 2)] = 0.001
        pgm_function38[(2, 0, 3)] = 0.005
        pgm_function38[(2, 1, 1)] = 0.2
        pgm_function38[(2, 1, 2)] = 0.001
        pgm_function38[(2, 1, 3)] = 0.005
        pgm_function38[(2, 2, 1)] = 0.2
        pgm_function38[(2, 2, 2)] = 0.001
        pgm_function38[(2, 2, 3)] = 0.005
        pgm_function38[(2, 3, 1)] = 0.15
        pgm_function38[(2, 3, 2)] = 0.001
        pgm_function38[(2, 3, 3)] = 0.005
        pgm_function38[(2, 4, 1)] = 0.2
        pgm_function38[(2, 4, 2)] = 0.001
        pgm_function38[(2, 4, 3)] = 0.005
        pgm_function38[(2, 5, 1)] = 0.2
        pgm_function38[(2, 5, 2)] = 0.001
        pgm_function38[(2, 5, 3)] = 0.005
        pgm_function38[(2, 6, 1)] = 0.2
        pgm_function38[(2, 6, 2)] = 0.001
        pgm_function38[(2, 6, 3)] = 0.005
        pgm_function38[(2, 7, 1)] = 0.15
        pgm_function38[(2, 7, 2)] = 0.001
        pgm_function38[(2, 7, 3)] = 0.005
        pgm_function38[(2, 8, 1)] = 0.15
        pgm_function38[(2, 8, 2)] = 0.001
        pgm_function38[(2, 8, 3)] = 0.005
        pgm_function38[(2, 9, 1)] = 0.2
        pgm_function38[(2, 9, 2)] = 0.001
        pgm_function38[(2, 9, 3)] = 0.005
        pgm_function38[(2, 10, 1)] = 0.15
        pgm_function38[(2, 10, 2)] = 0.001
        pgm_function38[(2, 10, 3)] = 0.005
        pgm_function38[(2, 11, 1)] = 0.2
        pgm_function38[(2, 11, 2)] = 0.001
        pgm_function38[(2, 11, 3)] = 0.005
        pgm_function38[(2, 12, 1)] = 0.2
        pgm_function38[(2, 12, 2)] = 0.001
        pgm_function38[(2, 12, 3)] = 0.005
        pgm_function38[(2, 13, 1)] = 0.2
        pgm_function38[(2, 13, 2)] = 0.001
        pgm_function38[(2, 13, 3)] = 0.005
        pgm_function38[(2, 14, 1)] = 0.15
        pgm_function38[(2, 14, 2)] = 0.001
        pgm_function38[(2, 14, 3)] = 0.005
        pgm_function38[(2, 15, 1)] = 0.15
        pgm_function38[(2, 15, 2)] = 0.001
        pgm_function38[(2, 15, 3)] = 0.005
        pgm_function38[(2, 16, 1)] = 0.2
        pgm_function38[(2, 16, 2)] = 0.001
        pgm_function38[(2, 16, 3)] = 0.005
        pgm_function38[(2, 17, 1)] = 0.2
        pgm_function38[(2, 17, 2)] = 0.001
        pgm_function38[(2, 17, 3)] = 0.005
        pgm_function38[(2, 18, 1)] = 0.2
        pgm_function38[(2, 18, 2)] = 0.001
        pgm_function38[(2, 18, 3)] = 0.005
        pgm_function38[(2, 19, 1)] = 0.2
        pgm_function38[(2, 19, 2)] = 0.001
        pgm_function38[(2, 19, 3)] = 0.005
        pgm_function38[(2, 20, 1)] = 0.2
        pgm_function38[(2, 20, 2)] = 0.001
        pgm_function38[(2, 20, 3)] = 0.005
        pgm_function38[(2, 21, 1)] = 0.2
        pgm_function38[(2, 21, 2)] = 0.001
        pgm_function38[(2, 21, 3)] = 0.005
        pgm_function38[(2, 22, 1)] = 0.2
        pgm_function38[(2, 22, 2)] = 0.001
        pgm_function38[(2, 22, 3)] = 0.005
        pgm_function38[(2, 23, 1)] = 0.15
        pgm_function38[(2, 23, 2)] = 0.001
        pgm_function38[(2, 23, 3)] = 0.005
        pgm_function38[(2, 24, 1)] = 0.2
        pgm_function38[(2, 24, 2)] = 0.001
        pgm_function38[(2, 24, 3)] = 0.005
        pgm_function38[(2, 25, 1)] = 0.19
        pgm_function38[(2, 25, 2)] = 0.001
        pgm_function38[(2, 25, 3)] = 0.005
        pgm_function38[(2, 26, 1)] = 0.19
        pgm_function38[(2, 26, 2)] = 0.001
        pgm_function38[(2, 26, 3)] = 0.005
        pgm_function38[(2, 27, 1)] = 0.19
        pgm_function38[(2, 27, 2)] = 0.001
        pgm_function38[(2, 27, 3)] = 0.005
        pgm_function38[(2, 28, 1)] = 0.19
        pgm_function38[(2, 28, 2)] = 0.001
        pgm_function38[(2, 28, 3)] = 0.005
        pgm_function38[(2, 29, 1)] = 0.19
        pgm_function38[(2, 29, 2)] = 0.001
        pgm_function38[(2, 29, 3)] = 0.005
        pgm_function38[(2, 30, 1)] = 0.19
        pgm_function38[(2, 30, 2)] = 0.001
        pgm_function38[(2, 30, 3)] = 0.005
        pgm_function38[(2, 31, 1)] = 0.19
        pgm_function38[(2, 31, 2)] = 0.001
        pgm_function38[(2, 31, 3)] = 0.005
        pgm_function38[(2, 32, 1)] = 0.19
        pgm_function38[(2, 32, 2)] = 0.001
        pgm_function38[(2, 32, 3)] = 0.005
        pgm_function38[(2, 33, 1)] = 0.19
        pgm_function38[(2, 33, 2)] = 0.001
        pgm_function38[(2, 33, 3)] = 0.005
        pgm_function38[(2, 34, 1)] = 0.02
        pgm_function38[(2, 34, 2)] = 0.001
        pgm_function38[(2, 34, 3)] = 0.005
        pgm_function38[(2, 35, 1)] = 0.03
        pgm_function38[(2, 35, 2)] = 0.001
        pgm_function38[(2, 35, 3)] = 0.005
        pgm_function38[(2, 36, 1)] = 0.05
        pgm_function38[(2, 36, 2)] = 0.001
        pgm_function38[(2, 36, 3)] = 0.005
        pgm_function38[(2, 37, 1)] = 0.03
        pgm_function38[(2, 37, 2)] = 0.001
        pgm_function38[(2, 37, 3)] = 0.005
        pgm_function38[(2, 38, 1)] = 0.2
        pgm_function38[(2, 38, 2)] = 0.001
        pgm_function38[(2, 38, 3)] = 0.005
        pgm_function38[(2, 39, 1)] = 0.01
        pgm_function38[(2, 39, 2)] = 0.001
        pgm_function38[(2, 39, 3)] = 0.005
        pgm_function38[(2, 40, 1)] = 0.2
        pgm_function38[(2, 40, 2)] = 0.001
        pgm_function38[(2, 40, 3)] = 0.005
        pgm_function38[(2, 41, 1)] = 0.02
        pgm_function38[(2, 41, 2)] = 0.001
        pgm_function38[(2, 41, 3)] = 0.005
        pgm_function38[(2, 42, 1)] = 0.03
        pgm_function38[(2, 42, 2)] = 0.001
        pgm_function38[(2, 42, 3)] = 0.005
        pgm_function38[(2, 43, 1)] = 0.05
        pgm_function38[(2, 43, 2)] = 0.001
        pgm_function38[(2, 43, 3)] = 0.005
        pgm_function38[(2, 44, 2)] = 0.001
        pgm_function38[(2, 44, 3)] = 0.005
        pgm_function38[(2, 45, 1)] = 0.48
        pgm_function38[(2, 45, 2)] = 0.001
        pgm_function38[(2, 45, 3)] = 0.005
        pgm_function38[(2, 46, 1)] = 0.8
        pgm_function38[(2, 46, 2)] = 0.001
        pgm_function38[(2, 46, 3)] = 0.005
        pgm_function38[(2, 47, 1)] = 0.25
        pgm_function38[(2, 47, 2)] = 0.001
        pgm_function38[(2, 47, 3)] = 0.005
        pgm_function38[(2, 48, 2)] = 0.001
        pgm_function38[(2, 48, 3)] = 0.005
        pgm_function38[(2, 49, 1)] = 0.03
        pgm_function38[(2, 49, 2)] = 0.001
        pgm_function38[(2, 49, 3)] = 0.005
        pgm_function38[(2, 50, 1)] = 0.9
        pgm_function38[(2, 50, 2)] = 0.001
        pgm_function38[(2, 50, 3)] = 0.005
        pgm_function38[(2, 51, 1)] = 0.2
        pgm_function38[(2, 51, 2)] = 0.001
        pgm_function38[(2, 51, 3)] = 0.005
        pgm_function38[(2, 52, 2)] = 0.001
        pgm_function38[(2, 52, 3)] = 0.005
        pgm_function38[(2, 53, 1)] = 0.4
        pgm_function38[(2, 53, 2)] = 0.001
        pgm_function38[(2, 53, 3)] = 0.005
        pgm_function38[(2, 54, 1)] = 0.01
        pgm_function38[(2, 54, 2)] = 0.001
        pgm_function38[(2, 54, 3)] = 0.005
        pgm_function38[(2, 55, 1)] = 0.3
        pgm_function38[(2, 55, 2)] = 0.001
        pgm_function38[(2, 55, 3)] = 0.005
        pgm_function38[(2, 56, 1)] = 0.52
        pgm_function38[(2, 56, 2)] = 0.001
        pgm_function38[(2, 56, 3)] = 0.005
        pgm_function38[(2, 57, 1)] = 0.01
        pgm_function38[(2, 57, 2)] = 0.001
        pgm_function38[(2, 57, 3)] = 0.005
        pgm_function38[(2, 58, 2)] = 0.001
        pgm_function38[(2, 58, 3)] = 0.005
        pgm_function38[(2, 59, 1)] = 0.2
        pgm_function38[(2, 59, 2)] = 0.001
        pgm_function38[(2, 59, 3)] = 0.005
        pgm_function38[(2, 60, 1)] = 0.28
        pgm_function38[(2, 60, 2)] = 0.001
        pgm_function38[(2, 60, 3)] = 0.005
        pgm_function38[(2, 61, 1)] = 0.2
        pgm_function38[(2, 61, 2)] = 0.001
        pgm_function38[(2, 61, 3)] = 0.005
        pgm_function38[(2, 62, 1)] = 0.58
        pgm_function38[(2, 62, 2)] = 0.001
        pgm_function38[(2, 62, 3)] = 0.005
        pgm_function38[(2, 63, 1)] = 0.45
        pgm_function38[(2, 63, 2)] = 0.001
        pgm_function38[(2, 63, 3)] = 0.005
        pgm_function38[(2, 64, 1)] = 0.52
        pgm_function38[(2, 64, 2)] = 0.001
        pgm_function38[(2, 64, 3)] = 0.005
        pgm_function38[(2, 65, 1)] = 0.8
        pgm_function38[(2, 65, 2)] = 0.001
        pgm_function38[(2, 65, 3)] = 0.005
        pgm_function38[(2, 66, 1)] = 0.15
        pgm_function38[(2, 66, 2)] = 0.001
        pgm_function38[(2, 66, 3)] = 0.005
        pgm_function38[(2, 67, 1)] = 0.2
        pgm_function38[(2, 67, 2)] = 0.001
        pgm_function38[(2, 67, 3)] = 0.005
        pgm_function38[(2, 68, 1)] = 0.28
        pgm_function38[(2, 68, 2)] = 0.001
        pgm_function38[(2, 68, 3)] = 0.005
        pgm_function38[(2, 69, 1)] = 0.15
        pgm_function38[(2, 69, 2)] = 0.001
        pgm_function38[(2, 69, 3)] = 0.005
        pgm_function38[(2, 70, 1)] = 0.2
        pgm_function38[(2, 70, 2)] = 0.001
        pgm_function38[(2, 70, 3)] = 0.005
        pgm_function38[(2, 71, 1)] = 0.2
        pgm_function38[(2, 71, 2)] = 0.001
        pgm_function38[(2, 71, 3)] = 0.005
        pgm_function38[(2, 72, 1)] = 0.2
        pgm_function38[(2, 72, 2)] = 0.001
        pgm_function38[(2, 72, 3)] = 0.005
        pgm_function38[(2, 73, 1)] = 0.2
        pgm_function38[(2, 73, 2)] = 0.001
        pgm_function38[(2, 73, 3)] = 0.005
        pgm_function38[(2, 74, 1)] = 0.2
        pgm_function38[(2, 74, 2)] = 0.001
        pgm_function38[(2, 74, 3)] = 0.005
        pgm_function38[(2, 75, 1)] = 0.2
        pgm_function38[(2, 75, 2)] = 0.001
        pgm_function38[(2, 75, 3)] = 0.005
        pgm_function38[(3, 0, 1)] = 0.2
        pgm_function38[(3, 0, 2)] = 0.001
        pgm_function38[(3, 0, 3)] = 0.005
        pgm_function38[(3, 1, 1)] = 0.2
        pgm_function38[(3, 1, 2)] = 0.001
        pgm_function38[(3, 1, 3)] = 0.005
        pgm_function38[(3, 2, 1)] = 0.2
        pgm_function38[(3, 2, 2)] = 0.001
        pgm_function38[(3, 2, 3)] = 0.005
        pgm_function38[(3, 3, 1)] = 0.15
        pgm_function38[(3, 3, 2)] = 0.001
        pgm_function38[(3, 3, 3)] = 0.005
        pgm_function38[(3, 4, 1)] = 0.2
        pgm_function38[(3, 4, 2)] = 0.001
        pgm_function38[(3, 4, 3)] = 0.005
        pgm_function38[(3, 5, 1)] = 0.2
        pgm_function38[(3, 5, 2)] = 0.001
        pgm_function38[(3, 5, 3)] = 0.005
        pgm_function38[(3, 6, 1)] = 0.2
        pgm_function38[(3, 6, 2)] = 0.001
        pgm_function38[(3, 6, 3)] = 0.005
        pgm_function38[(3, 7, 1)] = 0.15
        pgm_function38[(3, 7, 2)] = 0.001
        pgm_function38[(3, 7, 3)] = 0.005
        pgm_function38[(3, 8, 1)] = 0.15
        pgm_function38[(3, 8, 2)] = 0.001
        pgm_function38[(3, 8, 3)] = 0.005
        pgm_function38[(3, 9, 1)] = 0.2
        pgm_function38[(3, 9, 2)] = 0.001
        pgm_function38[(3, 9, 3)] = 0.005
        pgm_function38[(3, 10, 1)] = 0.15
        pgm_function38[(3, 10, 2)] = 0.001
        pgm_function38[(3, 10, 3)] = 0.005
        pgm_function38[(3, 11, 1)] = 0.2
        pgm_function38[(3, 11, 2)] = 0.001
        pgm_function38[(3, 11, 3)] = 0.005
        pgm_function38[(3, 12, 1)] = 0.2
        pgm_function38[(3, 12, 2)] = 0.001
        pgm_function38[(3, 12, 3)] = 0.005
        pgm_function38[(3, 13, 1)] = 0.2
        pgm_function38[(3, 13, 2)] = 0.001
        pgm_function38[(3, 13, 3)] = 0.005
        pgm_function38[(3, 14, 1)] = 0.15
        pgm_function38[(3, 14, 2)] = 0.001
        pgm_function38[(3, 14, 3)] = 0.005
        pgm_function38[(3, 15, 1)] = 0.15
        pgm_function38[(3, 15, 2)] = 0.001
        pgm_function38[(3, 15, 3)] = 0.005
        pgm_function38[(3, 16, 1)] = 0.2
        pgm_function38[(3, 16, 2)] = 0.001
        pgm_function38[(3, 16, 3)] = 0.005
        pgm_function38[(3, 17, 1)] = 0.2
        pgm_function38[(3, 17, 2)] = 0.001
        pgm_function38[(3, 17, 3)] = 0.005
        pgm_function38[(3, 18, 1)] = 0.2
        pgm_function38[(3, 18, 2)] = 0.001
        pgm_function38[(3, 18, 3)] = 0.005
        pgm_function38[(3, 19, 1)] = 0.2
        pgm_function38[(3, 19, 2)] = 0.001
        pgm_function38[(3, 19, 3)] = 0.005
        pgm_function38[(3, 20, 1)] = 0.2
        pgm_function38[(3, 20, 2)] = 0.001
        pgm_function38[(3, 20, 3)] = 0.005
        pgm_function38[(3, 21, 1)] = 0.2
        pgm_function38[(3, 21, 2)] = 0.001
        pgm_function38[(3, 21, 3)] = 0.005
        pgm_function38[(3, 22, 1)] = 0.2
        pgm_function38[(3, 22, 2)] = 0.001
        pgm_function38[(3, 22, 3)] = 0.005
        pgm_function38[(3, 23, 1)] = 0.15
        pgm_function38[(3, 23, 2)] = 0.001
        pgm_function38[(3, 23, 3)] = 0.005
        pgm_function38[(3, 24, 1)] = 0.2
        pgm_function38[(3, 24, 2)] = 0.001
        pgm_function38[(3, 24, 3)] = 0.005
        pgm_function38[(3, 25, 1)] = 0.01
        pgm_function38[(3, 25, 2)] = 0.001
        pgm_function38[(3, 25, 3)] = 0.005
        pgm_function38[(3, 26, 1)] = 0.01
        pgm_function38[(3, 26, 2)] = 0.001
        pgm_function38[(3, 26, 3)] = 0.005
        pgm_function38[(3, 27, 1)] = 0.01
        pgm_function38[(3, 27, 2)] = 0.001
        pgm_function38[(3, 27, 3)] = 0.005
        pgm_function38[(3, 28, 1)] = 0.01
        pgm_function38[(3, 28, 2)] = 0.001
        pgm_function38[(3, 28, 3)] = 0.005
        pgm_function38[(3, 29, 1)] = 0.01
        pgm_function38[(3, 29, 2)] = 0.001
        pgm_function38[(3, 29, 3)] = 0.005
        pgm_function38[(3, 30, 1)] = 0.01
        pgm_function38[(3, 30, 2)] = 0.001
        pgm_function38[(3, 30, 3)] = 0.005
        pgm_function38[(3, 31, 1)] = 0.01
        pgm_function38[(3, 31, 2)] = 0.001
        pgm_function38[(3, 31, 3)] = 0.005
        pgm_function38[(3, 32, 1)] = 0.01
        pgm_function38[(3, 32, 2)] = 0.001
        pgm_function38[(3, 32, 3)] = 0.005
        pgm_function38[(3, 33, 1)] = 0.01
        pgm_function38[(3, 33, 2)] = 0.001
        pgm_function38[(3, 33, 3)] = 0.005
        pgm_function38[(3, 34, 1)] = 0.005
        pgm_function38[(3, 34, 2)] = 0.001
        pgm_function38[(3, 34, 3)] = 0.005
        pgm_function38[(3, 35, 1)] = 0.01
        pgm_function38[(3, 35, 2)] = 0.001
        pgm_function38[(3, 35, 3)] = 0.005
        pgm_function38[(3, 36, 1)] = 0.01
        pgm_function38[(3, 36, 2)] = 0.001
        pgm_function38[(3, 36, 3)] = 0.005
        pgm_function38[(3, 37, 1)] = 0.01
        pgm_function38[(3, 37, 2)] = 0.001
        pgm_function38[(3, 37, 3)] = 0.005
        pgm_function38[(3, 38, 1)] = 0.01
        pgm_function38[(3, 38, 2)] = 0.001
        pgm_function38[(3, 38, 3)] = 0.005
        pgm_function38[(3, 39, 1)] = 0.1
        pgm_function38[(3, 39, 2)] = 0.001
        pgm_function38[(3, 39, 3)] = 0.005
        pgm_function38[(3, 40, 1)] = 0.2
        pgm_function38[(3, 40, 2)] = 0.001
        pgm_function38[(3, 40, 3)] = 0.005
        pgm_function38[(3, 41, 1)] = 0.005
        pgm_function38[(3, 41, 2)] = 0.001
        pgm_function38[(3, 41, 3)] = 0.005
        pgm_function38[(3, 42, 1)] = 0.01
        pgm_function38[(3, 42, 2)] = 0.001
        pgm_function38[(3, 42, 3)] = 0.005
        pgm_function38[(3, 43, 1)] = 0.01
        pgm_function38[(3, 43, 2)] = 0.001
        pgm_function38[(3, 43, 3)] = 0.005
        pgm_function38[(3, 44, 1)] = 0.8
        pgm_function38[(3, 44, 2)] = 0.001
        pgm_function38[(3, 44, 3)] = 0.005
        pgm_function38[(3, 45, 1)] = 0.02
        pgm_function38[(3, 45, 2)] = 0.001
        pgm_function38[(3, 45, 3)] = 0.005
        pgm_function38[(3, 46, 1)] = 0.1
        pgm_function38[(3, 46, 2)] = 0.001
        pgm_function38[(3, 46, 3)] = 0.005
        pgm_function38[(3, 47, 1)] = 0.25
        pgm_function38[(3, 47, 2)] = 0.001
        pgm_function38[(3, 47, 3)] = 0.005
        pgm_function38[(3, 48, 2)] = 0.001
        pgm_function38[(3, 48, 3)] = 0.005
        pgm_function38[(3, 49, 1)] = 0.01
        pgm_function38[(3, 49, 2)] = 0.001
        pgm_function38[(3, 49, 3)] = 0.005
        pgm_function38[(3, 50, 1)] = 0.09
        pgm_function38[(3, 50, 2)] = 0.001
        pgm_function38[(3, 50, 3)] = 0.005
        pgm_function38[(3, 51, 1)] = 0.6
        pgm_function38[(3, 51, 2)] = 0.001
        pgm_function38[(3, 51, 3)] = 0.005
        pgm_function38[(3, 52, 1)] = 0.8
        pgm_function38[(3, 52, 2)] = 0.001
        pgm_function38[(3, 52, 3)] = 0.005
        pgm_function38[(3, 53, 1)] = 0.05
        pgm_function38[(3, 53, 2)] = 0.001
        pgm_function38[(3, 53, 3)] = 0.005
        pgm_function38[(3, 54, 1)] = 0.01
        pgm_function38[(3, 54, 2)] = 0.001
        pgm_function38[(3, 54, 3)] = 0.005
        pgm_function38[(3, 55, 2)] = 0.001
        pgm_function38[(3, 55, 3)] = 0.005
        pgm_function38[(3, 56, 1)] = 0.18
        pgm_function38[(3, 56, 2)] = 0.001
        pgm_function38[(3, 56, 3)] = 0.005
        pgm_function38[(3, 57, 1)] = 0.89
        pgm_function38[(3, 57, 2)] = 0.001
        pgm_function38[(3, 57, 3)] = 0.005
        pgm_function38[(3, 58, 1)] = 0.7
        pgm_function38[(3, 58, 2)] = 0.001
        pgm_function38[(3, 58, 3)] = 0.005
        pgm_function38[(3, 59, 1)] = 0.2
        pgm_function38[(3, 59, 2)] = 0.001
        pgm_function38[(3, 59, 3)] = 0.005
        pgm_function38[(3, 60, 1)] = 0.02
        pgm_function38[(3, 60, 2)] = 0.001
        pgm_function38[(3, 60, 3)] = 0.005
        pgm_function38[(3, 61, 1)] = 0.2
        pgm_function38[(3, 61, 2)] = 0.001
        pgm_function38[(3, 61, 3)] = 0.005
        pgm_function38[(3, 62, 1)] = 0.02
        pgm_function38[(3, 62, 2)] = 0.001
        pgm_function38[(3, 62, 3)] = 0.005
        pgm_function38[(3, 63, 1)] = 0.05
        pgm_function38[(3, 63, 2)] = 0.001
        pgm_function38[(3, 63, 3)] = 0.005
        pgm_function38[(3, 64, 1)] = 0.18
        pgm_function38[(3, 64, 2)] = 0.001
        pgm_function38[(3, 64, 3)] = 0.005
        pgm_function38[(3, 65, 1)] = 0.18
        pgm_function38[(3, 65, 2)] = 0.001
        pgm_function38[(3, 65, 3)] = 0.005
        pgm_function38[(3, 66, 1)] = 0.15
        pgm_function38[(3, 66, 2)] = 0.001
        pgm_function38[(3, 66, 3)] = 0.005
        pgm_function38[(3, 67, 1)] = 0.2
        pgm_function38[(3, 67, 2)] = 0.001
        pgm_function38[(3, 67, 3)] = 0.005
        pgm_function38[(3, 68, 1)] = 0.02
        pgm_function38[(3, 68, 2)] = 0.001
        pgm_function38[(3, 68, 3)] = 0.005
        pgm_function38[(3, 69, 1)] = 0.15
        pgm_function38[(3, 69, 2)] = 0.001
        pgm_function38[(3, 69, 3)] = 0.005
        pgm_function38[(3, 70, 1)] = 0.2
        pgm_function38[(3, 70, 2)] = 0.001
        pgm_function38[(3, 70, 3)] = 0.005
        pgm_function38[(3, 71, 1)] = 0.2
        pgm_function38[(3, 71, 2)] = 0.001
        pgm_function38[(3, 71, 3)] = 0.005
        pgm_function38[(3, 72, 1)] = 0.2
        pgm_function38[(3, 72, 2)] = 0.001
        pgm_function38[(3, 72, 3)] = 0.005
        pgm_function38[(3, 73, 1)] = 0.2
        pgm_function38[(3, 73, 2)] = 0.001
        pgm_function38[(3, 73, 3)] = 0.005
        pgm_function38[(3, 74, 1)] = 0.6
        pgm_function38[(3, 74, 2)] = 0.001
        pgm_function38[(3, 74, 3)] = 0.005
        pgm_function38[(3, 75, 1)] = 0.2
        pgm_function38[(3, 75, 2)] = 0.001
        pgm_function38[(3, 75, 3)] = 0.005

        pgm_function39 = pgm_factor39.set_sparse()
        pgm_function39[(0, 0, 0)] = 1.0
        pgm_function39[(0, 1, 0)] = 1.0
        pgm_function39[(0, 2, 0)] = 1.0
        pgm_function39[(0, 3, 0)] = 1.0
        pgm_function39[(0, 4, 0)] = 1.0
        pgm_function39[(0, 5, 0)] = 1.0
        pgm_function39[(0, 6, 0)] = 1.0
        pgm_function39[(0, 7, 0)] = 1.0
        pgm_function39[(0, 8, 0)] = 1.0
        pgm_function39[(0, 9, 0)] = 1.0
        pgm_function39[(0, 10, 0)] = 1.0
        pgm_function39[(0, 11, 0)] = 1.0
        pgm_function39[(0, 12, 0)] = 1.0
        pgm_function39[(0, 13, 0)] = 1.0
        pgm_function39[(0, 14, 0)] = 1.0
        pgm_function39[(0, 15, 0)] = 1.0
        pgm_function39[(0, 16, 0)] = 1.0
        pgm_function39[(0, 17, 0)] = 1.0
        pgm_function39[(0, 18, 0)] = 1.0
        pgm_function39[(0, 19, 0)] = 1.0
        pgm_function39[(0, 20, 0)] = 1.0
        pgm_function39[(0, 21, 0)] = 1.0
        pgm_function39[(0, 22, 0)] = 1.0
        pgm_function39[(0, 23, 0)] = 1.0
        pgm_function39[(0, 24, 0)] = 1.0
        pgm_function39[(0, 25, 0)] = 1.0
        pgm_function39[(0, 26, 0)] = 1.0
        pgm_function39[(0, 27, 0)] = 1.0
        pgm_function39[(0, 28, 0)] = 1.0
        pgm_function39[(0, 29, 0)] = 1.0
        pgm_function39[(0, 30, 0)] = 1.0
        pgm_function39[(0, 31, 0)] = 1.0
        pgm_function39[(0, 32, 0)] = 1.0
        pgm_function39[(0, 33, 0)] = 1.0
        pgm_function39[(0, 34, 0)] = 1.0
        pgm_function39[(0, 35, 0)] = 1.0
        pgm_function39[(0, 36, 0)] = 1.0
        pgm_function39[(0, 37, 0)] = 1.0
        pgm_function39[(0, 38, 0)] = 1.0
        pgm_function39[(0, 39, 0)] = 1.0
        pgm_function39[(0, 40, 0)] = 1.0
        pgm_function39[(0, 41, 0)] = 1.0
        pgm_function39[(0, 42, 0)] = 1.0
        pgm_function39[(0, 43, 0)] = 1.0
        pgm_function39[(0, 44, 0)] = 1.0
        pgm_function39[(0, 45, 0)] = 1.0
        pgm_function39[(0, 46, 0)] = 1.0
        pgm_function39[(0, 47, 0)] = 1.0
        pgm_function39[(0, 48, 0)] = 1.0
        pgm_function39[(0, 49, 0)] = 1.0
        pgm_function39[(0, 50, 0)] = 1.0
        pgm_function39[(0, 51, 0)] = 1.0
        pgm_function39[(0, 52, 0)] = 1.0
        pgm_function39[(0, 53, 0)] = 1.0
        pgm_function39[(0, 54, 0)] = 1.0
        pgm_function39[(0, 55, 0)] = 1.0
        pgm_function39[(0, 56, 0)] = 1.0
        pgm_function39[(0, 57, 0)] = 1.0
        pgm_function39[(0, 58, 0)] = 1.0
        pgm_function39[(0, 59, 0)] = 1.0
        pgm_function39[(0, 60, 0)] = 1.0
        pgm_function39[(0, 61, 0)] = 1.0
        pgm_function39[(0, 62, 0)] = 1.0
        pgm_function39[(0, 63, 0)] = 1.0
        pgm_function39[(0, 64, 0)] = 1.0
        pgm_function39[(0, 65, 0)] = 1.0
        pgm_function39[(0, 66, 0)] = 1.0
        pgm_function39[(0, 67, 0)] = 1.0
        pgm_function39[(0, 68, 0)] = 1.0
        pgm_function39[(0, 69, 0)] = 1.0
        pgm_function39[(0, 70, 0)] = 1.0
        pgm_function39[(0, 71, 0)] = 1.0
        pgm_function39[(0, 72, 0)] = 1.0
        pgm_function39[(0, 73, 0)] = 1.0
        pgm_function39[(0, 74, 0)] = 1.0
        pgm_function39[(0, 75, 0)] = 1.0
        pgm_function39[(1, 25, 1)] = 0.01
        pgm_function39[(1, 26, 1)] = 0.01
        pgm_function39[(1, 27, 1)] = 0.01
        pgm_function39[(1, 28, 1)] = 0.01
        pgm_function39[(1, 29, 1)] = 0.01
        pgm_function39[(1, 30, 1)] = 0.01
        pgm_function39[(1, 31, 1)] = 0.01
        pgm_function39[(1, 32, 1)] = 0.01
        pgm_function39[(1, 33, 1)] = 0.01
        pgm_function39[(1, 35, 1)] = 0.03
        pgm_function39[(1, 36, 1)] = 0.03
        pgm_function39[(1, 37, 1)] = 0.001
        pgm_function39[(1, 42, 1)] = 0.03
        pgm_function39[(1, 43, 1)] = 0.03
        pgm_function39[(1, 44, 1)] = 0.01
        pgm_function39[(1, 45, 1)] = 0.03
        pgm_function39[(1, 47, 1)] = 0.1
        pgm_function39[(1, 48, 1)] = 0.01
        pgm_function39[(1, 49, 1)] = 0.001
        pgm_function39[(1, 50, 1)] = 0.03
        pgm_function39[(1, 51, 1)] = 0.01
        pgm_function39[(1, 52, 1)] = 0.01
        pgm_function39[(1, 53, 1)] = 0.005
        pgm_function39[(1, 54, 1)] = 0.03
        pgm_function39[(1, 62, 1)] = 0.03
        pgm_function39[(1, 74, 1)] = 0.01
        pgm_function39[(2, 45, 1)] = 0.001
        pgm_function39[(2, 47, 1)] = 0.2
        pgm_function39[(2, 48, 1)] = 0.01
        pgm_function39[(2, 50, 1)] = 0.001
        pgm_function39[(2, 53, 1)] = 0.25
        pgm_function39[(2, 62, 1)] = 0.001
        pgm_function39[(3, 35, 1)] = 0.01
        pgm_function39[(3, 36, 1)] = 0.01
        pgm_function39[(3, 37, 1)] = 0.01
        pgm_function39[(3, 42, 1)] = 0.01
        pgm_function39[(3, 43, 1)] = 0.01
        pgm_function39[(3, 44, 1)] = 0.005
        pgm_function39[(3, 45, 1)] = 0.01
        pgm_function39[(3, 47, 1)] = 0.25
        pgm_function39[(3, 48, 1)] = 0.01
        pgm_function39[(3, 49, 1)] = 0.01
        pgm_function39[(3, 50, 1)] = 0.01
        pgm_function39[(3, 51, 1)] = 0.005
        pgm_function39[(3, 52, 1)] = 0.005
        pgm_function39[(3, 53, 1)] = 0.1
        pgm_function39[(3, 54, 1)] = 0.01
        pgm_function39[(3, 62, 1)] = 0.01
        pgm_function39[(3, 74, 1)] = 0.005
        pgm_function39[(4, 0, 1)] = 0.01
        pgm_function39[(4, 0, 2)] = 0.99
        pgm_function39[(4, 0, 3)] = 0.01
        pgm_function39[(4, 1, 1)] = 0.05
        pgm_function39[(4, 1, 2)] = 0.99
        pgm_function39[(4, 1, 3)] = 0.01
        pgm_function39[(4, 2, 1)] = 0.02
        pgm_function39[(4, 2, 2)] = 0.99
        pgm_function39[(4, 2, 3)] = 0.01
        pgm_function39[(4, 3, 1)] = 0.02
        pgm_function39[(4, 3, 2)] = 0.99
        pgm_function39[(4, 3, 3)] = 0.01
        pgm_function39[(4, 4, 1)] = 0.01
        pgm_function39[(4, 4, 2)] = 0.99
        pgm_function39[(4, 4, 3)] = 0.01
        pgm_function39[(4, 5, 1)] = 0.01
        pgm_function39[(4, 5, 2)] = 0.99
        pgm_function39[(4, 5, 3)] = 0.01
        pgm_function39[(4, 6, 1)] = 0.01
        pgm_function39[(4, 6, 2)] = 0.99
        pgm_function39[(4, 6, 3)] = 0.01
        pgm_function39[(4, 7, 1)] = 0.02
        pgm_function39[(4, 7, 2)] = 0.99
        pgm_function39[(4, 7, 3)] = 0.01
        pgm_function39[(4, 8, 1)] = 0.02
        pgm_function39[(4, 8, 2)] = 0.99
        pgm_function39[(4, 8, 3)] = 0.01
        pgm_function39[(4, 9, 1)] = 0.01
        pgm_function39[(4, 9, 2)] = 0.99
        pgm_function39[(4, 9, 3)] = 0.01
        pgm_function39[(4, 10, 1)] = 0.02
        pgm_function39[(4, 10, 2)] = 0.99
        pgm_function39[(4, 10, 3)] = 0.01
        pgm_function39[(4, 11, 1)] = 0.01
        pgm_function39[(4, 11, 2)] = 0.99
        pgm_function39[(4, 11, 3)] = 0.01
        pgm_function39[(4, 12, 1)] = 0.01
        pgm_function39[(4, 12, 2)] = 0.99
        pgm_function39[(4, 12, 3)] = 0.01
        pgm_function39[(4, 13, 1)] = 0.01
        pgm_function39[(4, 13, 2)] = 0.99
        pgm_function39[(4, 13, 3)] = 0.01
        pgm_function39[(4, 14, 1)] = 0.02
        pgm_function39[(4, 14, 2)] = 0.99
        pgm_function39[(4, 14, 3)] = 0.01
        pgm_function39[(4, 15, 1)] = 0.02
        pgm_function39[(4, 15, 2)] = 0.99
        pgm_function39[(4, 15, 3)] = 0.01
        pgm_function39[(4, 16, 1)] = 0.01
        pgm_function39[(4, 16, 2)] = 0.99
        pgm_function39[(4, 16, 3)] = 0.01
        pgm_function39[(4, 17, 1)] = 0.01
        pgm_function39[(4, 17, 2)] = 0.99
        pgm_function39[(4, 17, 3)] = 0.01
        pgm_function39[(4, 18, 1)] = 0.01
        pgm_function39[(4, 18, 2)] = 0.99
        pgm_function39[(4, 18, 3)] = 0.01
        pgm_function39[(4, 19, 1)] = 0.01
        pgm_function39[(4, 19, 2)] = 0.99
        pgm_function39[(4, 19, 3)] = 0.01
        pgm_function39[(4, 20, 1)] = 0.01
        pgm_function39[(4, 20, 2)] = 0.99
        pgm_function39[(4, 20, 3)] = 0.01
        pgm_function39[(4, 21, 1)] = 0.01
        pgm_function39[(4, 21, 2)] = 0.99
        pgm_function39[(4, 21, 3)] = 0.01
        pgm_function39[(4, 22, 1)] = 0.01
        pgm_function39[(4, 22, 2)] = 0.99
        pgm_function39[(4, 22, 3)] = 0.01
        pgm_function39[(4, 23, 1)] = 0.02
        pgm_function39[(4, 23, 2)] = 0.99
        pgm_function39[(4, 23, 3)] = 0.01
        pgm_function39[(4, 24, 1)] = 0.01
        pgm_function39[(4, 24, 2)] = 0.99
        pgm_function39[(4, 24, 3)] = 0.01
        pgm_function39[(4, 25, 1)] = 0.09
        pgm_function39[(4, 25, 2)] = 0.99
        pgm_function39[(4, 25, 3)] = 0.01
        pgm_function39[(4, 26, 1)] = 0.09
        pgm_function39[(4, 26, 2)] = 0.99
        pgm_function39[(4, 26, 3)] = 0.01
        pgm_function39[(4, 27, 1)] = 0.09
        pgm_function39[(4, 27, 2)] = 0.99
        pgm_function39[(4, 27, 3)] = 0.01
        pgm_function39[(4, 28, 1)] = 0.09
        pgm_function39[(4, 28, 2)] = 0.99
        pgm_function39[(4, 28, 3)] = 0.01
        pgm_function39[(4, 29, 1)] = 0.09
        pgm_function39[(4, 29, 2)] = 0.99
        pgm_function39[(4, 29, 3)] = 0.01
        pgm_function39[(4, 30, 1)] = 0.09
        pgm_function39[(4, 30, 2)] = 0.99
        pgm_function39[(4, 30, 3)] = 0.01
        pgm_function39[(4, 31, 1)] = 0.09
        pgm_function39[(4, 31, 2)] = 0.99
        pgm_function39[(4, 31, 3)] = 0.01
        pgm_function39[(4, 32, 1)] = 0.09
        pgm_function39[(4, 32, 2)] = 0.99
        pgm_function39[(4, 32, 3)] = 0.01
        pgm_function39[(4, 33, 1)] = 0.09
        pgm_function39[(4, 33, 2)] = 0.99
        pgm_function39[(4, 33, 3)] = 0.01
        pgm_function39[(4, 34, 1)] = 0.01
        pgm_function39[(4, 34, 2)] = 0.99
        pgm_function39[(4, 34, 3)] = 0.01
        pgm_function39[(4, 35, 1)] = 0.15
        pgm_function39[(4, 35, 2)] = 0.99
        pgm_function39[(4, 35, 3)] = 0.01
        pgm_function39[(4, 36, 1)] = 0.15
        pgm_function39[(4, 36, 2)] = 0.99
        pgm_function39[(4, 36, 3)] = 0.01
        pgm_function39[(4, 37, 1)] = 0.1
        pgm_function39[(4, 37, 2)] = 0.99
        pgm_function39[(4, 37, 3)] = 0.01
        pgm_function39[(4, 38, 1)] = 0.01
        pgm_function39[(4, 38, 2)] = 0.99
        pgm_function39[(4, 38, 3)] = 0.01
        pgm_function39[(4, 39, 1)] = 0.01
        pgm_function39[(4, 39, 2)] = 0.99
        pgm_function39[(4, 39, 3)] = 0.01
        pgm_function39[(4, 40, 1)] = 0.01
        pgm_function39[(4, 40, 2)] = 0.99
        pgm_function39[(4, 40, 3)] = 0.01
        pgm_function39[(4, 41, 1)] = 0.01
        pgm_function39[(4, 41, 2)] = 0.99
        pgm_function39[(4, 41, 3)] = 0.01
        pgm_function39[(4, 42, 1)] = 0.15
        pgm_function39[(4, 42, 2)] = 0.99
        pgm_function39[(4, 42, 3)] = 0.01
        pgm_function39[(4, 43, 1)] = 0.15
        pgm_function39[(4, 43, 2)] = 0.99
        pgm_function39[(4, 43, 3)] = 0.01
        pgm_function39[(4, 44, 1)] = 0.05
        pgm_function39[(4, 44, 2)] = 0.99
        pgm_function39[(4, 44, 3)] = 0.01
        pgm_function39[(4, 45, 1)] = 0.15
        pgm_function39[(4, 45, 2)] = 0.99
        pgm_function39[(4, 45, 3)] = 0.01
        pgm_function39[(4, 46, 1)] = 0.05
        pgm_function39[(4, 46, 2)] = 0.99
        pgm_function39[(4, 46, 3)] = 0.01
        pgm_function39[(4, 47, 1)] = 0.42
        pgm_function39[(4, 47, 2)] = 0.99
        pgm_function39[(4, 47, 3)] = 0.01
        pgm_function39[(4, 48, 1)] = 0.1
        pgm_function39[(4, 48, 2)] = 0.99
        pgm_function39[(4, 48, 3)] = 0.01
        pgm_function39[(4, 49, 1)] = 0.1
        pgm_function39[(4, 49, 2)] = 0.99
        pgm_function39[(4, 49, 3)] = 0.01
        pgm_function39[(4, 50, 1)] = 0.15
        pgm_function39[(4, 50, 2)] = 0.99
        pgm_function39[(4, 50, 3)] = 0.01
        pgm_function39[(4, 51, 1)] = 0.05
        pgm_function39[(4, 51, 2)] = 0.99
        pgm_function39[(4, 51, 3)] = 0.01
        pgm_function39[(4, 52, 1)] = 0.05
        pgm_function39[(4, 52, 2)] = 0.99
        pgm_function39[(4, 52, 3)] = 0.01
        pgm_function39[(4, 53, 1)] = 0.2
        pgm_function39[(4, 53, 2)] = 0.99
        pgm_function39[(4, 53, 3)] = 0.01
        pgm_function39[(4, 54, 1)] = 0.15
        pgm_function39[(4, 54, 2)] = 0.99
        pgm_function39[(4, 54, 3)] = 0.01
        pgm_function39[(4, 55, 1)] = 0.01
        pgm_function39[(4, 55, 2)] = 0.99
        pgm_function39[(4, 55, 3)] = 0.01
        pgm_function39[(4, 56, 1)] = 0.01
        pgm_function39[(4, 56, 2)] = 0.99
        pgm_function39[(4, 56, 3)] = 0.01
        pgm_function39[(4, 57, 1)] = 0.01
        pgm_function39[(4, 57, 2)] = 0.99
        pgm_function39[(4, 57, 3)] = 0.01
        pgm_function39[(4, 58, 1)] = 0.01
        pgm_function39[(4, 58, 2)] = 0.99
        pgm_function39[(4, 58, 3)] = 0.01
        pgm_function39[(4, 59, 1)] = 0.01
        pgm_function39[(4, 59, 2)] = 0.99
        pgm_function39[(4, 59, 3)] = 0.01
        pgm_function39[(4, 60, 1)] = 0.01
        pgm_function39[(4, 60, 2)] = 0.99
        pgm_function39[(4, 60, 3)] = 0.01
        pgm_function39[(4, 61, 1)] = 0.01
        pgm_function39[(4, 61, 2)] = 0.99
        pgm_function39[(4, 61, 3)] = 0.01
        pgm_function39[(4, 62, 1)] = 0.15
        pgm_function39[(4, 62, 2)] = 0.99
        pgm_function39[(4, 62, 3)] = 0.01
        pgm_function39[(4, 63, 1)] = 0.01
        pgm_function39[(4, 63, 2)] = 0.99
        pgm_function39[(4, 63, 3)] = 0.01
        pgm_function39[(4, 64, 1)] = 0.01
        pgm_function39[(4, 64, 2)] = 0.99
        pgm_function39[(4, 64, 3)] = 0.01
        pgm_function39[(4, 65, 1)] = 0.01
        pgm_function39[(4, 65, 2)] = 0.99
        pgm_function39[(4, 65, 3)] = 0.01
        pgm_function39[(4, 66, 1)] = 0.02
        pgm_function39[(4, 66, 2)] = 0.99
        pgm_function39[(4, 66, 3)] = 0.01
        pgm_function39[(4, 67, 1)] = 0.01
        pgm_function39[(4, 67, 2)] = 0.99
        pgm_function39[(4, 67, 3)] = 0.01
        pgm_function39[(4, 68, 1)] = 0.01
        pgm_function39[(4, 68, 2)] = 0.99
        pgm_function39[(4, 68, 3)] = 0.01
        pgm_function39[(4, 69, 1)] = 0.02
        pgm_function39[(4, 69, 2)] = 0.99
        pgm_function39[(4, 69, 3)] = 0.01
        pgm_function39[(4, 70, 1)] = 0.01
        pgm_function39[(4, 70, 2)] = 0.99
        pgm_function39[(4, 70, 3)] = 0.01
        pgm_function39[(4, 71, 1)] = 0.01
        pgm_function39[(4, 71, 2)] = 0.99
        pgm_function39[(4, 71, 3)] = 0.01
        pgm_function39[(4, 72, 1)] = 0.01
        pgm_function39[(4, 72, 2)] = 0.99
        pgm_function39[(4, 72, 3)] = 0.01
        pgm_function39[(4, 73, 1)] = 0.01
        pgm_function39[(4, 73, 2)] = 0.99
        pgm_function39[(4, 73, 3)] = 0.01
        pgm_function39[(4, 74, 1)] = 0.05
        pgm_function39[(4, 74, 2)] = 0.99
        pgm_function39[(4, 74, 3)] = 0.01
        pgm_function39[(4, 75, 1)] = 0.01
        pgm_function39[(4, 75, 2)] = 0.99
        pgm_function39[(4, 75, 3)] = 0.01
        pgm_function39[(5, 0, 1)] = 0.99
        pgm_function39[(5, 0, 2)] = 0.01
        pgm_function39[(5, 0, 3)] = 0.99
        pgm_function39[(5, 1, 1)] = 0.95
        pgm_function39[(5, 1, 2)] = 0.01
        pgm_function39[(5, 1, 3)] = 0.99
        pgm_function39[(5, 2, 1)] = 0.98
        pgm_function39[(5, 2, 2)] = 0.01
        pgm_function39[(5, 2, 3)] = 0.99
        pgm_function39[(5, 3, 1)] = 0.98
        pgm_function39[(5, 3, 2)] = 0.01
        pgm_function39[(5, 3, 3)] = 0.99
        pgm_function39[(5, 4, 1)] = 0.99
        pgm_function39[(5, 4, 2)] = 0.01
        pgm_function39[(5, 4, 3)] = 0.99
        pgm_function39[(5, 5, 1)] = 0.99
        pgm_function39[(5, 5, 2)] = 0.01
        pgm_function39[(5, 5, 3)] = 0.99
        pgm_function39[(5, 6, 1)] = 0.99
        pgm_function39[(5, 6, 2)] = 0.01
        pgm_function39[(5, 6, 3)] = 0.99
        pgm_function39[(5, 7, 1)] = 0.98
        pgm_function39[(5, 7, 2)] = 0.01
        pgm_function39[(5, 7, 3)] = 0.99
        pgm_function39[(5, 8, 1)] = 0.98
        pgm_function39[(5, 8, 2)] = 0.01
        pgm_function39[(5, 8, 3)] = 0.99
        pgm_function39[(5, 9, 1)] = 0.99
        pgm_function39[(5, 9, 2)] = 0.01
        pgm_function39[(5, 9, 3)] = 0.99
        pgm_function39[(5, 10, 1)] = 0.98
        pgm_function39[(5, 10, 2)] = 0.01
        pgm_function39[(5, 10, 3)] = 0.99
        pgm_function39[(5, 11, 1)] = 0.99
        pgm_function39[(5, 11, 2)] = 0.01
        pgm_function39[(5, 11, 3)] = 0.99
        pgm_function39[(5, 12, 1)] = 0.99
        pgm_function39[(5, 12, 2)] = 0.01
        pgm_function39[(5, 12, 3)] = 0.99
        pgm_function39[(5, 13, 1)] = 0.99
        pgm_function39[(5, 13, 2)] = 0.01
        pgm_function39[(5, 13, 3)] = 0.99
        pgm_function39[(5, 14, 1)] = 0.98
        pgm_function39[(5, 14, 2)] = 0.01
        pgm_function39[(5, 14, 3)] = 0.99
        pgm_function39[(5, 15, 1)] = 0.98
        pgm_function39[(5, 15, 2)] = 0.01
        pgm_function39[(5, 15, 3)] = 0.99
        pgm_function39[(5, 16, 1)] = 0.99
        pgm_function39[(5, 16, 2)] = 0.01
        pgm_function39[(5, 16, 3)] = 0.99
        pgm_function39[(5, 17, 1)] = 0.99
        pgm_function39[(5, 17, 2)] = 0.01
        pgm_function39[(5, 17, 3)] = 0.99
        pgm_function39[(5, 18, 1)] = 0.99
        pgm_function39[(5, 18, 2)] = 0.01
        pgm_function39[(5, 18, 3)] = 0.99
        pgm_function39[(5, 19, 1)] = 0.99
        pgm_function39[(5, 19, 2)] = 0.01
        pgm_function39[(5, 19, 3)] = 0.99
        pgm_function39[(5, 20, 1)] = 0.99
        pgm_function39[(5, 20, 2)] = 0.01
        pgm_function39[(5, 20, 3)] = 0.99
        pgm_function39[(5, 21, 1)] = 0.99
        pgm_function39[(5, 21, 2)] = 0.01
        pgm_function39[(5, 21, 3)] = 0.99
        pgm_function39[(5, 22, 1)] = 0.99
        pgm_function39[(5, 22, 2)] = 0.01
        pgm_function39[(5, 22, 3)] = 0.99
        pgm_function39[(5, 23, 1)] = 0.98
        pgm_function39[(5, 23, 2)] = 0.01
        pgm_function39[(5, 23, 3)] = 0.99
        pgm_function39[(5, 24, 1)] = 0.99
        pgm_function39[(5, 24, 2)] = 0.01
        pgm_function39[(5, 24, 3)] = 0.99
        pgm_function39[(5, 25, 1)] = 0.9
        pgm_function39[(5, 25, 2)] = 0.01
        pgm_function39[(5, 25, 3)] = 0.99
        pgm_function39[(5, 26, 1)] = 0.9
        pgm_function39[(5, 26, 2)] = 0.01
        pgm_function39[(5, 26, 3)] = 0.99
        pgm_function39[(5, 27, 1)] = 0.9
        pgm_function39[(5, 27, 2)] = 0.01
        pgm_function39[(5, 27, 3)] = 0.99
        pgm_function39[(5, 28, 1)] = 0.9
        pgm_function39[(5, 28, 2)] = 0.01
        pgm_function39[(5, 28, 3)] = 0.99
        pgm_function39[(5, 29, 1)] = 0.9
        pgm_function39[(5, 29, 2)] = 0.01
        pgm_function39[(5, 29, 3)] = 0.99
        pgm_function39[(5, 30, 1)] = 0.9
        pgm_function39[(5, 30, 2)] = 0.01
        pgm_function39[(5, 30, 3)] = 0.99
        pgm_function39[(5, 31, 1)] = 0.9
        pgm_function39[(5, 31, 2)] = 0.01
        pgm_function39[(5, 31, 3)] = 0.99
        pgm_function39[(5, 32, 1)] = 0.9
        pgm_function39[(5, 32, 2)] = 0.01
        pgm_function39[(5, 32, 3)] = 0.99
        pgm_function39[(5, 33, 1)] = 0.9
        pgm_function39[(5, 33, 2)] = 0.01
        pgm_function39[(5, 33, 3)] = 0.99
        pgm_function39[(5, 34, 1)] = 0.99
        pgm_function39[(5, 34, 2)] = 0.01
        pgm_function39[(5, 34, 3)] = 0.99
        pgm_function39[(5, 35, 1)] = 0.81
        pgm_function39[(5, 35, 2)] = 0.01
        pgm_function39[(5, 35, 3)] = 0.99
        pgm_function39[(5, 36, 1)] = 0.81
        pgm_function39[(5, 36, 2)] = 0.01
        pgm_function39[(5, 36, 3)] = 0.99
        pgm_function39[(5, 37, 1)] = 0.889
        pgm_function39[(5, 37, 2)] = 0.01
        pgm_function39[(5, 37, 3)] = 0.99
        pgm_function39[(5, 38, 1)] = 0.99
        pgm_function39[(5, 38, 2)] = 0.01
        pgm_function39[(5, 38, 3)] = 0.99
        pgm_function39[(5, 39, 1)] = 0.99
        pgm_function39[(5, 39, 2)] = 0.01
        pgm_function39[(5, 39, 3)] = 0.99
        pgm_function39[(5, 40, 1)] = 0.99
        pgm_function39[(5, 40, 2)] = 0.01
        pgm_function39[(5, 40, 3)] = 0.99
        pgm_function39[(5, 41, 1)] = 0.99
        pgm_function39[(5, 41, 2)] = 0.01
        pgm_function39[(5, 41, 3)] = 0.99
        pgm_function39[(5, 42, 1)] = 0.81
        pgm_function39[(5, 42, 2)] = 0.01
        pgm_function39[(5, 42, 3)] = 0.99
        pgm_function39[(5, 43, 1)] = 0.81
        pgm_function39[(5, 43, 2)] = 0.01
        pgm_function39[(5, 43, 3)] = 0.99
        pgm_function39[(5, 44, 1)] = 0.935
        pgm_function39[(5, 44, 2)] = 0.01
        pgm_function39[(5, 44, 3)] = 0.99
        pgm_function39[(5, 45, 1)] = 0.809
        pgm_function39[(5, 45, 2)] = 0.01
        pgm_function39[(5, 45, 3)] = 0.99
        pgm_function39[(5, 46, 1)] = 0.95
        pgm_function39[(5, 46, 2)] = 0.01
        pgm_function39[(5, 46, 3)] = 0.99
        pgm_function39[(5, 47, 1)] = 0.03
        pgm_function39[(5, 47, 2)] = 0.01
        pgm_function39[(5, 47, 3)] = 0.99
        pgm_function39[(5, 48, 1)] = 0.87
        pgm_function39[(5, 48, 2)] = 0.01
        pgm_function39[(5, 48, 3)] = 0.99
        pgm_function39[(5, 49, 1)] = 0.889
        pgm_function39[(5, 49, 2)] = 0.01
        pgm_function39[(5, 49, 3)] = 0.99
        pgm_function39[(5, 50, 1)] = 0.809
        pgm_function39[(5, 50, 2)] = 0.01
        pgm_function39[(5, 50, 3)] = 0.99
        pgm_function39[(5, 51, 1)] = 0.935
        pgm_function39[(5, 51, 2)] = 0.01
        pgm_function39[(5, 51, 3)] = 0.99
        pgm_function39[(5, 52, 1)] = 0.935
        pgm_function39[(5, 52, 2)] = 0.01
        pgm_function39[(5, 52, 3)] = 0.99
        pgm_function39[(5, 53, 1)] = 0.445
        pgm_function39[(5, 53, 2)] = 0.01
        pgm_function39[(5, 53, 3)] = 0.99
        pgm_function39[(5, 54, 1)] = 0.81
        pgm_function39[(5, 54, 2)] = 0.01
        pgm_function39[(5, 54, 3)] = 0.99
        pgm_function39[(5, 55, 1)] = 0.99
        pgm_function39[(5, 55, 2)] = 0.01
        pgm_function39[(5, 55, 3)] = 0.99
        pgm_function39[(5, 56, 1)] = 0.99
        pgm_function39[(5, 56, 2)] = 0.01
        pgm_function39[(5, 56, 3)] = 0.99
        pgm_function39[(5, 57, 1)] = 0.99
        pgm_function39[(5, 57, 2)] = 0.01
        pgm_function39[(5, 57, 3)] = 0.99
        pgm_function39[(5, 58, 1)] = 0.99
        pgm_function39[(5, 58, 2)] = 0.01
        pgm_function39[(5, 58, 3)] = 0.99
        pgm_function39[(5, 59, 1)] = 0.99
        pgm_function39[(5, 59, 2)] = 0.01
        pgm_function39[(5, 59, 3)] = 0.99
        pgm_function39[(5, 60, 1)] = 0.99
        pgm_function39[(5, 60, 2)] = 0.01
        pgm_function39[(5, 60, 3)] = 0.99
        pgm_function39[(5, 61, 1)] = 0.99
        pgm_function39[(5, 61, 2)] = 0.01
        pgm_function39[(5, 61, 3)] = 0.99
        pgm_function39[(5, 62, 1)] = 0.809
        pgm_function39[(5, 62, 2)] = 0.01
        pgm_function39[(5, 62, 3)] = 0.99
        pgm_function39[(5, 63, 1)] = 0.99
        pgm_function39[(5, 63, 2)] = 0.01
        pgm_function39[(5, 63, 3)] = 0.99
        pgm_function39[(5, 64, 1)] = 0.99
        pgm_function39[(5, 64, 2)] = 0.01
        pgm_function39[(5, 64, 3)] = 0.99
        pgm_function39[(5, 65, 1)] = 0.99
        pgm_function39[(5, 65, 2)] = 0.01
        pgm_function39[(5, 65, 3)] = 0.99
        pgm_function39[(5, 66, 1)] = 0.98
        pgm_function39[(5, 66, 2)] = 0.01
        pgm_function39[(5, 66, 3)] = 0.99
        pgm_function39[(5, 67, 1)] = 0.99
        pgm_function39[(5, 67, 2)] = 0.01
        pgm_function39[(5, 67, 3)] = 0.99
        pgm_function39[(5, 68, 1)] = 0.99
        pgm_function39[(5, 68, 2)] = 0.01
        pgm_function39[(5, 68, 3)] = 0.99
        pgm_function39[(5, 69, 1)] = 0.98
        pgm_function39[(5, 69, 2)] = 0.01
        pgm_function39[(5, 69, 3)] = 0.99
        pgm_function39[(5, 70, 1)] = 0.99
        pgm_function39[(5, 70, 2)] = 0.01
        pgm_function39[(5, 70, 3)] = 0.99
        pgm_function39[(5, 71, 1)] = 0.99
        pgm_function39[(5, 71, 2)] = 0.01
        pgm_function39[(5, 71, 3)] = 0.99
        pgm_function39[(5, 72, 1)] = 0.99
        pgm_function39[(5, 72, 2)] = 0.01
        pgm_function39[(5, 72, 3)] = 0.99
        pgm_function39[(5, 73, 1)] = 0.99
        pgm_function39[(5, 73, 2)] = 0.01
        pgm_function39[(5, 73, 3)] = 0.99
        pgm_function39[(5, 74, 1)] = 0.935
        pgm_function39[(5, 74, 2)] = 0.01
        pgm_function39[(5, 74, 3)] = 0.99
        pgm_function39[(5, 75, 1)] = 0.99
        pgm_function39[(5, 75, 2)] = 0.01
        pgm_function39[(5, 75, 3)] = 0.99

        pgm_function40 = pgm_factor40.set_sparse()
        pgm_function40[(0, 0)] = 0.94
        pgm_function40[(0, 3)] = 0.2
        pgm_function40[(0, 4)] = 0.3
        pgm_function40[(0, 5)] = 0.94
        pgm_function40[(0, 6)] = 0.3
        pgm_function40[(0, 7)] = 0.3
        pgm_function40[(0, 8)] = 0.3
        pgm_function40[(0, 9)] = 0.985
        pgm_function40[(0, 11)] = 0.985
        pgm_function40[(0, 12)] = 0.985
        pgm_function40[(0, 13)] = 0.985
        pgm_function40[(0, 14)] = 0.1
        pgm_function40[(0, 15)] = 0.25
        pgm_function40[(0, 16)] = 0.94
        pgm_function40[(0, 17)] = 0.985
        pgm_function40[(0, 18)] = 0.985
        pgm_function40[(0, 19)] = 0.985
        pgm_function40[(0, 20)] = 0.94
        pgm_function40[(0, 21)] = 0.94
        pgm_function40[(0, 22)] = 0.985
        pgm_function40[(0, 24)] = 0.985
        pgm_function40[(0, 25)] = 0.3
        pgm_function40[(0, 26)] = 0.3
        pgm_function40[(0, 27)] = 0.3
        pgm_function40[(0, 28)] = 0.3
        pgm_function40[(0, 29)] = 0.3
        pgm_function40[(0, 30)] = 0.3
        pgm_function40[(0, 31)] = 0.3
        pgm_function40[(0, 32)] = 0.3
        pgm_function40[(0, 33)] = 0.3
        pgm_function40[(0, 34)] = 0.98
        pgm_function40[(0, 35)] = 0.8
        pgm_function40[(0, 36)] = 0.05
        pgm_function40[(0, 37)] = 0.66
        pgm_function40[(0, 38)] = 0.05
        pgm_function40[(0, 39)] = 0.9
        pgm_function40[(0, 40)] = 0.99
        pgm_function40[(0, 41)] = 0.99
        pgm_function40[(0, 47)] = 0.01
        pgm_function40[(0, 48)] = 0.99
        pgm_function40[(0, 49)] = 0.66
        pgm_function40[(0, 53)] = 0.399
        pgm_function40[(0, 54)] = 0.3
        pgm_function40[(0, 55)] = 0.985
        pgm_function40[(0, 56)] = 0.996
        pgm_function40[(0, 57)] = 0.996
        pgm_function40[(0, 58)] = 0.94
        pgm_function40[(0, 59)] = 0.985
        pgm_function40[(0, 60)] = 0.985
        pgm_function40[(0, 61)] = 0.79
        pgm_function40[(0, 63)] = 0.01
        pgm_function40[(0, 64)] = 0.996
        pgm_function40[(0, 65)] = 0.996
        pgm_function40[(0, 67)] = 0.985
        pgm_function40[(0, 68)] = 0.985
        pgm_function40[(0, 69)] = 0.2
        pgm_function40[(0, 70)] = 0.985
        pgm_function40[(0, 71)] = 0.985
        pgm_function40[(0, 72)] = 0.985
        pgm_function40[(0, 73)] = 0.94
        pgm_function40[(0, 75)] = 0.99
        pgm_function40[(1, 0)] = 0.05
        pgm_function40[(1, 1)] = 0.3
        pgm_function40[(1, 2)] = 0.8
        pgm_function40[(1, 3)] = 0.79
        pgm_function40[(1, 4)] = 0.69
        pgm_function40[(1, 5)] = 0.05
        pgm_function40[(1, 6)] = 0.69
        pgm_function40[(1, 7)] = 0.69
        pgm_function40[(1, 8)] = 0.69
        pgm_function40[(1, 9)] = 0.01
        pgm_function40[(1, 10)] = 0.69999
        pgm_function40[(1, 11)] = 0.01
        pgm_function40[(1, 12)] = 0.01
        pgm_function40[(1, 13)] = 0.01
        pgm_function40[(1, 14)] = 0.6
        pgm_function40[(1, 15)] = 0.7
        pgm_function40[(1, 16)] = 0.05
        pgm_function40[(1, 17)] = 0.01
        pgm_function40[(1, 18)] = 0.01
        pgm_function40[(1, 19)] = 0.01
        pgm_function40[(1, 20)] = 0.05
        pgm_function40[(1, 21)] = 0.05
        pgm_function40[(1, 22)] = 0.01
        pgm_function40[(1, 23)] = 0.7999
        pgm_function40[(1, 24)] = 0.01
        pgm_function40[(1, 25)] = 0.686
        pgm_function40[(1, 26)] = 0.686
        pgm_function40[(1, 27)] = 0.686
        pgm_function40[(1, 28)] = 0.686
        pgm_function40[(1, 29)] = 0.686
        pgm_function40[(1, 30)] = 0.686
        pgm_function40[(1, 31)] = 0.686
        pgm_function40[(1, 32)] = 0.686
        pgm_function40[(1, 33)] = 0.686
        pgm_function40[(1, 34)] = 0.02
        pgm_function40[(1, 35)] = 0.15
        pgm_function40[(1, 36)] = 0.2375
        pgm_function40[(1, 37)] = 0.3
        pgm_function40[(1, 38)] = 0.9025
        pgm_function40[(1, 39)] = 0.095
        pgm_function40[(1, 40)] = 0.01
        pgm_function40[(1, 41)] = 0.01
        pgm_function40[(1, 42)] = 0.65
        pgm_function40[(1, 45)] = 0.3
        pgm_function40[(1, 46)] = 0.25
        pgm_function40[(1, 47)] = 0.02
        pgm_function40[(1, 48)] = 0.01
        pgm_function40[(1, 49)] = 0.3
        pgm_function40[(1, 53)] = 0.28
        pgm_function40[(1, 54)] = 0.1
        pgm_function40[(1, 55)] = 0.01
        pgm_function40[(1, 56)] = 0.001
        pgm_function40[(1, 57)] = 0.001
        pgm_function40[(1, 58)] = 0.05
        pgm_function40[(1, 59)] = 0.01
        pgm_function40[(1, 60)] = 0.01
        pgm_function40[(1, 61)] = 0.2
        pgm_function40[(1, 63)] = 0.189
        pgm_function40[(1, 64)] = 0.001
        pgm_function40[(1, 65)] = 0.001
        pgm_function40[(1, 66)] = 0.69999
        pgm_function40[(1, 67)] = 0.01
        pgm_function40[(1, 68)] = 0.01
        pgm_function40[(1, 69)] = 0.79
        pgm_function40[(1, 70)] = 0.01
        pgm_function40[(1, 71)] = 0.01
        pgm_function40[(1, 72)] = 0.01
        pgm_function40[(1, 73)] = 0.05
        pgm_function40[(1, 75)] = 0.01
        pgm_function40[(2, 0)] = 0.01
        pgm_function40[(2, 1)] = 0.7
        pgm_function40[(2, 2)] = 0.2
        pgm_function40[(2, 3)] = 0.01
        pgm_function40[(2, 4)] = 0.01
        pgm_function40[(2, 5)] = 0.01
        pgm_function40[(2, 6)] = 0.01
        pgm_function40[(2, 7)] = 0.01
        pgm_function40[(2, 8)] = 0.01
        pgm_function40[(2, 9)] = 0.005
        pgm_function40[(2, 10)] = 0.29
        pgm_function40[(2, 11)] = 0.005
        pgm_function40[(2, 12)] = 0.005
        pgm_function40[(2, 13)] = 0.005
        pgm_function40[(2, 14)] = 0.3
        pgm_function40[(2, 15)] = 0.05
        pgm_function40[(2, 16)] = 0.01
        pgm_function40[(2, 17)] = 0.005
        pgm_function40[(2, 18)] = 0.005
        pgm_function40[(2, 19)] = 0.005
        pgm_function40[(2, 20)] = 0.01
        pgm_function40[(2, 21)] = 0.01
        pgm_function40[(2, 22)] = 0.005
        pgm_function40[(2, 23)] = 0.2
        pgm_function40[(2, 24)] = 0.005
        pgm_function40[(2, 25)] = 0.014
        pgm_function40[(2, 26)] = 0.014
        pgm_function40[(2, 27)] = 0.014
        pgm_function40[(2, 28)] = 0.014
        pgm_function40[(2, 29)] = 0.014
        pgm_function40[(2, 30)] = 0.014
        pgm_function40[(2, 31)] = 0.014
        pgm_function40[(2, 32)] = 0.014
        pgm_function40[(2, 33)] = 0.014
        pgm_function40[(2, 35)] = 0.05
        pgm_function40[(2, 36)] = 0.2375
        pgm_function40[(2, 37)] = 0.04
        pgm_function40[(2, 38)] = 0.0475
        pgm_function40[(2, 39)] = 0.005
        pgm_function40[(2, 42)] = 0.35
        pgm_function40[(2, 43)] = 0.02
        pgm_function40[(2, 44)] = 0.01
        pgm_function40[(2, 45)] = 0.7
        pgm_function40[(2, 46)] = 0.7
        pgm_function40[(2, 47)] = 0.22
        pgm_function40[(2, 49)] = 0.04
        pgm_function40[(2, 50)] = 0.01
        pgm_function40[(2, 51)] = 0.05
        pgm_function40[(2, 52)] = 0.1
        pgm_function40[(2, 53)] = 0.3
        pgm_function40[(2, 54)] = 0.1
        pgm_function40[(2, 55)] = 0.005
        pgm_function40[(2, 56)] = 0.001
        pgm_function40[(2, 57)] = 0.001
        pgm_function40[(2, 58)] = 0.01
        pgm_function40[(2, 59)] = 0.005
        pgm_function40[(2, 60)] = 0.005
        pgm_function40[(2, 61)] = 0.01
        pgm_function40[(2, 62)] = 0.02
        pgm_function40[(2, 63)] = 0.8
        pgm_function40[(2, 64)] = 0.001
        pgm_function40[(2, 65)] = 0.001
        pgm_function40[(2, 66)] = 0.29
        pgm_function40[(2, 67)] = 0.005
        pgm_function40[(2, 68)] = 0.005
        pgm_function40[(2, 69)] = 0.01
        pgm_function40[(2, 70)] = 0.005
        pgm_function40[(2, 71)] = 0.005
        pgm_function40[(2, 72)] = 0.005
        pgm_function40[(2, 73)] = 0.01
        pgm_function40[(2, 74)] = 0.05
        pgm_function40[(3, 10)] = 0.01
        pgm_function40[(3, 23)] = 0.0001
        pgm_function40[(3, 36)] = 0.2375
        pgm_function40[(3, 43)] = 0.23
        pgm_function40[(3, 44)] = 0.24
        pgm_function40[(3, 46)] = 0.05
        pgm_function40[(3, 47)] = 0.15
        pgm_function40[(3, 50)] = 0.14
        pgm_function40[(3, 51)] = 0.6
        pgm_function40[(3, 52)] = 0.8
        pgm_function40[(3, 53)] = 0.02
        pgm_function40[(3, 54)] = 0.2
        pgm_function40[(3, 56)] = 0.001
        pgm_function40[(3, 57)] = 0.001
        pgm_function40[(3, 62)] = 0.48
        pgm_function40[(3, 63)] = 0.001
        pgm_function40[(3, 64)] = 0.001
        pgm_function40[(3, 65)] = 0.001
        pgm_function40[(3, 66)] = 0.01
        pgm_function40[(3, 74)] = 0.6
        pgm_function40[(4, 10)] = 1e-05
        pgm_function40[(4, 36)] = 0.2375
        pgm_function40[(4, 43)] = 0.75
        pgm_function40[(4, 44)] = 0.75
        pgm_function40[(4, 47)] = 0.6
        pgm_function40[(4, 50)] = 0.85
        pgm_function40[(4, 51)] = 0.35
        pgm_function40[(4, 52)] = 0.1
        pgm_function40[(4, 53)] = 0.001
        pgm_function40[(4, 54)] = 0.3
        pgm_function40[(4, 56)] = 0.001
        pgm_function40[(4, 57)] = 0.001
        pgm_function40[(4, 62)] = 0.5
        pgm_function40[(4, 64)] = 0.001
        pgm_function40[(4, 65)] = 0.001
        pgm_function40[(4, 66)] = 1e-05
        pgm_function40[(4, 74)] = 0.35

        pgm_function41 = pgm_factor41.set_sparse()
        pgm_function41[(0, 0, 0)] = 1.0
        pgm_function41[(0, 1, 0)] = 1.0
        pgm_function41[(0, 2, 0)] = 1.0
        pgm_function41[(0, 3, 0)] = 1.0
        pgm_function41[(0, 4, 0)] = 1.0
        pgm_function41[(0, 5, 0)] = 1.0
        pgm_function41[(0, 6, 0)] = 1.0
        pgm_function41[(0, 7, 0)] = 1.0
        pgm_function41[(0, 8, 0)] = 1.0
        pgm_function41[(0, 9, 0)] = 1.0
        pgm_function41[(0, 10, 0)] = 1.0
        pgm_function41[(0, 11, 0)] = 1.0
        pgm_function41[(0, 12, 0)] = 1.0
        pgm_function41[(0, 13, 0)] = 1.0
        pgm_function41[(0, 14, 0)] = 1.0
        pgm_function41[(0, 15, 0)] = 1.0
        pgm_function41[(0, 16, 0)] = 1.0
        pgm_function41[(0, 17, 0)] = 1.0
        pgm_function41[(0, 18, 0)] = 1.0
        pgm_function41[(0, 19, 0)] = 1.0
        pgm_function41[(0, 20, 0)] = 1.0
        pgm_function41[(0, 21, 0)] = 1.0
        pgm_function41[(0, 22, 0)] = 1.0
        pgm_function41[(0, 23, 0)] = 1.0
        pgm_function41[(0, 24, 0)] = 1.0
        pgm_function41[(0, 25, 0)] = 1.0
        pgm_function41[(0, 26, 0)] = 1.0
        pgm_function41[(0, 27, 0)] = 1.0
        pgm_function41[(0, 28, 0)] = 1.0
        pgm_function41[(0, 29, 0)] = 1.0
        pgm_function41[(0, 30, 0)] = 1.0
        pgm_function41[(0, 31, 0)] = 1.0
        pgm_function41[(0, 32, 0)] = 1.0
        pgm_function41[(0, 33, 0)] = 1.0
        pgm_function41[(0, 34, 0)] = 1.0
        pgm_function41[(0, 35, 0)] = 1.0
        pgm_function41[(0, 36, 0)] = 1.0
        pgm_function41[(0, 37, 0)] = 1.0
        pgm_function41[(0, 38, 0)] = 1.0
        pgm_function41[(0, 39, 0)] = 1.0
        pgm_function41[(0, 40, 0)] = 1.0
        pgm_function41[(0, 41, 0)] = 1.0
        pgm_function41[(0, 42, 0)] = 1.0
        pgm_function41[(0, 43, 0)] = 1.0
        pgm_function41[(0, 44, 0)] = 1.0
        pgm_function41[(0, 45, 0)] = 1.0
        pgm_function41[(0, 46, 0)] = 1.0
        pgm_function41[(0, 47, 0)] = 1.0
        pgm_function41[(0, 48, 0)] = 1.0
        pgm_function41[(0, 49, 0)] = 1.0
        pgm_function41[(0, 50, 0)] = 1.0
        pgm_function41[(0, 51, 0)] = 1.0
        pgm_function41[(0, 52, 0)] = 1.0
        pgm_function41[(0, 53, 0)] = 1.0
        pgm_function41[(0, 54, 0)] = 1.0
        pgm_function41[(0, 55, 0)] = 1.0
        pgm_function41[(0, 56, 0)] = 1.0
        pgm_function41[(0, 57, 0)] = 1.0
        pgm_function41[(0, 58, 0)] = 1.0
        pgm_function41[(0, 59, 0)] = 1.0
        pgm_function41[(0, 60, 0)] = 1.0
        pgm_function41[(0, 61, 0)] = 1.0
        pgm_function41[(0, 62, 0)] = 1.0
        pgm_function41[(0, 63, 0)] = 1.0
        pgm_function41[(0, 64, 0)] = 1.0
        pgm_function41[(0, 65, 0)] = 1.0
        pgm_function41[(0, 66, 0)] = 1.0
        pgm_function41[(0, 67, 0)] = 1.0
        pgm_function41[(0, 68, 0)] = 1.0
        pgm_function41[(0, 69, 0)] = 1.0
        pgm_function41[(0, 70, 0)] = 1.0
        pgm_function41[(0, 71, 0)] = 1.0
        pgm_function41[(0, 72, 0)] = 1.0
        pgm_function41[(0, 73, 0)] = 1.0
        pgm_function41[(0, 74, 0)] = 1.0
        pgm_function41[(0, 75, 0)] = 1.0
        pgm_function41[(1, 0, 1)] = 0.02
        pgm_function41[(1, 0, 2)] = 0.02
        pgm_function41[(1, 0, 3)] = 0.02
        pgm_function41[(1, 0, 4)] = 0.02
        pgm_function41[(1, 1, 1)] = 0.2
        pgm_function41[(1, 1, 2)] = 0.2
        pgm_function41[(1, 1, 3)] = 0.2
        pgm_function41[(1, 1, 4)] = 0.2
        pgm_function41[(1, 2, 1)] = 0.2
        pgm_function41[(1, 2, 2)] = 0.2
        pgm_function41[(1, 2, 3)] = 0.2
        pgm_function41[(1, 2, 4)] = 0.2
        pgm_function41[(1, 3, 1)] = 0.1
        pgm_function41[(1, 3, 2)] = 0.1
        pgm_function41[(1, 3, 3)] = 0.1
        pgm_function41[(1, 3, 4)] = 0.1
        pgm_function41[(1, 4, 1)] = 0.2
        pgm_function41[(1, 4, 2)] = 0.2
        pgm_function41[(1, 4, 3)] = 0.2
        pgm_function41[(1, 4, 4)] = 0.2
        pgm_function41[(1, 5, 1)] = 0.02
        pgm_function41[(1, 5, 2)] = 0.02
        pgm_function41[(1, 5, 3)] = 0.02
        pgm_function41[(1, 5, 4)] = 0.02
        pgm_function41[(1, 6, 1)] = 0.2
        pgm_function41[(1, 6, 2)] = 0.2
        pgm_function41[(1, 6, 3)] = 0.2
        pgm_function41[(1, 6, 4)] = 0.2
        pgm_function41[(1, 7, 1)] = 0.1
        pgm_function41[(1, 7, 2)] = 0.1
        pgm_function41[(1, 7, 3)] = 0.1
        pgm_function41[(1, 7, 4)] = 0.1
        pgm_function41[(1, 8, 1)] = 0.2
        pgm_function41[(1, 8, 2)] = 0.2
        pgm_function41[(1, 8, 3)] = 0.2
        pgm_function41[(1, 8, 4)] = 0.2
        pgm_function41[(1, 9, 1)] = 0.2
        pgm_function41[(1, 9, 2)] = 0.2
        pgm_function41[(1, 9, 3)] = 0.2
        pgm_function41[(1, 9, 4)] = 0.2
        pgm_function41[(1, 10, 1)] = 0.1
        pgm_function41[(1, 10, 2)] = 0.1
        pgm_function41[(1, 10, 3)] = 0.1
        pgm_function41[(1, 10, 4)] = 0.1
        pgm_function41[(1, 11, 1)] = 0.2
        pgm_function41[(1, 11, 2)] = 0.2
        pgm_function41[(1, 11, 3)] = 0.2
        pgm_function41[(1, 11, 4)] = 0.2
        pgm_function41[(1, 12, 1)] = 0.2
        pgm_function41[(1, 12, 2)] = 0.2
        pgm_function41[(1, 12, 3)] = 0.2
        pgm_function41[(1, 12, 4)] = 0.2
        pgm_function41[(1, 13, 1)] = 0.2
        pgm_function41[(1, 13, 2)] = 0.2
        pgm_function41[(1, 13, 3)] = 0.2
        pgm_function41[(1, 13, 4)] = 0.2
        pgm_function41[(1, 14, 1)] = 0.2
        pgm_function41[(1, 14, 2)] = 0.2
        pgm_function41[(1, 14, 3)] = 0.2
        pgm_function41[(1, 14, 4)] = 0.2
        pgm_function41[(1, 15, 1)] = 0.2
        pgm_function41[(1, 15, 2)] = 0.2
        pgm_function41[(1, 15, 3)] = 0.2
        pgm_function41[(1, 15, 4)] = 0.2
        pgm_function41[(1, 16, 1)] = 0.1
        pgm_function41[(1, 16, 2)] = 0.1
        pgm_function41[(1, 16, 3)] = 0.1
        pgm_function41[(1, 16, 4)] = 0.1
        pgm_function41[(1, 17, 1)] = 0.2
        pgm_function41[(1, 17, 2)] = 0.2
        pgm_function41[(1, 17, 3)] = 0.2
        pgm_function41[(1, 17, 4)] = 0.2
        pgm_function41[(1, 18, 1)] = 0.2
        pgm_function41[(1, 18, 2)] = 0.2
        pgm_function41[(1, 18, 3)] = 0.2
        pgm_function41[(1, 18, 4)] = 0.2
        pgm_function41[(1, 19, 1)] = 0.2
        pgm_function41[(1, 19, 2)] = 0.2
        pgm_function41[(1, 19, 3)] = 0.2
        pgm_function41[(1, 19, 4)] = 0.2
        pgm_function41[(1, 20, 1)] = 0.1
        pgm_function41[(1, 20, 2)] = 0.1
        pgm_function41[(1, 20, 3)] = 0.1
        pgm_function41[(1, 20, 4)] = 0.1
        pgm_function41[(1, 21, 1)] = 0.1
        pgm_function41[(1, 21, 2)] = 0.1
        pgm_function41[(1, 21, 3)] = 0.1
        pgm_function41[(1, 21, 4)] = 0.1
        pgm_function41[(1, 22, 1)] = 0.2
        pgm_function41[(1, 22, 2)] = 0.2
        pgm_function41[(1, 22, 3)] = 0.2
        pgm_function41[(1, 22, 4)] = 0.2
        pgm_function41[(1, 23, 1)] = 0.1
        pgm_function41[(1, 23, 2)] = 0.1
        pgm_function41[(1, 23, 3)] = 0.1
        pgm_function41[(1, 23, 4)] = 0.1
        pgm_function41[(1, 24, 1)] = 0.2
        pgm_function41[(1, 24, 2)] = 0.2
        pgm_function41[(1, 24, 3)] = 0.2
        pgm_function41[(1, 24, 4)] = 0.2
        pgm_function41[(1, 25, 1)] = 0.2
        pgm_function41[(1, 25, 2)] = 0.2
        pgm_function41[(1, 25, 3)] = 0.2
        pgm_function41[(1, 25, 4)] = 0.2
        pgm_function41[(1, 26, 1)] = 0.2
        pgm_function41[(1, 26, 2)] = 0.2
        pgm_function41[(1, 26, 3)] = 0.2
        pgm_function41[(1, 26, 4)] = 0.2
        pgm_function41[(1, 27, 1)] = 0.2
        pgm_function41[(1, 27, 2)] = 0.2
        pgm_function41[(1, 27, 3)] = 0.2
        pgm_function41[(1, 27, 4)] = 0.2
        pgm_function41[(1, 28, 1)] = 0.2
        pgm_function41[(1, 28, 2)] = 0.2
        pgm_function41[(1, 28, 3)] = 0.2
        pgm_function41[(1, 28, 4)] = 0.2
        pgm_function41[(1, 29, 1)] = 0.2
        pgm_function41[(1, 29, 2)] = 0.2
        pgm_function41[(1, 29, 3)] = 0.2
        pgm_function41[(1, 29, 4)] = 0.2
        pgm_function41[(1, 30, 1)] = 0.2
        pgm_function41[(1, 30, 2)] = 0.2
        pgm_function41[(1, 30, 3)] = 0.2
        pgm_function41[(1, 30, 4)] = 0.2
        pgm_function41[(1, 31, 1)] = 0.2
        pgm_function41[(1, 31, 2)] = 0.2
        pgm_function41[(1, 31, 3)] = 0.2
        pgm_function41[(1, 31, 4)] = 0.2
        pgm_function41[(1, 32, 1)] = 0.2
        pgm_function41[(1, 32, 2)] = 0.2
        pgm_function41[(1, 32, 3)] = 0.2
        pgm_function41[(1, 32, 4)] = 0.2
        pgm_function41[(1, 33, 1)] = 0.2
        pgm_function41[(1, 33, 2)] = 0.2
        pgm_function41[(1, 33, 3)] = 0.2
        pgm_function41[(1, 33, 4)] = 0.2
        pgm_function41[(1, 34, 1)] = 1.0
        pgm_function41[(1, 34, 2)] = 1.0
        pgm_function41[(1, 34, 3)] = 1.0
        pgm_function41[(1, 34, 4)] = 1.0
        pgm_function41[(1, 38, 1)] = 0.2
        pgm_function41[(1, 38, 2)] = 0.2
        pgm_function41[(1, 38, 3)] = 0.2
        pgm_function41[(1, 38, 4)] = 0.2
        pgm_function41[(1, 39, 1)] = 0.2
        pgm_function41[(1, 39, 2)] = 0.2
        pgm_function41[(1, 39, 3)] = 0.2
        pgm_function41[(1, 39, 4)] = 0.2
        pgm_function41[(1, 40, 1)] = 0.2
        pgm_function41[(1, 40, 2)] = 0.2
        pgm_function41[(1, 40, 3)] = 0.2
        pgm_function41[(1, 40, 4)] = 0.2
        pgm_function41[(1, 41, 1)] = 0.2
        pgm_function41[(1, 41, 2)] = 0.2
        pgm_function41[(1, 41, 3)] = 0.2
        pgm_function41[(1, 41, 4)] = 0.2
        pgm_function41[(1, 42, 1)] = 0.2
        pgm_function41[(1, 42, 2)] = 0.2
        pgm_function41[(1, 42, 3)] = 0.2
        pgm_function41[(1, 42, 4)] = 0.2
        pgm_function41[(1, 43, 1)] = 0.2
        pgm_function41[(1, 43, 2)] = 0.2
        pgm_function41[(1, 43, 3)] = 0.2
        pgm_function41[(1, 43, 4)] = 0.2
        pgm_function41[(1, 44, 1)] = 0.2
        pgm_function41[(1, 44, 2)] = 0.2
        pgm_function41[(1, 44, 3)] = 0.2
        pgm_function41[(1, 44, 4)] = 0.2
        pgm_function41[(1, 45, 1)] = 0.2
        pgm_function41[(1, 45, 2)] = 0.2
        pgm_function41[(1, 45, 3)] = 0.2
        pgm_function41[(1, 45, 4)] = 0.2
        pgm_function41[(1, 46, 1)] = 0.2
        pgm_function41[(1, 46, 2)] = 0.2
        pgm_function41[(1, 46, 3)] = 0.2
        pgm_function41[(1, 46, 4)] = 0.2
        pgm_function41[(1, 47, 1)] = 0.2
        pgm_function41[(1, 47, 2)] = 0.2
        pgm_function41[(1, 47, 3)] = 0.2
        pgm_function41[(1, 47, 4)] = 0.2
        pgm_function41[(1, 48, 1)] = 0.2
        pgm_function41[(1, 48, 2)] = 0.2
        pgm_function41[(1, 48, 3)] = 0.2
        pgm_function41[(1, 48, 4)] = 0.2
        pgm_function41[(1, 49, 1)] = 0.2
        pgm_function41[(1, 49, 2)] = 0.2
        pgm_function41[(1, 49, 3)] = 0.2
        pgm_function41[(1, 49, 4)] = 0.2
        pgm_function41[(1, 50, 1)] = 0.2
        pgm_function41[(1, 50, 2)] = 0.2
        pgm_function41[(1, 50, 3)] = 0.2
        pgm_function41[(1, 50, 4)] = 0.2
        pgm_function41[(1, 51, 1)] = 0.2
        pgm_function41[(1, 51, 2)] = 0.2
        pgm_function41[(1, 51, 3)] = 0.2
        pgm_function41[(1, 51, 4)] = 0.2
        pgm_function41[(1, 52, 1)] = 0.2
        pgm_function41[(1, 52, 2)] = 0.2
        pgm_function41[(1, 52, 3)] = 0.2
        pgm_function41[(1, 52, 4)] = 0.2
        pgm_function41[(1, 53, 1)] = 0.2
        pgm_function41[(1, 53, 2)] = 0.2
        pgm_function41[(1, 53, 3)] = 0.2
        pgm_function41[(1, 53, 4)] = 0.2
        pgm_function41[(1, 54, 1)] = 0.2
        pgm_function41[(1, 54, 2)] = 0.2
        pgm_function41[(1, 54, 3)] = 0.2
        pgm_function41[(1, 54, 4)] = 0.2
        pgm_function41[(1, 55, 1)] = 0.2
        pgm_function41[(1, 55, 2)] = 0.2
        pgm_function41[(1, 55, 3)] = 0.2
        pgm_function41[(1, 55, 4)] = 0.2
        pgm_function41[(1, 56, 1)] = 0.2
        pgm_function41[(1, 56, 2)] = 0.2
        pgm_function41[(1, 56, 3)] = 0.2
        pgm_function41[(1, 56, 4)] = 0.2
        pgm_function41[(1, 57, 1)] = 0.2
        pgm_function41[(1, 57, 2)] = 0.2
        pgm_function41[(1, 57, 3)] = 0.2
        pgm_function41[(1, 57, 4)] = 0.2
        pgm_function41[(1, 58, 1)] = 0.2
        pgm_function41[(1, 58, 2)] = 0.2
        pgm_function41[(1, 58, 3)] = 0.2
        pgm_function41[(1, 58, 4)] = 0.2
        pgm_function41[(1, 59, 1)] = 0.2
        pgm_function41[(1, 59, 2)] = 0.2
        pgm_function41[(1, 59, 3)] = 0.2
        pgm_function41[(1, 59, 4)] = 0.2
        pgm_function41[(1, 60, 1)] = 0.2
        pgm_function41[(1, 60, 2)] = 0.2
        pgm_function41[(1, 60, 3)] = 0.2
        pgm_function41[(1, 60, 4)] = 0.2
        pgm_function41[(1, 61, 1)] = 0.2
        pgm_function41[(1, 61, 2)] = 0.2
        pgm_function41[(1, 61, 3)] = 0.2
        pgm_function41[(1, 61, 4)] = 0.2
        pgm_function41[(1, 62, 1)] = 0.2
        pgm_function41[(1, 62, 2)] = 0.2
        pgm_function41[(1, 62, 3)] = 0.2
        pgm_function41[(1, 62, 4)] = 0.2
        pgm_function41[(1, 63, 1)] = 0.4
        pgm_function41[(1, 63, 2)] = 0.4
        pgm_function41[(1, 63, 3)] = 0.4
        pgm_function41[(1, 63, 4)] = 0.4
        pgm_function41[(1, 64, 1)] = 0.2
        pgm_function41[(1, 64, 2)] = 0.2
        pgm_function41[(1, 64, 3)] = 0.2
        pgm_function41[(1, 64, 4)] = 0.2
        pgm_function41[(1, 65, 1)] = 0.2
        pgm_function41[(1, 65, 2)] = 0.2
        pgm_function41[(1, 65, 3)] = 0.2
        pgm_function41[(1, 65, 4)] = 0.2
        pgm_function41[(1, 66, 1)] = 0.2
        pgm_function41[(1, 66, 2)] = 0.2
        pgm_function41[(1, 66, 3)] = 0.2
        pgm_function41[(1, 66, 4)] = 0.2
        pgm_function41[(1, 67, 1)] = 0.2
        pgm_function41[(1, 67, 2)] = 0.2
        pgm_function41[(1, 67, 3)] = 0.2
        pgm_function41[(1, 67, 4)] = 0.2
        pgm_function41[(1, 68, 1)] = 0.2
        pgm_function41[(1, 68, 2)] = 0.2
        pgm_function41[(1, 68, 3)] = 0.2
        pgm_function41[(1, 68, 4)] = 0.2
        pgm_function41[(1, 69, 1)] = 0.2
        pgm_function41[(1, 69, 2)] = 0.2
        pgm_function41[(1, 69, 3)] = 0.2
        pgm_function41[(1, 69, 4)] = 0.2
        pgm_function41[(1, 70, 1)] = 0.2
        pgm_function41[(1, 70, 2)] = 0.2
        pgm_function41[(1, 70, 3)] = 0.2
        pgm_function41[(1, 70, 4)] = 0.2
        pgm_function41[(1, 71, 1)] = 0.2
        pgm_function41[(1, 71, 2)] = 0.2
        pgm_function41[(1, 71, 3)] = 0.2
        pgm_function41[(1, 71, 4)] = 0.2
        pgm_function41[(1, 72, 1)] = 0.2
        pgm_function41[(1, 72, 2)] = 0.2
        pgm_function41[(1, 72, 3)] = 0.2
        pgm_function41[(1, 72, 4)] = 0.2
        pgm_function41[(1, 73, 1)] = 0.2
        pgm_function41[(1, 73, 2)] = 0.2
        pgm_function41[(1, 73, 3)] = 0.2
        pgm_function41[(1, 73, 4)] = 0.2
        pgm_function41[(1, 74, 1)] = 0.2
        pgm_function41[(1, 74, 2)] = 0.2
        pgm_function41[(1, 74, 3)] = 0.2
        pgm_function41[(1, 74, 4)] = 0.2
        pgm_function41[(1, 75, 1)] = 0.2
        pgm_function41[(1, 75, 2)] = 0.2
        pgm_function41[(1, 75, 3)] = 0.2
        pgm_function41[(1, 75, 4)] = 0.2
        pgm_function41[(2, 0, 1)] = 0.01
        pgm_function41[(2, 0, 2)] = 0.01
        pgm_function41[(2, 0, 3)] = 0.01
        pgm_function41[(2, 0, 4)] = 0.01
        pgm_function41[(2, 1, 1)] = 0.001
        pgm_function41[(2, 1, 2)] = 0.001
        pgm_function41[(2, 1, 3)] = 0.001
        pgm_function41[(2, 1, 4)] = 0.001
        pgm_function41[(2, 2, 1)] = 0.001
        pgm_function41[(2, 2, 2)] = 0.001
        pgm_function41[(2, 2, 3)] = 0.001
        pgm_function41[(2, 2, 4)] = 0.001
        pgm_function41[(2, 3, 1)] = 0.001
        pgm_function41[(2, 3, 2)] = 0.001
        pgm_function41[(2, 3, 3)] = 0.001
        pgm_function41[(2, 3, 4)] = 0.001
        pgm_function41[(2, 4, 1)] = 0.001
        pgm_function41[(2, 4, 2)] = 0.001
        pgm_function41[(2, 4, 3)] = 0.001
        pgm_function41[(2, 4, 4)] = 0.001
        pgm_function41[(2, 5, 1)] = 0.01
        pgm_function41[(2, 5, 2)] = 0.01
        pgm_function41[(2, 5, 3)] = 0.01
        pgm_function41[(2, 5, 4)] = 0.01
        pgm_function41[(2, 6, 1)] = 0.001
        pgm_function41[(2, 6, 2)] = 0.001
        pgm_function41[(2, 6, 3)] = 0.001
        pgm_function41[(2, 6, 4)] = 0.001
        pgm_function41[(2, 7, 1)] = 0.001
        pgm_function41[(2, 7, 2)] = 0.001
        pgm_function41[(2, 7, 3)] = 0.001
        pgm_function41[(2, 7, 4)] = 0.001
        pgm_function41[(2, 8, 1)] = 0.001
        pgm_function41[(2, 8, 2)] = 0.001
        pgm_function41[(2, 8, 3)] = 0.001
        pgm_function41[(2, 8, 4)] = 0.001
        pgm_function41[(2, 9, 1)] = 0.001
        pgm_function41[(2, 9, 2)] = 0.001
        pgm_function41[(2, 9, 3)] = 0.001
        pgm_function41[(2, 9, 4)] = 0.001
        pgm_function41[(2, 10, 1)] = 0.001
        pgm_function41[(2, 10, 2)] = 0.001
        pgm_function41[(2, 10, 3)] = 0.001
        pgm_function41[(2, 10, 4)] = 0.001
        pgm_function41[(2, 11, 1)] = 0.001
        pgm_function41[(2, 11, 2)] = 0.001
        pgm_function41[(2, 11, 3)] = 0.001
        pgm_function41[(2, 11, 4)] = 0.001
        pgm_function41[(2, 12, 1)] = 0.001
        pgm_function41[(2, 12, 2)] = 0.001
        pgm_function41[(2, 12, 3)] = 0.001
        pgm_function41[(2, 12, 4)] = 0.001
        pgm_function41[(2, 13, 1)] = 0.001
        pgm_function41[(2, 13, 2)] = 0.001
        pgm_function41[(2, 13, 3)] = 0.001
        pgm_function41[(2, 13, 4)] = 0.001
        pgm_function41[(2, 14, 1)] = 0.001
        pgm_function41[(2, 14, 2)] = 0.001
        pgm_function41[(2, 14, 3)] = 0.001
        pgm_function41[(2, 14, 4)] = 0.001
        pgm_function41[(2, 15, 1)] = 0.001
        pgm_function41[(2, 15, 2)] = 0.001
        pgm_function41[(2, 15, 3)] = 0.001
        pgm_function41[(2, 15, 4)] = 0.001
        pgm_function41[(2, 16, 1)] = 0.001
        pgm_function41[(2, 16, 2)] = 0.001
        pgm_function41[(2, 16, 3)] = 0.001
        pgm_function41[(2, 16, 4)] = 0.001
        pgm_function41[(2, 17, 1)] = 0.001
        pgm_function41[(2, 17, 2)] = 0.001
        pgm_function41[(2, 17, 3)] = 0.001
        pgm_function41[(2, 17, 4)] = 0.001
        pgm_function41[(2, 18, 1)] = 0.001
        pgm_function41[(2, 18, 2)] = 0.001
        pgm_function41[(2, 18, 3)] = 0.001
        pgm_function41[(2, 18, 4)] = 0.001
        pgm_function41[(2, 19, 1)] = 0.001
        pgm_function41[(2, 19, 2)] = 0.001
        pgm_function41[(2, 19, 3)] = 0.001
        pgm_function41[(2, 19, 4)] = 0.001
        pgm_function41[(2, 20, 1)] = 0.001
        pgm_function41[(2, 20, 2)] = 0.001
        pgm_function41[(2, 20, 3)] = 0.001
        pgm_function41[(2, 20, 4)] = 0.001
        pgm_function41[(2, 21, 1)] = 0.001
        pgm_function41[(2, 21, 2)] = 0.001
        pgm_function41[(2, 21, 3)] = 0.001
        pgm_function41[(2, 21, 4)] = 0.001
        pgm_function41[(2, 22, 1)] = 0.001
        pgm_function41[(2, 22, 2)] = 0.001
        pgm_function41[(2, 22, 3)] = 0.001
        pgm_function41[(2, 22, 4)] = 0.001
        pgm_function41[(2, 23, 1)] = 0.001
        pgm_function41[(2, 23, 2)] = 0.001
        pgm_function41[(2, 23, 3)] = 0.001
        pgm_function41[(2, 23, 4)] = 0.001
        pgm_function41[(2, 24, 1)] = 0.001
        pgm_function41[(2, 24, 2)] = 0.001
        pgm_function41[(2, 24, 3)] = 0.001
        pgm_function41[(2, 24, 4)] = 0.001
        pgm_function41[(2, 25, 1)] = 0.001
        pgm_function41[(2, 25, 2)] = 0.001
        pgm_function41[(2, 25, 3)] = 0.001
        pgm_function41[(2, 25, 4)] = 0.001
        pgm_function41[(2, 26, 1)] = 0.001
        pgm_function41[(2, 26, 2)] = 0.001
        pgm_function41[(2, 26, 3)] = 0.001
        pgm_function41[(2, 26, 4)] = 0.001
        pgm_function41[(2, 27, 1)] = 0.001
        pgm_function41[(2, 27, 2)] = 0.001
        pgm_function41[(2, 27, 3)] = 0.001
        pgm_function41[(2, 27, 4)] = 0.001
        pgm_function41[(2, 28, 1)] = 0.001
        pgm_function41[(2, 28, 2)] = 0.001
        pgm_function41[(2, 28, 3)] = 0.001
        pgm_function41[(2, 28, 4)] = 0.001
        pgm_function41[(2, 29, 1)] = 0.001
        pgm_function41[(2, 29, 2)] = 0.001
        pgm_function41[(2, 29, 3)] = 0.001
        pgm_function41[(2, 29, 4)] = 0.001
        pgm_function41[(2, 30, 1)] = 0.001
        pgm_function41[(2, 30, 2)] = 0.001
        pgm_function41[(2, 30, 3)] = 0.001
        pgm_function41[(2, 30, 4)] = 0.001
        pgm_function41[(2, 31, 1)] = 0.001
        pgm_function41[(2, 31, 2)] = 0.001
        pgm_function41[(2, 31, 3)] = 0.001
        pgm_function41[(2, 31, 4)] = 0.001
        pgm_function41[(2, 32, 1)] = 0.001
        pgm_function41[(2, 32, 2)] = 0.001
        pgm_function41[(2, 32, 3)] = 0.001
        pgm_function41[(2, 32, 4)] = 0.001
        pgm_function41[(2, 33, 1)] = 0.001
        pgm_function41[(2, 33, 2)] = 0.001
        pgm_function41[(2, 33, 3)] = 0.001
        pgm_function41[(2, 33, 4)] = 0.001
        pgm_function41[(2, 37, 1)] = 1.0
        pgm_function41[(2, 37, 2)] = 1.0
        pgm_function41[(2, 37, 3)] = 1.0
        pgm_function41[(2, 37, 4)] = 1.0
        pgm_function41[(2, 38, 1)] = 0.001
        pgm_function41[(2, 38, 2)] = 0.001
        pgm_function41[(2, 38, 3)] = 0.001
        pgm_function41[(2, 38, 4)] = 0.001
        pgm_function41[(2, 39, 1)] = 0.001
        pgm_function41[(2, 39, 2)] = 0.001
        pgm_function41[(2, 39, 3)] = 0.001
        pgm_function41[(2, 39, 4)] = 0.001
        pgm_function41[(2, 40, 1)] = 0.001
        pgm_function41[(2, 40, 2)] = 0.001
        pgm_function41[(2, 40, 3)] = 0.001
        pgm_function41[(2, 40, 4)] = 0.001
        pgm_function41[(2, 41, 1)] = 0.001
        pgm_function41[(2, 41, 2)] = 0.001
        pgm_function41[(2, 41, 3)] = 0.001
        pgm_function41[(2, 41, 4)] = 0.001
        pgm_function41[(2, 42, 1)] = 0.001
        pgm_function41[(2, 42, 2)] = 0.001
        pgm_function41[(2, 42, 3)] = 0.001
        pgm_function41[(2, 42, 4)] = 0.001
        pgm_function41[(2, 43, 1)] = 0.001
        pgm_function41[(2, 43, 2)] = 0.001
        pgm_function41[(2, 43, 3)] = 0.001
        pgm_function41[(2, 43, 4)] = 0.001
        pgm_function41[(2, 44, 1)] = 0.001
        pgm_function41[(2, 44, 2)] = 0.001
        pgm_function41[(2, 44, 3)] = 0.001
        pgm_function41[(2, 44, 4)] = 0.001
        pgm_function41[(2, 45, 1)] = 0.001
        pgm_function41[(2, 45, 2)] = 0.001
        pgm_function41[(2, 45, 3)] = 0.001
        pgm_function41[(2, 45, 4)] = 0.001
        pgm_function41[(2, 46, 1)] = 0.001
        pgm_function41[(2, 46, 2)] = 0.001
        pgm_function41[(2, 46, 3)] = 0.001
        pgm_function41[(2, 46, 4)] = 0.001
        pgm_function41[(2, 47, 1)] = 0.001
        pgm_function41[(2, 47, 2)] = 0.001
        pgm_function41[(2, 47, 3)] = 0.001
        pgm_function41[(2, 47, 4)] = 0.001
        pgm_function41[(2, 48, 1)] = 0.001
        pgm_function41[(2, 48, 2)] = 0.001
        pgm_function41[(2, 48, 3)] = 0.001
        pgm_function41[(2, 48, 4)] = 0.001
        pgm_function41[(2, 49, 1)] = 0.001
        pgm_function41[(2, 49, 2)] = 0.001
        pgm_function41[(2, 49, 3)] = 0.001
        pgm_function41[(2, 49, 4)] = 0.001
        pgm_function41[(2, 50, 1)] = 0.001
        pgm_function41[(2, 50, 2)] = 0.001
        pgm_function41[(2, 50, 3)] = 0.001
        pgm_function41[(2, 50, 4)] = 0.001
        pgm_function41[(2, 51, 1)] = 0.001
        pgm_function41[(2, 51, 2)] = 0.001
        pgm_function41[(2, 51, 3)] = 0.001
        pgm_function41[(2, 51, 4)] = 0.001
        pgm_function41[(2, 52, 1)] = 0.001
        pgm_function41[(2, 52, 2)] = 0.001
        pgm_function41[(2, 52, 3)] = 0.001
        pgm_function41[(2, 52, 4)] = 0.001
        pgm_function41[(2, 53, 1)] = 0.001
        pgm_function41[(2, 53, 2)] = 0.001
        pgm_function41[(2, 53, 3)] = 0.001
        pgm_function41[(2, 53, 4)] = 0.001
        pgm_function41[(2, 54, 1)] = 0.001
        pgm_function41[(2, 54, 2)] = 0.001
        pgm_function41[(2, 54, 3)] = 0.001
        pgm_function41[(2, 54, 4)] = 0.001
        pgm_function41[(2, 55, 1)] = 0.001
        pgm_function41[(2, 55, 2)] = 0.001
        pgm_function41[(2, 55, 3)] = 0.001
        pgm_function41[(2, 55, 4)] = 0.001
        pgm_function41[(2, 56, 1)] = 0.001
        pgm_function41[(2, 56, 2)] = 0.001
        pgm_function41[(2, 56, 3)] = 0.001
        pgm_function41[(2, 56, 4)] = 0.001
        pgm_function41[(2, 57, 1)] = 0.001
        pgm_function41[(2, 57, 2)] = 0.001
        pgm_function41[(2, 57, 3)] = 0.001
        pgm_function41[(2, 57, 4)] = 0.001
        pgm_function41[(2, 58, 1)] = 0.001
        pgm_function41[(2, 58, 2)] = 0.001
        pgm_function41[(2, 58, 3)] = 0.001
        pgm_function41[(2, 58, 4)] = 0.001
        pgm_function41[(2, 59, 1)] = 0.001
        pgm_function41[(2, 59, 2)] = 0.001
        pgm_function41[(2, 59, 3)] = 0.001
        pgm_function41[(2, 59, 4)] = 0.001
        pgm_function41[(2, 60, 1)] = 0.001
        pgm_function41[(2, 60, 2)] = 0.001
        pgm_function41[(2, 60, 3)] = 0.001
        pgm_function41[(2, 60, 4)] = 0.001
        pgm_function41[(2, 61, 1)] = 0.001
        pgm_function41[(2, 61, 2)] = 0.001
        pgm_function41[(2, 61, 3)] = 0.001
        pgm_function41[(2, 61, 4)] = 0.001
        pgm_function41[(2, 62, 1)] = 0.001
        pgm_function41[(2, 62, 2)] = 0.001
        pgm_function41[(2, 62, 3)] = 0.001
        pgm_function41[(2, 62, 4)] = 0.001
        pgm_function41[(2, 63, 1)] = 0.001
        pgm_function41[(2, 63, 2)] = 0.001
        pgm_function41[(2, 63, 3)] = 0.001
        pgm_function41[(2, 63, 4)] = 0.001
        pgm_function41[(2, 64, 1)] = 0.001
        pgm_function41[(2, 64, 2)] = 0.001
        pgm_function41[(2, 64, 3)] = 0.001
        pgm_function41[(2, 64, 4)] = 0.001
        pgm_function41[(2, 65, 1)] = 0.001
        pgm_function41[(2, 65, 2)] = 0.001
        pgm_function41[(2, 65, 3)] = 0.001
        pgm_function41[(2, 65, 4)] = 0.001
        pgm_function41[(2, 66, 1)] = 0.001
        pgm_function41[(2, 66, 2)] = 0.001
        pgm_function41[(2, 66, 3)] = 0.001
        pgm_function41[(2, 66, 4)] = 0.001
        pgm_function41[(2, 67, 1)] = 0.001
        pgm_function41[(2, 67, 2)] = 0.001
        pgm_function41[(2, 67, 3)] = 0.001
        pgm_function41[(2, 67, 4)] = 0.001
        pgm_function41[(2, 68, 1)] = 0.001
        pgm_function41[(2, 68, 2)] = 0.001
        pgm_function41[(2, 68, 3)] = 0.001
        pgm_function41[(2, 68, 4)] = 0.001
        pgm_function41[(2, 69, 1)] = 0.001
        pgm_function41[(2, 69, 2)] = 0.001
        pgm_function41[(2, 69, 3)] = 0.001
        pgm_function41[(2, 69, 4)] = 0.001
        pgm_function41[(2, 70, 1)] = 0.001
        pgm_function41[(2, 70, 2)] = 0.001
        pgm_function41[(2, 70, 3)] = 0.001
        pgm_function41[(2, 70, 4)] = 0.001
        pgm_function41[(2, 71, 1)] = 0.001
        pgm_function41[(2, 71, 2)] = 0.001
        pgm_function41[(2, 71, 3)] = 0.001
        pgm_function41[(2, 71, 4)] = 0.001
        pgm_function41[(2, 72, 1)] = 0.001
        pgm_function41[(2, 72, 2)] = 0.001
        pgm_function41[(2, 72, 3)] = 0.001
        pgm_function41[(2, 72, 4)] = 0.001
        pgm_function41[(2, 73, 1)] = 0.001
        pgm_function41[(2, 73, 2)] = 0.001
        pgm_function41[(2, 73, 3)] = 0.001
        pgm_function41[(2, 73, 4)] = 0.001
        pgm_function41[(2, 74, 1)] = 0.001
        pgm_function41[(2, 74, 2)] = 0.001
        pgm_function41[(2, 74, 3)] = 0.001
        pgm_function41[(2, 74, 4)] = 0.001
        pgm_function41[(2, 75, 1)] = 0.001
        pgm_function41[(2, 75, 2)] = 0.001
        pgm_function41[(2, 75, 3)] = 0.001
        pgm_function41[(2, 75, 4)] = 0.001
        pgm_function41[(3, 0, 1)] = 0.03
        pgm_function41[(3, 0, 2)] = 0.03
        pgm_function41[(3, 0, 3)] = 0.03
        pgm_function41[(3, 0, 4)] = 0.03
        pgm_function41[(3, 1, 1)] = 0.001
        pgm_function41[(3, 1, 2)] = 0.001
        pgm_function41[(3, 1, 3)] = 0.001
        pgm_function41[(3, 1, 4)] = 0.001
        pgm_function41[(3, 2, 1)] = 0.001
        pgm_function41[(3, 2, 2)] = 0.001
        pgm_function41[(3, 2, 3)] = 0.001
        pgm_function41[(3, 2, 4)] = 0.001
        pgm_function41[(3, 3, 1)] = 0.001
        pgm_function41[(3, 3, 2)] = 0.001
        pgm_function41[(3, 3, 3)] = 0.001
        pgm_function41[(3, 3, 4)] = 0.001
        pgm_function41[(3, 4, 1)] = 0.001
        pgm_function41[(3, 4, 2)] = 0.001
        pgm_function41[(3, 4, 3)] = 0.001
        pgm_function41[(3, 4, 4)] = 0.001
        pgm_function41[(3, 5, 1)] = 0.03
        pgm_function41[(3, 5, 2)] = 0.03
        pgm_function41[(3, 5, 3)] = 0.03
        pgm_function41[(3, 5, 4)] = 0.03
        pgm_function41[(3, 6, 1)] = 0.001
        pgm_function41[(3, 6, 2)] = 0.001
        pgm_function41[(3, 6, 3)] = 0.001
        pgm_function41[(3, 6, 4)] = 0.001
        pgm_function41[(3, 7, 1)] = 0.001
        pgm_function41[(3, 7, 2)] = 0.001
        pgm_function41[(3, 7, 3)] = 0.001
        pgm_function41[(3, 7, 4)] = 0.001
        pgm_function41[(3, 8, 1)] = 0.001
        pgm_function41[(3, 8, 2)] = 0.001
        pgm_function41[(3, 8, 3)] = 0.001
        pgm_function41[(3, 8, 4)] = 0.001
        pgm_function41[(3, 9, 1)] = 0.001
        pgm_function41[(3, 9, 2)] = 0.001
        pgm_function41[(3, 9, 3)] = 0.001
        pgm_function41[(3, 9, 4)] = 0.001
        pgm_function41[(3, 10, 1)] = 0.001
        pgm_function41[(3, 10, 2)] = 0.001
        pgm_function41[(3, 10, 3)] = 0.001
        pgm_function41[(3, 10, 4)] = 0.001
        pgm_function41[(3, 11, 1)] = 0.001
        pgm_function41[(3, 11, 2)] = 0.001
        pgm_function41[(3, 11, 3)] = 0.001
        pgm_function41[(3, 11, 4)] = 0.001
        pgm_function41[(3, 12, 1)] = 0.001
        pgm_function41[(3, 12, 2)] = 0.001
        pgm_function41[(3, 12, 3)] = 0.001
        pgm_function41[(3, 12, 4)] = 0.001
        pgm_function41[(3, 13, 1)] = 0.001
        pgm_function41[(3, 13, 2)] = 0.001
        pgm_function41[(3, 13, 3)] = 0.001
        pgm_function41[(3, 13, 4)] = 0.001
        pgm_function41[(3, 14, 1)] = 0.001
        pgm_function41[(3, 14, 2)] = 0.001
        pgm_function41[(3, 14, 3)] = 0.001
        pgm_function41[(3, 14, 4)] = 0.001
        pgm_function41[(3, 15, 1)] = 0.001
        pgm_function41[(3, 15, 2)] = 0.001
        pgm_function41[(3, 15, 3)] = 0.001
        pgm_function41[(3, 15, 4)] = 0.001
        pgm_function41[(3, 16, 1)] = 0.001
        pgm_function41[(3, 16, 2)] = 0.001
        pgm_function41[(3, 16, 3)] = 0.001
        pgm_function41[(3, 16, 4)] = 0.001
        pgm_function41[(3, 17, 1)] = 0.001
        pgm_function41[(3, 17, 2)] = 0.001
        pgm_function41[(3, 17, 3)] = 0.001
        pgm_function41[(3, 17, 4)] = 0.001
        pgm_function41[(3, 18, 1)] = 0.001
        pgm_function41[(3, 18, 2)] = 0.001
        pgm_function41[(3, 18, 3)] = 0.001
        pgm_function41[(3, 18, 4)] = 0.001
        pgm_function41[(3, 19, 1)] = 0.001
        pgm_function41[(3, 19, 2)] = 0.001
        pgm_function41[(3, 19, 3)] = 0.001
        pgm_function41[(3, 19, 4)] = 0.001
        pgm_function41[(3, 20, 1)] = 0.001
        pgm_function41[(3, 20, 2)] = 0.001
        pgm_function41[(3, 20, 3)] = 0.001
        pgm_function41[(3, 20, 4)] = 0.001
        pgm_function41[(3, 21, 1)] = 0.001
        pgm_function41[(3, 21, 2)] = 0.001
        pgm_function41[(3, 21, 3)] = 0.001
        pgm_function41[(3, 21, 4)] = 0.001
        pgm_function41[(3, 22, 1)] = 0.001
        pgm_function41[(3, 22, 2)] = 0.001
        pgm_function41[(3, 22, 3)] = 0.001
        pgm_function41[(3, 22, 4)] = 0.001
        pgm_function41[(3, 23, 1)] = 0.001
        pgm_function41[(3, 23, 2)] = 0.001
        pgm_function41[(3, 23, 3)] = 0.001
        pgm_function41[(3, 23, 4)] = 0.001
        pgm_function41[(3, 24, 1)] = 0.001
        pgm_function41[(3, 24, 2)] = 0.001
        pgm_function41[(3, 24, 3)] = 0.001
        pgm_function41[(3, 24, 4)] = 0.001
        pgm_function41[(3, 25, 1)] = 0.001
        pgm_function41[(3, 25, 2)] = 0.001
        pgm_function41[(3, 25, 3)] = 0.001
        pgm_function41[(3, 25, 4)] = 0.001
        pgm_function41[(3, 26, 1)] = 0.001
        pgm_function41[(3, 26, 2)] = 0.001
        pgm_function41[(3, 26, 3)] = 0.001
        pgm_function41[(3, 26, 4)] = 0.001
        pgm_function41[(3, 27, 1)] = 0.001
        pgm_function41[(3, 27, 2)] = 0.001
        pgm_function41[(3, 27, 3)] = 0.001
        pgm_function41[(3, 27, 4)] = 0.001
        pgm_function41[(3, 28, 1)] = 0.001
        pgm_function41[(3, 28, 2)] = 0.001
        pgm_function41[(3, 28, 3)] = 0.001
        pgm_function41[(3, 28, 4)] = 0.001
        pgm_function41[(3, 29, 1)] = 0.001
        pgm_function41[(3, 29, 2)] = 0.001
        pgm_function41[(3, 29, 3)] = 0.001
        pgm_function41[(3, 29, 4)] = 0.001
        pgm_function41[(3, 30, 1)] = 0.001
        pgm_function41[(3, 30, 2)] = 0.001
        pgm_function41[(3, 30, 3)] = 0.001
        pgm_function41[(3, 30, 4)] = 0.001
        pgm_function41[(3, 31, 1)] = 0.001
        pgm_function41[(3, 31, 2)] = 0.001
        pgm_function41[(3, 31, 3)] = 0.001
        pgm_function41[(3, 31, 4)] = 0.001
        pgm_function41[(3, 32, 1)] = 0.001
        pgm_function41[(3, 32, 2)] = 0.001
        pgm_function41[(3, 32, 3)] = 0.001
        pgm_function41[(3, 32, 4)] = 0.001
        pgm_function41[(3, 33, 1)] = 0.001
        pgm_function41[(3, 33, 2)] = 0.001
        pgm_function41[(3, 33, 3)] = 0.001
        pgm_function41[(3, 33, 4)] = 0.001
        pgm_function41[(3, 36, 1)] = 0.95
        pgm_function41[(3, 36, 2)] = 0.95
        pgm_function41[(3, 36, 3)] = 0.95
        pgm_function41[(3, 36, 4)] = 0.95
        pgm_function41[(3, 38, 1)] = 0.001
        pgm_function41[(3, 38, 2)] = 0.001
        pgm_function41[(3, 38, 3)] = 0.001
        pgm_function41[(3, 38, 4)] = 0.001
        pgm_function41[(3, 39, 1)] = 0.001
        pgm_function41[(3, 39, 2)] = 0.001
        pgm_function41[(3, 39, 3)] = 0.001
        pgm_function41[(3, 39, 4)] = 0.001
        pgm_function41[(3, 40, 1)] = 0.001
        pgm_function41[(3, 40, 2)] = 0.001
        pgm_function41[(3, 40, 3)] = 0.001
        pgm_function41[(3, 40, 4)] = 0.001
        pgm_function41[(3, 41, 1)] = 0.001
        pgm_function41[(3, 41, 2)] = 0.001
        pgm_function41[(3, 41, 3)] = 0.001
        pgm_function41[(3, 41, 4)] = 0.001
        pgm_function41[(3, 42, 1)] = 0.001
        pgm_function41[(3, 42, 2)] = 0.001
        pgm_function41[(3, 42, 3)] = 0.001
        pgm_function41[(3, 42, 4)] = 0.001
        pgm_function41[(3, 43, 1)] = 0.001
        pgm_function41[(3, 43, 2)] = 0.001
        pgm_function41[(3, 43, 3)] = 0.001
        pgm_function41[(3, 43, 4)] = 0.001
        pgm_function41[(3, 44, 1)] = 0.001
        pgm_function41[(3, 44, 2)] = 0.001
        pgm_function41[(3, 44, 3)] = 0.001
        pgm_function41[(3, 44, 4)] = 0.001
        pgm_function41[(3, 45, 1)] = 0.001
        pgm_function41[(3, 45, 2)] = 0.001
        pgm_function41[(3, 45, 3)] = 0.001
        pgm_function41[(3, 45, 4)] = 0.001
        pgm_function41[(3, 46, 1)] = 0.001
        pgm_function41[(3, 46, 2)] = 0.001
        pgm_function41[(3, 46, 3)] = 0.001
        pgm_function41[(3, 46, 4)] = 0.001
        pgm_function41[(3, 47, 1)] = 0.001
        pgm_function41[(3, 47, 2)] = 0.001
        pgm_function41[(3, 47, 3)] = 0.001
        pgm_function41[(3, 47, 4)] = 0.001
        pgm_function41[(3, 48, 1)] = 0.001
        pgm_function41[(3, 48, 2)] = 0.001
        pgm_function41[(3, 48, 3)] = 0.001
        pgm_function41[(3, 48, 4)] = 0.001
        pgm_function41[(3, 49, 1)] = 0.001
        pgm_function41[(3, 49, 2)] = 0.001
        pgm_function41[(3, 49, 3)] = 0.001
        pgm_function41[(3, 49, 4)] = 0.001
        pgm_function41[(3, 50, 1)] = 0.001
        pgm_function41[(3, 50, 2)] = 0.001
        pgm_function41[(3, 50, 3)] = 0.001
        pgm_function41[(3, 50, 4)] = 0.001
        pgm_function41[(3, 51, 1)] = 0.001
        pgm_function41[(3, 51, 2)] = 0.001
        pgm_function41[(3, 51, 3)] = 0.001
        pgm_function41[(3, 51, 4)] = 0.001
        pgm_function41[(3, 52, 1)] = 0.001
        pgm_function41[(3, 52, 2)] = 0.001
        pgm_function41[(3, 52, 3)] = 0.001
        pgm_function41[(3, 52, 4)] = 0.001
        pgm_function41[(3, 53, 1)] = 0.001
        pgm_function41[(3, 53, 2)] = 0.001
        pgm_function41[(3, 53, 3)] = 0.001
        pgm_function41[(3, 53, 4)] = 0.001
        pgm_function41[(3, 54, 1)] = 0.001
        pgm_function41[(3, 54, 2)] = 0.001
        pgm_function41[(3, 54, 3)] = 0.001
        pgm_function41[(3, 54, 4)] = 0.001
        pgm_function41[(3, 55, 1)] = 0.001
        pgm_function41[(3, 55, 2)] = 0.001
        pgm_function41[(3, 55, 3)] = 0.001
        pgm_function41[(3, 55, 4)] = 0.001
        pgm_function41[(3, 56, 1)] = 0.001
        pgm_function41[(3, 56, 2)] = 0.001
        pgm_function41[(3, 56, 3)] = 0.001
        pgm_function41[(3, 56, 4)] = 0.001
        pgm_function41[(3, 57, 1)] = 0.001
        pgm_function41[(3, 57, 2)] = 0.001
        pgm_function41[(3, 57, 3)] = 0.001
        pgm_function41[(3, 57, 4)] = 0.001
        pgm_function41[(3, 58, 1)] = 0.001
        pgm_function41[(3, 58, 2)] = 0.001
        pgm_function41[(3, 58, 3)] = 0.001
        pgm_function41[(3, 58, 4)] = 0.001
        pgm_function41[(3, 59, 1)] = 0.001
        pgm_function41[(3, 59, 2)] = 0.001
        pgm_function41[(3, 59, 3)] = 0.001
        pgm_function41[(3, 59, 4)] = 0.001
        pgm_function41[(3, 60, 1)] = 0.001
        pgm_function41[(3, 60, 2)] = 0.001
        pgm_function41[(3, 60, 3)] = 0.001
        pgm_function41[(3, 60, 4)] = 0.001
        pgm_function41[(3, 61, 1)] = 0.001
        pgm_function41[(3, 61, 2)] = 0.001
        pgm_function41[(3, 61, 3)] = 0.001
        pgm_function41[(3, 61, 4)] = 0.001
        pgm_function41[(3, 62, 1)] = 0.001
        pgm_function41[(3, 62, 2)] = 0.001
        pgm_function41[(3, 62, 3)] = 0.001
        pgm_function41[(3, 62, 4)] = 0.001
        pgm_function41[(3, 63, 1)] = 0.001
        pgm_function41[(3, 63, 2)] = 0.001
        pgm_function41[(3, 63, 3)] = 0.001
        pgm_function41[(3, 63, 4)] = 0.001
        pgm_function41[(3, 64, 1)] = 0.001
        pgm_function41[(3, 64, 2)] = 0.001
        pgm_function41[(3, 64, 3)] = 0.001
        pgm_function41[(3, 64, 4)] = 0.001
        pgm_function41[(3, 65, 1)] = 0.001
        pgm_function41[(3, 65, 2)] = 0.001
        pgm_function41[(3, 65, 3)] = 0.001
        pgm_function41[(3, 65, 4)] = 0.001
        pgm_function41[(3, 66, 1)] = 0.001
        pgm_function41[(3, 66, 2)] = 0.001
        pgm_function41[(3, 66, 3)] = 0.001
        pgm_function41[(3, 66, 4)] = 0.001
        pgm_function41[(3, 67, 1)] = 0.001
        pgm_function41[(3, 67, 2)] = 0.001
        pgm_function41[(3, 67, 3)] = 0.001
        pgm_function41[(3, 67, 4)] = 0.001
        pgm_function41[(3, 68, 1)] = 0.001
        pgm_function41[(3, 68, 2)] = 0.001
        pgm_function41[(3, 68, 3)] = 0.001
        pgm_function41[(3, 68, 4)] = 0.001
        pgm_function41[(3, 69, 1)] = 0.001
        pgm_function41[(3, 69, 2)] = 0.001
        pgm_function41[(3, 69, 3)] = 0.001
        pgm_function41[(3, 69, 4)] = 0.001
        pgm_function41[(3, 70, 1)] = 0.001
        pgm_function41[(3, 70, 2)] = 0.001
        pgm_function41[(3, 70, 3)] = 0.001
        pgm_function41[(3, 70, 4)] = 0.001
        pgm_function41[(3, 71, 1)] = 0.001
        pgm_function41[(3, 71, 2)] = 0.001
        pgm_function41[(3, 71, 3)] = 0.001
        pgm_function41[(3, 71, 4)] = 0.001
        pgm_function41[(3, 72, 1)] = 0.001
        pgm_function41[(3, 72, 2)] = 0.001
        pgm_function41[(3, 72, 3)] = 0.001
        pgm_function41[(3, 72, 4)] = 0.001
        pgm_function41[(3, 73, 1)] = 0.001
        pgm_function41[(3, 73, 2)] = 0.001
        pgm_function41[(3, 73, 3)] = 0.001
        pgm_function41[(3, 73, 4)] = 0.001
        pgm_function41[(3, 74, 1)] = 0.001
        pgm_function41[(3, 74, 2)] = 0.001
        pgm_function41[(3, 74, 3)] = 0.001
        pgm_function41[(3, 74, 4)] = 0.001
        pgm_function41[(3, 75, 1)] = 0.001
        pgm_function41[(3, 75, 2)] = 0.001
        pgm_function41[(3, 75, 3)] = 0.001
        pgm_function41[(3, 75, 4)] = 0.001
        pgm_function41[(4, 0, 1)] = 0.94
        pgm_function41[(4, 0, 2)] = 0.94
        pgm_function41[(4, 0, 3)] = 0.94
        pgm_function41[(4, 0, 4)] = 0.94
        pgm_function41[(4, 1, 1)] = 0.798
        pgm_function41[(4, 1, 2)] = 0.798
        pgm_function41[(4, 1, 3)] = 0.798
        pgm_function41[(4, 1, 4)] = 0.798
        pgm_function41[(4, 2, 1)] = 0.798
        pgm_function41[(4, 2, 2)] = 0.798
        pgm_function41[(4, 2, 3)] = 0.798
        pgm_function41[(4, 2, 4)] = 0.798
        pgm_function41[(4, 3, 1)] = 0.898
        pgm_function41[(4, 3, 2)] = 0.898
        pgm_function41[(4, 3, 3)] = 0.898
        pgm_function41[(4, 3, 4)] = 0.898
        pgm_function41[(4, 4, 1)] = 0.798
        pgm_function41[(4, 4, 2)] = 0.798
        pgm_function41[(4, 4, 3)] = 0.798
        pgm_function41[(4, 4, 4)] = 0.798
        pgm_function41[(4, 5, 1)] = 0.94
        pgm_function41[(4, 5, 2)] = 0.94
        pgm_function41[(4, 5, 3)] = 0.94
        pgm_function41[(4, 5, 4)] = 0.94
        pgm_function41[(4, 6, 1)] = 0.798
        pgm_function41[(4, 6, 2)] = 0.798
        pgm_function41[(4, 6, 3)] = 0.798
        pgm_function41[(4, 6, 4)] = 0.798
        pgm_function41[(4, 7, 1)] = 0.898
        pgm_function41[(4, 7, 2)] = 0.898
        pgm_function41[(4, 7, 3)] = 0.898
        pgm_function41[(4, 7, 4)] = 0.898
        pgm_function41[(4, 8, 1)] = 0.798
        pgm_function41[(4, 8, 2)] = 0.798
        pgm_function41[(4, 8, 3)] = 0.798
        pgm_function41[(4, 8, 4)] = 0.798
        pgm_function41[(4, 9, 1)] = 0.798
        pgm_function41[(4, 9, 2)] = 0.798
        pgm_function41[(4, 9, 3)] = 0.798
        pgm_function41[(4, 9, 4)] = 0.798
        pgm_function41[(4, 10, 1)] = 0.898
        pgm_function41[(4, 10, 2)] = 0.898
        pgm_function41[(4, 10, 3)] = 0.898
        pgm_function41[(4, 10, 4)] = 0.898
        pgm_function41[(4, 11, 1)] = 0.798
        pgm_function41[(4, 11, 2)] = 0.798
        pgm_function41[(4, 11, 3)] = 0.798
        pgm_function41[(4, 11, 4)] = 0.798
        pgm_function41[(4, 12, 1)] = 0.798
        pgm_function41[(4, 12, 2)] = 0.798
        pgm_function41[(4, 12, 3)] = 0.798
        pgm_function41[(4, 12, 4)] = 0.798
        pgm_function41[(4, 13, 1)] = 0.798
        pgm_function41[(4, 13, 2)] = 0.798
        pgm_function41[(4, 13, 3)] = 0.798
        pgm_function41[(4, 13, 4)] = 0.798
        pgm_function41[(4, 14, 1)] = 0.798
        pgm_function41[(4, 14, 2)] = 0.798
        pgm_function41[(4, 14, 3)] = 0.798
        pgm_function41[(4, 14, 4)] = 0.798
        pgm_function41[(4, 15, 1)] = 0.798
        pgm_function41[(4, 15, 2)] = 0.798
        pgm_function41[(4, 15, 3)] = 0.798
        pgm_function41[(4, 15, 4)] = 0.798
        pgm_function41[(4, 16, 1)] = 0.898
        pgm_function41[(4, 16, 2)] = 0.898
        pgm_function41[(4, 16, 3)] = 0.898
        pgm_function41[(4, 16, 4)] = 0.898
        pgm_function41[(4, 17, 1)] = 0.798
        pgm_function41[(4, 17, 2)] = 0.798
        pgm_function41[(4, 17, 3)] = 0.798
        pgm_function41[(4, 17, 4)] = 0.798
        pgm_function41[(4, 18, 1)] = 0.798
        pgm_function41[(4, 18, 2)] = 0.798
        pgm_function41[(4, 18, 3)] = 0.798
        pgm_function41[(4, 18, 4)] = 0.798
        pgm_function41[(4, 19, 1)] = 0.798
        pgm_function41[(4, 19, 2)] = 0.798
        pgm_function41[(4, 19, 3)] = 0.798
        pgm_function41[(4, 19, 4)] = 0.798
        pgm_function41[(4, 20, 1)] = 0.898
        pgm_function41[(4, 20, 2)] = 0.898
        pgm_function41[(4, 20, 3)] = 0.898
        pgm_function41[(4, 20, 4)] = 0.898
        pgm_function41[(4, 21, 1)] = 0.898
        pgm_function41[(4, 21, 2)] = 0.898
        pgm_function41[(4, 21, 3)] = 0.898
        pgm_function41[(4, 21, 4)] = 0.898
        pgm_function41[(4, 22, 1)] = 0.798
        pgm_function41[(4, 22, 2)] = 0.798
        pgm_function41[(4, 22, 3)] = 0.798
        pgm_function41[(4, 22, 4)] = 0.798
        pgm_function41[(4, 23, 1)] = 0.898
        pgm_function41[(4, 23, 2)] = 0.898
        pgm_function41[(4, 23, 3)] = 0.898
        pgm_function41[(4, 23, 4)] = 0.898
        pgm_function41[(4, 24, 1)] = 0.798
        pgm_function41[(4, 24, 2)] = 0.798
        pgm_function41[(4, 24, 3)] = 0.798
        pgm_function41[(4, 24, 4)] = 0.798
        pgm_function41[(4, 25, 1)] = 0.798
        pgm_function41[(4, 25, 2)] = 0.798
        pgm_function41[(4, 25, 3)] = 0.798
        pgm_function41[(4, 25, 4)] = 0.798
        pgm_function41[(4, 26, 1)] = 0.798
        pgm_function41[(4, 26, 2)] = 0.798
        pgm_function41[(4, 26, 3)] = 0.798
        pgm_function41[(4, 26, 4)] = 0.798
        pgm_function41[(4, 27, 1)] = 0.798
        pgm_function41[(4, 27, 2)] = 0.798
        pgm_function41[(4, 27, 3)] = 0.798
        pgm_function41[(4, 27, 4)] = 0.798
        pgm_function41[(4, 28, 1)] = 0.798
        pgm_function41[(4, 28, 2)] = 0.798
        pgm_function41[(4, 28, 3)] = 0.798
        pgm_function41[(4, 28, 4)] = 0.798
        pgm_function41[(4, 29, 1)] = 0.798
        pgm_function41[(4, 29, 2)] = 0.798
        pgm_function41[(4, 29, 3)] = 0.798
        pgm_function41[(4, 29, 4)] = 0.798
        pgm_function41[(4, 30, 1)] = 0.798
        pgm_function41[(4, 30, 2)] = 0.798
        pgm_function41[(4, 30, 3)] = 0.798
        pgm_function41[(4, 30, 4)] = 0.798
        pgm_function41[(4, 31, 1)] = 0.798
        pgm_function41[(4, 31, 2)] = 0.798
        pgm_function41[(4, 31, 3)] = 0.798
        pgm_function41[(4, 31, 4)] = 0.798
        pgm_function41[(4, 32, 1)] = 0.798
        pgm_function41[(4, 32, 2)] = 0.798
        pgm_function41[(4, 32, 3)] = 0.798
        pgm_function41[(4, 32, 4)] = 0.798
        pgm_function41[(4, 33, 1)] = 0.798
        pgm_function41[(4, 33, 2)] = 0.798
        pgm_function41[(4, 33, 3)] = 0.798
        pgm_function41[(4, 33, 4)] = 0.798
        pgm_function41[(4, 35, 1)] = 1.0
        pgm_function41[(4, 35, 2)] = 1.0
        pgm_function41[(4, 35, 3)] = 1.0
        pgm_function41[(4, 35, 4)] = 1.0
        pgm_function41[(4, 36, 1)] = 0.05
        pgm_function41[(4, 36, 2)] = 0.05
        pgm_function41[(4, 36, 3)] = 0.05
        pgm_function41[(4, 36, 4)] = 0.05
        pgm_function41[(4, 38, 1)] = 0.798
        pgm_function41[(4, 38, 2)] = 0.798
        pgm_function41[(4, 38, 3)] = 0.798
        pgm_function41[(4, 38, 4)] = 0.798
        pgm_function41[(4, 39, 1)] = 0.798
        pgm_function41[(4, 39, 2)] = 0.798
        pgm_function41[(4, 39, 3)] = 0.798
        pgm_function41[(4, 39, 4)] = 0.798
        pgm_function41[(4, 40, 1)] = 0.798
        pgm_function41[(4, 40, 2)] = 0.798
        pgm_function41[(4, 40, 3)] = 0.798
        pgm_function41[(4, 40, 4)] = 0.798
        pgm_function41[(4, 41, 1)] = 0.798
        pgm_function41[(4, 41, 2)] = 0.798
        pgm_function41[(4, 41, 3)] = 0.798
        pgm_function41[(4, 41, 4)] = 0.798
        pgm_function41[(4, 42, 1)] = 0.798
        pgm_function41[(4, 42, 2)] = 0.798
        pgm_function41[(4, 42, 3)] = 0.798
        pgm_function41[(4, 42, 4)] = 0.798
        pgm_function41[(4, 43, 1)] = 0.798
        pgm_function41[(4, 43, 2)] = 0.798
        pgm_function41[(4, 43, 3)] = 0.798
        pgm_function41[(4, 43, 4)] = 0.798
        pgm_function41[(4, 44, 1)] = 0.798
        pgm_function41[(4, 44, 2)] = 0.798
        pgm_function41[(4, 44, 3)] = 0.798
        pgm_function41[(4, 44, 4)] = 0.798
        pgm_function41[(4, 45, 1)] = 0.798
        pgm_function41[(4, 45, 2)] = 0.798
        pgm_function41[(4, 45, 3)] = 0.798
        pgm_function41[(4, 45, 4)] = 0.798
        pgm_function41[(4, 46, 1)] = 0.798
        pgm_function41[(4, 46, 2)] = 0.798
        pgm_function41[(4, 46, 3)] = 0.798
        pgm_function41[(4, 46, 4)] = 0.798
        pgm_function41[(4, 47, 1)] = 0.798
        pgm_function41[(4, 47, 2)] = 0.798
        pgm_function41[(4, 47, 3)] = 0.798
        pgm_function41[(4, 47, 4)] = 0.798
        pgm_function41[(4, 48, 1)] = 0.798
        pgm_function41[(4, 48, 2)] = 0.798
        pgm_function41[(4, 48, 3)] = 0.798
        pgm_function41[(4, 48, 4)] = 0.798
        pgm_function41[(4, 49, 1)] = 0.798
        pgm_function41[(4, 49, 2)] = 0.798
        pgm_function41[(4, 49, 3)] = 0.798
        pgm_function41[(4, 49, 4)] = 0.798
        pgm_function41[(4, 50, 1)] = 0.798
        pgm_function41[(4, 50, 2)] = 0.798
        pgm_function41[(4, 50, 3)] = 0.798
        pgm_function41[(4, 50, 4)] = 0.798
        pgm_function41[(4, 51, 1)] = 0.798
        pgm_function41[(4, 51, 2)] = 0.798
        pgm_function41[(4, 51, 3)] = 0.798
        pgm_function41[(4, 51, 4)] = 0.798
        pgm_function41[(4, 52, 1)] = 0.798
        pgm_function41[(4, 52, 2)] = 0.798
        pgm_function41[(4, 52, 3)] = 0.798
        pgm_function41[(4, 52, 4)] = 0.798
        pgm_function41[(4, 53, 1)] = 0.798
        pgm_function41[(4, 53, 2)] = 0.798
        pgm_function41[(4, 53, 3)] = 0.798
        pgm_function41[(4, 53, 4)] = 0.798
        pgm_function41[(4, 54, 1)] = 0.798
        pgm_function41[(4, 54, 2)] = 0.798
        pgm_function41[(4, 54, 3)] = 0.798
        pgm_function41[(4, 54, 4)] = 0.798
        pgm_function41[(4, 55, 1)] = 0.798
        pgm_function41[(4, 55, 2)] = 0.798
        pgm_function41[(4, 55, 3)] = 0.798
        pgm_function41[(4, 55, 4)] = 0.798
        pgm_function41[(4, 56, 1)] = 0.798
        pgm_function41[(4, 56, 2)] = 0.798
        pgm_function41[(4, 56, 3)] = 0.798
        pgm_function41[(4, 56, 4)] = 0.798
        pgm_function41[(4, 57, 1)] = 0.798
        pgm_function41[(4, 57, 2)] = 0.798
        pgm_function41[(4, 57, 3)] = 0.798
        pgm_function41[(4, 57, 4)] = 0.798
        pgm_function41[(4, 58, 1)] = 0.798
        pgm_function41[(4, 58, 2)] = 0.798
        pgm_function41[(4, 58, 3)] = 0.798
        pgm_function41[(4, 58, 4)] = 0.798
        pgm_function41[(4, 59, 1)] = 0.798
        pgm_function41[(4, 59, 2)] = 0.798
        pgm_function41[(4, 59, 3)] = 0.798
        pgm_function41[(4, 59, 4)] = 0.798
        pgm_function41[(4, 60, 1)] = 0.798
        pgm_function41[(4, 60, 2)] = 0.798
        pgm_function41[(4, 60, 3)] = 0.798
        pgm_function41[(4, 60, 4)] = 0.798
        pgm_function41[(4, 61, 1)] = 0.798
        pgm_function41[(4, 61, 2)] = 0.798
        pgm_function41[(4, 61, 3)] = 0.798
        pgm_function41[(4, 61, 4)] = 0.798
        pgm_function41[(4, 62, 1)] = 0.798
        pgm_function41[(4, 62, 2)] = 0.798
        pgm_function41[(4, 62, 3)] = 0.798
        pgm_function41[(4, 62, 4)] = 0.798
        pgm_function41[(4, 63, 1)] = 0.598
        pgm_function41[(4, 63, 2)] = 0.598
        pgm_function41[(4, 63, 3)] = 0.598
        pgm_function41[(4, 63, 4)] = 0.598
        pgm_function41[(4, 64, 1)] = 0.798
        pgm_function41[(4, 64, 2)] = 0.798
        pgm_function41[(4, 64, 3)] = 0.798
        pgm_function41[(4, 64, 4)] = 0.798
        pgm_function41[(4, 65, 1)] = 0.798
        pgm_function41[(4, 65, 2)] = 0.798
        pgm_function41[(4, 65, 3)] = 0.798
        pgm_function41[(4, 65, 4)] = 0.798
        pgm_function41[(4, 66, 1)] = 0.798
        pgm_function41[(4, 66, 2)] = 0.798
        pgm_function41[(4, 66, 3)] = 0.798
        pgm_function41[(4, 66, 4)] = 0.798
        pgm_function41[(4, 67, 1)] = 0.798
        pgm_function41[(4, 67, 2)] = 0.798
        pgm_function41[(4, 67, 3)] = 0.798
        pgm_function41[(4, 67, 4)] = 0.798
        pgm_function41[(4, 68, 1)] = 0.798
        pgm_function41[(4, 68, 2)] = 0.798
        pgm_function41[(4, 68, 3)] = 0.798
        pgm_function41[(4, 68, 4)] = 0.798
        pgm_function41[(4, 69, 1)] = 0.798
        pgm_function41[(4, 69, 2)] = 0.798
        pgm_function41[(4, 69, 3)] = 0.798
        pgm_function41[(4, 69, 4)] = 0.798
        pgm_function41[(4, 70, 1)] = 0.798
        pgm_function41[(4, 70, 2)] = 0.798
        pgm_function41[(4, 70, 3)] = 0.798
        pgm_function41[(4, 70, 4)] = 0.798
        pgm_function41[(4, 71, 1)] = 0.798
        pgm_function41[(4, 71, 2)] = 0.798
        pgm_function41[(4, 71, 3)] = 0.798
        pgm_function41[(4, 71, 4)] = 0.798
        pgm_function41[(4, 72, 1)] = 0.798
        pgm_function41[(4, 72, 2)] = 0.798
        pgm_function41[(4, 72, 3)] = 0.798
        pgm_function41[(4, 72, 4)] = 0.798
        pgm_function41[(4, 73, 1)] = 0.798
        pgm_function41[(4, 73, 2)] = 0.798
        pgm_function41[(4, 73, 3)] = 0.798
        pgm_function41[(4, 73, 4)] = 0.798
        pgm_function41[(4, 74, 1)] = 0.798
        pgm_function41[(4, 74, 2)] = 0.798
        pgm_function41[(4, 74, 3)] = 0.798
        pgm_function41[(4, 74, 4)] = 0.798
        pgm_function41[(4, 75, 1)] = 0.798
        pgm_function41[(4, 75, 2)] = 0.798
        pgm_function41[(4, 75, 3)] = 0.798
        pgm_function41[(4, 75, 4)] = 0.798

        pgm_function42 = pgm_factor42.set_sparse()
        pgm_function42[(0, 0)] = 0.9
        pgm_function42[(0, 1)] = 0.9
        pgm_function42[(0, 2)] = 0.9
        pgm_function42[(0, 3)] = 0.9
        pgm_function42[(0, 4)] = 0.9
        pgm_function42[(0, 5)] = 0.9
        pgm_function42[(0, 6)] = 0.9
        pgm_function42[(0, 7)] = 0.9
        pgm_function42[(0, 8)] = 0.9
        pgm_function42[(0, 9)] = 0.9
        pgm_function42[(0, 10)] = 0.9
        pgm_function42[(0, 11)] = 0.9
        pgm_function42[(0, 12)] = 0.9
        pgm_function42[(0, 13)] = 0.9
        pgm_function42[(0, 14)] = 0.9
        pgm_function42[(0, 15)] = 0.9
        pgm_function42[(0, 16)] = 0.9
        pgm_function42[(0, 17)] = 0.9
        pgm_function42[(0, 18)] = 0.9
        pgm_function42[(0, 19)] = 0.9
        pgm_function42[(0, 20)] = 0.9
        pgm_function42[(0, 21)] = 0.9
        pgm_function42[(0, 22)] = 0.9
        pgm_function42[(0, 23)] = 0.9
        pgm_function42[(0, 24)] = 0.9
        pgm_function42[(0, 25)] = 0.9
        pgm_function42[(0, 26)] = 0.9
        pgm_function42[(0, 27)] = 0.9
        pgm_function42[(0, 28)] = 0.9
        pgm_function42[(0, 29)] = 0.9
        pgm_function42[(0, 30)] = 0.9
        pgm_function42[(0, 31)] = 0.9
        pgm_function42[(0, 32)] = 0.9
        pgm_function42[(0, 33)] = 0.9
        pgm_function42[(0, 34)] = 0.9
        pgm_function42[(0, 35)] = 0.9
        pgm_function42[(0, 36)] = 0.9
        pgm_function42[(0, 37)] = 0.9
        pgm_function42[(0, 38)] = 0.9
        pgm_function42[(0, 39)] = 0.9
        pgm_function42[(0, 40)] = 0.9
        pgm_function42[(0, 41)] = 0.9
        pgm_function42[(0, 42)] = 0.9
        pgm_function42[(0, 43)] = 0.9
        pgm_function42[(0, 44)] = 0.9
        pgm_function42[(0, 45)] = 0.9
        pgm_function42[(0, 46)] = 0.9
        pgm_function42[(0, 47)] = 0.9
        pgm_function42[(0, 48)] = 0.9
        pgm_function42[(0, 49)] = 0.9
        pgm_function42[(0, 50)] = 0.9
        pgm_function42[(0, 51)] = 0.9
        pgm_function42[(0, 52)] = 0.9
        pgm_function42[(0, 53)] = 0.9
        pgm_function42[(0, 54)] = 0.9
        pgm_function42[(0, 55)] = 0.9
        pgm_function42[(0, 56)] = 0.9
        pgm_function42[(0, 57)] = 0.9
        pgm_function42[(0, 58)] = 0.9
        pgm_function42[(0, 59)] = 0.9
        pgm_function42[(0, 61)] = 0.9
        pgm_function42[(0, 62)] = 0.9
        pgm_function42[(0, 63)] = 0.9
        pgm_function42[(0, 64)] = 0.9
        pgm_function42[(0, 65)] = 0.9
        pgm_function42[(0, 66)] = 0.9
        pgm_function42[(0, 67)] = 0.9
        pgm_function42[(0, 69)] = 0.9
        pgm_function42[(0, 70)] = 0.9
        pgm_function42[(0, 71)] = 0.9
        pgm_function42[(0, 72)] = 0.9
        pgm_function42[(0, 73)] = 0.9
        pgm_function42[(0, 74)] = 0.9
        pgm_function42[(0, 75)] = 0.9
        pgm_function42[(1, 0)] = 0.1
        pgm_function42[(1, 1)] = 0.1
        pgm_function42[(1, 2)] = 0.1
        pgm_function42[(1, 3)] = 0.1
        pgm_function42[(1, 4)] = 0.1
        pgm_function42[(1, 5)] = 0.1
        pgm_function42[(1, 6)] = 0.1
        pgm_function42[(1, 7)] = 0.1
        pgm_function42[(1, 8)] = 0.1
        pgm_function42[(1, 9)] = 0.1
        pgm_function42[(1, 10)] = 0.1
        pgm_function42[(1, 11)] = 0.1
        pgm_function42[(1, 12)] = 0.1
        pgm_function42[(1, 13)] = 0.1
        pgm_function42[(1, 14)] = 0.1
        pgm_function42[(1, 15)] = 0.1
        pgm_function42[(1, 16)] = 0.1
        pgm_function42[(1, 17)] = 0.1
        pgm_function42[(1, 18)] = 0.1
        pgm_function42[(1, 19)] = 0.1
        pgm_function42[(1, 20)] = 0.1
        pgm_function42[(1, 21)] = 0.1
        pgm_function42[(1, 22)] = 0.1
        pgm_function42[(1, 23)] = 0.1
        pgm_function42[(1, 24)] = 0.1
        pgm_function42[(1, 25)] = 0.1
        pgm_function42[(1, 26)] = 0.1
        pgm_function42[(1, 27)] = 0.1
        pgm_function42[(1, 28)] = 0.1
        pgm_function42[(1, 29)] = 0.1
        pgm_function42[(1, 30)] = 0.1
        pgm_function42[(1, 31)] = 0.1
        pgm_function42[(1, 32)] = 0.1
        pgm_function42[(1, 33)] = 0.1
        pgm_function42[(1, 34)] = 0.1
        pgm_function42[(1, 35)] = 0.1
        pgm_function42[(1, 36)] = 0.1
        pgm_function42[(1, 37)] = 0.1
        pgm_function42[(1, 38)] = 0.1
        pgm_function42[(1, 39)] = 0.1
        pgm_function42[(1, 40)] = 0.1
        pgm_function42[(1, 41)] = 0.1
        pgm_function42[(1, 42)] = 0.1
        pgm_function42[(1, 43)] = 0.1
        pgm_function42[(1, 44)] = 0.1
        pgm_function42[(1, 45)] = 0.1
        pgm_function42[(1, 46)] = 0.1
        pgm_function42[(1, 47)] = 0.1
        pgm_function42[(1, 48)] = 0.1
        pgm_function42[(1, 49)] = 0.1
        pgm_function42[(1, 50)] = 0.1
        pgm_function42[(1, 51)] = 0.1
        pgm_function42[(1, 52)] = 0.1
        pgm_function42[(1, 53)] = 0.1
        pgm_function42[(1, 54)] = 0.1
        pgm_function42[(1, 55)] = 0.1
        pgm_function42[(1, 56)] = 0.1
        pgm_function42[(1, 57)] = 0.1
        pgm_function42[(1, 58)] = 0.1
        pgm_function42[(1, 59)] = 0.1
        pgm_function42[(1, 60)] = 0.3
        pgm_function42[(1, 61)] = 0.1
        pgm_function42[(1, 62)] = 0.1
        pgm_function42[(1, 63)] = 0.1
        pgm_function42[(1, 64)] = 0.1
        pgm_function42[(1, 65)] = 0.1
        pgm_function42[(1, 66)] = 0.1
        pgm_function42[(1, 67)] = 0.1
        pgm_function42[(1, 68)] = 0.9
        pgm_function42[(1, 69)] = 0.1
        pgm_function42[(1, 70)] = 0.1
        pgm_function42[(1, 71)] = 0.1
        pgm_function42[(1, 72)] = 0.1
        pgm_function42[(1, 73)] = 0.1
        pgm_function42[(1, 74)] = 0.1
        pgm_function42[(1, 75)] = 0.1
        pgm_function42[(2, 60)] = 0.7
        pgm_function42[(2, 68)] = 0.1

        pgm_function43 = pgm_factor43.set_sparse()
        pgm_function43[(0, 0)] = 0.79
        pgm_function43[(0, 1)] = 0.01
        pgm_function43[(0, 2)] = 0.01
        pgm_function43[(0, 3)] = 0.25
        pgm_function43[(0, 4)] = 0.79
        pgm_function43[(0, 5)] = 0.6
        pgm_function43[(0, 6)] = 0.79
        pgm_function43[(0, 7)] = 0.25
        pgm_function43[(0, 8)] = 0.25
        pgm_function43[(0, 9)] = 0.79
        pgm_function43[(0, 10)] = 0.01
        pgm_function43[(0, 11)] = 0.79
        pgm_function43[(0, 12)] = 0.79
        pgm_function43[(0, 13)] = 0.79
        pgm_function43[(0, 14)] = 0.25
        pgm_function43[(0, 15)] = 0.25
        pgm_function43[(0, 16)] = 0.6
        pgm_function43[(0, 17)] = 0.79
        pgm_function43[(0, 18)] = 0.79
        pgm_function43[(0, 19)] = 0.79
        pgm_function43[(0, 20)] = 0.6
        pgm_function43[(0, 21)] = 0.6
        pgm_function43[(0, 22)] = 0.79
        pgm_function43[(0, 23)] = 0.01
        pgm_function43[(0, 24)] = 0.79
        pgm_function43[(0, 25)] = 0.2
        pgm_function43[(0, 26)] = 0.2
        pgm_function43[(0, 27)] = 0.2
        pgm_function43[(0, 28)] = 0.2
        pgm_function43[(0, 29)] = 0.2
        pgm_function43[(0, 30)] = 0.2
        pgm_function43[(0, 31)] = 0.2
        pgm_function43[(0, 32)] = 0.2
        pgm_function43[(0, 33)] = 0.2
        pgm_function43[(0, 34)] = 0.5
        pgm_function43[(0, 35)] = 0.3
        pgm_function43[(0, 36)] = 0.1
        pgm_function43[(0, 37)] = 0.05
        pgm_function43[(0, 38)] = 0.1
        pgm_function43[(0, 39)] = 0.84
        pgm_function43[(0, 40)] = 0.95
        pgm_function43[(0, 41)] = 0.95
        pgm_function43[(0, 42)] = 0.1
        pgm_function43[(0, 43)] = 0.1
        pgm_function43[(0, 44)] = 0.8
        pgm_function43[(0, 45)] = 0.1
        pgm_function43[(0, 46)] = 0.01
        pgm_function43[(0, 47)] = 0.1
        pgm_function43[(0, 50)] = 0.95
        pgm_function43[(0, 51)] = 0.949
        pgm_function43[(0, 52)] = 0.3
        pgm_function43[(0, 53)] = 0.01
        pgm_function43[(0, 54)] = 0.25
        pgm_function43[(0, 55)] = 0.05
        pgm_function43[(0, 56)] = 0.79
        pgm_function43[(0, 57)] = 0.79
        pgm_function43[(0, 58)] = 0.2
        pgm_function43[(0, 59)] = 0.79
        pgm_function43[(0, 60)] = 0.55
        pgm_function43[(0, 61)] = 0.79
        pgm_function43[(0, 62)] = 0.1
        pgm_function43[(0, 63)] = 0.65
        pgm_function43[(0, 64)] = 0.79
        pgm_function43[(0, 65)] = 0.79
        pgm_function43[(0, 66)] = 0.01
        pgm_function43[(0, 67)] = 0.79
        pgm_function43[(0, 68)] = 0.6
        pgm_function43[(0, 69)] = 0.25
        pgm_function43[(0, 70)] = 0.79
        pgm_function43[(0, 71)] = 0.79
        pgm_function43[(0, 72)] = 0.79
        pgm_function43[(0, 73)] = 0.79
        pgm_function43[(0, 74)] = 0.949
        pgm_function43[(0, 75)] = 0.95
        pgm_function43[(1, 0)] = 0.2
        pgm_function43[(1, 1)] = 0.79
        pgm_function43[(1, 2)] = 0.94
        pgm_function43[(1, 3)] = 0.7
        pgm_function43[(1, 4)] = 0.2
        pgm_function43[(1, 5)] = 0.39
        pgm_function43[(1, 6)] = 0.2
        pgm_function43[(1, 7)] = 0.65
        pgm_function43[(1, 8)] = 0.65
        pgm_function43[(1, 9)] = 0.2
        pgm_function43[(1, 10)] = 0.693
        pgm_function43[(1, 11)] = 0.2
        pgm_function43[(1, 12)] = 0.2
        pgm_function43[(1, 13)] = 0.2
        pgm_function43[(1, 14)] = 0.65
        pgm_function43[(1, 15)] = 0.65
        pgm_function43[(1, 16)] = 0.39
        pgm_function43[(1, 17)] = 0.2
        pgm_function43[(1, 18)] = 0.2
        pgm_function43[(1, 19)] = 0.2
        pgm_function43[(1, 20)] = 0.39
        pgm_function43[(1, 21)] = 0.39
        pgm_function43[(1, 22)] = 0.2
        pgm_function43[(1, 23)] = 0.693
        pgm_function43[(1, 24)] = 0.2
        pgm_function43[(1, 25)] = 0.76
        pgm_function43[(1, 26)] = 0.76
        pgm_function43[(1, 27)] = 0.76
        pgm_function43[(1, 28)] = 0.76
        pgm_function43[(1, 29)] = 0.76
        pgm_function43[(1, 30)] = 0.76
        pgm_function43[(1, 31)] = 0.76
        pgm_function43[(1, 32)] = 0.76
        pgm_function43[(1, 33)] = 0.76
        pgm_function43[(1, 34)] = 0.49
        pgm_function43[(1, 35)] = 0.69
        pgm_function43[(1, 36)] = 0.85
        pgm_function43[(1, 37)] = 0.1
        pgm_function43[(1, 38)] = 0.83
        pgm_function43[(1, 39)] = 0.15
        pgm_function43[(1, 40)] = 0.05
        pgm_function43[(1, 41)] = 0.05
        pgm_function43[(1, 42)] = 0.65
        pgm_function43[(1, 43)] = 0.7
        pgm_function43[(1, 44)] = 0.19
        pgm_function43[(1, 45)] = 0.65
        pgm_function43[(1, 46)] = 0.84
        pgm_function43[(1, 47)] = 0.805
        pgm_function43[(1, 50)] = 0.0475
        pgm_function43[(1, 51)] = 0.05
        pgm_function43[(1, 52)] = 0.665
        pgm_function43[(1, 53)] = 0.1
        pgm_function43[(1, 54)] = 0.1
        pgm_function43[(1, 55)] = 0.85
        pgm_function43[(1, 56)] = 0.2
        pgm_function43[(1, 57)] = 0.2
        pgm_function43[(1, 58)] = 0.792
        pgm_function43[(1, 59)] = 0.2
        pgm_function43[(1, 60)] = 0.4
        pgm_function43[(1, 61)] = 0.2
        pgm_function43[(1, 62)] = 0.8
        pgm_function43[(1, 63)] = 0.24999
        pgm_function43[(1, 64)] = 0.2
        pgm_function43[(1, 65)] = 0.2
        pgm_function43[(1, 66)] = 0.693
        pgm_function43[(1, 67)] = 0.2
        pgm_function43[(1, 68)] = 0.36
        pgm_function43[(1, 69)] = 0.7
        pgm_function43[(1, 70)] = 0.2
        pgm_function43[(1, 71)] = 0.2
        pgm_function43[(1, 72)] = 0.2
        pgm_function43[(1, 73)] = 0.2
        pgm_function43[(1, 74)] = 0.05
        pgm_function43[(1, 75)] = 0.05
        pgm_function43[(2, 0)] = 0.01
        pgm_function43[(2, 1)] = 0.2
        pgm_function43[(2, 2)] = 0.05
        pgm_function43[(2, 3)] = 0.05
        pgm_function43[(2, 4)] = 0.01
        pgm_function43[(2, 5)] = 0.01
        pgm_function43[(2, 6)] = 0.01
        pgm_function43[(2, 7)] = 0.1
        pgm_function43[(2, 8)] = 0.1
        pgm_function43[(2, 9)] = 0.01
        pgm_function43[(2, 10)] = 0.297
        pgm_function43[(2, 11)] = 0.01
        pgm_function43[(2, 12)] = 0.01
        pgm_function43[(2, 13)] = 0.01
        pgm_function43[(2, 14)] = 0.1
        pgm_function43[(2, 15)] = 0.1
        pgm_function43[(2, 16)] = 0.01
        pgm_function43[(2, 17)] = 0.01
        pgm_function43[(2, 18)] = 0.01
        pgm_function43[(2, 19)] = 0.01
        pgm_function43[(2, 20)] = 0.01
        pgm_function43[(2, 21)] = 0.01
        pgm_function43[(2, 22)] = 0.01
        pgm_function43[(2, 23)] = 0.297
        pgm_function43[(2, 24)] = 0.01
        pgm_function43[(2, 25)] = 0.04
        pgm_function43[(2, 26)] = 0.04
        pgm_function43[(2, 27)] = 0.04
        pgm_function43[(2, 28)] = 0.04
        pgm_function43[(2, 29)] = 0.04
        pgm_function43[(2, 30)] = 0.04
        pgm_function43[(2, 31)] = 0.04
        pgm_function43[(2, 32)] = 0.04
        pgm_function43[(2, 33)] = 0.04
        pgm_function43[(2, 34)] = 0.01
        pgm_function43[(2, 35)] = 0.01
        pgm_function43[(2, 36)] = 0.05
        pgm_function43[(2, 37)] = 0.15
        pgm_function43[(2, 38)] = 0.07
        pgm_function43[(2, 39)] = 0.01
        pgm_function43[(2, 42)] = 0.25
        pgm_function43[(2, 43)] = 0.2
        pgm_function43[(2, 44)] = 0.01
        pgm_function43[(2, 45)] = 0.25
        pgm_function43[(2, 46)] = 0.15
        pgm_function43[(2, 47)] = 0.09
        pgm_function43[(2, 48)] = 0.01
        pgm_function43[(2, 49)] = 0.01
        pgm_function43[(2, 50)] = 0.0025
        pgm_function43[(2, 51)] = 0.001
        pgm_function43[(2, 52)] = 0.035
        pgm_function43[(2, 53)] = 0.855
        pgm_function43[(2, 54)] = 0.45
        pgm_function43[(2, 55)] = 0.1
        pgm_function43[(2, 56)] = 0.01
        pgm_function43[(2, 57)] = 0.01
        pgm_function43[(2, 58)] = 0.008
        pgm_function43[(2, 59)] = 0.01
        pgm_function43[(2, 60)] = 0.05
        pgm_function43[(2, 61)] = 0.01
        pgm_function43[(2, 62)] = 0.1
        pgm_function43[(2, 63)] = 0.1
        pgm_function43[(2, 64)] = 0.01
        pgm_function43[(2, 65)] = 0.01
        pgm_function43[(2, 66)] = 0.297
        pgm_function43[(2, 67)] = 0.01
        pgm_function43[(2, 68)] = 0.04
        pgm_function43[(2, 69)] = 0.05
        pgm_function43[(2, 70)] = 0.01
        pgm_function43[(2, 71)] = 0.01
        pgm_function43[(2, 72)] = 0.01
        pgm_function43[(2, 73)] = 0.01
        pgm_function43[(2, 74)] = 0.001
        pgm_function43[(3, 37)] = 0.4
        pgm_function43[(3, 47)] = 0.005
        pgm_function43[(3, 48)] = 0.19
        pgm_function43[(3, 49)] = 0.05
        pgm_function43[(3, 53)] = 0.03
        pgm_function43[(3, 54)] = 0.1
        pgm_function43[(3, 63)] = 1e-05
        pgm_function43[(4, 37)] = 0.3
        pgm_function43[(4, 48)] = 0.8
        pgm_function43[(4, 49)] = 0.94
        pgm_function43[(4, 53)] = 0.005
        pgm_function43[(4, 54)] = 0.1

        pgm_function44 = pgm_factor44.set_sparse()
        pgm_function44[(0, 0)] = 1.0
        pgm_function44[(0, 1)] = 1.0
        pgm_function44[(0, 2)] = 1.0
        pgm_function44[(0, 3)] = 1.0
        pgm_function44[(0, 4)] = 1.0
        pgm_function44[(0, 5)] = 1.0
        pgm_function44[(0, 6)] = 1.0
        pgm_function44[(0, 7)] = 1.0
        pgm_function44[(0, 8)] = 1.0
        pgm_function44[(0, 9)] = 1.0
        pgm_function44[(0, 10)] = 1.0
        pgm_function44[(0, 11)] = 1.0
        pgm_function44[(0, 12)] = 1.0
        pgm_function44[(0, 13)] = 1.0
        pgm_function44[(0, 14)] = 1.0
        pgm_function44[(0, 15)] = 1.0
        pgm_function44[(0, 16)] = 1.0
        pgm_function44[(0, 17)] = 1.0
        pgm_function44[(0, 18)] = 1.0
        pgm_function44[(0, 19)] = 1.0
        pgm_function44[(0, 20)] = 1.0
        pgm_function44[(0, 21)] = 1.0
        pgm_function44[(0, 22)] = 1.0
        pgm_function44[(0, 23)] = 1.0
        pgm_function44[(0, 24)] = 1.0
        pgm_function44[(0, 25)] = 1.0
        pgm_function44[(0, 26)] = 1.0
        pgm_function44[(0, 27)] = 1.0
        pgm_function44[(0, 28)] = 1.0
        pgm_function44[(0, 29)] = 1.0
        pgm_function44[(0, 30)] = 1.0
        pgm_function44[(0, 31)] = 1.0
        pgm_function44[(0, 32)] = 1.0
        pgm_function44[(0, 33)] = 1.0
        pgm_function44[(0, 34)] = 1.0
        pgm_function44[(0, 35)] = 1.0
        pgm_function44[(0, 36)] = 1.0
        pgm_function44[(0, 37)] = 1.0
        pgm_function44[(0, 38)] = 1.0
        pgm_function44[(0, 39)] = 1.0
        pgm_function44[(0, 40)] = 1.0
        pgm_function44[(0, 41)] = 1.0
        pgm_function44[(0, 42)] = 1.0
        pgm_function44[(0, 43)] = 1.0
        pgm_function44[(0, 44)] = 1.0
        pgm_function44[(0, 45)] = 1.0
        pgm_function44[(0, 46)] = 1.0
        pgm_function44[(0, 47)] = 1.0
        pgm_function44[(0, 48)] = 1.0
        pgm_function44[(0, 49)] = 1.0
        pgm_function44[(0, 50)] = 1.0
        pgm_function44[(0, 51)] = 1.0
        pgm_function44[(0, 52)] = 1.0
        pgm_function44[(0, 53)] = 1.0
        pgm_function44[(0, 54)] = 1.0
        pgm_function44[(0, 55)] = 1.0
        pgm_function44[(0, 56)] = 1.0
        pgm_function44[(0, 58)] = 1.0
        pgm_function44[(0, 59)] = 1.0
        pgm_function44[(0, 60)] = 1.0
        pgm_function44[(0, 61)] = 1.0
        pgm_function44[(0, 62)] = 1.0
        pgm_function44[(0, 63)] = 1.0
        pgm_function44[(0, 64)] = 1.0
        pgm_function44[(0, 65)] = 1.0
        pgm_function44[(0, 66)] = 1.0
        pgm_function44[(0, 67)] = 1.0
        pgm_function44[(0, 68)] = 1.0
        pgm_function44[(0, 69)] = 1.0
        pgm_function44[(0, 70)] = 1.0
        pgm_function44[(0, 71)] = 1.0
        pgm_function44[(0, 72)] = 1.0
        pgm_function44[(0, 73)] = 1.0
        pgm_function44[(0, 74)] = 1.0
        pgm_function44[(0, 75)] = 1.0
        pgm_function44[(1, 57)] = 1.0

        pgm_function45 = pgm_factor45.set_sparse()
        pgm_function45[(0, 0)] = 0.899
        pgm_function45[(0, 3)] = 0.899
        pgm_function45[(0, 4)] = 0.899
        pgm_function45[(0, 5)] = 0.899
        pgm_function45[(0, 6)] = 0.899
        pgm_function45[(0, 7)] = 0.899
        pgm_function45[(0, 8)] = 0.899
        pgm_function45[(0, 9)] = 0.899
        pgm_function45[(0, 10)] = 0.05
        pgm_function45[(0, 11)] = 0.899
        pgm_function45[(0, 12)] = 0.899
        pgm_function45[(0, 13)] = 0.899
        pgm_function45[(0, 14)] = 0.001
        pgm_function45[(0, 15)] = 0.001
        pgm_function45[(0, 16)] = 0.899
        pgm_function45[(0, 17)] = 0.899
        pgm_function45[(0, 18)] = 0.899
        pgm_function45[(0, 19)] = 0.899
        pgm_function45[(0, 20)] = 0.899
        pgm_function45[(0, 21)] = 0.899
        pgm_function45[(0, 22)] = 0.899
        pgm_function45[(0, 23)] = 0.05
        pgm_function45[(0, 24)] = 0.899
        pgm_function45[(0, 25)] = 0.02
        pgm_function45[(0, 26)] = 0.02
        pgm_function45[(0, 27)] = 0.02
        pgm_function45[(0, 28)] = 0.02
        pgm_function45[(0, 29)] = 0.02
        pgm_function45[(0, 30)] = 0.02
        pgm_function45[(0, 31)] = 0.02
        pgm_function45[(0, 34)] = 0.2
        pgm_function45[(0, 35)] = 0.2
        pgm_function45[(0, 36)] = 0.1
        pgm_function45[(0, 37)] = 0.1
        pgm_function45[(0, 38)] = 0.3
        pgm_function45[(0, 39)] = 0.3
        pgm_function45[(0, 40)] = 0.1
        pgm_function45[(0, 53)] = 0.005
        pgm_function45[(0, 55)] = 0.799
        pgm_function45[(0, 58)] = 0.01
        pgm_function45[(0, 59)] = 0.01
        pgm_function45[(0, 60)] = 0.2
        pgm_function45[(0, 61)] = 0.899
        pgm_function45[(0, 66)] = 0.05
        pgm_function45[(0, 67)] = 0.899
        pgm_function45[(0, 68)] = 0.899
        pgm_function45[(0, 69)] = 0.899
        pgm_function45[(0, 70)] = 0.899
        pgm_function45[(0, 71)] = 0.899
        pgm_function45[(0, 72)] = 0.899
        pgm_function45[(0, 73)] = 0.899
        pgm_function45[(0, 75)] = 0.05
        pgm_function45[(1, 0)] = 0.1
        pgm_function45[(1, 1)] = 0.01
        pgm_function45[(1, 2)] = 0.05
        pgm_function45[(1, 3)] = 0.1
        pgm_function45[(1, 4)] = 0.1
        pgm_function45[(1, 5)] = 0.1
        pgm_function45[(1, 6)] = 0.1
        pgm_function45[(1, 7)] = 0.1
        pgm_function45[(1, 8)] = 0.1
        pgm_function45[(1, 9)] = 0.1
        pgm_function45[(1, 10)] = 0.65
        pgm_function45[(1, 11)] = 0.1
        pgm_function45[(1, 12)] = 0.1
        pgm_function45[(1, 13)] = 0.1
        pgm_function45[(1, 14)] = 0.7
        pgm_function45[(1, 15)] = 0.7
        pgm_function45[(1, 16)] = 0.1
        pgm_function45[(1, 17)] = 0.1
        pgm_function45[(1, 18)] = 0.1
        pgm_function45[(1, 19)] = 0.1
        pgm_function45[(1, 20)] = 0.1
        pgm_function45[(1, 21)] = 0.1
        pgm_function45[(1, 22)] = 0.1
        pgm_function45[(1, 23)] = 0.65
        pgm_function45[(1, 24)] = 0.1
        pgm_function45[(1, 25)] = 0.5
        pgm_function45[(1, 26)] = 0.5
        pgm_function45[(1, 27)] = 0.5
        pgm_function45[(1, 28)] = 0.5
        pgm_function45[(1, 29)] = 0.5
        pgm_function45[(1, 30)] = 0.5
        pgm_function45[(1, 31)] = 0.5
        pgm_function45[(1, 32)] = 0.4
        pgm_function45[(1, 33)] = 0.4
        pgm_function45[(1, 34)] = 0.6999
        pgm_function45[(1, 35)] = 0.6999
        pgm_function45[(1, 36)] = 0.35
        pgm_function45[(1, 37)] = 0.35
        pgm_function45[(1, 38)] = 0.6
        pgm_function45[(1, 39)] = 0.6
        pgm_function45[(1, 40)] = 0.7
        pgm_function45[(1, 41)] = 0.05
        pgm_function45[(1, 42)] = 0.005
        pgm_function45[(1, 43)] = 0.001
        pgm_function45[(1, 44)] = 0.001
        pgm_function45[(1, 45)] = 0.005
        pgm_function45[(1, 46)] = 0.005
        pgm_function45[(1, 47)] = 0.001
        pgm_function45[(1, 48)] = 0.001
        pgm_function45[(1, 49)] = 0.001
        pgm_function45[(1, 50)] = 0.001
        pgm_function45[(1, 51)] = 0.001
        pgm_function45[(1, 52)] = 0.001
        pgm_function45[(1, 53)] = 0.295
        pgm_function45[(1, 54)] = 0.05
        pgm_function45[(1, 55)] = 0.2
        pgm_function45[(1, 56)] = 0.3
        pgm_function45[(1, 57)] = 0.3
        pgm_function45[(1, 58)] = 0.4
        pgm_function45[(1, 59)] = 0.4
        pgm_function45[(1, 60)] = 0.75
        pgm_function45[(1, 61)] = 0.1
        pgm_function45[(1, 62)] = 0.001
        pgm_function45[(1, 63)] = 0.01
        pgm_function45[(1, 64)] = 0.55
        pgm_function45[(1, 65)] = 0.3
        pgm_function45[(1, 66)] = 0.65
        pgm_function45[(1, 67)] = 0.1
        pgm_function45[(1, 68)] = 0.1
        pgm_function45[(1, 69)] = 0.1
        pgm_function45[(1, 70)] = 0.1
        pgm_function45[(1, 71)] = 0.1
        pgm_function45[(1, 72)] = 0.1
        pgm_function45[(1, 73)] = 0.1
        pgm_function45[(1, 74)] = 0.001
        pgm_function45[(1, 75)] = 0.595
        pgm_function45[(2, 0)] = 0.001
        pgm_function45[(2, 1)] = 0.89
        pgm_function45[(2, 2)] = 0.93
        pgm_function45[(2, 3)] = 0.001
        pgm_function45[(2, 4)] = 0.001
        pgm_function45[(2, 5)] = 0.001
        pgm_function45[(2, 6)] = 0.001
        pgm_function45[(2, 7)] = 0.001
        pgm_function45[(2, 8)] = 0.001
        pgm_function45[(2, 9)] = 0.001
        pgm_function45[(2, 10)] = 0.29
        pgm_function45[(2, 11)] = 0.001
        pgm_function45[(2, 12)] = 0.001
        pgm_function45[(2, 13)] = 0.001
        pgm_function45[(2, 14)] = 0.2989
        pgm_function45[(2, 15)] = 0.2989
        pgm_function45[(2, 16)] = 0.001
        pgm_function45[(2, 17)] = 0.001
        pgm_function45[(2, 18)] = 0.001
        pgm_function45[(2, 19)] = 0.001
        pgm_function45[(2, 20)] = 0.001
        pgm_function45[(2, 21)] = 0.001
        pgm_function45[(2, 22)] = 0.001
        pgm_function45[(2, 23)] = 0.29
        pgm_function45[(2, 24)] = 0.001
        pgm_function45[(2, 25)] = 0.47
        pgm_function45[(2, 26)] = 0.47
        pgm_function45[(2, 27)] = 0.47
        pgm_function45[(2, 28)] = 0.47
        pgm_function45[(2, 29)] = 0.47
        pgm_function45[(2, 30)] = 0.47
        pgm_function45[(2, 31)] = 0.47
        pgm_function45[(2, 32)] = 0.5
        pgm_function45[(2, 33)] = 0.5
        pgm_function45[(2, 34)] = 0.1
        pgm_function45[(2, 35)] = 0.1
        pgm_function45[(2, 36)] = 0.43
        pgm_function45[(2, 37)] = 0.43
        pgm_function45[(2, 38)] = 0.0999
        pgm_function45[(2, 39)] = 0.0999
        pgm_function45[(2, 40)] = 0.199
        pgm_function45[(2, 41)] = 0.85
        pgm_function45[(2, 42)] = 0.745
        pgm_function45[(2, 43)] = 0.2
        pgm_function45[(2, 44)] = 0.2
        pgm_function45[(2, 45)] = 0.45
        pgm_function45[(2, 46)] = 0.795
        pgm_function45[(2, 47)] = 0.2
        pgm_function45[(2, 48)] = 0.02
        pgm_function45[(2, 49)] = 0.02
        pgm_function45[(2, 50)] = 0.2
        pgm_function45[(2, 51)] = 0.2
        pgm_function45[(2, 52)] = 0.2
        pgm_function45[(2, 53)] = 0.65
        pgm_function45[(2, 54)] = 0.4
        pgm_function45[(2, 55)] = 0.001
        pgm_function45[(2, 56)] = 0.6
        pgm_function45[(2, 57)] = 0.6
        pgm_function45[(2, 58)] = 0.58
        pgm_function45[(2, 59)] = 0.58
        pgm_function45[(2, 60)] = 0.04
        pgm_function45[(2, 61)] = 0.001
        pgm_function45[(2, 62)] = 0.2
        pgm_function45[(2, 63)] = 0.94
        pgm_function45[(2, 64)] = 0.4
        pgm_function45[(2, 65)] = 0.6
        pgm_function45[(2, 66)] = 0.29
        pgm_function45[(2, 67)] = 0.001
        pgm_function45[(2, 68)] = 0.001
        pgm_function45[(2, 69)] = 0.001
        pgm_function45[(2, 70)] = 0.001
        pgm_function45[(2, 71)] = 0.001
        pgm_function45[(2, 72)] = 0.001
        pgm_function45[(2, 73)] = 0.001
        pgm_function45[(2, 74)] = 0.2
        pgm_function45[(2, 75)] = 0.35
        pgm_function45[(3, 1)] = 0.1
        pgm_function45[(3, 2)] = 0.02
        pgm_function45[(3, 10)] = 0.01
        pgm_function45[(3, 14)] = 0.0001
        pgm_function45[(3, 15)] = 0.0001
        pgm_function45[(3, 23)] = 0.01
        pgm_function45[(3, 25)] = 0.01
        pgm_function45[(3, 26)] = 0.01
        pgm_function45[(3, 27)] = 0.01
        pgm_function45[(3, 28)] = 0.01
        pgm_function45[(3, 29)] = 0.01
        pgm_function45[(3, 30)] = 0.01
        pgm_function45[(3, 31)] = 0.01
        pgm_function45[(3, 32)] = 0.1
        pgm_function45[(3, 33)] = 0.1
        pgm_function45[(3, 34)] = 0.0001
        pgm_function45[(3, 35)] = 0.0001
        pgm_function45[(3, 36)] = 0.12
        pgm_function45[(3, 37)] = 0.12
        pgm_function45[(3, 38)] = 0.0001
        pgm_function45[(3, 39)] = 0.0001
        pgm_function45[(3, 40)] = 0.001
        pgm_function45[(3, 41)] = 0.1
        pgm_function45[(3, 42)] = 0.25
        pgm_function45[(3, 43)] = 0.799
        pgm_function45[(3, 44)] = 0.799
        pgm_function45[(3, 45)] = 0.545
        pgm_function45[(3, 46)] = 0.2
        pgm_function45[(3, 47)] = 0.799
        pgm_function45[(3, 48)] = 0.979
        pgm_function45[(3, 49)] = 0.979
        pgm_function45[(3, 50)] = 0.799
        pgm_function45[(3, 51)] = 0.799
        pgm_function45[(3, 52)] = 0.799
        pgm_function45[(3, 53)] = 0.05
        pgm_function45[(3, 54)] = 0.55
        pgm_function45[(3, 56)] = 0.1
        pgm_function45[(3, 57)] = 0.1
        pgm_function45[(3, 58)] = 0.01
        pgm_function45[(3, 59)] = 0.01
        pgm_function45[(3, 60)] = 0.01
        pgm_function45[(3, 62)] = 0.799
        pgm_function45[(3, 63)] = 0.05
        pgm_function45[(3, 64)] = 0.05
        pgm_function45[(3, 65)] = 0.1
        pgm_function45[(3, 66)] = 0.01
        pgm_function45[(3, 74)] = 0.799
        pgm_function45[(3, 75)] = 0.005

        pgm_function46 = pgm_factor46.set_sparse()
        pgm_function46[(0, 0, 0)] = 1.0
        pgm_function46[(0, 1, 0)] = 1.0
        pgm_function46[(0, 2, 0)] = 1.0
        pgm_function46[(0, 3, 0)] = 1.0
        pgm_function46[(0, 4, 0)] = 1.0
        pgm_function46[(0, 5, 0)] = 1.0
        pgm_function46[(0, 6, 0)] = 1.0
        pgm_function46[(0, 7, 0)] = 1.0
        pgm_function46[(0, 8, 0)] = 1.0
        pgm_function46[(0, 9, 0)] = 1.0
        pgm_function46[(0, 10, 0)] = 1.0
        pgm_function46[(0, 11, 0)] = 1.0
        pgm_function46[(0, 12, 0)] = 1.0
        pgm_function46[(0, 13, 0)] = 1.0
        pgm_function46[(0, 14, 0)] = 1.0
        pgm_function46[(0, 15, 0)] = 1.0
        pgm_function46[(0, 16, 0)] = 1.0
        pgm_function46[(0, 17, 0)] = 1.0
        pgm_function46[(0, 18, 0)] = 1.0
        pgm_function46[(0, 19, 0)] = 1.0
        pgm_function46[(0, 20, 0)] = 1.0
        pgm_function46[(0, 21, 0)] = 1.0
        pgm_function46[(0, 22, 0)] = 1.0
        pgm_function46[(0, 23, 0)] = 1.0
        pgm_function46[(0, 24, 0)] = 1.0
        pgm_function46[(0, 25, 0)] = 1.0
        pgm_function46[(0, 26, 0)] = 1.0
        pgm_function46[(0, 27, 0)] = 1.0
        pgm_function46[(0, 28, 0)] = 1.0
        pgm_function46[(0, 29, 0)] = 1.0
        pgm_function46[(0, 30, 0)] = 1.0
        pgm_function46[(0, 31, 0)] = 1.0
        pgm_function46[(0, 32, 0)] = 1.0
        pgm_function46[(0, 33, 0)] = 1.0
        pgm_function46[(0, 34, 0)] = 1.0
        pgm_function46[(0, 35, 0)] = 1.0
        pgm_function46[(0, 36, 0)] = 1.0
        pgm_function46[(0, 37, 0)] = 1.0
        pgm_function46[(0, 38, 0)] = 1.0
        pgm_function46[(0, 39, 0)] = 1.0
        pgm_function46[(0, 40, 0)] = 1.0
        pgm_function46[(0, 41, 0)] = 1.0
        pgm_function46[(0, 42, 0)] = 1.0
        pgm_function46[(0, 43, 0)] = 1.0
        pgm_function46[(0, 44, 0)] = 1.0
        pgm_function46[(0, 45, 0)] = 1.0
        pgm_function46[(0, 46, 0)] = 1.0
        pgm_function46[(0, 47, 0)] = 1.0
        pgm_function46[(0, 48, 0)] = 1.0
        pgm_function46[(0, 49, 0)] = 1.0
        pgm_function46[(0, 50, 0)] = 1.0
        pgm_function46[(0, 51, 0)] = 1.0
        pgm_function46[(0, 52, 0)] = 1.0
        pgm_function46[(0, 53, 0)] = 1.0
        pgm_function46[(0, 54, 0)] = 1.0
        pgm_function46[(0, 55, 0)] = 1.0
        pgm_function46[(0, 56, 0)] = 1.0
        pgm_function46[(0, 57, 0)] = 1.0
        pgm_function46[(0, 58, 0)] = 1.0
        pgm_function46[(0, 59, 0)] = 1.0
        pgm_function46[(0, 60, 0)] = 1.0
        pgm_function46[(0, 61, 0)] = 1.0
        pgm_function46[(0, 62, 0)] = 1.0
        pgm_function46[(0, 63, 0)] = 1.0
        pgm_function46[(0, 64, 0)] = 1.0
        pgm_function46[(0, 65, 0)] = 1.0
        pgm_function46[(0, 66, 0)] = 1.0
        pgm_function46[(0, 67, 0)] = 1.0
        pgm_function46[(0, 68, 0)] = 1.0
        pgm_function46[(0, 69, 0)] = 1.0
        pgm_function46[(0, 70, 0)] = 1.0
        pgm_function46[(0, 71, 0)] = 1.0
        pgm_function46[(0, 72, 0)] = 1.0
        pgm_function46[(0, 73, 0)] = 1.0
        pgm_function46[(0, 74, 0)] = 1.0
        pgm_function46[(0, 75, 0)] = 1.0
        pgm_function46[(1, 0, 1)] = 0.9
        pgm_function46[(1, 0, 2)] = 0.9
        pgm_function46[(1, 0, 3)] = 0.9
        pgm_function46[(1, 0, 4)] = 0.9
        pgm_function46[(1, 1, 1)] = 0.8
        pgm_function46[(1, 1, 2)] = 0.8
        pgm_function46[(1, 1, 3)] = 0.8
        pgm_function46[(1, 1, 4)] = 0.8
        pgm_function46[(1, 2, 1)] = 0.8
        pgm_function46[(1, 2, 2)] = 0.8
        pgm_function46[(1, 2, 3)] = 0.8
        pgm_function46[(1, 2, 4)] = 0.8
        pgm_function46[(1, 3, 1)] = 0.8
        pgm_function46[(1, 3, 2)] = 0.8
        pgm_function46[(1, 3, 3)] = 0.8
        pgm_function46[(1, 3, 4)] = 0.8
        pgm_function46[(1, 4, 1)] = 0.9
        pgm_function46[(1, 4, 2)] = 0.9
        pgm_function46[(1, 4, 3)] = 0.9
        pgm_function46[(1, 4, 4)] = 0.9
        pgm_function46[(1, 5, 1)] = 0.9
        pgm_function46[(1, 5, 2)] = 0.9
        pgm_function46[(1, 5, 3)] = 0.9
        pgm_function46[(1, 5, 4)] = 0.9
        pgm_function46[(1, 6, 1)] = 0.9
        pgm_function46[(1, 6, 2)] = 0.9
        pgm_function46[(1, 6, 3)] = 0.9
        pgm_function46[(1, 6, 4)] = 0.9
        pgm_function46[(1, 7, 1)] = 0.8
        pgm_function46[(1, 7, 2)] = 0.8
        pgm_function46[(1, 7, 3)] = 0.8
        pgm_function46[(1, 7, 4)] = 0.8
        pgm_function46[(1, 8, 1)] = 0.8
        pgm_function46[(1, 8, 2)] = 0.8
        pgm_function46[(1, 8, 3)] = 0.8
        pgm_function46[(1, 8, 4)] = 0.8
        pgm_function46[(1, 9, 1)] = 0.9
        pgm_function46[(1, 9, 2)] = 0.9
        pgm_function46[(1, 9, 3)] = 0.9
        pgm_function46[(1, 9, 4)] = 0.9
        pgm_function46[(1, 10, 1)] = 0.8
        pgm_function46[(1, 10, 2)] = 0.8
        pgm_function46[(1, 10, 3)] = 0.8
        pgm_function46[(1, 10, 4)] = 0.8
        pgm_function46[(1, 11, 1)] = 0.9
        pgm_function46[(1, 11, 2)] = 0.9
        pgm_function46[(1, 11, 3)] = 0.9
        pgm_function46[(1, 11, 4)] = 0.9
        pgm_function46[(1, 12, 1)] = 0.9
        pgm_function46[(1, 12, 2)] = 0.9
        pgm_function46[(1, 12, 3)] = 0.9
        pgm_function46[(1, 12, 4)] = 0.9
        pgm_function46[(1, 13, 1)] = 0.9
        pgm_function46[(1, 13, 2)] = 0.9
        pgm_function46[(1, 13, 3)] = 0.9
        pgm_function46[(1, 13, 4)] = 0.9
        pgm_function46[(1, 14, 1)] = 0.8
        pgm_function46[(1, 14, 2)] = 0.8
        pgm_function46[(1, 14, 3)] = 0.8
        pgm_function46[(1, 14, 4)] = 0.8
        pgm_function46[(1, 15, 1)] = 0.8
        pgm_function46[(1, 15, 2)] = 0.8
        pgm_function46[(1, 15, 3)] = 0.8
        pgm_function46[(1, 15, 4)] = 0.8
        pgm_function46[(1, 16, 1)] = 0.9
        pgm_function46[(1, 16, 2)] = 0.9
        pgm_function46[(1, 16, 3)] = 0.9
        pgm_function46[(1, 16, 4)] = 0.9
        pgm_function46[(1, 17, 1)] = 0.9
        pgm_function46[(1, 17, 2)] = 0.9
        pgm_function46[(1, 17, 3)] = 0.9
        pgm_function46[(1, 17, 4)] = 0.9
        pgm_function46[(1, 18, 1)] = 0.9
        pgm_function46[(1, 18, 2)] = 0.9
        pgm_function46[(1, 18, 3)] = 0.9
        pgm_function46[(1, 18, 4)] = 0.9
        pgm_function46[(1, 19, 1)] = 0.9
        pgm_function46[(1, 19, 2)] = 0.9
        pgm_function46[(1, 19, 3)] = 0.9
        pgm_function46[(1, 19, 4)] = 0.9
        pgm_function46[(1, 20, 1)] = 0.9
        pgm_function46[(1, 20, 2)] = 0.9
        pgm_function46[(1, 20, 3)] = 0.9
        pgm_function46[(1, 20, 4)] = 0.9
        pgm_function46[(1, 21, 1)] = 0.9
        pgm_function46[(1, 21, 2)] = 0.9
        pgm_function46[(1, 21, 3)] = 0.9
        pgm_function46[(1, 21, 4)] = 0.9
        pgm_function46[(1, 22, 1)] = 0.9
        pgm_function46[(1, 22, 2)] = 0.9
        pgm_function46[(1, 22, 3)] = 0.9
        pgm_function46[(1, 22, 4)] = 0.9
        pgm_function46[(1, 23, 1)] = 0.8
        pgm_function46[(1, 23, 2)] = 0.8
        pgm_function46[(1, 23, 3)] = 0.8
        pgm_function46[(1, 23, 4)] = 0.8
        pgm_function46[(1, 24, 1)] = 0.9
        pgm_function46[(1, 24, 2)] = 0.9
        pgm_function46[(1, 24, 3)] = 0.9
        pgm_function46[(1, 24, 4)] = 0.9
        pgm_function46[(1, 25, 1)] = 0.8
        pgm_function46[(1, 25, 2)] = 0.8
        pgm_function46[(1, 25, 3)] = 0.8
        pgm_function46[(1, 25, 4)] = 0.8
        pgm_function46[(1, 26, 1)] = 0.8
        pgm_function46[(1, 26, 2)] = 0.8
        pgm_function46[(1, 26, 3)] = 0.8
        pgm_function46[(1, 26, 4)] = 0.8
        pgm_function46[(1, 27, 1)] = 0.8
        pgm_function46[(1, 27, 2)] = 0.8
        pgm_function46[(1, 27, 3)] = 0.8
        pgm_function46[(1, 27, 4)] = 0.8
        pgm_function46[(1, 28, 1)] = 0.8
        pgm_function46[(1, 28, 2)] = 0.8
        pgm_function46[(1, 28, 3)] = 0.8
        pgm_function46[(1, 28, 4)] = 0.8
        pgm_function46[(1, 29, 1)] = 0.8
        pgm_function46[(1, 29, 2)] = 0.8
        pgm_function46[(1, 29, 3)] = 0.8
        pgm_function46[(1, 29, 4)] = 0.8
        pgm_function46[(1, 30, 1)] = 0.8
        pgm_function46[(1, 30, 2)] = 0.8
        pgm_function46[(1, 30, 3)] = 0.8
        pgm_function46[(1, 30, 4)] = 0.8
        pgm_function46[(1, 31, 1)] = 0.8
        pgm_function46[(1, 31, 2)] = 0.8
        pgm_function46[(1, 31, 3)] = 0.8
        pgm_function46[(1, 31, 4)] = 0.8
        pgm_function46[(1, 32, 1)] = 0.8
        pgm_function46[(1, 32, 2)] = 0.8
        pgm_function46[(1, 32, 3)] = 0.8
        pgm_function46[(1, 32, 4)] = 0.8
        pgm_function46[(1, 33, 1)] = 0.8
        pgm_function46[(1, 33, 2)] = 0.8
        pgm_function46[(1, 33, 3)] = 0.8
        pgm_function46[(1, 33, 4)] = 0.8
        pgm_function46[(1, 34, 1)] = 0.98
        pgm_function46[(1, 34, 2)] = 0.98
        pgm_function46[(1, 34, 3)] = 0.98
        pgm_function46[(1, 34, 4)] = 0.98
        pgm_function46[(1, 35, 1)] = 0.98
        pgm_function46[(1, 35, 2)] = 0.98
        pgm_function46[(1, 35, 3)] = 0.98
        pgm_function46[(1, 35, 4)] = 0.98
        pgm_function46[(1, 36, 1)] = 0.98
        pgm_function46[(1, 36, 2)] = 0.98
        pgm_function46[(1, 36, 3)] = 0.98
        pgm_function46[(1, 36, 4)] = 0.98
        pgm_function46[(1, 37, 1)] = 0.98
        pgm_function46[(1, 37, 2)] = 0.98
        pgm_function46[(1, 37, 3)] = 0.98
        pgm_function46[(1, 37, 4)] = 0.98
        pgm_function46[(1, 38, 1)] = 0.79
        pgm_function46[(1, 38, 2)] = 0.79
        pgm_function46[(1, 38, 3)] = 0.79
        pgm_function46[(1, 38, 4)] = 0.79
        pgm_function46[(1, 39, 1)] = 0.89
        pgm_function46[(1, 39, 2)] = 0.89
        pgm_function46[(1, 39, 3)] = 0.89
        pgm_function46[(1, 39, 4)] = 0.89
        pgm_function46[(1, 40, 1)] = 0.9
        pgm_function46[(1, 40, 2)] = 0.9
        pgm_function46[(1, 40, 3)] = 0.9
        pgm_function46[(1, 40, 4)] = 0.9
        pgm_function46[(1, 41, 1)] = 0.98
        pgm_function46[(1, 41, 2)] = 0.98
        pgm_function46[(1, 41, 3)] = 0.98
        pgm_function46[(1, 41, 4)] = 0.98
        pgm_function46[(1, 42, 1)] = 0.98
        pgm_function46[(1, 42, 2)] = 0.98
        pgm_function46[(1, 42, 3)] = 0.98
        pgm_function46[(1, 42, 4)] = 0.98
        pgm_function46[(1, 43, 1)] = 0.98
        pgm_function46[(1, 43, 2)] = 0.98
        pgm_function46[(1, 43, 3)] = 0.98
        pgm_function46[(1, 43, 4)] = 0.98
        pgm_function46[(1, 44, 1)] = 0.7
        pgm_function46[(1, 44, 2)] = 0.7
        pgm_function46[(1, 44, 3)] = 0.7
        pgm_function46[(1, 44, 4)] = 0.7
        pgm_function46[(1, 45, 1)] = 0.5
        pgm_function46[(1, 45, 2)] = 0.5
        pgm_function46[(1, 45, 3)] = 0.5
        pgm_function46[(1, 45, 4)] = 0.5
        pgm_function46[(1, 46, 1)] = 0.02
        pgm_function46[(1, 46, 2)] = 0.02
        pgm_function46[(1, 46, 3)] = 0.02
        pgm_function46[(1, 46, 4)] = 0.02
        pgm_function46[(1, 47, 1)] = 0.7
        pgm_function46[(1, 47, 2)] = 0.7
        pgm_function46[(1, 47, 3)] = 0.7
        pgm_function46[(1, 47, 4)] = 0.7
        pgm_function46[(1, 48, 1)] = 1.0
        pgm_function46[(1, 48, 2)] = 1.0
        pgm_function46[(1, 48, 3)] = 1.0
        pgm_function46[(1, 48, 4)] = 1.0
        pgm_function46[(1, 49, 1)] = 0.98
        pgm_function46[(1, 49, 2)] = 0.98
        pgm_function46[(1, 49, 3)] = 0.98
        pgm_function46[(1, 49, 4)] = 0.98
        pgm_function46[(1, 50, 1)] = 0.6
        pgm_function46[(1, 50, 2)] = 0.6
        pgm_function46[(1, 50, 3)] = 0.6
        pgm_function46[(1, 50, 4)] = 0.6
        pgm_function46[(1, 51, 1)] = 0.4
        pgm_function46[(1, 51, 2)] = 0.4
        pgm_function46[(1, 51, 3)] = 0.4
        pgm_function46[(1, 51, 4)] = 0.4
        pgm_function46[(1, 52, 1)] = 0.7
        pgm_function46[(1, 52, 2)] = 0.7
        pgm_function46[(1, 52, 3)] = 0.7
        pgm_function46[(1, 52, 4)] = 0.7
        pgm_function46[(1, 53, 1)] = 0.8
        pgm_function46[(1, 53, 2)] = 0.8
        pgm_function46[(1, 53, 3)] = 0.8
        pgm_function46[(1, 53, 4)] = 0.8
        pgm_function46[(1, 54, 1)] = 0.988900101
        pgm_function46[(1, 54, 2)] = 0.988900101
        pgm_function46[(1, 54, 3)] = 0.988900101
        pgm_function46[(1, 54, 4)] = 0.988900101
        pgm_function46[(1, 55, 1)] = 0.9
        pgm_function46[(1, 55, 2)] = 0.9
        pgm_function46[(1, 55, 3)] = 0.9
        pgm_function46[(1, 55, 4)] = 0.9
        pgm_function46[(1, 56, 1)] = 0.9
        pgm_function46[(1, 56, 2)] = 0.9
        pgm_function46[(1, 56, 3)] = 0.9
        pgm_function46[(1, 56, 4)] = 0.9
        pgm_function46[(1, 57, 1)] = 0.9
        pgm_function46[(1, 57, 2)] = 0.9
        pgm_function46[(1, 57, 3)] = 0.9
        pgm_function46[(1, 57, 4)] = 0.9
        pgm_function46[(1, 58, 1)] = 0.6
        pgm_function46[(1, 58, 2)] = 0.6
        pgm_function46[(1, 58, 3)] = 0.6
        pgm_function46[(1, 58, 4)] = 0.6
        pgm_function46[(1, 59, 1)] = 0.9
        pgm_function46[(1, 59, 2)] = 0.9
        pgm_function46[(1, 59, 3)] = 0.9
        pgm_function46[(1, 59, 4)] = 0.9
        pgm_function46[(1, 60, 1)] = 0.9
        pgm_function46[(1, 60, 2)] = 0.9
        pgm_function46[(1, 60, 3)] = 0.9
        pgm_function46[(1, 60, 4)] = 0.9
        pgm_function46[(1, 61, 1)] = 0.9
        pgm_function46[(1, 61, 2)] = 0.9
        pgm_function46[(1, 61, 3)] = 0.9
        pgm_function46[(1, 61, 4)] = 0.9
        pgm_function46[(1, 62, 1)] = 0.5
        pgm_function46[(1, 62, 2)] = 0.5
        pgm_function46[(1, 62, 3)] = 0.5
        pgm_function46[(1, 62, 4)] = 0.5
        pgm_function46[(1, 63, 1)] = 0.2
        pgm_function46[(1, 63, 2)] = 0.2
        pgm_function46[(1, 63, 3)] = 0.2
        pgm_function46[(1, 63, 4)] = 0.2
        pgm_function46[(1, 64, 1)] = 0.9
        pgm_function46[(1, 64, 2)] = 0.9
        pgm_function46[(1, 64, 3)] = 0.9
        pgm_function46[(1, 64, 4)] = 0.9
        pgm_function46[(1, 65, 1)] = 0.9
        pgm_function46[(1, 65, 2)] = 0.9
        pgm_function46[(1, 65, 3)] = 0.9
        pgm_function46[(1, 65, 4)] = 0.9
        pgm_function46[(1, 66, 1)] = 0.8
        pgm_function46[(1, 66, 2)] = 0.8
        pgm_function46[(1, 66, 3)] = 0.8
        pgm_function46[(1, 66, 4)] = 0.8
        pgm_function46[(1, 67, 1)] = 0.9
        pgm_function46[(1, 67, 2)] = 0.9
        pgm_function46[(1, 67, 3)] = 0.9
        pgm_function46[(1, 67, 4)] = 0.9
        pgm_function46[(1, 68, 1)] = 0.9
        pgm_function46[(1, 68, 2)] = 0.9
        pgm_function46[(1, 68, 3)] = 0.9
        pgm_function46[(1, 68, 4)] = 0.9
        pgm_function46[(1, 69, 1)] = 0.8
        pgm_function46[(1, 69, 2)] = 0.8
        pgm_function46[(1, 69, 3)] = 0.8
        pgm_function46[(1, 69, 4)] = 0.8
        pgm_function46[(1, 70, 1)] = 0.9
        pgm_function46[(1, 70, 2)] = 0.9
        pgm_function46[(1, 70, 3)] = 0.9
        pgm_function46[(1, 70, 4)] = 0.9
        pgm_function46[(1, 71, 1)] = 0.9
        pgm_function46[(1, 71, 2)] = 0.9
        pgm_function46[(1, 71, 3)] = 0.9
        pgm_function46[(1, 71, 4)] = 0.9
        pgm_function46[(1, 72, 1)] = 0.9
        pgm_function46[(1, 72, 2)] = 0.9
        pgm_function46[(1, 72, 3)] = 0.9
        pgm_function46[(1, 72, 4)] = 0.9
        pgm_function46[(1, 73, 1)] = 0.9
        pgm_function46[(1, 73, 2)] = 0.9
        pgm_function46[(1, 73, 3)] = 0.9
        pgm_function46[(1, 73, 4)] = 0.9
        pgm_function46[(1, 74, 1)] = 0.4
        pgm_function46[(1, 74, 2)] = 0.4
        pgm_function46[(1, 74, 3)] = 0.4
        pgm_function46[(1, 74, 4)] = 0.4
        pgm_function46[(1, 75, 1)] = 0.9
        pgm_function46[(1, 75, 2)] = 0.9
        pgm_function46[(1, 75, 3)] = 0.9
        pgm_function46[(1, 75, 4)] = 0.9
        pgm_function46[(2, 0, 1)] = 0.05
        pgm_function46[(2, 0, 2)] = 0.05
        pgm_function46[(2, 0, 3)] = 0.05
        pgm_function46[(2, 0, 4)] = 0.05
        pgm_function46[(2, 1, 1)] = 0.1
        pgm_function46[(2, 1, 2)] = 0.1
        pgm_function46[(2, 1, 3)] = 0.1
        pgm_function46[(2, 1, 4)] = 0.1
        pgm_function46[(2, 2, 1)] = 0.1
        pgm_function46[(2, 2, 2)] = 0.1
        pgm_function46[(2, 2, 3)] = 0.1
        pgm_function46[(2, 2, 4)] = 0.1
        pgm_function46[(2, 3, 1)] = 0.1
        pgm_function46[(2, 3, 2)] = 0.1
        pgm_function46[(2, 3, 3)] = 0.1
        pgm_function46[(2, 3, 4)] = 0.1
        pgm_function46[(2, 4, 1)] = 0.05
        pgm_function46[(2, 4, 2)] = 0.05
        pgm_function46[(2, 4, 3)] = 0.05
        pgm_function46[(2, 4, 4)] = 0.05
        pgm_function46[(2, 5, 1)] = 0.05
        pgm_function46[(2, 5, 2)] = 0.05
        pgm_function46[(2, 5, 3)] = 0.05
        pgm_function46[(2, 5, 4)] = 0.05
        pgm_function46[(2, 6, 1)] = 0.05
        pgm_function46[(2, 6, 2)] = 0.05
        pgm_function46[(2, 6, 3)] = 0.05
        pgm_function46[(2, 6, 4)] = 0.05
        pgm_function46[(2, 7, 1)] = 0.1
        pgm_function46[(2, 7, 2)] = 0.1
        pgm_function46[(2, 7, 3)] = 0.1
        pgm_function46[(2, 7, 4)] = 0.1
        pgm_function46[(2, 8, 1)] = 0.1
        pgm_function46[(2, 8, 2)] = 0.1
        pgm_function46[(2, 8, 3)] = 0.1
        pgm_function46[(2, 8, 4)] = 0.1
        pgm_function46[(2, 9, 1)] = 0.05
        pgm_function46[(2, 9, 2)] = 0.05
        pgm_function46[(2, 9, 3)] = 0.05
        pgm_function46[(2, 9, 4)] = 0.05
        pgm_function46[(2, 10, 1)] = 0.1
        pgm_function46[(2, 10, 2)] = 0.1
        pgm_function46[(2, 10, 3)] = 0.1
        pgm_function46[(2, 10, 4)] = 0.1
        pgm_function46[(2, 11, 1)] = 0.05
        pgm_function46[(2, 11, 2)] = 0.05
        pgm_function46[(2, 11, 3)] = 0.05
        pgm_function46[(2, 11, 4)] = 0.05
        pgm_function46[(2, 12, 1)] = 0.05
        pgm_function46[(2, 12, 2)] = 0.05
        pgm_function46[(2, 12, 3)] = 0.05
        pgm_function46[(2, 12, 4)] = 0.05
        pgm_function46[(2, 13, 1)] = 0.05
        pgm_function46[(2, 13, 2)] = 0.05
        pgm_function46[(2, 13, 3)] = 0.05
        pgm_function46[(2, 13, 4)] = 0.05
        pgm_function46[(2, 14, 1)] = 0.1
        pgm_function46[(2, 14, 2)] = 0.1
        pgm_function46[(2, 14, 3)] = 0.1
        pgm_function46[(2, 14, 4)] = 0.1
        pgm_function46[(2, 15, 1)] = 0.1
        pgm_function46[(2, 15, 2)] = 0.1
        pgm_function46[(2, 15, 3)] = 0.1
        pgm_function46[(2, 15, 4)] = 0.1
        pgm_function46[(2, 16, 1)] = 0.05
        pgm_function46[(2, 16, 2)] = 0.05
        pgm_function46[(2, 16, 3)] = 0.05
        pgm_function46[(2, 16, 4)] = 0.05
        pgm_function46[(2, 17, 1)] = 0.05
        pgm_function46[(2, 17, 2)] = 0.05
        pgm_function46[(2, 17, 3)] = 0.05
        pgm_function46[(2, 17, 4)] = 0.05
        pgm_function46[(2, 18, 1)] = 0.05
        pgm_function46[(2, 18, 2)] = 0.05
        pgm_function46[(2, 18, 3)] = 0.05
        pgm_function46[(2, 18, 4)] = 0.05
        pgm_function46[(2, 19, 1)] = 0.05
        pgm_function46[(2, 19, 2)] = 0.05
        pgm_function46[(2, 19, 3)] = 0.05
        pgm_function46[(2, 19, 4)] = 0.05
        pgm_function46[(2, 20, 1)] = 0.05
        pgm_function46[(2, 20, 2)] = 0.05
        pgm_function46[(2, 20, 3)] = 0.05
        pgm_function46[(2, 20, 4)] = 0.05
        pgm_function46[(2, 21, 1)] = 0.05
        pgm_function46[(2, 21, 2)] = 0.05
        pgm_function46[(2, 21, 3)] = 0.05
        pgm_function46[(2, 21, 4)] = 0.05
        pgm_function46[(2, 22, 1)] = 0.05
        pgm_function46[(2, 22, 2)] = 0.05
        pgm_function46[(2, 22, 3)] = 0.05
        pgm_function46[(2, 22, 4)] = 0.05
        pgm_function46[(2, 23, 1)] = 0.1
        pgm_function46[(2, 23, 2)] = 0.1
        pgm_function46[(2, 23, 3)] = 0.1
        pgm_function46[(2, 23, 4)] = 0.1
        pgm_function46[(2, 24, 1)] = 0.05
        pgm_function46[(2, 24, 2)] = 0.05
        pgm_function46[(2, 24, 3)] = 0.05
        pgm_function46[(2, 24, 4)] = 0.05
        pgm_function46[(2, 25, 1)] = 0.2
        pgm_function46[(2, 25, 2)] = 0.2
        pgm_function46[(2, 25, 3)] = 0.2
        pgm_function46[(2, 25, 4)] = 0.2
        pgm_function46[(2, 26, 1)] = 0.2
        pgm_function46[(2, 26, 2)] = 0.2
        pgm_function46[(2, 26, 3)] = 0.2
        pgm_function46[(2, 26, 4)] = 0.2
        pgm_function46[(2, 27, 1)] = 0.2
        pgm_function46[(2, 27, 2)] = 0.2
        pgm_function46[(2, 27, 3)] = 0.2
        pgm_function46[(2, 27, 4)] = 0.2
        pgm_function46[(2, 28, 1)] = 0.2
        pgm_function46[(2, 28, 2)] = 0.2
        pgm_function46[(2, 28, 3)] = 0.2
        pgm_function46[(2, 28, 4)] = 0.2
        pgm_function46[(2, 29, 1)] = 0.2
        pgm_function46[(2, 29, 2)] = 0.2
        pgm_function46[(2, 29, 3)] = 0.2
        pgm_function46[(2, 29, 4)] = 0.2
        pgm_function46[(2, 30, 1)] = 0.2
        pgm_function46[(2, 30, 2)] = 0.2
        pgm_function46[(2, 30, 3)] = 0.2
        pgm_function46[(2, 30, 4)] = 0.2
        pgm_function46[(2, 31, 1)] = 0.2
        pgm_function46[(2, 31, 2)] = 0.2
        pgm_function46[(2, 31, 3)] = 0.2
        pgm_function46[(2, 31, 4)] = 0.2
        pgm_function46[(2, 32, 1)] = 0.2
        pgm_function46[(2, 32, 2)] = 0.2
        pgm_function46[(2, 32, 3)] = 0.2
        pgm_function46[(2, 32, 4)] = 0.2
        pgm_function46[(2, 33, 1)] = 0.2
        pgm_function46[(2, 33, 2)] = 0.2
        pgm_function46[(2, 33, 3)] = 0.2
        pgm_function46[(2, 33, 4)] = 0.2
        pgm_function46[(2, 34, 1)] = 0.01
        pgm_function46[(2, 34, 2)] = 0.01
        pgm_function46[(2, 34, 3)] = 0.01
        pgm_function46[(2, 34, 4)] = 0.01
        pgm_function46[(2, 35, 1)] = 0.01
        pgm_function46[(2, 35, 2)] = 0.01
        pgm_function46[(2, 35, 3)] = 0.01
        pgm_function46[(2, 35, 4)] = 0.01
        pgm_function46[(2, 36, 1)] = 0.01
        pgm_function46[(2, 36, 2)] = 0.01
        pgm_function46[(2, 36, 3)] = 0.01
        pgm_function46[(2, 36, 4)] = 0.01
        pgm_function46[(2, 37, 1)] = 0.01
        pgm_function46[(2, 37, 2)] = 0.01
        pgm_function46[(2, 37, 3)] = 0.01
        pgm_function46[(2, 37, 4)] = 0.01
        pgm_function46[(2, 38, 1)] = 0.2
        pgm_function46[(2, 38, 2)] = 0.2
        pgm_function46[(2, 38, 3)] = 0.2
        pgm_function46[(2, 38, 4)] = 0.2
        pgm_function46[(2, 39, 1)] = 0.01
        pgm_function46[(2, 39, 2)] = 0.01
        pgm_function46[(2, 39, 3)] = 0.01
        pgm_function46[(2, 39, 4)] = 0.01
        pgm_function46[(2, 40, 1)] = 0.05
        pgm_function46[(2, 40, 2)] = 0.05
        pgm_function46[(2, 40, 3)] = 0.05
        pgm_function46[(2, 40, 4)] = 0.05
        pgm_function46[(2, 41, 1)] = 0.01
        pgm_function46[(2, 41, 2)] = 0.01
        pgm_function46[(2, 41, 3)] = 0.01
        pgm_function46[(2, 41, 4)] = 0.01
        pgm_function46[(2, 42, 1)] = 0.01
        pgm_function46[(2, 42, 2)] = 0.01
        pgm_function46[(2, 42, 3)] = 0.01
        pgm_function46[(2, 42, 4)] = 0.01
        pgm_function46[(2, 43, 1)] = 0.01
        pgm_function46[(2, 43, 2)] = 0.01
        pgm_function46[(2, 43, 3)] = 0.01
        pgm_function46[(2, 43, 4)] = 0.01
        pgm_function46[(2, 45, 1)] = 0.48
        pgm_function46[(2, 45, 2)] = 0.48
        pgm_function46[(2, 45, 3)] = 0.48
        pgm_function46[(2, 45, 4)] = 0.48
        pgm_function46[(2, 46, 1)] = 0.97
        pgm_function46[(2, 46, 2)] = 0.97
        pgm_function46[(2, 46, 3)] = 0.97
        pgm_function46[(2, 46, 4)] = 0.97
        pgm_function46[(2, 47, 1)] = 0.15
        pgm_function46[(2, 47, 2)] = 0.15
        pgm_function46[(2, 47, 3)] = 0.15
        pgm_function46[(2, 47, 4)] = 0.15
        pgm_function46[(2, 49, 1)] = 0.01
        pgm_function46[(2, 49, 2)] = 0.01
        pgm_function46[(2, 49, 3)] = 0.01
        pgm_function46[(2, 49, 4)] = 0.01
        pgm_function46[(2, 50, 1)] = 0.35
        pgm_function46[(2, 50, 2)] = 0.35
        pgm_function46[(2, 50, 3)] = 0.35
        pgm_function46[(2, 50, 4)] = 0.35
        pgm_function46[(2, 51, 1)] = 0.4
        pgm_function46[(2, 51, 2)] = 0.4
        pgm_function46[(2, 51, 3)] = 0.4
        pgm_function46[(2, 51, 4)] = 0.4
        pgm_function46[(2, 53, 1)] = 0.1
        pgm_function46[(2, 53, 2)] = 0.1
        pgm_function46[(2, 53, 3)] = 0.1
        pgm_function46[(2, 53, 4)] = 0.1
        pgm_function46[(2, 54, 1)] = 0.001009082
        pgm_function46[(2, 54, 2)] = 0.001009082
        pgm_function46[(2, 54, 3)] = 0.001009082
        pgm_function46[(2, 54, 4)] = 0.001009082
        pgm_function46[(2, 55, 1)] = 0.05
        pgm_function46[(2, 55, 2)] = 0.05
        pgm_function46[(2, 55, 3)] = 0.05
        pgm_function46[(2, 55, 4)] = 0.05
        pgm_function46[(2, 56, 1)] = 0.05
        pgm_function46[(2, 56, 2)] = 0.05
        pgm_function46[(2, 56, 3)] = 0.05
        pgm_function46[(2, 56, 4)] = 0.05
        pgm_function46[(2, 57, 1)] = 0.05
        pgm_function46[(2, 57, 2)] = 0.05
        pgm_function46[(2, 57, 3)] = 0.05
        pgm_function46[(2, 57, 4)] = 0.05
        pgm_function46[(2, 59, 1)] = 0.05
        pgm_function46[(2, 59, 2)] = 0.05
        pgm_function46[(2, 59, 3)] = 0.05
        pgm_function46[(2, 59, 4)] = 0.05
        pgm_function46[(2, 60, 1)] = 0.05
        pgm_function46[(2, 60, 2)] = 0.05
        pgm_function46[(2, 60, 3)] = 0.05
        pgm_function46[(2, 60, 4)] = 0.05
        pgm_function46[(2, 61, 1)] = 0.05
        pgm_function46[(2, 61, 2)] = 0.05
        pgm_function46[(2, 61, 3)] = 0.05
        pgm_function46[(2, 61, 4)] = 0.05
        pgm_function46[(2, 62, 1)] = 0.45
        pgm_function46[(2, 62, 2)] = 0.45
        pgm_function46[(2, 62, 3)] = 0.45
        pgm_function46[(2, 62, 4)] = 0.45
        pgm_function46[(2, 63, 1)] = 0.78
        pgm_function46[(2, 63, 2)] = 0.78
        pgm_function46[(2, 63, 3)] = 0.78
        pgm_function46[(2, 63, 4)] = 0.78
        pgm_function46[(2, 64, 1)] = 0.05
        pgm_function46[(2, 64, 2)] = 0.05
        pgm_function46[(2, 64, 3)] = 0.05
        pgm_function46[(2, 64, 4)] = 0.05
        pgm_function46[(2, 65, 1)] = 0.05
        pgm_function46[(2, 65, 2)] = 0.05
        pgm_function46[(2, 65, 3)] = 0.05
        pgm_function46[(2, 65, 4)] = 0.05
        pgm_function46[(2, 66, 1)] = 0.1
        pgm_function46[(2, 66, 2)] = 0.1
        pgm_function46[(2, 66, 3)] = 0.1
        pgm_function46[(2, 66, 4)] = 0.1
        pgm_function46[(2, 67, 1)] = 0.05
        pgm_function46[(2, 67, 2)] = 0.05
        pgm_function46[(2, 67, 3)] = 0.05
        pgm_function46[(2, 67, 4)] = 0.05
        pgm_function46[(2, 68, 1)] = 0.05
        pgm_function46[(2, 68, 2)] = 0.05
        pgm_function46[(2, 68, 3)] = 0.05
        pgm_function46[(2, 68, 4)] = 0.05
        pgm_function46[(2, 69, 1)] = 0.1
        pgm_function46[(2, 69, 2)] = 0.1
        pgm_function46[(2, 69, 3)] = 0.1
        pgm_function46[(2, 69, 4)] = 0.1
        pgm_function46[(2, 70, 1)] = 0.05
        pgm_function46[(2, 70, 2)] = 0.05
        pgm_function46[(2, 70, 3)] = 0.05
        pgm_function46[(2, 70, 4)] = 0.05
        pgm_function46[(2, 71, 1)] = 0.05
        pgm_function46[(2, 71, 2)] = 0.05
        pgm_function46[(2, 71, 3)] = 0.05
        pgm_function46[(2, 71, 4)] = 0.05
        pgm_function46[(2, 72, 1)] = 0.05
        pgm_function46[(2, 72, 2)] = 0.05
        pgm_function46[(2, 72, 3)] = 0.05
        pgm_function46[(2, 72, 4)] = 0.05
        pgm_function46[(2, 73, 1)] = 0.05
        pgm_function46[(2, 73, 2)] = 0.05
        pgm_function46[(2, 73, 3)] = 0.05
        pgm_function46[(2, 73, 4)] = 0.05
        pgm_function46[(2, 74, 1)] = 0.4
        pgm_function46[(2, 74, 2)] = 0.4
        pgm_function46[(2, 74, 3)] = 0.4
        pgm_function46[(2, 74, 4)] = 0.4
        pgm_function46[(2, 75, 1)] = 0.05
        pgm_function46[(2, 75, 2)] = 0.05
        pgm_function46[(2, 75, 3)] = 0.05
        pgm_function46[(2, 75, 4)] = 0.05
        pgm_function46[(3, 0, 1)] = 0.05
        pgm_function46[(3, 0, 2)] = 0.05
        pgm_function46[(3, 0, 3)] = 0.05
        pgm_function46[(3, 0, 4)] = 0.05
        pgm_function46[(3, 1, 1)] = 0.1
        pgm_function46[(3, 1, 2)] = 0.1
        pgm_function46[(3, 1, 3)] = 0.1
        pgm_function46[(3, 1, 4)] = 0.1
        pgm_function46[(3, 2, 1)] = 0.1
        pgm_function46[(3, 2, 2)] = 0.1
        pgm_function46[(3, 2, 3)] = 0.1
        pgm_function46[(3, 2, 4)] = 0.1
        pgm_function46[(3, 3, 1)] = 0.1
        pgm_function46[(3, 3, 2)] = 0.1
        pgm_function46[(3, 3, 3)] = 0.1
        pgm_function46[(3, 3, 4)] = 0.1
        pgm_function46[(3, 4, 1)] = 0.05
        pgm_function46[(3, 4, 2)] = 0.05
        pgm_function46[(3, 4, 3)] = 0.05
        pgm_function46[(3, 4, 4)] = 0.05
        pgm_function46[(3, 5, 1)] = 0.05
        pgm_function46[(3, 5, 2)] = 0.05
        pgm_function46[(3, 5, 3)] = 0.05
        pgm_function46[(3, 5, 4)] = 0.05
        pgm_function46[(3, 6, 1)] = 0.05
        pgm_function46[(3, 6, 2)] = 0.05
        pgm_function46[(3, 6, 3)] = 0.05
        pgm_function46[(3, 6, 4)] = 0.05
        pgm_function46[(3, 7, 1)] = 0.1
        pgm_function46[(3, 7, 2)] = 0.1
        pgm_function46[(3, 7, 3)] = 0.1
        pgm_function46[(3, 7, 4)] = 0.1
        pgm_function46[(3, 8, 1)] = 0.1
        pgm_function46[(3, 8, 2)] = 0.1
        pgm_function46[(3, 8, 3)] = 0.1
        pgm_function46[(3, 8, 4)] = 0.1
        pgm_function46[(3, 9, 1)] = 0.05
        pgm_function46[(3, 9, 2)] = 0.05
        pgm_function46[(3, 9, 3)] = 0.05
        pgm_function46[(3, 9, 4)] = 0.05
        pgm_function46[(3, 10, 1)] = 0.1
        pgm_function46[(3, 10, 2)] = 0.1
        pgm_function46[(3, 10, 3)] = 0.1
        pgm_function46[(3, 10, 4)] = 0.1
        pgm_function46[(3, 11, 1)] = 0.05
        pgm_function46[(3, 11, 2)] = 0.05
        pgm_function46[(3, 11, 3)] = 0.05
        pgm_function46[(3, 11, 4)] = 0.05
        pgm_function46[(3, 12, 1)] = 0.05
        pgm_function46[(3, 12, 2)] = 0.05
        pgm_function46[(3, 12, 3)] = 0.05
        pgm_function46[(3, 12, 4)] = 0.05
        pgm_function46[(3, 13, 1)] = 0.05
        pgm_function46[(3, 13, 2)] = 0.05
        pgm_function46[(3, 13, 3)] = 0.05
        pgm_function46[(3, 13, 4)] = 0.05
        pgm_function46[(3, 14, 1)] = 0.1
        pgm_function46[(3, 14, 2)] = 0.1
        pgm_function46[(3, 14, 3)] = 0.1
        pgm_function46[(3, 14, 4)] = 0.1
        pgm_function46[(3, 15, 1)] = 0.1
        pgm_function46[(3, 15, 2)] = 0.1
        pgm_function46[(3, 15, 3)] = 0.1
        pgm_function46[(3, 15, 4)] = 0.1
        pgm_function46[(3, 16, 1)] = 0.05
        pgm_function46[(3, 16, 2)] = 0.05
        pgm_function46[(3, 16, 3)] = 0.05
        pgm_function46[(3, 16, 4)] = 0.05
        pgm_function46[(3, 17, 1)] = 0.05
        pgm_function46[(3, 17, 2)] = 0.05
        pgm_function46[(3, 17, 3)] = 0.05
        pgm_function46[(3, 17, 4)] = 0.05
        pgm_function46[(3, 18, 1)] = 0.05
        pgm_function46[(3, 18, 2)] = 0.05
        pgm_function46[(3, 18, 3)] = 0.05
        pgm_function46[(3, 18, 4)] = 0.05
        pgm_function46[(3, 19, 1)] = 0.05
        pgm_function46[(3, 19, 2)] = 0.05
        pgm_function46[(3, 19, 3)] = 0.05
        pgm_function46[(3, 19, 4)] = 0.05
        pgm_function46[(3, 20, 1)] = 0.05
        pgm_function46[(3, 20, 2)] = 0.05
        pgm_function46[(3, 20, 3)] = 0.05
        pgm_function46[(3, 20, 4)] = 0.05
        pgm_function46[(3, 21, 1)] = 0.05
        pgm_function46[(3, 21, 2)] = 0.05
        pgm_function46[(3, 21, 3)] = 0.05
        pgm_function46[(3, 21, 4)] = 0.05
        pgm_function46[(3, 22, 1)] = 0.05
        pgm_function46[(3, 22, 2)] = 0.05
        pgm_function46[(3, 22, 3)] = 0.05
        pgm_function46[(3, 22, 4)] = 0.05
        pgm_function46[(3, 23, 1)] = 0.1
        pgm_function46[(3, 23, 2)] = 0.1
        pgm_function46[(3, 23, 3)] = 0.1
        pgm_function46[(3, 23, 4)] = 0.1
        pgm_function46[(3, 24, 1)] = 0.05
        pgm_function46[(3, 24, 2)] = 0.05
        pgm_function46[(3, 24, 3)] = 0.05
        pgm_function46[(3, 24, 4)] = 0.05
        pgm_function46[(3, 34, 1)] = 0.01
        pgm_function46[(3, 34, 2)] = 0.01
        pgm_function46[(3, 34, 3)] = 0.01
        pgm_function46[(3, 34, 4)] = 0.01
        pgm_function46[(3, 35, 1)] = 0.01
        pgm_function46[(3, 35, 2)] = 0.01
        pgm_function46[(3, 35, 3)] = 0.01
        pgm_function46[(3, 35, 4)] = 0.01
        pgm_function46[(3, 36, 1)] = 0.01
        pgm_function46[(3, 36, 2)] = 0.01
        pgm_function46[(3, 36, 3)] = 0.01
        pgm_function46[(3, 36, 4)] = 0.01
        pgm_function46[(3, 37, 1)] = 0.01
        pgm_function46[(3, 37, 2)] = 0.01
        pgm_function46[(3, 37, 3)] = 0.01
        pgm_function46[(3, 37, 4)] = 0.01
        pgm_function46[(3, 38, 1)] = 0.01
        pgm_function46[(3, 38, 2)] = 0.01
        pgm_function46[(3, 38, 3)] = 0.01
        pgm_function46[(3, 38, 4)] = 0.01
        pgm_function46[(3, 39, 1)] = 0.1
        pgm_function46[(3, 39, 2)] = 0.1
        pgm_function46[(3, 39, 3)] = 0.1
        pgm_function46[(3, 39, 4)] = 0.1
        pgm_function46[(3, 40, 1)] = 0.05
        pgm_function46[(3, 40, 2)] = 0.05
        pgm_function46[(3, 40, 3)] = 0.05
        pgm_function46[(3, 40, 4)] = 0.05
        pgm_function46[(3, 41, 1)] = 0.01
        pgm_function46[(3, 41, 2)] = 0.01
        pgm_function46[(3, 41, 3)] = 0.01
        pgm_function46[(3, 41, 4)] = 0.01
        pgm_function46[(3, 42, 1)] = 0.01
        pgm_function46[(3, 42, 2)] = 0.01
        pgm_function46[(3, 42, 3)] = 0.01
        pgm_function46[(3, 42, 4)] = 0.01
        pgm_function46[(3, 43, 1)] = 0.01
        pgm_function46[(3, 43, 2)] = 0.01
        pgm_function46[(3, 43, 3)] = 0.01
        pgm_function46[(3, 43, 4)] = 0.01
        pgm_function46[(3, 44, 1)] = 0.3
        pgm_function46[(3, 44, 2)] = 0.3
        pgm_function46[(3, 44, 3)] = 0.3
        pgm_function46[(3, 44, 4)] = 0.3
        pgm_function46[(3, 45, 1)] = 0.02
        pgm_function46[(3, 45, 2)] = 0.02
        pgm_function46[(3, 45, 3)] = 0.02
        pgm_function46[(3, 45, 4)] = 0.02
        pgm_function46[(3, 46, 1)] = 0.01
        pgm_function46[(3, 46, 2)] = 0.01
        pgm_function46[(3, 46, 3)] = 0.01
        pgm_function46[(3, 46, 4)] = 0.01
        pgm_function46[(3, 47, 1)] = 0.15
        pgm_function46[(3, 47, 2)] = 0.15
        pgm_function46[(3, 47, 3)] = 0.15
        pgm_function46[(3, 47, 4)] = 0.15
        pgm_function46[(3, 49, 1)] = 0.01
        pgm_function46[(3, 49, 2)] = 0.01
        pgm_function46[(3, 49, 3)] = 0.01
        pgm_function46[(3, 49, 4)] = 0.01
        pgm_function46[(3, 50, 1)] = 0.05
        pgm_function46[(3, 50, 2)] = 0.05
        pgm_function46[(3, 50, 3)] = 0.05
        pgm_function46[(3, 50, 4)] = 0.05
        pgm_function46[(3, 51, 1)] = 0.2
        pgm_function46[(3, 51, 2)] = 0.2
        pgm_function46[(3, 51, 3)] = 0.2
        pgm_function46[(3, 51, 4)] = 0.2
        pgm_function46[(3, 52, 1)] = 0.3
        pgm_function46[(3, 52, 2)] = 0.3
        pgm_function46[(3, 52, 3)] = 0.3
        pgm_function46[(3, 52, 4)] = 0.3
        pgm_function46[(3, 53, 1)] = 0.1
        pgm_function46[(3, 53, 2)] = 0.1
        pgm_function46[(3, 53, 3)] = 0.1
        pgm_function46[(3, 53, 4)] = 0.1
        pgm_function46[(3, 54, 1)] = 0.010090817
        pgm_function46[(3, 54, 2)] = 0.010090817
        pgm_function46[(3, 54, 3)] = 0.010090817
        pgm_function46[(3, 54, 4)] = 0.010090817
        pgm_function46[(3, 55, 1)] = 0.05
        pgm_function46[(3, 55, 2)] = 0.05
        pgm_function46[(3, 55, 3)] = 0.05
        pgm_function46[(3, 55, 4)] = 0.05
        pgm_function46[(3, 56, 1)] = 0.05
        pgm_function46[(3, 56, 2)] = 0.05
        pgm_function46[(3, 56, 3)] = 0.05
        pgm_function46[(3, 56, 4)] = 0.05
        pgm_function46[(3, 57, 1)] = 0.05
        pgm_function46[(3, 57, 2)] = 0.05
        pgm_function46[(3, 57, 3)] = 0.05
        pgm_function46[(3, 57, 4)] = 0.05
        pgm_function46[(3, 58, 1)] = 0.4
        pgm_function46[(3, 58, 2)] = 0.4
        pgm_function46[(3, 58, 3)] = 0.4
        pgm_function46[(3, 58, 4)] = 0.4
        pgm_function46[(3, 59, 1)] = 0.05
        pgm_function46[(3, 59, 2)] = 0.05
        pgm_function46[(3, 59, 3)] = 0.05
        pgm_function46[(3, 59, 4)] = 0.05
        pgm_function46[(3, 60, 1)] = 0.05
        pgm_function46[(3, 60, 2)] = 0.05
        pgm_function46[(3, 60, 3)] = 0.05
        pgm_function46[(3, 60, 4)] = 0.05
        pgm_function46[(3, 61, 1)] = 0.05
        pgm_function46[(3, 61, 2)] = 0.05
        pgm_function46[(3, 61, 3)] = 0.05
        pgm_function46[(3, 61, 4)] = 0.05
        pgm_function46[(3, 62, 1)] = 0.05
        pgm_function46[(3, 62, 2)] = 0.05
        pgm_function46[(3, 62, 3)] = 0.05
        pgm_function46[(3, 62, 4)] = 0.05
        pgm_function46[(3, 63, 1)] = 0.02
        pgm_function46[(3, 63, 2)] = 0.02
        pgm_function46[(3, 63, 3)] = 0.02
        pgm_function46[(3, 63, 4)] = 0.02
        pgm_function46[(3, 64, 1)] = 0.05
        pgm_function46[(3, 64, 2)] = 0.05
        pgm_function46[(3, 64, 3)] = 0.05
        pgm_function46[(3, 64, 4)] = 0.05
        pgm_function46[(3, 65, 1)] = 0.05
        pgm_function46[(3, 65, 2)] = 0.05
        pgm_function46[(3, 65, 3)] = 0.05
        pgm_function46[(3, 65, 4)] = 0.05
        pgm_function46[(3, 66, 1)] = 0.1
        pgm_function46[(3, 66, 2)] = 0.1
        pgm_function46[(3, 66, 3)] = 0.1
        pgm_function46[(3, 66, 4)] = 0.1
        pgm_function46[(3, 67, 1)] = 0.05
        pgm_function46[(3, 67, 2)] = 0.05
        pgm_function46[(3, 67, 3)] = 0.05
        pgm_function46[(3, 67, 4)] = 0.05
        pgm_function46[(3, 68, 1)] = 0.05
        pgm_function46[(3, 68, 2)] = 0.05
        pgm_function46[(3, 68, 3)] = 0.05
        pgm_function46[(3, 68, 4)] = 0.05
        pgm_function46[(3, 69, 1)] = 0.1
        pgm_function46[(3, 69, 2)] = 0.1
        pgm_function46[(3, 69, 3)] = 0.1
        pgm_function46[(3, 69, 4)] = 0.1
        pgm_function46[(3, 70, 1)] = 0.05
        pgm_function46[(3, 70, 2)] = 0.05
        pgm_function46[(3, 70, 3)] = 0.05
        pgm_function46[(3, 70, 4)] = 0.05
        pgm_function46[(3, 71, 1)] = 0.05
        pgm_function46[(3, 71, 2)] = 0.05
        pgm_function46[(3, 71, 3)] = 0.05
        pgm_function46[(3, 71, 4)] = 0.05
        pgm_function46[(3, 72, 1)] = 0.05
        pgm_function46[(3, 72, 2)] = 0.05
        pgm_function46[(3, 72, 3)] = 0.05
        pgm_function46[(3, 72, 4)] = 0.05
        pgm_function46[(3, 73, 1)] = 0.05
        pgm_function46[(3, 73, 2)] = 0.05
        pgm_function46[(3, 73, 3)] = 0.05
        pgm_function46[(3, 73, 4)] = 0.05
        pgm_function46[(3, 74, 1)] = 0.2
        pgm_function46[(3, 74, 2)] = 0.2
        pgm_function46[(3, 74, 3)] = 0.2
        pgm_function46[(3, 74, 4)] = 0.2
        pgm_function46[(3, 75, 1)] = 0.05
        pgm_function46[(3, 75, 2)] = 0.05
        pgm_function46[(3, 75, 3)] = 0.05
        pgm_function46[(3, 75, 4)] = 0.05

        pgm_function47 = pgm_factor47.set_sparse()
        pgm_function47[(0, 0, 0)] = 1.0
        pgm_function47[(0, 1, 0)] = 1.0
        pgm_function47[(0, 2, 0)] = 1.0
        pgm_function47[(0, 3, 0)] = 1.0
        pgm_function47[(0, 4, 0)] = 1.0
        pgm_function47[(0, 5, 0)] = 1.0
        pgm_function47[(0, 6, 0)] = 1.0
        pgm_function47[(0, 7, 0)] = 1.0
        pgm_function47[(0, 8, 0)] = 1.0
        pgm_function47[(0, 9, 0)] = 1.0
        pgm_function47[(0, 10, 0)] = 1.0
        pgm_function47[(0, 11, 0)] = 1.0
        pgm_function47[(0, 12, 0)] = 1.0
        pgm_function47[(0, 13, 0)] = 1.0
        pgm_function47[(0, 14, 0)] = 1.0
        pgm_function47[(0, 15, 0)] = 1.0
        pgm_function47[(0, 16, 0)] = 1.0
        pgm_function47[(0, 17, 0)] = 1.0
        pgm_function47[(0, 18, 0)] = 1.0
        pgm_function47[(0, 19, 0)] = 1.0
        pgm_function47[(0, 20, 0)] = 1.0
        pgm_function47[(0, 21, 0)] = 1.0
        pgm_function47[(0, 22, 0)] = 1.0
        pgm_function47[(0, 23, 0)] = 1.0
        pgm_function47[(0, 24, 0)] = 1.0
        pgm_function47[(0, 25, 0)] = 1.0
        pgm_function47[(0, 26, 0)] = 1.0
        pgm_function47[(0, 27, 0)] = 1.0
        pgm_function47[(0, 28, 0)] = 1.0
        pgm_function47[(0, 29, 0)] = 1.0
        pgm_function47[(0, 30, 0)] = 1.0
        pgm_function47[(0, 31, 0)] = 1.0
        pgm_function47[(0, 32, 0)] = 1.0
        pgm_function47[(0, 33, 0)] = 1.0
        pgm_function47[(0, 34, 0)] = 1.0
        pgm_function47[(0, 35, 0)] = 1.0
        pgm_function47[(0, 36, 0)] = 1.0
        pgm_function47[(0, 37, 0)] = 1.0
        pgm_function47[(0, 38, 0)] = 1.0
        pgm_function47[(0, 39, 0)] = 1.0
        pgm_function47[(0, 40, 0)] = 1.0
        pgm_function47[(0, 41, 0)] = 1.0
        pgm_function47[(0, 42, 0)] = 1.0
        pgm_function47[(0, 43, 0)] = 1.0
        pgm_function47[(0, 44, 0)] = 1.0
        pgm_function47[(0, 45, 0)] = 1.0
        pgm_function47[(0, 46, 0)] = 1.0
        pgm_function47[(0, 47, 0)] = 1.0
        pgm_function47[(0, 48, 0)] = 1.0
        pgm_function47[(0, 49, 0)] = 1.0
        pgm_function47[(0, 50, 0)] = 1.0
        pgm_function47[(0, 51, 0)] = 1.0
        pgm_function47[(0, 52, 0)] = 1.0
        pgm_function47[(0, 53, 0)] = 1.0
        pgm_function47[(0, 54, 0)] = 1.0
        pgm_function47[(0, 55, 0)] = 1.0
        pgm_function47[(0, 56, 0)] = 1.0
        pgm_function47[(0, 57, 0)] = 1.0
        pgm_function47[(0, 58, 0)] = 1.0
        pgm_function47[(0, 59, 0)] = 1.0
        pgm_function47[(0, 60, 0)] = 1.0
        pgm_function47[(0, 61, 0)] = 1.0
        pgm_function47[(0, 62, 0)] = 1.0
        pgm_function47[(0, 63, 0)] = 1.0
        pgm_function47[(0, 64, 0)] = 1.0
        pgm_function47[(0, 65, 0)] = 1.0
        pgm_function47[(0, 66, 0)] = 1.0
        pgm_function47[(0, 67, 0)] = 1.0
        pgm_function47[(0, 68, 0)] = 1.0
        pgm_function47[(0, 69, 0)] = 1.0
        pgm_function47[(0, 70, 0)] = 1.0
        pgm_function47[(0, 71, 0)] = 1.0
        pgm_function47[(0, 72, 0)] = 1.0
        pgm_function47[(0, 73, 0)] = 1.0
        pgm_function47[(0, 74, 0)] = 1.0
        pgm_function47[(0, 75, 0)] = 1.0
        pgm_function47[(1, 45, 1)] = 0.0001
        pgm_function47[(1, 45, 2)] = 0.0001
        pgm_function47[(1, 45, 3)] = 0.0001
        pgm_function47[(1, 45, 4)] = 0.0001
        pgm_function47[(1, 47, 1)] = 0.2
        pgm_function47[(1, 47, 2)] = 0.2
        pgm_function47[(1, 47, 3)] = 0.2
        pgm_function47[(1, 47, 4)] = 0.2
        pgm_function47[(1, 48, 1)] = 0.001
        pgm_function47[(1, 48, 2)] = 0.001
        pgm_function47[(1, 48, 3)] = 0.001
        pgm_function47[(1, 48, 4)] = 0.001
        pgm_function47[(1, 50, 1)] = 0.0001
        pgm_function47[(1, 50, 2)] = 0.0001
        pgm_function47[(1, 50, 3)] = 0.0001
        pgm_function47[(1, 50, 4)] = 0.0001
        pgm_function47[(1, 53, 1)] = 0.6
        pgm_function47[(1, 53, 2)] = 0.6
        pgm_function47[(1, 53, 3)] = 0.6
        pgm_function47[(1, 53, 4)] = 0.6
        pgm_function47[(1, 62, 1)] = 0.0001
        pgm_function47[(1, 62, 2)] = 0.0001
        pgm_function47[(1, 62, 3)] = 0.0001
        pgm_function47[(1, 62, 4)] = 0.0001
        pgm_function47[(2, 25, 1)] = 0.001
        pgm_function47[(2, 25, 2)] = 0.001
        pgm_function47[(2, 25, 3)] = 0.001
        pgm_function47[(2, 25, 4)] = 0.001
        pgm_function47[(2, 26, 1)] = 0.001
        pgm_function47[(2, 26, 2)] = 0.001
        pgm_function47[(2, 26, 3)] = 0.001
        pgm_function47[(2, 26, 4)] = 0.001
        pgm_function47[(2, 27, 1)] = 0.001
        pgm_function47[(2, 27, 2)] = 0.001
        pgm_function47[(2, 27, 3)] = 0.001
        pgm_function47[(2, 27, 4)] = 0.001
        pgm_function47[(2, 28, 1)] = 0.001
        pgm_function47[(2, 28, 2)] = 0.001
        pgm_function47[(2, 28, 3)] = 0.001
        pgm_function47[(2, 28, 4)] = 0.001
        pgm_function47[(2, 29, 1)] = 0.001
        pgm_function47[(2, 29, 2)] = 0.001
        pgm_function47[(2, 29, 3)] = 0.001
        pgm_function47[(2, 29, 4)] = 0.001
        pgm_function47[(2, 31, 1)] = 0.001
        pgm_function47[(2, 31, 2)] = 0.001
        pgm_function47[(2, 31, 3)] = 0.001
        pgm_function47[(2, 31, 4)] = 0.001
        pgm_function47[(2, 32, 1)] = 0.001
        pgm_function47[(2, 32, 2)] = 0.001
        pgm_function47[(2, 32, 3)] = 0.001
        pgm_function47[(2, 32, 4)] = 0.001
        pgm_function47[(2, 33, 1)] = 0.001
        pgm_function47[(2, 33, 2)] = 0.001
        pgm_function47[(2, 33, 3)] = 0.001
        pgm_function47[(2, 33, 4)] = 0.001
        pgm_function47[(2, 34, 1)] = 0.001
        pgm_function47[(2, 34, 2)] = 0.001
        pgm_function47[(2, 34, 3)] = 0.001
        pgm_function47[(2, 34, 4)] = 0.001
        pgm_function47[(2, 35, 1)] = 0.001
        pgm_function47[(2, 35, 2)] = 0.001
        pgm_function47[(2, 35, 3)] = 0.001
        pgm_function47[(2, 35, 4)] = 0.001
        pgm_function47[(2, 36, 1)] = 0.001
        pgm_function47[(2, 36, 2)] = 0.001
        pgm_function47[(2, 36, 3)] = 0.001
        pgm_function47[(2, 36, 4)] = 0.001
        pgm_function47[(2, 41, 1)] = 0.001
        pgm_function47[(2, 41, 2)] = 0.001
        pgm_function47[(2, 41, 3)] = 0.001
        pgm_function47[(2, 41, 4)] = 0.001
        pgm_function47[(2, 42, 1)] = 0.01
        pgm_function47[(2, 42, 2)] = 0.01
        pgm_function47[(2, 42, 3)] = 0.01
        pgm_function47[(2, 42, 4)] = 0.01
        pgm_function47[(2, 43, 1)] = 0.01
        pgm_function47[(2, 43, 2)] = 0.01
        pgm_function47[(2, 43, 3)] = 0.01
        pgm_function47[(2, 43, 4)] = 0.01
        pgm_function47[(2, 45, 1)] = 0.01
        pgm_function47[(2, 45, 2)] = 0.01
        pgm_function47[(2, 45, 3)] = 0.01
        pgm_function47[(2, 45, 4)] = 0.01
        pgm_function47[(2, 47, 1)] = 0.29
        pgm_function47[(2, 47, 2)] = 0.29
        pgm_function47[(2, 47, 3)] = 0.29
        pgm_function47[(2, 47, 4)] = 0.29
        pgm_function47[(2, 48, 1)] = 0.25
        pgm_function47[(2, 48, 2)] = 0.25
        pgm_function47[(2, 48, 3)] = 0.25
        pgm_function47[(2, 48, 4)] = 0.25
        pgm_function47[(2, 50, 1)] = 0.01
        pgm_function47[(2, 50, 2)] = 0.01
        pgm_function47[(2, 50, 3)] = 0.01
        pgm_function47[(2, 50, 4)] = 0.01
        pgm_function47[(2, 53, 1)] = 0.35
        pgm_function47[(2, 53, 2)] = 0.35
        pgm_function47[(2, 53, 3)] = 0.35
        pgm_function47[(2, 53, 4)] = 0.35
        pgm_function47[(2, 54, 1)] = 0.01
        pgm_function47[(2, 54, 2)] = 0.01
        pgm_function47[(2, 54, 3)] = 0.01
        pgm_function47[(2, 54, 4)] = 0.01
        pgm_function47[(2, 62, 1)] = 0.01
        pgm_function47[(2, 62, 2)] = 0.01
        pgm_function47[(2, 62, 3)] = 0.01
        pgm_function47[(2, 62, 4)] = 0.01
        pgm_function47[(2, 63, 1)] = 0.001
        pgm_function47[(2, 63, 2)] = 0.001
        pgm_function47[(2, 63, 3)] = 0.001
        pgm_function47[(2, 63, 4)] = 0.001
        pgm_function47[(3, 0, 1)] = 0.01
        pgm_function47[(3, 0, 2)] = 0.01
        pgm_function47[(3, 0, 3)] = 0.01
        pgm_function47[(3, 0, 4)] = 0.01
        pgm_function47[(3, 1, 1)] = 0.05
        pgm_function47[(3, 1, 2)] = 0.05
        pgm_function47[(3, 1, 3)] = 0.05
        pgm_function47[(3, 1, 4)] = 0.05
        pgm_function47[(3, 2, 1)] = 0.05
        pgm_function47[(3, 2, 2)] = 0.05
        pgm_function47[(3, 2, 3)] = 0.05
        pgm_function47[(3, 2, 4)] = 0.05
        pgm_function47[(3, 3, 1)] = 0.01
        pgm_function47[(3, 3, 2)] = 0.01
        pgm_function47[(3, 3, 3)] = 0.01
        pgm_function47[(3, 3, 4)] = 0.01
        pgm_function47[(3, 4, 1)] = 0.01
        pgm_function47[(3, 4, 2)] = 0.01
        pgm_function47[(3, 4, 3)] = 0.01
        pgm_function47[(3, 4, 4)] = 0.01
        pgm_function47[(3, 5, 1)] = 0.01
        pgm_function47[(3, 5, 2)] = 0.01
        pgm_function47[(3, 5, 3)] = 0.01
        pgm_function47[(3, 5, 4)] = 0.01
        pgm_function47[(3, 6, 1)] = 0.01
        pgm_function47[(3, 6, 2)] = 0.01
        pgm_function47[(3, 6, 3)] = 0.01
        pgm_function47[(3, 6, 4)] = 0.01
        pgm_function47[(3, 7, 1)] = 0.01
        pgm_function47[(3, 7, 2)] = 0.01
        pgm_function47[(3, 7, 3)] = 0.01
        pgm_function47[(3, 7, 4)] = 0.01
        pgm_function47[(3, 8, 1)] = 0.01
        pgm_function47[(3, 8, 2)] = 0.01
        pgm_function47[(3, 8, 3)] = 0.01
        pgm_function47[(3, 8, 4)] = 0.01
        pgm_function47[(3, 9, 1)] = 0.01
        pgm_function47[(3, 9, 2)] = 0.01
        pgm_function47[(3, 9, 3)] = 0.01
        pgm_function47[(3, 9, 4)] = 0.01
        pgm_function47[(3, 10, 1)] = 0.01
        pgm_function47[(3, 10, 2)] = 0.01
        pgm_function47[(3, 10, 3)] = 0.01
        pgm_function47[(3, 10, 4)] = 0.01
        pgm_function47[(3, 11, 1)] = 0.01
        pgm_function47[(3, 11, 2)] = 0.01
        pgm_function47[(3, 11, 3)] = 0.01
        pgm_function47[(3, 11, 4)] = 0.01
        pgm_function47[(3, 12, 1)] = 0.01
        pgm_function47[(3, 12, 2)] = 0.01
        pgm_function47[(3, 12, 3)] = 0.01
        pgm_function47[(3, 12, 4)] = 0.01
        pgm_function47[(3, 13, 1)] = 0.01
        pgm_function47[(3, 13, 2)] = 0.01
        pgm_function47[(3, 13, 3)] = 0.01
        pgm_function47[(3, 13, 4)] = 0.01
        pgm_function47[(3, 14, 1)] = 0.01
        pgm_function47[(3, 14, 2)] = 0.01
        pgm_function47[(3, 14, 3)] = 0.01
        pgm_function47[(3, 14, 4)] = 0.01
        pgm_function47[(3, 15, 1)] = 0.01
        pgm_function47[(3, 15, 2)] = 0.01
        pgm_function47[(3, 15, 3)] = 0.01
        pgm_function47[(3, 15, 4)] = 0.01
        pgm_function47[(3, 16, 1)] = 0.01
        pgm_function47[(3, 16, 2)] = 0.01
        pgm_function47[(3, 16, 3)] = 0.01
        pgm_function47[(3, 16, 4)] = 0.01
        pgm_function47[(3, 17, 1)] = 0.01
        pgm_function47[(3, 17, 2)] = 0.01
        pgm_function47[(3, 17, 3)] = 0.01
        pgm_function47[(3, 17, 4)] = 0.01
        pgm_function47[(3, 18, 1)] = 0.01
        pgm_function47[(3, 18, 2)] = 0.01
        pgm_function47[(3, 18, 3)] = 0.01
        pgm_function47[(3, 18, 4)] = 0.01
        pgm_function47[(3, 19, 1)] = 0.01
        pgm_function47[(3, 19, 2)] = 0.01
        pgm_function47[(3, 19, 3)] = 0.01
        pgm_function47[(3, 19, 4)] = 0.01
        pgm_function47[(3, 20, 1)] = 0.01
        pgm_function47[(3, 20, 2)] = 0.01
        pgm_function47[(3, 20, 3)] = 0.01
        pgm_function47[(3, 20, 4)] = 0.01
        pgm_function47[(3, 21, 1)] = 0.01
        pgm_function47[(3, 21, 2)] = 0.01
        pgm_function47[(3, 21, 3)] = 0.01
        pgm_function47[(3, 21, 4)] = 0.01
        pgm_function47[(3, 22, 1)] = 0.01
        pgm_function47[(3, 22, 2)] = 0.01
        pgm_function47[(3, 22, 3)] = 0.01
        pgm_function47[(3, 22, 4)] = 0.01
        pgm_function47[(3, 23, 1)] = 0.01
        pgm_function47[(3, 23, 2)] = 0.01
        pgm_function47[(3, 23, 3)] = 0.01
        pgm_function47[(3, 23, 4)] = 0.01
        pgm_function47[(3, 24, 1)] = 0.01
        pgm_function47[(3, 24, 2)] = 0.01
        pgm_function47[(3, 24, 3)] = 0.01
        pgm_function47[(3, 24, 4)] = 0.01
        pgm_function47[(3, 25, 1)] = 0.02
        pgm_function47[(3, 25, 2)] = 0.02
        pgm_function47[(3, 25, 3)] = 0.02
        pgm_function47[(3, 25, 4)] = 0.02
        pgm_function47[(3, 26, 1)] = 0.02
        pgm_function47[(3, 26, 2)] = 0.02
        pgm_function47[(3, 26, 3)] = 0.02
        pgm_function47[(3, 26, 4)] = 0.02
        pgm_function47[(3, 27, 1)] = 0.02
        pgm_function47[(3, 27, 2)] = 0.02
        pgm_function47[(3, 27, 3)] = 0.02
        pgm_function47[(3, 27, 4)] = 0.02
        pgm_function47[(3, 28, 1)] = 0.02
        pgm_function47[(3, 28, 2)] = 0.02
        pgm_function47[(3, 28, 3)] = 0.02
        pgm_function47[(3, 28, 4)] = 0.02
        pgm_function47[(3, 29, 1)] = 0.02
        pgm_function47[(3, 29, 2)] = 0.02
        pgm_function47[(3, 29, 3)] = 0.02
        pgm_function47[(3, 29, 4)] = 0.02
        pgm_function47[(3, 30, 1)] = 0.01
        pgm_function47[(3, 30, 2)] = 0.01
        pgm_function47[(3, 30, 3)] = 0.01
        pgm_function47[(3, 30, 4)] = 0.01
        pgm_function47[(3, 31, 1)] = 0.02
        pgm_function47[(3, 31, 2)] = 0.02
        pgm_function47[(3, 31, 3)] = 0.02
        pgm_function47[(3, 31, 4)] = 0.02
        pgm_function47[(3, 32, 1)] = 0.02
        pgm_function47[(3, 32, 2)] = 0.02
        pgm_function47[(3, 32, 3)] = 0.02
        pgm_function47[(3, 32, 4)] = 0.02
        pgm_function47[(3, 33, 1)] = 0.02
        pgm_function47[(3, 33, 2)] = 0.02
        pgm_function47[(3, 33, 3)] = 0.02
        pgm_function47[(3, 33, 4)] = 0.02
        pgm_function47[(3, 34, 1)] = 0.05
        pgm_function47[(3, 34, 2)] = 0.05
        pgm_function47[(3, 34, 3)] = 0.05
        pgm_function47[(3, 34, 4)] = 0.05
        pgm_function47[(3, 35, 1)] = 0.05
        pgm_function47[(3, 35, 2)] = 0.05
        pgm_function47[(3, 35, 3)] = 0.05
        pgm_function47[(3, 35, 4)] = 0.05
        pgm_function47[(3, 36, 1)] = 0.05
        pgm_function47[(3, 36, 2)] = 0.05
        pgm_function47[(3, 36, 3)] = 0.05
        pgm_function47[(3, 36, 4)] = 0.05
        pgm_function47[(3, 37, 1)] = 0.01
        pgm_function47[(3, 37, 2)] = 0.01
        pgm_function47[(3, 37, 3)] = 0.01
        pgm_function47[(3, 37, 4)] = 0.01
        pgm_function47[(3, 38, 1)] = 0.01
        pgm_function47[(3, 38, 2)] = 0.01
        pgm_function47[(3, 38, 3)] = 0.01
        pgm_function47[(3, 38, 4)] = 0.01
        pgm_function47[(3, 39, 1)] = 0.01
        pgm_function47[(3, 39, 2)] = 0.01
        pgm_function47[(3, 39, 3)] = 0.01
        pgm_function47[(3, 39, 4)] = 0.01
        pgm_function47[(3, 40, 1)] = 0.01
        pgm_function47[(3, 40, 2)] = 0.01
        pgm_function47[(3, 40, 3)] = 0.01
        pgm_function47[(3, 40, 4)] = 0.01
        pgm_function47[(3, 41, 1)] = 0.05
        pgm_function47[(3, 41, 2)] = 0.05
        pgm_function47[(3, 41, 3)] = 0.05
        pgm_function47[(3, 41, 4)] = 0.05
        pgm_function47[(3, 42, 1)] = 0.45
        pgm_function47[(3, 42, 2)] = 0.45
        pgm_function47[(3, 42, 3)] = 0.45
        pgm_function47[(3, 42, 4)] = 0.45
        pgm_function47[(3, 43, 1)] = 0.45
        pgm_function47[(3, 43, 2)] = 0.45
        pgm_function47[(3, 43, 3)] = 0.45
        pgm_function47[(3, 43, 4)] = 0.45
        pgm_function47[(3, 44, 1)] = 0.01
        pgm_function47[(3, 44, 2)] = 0.01
        pgm_function47[(3, 44, 3)] = 0.01
        pgm_function47[(3, 44, 4)] = 0.01
        pgm_function47[(3, 45, 1)] = 0.45
        pgm_function47[(3, 45, 2)] = 0.45
        pgm_function47[(3, 45, 3)] = 0.45
        pgm_function47[(3, 45, 4)] = 0.45
        pgm_function47[(3, 46, 1)] = 0.05
        pgm_function47[(3, 46, 2)] = 0.05
        pgm_function47[(3, 46, 3)] = 0.05
        pgm_function47[(3, 46, 4)] = 0.05
        pgm_function47[(3, 47, 1)] = 0.5
        pgm_function47[(3, 47, 2)] = 0.5
        pgm_function47[(3, 47, 3)] = 0.5
        pgm_function47[(3, 47, 4)] = 0.5
        pgm_function47[(3, 48, 1)] = 0.6
        pgm_function47[(3, 48, 2)] = 0.6
        pgm_function47[(3, 48, 3)] = 0.6
        pgm_function47[(3, 48, 4)] = 0.6
        pgm_function47[(3, 49, 1)] = 0.01
        pgm_function47[(3, 49, 2)] = 0.01
        pgm_function47[(3, 49, 3)] = 0.01
        pgm_function47[(3, 49, 4)] = 0.01
        pgm_function47[(3, 50, 1)] = 0.45
        pgm_function47[(3, 50, 2)] = 0.45
        pgm_function47[(3, 50, 3)] = 0.45
        pgm_function47[(3, 50, 4)] = 0.45
        pgm_function47[(3, 51, 1)] = 0.01
        pgm_function47[(3, 51, 2)] = 0.01
        pgm_function47[(3, 51, 3)] = 0.01
        pgm_function47[(3, 51, 4)] = 0.01
        pgm_function47[(3, 52, 1)] = 0.01
        pgm_function47[(3, 52, 2)] = 0.01
        pgm_function47[(3, 52, 3)] = 0.01
        pgm_function47[(3, 52, 4)] = 0.01
        pgm_function47[(3, 53, 1)] = 0.05
        pgm_function47[(3, 53, 2)] = 0.05
        pgm_function47[(3, 53, 3)] = 0.05
        pgm_function47[(3, 53, 4)] = 0.05
        pgm_function47[(3, 54, 1)] = 0.04
        pgm_function47[(3, 54, 2)] = 0.04
        pgm_function47[(3, 54, 3)] = 0.04
        pgm_function47[(3, 54, 4)] = 0.04
        pgm_function47[(3, 55, 1)] = 0.01
        pgm_function47[(3, 55, 2)] = 0.01
        pgm_function47[(3, 55, 3)] = 0.01
        pgm_function47[(3, 55, 4)] = 0.01
        pgm_function47[(3, 56, 1)] = 0.01
        pgm_function47[(3, 56, 2)] = 0.01
        pgm_function47[(3, 56, 3)] = 0.01
        pgm_function47[(3, 56, 4)] = 0.01
        pgm_function47[(3, 57, 1)] = 0.01
        pgm_function47[(3, 57, 2)] = 0.01
        pgm_function47[(3, 57, 3)] = 0.01
        pgm_function47[(3, 57, 4)] = 0.01
        pgm_function47[(3, 58, 1)] = 0.01
        pgm_function47[(3, 58, 2)] = 0.01
        pgm_function47[(3, 58, 3)] = 0.01
        pgm_function47[(3, 58, 4)] = 0.01
        pgm_function47[(3, 59, 1)] = 0.01
        pgm_function47[(3, 59, 2)] = 0.01
        pgm_function47[(3, 59, 3)] = 0.01
        pgm_function47[(3, 59, 4)] = 0.01
        pgm_function47[(3, 60, 1)] = 0.01
        pgm_function47[(3, 60, 2)] = 0.01
        pgm_function47[(3, 60, 3)] = 0.01
        pgm_function47[(3, 60, 4)] = 0.01
        pgm_function47[(3, 61, 1)] = 0.01
        pgm_function47[(3, 61, 2)] = 0.01
        pgm_function47[(3, 61, 3)] = 0.01
        pgm_function47[(3, 61, 4)] = 0.01
        pgm_function47[(3, 62, 1)] = 0.45
        pgm_function47[(3, 62, 2)] = 0.45
        pgm_function47[(3, 62, 3)] = 0.45
        pgm_function47[(3, 62, 4)] = 0.45
        pgm_function47[(3, 63, 1)] = 0.149
        pgm_function47[(3, 63, 2)] = 0.149
        pgm_function47[(3, 63, 3)] = 0.149
        pgm_function47[(3, 63, 4)] = 0.149
        pgm_function47[(3, 64, 1)] = 0.01
        pgm_function47[(3, 64, 2)] = 0.01
        pgm_function47[(3, 64, 3)] = 0.01
        pgm_function47[(3, 64, 4)] = 0.01
        pgm_function47[(3, 65, 1)] = 0.01
        pgm_function47[(3, 65, 2)] = 0.01
        pgm_function47[(3, 65, 3)] = 0.01
        pgm_function47[(3, 65, 4)] = 0.01
        pgm_function47[(3, 66, 1)] = 0.01
        pgm_function47[(3, 66, 2)] = 0.01
        pgm_function47[(3, 66, 3)] = 0.01
        pgm_function47[(3, 66, 4)] = 0.01
        pgm_function47[(3, 67, 1)] = 0.01
        pgm_function47[(3, 67, 2)] = 0.01
        pgm_function47[(3, 67, 3)] = 0.01
        pgm_function47[(3, 67, 4)] = 0.01
        pgm_function47[(3, 68, 1)] = 0.01
        pgm_function47[(3, 68, 2)] = 0.01
        pgm_function47[(3, 68, 3)] = 0.01
        pgm_function47[(3, 68, 4)] = 0.01
        pgm_function47[(3, 69, 1)] = 0.01
        pgm_function47[(3, 69, 2)] = 0.01
        pgm_function47[(3, 69, 3)] = 0.01
        pgm_function47[(3, 69, 4)] = 0.01
        pgm_function47[(3, 70, 1)] = 0.01
        pgm_function47[(3, 70, 2)] = 0.01
        pgm_function47[(3, 70, 3)] = 0.01
        pgm_function47[(3, 70, 4)] = 0.01
        pgm_function47[(3, 71, 1)] = 0.01
        pgm_function47[(3, 71, 2)] = 0.01
        pgm_function47[(3, 71, 3)] = 0.01
        pgm_function47[(3, 71, 4)] = 0.01
        pgm_function47[(3, 72, 1)] = 0.01
        pgm_function47[(3, 72, 2)] = 0.01
        pgm_function47[(3, 72, 3)] = 0.01
        pgm_function47[(3, 72, 4)] = 0.01
        pgm_function47[(3, 73, 1)] = 0.01
        pgm_function47[(3, 73, 2)] = 0.01
        pgm_function47[(3, 73, 3)] = 0.01
        pgm_function47[(3, 73, 4)] = 0.01
        pgm_function47[(3, 74, 1)] = 0.01
        pgm_function47[(3, 74, 2)] = 0.01
        pgm_function47[(3, 74, 3)] = 0.01
        pgm_function47[(3, 74, 4)] = 0.01
        pgm_function47[(3, 75, 1)] = 0.01
        pgm_function47[(3, 75, 2)] = 0.01
        pgm_function47[(3, 75, 3)] = 0.01
        pgm_function47[(3, 75, 4)] = 0.01
        pgm_function47[(4, 0, 1)] = 0.99
        pgm_function47[(4, 0, 2)] = 0.99
        pgm_function47[(4, 0, 3)] = 0.99
        pgm_function47[(4, 0, 4)] = 0.99
        pgm_function47[(4, 1, 1)] = 0.95
        pgm_function47[(4, 1, 2)] = 0.95
        pgm_function47[(4, 1, 3)] = 0.95
        pgm_function47[(4, 1, 4)] = 0.95
        pgm_function47[(4, 2, 1)] = 0.95
        pgm_function47[(4, 2, 2)] = 0.95
        pgm_function47[(4, 2, 3)] = 0.95
        pgm_function47[(4, 2, 4)] = 0.95
        pgm_function47[(4, 3, 1)] = 0.99
        pgm_function47[(4, 3, 2)] = 0.99
        pgm_function47[(4, 3, 3)] = 0.99
        pgm_function47[(4, 3, 4)] = 0.99
        pgm_function47[(4, 4, 1)] = 0.99
        pgm_function47[(4, 4, 2)] = 0.99
        pgm_function47[(4, 4, 3)] = 0.99
        pgm_function47[(4, 4, 4)] = 0.99
        pgm_function47[(4, 5, 1)] = 0.99
        pgm_function47[(4, 5, 2)] = 0.99
        pgm_function47[(4, 5, 3)] = 0.99
        pgm_function47[(4, 5, 4)] = 0.99
        pgm_function47[(4, 6, 1)] = 0.99
        pgm_function47[(4, 6, 2)] = 0.99
        pgm_function47[(4, 6, 3)] = 0.99
        pgm_function47[(4, 6, 4)] = 0.99
        pgm_function47[(4, 7, 1)] = 0.99
        pgm_function47[(4, 7, 2)] = 0.99
        pgm_function47[(4, 7, 3)] = 0.99
        pgm_function47[(4, 7, 4)] = 0.99
        pgm_function47[(4, 8, 1)] = 0.99
        pgm_function47[(4, 8, 2)] = 0.99
        pgm_function47[(4, 8, 3)] = 0.99
        pgm_function47[(4, 8, 4)] = 0.99
        pgm_function47[(4, 9, 1)] = 0.99
        pgm_function47[(4, 9, 2)] = 0.99
        pgm_function47[(4, 9, 3)] = 0.99
        pgm_function47[(4, 9, 4)] = 0.99
        pgm_function47[(4, 10, 1)] = 0.99
        pgm_function47[(4, 10, 2)] = 0.99
        pgm_function47[(4, 10, 3)] = 0.99
        pgm_function47[(4, 10, 4)] = 0.99
        pgm_function47[(4, 11, 1)] = 0.99
        pgm_function47[(4, 11, 2)] = 0.99
        pgm_function47[(4, 11, 3)] = 0.99
        pgm_function47[(4, 11, 4)] = 0.99
        pgm_function47[(4, 12, 1)] = 0.99
        pgm_function47[(4, 12, 2)] = 0.99
        pgm_function47[(4, 12, 3)] = 0.99
        pgm_function47[(4, 12, 4)] = 0.99
        pgm_function47[(4, 13, 1)] = 0.99
        pgm_function47[(4, 13, 2)] = 0.99
        pgm_function47[(4, 13, 3)] = 0.99
        pgm_function47[(4, 13, 4)] = 0.99
        pgm_function47[(4, 14, 1)] = 0.99
        pgm_function47[(4, 14, 2)] = 0.99
        pgm_function47[(4, 14, 3)] = 0.99
        pgm_function47[(4, 14, 4)] = 0.99
        pgm_function47[(4, 15, 1)] = 0.99
        pgm_function47[(4, 15, 2)] = 0.99
        pgm_function47[(4, 15, 3)] = 0.99
        pgm_function47[(4, 15, 4)] = 0.99
        pgm_function47[(4, 16, 1)] = 0.99
        pgm_function47[(4, 16, 2)] = 0.99
        pgm_function47[(4, 16, 3)] = 0.99
        pgm_function47[(4, 16, 4)] = 0.99
        pgm_function47[(4, 17, 1)] = 0.99
        pgm_function47[(4, 17, 2)] = 0.99
        pgm_function47[(4, 17, 3)] = 0.99
        pgm_function47[(4, 17, 4)] = 0.99
        pgm_function47[(4, 18, 1)] = 0.99
        pgm_function47[(4, 18, 2)] = 0.99
        pgm_function47[(4, 18, 3)] = 0.99
        pgm_function47[(4, 18, 4)] = 0.99
        pgm_function47[(4, 19, 1)] = 0.99
        pgm_function47[(4, 19, 2)] = 0.99
        pgm_function47[(4, 19, 3)] = 0.99
        pgm_function47[(4, 19, 4)] = 0.99
        pgm_function47[(4, 20, 1)] = 0.99
        pgm_function47[(4, 20, 2)] = 0.99
        pgm_function47[(4, 20, 3)] = 0.99
        pgm_function47[(4, 20, 4)] = 0.99
        pgm_function47[(4, 21, 1)] = 0.99
        pgm_function47[(4, 21, 2)] = 0.99
        pgm_function47[(4, 21, 3)] = 0.99
        pgm_function47[(4, 21, 4)] = 0.99
        pgm_function47[(4, 22, 1)] = 0.99
        pgm_function47[(4, 22, 2)] = 0.99
        pgm_function47[(4, 22, 3)] = 0.99
        pgm_function47[(4, 22, 4)] = 0.99
        pgm_function47[(4, 23, 1)] = 0.99
        pgm_function47[(4, 23, 2)] = 0.99
        pgm_function47[(4, 23, 3)] = 0.99
        pgm_function47[(4, 23, 4)] = 0.99
        pgm_function47[(4, 24, 1)] = 0.99
        pgm_function47[(4, 24, 2)] = 0.99
        pgm_function47[(4, 24, 3)] = 0.99
        pgm_function47[(4, 24, 4)] = 0.99
        pgm_function47[(4, 25, 1)] = 0.979
        pgm_function47[(4, 25, 2)] = 0.979
        pgm_function47[(4, 25, 3)] = 0.979
        pgm_function47[(4, 25, 4)] = 0.979
        pgm_function47[(4, 26, 1)] = 0.979
        pgm_function47[(4, 26, 2)] = 0.979
        pgm_function47[(4, 26, 3)] = 0.979
        pgm_function47[(4, 26, 4)] = 0.979
        pgm_function47[(4, 27, 1)] = 0.979
        pgm_function47[(4, 27, 2)] = 0.979
        pgm_function47[(4, 27, 3)] = 0.979
        pgm_function47[(4, 27, 4)] = 0.979
        pgm_function47[(4, 28, 1)] = 0.979
        pgm_function47[(4, 28, 2)] = 0.979
        pgm_function47[(4, 28, 3)] = 0.979
        pgm_function47[(4, 28, 4)] = 0.979
        pgm_function47[(4, 29, 1)] = 0.979
        pgm_function47[(4, 29, 2)] = 0.979
        pgm_function47[(4, 29, 3)] = 0.979
        pgm_function47[(4, 29, 4)] = 0.979
        pgm_function47[(4, 30, 1)] = 0.99
        pgm_function47[(4, 30, 2)] = 0.99
        pgm_function47[(4, 30, 3)] = 0.99
        pgm_function47[(4, 30, 4)] = 0.99
        pgm_function47[(4, 31, 1)] = 0.979
        pgm_function47[(4, 31, 2)] = 0.979
        pgm_function47[(4, 31, 3)] = 0.979
        pgm_function47[(4, 31, 4)] = 0.979
        pgm_function47[(4, 32, 1)] = 0.979
        pgm_function47[(4, 32, 2)] = 0.979
        pgm_function47[(4, 32, 3)] = 0.979
        pgm_function47[(4, 32, 4)] = 0.979
        pgm_function47[(4, 33, 1)] = 0.979
        pgm_function47[(4, 33, 2)] = 0.979
        pgm_function47[(4, 33, 3)] = 0.979
        pgm_function47[(4, 33, 4)] = 0.979
        pgm_function47[(4, 34, 1)] = 0.949
        pgm_function47[(4, 34, 2)] = 0.949
        pgm_function47[(4, 34, 3)] = 0.949
        pgm_function47[(4, 34, 4)] = 0.949
        pgm_function47[(4, 35, 1)] = 0.949
        pgm_function47[(4, 35, 2)] = 0.949
        pgm_function47[(4, 35, 3)] = 0.949
        pgm_function47[(4, 35, 4)] = 0.949
        pgm_function47[(4, 36, 1)] = 0.949
        pgm_function47[(4, 36, 2)] = 0.949
        pgm_function47[(4, 36, 3)] = 0.949
        pgm_function47[(4, 36, 4)] = 0.949
        pgm_function47[(4, 37, 1)] = 0.99
        pgm_function47[(4, 37, 2)] = 0.99
        pgm_function47[(4, 37, 3)] = 0.99
        pgm_function47[(4, 37, 4)] = 0.99
        pgm_function47[(4, 38, 1)] = 0.99
        pgm_function47[(4, 38, 2)] = 0.99
        pgm_function47[(4, 38, 3)] = 0.99
        pgm_function47[(4, 38, 4)] = 0.99
        pgm_function47[(4, 39, 1)] = 0.99
        pgm_function47[(4, 39, 2)] = 0.99
        pgm_function47[(4, 39, 3)] = 0.99
        pgm_function47[(4, 39, 4)] = 0.99
        pgm_function47[(4, 40, 1)] = 0.99
        pgm_function47[(4, 40, 2)] = 0.99
        pgm_function47[(4, 40, 3)] = 0.99
        pgm_function47[(4, 40, 4)] = 0.99
        pgm_function47[(4, 41, 1)] = 0.949
        pgm_function47[(4, 41, 2)] = 0.949
        pgm_function47[(4, 41, 3)] = 0.949
        pgm_function47[(4, 41, 4)] = 0.949
        pgm_function47[(4, 42, 1)] = 0.54
        pgm_function47[(4, 42, 2)] = 0.54
        pgm_function47[(4, 42, 3)] = 0.54
        pgm_function47[(4, 42, 4)] = 0.54
        pgm_function47[(4, 43, 1)] = 0.54
        pgm_function47[(4, 43, 2)] = 0.54
        pgm_function47[(4, 43, 3)] = 0.54
        pgm_function47[(4, 43, 4)] = 0.54
        pgm_function47[(4, 44, 1)] = 0.99
        pgm_function47[(4, 44, 2)] = 0.99
        pgm_function47[(4, 44, 3)] = 0.99
        pgm_function47[(4, 44, 4)] = 0.99
        pgm_function47[(4, 45, 1)] = 0.5399
        pgm_function47[(4, 45, 2)] = 0.5399
        pgm_function47[(4, 45, 3)] = 0.5399
        pgm_function47[(4, 45, 4)] = 0.5399
        pgm_function47[(4, 46, 1)] = 0.95
        pgm_function47[(4, 46, 2)] = 0.95
        pgm_function47[(4, 46, 3)] = 0.95
        pgm_function47[(4, 46, 4)] = 0.95
        pgm_function47[(4, 47, 1)] = 0.01
        pgm_function47[(4, 47, 2)] = 0.01
        pgm_function47[(4, 47, 3)] = 0.01
        pgm_function47[(4, 47, 4)] = 0.01
        pgm_function47[(4, 48, 1)] = 0.149
        pgm_function47[(4, 48, 2)] = 0.149
        pgm_function47[(4, 48, 3)] = 0.149
        pgm_function47[(4, 48, 4)] = 0.149
        pgm_function47[(4, 49, 1)] = 0.99
        pgm_function47[(4, 49, 2)] = 0.99
        pgm_function47[(4, 49, 3)] = 0.99
        pgm_function47[(4, 49, 4)] = 0.99
        pgm_function47[(4, 50, 1)] = 0.5399
        pgm_function47[(4, 50, 2)] = 0.5399
        pgm_function47[(4, 50, 3)] = 0.5399
        pgm_function47[(4, 50, 4)] = 0.5399
        pgm_function47[(4, 51, 1)] = 0.99
        pgm_function47[(4, 51, 2)] = 0.99
        pgm_function47[(4, 51, 3)] = 0.99
        pgm_function47[(4, 51, 4)] = 0.99
        pgm_function47[(4, 52, 1)] = 0.99
        pgm_function47[(4, 52, 2)] = 0.99
        pgm_function47[(4, 52, 3)] = 0.99
        pgm_function47[(4, 52, 4)] = 0.99
        pgm_function47[(4, 54, 1)] = 0.95
        pgm_function47[(4, 54, 2)] = 0.95
        pgm_function47[(4, 54, 3)] = 0.95
        pgm_function47[(4, 54, 4)] = 0.95
        pgm_function47[(4, 55, 1)] = 0.99
        pgm_function47[(4, 55, 2)] = 0.99
        pgm_function47[(4, 55, 3)] = 0.99
        pgm_function47[(4, 55, 4)] = 0.99
        pgm_function47[(4, 56, 1)] = 0.99
        pgm_function47[(4, 56, 2)] = 0.99
        pgm_function47[(4, 56, 3)] = 0.99
        pgm_function47[(4, 56, 4)] = 0.99
        pgm_function47[(4, 57, 1)] = 0.99
        pgm_function47[(4, 57, 2)] = 0.99
        pgm_function47[(4, 57, 3)] = 0.99
        pgm_function47[(4, 57, 4)] = 0.99
        pgm_function47[(4, 58, 1)] = 0.99
        pgm_function47[(4, 58, 2)] = 0.99
        pgm_function47[(4, 58, 3)] = 0.99
        pgm_function47[(4, 58, 4)] = 0.99
        pgm_function47[(4, 59, 1)] = 0.99
        pgm_function47[(4, 59, 2)] = 0.99
        pgm_function47[(4, 59, 3)] = 0.99
        pgm_function47[(4, 59, 4)] = 0.99
        pgm_function47[(4, 60, 1)] = 0.99
        pgm_function47[(4, 60, 2)] = 0.99
        pgm_function47[(4, 60, 3)] = 0.99
        pgm_function47[(4, 60, 4)] = 0.99
        pgm_function47[(4, 61, 1)] = 0.99
        pgm_function47[(4, 61, 2)] = 0.99
        pgm_function47[(4, 61, 3)] = 0.99
        pgm_function47[(4, 61, 4)] = 0.99
        pgm_function47[(4, 62, 1)] = 0.5399
        pgm_function47[(4, 62, 2)] = 0.5399
        pgm_function47[(4, 62, 3)] = 0.5399
        pgm_function47[(4, 62, 4)] = 0.5399
        pgm_function47[(4, 63, 1)] = 0.85
        pgm_function47[(4, 63, 2)] = 0.85
        pgm_function47[(4, 63, 3)] = 0.85
        pgm_function47[(4, 63, 4)] = 0.85
        pgm_function47[(4, 64, 1)] = 0.99
        pgm_function47[(4, 64, 2)] = 0.99
        pgm_function47[(4, 64, 3)] = 0.99
        pgm_function47[(4, 64, 4)] = 0.99
        pgm_function47[(4, 65, 1)] = 0.99
        pgm_function47[(4, 65, 2)] = 0.99
        pgm_function47[(4, 65, 3)] = 0.99
        pgm_function47[(4, 65, 4)] = 0.99
        pgm_function47[(4, 66, 1)] = 0.99
        pgm_function47[(4, 66, 2)] = 0.99
        pgm_function47[(4, 66, 3)] = 0.99
        pgm_function47[(4, 66, 4)] = 0.99
        pgm_function47[(4, 67, 1)] = 0.99
        pgm_function47[(4, 67, 2)] = 0.99
        pgm_function47[(4, 67, 3)] = 0.99
        pgm_function47[(4, 67, 4)] = 0.99
        pgm_function47[(4, 68, 1)] = 0.99
        pgm_function47[(4, 68, 2)] = 0.99
        pgm_function47[(4, 68, 3)] = 0.99
        pgm_function47[(4, 68, 4)] = 0.99
        pgm_function47[(4, 69, 1)] = 0.99
        pgm_function47[(4, 69, 2)] = 0.99
        pgm_function47[(4, 69, 3)] = 0.99
        pgm_function47[(4, 69, 4)] = 0.99
        pgm_function47[(4, 70, 1)] = 0.99
        pgm_function47[(4, 70, 2)] = 0.99
        pgm_function47[(4, 70, 3)] = 0.99
        pgm_function47[(4, 70, 4)] = 0.99
        pgm_function47[(4, 71, 1)] = 0.99
        pgm_function47[(4, 71, 2)] = 0.99
        pgm_function47[(4, 71, 3)] = 0.99
        pgm_function47[(4, 71, 4)] = 0.99
        pgm_function47[(4, 72, 1)] = 0.99
        pgm_function47[(4, 72, 2)] = 0.99
        pgm_function47[(4, 72, 3)] = 0.99
        pgm_function47[(4, 72, 4)] = 0.99
        pgm_function47[(4, 73, 1)] = 0.99
        pgm_function47[(4, 73, 2)] = 0.99
        pgm_function47[(4, 73, 3)] = 0.99
        pgm_function47[(4, 73, 4)] = 0.99
        pgm_function47[(4, 74, 1)] = 0.99
        pgm_function47[(4, 74, 2)] = 0.99
        pgm_function47[(4, 74, 3)] = 0.99
        pgm_function47[(4, 74, 4)] = 0.99
        pgm_function47[(4, 75, 1)] = 0.99
        pgm_function47[(4, 75, 2)] = 0.99
        pgm_function47[(4, 75, 3)] = 0.99
        pgm_function47[(4, 75, 4)] = 0.99

        pgm_function48 = pgm_factor48.set_sparse()
        pgm_function48[(0, 0, 0)] = 1.0
        pgm_function48[(0, 1, 0)] = 1.0
        pgm_function48[(0, 2, 0)] = 1.0
        pgm_function48[(0, 3, 0)] = 1.0
        pgm_function48[(0, 4, 0)] = 1.0
        pgm_function48[(0, 5, 0)] = 1.0
        pgm_function48[(0, 6, 0)] = 1.0
        pgm_function48[(0, 7, 0)] = 1.0
        pgm_function48[(0, 8, 0)] = 1.0
        pgm_function48[(0, 9, 0)] = 1.0
        pgm_function48[(0, 10, 0)] = 1.0
        pgm_function48[(0, 11, 0)] = 1.0
        pgm_function48[(0, 12, 0)] = 1.0
        pgm_function48[(0, 13, 0)] = 1.0
        pgm_function48[(0, 14, 0)] = 1.0
        pgm_function48[(0, 15, 0)] = 1.0
        pgm_function48[(0, 16, 0)] = 1.0
        pgm_function48[(0, 17, 0)] = 1.0
        pgm_function48[(0, 18, 0)] = 1.0
        pgm_function48[(0, 19, 0)] = 1.0
        pgm_function48[(0, 20, 0)] = 1.0
        pgm_function48[(0, 21, 0)] = 1.0
        pgm_function48[(0, 22, 0)] = 1.0
        pgm_function48[(0, 23, 0)] = 1.0
        pgm_function48[(0, 24, 0)] = 1.0
        pgm_function48[(0, 25, 0)] = 1.0
        pgm_function48[(0, 26, 0)] = 1.0
        pgm_function48[(0, 27, 0)] = 1.0
        pgm_function48[(0, 28, 0)] = 1.0
        pgm_function48[(0, 29, 0)] = 1.0
        pgm_function48[(0, 30, 0)] = 1.0
        pgm_function48[(0, 31, 0)] = 1.0
        pgm_function48[(0, 32, 0)] = 1.0
        pgm_function48[(0, 33, 0)] = 1.0
        pgm_function48[(0, 34, 0)] = 1.0
        pgm_function48[(0, 35, 0)] = 1.0
        pgm_function48[(0, 36, 0)] = 1.0
        pgm_function48[(0, 37, 0)] = 1.0
        pgm_function48[(0, 38, 0)] = 1.0
        pgm_function48[(0, 39, 0)] = 1.0
        pgm_function48[(0, 40, 0)] = 1.0
        pgm_function48[(0, 41, 0)] = 1.0
        pgm_function48[(0, 42, 0)] = 1.0
        pgm_function48[(0, 43, 0)] = 1.0
        pgm_function48[(0, 44, 0)] = 1.0
        pgm_function48[(0, 45, 0)] = 1.0
        pgm_function48[(0, 46, 0)] = 1.0
        pgm_function48[(0, 47, 0)] = 1.0
        pgm_function48[(0, 48, 0)] = 1.0
        pgm_function48[(0, 49, 0)] = 1.0
        pgm_function48[(0, 50, 0)] = 1.0
        pgm_function48[(0, 51, 0)] = 1.0
        pgm_function48[(0, 52, 0)] = 1.0
        pgm_function48[(0, 53, 0)] = 1.0
        pgm_function48[(0, 54, 0)] = 1.0
        pgm_function48[(0, 55, 0)] = 1.0
        pgm_function48[(0, 56, 0)] = 1.0
        pgm_function48[(0, 57, 0)] = 1.0
        pgm_function48[(0, 58, 0)] = 1.0
        pgm_function48[(0, 59, 0)] = 1.0
        pgm_function48[(0, 60, 0)] = 1.0
        pgm_function48[(0, 61, 0)] = 1.0
        pgm_function48[(0, 62, 0)] = 1.0
        pgm_function48[(0, 63, 0)] = 1.0
        pgm_function48[(0, 64, 0)] = 1.0
        pgm_function48[(0, 65, 0)] = 1.0
        pgm_function48[(0, 66, 0)] = 1.0
        pgm_function48[(0, 67, 0)] = 1.0
        pgm_function48[(0, 68, 0)] = 1.0
        pgm_function48[(0, 69, 0)] = 1.0
        pgm_function48[(0, 70, 0)] = 1.0
        pgm_function48[(0, 71, 0)] = 1.0
        pgm_function48[(0, 72, 0)] = 1.0
        pgm_function48[(0, 73, 0)] = 1.0
        pgm_function48[(0, 74, 0)] = 1.0
        pgm_function48[(0, 75, 0)] = 1.0
        pgm_function48[(1, 0, 1)] = 0.1
        pgm_function48[(1, 0, 2)] = 0.1
        pgm_function48[(1, 0, 3)] = 0.1
        pgm_function48[(1, 0, 4)] = 0.1
        pgm_function48[(1, 1, 1)] = 0.051
        pgm_function48[(1, 1, 2)] = 0.051
        pgm_function48[(1, 1, 3)] = 0.051
        pgm_function48[(1, 1, 4)] = 0.051
        pgm_function48[(1, 2, 1)] = 0.1
        pgm_function48[(1, 2, 2)] = 0.1
        pgm_function48[(1, 2, 3)] = 0.1
        pgm_function48[(1, 2, 4)] = 0.1
        pgm_function48[(1, 3, 1)] = 0.1
        pgm_function48[(1, 3, 2)] = 0.1
        pgm_function48[(1, 3, 3)] = 0.1
        pgm_function48[(1, 3, 4)] = 0.1
        pgm_function48[(1, 4, 1)] = 0.1
        pgm_function48[(1, 4, 2)] = 0.1
        pgm_function48[(1, 4, 3)] = 0.1
        pgm_function48[(1, 4, 4)] = 0.1
        pgm_function48[(1, 5, 1)] = 0.1
        pgm_function48[(1, 5, 2)] = 0.1
        pgm_function48[(1, 5, 3)] = 0.1
        pgm_function48[(1, 5, 4)] = 0.1
        pgm_function48[(1, 6, 1)] = 0.1
        pgm_function48[(1, 6, 2)] = 0.1
        pgm_function48[(1, 6, 3)] = 0.1
        pgm_function48[(1, 6, 4)] = 0.1
        pgm_function48[(1, 7, 1)] = 0.1
        pgm_function48[(1, 7, 2)] = 0.1
        pgm_function48[(1, 7, 3)] = 0.1
        pgm_function48[(1, 7, 4)] = 0.1
        pgm_function48[(1, 8, 1)] = 0.1
        pgm_function48[(1, 8, 2)] = 0.1
        pgm_function48[(1, 8, 3)] = 0.1
        pgm_function48[(1, 8, 4)] = 0.1
        pgm_function48[(1, 9, 1)] = 0.1
        pgm_function48[(1, 9, 2)] = 0.1
        pgm_function48[(1, 9, 3)] = 0.1
        pgm_function48[(1, 9, 4)] = 0.1
        pgm_function48[(1, 10, 1)] = 0.1
        pgm_function48[(1, 10, 2)] = 0.1
        pgm_function48[(1, 10, 3)] = 0.1
        pgm_function48[(1, 10, 4)] = 0.1
        pgm_function48[(1, 11, 1)] = 0.1
        pgm_function48[(1, 11, 2)] = 0.1
        pgm_function48[(1, 11, 3)] = 0.1
        pgm_function48[(1, 11, 4)] = 0.1
        pgm_function48[(1, 12, 1)] = 0.1
        pgm_function48[(1, 12, 2)] = 0.1
        pgm_function48[(1, 12, 3)] = 0.1
        pgm_function48[(1, 12, 4)] = 0.1
        pgm_function48[(1, 13, 1)] = 0.05
        pgm_function48[(1, 13, 2)] = 0.05
        pgm_function48[(1, 13, 3)] = 0.05
        pgm_function48[(1, 13, 4)] = 0.05
        pgm_function48[(1, 14, 1)] = 0.1
        pgm_function48[(1, 14, 2)] = 0.1
        pgm_function48[(1, 14, 3)] = 0.1
        pgm_function48[(1, 14, 4)] = 0.1
        pgm_function48[(1, 15, 1)] = 0.1
        pgm_function48[(1, 15, 2)] = 0.1
        pgm_function48[(1, 15, 3)] = 0.1
        pgm_function48[(1, 15, 4)] = 0.1
        pgm_function48[(1, 16, 1)] = 0.1
        pgm_function48[(1, 16, 2)] = 0.1
        pgm_function48[(1, 16, 3)] = 0.1
        pgm_function48[(1, 16, 4)] = 0.1
        pgm_function48[(1, 17, 1)] = 0.1
        pgm_function48[(1, 17, 2)] = 0.1
        pgm_function48[(1, 17, 3)] = 0.1
        pgm_function48[(1, 17, 4)] = 0.1
        pgm_function48[(1, 18, 1)] = 0.1
        pgm_function48[(1, 18, 2)] = 0.1
        pgm_function48[(1, 18, 3)] = 0.1
        pgm_function48[(1, 18, 4)] = 0.1
        pgm_function48[(1, 19, 1)] = 0.1
        pgm_function48[(1, 19, 2)] = 0.1
        pgm_function48[(1, 19, 3)] = 0.1
        pgm_function48[(1, 19, 4)] = 0.1
        pgm_function48[(1, 20, 1)] = 0.1
        pgm_function48[(1, 20, 2)] = 0.1
        pgm_function48[(1, 20, 3)] = 0.1
        pgm_function48[(1, 20, 4)] = 0.1
        pgm_function48[(1, 21, 1)] = 0.1
        pgm_function48[(1, 21, 2)] = 0.1
        pgm_function48[(1, 21, 3)] = 0.1
        pgm_function48[(1, 21, 4)] = 0.1
        pgm_function48[(1, 22, 1)] = 0.1
        pgm_function48[(1, 22, 2)] = 0.1
        pgm_function48[(1, 22, 3)] = 0.1
        pgm_function48[(1, 22, 4)] = 0.1
        pgm_function48[(1, 23, 1)] = 0.1
        pgm_function48[(1, 23, 2)] = 0.1
        pgm_function48[(1, 23, 3)] = 0.1
        pgm_function48[(1, 23, 4)] = 0.1
        pgm_function48[(1, 24, 1)] = 0.1
        pgm_function48[(1, 24, 2)] = 0.1
        pgm_function48[(1, 24, 3)] = 0.1
        pgm_function48[(1, 24, 4)] = 0.1
        pgm_function48[(1, 25, 1)] = 0.15
        pgm_function48[(1, 25, 2)] = 0.15
        pgm_function48[(1, 25, 3)] = 0.15
        pgm_function48[(1, 25, 4)] = 0.15
        pgm_function48[(1, 26, 1)] = 0.15
        pgm_function48[(1, 26, 2)] = 0.15
        pgm_function48[(1, 26, 3)] = 0.15
        pgm_function48[(1, 26, 4)] = 0.15
        pgm_function48[(1, 27, 1)] = 0.15
        pgm_function48[(1, 27, 2)] = 0.15
        pgm_function48[(1, 27, 3)] = 0.15
        pgm_function48[(1, 27, 4)] = 0.15
        pgm_function48[(1, 28, 1)] = 0.15
        pgm_function48[(1, 28, 2)] = 0.15
        pgm_function48[(1, 28, 3)] = 0.15
        pgm_function48[(1, 28, 4)] = 0.15
        pgm_function48[(1, 29, 1)] = 0.15
        pgm_function48[(1, 29, 2)] = 0.15
        pgm_function48[(1, 29, 3)] = 0.15
        pgm_function48[(1, 29, 4)] = 0.15
        pgm_function48[(1, 30, 1)] = 0.15
        pgm_function48[(1, 30, 2)] = 0.15
        pgm_function48[(1, 30, 3)] = 0.15
        pgm_function48[(1, 30, 4)] = 0.15
        pgm_function48[(1, 31, 1)] = 0.15
        pgm_function48[(1, 31, 2)] = 0.15
        pgm_function48[(1, 31, 3)] = 0.15
        pgm_function48[(1, 31, 4)] = 0.15
        pgm_function48[(1, 32, 1)] = 0.15
        pgm_function48[(1, 32, 2)] = 0.15
        pgm_function48[(1, 32, 3)] = 0.15
        pgm_function48[(1, 32, 4)] = 0.15
        pgm_function48[(1, 33, 1)] = 0.15
        pgm_function48[(1, 33, 2)] = 0.15
        pgm_function48[(1, 33, 3)] = 0.15
        pgm_function48[(1, 33, 4)] = 0.15
        pgm_function48[(1, 34, 1)] = 0.05
        pgm_function48[(1, 34, 2)] = 0.05
        pgm_function48[(1, 34, 3)] = 0.05
        pgm_function48[(1, 34, 4)] = 0.05
        pgm_function48[(1, 35, 1)] = 0.05
        pgm_function48[(1, 35, 2)] = 0.05
        pgm_function48[(1, 35, 3)] = 0.05
        pgm_function48[(1, 35, 4)] = 0.05
        pgm_function48[(1, 36, 1)] = 0.05
        pgm_function48[(1, 36, 2)] = 0.05
        pgm_function48[(1, 36, 3)] = 0.05
        pgm_function48[(1, 36, 4)] = 0.05
        pgm_function48[(1, 37, 1)] = 0.05
        pgm_function48[(1, 37, 2)] = 0.05
        pgm_function48[(1, 37, 3)] = 0.05
        pgm_function48[(1, 37, 4)] = 0.05
        pgm_function48[(1, 38, 1)] = 0.01
        pgm_function48[(1, 38, 2)] = 0.01
        pgm_function48[(1, 38, 3)] = 0.01
        pgm_function48[(1, 38, 4)] = 0.01
        pgm_function48[(1, 39, 1)] = 0.01
        pgm_function48[(1, 39, 2)] = 0.01
        pgm_function48[(1, 39, 3)] = 0.01
        pgm_function48[(1, 39, 4)] = 0.01
        pgm_function48[(1, 40, 1)] = 0.05
        pgm_function48[(1, 40, 2)] = 0.05
        pgm_function48[(1, 40, 3)] = 0.05
        pgm_function48[(1, 40, 4)] = 0.05
        pgm_function48[(1, 41, 1)] = 0.05
        pgm_function48[(1, 41, 2)] = 0.05
        pgm_function48[(1, 41, 3)] = 0.05
        pgm_function48[(1, 41, 4)] = 0.05
        pgm_function48[(1, 42, 1)] = 0.05
        pgm_function48[(1, 42, 2)] = 0.05
        pgm_function48[(1, 42, 3)] = 0.05
        pgm_function48[(1, 42, 4)] = 0.05
        pgm_function48[(1, 43, 1)] = 0.05
        pgm_function48[(1, 43, 2)] = 0.05
        pgm_function48[(1, 43, 3)] = 0.05
        pgm_function48[(1, 43, 4)] = 0.05
        pgm_function48[(1, 44, 1)] = 0.01
        pgm_function48[(1, 44, 2)] = 0.01
        pgm_function48[(1, 44, 3)] = 0.01
        pgm_function48[(1, 44, 4)] = 0.01
        pgm_function48[(1, 45, 1)] = 0.051
        pgm_function48[(1, 45, 2)] = 0.051
        pgm_function48[(1, 45, 3)] = 0.051
        pgm_function48[(1, 45, 4)] = 0.051
        pgm_function48[(1, 46, 1)] = 0.051
        pgm_function48[(1, 46, 2)] = 0.051
        pgm_function48[(1, 46, 3)] = 0.051
        pgm_function48[(1, 46, 4)] = 0.051
        pgm_function48[(1, 47, 1)] = 0.1
        pgm_function48[(1, 47, 2)] = 0.1
        pgm_function48[(1, 47, 3)] = 0.1
        pgm_function48[(1, 47, 4)] = 0.1
        pgm_function48[(1, 48, 1)] = 0.97
        pgm_function48[(1, 48, 2)] = 0.97
        pgm_function48[(1, 48, 3)] = 0.97
        pgm_function48[(1, 48, 4)] = 0.97
        pgm_function48[(1, 49, 1)] = 0.05
        pgm_function48[(1, 49, 2)] = 0.05
        pgm_function48[(1, 49, 3)] = 0.05
        pgm_function48[(1, 49, 4)] = 0.05
        pgm_function48[(1, 50, 1)] = 0.051
        pgm_function48[(1, 50, 2)] = 0.051
        pgm_function48[(1, 50, 3)] = 0.051
        pgm_function48[(1, 50, 4)] = 0.051
        pgm_function48[(1, 51, 1)] = 0.04
        pgm_function48[(1, 51, 2)] = 0.04
        pgm_function48[(1, 51, 3)] = 0.04
        pgm_function48[(1, 51, 4)] = 0.04
        pgm_function48[(1, 52, 1)] = 0.01
        pgm_function48[(1, 52, 2)] = 0.01
        pgm_function48[(1, 52, 3)] = 0.01
        pgm_function48[(1, 52, 4)] = 0.01
        pgm_function48[(1, 53, 1)] = 0.44
        pgm_function48[(1, 53, 2)] = 0.44
        pgm_function48[(1, 53, 3)] = 0.44
        pgm_function48[(1, 53, 4)] = 0.44
        pgm_function48[(1, 54, 1)] = 0.1
        pgm_function48[(1, 54, 2)] = 0.1
        pgm_function48[(1, 54, 3)] = 0.1
        pgm_function48[(1, 54, 4)] = 0.1
        pgm_function48[(1, 55, 1)] = 0.3
        pgm_function48[(1, 55, 2)] = 0.3
        pgm_function48[(1, 55, 3)] = 0.3
        pgm_function48[(1, 55, 4)] = 0.3
        pgm_function48[(1, 56, 1)] = 0.05
        pgm_function48[(1, 56, 2)] = 0.05
        pgm_function48[(1, 56, 3)] = 0.05
        pgm_function48[(1, 56, 4)] = 0.05
        pgm_function48[(1, 57, 1)] = 0.05
        pgm_function48[(1, 57, 2)] = 0.05
        pgm_function48[(1, 57, 3)] = 0.05
        pgm_function48[(1, 57, 4)] = 0.05
        pgm_function48[(1, 58, 1)] = 0.01
        pgm_function48[(1, 58, 2)] = 0.01
        pgm_function48[(1, 58, 3)] = 0.01
        pgm_function48[(1, 58, 4)] = 0.01
        pgm_function48[(1, 59, 1)] = 0.1
        pgm_function48[(1, 59, 2)] = 0.1
        pgm_function48[(1, 59, 3)] = 0.1
        pgm_function48[(1, 59, 4)] = 0.1
        pgm_function48[(1, 60, 1)] = 0.3
        pgm_function48[(1, 60, 2)] = 0.3
        pgm_function48[(1, 60, 3)] = 0.3
        pgm_function48[(1, 60, 4)] = 0.3
        pgm_function48[(1, 61, 1)] = 0.1
        pgm_function48[(1, 61, 2)] = 0.1
        pgm_function48[(1, 61, 3)] = 0.1
        pgm_function48[(1, 61, 4)] = 0.1
        pgm_function48[(1, 62, 1)] = 0.051
        pgm_function48[(1, 62, 2)] = 0.051
        pgm_function48[(1, 62, 3)] = 0.051
        pgm_function48[(1, 62, 4)] = 0.051
        pgm_function48[(1, 63, 1)] = 0.3
        pgm_function48[(1, 63, 2)] = 0.3
        pgm_function48[(1, 63, 3)] = 0.3
        pgm_function48[(1, 63, 4)] = 0.3
        pgm_function48[(1, 64, 1)] = 0.05
        pgm_function48[(1, 64, 2)] = 0.05
        pgm_function48[(1, 64, 3)] = 0.05
        pgm_function48[(1, 64, 4)] = 0.05
        pgm_function48[(1, 65, 1)] = 0.05
        pgm_function48[(1, 65, 2)] = 0.05
        pgm_function48[(1, 65, 3)] = 0.05
        pgm_function48[(1, 65, 4)] = 0.05
        pgm_function48[(1, 66, 1)] = 0.1
        pgm_function48[(1, 66, 2)] = 0.1
        pgm_function48[(1, 66, 3)] = 0.1
        pgm_function48[(1, 66, 4)] = 0.1
        pgm_function48[(1, 67, 1)] = 0.1
        pgm_function48[(1, 67, 2)] = 0.1
        pgm_function48[(1, 67, 3)] = 0.1
        pgm_function48[(1, 67, 4)] = 0.1
        pgm_function48[(1, 68, 1)] = 0.3
        pgm_function48[(1, 68, 2)] = 0.3
        pgm_function48[(1, 68, 3)] = 0.3
        pgm_function48[(1, 68, 4)] = 0.3
        pgm_function48[(1, 69, 1)] = 0.1
        pgm_function48[(1, 69, 2)] = 0.1
        pgm_function48[(1, 69, 3)] = 0.1
        pgm_function48[(1, 69, 4)] = 0.1
        pgm_function48[(1, 70, 1)] = 0.1
        pgm_function48[(1, 70, 2)] = 0.1
        pgm_function48[(1, 70, 3)] = 0.1
        pgm_function48[(1, 70, 4)] = 0.1
        pgm_function48[(1, 71, 1)] = 0.1
        pgm_function48[(1, 71, 2)] = 0.1
        pgm_function48[(1, 71, 3)] = 0.1
        pgm_function48[(1, 71, 4)] = 0.1
        pgm_function48[(1, 72, 1)] = 0.1
        pgm_function48[(1, 72, 2)] = 0.1
        pgm_function48[(1, 72, 3)] = 0.1
        pgm_function48[(1, 72, 4)] = 0.1
        pgm_function48[(1, 73, 1)] = 0.1
        pgm_function48[(1, 73, 2)] = 0.1
        pgm_function48[(1, 73, 3)] = 0.1
        pgm_function48[(1, 73, 4)] = 0.1
        pgm_function48[(1, 74, 1)] = 0.04
        pgm_function48[(1, 74, 2)] = 0.04
        pgm_function48[(1, 74, 3)] = 0.04
        pgm_function48[(1, 74, 4)] = 0.04
        pgm_function48[(1, 75, 1)] = 0.05
        pgm_function48[(1, 75, 2)] = 0.05
        pgm_function48[(1, 75, 3)] = 0.05
        pgm_function48[(1, 75, 4)] = 0.05
        pgm_function48[(2, 0, 1)] = 0.4
        pgm_function48[(2, 0, 2)] = 0.4
        pgm_function48[(2, 0, 3)] = 0.4
        pgm_function48[(2, 0, 4)] = 0.4
        pgm_function48[(2, 1, 1)] = 0.739
        pgm_function48[(2, 1, 2)] = 0.739
        pgm_function48[(2, 1, 3)] = 0.739
        pgm_function48[(2, 1, 4)] = 0.739
        pgm_function48[(2, 2, 1)] = 0.4
        pgm_function48[(2, 2, 2)] = 0.4
        pgm_function48[(2, 2, 3)] = 0.4
        pgm_function48[(2, 2, 4)] = 0.4
        pgm_function48[(2, 3, 1)] = 0.4
        pgm_function48[(2, 3, 2)] = 0.4
        pgm_function48[(2, 3, 3)] = 0.4
        pgm_function48[(2, 3, 4)] = 0.4
        pgm_function48[(2, 4, 1)] = 0.4
        pgm_function48[(2, 4, 2)] = 0.4
        pgm_function48[(2, 4, 3)] = 0.4
        pgm_function48[(2, 4, 4)] = 0.4
        pgm_function48[(2, 5, 1)] = 0.4
        pgm_function48[(2, 5, 2)] = 0.4
        pgm_function48[(2, 5, 3)] = 0.4
        pgm_function48[(2, 5, 4)] = 0.4
        pgm_function48[(2, 6, 1)] = 0.4
        pgm_function48[(2, 6, 2)] = 0.4
        pgm_function48[(2, 6, 3)] = 0.4
        pgm_function48[(2, 6, 4)] = 0.4
        pgm_function48[(2, 7, 1)] = 0.4
        pgm_function48[(2, 7, 2)] = 0.4
        pgm_function48[(2, 7, 3)] = 0.4
        pgm_function48[(2, 7, 4)] = 0.4
        pgm_function48[(2, 8, 1)] = 0.4
        pgm_function48[(2, 8, 2)] = 0.4
        pgm_function48[(2, 8, 3)] = 0.4
        pgm_function48[(2, 8, 4)] = 0.4
        pgm_function48[(2, 9, 1)] = 0.4
        pgm_function48[(2, 9, 2)] = 0.4
        pgm_function48[(2, 9, 3)] = 0.4
        pgm_function48[(2, 9, 4)] = 0.4
        pgm_function48[(2, 10, 1)] = 0.4
        pgm_function48[(2, 10, 2)] = 0.4
        pgm_function48[(2, 10, 3)] = 0.4
        pgm_function48[(2, 10, 4)] = 0.4
        pgm_function48[(2, 11, 1)] = 0.4
        pgm_function48[(2, 11, 2)] = 0.4
        pgm_function48[(2, 11, 3)] = 0.4
        pgm_function48[(2, 11, 4)] = 0.4
        pgm_function48[(2, 12, 1)] = 0.4
        pgm_function48[(2, 12, 2)] = 0.4
        pgm_function48[(2, 12, 3)] = 0.4
        pgm_function48[(2, 12, 4)] = 0.4
        pgm_function48[(2, 13, 1)] = 0.01
        pgm_function48[(2, 13, 2)] = 0.01
        pgm_function48[(2, 13, 3)] = 0.01
        pgm_function48[(2, 13, 4)] = 0.01
        pgm_function48[(2, 14, 1)] = 0.4
        pgm_function48[(2, 14, 2)] = 0.4
        pgm_function48[(2, 14, 3)] = 0.4
        pgm_function48[(2, 14, 4)] = 0.4
        pgm_function48[(2, 15, 1)] = 0.4
        pgm_function48[(2, 15, 2)] = 0.4
        pgm_function48[(2, 15, 3)] = 0.4
        pgm_function48[(2, 15, 4)] = 0.4
        pgm_function48[(2, 16, 1)] = 0.4
        pgm_function48[(2, 16, 2)] = 0.4
        pgm_function48[(2, 16, 3)] = 0.4
        pgm_function48[(2, 16, 4)] = 0.4
        pgm_function48[(2, 17, 1)] = 0.4
        pgm_function48[(2, 17, 2)] = 0.4
        pgm_function48[(2, 17, 3)] = 0.4
        pgm_function48[(2, 17, 4)] = 0.4
        pgm_function48[(2, 18, 1)] = 0.4
        pgm_function48[(2, 18, 2)] = 0.4
        pgm_function48[(2, 18, 3)] = 0.4
        pgm_function48[(2, 18, 4)] = 0.4
        pgm_function48[(2, 19, 1)] = 0.4
        pgm_function48[(2, 19, 2)] = 0.4
        pgm_function48[(2, 19, 3)] = 0.4
        pgm_function48[(2, 19, 4)] = 0.4
        pgm_function48[(2, 20, 1)] = 0.4
        pgm_function48[(2, 20, 2)] = 0.4
        pgm_function48[(2, 20, 3)] = 0.4
        pgm_function48[(2, 20, 4)] = 0.4
        pgm_function48[(2, 21, 1)] = 0.4
        pgm_function48[(2, 21, 2)] = 0.4
        pgm_function48[(2, 21, 3)] = 0.4
        pgm_function48[(2, 21, 4)] = 0.4
        pgm_function48[(2, 22, 1)] = 0.4
        pgm_function48[(2, 22, 2)] = 0.4
        pgm_function48[(2, 22, 3)] = 0.4
        pgm_function48[(2, 22, 4)] = 0.4
        pgm_function48[(2, 23, 1)] = 0.4
        pgm_function48[(2, 23, 2)] = 0.4
        pgm_function48[(2, 23, 3)] = 0.4
        pgm_function48[(2, 23, 4)] = 0.4
        pgm_function48[(2, 24, 1)] = 0.4
        pgm_function48[(2, 24, 2)] = 0.4
        pgm_function48[(2, 24, 3)] = 0.4
        pgm_function48[(2, 24, 4)] = 0.4
        pgm_function48[(2, 25, 1)] = 0.25
        pgm_function48[(2, 25, 2)] = 0.25
        pgm_function48[(2, 25, 3)] = 0.25
        pgm_function48[(2, 25, 4)] = 0.25
        pgm_function48[(2, 26, 1)] = 0.25
        pgm_function48[(2, 26, 2)] = 0.25
        pgm_function48[(2, 26, 3)] = 0.25
        pgm_function48[(2, 26, 4)] = 0.25
        pgm_function48[(2, 27, 1)] = 0.25
        pgm_function48[(2, 27, 2)] = 0.25
        pgm_function48[(2, 27, 3)] = 0.25
        pgm_function48[(2, 27, 4)] = 0.25
        pgm_function48[(2, 28, 1)] = 0.25
        pgm_function48[(2, 28, 2)] = 0.25
        pgm_function48[(2, 28, 3)] = 0.25
        pgm_function48[(2, 28, 4)] = 0.25
        pgm_function48[(2, 29, 1)] = 0.25
        pgm_function48[(2, 29, 2)] = 0.25
        pgm_function48[(2, 29, 3)] = 0.25
        pgm_function48[(2, 29, 4)] = 0.25
        pgm_function48[(2, 30, 1)] = 0.25
        pgm_function48[(2, 30, 2)] = 0.25
        pgm_function48[(2, 30, 3)] = 0.25
        pgm_function48[(2, 30, 4)] = 0.25
        pgm_function48[(2, 31, 1)] = 0.25
        pgm_function48[(2, 31, 2)] = 0.25
        pgm_function48[(2, 31, 3)] = 0.25
        pgm_function48[(2, 31, 4)] = 0.25
        pgm_function48[(2, 32, 1)] = 0.25
        pgm_function48[(2, 32, 2)] = 0.25
        pgm_function48[(2, 32, 3)] = 0.25
        pgm_function48[(2, 32, 4)] = 0.25
        pgm_function48[(2, 33, 1)] = 0.25
        pgm_function48[(2, 33, 2)] = 0.25
        pgm_function48[(2, 33, 3)] = 0.25
        pgm_function48[(2, 33, 4)] = 0.25
        pgm_function48[(2, 34, 1)] = 0.01
        pgm_function48[(2, 34, 2)] = 0.01
        pgm_function48[(2, 34, 3)] = 0.01
        pgm_function48[(2, 34, 4)] = 0.01
        pgm_function48[(2, 35, 1)] = 0.01
        pgm_function48[(2, 35, 2)] = 0.01
        pgm_function48[(2, 35, 3)] = 0.01
        pgm_function48[(2, 35, 4)] = 0.01
        pgm_function48[(2, 36, 1)] = 0.01
        pgm_function48[(2, 36, 2)] = 0.01
        pgm_function48[(2, 36, 3)] = 0.01
        pgm_function48[(2, 36, 4)] = 0.01
        pgm_function48[(2, 37, 1)] = 0.01
        pgm_function48[(2, 37, 2)] = 0.01
        pgm_function48[(2, 37, 3)] = 0.01
        pgm_function48[(2, 37, 4)] = 0.01
        pgm_function48[(2, 38, 1)] = 0.96
        pgm_function48[(2, 38, 2)] = 0.96
        pgm_function48[(2, 38, 3)] = 0.96
        pgm_function48[(2, 38, 4)] = 0.96
        pgm_function48[(2, 39, 1)] = 0.96
        pgm_function48[(2, 39, 2)] = 0.96
        pgm_function48[(2, 39, 3)] = 0.96
        pgm_function48[(2, 39, 4)] = 0.96
        pgm_function48[(2, 40, 1)] = 0.01
        pgm_function48[(2, 40, 2)] = 0.01
        pgm_function48[(2, 40, 3)] = 0.01
        pgm_function48[(2, 40, 4)] = 0.01
        pgm_function48[(2, 41, 1)] = 0.01
        pgm_function48[(2, 41, 2)] = 0.01
        pgm_function48[(2, 41, 3)] = 0.01
        pgm_function48[(2, 41, 4)] = 0.01
        pgm_function48[(2, 42, 1)] = 0.01
        pgm_function48[(2, 42, 2)] = 0.01
        pgm_function48[(2, 42, 3)] = 0.01
        pgm_function48[(2, 42, 4)] = 0.01
        pgm_function48[(2, 43, 1)] = 0.01
        pgm_function48[(2, 43, 2)] = 0.01
        pgm_function48[(2, 43, 3)] = 0.01
        pgm_function48[(2, 43, 4)] = 0.01
        pgm_function48[(2, 44, 1)] = 0.93
        pgm_function48[(2, 44, 2)] = 0.93
        pgm_function48[(2, 44, 3)] = 0.93
        pgm_function48[(2, 44, 4)] = 0.93
        pgm_function48[(2, 45, 1)] = 0.739
        pgm_function48[(2, 45, 2)] = 0.739
        pgm_function48[(2, 45, 3)] = 0.739
        pgm_function48[(2, 45, 4)] = 0.739
        pgm_function48[(2, 46, 1)] = 0.739
        pgm_function48[(2, 46, 2)] = 0.739
        pgm_function48[(2, 46, 3)] = 0.739
        pgm_function48[(2, 46, 4)] = 0.739
        pgm_function48[(2, 47, 1)] = 0.59
        pgm_function48[(2, 47, 2)] = 0.59
        pgm_function48[(2, 47, 3)] = 0.59
        pgm_function48[(2, 47, 4)] = 0.59
        pgm_function48[(2, 49, 1)] = 0.01
        pgm_function48[(2, 49, 2)] = 0.01
        pgm_function48[(2, 49, 3)] = 0.01
        pgm_function48[(2, 49, 4)] = 0.01
        pgm_function48[(2, 50, 1)] = 0.739
        pgm_function48[(2, 50, 2)] = 0.739
        pgm_function48[(2, 50, 3)] = 0.739
        pgm_function48[(2, 50, 4)] = 0.739
        pgm_function48[(2, 51, 1)] = 0.76
        pgm_function48[(2, 51, 2)] = 0.76
        pgm_function48[(2, 51, 3)] = 0.76
        pgm_function48[(2, 51, 4)] = 0.76
        pgm_function48[(2, 52, 1)] = 0.93
        pgm_function48[(2, 52, 2)] = 0.93
        pgm_function48[(2, 52, 3)] = 0.93
        pgm_function48[(2, 52, 4)] = 0.93
        pgm_function48[(2, 53, 1)] = 0.25
        pgm_function48[(2, 53, 2)] = 0.25
        pgm_function48[(2, 53, 3)] = 0.25
        pgm_function48[(2, 53, 4)] = 0.25
        pgm_function48[(2, 54, 1)] = 0.35
        pgm_function48[(2, 54, 2)] = 0.35
        pgm_function48[(2, 54, 3)] = 0.35
        pgm_function48[(2, 54, 4)] = 0.35
        pgm_function48[(2, 55, 1)] = 0.3
        pgm_function48[(2, 55, 2)] = 0.3
        pgm_function48[(2, 55, 3)] = 0.3
        pgm_function48[(2, 55, 4)] = 0.3
        pgm_function48[(2, 56, 1)] = 0.4
        pgm_function48[(2, 56, 2)] = 0.4
        pgm_function48[(2, 56, 3)] = 0.4
        pgm_function48[(2, 56, 4)] = 0.4
        pgm_function48[(2, 57, 1)] = 0.4
        pgm_function48[(2, 57, 2)] = 0.4
        pgm_function48[(2, 57, 3)] = 0.4
        pgm_function48[(2, 57, 4)] = 0.4
        pgm_function48[(2, 58, 1)] = 0.96
        pgm_function48[(2, 58, 2)] = 0.96
        pgm_function48[(2, 58, 3)] = 0.96
        pgm_function48[(2, 58, 4)] = 0.96
        pgm_function48[(2, 59, 1)] = 0.4
        pgm_function48[(2, 59, 2)] = 0.4
        pgm_function48[(2, 59, 3)] = 0.4
        pgm_function48[(2, 59, 4)] = 0.4
        pgm_function48[(2, 60, 1)] = 0.3
        pgm_function48[(2, 60, 2)] = 0.3
        pgm_function48[(2, 60, 3)] = 0.3
        pgm_function48[(2, 60, 4)] = 0.3
        pgm_function48[(2, 61, 1)] = 0.4
        pgm_function48[(2, 61, 2)] = 0.4
        pgm_function48[(2, 61, 3)] = 0.4
        pgm_function48[(2, 61, 4)] = 0.4
        pgm_function48[(2, 62, 1)] = 0.739
        pgm_function48[(2, 62, 2)] = 0.739
        pgm_function48[(2, 62, 3)] = 0.739
        pgm_function48[(2, 62, 4)] = 0.739
        pgm_function48[(2, 63, 1)] = 0.3
        pgm_function48[(2, 63, 2)] = 0.3
        pgm_function48[(2, 63, 3)] = 0.3
        pgm_function48[(2, 63, 4)] = 0.3
        pgm_function48[(2, 64, 1)] = 0.4
        pgm_function48[(2, 64, 2)] = 0.4
        pgm_function48[(2, 64, 3)] = 0.4
        pgm_function48[(2, 64, 4)] = 0.4
        pgm_function48[(2, 65, 1)] = 0.4
        pgm_function48[(2, 65, 2)] = 0.4
        pgm_function48[(2, 65, 3)] = 0.4
        pgm_function48[(2, 65, 4)] = 0.4
        pgm_function48[(2, 66, 1)] = 0.4
        pgm_function48[(2, 66, 2)] = 0.4
        pgm_function48[(2, 66, 3)] = 0.4
        pgm_function48[(2, 66, 4)] = 0.4
        pgm_function48[(2, 67, 1)] = 0.4
        pgm_function48[(2, 67, 2)] = 0.4
        pgm_function48[(2, 67, 3)] = 0.4
        pgm_function48[(2, 67, 4)] = 0.4
        pgm_function48[(2, 68, 1)] = 0.3
        pgm_function48[(2, 68, 2)] = 0.3
        pgm_function48[(2, 68, 3)] = 0.3
        pgm_function48[(2, 68, 4)] = 0.3
        pgm_function48[(2, 69, 1)] = 0.4
        pgm_function48[(2, 69, 2)] = 0.4
        pgm_function48[(2, 69, 3)] = 0.4
        pgm_function48[(2, 69, 4)] = 0.4
        pgm_function48[(2, 70, 1)] = 0.4
        pgm_function48[(2, 70, 2)] = 0.4
        pgm_function48[(2, 70, 3)] = 0.4
        pgm_function48[(2, 70, 4)] = 0.4
        pgm_function48[(2, 71, 1)] = 0.4
        pgm_function48[(2, 71, 2)] = 0.4
        pgm_function48[(2, 71, 3)] = 0.4
        pgm_function48[(2, 71, 4)] = 0.4
        pgm_function48[(2, 72, 1)] = 0.4
        pgm_function48[(2, 72, 2)] = 0.4
        pgm_function48[(2, 72, 3)] = 0.4
        pgm_function48[(2, 72, 4)] = 0.4
        pgm_function48[(2, 73, 1)] = 0.4
        pgm_function48[(2, 73, 2)] = 0.4
        pgm_function48[(2, 73, 3)] = 0.4
        pgm_function48[(2, 73, 4)] = 0.4
        pgm_function48[(2, 74, 1)] = 0.76
        pgm_function48[(2, 74, 2)] = 0.76
        pgm_function48[(2, 74, 3)] = 0.76
        pgm_function48[(2, 74, 4)] = 0.76
        pgm_function48[(2, 75, 1)] = 0.01
        pgm_function48[(2, 75, 2)] = 0.01
        pgm_function48[(2, 75, 3)] = 0.01
        pgm_function48[(2, 75, 4)] = 0.01
        pgm_function48[(3, 0, 1)] = 0.49
        pgm_function48[(3, 0, 2)] = 0.49
        pgm_function48[(3, 0, 3)] = 0.49
        pgm_function48[(3, 0, 4)] = 0.49
        pgm_function48[(3, 1, 1)] = 0.2
        pgm_function48[(3, 1, 2)] = 0.2
        pgm_function48[(3, 1, 3)] = 0.2
        pgm_function48[(3, 1, 4)] = 0.2
        pgm_function48[(3, 2, 1)] = 0.49
        pgm_function48[(3, 2, 2)] = 0.49
        pgm_function48[(3, 2, 3)] = 0.49
        pgm_function48[(3, 2, 4)] = 0.49
        pgm_function48[(3, 3, 1)] = 0.49
        pgm_function48[(3, 3, 2)] = 0.49
        pgm_function48[(3, 3, 3)] = 0.49
        pgm_function48[(3, 3, 4)] = 0.49
        pgm_function48[(3, 4, 1)] = 0.49
        pgm_function48[(3, 4, 2)] = 0.49
        pgm_function48[(3, 4, 3)] = 0.49
        pgm_function48[(3, 4, 4)] = 0.49
        pgm_function48[(3, 5, 1)] = 0.49
        pgm_function48[(3, 5, 2)] = 0.49
        pgm_function48[(3, 5, 3)] = 0.49
        pgm_function48[(3, 5, 4)] = 0.49
        pgm_function48[(3, 6, 1)] = 0.49
        pgm_function48[(3, 6, 2)] = 0.49
        pgm_function48[(3, 6, 3)] = 0.49
        pgm_function48[(3, 6, 4)] = 0.49
        pgm_function48[(3, 7, 1)] = 0.49
        pgm_function48[(3, 7, 2)] = 0.49
        pgm_function48[(3, 7, 3)] = 0.49
        pgm_function48[(3, 7, 4)] = 0.49
        pgm_function48[(3, 8, 1)] = 0.49
        pgm_function48[(3, 8, 2)] = 0.49
        pgm_function48[(3, 8, 3)] = 0.49
        pgm_function48[(3, 8, 4)] = 0.49
        pgm_function48[(3, 9, 1)] = 0.49
        pgm_function48[(3, 9, 2)] = 0.49
        pgm_function48[(3, 9, 3)] = 0.49
        pgm_function48[(3, 9, 4)] = 0.49
        pgm_function48[(3, 10, 1)] = 0.49
        pgm_function48[(3, 10, 2)] = 0.49
        pgm_function48[(3, 10, 3)] = 0.49
        pgm_function48[(3, 10, 4)] = 0.49
        pgm_function48[(3, 11, 1)] = 0.49
        pgm_function48[(3, 11, 2)] = 0.49
        pgm_function48[(3, 11, 3)] = 0.49
        pgm_function48[(3, 11, 4)] = 0.49
        pgm_function48[(3, 12, 1)] = 0.49
        pgm_function48[(3, 12, 2)] = 0.49
        pgm_function48[(3, 12, 3)] = 0.49
        pgm_function48[(3, 12, 4)] = 0.49
        pgm_function48[(3, 13, 1)] = 0.93
        pgm_function48[(3, 13, 2)] = 0.93
        pgm_function48[(3, 13, 3)] = 0.93
        pgm_function48[(3, 13, 4)] = 0.93
        pgm_function48[(3, 14, 1)] = 0.49
        pgm_function48[(3, 14, 2)] = 0.49
        pgm_function48[(3, 14, 3)] = 0.49
        pgm_function48[(3, 14, 4)] = 0.49
        pgm_function48[(3, 15, 1)] = 0.49
        pgm_function48[(3, 15, 2)] = 0.49
        pgm_function48[(3, 15, 3)] = 0.49
        pgm_function48[(3, 15, 4)] = 0.49
        pgm_function48[(3, 16, 1)] = 0.49
        pgm_function48[(3, 16, 2)] = 0.49
        pgm_function48[(3, 16, 3)] = 0.49
        pgm_function48[(3, 16, 4)] = 0.49
        pgm_function48[(3, 17, 1)] = 0.49
        pgm_function48[(3, 17, 2)] = 0.49
        pgm_function48[(3, 17, 3)] = 0.49
        pgm_function48[(3, 17, 4)] = 0.49
        pgm_function48[(3, 18, 1)] = 0.49
        pgm_function48[(3, 18, 2)] = 0.49
        pgm_function48[(3, 18, 3)] = 0.49
        pgm_function48[(3, 18, 4)] = 0.49
        pgm_function48[(3, 19, 1)] = 0.49
        pgm_function48[(3, 19, 2)] = 0.49
        pgm_function48[(3, 19, 3)] = 0.49
        pgm_function48[(3, 19, 4)] = 0.49
        pgm_function48[(3, 20, 1)] = 0.49
        pgm_function48[(3, 20, 2)] = 0.49
        pgm_function48[(3, 20, 3)] = 0.49
        pgm_function48[(3, 20, 4)] = 0.49
        pgm_function48[(3, 21, 1)] = 0.49
        pgm_function48[(3, 21, 2)] = 0.49
        pgm_function48[(3, 21, 3)] = 0.49
        pgm_function48[(3, 21, 4)] = 0.49
        pgm_function48[(3, 22, 1)] = 0.49
        pgm_function48[(3, 22, 2)] = 0.49
        pgm_function48[(3, 22, 3)] = 0.49
        pgm_function48[(3, 22, 4)] = 0.49
        pgm_function48[(3, 23, 1)] = 0.49
        pgm_function48[(3, 23, 2)] = 0.49
        pgm_function48[(3, 23, 3)] = 0.49
        pgm_function48[(3, 23, 4)] = 0.49
        pgm_function48[(3, 24, 1)] = 0.49
        pgm_function48[(3, 24, 2)] = 0.49
        pgm_function48[(3, 24, 3)] = 0.49
        pgm_function48[(3, 24, 4)] = 0.49
        pgm_function48[(3, 25, 1)] = 0.59
        pgm_function48[(3, 25, 2)] = 0.59
        pgm_function48[(3, 25, 3)] = 0.59
        pgm_function48[(3, 25, 4)] = 0.59
        pgm_function48[(3, 26, 1)] = 0.59
        pgm_function48[(3, 26, 2)] = 0.59
        pgm_function48[(3, 26, 3)] = 0.59
        pgm_function48[(3, 26, 4)] = 0.59
        pgm_function48[(3, 27, 1)] = 0.59
        pgm_function48[(3, 27, 2)] = 0.59
        pgm_function48[(3, 27, 3)] = 0.59
        pgm_function48[(3, 27, 4)] = 0.59
        pgm_function48[(3, 28, 1)] = 0.59
        pgm_function48[(3, 28, 2)] = 0.59
        pgm_function48[(3, 28, 3)] = 0.59
        pgm_function48[(3, 28, 4)] = 0.59
        pgm_function48[(3, 29, 1)] = 0.59
        pgm_function48[(3, 29, 2)] = 0.59
        pgm_function48[(3, 29, 3)] = 0.59
        pgm_function48[(3, 29, 4)] = 0.59
        pgm_function48[(3, 30, 1)] = 0.59
        pgm_function48[(3, 30, 2)] = 0.59
        pgm_function48[(3, 30, 3)] = 0.59
        pgm_function48[(3, 30, 4)] = 0.59
        pgm_function48[(3, 31, 1)] = 0.59
        pgm_function48[(3, 31, 2)] = 0.59
        pgm_function48[(3, 31, 3)] = 0.59
        pgm_function48[(3, 31, 4)] = 0.59
        pgm_function48[(3, 32, 1)] = 0.59
        pgm_function48[(3, 32, 2)] = 0.59
        pgm_function48[(3, 32, 3)] = 0.59
        pgm_function48[(3, 32, 4)] = 0.59
        pgm_function48[(3, 33, 1)] = 0.59
        pgm_function48[(3, 33, 2)] = 0.59
        pgm_function48[(3, 33, 3)] = 0.59
        pgm_function48[(3, 33, 4)] = 0.59
        pgm_function48[(3, 34, 1)] = 0.93
        pgm_function48[(3, 34, 2)] = 0.93
        pgm_function48[(3, 34, 3)] = 0.93
        pgm_function48[(3, 34, 4)] = 0.93
        pgm_function48[(3, 35, 1)] = 0.93
        pgm_function48[(3, 35, 2)] = 0.93
        pgm_function48[(3, 35, 3)] = 0.93
        pgm_function48[(3, 35, 4)] = 0.93
        pgm_function48[(3, 36, 1)] = 0.93
        pgm_function48[(3, 36, 2)] = 0.93
        pgm_function48[(3, 36, 3)] = 0.93
        pgm_function48[(3, 36, 4)] = 0.93
        pgm_function48[(3, 37, 1)] = 0.93
        pgm_function48[(3, 37, 2)] = 0.93
        pgm_function48[(3, 37, 3)] = 0.93
        pgm_function48[(3, 37, 4)] = 0.93
        pgm_function48[(3, 38, 1)] = 0.02
        pgm_function48[(3, 38, 2)] = 0.02
        pgm_function48[(3, 38, 3)] = 0.02
        pgm_function48[(3, 38, 4)] = 0.02
        pgm_function48[(3, 39, 1)] = 0.02
        pgm_function48[(3, 39, 2)] = 0.02
        pgm_function48[(3, 39, 3)] = 0.02
        pgm_function48[(3, 39, 4)] = 0.02
        pgm_function48[(3, 40, 1)] = 0.93
        pgm_function48[(3, 40, 2)] = 0.93
        pgm_function48[(3, 40, 3)] = 0.93
        pgm_function48[(3, 40, 4)] = 0.93
        pgm_function48[(3, 41, 1)] = 0.93
        pgm_function48[(3, 41, 2)] = 0.93
        pgm_function48[(3, 41, 3)] = 0.93
        pgm_function48[(3, 41, 4)] = 0.93
        pgm_function48[(3, 42, 1)] = 0.93
        pgm_function48[(3, 42, 2)] = 0.93
        pgm_function48[(3, 42, 3)] = 0.93
        pgm_function48[(3, 42, 4)] = 0.93
        pgm_function48[(3, 43, 1)] = 0.93
        pgm_function48[(3, 43, 2)] = 0.93
        pgm_function48[(3, 43, 3)] = 0.93
        pgm_function48[(3, 43, 4)] = 0.93
        pgm_function48[(3, 44, 1)] = 0.05
        pgm_function48[(3, 44, 2)] = 0.05
        pgm_function48[(3, 44, 3)] = 0.05
        pgm_function48[(3, 44, 4)] = 0.05
        pgm_function48[(3, 45, 1)] = 0.2
        pgm_function48[(3, 45, 2)] = 0.2
        pgm_function48[(3, 45, 3)] = 0.2
        pgm_function48[(3, 45, 4)] = 0.2
        pgm_function48[(3, 46, 1)] = 0.2
        pgm_function48[(3, 46, 2)] = 0.2
        pgm_function48[(3, 46, 3)] = 0.2
        pgm_function48[(3, 46, 4)] = 0.2
        pgm_function48[(3, 47, 1)] = 0.3
        pgm_function48[(3, 47, 2)] = 0.3
        pgm_function48[(3, 47, 3)] = 0.3
        pgm_function48[(3, 47, 4)] = 0.3
        pgm_function48[(3, 48, 1)] = 0.02
        pgm_function48[(3, 48, 2)] = 0.02
        pgm_function48[(3, 48, 3)] = 0.02
        pgm_function48[(3, 48, 4)] = 0.02
        pgm_function48[(3, 49, 1)] = 0.93
        pgm_function48[(3, 49, 2)] = 0.93
        pgm_function48[(3, 49, 3)] = 0.93
        pgm_function48[(3, 49, 4)] = 0.93
        pgm_function48[(3, 50, 1)] = 0.2
        pgm_function48[(3, 50, 2)] = 0.2
        pgm_function48[(3, 50, 3)] = 0.2
        pgm_function48[(3, 50, 4)] = 0.2
        pgm_function48[(3, 51, 1)] = 0.19
        pgm_function48[(3, 51, 2)] = 0.19
        pgm_function48[(3, 51, 3)] = 0.19
        pgm_function48[(3, 51, 4)] = 0.19
        pgm_function48[(3, 52, 1)] = 0.05
        pgm_function48[(3, 52, 2)] = 0.05
        pgm_function48[(3, 52, 3)] = 0.05
        pgm_function48[(3, 52, 4)] = 0.05
        pgm_function48[(3, 53, 1)] = 0.3
        pgm_function48[(3, 53, 2)] = 0.3
        pgm_function48[(3, 53, 3)] = 0.3
        pgm_function48[(3, 53, 4)] = 0.3
        pgm_function48[(3, 54, 1)] = 0.54
        pgm_function48[(3, 54, 2)] = 0.54
        pgm_function48[(3, 54, 3)] = 0.54
        pgm_function48[(3, 54, 4)] = 0.54
        pgm_function48[(3, 55, 1)] = 0.39
        pgm_function48[(3, 55, 2)] = 0.39
        pgm_function48[(3, 55, 3)] = 0.39
        pgm_function48[(3, 55, 4)] = 0.39
        pgm_function48[(3, 56, 1)] = 0.54
        pgm_function48[(3, 56, 2)] = 0.54
        pgm_function48[(3, 56, 3)] = 0.54
        pgm_function48[(3, 56, 4)] = 0.54
        pgm_function48[(3, 57, 1)] = 0.54
        pgm_function48[(3, 57, 2)] = 0.54
        pgm_function48[(3, 57, 3)] = 0.54
        pgm_function48[(3, 57, 4)] = 0.54
        pgm_function48[(3, 58, 1)] = 0.02
        pgm_function48[(3, 58, 2)] = 0.02
        pgm_function48[(3, 58, 3)] = 0.02
        pgm_function48[(3, 58, 4)] = 0.02
        pgm_function48[(3, 59, 1)] = 0.49
        pgm_function48[(3, 59, 2)] = 0.49
        pgm_function48[(3, 59, 3)] = 0.49
        pgm_function48[(3, 59, 4)] = 0.49
        pgm_function48[(3, 60, 1)] = 0.39
        pgm_function48[(3, 60, 2)] = 0.39
        pgm_function48[(3, 60, 3)] = 0.39
        pgm_function48[(3, 60, 4)] = 0.39
        pgm_function48[(3, 61, 1)] = 0.49
        pgm_function48[(3, 61, 2)] = 0.49
        pgm_function48[(3, 61, 3)] = 0.49
        pgm_function48[(3, 61, 4)] = 0.49
        pgm_function48[(3, 62, 1)] = 0.2
        pgm_function48[(3, 62, 2)] = 0.2
        pgm_function48[(3, 62, 3)] = 0.2
        pgm_function48[(3, 62, 4)] = 0.2
        pgm_function48[(3, 63, 1)] = 0.39
        pgm_function48[(3, 63, 2)] = 0.39
        pgm_function48[(3, 63, 3)] = 0.39
        pgm_function48[(3, 63, 4)] = 0.39
        pgm_function48[(3, 64, 1)] = 0.54
        pgm_function48[(3, 64, 2)] = 0.54
        pgm_function48[(3, 64, 3)] = 0.54
        pgm_function48[(3, 64, 4)] = 0.54
        pgm_function48[(3, 65, 1)] = 0.54
        pgm_function48[(3, 65, 2)] = 0.54
        pgm_function48[(3, 65, 3)] = 0.54
        pgm_function48[(3, 65, 4)] = 0.54
        pgm_function48[(3, 66, 1)] = 0.49
        pgm_function48[(3, 66, 2)] = 0.49
        pgm_function48[(3, 66, 3)] = 0.49
        pgm_function48[(3, 66, 4)] = 0.49
        pgm_function48[(3, 67, 1)] = 0.49
        pgm_function48[(3, 67, 2)] = 0.49
        pgm_function48[(3, 67, 3)] = 0.49
        pgm_function48[(3, 67, 4)] = 0.49
        pgm_function48[(3, 68, 1)] = 0.39
        pgm_function48[(3, 68, 2)] = 0.39
        pgm_function48[(3, 68, 3)] = 0.39
        pgm_function48[(3, 68, 4)] = 0.39
        pgm_function48[(3, 69, 1)] = 0.49
        pgm_function48[(3, 69, 2)] = 0.49
        pgm_function48[(3, 69, 3)] = 0.49
        pgm_function48[(3, 69, 4)] = 0.49
        pgm_function48[(3, 70, 1)] = 0.49
        pgm_function48[(3, 70, 2)] = 0.49
        pgm_function48[(3, 70, 3)] = 0.49
        pgm_function48[(3, 70, 4)] = 0.49
        pgm_function48[(3, 71, 1)] = 0.49
        pgm_function48[(3, 71, 2)] = 0.49
        pgm_function48[(3, 71, 3)] = 0.49
        pgm_function48[(3, 71, 4)] = 0.49
        pgm_function48[(3, 72, 1)] = 0.49
        pgm_function48[(3, 72, 2)] = 0.49
        pgm_function48[(3, 72, 3)] = 0.49
        pgm_function48[(3, 72, 4)] = 0.49
        pgm_function48[(3, 73, 1)] = 0.49
        pgm_function48[(3, 73, 2)] = 0.49
        pgm_function48[(3, 73, 3)] = 0.49
        pgm_function48[(3, 73, 4)] = 0.49
        pgm_function48[(3, 74, 1)] = 0.19
        pgm_function48[(3, 74, 2)] = 0.19
        pgm_function48[(3, 74, 3)] = 0.19
        pgm_function48[(3, 74, 4)] = 0.19
        pgm_function48[(3, 75, 1)] = 0.93
        pgm_function48[(3, 75, 2)] = 0.93
        pgm_function48[(3, 75, 3)] = 0.93
        pgm_function48[(3, 75, 4)] = 0.93
        pgm_function48[(4, 0, 1)] = 0.01
        pgm_function48[(4, 0, 2)] = 0.01
        pgm_function48[(4, 0, 3)] = 0.01
        pgm_function48[(4, 0, 4)] = 0.01
        pgm_function48[(4, 1, 1)] = 0.01
        pgm_function48[(4, 1, 2)] = 0.01
        pgm_function48[(4, 1, 3)] = 0.01
        pgm_function48[(4, 1, 4)] = 0.01
        pgm_function48[(4, 2, 1)] = 0.01
        pgm_function48[(4, 2, 2)] = 0.01
        pgm_function48[(4, 2, 3)] = 0.01
        pgm_function48[(4, 2, 4)] = 0.01
        pgm_function48[(4, 3, 1)] = 0.01
        pgm_function48[(4, 3, 2)] = 0.01
        pgm_function48[(4, 3, 3)] = 0.01
        pgm_function48[(4, 3, 4)] = 0.01
        pgm_function48[(4, 4, 1)] = 0.01
        pgm_function48[(4, 4, 2)] = 0.01
        pgm_function48[(4, 4, 3)] = 0.01
        pgm_function48[(4, 4, 4)] = 0.01
        pgm_function48[(4, 5, 1)] = 0.01
        pgm_function48[(4, 5, 2)] = 0.01
        pgm_function48[(4, 5, 3)] = 0.01
        pgm_function48[(4, 5, 4)] = 0.01
        pgm_function48[(4, 6, 1)] = 0.01
        pgm_function48[(4, 6, 2)] = 0.01
        pgm_function48[(4, 6, 3)] = 0.01
        pgm_function48[(4, 6, 4)] = 0.01
        pgm_function48[(4, 7, 1)] = 0.01
        pgm_function48[(4, 7, 2)] = 0.01
        pgm_function48[(4, 7, 3)] = 0.01
        pgm_function48[(4, 7, 4)] = 0.01
        pgm_function48[(4, 8, 1)] = 0.01
        pgm_function48[(4, 8, 2)] = 0.01
        pgm_function48[(4, 8, 3)] = 0.01
        pgm_function48[(4, 8, 4)] = 0.01
        pgm_function48[(4, 9, 1)] = 0.01
        pgm_function48[(4, 9, 2)] = 0.01
        pgm_function48[(4, 9, 3)] = 0.01
        pgm_function48[(4, 9, 4)] = 0.01
        pgm_function48[(4, 10, 1)] = 0.01
        pgm_function48[(4, 10, 2)] = 0.01
        pgm_function48[(4, 10, 3)] = 0.01
        pgm_function48[(4, 10, 4)] = 0.01
        pgm_function48[(4, 11, 1)] = 0.01
        pgm_function48[(4, 11, 2)] = 0.01
        pgm_function48[(4, 11, 3)] = 0.01
        pgm_function48[(4, 11, 4)] = 0.01
        pgm_function48[(4, 12, 1)] = 0.01
        pgm_function48[(4, 12, 2)] = 0.01
        pgm_function48[(4, 12, 3)] = 0.01
        pgm_function48[(4, 12, 4)] = 0.01
        pgm_function48[(4, 13, 1)] = 0.01
        pgm_function48[(4, 13, 2)] = 0.01
        pgm_function48[(4, 13, 3)] = 0.01
        pgm_function48[(4, 13, 4)] = 0.01
        pgm_function48[(4, 14, 1)] = 0.01
        pgm_function48[(4, 14, 2)] = 0.01
        pgm_function48[(4, 14, 3)] = 0.01
        pgm_function48[(4, 14, 4)] = 0.01
        pgm_function48[(4, 15, 1)] = 0.01
        pgm_function48[(4, 15, 2)] = 0.01
        pgm_function48[(4, 15, 3)] = 0.01
        pgm_function48[(4, 15, 4)] = 0.01
        pgm_function48[(4, 16, 1)] = 0.01
        pgm_function48[(4, 16, 2)] = 0.01
        pgm_function48[(4, 16, 3)] = 0.01
        pgm_function48[(4, 16, 4)] = 0.01
        pgm_function48[(4, 17, 1)] = 0.01
        pgm_function48[(4, 17, 2)] = 0.01
        pgm_function48[(4, 17, 3)] = 0.01
        pgm_function48[(4, 17, 4)] = 0.01
        pgm_function48[(4, 18, 1)] = 0.01
        pgm_function48[(4, 18, 2)] = 0.01
        pgm_function48[(4, 18, 3)] = 0.01
        pgm_function48[(4, 18, 4)] = 0.01
        pgm_function48[(4, 19, 1)] = 0.01
        pgm_function48[(4, 19, 2)] = 0.01
        pgm_function48[(4, 19, 3)] = 0.01
        pgm_function48[(4, 19, 4)] = 0.01
        pgm_function48[(4, 20, 1)] = 0.01
        pgm_function48[(4, 20, 2)] = 0.01
        pgm_function48[(4, 20, 3)] = 0.01
        pgm_function48[(4, 20, 4)] = 0.01
        pgm_function48[(4, 21, 1)] = 0.01
        pgm_function48[(4, 21, 2)] = 0.01
        pgm_function48[(4, 21, 3)] = 0.01
        pgm_function48[(4, 21, 4)] = 0.01
        pgm_function48[(4, 22, 1)] = 0.01
        pgm_function48[(4, 22, 2)] = 0.01
        pgm_function48[(4, 22, 3)] = 0.01
        pgm_function48[(4, 22, 4)] = 0.01
        pgm_function48[(4, 23, 1)] = 0.01
        pgm_function48[(4, 23, 2)] = 0.01
        pgm_function48[(4, 23, 3)] = 0.01
        pgm_function48[(4, 23, 4)] = 0.01
        pgm_function48[(4, 24, 1)] = 0.01
        pgm_function48[(4, 24, 2)] = 0.01
        pgm_function48[(4, 24, 3)] = 0.01
        pgm_function48[(4, 24, 4)] = 0.01
        pgm_function48[(4, 25, 1)] = 0.01
        pgm_function48[(4, 25, 2)] = 0.01
        pgm_function48[(4, 25, 3)] = 0.01
        pgm_function48[(4, 25, 4)] = 0.01
        pgm_function48[(4, 26, 1)] = 0.01
        pgm_function48[(4, 26, 2)] = 0.01
        pgm_function48[(4, 26, 3)] = 0.01
        pgm_function48[(4, 26, 4)] = 0.01
        pgm_function48[(4, 27, 1)] = 0.01
        pgm_function48[(4, 27, 2)] = 0.01
        pgm_function48[(4, 27, 3)] = 0.01
        pgm_function48[(4, 27, 4)] = 0.01
        pgm_function48[(4, 28, 1)] = 0.01
        pgm_function48[(4, 28, 2)] = 0.01
        pgm_function48[(4, 28, 3)] = 0.01
        pgm_function48[(4, 28, 4)] = 0.01
        pgm_function48[(4, 29, 1)] = 0.01
        pgm_function48[(4, 29, 2)] = 0.01
        pgm_function48[(4, 29, 3)] = 0.01
        pgm_function48[(4, 29, 4)] = 0.01
        pgm_function48[(4, 30, 1)] = 0.01
        pgm_function48[(4, 30, 2)] = 0.01
        pgm_function48[(4, 30, 3)] = 0.01
        pgm_function48[(4, 30, 4)] = 0.01
        pgm_function48[(4, 31, 1)] = 0.01
        pgm_function48[(4, 31, 2)] = 0.01
        pgm_function48[(4, 31, 3)] = 0.01
        pgm_function48[(4, 31, 4)] = 0.01
        pgm_function48[(4, 32, 1)] = 0.01
        pgm_function48[(4, 32, 2)] = 0.01
        pgm_function48[(4, 32, 3)] = 0.01
        pgm_function48[(4, 32, 4)] = 0.01
        pgm_function48[(4, 33, 1)] = 0.01
        pgm_function48[(4, 33, 2)] = 0.01
        pgm_function48[(4, 33, 3)] = 0.01
        pgm_function48[(4, 33, 4)] = 0.01
        pgm_function48[(4, 34, 1)] = 0.01
        pgm_function48[(4, 34, 2)] = 0.01
        pgm_function48[(4, 34, 3)] = 0.01
        pgm_function48[(4, 34, 4)] = 0.01
        pgm_function48[(4, 35, 1)] = 0.01
        pgm_function48[(4, 35, 2)] = 0.01
        pgm_function48[(4, 35, 3)] = 0.01
        pgm_function48[(4, 35, 4)] = 0.01
        pgm_function48[(4, 36, 1)] = 0.01
        pgm_function48[(4, 36, 2)] = 0.01
        pgm_function48[(4, 36, 3)] = 0.01
        pgm_function48[(4, 36, 4)] = 0.01
        pgm_function48[(4, 37, 1)] = 0.01
        pgm_function48[(4, 37, 2)] = 0.01
        pgm_function48[(4, 37, 3)] = 0.01
        pgm_function48[(4, 37, 4)] = 0.01
        pgm_function48[(4, 38, 1)] = 0.01
        pgm_function48[(4, 38, 2)] = 0.01
        pgm_function48[(4, 38, 3)] = 0.01
        pgm_function48[(4, 38, 4)] = 0.01
        pgm_function48[(4, 39, 1)] = 0.01
        pgm_function48[(4, 39, 2)] = 0.01
        pgm_function48[(4, 39, 3)] = 0.01
        pgm_function48[(4, 39, 4)] = 0.01
        pgm_function48[(4, 40, 1)] = 0.01
        pgm_function48[(4, 40, 2)] = 0.01
        pgm_function48[(4, 40, 3)] = 0.01
        pgm_function48[(4, 40, 4)] = 0.01
        pgm_function48[(4, 41, 1)] = 0.01
        pgm_function48[(4, 41, 2)] = 0.01
        pgm_function48[(4, 41, 3)] = 0.01
        pgm_function48[(4, 41, 4)] = 0.01
        pgm_function48[(4, 42, 1)] = 0.01
        pgm_function48[(4, 42, 2)] = 0.01
        pgm_function48[(4, 42, 3)] = 0.01
        pgm_function48[(4, 42, 4)] = 0.01
        pgm_function48[(4, 43, 1)] = 0.01
        pgm_function48[(4, 43, 2)] = 0.01
        pgm_function48[(4, 43, 3)] = 0.01
        pgm_function48[(4, 43, 4)] = 0.01
        pgm_function48[(4, 44, 1)] = 0.01
        pgm_function48[(4, 44, 2)] = 0.01
        pgm_function48[(4, 44, 3)] = 0.01
        pgm_function48[(4, 44, 4)] = 0.01
        pgm_function48[(4, 45, 1)] = 0.01
        pgm_function48[(4, 45, 2)] = 0.01
        pgm_function48[(4, 45, 3)] = 0.01
        pgm_function48[(4, 45, 4)] = 0.01
        pgm_function48[(4, 46, 1)] = 0.01
        pgm_function48[(4, 46, 2)] = 0.01
        pgm_function48[(4, 46, 3)] = 0.01
        pgm_function48[(4, 46, 4)] = 0.01
        pgm_function48[(4, 47, 1)] = 0.01
        pgm_function48[(4, 47, 2)] = 0.01
        pgm_function48[(4, 47, 3)] = 0.01
        pgm_function48[(4, 47, 4)] = 0.01
        pgm_function48[(4, 48, 1)] = 0.01
        pgm_function48[(4, 48, 2)] = 0.01
        pgm_function48[(4, 48, 3)] = 0.01
        pgm_function48[(4, 48, 4)] = 0.01
        pgm_function48[(4, 49, 1)] = 0.01
        pgm_function48[(4, 49, 2)] = 0.01
        pgm_function48[(4, 49, 3)] = 0.01
        pgm_function48[(4, 49, 4)] = 0.01
        pgm_function48[(4, 50, 1)] = 0.01
        pgm_function48[(4, 50, 2)] = 0.01
        pgm_function48[(4, 50, 3)] = 0.01
        pgm_function48[(4, 50, 4)] = 0.01
        pgm_function48[(4, 51, 1)] = 0.01
        pgm_function48[(4, 51, 2)] = 0.01
        pgm_function48[(4, 51, 3)] = 0.01
        pgm_function48[(4, 51, 4)] = 0.01
        pgm_function48[(4, 52, 1)] = 0.01
        pgm_function48[(4, 52, 2)] = 0.01
        pgm_function48[(4, 52, 3)] = 0.01
        pgm_function48[(4, 52, 4)] = 0.01
        pgm_function48[(4, 53, 1)] = 0.01
        pgm_function48[(4, 53, 2)] = 0.01
        pgm_function48[(4, 53, 3)] = 0.01
        pgm_function48[(4, 53, 4)] = 0.01
        pgm_function48[(4, 54, 1)] = 0.01
        pgm_function48[(4, 54, 2)] = 0.01
        pgm_function48[(4, 54, 3)] = 0.01
        pgm_function48[(4, 54, 4)] = 0.01
        pgm_function48[(4, 55, 1)] = 0.01
        pgm_function48[(4, 55, 2)] = 0.01
        pgm_function48[(4, 55, 3)] = 0.01
        pgm_function48[(4, 55, 4)] = 0.01
        pgm_function48[(4, 56, 1)] = 0.01
        pgm_function48[(4, 56, 2)] = 0.01
        pgm_function48[(4, 56, 3)] = 0.01
        pgm_function48[(4, 56, 4)] = 0.01
        pgm_function48[(4, 57, 1)] = 0.01
        pgm_function48[(4, 57, 2)] = 0.01
        pgm_function48[(4, 57, 3)] = 0.01
        pgm_function48[(4, 57, 4)] = 0.01
        pgm_function48[(4, 58, 1)] = 0.01
        pgm_function48[(4, 58, 2)] = 0.01
        pgm_function48[(4, 58, 3)] = 0.01
        pgm_function48[(4, 58, 4)] = 0.01
        pgm_function48[(4, 59, 1)] = 0.01
        pgm_function48[(4, 59, 2)] = 0.01
        pgm_function48[(4, 59, 3)] = 0.01
        pgm_function48[(4, 59, 4)] = 0.01
        pgm_function48[(4, 60, 1)] = 0.01
        pgm_function48[(4, 60, 2)] = 0.01
        pgm_function48[(4, 60, 3)] = 0.01
        pgm_function48[(4, 60, 4)] = 0.01
        pgm_function48[(4, 61, 1)] = 0.01
        pgm_function48[(4, 61, 2)] = 0.01
        pgm_function48[(4, 61, 3)] = 0.01
        pgm_function48[(4, 61, 4)] = 0.01
        pgm_function48[(4, 62, 1)] = 0.01
        pgm_function48[(4, 62, 2)] = 0.01
        pgm_function48[(4, 62, 3)] = 0.01
        pgm_function48[(4, 62, 4)] = 0.01
        pgm_function48[(4, 63, 1)] = 0.01
        pgm_function48[(4, 63, 2)] = 0.01
        pgm_function48[(4, 63, 3)] = 0.01
        pgm_function48[(4, 63, 4)] = 0.01
        pgm_function48[(4, 64, 1)] = 0.01
        pgm_function48[(4, 64, 2)] = 0.01
        pgm_function48[(4, 64, 3)] = 0.01
        pgm_function48[(4, 64, 4)] = 0.01
        pgm_function48[(4, 65, 1)] = 0.01
        pgm_function48[(4, 65, 2)] = 0.01
        pgm_function48[(4, 65, 3)] = 0.01
        pgm_function48[(4, 65, 4)] = 0.01
        pgm_function48[(4, 66, 1)] = 0.01
        pgm_function48[(4, 66, 2)] = 0.01
        pgm_function48[(4, 66, 3)] = 0.01
        pgm_function48[(4, 66, 4)] = 0.01
        pgm_function48[(4, 67, 1)] = 0.01
        pgm_function48[(4, 67, 2)] = 0.01
        pgm_function48[(4, 67, 3)] = 0.01
        pgm_function48[(4, 67, 4)] = 0.01
        pgm_function48[(4, 68, 1)] = 0.01
        pgm_function48[(4, 68, 2)] = 0.01
        pgm_function48[(4, 68, 3)] = 0.01
        pgm_function48[(4, 68, 4)] = 0.01
        pgm_function48[(4, 69, 1)] = 0.01
        pgm_function48[(4, 69, 2)] = 0.01
        pgm_function48[(4, 69, 3)] = 0.01
        pgm_function48[(4, 69, 4)] = 0.01
        pgm_function48[(4, 70, 1)] = 0.01
        pgm_function48[(4, 70, 2)] = 0.01
        pgm_function48[(4, 70, 3)] = 0.01
        pgm_function48[(4, 70, 4)] = 0.01
        pgm_function48[(4, 71, 1)] = 0.01
        pgm_function48[(4, 71, 2)] = 0.01
        pgm_function48[(4, 71, 3)] = 0.01
        pgm_function48[(4, 71, 4)] = 0.01
        pgm_function48[(4, 72, 1)] = 0.01
        pgm_function48[(4, 72, 2)] = 0.01
        pgm_function48[(4, 72, 3)] = 0.01
        pgm_function48[(4, 72, 4)] = 0.01
        pgm_function48[(4, 73, 1)] = 0.01
        pgm_function48[(4, 73, 2)] = 0.01
        pgm_function48[(4, 73, 3)] = 0.01
        pgm_function48[(4, 73, 4)] = 0.01
        pgm_function48[(4, 74, 1)] = 0.01
        pgm_function48[(4, 74, 2)] = 0.01
        pgm_function48[(4, 74, 3)] = 0.01
        pgm_function48[(4, 74, 4)] = 0.01
        pgm_function48[(4, 75, 1)] = 0.01
        pgm_function48[(4, 75, 2)] = 0.01
        pgm_function48[(4, 75, 3)] = 0.01
        pgm_function48[(4, 75, 4)] = 0.01

        pgm_function49 = pgm_factor49.set_sparse()
        pgm_function49[(0, 0)] = 0.05
        pgm_function49[(0, 1)] = 0.99999
        pgm_function49[(0, 2)] = 0.99999
        pgm_function49[(0, 3)] = 0.94
        pgm_function49[(0, 4)] = 0.99999
        pgm_function49[(0, 5)] = 0.96
        pgm_function49[(0, 6)] = 0.99999
        pgm_function49[(0, 7)] = 0.99999
        pgm_function49[(0, 8)] = 0.97
        pgm_function49[(0, 9)] = 0.99999
        pgm_function49[(0, 10)] = 0.25
        pgm_function49[(0, 11)] = 0.99999
        pgm_function49[(0, 12)] = 0.99999
        pgm_function49[(0, 13)] = 0.99999
        pgm_function49[(0, 14)] = 0.97
        pgm_function49[(0, 15)] = 0.97
        pgm_function49[(0, 16)] = 0.99999
        pgm_function49[(0, 17)] = 0.99999
        pgm_function49[(0, 18)] = 0.99999
        pgm_function49[(0, 19)] = 0.99999
        pgm_function49[(0, 20)] = 0.94
        pgm_function49[(0, 22)] = 0.99999
        pgm_function49[(0, 23)] = 0.25
        pgm_function49[(0, 24)] = 0.99999
        pgm_function49[(0, 25)] = 0.999
        pgm_function49[(0, 26)] = 0.999
        pgm_function49[(0, 27)] = 0.97
        pgm_function49[(0, 28)] = 0.97
        pgm_function49[(0, 29)] = 0.999
        pgm_function49[(0, 30)] = 0.97
        pgm_function49[(0, 31)] = 0.97
        pgm_function49[(0, 32)] = 0.999
        pgm_function49[(0, 33)] = 0.999
        pgm_function49[(0, 34)] = 0.91
        pgm_function49[(0, 35)] = 0.91
        pgm_function49[(0, 36)] = 0.91
        pgm_function49[(0, 37)] = 0.91
        pgm_function49[(0, 38)] = 0.91
        pgm_function49[(0, 39)] = 0.91
        pgm_function49[(0, 40)] = 0.91
        pgm_function49[(0, 41)] = 0.984
        pgm_function49[(0, 42)] = 0.984
        pgm_function49[(0, 43)] = 0.984
        pgm_function49[(0, 44)] = 0.99999
        pgm_function49[(0, 45)] = 0.99999
        pgm_function49[(0, 46)] = 0.99999
        pgm_function49[(0, 47)] = 0.99999
        pgm_function49[(0, 48)] = 0.99999
        pgm_function49[(0, 49)] = 0.984
        pgm_function49[(0, 50)] = 0.99999
        pgm_function49[(0, 51)] = 0.99999
        pgm_function49[(0, 52)] = 0.99999
        pgm_function49[(0, 53)] = 0.99999
        pgm_function49[(0, 54)] = 0.99999
        pgm_function49[(0, 55)] = 0.985
        pgm_function49[(0, 56)] = 0.99999
        pgm_function49[(0, 57)] = 0.99999
        pgm_function49[(0, 58)] = 0.99999
        pgm_function49[(0, 59)] = 0.99999
        pgm_function49[(0, 60)] = 0.985
        pgm_function49[(0, 61)] = 0.75
        pgm_function49[(0, 62)] = 0.99999
        pgm_function49[(0, 64)] = 0.99999
        pgm_function49[(0, 65)] = 0.99999
        pgm_function49[(0, 66)] = 0.25
        pgm_function49[(0, 67)] = 0.99999
        pgm_function49[(0, 68)] = 0.985
        pgm_function49[(0, 69)] = 0.99999
        pgm_function49[(0, 70)] = 0.94
        pgm_function49[(0, 71)] = 0.94
        pgm_function49[(0, 72)] = 0.94
        pgm_function49[(0, 74)] = 0.99999
        pgm_function49[(0, 75)] = 0.91
        pgm_function49[(1, 0)] = 0.85
        pgm_function49[(1, 1)] = 1e-05
        pgm_function49[(1, 2)] = 1e-05
        pgm_function49[(1, 3)] = 0.05
        pgm_function49[(1, 4)] = 1e-05
        pgm_function49[(1, 5)] = 0.03
        pgm_function49[(1, 6)] = 1e-05
        pgm_function49[(1, 7)] = 1e-05
        pgm_function49[(1, 8)] = 0.02
        pgm_function49[(1, 9)] = 1e-05
        pgm_function49[(1, 10)] = 0.7
        pgm_function49[(1, 11)] = 1e-05
        pgm_function49[(1, 12)] = 1e-05
        pgm_function49[(1, 13)] = 1e-05
        pgm_function49[(1, 14)] = 0.02
        pgm_function49[(1, 15)] = 0.02
        pgm_function49[(1, 16)] = 1e-05
        pgm_function49[(1, 17)] = 1e-05
        pgm_function49[(1, 18)] = 1e-05
        pgm_function49[(1, 19)] = 1e-05
        pgm_function49[(1, 20)] = 0.05
        pgm_function49[(1, 21)] = 0.6
        pgm_function49[(1, 22)] = 1e-05
        pgm_function49[(1, 23)] = 0.7
        pgm_function49[(1, 24)] = 1e-05
        pgm_function49[(1, 25)] = 0.001
        pgm_function49[(1, 26)] = 0.001
        pgm_function49[(1, 27)] = 0.02
        pgm_function49[(1, 28)] = 0.02
        pgm_function49[(1, 29)] = 0.001
        pgm_function49[(1, 30)] = 0.02
        pgm_function49[(1, 31)] = 0.02
        pgm_function49[(1, 32)] = 0.001
        pgm_function49[(1, 33)] = 0.001
        pgm_function49[(1, 34)] = 0.04
        pgm_function49[(1, 35)] = 0.04
        pgm_function49[(1, 36)] = 0.04
        pgm_function49[(1, 37)] = 0.04
        pgm_function49[(1, 38)] = 0.04
        pgm_function49[(1, 39)] = 0.04
        pgm_function49[(1, 40)] = 0.04
        pgm_function49[(1, 41)] = 0.01
        pgm_function49[(1, 42)] = 0.01
        pgm_function49[(1, 43)] = 0.01
        pgm_function49[(1, 44)] = 1e-05
        pgm_function49[(1, 45)] = 1e-05
        pgm_function49[(1, 46)] = 1e-05
        pgm_function49[(1, 47)] = 1e-05
        pgm_function49[(1, 48)] = 1e-05
        pgm_function49[(1, 49)] = 0.01
        pgm_function49[(1, 50)] = 1e-05
        pgm_function49[(1, 51)] = 1e-05
        pgm_function49[(1, 52)] = 1e-05
        pgm_function49[(1, 53)] = 1e-05
        pgm_function49[(1, 54)] = 1e-05
        pgm_function49[(1, 55)] = 0.01
        pgm_function49[(1, 56)] = 1e-05
        pgm_function49[(1, 57)] = 1e-05
        pgm_function49[(1, 58)] = 1e-05
        pgm_function49[(1, 59)] = 1e-05
        pgm_function49[(1, 60)] = 0.01
        pgm_function49[(1, 61)] = 0.2
        pgm_function49[(1, 62)] = 1e-05
        pgm_function49[(1, 63)] = 0.01
        pgm_function49[(1, 64)] = 1e-05
        pgm_function49[(1, 65)] = 1e-05
        pgm_function49[(1, 66)] = 0.7
        pgm_function49[(1, 67)] = 1e-05
        pgm_function49[(1, 68)] = 0.01
        pgm_function49[(1, 69)] = 1e-05
        pgm_function49[(1, 70)] = 0.05
        pgm_function49[(1, 71)] = 0.05
        pgm_function49[(1, 72)] = 0.05
        pgm_function49[(1, 73)] = 0.6
        pgm_function49[(1, 74)] = 1e-05
        pgm_function49[(1, 75)] = 0.04
        pgm_function49[(2, 0)] = 0.1
        pgm_function49[(2, 3)] = 0.01
        pgm_function49[(2, 5)] = 0.01
        pgm_function49[(2, 8)] = 0.01
        pgm_function49[(2, 10)] = 0.05
        pgm_function49[(2, 14)] = 0.01
        pgm_function49[(2, 15)] = 0.01
        pgm_function49[(2, 20)] = 0.01
        pgm_function49[(2, 21)] = 0.4
        pgm_function49[(2, 23)] = 0.05
        pgm_function49[(2, 27)] = 0.01
        pgm_function49[(2, 28)] = 0.01
        pgm_function49[(2, 30)] = 0.01
        pgm_function49[(2, 31)] = 0.01
        pgm_function49[(2, 34)] = 0.03
        pgm_function49[(2, 35)] = 0.03
        pgm_function49[(2, 36)] = 0.03
        pgm_function49[(2, 37)] = 0.03
        pgm_function49[(2, 38)] = 0.03
        pgm_function49[(2, 39)] = 0.03
        pgm_function49[(2, 40)] = 0.03
        pgm_function49[(2, 41)] = 0.001
        pgm_function49[(2, 42)] = 0.001
        pgm_function49[(2, 43)] = 0.001
        pgm_function49[(2, 49)] = 0.001
        pgm_function49[(2, 55)] = 0.005
        pgm_function49[(2, 60)] = 0.005
        pgm_function49[(2, 61)] = 0.05
        pgm_function49[(2, 63)] = 0.15
        pgm_function49[(2, 66)] = 0.05
        pgm_function49[(2, 68)] = 0.005
        pgm_function49[(2, 70)] = 0.01
        pgm_function49[(2, 71)] = 0.01
        pgm_function49[(2, 72)] = 0.01
        pgm_function49[(2, 73)] = 0.4
        pgm_function49[(2, 75)] = 0.03
        pgm_function49[(3, 34)] = 0.02
        pgm_function49[(3, 35)] = 0.02
        pgm_function49[(3, 36)] = 0.02
        pgm_function49[(3, 37)] = 0.02
        pgm_function49[(3, 38)] = 0.02
        pgm_function49[(3, 39)] = 0.02
        pgm_function49[(3, 40)] = 0.02
        pgm_function49[(3, 41)] = 0.005
        pgm_function49[(3, 42)] = 0.005
        pgm_function49[(3, 43)] = 0.005
        pgm_function49[(3, 49)] = 0.005
        pgm_function49[(3, 63)] = 0.84
        pgm_function49[(3, 75)] = 0.02

        pgm_function50 = pgm_factor50.set_sparse()
        pgm_function50[(0, 0, 0)] = 0.9999
        pgm_function50[(0, 0, 1)] = 0.999
        pgm_function50[(0, 0, 2)] = 0.25
        pgm_function50[(0, 0, 3)] = 0.25
        pgm_function50[(0, 1, 0)] = 0.969
        pgm_function50[(0, 1, 1)] = 0.969
        pgm_function50[(0, 1, 2)] = 0.969
        pgm_function50[(0, 1, 3)] = 0.25
        pgm_function50[(0, 2, 0)] = 0.9999
        pgm_function50[(0, 2, 1)] = 0.999
        pgm_function50[(0, 2, 2)] = 0.25
        pgm_function50[(0, 2, 3)] = 0.25
        pgm_function50[(0, 3, 0)] = 0.9999
        pgm_function50[(0, 3, 1)] = 0.999
        pgm_function50[(0, 3, 2)] = 0.25
        pgm_function50[(0, 3, 3)] = 0.25
        pgm_function50[(0, 4, 0)] = 0.9999
        pgm_function50[(0, 4, 1)] = 0.999
        pgm_function50[(0, 4, 2)] = 0.25
        pgm_function50[(0, 4, 3)] = 0.25
        pgm_function50[(0, 5, 0)] = 0.9999
        pgm_function50[(0, 5, 1)] = 0.999
        pgm_function50[(0, 5, 2)] = 0.25
        pgm_function50[(0, 5, 3)] = 0.25
        pgm_function50[(0, 6, 0)] = 0.98
        pgm_function50[(0, 6, 1)] = 0.98
        pgm_function50[(0, 6, 2)] = 0.25
        pgm_function50[(0, 6, 3)] = 0.25
        pgm_function50[(0, 7, 0)] = 0.98
        pgm_function50[(0, 7, 1)] = 0.98
        pgm_function50[(0, 7, 2)] = 0.25
        pgm_function50[(0, 7, 3)] = 0.25
        pgm_function50[(0, 8, 0)] = 0.9999
        pgm_function50[(0, 8, 1)] = 0.999
        pgm_function50[(0, 8, 2)] = 0.25
        pgm_function50[(0, 8, 3)] = 0.25
        pgm_function50[(0, 9, 0)] = 0.9999
        pgm_function50[(0, 9, 1)] = 0.999
        pgm_function50[(0, 9, 2)] = 0.25
        pgm_function50[(0, 9, 3)] = 0.25
        pgm_function50[(0, 10, 0)] = 0.969
        pgm_function50[(0, 10, 1)] = 0.969
        pgm_function50[(0, 10, 2)] = 0.959
        pgm_function50[(0, 10, 3)] = 0.01
        pgm_function50[(0, 11, 0)] = 0.9999
        pgm_function50[(0, 11, 1)] = 0.999
        pgm_function50[(0, 11, 2)] = 0.25
        pgm_function50[(0, 11, 3)] = 0.25
        pgm_function50[(0, 12, 0)] = 0.9999
        pgm_function50[(0, 12, 1)] = 0.999
        pgm_function50[(0, 12, 2)] = 0.25
        pgm_function50[(0, 12, 3)] = 0.25
        pgm_function50[(0, 13, 0)] = 0.9999
        pgm_function50[(0, 13, 1)] = 0.999
        pgm_function50[(0, 13, 2)] = 0.25
        pgm_function50[(0, 13, 3)] = 0.25
        pgm_function50[(0, 14, 0)] = 0.99
        pgm_function50[(0, 14, 1)] = 0.99
        pgm_function50[(0, 14, 2)] = 0.25
        pgm_function50[(0, 14, 3)] = 0.25
        pgm_function50[(0, 15, 0)] = 0.99
        pgm_function50[(0, 15, 1)] = 0.99
        pgm_function50[(0, 15, 2)] = 0.25
        pgm_function50[(0, 15, 3)] = 0.25
        pgm_function50[(0, 16, 0)] = 0.9999
        pgm_function50[(0, 16, 1)] = 0.999
        pgm_function50[(0, 16, 2)] = 0.25
        pgm_function50[(0, 16, 3)] = 0.25
        pgm_function50[(0, 17, 0)] = 0.9999
        pgm_function50[(0, 17, 1)] = 0.999
        pgm_function50[(0, 17, 2)] = 0.25
        pgm_function50[(0, 17, 3)] = 0.25
        pgm_function50[(0, 18, 0)] = 0.9999
        pgm_function50[(0, 18, 1)] = 0.999
        pgm_function50[(0, 18, 2)] = 0.25
        pgm_function50[(0, 18, 3)] = 0.25
        pgm_function50[(0, 19, 0)] = 0.9999
        pgm_function50[(0, 19, 1)] = 0.999
        pgm_function50[(0, 19, 2)] = 0.25
        pgm_function50[(0, 19, 3)] = 0.25
        pgm_function50[(0, 20, 0)] = 0.9999
        pgm_function50[(0, 20, 1)] = 0.999
        pgm_function50[(0, 20, 2)] = 0.25
        pgm_function50[(0, 20, 3)] = 0.25
        pgm_function50[(0, 21, 0)] = 0.9999
        pgm_function50[(0, 21, 1)] = 0.999
        pgm_function50[(0, 21, 2)] = 0.25
        pgm_function50[(0, 21, 3)] = 0.25
        pgm_function50[(0, 22, 0)] = 0.9999
        pgm_function50[(0, 22, 1)] = 0.999
        pgm_function50[(0, 22, 2)] = 0.25
        pgm_function50[(0, 22, 3)] = 0.25
        pgm_function50[(0, 23, 0)] = 0.989
        pgm_function50[(0, 23, 1)] = 0.989
        pgm_function50[(0, 23, 2)] = 0.96
        pgm_function50[(0, 23, 3)] = 0.25
        pgm_function50[(0, 24, 0)] = 0.9999
        pgm_function50[(0, 24, 1)] = 0.999
        pgm_function50[(0, 24, 2)] = 0.25
        pgm_function50[(0, 24, 3)] = 0.25
        pgm_function50[(0, 25, 0)] = 0.01
        pgm_function50[(0, 25, 1)] = 0.01
        pgm_function50[(0, 25, 2)] = 0.01
        pgm_function50[(0, 25, 3)] = 0.25
        pgm_function50[(0, 26, 0)] = 0.01
        pgm_function50[(0, 26, 1)] = 0.01
        pgm_function50[(0, 26, 2)] = 0.01
        pgm_function50[(0, 26, 3)] = 0.25
        pgm_function50[(0, 34, 0)] = 0.9999
        pgm_function50[(0, 34, 1)] = 0.9999
        pgm_function50[(0, 34, 2)] = 0.25
        pgm_function50[(0, 34, 3)] = 0.25
        pgm_function50[(0, 35, 0)] = 0.9999
        pgm_function50[(0, 35, 1)] = 0.9999
        pgm_function50[(0, 35, 2)] = 0.25
        pgm_function50[(0, 35, 3)] = 0.25
        pgm_function50[(0, 36, 0)] = 0.9999
        pgm_function50[(0, 36, 1)] = 0.9999
        pgm_function50[(0, 36, 2)] = 0.25
        pgm_function50[(0, 36, 3)] = 0.25
        pgm_function50[(0, 37, 0)] = 0.9999
        pgm_function50[(0, 37, 1)] = 0.9999
        pgm_function50[(0, 37, 2)] = 0.25
        pgm_function50[(0, 37, 3)] = 0.25
        pgm_function50[(0, 38, 0)] = 0.969
        pgm_function50[(0, 38, 1)] = 0.969
        pgm_function50[(0, 38, 2)] = 0.939
        pgm_function50[(0, 38, 3)] = 0.25
        pgm_function50[(0, 39, 0)] = 0.969
        pgm_function50[(0, 39, 1)] = 0.969
        pgm_function50[(0, 39, 2)] = 0.969
        pgm_function50[(0, 39, 3)] = 0.8
        pgm_function50[(0, 40, 0)] = 0.9999
        pgm_function50[(0, 40, 1)] = 0.9999
        pgm_function50[(0, 40, 2)] = 0.969
        pgm_function50[(0, 40, 3)] = 0.25
        pgm_function50[(0, 41, 0)] = 0.9999
        pgm_function50[(0, 41, 1)] = 0.9999
        pgm_function50[(0, 41, 2)] = 0.969
        pgm_function50[(0, 41, 3)] = 0.25
        pgm_function50[(0, 42, 0)] = 0.969
        pgm_function50[(0, 42, 1)] = 0.969
        pgm_function50[(0, 42, 2)] = 0.969
        pgm_function50[(0, 42, 3)] = 0.25
        pgm_function50[(0, 43, 0)] = 0.969
        pgm_function50[(0, 43, 1)] = 0.969
        pgm_function50[(0, 43, 2)] = 0.969
        pgm_function50[(0, 43, 3)] = 0.925
        pgm_function50[(0, 44, 0)] = 0.88
        pgm_function50[(0, 44, 1)] = 0.88
        pgm_function50[(0, 44, 2)] = 0.88
        pgm_function50[(0, 44, 3)] = 0.25
        pgm_function50[(0, 45, 0)] = 0.969
        pgm_function50[(0, 45, 1)] = 0.969
        pgm_function50[(0, 45, 2)] = 0.969
        pgm_function50[(0, 45, 3)] = 0.25
        pgm_function50[(0, 46, 0)] = 0.969
        pgm_function50[(0, 46, 1)] = 0.969
        pgm_function50[(0, 46, 2)] = 0.969
        pgm_function50[(0, 46, 3)] = 0.25
        pgm_function50[(0, 47, 0)] = 0.969
        pgm_function50[(0, 47, 1)] = 0.969
        pgm_function50[(0, 47, 2)] = 0.969
        pgm_function50[(0, 47, 3)] = 0.969
        pgm_function50[(0, 48, 0)] = 0.9999
        pgm_function50[(0, 48, 1)] = 0.9999
        pgm_function50[(0, 48, 2)] = 0.969
        pgm_function50[(0, 48, 3)] = 0.25
        pgm_function50[(0, 49, 0)] = 0.969
        pgm_function50[(0, 49, 1)] = 0.969
        pgm_function50[(0, 49, 2)] = 0.969
        pgm_function50[(0, 49, 3)] = 0.925
        pgm_function50[(0, 50, 0)] = 0.969
        pgm_function50[(0, 50, 1)] = 0.969
        pgm_function50[(0, 50, 2)] = 0.969
        pgm_function50[(0, 50, 3)] = 0.925
        pgm_function50[(0, 51, 0)] = 0.969
        pgm_function50[(0, 51, 1)] = 0.969
        pgm_function50[(0, 51, 2)] = 0.969
        pgm_function50[(0, 51, 3)] = 0.25
        pgm_function50[(0, 52, 0)] = 0.45
        pgm_function50[(0, 52, 1)] = 0.45
        pgm_function50[(0, 52, 2)] = 0.3
        pgm_function50[(0, 53, 0)] = 0.969
        pgm_function50[(0, 53, 1)] = 0.969
        pgm_function50[(0, 53, 2)] = 0.969
        pgm_function50[(0, 53, 3)] = 0.25
        pgm_function50[(0, 54, 0)] = 0.9999
        pgm_function50[(0, 54, 1)] = 0.999
        pgm_function50[(0, 54, 2)] = 0.25
        pgm_function50[(0, 54, 3)] = 0.25
        pgm_function50[(0, 55, 0)] = 0.9999
        pgm_function50[(0, 55, 1)] = 0.999
        pgm_function50[(0, 55, 2)] = 0.25
        pgm_function50[(0, 55, 3)] = 0.25
        pgm_function50[(0, 56, 0)] = 0.9499
        pgm_function50[(0, 56, 1)] = 0.9499
        pgm_function50[(0, 56, 2)] = 0.59
        pgm_function50[(0, 56, 3)] = 0.25
        pgm_function50[(0, 57, 0)] = 0.9499
        pgm_function50[(0, 57, 1)] = 0.9499
        pgm_function50[(0, 57, 2)] = 0.59
        pgm_function50[(0, 57, 3)] = 0.25
        pgm_function50[(0, 58, 0)] = 0.8
        pgm_function50[(0, 58, 1)] = 0.8
        pgm_function50[(0, 58, 2)] = 0.6
        pgm_function50[(0, 58, 3)] = 0.25
        pgm_function50[(0, 59, 0)] = 0.9999
        pgm_function50[(0, 59, 1)] = 0.999
        pgm_function50[(0, 59, 2)] = 0.25
        pgm_function50[(0, 59, 3)] = 0.25
        pgm_function50[(0, 60, 0)] = 0.9999
        pgm_function50[(0, 60, 1)] = 0.999
        pgm_function50[(0, 60, 2)] = 0.25
        pgm_function50[(0, 60, 3)] = 0.25
        pgm_function50[(0, 61, 0)] = 0.9999
        pgm_function50[(0, 61, 1)] = 0.999
        pgm_function50[(0, 61, 2)] = 0.25
        pgm_function50[(0, 61, 3)] = 0.25
        pgm_function50[(0, 62, 0)] = 0.969
        pgm_function50[(0, 62, 1)] = 0.969
        pgm_function50[(0, 62, 2)] = 0.969
        pgm_function50[(0, 62, 3)] = 0.969
        pgm_function50[(0, 63, 0)] = 0.9999
        pgm_function50[(0, 63, 1)] = 0.9999
        pgm_function50[(0, 63, 2)] = 0.969
        pgm_function50[(0, 63, 3)] = 0.25
        pgm_function50[(0, 64, 0)] = 0.9499
        pgm_function50[(0, 64, 1)] = 0.9499
        pgm_function50[(0, 64, 2)] = 0.59
        pgm_function50[(0, 64, 3)] = 0.25
        pgm_function50[(0, 65, 0)] = 0.949
        pgm_function50[(0, 65, 1)] = 0.9499
        pgm_function50[(0, 65, 2)] = 0.59
        pgm_function50[(0, 65, 3)] = 0.25
        pgm_function50[(0, 66, 0)] = 0.969
        pgm_function50[(0, 66, 1)] = 0.969
        pgm_function50[(0, 66, 2)] = 0.96
        pgm_function50[(0, 66, 3)] = 0.25
        pgm_function50[(0, 67, 0)] = 0.9999
        pgm_function50[(0, 67, 1)] = 0.999
        pgm_function50[(0, 67, 2)] = 0.25
        pgm_function50[(0, 67, 3)] = 0.25
        pgm_function50[(0, 68, 0)] = 0.9999
        pgm_function50[(0, 68, 1)] = 0.999
        pgm_function50[(0, 68, 2)] = 0.25
        pgm_function50[(0, 68, 3)] = 0.25
        pgm_function50[(0, 69, 0)] = 0.9999
        pgm_function50[(0, 69, 1)] = 0.999
        pgm_function50[(0, 69, 2)] = 0.25
        pgm_function50[(0, 69, 3)] = 0.25
        pgm_function50[(0, 70, 0)] = 0.9999
        pgm_function50[(0, 70, 1)] = 0.999
        pgm_function50[(0, 70, 2)] = 0.25
        pgm_function50[(0, 70, 3)] = 0.25
        pgm_function50[(0, 71, 0)] = 0.9999
        pgm_function50[(0, 71, 1)] = 0.999
        pgm_function50[(0, 71, 2)] = 0.25
        pgm_function50[(0, 71, 3)] = 0.25
        pgm_function50[(0, 72, 0)] = 0.969
        pgm_function50[(0, 72, 1)] = 0.969
        pgm_function50[(0, 72, 2)] = 0.969
        pgm_function50[(0, 72, 3)] = 0.25
        pgm_function50[(0, 73, 0)] = 0.9999
        pgm_function50[(0, 73, 1)] = 0.999
        pgm_function50[(0, 73, 2)] = 0.25
        pgm_function50[(0, 73, 3)] = 0.25
        pgm_function50[(0, 74, 0)] = 0.969
        pgm_function50[(0, 74, 1)] = 0.969
        pgm_function50[(0, 74, 2)] = 0.969
        pgm_function50[(0, 74, 3)] = 0.25
        pgm_function50[(0, 75, 0)] = 0.9999
        pgm_function50[(0, 75, 1)] = 0.9999
        pgm_function50[(0, 75, 2)] = 0.969
        pgm_function50[(0, 75, 3)] = 0.25
        pgm_function50[(1, 0, 0)] = 0.0001
        pgm_function50[(1, 0, 1)] = 0.001
        pgm_function50[(1, 0, 2)] = 0.25
        pgm_function50[(1, 0, 3)] = 0.25
        pgm_function50[(1, 1, 0)] = 0.02
        pgm_function50[(1, 1, 1)] = 0.02
        pgm_function50[(1, 1, 2)] = 0.02
        pgm_function50[(1, 1, 3)] = 0.25
        pgm_function50[(1, 2, 0)] = 0.0001
        pgm_function50[(1, 2, 1)] = 0.001
        pgm_function50[(1, 2, 2)] = 0.25
        pgm_function50[(1, 2, 3)] = 0.25
        pgm_function50[(1, 3, 0)] = 0.0001
        pgm_function50[(1, 3, 1)] = 0.001
        pgm_function50[(1, 3, 2)] = 0.25
        pgm_function50[(1, 3, 3)] = 0.25
        pgm_function50[(1, 4, 0)] = 0.0001
        pgm_function50[(1, 4, 1)] = 0.001
        pgm_function50[(1, 4, 2)] = 0.25
        pgm_function50[(1, 4, 3)] = 0.25
        pgm_function50[(1, 5, 0)] = 0.0001
        pgm_function50[(1, 5, 1)] = 0.001
        pgm_function50[(1, 5, 2)] = 0.25
        pgm_function50[(1, 5, 3)] = 0.25
        pgm_function50[(1, 6, 0)] = 0.02
        pgm_function50[(1, 6, 1)] = 0.02
        pgm_function50[(1, 6, 2)] = 0.25
        pgm_function50[(1, 6, 3)] = 0.25
        pgm_function50[(1, 7, 0)] = 0.02
        pgm_function50[(1, 7, 1)] = 0.02
        pgm_function50[(1, 7, 2)] = 0.25
        pgm_function50[(1, 7, 3)] = 0.25
        pgm_function50[(1, 8, 0)] = 0.0001
        pgm_function50[(1, 8, 1)] = 0.001
        pgm_function50[(1, 8, 2)] = 0.25
        pgm_function50[(1, 8, 3)] = 0.25
        pgm_function50[(1, 9, 0)] = 0.0001
        pgm_function50[(1, 9, 1)] = 0.001
        pgm_function50[(1, 9, 2)] = 0.25
        pgm_function50[(1, 9, 3)] = 0.25
        pgm_function50[(1, 10, 0)] = 0.03
        pgm_function50[(1, 10, 1)] = 0.03
        pgm_function50[(1, 10, 2)] = 0.03
        pgm_function50[(1, 10, 3)] = 0.93
        pgm_function50[(1, 11, 0)] = 0.0001
        pgm_function50[(1, 11, 1)] = 0.001
        pgm_function50[(1, 11, 2)] = 0.25
        pgm_function50[(1, 11, 3)] = 0.25
        pgm_function50[(1, 12, 0)] = 0.0001
        pgm_function50[(1, 12, 1)] = 0.001
        pgm_function50[(1, 12, 2)] = 0.25
        pgm_function50[(1, 12, 3)] = 0.25
        pgm_function50[(1, 13, 0)] = 0.0001
        pgm_function50[(1, 13, 1)] = 0.001
        pgm_function50[(1, 13, 2)] = 0.25
        pgm_function50[(1, 13, 3)] = 0.25
        pgm_function50[(1, 14, 0)] = 0.01
        pgm_function50[(1, 14, 1)] = 0.01
        pgm_function50[(1, 14, 2)] = 0.25
        pgm_function50[(1, 14, 3)] = 0.25
        pgm_function50[(1, 15, 0)] = 0.01
        pgm_function50[(1, 15, 1)] = 0.01
        pgm_function50[(1, 15, 2)] = 0.25
        pgm_function50[(1, 15, 3)] = 0.25
        pgm_function50[(1, 16, 0)] = 0.0001
        pgm_function50[(1, 16, 1)] = 0.001
        pgm_function50[(1, 16, 2)] = 0.25
        pgm_function50[(1, 16, 3)] = 0.25
        pgm_function50[(1, 17, 0)] = 0.0001
        pgm_function50[(1, 17, 1)] = 0.001
        pgm_function50[(1, 17, 2)] = 0.25
        pgm_function50[(1, 17, 3)] = 0.25
        pgm_function50[(1, 18, 0)] = 0.0001
        pgm_function50[(1, 18, 1)] = 0.001
        pgm_function50[(1, 18, 2)] = 0.25
        pgm_function50[(1, 18, 3)] = 0.25
        pgm_function50[(1, 19, 0)] = 0.0001
        pgm_function50[(1, 19, 1)] = 0.001
        pgm_function50[(1, 19, 2)] = 0.25
        pgm_function50[(1, 19, 3)] = 0.25
        pgm_function50[(1, 20, 0)] = 0.0001
        pgm_function50[(1, 20, 1)] = 0.001
        pgm_function50[(1, 20, 2)] = 0.25
        pgm_function50[(1, 20, 3)] = 0.25
        pgm_function50[(1, 21, 0)] = 0.0001
        pgm_function50[(1, 21, 1)] = 0.001
        pgm_function50[(1, 21, 2)] = 0.25
        pgm_function50[(1, 21, 3)] = 0.25
        pgm_function50[(1, 22, 0)] = 0.0001
        pgm_function50[(1, 22, 1)] = 0.001
        pgm_function50[(1, 22, 2)] = 0.25
        pgm_function50[(1, 22, 3)] = 0.25
        pgm_function50[(1, 23, 0)] = 0.01
        pgm_function50[(1, 23, 1)] = 0.01
        pgm_function50[(1, 23, 2)] = 0.03
        pgm_function50[(1, 23, 3)] = 0.25
        pgm_function50[(1, 24, 0)] = 0.0001
        pgm_function50[(1, 24, 1)] = 0.001
        pgm_function50[(1, 24, 2)] = 0.25
        pgm_function50[(1, 24, 3)] = 0.25
        pgm_function50[(1, 25, 0)] = 0.98
        pgm_function50[(1, 25, 1)] = 0.98
        pgm_function50[(1, 25, 2)] = 0.98
        pgm_function50[(1, 25, 3)] = 0.25
        pgm_function50[(1, 26, 0)] = 0.98
        pgm_function50[(1, 26, 1)] = 0.98
        pgm_function50[(1, 26, 2)] = 0.98
        pgm_function50[(1, 26, 3)] = 0.25
        pgm_function50[(1, 27, 0)] = 0.05
        pgm_function50[(1, 27, 1)] = 0.05
        pgm_function50[(1, 27, 2)] = 0.02
        pgm_function50[(1, 27, 3)] = 0.000999001
        pgm_function50[(1, 28, 0)] = 0.05
        pgm_function50[(1, 28, 1)] = 0.05
        pgm_function50[(1, 28, 2)] = 0.02
        pgm_function50[(1, 28, 3)] = 0.000999001
        pgm_function50[(1, 29, 0)] = 0.05
        pgm_function50[(1, 29, 1)] = 0.05
        pgm_function50[(1, 29, 2)] = 0.02
        pgm_function50[(1, 29, 3)] = 0.000999001
        pgm_function50[(1, 30, 0)] = 0.001
        pgm_function50[(1, 30, 1)] = 0.001
        pgm_function50[(1, 30, 2)] = 0.01
        pgm_function50[(1, 31, 0)] = 0.2
        pgm_function50[(1, 31, 1)] = 0.2
        pgm_function50[(1, 31, 2)] = 0.05
        pgm_function50[(1, 31, 3)] = 0.05
        pgm_function50[(1, 32, 0)] = 0.05
        pgm_function50[(1, 32, 1)] = 0.05
        pgm_function50[(1, 32, 2)] = 0.02
        pgm_function50[(1, 32, 3)] = 0.000999001
        pgm_function50[(1, 33, 0)] = 0.01
        pgm_function50[(1, 33, 1)] = 0.01
        pgm_function50[(1, 33, 3)] = 9.999e-05
        pgm_function50[(1, 34, 0)] = 0.0001
        pgm_function50[(1, 34, 1)] = 0.0001
        pgm_function50[(1, 34, 2)] = 0.25
        pgm_function50[(1, 34, 3)] = 0.25
        pgm_function50[(1, 35, 0)] = 0.0001
        pgm_function50[(1, 35, 1)] = 0.0001
        pgm_function50[(1, 35, 2)] = 0.25
        pgm_function50[(1, 35, 3)] = 0.25
        pgm_function50[(1, 36, 0)] = 0.0001
        pgm_function50[(1, 36, 1)] = 0.0001
        pgm_function50[(1, 36, 2)] = 0.25
        pgm_function50[(1, 36, 3)] = 0.25
        pgm_function50[(1, 37, 0)] = 0.0001
        pgm_function50[(1, 37, 1)] = 0.0001
        pgm_function50[(1, 37, 2)] = 0.25
        pgm_function50[(1, 37, 3)] = 0.25
        pgm_function50[(1, 38, 0)] = 0.02
        pgm_function50[(1, 38, 1)] = 0.02
        pgm_function50[(1, 38, 2)] = 0.04
        pgm_function50[(1, 38, 3)] = 0.25
        pgm_function50[(1, 39, 0)] = 0.02
        pgm_function50[(1, 39, 1)] = 0.02
        pgm_function50[(1, 39, 2)] = 0.02
        pgm_function50[(1, 39, 3)] = 0.1
        pgm_function50[(1, 40, 0)] = 0.0001
        pgm_function50[(1, 40, 1)] = 0.0001
        pgm_function50[(1, 40, 2)] = 0.02
        pgm_function50[(1, 40, 3)] = 0.25
        pgm_function50[(1, 41, 0)] = 0.0001
        pgm_function50[(1, 41, 1)] = 0.0001
        pgm_function50[(1, 41, 2)] = 0.02
        pgm_function50[(1, 41, 3)] = 0.25
        pgm_function50[(1, 42, 0)] = 0.02
        pgm_function50[(1, 42, 1)] = 0.02
        pgm_function50[(1, 42, 2)] = 0.02
        pgm_function50[(1, 42, 3)] = 0.25
        pgm_function50[(1, 43, 0)] = 0.02
        pgm_function50[(1, 43, 1)] = 0.02
        pgm_function50[(1, 43, 2)] = 0.02
        pgm_function50[(1, 43, 3)] = 0.05
        pgm_function50[(1, 44, 0)] = 0.07
        pgm_function50[(1, 44, 1)] = 0.07
        pgm_function50[(1, 44, 2)] = 0.07
        pgm_function50[(1, 44, 3)] = 0.25
        pgm_function50[(1, 45, 0)] = 0.02
        pgm_function50[(1, 45, 1)] = 0.02
        pgm_function50[(1, 45, 2)] = 0.02
        pgm_function50[(1, 45, 3)] = 0.25
        pgm_function50[(1, 46, 0)] = 0.02
        pgm_function50[(1, 46, 1)] = 0.02
        pgm_function50[(1, 46, 2)] = 0.02
        pgm_function50[(1, 46, 3)] = 0.25
        pgm_function50[(1, 47, 0)] = 0.02
        pgm_function50[(1, 47, 1)] = 0.02
        pgm_function50[(1, 47, 2)] = 0.02
        pgm_function50[(1, 47, 3)] = 0.02
        pgm_function50[(1, 48, 0)] = 0.0001
        pgm_function50[(1, 48, 1)] = 0.0001
        pgm_function50[(1, 48, 2)] = 0.02
        pgm_function50[(1, 48, 3)] = 0.25
        pgm_function50[(1, 49, 0)] = 0.02
        pgm_function50[(1, 49, 1)] = 0.02
        pgm_function50[(1, 49, 2)] = 0.02
        pgm_function50[(1, 49, 3)] = 0.05
        pgm_function50[(1, 50, 0)] = 0.02
        pgm_function50[(1, 50, 1)] = 0.02
        pgm_function50[(1, 50, 2)] = 0.02
        pgm_function50[(1, 50, 3)] = 0.05
        pgm_function50[(1, 51, 0)] = 0.02
        pgm_function50[(1, 51, 1)] = 0.02
        pgm_function50[(1, 51, 2)] = 0.02
        pgm_function50[(1, 51, 3)] = 0.25
        pgm_function50[(1, 52, 0)] = 0.3
        pgm_function50[(1, 52, 1)] = 0.3
        pgm_function50[(1, 52, 2)] = 0.35
        pgm_function50[(1, 52, 3)] = 0.000999001
        pgm_function50[(1, 53, 0)] = 0.02
        pgm_function50[(1, 53, 1)] = 0.02
        pgm_function50[(1, 53, 2)] = 0.02
        pgm_function50[(1, 53, 3)] = 0.25
        pgm_function50[(1, 54, 0)] = 0.0001
        pgm_function50[(1, 54, 1)] = 0.001
        pgm_function50[(1, 54, 2)] = 0.25
        pgm_function50[(1, 54, 3)] = 0.25
        pgm_function50[(1, 55, 0)] = 0.0001
        pgm_function50[(1, 55, 1)] = 0.001
        pgm_function50[(1, 55, 2)] = 0.25
        pgm_function50[(1, 55, 3)] = 0.25
        pgm_function50[(1, 56, 0)] = 0.04
        pgm_function50[(1, 56, 1)] = 0.04
        pgm_function50[(1, 56, 2)] = 0.3
        pgm_function50[(1, 56, 3)] = 0.25
        pgm_function50[(1, 57, 0)] = 0.04
        pgm_function50[(1, 57, 1)] = 0.04
        pgm_function50[(1, 57, 2)] = 0.3
        pgm_function50[(1, 57, 3)] = 0.25
        pgm_function50[(1, 58, 0)] = 0.15
        pgm_function50[(1, 58, 1)] = 0.15
        pgm_function50[(1, 58, 2)] = 0.25
        pgm_function50[(1, 58, 3)] = 0.25
        pgm_function50[(1, 59, 0)] = 0.0001
        pgm_function50[(1, 59, 1)] = 0.001
        pgm_function50[(1, 59, 2)] = 0.25
        pgm_function50[(1, 59, 3)] = 0.25
        pgm_function50[(1, 60, 0)] = 0.0001
        pgm_function50[(1, 60, 1)] = 0.001
        pgm_function50[(1, 60, 2)] = 0.25
        pgm_function50[(1, 60, 3)] = 0.25
        pgm_function50[(1, 61, 0)] = 0.0001
        pgm_function50[(1, 61, 1)] = 0.001
        pgm_function50[(1, 61, 2)] = 0.25
        pgm_function50[(1, 61, 3)] = 0.25
        pgm_function50[(1, 62, 0)] = 0.02
        pgm_function50[(1, 62, 1)] = 0.02
        pgm_function50[(1, 62, 2)] = 0.02
        pgm_function50[(1, 62, 3)] = 0.02
        pgm_function50[(1, 63, 0)] = 0.0001
        pgm_function50[(1, 63, 1)] = 0.0001
        pgm_function50[(1, 63, 2)] = 0.02
        pgm_function50[(1, 63, 3)] = 0.25
        pgm_function50[(1, 64, 0)] = 0.04
        pgm_function50[(1, 64, 1)] = 0.04
        pgm_function50[(1, 64, 2)] = 0.3
        pgm_function50[(1, 64, 3)] = 0.25
        pgm_function50[(1, 65, 0)] = 0.04
        pgm_function50[(1, 65, 1)] = 0.04
        pgm_function50[(1, 65, 2)] = 0.3
        pgm_function50[(1, 65, 3)] = 0.25
        pgm_function50[(1, 66, 0)] = 0.03
        pgm_function50[(1, 66, 1)] = 0.03
        pgm_function50[(1, 66, 2)] = 0.03
        pgm_function50[(1, 66, 3)] = 0.25
        pgm_function50[(1, 67, 0)] = 0.0001
        pgm_function50[(1, 67, 1)] = 0.001
        pgm_function50[(1, 67, 2)] = 0.25
        pgm_function50[(1, 67, 3)] = 0.25
        pgm_function50[(1, 68, 0)] = 0.0001
        pgm_function50[(1, 68, 1)] = 0.001
        pgm_function50[(1, 68, 2)] = 0.25
        pgm_function50[(1, 68, 3)] = 0.25
        pgm_function50[(1, 69, 0)] = 0.0001
        pgm_function50[(1, 69, 1)] = 0.001
        pgm_function50[(1, 69, 2)] = 0.25
        pgm_function50[(1, 69, 3)] = 0.25
        pgm_function50[(1, 70, 0)] = 0.0001
        pgm_function50[(1, 70, 1)] = 0.001
        pgm_function50[(1, 70, 2)] = 0.25
        pgm_function50[(1, 70, 3)] = 0.25
        pgm_function50[(1, 71, 0)] = 0.0001
        pgm_function50[(1, 71, 1)] = 0.001
        pgm_function50[(1, 71, 2)] = 0.25
        pgm_function50[(1, 71, 3)] = 0.25
        pgm_function50[(1, 72, 0)] = 0.02
        pgm_function50[(1, 72, 1)] = 0.02
        pgm_function50[(1, 72, 2)] = 0.02
        pgm_function50[(1, 72, 3)] = 0.25
        pgm_function50[(1, 73, 0)] = 0.0001
        pgm_function50[(1, 73, 1)] = 0.001
        pgm_function50[(1, 73, 2)] = 0.25
        pgm_function50[(1, 73, 3)] = 0.25
        pgm_function50[(1, 74, 0)] = 0.02
        pgm_function50[(1, 74, 1)] = 0.02
        pgm_function50[(1, 74, 2)] = 0.02
        pgm_function50[(1, 74, 3)] = 0.25
        pgm_function50[(1, 75, 0)] = 0.0001
        pgm_function50[(1, 75, 1)] = 0.0001
        pgm_function50[(1, 75, 2)] = 0.02
        pgm_function50[(1, 75, 3)] = 0.25
        pgm_function50[(2, 0, 2)] = 0.25
        pgm_function50[(2, 0, 3)] = 0.25
        pgm_function50[(2, 1, 0)] = 0.01
        pgm_function50[(2, 1, 1)] = 0.01
        pgm_function50[(2, 1, 2)] = 0.01
        pgm_function50[(2, 1, 3)] = 0.25
        pgm_function50[(2, 2, 2)] = 0.25
        pgm_function50[(2, 2, 3)] = 0.25
        pgm_function50[(2, 3, 2)] = 0.25
        pgm_function50[(2, 3, 3)] = 0.25
        pgm_function50[(2, 4, 2)] = 0.25
        pgm_function50[(2, 4, 3)] = 0.25
        pgm_function50[(2, 5, 2)] = 0.25
        pgm_function50[(2, 5, 3)] = 0.25
        pgm_function50[(2, 6, 2)] = 0.25
        pgm_function50[(2, 6, 3)] = 0.25
        pgm_function50[(2, 7, 2)] = 0.25
        pgm_function50[(2, 7, 3)] = 0.25
        pgm_function50[(2, 8, 2)] = 0.25
        pgm_function50[(2, 8, 3)] = 0.25
        pgm_function50[(2, 9, 2)] = 0.25
        pgm_function50[(2, 9, 3)] = 0.25
        pgm_function50[(2, 10, 0)] = 0.001
        pgm_function50[(2, 10, 1)] = 0.001
        pgm_function50[(2, 10, 2)] = 0.01
        pgm_function50[(2, 10, 3)] = 0.05
        pgm_function50[(2, 11, 2)] = 0.25
        pgm_function50[(2, 11, 3)] = 0.25
        pgm_function50[(2, 12, 2)] = 0.25
        pgm_function50[(2, 12, 3)] = 0.25
        pgm_function50[(2, 13, 2)] = 0.25
        pgm_function50[(2, 13, 3)] = 0.25
        pgm_function50[(2, 14, 2)] = 0.25
        pgm_function50[(2, 14, 3)] = 0.25
        pgm_function50[(2, 15, 2)] = 0.25
        pgm_function50[(2, 15, 3)] = 0.25
        pgm_function50[(2, 16, 2)] = 0.25
        pgm_function50[(2, 16, 3)] = 0.25
        pgm_function50[(2, 17, 2)] = 0.25
        pgm_function50[(2, 17, 3)] = 0.25
        pgm_function50[(2, 18, 2)] = 0.25
        pgm_function50[(2, 18, 3)] = 0.25
        pgm_function50[(2, 19, 2)] = 0.25
        pgm_function50[(2, 19, 3)] = 0.25
        pgm_function50[(2, 20, 2)] = 0.25
        pgm_function50[(2, 20, 3)] = 0.25
        pgm_function50[(2, 21, 2)] = 0.25
        pgm_function50[(2, 21, 3)] = 0.25
        pgm_function50[(2, 22, 2)] = 0.25
        pgm_function50[(2, 22, 3)] = 0.25
        pgm_function50[(2, 23, 0)] = 0.001
        pgm_function50[(2, 23, 1)] = 0.001
        pgm_function50[(2, 23, 2)] = 0.01
        pgm_function50[(2, 23, 3)] = 0.25
        pgm_function50[(2, 24, 2)] = 0.25
        pgm_function50[(2, 24, 3)] = 0.25
        pgm_function50[(2, 25, 0)] = 0.01
        pgm_function50[(2, 25, 1)] = 0.01
        pgm_function50[(2, 25, 2)] = 0.01
        pgm_function50[(2, 25, 3)] = 0.25
        pgm_function50[(2, 26, 0)] = 0.01
        pgm_function50[(2, 26, 1)] = 0.01
        pgm_function50[(2, 26, 2)] = 0.01
        pgm_function50[(2, 26, 3)] = 0.25
        pgm_function50[(2, 27, 0)] = 0.85
        pgm_function50[(2, 27, 1)] = 0.85
        pgm_function50[(2, 27, 2)] = 0.83
        pgm_function50[(2, 27, 3)] = 0.749250749
        pgm_function50[(2, 28, 0)] = 0.85
        pgm_function50[(2, 28, 1)] = 0.85
        pgm_function50[(2, 28, 2)] = 0.83
        pgm_function50[(2, 28, 3)] = 0.749250749
        pgm_function50[(2, 29, 0)] = 0.85
        pgm_function50[(2, 29, 1)] = 0.85
        pgm_function50[(2, 29, 2)] = 0.83
        pgm_function50[(2, 29, 3)] = 0.749250749
        pgm_function50[(2, 30, 0)] = 0.849
        pgm_function50[(2, 30, 1)] = 0.849
        pgm_function50[(2, 30, 2)] = 0.84
        pgm_function50[(2, 30, 3)] = 0.65
        pgm_function50[(2, 31, 0)] = 0.75
        pgm_function50[(2, 31, 1)] = 0.75
        pgm_function50[(2, 31, 2)] = 0.83
        pgm_function50[(2, 31, 3)] = 0.8
        pgm_function50[(2, 32, 0)] = 0.15
        pgm_function50[(2, 32, 1)] = 0.15
        pgm_function50[(2, 32, 2)] = 0.15
        pgm_function50[(2, 32, 3)] = 0.0999001
        pgm_function50[(2, 33, 0)] = 0.2
        pgm_function50[(2, 33, 1)] = 0.2
        pgm_function50[(2, 33, 2)] = 0.15
        pgm_function50[(2, 33, 3)] = 0.049995
        pgm_function50[(2, 34, 2)] = 0.25
        pgm_function50[(2, 34, 3)] = 0.25
        pgm_function50[(2, 35, 2)] = 0.25
        pgm_function50[(2, 35, 3)] = 0.25
        pgm_function50[(2, 36, 2)] = 0.25
        pgm_function50[(2, 36, 3)] = 0.25
        pgm_function50[(2, 37, 2)] = 0.25
        pgm_function50[(2, 37, 3)] = 0.25
        pgm_function50[(2, 38, 0)] = 0.01
        pgm_function50[(2, 38, 1)] = 0.01
        pgm_function50[(2, 38, 2)] = 0.02
        pgm_function50[(2, 38, 3)] = 0.25
        pgm_function50[(2, 39, 0)] = 0.01
        pgm_function50[(2, 39, 1)] = 0.01
        pgm_function50[(2, 39, 2)] = 0.01
        pgm_function50[(2, 39, 3)] = 0.09
        pgm_function50[(2, 40, 2)] = 0.01
        pgm_function50[(2, 40, 3)] = 0.25
        pgm_function50[(2, 41, 2)] = 0.01
        pgm_function50[(2, 41, 3)] = 0.25
        pgm_function50[(2, 42, 0)] = 0.01
        pgm_function50[(2, 42, 1)] = 0.01
        pgm_function50[(2, 42, 2)] = 0.01
        pgm_function50[(2, 42, 3)] = 0.25
        pgm_function50[(2, 43, 0)] = 0.01
        pgm_function50[(2, 43, 1)] = 0.01
        pgm_function50[(2, 43, 2)] = 0.01
        pgm_function50[(2, 43, 3)] = 0.02
        pgm_function50[(2, 44, 0)] = 0.04
        pgm_function50[(2, 44, 1)] = 0.04
        pgm_function50[(2, 44, 2)] = 0.04
        pgm_function50[(2, 44, 3)] = 0.25
        pgm_function50[(2, 45, 0)] = 0.01
        pgm_function50[(2, 45, 1)] = 0.01
        pgm_function50[(2, 45, 2)] = 0.01
        pgm_function50[(2, 45, 3)] = 0.25
        pgm_function50[(2, 46, 0)] = 0.01
        pgm_function50[(2, 46, 1)] = 0.01
        pgm_function50[(2, 46, 2)] = 0.01
        pgm_function50[(2, 46, 3)] = 0.25
        pgm_function50[(2, 47, 0)] = 0.01
        pgm_function50[(2, 47, 1)] = 0.01
        pgm_function50[(2, 47, 2)] = 0.01
        pgm_function50[(2, 47, 3)] = 0.01
        pgm_function50[(2, 48, 2)] = 0.01
        pgm_function50[(2, 48, 3)] = 0.25
        pgm_function50[(2, 49, 0)] = 0.01
        pgm_function50[(2, 49, 1)] = 0.01
        pgm_function50[(2, 49, 2)] = 0.01
        pgm_function50[(2, 49, 3)] = 0.02
        pgm_function50[(2, 50, 0)] = 0.01
        pgm_function50[(2, 50, 1)] = 0.01
        pgm_function50[(2, 50, 2)] = 0.01
        pgm_function50[(2, 50, 3)] = 0.02
        pgm_function50[(2, 51, 0)] = 0.01
        pgm_function50[(2, 51, 1)] = 0.01
        pgm_function50[(2, 51, 2)] = 0.01
        pgm_function50[(2, 51, 3)] = 0.25
        pgm_function50[(2, 52, 0)] = 0.2
        pgm_function50[(2, 52, 1)] = 0.2
        pgm_function50[(2, 52, 2)] = 0.25
        pgm_function50[(2, 52, 3)] = 0.599400599
        pgm_function50[(2, 53, 0)] = 0.01
        pgm_function50[(2, 53, 1)] = 0.01
        pgm_function50[(2, 53, 2)] = 0.01
        pgm_function50[(2, 53, 3)] = 0.25
        pgm_function50[(2, 54, 2)] = 0.25
        pgm_function50[(2, 54, 3)] = 0.25
        pgm_function50[(2, 55, 2)] = 0.25
        pgm_function50[(2, 55, 3)] = 0.25
        pgm_function50[(2, 56, 0)] = 0.01
        pgm_function50[(2, 56, 1)] = 0.01
        pgm_function50[(2, 56, 2)] = 0.1
        pgm_function50[(2, 56, 3)] = 0.25
        pgm_function50[(2, 57, 0)] = 0.01
        pgm_function50[(2, 57, 1)] = 0.01
        pgm_function50[(2, 57, 2)] = 0.1
        pgm_function50[(2, 57, 3)] = 0.25
        pgm_function50[(2, 58, 0)] = 0.04
        pgm_function50[(2, 58, 1)] = 0.04
        pgm_function50[(2, 58, 2)] = 0.1
        pgm_function50[(2, 58, 3)] = 0.25
        pgm_function50[(2, 59, 2)] = 0.25
        pgm_function50[(2, 59, 3)] = 0.25
        pgm_function50[(2, 60, 2)] = 0.25
        pgm_function50[(2, 60, 3)] = 0.25
        pgm_function50[(2, 61, 2)] = 0.25
        pgm_function50[(2, 61, 3)] = 0.25
        pgm_function50[(2, 62, 0)] = 0.01
        pgm_function50[(2, 62, 1)] = 0.01
        pgm_function50[(2, 62, 2)] = 0.01
        pgm_function50[(2, 62, 3)] = 0.01
        pgm_function50[(2, 63, 2)] = 0.01
        pgm_function50[(2, 63, 3)] = 0.25
        pgm_function50[(2, 64, 0)] = 0.01
        pgm_function50[(2, 64, 1)] = 0.01
        pgm_function50[(2, 64, 2)] = 0.1
        pgm_function50[(2, 64, 3)] = 0.25
        pgm_function50[(2, 65, 0)] = 0.01
        pgm_function50[(2, 65, 1)] = 0.01
        pgm_function50[(2, 65, 2)] = 0.1
        pgm_function50[(2, 65, 3)] = 0.25
        pgm_function50[(2, 66, 0)] = 0.001
        pgm_function50[(2, 66, 1)] = 0.001
        pgm_function50[(2, 66, 2)] = 0.01
        pgm_function50[(2, 66, 3)] = 0.25
        pgm_function50[(2, 67, 2)] = 0.25
        pgm_function50[(2, 67, 3)] = 0.25
        pgm_function50[(2, 68, 2)] = 0.25
        pgm_function50[(2, 68, 3)] = 0.25
        pgm_function50[(2, 69, 2)] = 0.25
        pgm_function50[(2, 69, 3)] = 0.25
        pgm_function50[(2, 70, 2)] = 0.25
        pgm_function50[(2, 70, 3)] = 0.25
        pgm_function50[(2, 71, 2)] = 0.25
        pgm_function50[(2, 71, 3)] = 0.25
        pgm_function50[(2, 72, 0)] = 0.01
        pgm_function50[(2, 72, 1)] = 0.01
        pgm_function50[(2, 72, 2)] = 0.01
        pgm_function50[(2, 72, 3)] = 0.25
        pgm_function50[(2, 73, 2)] = 0.25
        pgm_function50[(2, 73, 3)] = 0.25
        pgm_function50[(2, 74, 0)] = 0.01
        pgm_function50[(2, 74, 1)] = 0.01
        pgm_function50[(2, 74, 2)] = 0.01
        pgm_function50[(2, 74, 3)] = 0.25
        pgm_function50[(2, 75, 2)] = 0.01
        pgm_function50[(2, 75, 3)] = 0.25
        pgm_function50[(3, 0, 2)] = 0.25
        pgm_function50[(3, 0, 3)] = 0.25
        pgm_function50[(3, 1, 0)] = 0.001
        pgm_function50[(3, 1, 1)] = 0.001
        pgm_function50[(3, 1, 2)] = 0.001
        pgm_function50[(3, 1, 3)] = 0.25
        pgm_function50[(3, 2, 2)] = 0.25
        pgm_function50[(3, 2, 3)] = 0.25
        pgm_function50[(3, 3, 2)] = 0.25
        pgm_function50[(3, 3, 3)] = 0.25
        pgm_function50[(3, 4, 2)] = 0.25
        pgm_function50[(3, 4, 3)] = 0.25
        pgm_function50[(3, 5, 2)] = 0.25
        pgm_function50[(3, 5, 3)] = 0.25
        pgm_function50[(3, 6, 2)] = 0.25
        pgm_function50[(3, 6, 3)] = 0.25
        pgm_function50[(3, 7, 2)] = 0.25
        pgm_function50[(3, 7, 3)] = 0.25
        pgm_function50[(3, 8, 2)] = 0.25
        pgm_function50[(3, 8, 3)] = 0.25
        pgm_function50[(3, 9, 2)] = 0.25
        pgm_function50[(3, 9, 3)] = 0.25
        pgm_function50[(3, 10, 2)] = 0.001
        pgm_function50[(3, 10, 3)] = 0.01
        pgm_function50[(3, 11, 2)] = 0.25
        pgm_function50[(3, 11, 3)] = 0.25
        pgm_function50[(3, 12, 2)] = 0.25
        pgm_function50[(3, 12, 3)] = 0.25
        pgm_function50[(3, 13, 2)] = 0.25
        pgm_function50[(3, 13, 3)] = 0.25
        pgm_function50[(3, 14, 2)] = 0.25
        pgm_function50[(3, 14, 3)] = 0.25
        pgm_function50[(3, 15, 2)] = 0.25
        pgm_function50[(3, 15, 3)] = 0.25
        pgm_function50[(3, 16, 2)] = 0.25
        pgm_function50[(3, 16, 3)] = 0.25
        pgm_function50[(3, 17, 2)] = 0.25
        pgm_function50[(3, 17, 3)] = 0.25
        pgm_function50[(3, 18, 2)] = 0.25
        pgm_function50[(3, 18, 3)] = 0.25
        pgm_function50[(3, 19, 2)] = 0.25
        pgm_function50[(3, 19, 3)] = 0.25
        pgm_function50[(3, 20, 2)] = 0.25
        pgm_function50[(3, 20, 3)] = 0.25
        pgm_function50[(3, 21, 2)] = 0.25
        pgm_function50[(3, 21, 3)] = 0.25
        pgm_function50[(3, 22, 2)] = 0.25
        pgm_function50[(3, 22, 3)] = 0.25
        pgm_function50[(3, 23, 3)] = 0.25
        pgm_function50[(3, 24, 2)] = 0.25
        pgm_function50[(3, 24, 3)] = 0.25
        pgm_function50[(3, 25, 3)] = 0.25
        pgm_function50[(3, 26, 3)] = 0.25
        pgm_function50[(3, 27, 0)] = 0.1
        pgm_function50[(3, 27, 1)] = 0.1
        pgm_function50[(3, 27, 2)] = 0.15
        pgm_function50[(3, 27, 3)] = 0.24975025
        pgm_function50[(3, 28, 0)] = 0.1
        pgm_function50[(3, 28, 1)] = 0.1
        pgm_function50[(3, 28, 2)] = 0.15
        pgm_function50[(3, 28, 3)] = 0.24975025
        pgm_function50[(3, 29, 0)] = 0.1
        pgm_function50[(3, 29, 1)] = 0.1
        pgm_function50[(3, 29, 2)] = 0.15
        pgm_function50[(3, 29, 3)] = 0.24975025
        pgm_function50[(3, 30, 0)] = 0.15
        pgm_function50[(3, 30, 1)] = 0.15
        pgm_function50[(3, 30, 2)] = 0.15
        pgm_function50[(3, 30, 3)] = 0.35
        pgm_function50[(3, 31, 0)] = 0.05
        pgm_function50[(3, 31, 1)] = 0.05
        pgm_function50[(3, 31, 2)] = 0.12
        pgm_function50[(3, 31, 3)] = 0.15
        pgm_function50[(3, 32, 0)] = 0.8
        pgm_function50[(3, 32, 1)] = 0.8
        pgm_function50[(3, 32, 2)] = 0.83
        pgm_function50[(3, 32, 3)] = 0.899100899
        pgm_function50[(3, 33, 0)] = 0.79
        pgm_function50[(3, 33, 1)] = 0.79
        pgm_function50[(3, 33, 2)] = 0.85
        pgm_function50[(3, 33, 3)] = 0.94990501
        pgm_function50[(3, 34, 2)] = 0.25
        pgm_function50[(3, 34, 3)] = 0.25
        pgm_function50[(3, 35, 2)] = 0.25
        pgm_function50[(3, 35, 3)] = 0.25
        pgm_function50[(3, 36, 2)] = 0.25
        pgm_function50[(3, 36, 3)] = 0.25
        pgm_function50[(3, 37, 2)] = 0.25
        pgm_function50[(3, 37, 3)] = 0.25
        pgm_function50[(3, 38, 0)] = 0.001
        pgm_function50[(3, 38, 1)] = 0.001
        pgm_function50[(3, 38, 2)] = 0.001
        pgm_function50[(3, 38, 3)] = 0.25
        pgm_function50[(3, 39, 0)] = 0.001
        pgm_function50[(3, 39, 1)] = 0.001
        pgm_function50[(3, 39, 2)] = 0.001
        pgm_function50[(3, 39, 3)] = 0.01
        pgm_function50[(3, 40, 2)] = 0.001
        pgm_function50[(3, 40, 3)] = 0.25
        pgm_function50[(3, 41, 2)] = 0.001
        pgm_function50[(3, 41, 3)] = 0.25
        pgm_function50[(3, 42, 0)] = 0.001
        pgm_function50[(3, 42, 1)] = 0.001
        pgm_function50[(3, 42, 2)] = 0.001
        pgm_function50[(3, 42, 3)] = 0.25
        pgm_function50[(3, 43, 0)] = 0.001
        pgm_function50[(3, 43, 1)] = 0.001
        pgm_function50[(3, 43, 2)] = 0.001
        pgm_function50[(3, 43, 3)] = 0.005
        pgm_function50[(3, 44, 0)] = 0.01
        pgm_function50[(3, 44, 1)] = 0.01
        pgm_function50[(3, 44, 2)] = 0.01
        pgm_function50[(3, 44, 3)] = 0.25
        pgm_function50[(3, 45, 0)] = 0.001
        pgm_function50[(3, 45, 1)] = 0.001
        pgm_function50[(3, 45, 2)] = 0.001
        pgm_function50[(3, 45, 3)] = 0.25
        pgm_function50[(3, 46, 0)] = 0.001
        pgm_function50[(3, 46, 1)] = 0.001
        pgm_function50[(3, 46, 2)] = 0.001
        pgm_function50[(3, 46, 3)] = 0.25
        pgm_function50[(3, 47, 0)] = 0.001
        pgm_function50[(3, 47, 1)] = 0.001
        pgm_function50[(3, 47, 2)] = 0.001
        pgm_function50[(3, 47, 3)] = 0.001
        pgm_function50[(3, 48, 2)] = 0.001
        pgm_function50[(3, 48, 3)] = 0.25
        pgm_function50[(3, 49, 0)] = 0.001
        pgm_function50[(3, 49, 1)] = 0.001
        pgm_function50[(3, 49, 2)] = 0.001
        pgm_function50[(3, 49, 3)] = 0.005
        pgm_function50[(3, 50, 0)] = 0.001
        pgm_function50[(3, 50, 1)] = 0.001
        pgm_function50[(3, 50, 2)] = 0.001
        pgm_function50[(3, 50, 3)] = 0.005
        pgm_function50[(3, 51, 0)] = 0.001
        pgm_function50[(3, 51, 1)] = 0.001
        pgm_function50[(3, 51, 2)] = 0.001
        pgm_function50[(3, 51, 3)] = 0.25
        pgm_function50[(3, 52, 0)] = 0.05
        pgm_function50[(3, 52, 1)] = 0.05
        pgm_function50[(3, 52, 2)] = 0.1
        pgm_function50[(3, 52, 3)] = 0.3996004
        pgm_function50[(3, 53, 0)] = 0.001
        pgm_function50[(3, 53, 1)] = 0.001
        pgm_function50[(3, 53, 2)] = 0.001
        pgm_function50[(3, 53, 3)] = 0.25
        pgm_function50[(3, 54, 2)] = 0.25
        pgm_function50[(3, 54, 3)] = 0.25
        pgm_function50[(3, 55, 2)] = 0.25
        pgm_function50[(3, 55, 3)] = 0.25
        pgm_function50[(3, 56, 0)] = 0.0001
        pgm_function50[(3, 56, 1)] = 0.0001
        pgm_function50[(3, 56, 2)] = 0.01
        pgm_function50[(3, 56, 3)] = 0.25
        pgm_function50[(3, 57, 0)] = 0.0001
        pgm_function50[(3, 57, 1)] = 0.0001
        pgm_function50[(3, 57, 2)] = 0.01
        pgm_function50[(3, 57, 3)] = 0.25
        pgm_function50[(3, 58, 0)] = 0.01
        pgm_function50[(3, 58, 1)] = 0.01
        pgm_function50[(3, 58, 2)] = 0.05
        pgm_function50[(3, 58, 3)] = 0.25
        pgm_function50[(3, 59, 2)] = 0.25
        pgm_function50[(3, 59, 3)] = 0.25
        pgm_function50[(3, 60, 2)] = 0.25
        pgm_function50[(3, 60, 3)] = 0.25
        pgm_function50[(3, 61, 2)] = 0.25
        pgm_function50[(3, 61, 3)] = 0.25
        pgm_function50[(3, 62, 0)] = 0.001
        pgm_function50[(3, 62, 1)] = 0.001
        pgm_function50[(3, 62, 2)] = 0.001
        pgm_function50[(3, 62, 3)] = 0.001
        pgm_function50[(3, 63, 2)] = 0.001
        pgm_function50[(3, 63, 3)] = 0.25
        pgm_function50[(3, 64, 0)] = 0.0001
        pgm_function50[(3, 64, 1)] = 0.0001
        pgm_function50[(3, 64, 2)] = 0.01
        pgm_function50[(3, 64, 3)] = 0.25
        pgm_function50[(3, 65, 0)] = 0.001
        pgm_function50[(3, 65, 1)] = 0.0001
        pgm_function50[(3, 65, 2)] = 0.01
        pgm_function50[(3, 65, 3)] = 0.25
        pgm_function50[(3, 66, 3)] = 0.25
        pgm_function50[(3, 67, 2)] = 0.25
        pgm_function50[(3, 67, 3)] = 0.25
        pgm_function50[(3, 68, 2)] = 0.25
        pgm_function50[(3, 68, 3)] = 0.25
        pgm_function50[(3, 69, 2)] = 0.25
        pgm_function50[(3, 69, 3)] = 0.25
        pgm_function50[(3, 70, 2)] = 0.25
        pgm_function50[(3, 70, 3)] = 0.25
        pgm_function50[(3, 71, 2)] = 0.25
        pgm_function50[(3, 71, 3)] = 0.25
        pgm_function50[(3, 72, 0)] = 0.001
        pgm_function50[(3, 72, 1)] = 0.001
        pgm_function50[(3, 72, 2)] = 0.001
        pgm_function50[(3, 72, 3)] = 0.25
        pgm_function50[(3, 73, 2)] = 0.25
        pgm_function50[(3, 73, 3)] = 0.25
        pgm_function50[(3, 74, 0)] = 0.001
        pgm_function50[(3, 74, 1)] = 0.001
        pgm_function50[(3, 74, 2)] = 0.001
        pgm_function50[(3, 74, 3)] = 0.25
        pgm_function50[(3, 75, 2)] = 0.001
        pgm_function50[(3, 75, 3)] = 0.25

        pgm_function51 = pgm_factor51.set_dense()
        pgm_function51.set_flat(
            0.64, 0.82, 0.82, 0.64, 0.05,
            0.64, 0.9699, 0.9699, 0.64, 0.9699,
            0.84, 0.64, 0.9699, 0.9699, 0.64,
            0.64, 0.9699, 0.9699, 0.9699, 0.9699,
            0.64, 0.9699, 0.9699, 0.84, 0.9699,
            0.9699, 0.9699, 0.9699, 0.9699, 0.9699,
            0.9699, 0.9699, 0.9699, 0.9699, 0.9699,
            0.9699, 0.9699, 0.9699, 0.9699, 0.9699,
            0.9699, 0.9699, 0.9699, 0.9699, 0.9699,
            0.9699, 0.82, 0.35, 0.9699, 0.9699,
            0.9699, 0.9699, 0.9699, 0.15, 0.9699,
            0.9699, 0.9699, 0.64, 0.9699, 0.64,
            0.9699, 0.64, 0.9699, 0.9699, 0.9699,
            0.9699, 0.84, 0.9699, 0.9699, 0.64,
            0.64, 0.64, 0.64, 0.9699, 0.9699,
            0.9699, 0.25, 0.1, 0.1, 0.25,
            0.3, 0.25, 0.02, 0.02, 0.25,
            0.02, 0.1, 0.25, 0.02, 0.02,
            0.25, 0.25, 0.02, 0.02, 0.02,
            0.02, 0.25, 0.02, 0.02, 0.1,
            0.02, 0.02, 0.02, 0.02, 0.02,
            0.02, 0.02, 0.02, 0.02, 0.02,
            0.02, 0.02, 0.02, 0.02, 0.02,
            0.02, 0.02, 0.02, 0.02, 0.02,
            0.02, 0.02, 0.1, 0.2, 0.02,
            0.02, 0.02, 0.02, 0.02, 0.35,
            0.02, 0.02, 0.02, 0.25, 0.02,
            0.25, 0.02, 0.25, 0.02, 0.02,
            0.02, 0.02, 0.1, 0.02, 0.02,
            0.25, 0.25, 0.25, 0.25, 0.02,
            0.02, 0.02, 0.1, 0.05, 0.05,
            0.1, 0.55, 0.1, 0.01, 0.01,
            0.1, 0.01, 0.05, 0.1, 0.01,
            0.01, 0.1, 0.1, 0.01, 0.01,
            0.01, 0.01, 0.1, 0.01, 0.01,
            0.05, 0.01, 0.01, 0.01, 0.01,
            0.01, 0.01, 0.01, 0.01, 0.01,
            0.01, 0.01, 0.01, 0.01, 0.01,
            0.01, 0.01, 0.01, 0.01, 0.01,
            0.01, 0.01, 0.01, 0.05, 0.4,
            0.01, 0.01, 0.01, 0.01, 0.01,
            0.45, 0.01, 0.01, 0.01, 0.1,
            0.01, 0.1, 0.01, 0.1, 0.01,
            0.01, 0.01, 0.01, 0.05, 0.01,
            0.01, 0.1, 0.1, 0.1, 0.1,
            0.01, 0.01, 0.01, 0.01, 0.03,
            0.03, 0.01, 0.1, 0.01, 0.0001,
            0.0001, 0.01, 0.0001, 0.01, 0.01,
            0.0001, 0.0001, 0.01, 0.01, 0.0001,
            0.0001, 0.0001, 0.0001, 0.01, 0.0001,
            0.0001, 0.01, 0.0001, 0.0001, 0.0001,
            0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
            0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
            0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
            0.0001, 0.0001, 0.0001, 0.0001, 0.03,
            0.05, 0.0001, 0.0001, 0.0001, 0.0001,
            0.0001, 0.05, 0.0001, 0.0001, 0.0001,
            0.01, 0.0001, 0.01, 0.0001, 0.01,
            0.0001, 0.0001, 0.0001, 0.0001, 0.01,
            0.0001, 0.0001, 0.01, 0.01, 0.01,
            0.01, 0.0001, 0.0001, 0.0001
        )

        pgm_function52 = pgm_factor52.set_sparse()
        pgm_function52[(0, 0, 0)] = 1.0
        pgm_function52[(0, 0, 1)] = 0.885
        pgm_function52[(0, 0, 2)] = 0.885
        pgm_function52[(0, 0, 3)] = 0.25
        pgm_function52[(0, 0, 4)] = 1.0
        pgm_function52[(0, 1, 0)] = 1.0
        pgm_function52[(0, 1, 1)] = 0.939
        pgm_function52[(0, 1, 2)] = 0.939
        pgm_function52[(0, 1, 3)] = 0.25
        pgm_function52[(0, 1, 4)] = 1.0
        pgm_function52[(0, 2, 0)] = 1.0
        pgm_function52[(0, 2, 1)] = 0.939
        pgm_function52[(0, 2, 2)] = 0.939
        pgm_function52[(0, 2, 3)] = 0.25
        pgm_function52[(0, 2, 4)] = 1.0
        pgm_function52[(0, 3, 0)] = 1.0
        pgm_function52[(0, 3, 1)] = 0.42
        pgm_function52[(0, 3, 2)] = 0.42
        pgm_function52[(0, 3, 3)] = 0.25
        pgm_function52[(0, 3, 4)] = 1.0
        pgm_function52[(0, 4, 0)] = 1.0
        pgm_function52[(0, 4, 1)] = 0.939
        pgm_function52[(0, 4, 2)] = 0.939
        pgm_function52[(0, 4, 3)] = 0.25
        pgm_function52[(0, 4, 4)] = 1.0
        pgm_function52[(0, 5, 0)] = 1.0
        pgm_function52[(0, 5, 1)] = 0.885
        pgm_function52[(0, 5, 2)] = 0.885
        pgm_function52[(0, 5, 3)] = 1.0
        pgm_function52[(0, 5, 4)] = 1.0
        pgm_function52[(0, 6, 0)] = 1.0
        pgm_function52[(0, 6, 1)] = 0.885
        pgm_function52[(0, 6, 2)] = 0.885
        pgm_function52[(0, 6, 3)] = 1.0
        pgm_function52[(0, 6, 4)] = 1.0
        pgm_function52[(0, 7, 0)] = 1.0
        pgm_function52[(0, 7, 1)] = 0.885
        pgm_function52[(0, 7, 2)] = 0.885
        pgm_function52[(0, 7, 3)] = 1.0
        pgm_function52[(0, 7, 4)] = 1.0
        pgm_function52[(0, 8, 0)] = 1.0
        pgm_function52[(0, 8, 1)] = 0.42
        pgm_function52[(0, 8, 2)] = 0.42
        pgm_function52[(0, 8, 3)] = 0.25
        pgm_function52[(0, 8, 4)] = 1.0
        pgm_function52[(0, 9, 0)] = 1.0
        pgm_function52[(0, 9, 1)] = 0.939
        pgm_function52[(0, 9, 2)] = 0.939
        pgm_function52[(0, 9, 3)] = 1.0
        pgm_function52[(0, 9, 4)] = 1.0
        pgm_function52[(0, 10, 0)] = 1.0
        pgm_function52[(0, 10, 1)] = 0.01
        pgm_function52[(0, 10, 2)] = 0.01
        pgm_function52[(0, 10, 3)] = 0.879
        pgm_function52[(0, 10, 4)] = 1.0
        pgm_function52[(0, 11, 0)] = 1.0
        pgm_function52[(0, 11, 1)] = 0.939
        pgm_function52[(0, 11, 2)] = 0.939
        pgm_function52[(0, 11, 3)] = 1.0
        pgm_function52[(0, 11, 4)] = 1.0
        pgm_function52[(0, 12, 0)] = 1.0
        pgm_function52[(0, 12, 1)] = 0.939
        pgm_function52[(0, 12, 2)] = 0.939
        pgm_function52[(0, 12, 3)] = 1.0
        pgm_function52[(0, 12, 4)] = 1.0
        pgm_function52[(0, 13, 0)] = 1.0
        pgm_function52[(0, 13, 1)] = 0.939
        pgm_function52[(0, 13, 2)] = 0.939
        pgm_function52[(0, 13, 3)] = 1.0
        pgm_function52[(0, 13, 4)] = 1.0
        pgm_function52[(0, 14, 0)] = 1.0
        pgm_function52[(0, 14, 1)] = 0.01
        pgm_function52[(0, 14, 2)] = 0.01
        pgm_function52[(0, 14, 3)] = 0.879
        pgm_function52[(0, 14, 4)] = 1.0
        pgm_function52[(0, 15, 0)] = 1.0
        pgm_function52[(0, 15, 1)] = 0.42
        pgm_function52[(0, 15, 2)] = 0.42
        pgm_function52[(0, 15, 3)] = 0.25
        pgm_function52[(0, 15, 4)] = 1.0
        pgm_function52[(0, 16, 0)] = 1.0
        pgm_function52[(0, 16, 1)] = 0.885
        pgm_function52[(0, 16, 2)] = 0.885
        pgm_function52[(0, 16, 3)] = 1.0
        pgm_function52[(0, 16, 4)] = 1.0
        pgm_function52[(0, 17, 0)] = 1.0
        pgm_function52[(0, 17, 1)] = 0.939
        pgm_function52[(0, 17, 2)] = 0.939
        pgm_function52[(0, 17, 3)] = 1.0
        pgm_function52[(0, 17, 4)] = 1.0
        pgm_function52[(0, 18, 0)] = 1.0
        pgm_function52[(0, 18, 1)] = 0.939
        pgm_function52[(0, 18, 2)] = 0.939
        pgm_function52[(0, 18, 3)] = 1.0
        pgm_function52[(0, 18, 4)] = 1.0
        pgm_function52[(0, 19, 0)] = 1.0
        pgm_function52[(0, 19, 1)] = 0.939
        pgm_function52[(0, 19, 2)] = 0.939
        pgm_function52[(0, 19, 3)] = 1.0
        pgm_function52[(0, 19, 4)] = 1.0
        pgm_function52[(0, 20, 0)] = 1.0
        pgm_function52[(0, 20, 1)] = 0.939
        pgm_function52[(0, 20, 2)] = 0.939
        pgm_function52[(0, 20, 3)] = 1.0
        pgm_function52[(0, 20, 4)] = 1.0
        pgm_function52[(0, 21, 0)] = 1.0
        pgm_function52[(0, 21, 1)] = 0.885
        pgm_function52[(0, 21, 2)] = 0.885
        pgm_function52[(0, 21, 3)] = 1.0
        pgm_function52[(0, 21, 4)] = 1.0
        pgm_function52[(0, 22, 0)] = 1.0
        pgm_function52[(0, 22, 1)] = 0.939
        pgm_function52[(0, 22, 2)] = 0.939
        pgm_function52[(0, 22, 3)] = 1.0
        pgm_function52[(0, 22, 4)] = 1.0
        pgm_function52[(0, 23, 0)] = 1.0
        pgm_function52[(0, 23, 1)] = 0.01
        pgm_function52[(0, 23, 2)] = 0.01
        pgm_function52[(0, 23, 3)] = 0.879
        pgm_function52[(0, 23, 4)] = 1.0
        pgm_function52[(0, 24, 0)] = 1.0
        pgm_function52[(0, 24, 1)] = 0.939
        pgm_function52[(0, 24, 2)] = 0.939
        pgm_function52[(0, 24, 3)] = 1.0
        pgm_function52[(0, 24, 4)] = 1.0
        pgm_function52[(0, 25, 0)] = 1.0
        pgm_function52[(0, 25, 1)] = 0.999
        pgm_function52[(0, 25, 2)] = 0.999
        pgm_function52[(0, 25, 3)] = 1.0
        pgm_function52[(0, 25, 4)] = 1.0
        pgm_function52[(0, 26, 0)] = 1.0
        pgm_function52[(0, 26, 1)] = 0.999
        pgm_function52[(0, 26, 2)] = 0.999
        pgm_function52[(0, 26, 3)] = 1.0
        pgm_function52[(0, 26, 4)] = 1.0
        pgm_function52[(0, 27, 0)] = 1.0
        pgm_function52[(0, 27, 1)] = 0.999
        pgm_function52[(0, 27, 2)] = 0.999
        pgm_function52[(0, 27, 3)] = 1.0
        pgm_function52[(0, 27, 4)] = 1.0
        pgm_function52[(0, 28, 0)] = 1.0
        pgm_function52[(0, 28, 1)] = 0.999
        pgm_function52[(0, 28, 2)] = 0.999
        pgm_function52[(0, 28, 3)] = 1.0
        pgm_function52[(0, 28, 4)] = 1.0
        pgm_function52[(0, 29, 0)] = 1.0
        pgm_function52[(0, 29, 1)] = 0.999
        pgm_function52[(0, 29, 2)] = 0.999
        pgm_function52[(0, 29, 3)] = 1.0
        pgm_function52[(0, 29, 4)] = 1.0
        pgm_function52[(0, 30, 0)] = 1.0
        pgm_function52[(0, 30, 1)] = 0.999
        pgm_function52[(0, 30, 2)] = 0.999
        pgm_function52[(0, 30, 3)] = 1.0
        pgm_function52[(0, 30, 4)] = 1.0
        pgm_function52[(0, 31, 0)] = 1.0
        pgm_function52[(0, 31, 1)] = 0.999
        pgm_function52[(0, 31, 2)] = 0.999
        pgm_function52[(0, 31, 3)] = 1.0
        pgm_function52[(0, 31, 4)] = 1.0
        pgm_function52[(0, 32, 0)] = 1.0
        pgm_function52[(0, 32, 1)] = 0.999
        pgm_function52[(0, 32, 2)] = 0.999
        pgm_function52[(0, 32, 3)] = 1.0
        pgm_function52[(0, 32, 4)] = 1.0
        pgm_function52[(0, 33, 0)] = 1.0
        pgm_function52[(0, 33, 1)] = 0.999
        pgm_function52[(0, 33, 2)] = 0.999
        pgm_function52[(0, 33, 3)] = 1.0
        pgm_function52[(0, 33, 4)] = 1.0
        pgm_function52[(0, 34, 0)] = 1.0
        pgm_function52[(0, 34, 1)] = 0.999
        pgm_function52[(0, 34, 2)] = 0.999
        pgm_function52[(0, 34, 3)] = 1.0
        pgm_function52[(0, 34, 4)] = 1.0
        pgm_function52[(0, 35, 0)] = 1.0
        pgm_function52[(0, 35, 1)] = 0.999
        pgm_function52[(0, 35, 2)] = 0.999
        pgm_function52[(0, 35, 3)] = 1.0
        pgm_function52[(0, 35, 4)] = 1.0
        pgm_function52[(0, 36, 0)] = 1.0
        pgm_function52[(0, 36, 1)] = 0.999
        pgm_function52[(0, 36, 2)] = 0.999
        pgm_function52[(0, 36, 3)] = 1.0
        pgm_function52[(0, 36, 4)] = 1.0
        pgm_function52[(0, 37, 0)] = 1.0
        pgm_function52[(0, 37, 1)] = 0.999
        pgm_function52[(0, 37, 2)] = 0.999
        pgm_function52[(0, 37, 3)] = 1.0
        pgm_function52[(0, 37, 4)] = 1.0
        pgm_function52[(0, 38, 0)] = 1.0
        pgm_function52[(0, 38, 1)] = 0.999
        pgm_function52[(0, 38, 2)] = 0.999
        pgm_function52[(0, 38, 3)] = 1.0
        pgm_function52[(0, 38, 4)] = 1.0
        pgm_function52[(0, 39, 0)] = 1.0
        pgm_function52[(0, 39, 1)] = 0.999
        pgm_function52[(0, 39, 2)] = 0.999
        pgm_function52[(0, 39, 3)] = 1.0
        pgm_function52[(0, 39, 4)] = 1.0
        pgm_function52[(0, 40, 0)] = 1.0
        pgm_function52[(0, 40, 1)] = 0.999
        pgm_function52[(0, 40, 2)] = 0.999
        pgm_function52[(0, 40, 3)] = 1.0
        pgm_function52[(0, 40, 4)] = 1.0
        pgm_function52[(0, 41, 0)] = 1.0
        pgm_function52[(0, 41, 1)] = 0.999
        pgm_function52[(0, 41, 2)] = 0.999
        pgm_function52[(0, 41, 3)] = 1.0
        pgm_function52[(0, 41, 4)] = 1.0
        pgm_function52[(0, 42, 0)] = 1.0
        pgm_function52[(0, 42, 1)] = 0.999
        pgm_function52[(0, 42, 2)] = 0.999
        pgm_function52[(0, 42, 3)] = 1.0
        pgm_function52[(0, 42, 4)] = 1.0
        pgm_function52[(0, 43, 0)] = 1.0
        pgm_function52[(0, 43, 1)] = 0.999
        pgm_function52[(0, 43, 2)] = 0.999
        pgm_function52[(0, 43, 3)] = 1.0
        pgm_function52[(0, 43, 4)] = 1.0
        pgm_function52[(0, 44, 0)] = 1.0
        pgm_function52[(0, 44, 1)] = 0.999
        pgm_function52[(0, 44, 2)] = 0.999
        pgm_function52[(0, 44, 3)] = 1.0
        pgm_function52[(0, 44, 4)] = 1.0
        pgm_function52[(0, 45, 0)] = 1.0
        pgm_function52[(0, 45, 1)] = 0.999
        pgm_function52[(0, 45, 2)] = 0.999
        pgm_function52[(0, 45, 3)] = 1.0
        pgm_function52[(0, 45, 4)] = 1.0
        pgm_function52[(0, 46, 0)] = 1.0
        pgm_function52[(0, 46, 1)] = 0.999
        pgm_function52[(0, 46, 2)] = 0.999
        pgm_function52[(0, 46, 3)] = 1.0
        pgm_function52[(0, 46, 4)] = 1.0
        pgm_function52[(0, 47, 0)] = 1.0
        pgm_function52[(0, 47, 1)] = 0.999
        pgm_function52[(0, 47, 2)] = 0.999
        pgm_function52[(0, 47, 3)] = 1.0
        pgm_function52[(0, 47, 4)] = 1.0
        pgm_function52[(0, 48, 0)] = 1.0
        pgm_function52[(0, 48, 1)] = 0.999
        pgm_function52[(0, 48, 2)] = 0.999
        pgm_function52[(0, 48, 3)] = 1.0
        pgm_function52[(0, 48, 4)] = 1.0
        pgm_function52[(0, 49, 0)] = 1.0
        pgm_function52[(0, 49, 1)] = 0.999
        pgm_function52[(0, 49, 2)] = 0.999
        pgm_function52[(0, 49, 3)] = 1.0
        pgm_function52[(0, 49, 4)] = 1.0
        pgm_function52[(0, 50, 0)] = 1.0
        pgm_function52[(0, 50, 1)] = 0.999
        pgm_function52[(0, 50, 2)] = 0.999
        pgm_function52[(0, 50, 3)] = 1.0
        pgm_function52[(0, 50, 4)] = 1.0
        pgm_function52[(0, 51, 0)] = 1.0
        pgm_function52[(0, 51, 1)] = 0.999
        pgm_function52[(0, 51, 2)] = 0.999
        pgm_function52[(0, 51, 3)] = 1.0
        pgm_function52[(0, 51, 4)] = 1.0
        pgm_function52[(0, 52, 0)] = 1.0
        pgm_function52[(0, 52, 1)] = 0.999
        pgm_function52[(0, 52, 2)] = 0.999
        pgm_function52[(0, 52, 3)] = 1.0
        pgm_function52[(0, 52, 4)] = 1.0
        pgm_function52[(0, 53, 0)] = 1.0
        pgm_function52[(0, 53, 1)] = 0.999
        pgm_function52[(0, 53, 2)] = 0.999
        pgm_function52[(0, 53, 3)] = 1.0
        pgm_function52[(0, 53, 4)] = 1.0
        pgm_function52[(0, 54, 0)] = 1.0
        pgm_function52[(0, 54, 1)] = 0.999
        pgm_function52[(0, 54, 2)] = 0.999
        pgm_function52[(0, 54, 3)] = 1.0
        pgm_function52[(0, 54, 4)] = 1.0
        pgm_function52[(0, 55, 0)] = 1.0
        pgm_function52[(0, 55, 1)] = 0.999
        pgm_function52[(0, 55, 2)] = 0.999
        pgm_function52[(0, 55, 3)] = 1.0
        pgm_function52[(0, 55, 4)] = 1.0
        pgm_function52[(0, 56, 0)] = 1.0
        pgm_function52[(0, 56, 1)] = 0.999
        pgm_function52[(0, 56, 2)] = 0.999
        pgm_function52[(0, 56, 3)] = 1.0
        pgm_function52[(0, 56, 4)] = 1.0
        pgm_function52[(0, 57, 0)] = 1.0
        pgm_function52[(0, 57, 1)] = 0.999
        pgm_function52[(0, 57, 2)] = 0.999
        pgm_function52[(0, 57, 3)] = 1.0
        pgm_function52[(0, 57, 4)] = 1.0
        pgm_function52[(0, 58, 0)] = 1.0
        pgm_function52[(0, 58, 1)] = 0.999
        pgm_function52[(0, 58, 2)] = 0.999
        pgm_function52[(0, 58, 3)] = 1.0
        pgm_function52[(0, 58, 4)] = 1.0
        pgm_function52[(0, 59, 0)] = 1.0
        pgm_function52[(0, 59, 1)] = 0.885
        pgm_function52[(0, 59, 2)] = 0.999
        pgm_function52[(0, 59, 3)] = 1.0
        pgm_function52[(0, 59, 4)] = 1.0
        pgm_function52[(0, 60, 0)] = 1.0
        pgm_function52[(0, 60, 1)] = 0.989
        pgm_function52[(0, 60, 2)] = 0.999
        pgm_function52[(0, 60, 3)] = 1.0
        pgm_function52[(0, 60, 4)] = 1.0
        pgm_function52[(0, 61, 0)] = 1.0
        pgm_function52[(0, 61, 1)] = 0.885
        pgm_function52[(0, 61, 2)] = 0.885
        pgm_function52[(0, 61, 3)] = 0.25
        pgm_function52[(0, 61, 4)] = 1.0
        pgm_function52[(0, 62, 0)] = 1.0
        pgm_function52[(0, 62, 1)] = 0.999
        pgm_function52[(0, 62, 2)] = 0.999
        pgm_function52[(0, 62, 3)] = 1.0
        pgm_function52[(0, 62, 4)] = 1.0
        pgm_function52[(0, 63, 0)] = 1.0
        pgm_function52[(0, 63, 1)] = 0.999
        pgm_function52[(0, 63, 2)] = 0.999
        pgm_function52[(0, 63, 3)] = 1.0
        pgm_function52[(0, 63, 4)] = 1.0
        pgm_function52[(0, 64, 0)] = 1.0
        pgm_function52[(0, 64, 1)] = 0.999
        pgm_function52[(0, 64, 2)] = 0.999
        pgm_function52[(0, 64, 3)] = 1.0
        pgm_function52[(0, 64, 4)] = 1.0
        pgm_function52[(0, 65, 0)] = 1.0
        pgm_function52[(0, 65, 1)] = 0.999
        pgm_function52[(0, 65, 2)] = 0.999
        pgm_function52[(0, 65, 3)] = 1.0
        pgm_function52[(0, 65, 4)] = 1.0
        pgm_function52[(0, 66, 0)] = 1.0
        pgm_function52[(0, 66, 1)] = 0.01
        pgm_function52[(0, 66, 2)] = 0.01
        pgm_function52[(0, 66, 3)] = 0.879
        pgm_function52[(0, 66, 4)] = 1.0
        pgm_function52[(0, 67, 0)] = 1.0
        pgm_function52[(0, 67, 1)] = 0.939
        pgm_function52[(0, 67, 2)] = 0.939
        pgm_function52[(0, 67, 3)] = 1.0
        pgm_function52[(0, 67, 4)] = 1.0
        pgm_function52[(0, 68, 0)] = 1.0
        pgm_function52[(0, 68, 1)] = 0.989
        pgm_function52[(0, 68, 2)] = 0.939
        pgm_function52[(0, 68, 3)] = 1.0
        pgm_function52[(0, 68, 4)] = 1.0
        pgm_function52[(0, 69, 0)] = 1.0
        pgm_function52[(0, 69, 1)] = 0.939
        pgm_function52[(0, 69, 2)] = 0.939
        pgm_function52[(0, 69, 3)] = 1.0
        pgm_function52[(0, 69, 4)] = 1.0
        pgm_function52[(0, 70, 0)] = 1.0
        pgm_function52[(0, 70, 1)] = 0.939
        pgm_function52[(0, 70, 2)] = 0.939
        pgm_function52[(0, 70, 3)] = 1.0
        pgm_function52[(0, 70, 4)] = 1.0
        pgm_function52[(0, 71, 0)] = 1.0
        pgm_function52[(0, 71, 1)] = 0.885
        pgm_function52[(0, 71, 2)] = 0.885
        pgm_function52[(0, 71, 3)] = 1.0
        pgm_function52[(0, 71, 4)] = 1.0
        pgm_function52[(0, 72, 0)] = 1.0
        pgm_function52[(0, 72, 1)] = 0.885
        pgm_function52[(0, 72, 2)] = 0.885
        pgm_function52[(0, 72, 3)] = 1.0
        pgm_function52[(0, 72, 4)] = 1.0
        pgm_function52[(0, 73, 0)] = 1.0
        pgm_function52[(0, 73, 1)] = 0.885
        pgm_function52[(0, 73, 2)] = 0.885
        pgm_function52[(0, 73, 3)] = 1.0
        pgm_function52[(0, 73, 4)] = 1.0
        pgm_function52[(0, 74, 0)] = 1.0
        pgm_function52[(0, 74, 1)] = 0.999
        pgm_function52[(0, 74, 2)] = 0.999
        pgm_function52[(0, 74, 3)] = 1.0
        pgm_function52[(0, 74, 4)] = 1.0
        pgm_function52[(0, 75, 0)] = 1.0
        pgm_function52[(0, 75, 1)] = 0.999
        pgm_function52[(0, 75, 2)] = 0.999
        pgm_function52[(0, 75, 3)] = 1.0
        pgm_function52[(0, 75, 4)] = 1.0
        pgm_function52[(1, 0, 1)] = 0.1
        pgm_function52[(1, 0, 2)] = 0.1
        pgm_function52[(1, 0, 3)] = 0.25
        pgm_function52[(1, 1, 1)] = 0.05
        pgm_function52[(1, 1, 2)] = 0.05
        pgm_function52[(1, 1, 3)] = 0.25
        pgm_function52[(1, 2, 1)] = 0.05
        pgm_function52[(1, 2, 2)] = 0.05
        pgm_function52[(1, 2, 3)] = 0.25
        pgm_function52[(1, 3, 1)] = 0.45
        pgm_function52[(1, 3, 2)] = 0.45
        pgm_function52[(1, 3, 3)] = 0.25
        pgm_function52[(1, 4, 1)] = 0.05
        pgm_function52[(1, 4, 2)] = 0.05
        pgm_function52[(1, 4, 3)] = 0.25
        pgm_function52[(1, 5, 1)] = 0.1
        pgm_function52[(1, 5, 2)] = 0.1
        pgm_function52[(1, 6, 1)] = 0.1
        pgm_function52[(1, 6, 2)] = 0.1
        pgm_function52[(1, 7, 1)] = 0.1
        pgm_function52[(1, 7, 2)] = 0.1
        pgm_function52[(1, 8, 1)] = 0.45
        pgm_function52[(1, 8, 2)] = 0.45
        pgm_function52[(1, 8, 3)] = 0.25
        pgm_function52[(1, 9, 1)] = 0.05
        pgm_function52[(1, 9, 2)] = 0.05
        pgm_function52[(1, 10, 1)] = 0.2
        pgm_function52[(1, 10, 2)] = 0.2
        pgm_function52[(1, 10, 3)] = 0.1
        pgm_function52[(1, 11, 1)] = 0.05
        pgm_function52[(1, 11, 2)] = 0.05
        pgm_function52[(1, 12, 1)] = 0.05
        pgm_function52[(1, 12, 2)] = 0.05
        pgm_function52[(1, 13, 1)] = 0.05
        pgm_function52[(1, 13, 2)] = 0.05
        pgm_function52[(1, 14, 1)] = 0.2
        pgm_function52[(1, 14, 2)] = 0.2
        pgm_function52[(1, 14, 3)] = 0.1
        pgm_function52[(1, 15, 1)] = 0.45
        pgm_function52[(1, 15, 2)] = 0.45
        pgm_function52[(1, 15, 3)] = 0.25
        pgm_function52[(1, 16, 1)] = 0.1
        pgm_function52[(1, 16, 2)] = 0.1
        pgm_function52[(1, 17, 1)] = 0.05
        pgm_function52[(1, 17, 2)] = 0.05
        pgm_function52[(1, 18, 1)] = 0.05
        pgm_function52[(1, 18, 2)] = 0.05
        pgm_function52[(1, 19, 1)] = 0.05
        pgm_function52[(1, 19, 2)] = 0.05
        pgm_function52[(1, 20, 1)] = 0.05
        pgm_function52[(1, 20, 2)] = 0.05
        pgm_function52[(1, 21, 1)] = 0.1
        pgm_function52[(1, 21, 2)] = 0.1
        pgm_function52[(1, 22, 1)] = 0.05
        pgm_function52[(1, 22, 2)] = 0.05
        pgm_function52[(1, 23, 1)] = 0.2
        pgm_function52[(1, 23, 2)] = 0.2
        pgm_function52[(1, 23, 3)] = 0.1
        pgm_function52[(1, 24, 1)] = 0.05
        pgm_function52[(1, 24, 2)] = 0.05
        pgm_function52[(1, 25, 1)] = 0.001
        pgm_function52[(1, 25, 2)] = 0.001
        pgm_function52[(1, 26, 1)] = 0.001
        pgm_function52[(1, 26, 2)] = 0.001
        pgm_function52[(1, 27, 1)] = 0.001
        pgm_function52[(1, 27, 2)] = 0.001
        pgm_function52[(1, 28, 1)] = 0.001
        pgm_function52[(1, 28, 2)] = 0.001
        pgm_function52[(1, 29, 1)] = 0.001
        pgm_function52[(1, 29, 2)] = 0.001
        pgm_function52[(1, 30, 1)] = 0.001
        pgm_function52[(1, 30, 2)] = 0.001
        pgm_function52[(1, 31, 1)] = 0.001
        pgm_function52[(1, 31, 2)] = 0.001
        pgm_function52[(1, 32, 1)] = 0.001
        pgm_function52[(1, 32, 2)] = 0.001
        pgm_function52[(1, 33, 1)] = 0.001
        pgm_function52[(1, 33, 2)] = 0.001
        pgm_function52[(1, 34, 1)] = 0.001
        pgm_function52[(1, 34, 2)] = 0.001
        pgm_function52[(1, 35, 1)] = 0.001
        pgm_function52[(1, 35, 2)] = 0.001
        pgm_function52[(1, 36, 1)] = 0.001
        pgm_function52[(1, 36, 2)] = 0.001
        pgm_function52[(1, 37, 1)] = 0.001
        pgm_function52[(1, 37, 2)] = 0.001
        pgm_function52[(1, 38, 1)] = 0.001
        pgm_function52[(1, 38, 2)] = 0.001
        pgm_function52[(1, 39, 1)] = 0.001
        pgm_function52[(1, 39, 2)] = 0.001
        pgm_function52[(1, 40, 1)] = 0.001
        pgm_function52[(1, 40, 2)] = 0.001
        pgm_function52[(1, 41, 1)] = 0.001
        pgm_function52[(1, 41, 2)] = 0.001
        pgm_function52[(1, 42, 1)] = 0.001
        pgm_function52[(1, 42, 2)] = 0.001
        pgm_function52[(1, 43, 1)] = 0.001
        pgm_function52[(1, 43, 2)] = 0.001
        pgm_function52[(1, 44, 1)] = 0.001
        pgm_function52[(1, 44, 2)] = 0.001
        pgm_function52[(1, 45, 1)] = 0.001
        pgm_function52[(1, 45, 2)] = 0.001
        pgm_function52[(1, 46, 1)] = 0.001
        pgm_function52[(1, 46, 2)] = 0.001
        pgm_function52[(1, 47, 1)] = 0.001
        pgm_function52[(1, 47, 2)] = 0.001
        pgm_function52[(1, 48, 1)] = 0.001
        pgm_function52[(1, 48, 2)] = 0.001
        pgm_function52[(1, 49, 1)] = 0.001
        pgm_function52[(1, 49, 2)] = 0.001
        pgm_function52[(1, 50, 1)] = 0.001
        pgm_function52[(1, 50, 2)] = 0.001
        pgm_function52[(1, 51, 1)] = 0.001
        pgm_function52[(1, 51, 2)] = 0.001
        pgm_function52[(1, 52, 1)] = 0.001
        pgm_function52[(1, 52, 2)] = 0.001
        pgm_function52[(1, 53, 1)] = 0.001
        pgm_function52[(1, 53, 2)] = 0.001
        pgm_function52[(1, 54, 1)] = 0.001
        pgm_function52[(1, 54, 2)] = 0.001
        pgm_function52[(1, 55, 1)] = 0.001
        pgm_function52[(1, 55, 2)] = 0.001
        pgm_function52[(1, 56, 1)] = 0.001
        pgm_function52[(1, 56, 2)] = 0.001
        pgm_function52[(1, 57, 1)] = 0.001
        pgm_function52[(1, 57, 2)] = 0.001
        pgm_function52[(1, 58, 1)] = 0.001
        pgm_function52[(1, 58, 2)] = 0.001
        pgm_function52[(1, 59, 1)] = 0.1
        pgm_function52[(1, 59, 2)] = 0.001
        pgm_function52[(1, 60, 1)] = 0.01
        pgm_function52[(1, 60, 2)] = 0.001
        pgm_function52[(1, 61, 1)] = 0.1
        pgm_function52[(1, 61, 2)] = 0.1
        pgm_function52[(1, 61, 3)] = 0.25
        pgm_function52[(1, 62, 1)] = 0.001
        pgm_function52[(1, 62, 2)] = 0.001
        pgm_function52[(1, 63, 1)] = 0.001
        pgm_function52[(1, 63, 2)] = 0.001
        pgm_function52[(1, 64, 1)] = 0.001
        pgm_function52[(1, 64, 2)] = 0.001
        pgm_function52[(1, 65, 1)] = 0.001
        pgm_function52[(1, 65, 2)] = 0.001
        pgm_function52[(1, 66, 1)] = 0.2
        pgm_function52[(1, 66, 2)] = 0.2
        pgm_function52[(1, 66, 3)] = 0.1
        pgm_function52[(1, 67, 1)] = 0.05
        pgm_function52[(1, 67, 2)] = 0.05
        pgm_function52[(1, 68, 1)] = 0.01
        pgm_function52[(1, 68, 2)] = 0.05
        pgm_function52[(1, 69, 1)] = 0.05
        pgm_function52[(1, 69, 2)] = 0.05
        pgm_function52[(1, 70, 1)] = 0.05
        pgm_function52[(1, 70, 2)] = 0.05
        pgm_function52[(1, 71, 1)] = 0.1
        pgm_function52[(1, 71, 2)] = 0.1
        pgm_function52[(1, 72, 1)] = 0.1
        pgm_function52[(1, 72, 2)] = 0.1
        pgm_function52[(1, 73, 1)] = 0.1
        pgm_function52[(1, 73, 2)] = 0.1
        pgm_function52[(1, 74, 1)] = 0.001
        pgm_function52[(1, 74, 2)] = 0.001
        pgm_function52[(1, 75, 1)] = 0.001
        pgm_function52[(1, 75, 2)] = 0.001
        pgm_function52[(2, 0, 1)] = 0.01
        pgm_function52[(2, 0, 2)] = 0.01
        pgm_function52[(2, 0, 3)] = 0.25
        pgm_function52[(2, 1, 1)] = 0.01
        pgm_function52[(2, 1, 2)] = 0.01
        pgm_function52[(2, 1, 3)] = 0.25
        pgm_function52[(2, 2, 1)] = 0.01
        pgm_function52[(2, 2, 2)] = 0.01
        pgm_function52[(2, 2, 3)] = 0.25
        pgm_function52[(2, 3, 1)] = 0.08
        pgm_function52[(2, 3, 2)] = 0.08
        pgm_function52[(2, 3, 3)] = 0.25
        pgm_function52[(2, 4, 1)] = 0.01
        pgm_function52[(2, 4, 2)] = 0.01
        pgm_function52[(2, 4, 3)] = 0.25
        pgm_function52[(2, 5, 1)] = 0.01
        pgm_function52[(2, 5, 2)] = 0.01
        pgm_function52[(2, 6, 1)] = 0.01
        pgm_function52[(2, 6, 2)] = 0.01
        pgm_function52[(2, 7, 1)] = 0.01
        pgm_function52[(2, 7, 2)] = 0.01
        pgm_function52[(2, 8, 1)] = 0.08
        pgm_function52[(2, 8, 2)] = 0.08
        pgm_function52[(2, 8, 3)] = 0.25
        pgm_function52[(2, 9, 1)] = 0.01
        pgm_function52[(2, 9, 2)] = 0.01
        pgm_function52[(2, 10, 1)] = 0.64
        pgm_function52[(2, 10, 2)] = 0.64
        pgm_function52[(2, 10, 3)] = 0.02
        pgm_function52[(2, 11, 1)] = 0.01
        pgm_function52[(2, 11, 2)] = 0.01
        pgm_function52[(2, 12, 1)] = 0.01
        pgm_function52[(2, 12, 2)] = 0.01
        pgm_function52[(2, 13, 1)] = 0.01
        pgm_function52[(2, 13, 2)] = 0.01
        pgm_function52[(2, 14, 1)] = 0.64
        pgm_function52[(2, 14, 2)] = 0.64
        pgm_function52[(2, 14, 3)] = 0.02
        pgm_function52[(2, 15, 1)] = 0.08
        pgm_function52[(2, 15, 2)] = 0.08
        pgm_function52[(2, 15, 3)] = 0.25
        pgm_function52[(2, 16, 1)] = 0.01
        pgm_function52[(2, 16, 2)] = 0.01
        pgm_function52[(2, 17, 1)] = 0.01
        pgm_function52[(2, 17, 2)] = 0.01
        pgm_function52[(2, 18, 1)] = 0.01
        pgm_function52[(2, 18, 2)] = 0.01
        pgm_function52[(2, 19, 1)] = 0.01
        pgm_function52[(2, 19, 2)] = 0.01
        pgm_function52[(2, 20, 1)] = 0.01
        pgm_function52[(2, 20, 2)] = 0.01
        pgm_function52[(2, 21, 1)] = 0.01
        pgm_function52[(2, 21, 2)] = 0.01
        pgm_function52[(2, 22, 1)] = 0.01
        pgm_function52[(2, 22, 2)] = 0.01
        pgm_function52[(2, 23, 1)] = 0.64
        pgm_function52[(2, 23, 2)] = 0.64
        pgm_function52[(2, 23, 3)] = 0.02
        pgm_function52[(2, 24, 1)] = 0.01
        pgm_function52[(2, 24, 2)] = 0.01
        pgm_function52[(2, 59, 1)] = 0.01
        pgm_function52[(2, 60, 1)] = 0.001
        pgm_function52[(2, 61, 1)] = 0.01
        pgm_function52[(2, 61, 2)] = 0.01
        pgm_function52[(2, 61, 3)] = 0.25
        pgm_function52[(2, 66, 1)] = 0.64
        pgm_function52[(2, 66, 2)] = 0.64
        pgm_function52[(2, 66, 3)] = 0.02
        pgm_function52[(2, 67, 1)] = 0.01
        pgm_function52[(2, 67, 2)] = 0.01
        pgm_function52[(2, 68, 1)] = 0.001
        pgm_function52[(2, 68, 2)] = 0.01
        pgm_function52[(2, 69, 1)] = 0.01
        pgm_function52[(2, 69, 2)] = 0.01
        pgm_function52[(2, 70, 1)] = 0.01
        pgm_function52[(2, 70, 2)] = 0.01
        pgm_function52[(2, 71, 1)] = 0.01
        pgm_function52[(2, 71, 2)] = 0.01
        pgm_function52[(2, 72, 1)] = 0.01
        pgm_function52[(2, 72, 2)] = 0.01
        pgm_function52[(2, 73, 1)] = 0.01
        pgm_function52[(2, 73, 2)] = 0.01
        pgm_function52[(3, 0, 1)] = 0.005
        pgm_function52[(3, 0, 2)] = 0.005
        pgm_function52[(3, 0, 3)] = 0.25
        pgm_function52[(3, 1, 1)] = 0.001
        pgm_function52[(3, 1, 2)] = 0.001
        pgm_function52[(3, 1, 3)] = 0.25
        pgm_function52[(3, 2, 1)] = 0.001
        pgm_function52[(3, 2, 2)] = 0.001
        pgm_function52[(3, 2, 3)] = 0.25
        pgm_function52[(3, 3, 1)] = 0.05
        pgm_function52[(3, 3, 2)] = 0.05
        pgm_function52[(3, 3, 3)] = 0.25
        pgm_function52[(3, 4, 1)] = 0.001
        pgm_function52[(3, 4, 2)] = 0.001
        pgm_function52[(3, 4, 3)] = 0.25
        pgm_function52[(3, 5, 1)] = 0.005
        pgm_function52[(3, 5, 2)] = 0.005
        pgm_function52[(3, 6, 1)] = 0.005
        pgm_function52[(3, 6, 2)] = 0.005
        pgm_function52[(3, 7, 1)] = 0.005
        pgm_function52[(3, 7, 2)] = 0.005
        pgm_function52[(3, 8, 1)] = 0.05
        pgm_function52[(3, 8, 2)] = 0.05
        pgm_function52[(3, 8, 3)] = 0.25
        pgm_function52[(3, 9, 1)] = 0.001
        pgm_function52[(3, 9, 2)] = 0.001
        pgm_function52[(3, 10, 1)] = 0.15
        pgm_function52[(3, 10, 2)] = 0.15
        pgm_function52[(3, 10, 3)] = 0.001
        pgm_function52[(3, 11, 1)] = 0.001
        pgm_function52[(3, 11, 2)] = 0.001
        pgm_function52[(3, 12, 1)] = 0.001
        pgm_function52[(3, 12, 2)] = 0.001
        pgm_function52[(3, 13, 1)] = 0.001
        pgm_function52[(3, 13, 2)] = 0.001
        pgm_function52[(3, 14, 1)] = 0.15
        pgm_function52[(3, 14, 2)] = 0.15
        pgm_function52[(3, 14, 3)] = 0.001
        pgm_function52[(3, 15, 1)] = 0.05
        pgm_function52[(3, 15, 2)] = 0.05
        pgm_function52[(3, 15, 3)] = 0.25
        pgm_function52[(3, 16, 1)] = 0.005
        pgm_function52[(3, 16, 2)] = 0.005
        pgm_function52[(3, 17, 1)] = 0.001
        pgm_function52[(3, 17, 2)] = 0.001
        pgm_function52[(3, 18, 1)] = 0.001
        pgm_function52[(3, 18, 2)] = 0.001
        pgm_function52[(3, 19, 1)] = 0.001
        pgm_function52[(3, 19, 2)] = 0.001
        pgm_function52[(3, 20, 1)] = 0.001
        pgm_function52[(3, 20, 2)] = 0.001
        pgm_function52[(3, 21, 1)] = 0.005
        pgm_function52[(3, 21, 2)] = 0.005
        pgm_function52[(3, 22, 1)] = 0.001
        pgm_function52[(3, 22, 2)] = 0.001
        pgm_function52[(3, 23, 1)] = 0.15
        pgm_function52[(3, 23, 2)] = 0.15
        pgm_function52[(3, 23, 3)] = 0.001
        pgm_function52[(3, 24, 1)] = 0.001
        pgm_function52[(3, 24, 2)] = 0.001
        pgm_function52[(3, 59, 1)] = 0.005
        pgm_function52[(3, 61, 1)] = 0.005
        pgm_function52[(3, 61, 2)] = 0.005
        pgm_function52[(3, 61, 3)] = 0.25
        pgm_function52[(3, 66, 1)] = 0.15
        pgm_function52[(3, 66, 2)] = 0.15
        pgm_function52[(3, 66, 3)] = 0.001
        pgm_function52[(3, 67, 1)] = 0.001
        pgm_function52[(3, 67, 2)] = 0.001
        pgm_function52[(3, 68, 2)] = 0.001
        pgm_function52[(3, 69, 1)] = 0.001
        pgm_function52[(3, 69, 2)] = 0.001
        pgm_function52[(3, 70, 1)] = 0.001
        pgm_function52[(3, 70, 2)] = 0.001
        pgm_function52[(3, 71, 1)] = 0.005
        pgm_function52[(3, 71, 2)] = 0.005
        pgm_function52[(3, 72, 1)] = 0.005
        pgm_function52[(3, 72, 2)] = 0.005
        pgm_function52[(3, 73, 1)] = 0.005
        pgm_function52[(3, 73, 2)] = 0.005

        pgm_function53 = pgm_factor53.set_sparse()
        pgm_function53[(0, 0)] = 0.999
        pgm_function53[(0, 1)] = 0.985
        pgm_function53[(0, 2)] = 0.999
        pgm_function53[(0, 3)] = 0.999
        pgm_function53[(0, 4)] = 0.999
        pgm_function53[(0, 5)] = 0.999
        pgm_function53[(0, 6)] = 0.999
        pgm_function53[(0, 7)] = 0.999
        pgm_function53[(0, 8)] = 0.999
        pgm_function53[(0, 9)] = 0.999
        pgm_function53[(0, 10)] = 0.959
        pgm_function53[(0, 11)] = 0.999
        pgm_function53[(0, 12)] = 0.999
        pgm_function53[(0, 13)] = 0.999
        pgm_function53[(0, 14)] = 0.999
        pgm_function53[(0, 15)] = 0.999
        pgm_function53[(0, 16)] = 0.999
        pgm_function53[(0, 17)] = 0.999
        pgm_function53[(0, 18)] = 0.999
        pgm_function53[(0, 19)] = 0.999
        pgm_function53[(0, 20)] = 0.999
        pgm_function53[(0, 21)] = 0.999
        pgm_function53[(0, 22)] = 0.999
        pgm_function53[(0, 23)] = 0.985
        pgm_function53[(0, 24)] = 0.999
        pgm_function53[(0, 25)] = 0.8
        pgm_function53[(0, 26)] = 0.8
        pgm_function53[(0, 27)] = 0.25
        pgm_function53[(0, 28)] = 0.25
        pgm_function53[(0, 29)] = 0.25
        pgm_function53[(0, 30)] = 0.35
        pgm_function53[(0, 31)] = 0.3
        pgm_function53[(0, 32)] = 0.7
        pgm_function53[(0, 33)] = 0.7
        pgm_function53[(0, 34)] = 0.999
        pgm_function53[(0, 35)] = 0.999
        pgm_function53[(0, 36)] = 0.999
        pgm_function53[(0, 37)] = 0.999
        pgm_function53[(0, 38)] = 0.985
        pgm_function53[(0, 39)] = 0.985
        pgm_function53[(0, 40)] = 0.985
        pgm_function53[(0, 41)] = 0.985
        pgm_function53[(0, 42)] = 0.985
        pgm_function53[(0, 43)] = 0.985
        pgm_function53[(0, 44)] = 0.98
        pgm_function53[(0, 45)] = 0.98
        pgm_function53[(0, 46)] = 0.985
        pgm_function53[(0, 47)] = 0.949
        pgm_function53[(0, 48)] = 0.985
        pgm_function53[(0, 49)] = 0.985
        pgm_function53[(0, 50)] = 0.985
        pgm_function53[(0, 51)] = 0.98
        pgm_function53[(0, 52)] = 0.79
        pgm_function53[(0, 53)] = 0.999
        pgm_function53[(0, 54)] = 0.999
        pgm_function53[(0, 55)] = 0.999
        pgm_function53[(0, 56)] = 0.9985
        pgm_function53[(0, 57)] = 0.9985
        pgm_function53[(0, 58)] = 0.999
        pgm_function53[(0, 59)] = 0.999
        pgm_function53[(0, 60)] = 0.999
        pgm_function53[(0, 61)] = 0.999
        pgm_function53[(0, 62)] = 0.949
        pgm_function53[(0, 63)] = 0.985
        pgm_function53[(0, 64)] = 0.9985
        pgm_function53[(0, 65)] = 0.9985
        pgm_function53[(0, 66)] = 0.96
        pgm_function53[(0, 67)] = 0.999
        pgm_function53[(0, 68)] = 0.999
        pgm_function53[(0, 69)] = 0.999
        pgm_function53[(0, 70)] = 0.999
        pgm_function53[(0, 71)] = 0.999
        pgm_function53[(0, 72)] = 0.97
        pgm_function53[(0, 73)] = 0.999
        pgm_function53[(0, 74)] = 0.98
        pgm_function53[(0, 75)] = 0.985
        pgm_function53[(1, 0)] = 0.001
        pgm_function53[(1, 1)] = 0.01
        pgm_function53[(1, 2)] = 0.001
        pgm_function53[(1, 3)] = 0.001
        pgm_function53[(1, 4)] = 0.001
        pgm_function53[(1, 5)] = 0.001
        pgm_function53[(1, 6)] = 0.001
        pgm_function53[(1, 7)] = 0.001
        pgm_function53[(1, 8)] = 0.001
        pgm_function53[(1, 9)] = 0.001
        pgm_function53[(1, 10)] = 0.03
        pgm_function53[(1, 11)] = 0.001
        pgm_function53[(1, 12)] = 0.001
        pgm_function53[(1, 13)] = 0.001
        pgm_function53[(1, 14)] = 0.001
        pgm_function53[(1, 15)] = 0.001
        pgm_function53[(1, 16)] = 0.001
        pgm_function53[(1, 17)] = 0.001
        pgm_function53[(1, 18)] = 0.001
        pgm_function53[(1, 19)] = 0.001
        pgm_function53[(1, 20)] = 0.001
        pgm_function53[(1, 21)] = 0.001
        pgm_function53[(1, 22)] = 0.001
        pgm_function53[(1, 23)] = 0.01
        pgm_function53[(1, 24)] = 0.001
        pgm_function53[(1, 25)] = 0.19
        pgm_function53[(1, 26)] = 0.19
        pgm_function53[(1, 27)] = 0.5
        pgm_function53[(1, 28)] = 0.5
        pgm_function53[(1, 29)] = 0.5
        pgm_function53[(1, 30)] = 0.5
        pgm_function53[(1, 31)] = 0.6
        pgm_function53[(1, 32)] = 0.15
        pgm_function53[(1, 33)] = 0.15
        pgm_function53[(1, 34)] = 0.001
        pgm_function53[(1, 35)] = 0.001
        pgm_function53[(1, 36)] = 0.001
        pgm_function53[(1, 37)] = 0.001
        pgm_function53[(1, 38)] = 0.01
        pgm_function53[(1, 39)] = 0.01
        pgm_function53[(1, 40)] = 0.01
        pgm_function53[(1, 41)] = 0.01
        pgm_function53[(1, 42)] = 0.01
        pgm_function53[(1, 43)] = 0.01
        pgm_function53[(1, 44)] = 0.01
        pgm_function53[(1, 45)] = 0.01
        pgm_function53[(1, 46)] = 0.01
        pgm_function53[(1, 47)] = 0.03
        pgm_function53[(1, 48)] = 0.01
        pgm_function53[(1, 49)] = 0.01
        pgm_function53[(1, 50)] = 0.01
        pgm_function53[(1, 51)] = 0.01
        pgm_function53[(1, 52)] = 0.15
        pgm_function53[(1, 53)] = 0.001
        pgm_function53[(1, 54)] = 0.001
        pgm_function53[(1, 55)] = 0.001
        pgm_function53[(1, 56)] = 0.001
        pgm_function53[(1, 57)] = 0.001
        pgm_function53[(1, 58)] = 0.001
        pgm_function53[(1, 59)] = 0.001
        pgm_function53[(1, 60)] = 0.001
        pgm_function53[(1, 61)] = 0.001
        pgm_function53[(1, 62)] = 0.03
        pgm_function53[(1, 63)] = 0.01
        pgm_function53[(1, 64)] = 0.001
        pgm_function53[(1, 65)] = 0.001
        pgm_function53[(1, 66)] = 0.03
        pgm_function53[(1, 67)] = 0.001
        pgm_function53[(1, 68)] = 0.001
        pgm_function53[(1, 69)] = 0.001
        pgm_function53[(1, 70)] = 0.001
        pgm_function53[(1, 71)] = 0.001
        pgm_function53[(1, 72)] = 0.02
        pgm_function53[(1, 73)] = 0.001
        pgm_function53[(1, 74)] = 0.01
        pgm_function53[(1, 75)] = 0.01
        pgm_function53[(2, 1)] = 0.005
        pgm_function53[(2, 10)] = 0.01
        pgm_function53[(2, 23)] = 0.005
        pgm_function53[(2, 25)] = 0.01
        pgm_function53[(2, 26)] = 0.01
        pgm_function53[(2, 27)] = 0.2
        pgm_function53[(2, 28)] = 0.2
        pgm_function53[(2, 29)] = 0.2
        pgm_function53[(2, 30)] = 0.1
        pgm_function53[(2, 31)] = 0.07
        pgm_function53[(2, 32)] = 0.1
        pgm_function53[(2, 33)] = 0.1
        pgm_function53[(2, 38)] = 0.005
        pgm_function53[(2, 39)] = 0.005
        pgm_function53[(2, 40)] = 0.005
        pgm_function53[(2, 41)] = 0.005
        pgm_function53[(2, 42)] = 0.005
        pgm_function53[(2, 43)] = 0.005
        pgm_function53[(2, 44)] = 0.01
        pgm_function53[(2, 45)] = 0.01
        pgm_function53[(2, 46)] = 0.005
        pgm_function53[(2, 47)] = 0.02
        pgm_function53[(2, 48)] = 0.005
        pgm_function53[(2, 49)] = 0.005
        pgm_function53[(2, 50)] = 0.005
        pgm_function53[(2, 51)] = 0.01
        pgm_function53[(2, 52)] = 0.05
        pgm_function53[(2, 56)] = 0.0005
        pgm_function53[(2, 57)] = 0.0005
        pgm_function53[(2, 62)] = 0.02
        pgm_function53[(2, 63)] = 0.005
        pgm_function53[(2, 64)] = 0.0005
        pgm_function53[(2, 65)] = 0.0005
        pgm_function53[(2, 66)] = 0.01
        pgm_function53[(2, 72)] = 0.01
        pgm_function53[(2, 74)] = 0.01
        pgm_function53[(2, 75)] = 0.005
        pgm_function53[(3, 10)] = 0.001
        pgm_function53[(3, 27)] = 0.05
        pgm_function53[(3, 28)] = 0.05
        pgm_function53[(3, 29)] = 0.05
        pgm_function53[(3, 30)] = 0.05
        pgm_function53[(3, 31)] = 0.03
        pgm_function53[(3, 32)] = 0.05
        pgm_function53[(3, 33)] = 0.05
        pgm_function53[(3, 47)] = 0.001
        pgm_function53[(3, 52)] = 0.01
        pgm_function53[(3, 62)] = 0.001

        pgm_function54 = pgm_factor54.set_sparse()
        pgm_function54[(0, 0)] = 0.99
        pgm_function54[(0, 1)] = 0.99
        pgm_function54[(0, 2)] = 0.99
        pgm_function54[(0, 3)] = 0.05
        pgm_function54[(0, 4)] = 0.99
        pgm_function54[(0, 5)] = 0.99
        pgm_function54[(0, 6)] = 0.99
        pgm_function54[(0, 7)] = 0.99
        pgm_function54[(0, 8)] = 0.4
        pgm_function54[(0, 9)] = 0.25
        pgm_function54[(0, 10)] = 0.91
        pgm_function54[(0, 11)] = 0.92
        pgm_function54[(0, 12)] = 0.99
        pgm_function54[(0, 13)] = 0.99
        pgm_function54[(0, 14)] = 0.3
        pgm_function54[(0, 16)] = 0.99
        pgm_function54[(0, 17)] = 0.99
        pgm_function54[(0, 18)] = 0.99
        pgm_function54[(0, 19)] = 0.99
        pgm_function54[(0, 20)] = 0.99
        pgm_function54[(0, 21)] = 0.99
        pgm_function54[(0, 22)] = 0.05
        pgm_function54[(0, 23)] = 0.91
        pgm_function54[(0, 24)] = 0.92
        pgm_function54[(0, 25)] = 0.989
        pgm_function54[(0, 26)] = 0.989
        pgm_function54[(0, 27)] = 0.49
        pgm_function54[(0, 28)] = 0.49
        pgm_function54[(0, 29)] = 0.49
        pgm_function54[(0, 30)] = 0.84158416
        pgm_function54[(0, 31)] = 0.84158416
        pgm_function54[(0, 32)] = 0.78
        pgm_function54[(0, 33)] = 0.78
        pgm_function54[(0, 34)] = 0.97
        pgm_function54[(0, 35)] = 0.97
        pgm_function54[(0, 36)] = 0.97
        pgm_function54[(0, 37)] = 0.97
        pgm_function54[(0, 38)] = 0.94
        pgm_function54[(0, 39)] = 0.94
        pgm_function54[(0, 40)] = 0.94
        pgm_function54[(0, 41)] = 0.94
        pgm_function54[(0, 42)] = 0.94
        pgm_function54[(0, 43)] = 0.88
        pgm_function54[(0, 44)] = 0.88
        pgm_function54[(0, 45)] = 0.88
        pgm_function54[(0, 46)] = 0.88
        pgm_function54[(0, 47)] = 0.88
        pgm_function54[(0, 48)] = 0.88
        pgm_function54[(0, 49)] = 0.88
        pgm_function54[(0, 50)] = 0.88
        pgm_function54[(0, 51)] = 0.88
        pgm_function54[(0, 52)] = 0.88
        pgm_function54[(0, 53)] = 0.88
        pgm_function54[(0, 54)] = 0.88
        pgm_function54[(0, 55)] = 0.99
        pgm_function54[(0, 56)] = 0.84
        pgm_function54[(0, 57)] = 0.84
        pgm_function54[(0, 58)] = 0.99
        pgm_function54[(0, 59)] = 0.99
        pgm_function54[(0, 60)] = 0.94
        pgm_function54[(0, 61)] = 0.99
        pgm_function54[(0, 62)] = 0.88
        pgm_function54[(0, 63)] = 0.97
        pgm_function54[(0, 64)] = 0.84
        pgm_function54[(0, 65)] = 0.84
        pgm_function54[(0, 66)] = 0.91
        pgm_function54[(0, 67)] = 0.92
        pgm_function54[(0, 68)] = 0.99
        pgm_function54[(0, 70)] = 0.99
        pgm_function54[(0, 71)] = 0.99
        pgm_function54[(0, 72)] = 0.99
        pgm_function54[(0, 73)] = 0.99
        pgm_function54[(0, 74)] = 0.88
        pgm_function54[(0, 75)] = 0.94
        pgm_function54[(1, 0)] = 0.01
        pgm_function54[(1, 1)] = 0.01
        pgm_function54[(1, 2)] = 0.01
        pgm_function54[(1, 3)] = 0.35
        pgm_function54[(1, 4)] = 0.01
        pgm_function54[(1, 5)] = 0.01
        pgm_function54[(1, 6)] = 0.01
        pgm_function54[(1, 7)] = 0.01
        pgm_function54[(1, 8)] = 0.2
        pgm_function54[(1, 9)] = 0.5
        pgm_function54[(1, 10)] = 0.05
        pgm_function54[(1, 11)] = 0.05
        pgm_function54[(1, 12)] = 0.01
        pgm_function54[(1, 13)] = 0.01
        pgm_function54[(1, 14)] = 0.1
        pgm_function54[(1, 15)] = 0.1
        pgm_function54[(1, 16)] = 0.01
        pgm_function54[(1, 17)] = 0.01
        pgm_function54[(1, 18)] = 0.01
        pgm_function54[(1, 19)] = 0.01
        pgm_function54[(1, 20)] = 0.01
        pgm_function54[(1, 21)] = 0.01
        pgm_function54[(1, 22)] = 0.3
        pgm_function54[(1, 23)] = 0.05
        pgm_function54[(1, 24)] = 0.05
        pgm_function54[(1, 25)] = 0.01
        pgm_function54[(1, 26)] = 0.01
        pgm_function54[(1, 27)] = 0.2
        pgm_function54[(1, 28)] = 0.2
        pgm_function54[(1, 29)] = 0.2
        pgm_function54[(1, 30)] = 0.12871287
        pgm_function54[(1, 31)] = 0.12871287
        pgm_function54[(1, 32)] = 0.1
        pgm_function54[(1, 33)] = 0.1
        pgm_function54[(1, 34)] = 0.01
        pgm_function54[(1, 35)] = 0.01
        pgm_function54[(1, 36)] = 0.01
        pgm_function54[(1, 37)] = 0.01
        pgm_function54[(1, 38)] = 0.03
        pgm_function54[(1, 39)] = 0.03
        pgm_function54[(1, 40)] = 0.03
        pgm_function54[(1, 41)] = 0.03
        pgm_function54[(1, 42)] = 0.03
        pgm_function54[(1, 43)] = 0.07
        pgm_function54[(1, 44)] = 0.07
        pgm_function54[(1, 45)] = 0.07
        pgm_function54[(1, 46)] = 0.07
        pgm_function54[(1, 47)] = 0.07
        pgm_function54[(1, 48)] = 0.07
        pgm_function54[(1, 49)] = 0.07
        pgm_function54[(1, 50)] = 0.07
        pgm_function54[(1, 51)] = 0.07
        pgm_function54[(1, 52)] = 0.07
        pgm_function54[(1, 53)] = 0.07
        pgm_function54[(1, 54)] = 0.07
        pgm_function54[(1, 55)] = 0.01
        pgm_function54[(1, 56)] = 0.1
        pgm_function54[(1, 57)] = 0.1
        pgm_function54[(1, 58)] = 0.01
        pgm_function54[(1, 59)] = 0.01
        pgm_function54[(1, 60)] = 0.03
        pgm_function54[(1, 61)] = 0.01
        pgm_function54[(1, 62)] = 0.07
        pgm_function54[(1, 63)] = 0.01
        pgm_function54[(1, 64)] = 0.1
        pgm_function54[(1, 65)] = 0.1
        pgm_function54[(1, 66)] = 0.05
        pgm_function54[(1, 67)] = 0.05
        pgm_function54[(1, 68)] = 0.01
        pgm_function54[(1, 69)] = 0.1
        pgm_function54[(1, 70)] = 0.01
        pgm_function54[(1, 71)] = 0.01
        pgm_function54[(1, 72)] = 0.01
        pgm_function54[(1, 73)] = 0.01
        pgm_function54[(1, 74)] = 0.07
        pgm_function54[(1, 75)] = 0.03
        pgm_function54[(2, 3)] = 0.55
        pgm_function54[(2, 8)] = 0.2
        pgm_function54[(2, 9)] = 0.2
        pgm_function54[(2, 10)] = 0.03
        pgm_function54[(2, 11)] = 0.02
        pgm_function54[(2, 14)] = 0.4
        pgm_function54[(2, 15)] = 0.3
        pgm_function54[(2, 22)] = 0.35
        pgm_function54[(2, 23)] = 0.03
        pgm_function54[(2, 24)] = 0.02
        pgm_function54[(2, 25)] = 0.001
        pgm_function54[(2, 26)] = 0.001
        pgm_function54[(2, 27)] = 0.3
        pgm_function54[(2, 28)] = 0.3
        pgm_function54[(2, 29)] = 0.3
        pgm_function54[(2, 30)] = 0.01980198
        pgm_function54[(2, 31)] = 0.01980198
        pgm_function54[(2, 32)] = 0.07
        pgm_function54[(2, 33)] = 0.07
        pgm_function54[(2, 34)] = 0.01
        pgm_function54[(2, 35)] = 0.01
        pgm_function54[(2, 36)] = 0.01
        pgm_function54[(2, 37)] = 0.01
        pgm_function54[(2, 38)] = 0.02
        pgm_function54[(2, 39)] = 0.02
        pgm_function54[(2, 40)] = 0.02
        pgm_function54[(2, 41)] = 0.02
        pgm_function54[(2, 42)] = 0.02
        pgm_function54[(2, 43)] = 0.03
        pgm_function54[(2, 44)] = 0.03
        pgm_function54[(2, 45)] = 0.03
        pgm_function54[(2, 46)] = 0.03
        pgm_function54[(2, 47)] = 0.03
        pgm_function54[(2, 48)] = 0.03
        pgm_function54[(2, 49)] = 0.03
        pgm_function54[(2, 50)] = 0.03
        pgm_function54[(2, 51)] = 0.03
        pgm_function54[(2, 52)] = 0.03
        pgm_function54[(2, 53)] = 0.03
        pgm_function54[(2, 54)] = 0.03
        pgm_function54[(2, 56)] = 0.05
        pgm_function54[(2, 57)] = 0.05
        pgm_function54[(2, 60)] = 0.02
        pgm_function54[(2, 62)] = 0.03
        pgm_function54[(2, 63)] = 0.01
        pgm_function54[(2, 64)] = 0.05
        pgm_function54[(2, 65)] = 0.05
        pgm_function54[(2, 66)] = 0.03
        pgm_function54[(2, 67)] = 0.02
        pgm_function54[(2, 69)] = 0.6
        pgm_function54[(2, 74)] = 0.03
        pgm_function54[(2, 75)] = 0.02
        pgm_function54[(3, 3)] = 0.05
        pgm_function54[(3, 8)] = 0.2
        pgm_function54[(3, 9)] = 0.05
        pgm_function54[(3, 10)] = 0.01
        pgm_function54[(3, 11)] = 0.01
        pgm_function54[(3, 14)] = 0.2
        pgm_function54[(3, 15)] = 0.6
        pgm_function54[(3, 22)] = 0.3
        pgm_function54[(3, 23)] = 0.01
        pgm_function54[(3, 24)] = 0.01
        pgm_function54[(3, 27)] = 0.01
        pgm_function54[(3, 28)] = 0.01
        pgm_function54[(3, 29)] = 0.01
        pgm_function54[(3, 30)] = 0.00990099
        pgm_function54[(3, 31)] = 0.00990099
        pgm_function54[(3, 32)] = 0.05
        pgm_function54[(3, 33)] = 0.05
        pgm_function54[(3, 34)] = 0.01
        pgm_function54[(3, 35)] = 0.01
        pgm_function54[(3, 36)] = 0.01
        pgm_function54[(3, 37)] = 0.01
        pgm_function54[(3, 38)] = 0.01
        pgm_function54[(3, 39)] = 0.01
        pgm_function54[(3, 40)] = 0.01
        pgm_function54[(3, 41)] = 0.01
        pgm_function54[(3, 42)] = 0.01
        pgm_function54[(3, 43)] = 0.02
        pgm_function54[(3, 44)] = 0.02
        pgm_function54[(3, 45)] = 0.02
        pgm_function54[(3, 46)] = 0.02
        pgm_function54[(3, 47)] = 0.02
        pgm_function54[(3, 48)] = 0.02
        pgm_function54[(3, 49)] = 0.02
        pgm_function54[(3, 50)] = 0.02
        pgm_function54[(3, 51)] = 0.02
        pgm_function54[(3, 52)] = 0.02
        pgm_function54[(3, 53)] = 0.02
        pgm_function54[(3, 54)] = 0.02
        pgm_function54[(3, 56)] = 0.01
        pgm_function54[(3, 57)] = 0.01
        pgm_function54[(3, 60)] = 0.01
        pgm_function54[(3, 62)] = 0.02
        pgm_function54[(3, 63)] = 0.01
        pgm_function54[(3, 64)] = 0.01
        pgm_function54[(3, 65)] = 0.01
        pgm_function54[(3, 66)] = 0.01
        pgm_function54[(3, 67)] = 0.01
        pgm_function54[(3, 69)] = 0.3
        pgm_function54[(3, 74)] = 0.02
        pgm_function54[(3, 75)] = 0.01

        pgm_function55 = pgm_factor55.set_sparse()
        pgm_function55[(0, 0)] = 1.0
        pgm_function55[(0, 1)] = 1.0
        pgm_function55[(0, 2)] = 1.0
        pgm_function55[(0, 3)] = 0.9
        pgm_function55[(0, 4)] = 1.0
        pgm_function55[(0, 5)] = 1.0
        pgm_function55[(0, 6)] = 1.0
        pgm_function55[(0, 7)] = 1.0
        pgm_function55[(0, 8)] = 0.95
        pgm_function55[(0, 9)] = 1.0
        pgm_function55[(0, 10)] = 0.995
        pgm_function55[(0, 11)] = 1.0
        pgm_function55[(0, 12)] = 1.0
        pgm_function55[(0, 13)] = 1.0
        pgm_function55[(0, 14)] = 1.0
        pgm_function55[(0, 15)] = 0.9
        pgm_function55[(0, 16)] = 1.0
        pgm_function55[(0, 17)] = 1.0
        pgm_function55[(0, 18)] = 1.0
        pgm_function55[(0, 19)] = 1.0
        pgm_function55[(0, 20)] = 0.995
        pgm_function55[(0, 21)] = 1.0
        pgm_function55[(0, 22)] = 1.0
        pgm_function55[(0, 23)] = 0.995
        pgm_function55[(0, 24)] = 0.995
        pgm_function55[(0, 25)] = 1.0
        pgm_function55[(0, 26)] = 1.0
        pgm_function55[(0, 27)] = 0.995
        pgm_function55[(0, 28)] = 0.995
        pgm_function55[(0, 29)] = 0.995
        pgm_function55[(0, 30)] = 0.995
        pgm_function55[(0, 31)] = 0.995
        pgm_function55[(0, 32)] = 1.0
        pgm_function55[(0, 33)] = 1.0
        pgm_function55[(0, 34)] = 1.0
        pgm_function55[(0, 35)] = 1.0
        pgm_function55[(0, 36)] = 1.0
        pgm_function55[(0, 37)] = 1.0
        pgm_function55[(0, 38)] = 1.0
        pgm_function55[(0, 39)] = 1.0
        pgm_function55[(0, 40)] = 1.0
        pgm_function55[(0, 41)] = 1.0
        pgm_function55[(0, 42)] = 1.0
        pgm_function55[(0, 43)] = 1.0
        pgm_function55[(0, 44)] = 1.0
        pgm_function55[(0, 45)] = 1.0
        pgm_function55[(0, 46)] = 1.0
        pgm_function55[(0, 47)] = 1.0
        pgm_function55[(0, 48)] = 1.0
        pgm_function55[(0, 49)] = 1.0
        pgm_function55[(0, 50)] = 1.0
        pgm_function55[(0, 51)] = 1.0
        pgm_function55[(0, 52)] = 1.0
        pgm_function55[(0, 53)] = 1.0
        pgm_function55[(0, 54)] = 1.0
        pgm_function55[(0, 55)] = 1.0
        pgm_function55[(0, 56)] = 1.0
        pgm_function55[(0, 57)] = 1.0
        pgm_function55[(0, 58)] = 1.0
        pgm_function55[(0, 59)] = 1.0
        pgm_function55[(0, 60)] = 0.995
        pgm_function55[(0, 61)] = 1.0
        pgm_function55[(0, 62)] = 1.0
        pgm_function55[(0, 63)] = 0.97
        pgm_function55[(0, 64)] = 0.995
        pgm_function55[(0, 65)] = 1.0
        pgm_function55[(0, 66)] = 0.995
        pgm_function55[(0, 67)] = 1.0
        pgm_function55[(0, 68)] = 0.995
        pgm_function55[(0, 69)] = 0.7
        pgm_function55[(0, 70)] = 0.995
        pgm_function55[(0, 71)] = 0.995
        pgm_function55[(0, 72)] = 1.0
        pgm_function55[(0, 73)] = 1.0
        pgm_function55[(0, 74)] = 1.0
        pgm_function55[(0, 75)] = 1.0
        pgm_function55[(1, 3)] = 0.1
        pgm_function55[(1, 8)] = 0.05
        pgm_function55[(1, 10)] = 0.005
        pgm_function55[(1, 15)] = 0.1
        pgm_function55[(1, 20)] = 0.005
        pgm_function55[(1, 23)] = 0.005
        pgm_function55[(1, 24)] = 0.005
        pgm_function55[(1, 27)] = 0.005
        pgm_function55[(1, 28)] = 0.005
        pgm_function55[(1, 29)] = 0.005
        pgm_function55[(1, 30)] = 0.005
        pgm_function55[(1, 31)] = 0.005
        pgm_function55[(1, 60)] = 0.005
        pgm_function55[(1, 63)] = 0.03
        pgm_function55[(1, 64)] = 0.005
        pgm_function55[(1, 66)] = 0.005
        pgm_function55[(1, 68)] = 0.005
        pgm_function55[(1, 69)] = 0.3
        pgm_function55[(1, 70)] = 0.005
        pgm_function55[(1, 71)] = 0.005

        pgm_function56 = pgm_factor56.set_dense()
        pgm_function56.set_flat(
            0.691, 0.8, 0.691, 0.0, 0.691,
            0.691, 0.691, 0.691, 0.1, 0.691,
            0.37, 0.691, 0.691, 0.691, 0.89,
            0.0, 0.35, 0.691, 0.691, 0.691,
            0.37, 0.691, 0.691, 0.37, 0.691,
            0.691, 0.691, 0.1, 0.1, 0.1,
            0.1, 0.1, 0.691, 0.691, 0.691,
            0.691, 0.691, 0.691, 0.691, 0.691,
            0.691, 0.691, 0.691, 0.691, 0.691,
            0.691, 0.8, 0.691, 0.691, 0.691,
            0.691, 0.691, 0.691, 0.691, 0.691,
            0.691, 0.691, 0.691, 0.691, 0.691,
            0.05, 0.691, 0.691, 0.03, 0.1,
            0.691, 0.37, 0.6, 0.05, 0.0,
            0.37, 0.37, 0.37, 0.691, 0.691,
            0.691, 0.3, 0.19, 0.3, 0.6,
            0.3, 0.3, 0.3, 0.3, 0.7,
            0.3, 0.6, 0.3, 0.3, 0.3,
            0.11, 0.6, 0.6, 0.3, 0.3,
            0.3, 0.6, 0.3, 0.3, 0.6,
            0.3, 0.3, 0.3, 0.85, 0.85,
            0.85, 0.85, 0.85, 0.3, 0.3,
            0.3, 0.3, 0.3, 0.3, 0.3,
            0.3, 0.3, 0.3, 0.3, 0.3,
            0.3, 0.3, 0.19, 0.3, 0.3,
            0.3, 0.3, 0.3, 0.3, 0.3,
            0.3, 0.3, 0.3, 0.3, 0.3,
            0.3, 0.75, 0.3, 0.3, 0.77,
            0.85, 0.3, 0.6, 0.39, 0.75,
            0.6, 0.6, 0.6, 0.6, 0.3,
            0.3, 0.3, 0.009, 0.01, 0.009,
            0.4, 0.009, 0.009, 0.009, 0.009,
            0.2, 0.009, 0.03, 0.009, 0.009,
            0.009, 0.0, 0.4, 0.05, 0.009,
            0.009, 0.009, 0.03, 0.009, 0.009,
            0.03, 0.009, 0.009, 0.009, 0.05,
            0.05, 0.05, 0.05, 0.05, 0.009,
            0.009, 0.009, 0.009, 0.009, 0.009,
            0.009, 0.009, 0.009, 0.009, 0.009,
            0.009, 0.009, 0.009, 0.01, 0.009,
            0.009, 0.009, 0.009, 0.009, 0.009,
            0.009, 0.009, 0.009, 0.009, 0.009,
            0.009, 0.009, 0.2, 0.009, 0.009,
            0.2, 0.05, 0.009, 0.03, 0.01,
            0.2, 0.4, 0.03, 0.03, 0.03,
            0.009, 0.009, 0.009
        )

        pgm_function57 = pgm_factor57.set_sparse()
        pgm_function57[(0, 0)] = 1.0
        pgm_function57[(0, 1)] = 1.0
        pgm_function57[(0, 2)] = 1.0
        pgm_function57[(0, 3)] = 1.0
        pgm_function57[(0, 4)] = 1.0
        pgm_function57[(0, 5)] = 1.0
        pgm_function57[(0, 6)] = 1.0
        pgm_function57[(0, 7)] = 1.0
        pgm_function57[(0, 8)] = 1.0
        pgm_function57[(0, 9)] = 1.0
        pgm_function57[(0, 10)] = 1.0
        pgm_function57[(0, 11)] = 1.0
        pgm_function57[(0, 12)] = 1.0
        pgm_function57[(0, 13)] = 1.0
        pgm_function57[(0, 14)] = 1.0
        pgm_function57[(0, 15)] = 1.0
        pgm_function57[(0, 16)] = 1.0
        pgm_function57[(0, 17)] = 1.0
        pgm_function57[(0, 18)] = 1.0
        pgm_function57[(0, 19)] = 1.0
        pgm_function57[(0, 20)] = 1.0
        pgm_function57[(0, 21)] = 1.0
        pgm_function57[(0, 22)] = 1.0
        pgm_function57[(0, 23)] = 1.0
        pgm_function57[(0, 25)] = 1.0
        pgm_function57[(0, 26)] = 1.0
        pgm_function57[(0, 27)] = 1.0
        pgm_function57[(0, 28)] = 1.0
        pgm_function57[(0, 29)] = 1.0
        pgm_function57[(0, 30)] = 1.0
        pgm_function57[(0, 31)] = 1.0
        pgm_function57[(0, 32)] = 1.0
        pgm_function57[(0, 33)] = 1.0
        pgm_function57[(0, 34)] = 1.0
        pgm_function57[(0, 35)] = 1.0
        pgm_function57[(0, 36)] = 1.0
        pgm_function57[(0, 37)] = 1.0
        pgm_function57[(0, 38)] = 1.0
        pgm_function57[(0, 39)] = 1.0
        pgm_function57[(0, 40)] = 1.0
        pgm_function57[(0, 41)] = 1.0
        pgm_function57[(0, 42)] = 1.0
        pgm_function57[(0, 43)] = 1.0
        pgm_function57[(0, 44)] = 1.0
        pgm_function57[(0, 45)] = 1.0
        pgm_function57[(0, 46)] = 1.0
        pgm_function57[(0, 47)] = 1.0
        pgm_function57[(0, 48)] = 1.0
        pgm_function57[(0, 49)] = 1.0
        pgm_function57[(0, 50)] = 1.0
        pgm_function57[(0, 51)] = 1.0
        pgm_function57[(0, 52)] = 1.0
        pgm_function57[(0, 53)] = 1.0
        pgm_function57[(0, 54)] = 1.0
        pgm_function57[(0, 55)] = 1.0
        pgm_function57[(0, 56)] = 1.0
        pgm_function57[(0, 57)] = 1.0
        pgm_function57[(0, 58)] = 1.0
        pgm_function57[(0, 59)] = 1.0
        pgm_function57[(0, 60)] = 1.0
        pgm_function57[(0, 61)] = 1.0
        pgm_function57[(0, 62)] = 1.0
        pgm_function57[(0, 63)] = 1.0
        pgm_function57[(0, 64)] = 1.0
        pgm_function57[(0, 65)] = 1.0
        pgm_function57[(0, 66)] = 1.0
        pgm_function57[(0, 67)] = 1.0
        pgm_function57[(0, 68)] = 1.0
        pgm_function57[(0, 69)] = 1.0
        pgm_function57[(0, 70)] = 1.0
        pgm_function57[(0, 71)] = 1.0
        pgm_function57[(0, 72)] = 1.0
        pgm_function57[(0, 73)] = 1.0
        pgm_function57[(0, 74)] = 1.0
        pgm_function57[(0, 75)] = 1.0
        pgm_function57[(1, 24)] = 1.0

        pgm_function58 = pgm_factor58.set_dense()
        pgm_function58.set_flat(
            0.95, 0.65, 0.95, 0.4, 0.95,
            0.95, 0.95, 0.95, 0.85, 0.95,
            0.55, 0.95, 0.95, 0.95, 0.4,
            0.4, 0.95, 0.95, 0.95, 0.95,
            0.85, 0.95, 0.95, 0.7, 0.95,
            0.93, 0.93, 0.35, 0.35, 0.35,
            0.93, 0.93, 0.75, 0.75, 0.5,
            0.5, 0.3, 0.3, 0.6, 0.7,
            0.7, 0.6, 0.6, 0.2, 0.2,
            0.2, 0.2, 0.2, 0.2, 0.2,
            0.2, 0.2, 0.2, 0.2, 0.2,
            0.9, 0.9, 0.9, 0.8, 0.3,
            0.8, 0.95, 0.2, 0.5, 0.9,
            0.9, 0.55, 0.95, 0.8, 0.4,
            0.95, 0.95, 0.95, 0.95, 0.2,
            0.7, 0.04, 0.3, 0.04, 0.5,
            0.04, 0.04, 0.04, 0.04, 0.13,
            0.04, 0.35, 0.04, 0.04, 0.04,
            0.5, 0.5, 0.04, 0.04, 0.04,
            0.04, 0.13, 0.04, 0.04, 0.25,
            0.04, 0.05, 0.05, 0.45, 0.45,
            0.45, 0.05, 0.05, 0.2, 0.2,
            0.4, 0.4, 0.55, 0.55, 0.25,
            0.2, 0.2, 0.3, 0.3, 0.6,
            0.6, 0.6, 0.6, 0.6, 0.6,
            0.6, 0.6, 0.6, 0.6, 0.6,
            0.6, 0.09, 0.09, 0.09, 0.15,
            0.4, 0.15, 0.04, 0.6, 0.4,
            0.09, 0.09, 0.35, 0.04, 0.15,
            0.5, 0.04, 0.04, 0.04, 0.04,
            0.6, 0.2, 0.01, 0.05, 0.01,
            0.1, 0.01, 0.01, 0.01, 0.01,
            0.02, 0.01, 0.1, 0.01, 0.01,
            0.01, 0.1, 0.1, 0.01, 0.01,
            0.01, 0.01, 0.02, 0.01, 0.01,
            0.05, 0.01, 0.02, 0.02, 0.2,
            0.2, 0.2, 0.02, 0.02, 0.05,
            0.05, 0.1, 0.1, 0.15, 0.15,
            0.15, 0.1, 0.1, 0.1, 0.1,
            0.2, 0.2, 0.2, 0.2, 0.2,
            0.2, 0.2, 0.2, 0.2, 0.2,
            0.2, 0.2, 0.01, 0.01, 0.01,
            0.05, 0.3, 0.05, 0.01, 0.2,
            0.1, 0.01, 0.01, 0.1, 0.01,
            0.05, 0.1, 0.01, 0.01, 0.01,
            0.01, 0.2, 0.1
        )

        pgm_function59 = pgm_factor59.set_sparse()
        pgm_function59[(0, 0, 0)] = 0.5
        pgm_function59[(0, 0, 1)] = 0.5
        pgm_function59[(0, 0, 2)] = 0.5
        pgm_function59[(0, 0, 3)] = 0.5
        pgm_function59[(0, 3, 0)] = 0.5
        pgm_function59[(0, 3, 1)] = 0.5
        pgm_function59[(0, 3, 2)] = 0.5
        pgm_function59[(0, 3, 3)] = 0.5
        pgm_function59[(0, 4, 0)] = 0.005
        pgm_function59[(0, 4, 1)] = 0.005
        pgm_function59[(0, 4, 2)] = 0.005
        pgm_function59[(0, 4, 3)] = 0.005
        pgm_function59[(0, 5, 0)] = 0.5
        pgm_function59[(0, 5, 1)] = 0.5
        pgm_function59[(0, 5, 2)] = 0.5
        pgm_function59[(0, 5, 3)] = 0.5
        pgm_function59[(0, 6, 0)] = 0.5
        pgm_function59[(0, 6, 1)] = 0.5
        pgm_function59[(0, 6, 2)] = 0.5
        pgm_function59[(0, 6, 3)] = 0.5
        pgm_function59[(0, 8, 0)] = 0.5
        pgm_function59[(0, 8, 1)] = 0.5
        pgm_function59[(0, 8, 2)] = 0.5
        pgm_function59[(0, 8, 3)] = 0.5
        pgm_function59[(0, 9, 0)] = 0.5
        pgm_function59[(0, 9, 1)] = 0.5
        pgm_function59[(0, 9, 2)] = 0.5
        pgm_function59[(0, 9, 3)] = 0.5
        pgm_function59[(0, 10, 0)] = 0.1
        pgm_function59[(0, 10, 1)] = 0.1
        pgm_function59[(0, 10, 2)] = 0.1
        pgm_function59[(0, 10, 3)] = 0.1
        pgm_function59[(0, 11, 0)] = 0.5
        pgm_function59[(0, 11, 1)] = 0.5
        pgm_function59[(0, 11, 2)] = 0.5
        pgm_function59[(0, 11, 3)] = 0.5
        pgm_function59[(0, 12, 0)] = 0.5
        pgm_function59[(0, 12, 1)] = 0.5
        pgm_function59[(0, 12, 2)] = 0.5
        pgm_function59[(0, 12, 3)] = 0.5
        pgm_function59[(0, 13, 0)] = 0.5
        pgm_function59[(0, 13, 1)] = 0.5
        pgm_function59[(0, 13, 2)] = 0.5
        pgm_function59[(0, 13, 3)] = 0.5
        pgm_function59[(0, 14, 0)] = 0.5
        pgm_function59[(0, 14, 1)] = 0.5
        pgm_function59[(0, 14, 2)] = 0.5
        pgm_function59[(0, 14, 3)] = 0.5
        pgm_function59[(0, 15, 0)] = 0.5
        pgm_function59[(0, 15, 1)] = 0.5
        pgm_function59[(0, 15, 2)] = 0.5
        pgm_function59[(0, 15, 3)] = 0.5
        pgm_function59[(0, 17, 0)] = 0.5
        pgm_function59[(0, 17, 1)] = 0.5
        pgm_function59[(0, 17, 2)] = 0.5
        pgm_function59[(0, 17, 3)] = 0.5
        pgm_function59[(0, 19, 0)] = 0.5
        pgm_function59[(0, 19, 1)] = 0.5
        pgm_function59[(0, 19, 2)] = 0.5
        pgm_function59[(0, 19, 3)] = 0.5
        pgm_function59[(0, 21, 0)] = 0.5
        pgm_function59[(0, 21, 1)] = 0.5
        pgm_function59[(0, 21, 2)] = 0.5
        pgm_function59[(0, 21, 3)] = 0.5
        pgm_function59[(0, 22, 0)] = 0.5
        pgm_function59[(0, 22, 1)] = 0.5
        pgm_function59[(0, 22, 2)] = 0.5
        pgm_function59[(0, 22, 3)] = 0.5
        pgm_function59[(0, 23, 0)] = 0.1
        pgm_function59[(0, 23, 1)] = 0.1
        pgm_function59[(0, 23, 2)] = 0.1
        pgm_function59[(0, 23, 3)] = 0.1
        pgm_function59[(0, 24, 0)] = 0.5
        pgm_function59[(0, 24, 1)] = 0.5
        pgm_function59[(0, 24, 2)] = 0.5
        pgm_function59[(0, 24, 3)] = 0.5
        pgm_function59[(0, 25, 0)] = 0.5
        pgm_function59[(0, 25, 1)] = 0.5
        pgm_function59[(0, 25, 2)] = 0.5
        pgm_function59[(0, 25, 3)] = 0.5
        pgm_function59[(0, 26, 0)] = 0.5
        pgm_function59[(0, 26, 1)] = 0.5
        pgm_function59[(0, 26, 2)] = 0.5
        pgm_function59[(0, 26, 3)] = 0.5
        pgm_function59[(0, 27, 0)] = 0.1
        pgm_function59[(0, 27, 1)] = 0.1
        pgm_function59[(0, 27, 2)] = 0.1
        pgm_function59[(0, 27, 3)] = 0.1
        pgm_function59[(0, 28, 0)] = 0.5
        pgm_function59[(0, 28, 1)] = 0.5
        pgm_function59[(0, 28, 2)] = 0.5
        pgm_function59[(0, 28, 3)] = 0.5
        pgm_function59[(0, 29, 0)] = 0.5
        pgm_function59[(0, 29, 1)] = 0.5
        pgm_function59[(0, 29, 2)] = 0.5
        pgm_function59[(0, 29, 3)] = 0.5
        pgm_function59[(0, 30, 0)] = 0.1
        pgm_function59[(0, 30, 1)] = 0.1
        pgm_function59[(0, 30, 2)] = 0.1
        pgm_function59[(0, 30, 3)] = 0.1
        pgm_function59[(0, 31, 0)] = 0.5
        pgm_function59[(0, 31, 1)] = 0.5
        pgm_function59[(0, 31, 2)] = 0.5
        pgm_function59[(0, 31, 3)] = 0.5
        pgm_function59[(0, 32, 0)] = 0.5
        pgm_function59[(0, 32, 1)] = 0.5
        pgm_function59[(0, 32, 2)] = 0.5
        pgm_function59[(0, 32, 3)] = 0.5
        pgm_function59[(0, 33, 0)] = 0.5
        pgm_function59[(0, 33, 1)] = 0.5
        pgm_function59[(0, 33, 2)] = 0.5
        pgm_function59[(0, 33, 3)] = 0.5
        pgm_function59[(0, 34, 0)] = 0.5
        pgm_function59[(0, 34, 1)] = 0.5
        pgm_function59[(0, 34, 2)] = 0.5
        pgm_function59[(0, 34, 3)] = 0.5
        pgm_function59[(0, 35, 0)] = 0.5
        pgm_function59[(0, 35, 1)] = 0.5
        pgm_function59[(0, 35, 2)] = 0.5
        pgm_function59[(0, 35, 3)] = 0.5
        pgm_function59[(0, 36, 0)] = 0.5
        pgm_function59[(0, 36, 1)] = 0.5
        pgm_function59[(0, 36, 2)] = 0.5
        pgm_function59[(0, 36, 3)] = 0.5
        pgm_function59[(0, 37, 0)] = 0.5
        pgm_function59[(0, 37, 1)] = 0.5
        pgm_function59[(0, 37, 2)] = 0.5
        pgm_function59[(0, 37, 3)] = 0.5
        pgm_function59[(0, 38, 0)] = 0.5
        pgm_function59[(0, 38, 1)] = 0.5
        pgm_function59[(0, 38, 2)] = 0.5
        pgm_function59[(0, 38, 3)] = 0.5
        pgm_function59[(0, 40, 0)] = 0.5
        pgm_function59[(0, 40, 1)] = 0.5
        pgm_function59[(0, 40, 2)] = 0.5
        pgm_function59[(0, 40, 3)] = 0.5
        pgm_function59[(0, 41, 0)] = 0.5
        pgm_function59[(0, 41, 1)] = 0.5
        pgm_function59[(0, 41, 2)] = 0.5
        pgm_function59[(0, 41, 3)] = 0.5
        pgm_function59[(0, 42, 0)] = 0.37
        pgm_function59[(0, 42, 1)] = 0.37
        pgm_function59[(0, 42, 2)] = 0.37
        pgm_function59[(0, 42, 3)] = 0.27
        pgm_function59[(0, 43, 0)] = 0.5
        pgm_function59[(0, 43, 1)] = 0.5
        pgm_function59[(0, 43, 2)] = 0.5
        pgm_function59[(0, 43, 3)] = 0.5
        pgm_function59[(0, 44, 0)] = 0.15
        pgm_function59[(0, 44, 1)] = 0.15
        pgm_function59[(0, 44, 2)] = 0.15
        pgm_function59[(0, 44, 3)] = 0.25
        pgm_function59[(0, 45, 0)] = 0.37
        pgm_function59[(0, 45, 1)] = 0.37
        pgm_function59[(0, 45, 2)] = 0.37
        pgm_function59[(0, 45, 3)] = 0.27
        pgm_function59[(0, 47, 0)] = 0.5
        pgm_function59[(0, 47, 1)] = 0.5
        pgm_function59[(0, 47, 2)] = 0.5
        pgm_function59[(0, 47, 3)] = 0.5
        pgm_function59[(0, 48, 0)] = 0.5
        pgm_function59[(0, 48, 1)] = 0.5
        pgm_function59[(0, 48, 2)] = 0.5
        pgm_function59[(0, 48, 3)] = 0.5
        pgm_function59[(0, 49, 0)] = 0.5
        pgm_function59[(0, 49, 1)] = 0.5
        pgm_function59[(0, 49, 2)] = 0.5
        pgm_function59[(0, 49, 3)] = 0.5
        pgm_function59[(0, 50, 0)] = 0.5
        pgm_function59[(0, 50, 1)] = 0.5
        pgm_function59[(0, 50, 2)] = 0.5
        pgm_function59[(0, 50, 3)] = 0.5
        pgm_function59[(0, 51, 0)] = 0.5
        pgm_function59[(0, 51, 1)] = 0.5
        pgm_function59[(0, 51, 2)] = 0.5
        pgm_function59[(0, 51, 3)] = 0.5
        pgm_function59[(0, 53, 0)] = 0.75
        pgm_function59[(0, 53, 1)] = 0.75
        pgm_function59[(0, 53, 2)] = 0.75
        pgm_function59[(0, 53, 3)] = 0.59
        pgm_function59[(0, 54, 0)] = 0.5
        pgm_function59[(0, 54, 1)] = 0.5
        pgm_function59[(0, 54, 2)] = 0.5
        pgm_function59[(0, 54, 3)] = 0.5
        pgm_function59[(0, 55, 0)] = 0.5
        pgm_function59[(0, 55, 1)] = 0.5
        pgm_function59[(0, 55, 2)] = 0.5
        pgm_function59[(0, 55, 3)] = 0.5
        pgm_function59[(0, 56, 0)] = 0.5
        pgm_function59[(0, 56, 1)] = 0.5
        pgm_function59[(0, 56, 2)] = 0.5
        pgm_function59[(0, 56, 3)] = 0.5
        pgm_function59[(0, 60, 0)] = 0.5
        pgm_function59[(0, 60, 1)] = 0.5
        pgm_function59[(0, 60, 2)] = 0.5
        pgm_function59[(0, 60, 3)] = 0.5
        pgm_function59[(0, 62, 0)] = 0.5
        pgm_function59[(0, 62, 1)] = 0.5
        pgm_function59[(0, 62, 2)] = 0.5
        pgm_function59[(0, 62, 3)] = 0.5
        pgm_function59[(0, 63, 0)] = 0.1
        pgm_function59[(0, 63, 1)] = 0.1
        pgm_function59[(0, 63, 2)] = 0.1
        pgm_function59[(0, 63, 3)] = 0.1
        pgm_function59[(0, 64, 0)] = 0.5
        pgm_function59[(0, 64, 1)] = 0.5
        pgm_function59[(0, 64, 2)] = 0.5
        pgm_function59[(0, 64, 3)] = 0.5
        pgm_function59[(0, 65, 0)] = 0.5
        pgm_function59[(0, 65, 1)] = 0.5
        pgm_function59[(0, 65, 2)] = 0.5
        pgm_function59[(0, 65, 3)] = 0.5
        pgm_function59[(0, 66, 0)] = 0.1
        pgm_function59[(0, 66, 1)] = 0.1
        pgm_function59[(0, 66, 2)] = 0.1
        pgm_function59[(0, 66, 3)] = 0.1
        pgm_function59[(0, 67, 0)] = 0.5
        pgm_function59[(0, 67, 1)] = 0.5
        pgm_function59[(0, 67, 2)] = 0.5
        pgm_function59[(0, 67, 3)] = 0.5
        pgm_function59[(0, 68, 0)] = 0.5
        pgm_function59[(0, 68, 1)] = 0.5
        pgm_function59[(0, 68, 2)] = 0.5
        pgm_function59[(0, 68, 3)] = 0.5
        pgm_function59[(0, 69, 0)] = 0.5
        pgm_function59[(0, 69, 1)] = 0.5
        pgm_function59[(0, 69, 2)] = 0.5
        pgm_function59[(0, 69, 3)] = 0.5
        pgm_function59[(0, 70, 0)] = 0.1
        pgm_function59[(0, 70, 1)] = 0.1
        pgm_function59[(0, 70, 2)] = 0.1
        pgm_function59[(0, 70, 3)] = 0.1
        pgm_function59[(0, 71, 0)] = 0.1
        pgm_function59[(0, 71, 1)] = 0.1
        pgm_function59[(0, 71, 2)] = 0.1
        pgm_function59[(0, 71, 3)] = 0.1
        pgm_function59[(0, 72, 0)] = 0.1
        pgm_function59[(0, 72, 1)] = 0.1
        pgm_function59[(0, 72, 2)] = 0.1
        pgm_function59[(0, 72, 3)] = 0.1
        pgm_function59[(0, 73, 0)] = 0.5
        pgm_function59[(0, 73, 1)] = 0.5
        pgm_function59[(0, 73, 2)] = 0.5
        pgm_function59[(0, 73, 3)] = 0.5
        pgm_function59[(0, 74, 0)] = 0.5
        pgm_function59[(0, 74, 1)] = 0.5
        pgm_function59[(0, 74, 2)] = 0.5
        pgm_function59[(0, 74, 3)] = 0.5
        pgm_function59[(0, 75, 0)] = 0.5
        pgm_function59[(0, 75, 1)] = 0.5
        pgm_function59[(0, 75, 2)] = 0.5
        pgm_function59[(0, 75, 3)] = 0.5
        pgm_function59[(1, 0, 0)] = 0.48
        pgm_function59[(1, 0, 1)] = 0.48
        pgm_function59[(1, 0, 2)] = 0.48
        pgm_function59[(1, 0, 3)] = 0.37
        pgm_function59[(1, 1, 0)] = 0.01
        pgm_function59[(1, 1, 1)] = 0.01
        pgm_function59[(1, 1, 2)] = 0.01
        pgm_function59[(1, 1, 3)] = 0.01
        pgm_function59[(1, 2, 0)] = 0.01
        pgm_function59[(1, 2, 1)] = 0.01
        pgm_function59[(1, 2, 2)] = 0.01
        pgm_function59[(1, 2, 3)] = 0.01
        pgm_function59[(1, 3, 0)] = 0.48
        pgm_function59[(1, 3, 1)] = 0.48
        pgm_function59[(1, 3, 2)] = 0.48
        pgm_function59[(1, 3, 3)] = 0.37
        pgm_function59[(1, 4, 0)] = 0.25
        pgm_function59[(1, 4, 1)] = 0.25
        pgm_function59[(1, 4, 2)] = 0.25
        pgm_function59[(1, 4, 3)] = 0.25
        pgm_function59[(1, 5, 0)] = 0.48
        pgm_function59[(1, 5, 1)] = 0.48
        pgm_function59[(1, 5, 2)] = 0.48
        pgm_function59[(1, 5, 3)] = 0.37
        pgm_function59[(1, 6, 0)] = 0.48
        pgm_function59[(1, 6, 1)] = 0.48
        pgm_function59[(1, 6, 2)] = 0.48
        pgm_function59[(1, 6, 3)] = 0.37
        pgm_function59[(1, 8, 0)] = 0.48
        pgm_function59[(1, 8, 1)] = 0.48
        pgm_function59[(1, 8, 2)] = 0.48
        pgm_function59[(1, 8, 3)] = 0.37
        pgm_function59[(1, 9, 0)] = 0.48
        pgm_function59[(1, 9, 1)] = 0.48
        pgm_function59[(1, 9, 2)] = 0.48
        pgm_function59[(1, 9, 3)] = 0.37
        pgm_function59[(1, 10, 0)] = 0.74
        pgm_function59[(1, 10, 1)] = 0.74
        pgm_function59[(1, 10, 2)] = 0.74
        pgm_function59[(1, 10, 3)] = 0.62
        pgm_function59[(1, 11, 0)] = 0.48
        pgm_function59[(1, 11, 1)] = 0.48
        pgm_function59[(1, 11, 2)] = 0.48
        pgm_function59[(1, 11, 3)] = 0.37
        pgm_function59[(1, 12, 0)] = 0.48
        pgm_function59[(1, 12, 1)] = 0.48
        pgm_function59[(1, 12, 2)] = 0.48
        pgm_function59[(1, 12, 3)] = 0.37
        pgm_function59[(1, 13, 0)] = 0.48
        pgm_function59[(1, 13, 1)] = 0.48
        pgm_function59[(1, 13, 2)] = 0.48
        pgm_function59[(1, 13, 3)] = 0.37
        pgm_function59[(1, 14, 0)] = 0.48
        pgm_function59[(1, 14, 1)] = 0.48
        pgm_function59[(1, 14, 2)] = 0.48
        pgm_function59[(1, 14, 3)] = 0.37
        pgm_function59[(1, 15, 0)] = 0.48
        pgm_function59[(1, 15, 1)] = 0.48
        pgm_function59[(1, 15, 2)] = 0.48
        pgm_function59[(1, 15, 3)] = 0.37
        pgm_function59[(1, 16, 0)] = 0.01
        pgm_function59[(1, 16, 1)] = 0.01
        pgm_function59[(1, 16, 2)] = 0.01
        pgm_function59[(1, 16, 3)] = 0.01
        pgm_function59[(1, 17, 0)] = 0.48
        pgm_function59[(1, 17, 1)] = 0.48
        pgm_function59[(1, 17, 2)] = 0.48
        pgm_function59[(1, 17, 3)] = 0.37
        pgm_function59[(1, 18, 0)] = 0.01
        pgm_function59[(1, 18, 1)] = 0.01
        pgm_function59[(1, 18, 2)] = 0.01
        pgm_function59[(1, 18, 3)] = 0.01
        pgm_function59[(1, 19, 0)] = 0.48
        pgm_function59[(1, 19, 1)] = 0.48
        pgm_function59[(1, 19, 2)] = 0.48
        pgm_function59[(1, 19, 3)] = 0.37
        pgm_function59[(1, 20, 0)] = 0.01
        pgm_function59[(1, 20, 1)] = 0.01
        pgm_function59[(1, 20, 2)] = 0.01
        pgm_function59[(1, 20, 3)] = 0.01
        pgm_function59[(1, 21, 0)] = 0.48
        pgm_function59[(1, 21, 1)] = 0.48
        pgm_function59[(1, 21, 2)] = 0.48
        pgm_function59[(1, 21, 3)] = 0.37
        pgm_function59[(1, 22, 0)] = 0.48
        pgm_function59[(1, 22, 1)] = 0.48
        pgm_function59[(1, 22, 2)] = 0.48
        pgm_function59[(1, 22, 3)] = 0.37
        pgm_function59[(1, 23, 0)] = 0.74
        pgm_function59[(1, 23, 1)] = 0.74
        pgm_function59[(1, 23, 2)] = 0.74
        pgm_function59[(1, 23, 3)] = 0.62
        pgm_function59[(1, 24, 0)] = 0.48
        pgm_function59[(1, 24, 1)] = 0.48
        pgm_function59[(1, 24, 2)] = 0.48
        pgm_function59[(1, 24, 3)] = 0.37
        pgm_function59[(1, 25, 0)] = 0.48
        pgm_function59[(1, 25, 1)] = 0.48
        pgm_function59[(1, 25, 2)] = 0.48
        pgm_function59[(1, 25, 3)] = 0.37
        pgm_function59[(1, 26, 0)] = 0.48
        pgm_function59[(1, 26, 1)] = 0.48
        pgm_function59[(1, 26, 2)] = 0.48
        pgm_function59[(1, 26, 3)] = 0.37
        pgm_function59[(1, 27, 0)] = 0.8
        pgm_function59[(1, 27, 1)] = 0.8
        pgm_function59[(1, 27, 2)] = 0.8
        pgm_function59[(1, 27, 3)] = 0.68
        pgm_function59[(1, 28, 0)] = 0.48
        pgm_function59[(1, 28, 1)] = 0.48
        pgm_function59[(1, 28, 2)] = 0.48
        pgm_function59[(1, 28, 3)] = 0.37
        pgm_function59[(1, 29, 0)] = 0.48
        pgm_function59[(1, 29, 1)] = 0.48
        pgm_function59[(1, 29, 2)] = 0.48
        pgm_function59[(1, 29, 3)] = 0.37
        pgm_function59[(1, 30, 0)] = 0.8
        pgm_function59[(1, 30, 1)] = 0.8
        pgm_function59[(1, 30, 2)] = 0.8
        pgm_function59[(1, 30, 3)] = 0.68
        pgm_function59[(1, 31, 0)] = 0.48
        pgm_function59[(1, 31, 1)] = 0.48
        pgm_function59[(1, 31, 2)] = 0.48
        pgm_function59[(1, 31, 3)] = 0.37
        pgm_function59[(1, 32, 0)] = 0.48
        pgm_function59[(1, 32, 1)] = 0.48
        pgm_function59[(1, 32, 2)] = 0.48
        pgm_function59[(1, 32, 3)] = 0.37
        pgm_function59[(1, 33, 0)] = 0.48
        pgm_function59[(1, 33, 1)] = 0.48
        pgm_function59[(1, 33, 2)] = 0.48
        pgm_function59[(1, 33, 3)] = 0.37
        pgm_function59[(1, 34, 0)] = 0.48
        pgm_function59[(1, 34, 1)] = 0.48
        pgm_function59[(1, 34, 2)] = 0.48
        pgm_function59[(1, 34, 3)] = 0.37
        pgm_function59[(1, 35, 0)] = 0.48
        pgm_function59[(1, 35, 1)] = 0.48
        pgm_function59[(1, 35, 2)] = 0.48
        pgm_function59[(1, 35, 3)] = 0.37
        pgm_function59[(1, 36, 0)] = 0.48
        pgm_function59[(1, 36, 1)] = 0.48
        pgm_function59[(1, 36, 2)] = 0.48
        pgm_function59[(1, 36, 3)] = 0.37
        pgm_function59[(1, 37, 0)] = 0.48
        pgm_function59[(1, 37, 1)] = 0.48
        pgm_function59[(1, 37, 2)] = 0.48
        pgm_function59[(1, 37, 3)] = 0.37
        pgm_function59[(1, 38, 0)] = 0.48
        pgm_function59[(1, 38, 1)] = 0.48
        pgm_function59[(1, 38, 2)] = 0.48
        pgm_function59[(1, 38, 3)] = 0.37
        pgm_function59[(1, 39, 0)] = 0.149
        pgm_function59[(1, 39, 1)] = 0.149
        pgm_function59[(1, 39, 2)] = 0.149
        pgm_function59[(1, 39, 3)] = 0.149
        pgm_function59[(1, 40, 0)] = 0.48
        pgm_function59[(1, 40, 1)] = 0.48
        pgm_function59[(1, 40, 2)] = 0.48
        pgm_function59[(1, 40, 3)] = 0.37
        pgm_function59[(1, 41, 0)] = 0.48
        pgm_function59[(1, 41, 1)] = 0.48
        pgm_function59[(1, 41, 2)] = 0.48
        pgm_function59[(1, 41, 3)] = 0.37
        pgm_function59[(1, 42, 0)] = 0.46
        pgm_function59[(1, 42, 1)] = 0.46
        pgm_function59[(1, 42, 2)] = 0.46
        pgm_function59[(1, 42, 3)] = 0.46
        pgm_function59[(1, 43, 0)] = 0.48
        pgm_function59[(1, 43, 1)] = 0.48
        pgm_function59[(1, 43, 2)] = 0.48
        pgm_function59[(1, 43, 3)] = 0.37
        pgm_function59[(1, 44, 0)] = 0.7
        pgm_function59[(1, 44, 1)] = 0.7
        pgm_function59[(1, 44, 2)] = 0.7
        pgm_function59[(1, 44, 3)] = 0.58
        pgm_function59[(1, 45, 0)] = 0.46
        pgm_function59[(1, 45, 1)] = 0.46
        pgm_function59[(1, 45, 2)] = 0.46
        pgm_function59[(1, 45, 3)] = 0.46
        pgm_function59[(1, 46, 0)] = 0.01
        pgm_function59[(1, 46, 1)] = 0.01
        pgm_function59[(1, 46, 2)] = 0.01
        pgm_function59[(1, 46, 3)] = 0.01
        pgm_function59[(1, 47, 0)] = 0.48
        pgm_function59[(1, 47, 1)] = 0.48
        pgm_function59[(1, 47, 2)] = 0.48
        pgm_function59[(1, 47, 3)] = 0.37
        pgm_function59[(1, 48, 0)] = 0.48
        pgm_function59[(1, 48, 1)] = 0.48
        pgm_function59[(1, 48, 2)] = 0.48
        pgm_function59[(1, 48, 3)] = 0.37
        pgm_function59[(1, 49, 0)] = 0.48
        pgm_function59[(1, 49, 1)] = 0.48
        pgm_function59[(1, 49, 2)] = 0.48
        pgm_function59[(1, 49, 3)] = 0.37
        pgm_function59[(1, 50, 0)] = 0.48
        pgm_function59[(1, 50, 1)] = 0.48
        pgm_function59[(1, 50, 2)] = 0.48
        pgm_function59[(1, 50, 3)] = 0.37
        pgm_function59[(1, 51, 0)] = 0.48
        pgm_function59[(1, 51, 1)] = 0.48
        pgm_function59[(1, 51, 2)] = 0.48
        pgm_function59[(1, 51, 3)] = 0.37
        pgm_function59[(1, 52, 0)] = 0.1
        pgm_function59[(1, 52, 1)] = 0.1
        pgm_function59[(1, 52, 2)] = 0.1
        pgm_function59[(1, 52, 3)] = 0.1
        pgm_function59[(1, 53, 0)] = 0.2
        pgm_function59[(1, 53, 1)] = 0.2
        pgm_function59[(1, 53, 2)] = 0.2
        pgm_function59[(1, 53, 3)] = 0.24
        pgm_function59[(1, 54, 0)] = 0.48
        pgm_function59[(1, 54, 1)] = 0.48
        pgm_function59[(1, 54, 2)] = 0.48
        pgm_function59[(1, 54, 3)] = 0.37
        pgm_function59[(1, 55, 0)] = 0.48
        pgm_function59[(1, 55, 1)] = 0.48
        pgm_function59[(1, 55, 2)] = 0.48
        pgm_function59[(1, 55, 3)] = 0.37
        pgm_function59[(1, 56, 0)] = 0.48
        pgm_function59[(1, 56, 1)] = 0.48
        pgm_function59[(1, 56, 2)] = 0.48
        pgm_function59[(1, 56, 3)] = 0.37
        pgm_function59[(1, 57, 0)] = 0.01
        pgm_function59[(1, 57, 1)] = 0.01
        pgm_function59[(1, 57, 2)] = 0.01
        pgm_function59[(1, 57, 3)] = 0.01
        pgm_function59[(1, 59, 0)] = 0.01
        pgm_function59[(1, 59, 1)] = 0.01
        pgm_function59[(1, 59, 2)] = 0.01
        pgm_function59[(1, 59, 3)] = 0.01
        pgm_function59[(1, 60, 0)] = 0.48
        pgm_function59[(1, 60, 1)] = 0.48
        pgm_function59[(1, 60, 2)] = 0.48
        pgm_function59[(1, 60, 3)] = 0.37
        pgm_function59[(1, 61, 0)] = 0.01
        pgm_function59[(1, 61, 1)] = 0.01
        pgm_function59[(1, 61, 2)] = 0.01
        pgm_function59[(1, 61, 3)] = 0.01
        pgm_function59[(1, 62, 0)] = 0.48
        pgm_function59[(1, 62, 1)] = 0.48
        pgm_function59[(1, 62, 2)] = 0.48
        pgm_function59[(1, 62, 3)] = 0.37
        pgm_function59[(1, 63, 0)] = 0.7
        pgm_function59[(1, 63, 1)] = 0.7
        pgm_function59[(1, 63, 2)] = 0.7
        pgm_function59[(1, 63, 3)] = 0.778
        pgm_function59[(1, 64, 0)] = 0.48
        pgm_function59[(1, 64, 1)] = 0.48
        pgm_function59[(1, 64, 2)] = 0.48
        pgm_function59[(1, 64, 3)] = 0.37
        pgm_function59[(1, 65, 0)] = 0.48
        pgm_function59[(1, 65, 1)] = 0.48
        pgm_function59[(1, 65, 2)] = 0.48
        pgm_function59[(1, 65, 3)] = 0.37
        pgm_function59[(1, 66, 0)] = 0.74
        pgm_function59[(1, 66, 1)] = 0.74
        pgm_function59[(1, 66, 2)] = 0.74
        pgm_function59[(1, 66, 3)] = 0.62
        pgm_function59[(1, 67, 0)] = 0.48
        pgm_function59[(1, 67, 1)] = 0.48
        pgm_function59[(1, 67, 2)] = 0.48
        pgm_function59[(1, 67, 3)] = 0.37
        pgm_function59[(1, 68, 0)] = 0.48
        pgm_function59[(1, 68, 1)] = 0.48
        pgm_function59[(1, 68, 2)] = 0.48
        pgm_function59[(1, 68, 3)] = 0.37
        pgm_function59[(1, 69, 0)] = 0.48
        pgm_function59[(1, 69, 1)] = 0.48
        pgm_function59[(1, 69, 2)] = 0.48
        pgm_function59[(1, 69, 3)] = 0.37
        pgm_function59[(1, 70, 0)] = 0.74
        pgm_function59[(1, 70, 1)] = 0.74
        pgm_function59[(1, 70, 2)] = 0.74
        pgm_function59[(1, 70, 3)] = 0.62
        pgm_function59[(1, 71, 0)] = 0.74
        pgm_function59[(1, 71, 1)] = 0.74
        pgm_function59[(1, 71, 2)] = 0.74
        pgm_function59[(1, 71, 3)] = 0.62
        pgm_function59[(1, 72, 0)] = 0.74
        pgm_function59[(1, 72, 1)] = 0.74
        pgm_function59[(1, 72, 2)] = 0.74
        pgm_function59[(1, 72, 3)] = 0.62
        pgm_function59[(1, 73, 0)] = 0.48
        pgm_function59[(1, 73, 1)] = 0.48
        pgm_function59[(1, 73, 2)] = 0.48
        pgm_function59[(1, 73, 3)] = 0.37
        pgm_function59[(1, 74, 0)] = 0.48
        pgm_function59[(1, 74, 1)] = 0.48
        pgm_function59[(1, 74, 2)] = 0.48
        pgm_function59[(1, 74, 3)] = 0.37
        pgm_function59[(1, 75, 0)] = 0.48
        pgm_function59[(1, 75, 1)] = 0.48
        pgm_function59[(1, 75, 2)] = 0.48
        pgm_function59[(1, 75, 3)] = 0.37
        pgm_function59[(2, 0, 0)] = 0.015
        pgm_function59[(2, 0, 1)] = 0.015
        pgm_function59[(2, 0, 2)] = 0.015
        pgm_function59[(2, 0, 3)] = 0.035
        pgm_function59[(2, 1, 0)] = 0.79
        pgm_function59[(2, 1, 1)] = 0.79
        pgm_function59[(2, 1, 2)] = 0.79
        pgm_function59[(2, 1, 3)] = 0.7
        pgm_function59[(2, 2, 0)] = 0.79
        pgm_function59[(2, 2, 1)] = 0.79
        pgm_function59[(2, 2, 2)] = 0.79
        pgm_function59[(2, 2, 3)] = 0.7
        pgm_function59[(2, 3, 0)] = 0.015
        pgm_function59[(2, 3, 1)] = 0.015
        pgm_function59[(2, 3, 2)] = 0.015
        pgm_function59[(2, 3, 3)] = 0.035
        pgm_function59[(2, 4, 0)] = 0.695
        pgm_function59[(2, 4, 1)] = 0.695
        pgm_function59[(2, 4, 2)] = 0.695
        pgm_function59[(2, 4, 3)] = 0.605
        pgm_function59[(2, 5, 0)] = 0.015
        pgm_function59[(2, 5, 1)] = 0.015
        pgm_function59[(2, 5, 2)] = 0.015
        pgm_function59[(2, 5, 3)] = 0.035
        pgm_function59[(2, 6, 0)] = 0.015
        pgm_function59[(2, 6, 1)] = 0.015
        pgm_function59[(2, 6, 2)] = 0.015
        pgm_function59[(2, 6, 3)] = 0.035
        pgm_function59[(2, 7, 0)] = 0.2
        pgm_function59[(2, 7, 1)] = 0.2
        pgm_function59[(2, 7, 2)] = 0.2
        pgm_function59[(2, 7, 3)] = 0.2
        pgm_function59[(2, 8, 0)] = 0.015
        pgm_function59[(2, 8, 1)] = 0.015
        pgm_function59[(2, 8, 2)] = 0.015
        pgm_function59[(2, 8, 3)] = 0.035
        pgm_function59[(2, 9, 0)] = 0.015
        pgm_function59[(2, 9, 1)] = 0.015
        pgm_function59[(2, 9, 2)] = 0.015
        pgm_function59[(2, 9, 3)] = 0.035
        pgm_function59[(2, 10, 0)] = 0.15
        pgm_function59[(2, 10, 1)] = 0.15
        pgm_function59[(2, 10, 2)] = 0.15
        pgm_function59[(2, 10, 3)] = 0.18
        pgm_function59[(2, 11, 0)] = 0.015
        pgm_function59[(2, 11, 1)] = 0.015
        pgm_function59[(2, 11, 2)] = 0.015
        pgm_function59[(2, 11, 3)] = 0.035
        pgm_function59[(2, 12, 0)] = 0.015
        pgm_function59[(2, 12, 1)] = 0.015
        pgm_function59[(2, 12, 2)] = 0.015
        pgm_function59[(2, 12, 3)] = 0.035
        pgm_function59[(2, 13, 0)] = 0.015
        pgm_function59[(2, 13, 1)] = 0.015
        pgm_function59[(2, 13, 2)] = 0.015
        pgm_function59[(2, 13, 3)] = 0.035
        pgm_function59[(2, 14, 0)] = 0.015
        pgm_function59[(2, 14, 1)] = 0.015
        pgm_function59[(2, 14, 2)] = 0.015
        pgm_function59[(2, 14, 3)] = 0.035
        pgm_function59[(2, 15, 0)] = 0.015
        pgm_function59[(2, 15, 1)] = 0.015
        pgm_function59[(2, 15, 2)] = 0.015
        pgm_function59[(2, 15, 3)] = 0.035
        pgm_function59[(2, 16, 0)] = 0.79
        pgm_function59[(2, 16, 1)] = 0.79
        pgm_function59[(2, 16, 2)] = 0.79
        pgm_function59[(2, 16, 3)] = 0.7
        pgm_function59[(2, 17, 0)] = 0.015
        pgm_function59[(2, 17, 1)] = 0.015
        pgm_function59[(2, 17, 2)] = 0.015
        pgm_function59[(2, 17, 3)] = 0.035
        pgm_function59[(2, 18, 0)] = 0.79
        pgm_function59[(2, 18, 1)] = 0.79
        pgm_function59[(2, 18, 2)] = 0.79
        pgm_function59[(2, 18, 3)] = 0.7
        pgm_function59[(2, 19, 0)] = 0.015
        pgm_function59[(2, 19, 1)] = 0.015
        pgm_function59[(2, 19, 2)] = 0.015
        pgm_function59[(2, 19, 3)] = 0.035
        pgm_function59[(2, 20, 0)] = 0.79
        pgm_function59[(2, 20, 1)] = 0.79
        pgm_function59[(2, 20, 2)] = 0.79
        pgm_function59[(2, 20, 3)] = 0.7
        pgm_function59[(2, 21, 0)] = 0.015
        pgm_function59[(2, 21, 1)] = 0.015
        pgm_function59[(2, 21, 2)] = 0.015
        pgm_function59[(2, 21, 3)] = 0.035
        pgm_function59[(2, 22, 0)] = 0.015
        pgm_function59[(2, 22, 1)] = 0.015
        pgm_function59[(2, 22, 2)] = 0.015
        pgm_function59[(2, 22, 3)] = 0.035
        pgm_function59[(2, 23, 0)] = 0.15
        pgm_function59[(2, 23, 1)] = 0.15
        pgm_function59[(2, 23, 2)] = 0.15
        pgm_function59[(2, 23, 3)] = 0.18
        pgm_function59[(2, 24, 0)] = 0.015
        pgm_function59[(2, 24, 1)] = 0.015
        pgm_function59[(2, 24, 2)] = 0.015
        pgm_function59[(2, 24, 3)] = 0.035
        pgm_function59[(2, 25, 0)] = 0.015
        pgm_function59[(2, 25, 1)] = 0.015
        pgm_function59[(2, 25, 2)] = 0.015
        pgm_function59[(2, 25, 3)] = 0.035
        pgm_function59[(2, 26, 0)] = 0.015
        pgm_function59[(2, 26, 1)] = 0.015
        pgm_function59[(2, 26, 2)] = 0.015
        pgm_function59[(2, 26, 3)] = 0.035
        pgm_function59[(2, 27, 0)] = 0.09
        pgm_function59[(2, 27, 1)] = 0.09
        pgm_function59[(2, 27, 2)] = 0.09
        pgm_function59[(2, 27, 3)] = 0.12
        pgm_function59[(2, 28, 0)] = 0.015
        pgm_function59[(2, 28, 1)] = 0.015
        pgm_function59[(2, 28, 2)] = 0.015
        pgm_function59[(2, 28, 3)] = 0.035
        pgm_function59[(2, 29, 0)] = 0.015
        pgm_function59[(2, 29, 1)] = 0.015
        pgm_function59[(2, 29, 2)] = 0.015
        pgm_function59[(2, 29, 3)] = 0.035
        pgm_function59[(2, 30, 0)] = 0.09
        pgm_function59[(2, 30, 1)] = 0.09
        pgm_function59[(2, 30, 2)] = 0.09
        pgm_function59[(2, 30, 3)] = 0.12
        pgm_function59[(2, 31, 0)] = 0.015
        pgm_function59[(2, 31, 1)] = 0.015
        pgm_function59[(2, 31, 2)] = 0.015
        pgm_function59[(2, 31, 3)] = 0.035
        pgm_function59[(2, 32, 0)] = 0.015
        pgm_function59[(2, 32, 1)] = 0.015
        pgm_function59[(2, 32, 2)] = 0.015
        pgm_function59[(2, 32, 3)] = 0.035
        pgm_function59[(2, 33, 0)] = 0.015
        pgm_function59[(2, 33, 1)] = 0.015
        pgm_function59[(2, 33, 2)] = 0.015
        pgm_function59[(2, 33, 3)] = 0.035
        pgm_function59[(2, 34, 0)] = 0.015
        pgm_function59[(2, 34, 1)] = 0.015
        pgm_function59[(2, 34, 2)] = 0.015
        pgm_function59[(2, 34, 3)] = 0.035
        pgm_function59[(2, 35, 0)] = 0.015
        pgm_function59[(2, 35, 1)] = 0.015
        pgm_function59[(2, 35, 2)] = 0.015
        pgm_function59[(2, 35, 3)] = 0.035
        pgm_function59[(2, 36, 0)] = 0.015
        pgm_function59[(2, 36, 1)] = 0.015
        pgm_function59[(2, 36, 2)] = 0.015
        pgm_function59[(2, 36, 3)] = 0.035
        pgm_function59[(2, 37, 0)] = 0.015
        pgm_function59[(2, 37, 1)] = 0.015
        pgm_function59[(2, 37, 2)] = 0.015
        pgm_function59[(2, 37, 3)] = 0.035
        pgm_function59[(2, 38, 0)] = 0.015
        pgm_function59[(2, 38, 1)] = 0.015
        pgm_function59[(2, 38, 2)] = 0.015
        pgm_function59[(2, 38, 3)] = 0.035
        pgm_function59[(2, 39, 0)] = 0.65
        pgm_function59[(2, 39, 1)] = 0.65
        pgm_function59[(2, 39, 2)] = 0.65
        pgm_function59[(2, 39, 3)] = 0.65
        pgm_function59[(2, 40, 0)] = 0.015
        pgm_function59[(2, 40, 1)] = 0.015
        pgm_function59[(2, 40, 2)] = 0.015
        pgm_function59[(2, 40, 3)] = 0.035
        pgm_function59[(2, 41, 0)] = 0.015
        pgm_function59[(2, 41, 1)] = 0.015
        pgm_function59[(2, 41, 2)] = 0.015
        pgm_function59[(2, 41, 3)] = 0.035
        pgm_function59[(2, 42, 0)] = 0.15
        pgm_function59[(2, 42, 1)] = 0.15
        pgm_function59[(2, 42, 2)] = 0.15
        pgm_function59[(2, 42, 3)] = 0.17
        pgm_function59[(2, 43, 0)] = 0.015
        pgm_function59[(2, 43, 1)] = 0.015
        pgm_function59[(2, 43, 2)] = 0.015
        pgm_function59[(2, 43, 3)] = 0.035
        pgm_function59[(2, 44, 0)] = 0.1
        pgm_function59[(2, 44, 1)] = 0.1
        pgm_function59[(2, 44, 2)] = 0.1
        pgm_function59[(2, 44, 3)] = 0.07
        pgm_function59[(2, 45, 0)] = 0.15
        pgm_function59[(2, 45, 1)] = 0.15
        pgm_function59[(2, 45, 2)] = 0.15
        pgm_function59[(2, 45, 3)] = 0.17
        pgm_function59[(2, 46, 0)] = 0.79
        pgm_function59[(2, 46, 1)] = 0.79
        pgm_function59[(2, 46, 2)] = 0.79
        pgm_function59[(2, 46, 3)] = 0.7
        pgm_function59[(2, 47, 0)] = 0.015
        pgm_function59[(2, 47, 1)] = 0.015
        pgm_function59[(2, 47, 2)] = 0.015
        pgm_function59[(2, 47, 3)] = 0.035
        pgm_function59[(2, 48, 0)] = 0.015
        pgm_function59[(2, 48, 1)] = 0.015
        pgm_function59[(2, 48, 2)] = 0.015
        pgm_function59[(2, 48, 3)] = 0.035
        pgm_function59[(2, 49, 0)] = 0.015
        pgm_function59[(2, 49, 1)] = 0.015
        pgm_function59[(2, 49, 2)] = 0.015
        pgm_function59[(2, 49, 3)] = 0.035
        pgm_function59[(2, 50, 0)] = 0.015
        pgm_function59[(2, 50, 1)] = 0.015
        pgm_function59[(2, 50, 2)] = 0.015
        pgm_function59[(2, 50, 3)] = 0.035
        pgm_function59[(2, 51, 0)] = 0.015
        pgm_function59[(2, 51, 1)] = 0.015
        pgm_function59[(2, 51, 2)] = 0.015
        pgm_function59[(2, 51, 3)] = 0.035
        pgm_function59[(2, 52, 0)] = 0.65
        pgm_function59[(2, 52, 1)] = 0.65
        pgm_function59[(2, 52, 2)] = 0.65
        pgm_function59[(2, 52, 3)] = 0.56
        pgm_function59[(2, 53, 0)] = 0.04
        pgm_function59[(2, 53, 1)] = 0.04
        pgm_function59[(2, 53, 2)] = 0.04
        pgm_function59[(2, 53, 3)] = 0.07
        pgm_function59[(2, 54, 0)] = 0.015
        pgm_function59[(2, 54, 1)] = 0.015
        pgm_function59[(2, 54, 2)] = 0.015
        pgm_function59[(2, 54, 3)] = 0.035
        pgm_function59[(2, 55, 0)] = 0.015
        pgm_function59[(2, 55, 1)] = 0.015
        pgm_function59[(2, 55, 2)] = 0.015
        pgm_function59[(2, 55, 3)] = 0.035
        pgm_function59[(2, 56, 0)] = 0.015
        pgm_function59[(2, 56, 1)] = 0.015
        pgm_function59[(2, 56, 2)] = 0.015
        pgm_function59[(2, 56, 3)] = 0.035
        pgm_function59[(2, 57, 0)] = 0.79
        pgm_function59[(2, 57, 1)] = 0.79
        pgm_function59[(2, 57, 2)] = 0.79
        pgm_function59[(2, 57, 3)] = 0.7
        pgm_function59[(2, 58, 3)] = 0.05
        pgm_function59[(2, 59, 0)] = 0.79
        pgm_function59[(2, 59, 1)] = 0.79
        pgm_function59[(2, 59, 2)] = 0.79
        pgm_function59[(2, 59, 3)] = 0.7
        pgm_function59[(2, 60, 0)] = 0.015
        pgm_function59[(2, 60, 1)] = 0.015
        pgm_function59[(2, 60, 2)] = 0.015
        pgm_function59[(2, 60, 3)] = 0.035
        pgm_function59[(2, 61, 0)] = 0.79
        pgm_function59[(2, 61, 1)] = 0.79
        pgm_function59[(2, 61, 2)] = 0.79
        pgm_function59[(2, 61, 3)] = 0.7
        pgm_function59[(2, 62, 0)] = 0.015
        pgm_function59[(2, 62, 1)] = 0.015
        pgm_function59[(2, 62, 2)] = 0.015
        pgm_function59[(2, 62, 3)] = 0.035
        pgm_function59[(2, 63, 0)] = 0.19
        pgm_function59[(2, 63, 1)] = 0.19
        pgm_function59[(2, 63, 2)] = 0.19
        pgm_function59[(2, 63, 3)] = 0.022
        pgm_function59[(2, 64, 0)] = 0.015
        pgm_function59[(2, 64, 1)] = 0.015
        pgm_function59[(2, 64, 2)] = 0.015
        pgm_function59[(2, 64, 3)] = 0.035
        pgm_function59[(2, 65, 0)] = 0.015
        pgm_function59[(2, 65, 1)] = 0.015
        pgm_function59[(2, 65, 2)] = 0.015
        pgm_function59[(2, 65, 3)] = 0.035
        pgm_function59[(2, 66, 0)] = 0.15
        pgm_function59[(2, 66, 1)] = 0.15
        pgm_function59[(2, 66, 2)] = 0.15
        pgm_function59[(2, 66, 3)] = 0.18
        pgm_function59[(2, 67, 0)] = 0.015
        pgm_function59[(2, 67, 1)] = 0.015
        pgm_function59[(2, 67, 2)] = 0.015
        pgm_function59[(2, 67, 3)] = 0.035
        pgm_function59[(2, 68, 0)] = 0.015
        pgm_function59[(2, 68, 1)] = 0.015
        pgm_function59[(2, 68, 2)] = 0.015
        pgm_function59[(2, 68, 3)] = 0.035
        pgm_function59[(2, 69, 0)] = 0.015
        pgm_function59[(2, 69, 1)] = 0.015
        pgm_function59[(2, 69, 2)] = 0.015
        pgm_function59[(2, 69, 3)] = 0.035
        pgm_function59[(2, 70, 0)] = 0.15
        pgm_function59[(2, 70, 1)] = 0.15
        pgm_function59[(2, 70, 2)] = 0.15
        pgm_function59[(2, 70, 3)] = 0.18
        pgm_function59[(2, 71, 0)] = 0.15
        pgm_function59[(2, 71, 1)] = 0.15
        pgm_function59[(2, 71, 2)] = 0.15
        pgm_function59[(2, 71, 3)] = 0.18
        pgm_function59[(2, 72, 0)] = 0.15
        pgm_function59[(2, 72, 1)] = 0.15
        pgm_function59[(2, 72, 2)] = 0.15
        pgm_function59[(2, 72, 3)] = 0.18
        pgm_function59[(2, 73, 0)] = 0.015
        pgm_function59[(2, 73, 1)] = 0.015
        pgm_function59[(2, 73, 2)] = 0.015
        pgm_function59[(2, 73, 3)] = 0.035
        pgm_function59[(2, 74, 0)] = 0.015
        pgm_function59[(2, 74, 1)] = 0.015
        pgm_function59[(2, 74, 2)] = 0.015
        pgm_function59[(2, 74, 3)] = 0.035
        pgm_function59[(2, 75, 0)] = 0.015
        pgm_function59[(2, 75, 1)] = 0.015
        pgm_function59[(2, 75, 2)] = 0.015
        pgm_function59[(2, 75, 3)] = 0.035
        pgm_function59[(3, 0, 0)] = 0.005
        pgm_function59[(3, 0, 1)] = 0.005
        pgm_function59[(3, 0, 2)] = 0.005
        pgm_function59[(3, 0, 3)] = 0.095
        pgm_function59[(3, 1, 0)] = 0.2
        pgm_function59[(3, 1, 1)] = 0.2
        pgm_function59[(3, 1, 2)] = 0.2
        pgm_function59[(3, 1, 3)] = 0.29
        pgm_function59[(3, 2, 0)] = 0.2
        pgm_function59[(3, 2, 1)] = 0.2
        pgm_function59[(3, 2, 2)] = 0.2
        pgm_function59[(3, 2, 3)] = 0.29
        pgm_function59[(3, 3, 0)] = 0.005
        pgm_function59[(3, 3, 1)] = 0.005
        pgm_function59[(3, 3, 2)] = 0.005
        pgm_function59[(3, 3, 3)] = 0.095
        pgm_function59[(3, 4, 0)] = 0.05
        pgm_function59[(3, 4, 1)] = 0.05
        pgm_function59[(3, 4, 2)] = 0.05
        pgm_function59[(3, 4, 3)] = 0.14
        pgm_function59[(3, 5, 0)] = 0.005
        pgm_function59[(3, 5, 1)] = 0.005
        pgm_function59[(3, 5, 2)] = 0.005
        pgm_function59[(3, 5, 3)] = 0.095
        pgm_function59[(3, 6, 0)] = 0.005
        pgm_function59[(3, 6, 1)] = 0.005
        pgm_function59[(3, 6, 2)] = 0.005
        pgm_function59[(3, 6, 3)] = 0.095
        pgm_function59[(3, 7, 0)] = 0.799
        pgm_function59[(3, 7, 1)] = 0.799
        pgm_function59[(3, 7, 2)] = 0.799
        pgm_function59[(3, 7, 3)] = 0.799
        pgm_function59[(3, 8, 0)] = 0.005
        pgm_function59[(3, 8, 1)] = 0.005
        pgm_function59[(3, 8, 2)] = 0.005
        pgm_function59[(3, 8, 3)] = 0.095
        pgm_function59[(3, 9, 0)] = 0.005
        pgm_function59[(3, 9, 1)] = 0.005
        pgm_function59[(3, 9, 2)] = 0.005
        pgm_function59[(3, 9, 3)] = 0.095
        pgm_function59[(3, 10, 0)] = 0.01
        pgm_function59[(3, 10, 1)] = 0.01
        pgm_function59[(3, 10, 2)] = 0.01
        pgm_function59[(3, 10, 3)] = 0.1
        pgm_function59[(3, 11, 0)] = 0.005
        pgm_function59[(3, 11, 1)] = 0.005
        pgm_function59[(3, 11, 2)] = 0.005
        pgm_function59[(3, 11, 3)] = 0.095
        pgm_function59[(3, 12, 0)] = 0.005
        pgm_function59[(3, 12, 1)] = 0.005
        pgm_function59[(3, 12, 2)] = 0.005
        pgm_function59[(3, 12, 3)] = 0.095
        pgm_function59[(3, 13, 0)] = 0.005
        pgm_function59[(3, 13, 1)] = 0.005
        pgm_function59[(3, 13, 2)] = 0.005
        pgm_function59[(3, 13, 3)] = 0.095
        pgm_function59[(3, 14, 0)] = 0.005
        pgm_function59[(3, 14, 1)] = 0.005
        pgm_function59[(3, 14, 2)] = 0.005
        pgm_function59[(3, 14, 3)] = 0.095
        pgm_function59[(3, 15, 0)] = 0.005
        pgm_function59[(3, 15, 1)] = 0.005
        pgm_function59[(3, 15, 2)] = 0.005
        pgm_function59[(3, 15, 3)] = 0.095
        pgm_function59[(3, 16, 0)] = 0.2
        pgm_function59[(3, 16, 1)] = 0.2
        pgm_function59[(3, 16, 2)] = 0.2
        pgm_function59[(3, 16, 3)] = 0.29
        pgm_function59[(3, 17, 0)] = 0.005
        pgm_function59[(3, 17, 1)] = 0.005
        pgm_function59[(3, 17, 2)] = 0.005
        pgm_function59[(3, 17, 3)] = 0.095
        pgm_function59[(3, 18, 0)] = 0.2
        pgm_function59[(3, 18, 1)] = 0.2
        pgm_function59[(3, 18, 2)] = 0.2
        pgm_function59[(3, 18, 3)] = 0.29
        pgm_function59[(3, 19, 0)] = 0.005
        pgm_function59[(3, 19, 1)] = 0.005
        pgm_function59[(3, 19, 2)] = 0.005
        pgm_function59[(3, 19, 3)] = 0.095
        pgm_function59[(3, 20, 0)] = 0.2
        pgm_function59[(3, 20, 1)] = 0.2
        pgm_function59[(3, 20, 2)] = 0.2
        pgm_function59[(3, 20, 3)] = 0.29
        pgm_function59[(3, 21, 0)] = 0.005
        pgm_function59[(3, 21, 1)] = 0.005
        pgm_function59[(3, 21, 2)] = 0.005
        pgm_function59[(3, 21, 3)] = 0.095
        pgm_function59[(3, 22, 0)] = 0.005
        pgm_function59[(3, 22, 1)] = 0.005
        pgm_function59[(3, 22, 2)] = 0.005
        pgm_function59[(3, 22, 3)] = 0.095
        pgm_function59[(3, 23, 0)] = 0.01
        pgm_function59[(3, 23, 1)] = 0.01
        pgm_function59[(3, 23, 2)] = 0.01
        pgm_function59[(3, 23, 3)] = 0.1
        pgm_function59[(3, 24, 0)] = 0.005
        pgm_function59[(3, 24, 1)] = 0.005
        pgm_function59[(3, 24, 2)] = 0.005
        pgm_function59[(3, 24, 3)] = 0.095
        pgm_function59[(3, 25, 0)] = 0.005
        pgm_function59[(3, 25, 1)] = 0.005
        pgm_function59[(3, 25, 2)] = 0.005
        pgm_function59[(3, 25, 3)] = 0.095
        pgm_function59[(3, 26, 0)] = 0.005
        pgm_function59[(3, 26, 1)] = 0.005
        pgm_function59[(3, 26, 2)] = 0.005
        pgm_function59[(3, 26, 3)] = 0.095
        pgm_function59[(3, 27, 0)] = 0.01
        pgm_function59[(3, 27, 1)] = 0.01
        pgm_function59[(3, 27, 2)] = 0.01
        pgm_function59[(3, 27, 3)] = 0.1
        pgm_function59[(3, 28, 0)] = 0.005
        pgm_function59[(3, 28, 1)] = 0.005
        pgm_function59[(3, 28, 2)] = 0.005
        pgm_function59[(3, 28, 3)] = 0.095
        pgm_function59[(3, 29, 0)] = 0.005
        pgm_function59[(3, 29, 1)] = 0.005
        pgm_function59[(3, 29, 2)] = 0.005
        pgm_function59[(3, 29, 3)] = 0.095
        pgm_function59[(3, 30, 0)] = 0.01
        pgm_function59[(3, 30, 1)] = 0.01
        pgm_function59[(3, 30, 2)] = 0.01
        pgm_function59[(3, 30, 3)] = 0.1
        pgm_function59[(3, 31, 0)] = 0.005
        pgm_function59[(3, 31, 1)] = 0.005
        pgm_function59[(3, 31, 2)] = 0.005
        pgm_function59[(3, 31, 3)] = 0.095
        pgm_function59[(3, 32, 0)] = 0.005
        pgm_function59[(3, 32, 1)] = 0.005
        pgm_function59[(3, 32, 2)] = 0.005
        pgm_function59[(3, 32, 3)] = 0.095
        pgm_function59[(3, 33, 0)] = 0.005
        pgm_function59[(3, 33, 1)] = 0.005
        pgm_function59[(3, 33, 2)] = 0.005
        pgm_function59[(3, 33, 3)] = 0.095
        pgm_function59[(3, 34, 0)] = 0.005
        pgm_function59[(3, 34, 1)] = 0.005
        pgm_function59[(3, 34, 2)] = 0.005
        pgm_function59[(3, 34, 3)] = 0.095
        pgm_function59[(3, 35, 0)] = 0.005
        pgm_function59[(3, 35, 1)] = 0.005
        pgm_function59[(3, 35, 2)] = 0.005
        pgm_function59[(3, 35, 3)] = 0.095
        pgm_function59[(3, 36, 0)] = 0.005
        pgm_function59[(3, 36, 1)] = 0.005
        pgm_function59[(3, 36, 2)] = 0.005
        pgm_function59[(3, 36, 3)] = 0.095
        pgm_function59[(3, 37, 0)] = 0.005
        pgm_function59[(3, 37, 1)] = 0.005
        pgm_function59[(3, 37, 2)] = 0.005
        pgm_function59[(3, 37, 3)] = 0.095
        pgm_function59[(3, 38, 0)] = 0.005
        pgm_function59[(3, 38, 1)] = 0.005
        pgm_function59[(3, 38, 2)] = 0.005
        pgm_function59[(3, 38, 3)] = 0.095
        pgm_function59[(3, 39, 0)] = 0.2
        pgm_function59[(3, 39, 1)] = 0.2
        pgm_function59[(3, 39, 2)] = 0.2
        pgm_function59[(3, 39, 3)] = 0.2
        pgm_function59[(3, 40, 0)] = 0.005
        pgm_function59[(3, 40, 1)] = 0.005
        pgm_function59[(3, 40, 2)] = 0.005
        pgm_function59[(3, 40, 3)] = 0.095
        pgm_function59[(3, 41, 0)] = 0.005
        pgm_function59[(3, 41, 1)] = 0.005
        pgm_function59[(3, 41, 2)] = 0.005
        pgm_function59[(3, 41, 3)] = 0.095
        pgm_function59[(3, 42, 0)] = 0.02
        pgm_function59[(3, 42, 1)] = 0.02
        pgm_function59[(3, 42, 2)] = 0.02
        pgm_function59[(3, 42, 3)] = 0.1
        pgm_function59[(3, 43, 0)] = 0.005
        pgm_function59[(3, 43, 1)] = 0.005
        pgm_function59[(3, 43, 2)] = 0.005
        pgm_function59[(3, 43, 3)] = 0.095
        pgm_function59[(3, 44, 0)] = 0.05
        pgm_function59[(3, 44, 1)] = 0.05
        pgm_function59[(3, 44, 2)] = 0.05
        pgm_function59[(3, 44, 3)] = 0.1
        pgm_function59[(3, 45, 0)] = 0.02
        pgm_function59[(3, 45, 1)] = 0.02
        pgm_function59[(3, 45, 2)] = 0.02
        pgm_function59[(3, 45, 3)] = 0.1
        pgm_function59[(3, 46, 0)] = 0.2
        pgm_function59[(3, 46, 1)] = 0.2
        pgm_function59[(3, 46, 2)] = 0.2
        pgm_function59[(3, 46, 3)] = 0.29
        pgm_function59[(3, 47, 0)] = 0.005
        pgm_function59[(3, 47, 1)] = 0.005
        pgm_function59[(3, 47, 2)] = 0.005
        pgm_function59[(3, 47, 3)] = 0.095
        pgm_function59[(3, 48, 0)] = 0.005
        pgm_function59[(3, 48, 1)] = 0.005
        pgm_function59[(3, 48, 2)] = 0.005
        pgm_function59[(3, 48, 3)] = 0.095
        pgm_function59[(3, 49, 0)] = 0.005
        pgm_function59[(3, 49, 1)] = 0.005
        pgm_function59[(3, 49, 2)] = 0.005
        pgm_function59[(3, 49, 3)] = 0.095
        pgm_function59[(3, 50, 0)] = 0.005
        pgm_function59[(3, 50, 1)] = 0.005
        pgm_function59[(3, 50, 2)] = 0.005
        pgm_function59[(3, 50, 3)] = 0.095
        pgm_function59[(3, 51, 0)] = 0.005
        pgm_function59[(3, 51, 1)] = 0.005
        pgm_function59[(3, 51, 2)] = 0.005
        pgm_function59[(3, 51, 3)] = 0.095
        pgm_function59[(3, 52, 0)] = 0.25
        pgm_function59[(3, 52, 1)] = 0.25
        pgm_function59[(3, 52, 2)] = 0.25
        pgm_function59[(3, 52, 3)] = 0.34
        pgm_function59[(3, 53, 0)] = 0.01
        pgm_function59[(3, 53, 1)] = 0.01
        pgm_function59[(3, 53, 2)] = 0.01
        pgm_function59[(3, 53, 3)] = 0.1
        pgm_function59[(3, 54, 0)] = 0.005
        pgm_function59[(3, 54, 1)] = 0.005
        pgm_function59[(3, 54, 2)] = 0.005
        pgm_function59[(3, 54, 3)] = 0.095
        pgm_function59[(3, 55, 0)] = 0.005
        pgm_function59[(3, 55, 1)] = 0.005
        pgm_function59[(3, 55, 2)] = 0.005
        pgm_function59[(3, 55, 3)] = 0.095
        pgm_function59[(3, 56, 0)] = 0.005
        pgm_function59[(3, 56, 1)] = 0.005
        pgm_function59[(3, 56, 2)] = 0.005
        pgm_function59[(3, 56, 3)] = 0.095
        pgm_function59[(3, 57, 0)] = 0.2
        pgm_function59[(3, 57, 1)] = 0.2
        pgm_function59[(3, 57, 2)] = 0.2
        pgm_function59[(3, 57, 3)] = 0.29
        pgm_function59[(3, 58, 0)] = 0.1
        pgm_function59[(3, 58, 1)] = 0.1
        pgm_function59[(3, 58, 2)] = 0.1
        pgm_function59[(3, 58, 3)] = 0.05
        pgm_function59[(3, 59, 0)] = 0.2
        pgm_function59[(3, 59, 1)] = 0.2
        pgm_function59[(3, 59, 2)] = 0.2
        pgm_function59[(3, 59, 3)] = 0.29
        pgm_function59[(3, 60, 0)] = 0.005
        pgm_function59[(3, 60, 1)] = 0.005
        pgm_function59[(3, 60, 2)] = 0.005
        pgm_function59[(3, 60, 3)] = 0.095
        pgm_function59[(3, 61, 0)] = 0.2
        pgm_function59[(3, 61, 1)] = 0.2
        pgm_function59[(3, 61, 2)] = 0.2
        pgm_function59[(3, 61, 3)] = 0.29
        pgm_function59[(3, 62, 0)] = 0.005
        pgm_function59[(3, 62, 1)] = 0.005
        pgm_function59[(3, 62, 2)] = 0.005
        pgm_function59[(3, 62, 3)] = 0.095
        pgm_function59[(3, 63, 0)] = 0.01
        pgm_function59[(3, 63, 1)] = 0.01
        pgm_function59[(3, 63, 2)] = 0.01
        pgm_function59[(3, 63, 3)] = 0.05
        pgm_function59[(3, 64, 0)] = 0.005
        pgm_function59[(3, 64, 1)] = 0.005
        pgm_function59[(3, 64, 2)] = 0.005
        pgm_function59[(3, 64, 3)] = 0.095
        pgm_function59[(3, 65, 0)] = 0.005
        pgm_function59[(3, 65, 1)] = 0.005
        pgm_function59[(3, 65, 2)] = 0.005
        pgm_function59[(3, 65, 3)] = 0.095
        pgm_function59[(3, 66, 0)] = 0.01
        pgm_function59[(3, 66, 1)] = 0.01
        pgm_function59[(3, 66, 2)] = 0.01
        pgm_function59[(3, 66, 3)] = 0.1
        pgm_function59[(3, 67, 0)] = 0.005
        pgm_function59[(3, 67, 1)] = 0.005
        pgm_function59[(3, 67, 2)] = 0.005
        pgm_function59[(3, 67, 3)] = 0.095
        pgm_function59[(3, 68, 0)] = 0.005
        pgm_function59[(3, 68, 1)] = 0.005
        pgm_function59[(3, 68, 2)] = 0.005
        pgm_function59[(3, 68, 3)] = 0.095
        pgm_function59[(3, 69, 0)] = 0.005
        pgm_function59[(3, 69, 1)] = 0.005
        pgm_function59[(3, 69, 2)] = 0.005
        pgm_function59[(3, 69, 3)] = 0.095
        pgm_function59[(3, 70, 0)] = 0.01
        pgm_function59[(3, 70, 1)] = 0.01
        pgm_function59[(3, 70, 2)] = 0.01
        pgm_function59[(3, 70, 3)] = 0.1
        pgm_function59[(3, 71, 0)] = 0.01
        pgm_function59[(3, 71, 1)] = 0.01
        pgm_function59[(3, 71, 2)] = 0.01
        pgm_function59[(3, 71, 3)] = 0.1
        pgm_function59[(3, 72, 0)] = 0.01
        pgm_function59[(3, 72, 1)] = 0.01
        pgm_function59[(3, 72, 2)] = 0.01
        pgm_function59[(3, 72, 3)] = 0.1
        pgm_function59[(3, 73, 0)] = 0.005
        pgm_function59[(3, 73, 1)] = 0.005
        pgm_function59[(3, 73, 2)] = 0.005
        pgm_function59[(3, 73, 3)] = 0.095
        pgm_function59[(3, 74, 0)] = 0.005
        pgm_function59[(3, 74, 1)] = 0.005
        pgm_function59[(3, 74, 2)] = 0.005
        pgm_function59[(3, 74, 3)] = 0.095
        pgm_function59[(3, 75, 0)] = 0.005
        pgm_function59[(3, 75, 1)] = 0.005
        pgm_function59[(3, 75, 2)] = 0.005
        pgm_function59[(3, 75, 3)] = 0.095
        pgm_function59[(4, 7, 0)] = 0.001
        pgm_function59[(4, 7, 1)] = 0.001
        pgm_function59[(4, 7, 2)] = 0.001
        pgm_function59[(4, 7, 3)] = 0.001
        pgm_function59[(4, 39, 0)] = 0.001
        pgm_function59[(4, 39, 1)] = 0.001
        pgm_function59[(4, 39, 2)] = 0.001
        pgm_function59[(4, 39, 3)] = 0.001
        pgm_function59[(4, 58, 0)] = 0.55
        pgm_function59[(4, 58, 1)] = 0.55
        pgm_function59[(4, 58, 2)] = 0.55
        pgm_function59[(4, 58, 3)] = 0.6
        pgm_function59[(4, 63, 3)] = 0.05
        pgm_function59[(5, 58, 0)] = 0.35
        pgm_function59[(5, 58, 1)] = 0.35
        pgm_function59[(5, 58, 2)] = 0.35
        pgm_function59[(5, 58, 3)] = 0.3

        pgm_function60 = pgm_factor60.set_sparse()
        pgm_function60[(0, 0, 0)] = 1.0
        pgm_function60[(0, 1, 0)] = 1.0
        pgm_function60[(0, 2, 0)] = 1.0
        pgm_function60[(0, 3, 0)] = 1.0
        pgm_function60[(0, 4, 0)] = 1.0
        pgm_function60[(0, 5, 0)] = 1.0
        pgm_function60[(0, 6, 0)] = 1.0
        pgm_function60[(0, 7, 0)] = 1.0
        pgm_function60[(0, 8, 0)] = 1.0
        pgm_function60[(0, 9, 0)] = 1.0
        pgm_function60[(0, 10, 0)] = 1.0
        pgm_function60[(0, 11, 0)] = 1.0
        pgm_function60[(0, 12, 0)] = 1.0
        pgm_function60[(0, 13, 0)] = 1.0
        pgm_function60[(0, 14, 0)] = 1.0
        pgm_function60[(0, 15, 0)] = 1.0
        pgm_function60[(0, 16, 0)] = 1.0
        pgm_function60[(0, 17, 0)] = 1.0
        pgm_function60[(0, 18, 0)] = 1.0
        pgm_function60[(0, 19, 0)] = 1.0
        pgm_function60[(0, 20, 0)] = 1.0
        pgm_function60[(0, 21, 0)] = 1.0
        pgm_function60[(0, 22, 0)] = 1.0
        pgm_function60[(0, 23, 0)] = 1.0
        pgm_function60[(0, 24, 0)] = 1.0
        pgm_function60[(0, 25, 0)] = 1.0
        pgm_function60[(0, 26, 0)] = 1.0
        pgm_function60[(0, 27, 0)] = 1.0
        pgm_function60[(0, 28, 0)] = 1.0
        pgm_function60[(0, 29, 0)] = 1.0
        pgm_function60[(0, 30, 0)] = 1.0
        pgm_function60[(0, 31, 0)] = 1.0
        pgm_function60[(0, 32, 0)] = 1.0
        pgm_function60[(0, 33, 0)] = 1.0
        pgm_function60[(0, 34, 0)] = 1.0
        pgm_function60[(0, 35, 0)] = 1.0
        pgm_function60[(0, 36, 0)] = 1.0
        pgm_function60[(0, 37, 0)] = 1.0
        pgm_function60[(0, 38, 0)] = 1.0
        pgm_function60[(0, 39, 0)] = 1.0
        pgm_function60[(0, 40, 0)] = 1.0
        pgm_function60[(0, 41, 0)] = 1.0
        pgm_function60[(0, 42, 0)] = 1.0
        pgm_function60[(0, 43, 0)] = 1.0
        pgm_function60[(0, 44, 0)] = 1.0
        pgm_function60[(0, 45, 0)] = 1.0
        pgm_function60[(0, 46, 0)] = 1.0
        pgm_function60[(0, 47, 0)] = 1.0
        pgm_function60[(0, 48, 0)] = 1.0
        pgm_function60[(0, 49, 0)] = 1.0
        pgm_function60[(0, 50, 0)] = 1.0
        pgm_function60[(0, 51, 0)] = 1.0
        pgm_function60[(0, 52, 0)] = 1.0
        pgm_function60[(0, 53, 0)] = 1.0
        pgm_function60[(0, 54, 0)] = 1.0
        pgm_function60[(0, 55, 0)] = 1.0
        pgm_function60[(0, 56, 0)] = 1.0
        pgm_function60[(0, 57, 0)] = 1.0
        pgm_function60[(0, 58, 0)] = 1.0
        pgm_function60[(0, 58, 1)] = 0.1666667
        pgm_function60[(0, 59, 0)] = 1.0
        pgm_function60[(0, 60, 0)] = 1.0
        pgm_function60[(0, 61, 0)] = 1.0
        pgm_function60[(0, 62, 0)] = 1.0
        pgm_function60[(0, 63, 0)] = 1.0
        pgm_function60[(0, 64, 0)] = 1.0
        pgm_function60[(0, 65, 0)] = 1.0
        pgm_function60[(0, 66, 0)] = 1.0
        pgm_function60[(0, 67, 0)] = 1.0
        pgm_function60[(0, 68, 0)] = 1.0
        pgm_function60[(0, 69, 0)] = 1.0
        pgm_function60[(0, 70, 0)] = 1.0
        pgm_function60[(0, 71, 0)] = 1.0
        pgm_function60[(0, 72, 0)] = 1.0
        pgm_function60[(0, 73, 0)] = 1.0
        pgm_function60[(0, 74, 0)] = 1.0
        pgm_function60[(0, 75, 0)] = 1.0
        pgm_function60[(1, 0, 1)] = 0.929
        pgm_function60[(1, 0, 2)] = 0.929
        pgm_function60[(1, 0, 3)] = 0.929
        pgm_function60[(1, 0, 4)] = 0.929
        pgm_function60[(1, 0, 5)] = 0.929
        pgm_function60[(1, 1, 1)] = 0.948
        pgm_function60[(1, 1, 2)] = 0.948
        pgm_function60[(1, 1, 3)] = 0.948
        pgm_function60[(1, 1, 4)] = 0.948
        pgm_function60[(1, 1, 5)] = 0.948
        pgm_function60[(1, 2, 1)] = 0.948
        pgm_function60[(1, 2, 2)] = 0.948
        pgm_function60[(1, 2, 3)] = 0.948
        pgm_function60[(1, 2, 4)] = 0.948
        pgm_function60[(1, 2, 5)] = 0.948
        pgm_function60[(1, 3, 1)] = 0.978
        pgm_function60[(1, 3, 2)] = 0.978
        pgm_function60[(1, 3, 3)] = 0.978
        pgm_function60[(1, 3, 4)] = 0.978
        pgm_function60[(1, 3, 5)] = 0.978
        pgm_function60[(1, 4, 1)] = 0.929
        pgm_function60[(1, 4, 2)] = 0.929
        pgm_function60[(1, 4, 3)] = 0.929
        pgm_function60[(1, 4, 4)] = 0.929
        pgm_function60[(1, 4, 5)] = 0.929
        pgm_function60[(1, 5, 1)] = 0.978
        pgm_function60[(1, 5, 2)] = 0.978
        pgm_function60[(1, 5, 3)] = 0.978
        pgm_function60[(1, 5, 4)] = 0.978
        pgm_function60[(1, 5, 5)] = 0.978
        pgm_function60[(1, 6, 1)] = 0.978
        pgm_function60[(1, 6, 2)] = 0.978
        pgm_function60[(1, 6, 3)] = 0.978
        pgm_function60[(1, 6, 4)] = 0.978
        pgm_function60[(1, 6, 5)] = 0.978
        pgm_function60[(1, 7, 1)] = 0.929
        pgm_function60[(1, 7, 2)] = 0.929
        pgm_function60[(1, 7, 3)] = 0.929
        pgm_function60[(1, 7, 4)] = 0.929
        pgm_function60[(1, 7, 5)] = 0.929
        pgm_function60[(1, 8, 1)] = 0.978
        pgm_function60[(1, 8, 2)] = 0.978
        pgm_function60[(1, 8, 3)] = 0.978
        pgm_function60[(1, 8, 4)] = 0.978
        pgm_function60[(1, 8, 5)] = 0.978
        pgm_function60[(1, 9, 1)] = 0.978
        pgm_function60[(1, 9, 2)] = 0.978
        pgm_function60[(1, 9, 3)] = 0.978
        pgm_function60[(1, 9, 4)] = 0.978
        pgm_function60[(1, 9, 5)] = 0.978
        pgm_function60[(1, 10, 1)] = 0.929
        pgm_function60[(1, 10, 2)] = 0.929
        pgm_function60[(1, 10, 3)] = 0.929
        pgm_function60[(1, 10, 4)] = 0.929
        pgm_function60[(1, 10, 5)] = 0.929
        pgm_function60[(1, 11, 1)] = 0.978
        pgm_function60[(1, 11, 2)] = 0.978
        pgm_function60[(1, 11, 3)] = 0.978
        pgm_function60[(1, 11, 4)] = 0.978
        pgm_function60[(1, 11, 5)] = 0.978
        pgm_function60[(1, 12, 1)] = 0.978
        pgm_function60[(1, 12, 2)] = 0.978
        pgm_function60[(1, 12, 3)] = 0.978
        pgm_function60[(1, 12, 4)] = 0.978
        pgm_function60[(1, 12, 5)] = 0.978
        pgm_function60[(1, 13, 1)] = 0.978
        pgm_function60[(1, 13, 2)] = 0.978
        pgm_function60[(1, 13, 3)] = 0.978
        pgm_function60[(1, 13, 4)] = 0.978
        pgm_function60[(1, 13, 5)] = 0.978
        pgm_function60[(1, 14, 1)] = 0.978
        pgm_function60[(1, 14, 2)] = 0.978
        pgm_function60[(1, 14, 3)] = 0.978
        pgm_function60[(1, 14, 4)] = 0.978
        pgm_function60[(1, 14, 5)] = 0.978
        pgm_function60[(1, 15, 1)] = 0.978
        pgm_function60[(1, 15, 2)] = 0.978
        pgm_function60[(1, 15, 3)] = 0.978
        pgm_function60[(1, 15, 4)] = 0.978
        pgm_function60[(1, 15, 5)] = 0.978
        pgm_function60[(1, 16, 1)] = 0.929
        pgm_function60[(1, 16, 2)] = 0.929
        pgm_function60[(1, 16, 3)] = 0.929
        pgm_function60[(1, 16, 4)] = 0.929
        pgm_function60[(1, 16, 5)] = 0.929
        pgm_function60[(1, 17, 1)] = 0.978
        pgm_function60[(1, 17, 2)] = 0.978
        pgm_function60[(1, 17, 3)] = 0.978
        pgm_function60[(1, 17, 4)] = 0.978
        pgm_function60[(1, 17, 5)] = 0.978
        pgm_function60[(1, 18, 1)] = 0.929
        pgm_function60[(1, 18, 2)] = 0.929
        pgm_function60[(1, 18, 3)] = 0.929
        pgm_function60[(1, 18, 4)] = 0.929
        pgm_function60[(1, 18, 5)] = 0.929
        pgm_function60[(1, 19, 1)] = 0.978
        pgm_function60[(1, 19, 2)] = 0.978
        pgm_function60[(1, 19, 3)] = 0.978
        pgm_function60[(1, 19, 4)] = 0.978
        pgm_function60[(1, 19, 5)] = 0.978
        pgm_function60[(1, 20, 1)] = 0.929
        pgm_function60[(1, 20, 2)] = 0.929
        pgm_function60[(1, 20, 3)] = 0.929
        pgm_function60[(1, 20, 4)] = 0.929
        pgm_function60[(1, 20, 5)] = 0.929
        pgm_function60[(1, 21, 1)] = 0.978
        pgm_function60[(1, 21, 2)] = 0.978
        pgm_function60[(1, 21, 3)] = 0.978
        pgm_function60[(1, 21, 4)] = 0.978
        pgm_function60[(1, 21, 5)] = 0.978
        pgm_function60[(1, 22, 1)] = 0.978
        pgm_function60[(1, 22, 2)] = 0.978
        pgm_function60[(1, 22, 3)] = 0.978
        pgm_function60[(1, 22, 4)] = 0.978
        pgm_function60[(1, 22, 5)] = 0.978
        pgm_function60[(1, 23, 1)] = 0.929
        pgm_function60[(1, 23, 2)] = 0.929
        pgm_function60[(1, 23, 3)] = 0.929
        pgm_function60[(1, 23, 4)] = 0.929
        pgm_function60[(1, 23, 5)] = 0.929
        pgm_function60[(1, 24, 1)] = 0.978
        pgm_function60[(1, 24, 2)] = 0.978
        pgm_function60[(1, 24, 3)] = 0.978
        pgm_function60[(1, 24, 4)] = 0.978
        pgm_function60[(1, 24, 5)] = 0.978
        pgm_function60[(1, 25, 1)] = 0.978
        pgm_function60[(1, 25, 2)] = 0.978
        pgm_function60[(1, 25, 3)] = 0.978
        pgm_function60[(1, 25, 4)] = 0.978
        pgm_function60[(1, 25, 5)] = 0.978
        pgm_function60[(1, 26, 1)] = 0.978
        pgm_function60[(1, 26, 2)] = 0.978
        pgm_function60[(1, 26, 3)] = 0.978
        pgm_function60[(1, 26, 4)] = 0.978
        pgm_function60[(1, 26, 5)] = 0.978
        pgm_function60[(1, 27, 1)] = 0.929
        pgm_function60[(1, 27, 2)] = 0.929
        pgm_function60[(1, 27, 3)] = 0.929
        pgm_function60[(1, 27, 4)] = 0.929
        pgm_function60[(1, 27, 5)] = 0.929
        pgm_function60[(1, 28, 1)] = 0.978
        pgm_function60[(1, 28, 2)] = 0.978
        pgm_function60[(1, 28, 3)] = 0.978
        pgm_function60[(1, 28, 4)] = 0.978
        pgm_function60[(1, 28, 5)] = 0.978
        pgm_function60[(1, 29, 1)] = 0.978
        pgm_function60[(1, 29, 2)] = 0.978
        pgm_function60[(1, 29, 3)] = 0.978
        pgm_function60[(1, 29, 4)] = 0.978
        pgm_function60[(1, 29, 5)] = 0.978
        pgm_function60[(1, 30, 1)] = 0.929
        pgm_function60[(1, 30, 2)] = 0.929
        pgm_function60[(1, 30, 3)] = 0.929
        pgm_function60[(1, 30, 4)] = 0.929
        pgm_function60[(1, 30, 5)] = 0.929
        pgm_function60[(1, 31, 1)] = 0.978
        pgm_function60[(1, 31, 2)] = 0.978
        pgm_function60[(1, 31, 3)] = 0.978
        pgm_function60[(1, 31, 4)] = 0.978
        pgm_function60[(1, 31, 5)] = 0.978
        pgm_function60[(1, 32, 1)] = 0.978
        pgm_function60[(1, 32, 2)] = 0.978
        pgm_function60[(1, 32, 3)] = 0.978
        pgm_function60[(1, 32, 4)] = 0.978
        pgm_function60[(1, 32, 5)] = 0.978
        pgm_function60[(1, 33, 1)] = 0.978
        pgm_function60[(1, 33, 2)] = 0.978
        pgm_function60[(1, 33, 3)] = 0.978
        pgm_function60[(1, 33, 4)] = 0.978
        pgm_function60[(1, 33, 5)] = 0.978
        pgm_function60[(1, 34, 1)] = 0.978
        pgm_function60[(1, 34, 2)] = 0.978
        pgm_function60[(1, 34, 3)] = 0.978
        pgm_function60[(1, 34, 4)] = 0.978
        pgm_function60[(1, 34, 5)] = 0.978
        pgm_function60[(1, 35, 1)] = 0.978
        pgm_function60[(1, 35, 2)] = 0.978
        pgm_function60[(1, 35, 3)] = 0.978
        pgm_function60[(1, 35, 4)] = 0.978
        pgm_function60[(1, 35, 5)] = 0.978
        pgm_function60[(1, 36, 1)] = 0.978
        pgm_function60[(1, 36, 2)] = 0.978
        pgm_function60[(1, 36, 3)] = 0.978
        pgm_function60[(1, 36, 4)] = 0.978
        pgm_function60[(1, 36, 5)] = 0.978
        pgm_function60[(1, 37, 1)] = 0.978
        pgm_function60[(1, 37, 2)] = 0.978
        pgm_function60[(1, 37, 3)] = 0.978
        pgm_function60[(1, 37, 4)] = 0.978
        pgm_function60[(1, 37, 5)] = 0.978
        pgm_function60[(1, 38, 1)] = 0.978
        pgm_function60[(1, 38, 2)] = 0.978
        pgm_function60[(1, 38, 3)] = 0.978
        pgm_function60[(1, 38, 4)] = 0.978
        pgm_function60[(1, 38, 5)] = 0.978
        pgm_function60[(1, 39, 1)] = 0.928
        pgm_function60[(1, 39, 2)] = 0.928
        pgm_function60[(1, 39, 3)] = 0.928
        pgm_function60[(1, 39, 4)] = 0.928
        pgm_function60[(1, 39, 5)] = 0.928
        pgm_function60[(1, 40, 1)] = 0.978
        pgm_function60[(1, 40, 2)] = 0.978
        pgm_function60[(1, 40, 3)] = 0.978
        pgm_function60[(1, 40, 4)] = 0.978
        pgm_function60[(1, 40, 5)] = 0.978
        pgm_function60[(1, 41, 1)] = 0.978
        pgm_function60[(1, 41, 2)] = 0.978
        pgm_function60[(1, 41, 3)] = 0.978
        pgm_function60[(1, 41, 4)] = 0.978
        pgm_function60[(1, 41, 5)] = 0.978
        pgm_function60[(1, 42, 1)] = 0.978
        pgm_function60[(1, 42, 2)] = 0.978
        pgm_function60[(1, 42, 3)] = 0.978
        pgm_function60[(1, 42, 4)] = 0.978
        pgm_function60[(1, 42, 5)] = 0.978
        pgm_function60[(1, 43, 1)] = 0.978
        pgm_function60[(1, 43, 2)] = 0.978
        pgm_function60[(1, 43, 3)] = 0.978
        pgm_function60[(1, 43, 4)] = 0.978
        pgm_function60[(1, 43, 5)] = 0.978
        pgm_function60[(1, 44, 1)] = 0.92
        pgm_function60[(1, 44, 2)] = 0.92
        pgm_function60[(1, 44, 3)] = 0.92
        pgm_function60[(1, 44, 4)] = 0.92
        pgm_function60[(1, 44, 5)] = 0.92
        pgm_function60[(1, 45, 1)] = 0.929
        pgm_function60[(1, 45, 2)] = 0.929
        pgm_function60[(1, 45, 3)] = 0.929
        pgm_function60[(1, 45, 4)] = 0.929
        pgm_function60[(1, 45, 5)] = 0.929
        pgm_function60[(1, 46, 1)] = 0.948
        pgm_function60[(1, 46, 2)] = 0.948
        pgm_function60[(1, 46, 3)] = 0.948
        pgm_function60[(1, 46, 4)] = 0.948
        pgm_function60[(1, 46, 5)] = 0.948
        pgm_function60[(1, 47, 1)] = 0.978
        pgm_function60[(1, 47, 2)] = 0.978
        pgm_function60[(1, 47, 3)] = 0.978
        pgm_function60[(1, 47, 4)] = 0.978
        pgm_function60[(1, 47, 5)] = 0.978
        pgm_function60[(1, 48, 1)] = 0.978
        pgm_function60[(1, 48, 2)] = 0.978
        pgm_function60[(1, 48, 3)] = 0.978
        pgm_function60[(1, 48, 4)] = 0.978
        pgm_function60[(1, 48, 5)] = 0.978
        pgm_function60[(1, 49, 1)] = 0.978
        pgm_function60[(1, 49, 2)] = 0.978
        pgm_function60[(1, 49, 3)] = 0.978
        pgm_function60[(1, 49, 4)] = 0.978
        pgm_function60[(1, 49, 5)] = 0.978
        pgm_function60[(1, 50, 1)] = 0.978
        pgm_function60[(1, 50, 2)] = 0.978
        pgm_function60[(1, 50, 3)] = 0.978
        pgm_function60[(1, 50, 4)] = 0.978
        pgm_function60[(1, 50, 5)] = 0.978
        pgm_function60[(1, 51, 1)] = 0.978
        pgm_function60[(1, 51, 2)] = 0.978
        pgm_function60[(1, 51, 3)] = 0.978
        pgm_function60[(1, 51, 4)] = 0.978
        pgm_function60[(1, 51, 5)] = 0.978
        pgm_function60[(1, 52, 1)] = 0.02
        pgm_function60[(1, 52, 2)] = 0.02
        pgm_function60[(1, 52, 3)] = 0.02
        pgm_function60[(1, 52, 4)] = 0.02
        pgm_function60[(1, 52, 5)] = 0.02
        pgm_function60[(1, 53, 1)] = 0.978
        pgm_function60[(1, 53, 2)] = 0.978
        pgm_function60[(1, 53, 3)] = 0.978
        pgm_function60[(1, 53, 4)] = 0.978
        pgm_function60[(1, 53, 5)] = 0.978
        pgm_function60[(1, 54, 1)] = 0.978
        pgm_function60[(1, 54, 2)] = 0.978
        pgm_function60[(1, 54, 3)] = 0.978
        pgm_function60[(1, 54, 4)] = 0.978
        pgm_function60[(1, 54, 5)] = 0.978
        pgm_function60[(1, 55, 1)] = 0.978
        pgm_function60[(1, 55, 2)] = 0.978
        pgm_function60[(1, 55, 3)] = 0.978
        pgm_function60[(1, 55, 4)] = 0.978
        pgm_function60[(1, 55, 5)] = 0.978
        pgm_function60[(1, 56, 1)] = 0.978
        pgm_function60[(1, 56, 2)] = 0.978
        pgm_function60[(1, 56, 3)] = 0.978
        pgm_function60[(1, 56, 4)] = 0.978
        pgm_function60[(1, 56, 5)] = 0.978
        pgm_function60[(1, 57, 1)] = 0.929
        pgm_function60[(1, 57, 2)] = 0.929
        pgm_function60[(1, 57, 3)] = 0.929
        pgm_function60[(1, 57, 4)] = 0.929
        pgm_function60[(1, 57, 5)] = 0.929
        pgm_function60[(1, 58, 1)] = 0.1666667
        pgm_function60[(1, 58, 2)] = 0.65
        pgm_function60[(1, 58, 3)] = 0.65
        pgm_function60[(1, 58, 4)] = 0.65
        pgm_function60[(1, 58, 5)] = 0.65
        pgm_function60[(1, 59, 1)] = 0.929
        pgm_function60[(1, 59, 2)] = 0.929
        pgm_function60[(1, 59, 3)] = 0.929
        pgm_function60[(1, 59, 4)] = 0.929
        pgm_function60[(1, 59, 5)] = 0.929
        pgm_function60[(1, 60, 1)] = 0.978
        pgm_function60[(1, 60, 2)] = 0.978
        pgm_function60[(1, 60, 3)] = 0.978
        pgm_function60[(1, 60, 4)] = 0.978
        pgm_function60[(1, 60, 5)] = 0.978
        pgm_function60[(1, 61, 1)] = 0.929
        pgm_function60[(1, 61, 2)] = 0.929
        pgm_function60[(1, 61, 3)] = 0.929
        pgm_function60[(1, 61, 4)] = 0.929
        pgm_function60[(1, 61, 5)] = 0.929
        pgm_function60[(1, 62, 1)] = 0.978
        pgm_function60[(1, 62, 2)] = 0.978
        pgm_function60[(1, 62, 3)] = 0.978
        pgm_function60[(1, 62, 4)] = 0.978
        pgm_function60[(1, 62, 5)] = 0.978
        pgm_function60[(1, 63, 1)] = 0.929
        pgm_function60[(1, 63, 2)] = 0.929
        pgm_function60[(1, 63, 3)] = 0.929
        pgm_function60[(1, 63, 4)] = 0.929
        pgm_function60[(1, 63, 5)] = 0.929
        pgm_function60[(1, 64, 1)] = 0.978
        pgm_function60[(1, 64, 2)] = 0.978
        pgm_function60[(1, 64, 3)] = 0.978
        pgm_function60[(1, 64, 4)] = 0.978
        pgm_function60[(1, 64, 5)] = 0.978
        pgm_function60[(1, 65, 1)] = 0.978
        pgm_function60[(1, 65, 2)] = 0.978
        pgm_function60[(1, 65, 3)] = 0.978
        pgm_function60[(1, 65, 4)] = 0.978
        pgm_function60[(1, 65, 5)] = 0.978
        pgm_function60[(1, 66, 1)] = 0.929
        pgm_function60[(1, 66, 2)] = 0.929
        pgm_function60[(1, 66, 3)] = 0.929
        pgm_function60[(1, 66, 4)] = 0.929
        pgm_function60[(1, 66, 5)] = 0.929
        pgm_function60[(1, 67, 1)] = 0.978
        pgm_function60[(1, 67, 2)] = 0.978
        pgm_function60[(1, 67, 3)] = 0.978
        pgm_function60[(1, 67, 4)] = 0.978
        pgm_function60[(1, 67, 5)] = 0.978
        pgm_function60[(1, 68, 1)] = 0.978
        pgm_function60[(1, 68, 2)] = 0.978
        pgm_function60[(1, 68, 3)] = 0.978
        pgm_function60[(1, 68, 4)] = 0.978
        pgm_function60[(1, 68, 5)] = 0.978
        pgm_function60[(1, 69, 1)] = 0.978
        pgm_function60[(1, 69, 2)] = 0.978
        pgm_function60[(1, 69, 3)] = 0.978
        pgm_function60[(1, 69, 4)] = 0.978
        pgm_function60[(1, 69, 5)] = 0.978
        pgm_function60[(1, 70, 1)] = 0.929
        pgm_function60[(1, 70, 2)] = 0.929
        pgm_function60[(1, 70, 3)] = 0.929
        pgm_function60[(1, 70, 4)] = 0.929
        pgm_function60[(1, 70, 5)] = 0.929
        pgm_function60[(1, 71, 1)] = 0.929
        pgm_function60[(1, 71, 2)] = 0.929
        pgm_function60[(1, 71, 3)] = 0.929
        pgm_function60[(1, 71, 4)] = 0.929
        pgm_function60[(1, 71, 5)] = 0.929
        pgm_function60[(1, 72, 1)] = 0.929
        pgm_function60[(1, 72, 2)] = 0.929
        pgm_function60[(1, 72, 3)] = 0.929
        pgm_function60[(1, 72, 4)] = 0.929
        pgm_function60[(1, 72, 5)] = 0.929
        pgm_function60[(1, 73, 1)] = 0.978
        pgm_function60[(1, 73, 2)] = 0.978
        pgm_function60[(1, 73, 3)] = 0.978
        pgm_function60[(1, 73, 4)] = 0.978
        pgm_function60[(1, 73, 5)] = 0.978
        pgm_function60[(1, 74, 1)] = 0.978
        pgm_function60[(1, 74, 2)] = 0.978
        pgm_function60[(1, 74, 3)] = 0.978
        pgm_function60[(1, 74, 4)] = 0.978
        pgm_function60[(1, 74, 5)] = 0.978
        pgm_function60[(1, 75, 1)] = 0.978
        pgm_function60[(1, 75, 2)] = 0.978
        pgm_function60[(1, 75, 3)] = 0.978
        pgm_function60[(1, 75, 4)] = 0.978
        pgm_function60[(1, 75, 5)] = 0.978
        pgm_function60[(2, 0, 1)] = 0.02
        pgm_function60[(2, 0, 2)] = 0.02
        pgm_function60[(2, 0, 3)] = 0.02
        pgm_function60[(2, 0, 4)] = 0.02
        pgm_function60[(2, 0, 5)] = 0.02
        pgm_function60[(2, 1, 1)] = 0.001
        pgm_function60[(2, 1, 2)] = 0.001
        pgm_function60[(2, 1, 3)] = 0.001
        pgm_function60[(2, 1, 4)] = 0.001
        pgm_function60[(2, 1, 5)] = 0.001
        pgm_function60[(2, 2, 1)] = 0.001
        pgm_function60[(2, 2, 2)] = 0.001
        pgm_function60[(2, 2, 3)] = 0.001
        pgm_function60[(2, 2, 4)] = 0.001
        pgm_function60[(2, 2, 5)] = 0.001
        pgm_function60[(2, 3, 1)] = 0.001
        pgm_function60[(2, 3, 2)] = 0.001
        pgm_function60[(2, 3, 3)] = 0.001
        pgm_function60[(2, 3, 4)] = 0.001
        pgm_function60[(2, 3, 5)] = 0.001
        pgm_function60[(2, 4, 1)] = 0.02
        pgm_function60[(2, 4, 2)] = 0.02
        pgm_function60[(2, 4, 3)] = 0.02
        pgm_function60[(2, 4, 4)] = 0.02
        pgm_function60[(2, 4, 5)] = 0.02
        pgm_function60[(2, 5, 1)] = 0.001
        pgm_function60[(2, 5, 2)] = 0.001
        pgm_function60[(2, 5, 3)] = 0.001
        pgm_function60[(2, 5, 4)] = 0.001
        pgm_function60[(2, 5, 5)] = 0.001
        pgm_function60[(2, 6, 1)] = 0.001
        pgm_function60[(2, 6, 2)] = 0.001
        pgm_function60[(2, 6, 3)] = 0.001
        pgm_function60[(2, 6, 4)] = 0.001
        pgm_function60[(2, 6, 5)] = 0.001
        pgm_function60[(2, 7, 1)] = 0.02
        pgm_function60[(2, 7, 2)] = 0.02
        pgm_function60[(2, 7, 3)] = 0.02
        pgm_function60[(2, 7, 4)] = 0.02
        pgm_function60[(2, 7, 5)] = 0.02
        pgm_function60[(2, 8, 1)] = 0.001
        pgm_function60[(2, 8, 2)] = 0.001
        pgm_function60[(2, 8, 3)] = 0.001
        pgm_function60[(2, 8, 4)] = 0.001
        pgm_function60[(2, 8, 5)] = 0.001
        pgm_function60[(2, 9, 1)] = 0.001
        pgm_function60[(2, 9, 2)] = 0.001
        pgm_function60[(2, 9, 3)] = 0.001
        pgm_function60[(2, 9, 4)] = 0.001
        pgm_function60[(2, 9, 5)] = 0.001
        pgm_function60[(2, 10, 1)] = 0.02
        pgm_function60[(2, 10, 2)] = 0.02
        pgm_function60[(2, 10, 3)] = 0.02
        pgm_function60[(2, 10, 4)] = 0.02
        pgm_function60[(2, 10, 5)] = 0.02
        pgm_function60[(2, 11, 1)] = 0.001
        pgm_function60[(2, 11, 2)] = 0.001
        pgm_function60[(2, 11, 3)] = 0.001
        pgm_function60[(2, 11, 4)] = 0.001
        pgm_function60[(2, 11, 5)] = 0.001
        pgm_function60[(2, 12, 1)] = 0.001
        pgm_function60[(2, 12, 2)] = 0.001
        pgm_function60[(2, 12, 3)] = 0.001
        pgm_function60[(2, 12, 4)] = 0.001
        pgm_function60[(2, 12, 5)] = 0.001
        pgm_function60[(2, 13, 1)] = 0.001
        pgm_function60[(2, 13, 2)] = 0.001
        pgm_function60[(2, 13, 3)] = 0.001
        pgm_function60[(2, 13, 4)] = 0.001
        pgm_function60[(2, 13, 5)] = 0.001
        pgm_function60[(2, 14, 1)] = 0.001
        pgm_function60[(2, 14, 2)] = 0.001
        pgm_function60[(2, 14, 3)] = 0.001
        pgm_function60[(2, 14, 4)] = 0.001
        pgm_function60[(2, 14, 5)] = 0.001
        pgm_function60[(2, 15, 1)] = 0.001
        pgm_function60[(2, 15, 2)] = 0.001
        pgm_function60[(2, 15, 3)] = 0.001
        pgm_function60[(2, 15, 4)] = 0.001
        pgm_function60[(2, 15, 5)] = 0.001
        pgm_function60[(2, 16, 1)] = 0.02
        pgm_function60[(2, 16, 2)] = 0.02
        pgm_function60[(2, 16, 3)] = 0.02
        pgm_function60[(2, 16, 4)] = 0.02
        pgm_function60[(2, 16, 5)] = 0.02
        pgm_function60[(2, 17, 1)] = 0.001
        pgm_function60[(2, 17, 2)] = 0.001
        pgm_function60[(2, 17, 3)] = 0.001
        pgm_function60[(2, 17, 4)] = 0.001
        pgm_function60[(2, 17, 5)] = 0.001
        pgm_function60[(2, 18, 1)] = 0.02
        pgm_function60[(2, 18, 2)] = 0.02
        pgm_function60[(2, 18, 3)] = 0.02
        pgm_function60[(2, 18, 4)] = 0.02
        pgm_function60[(2, 18, 5)] = 0.02
        pgm_function60[(2, 19, 1)] = 0.001
        pgm_function60[(2, 19, 2)] = 0.001
        pgm_function60[(2, 19, 3)] = 0.001
        pgm_function60[(2, 19, 4)] = 0.001
        pgm_function60[(2, 19, 5)] = 0.001
        pgm_function60[(2, 20, 1)] = 0.02
        pgm_function60[(2, 20, 2)] = 0.02
        pgm_function60[(2, 20, 3)] = 0.02
        pgm_function60[(2, 20, 4)] = 0.02
        pgm_function60[(2, 20, 5)] = 0.02
        pgm_function60[(2, 21, 1)] = 0.001
        pgm_function60[(2, 21, 2)] = 0.001
        pgm_function60[(2, 21, 3)] = 0.001
        pgm_function60[(2, 21, 4)] = 0.001
        pgm_function60[(2, 21, 5)] = 0.001
        pgm_function60[(2, 22, 1)] = 0.001
        pgm_function60[(2, 22, 2)] = 0.001
        pgm_function60[(2, 22, 3)] = 0.001
        pgm_function60[(2, 22, 4)] = 0.001
        pgm_function60[(2, 22, 5)] = 0.001
        pgm_function60[(2, 23, 1)] = 0.02
        pgm_function60[(2, 23, 2)] = 0.02
        pgm_function60[(2, 23, 3)] = 0.02
        pgm_function60[(2, 23, 4)] = 0.02
        pgm_function60[(2, 23, 5)] = 0.02
        pgm_function60[(2, 24, 1)] = 0.001
        pgm_function60[(2, 24, 2)] = 0.001
        pgm_function60[(2, 24, 3)] = 0.001
        pgm_function60[(2, 24, 4)] = 0.001
        pgm_function60[(2, 24, 5)] = 0.001
        pgm_function60[(2, 25, 1)] = 0.001
        pgm_function60[(2, 25, 2)] = 0.001
        pgm_function60[(2, 25, 3)] = 0.001
        pgm_function60[(2, 25, 4)] = 0.001
        pgm_function60[(2, 25, 5)] = 0.001
        pgm_function60[(2, 26, 1)] = 0.001
        pgm_function60[(2, 26, 2)] = 0.001
        pgm_function60[(2, 26, 3)] = 0.001
        pgm_function60[(2, 26, 4)] = 0.001
        pgm_function60[(2, 26, 5)] = 0.001
        pgm_function60[(2, 27, 1)] = 0.02
        pgm_function60[(2, 27, 2)] = 0.02
        pgm_function60[(2, 27, 3)] = 0.02
        pgm_function60[(2, 27, 4)] = 0.02
        pgm_function60[(2, 27, 5)] = 0.02
        pgm_function60[(2, 28, 1)] = 0.001
        pgm_function60[(2, 28, 2)] = 0.001
        pgm_function60[(2, 28, 3)] = 0.001
        pgm_function60[(2, 28, 4)] = 0.001
        pgm_function60[(2, 28, 5)] = 0.001
        pgm_function60[(2, 29, 1)] = 0.001
        pgm_function60[(2, 29, 2)] = 0.001
        pgm_function60[(2, 29, 3)] = 0.001
        pgm_function60[(2, 29, 4)] = 0.001
        pgm_function60[(2, 29, 5)] = 0.001
        pgm_function60[(2, 30, 1)] = 0.02
        pgm_function60[(2, 30, 2)] = 0.02
        pgm_function60[(2, 30, 3)] = 0.02
        pgm_function60[(2, 30, 4)] = 0.02
        pgm_function60[(2, 30, 5)] = 0.02
        pgm_function60[(2, 31, 1)] = 0.001
        pgm_function60[(2, 31, 2)] = 0.001
        pgm_function60[(2, 31, 3)] = 0.001
        pgm_function60[(2, 31, 4)] = 0.001
        pgm_function60[(2, 31, 5)] = 0.001
        pgm_function60[(2, 32, 1)] = 0.001
        pgm_function60[(2, 32, 2)] = 0.001
        pgm_function60[(2, 32, 3)] = 0.001
        pgm_function60[(2, 32, 4)] = 0.001
        pgm_function60[(2, 32, 5)] = 0.001
        pgm_function60[(2, 33, 1)] = 0.001
        pgm_function60[(2, 33, 2)] = 0.001
        pgm_function60[(2, 33, 3)] = 0.001
        pgm_function60[(2, 33, 4)] = 0.001
        pgm_function60[(2, 33, 5)] = 0.001
        pgm_function60[(2, 34, 1)] = 0.001
        pgm_function60[(2, 34, 2)] = 0.001
        pgm_function60[(2, 34, 3)] = 0.001
        pgm_function60[(2, 34, 4)] = 0.001
        pgm_function60[(2, 34, 5)] = 0.001
        pgm_function60[(2, 35, 1)] = 0.001
        pgm_function60[(2, 35, 2)] = 0.001
        pgm_function60[(2, 35, 3)] = 0.001
        pgm_function60[(2, 35, 4)] = 0.001
        pgm_function60[(2, 35, 5)] = 0.001
        pgm_function60[(2, 36, 1)] = 0.001
        pgm_function60[(2, 36, 2)] = 0.001
        pgm_function60[(2, 36, 3)] = 0.001
        pgm_function60[(2, 36, 4)] = 0.001
        pgm_function60[(2, 36, 5)] = 0.001
        pgm_function60[(2, 37, 1)] = 0.001
        pgm_function60[(2, 37, 2)] = 0.001
        pgm_function60[(2, 37, 3)] = 0.001
        pgm_function60[(2, 37, 4)] = 0.001
        pgm_function60[(2, 37, 5)] = 0.001
        pgm_function60[(2, 38, 1)] = 0.001
        pgm_function60[(2, 38, 2)] = 0.001
        pgm_function60[(2, 38, 3)] = 0.001
        pgm_function60[(2, 38, 4)] = 0.001
        pgm_function60[(2, 38, 5)] = 0.001
        pgm_function60[(2, 39, 1)] = 0.02
        pgm_function60[(2, 39, 2)] = 0.02
        pgm_function60[(2, 39, 3)] = 0.02
        pgm_function60[(2, 39, 4)] = 0.02
        pgm_function60[(2, 39, 5)] = 0.02
        pgm_function60[(2, 40, 1)] = 0.001
        pgm_function60[(2, 40, 2)] = 0.001
        pgm_function60[(2, 40, 3)] = 0.001
        pgm_function60[(2, 40, 4)] = 0.001
        pgm_function60[(2, 40, 5)] = 0.001
        pgm_function60[(2, 41, 1)] = 0.001
        pgm_function60[(2, 41, 2)] = 0.001
        pgm_function60[(2, 41, 3)] = 0.001
        pgm_function60[(2, 41, 4)] = 0.001
        pgm_function60[(2, 41, 5)] = 0.001
        pgm_function60[(2, 42, 1)] = 0.001
        pgm_function60[(2, 42, 2)] = 0.001
        pgm_function60[(2, 42, 3)] = 0.001
        pgm_function60[(2, 42, 4)] = 0.001
        pgm_function60[(2, 42, 5)] = 0.001
        pgm_function60[(2, 43, 1)] = 0.001
        pgm_function60[(2, 43, 2)] = 0.001
        pgm_function60[(2, 43, 3)] = 0.001
        pgm_function60[(2, 43, 4)] = 0.001
        pgm_function60[(2, 43, 5)] = 0.001
        pgm_function60[(2, 44, 1)] = 0.01
        pgm_function60[(2, 44, 2)] = 0.01
        pgm_function60[(2, 44, 3)] = 0.01
        pgm_function60[(2, 44, 4)] = 0.01
        pgm_function60[(2, 44, 5)] = 0.01
        pgm_function60[(2, 45, 1)] = 0.02
        pgm_function60[(2, 45, 2)] = 0.02
        pgm_function60[(2, 45, 3)] = 0.02
        pgm_function60[(2, 45, 4)] = 0.02
        pgm_function60[(2, 45, 5)] = 0.02
        pgm_function60[(2, 46, 1)] = 0.001
        pgm_function60[(2, 46, 2)] = 0.001
        pgm_function60[(2, 46, 3)] = 0.001
        pgm_function60[(2, 46, 4)] = 0.001
        pgm_function60[(2, 46, 5)] = 0.001
        pgm_function60[(2, 47, 1)] = 0.001
        pgm_function60[(2, 47, 2)] = 0.001
        pgm_function60[(2, 47, 3)] = 0.001
        pgm_function60[(2, 47, 4)] = 0.001
        pgm_function60[(2, 47, 5)] = 0.001
        pgm_function60[(2, 48, 1)] = 0.001
        pgm_function60[(2, 48, 2)] = 0.001
        pgm_function60[(2, 48, 3)] = 0.001
        pgm_function60[(2, 48, 4)] = 0.001
        pgm_function60[(2, 48, 5)] = 0.001
        pgm_function60[(2, 49, 1)] = 0.001
        pgm_function60[(2, 49, 2)] = 0.001
        pgm_function60[(2, 49, 3)] = 0.001
        pgm_function60[(2, 49, 4)] = 0.001
        pgm_function60[(2, 49, 5)] = 0.001
        pgm_function60[(2, 50, 1)] = 0.001
        pgm_function60[(2, 50, 2)] = 0.001
        pgm_function60[(2, 50, 3)] = 0.001
        pgm_function60[(2, 50, 4)] = 0.001
        pgm_function60[(2, 50, 5)] = 0.001
        pgm_function60[(2, 51, 1)] = 0.001
        pgm_function60[(2, 51, 2)] = 0.001
        pgm_function60[(2, 51, 3)] = 0.001
        pgm_function60[(2, 51, 4)] = 0.001
        pgm_function60[(2, 51, 5)] = 0.001
        pgm_function60[(2, 52, 1)] = 0.3
        pgm_function60[(2, 52, 2)] = 0.3
        pgm_function60[(2, 52, 3)] = 0.3
        pgm_function60[(2, 52, 4)] = 0.3
        pgm_function60[(2, 52, 5)] = 0.3
        pgm_function60[(2, 53, 1)] = 0.001
        pgm_function60[(2, 53, 2)] = 0.001
        pgm_function60[(2, 53, 3)] = 0.001
        pgm_function60[(2, 53, 4)] = 0.001
        pgm_function60[(2, 53, 5)] = 0.001
        pgm_function60[(2, 54, 1)] = 0.001
        pgm_function60[(2, 54, 2)] = 0.001
        pgm_function60[(2, 54, 3)] = 0.001
        pgm_function60[(2, 54, 4)] = 0.001
        pgm_function60[(2, 54, 5)] = 0.001
        pgm_function60[(2, 55, 1)] = 0.001
        pgm_function60[(2, 55, 2)] = 0.001
        pgm_function60[(2, 55, 3)] = 0.001
        pgm_function60[(2, 55, 4)] = 0.001
        pgm_function60[(2, 55, 5)] = 0.001
        pgm_function60[(2, 56, 1)] = 0.001
        pgm_function60[(2, 56, 2)] = 0.001
        pgm_function60[(2, 56, 3)] = 0.001
        pgm_function60[(2, 56, 4)] = 0.001
        pgm_function60[(2, 56, 5)] = 0.001
        pgm_function60[(2, 57, 1)] = 0.02
        pgm_function60[(2, 57, 2)] = 0.02
        pgm_function60[(2, 57, 3)] = 0.02
        pgm_function60[(2, 57, 4)] = 0.02
        pgm_function60[(2, 57, 5)] = 0.02
        pgm_function60[(2, 58, 1)] = 0.1666667
        pgm_function60[(2, 58, 2)] = 0.1
        pgm_function60[(2, 58, 3)] = 0.1
        pgm_function60[(2, 58, 4)] = 0.1
        pgm_function60[(2, 58, 5)] = 0.1
        pgm_function60[(2, 59, 1)] = 0.02
        pgm_function60[(2, 59, 2)] = 0.02
        pgm_function60[(2, 59, 3)] = 0.02
        pgm_function60[(2, 59, 4)] = 0.02
        pgm_function60[(2, 59, 5)] = 0.02
        pgm_function60[(2, 60, 1)] = 0.001
        pgm_function60[(2, 60, 2)] = 0.001
        pgm_function60[(2, 60, 3)] = 0.001
        pgm_function60[(2, 60, 4)] = 0.001
        pgm_function60[(2, 60, 5)] = 0.001
        pgm_function60[(2, 61, 1)] = 0.02
        pgm_function60[(2, 61, 2)] = 0.02
        pgm_function60[(2, 61, 3)] = 0.02
        pgm_function60[(2, 61, 4)] = 0.02
        pgm_function60[(2, 61, 5)] = 0.02
        pgm_function60[(2, 62, 1)] = 0.001
        pgm_function60[(2, 62, 2)] = 0.001
        pgm_function60[(2, 62, 3)] = 0.001
        pgm_function60[(2, 62, 4)] = 0.001
        pgm_function60[(2, 62, 5)] = 0.001
        pgm_function60[(2, 63, 1)] = 0.02
        pgm_function60[(2, 63, 2)] = 0.02
        pgm_function60[(2, 63, 3)] = 0.02
        pgm_function60[(2, 63, 4)] = 0.02
        pgm_function60[(2, 63, 5)] = 0.02
        pgm_function60[(2, 64, 1)] = 0.001
        pgm_function60[(2, 64, 2)] = 0.001
        pgm_function60[(2, 64, 3)] = 0.001
        pgm_function60[(2, 64, 4)] = 0.001
        pgm_function60[(2, 64, 5)] = 0.001
        pgm_function60[(2, 65, 1)] = 0.001
        pgm_function60[(2, 65, 2)] = 0.001
        pgm_function60[(2, 65, 3)] = 0.001
        pgm_function60[(2, 65, 4)] = 0.001
        pgm_function60[(2, 65, 5)] = 0.001
        pgm_function60[(2, 66, 1)] = 0.02
        pgm_function60[(2, 66, 2)] = 0.02
        pgm_function60[(2, 66, 3)] = 0.02
        pgm_function60[(2, 66, 4)] = 0.02
        pgm_function60[(2, 66, 5)] = 0.02
        pgm_function60[(2, 67, 1)] = 0.001
        pgm_function60[(2, 67, 2)] = 0.001
        pgm_function60[(2, 67, 3)] = 0.001
        pgm_function60[(2, 67, 4)] = 0.001
        pgm_function60[(2, 67, 5)] = 0.001
        pgm_function60[(2, 68, 1)] = 0.001
        pgm_function60[(2, 68, 2)] = 0.001
        pgm_function60[(2, 68, 3)] = 0.001
        pgm_function60[(2, 68, 4)] = 0.001
        pgm_function60[(2, 68, 5)] = 0.001
        pgm_function60[(2, 69, 1)] = 0.001
        pgm_function60[(2, 69, 2)] = 0.001
        pgm_function60[(2, 69, 3)] = 0.001
        pgm_function60[(2, 69, 4)] = 0.001
        pgm_function60[(2, 69, 5)] = 0.001
        pgm_function60[(2, 70, 1)] = 0.02
        pgm_function60[(2, 70, 2)] = 0.02
        pgm_function60[(2, 70, 3)] = 0.02
        pgm_function60[(2, 70, 4)] = 0.02
        pgm_function60[(2, 70, 5)] = 0.02
        pgm_function60[(2, 71, 1)] = 0.02
        pgm_function60[(2, 71, 2)] = 0.02
        pgm_function60[(2, 71, 3)] = 0.02
        pgm_function60[(2, 71, 4)] = 0.02
        pgm_function60[(2, 71, 5)] = 0.02
        pgm_function60[(2, 72, 1)] = 0.02
        pgm_function60[(2, 72, 2)] = 0.02
        pgm_function60[(2, 72, 3)] = 0.02
        pgm_function60[(2, 72, 4)] = 0.02
        pgm_function60[(2, 72, 5)] = 0.02
        pgm_function60[(2, 73, 1)] = 0.001
        pgm_function60[(2, 73, 2)] = 0.001
        pgm_function60[(2, 73, 3)] = 0.001
        pgm_function60[(2, 73, 4)] = 0.001
        pgm_function60[(2, 73, 5)] = 0.001
        pgm_function60[(2, 74, 1)] = 0.001
        pgm_function60[(2, 74, 2)] = 0.001
        pgm_function60[(2, 74, 3)] = 0.001
        pgm_function60[(2, 74, 4)] = 0.001
        pgm_function60[(2, 74, 5)] = 0.001
        pgm_function60[(2, 75, 1)] = 0.001
        pgm_function60[(2, 75, 2)] = 0.001
        pgm_function60[(2, 75, 3)] = 0.001
        pgm_function60[(2, 75, 4)] = 0.001
        pgm_function60[(2, 75, 5)] = 0.001
        pgm_function60[(3, 39, 1)] = 0.001
        pgm_function60[(3, 39, 2)] = 0.001
        pgm_function60[(3, 39, 3)] = 0.001
        pgm_function60[(3, 39, 4)] = 0.001
        pgm_function60[(3, 39, 5)] = 0.001
        pgm_function60[(3, 44, 1)] = 0.01
        pgm_function60[(3, 44, 2)] = 0.01
        pgm_function60[(3, 44, 3)] = 0.01
        pgm_function60[(3, 44, 4)] = 0.01
        pgm_function60[(3, 44, 5)] = 0.01
        pgm_function60[(3, 52, 1)] = 0.05
        pgm_function60[(3, 52, 2)] = 0.05
        pgm_function60[(3, 52, 3)] = 0.05
        pgm_function60[(3, 52, 4)] = 0.05
        pgm_function60[(3, 52, 5)] = 0.05
        pgm_function60[(3, 58, 1)] = 0.1666667
        pgm_function60[(3, 58, 2)] = 0.03
        pgm_function60[(3, 58, 3)] = 0.03
        pgm_function60[(3, 58, 4)] = 0.03
        pgm_function60[(3, 58, 5)] = 0.03
        pgm_function60[(4, 0, 1)] = 0.001
        pgm_function60[(4, 0, 2)] = 0.001
        pgm_function60[(4, 0, 3)] = 0.001
        pgm_function60[(4, 0, 4)] = 0.001
        pgm_function60[(4, 0, 5)] = 0.001
        pgm_function60[(4, 1, 1)] = 0.001
        pgm_function60[(4, 1, 2)] = 0.001
        pgm_function60[(4, 1, 3)] = 0.001
        pgm_function60[(4, 1, 4)] = 0.001
        pgm_function60[(4, 1, 5)] = 0.001
        pgm_function60[(4, 2, 1)] = 0.001
        pgm_function60[(4, 2, 2)] = 0.001
        pgm_function60[(4, 2, 3)] = 0.001
        pgm_function60[(4, 2, 4)] = 0.001
        pgm_function60[(4, 2, 5)] = 0.001
        pgm_function60[(4, 3, 1)] = 0.001
        pgm_function60[(4, 3, 2)] = 0.001
        pgm_function60[(4, 3, 3)] = 0.001
        pgm_function60[(4, 3, 4)] = 0.001
        pgm_function60[(4, 3, 5)] = 0.001
        pgm_function60[(4, 4, 1)] = 0.001
        pgm_function60[(4, 4, 2)] = 0.001
        pgm_function60[(4, 4, 3)] = 0.001
        pgm_function60[(4, 4, 4)] = 0.001
        pgm_function60[(4, 4, 5)] = 0.001
        pgm_function60[(4, 5, 1)] = 0.001
        pgm_function60[(4, 5, 2)] = 0.001
        pgm_function60[(4, 5, 3)] = 0.001
        pgm_function60[(4, 5, 4)] = 0.001
        pgm_function60[(4, 5, 5)] = 0.001
        pgm_function60[(4, 6, 1)] = 0.001
        pgm_function60[(4, 6, 2)] = 0.001
        pgm_function60[(4, 6, 3)] = 0.001
        pgm_function60[(4, 6, 4)] = 0.001
        pgm_function60[(4, 6, 5)] = 0.001
        pgm_function60[(4, 7, 1)] = 0.001
        pgm_function60[(4, 7, 2)] = 0.001
        pgm_function60[(4, 7, 3)] = 0.001
        pgm_function60[(4, 7, 4)] = 0.001
        pgm_function60[(4, 7, 5)] = 0.001
        pgm_function60[(4, 8, 1)] = 0.001
        pgm_function60[(4, 8, 2)] = 0.001
        pgm_function60[(4, 8, 3)] = 0.001
        pgm_function60[(4, 8, 4)] = 0.001
        pgm_function60[(4, 8, 5)] = 0.001
        pgm_function60[(4, 9, 1)] = 0.001
        pgm_function60[(4, 9, 2)] = 0.001
        pgm_function60[(4, 9, 3)] = 0.001
        pgm_function60[(4, 9, 4)] = 0.001
        pgm_function60[(4, 9, 5)] = 0.001
        pgm_function60[(4, 10, 1)] = 0.001
        pgm_function60[(4, 10, 2)] = 0.001
        pgm_function60[(4, 10, 3)] = 0.001
        pgm_function60[(4, 10, 4)] = 0.001
        pgm_function60[(4, 10, 5)] = 0.001
        pgm_function60[(4, 11, 1)] = 0.001
        pgm_function60[(4, 11, 2)] = 0.001
        pgm_function60[(4, 11, 3)] = 0.001
        pgm_function60[(4, 11, 4)] = 0.001
        pgm_function60[(4, 11, 5)] = 0.001
        pgm_function60[(4, 12, 1)] = 0.001
        pgm_function60[(4, 12, 2)] = 0.001
        pgm_function60[(4, 12, 3)] = 0.001
        pgm_function60[(4, 12, 4)] = 0.001
        pgm_function60[(4, 12, 5)] = 0.001
        pgm_function60[(4, 13, 1)] = 0.001
        pgm_function60[(4, 13, 2)] = 0.001
        pgm_function60[(4, 13, 3)] = 0.001
        pgm_function60[(4, 13, 4)] = 0.001
        pgm_function60[(4, 13, 5)] = 0.001
        pgm_function60[(4, 14, 1)] = 0.001
        pgm_function60[(4, 14, 2)] = 0.001
        pgm_function60[(4, 14, 3)] = 0.001
        pgm_function60[(4, 14, 4)] = 0.001
        pgm_function60[(4, 14, 5)] = 0.001
        pgm_function60[(4, 15, 1)] = 0.001
        pgm_function60[(4, 15, 2)] = 0.001
        pgm_function60[(4, 15, 3)] = 0.001
        pgm_function60[(4, 15, 4)] = 0.001
        pgm_function60[(4, 15, 5)] = 0.001
        pgm_function60[(4, 16, 1)] = 0.001
        pgm_function60[(4, 16, 2)] = 0.001
        pgm_function60[(4, 16, 3)] = 0.001
        pgm_function60[(4, 16, 4)] = 0.001
        pgm_function60[(4, 16, 5)] = 0.001
        pgm_function60[(4, 17, 1)] = 0.001
        pgm_function60[(4, 17, 2)] = 0.001
        pgm_function60[(4, 17, 3)] = 0.001
        pgm_function60[(4, 17, 4)] = 0.001
        pgm_function60[(4, 17, 5)] = 0.001
        pgm_function60[(4, 18, 1)] = 0.001
        pgm_function60[(4, 18, 2)] = 0.001
        pgm_function60[(4, 18, 3)] = 0.001
        pgm_function60[(4, 18, 4)] = 0.001
        pgm_function60[(4, 18, 5)] = 0.001
        pgm_function60[(4, 19, 1)] = 0.001
        pgm_function60[(4, 19, 2)] = 0.001
        pgm_function60[(4, 19, 3)] = 0.001
        pgm_function60[(4, 19, 4)] = 0.001
        pgm_function60[(4, 19, 5)] = 0.001
        pgm_function60[(4, 20, 1)] = 0.001
        pgm_function60[(4, 20, 2)] = 0.001
        pgm_function60[(4, 20, 3)] = 0.001
        pgm_function60[(4, 20, 4)] = 0.001
        pgm_function60[(4, 20, 5)] = 0.001
        pgm_function60[(4, 21, 1)] = 0.001
        pgm_function60[(4, 21, 2)] = 0.001
        pgm_function60[(4, 21, 3)] = 0.001
        pgm_function60[(4, 21, 4)] = 0.001
        pgm_function60[(4, 21, 5)] = 0.001
        pgm_function60[(4, 22, 1)] = 0.001
        pgm_function60[(4, 22, 2)] = 0.001
        pgm_function60[(4, 22, 3)] = 0.001
        pgm_function60[(4, 22, 4)] = 0.001
        pgm_function60[(4, 22, 5)] = 0.001
        pgm_function60[(4, 23, 1)] = 0.001
        pgm_function60[(4, 23, 2)] = 0.001
        pgm_function60[(4, 23, 3)] = 0.001
        pgm_function60[(4, 23, 4)] = 0.001
        pgm_function60[(4, 23, 5)] = 0.001
        pgm_function60[(4, 24, 1)] = 0.001
        pgm_function60[(4, 24, 2)] = 0.001
        pgm_function60[(4, 24, 3)] = 0.001
        pgm_function60[(4, 24, 4)] = 0.001
        pgm_function60[(4, 24, 5)] = 0.001
        pgm_function60[(4, 25, 1)] = 0.001
        pgm_function60[(4, 25, 2)] = 0.001
        pgm_function60[(4, 25, 3)] = 0.001
        pgm_function60[(4, 25, 4)] = 0.001
        pgm_function60[(4, 25, 5)] = 0.001
        pgm_function60[(4, 26, 1)] = 0.001
        pgm_function60[(4, 26, 2)] = 0.001
        pgm_function60[(4, 26, 3)] = 0.001
        pgm_function60[(4, 26, 4)] = 0.001
        pgm_function60[(4, 26, 5)] = 0.001
        pgm_function60[(4, 27, 1)] = 0.001
        pgm_function60[(4, 27, 2)] = 0.001
        pgm_function60[(4, 27, 3)] = 0.001
        pgm_function60[(4, 27, 4)] = 0.001
        pgm_function60[(4, 27, 5)] = 0.001
        pgm_function60[(4, 28, 1)] = 0.001
        pgm_function60[(4, 28, 2)] = 0.001
        pgm_function60[(4, 28, 3)] = 0.001
        pgm_function60[(4, 28, 4)] = 0.001
        pgm_function60[(4, 28, 5)] = 0.001
        pgm_function60[(4, 29, 1)] = 0.001
        pgm_function60[(4, 29, 2)] = 0.001
        pgm_function60[(4, 29, 3)] = 0.001
        pgm_function60[(4, 29, 4)] = 0.001
        pgm_function60[(4, 29, 5)] = 0.001
        pgm_function60[(4, 30, 1)] = 0.001
        pgm_function60[(4, 30, 2)] = 0.001
        pgm_function60[(4, 30, 3)] = 0.001
        pgm_function60[(4, 30, 4)] = 0.001
        pgm_function60[(4, 30, 5)] = 0.001
        pgm_function60[(4, 31, 1)] = 0.001
        pgm_function60[(4, 31, 2)] = 0.001
        pgm_function60[(4, 31, 3)] = 0.001
        pgm_function60[(4, 31, 4)] = 0.001
        pgm_function60[(4, 31, 5)] = 0.001
        pgm_function60[(4, 32, 1)] = 0.001
        pgm_function60[(4, 32, 2)] = 0.001
        pgm_function60[(4, 32, 3)] = 0.001
        pgm_function60[(4, 32, 4)] = 0.001
        pgm_function60[(4, 32, 5)] = 0.001
        pgm_function60[(4, 33, 1)] = 0.001
        pgm_function60[(4, 33, 2)] = 0.001
        pgm_function60[(4, 33, 3)] = 0.001
        pgm_function60[(4, 33, 4)] = 0.001
        pgm_function60[(4, 33, 5)] = 0.001
        pgm_function60[(4, 34, 1)] = 0.001
        pgm_function60[(4, 34, 2)] = 0.001
        pgm_function60[(4, 34, 3)] = 0.001
        pgm_function60[(4, 34, 4)] = 0.001
        pgm_function60[(4, 34, 5)] = 0.001
        pgm_function60[(4, 35, 1)] = 0.001
        pgm_function60[(4, 35, 2)] = 0.001
        pgm_function60[(4, 35, 3)] = 0.001
        pgm_function60[(4, 35, 4)] = 0.001
        pgm_function60[(4, 35, 5)] = 0.001
        pgm_function60[(4, 36, 1)] = 0.001
        pgm_function60[(4, 36, 2)] = 0.001
        pgm_function60[(4, 36, 3)] = 0.001
        pgm_function60[(4, 36, 4)] = 0.001
        pgm_function60[(4, 36, 5)] = 0.001
        pgm_function60[(4, 37, 1)] = 0.001
        pgm_function60[(4, 37, 2)] = 0.001
        pgm_function60[(4, 37, 3)] = 0.001
        pgm_function60[(4, 37, 4)] = 0.001
        pgm_function60[(4, 37, 5)] = 0.001
        pgm_function60[(4, 38, 1)] = 0.001
        pgm_function60[(4, 38, 2)] = 0.001
        pgm_function60[(4, 38, 3)] = 0.001
        pgm_function60[(4, 38, 4)] = 0.001
        pgm_function60[(4, 38, 5)] = 0.001
        pgm_function60[(4, 39, 1)] = 0.001
        pgm_function60[(4, 39, 2)] = 0.001
        pgm_function60[(4, 39, 3)] = 0.001
        pgm_function60[(4, 39, 4)] = 0.001
        pgm_function60[(4, 39, 5)] = 0.001
        pgm_function60[(4, 40, 1)] = 0.001
        pgm_function60[(4, 40, 2)] = 0.001
        pgm_function60[(4, 40, 3)] = 0.001
        pgm_function60[(4, 40, 4)] = 0.001
        pgm_function60[(4, 40, 5)] = 0.001
        pgm_function60[(4, 41, 1)] = 0.001
        pgm_function60[(4, 41, 2)] = 0.001
        pgm_function60[(4, 41, 3)] = 0.001
        pgm_function60[(4, 41, 4)] = 0.001
        pgm_function60[(4, 41, 5)] = 0.001
        pgm_function60[(4, 42, 1)] = 0.001
        pgm_function60[(4, 42, 2)] = 0.001
        pgm_function60[(4, 42, 3)] = 0.001
        pgm_function60[(4, 42, 4)] = 0.001
        pgm_function60[(4, 42, 5)] = 0.001
        pgm_function60[(4, 43, 1)] = 0.001
        pgm_function60[(4, 43, 2)] = 0.001
        pgm_function60[(4, 43, 3)] = 0.001
        pgm_function60[(4, 43, 4)] = 0.001
        pgm_function60[(4, 43, 5)] = 0.001
        pgm_function60[(4, 44, 1)] = 0.01
        pgm_function60[(4, 44, 2)] = 0.01
        pgm_function60[(4, 44, 3)] = 0.01
        pgm_function60[(4, 44, 4)] = 0.01
        pgm_function60[(4, 44, 5)] = 0.01
        pgm_function60[(4, 45, 1)] = 0.001
        pgm_function60[(4, 45, 2)] = 0.001
        pgm_function60[(4, 45, 3)] = 0.001
        pgm_function60[(4, 45, 4)] = 0.001
        pgm_function60[(4, 45, 5)] = 0.001
        pgm_function60[(4, 46, 1)] = 0.001
        pgm_function60[(4, 46, 2)] = 0.001
        pgm_function60[(4, 46, 3)] = 0.001
        pgm_function60[(4, 46, 4)] = 0.001
        pgm_function60[(4, 46, 5)] = 0.001
        pgm_function60[(4, 47, 1)] = 0.001
        pgm_function60[(4, 47, 2)] = 0.001
        pgm_function60[(4, 47, 3)] = 0.001
        pgm_function60[(4, 47, 4)] = 0.001
        pgm_function60[(4, 47, 5)] = 0.001
        pgm_function60[(4, 48, 1)] = 0.001
        pgm_function60[(4, 48, 2)] = 0.001
        pgm_function60[(4, 48, 3)] = 0.001
        pgm_function60[(4, 48, 4)] = 0.001
        pgm_function60[(4, 48, 5)] = 0.001
        pgm_function60[(4, 49, 1)] = 0.001
        pgm_function60[(4, 49, 2)] = 0.001
        pgm_function60[(4, 49, 3)] = 0.001
        pgm_function60[(4, 49, 4)] = 0.001
        pgm_function60[(4, 49, 5)] = 0.001
        pgm_function60[(4, 50, 1)] = 0.001
        pgm_function60[(4, 50, 2)] = 0.001
        pgm_function60[(4, 50, 3)] = 0.001
        pgm_function60[(4, 50, 4)] = 0.001
        pgm_function60[(4, 50, 5)] = 0.001
        pgm_function60[(4, 51, 1)] = 0.001
        pgm_function60[(4, 51, 2)] = 0.001
        pgm_function60[(4, 51, 3)] = 0.001
        pgm_function60[(4, 51, 4)] = 0.001
        pgm_function60[(4, 51, 5)] = 0.001
        pgm_function60[(4, 52, 1)] = 0.15
        pgm_function60[(4, 52, 2)] = 0.15
        pgm_function60[(4, 52, 3)] = 0.15
        pgm_function60[(4, 52, 4)] = 0.15
        pgm_function60[(4, 52, 5)] = 0.15
        pgm_function60[(4, 53, 1)] = 0.001
        pgm_function60[(4, 53, 2)] = 0.001
        pgm_function60[(4, 53, 3)] = 0.001
        pgm_function60[(4, 53, 4)] = 0.001
        pgm_function60[(4, 53, 5)] = 0.001
        pgm_function60[(4, 54, 1)] = 0.001
        pgm_function60[(4, 54, 2)] = 0.001
        pgm_function60[(4, 54, 3)] = 0.001
        pgm_function60[(4, 54, 4)] = 0.001
        pgm_function60[(4, 54, 5)] = 0.001
        pgm_function60[(4, 55, 1)] = 0.001
        pgm_function60[(4, 55, 2)] = 0.001
        pgm_function60[(4, 55, 3)] = 0.001
        pgm_function60[(4, 55, 4)] = 0.001
        pgm_function60[(4, 55, 5)] = 0.001
        pgm_function60[(4, 56, 1)] = 0.001
        pgm_function60[(4, 56, 2)] = 0.001
        pgm_function60[(4, 56, 3)] = 0.001
        pgm_function60[(4, 56, 4)] = 0.001
        pgm_function60[(4, 56, 5)] = 0.001
        pgm_function60[(4, 57, 1)] = 0.001
        pgm_function60[(4, 57, 2)] = 0.001
        pgm_function60[(4, 57, 3)] = 0.001
        pgm_function60[(4, 57, 4)] = 0.001
        pgm_function60[(4, 57, 5)] = 0.001
        pgm_function60[(4, 58, 1)] = 0.1666667
        pgm_function60[(4, 58, 2)] = 0.02
        pgm_function60[(4, 58, 3)] = 0.02
        pgm_function60[(4, 58, 4)] = 0.02
        pgm_function60[(4, 58, 5)] = 0.02
        pgm_function60[(4, 59, 1)] = 0.001
        pgm_function60[(4, 59, 2)] = 0.001
        pgm_function60[(4, 59, 3)] = 0.001
        pgm_function60[(4, 59, 4)] = 0.001
        pgm_function60[(4, 59, 5)] = 0.001
        pgm_function60[(4, 60, 1)] = 0.001
        pgm_function60[(4, 60, 2)] = 0.001
        pgm_function60[(4, 60, 3)] = 0.001
        pgm_function60[(4, 60, 4)] = 0.001
        pgm_function60[(4, 60, 5)] = 0.001
        pgm_function60[(4, 61, 1)] = 0.001
        pgm_function60[(4, 61, 2)] = 0.001
        pgm_function60[(4, 61, 3)] = 0.001
        pgm_function60[(4, 61, 4)] = 0.001
        pgm_function60[(4, 61, 5)] = 0.001
        pgm_function60[(4, 62, 1)] = 0.001
        pgm_function60[(4, 62, 2)] = 0.001
        pgm_function60[(4, 62, 3)] = 0.001
        pgm_function60[(4, 62, 4)] = 0.001
        pgm_function60[(4, 62, 5)] = 0.001
        pgm_function60[(4, 63, 1)] = 0.001
        pgm_function60[(4, 63, 2)] = 0.001
        pgm_function60[(4, 63, 3)] = 0.001
        pgm_function60[(4, 63, 4)] = 0.001
        pgm_function60[(4, 63, 5)] = 0.001
        pgm_function60[(4, 64, 1)] = 0.001
        pgm_function60[(4, 64, 2)] = 0.001
        pgm_function60[(4, 64, 3)] = 0.001
        pgm_function60[(4, 64, 4)] = 0.001
        pgm_function60[(4, 64, 5)] = 0.001
        pgm_function60[(4, 65, 1)] = 0.001
        pgm_function60[(4, 65, 2)] = 0.001
        pgm_function60[(4, 65, 3)] = 0.001
        pgm_function60[(4, 65, 4)] = 0.001
        pgm_function60[(4, 65, 5)] = 0.001
        pgm_function60[(4, 66, 1)] = 0.001
        pgm_function60[(4, 66, 2)] = 0.001
        pgm_function60[(4, 66, 3)] = 0.001
        pgm_function60[(4, 66, 4)] = 0.001
        pgm_function60[(4, 66, 5)] = 0.001
        pgm_function60[(4, 67, 1)] = 0.001
        pgm_function60[(4, 67, 2)] = 0.001
        pgm_function60[(4, 67, 3)] = 0.001
        pgm_function60[(4, 67, 4)] = 0.001
        pgm_function60[(4, 67, 5)] = 0.001
        pgm_function60[(4, 68, 1)] = 0.001
        pgm_function60[(4, 68, 2)] = 0.001
        pgm_function60[(4, 68, 3)] = 0.001
        pgm_function60[(4, 68, 4)] = 0.001
        pgm_function60[(4, 68, 5)] = 0.001
        pgm_function60[(4, 69, 1)] = 0.001
        pgm_function60[(4, 69, 2)] = 0.001
        pgm_function60[(4, 69, 3)] = 0.001
        pgm_function60[(4, 69, 4)] = 0.001
        pgm_function60[(4, 69, 5)] = 0.001
        pgm_function60[(4, 70, 1)] = 0.001
        pgm_function60[(4, 70, 2)] = 0.001
        pgm_function60[(4, 70, 3)] = 0.001
        pgm_function60[(4, 70, 4)] = 0.001
        pgm_function60[(4, 70, 5)] = 0.001
        pgm_function60[(4, 71, 1)] = 0.001
        pgm_function60[(4, 71, 2)] = 0.001
        pgm_function60[(4, 71, 3)] = 0.001
        pgm_function60[(4, 71, 4)] = 0.001
        pgm_function60[(4, 71, 5)] = 0.001
        pgm_function60[(4, 72, 1)] = 0.001
        pgm_function60[(4, 72, 2)] = 0.001
        pgm_function60[(4, 72, 3)] = 0.001
        pgm_function60[(4, 72, 4)] = 0.001
        pgm_function60[(4, 72, 5)] = 0.001
        pgm_function60[(4, 73, 1)] = 0.001
        pgm_function60[(4, 73, 2)] = 0.001
        pgm_function60[(4, 73, 3)] = 0.001
        pgm_function60[(4, 73, 4)] = 0.001
        pgm_function60[(4, 73, 5)] = 0.001
        pgm_function60[(4, 74, 1)] = 0.001
        pgm_function60[(4, 74, 2)] = 0.001
        pgm_function60[(4, 74, 3)] = 0.001
        pgm_function60[(4, 74, 4)] = 0.001
        pgm_function60[(4, 74, 5)] = 0.001
        pgm_function60[(4, 75, 1)] = 0.001
        pgm_function60[(4, 75, 2)] = 0.001
        pgm_function60[(4, 75, 3)] = 0.001
        pgm_function60[(4, 75, 4)] = 0.001
        pgm_function60[(4, 75, 5)] = 0.001
        pgm_function60[(5, 0, 1)] = 0.05
        pgm_function60[(5, 0, 2)] = 0.05
        pgm_function60[(5, 0, 3)] = 0.05
        pgm_function60[(5, 0, 4)] = 0.05
        pgm_function60[(5, 0, 5)] = 0.05
        pgm_function60[(5, 1, 1)] = 0.05
        pgm_function60[(5, 1, 2)] = 0.05
        pgm_function60[(5, 1, 3)] = 0.05
        pgm_function60[(5, 1, 4)] = 0.05
        pgm_function60[(5, 1, 5)] = 0.05
        pgm_function60[(5, 2, 1)] = 0.05
        pgm_function60[(5, 2, 2)] = 0.05
        pgm_function60[(5, 2, 3)] = 0.05
        pgm_function60[(5, 2, 4)] = 0.05
        pgm_function60[(5, 2, 5)] = 0.05
        pgm_function60[(5, 3, 1)] = 0.02
        pgm_function60[(5, 3, 2)] = 0.02
        pgm_function60[(5, 3, 3)] = 0.02
        pgm_function60[(5, 3, 4)] = 0.02
        pgm_function60[(5, 3, 5)] = 0.02
        pgm_function60[(5, 4, 1)] = 0.05
        pgm_function60[(5, 4, 2)] = 0.05
        pgm_function60[(5, 4, 3)] = 0.05
        pgm_function60[(5, 4, 4)] = 0.05
        pgm_function60[(5, 4, 5)] = 0.05
        pgm_function60[(5, 5, 1)] = 0.02
        pgm_function60[(5, 5, 2)] = 0.02
        pgm_function60[(5, 5, 3)] = 0.02
        pgm_function60[(5, 5, 4)] = 0.02
        pgm_function60[(5, 5, 5)] = 0.02
        pgm_function60[(5, 6, 1)] = 0.02
        pgm_function60[(5, 6, 2)] = 0.02
        pgm_function60[(5, 6, 3)] = 0.02
        pgm_function60[(5, 6, 4)] = 0.02
        pgm_function60[(5, 6, 5)] = 0.02
        pgm_function60[(5, 7, 1)] = 0.05
        pgm_function60[(5, 7, 2)] = 0.05
        pgm_function60[(5, 7, 3)] = 0.05
        pgm_function60[(5, 7, 4)] = 0.05
        pgm_function60[(5, 7, 5)] = 0.05
        pgm_function60[(5, 8, 1)] = 0.02
        pgm_function60[(5, 8, 2)] = 0.02
        pgm_function60[(5, 8, 3)] = 0.02
        pgm_function60[(5, 8, 4)] = 0.02
        pgm_function60[(5, 8, 5)] = 0.02
        pgm_function60[(5, 9, 1)] = 0.02
        pgm_function60[(5, 9, 2)] = 0.02
        pgm_function60[(5, 9, 3)] = 0.02
        pgm_function60[(5, 9, 4)] = 0.02
        pgm_function60[(5, 9, 5)] = 0.02
        pgm_function60[(5, 10, 1)] = 0.05
        pgm_function60[(5, 10, 2)] = 0.05
        pgm_function60[(5, 10, 3)] = 0.05
        pgm_function60[(5, 10, 4)] = 0.05
        pgm_function60[(5, 10, 5)] = 0.05
        pgm_function60[(5, 11, 1)] = 0.02
        pgm_function60[(5, 11, 2)] = 0.02
        pgm_function60[(5, 11, 3)] = 0.02
        pgm_function60[(5, 11, 4)] = 0.02
        pgm_function60[(5, 11, 5)] = 0.02
        pgm_function60[(5, 12, 1)] = 0.02
        pgm_function60[(5, 12, 2)] = 0.02
        pgm_function60[(5, 12, 3)] = 0.02
        pgm_function60[(5, 12, 4)] = 0.02
        pgm_function60[(5, 12, 5)] = 0.02
        pgm_function60[(5, 13, 1)] = 0.02
        pgm_function60[(5, 13, 2)] = 0.02
        pgm_function60[(5, 13, 3)] = 0.02
        pgm_function60[(5, 13, 4)] = 0.02
        pgm_function60[(5, 13, 5)] = 0.02
        pgm_function60[(5, 14, 1)] = 0.02
        pgm_function60[(5, 14, 2)] = 0.02
        pgm_function60[(5, 14, 3)] = 0.02
        pgm_function60[(5, 14, 4)] = 0.02
        pgm_function60[(5, 14, 5)] = 0.02
        pgm_function60[(5, 15, 1)] = 0.02
        pgm_function60[(5, 15, 2)] = 0.02
        pgm_function60[(5, 15, 3)] = 0.02
        pgm_function60[(5, 15, 4)] = 0.02
        pgm_function60[(5, 15, 5)] = 0.02
        pgm_function60[(5, 16, 1)] = 0.05
        pgm_function60[(5, 16, 2)] = 0.05
        pgm_function60[(5, 16, 3)] = 0.05
        pgm_function60[(5, 16, 4)] = 0.05
        pgm_function60[(5, 16, 5)] = 0.05
        pgm_function60[(5, 17, 1)] = 0.02
        pgm_function60[(5, 17, 2)] = 0.02
        pgm_function60[(5, 17, 3)] = 0.02
        pgm_function60[(5, 17, 4)] = 0.02
        pgm_function60[(5, 17, 5)] = 0.02
        pgm_function60[(5, 18, 1)] = 0.05
        pgm_function60[(5, 18, 2)] = 0.05
        pgm_function60[(5, 18, 3)] = 0.05
        pgm_function60[(5, 18, 4)] = 0.05
        pgm_function60[(5, 18, 5)] = 0.05
        pgm_function60[(5, 19, 1)] = 0.02
        pgm_function60[(5, 19, 2)] = 0.02
        pgm_function60[(5, 19, 3)] = 0.02
        pgm_function60[(5, 19, 4)] = 0.02
        pgm_function60[(5, 19, 5)] = 0.02
        pgm_function60[(5, 20, 1)] = 0.05
        pgm_function60[(5, 20, 2)] = 0.05
        pgm_function60[(5, 20, 3)] = 0.05
        pgm_function60[(5, 20, 4)] = 0.05
        pgm_function60[(5, 20, 5)] = 0.05
        pgm_function60[(5, 21, 1)] = 0.02
        pgm_function60[(5, 21, 2)] = 0.02
        pgm_function60[(5, 21, 3)] = 0.02
        pgm_function60[(5, 21, 4)] = 0.02
        pgm_function60[(5, 21, 5)] = 0.02
        pgm_function60[(5, 22, 1)] = 0.02
        pgm_function60[(5, 22, 2)] = 0.02
        pgm_function60[(5, 22, 3)] = 0.02
        pgm_function60[(5, 22, 4)] = 0.02
        pgm_function60[(5, 22, 5)] = 0.02
        pgm_function60[(5, 23, 1)] = 0.05
        pgm_function60[(5, 23, 2)] = 0.05
        pgm_function60[(5, 23, 3)] = 0.05
        pgm_function60[(5, 23, 4)] = 0.05
        pgm_function60[(5, 23, 5)] = 0.05
        pgm_function60[(5, 24, 1)] = 0.02
        pgm_function60[(5, 24, 2)] = 0.02
        pgm_function60[(5, 24, 3)] = 0.02
        pgm_function60[(5, 24, 4)] = 0.02
        pgm_function60[(5, 24, 5)] = 0.02
        pgm_function60[(5, 25, 1)] = 0.02
        pgm_function60[(5, 25, 2)] = 0.02
        pgm_function60[(5, 25, 3)] = 0.02
        pgm_function60[(5, 25, 4)] = 0.02
        pgm_function60[(5, 25, 5)] = 0.02
        pgm_function60[(5, 26, 1)] = 0.02
        pgm_function60[(5, 26, 2)] = 0.02
        pgm_function60[(5, 26, 3)] = 0.02
        pgm_function60[(5, 26, 4)] = 0.02
        pgm_function60[(5, 26, 5)] = 0.02
        pgm_function60[(5, 27, 1)] = 0.05
        pgm_function60[(5, 27, 2)] = 0.05
        pgm_function60[(5, 27, 3)] = 0.05
        pgm_function60[(5, 27, 4)] = 0.05
        pgm_function60[(5, 27, 5)] = 0.05
        pgm_function60[(5, 28, 1)] = 0.02
        pgm_function60[(5, 28, 2)] = 0.02
        pgm_function60[(5, 28, 3)] = 0.02
        pgm_function60[(5, 28, 4)] = 0.02
        pgm_function60[(5, 28, 5)] = 0.02
        pgm_function60[(5, 29, 1)] = 0.02
        pgm_function60[(5, 29, 2)] = 0.02
        pgm_function60[(5, 29, 3)] = 0.02
        pgm_function60[(5, 29, 4)] = 0.02
        pgm_function60[(5, 29, 5)] = 0.02
        pgm_function60[(5, 30, 1)] = 0.05
        pgm_function60[(5, 30, 2)] = 0.05
        pgm_function60[(5, 30, 3)] = 0.05
        pgm_function60[(5, 30, 4)] = 0.05
        pgm_function60[(5, 30, 5)] = 0.05
        pgm_function60[(5, 31, 1)] = 0.02
        pgm_function60[(5, 31, 2)] = 0.02
        pgm_function60[(5, 31, 3)] = 0.02
        pgm_function60[(5, 31, 4)] = 0.02
        pgm_function60[(5, 31, 5)] = 0.02
        pgm_function60[(5, 32, 1)] = 0.02
        pgm_function60[(5, 32, 2)] = 0.02
        pgm_function60[(5, 32, 3)] = 0.02
        pgm_function60[(5, 32, 4)] = 0.02
        pgm_function60[(5, 32, 5)] = 0.02
        pgm_function60[(5, 33, 1)] = 0.02
        pgm_function60[(5, 33, 2)] = 0.02
        pgm_function60[(5, 33, 3)] = 0.02
        pgm_function60[(5, 33, 4)] = 0.02
        pgm_function60[(5, 33, 5)] = 0.02
        pgm_function60[(5, 34, 1)] = 0.02
        pgm_function60[(5, 34, 2)] = 0.02
        pgm_function60[(5, 34, 3)] = 0.02
        pgm_function60[(5, 34, 4)] = 0.02
        pgm_function60[(5, 34, 5)] = 0.02
        pgm_function60[(5, 35, 1)] = 0.02
        pgm_function60[(5, 35, 2)] = 0.02
        pgm_function60[(5, 35, 3)] = 0.02
        pgm_function60[(5, 35, 4)] = 0.02
        pgm_function60[(5, 35, 5)] = 0.02
        pgm_function60[(5, 36, 1)] = 0.02
        pgm_function60[(5, 36, 2)] = 0.02
        pgm_function60[(5, 36, 3)] = 0.02
        pgm_function60[(5, 36, 4)] = 0.02
        pgm_function60[(5, 36, 5)] = 0.02
        pgm_function60[(5, 37, 1)] = 0.02
        pgm_function60[(5, 37, 2)] = 0.02
        pgm_function60[(5, 37, 3)] = 0.02
        pgm_function60[(5, 37, 4)] = 0.02
        pgm_function60[(5, 37, 5)] = 0.02
        pgm_function60[(5, 38, 1)] = 0.02
        pgm_function60[(5, 38, 2)] = 0.02
        pgm_function60[(5, 38, 3)] = 0.02
        pgm_function60[(5, 38, 4)] = 0.02
        pgm_function60[(5, 38, 5)] = 0.02
        pgm_function60[(5, 39, 1)] = 0.05
        pgm_function60[(5, 39, 2)] = 0.05
        pgm_function60[(5, 39, 3)] = 0.05
        pgm_function60[(5, 39, 4)] = 0.05
        pgm_function60[(5, 39, 5)] = 0.05
        pgm_function60[(5, 40, 1)] = 0.02
        pgm_function60[(5, 40, 2)] = 0.02
        pgm_function60[(5, 40, 3)] = 0.02
        pgm_function60[(5, 40, 4)] = 0.02
        pgm_function60[(5, 40, 5)] = 0.02
        pgm_function60[(5, 41, 1)] = 0.02
        pgm_function60[(5, 41, 2)] = 0.02
        pgm_function60[(5, 41, 3)] = 0.02
        pgm_function60[(5, 41, 4)] = 0.02
        pgm_function60[(5, 41, 5)] = 0.02
        pgm_function60[(5, 42, 1)] = 0.02
        pgm_function60[(5, 42, 2)] = 0.02
        pgm_function60[(5, 42, 3)] = 0.02
        pgm_function60[(5, 42, 4)] = 0.02
        pgm_function60[(5, 42, 5)] = 0.02
        pgm_function60[(5, 43, 1)] = 0.02
        pgm_function60[(5, 43, 2)] = 0.02
        pgm_function60[(5, 43, 3)] = 0.02
        pgm_function60[(5, 43, 4)] = 0.02
        pgm_function60[(5, 43, 5)] = 0.02
        pgm_function60[(5, 44, 1)] = 0.05
        pgm_function60[(5, 44, 2)] = 0.05
        pgm_function60[(5, 44, 3)] = 0.05
        pgm_function60[(5, 44, 4)] = 0.05
        pgm_function60[(5, 44, 5)] = 0.05
        pgm_function60[(5, 45, 1)] = 0.05
        pgm_function60[(5, 45, 2)] = 0.05
        pgm_function60[(5, 45, 3)] = 0.05
        pgm_function60[(5, 45, 4)] = 0.05
        pgm_function60[(5, 45, 5)] = 0.05
        pgm_function60[(5, 46, 1)] = 0.05
        pgm_function60[(5, 46, 2)] = 0.05
        pgm_function60[(5, 46, 3)] = 0.05
        pgm_function60[(5, 46, 4)] = 0.05
        pgm_function60[(5, 46, 5)] = 0.05
        pgm_function60[(5, 47, 1)] = 0.02
        pgm_function60[(5, 47, 2)] = 0.02
        pgm_function60[(5, 47, 3)] = 0.02
        pgm_function60[(5, 47, 4)] = 0.02
        pgm_function60[(5, 47, 5)] = 0.02
        pgm_function60[(5, 48, 1)] = 0.02
        pgm_function60[(5, 48, 2)] = 0.02
        pgm_function60[(5, 48, 3)] = 0.02
        pgm_function60[(5, 48, 4)] = 0.02
        pgm_function60[(5, 48, 5)] = 0.02
        pgm_function60[(5, 49, 1)] = 0.02
        pgm_function60[(5, 49, 2)] = 0.02
        pgm_function60[(5, 49, 3)] = 0.02
        pgm_function60[(5, 49, 4)] = 0.02
        pgm_function60[(5, 49, 5)] = 0.02
        pgm_function60[(5, 50, 1)] = 0.02
        pgm_function60[(5, 50, 2)] = 0.02
        pgm_function60[(5, 50, 3)] = 0.02
        pgm_function60[(5, 50, 4)] = 0.02
        pgm_function60[(5, 50, 5)] = 0.02
        pgm_function60[(5, 51, 1)] = 0.02
        pgm_function60[(5, 51, 2)] = 0.02
        pgm_function60[(5, 51, 3)] = 0.02
        pgm_function60[(5, 51, 4)] = 0.02
        pgm_function60[(5, 51, 5)] = 0.02
        pgm_function60[(5, 52, 1)] = 0.48
        pgm_function60[(5, 52, 2)] = 0.48
        pgm_function60[(5, 52, 3)] = 0.48
        pgm_function60[(5, 52, 4)] = 0.48
        pgm_function60[(5, 52, 5)] = 0.48
        pgm_function60[(5, 53, 1)] = 0.02
        pgm_function60[(5, 53, 2)] = 0.02
        pgm_function60[(5, 53, 3)] = 0.02
        pgm_function60[(5, 53, 4)] = 0.02
        pgm_function60[(5, 53, 5)] = 0.02
        pgm_function60[(5, 54, 1)] = 0.02
        pgm_function60[(5, 54, 2)] = 0.02
        pgm_function60[(5, 54, 3)] = 0.02
        pgm_function60[(5, 54, 4)] = 0.02
        pgm_function60[(5, 54, 5)] = 0.02
        pgm_function60[(5, 55, 1)] = 0.02
        pgm_function60[(5, 55, 2)] = 0.02
        pgm_function60[(5, 55, 3)] = 0.02
        pgm_function60[(5, 55, 4)] = 0.02
        pgm_function60[(5, 55, 5)] = 0.02
        pgm_function60[(5, 56, 1)] = 0.02
        pgm_function60[(5, 56, 2)] = 0.02
        pgm_function60[(5, 56, 3)] = 0.02
        pgm_function60[(5, 56, 4)] = 0.02
        pgm_function60[(5, 56, 5)] = 0.02
        pgm_function60[(5, 57, 1)] = 0.05
        pgm_function60[(5, 57, 2)] = 0.05
        pgm_function60[(5, 57, 3)] = 0.05
        pgm_function60[(5, 57, 4)] = 0.05
        pgm_function60[(5, 57, 5)] = 0.05
        pgm_function60[(5, 58, 1)] = 0.1666667
        pgm_function60[(5, 58, 2)] = 0.2
        pgm_function60[(5, 58, 3)] = 0.2
        pgm_function60[(5, 58, 4)] = 0.2
        pgm_function60[(5, 58, 5)] = 0.2
        pgm_function60[(5, 59, 1)] = 0.05
        pgm_function60[(5, 59, 2)] = 0.05
        pgm_function60[(5, 59, 3)] = 0.05
        pgm_function60[(5, 59, 4)] = 0.05
        pgm_function60[(5, 59, 5)] = 0.05
        pgm_function60[(5, 60, 1)] = 0.02
        pgm_function60[(5, 60, 2)] = 0.02
        pgm_function60[(5, 60, 3)] = 0.02
        pgm_function60[(5, 60, 4)] = 0.02
        pgm_function60[(5, 60, 5)] = 0.02
        pgm_function60[(5, 61, 1)] = 0.05
        pgm_function60[(5, 61, 2)] = 0.05
        pgm_function60[(5, 61, 3)] = 0.05
        pgm_function60[(5, 61, 4)] = 0.05
        pgm_function60[(5, 61, 5)] = 0.05
        pgm_function60[(5, 62, 1)] = 0.02
        pgm_function60[(5, 62, 2)] = 0.02
        pgm_function60[(5, 62, 3)] = 0.02
        pgm_function60[(5, 62, 4)] = 0.02
        pgm_function60[(5, 62, 5)] = 0.02
        pgm_function60[(5, 63, 1)] = 0.05
        pgm_function60[(5, 63, 2)] = 0.05
        pgm_function60[(5, 63, 3)] = 0.05
        pgm_function60[(5, 63, 4)] = 0.05
        pgm_function60[(5, 63, 5)] = 0.05
        pgm_function60[(5, 64, 1)] = 0.02
        pgm_function60[(5, 64, 2)] = 0.02
        pgm_function60[(5, 64, 3)] = 0.02
        pgm_function60[(5, 64, 4)] = 0.02
        pgm_function60[(5, 64, 5)] = 0.02
        pgm_function60[(5, 65, 1)] = 0.02
        pgm_function60[(5, 65, 2)] = 0.02
        pgm_function60[(5, 65, 3)] = 0.02
        pgm_function60[(5, 65, 4)] = 0.02
        pgm_function60[(5, 65, 5)] = 0.02
        pgm_function60[(5, 66, 1)] = 0.05
        pgm_function60[(5, 66, 2)] = 0.05
        pgm_function60[(5, 66, 3)] = 0.05
        pgm_function60[(5, 66, 4)] = 0.05
        pgm_function60[(5, 66, 5)] = 0.05
        pgm_function60[(5, 67, 1)] = 0.02
        pgm_function60[(5, 67, 2)] = 0.02
        pgm_function60[(5, 67, 3)] = 0.02
        pgm_function60[(5, 67, 4)] = 0.02
        pgm_function60[(5, 67, 5)] = 0.02
        pgm_function60[(5, 68, 1)] = 0.02
        pgm_function60[(5, 68, 2)] = 0.02
        pgm_function60[(5, 68, 3)] = 0.02
        pgm_function60[(5, 68, 4)] = 0.02
        pgm_function60[(5, 68, 5)] = 0.02
        pgm_function60[(5, 69, 1)] = 0.02
        pgm_function60[(5, 69, 2)] = 0.02
        pgm_function60[(5, 69, 3)] = 0.02
        pgm_function60[(5, 69, 4)] = 0.02
        pgm_function60[(5, 69, 5)] = 0.02
        pgm_function60[(5, 70, 1)] = 0.05
        pgm_function60[(5, 70, 2)] = 0.05
        pgm_function60[(5, 70, 3)] = 0.05
        pgm_function60[(5, 70, 4)] = 0.05
        pgm_function60[(5, 70, 5)] = 0.05
        pgm_function60[(5, 71, 1)] = 0.05
        pgm_function60[(5, 71, 2)] = 0.05
        pgm_function60[(5, 71, 3)] = 0.05
        pgm_function60[(5, 71, 4)] = 0.05
        pgm_function60[(5, 71, 5)] = 0.05
        pgm_function60[(5, 72, 1)] = 0.05
        pgm_function60[(5, 72, 2)] = 0.05
        pgm_function60[(5, 72, 3)] = 0.05
        pgm_function60[(5, 72, 4)] = 0.05
        pgm_function60[(5, 72, 5)] = 0.05
        pgm_function60[(5, 73, 1)] = 0.02
        pgm_function60[(5, 73, 2)] = 0.02
        pgm_function60[(5, 73, 3)] = 0.02
        pgm_function60[(5, 73, 4)] = 0.02
        pgm_function60[(5, 73, 5)] = 0.02
        pgm_function60[(5, 74, 1)] = 0.02
        pgm_function60[(5, 74, 2)] = 0.02
        pgm_function60[(5, 74, 3)] = 0.02
        pgm_function60[(5, 74, 4)] = 0.02
        pgm_function60[(5, 74, 5)] = 0.02
        pgm_function60[(5, 75, 1)] = 0.02
        pgm_function60[(5, 75, 2)] = 0.02
        pgm_function60[(5, 75, 3)] = 0.02
        pgm_function60[(5, 75, 4)] = 0.02
        pgm_function60[(5, 75, 5)] = 0.02

        pgm_function61 = pgm_factor61.set_sparse()
        pgm_function61[(0, 0)] = 1.0
        pgm_function61[(0, 1)] = 1.0
        pgm_function61[(0, 2)] = 1.0
        pgm_function61[(0, 3)] = 1.0
        pgm_function61[(0, 4)] = 1.0
        pgm_function61[(0, 5)] = 1.0
        pgm_function61[(0, 6)] = 1.0
        pgm_function61[(0, 7)] = 1.0
        pgm_function61[(0, 8)] = 1.0
        pgm_function61[(0, 9)] = 1.0
        pgm_function61[(0, 10)] = 1.0
        pgm_function61[(0, 11)] = 1.0
        pgm_function61[(0, 12)] = 1.0
        pgm_function61[(0, 13)] = 1.0
        pgm_function61[(0, 14)] = 1.0
        pgm_function61[(0, 15)] = 1.0
        pgm_function61[(0, 16)] = 1.0
        pgm_function61[(0, 17)] = 1.0
        pgm_function61[(0, 18)] = 1.0
        pgm_function61[(0, 19)] = 1.0
        pgm_function61[(0, 20)] = 1.0
        pgm_function61[(0, 21)] = 1.0
        pgm_function61[(0, 22)] = 1.0
        pgm_function61[(0, 23)] = 1.0
        pgm_function61[(0, 24)] = 1.0
        pgm_function61[(0, 25)] = 1.0
        pgm_function61[(0, 26)] = 1.0
        pgm_function61[(0, 27)] = 0.74
        pgm_function61[(0, 28)] = 0.74
        pgm_function61[(0, 29)] = 0.74
        pgm_function61[(0, 30)] = 0.98990101
        pgm_function61[(0, 31)] = 0.98990101
        pgm_function61[(0, 32)] = 0.01
        pgm_function61[(0, 34)] = 1.0
        pgm_function61[(0, 35)] = 1.0
        pgm_function61[(0, 36)] = 1.0
        pgm_function61[(0, 37)] = 1.0
        pgm_function61[(0, 38)] = 1.0
        pgm_function61[(0, 39)] = 1.0
        pgm_function61[(0, 40)] = 1.0
        pgm_function61[(0, 41)] = 1.0
        pgm_function61[(0, 42)] = 1.0
        pgm_function61[(0, 43)] = 1.0
        pgm_function61[(0, 44)] = 0.97
        pgm_function61[(0, 45)] = 0.97
        pgm_function61[(0, 46)] = 1.0
        pgm_function61[(0, 47)] = 0.9589
        pgm_function61[(0, 48)] = 1.0
        pgm_function61[(0, 49)] = 1.0
        pgm_function61[(0, 50)] = 0.9299
        pgm_function61[(0, 51)] = 0.9299
        pgm_function61[(0, 52)] = 1.0
        pgm_function61[(0, 53)] = 1.0
        pgm_function61[(0, 54)] = 1.0
        pgm_function61[(0, 55)] = 1.0
        pgm_function61[(0, 56)] = 0.96
        pgm_function61[(0, 57)] = 1.0
        pgm_function61[(0, 58)] = 1.0
        pgm_function61[(0, 59)] = 1.0
        pgm_function61[(0, 60)] = 1.0
        pgm_function61[(0, 61)] = 1.0
        pgm_function61[(0, 62)] = 0.97
        pgm_function61[(0, 63)] = 1.0
        pgm_function61[(0, 64)] = 0.96
        pgm_function61[(0, 65)] = 1.0
        pgm_function61[(0, 66)] = 1.0
        pgm_function61[(0, 67)] = 1.0
        pgm_function61[(0, 68)] = 1.0
        pgm_function61[(0, 69)] = 1.0
        pgm_function61[(0, 70)] = 1.0
        pgm_function61[(0, 71)] = 1.0
        pgm_function61[(0, 72)] = 1.0
        pgm_function61[(0, 73)] = 1.0
        pgm_function61[(0, 74)] = 0.9299
        pgm_function61[(0, 75)] = 1.0
        pgm_function61[(1, 27)] = 0.2
        pgm_function61[(1, 28)] = 0.2
        pgm_function61[(1, 29)] = 0.2
        pgm_function61[(1, 30)] = 0.009999
        pgm_function61[(1, 31)] = 0.009999
        pgm_function61[(1, 32)] = 0.6
        pgm_function61[(1, 44)] = 0.02
        pgm_function61[(1, 45)] = 0.02
        pgm_function61[(1, 47)] = 0.03
        pgm_function61[(1, 50)] = 0.05
        pgm_function61[(1, 51)] = 0.05
        pgm_function61[(1, 56)] = 0.02
        pgm_function61[(1, 62)] = 0.02
        pgm_function61[(1, 64)] = 0.02
        pgm_function61[(1, 74)] = 0.05
        pgm_function61[(2, 27)] = 0.05
        pgm_function61[(2, 28)] = 0.05
        pgm_function61[(2, 29)] = 0.05
        pgm_function61[(2, 30)] = 9.999e-05
        pgm_function61[(2, 31)] = 9.999e-05
        pgm_function61[(2, 32)] = 0.38
        pgm_function61[(2, 33)] = 0.2
        pgm_function61[(2, 44)] = 0.01
        pgm_