"use strict";
const cdk = require("../lib");
const util_1 = require("./util");
module.exports = {
    'chain conditions'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const param = new cdk.CfnParameter(stack, 'Param1', { type: 'String' });
        const cond1 = new cdk.CfnCondition(stack, 'Condition1', { expression: cdk.Fn.conditionEquals("a", "b") });
        const cond2 = new cdk.CfnCondition(stack, 'Condition2', { expression: cdk.Fn.conditionContains(["a", "b", "c"], "c") });
        const cond3 = new cdk.CfnCondition(stack, 'Condition3', { expression: cdk.Fn.conditionEquals(param, "hello") });
        // WHEN
        new cdk.CfnCondition(stack, 'Condition4', {
            expression: cdk.Fn.conditionOr(cond1, cond2, cdk.Fn.conditionNot(cond3))
        });
        // THEN
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: { Param1: { Type: 'String' } },
            Conditions: {
                Condition1: { 'Fn::Equals': ['a', 'b'] },
                Condition2: { 'Fn::Contains': [['a', 'b', 'c'], 'c'] },
                Condition3: { 'Fn::Equals': [{ Ref: 'Param1' }, 'hello'] },
                Condition4: { 'Fn::Or': [
                        { Condition: 'Condition1' },
                        { Condition: 'Condition2' },
                        { 'Fn::Not': [{ Condition: 'Condition3' }] }
                    ] }
            }
        });
        test.done();
    },
    'condition expressions can be embedded as strings'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const propValue = cdk.Fn.conditionIf('Cond', 'A', 'B').toString();
        // WHEN
        new cdk.CfnResource(stack, 'MyResource', {
            type: 'AWS::Foo::Bar',
            properties: {
                StringProp: propValue
            }
        });
        // THEN
        test.ok(cdk.Token.isUnresolved(propValue));
        test.deepEqual(util_1.toCloudFormation(stack), {
            Resources: {
                MyResource: {
                    Type: 'AWS::Foo::Bar',
                    Properties: {
                        StringProp: { 'Fn::If': ['Cond', 'A', 'B'] }
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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