"""
Binance Sub Account REST API

OpenAPI Specification for the Binance Sub Account REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import List, Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import FuturesTransferForSubAccountResponse
from ..models import GetDetailOnSubAccountsFuturesAccountResponse
from ..models import GetDetailOnSubAccountsFuturesAccountV2Response
from ..models import GetDetailOnSubAccountsMarginAccountResponse
from ..models import GetMovePositionHistoryForSubAccountResponse
from ..models import GetSubAccountDepositAddressResponse
from ..models import GetSubAccountDepositHistoryResponse
from ..models import GetSummaryOfSubAccountsFuturesAccountResponse
from ..models import GetSummaryOfSubAccountsFuturesAccountV2Response
from ..models import GetSummaryOfSubAccountsMarginAccountResponse
from ..models import MarginTransferForSubAccountResponse
from ..models import MovePositionForSubAccountResponse
from ..models import QuerySubAccountAssetsResponse
from ..models import QuerySubAccountAssetsAssetManagementResponse
from ..models import QuerySubAccountFuturesAssetTransferHistoryResponse
from ..models import QuerySubAccountSpotAssetTransferHistoryResponse
from ..models import QuerySubAccountSpotAssetsSummaryResponse
from ..models import QueryUniversalTransferHistoryResponse
from ..models import SubAccountFuturesAssetTransferResponse
from ..models import SubAccountTransferHistoryResponse
from ..models import TransferToMasterResponse
from ..models import TransferToSubAccountOfSameMasterResponse
from ..models import UniversalTransferResponse


class AssetManagementApi:
    """API Client for AssetManagementApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def futures_transfer_for_sub_account(
        self,
        email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        type: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesTransferForSubAccountResponse]:
        """
                Futures Transfer for Sub-account (For Master Account) (USER_DATA)
                POST /sapi/v1/sub-account/futures/transfer
                https://developers.binance.com/docs/sub_account/asset-management/Futures-Transfer-for-Sub-account

                Futures Transfer for Sub-account

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    type (Union[int, None]): 1: transfer from subaccount's  spot account to margin account 2: transfer from subaccount's margin account to its spot account
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesTransferForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )
        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )

        payload = {
            "email": email,
            "asset": asset,
            "amount": amount,
            "type": type,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/futures/transfer",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=FuturesTransferForSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_detail_on_sub_accounts_futures_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDetailOnSubAccountsFuturesAccountResponse]:
        """
                Get Detail on Sub-account's Futures Account (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/futures/account
                https://developers.binance.com/docs/sub_account/asset-management/Get-Detail-on-Sub-accounts-Futures-Account

                Get Detail on Sub-account's Futures Account

        Weight: 10

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDetailOnSubAccountsFuturesAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/futures/account",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetDetailOnSubAccountsFuturesAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_detail_on_sub_accounts_futures_account_v2(
        self,
        email: Union[str, None],
        futures_type: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDetailOnSubAccountsFuturesAccountV2Response]:
        """
                Get Detail on Sub-account's Futures Account V2 (For Master Account) (USER_DATA)
                GET /sapi/v2/sub-account/futures/account
                https://developers.binance.com/docs/sub_account/asset-management/Get-Detail-on-Sub-accounts-Futures-Account-V2

                Get Detail on Sub-account's Futures Account

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDetailOnSubAccountsFuturesAccountV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if futures_type is None:
            raise RequiredError(
                field="futures_type",
                error_message="Missing required parameter 'futures_type'",
            )

        payload = {
            "email": email,
            "futures_type": futures_type,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/sub-account/futures/account",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetDetailOnSubAccountsFuturesAccountV2Response,
            is_signed=True,
            signer=self._signer,
        )

    def get_detail_on_sub_accounts_margin_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDetailOnSubAccountsMarginAccountResponse]:
        """
                Get Detail on Sub-account's Margin Account (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/margin/account
                https://developers.binance.com/docs/sub_account/asset-management/Get-Detail-on-Sub-accounts-Margin-Account

                Get Detail on Sub-account's Margin Account

        Weight: 10

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDetailOnSubAccountsMarginAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/margin/account",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetDetailOnSubAccountsMarginAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_move_position_history_for_sub_account(
        self,
        symbol: Union[str, None],
        page: Union[int, None],
        row: Union[int, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetMovePositionHistoryForSubAccountResponse]:
        """
                Get Move Position History for Sub-account (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/futures/move-position
                https://developers.binance.com/docs/sub_account/asset-management/Get-Move-Position-History-for-Sub-account

                Query move position history

        * If `startTime` and `endTime` not sent, return records of the last 90 days by default with 1000 maximum limits
        * If `startTime` is sent and `endTime` is not sent, return records of [max(startTime, now-90d), now].
        * If `startTime` is not sent and `endTime` is sent, return records of [max(now,endTime-90d), endTime].

        Weight: 150

                Args:
                    symbol (Union[str, None]):
                    page (Union[int, None]): Page
                    row (Union[int, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetMovePositionHistoryForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if page is None:
            raise RequiredError(
                field="page", error_message="Missing required parameter 'page'"
            )
        if row is None:
            raise RequiredError(
                field="row", error_message="Missing required parameter 'row'"
            )

        payload = {
            "symbol": symbol,
            "page": page,
            "row": row,
            "start_time": start_time,
            "end_time": end_time,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/futures/move-position",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetMovePositionHistoryForSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_sub_account_deposit_address(
        self,
        email: Union[str, None],
        coin: Union[str, None],
        network: Optional[str] = None,
        amount: Optional[float] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSubAccountDepositAddressResponse]:
        """
                Get Sub-account Deposit Address (For Master Account) (USER_DATA)
                GET /sapi/v1/capital/deposit/subAddress
                https://developers.binance.com/docs/sub_account/asset-management/Get-Sub-account-Deposit-Address

                Fetch sub-account deposit address

        * `amount` needs to be sent if using LIGHTNING network

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    coin (Union[str, None]):
                    network (Optional[str] = None): networks can be found in `GET /sapi/v1/capital/deposit/address`
                    amount (Optional[float] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSubAccountDepositAddressResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if coin is None:
            raise RequiredError(
                field="coin", error_message="Missing required parameter 'coin'"
            )

        payload = {
            "email": email,
            "coin": coin,
            "network": network,
            "amount": amount,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/capital/deposit/subAddress",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetSubAccountDepositAddressResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_sub_account_deposit_history(
        self,
        email: Union[str, None],
        coin: Optional[str] = None,
        status: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        recv_window: Optional[int] = None,
        tx_id: Optional[str] = None,
    ) -> ApiResponse[GetSubAccountDepositHistoryResponse]:
        """
                Get Sub-account Deposit History (For Master Account) (USER_DATA)
                GET /sapi/v1/capital/deposit/subHisrec
                https://developers.binance.com/docs/sub_account/asset-management/Get-Sub-account-Deposit-History

                Fetch sub-account deposit history

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    coin (Optional[str] = None):
                    status (Optional[int] = None): 0(0:pending,6: credited but cannot withdraw,7:Wrong Deposit,8:Waiting User confirm,1:success)
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    offset (Optional[int] = None): default:0
                    recv_window (Optional[int] = None):
                    tx_id (Optional[str] = None):

                Returns:
                    ApiResponse[GetSubAccountDepositHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {
            "email": email,
            "coin": coin,
            "status": status,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "offset": offset,
            "recv_window": recv_window,
            "tx_id": tx_id,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/capital/deposit/subHisrec",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetSubAccountDepositHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_summary_of_sub_accounts_futures_account(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSummaryOfSubAccountsFuturesAccountResponse]:
        """
                Get Summary of Sub-account's Futures Account (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/futures/accountSummary
                https://developers.binance.com/docs/sub_account/asset-management/Get-Summary-of-Sub-accounts-Futures-Account

                Get Summary of Sub-account's Futures Account

        Weight: 1

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSummaryOfSubAccountsFuturesAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/futures/accountSummary",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetSummaryOfSubAccountsFuturesAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_summary_of_sub_accounts_futures_account_v2(
        self,
        futures_type: Union[int, None],
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSummaryOfSubAccountsFuturesAccountV2Response]:
        """
                Get Summary of Sub-account's Futures Account V2 (For Master Account) (USER_DATA)
                GET /sapi/v2/sub-account/futures/accountSummary
                https://developers.binance.com/docs/sub_account/asset-management/Get-Summary-of-Sub-accounts-Futures-Account-V2

                Get Summary of Sub-account's Futures Account

        Weight: 10

                Args:
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSummaryOfSubAccountsFuturesAccountV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if futures_type is None:
            raise RequiredError(
                field="futures_type",
                error_message="Missing required parameter 'futures_type'",
            )

        payload = {
            "futures_type": futures_type,
            "page": page,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/sub-account/futures/accountSummary",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetSummaryOfSubAccountsFuturesAccountV2Response,
            is_signed=True,
            signer=self._signer,
        )

    def get_summary_of_sub_accounts_margin_account(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSummaryOfSubAccountsMarginAccountResponse]:
        """
                Get Summary of Sub-account's Margin Account (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/margin/accountSummary
                https://developers.binance.com/docs/sub_account/asset-management/Get-Summary-of-Sub-accounts-Margin-Account

                Get Summary of Sub-account's Margin Account

        Weight: 10

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSummaryOfSubAccountsMarginAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/margin/accountSummary",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetSummaryOfSubAccountsMarginAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def margin_transfer_for_sub_account(
        self,
        email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        type: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[MarginTransferForSubAccountResponse]:
        """
                Margin Transfer for Sub-account (For Master Account) (USER_DATA)
                POST /sapi/v1/sub-account/margin/transfer
                https://developers.binance.com/docs/sub_account/asset-management/Margin-Transfer-for-Sub-account

                Margin Transfer for Sub-account

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    type (Union[int, None]): 1: transfer from subaccount's  spot account to margin account 2: transfer from subaccount's margin account to its spot account
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[MarginTransferForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )
        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )

        payload = {
            "email": email,
            "asset": asset,
            "amount": amount,
            "type": type,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/margin/transfer",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=MarginTransferForSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def move_position_for_sub_account(
        self,
        from_user_email: Union[str, None],
        to_user_email: Union[str, None],
        product_type: Union[str, None],
        order_args: Union[List[object], None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[MovePositionForSubAccountResponse]:
        """
                Move Position for Sub-account (For Master Account) (USER_DATA)
                POST /sapi/v1/sub-account/futures/move-position
                https://developers.binance.com/docs/sub_account/asset-management/Move-Position-for-Sub-account

                Move position between sub-master, master-sub, or sub-sub accounts when necessary

        * You need to Enable Trading permission for the API Key which requests this endpoint.
        * This function only support VIP level 7-9.
        * Only master account can use the function
        * Quantity should be positive number only
        * The function support normal account, PM PRO and PM PRO SPAN.
        * Only support for from account has positions
        * For all orders in the same orderArgs request, if any symbol’s total close position quantity is bigger than the symbol’s current position quantity, all batch orders in the same list will fail simultaneously.
        * Only support cross margin mode
        * The price for move position is MarkPrice only.
        * Not support for MSA.
        * Not support for the symbol under Reduce-Only.

        Weight: 150

                Args:
                    from_user_email (Union[str, None]):
                    to_user_email (Union[str, None]):
                    product_type (Union[str, None]): Only support UM
                    order_args (Union[List[object], None]): Max 10 positions supported. When input request parameter,orderArgs.symbol should be STRING, orderArgs.quantity should be BIGDECIMAL, and orderArgs.positionSide should be STRING, positionSide support BOTH,LONG and SHORT. Each entry should be like orderArgs[0].symbol=BTCUSDT,orderArgs[0].quantity=0.001,orderArgs[0].positionSide=BOTH. Example of the request parameter array: orderArgs[0].symbol=BTCUSDT orderArgs[0].quantity=0.001 orderArgs[0].positionSide=BOTH orderArgs[1].symbol=ETHUSDT orderArgs[1].quantity=0.01 orderArgs[1].positionSide=BOTH
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[MovePositionForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if from_user_email is None:
            raise RequiredError(
                field="from_user_email",
                error_message="Missing required parameter 'from_user_email'",
            )
        if to_user_email is None:
            raise RequiredError(
                field="to_user_email",
                error_message="Missing required parameter 'to_user_email'",
            )
        if product_type is None:
            raise RequiredError(
                field="product_type",
                error_message="Missing required parameter 'product_type'",
            )
        if order_args is None:
            raise RequiredError(
                field="order_args",
                error_message="Missing required parameter 'order_args'",
            )

        payload = {
            "from_user_email": from_user_email,
            "to_user_email": to_user_email,
            "product_type": product_type,
            "order_args": order_args,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/futures/move-position",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=MovePositionForSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_sub_account_assets(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountAssetsResponse]:
        """
                Query Sub-account Assets (For Master Account) (USER_DATA)
                GET /sapi/v3/sub-account/assets
                https://developers.binance.com/docs/sub_account/asset-management/Query-Sub-account-Assets-V4

                Fetch sub-account assets

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountAssetsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v3/sub-account/assets",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuerySubAccountAssetsResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_sub_account_assets_asset_management(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountAssetsAssetManagementResponse]:
        """
                Query Sub-account Assets (For Master Account) (USER_DATA)
                GET /sapi/v4/sub-account/assets
                https://developers.binance.com/docs/sub_account/asset-management/Query-Sub-account-Assets-V4

                Fetch sub-account assets

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountAssetsAssetManagementResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v4/sub-account/assets",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuerySubAccountAssetsAssetManagementResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_sub_account_futures_asset_transfer_history(
        self,
        email: Union[str, None],
        futures_type: Union[int, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountFuturesAssetTransferHistoryResponse]:
        """
                Query Sub-account Futures Asset Transfer History (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/futures/internalTransfer
                https://developers.binance.com/docs/sub_account/asset-management/Query-Sub-account-Futures-Asset-Transfer-History

                Query Sub-account Futures Asset Transfer History

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountFuturesAssetTransferHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if futures_type is None:
            raise RequiredError(
                field="futures_type",
                error_message="Missing required parameter 'futures_type'",
            )

        payload = {
            "email": email,
            "futures_type": futures_type,
            "start_time": start_time,
            "end_time": end_time,
            "page": page,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/futures/internalTransfer",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuerySubAccountFuturesAssetTransferHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_sub_account_spot_asset_transfer_history(
        self,
        from_email: Optional[str] = None,
        to_email: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountSpotAssetTransferHistoryResponse]:
        """
                Query Sub-account Spot Asset Transfer History (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/sub/transfer/history
                https://developers.binance.com/docs/sub_account/asset-management/Query-Sub-account-Spot-Asset-Transfer-History

                Query Sub-account Spot Asset Transfer History

        * fromEmail and toEmail cannot be sent at the same time.
        * Return fromEmail equal master account email by default.

        Weight: 1

                Args:
                    from_email (Optional[str] = None):
                    to_email (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountSpotAssetTransferHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "from_email": from_email,
            "to_email": to_email,
            "start_time": start_time,
            "end_time": end_time,
            "page": page,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/sub/transfer/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuerySubAccountSpotAssetTransferHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_sub_account_spot_assets_summary(
        self,
        email: Optional[str] = None,
        page: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountSpotAssetsSummaryResponse]:
        """
                Query Sub-account Spot Assets Summary (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/spotSummary
                https://developers.binance.com/docs/sub_account/asset-management/Query-Sub-account-Spot-Assets-Summary

                Get BTC valued asset summary of subaccounts.

        Weight: 1

                Args:
                    email (Optional[str] = None): Managed sub-account email
                    page (Optional[int] = None): Default value: 1
                    size (Optional[int] = None): default 10, max 20
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountSpotAssetsSummaryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "email": email,
            "page": page,
            "size": size,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/spotSummary",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuerySubAccountSpotAssetsSummaryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_universal_transfer_history(
        self,
        from_email: Optional[str] = None,
        to_email: Optional[str] = None,
        client_tran_id: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryUniversalTransferHistoryResponse]:
        """
                Query Universal Transfer History (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/universalTransfer
                https://developers.binance.com/docs/sub_account/asset-management/Query-Universal-Transfer-History

                Query Universal Transfer History

        * fromEmail and toEmail cannot be sent at the same time.
        * Return fromEmail equal master account email by default.
        * The query time period must be less than 7 days.
        * If startTime and endTime not sent, return records of the last 7 days by default.

        Weight: 1

                Args:
                    from_email (Optional[str] = None):
                    to_email (Optional[str] = None):
                    client_tran_id (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryUniversalTransferHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "from_email": from_email,
            "to_email": to_email,
            "client_tran_id": client_tran_id,
            "start_time": start_time,
            "end_time": end_time,
            "page": page,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/universalTransfer",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryUniversalTransferHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def sub_account_futures_asset_transfer(
        self,
        from_email: Union[str, None],
        to_email: Union[str, None],
        futures_type: Union[int, None],
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubAccountFuturesAssetTransferResponse]:
        """
                Sub-account Futures Asset Transfer (For Master Account) (USER_DATA)
                POST /sapi/v1/sub-account/futures/internalTransfer
                https://developers.binance.com/docs/sub_account/asset-management/Sub-account-Futures-Asset-Transfer

                Sub-account Futures Asset Transfer


        * Master account can transfer max 2000 times a minute
        * There must be sufficient margin balance in futures wallet to execute transferring.

        Weight: 1

                Args:
                    from_email (Union[str, None]):
                    to_email (Union[str, None]):
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubAccountFuturesAssetTransferResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if from_email is None:
            raise RequiredError(
                field="from_email",
                error_message="Missing required parameter 'from_email'",
            )
        if to_email is None:
            raise RequiredError(
                field="to_email", error_message="Missing required parameter 'to_email'"
            )
        if futures_type is None:
            raise RequiredError(
                field="futures_type",
                error_message="Missing required parameter 'futures_type'",
            )
        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "from_email": from_email,
            "to_email": to_email,
            "futures_type": futures_type,
            "asset": asset,
            "amount": amount,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/futures/internalTransfer",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SubAccountFuturesAssetTransferResponse,
            is_signed=True,
            signer=self._signer,
        )

    def sub_account_transfer_history(
        self,
        asset: Optional[str] = None,
        type: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        return_fail_history: Optional[bool] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubAccountTransferHistoryResponse]:
        """
                Sub-account Transfer History (For Sub-account) (USER_DATA)
                GET /sapi/v1/sub-account/transfer/subUserHistory
                https://developers.binance.com/docs/sub_account/asset-management/Sub-account-Transfer-History

                Sub-account Transfer History

        * If type is not sent, the records of type 2: transfer out will be returned by default.
        * If startTime and endTime are not sent, the recent 30-day data will be returned.

        Weight: 1

                Args:
                    asset (Optional[str] = None): If not sent, result of all assets will be returned
                    type (Optional[int] = None): 1: transfer in, 2: transfer out
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    return_fail_history (Optional[bool] = None): Default `False`, return PROCESS and SUCCESS status history; If `True`,return PROCESS and SUCCESS and FAILURE status history
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubAccountTransferHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "asset": asset,
            "type": type,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "return_fail_history": return_fail_history,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/transfer/subUserHistory",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SubAccountTransferHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def transfer_to_master(
        self,
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[TransferToMasterResponse]:
        """
                Transfer to Master (For Sub-account) (USER_DATA)
                POST /sapi/v1/sub-account/transfer/subToMaster
                https://developers.binance.com/docs/sub_account/asset-management/Transfer-to-Master

                Transfer to Master

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[TransferToMasterResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {"asset": asset, "amount": amount, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/transfer/subToMaster",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=TransferToMasterResponse,
            is_signed=True,
            signer=self._signer,
        )

    def transfer_to_sub_account_of_same_master(
        self,
        to_email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[TransferToSubAccountOfSameMasterResponse]:
        """
                Transfer to Sub-account of Same Master (For Sub-account) (USER_DATA)
                POST /sapi/v1/sub-account/transfer/subToSub
                https://developers.binance.com/docs/sub_account/asset-management/Transfer-to-Sub-account-of-Same-Master

                Transfer to Sub-account of Same Master

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    to_email (Union[str, None]):
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[TransferToSubAccountOfSameMasterResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if to_email is None:
            raise RequiredError(
                field="to_email", error_message="Missing required parameter 'to_email'"
            )
        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "to_email": to_email,
            "asset": asset,
            "amount": amount,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/transfer/subToSub",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=TransferToSubAccountOfSameMasterResponse,
            is_signed=True,
            signer=self._signer,
        )

    def universal_transfer(
        self,
        from_account_type: Union[str, None],
        to_account_type: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        from_email: Optional[str] = None,
        to_email: Optional[str] = None,
        client_tran_id: Optional[str] = None,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[UniversalTransferResponse]:
        """
                Universal Transfer (For Master Account) (USER_DATA)
                POST /sapi/v1/sub-account/universalTransfer
                https://developers.binance.com/docs/sub_account/asset-management/Universal-Transfer

                Universal Transfer

        * You need to enable "internal transfer" option for the api key which requests this endpoint.
        * Transfer from master account by default if fromEmail is not sent.
        * Transfer to master account by default if toEmail is not sent.
        * At least either fromEmail or toEmail need to be sent when the fromAccountType and the toAccountType are the same.
        * Supported transfer scenarios:
        * `SPOT` transfer to `SPOT`, `USDT_FUTURE`, `COIN_FUTURE` (regardless of master or sub)
        * `SPOT`, `USDT_FUTURE`, `COIN_FUTURE` transfer to `SPOT`  (regardless of master or sub)
        * Master account `SPOT` transfer to sub-account `MARGIN(Cross)`, `ISOLATED_MARGIN`
        * Sub-account `MARGIN(Cross)`, `ISOLATED_MARGIN` transfer to master account `SPOT`
        * Sub-account `MARGIN(Cross)` transfer to Sub-account `MARGIN(Cross)`
        * `ALPHA` to `ALPHA`  (regardless of master or sub)

        Weight: 360

                Args:
                    from_account_type (Union[str, None]): "SPOT","USDT_FUTURE","COIN_FUTURE","MARGIN"(Cross),"ISOLATED_MARGIN"
                    to_account_type (Union[str, None]): "SPOT","USDT_FUTURE","COIN_FUTURE","MARGIN"(Cross),"ISOLATED_MARGIN"
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    from_email (Optional[str] = None):
                    to_email (Optional[str] = None):
                    client_tran_id (Optional[str] = None):
                    symbol (Optional[str] = None): Only supported under ISOLATED_MARGIN type
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[UniversalTransferResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if from_account_type is None:
            raise RequiredError(
                field="from_account_type",
                error_message="Missing required parameter 'from_account_type'",
            )
        if to_account_type is None:
            raise RequiredError(
                field="to_account_type",
                error_message="Missing required parameter 'to_account_type'",
            )
        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "from_account_type": from_account_type,
            "to_account_type": to_account_type,
            "asset": asset,
            "amount": amount,
            "from_email": from_email,
            "to_email": to_email,
            "client_tran_id": client_tran_id,
            "symbol": symbol,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/universalTransfer",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=UniversalTransferResponse,
            is_signed=True,
            signer=self._signer,
        )
