# coding: utf-8

"""
Binance Sub Account REST API

OpenAPI Specification for the Binance Sub Account REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_sub_account.rest_api.models.get_detail_on_sub_accounts_futures_account_v2_response_delivery_account_resp_assets_inner import (
    GetDetailOnSubAccountsFuturesAccountV2ResponseDeliveryAccountRespAssetsInner,
)
from typing import Set
from typing_extensions import Self


class GetDetailOnSubAccountsFuturesAccountV2ResponseDeliveryAccountResp(BaseModel):
    """
    GetDetailOnSubAccountsFuturesAccountV2ResponseDeliveryAccountResp
    """  # noqa: E501

    email: Optional[StrictStr] = None
    assets: Optional[
        List[
            GetDetailOnSubAccountsFuturesAccountV2ResponseDeliveryAccountRespAssetsInner
        ]
    ] = None
    can_deposit: Optional[StrictBool] = Field(default=None, alias="canDeposit")
    can_trade: Optional[StrictBool] = Field(default=None, alias="canTrade")
    can_withdraw: Optional[StrictBool] = Field(default=None, alias="canWithdraw")
    fee_tier: Optional[StrictInt] = Field(default=None, alias="feeTier")
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "email",
        "assets",
        "canDeposit",
        "canTrade",
        "canWithdraw",
        "feeTier",
        "updateTime",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetDetailOnSubAccountsFuturesAccountV2ResponseDeliveryAccountResp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item_assets in self.assets:
                if _item_assets:
                    _items.append(_item_assets.to_dict())
            _dict["assets"] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetDetailOnSubAccountsFuturesAccountV2ResponseDeliveryAccountResp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "email": obj.get("email"),
                "assets": (
                    [
                        GetDetailOnSubAccountsFuturesAccountV2ResponseDeliveryAccountRespAssetsInner.from_dict(
                            _item
                        )
                        for _item in obj["assets"]
                    ]
                    if obj.get("assets") is not None
                    else None
                ),
                "canDeposit": obj.get("canDeposit"),
                "canTrade": obj.get("canTrade"),
                "canWithdraw": obj.get("canWithdraw"),
                "feeTier": obj.get("feeTier"),
                "updateTime": obj.get("updateTime"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
