"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const intrinsic_1 = require("./private/intrinsic");
/**
 * References a dynamically retrieved value
 *
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
 */
class CfnDynamicReference extends intrinsic_1.Intrinsic {
    constructor(service, key) {
        super('{{resolve:' + service + ':' + key + '}}');
    }
}
exports.CfnDynamicReference = CfnDynamicReference;
/**
 * The service to retrieve the dynamic reference from
 */
var CfnDynamicReferenceService;
(function (CfnDynamicReferenceService) {
    /**
     * Plaintext value stored in AWS Systems Manager Parameter Store
     */
    CfnDynamicReferenceService["SSM"] = "ssm";
    /**
     * Secure string stored in AWS Systems Manager Parameter Store
     */
    CfnDynamicReferenceService["SSM_SECURE"] = "ssm-secure";
    /**
     * Secret stored in AWS Secrets Manager
     */
    CfnDynamicReferenceService["SECRETS_MANAGER"] = "secretsmanager";
})(CfnDynamicReferenceService = exports.CfnDynamicReferenceService || (exports.CfnDynamicReferenceService = {}));
//# sourceMappingURL=data:application/json;base64,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