class TtsLanguages:

    # voices for reference

    # package gtts languages
    # gtts-cli --all
    gtts = {
        "Afrikaans": "af",
        "Arabic": "ar",
        "Bulgarian": "bg",
        "Bengali": "bn",
        "Bosnian": "bs",
        "Catalan": "ca",
        "Czech": "cs",
        "Welsh": "cy",
        "Danish": "da",
        "German": "de",
        "Greek": "el",
        "English": "en",
        "Esperanto": "eo",
        "Spanish": "es",
        "Estonian": "et",
        "Finnish": "fi",
        "French": "fr",
        "Gujarati": "gu",
        "Hebrew": "he",
        "Hindi": "hi",
        "Croatian": "hr",
        "Hungarian": "hu",
        "Armenian": "hy",
        "Indonesian": "id",
        "Icelandic": "is",
        "Italian": "it",
        "Japanese": "ja",
        "Javanese": "jw",
        "Khmer": "km",
        "Kannada": "kn",
        "Korean": "ko",
        "Latin": "la",
        "Latvian": "lv",
        "Macedonian": "mk",
        "Malayalam": "ml",
        "Marathi": "mr",
        "Myanmar (Burmese)": "my",
        "Nepali": "ne",
        "Dutch": "nl",
        "Norwegian": "no",
        "Polish": "pl",
        "Portuguese": "pt",
        "Romanian": "ro",
        "Russian": "ru",
        "Sinhala": "si",
        "Slovak": "sk",
        "Albanian": "sq",
        "Serbian": "sr",
        "Sundanese": "su",
        "Swedish": "sv",
        "Swahili": "sw",
        "Tamil": "ta",
        "Telugu": "te",
        "Thai": "th",
        "Filipino": "tl",
        "Turkish": "tr",
        "Ukrainian": "uk",
        "Urdu": "ur",
        "Vietnamese": "vi",
        "Mandarin": "zh",
    }

    # official google cloud text-to-speech voices
    # https://cloud.google.com/text-to-speech/docs/voices
    gctts = (
        ("Afrikaans (South Africa)", "af-ZA", "af-ZA-Standard-A", "FEMALE"),
        ("Arabic", "ar-XA", "ar-XA-Standard-A", "FEMALE"),
        ("Arabic", "ar-XA", "ar-XA-Standard-B", "MALE"),
        ("Arabic", "ar-XA", "ar-XA-Standard-C", "MALE"),
        ("Arabic", "ar-XA", "ar-XA-Standard-D", "FEMALE"),
        ("Arabic", "ar-XA", "ar-XA-Wavenet-A", "FEMALE"),
        ("Arabic", "ar-XA", "ar-XA-Wavenet-B", "MALE"),
        ("Arabic", "ar-XA", "ar-XA-Wavenet-C", "MALE"),
        ("Arabic", "ar-XA", "ar-XA-Wavenet-D", "FEMALE"),
        ("Bengali (India)", "bn-IN", "bn-IN-Standard-A", "FEMALE"),
        ("Bengali (India)", "bn-IN", "bn-IN-Standard-B", "MALE"),
        ("Bengali (India)", "bn-IN", "bn-IN-Wavenet-A", "FEMALE"),
        ("Bengali (India)", "bn-IN", "bn-IN-Wavenet-B", "MALE"),
        ("Bulgarian (Bulgaria)", "bg-BG", "bg-bg-Standard-A", "FEMALE"),
        ("Catalan (Spain)", "ca-ES", "ca-es-Standard-A", "FEMALE"),
        ("Chinese (Hong Kong)", "yue-HK", "yue-HK-Standard-A", "FEMALE"),
        ("Chinese (Hong Kong)", "yue-HK", "yue-HK-Standard-B", "MALE"),
        ("Chinese (Hong Kong)", "yue-HK", "yue-HK-Standard-C", "FEMALE"),
        ("Chinese (Hong Kong)", "yue-HK", "yue-HK-Standard-D", "MALE"),
        ("Czech (Czech Republic)", "cs-CZ", "cs-CZ-Standard-A", "FEMALE"),
        ("Czech (Czech Republic)", "cs-CZ", "cs-CZ-Wavenet-A", "FEMALE"),
        ("Danish (Denmark)", "da-DK", "da-DK-Standard-A", "FEMALE"),
        ("Danish (Denmark)", "da-DK", "da-DK-Standard-C", "MALE"),
        ("Danish (Denmark)", "da-DK", "da-DK-Standard-D", "FEMALE"),
        ("Danish (Denmark)", "da-DK", "da-DK-Standard-E", "FEMALE"),
        ("Danish (Denmark)", "da-DK", "da-DK-Wavenet-A", "FEMALE"),
        ("Danish (Denmark)", "da-DK", "da-DK-Wavenet-C", "MALE"),
        ("Danish (Denmark)", "da-DK", "da-DK-Wavenet-D", "FEMALE"),
        ("Danish (Denmark)", "da-DK", "da-DK-Wavenet-E", "FEMALE"),
        ("Dutch (Belgium)", "nl-BE", "nl-BE-Standard-A", "FEMALE"),
        ("Dutch (Belgium)", "nl-BE", "nl-BE-Standard-B", "MALE"),
        ("Dutch (Belgium)", "nl-BE", "nl-BE-Wavenet-A", "FEMALE"),
        ("Dutch (Belgium)", "nl-BE", "nl-BE-Wavenet-B", "MALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Standard-A", "FEMALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Standard-B", "MALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Standard-C", "MALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Standard-D", "FEMALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Standard-E", "FEMALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Wavenet-A", "FEMALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Wavenet-B", "MALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Wavenet-C", "MALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Wavenet-D", "FEMALE"),
        ("Dutch (Netherlands)", "nl-NL", "nl-NL-Wavenet-E", "FEMALE"),
        ("English (Australia)", "en-AU", "en-AU-Standard-A", "FEMALE"),
        ("English (Australia)", "en-AU", "en-AU-Standard-B", "MALE"),
        ("English (Australia)", "en-AU", "en-AU-Standard-C", "FEMALE"),
        ("English (Australia)", "en-AU", "en-AU-Standard-D", "MALE"),
        ("English (Australia)", "en-AU", "en-AU-Wavenet-A", "FEMALE"),
        ("English (Australia)", "en-AU", "en-AU-Wavenet-B", "MALE"),
        ("English (Australia)", "en-AU", "en-AU-Wavenet-C", "FEMALE"),
        ("English (Australia)", "en-AU", "en-AU-Wavenet-D", "MALE"),
        ("English (India)", "en-IN", "en-IN-Standard-A", "FEMALE"),
        ("English (India)", "en-IN", "en-IN-Standard-B", "MALE"),
        ("English (India)", "en-IN", "en-IN-Standard-C", "MALE"),
        ("English (India)", "en-IN", "en-IN-Standard-D", "FEMALE"),
        ("English (India)", "en-IN", "en-IN-Wavenet-A", "FEMALE"),
        ("English (India)", "en-IN", "en-IN-Wavenet-B", "MALE"),
        ("English (India)", "en-IN", "en-IN-Wavenet-C", "MALE"),
        ("English (India)", "en-IN", "en-IN-Wavenet-D", "FEMALE"),
        ("English (UK)", "en-GB", "en-GB-Standard-A", "FEMALE"),
        ("English (UK)", "en-GB", "en-GB-Standard-B", "MALE"),
        ("English (UK)", "en-GB", "en-GB-Standard-C", "FEMALE"),
        ("English (UK)", "en-GB", "en-GB-Standard-D", "MALE"),
        ("English (UK)", "en-GB", "en-GB-Standard-F", "FEMALE"),
        ("English (UK)", "en-GB", "en-GB-Wavenet-A", "FEMALE"),
        ("English (UK)", "en-GB", "en-GB-Wavenet-B", "MALE"),
        ("English (UK)", "en-GB", "en-GB-Wavenet-C", "FEMALE"),
        ("English (UK)", "en-GB", "en-GB-Wavenet-D", "MALE"),
        ("English (UK)", "en-GB", "en-GB-Wavenet-F", "FEMALE"),
        ("English (US)", "en-US", "en-US-Standard-A", "MALE"),
        ("English (US)", "en-US", "en-US-Standard-B", "MALE"),
        ("English (US)", "en-US", "en-US-Standard-C", "FEMALE"),
        ("English (US)", "en-US", "en-US-Standard-D", "MALE"),
        ("English (US)", "en-US", "en-US-Standard-E", "FEMALE"),
        ("English (US)", "en-US", "en-US-Standard-F", "FEMALE"),
        ("English (US)", "en-US", "en-US-Standard-G", "FEMALE"),
        ("English (US)", "en-US", "en-US-Standard-H", "FEMALE"),
        ("English (US)", "en-US", "en-US-Standard-I", "MALE"),
        ("English (US)", "en-US", "en-US-Standard-J", "MALE"),
        ("English (US)", "en-US", "en-US-Wavenet-A", "MALE"),
        ("English (US)", "en-US", "en-US-Wavenet-B", "MALE"),
        ("English (US)", "en-US", "en-US-Wavenet-C", "FEMALE"),
        ("English (US)", "en-US", "en-US-Wavenet-D", "MALE"),
        ("English (US)", "en-US", "en-US-Wavenet-E", "FEMALE"),
        ("English (US)", "en-US", "en-US-Wavenet-F", "FEMALE"),
        ("English (US)", "en-US", "en-US-Wavenet-G", "FEMALE"),
        ("English (US)", "en-US", "en-US-Wavenet-H", "FEMALE"),
        ("English (US)", "en-US", "en-US-Wavenet-I", "MALE"),
        ("English (US)", "en-US", "en-US-Wavenet-J", "MALE"),
        ("Filipino (Philippines)", "fil-PH", "fil-PH-Standard-A", "FEMALE"),
        ("Filipino (Philippines)", "fil-PH", "fil-PH-Standard-B", "FEMALE"),
        ("Filipino (Philippines)", "fil-PH", "fil-PH-Standard-C", "MALE"),
        ("Filipino (Philippines)", "fil-PH", "fil-PH-Standard-D", "MALE"),
        ("Filipino (Philippines)", "fil-PH", "fil-PH-Wavenet-A", "FEMALE"),
        ("Filipino (Philippines)", "fil-PH", "fil-PH-Wavenet-B", "FEMALE"),
        ("Filipino (Philippines)", "fil-PH", "fil-PH-Wavenet-C", "MALE"),
        ("Filipino (Philippines)", "fil-PH", "fil-PH-Wavenet-D", "MALE"),
        ("Finnish (Finland)", "fi-FI", "fi-FI-Standard-A", "FEMALE"),
        ("Finnish (Finland)", "fi-FI", "fi-FI-Wavenet-A", "FEMALE"),
        ("French (Canada)", "fr-CA", "fr-CA-Standard-A", "FEMALE"),
        ("French (Canada)", "fr-CA", "fr-CA-Standard-B", "MALE"),
        ("French (Canada)", "fr-CA", "fr-CA-Standard-C", "FEMALE"),
        ("French (Canada)", "fr-CA", "fr-CA-Standard-D", "MALE"),
        ("French (Canada)", "fr-CA", "fr-CA-Wavenet-A", "FEMALE"),
        ("French (Canada)", "fr-CA", "fr-CA-Wavenet-B", "MALE"),
        ("French (Canada)", "fr-CA", "fr-CA-Wavenet-C", "FEMALE"),
        ("French (Canada)", "fr-CA", "fr-CA-Wavenet-D", "MALE"),
        ("French (France)", "fr-FR", "fr-FR-Standard-A", "FEMALE"),
        ("French (France)", "fr-FR", "fr-FR-Standard-B", "MALE"),
        ("French (France)", "fr-FR", "fr-FR-Standard-C", "FEMALE"),
        ("French (France)", "fr-FR", "fr-FR-Standard-D", "MALE"),
        ("French (France)", "fr-FR", "fr-FR-Standard-E", "FEMALE"),
        ("French (France)", "fr-FR", "fr-FR-Wavenet-A", "FEMALE"),
        ("French (France)", "fr-FR", "fr-FR-Wavenet-B", "MALE"),
        ("French (France)", "fr-FR", "fr-FR-Wavenet-C", "FEMALE"),
        ("French (France)", "fr-FR", "fr-FR-Wavenet-D", "MALE"),
        ("French (France)", "fr-FR", "fr-FR-Wavenet-E", "FEMALE"),
        ("German (Germany)", "de-DE", "de-DE-Standard-A", "FEMALE"),
        ("German (Germany)", "de-DE", "de-DE-Standard-B", "MALE"),
        ("German (Germany)", "de-DE", "de-DE-Standard-C", "FEMALE"),
        ("German (Germany)", "de-DE", "de-DE-Standard-D", "MALE"),
        ("German (Germany)", "de-DE", "de-DE-Standard-E", "MALE"),
        ("German (Germany)", "de-DE", "de-DE-Standard-F", "FEMALE"),
        ("German (Germany)", "de-DE", "de-DE-Wavenet-A", "FEMALE"),
        ("German (Germany)", "de-DE", "de-DE-Wavenet-B", "MALE"),
        ("German (Germany)", "de-DE", "de-DE-Wavenet-C", "FEMALE"),
        ("German (Germany)", "de-DE", "de-DE-Wavenet-D", "MALE"),
        ("German (Germany)", "de-DE", "de-DE-Wavenet-E", "MALE"),
        ("German (Germany)", "de-DE", "de-DE-Wavenet-F", "FEMALE"),
        ("Greek (Greece)", "el-GR", "el-GR-Standard-A", "FEMALE"),
        ("Greek (Greece)", "el-GR", "el-GR-Wavenet-A", "FEMALE"),
        ("Gujarati (India)", "gu-IN", "gu-IN-Standard-A", "FEMALE"),
        ("Gujarati (India)", "gu-IN", "gu-IN-Standard-B", "MALE"),
        ("Gujarati (India)", "gu-IN", "gu-IN-Wavenet-A", "FEMALE"),
        ("Gujarati (India)", "gu-IN", "gu-IN-Wavenet-B", "MALE"),
        # workaround for Hebrew text
        ("Hebrew", "he", "", ""),
        ("Hindi (India)", "hi-IN", "hi-IN-Standard-A", "FEMALE"),
        ("Hindi (India)", "hi-IN", "hi-IN-Standard-B", "MALE"),
        ("Hindi (India)", "hi-IN", "hi-IN-Standard-C", "MALE"),
        ("Hindi (India)", "hi-IN", "hi-IN-Standard-D", "FEMALE"),
        ("Hindi (India)", "hi-IN", "hi-IN-Wavenet-A", "FEMALE"),
        ("Hindi (India)", "hi-IN", "hi-IN-Wavenet-B", "MALE"),
        ("Hindi (India)", "hi-IN", "hi-IN-Wavenet-C", "MALE"),
        ("Hindi (India)", "hi-IN", "hi-IN-Wavenet-D", "FEMALE"),
        ("Hungarian (Hungary)", "hu-HU", "hu-HU-Standard-A", "FEMALE"),
        ("Hungarian (Hungary)", "hu-HU", "hu-HU-Wavenet-A", "FEMALE"),
        ("Icelandic (Iceland)", "is-IS", "is-is-Standard-A", "FEMALE"),
        ("Indonesian (Indonesia)", "id-ID", "id-ID-Standard-A", "FEMALE"),
        ("Indonesian (Indonesia)", "id-ID", "id-ID-Standard-B", "MALE"),
        ("Indonesian (Indonesia)", "id-ID", "id-ID-Standard-C", "MALE"),
        ("Indonesian (Indonesia)", "id-ID", "id-ID-Standard-D", "FEMALE"),
        ("Indonesian (Indonesia)", "id-ID", "id-ID-Wavenet-A", "FEMALE"),
        ("Indonesian (Indonesia)", "id-ID", "id-ID-Wavenet-B", "MALE"),
        ("Indonesian (Indonesia)", "id-ID", "id-ID-Wavenet-C", "MALE"),
        ("Indonesian (Indonesia)", "id-ID", "id-ID-Wavenet-D", "FEMALE"),
        ("Italian (Italy)", "it-IT", "it-IT-Standard-A", "FEMALE"),
        ("Italian (Italy)", "it-IT", "it-IT-Standard-B", "FEMALE"),
        ("Italian (Italy)", "it-IT", "it-IT-Standard-C", "MALE"),
        ("Italian (Italy)", "it-IT", "it-IT-Standard-D", "MALE"),
        ("Italian (Italy)", "it-IT", "it-IT-Wavenet-A", "FEMALE"),
        ("Italian (Italy)", "it-IT", "it-IT-Wavenet-B", "FEMALE"),
        ("Italian (Italy)", "it-IT", "it-IT-Wavenet-C", "MALE"),
        ("Italian (Italy)", "it-IT", "it-IT-Wavenet-D", "MALE"),
        ("Japanese (Japan)", "ja-JP", "ja-JP-Standard-A", "FEMALE"),
        ("Japanese (Japan)", "ja-JP", "ja-JP-Standard-B", "FEMALE"),
        ("Japanese (Japan)", "ja-JP", "ja-JP-Standard-C", "MALE"),
        ("Japanese (Japan)", "ja-JP", "ja-JP-Standard-D", "MALE"),
        ("Japanese (Japan)", "ja-JP", "ja-JP-Wavenet-A", "FEMALE"),
        ("Japanese (Japan)", "ja-JP", "ja-JP-Wavenet-B", "FEMALE"),
        ("Japanese (Japan)", "ja-JP", "ja-JP-Wavenet-C", "MALE"),
        ("Japanese (Japan)", "ja-JP", "ja-JP-Wavenet-D", "MALE"),
        ("Kannada (India)", "kn-IN", "kn-IN-Standard-A", "FEMALE"),
        ("Kannada (India)", "kn-IN", "kn-IN-Standard-B", "MALE"),
        ("Kannada (India)", "kn-IN", "kn-IN-Wavenet-A", "FEMALE"),
        ("Kannada (India)", "kn-IN", "kn-IN-Wavenet-B", "MALE"),
        ("Korean (South Korea)", "ko-KR", "ko-KR-Standard-A", "FEMALE"),
        ("Korean (South Korea)", "ko-KR", "ko-KR-Standard-B", "FEMALE"),
        ("Korean (South Korea)", "ko-KR", "ko-KR-Standard-C", "MALE"),
        ("Korean (South Korea)", "ko-KR", "ko-KR-Standard-D", "MALE"),
        ("Korean (South Korea)", "ko-KR", "ko-KR-Wavenet-A", "FEMALE"),
        ("Korean (South Korea)", "ko-KR", "ko-KR-Wavenet-B", "FEMALE"),
        ("Korean (South Korea)", "ko-KR", "ko-KR-Wavenet-C", "MALE"),
        ("Korean (South Korea)", "ko-KR", "ko-KR-Wavenet-D", "MALE"),
        ("Latvian (Latvia)", "lv-LV", "lv-lv-Standard-A", "MALE"),
        ("Malay (Malaysia)", "ms-MY", "ms-MY-Standard-A", "FEMALE"),
        ("Malay (Malaysia)", "ms-MY", "ms-MY-Standard-B", "MALE"),
        ("Malay (Malaysia)", "ms-MY", "ms-MY-Standard-C", "FEMALE"),
        ("Malay (Malaysia)", "ms-MY", "ms-MY-Standard-D", "MALE"),
        ("Malay (Malaysia)", "ms-MY", "ms-MY-Wavenet-A", "FEMALE"),
        ("Malay (Malaysia)", "ms-MY", "ms-MY-Wavenet-B", "MALE"),
        ("Malay (Malaysia)", "ms-MY", "ms-MY-Wavenet-C", "FEMALE"),
        ("Malay (Malaysia)", "ms-MY", "ms-MY-Wavenet-D", "MALE"),
        ("Malayalam (India)", "ml-IN", "ml-IN-Standard-A", "FEMALE"),
        ("Malayalam (India)", "ml-IN", "ml-IN-Standard-B", "MALE"),
        ("Malayalam (India)", "ml-IN", "ml-IN-Wavenet-A", "FEMALE"),
        ("Malayalam (India)", "ml-IN", "ml-IN-Wavenet-B", "MALE"),
        ("Mandarin Chinese", "cmn-CN", "cmn-CN-Standard-A", "FEMALE"),
        ("Mandarin Chinese", "cmn-CN", "cmn-CN-Standard-B", "MALE"),
        ("Mandarin Chinese", "cmn-CN", "cmn-CN-Standard-C", "MALE"),
        ("Mandarin Chinese", "cmn-CN", "cmn-CN-Standard-D", "FEMALE"),
        ("Mandarin Chinese", "cmn-CN", "cmn-CN-Wavenet-A", "FEMALE"),
        ("Mandarin Chinese", "cmn-CN", "cmn-CN-Wavenet-B", "MALE"),
        ("Mandarin Chinese", "cmn-CN", "cmn-CN-Wavenet-C", "MALE"),
        ("Mandarin Chinese", "cmn-CN", "cmn-CN-Wavenet-D", "FEMALE"),
        ("Mandarin Chinese", "cmn-TW", "cmn-TW-Standard-A", "FEMALE"),
        ("Mandarin Chinese", "cmn-TW", "cmn-TW-Standard-B", "MALE"),
        ("Mandarin Chinese", "cmn-TW", "cmn-TW-Standard-C", "MALE"),
        ("Mandarin Chinese", "cmn-TW", "cmn-TW-Wavenet-A", "FEMALE"),
        ("Mandarin Chinese", "cmn-TW", "cmn-TW-Wavenet-B", "MALE"),
        ("Mandarin Chinese", "cmn-TW", "cmn-TW-Wavenet-C", "MALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-NO-Standard-A", "FEMALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-NO-Standard-B", "MALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-NO-Standard-C", "FEMALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-NO-Standard-D", "MALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-NO-Wavenet-A", "FEMALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-NO-Wavenet-B", "MALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-NO-Wavenet-C", "FEMALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-NO-Wavenet-D", "MALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-no-Standard-E", "FEMALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-no-Standard-E", "FEMALE"),
        ("Norwegian (Norway)", "nb-NO", "nb-no-Wavenet-E", "FEMALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Standard-A", "FEMALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Standard-B", "MALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Standard-C", "MALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Standard-D", "FEMALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Standard-E", "FEMALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Wavenet-A", "FEMALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Wavenet-B", "MALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Wavenet-C", "MALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Wavenet-D", "FEMALE"),
        ("Polish (Poland)", "pl-PL", "pl-PL-Wavenet-E", "FEMALE"),
        ("Portuguese (Brazil)", "pt-BR", "pt-BR-Standard-A", "FEMALE"),
        ("Portuguese (Brazil)", "pt-BR", "pt-BR-Standard-B", "MALE"),
        ("Portuguese (Brazil)", "pt-BR", "pt-BR-Wavenet-A", "FEMALE"),
        ("Portuguese (Brazil)", "pt-BR", "pt-BR-Wavenet-B", "MALE"),
        ("Portuguese (Portugal)", "pt-PT", "pt-PT-Standard-A", "FEMALE"),
        ("Portuguese (Portugal)", "pt-PT", "pt-PT-Standard-B", "MALE"),
        ("Portuguese (Portugal)", "pt-PT", "pt-PT-Standard-C", "MALE"),
        ("Portuguese (Portugal)", "pt-PT", "pt-PT-Standard-D", "FEMALE"),
        ("Portuguese (Portugal)", "pt-PT", "pt-PT-Wavenet-A", "FEMALE"),
        ("Portuguese (Portugal)", "pt-PT", "pt-PT-Wavenet-B", "MALE"),
        ("Portuguese (Portugal)", "pt-PT", "pt-PT-Wavenet-C", "MALE"),
        ("Portuguese (Portugal)", "pt-PT", "pt-PT-Wavenet-D", "FEMALE"),
        ("Punjabi (India)", "pa-IN", "pa-IN-Standard-A", "FEMALE"),
        ("Punjabi (India)", "pa-IN", "pa-IN-Standard-B", "MALE"),
        ("Punjabi (India)", "pa-IN", "pa-IN-Standard-C", "FEMALE"),
        ("Punjabi (India)", "pa-IN", "pa-IN-Standard-D", "MALE"),
        ("Punjabi (India)", "pa-IN", "pa-IN-Wavenet-A", "FEMALE"),
        ("Punjabi (India)", "pa-IN", "pa-IN-Wavenet-B", "MALE"),
        ("Punjabi (India)", "pa-IN", "pa-IN-Wavenet-C", "FEMALE"),
        ("Punjabi (India)", "pa-IN", "pa-IN-Wavenet-D", "MALE"),
        ("Romanian (Romania)", "ro-RO", "ro-RO-Standard-A", "FEMALE"),
        ("Romanian (Romania)", "ro-RO", "ro-RO-Wavenet-A", "FEMALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Standard-A", "FEMALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Standard-B", "MALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Standard-C", "FEMALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Standard-D", "MALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Standard-E", "FEMALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Wavenet-A", "FEMALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Wavenet-B", "MALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Wavenet-C", "FEMALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Wavenet-D", "MALE"),
        ("Russian (Russia)", "ru-RU", "ru-RU-Wavenet-E", "FEMALE"),
        ("Serbian (Cyrillic)", "sr-RS", "sr-rs-Standard-A", "FEMALE"),
        ("Slovak (Slovakia)", "sk-SK", "sk-SK-Standard-A", "FEMALE"),
        ("Slovak (Slovakia)", "sk-SK", "sk-SK-Wavenet-A", "FEMALE"),
        ("Spanish (Spain)", "es-ES", "es-ES-Standard-A", "FEMALE"),
        ("Spanish (Spain)", "es-ES", "es-ES-Standard-B", "MALE"),
        ("Spanish (Spain)", "es-ES", "es-ES-Standard-C", "FEMALE"),
        ("Spanish (Spain)", "es-ES", "es-ES-Standard-D", "FEMALE"),
        ("Spanish (Spain)", "es-ES", "es-ES-Wavenet-B", "MALE"),
        ("Spanish (Spain)", "es-ES", "es-ES-Wavenet-C", "FEMALE"),
        ("Spanish (Spain)", "es-ES", "es-ES-Wavenet-D", "FEMALE"),
        ("Spanish (US)", "es-US", "es-US-Standard-A", "FEMALE"),
        ("Spanish (US)", "es-US", "es-US-Standard-B", "MALE"),
        ("Spanish (US)", "es-US", "es-US-Standard-C", "MALE"),
        ("Spanish (US)", "es-US", "es-US-Wavenet-A", "FEMALE"),
        ("Spanish (US)", "es-US", "es-US-Wavenet-B", "MALE"),
        ("Spanish (US)", "es-US", "es-US-Wavenet-C", "MALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Standard-A", "FEMALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Standard-B", "FEMALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Standard-C", "FEMALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Standard-D", "MALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Standard-E", "MALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Wavenet-A", "FEMALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Wavenet-B", "FEMALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Wavenet-C", "MALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Wavenet-D", "FEMALE"),
        ("Swedish (Sweden)", "sv-SE", "sv-SE-Wavenet-E", "MALE"),
        ("Tamil (India)", "ta-IN", "ta-IN-Standard-A", "FEMALE"),
        ("Tamil (India)", "ta-IN", "ta-IN-Standard-B", "MALE"),
        ("Tamil (India)", "ta-IN", "ta-IN-Wavenet-A", "FEMALE"),
        ("Tamil (India)", "ta-IN", "ta-IN-Wavenet-B", "MALE"),
        ("Telugu (India)", "te-IN", "te-IN-Standard-A", "FEMALE"),
        ("Telugu (India)", "te-IN", "te-IN-Standard-B", "MALE"),
        ("Thai (Thailand)", "th-TH", "th-TH-Standard-A", "FEMALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Standard-A", "FEMALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Standard-B", "MALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Standard-C", "FEMALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Standard-D", "FEMALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Standard-E", "MALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Wavenet-A", "FEMALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Wavenet-B", "MALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Wavenet-C", "FEMALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Wavenet-D", "FEMALE"),
        ("Turkish (Turkey)", "tr-TR", "tr-TR-Wavenet-E", "MALE"),
        ("Ukrainian (Ukraine)", "uk-UA", "uk-UA-Standard-A", "FEMALE"),
        ("Ukrainian (Ukraine)", "uk-UA", "uk-UA-Wavenet-A", "FEMALE"),
        ("Vietnamese (Vietnam)", "vi-VN", "vi-VN-Standard-A", "FEMALE"),
        ("Vietnamese (Vietnam)", "vi-VN", "vi-VN-Standard-B", "MALE"),
        ("Vietnamese (Vietnam)", "vi-VN", "vi-VN-Standard-C", "FEMALE"),
        ("Vietnamese (Vietnam)", "vi-VN", "vi-VN-Standard-D", "MALE"),
        ("Vietnamese (Vietnam)", "vi-VN", "vi-VN-Wavenet-A", "FEMALE"),
        ("Vietnamese (Vietnam)", "vi-VN", "vi-VN-Wavenet-B", "MALE"),
        ("Vietnamese (Vietnam)", "vi-VN", "vi-VN-Wavenet-C", "FEMALE"),
        ("Vietnamese (Vietnam)", "vi-VN", "vi-VN-Wavenet-D", "MALE"),
    )

    # espeak --voices
    espeak = {
        "af": ("af", "afrikaans", "other/af"),
        "an": ("an", "aragonese", "europe/an"),
        "bg": ("bg", "bulgarian", "europe/bg"),
        "bs": ("bs", "bosnian", "europe/bs"),
        "ca": ("ca", "catalan", "europe/ca"),
        "cs": ("cs", "czech", "europe/cs"),
        "cy": ("cy", "welsh", "europe/cy"),
        "da": ("da", "danish", "europe/da"),
        "de": ("de", "german", "de"),
        # espeak el voice cannot read accented Greek words
        "el": ("el", "greek", "europe/el"),
        # To read accented Greek words, use grc instead of el
        "grc": ("grc", "greek-ancient", "other/grc"),
        #"en": ("en", "default", "default"),
        "en": ("en", "english", "default"),
        #"en-gb": ("en-gb", "english", "en"),
        "en-gb": ("en-gb", "english-gb", "en"),
        "en-sc": ("en-sc", "en-scottish", "other/en-sc"),
        "en-uk-north": ("en-uk-north", "english-north", "other/en-n"),
        "en-uk-rp": ("en-uk-rp", "english_rp", "other/en-rp"),
        "en-uk-wmids": ("en-uk-wmids", "english_wmids", "other/en-wm"),
        "en-us": ("en-us", "english-us", "en-us"),
        "en-wi": ("en-wi", "en-westindies", "other/en-wi"),
        "eo": ("eo", "esperanto", "other/eo"),
        "es": ("es", "spanish", "europe/es"),
        "es-la": ("es-la", "spanish-latin-am", "es-la"),
        "et": ("et", "estonian", "europe/et"),
        "fa": ("fa", "persian", "asia/fa"),
        "fa-pin": ("fa-pin", "persian-pinglish", "asia/fa-pin"),
        "fi": ("fi", "finnish", "europe/fi"),
        "fr-be": ("fr-be", "french-Belgium", "europe/fr-be"),
        "fr": ("fr-fr", "french", "fr"),
        "ga": ("ga", "irish-gaeilge", "europe/ga"),
        "hi": ("hi", "hindi", "asia/hi"),
        "hr": ("hr", "croatian", "europe/hr"),
        "hu": ("hu", "hungarian", "europe/hu"),
        "hy": ("hy", "armenian", "asia/hy"),
        "hy-west": ("hy-west", "armenian-west", "asia/hy-west"),
        "id": ("id", "indonesian", "asia/id"),
        "is": ("is", "icelandic", "europe/is"),
        "it": ("it", "italian", "europe/it"),
        "jbo": ("jbo", "lojban", "other/jbo"),
        "ka": ("ka", "georgian", "asia/ka"),
        "kn": ("kn", "kannada", "asia/kn"),
        "ku": ("ku", "kurdish", "asia/ku"),
        "la": ("la", "latin", "other/la"),
        "lfn": ("lfn", "lingua_franca_nova", "other/lfn"),
        "lt": ("lt", "lithuanian", "europe/lt"),
        "lv": ("lv", "latvian", "europe/lv"),
        "mk": ("mk", "macedonian", "europe/mk"),
        "ml": ("ml", "malayalam", "asia/ml"),
        "ms": ("ms", "malay", "asia/ms"),
        "ne": ("ne", "nepali", "asia/ne"),
        "nl": ("nl", "dutch", "europe/nl"),
        "no": ("no", "norwegian", "europe/no"),
        "pa": ("pa", "punjabi", "asia/pa"),
        "pl": ("pl", "polish", "europe/pl"),
        "pt-br": ("pt-br", "brazil", "pt"),
        "pt": ("pt-pt", "portugal", "europe/pt-pt"),
        "ro": ("ro", "romanian", "europe/ro"),
        "ru": ("ru", "russian", "europe/ru"),
        "sk": ("sk", "slovak", "europe/sk"),
        "sq": ("sq", "albanian", "europe/sq"),
        "sr": ("sr", "serbian", "europe/sr"),
        "sv": ("sv", "swedish", "europe/sv"),
        "sw": ("sw", "swahili-test", "other/sw"),
        "ta": ("ta", "tamil", "asia/ta"),
        "tr": ("tr", "turkish", "asia/tr"),
        "vi": ("vi", "vietnam", "asia/vi"),
        "vi-hue": ("vi-hue", "vietnam_hue", "asia/vi-hue"),
        "vi-sgn": ("vi-sgn", "vietnam_sgn", "asia/vi-sgn"),
        "zh-cn": ("zh", "mandarin", "asia/zh"),
        "zh-tw": ("zh-yue", "cantonese", "asia/zh-yue"),
        "yue": ("zh-yue", "cantonese", "asia/zh-yue"),
        "he": ("he", "hebrew", "he"),
    }