# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VulnerabilityAuditArgs', 'VulnerabilityAudit']

@pulumi.input_type
class VulnerabilityAuditArgs:
    def __init__(__self__, *,
                 knowledge_base_id: pulumi.Input[builtins.str],
                 application_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditApplicationDependencyArgs']]]] = None,
                 build_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input['VulnerabilityAuditConfigurationArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 source: Optional[pulumi.Input['VulnerabilityAuditSourceArgs']] = None,
                 usage_data: Optional[pulumi.Input['VulnerabilityAuditUsageDataArgs']] = None):
        """
        The set of arguments for constructing a VulnerabilityAudit resource.
        :param pulumi.Input[builtins.str] knowledge_base_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditApplicationDependencyArgs']]] application_dependencies: List of application dependencies (without vulnerabilities).
        :param pulumi.Input[builtins.str] build_type: The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The compartment Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.  If compartment identifier is not provided the compartment of the associated knowledge base will be used instead.
        :param pulumi.Input['VulnerabilityAuditConfigurationArgs'] configuration: Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the vulnerability audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['VulnerabilityAuditSourceArgs'] source: vulnerability audit source.
        :param pulumi.Input['VulnerabilityAuditUsageDataArgs'] usage_data: The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        """
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if application_dependencies is not None:
            pulumi.set(__self__, "application_dependencies", application_dependencies)
        if build_type is not None:
            pulumi.set(__self__, "build_type", build_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if usage_data is not None:
            pulumi.set(__self__, "usage_data", usage_data)

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> pulumi.Input[builtins.str]:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @knowledge_base_id.setter
    def knowledge_base_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "knowledge_base_id", value)

    @property
    @pulumi.getter(name="applicationDependencies")
    def application_dependencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditApplicationDependencyArgs']]]]:
        """
        List of application dependencies (without vulnerabilities).
        """
        return pulumi.get(self, "application_dependencies")

    @application_dependencies.setter
    def application_dependencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditApplicationDependencyArgs']]]]):
        pulumi.set(self, "application_dependencies", value)

    @property
    @pulumi.getter(name="buildType")
    def build_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        """
        return pulumi.get(self, "build_type")

    @build_type.setter
    def build_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "build_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The compartment Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.  If compartment identifier is not provided the compartment of the associated knowledge base will be used instead.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['VulnerabilityAuditConfigurationArgs']]:
        """
        Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['VulnerabilityAuditConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the vulnerability audit.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['VulnerabilityAuditSourceArgs']]:
        """
        vulnerability audit source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['VulnerabilityAuditSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="usageData")
    def usage_data(self) -> Optional[pulumi.Input['VulnerabilityAuditUsageDataArgs']]:
        """
        The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        """
        return pulumi.get(self, "usage_data")

    @usage_data.setter
    def usage_data(self, value: Optional[pulumi.Input['VulnerabilityAuditUsageDataArgs']]):
        pulumi.set(self, "usage_data", value)


@pulumi.input_type
class _VulnerabilityAuditState:
    def __init__(__self__, *,
                 application_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditApplicationDependencyArgs']]]] = None,
                 build_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input['VulnerabilityAuditConfigurationArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_success: Optional[pulumi.Input[builtins.bool]] = None,
                 knowledge_base_id: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 max_observed_cvss_v2score: Optional[pulumi.Input[builtins.float]] = None,
                 max_observed_cvss_v2score_with_ignored: Optional[pulumi.Input[builtins.float]] = None,
                 max_observed_cvss_v3score: Optional[pulumi.Input[builtins.float]] = None,
                 max_observed_cvss_v3score_with_ignored: Optional[pulumi.Input[builtins.float]] = None,
                 max_observed_severity: Optional[pulumi.Input[builtins.str]] = None,
                 max_observed_severity_with_ignored: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input['VulnerabilityAuditSourceArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 usage_data: Optional[pulumi.Input['VulnerabilityAuditUsageDataArgs']] = None,
                 vulnerabilities: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditVulnerabilityArgs']]]] = None,
                 vulnerable_artifacts_count: Optional[pulumi.Input[builtins.int]] = None,
                 vulnerable_artifacts_count_with_ignored: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering VulnerabilityAudit resources.
        :param pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditApplicationDependencyArgs']]] application_dependencies: List of application dependencies (without vulnerabilities).
        :param pulumi.Input[builtins.str] build_type: The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The compartment Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.  If compartment identifier is not provided the compartment of the associated knowledge base will be used instead.
        :param pulumi.Input['VulnerabilityAuditConfigurationArgs'] configuration: Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the vulnerability audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_success: Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.
        :param pulumi.Input[builtins.str] knowledge_base_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param pulumi.Input[builtins.str] lifecycle_details: Details on the lifecycle state.
        :param pulumi.Input[builtins.float] max_observed_cvss_v2score: Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
        :param pulumi.Input[builtins.float] max_observed_cvss_v2score_with_ignored: Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
        :param pulumi.Input[builtins.float] max_observed_cvss_v3score: Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
        :param pulumi.Input[builtins.float] max_observed_cvss_v3score_with_ignored: Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
        :param pulumi.Input[builtins.str] max_observed_severity: Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
        :param pulumi.Input[builtins.str] max_observed_severity_with_ignored: Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
        :param pulumi.Input['VulnerabilityAuditSourceArgs'] source: vulnerability audit source.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the vulnerability audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The creation date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[builtins.str] time_updated: The update date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input['VulnerabilityAuditUsageDataArgs'] usage_data: The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        :param pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditVulnerabilityArgs']]] vulnerabilities: List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple dependencies, the metadata returned here consists of audit-wide aggregates.
        :param pulumi.Input[builtins.int] vulnerable_artifacts_count: Count of non-ignored vulnerable application dependencies.
        :param pulumi.Input[builtins.int] vulnerable_artifacts_count_with_ignored: Count of all vulnerable application dependencies.
        """
        if application_dependencies is not None:
            pulumi.set(__self__, "application_dependencies", application_dependencies)
        if build_type is not None:
            pulumi.set(__self__, "build_type", build_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_success is not None:
            pulumi.set(__self__, "is_success", is_success)
        if knowledge_base_id is not None:
            pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_observed_cvss_v2score is not None:
            pulumi.set(__self__, "max_observed_cvss_v2score", max_observed_cvss_v2score)
        if max_observed_cvss_v2score_with_ignored is not None:
            pulumi.set(__self__, "max_observed_cvss_v2score_with_ignored", max_observed_cvss_v2score_with_ignored)
        if max_observed_cvss_v3score is not None:
            pulumi.set(__self__, "max_observed_cvss_v3score", max_observed_cvss_v3score)
        if max_observed_cvss_v3score_with_ignored is not None:
            pulumi.set(__self__, "max_observed_cvss_v3score_with_ignored", max_observed_cvss_v3score_with_ignored)
        if max_observed_severity is not None:
            pulumi.set(__self__, "max_observed_severity", max_observed_severity)
        if max_observed_severity_with_ignored is not None:
            pulumi.set(__self__, "max_observed_severity_with_ignored", max_observed_severity_with_ignored)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if usage_data is not None:
            pulumi.set(__self__, "usage_data", usage_data)
        if vulnerabilities is not None:
            pulumi.set(__self__, "vulnerabilities", vulnerabilities)
        if vulnerable_artifacts_count is not None:
            pulumi.set(__self__, "vulnerable_artifacts_count", vulnerable_artifacts_count)
        if vulnerable_artifacts_count_with_ignored is not None:
            pulumi.set(__self__, "vulnerable_artifacts_count_with_ignored", vulnerable_artifacts_count_with_ignored)

    @property
    @pulumi.getter(name="applicationDependencies")
    def application_dependencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditApplicationDependencyArgs']]]]:
        """
        List of application dependencies (without vulnerabilities).
        """
        return pulumi.get(self, "application_dependencies")

    @application_dependencies.setter
    def application_dependencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditApplicationDependencyArgs']]]]):
        pulumi.set(self, "application_dependencies", value)

    @property
    @pulumi.getter(name="buildType")
    def build_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        """
        return pulumi.get(self, "build_type")

    @build_type.setter
    def build_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "build_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The compartment Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.  If compartment identifier is not provided the compartment of the associated knowledge base will be used instead.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['VulnerabilityAuditConfigurationArgs']]:
        """
        Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['VulnerabilityAuditConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the vulnerability audit.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isSuccess")
    def is_success(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.
        """
        return pulumi.get(self, "is_success")

    @is_success.setter
    def is_success(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_success", value)

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @knowledge_base_id.setter
    def knowledge_base_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "knowledge_base_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Details on the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maxObservedCvssV2score")
    def max_observed_cvss_v2score(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v2score")

    @max_observed_cvss_v2score.setter
    def max_observed_cvss_v2score(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_observed_cvss_v2score", value)

    @property
    @pulumi.getter(name="maxObservedCvssV2scoreWithIgnored")
    def max_observed_cvss_v2score_with_ignored(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v2score_with_ignored")

    @max_observed_cvss_v2score_with_ignored.setter
    def max_observed_cvss_v2score_with_ignored(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_observed_cvss_v2score_with_ignored", value)

    @property
    @pulumi.getter(name="maxObservedCvssV3score")
    def max_observed_cvss_v3score(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v3score")

    @max_observed_cvss_v3score.setter
    def max_observed_cvss_v3score(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_observed_cvss_v3score", value)

    @property
    @pulumi.getter(name="maxObservedCvssV3scoreWithIgnored")
    def max_observed_cvss_v3score_with_ignored(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v3score_with_ignored")

    @max_observed_cvss_v3score_with_ignored.setter
    def max_observed_cvss_v3score_with_ignored(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_observed_cvss_v3score_with_ignored", value)

    @property
    @pulumi.getter(name="maxObservedSeverity")
    def max_observed_severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_severity")

    @max_observed_severity.setter
    def max_observed_severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_observed_severity", value)

    @property
    @pulumi.getter(name="maxObservedSeverityWithIgnored")
    def max_observed_severity_with_ignored(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_severity_with_ignored")

    @max_observed_severity_with_ignored.setter
    def max_observed_severity_with_ignored(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_observed_severity_with_ignored", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['VulnerabilityAuditSourceArgs']]:
        """
        vulnerability audit source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['VulnerabilityAuditSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the vulnerability audit.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The update date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="usageData")
    def usage_data(self) -> Optional[pulumi.Input['VulnerabilityAuditUsageDataArgs']]:
        """
        The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        """
        return pulumi.get(self, "usage_data")

    @usage_data.setter
    def usage_data(self, value: Optional[pulumi.Input['VulnerabilityAuditUsageDataArgs']]):
        pulumi.set(self, "usage_data", value)

    @property
    @pulumi.getter
    def vulnerabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditVulnerabilityArgs']]]]:
        """
        List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple dependencies, the metadata returned here consists of audit-wide aggregates.
        """
        return pulumi.get(self, "vulnerabilities")

    @vulnerabilities.setter
    def vulnerabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityAuditVulnerabilityArgs']]]]):
        pulumi.set(self, "vulnerabilities", value)

    @property
    @pulumi.getter(name="vulnerableArtifactsCount")
    def vulnerable_artifacts_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count")

    @vulnerable_artifacts_count.setter
    def vulnerable_artifacts_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vulnerable_artifacts_count", value)

    @property
    @pulumi.getter(name="vulnerableArtifactsCountWithIgnored")
    def vulnerable_artifacts_count_with_ignored(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of all vulnerable application dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count_with_ignored")

    @vulnerable_artifacts_count_with_ignored.setter
    def vulnerable_artifacts_count_with_ignored(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vulnerable_artifacts_count_with_ignored", value)


class VulnerabilityAudit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityAuditApplicationDependencyArgs', 'VulnerabilityAuditApplicationDependencyArgsDict']]]]] = None,
                 build_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['VulnerabilityAuditConfigurationArgs', 'VulnerabilityAuditConfigurationArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 knowledge_base_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['VulnerabilityAuditSourceArgs', 'VulnerabilityAuditSourceArgsDict']]] = None,
                 usage_data: Optional[pulumi.Input[Union['VulnerabilityAuditUsageDataArgs', 'VulnerabilityAuditUsageDataArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Vulnerability Audit resource in Oracle Cloud Infrastructure Adm service.

        Creates a new Vulnerability Audit by providing a tree of Application Dependencies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vulnerability_audit = oci.adm.VulnerabilityAudit("test_vulnerability_audit",
            knowledge_base_id=test_knowledge_base["id"],
            application_dependencies=[{
                "node_id": test_node["id"],
                "application_dependency_node_ids": vulnerability_audit_application_dependencies_application_dependency_node_ids,
                "gav": vulnerability_audit_application_dependencies_gav,
                "purl": vulnerability_audit_application_dependencies_purl,
            }],
            build_type=vulnerability_audit_build_type,
            compartment_id=compartment_id,
            configuration={
                "exclusions": vulnerability_audit_configuration_exclusions,
                "max_permissible_cvss_v2score": vulnerability_audit_configuration_max_permissible_cvss_v2score,
                "max_permissible_cvss_v3score": vulnerability_audit_configuration_max_permissible_cvss_v3score,
                "max_permissible_severity": vulnerability_audit_configuration_max_permissible_severity,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=vulnerability_audit_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            source={
                "type": vulnerability_audit_source_type,
                "description": vulnerability_audit_source_description,
                "oci_resource_id": test_oci_resource["id"],
            },
            usage_data={
                "bucket": vulnerability_audit_usage_data_bucket,
                "namespace": vulnerability_audit_usage_data_namespace,
                "object": vulnerability_audit_usage_data_object,
                "source_type": vulnerability_audit_usage_data_source_type,
            })
        ```

        ## Import

        VulnerabilityAudits can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Adm/vulnerabilityAudit:VulnerabilityAudit test_vulnerability_audit "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityAuditApplicationDependencyArgs', 'VulnerabilityAuditApplicationDependencyArgsDict']]]] application_dependencies: List of application dependencies (without vulnerabilities).
        :param pulumi.Input[builtins.str] build_type: The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The compartment Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.  If compartment identifier is not provided the compartment of the associated knowledge base will be used instead.
        :param pulumi.Input[Union['VulnerabilityAuditConfigurationArgs', 'VulnerabilityAuditConfigurationArgsDict']] configuration: Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the vulnerability audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] knowledge_base_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param pulumi.Input[Union['VulnerabilityAuditSourceArgs', 'VulnerabilityAuditSourceArgsDict']] source: vulnerability audit source.
        :param pulumi.Input[Union['VulnerabilityAuditUsageDataArgs', 'VulnerabilityAuditUsageDataArgsDict']] usage_data: The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VulnerabilityAuditArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vulnerability Audit resource in Oracle Cloud Infrastructure Adm service.

        Creates a new Vulnerability Audit by providing a tree of Application Dependencies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vulnerability_audit = oci.adm.VulnerabilityAudit("test_vulnerability_audit",
            knowledge_base_id=test_knowledge_base["id"],
            application_dependencies=[{
                "node_id": test_node["id"],
                "application_dependency_node_ids": vulnerability_audit_application_dependencies_application_dependency_node_ids,
                "gav": vulnerability_audit_application_dependencies_gav,
                "purl": vulnerability_audit_application_dependencies_purl,
            }],
            build_type=vulnerability_audit_build_type,
            compartment_id=compartment_id,
            configuration={
                "exclusions": vulnerability_audit_configuration_exclusions,
                "max_permissible_cvss_v2score": vulnerability_audit_configuration_max_permissible_cvss_v2score,
                "max_permissible_cvss_v3score": vulnerability_audit_configuration_max_permissible_cvss_v3score,
                "max_permissible_severity": vulnerability_audit_configuration_max_permissible_severity,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=vulnerability_audit_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            source={
                "type": vulnerability_audit_source_type,
                "description": vulnerability_audit_source_description,
                "oci_resource_id": test_oci_resource["id"],
            },
            usage_data={
                "bucket": vulnerability_audit_usage_data_bucket,
                "namespace": vulnerability_audit_usage_data_namespace,
                "object": vulnerability_audit_usage_data_object,
                "source_type": vulnerability_audit_usage_data_source_type,
            })
        ```

        ## Import

        VulnerabilityAudits can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Adm/vulnerabilityAudit:VulnerabilityAudit test_vulnerability_audit "id"
        ```

        :param str resource_name: The name of the resource.
        :param VulnerabilityAuditArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilityAuditArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityAuditApplicationDependencyArgs', 'VulnerabilityAuditApplicationDependencyArgsDict']]]]] = None,
                 build_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['VulnerabilityAuditConfigurationArgs', 'VulnerabilityAuditConfigurationArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 knowledge_base_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['VulnerabilityAuditSourceArgs', 'VulnerabilityAuditSourceArgsDict']]] = None,
                 usage_data: Optional[pulumi.Input[Union['VulnerabilityAuditUsageDataArgs', 'VulnerabilityAuditUsageDataArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilityAuditArgs.__new__(VulnerabilityAuditArgs)

            __props__.__dict__["application_dependencies"] = application_dependencies
            __props__.__dict__["build_type"] = build_type
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if knowledge_base_id is None and not opts.urn:
                raise TypeError("Missing required property 'knowledge_base_id'")
            __props__.__dict__["knowledge_base_id"] = knowledge_base_id
            __props__.__dict__["source"] = source
            __props__.__dict__["usage_data"] = usage_data
            __props__.__dict__["is_success"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["max_observed_cvss_v2score"] = None
            __props__.__dict__["max_observed_cvss_v2score_with_ignored"] = None
            __props__.__dict__["max_observed_cvss_v3score"] = None
            __props__.__dict__["max_observed_cvss_v3score_with_ignored"] = None
            __props__.__dict__["max_observed_severity"] = None
            __props__.__dict__["max_observed_severity_with_ignored"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["vulnerabilities"] = None
            __props__.__dict__["vulnerable_artifacts_count"] = None
            __props__.__dict__["vulnerable_artifacts_count_with_ignored"] = None
        super(VulnerabilityAudit, __self__).__init__(
            'oci:Adm/vulnerabilityAudit:VulnerabilityAudit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityAuditApplicationDependencyArgs', 'VulnerabilityAuditApplicationDependencyArgsDict']]]]] = None,
            build_type: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['VulnerabilityAuditConfigurationArgs', 'VulnerabilityAuditConfigurationArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_success: Optional[pulumi.Input[builtins.bool]] = None,
            knowledge_base_id: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            max_observed_cvss_v2score: Optional[pulumi.Input[builtins.float]] = None,
            max_observed_cvss_v2score_with_ignored: Optional[pulumi.Input[builtins.float]] = None,
            max_observed_cvss_v3score: Optional[pulumi.Input[builtins.float]] = None,
            max_observed_cvss_v3score_with_ignored: Optional[pulumi.Input[builtins.float]] = None,
            max_observed_severity: Optional[pulumi.Input[builtins.str]] = None,
            max_observed_severity_with_ignored: Optional[pulumi.Input[builtins.str]] = None,
            source: Optional[pulumi.Input[Union['VulnerabilityAuditSourceArgs', 'VulnerabilityAuditSourceArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            usage_data: Optional[pulumi.Input[Union['VulnerabilityAuditUsageDataArgs', 'VulnerabilityAuditUsageDataArgsDict']]] = None,
            vulnerabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityAuditVulnerabilityArgs', 'VulnerabilityAuditVulnerabilityArgsDict']]]]] = None,
            vulnerable_artifacts_count: Optional[pulumi.Input[builtins.int]] = None,
            vulnerable_artifacts_count_with_ignored: Optional[pulumi.Input[builtins.int]] = None) -> 'VulnerabilityAudit':
        """
        Get an existing VulnerabilityAudit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityAuditApplicationDependencyArgs', 'VulnerabilityAuditApplicationDependencyArgsDict']]]] application_dependencies: List of application dependencies (without vulnerabilities).
        :param pulumi.Input[builtins.str] build_type: The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The compartment Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.  If compartment identifier is not provided the compartment of the associated knowledge base will be used instead.
        :param pulumi.Input[Union['VulnerabilityAuditConfigurationArgs', 'VulnerabilityAuditConfigurationArgsDict']] configuration: Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name of the vulnerability audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_success: Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.
        :param pulumi.Input[builtins.str] knowledge_base_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param pulumi.Input[builtins.str] lifecycle_details: Details on the lifecycle state.
        :param pulumi.Input[builtins.float] max_observed_cvss_v2score: Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
        :param pulumi.Input[builtins.float] max_observed_cvss_v2score_with_ignored: Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
        :param pulumi.Input[builtins.float] max_observed_cvss_v3score: Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
        :param pulumi.Input[builtins.float] max_observed_cvss_v3score_with_ignored: Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
        :param pulumi.Input[builtins.str] max_observed_severity: Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
        :param pulumi.Input[builtins.str] max_observed_severity_with_ignored: Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
        :param pulumi.Input[Union['VulnerabilityAuditSourceArgs', 'VulnerabilityAuditSourceArgsDict']] source: vulnerability audit source.
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the vulnerability audit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The creation date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[builtins.str] time_updated: The update date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[Union['VulnerabilityAuditUsageDataArgs', 'VulnerabilityAuditUsageDataArgsDict']] usage_data: The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityAuditVulnerabilityArgs', 'VulnerabilityAuditVulnerabilityArgsDict']]]] vulnerabilities: List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple dependencies, the metadata returned here consists of audit-wide aggregates.
        :param pulumi.Input[builtins.int] vulnerable_artifacts_count: Count of non-ignored vulnerable application dependencies.
        :param pulumi.Input[builtins.int] vulnerable_artifacts_count_with_ignored: Count of all vulnerable application dependencies.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilityAuditState.__new__(_VulnerabilityAuditState)

        __props__.__dict__["application_dependencies"] = application_dependencies
        __props__.__dict__["build_type"] = build_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_success"] = is_success
        __props__.__dict__["knowledge_base_id"] = knowledge_base_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["max_observed_cvss_v2score"] = max_observed_cvss_v2score
        __props__.__dict__["max_observed_cvss_v2score_with_ignored"] = max_observed_cvss_v2score_with_ignored
        __props__.__dict__["max_observed_cvss_v3score"] = max_observed_cvss_v3score
        __props__.__dict__["max_observed_cvss_v3score_with_ignored"] = max_observed_cvss_v3score_with_ignored
        __props__.__dict__["max_observed_severity"] = max_observed_severity
        __props__.__dict__["max_observed_severity_with_ignored"] = max_observed_severity_with_ignored
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["usage_data"] = usage_data
        __props__.__dict__["vulnerabilities"] = vulnerabilities
        __props__.__dict__["vulnerable_artifacts_count"] = vulnerable_artifacts_count
        __props__.__dict__["vulnerable_artifacts_count_with_ignored"] = vulnerable_artifacts_count_with_ignored
        return VulnerabilityAudit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationDependencies")
    def application_dependencies(self) -> pulumi.Output[Sequence['outputs.VulnerabilityAuditApplicationDependency']]:
        """
        List of application dependencies (without vulnerabilities).
        """
        return pulumi.get(self, "application_dependencies")

    @property
    @pulumi.getter(name="buildType")
    def build_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        """
        return pulumi.get(self, "build_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The compartment Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.  If compartment identifier is not provided the compartment of the associated knowledge base will be used instead.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.VulnerabilityAuditConfiguration']:
        """
        Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The name of the vulnerability audit.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isSuccess")
    def is_success(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.
        """
        return pulumi.get(self, "is_success")

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> pulumi.Output[builtins.str]:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Details on the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxObservedCvssV2score")
    def max_observed_cvss_v2score(self) -> pulumi.Output[builtins.float]:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v2score")

    @property
    @pulumi.getter(name="maxObservedCvssV2scoreWithIgnored")
    def max_observed_cvss_v2score_with_ignored(self) -> pulumi.Output[builtins.float]:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v2score_with_ignored")

    @property
    @pulumi.getter(name="maxObservedCvssV3score")
    def max_observed_cvss_v3score(self) -> pulumi.Output[builtins.float]:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v3score")

    @property
    @pulumi.getter(name="maxObservedCvssV3scoreWithIgnored")
    def max_observed_cvss_v3score_with_ignored(self) -> pulumi.Output[builtins.float]:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v3score_with_ignored")

    @property
    @pulumi.getter(name="maxObservedSeverity")
    def max_observed_severity(self) -> pulumi.Output[builtins.str]:
        """
        Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_severity")

    @property
    @pulumi.getter(name="maxObservedSeverityWithIgnored")
    def max_observed_severity_with_ignored(self) -> pulumi.Output[builtins.str]:
        """
        Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_severity_with_ignored")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.VulnerabilityAuditSource']:
        """
        vulnerability audit source.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the vulnerability audit.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The creation date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The update date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="usageData")
    def usage_data(self) -> pulumi.Output['outputs.VulnerabilityAuditUsageData']:
        """
        The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        """
        return pulumi.get(self, "usage_data")

    @property
    @pulumi.getter
    def vulnerabilities(self) -> pulumi.Output[Sequence['outputs.VulnerabilityAuditVulnerability']]:
        """
        List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple dependencies, the metadata returned here consists of audit-wide aggregates.
        """
        return pulumi.get(self, "vulnerabilities")

    @property
    @pulumi.getter(name="vulnerableArtifactsCount")
    def vulnerable_artifacts_count(self) -> pulumi.Output[builtins.int]:
        """
        Count of non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count")

    @property
    @pulumi.getter(name="vulnerableArtifactsCountWithIgnored")
    def vulnerable_artifacts_count_with_ignored(self) -> pulumi.Output[builtins.int]:
        """
        Count of all vulnerable application dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count_with_ignored")

