# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalyticsInstanceArgs', 'AnalyticsInstance']

@pulumi.input_type
class AnalyticsInstanceArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input['AnalyticsInstanceCapacityArgs'],
                 compartment_id: pulumi.Input[builtins.str],
                 feature_set: pulumi.Input[builtins.str],
                 license_type: pulumi.Input[builtins.str],
                 admin_user: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_notification: Optional[pulumi.Input[builtins.str]] = None,
                 feature_bundle: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_endpoint_details: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_channel: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AnalyticsInstance resource.
        :param pulumi.Input['AnalyticsInstanceCapacityArgs'] capacity: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] feature_set: Analytics feature set.
        :param pulumi.Input[builtins.str] license_type: (Updatable) The license used for the service.
        :param pulumi.Input[builtins.str] admin_user: user name of the authorized user.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Optional description.
        :param pulumi.Input[builtins.str] domain_id: domain id for which the user is authorized.
        :param pulumi.Input[builtins.str] email_notification: (Updatable) Email address receiving notifications.
        :param pulumi.Input[builtins.str] feature_bundle: The feature set of an Analytics instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] idcs_access_token: IDCS access token identifying a stripe and service administrator user.
        :param pulumi.Input[builtins.str] kms_key_id: OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        :param pulumi.Input[builtins.str] name: The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        :param pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] update_channel: (Updatable) Analytics instance update channel.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "feature_set", feature_set)
        pulumi.set(__self__, "license_type", license_type)
        if admin_user is not None:
            pulumi.set(__self__, "admin_user", admin_user)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if email_notification is not None:
            pulumi.set(__self__, "email_notification", email_notification)
        if feature_bundle is not None:
            pulumi.set(__self__, "feature_bundle", feature_bundle)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idcs_access_token is not None:
            pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_endpoint_details is not None:
            pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_channel is not None:
            pulumi.set(__self__, "update_channel", update_channel)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input['AnalyticsInstanceCapacityArgs']:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input['AnalyticsInstanceCapacityArgs']):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> pulumi.Input[builtins.str]:
        """
        Analytics feature set.
        """
        return pulumi.get(self, "feature_set")

    @feature_set.setter
    def feature_set(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_set", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        user name of the authorized user.
        """
        return pulumi.get(self, "admin_user")

    @admin_user.setter
    def admin_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_user", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        domain id for which the user is authorized.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @email_notification.setter
    def email_notification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email_notification", value)

    @property
    @pulumi.getter(name="featureBundle")
    def feature_bundle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The feature set of an Analytics instance.
        """
        return pulumi.get(self, "feature_bundle")

    @feature_bundle.setter
    def feature_bundle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_bundle", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IDCS access token identifying a stripe and service administrator user.
        """
        return pulumi.get(self, "idcs_access_token")

    @idcs_access_token.setter
    def idcs_access_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_access_token", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']]:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @network_endpoint_details.setter
    def network_endpoint_details(self, value: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']]):
        pulumi.set(self, "network_endpoint_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateChannel")
    def update_channel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Analytics instance update channel.
        """
        return pulumi.get(self, "update_channel")

    @update_channel.setter
    def update_channel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_channel", value)


@pulumi.input_type
class _AnalyticsInstanceState:
    def __init__(__self__, *,
                 admin_user: Optional[pulumi.Input[builtins.str]] = None,
                 capacity: Optional[pulumi.Input['AnalyticsInstanceCapacityArgs']] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_notification: Optional[pulumi.Input[builtins.str]] = None,
                 feature_bundle: Optional[pulumi.Input[builtins.str]] = None,
                 feature_set: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_endpoint_details: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']] = None,
                 service_url: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 update_channel: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AnalyticsInstance resources.
        :param pulumi.Input[builtins.str] admin_user: user name of the authorized user.
        :param pulumi.Input['AnalyticsInstanceCapacityArgs'] capacity: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Optional description.
        :param pulumi.Input[builtins.str] domain_id: domain id for which the user is authorized.
        :param pulumi.Input[builtins.str] email_notification: (Updatable) Email address receiving notifications.
        :param pulumi.Input[builtins.str] feature_bundle: The feature set of an Analytics instance.
        :param pulumi.Input[builtins.str] feature_set: Analytics feature set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] idcs_access_token: IDCS access token identifying a stripe and service administrator user.
        :param pulumi.Input[builtins.str] kms_key_id: OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        :param pulumi.Input[builtins.str] license_type: (Updatable) The license used for the service.
        :param pulumi.Input[builtins.str] name: The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        :param pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[builtins.str] service_url: URL of the Analytics service.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.key": "value"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        :param pulumi.Input[builtins.str] update_channel: (Updatable) Analytics instance update channel.
        """
        if admin_user is not None:
            pulumi.set(__self__, "admin_user", admin_user)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if email_notification is not None:
            pulumi.set(__self__, "email_notification", email_notification)
        if feature_bundle is not None:
            pulumi.set(__self__, "feature_bundle", feature_bundle)
        if feature_set is not None:
            pulumi.set(__self__, "feature_set", feature_set)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idcs_access_token is not None:
            pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_endpoint_details is not None:
            pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if update_channel is not None:
            pulumi.set(__self__, "update_channel", update_channel)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        user name of the authorized user.
        """
        return pulumi.get(self, "admin_user")

    @admin_user.setter
    def admin_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_user", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input['AnalyticsInstanceCapacityArgs']]:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input['AnalyticsInstanceCapacityArgs']]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        domain id for which the user is authorized.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @email_notification.setter
    def email_notification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email_notification", value)

    @property
    @pulumi.getter(name="featureBundle")
    def feature_bundle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The feature set of an Analytics instance.
        """
        return pulumi.get(self, "feature_bundle")

    @feature_bundle.setter
    def feature_bundle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_bundle", value)

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Analytics feature set.
        """
        return pulumi.get(self, "feature_set")

    @feature_set.setter
    def feature_set(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_set", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IDCS access token identifying a stripe and service administrator user.
        """
        return pulumi.get(self, "idcs_access_token")

    @idcs_access_token.setter
    def idcs_access_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_access_token", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']]:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @network_endpoint_details.setter
    def network_endpoint_details(self, value: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']]):
        pulumi.set(self, "network_endpoint_details", value)

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the Analytics service.
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_url", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="updateChannel")
    def update_channel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Analytics instance update channel.
        """
        return pulumi.get(self, "update_channel")

    @update_channel.setter
    def update_channel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_channel", value)


class AnalyticsInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_user: Optional[pulumi.Input[builtins.str]] = None,
                 capacity: Optional[pulumi.Input[Union['AnalyticsInstanceCapacityArgs', 'AnalyticsInstanceCapacityArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_notification: Optional[pulumi.Input[builtins.str]] = None,
                 feature_bundle: Optional[pulumi.Input[builtins.str]] = None,
                 feature_set: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_endpoint_details: Optional[pulumi.Input[Union['AnalyticsInstanceNetworkEndpointDetailsArgs', 'AnalyticsInstanceNetworkEndpointDetailsArgsDict']]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_channel: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Analytics Instance resource in Oracle Cloud Infrastructure Analytics service.

        Create a new AnalyticsInstance in the specified compartment. The operation is long-running
        and creates a new WorkRequest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analytics_instance = oci.analytics.AnalyticsInstance("test_analytics_instance",
            capacity={
                "capacity_type": analytics_instance_capacity_capacity_type,
                "capacity_value": analytics_instance_capacity_capacity_value,
            },
            compartment_id=compartment_id,
            feature_set=analytics_instance_feature_set,
            idcs_access_token=analytics_instance_idcs_access_token,
            license_type=analytics_instance_license_type,
            name=analytics_instance_name,
            admin_user=analytics_instance_admin_user,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=analytics_instance_description,
            domain_id=test_domain["id"],
            email_notification=analytics_instance_email_notification,
            feature_bundle=analytics_instance_feature_bundle,
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=test_key["id"],
            network_endpoint_details={
                "network_endpoint_type": analytics_instance_network_endpoint_details_network_endpoint_type,
                "network_security_group_ids": analytics_instance_network_endpoint_details_network_security_group_ids,
                "subnet_id": test_subnet["id"],
                "vcn_id": test_vcn["id"],
                "whitelisted_ips": analytics_instance_network_endpoint_details_whitelisted_ips,
                "whitelisted_services": analytics_instance_network_endpoint_details_whitelisted_services,
                "whitelisted_vcns": [{
                    "id": analytics_instance_network_endpoint_details_whitelisted_vcns_id,
                    "whitelisted_ips": analytics_instance_network_endpoint_details_whitelisted_vcns_whitelisted_ips,
                }],
            },
            update_channel=analytics_instance_update_channel)
        ```

        ## Import

        AnalyticsInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Analytics/analyticsInstance:AnalyticsInstance test_analytics_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admin_user: user name of the authorized user.
        :param pulumi.Input[Union['AnalyticsInstanceCapacityArgs', 'AnalyticsInstanceCapacityArgsDict']] capacity: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Optional description.
        :param pulumi.Input[builtins.str] domain_id: domain id for which the user is authorized.
        :param pulumi.Input[builtins.str] email_notification: (Updatable) Email address receiving notifications.
        :param pulumi.Input[builtins.str] feature_bundle: The feature set of an Analytics instance.
        :param pulumi.Input[builtins.str] feature_set: Analytics feature set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] idcs_access_token: IDCS access token identifying a stripe and service administrator user.
        :param pulumi.Input[builtins.str] kms_key_id: OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        :param pulumi.Input[builtins.str] license_type: (Updatable) The license used for the service.
        :param pulumi.Input[builtins.str] name: The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        :param pulumi.Input[Union['AnalyticsInstanceNetworkEndpointDetailsArgs', 'AnalyticsInstanceNetworkEndpointDetailsArgsDict']] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] update_channel: (Updatable) Analytics instance update channel.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalyticsInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Analytics Instance resource in Oracle Cloud Infrastructure Analytics service.

        Create a new AnalyticsInstance in the specified compartment. The operation is long-running
        and creates a new WorkRequest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analytics_instance = oci.analytics.AnalyticsInstance("test_analytics_instance",
            capacity={
                "capacity_type": analytics_instance_capacity_capacity_type,
                "capacity_value": analytics_instance_capacity_capacity_value,
            },
            compartment_id=compartment_id,
            feature_set=analytics_instance_feature_set,
            idcs_access_token=analytics_instance_idcs_access_token,
            license_type=analytics_instance_license_type,
            name=analytics_instance_name,
            admin_user=analytics_instance_admin_user,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=analytics_instance_description,
            domain_id=test_domain["id"],
            email_notification=analytics_instance_email_notification,
            feature_bundle=analytics_instance_feature_bundle,
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=test_key["id"],
            network_endpoint_details={
                "network_endpoint_type": analytics_instance_network_endpoint_details_network_endpoint_type,
                "network_security_group_ids": analytics_instance_network_endpoint_details_network_security_group_ids,
                "subnet_id": test_subnet["id"],
                "vcn_id": test_vcn["id"],
                "whitelisted_ips": analytics_instance_network_endpoint_details_whitelisted_ips,
                "whitelisted_services": analytics_instance_network_endpoint_details_whitelisted_services,
                "whitelisted_vcns": [{
                    "id": analytics_instance_network_endpoint_details_whitelisted_vcns_id,
                    "whitelisted_ips": analytics_instance_network_endpoint_details_whitelisted_vcns_whitelisted_ips,
                }],
            },
            update_channel=analytics_instance_update_channel)
        ```

        ## Import

        AnalyticsInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Analytics/analyticsInstance:AnalyticsInstance test_analytics_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param AnalyticsInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyticsInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_user: Optional[pulumi.Input[builtins.str]] = None,
                 capacity: Optional[pulumi.Input[Union['AnalyticsInstanceCapacityArgs', 'AnalyticsInstanceCapacityArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_notification: Optional[pulumi.Input[builtins.str]] = None,
                 feature_bundle: Optional[pulumi.Input[builtins.str]] = None,
                 feature_set: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_endpoint_details: Optional[pulumi.Input[Union['AnalyticsInstanceNetworkEndpointDetailsArgs', 'AnalyticsInstanceNetworkEndpointDetailsArgsDict']]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_channel: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyticsInstanceArgs.__new__(AnalyticsInstanceArgs)

            __props__.__dict__["admin_user"] = admin_user
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["domain_id"] = domain_id
            __props__.__dict__["email_notification"] = email_notification
            __props__.__dict__["feature_bundle"] = feature_bundle
            if feature_set is None and not opts.urn:
                raise TypeError("Missing required property 'feature_set'")
            __props__.__dict__["feature_set"] = feature_set
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["idcs_access_token"] = None if idcs_access_token is None else pulumi.Output.secret(idcs_access_token)
            __props__.__dict__["kms_key_id"] = kms_key_id
            if license_type is None and not opts.urn:
                raise TypeError("Missing required property 'license_type'")
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["name"] = name
            __props__.__dict__["network_endpoint_details"] = network_endpoint_details
            __props__.__dict__["state"] = state
            __props__.__dict__["update_channel"] = update_channel
            __props__.__dict__["service_url"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["idcsAccessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AnalyticsInstance, __self__).__init__(
            'oci:Analytics/analyticsInstance:AnalyticsInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_user: Optional[pulumi.Input[builtins.str]] = None,
            capacity: Optional[pulumi.Input[Union['AnalyticsInstanceCapacityArgs', 'AnalyticsInstanceCapacityArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain_id: Optional[pulumi.Input[builtins.str]] = None,
            email_notification: Optional[pulumi.Input[builtins.str]] = None,
            feature_bundle: Optional[pulumi.Input[builtins.str]] = None,
            feature_set: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            idcs_access_token: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            license_type: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_endpoint_details: Optional[pulumi.Input[Union['AnalyticsInstanceNetworkEndpointDetailsArgs', 'AnalyticsInstanceNetworkEndpointDetailsArgsDict']]] = None,
            service_url: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            update_channel: Optional[pulumi.Input[builtins.str]] = None) -> 'AnalyticsInstance':
        """
        Get an existing AnalyticsInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] admin_user: user name of the authorized user.
        :param pulumi.Input[Union['AnalyticsInstanceCapacityArgs', 'AnalyticsInstanceCapacityArgsDict']] capacity: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) Optional description.
        :param pulumi.Input[builtins.str] domain_id: domain id for which the user is authorized.
        :param pulumi.Input[builtins.str] email_notification: (Updatable) Email address receiving notifications.
        :param pulumi.Input[builtins.str] feature_bundle: The feature set of an Analytics instance.
        :param pulumi.Input[builtins.str] feature_set: Analytics feature set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] idcs_access_token: IDCS access token identifying a stripe and service administrator user.
        :param pulumi.Input[builtins.str] kms_key_id: OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        :param pulumi.Input[builtins.str] license_type: (Updatable) The license used for the service.
        :param pulumi.Input[builtins.str] name: The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        :param pulumi.Input[Union['AnalyticsInstanceNetworkEndpointDetailsArgs', 'AnalyticsInstanceNetworkEndpointDetailsArgsDict']] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[builtins.str] service_url: URL of the Analytics service.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.key": "value"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        :param pulumi.Input[builtins.str] update_channel: (Updatable) Analytics instance update channel.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalyticsInstanceState.__new__(_AnalyticsInstanceState)

        __props__.__dict__["admin_user"] = admin_user
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["email_notification"] = email_notification
        __props__.__dict__["feature_bundle"] = feature_bundle
        __props__.__dict__["feature_set"] = feature_set
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["idcs_access_token"] = idcs_access_token
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["name"] = name
        __props__.__dict__["network_endpoint_details"] = network_endpoint_details
        __props__.__dict__["service_url"] = service_url
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["update_channel"] = update_channel
        return AnalyticsInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> pulumi.Output[builtins.str]:
        """
        user name of the authorized user.
        """
        return pulumi.get(self, "admin_user")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output['outputs.AnalyticsInstanceCapacity']:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Optional description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        domain id for which the user is authorized.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @property
    @pulumi.getter(name="featureBundle")
    def feature_bundle(self) -> pulumi.Output[builtins.str]:
        """
        The feature set of an Analytics instance.
        """
        return pulumi.get(self, "feature_bundle")

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> pulumi.Output[builtins.str]:
        """
        Analytics feature set.
        """
        return pulumi.get(self, "feature_set")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IDCS access token identifying a stripe and service administrator user.
        """
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> pulumi.Output['outputs.AnalyticsInstanceNetworkEndpointDetails']:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> pulumi.Output[builtins.str]:
        """
        URL of the Analytics service.
        """
        return pulumi.get(self, "service_url")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updateChannel")
    def update_channel(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Analytics instance update channel.
        """
        return pulumi.get(self, "update_channel")

