# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigDimension',
    'ConfigInUseBy',
    'ConfigMetric',
    'ConfigRule',
    'GetConfigDimensionResult',
    'GetConfigInUseByResult',
    'GetConfigMetricResult',
    'GetConfigRuleResult',
    'GetConfigsConfigCollectionResult',
    'GetConfigsConfigCollectionItemResult',
    'GetConfigsConfigCollectionItemDimensionResult',
    'GetConfigsConfigCollectionItemInUseByResult',
    'GetConfigsConfigCollectionItemMetricResult',
    'GetConfigsConfigCollectionItemRuleResult',
    'GetConfigsFilterResult',
]

@pulumi.output_type
class ConfigDimension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value_source: Optional[builtins.str] = None):
        """
        :param builtins.str name: (Updatable) The name of the dimension.
        :param builtins.str value_source: (Updatable) The source to populate the dimension. This must not be specified.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Updatable) The name of the dimension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional[builtins.str]:
        """
        (Updatable) The source to populate the dimension. This must not be specified.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class ConfigInUseBy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configType":
            suggest = "config_type"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "optionsGroup":
            suggest = "options_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigInUseBy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigInUseBy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigInUseBy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_type: Optional[builtins.str] = None,
                 display_name: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 options_group: Optional[builtins.str] = None):
        """
        :param builtins.str config_type: (Updatable) The type of configuration item.
        :param builtins.str display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        :param builtins.str options_group: A string that specifies the group that an OPTIONS item belongs to.
        """
        if config_type is not None:
            pulumi.set(__self__, "config_type", config_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if options_group is not None:
            pulumi.set(__self__, "options_group", options_group)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[builtins.str]:
        """
        (Updatable) The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="optionsGroup")
    def options_group(self) -> Optional[builtins.str]:
        """
        A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "options_group")


@pulumi.output_type
class ConfigMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 unit: Optional[builtins.str] = None,
                 value_source: Optional[builtins.str] = None):
        """
        :param builtins.str description: (Updatable) A description of the metric.
        :param builtins.str name: (Updatable) The name of the metric. This must be a known metric name.
        :param builtins.str unit: (Updatable) The unit of the metric.
        :param builtins.str value_source: (Updatable) This must not be set.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        (Updatable) A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        (Updatable) The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> Optional[builtins.str]:
        """
        (Updatable) The unit of the metric.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional[builtins.str]:
        """
        (Updatable) This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class ConfigRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "filterText":
            suggest = "filter_text"
        elif key == "isApplyToErrorSpans":
            suggest = "is_apply_to_error_spans"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "satisfiedResponseTime":
            suggest = "satisfied_response_time"
        elif key == "toleratingResponseTime":
            suggest = "tolerating_response_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[builtins.str] = None,
                 filter_text: Optional[builtins.str] = None,
                 is_apply_to_error_spans: Optional[builtins.bool] = None,
                 is_enabled: Optional[builtins.bool] = None,
                 priority: Optional[builtins.int] = None,
                 satisfied_response_time: Optional[builtins.int] = None,
                 tolerating_response_time: Optional[builtins.int] = None):
        """
        :param builtins.str display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param builtins.str filter_text: (Updatable) The string that defines the Span Filter expression.
        :param builtins.bool is_apply_to_error_spans: (Updatable) Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        :param builtins.bool is_enabled: (Updatable) Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        :param builtins.int priority: (Updatable) The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        :param builtins.int satisfied_response_time: (Updatable) The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        :param builtins.int tolerating_response_time: (Updatable) The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime". 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filter_text is not None:
            pulumi.set(__self__, "filter_text", filter_text)
        if is_apply_to_error_spans is not None:
            pulumi.set(__self__, "is_apply_to_error_spans", is_apply_to_error_spans)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if satisfied_response_time is not None:
            pulumi.set(__self__, "satisfied_response_time", satisfied_response_time)
        if tolerating_response_time is not None:
            pulumi.set(__self__, "tolerating_response_time", tolerating_response_time)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> Optional[builtins.str]:
        """
        (Updatable) The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="isApplyToErrorSpans")
    def is_apply_to_error_spans(self) -> Optional[builtins.bool]:
        """
        (Updatable) Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        """
        return pulumi.get(self, "is_apply_to_error_spans")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[builtins.bool]:
        """
        (Updatable) Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        (Updatable) The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="satisfiedResponseTime")
    def satisfied_response_time(self) -> Optional[builtins.int]:
        """
        (Updatable) The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        """
        return pulumi.get(self, "satisfied_response_time")

    @property
    @pulumi.getter(name="toleratingResponseTime")
    def tolerating_response_time(self) -> Optional[builtins.int]:
        """
        (Updatable) The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime". 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tolerating_response_time")


@pulumi.output_type
class GetConfigDimensionResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value_source: builtins.str):
        """
        :param builtins.str name: The name of the metric. This must be a known metric name.
        :param builtins.str value_source: This must not be set.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> builtins.str:
        """
        This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GetConfigInUseByResult(dict):
    def __init__(__self__, *,
                 config_type: builtins.str,
                 display_name: builtins.str,
                 id: builtins.str,
                 options_group: builtins.str):
        """
        :param builtins.str config_type: The type of configuration item.
        :param builtins.str display_name: The name by which a configuration entity is displayed to the end user.
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        :param builtins.str options_group: A string that specifies the group that an OPTIONS item belongs to.
        """
        pulumi.set(__self__, "config_type", config_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "options_group", options_group)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> builtins.str:
        """
        The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="optionsGroup")
    def options_group(self) -> builtins.str:
        """
        A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "options_group")


@pulumi.output_type
class GetConfigMetricResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 name: builtins.str,
                 unit: builtins.str,
                 value_source: builtins.str):
        """
        :param builtins.str description: A description of the metric.
        :param builtins.str name: The name of the metric. This must be a known metric name.
        :param builtins.str unit: The unit of the metric.
        :param builtins.str value_source: This must not be set.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        """
        The unit of the metric.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> builtins.str:
        """
        This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GetConfigRuleResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 filter_text: builtins.str,
                 is_apply_to_error_spans: builtins.bool,
                 is_enabled: builtins.bool,
                 priority: builtins.int,
                 satisfied_response_time: builtins.int,
                 tolerating_response_time: builtins.int):
        """
        :param builtins.str display_name: The name by which a configuration entity is displayed to the end user.
        :param builtins.str filter_text: The string that defines the Span Filter expression.
        :param builtins.bool is_apply_to_error_spans: Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        :param builtins.bool is_enabled: Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        :param builtins.int priority: The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        :param builtins.int satisfied_response_time: The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        :param builtins.int tolerating_response_time: The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime".
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "filter_text", filter_text)
        pulumi.set(__self__, "is_apply_to_error_spans", is_apply_to_error_spans)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "satisfied_response_time", satisfied_response_time)
        pulumi.set(__self__, "tolerating_response_time", tolerating_response_time)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> builtins.str:
        """
        The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="isApplyToErrorSpans")
    def is_apply_to_error_spans(self) -> builtins.bool:
        """
        Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        """
        return pulumi.get(self, "is_apply_to_error_spans")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="satisfiedResponseTime")
    def satisfied_response_time(self) -> builtins.int:
        """
        The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        """
        return pulumi.get(self, "satisfied_response_time")

    @property
    @pulumi.getter(name="toleratingResponseTime")
    def tolerating_response_time(self) -> builtins.int:
        """
        The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime".
        """
        return pulumi.get(self, "tolerating_response_time")


@pulumi.output_type
class GetConfigsConfigCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigsConfigCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigsConfigCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigsConfigCollectionItemResult(dict):
    def __init__(__self__, *,
                 apm_domain_id: builtins.str,
                 config_type: builtins.str,
                 created_by: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 dimensions: Sequence['outputs.GetConfigsConfigCollectionItemDimensionResult'],
                 display_name: builtins.str,
                 etag: builtins.str,
                 filter_id: builtins.str,
                 filter_text: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 group: builtins.str,
                 id: builtins.str,
                 in_use_bies: Sequence['outputs.GetConfigsConfigCollectionItemInUseByResult'],
                 metrics: Sequence['outputs.GetConfigsConfigCollectionItemMetricResult'],
                 namespace: builtins.str,
                 opc_dry_run: builtins.str,
                 options: builtins.str,
                 rules: Sequence['outputs.GetConfigsConfigCollectionItemRuleResult'],
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 updated_by: builtins.str):
        """
        :param builtins.str apm_domain_id: The APM Domain ID the request is intended for.
        :param builtins.str config_type: A filter to match configuration items of a given type. Supported values are SPAN_FILTER, METRIC_GROUP, and APDEX.
        :param builtins.str created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A description of the metric.
        :param Sequence['GetConfigsConfigCollectionItemDimensionArgs'] dimensions: A list of dimensions for the metric. This variable should not be used.
        :param builtins.str display_name: A filter to return resources that match the given display name.
        :param builtins.str etag: For optimistic concurrency control. See `if-match`.
        :param builtins.str filter_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param builtins.str filter_text: The string that defines the Span Filter expression.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str group: A string that specifies the group that an OPTIONS item belongs to.
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        :param Sequence['GetConfigsConfigCollectionItemInUseByArgs'] in_use_bies: The list of configuration items that reference the span filter.
        :param Sequence['GetConfigsConfigCollectionItemMetricArgs'] metrics: The list of metrics in this group.
        :param builtins.str namespace: The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param builtins.str options: The options are stored here as JSON.
        :param builtins.str time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param builtins.str time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param builtins.str updated_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        pulumi.set(__self__, "config_type", config_type)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "filter_id", filter_id)
        pulumi.set(__self__, "filter_text", filter_text)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_use_bies", in_use_bies)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> builtins.str:
        """
        The APM Domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> builtins.str:
        """
        A filter to match configuration items of a given type. Supported values are SPAN_FILTER, METRIC_GROUP, and APDEX.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetConfigsConfigCollectionItemDimensionResult']:
        """
        A list of dimensions for the metric. This variable should not be used.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        For optimistic concurrency control. See `if-match`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        """
        return pulumi.get(self, "filter_id")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> builtins.str:
        """
        The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def group(self) -> builtins.str:
        """
        A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inUseBies")
    def in_use_bies(self) -> Sequence['outputs.GetConfigsConfigCollectionItemInUseByResult']:
        """
        The list of configuration items that reference the span filter.
        """
        return pulumi.get(self, "in_use_bies")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetConfigsConfigCollectionItemMetricResult']:
        """
        The list of metrics in this group.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace to which the metrics are published. It must be one of several predefined namespaces.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> builtins.str:
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter
    def options(self) -> builtins.str:
        """
        The options are stored here as JSON.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetConfigsConfigCollectionItemRuleResult']:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "updated_by")


@pulumi.output_type
class GetConfigsConfigCollectionItemDimensionResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value_source: builtins.str):
        """
        :param builtins.str name: The name of the metric. This must be a known metric name.
        :param builtins.str value_source: This must not be set.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> builtins.str:
        """
        This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GetConfigsConfigCollectionItemInUseByResult(dict):
    def __init__(__self__, *,
                 config_type: builtins.str,
                 display_name: builtins.str,
                 id: builtins.str,
                 options_group: builtins.str):
        """
        :param builtins.str config_type: A filter to match configuration items of a given type. Supported values are SPAN_FILTER, METRIC_GROUP, and APDEX.
        :param builtins.str display_name: A filter to return resources that match the given display name.
        :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        :param builtins.str options_group: A filter to return OPTIONS resources that match the given group.
        """
        pulumi.set(__self__, "config_type", config_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "options_group", options_group)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> builtins.str:
        """
        A filter to match configuration items of a given type. Supported values are SPAN_FILTER, METRIC_GROUP, and APDEX.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="optionsGroup")
    def options_group(self) -> builtins.str:
        """
        A filter to return OPTIONS resources that match the given group.
        """
        return pulumi.get(self, "options_group")


@pulumi.output_type
class GetConfigsConfigCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 name: builtins.str,
                 unit: builtins.str,
                 value_source: builtins.str):
        """
        :param builtins.str description: A description of the metric.
        :param builtins.str name: The name of the metric. This must be a known metric name.
        :param builtins.str unit: The unit of the metric.
        :param builtins.str value_source: This must not be set.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        """
        The unit of the metric.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> builtins.str:
        """
        This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GetConfigsConfigCollectionItemRuleResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 filter_text: builtins.str,
                 is_apply_to_error_spans: builtins.bool,
                 is_enabled: builtins.bool,
                 priority: builtins.int,
                 satisfied_response_time: builtins.int,
                 tolerating_response_time: builtins.int):
        """
        :param builtins.str display_name: A filter to return resources that match the given display name.
        :param builtins.str filter_text: The string that defines the Span Filter expression.
        :param builtins.bool is_apply_to_error_spans: Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        :param builtins.bool is_enabled: Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        :param builtins.int priority: The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        :param builtins.int satisfied_response_time: The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        :param builtins.int tolerating_response_time: The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime".
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "filter_text", filter_text)
        pulumi.set(__self__, "is_apply_to_error_spans", is_apply_to_error_spans)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "satisfied_response_time", satisfied_response_time)
        pulumi.set(__self__, "tolerating_response_time", tolerating_response_time)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> builtins.str:
        """
        The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="isApplyToErrorSpans")
    def is_apply_to_error_spans(self) -> builtins.bool:
        """
        Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        """
        return pulumi.get(self, "is_apply_to_error_spans")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="satisfiedResponseTime")
    def satisfied_response_time(self) -> builtins.int:
        """
        The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        """
        return pulumi.get(self, "satisfied_response_time")

    @property
    @pulumi.getter(name="toleratingResponseTime")
    def tolerating_response_time(self) -> builtins.int:
        """
        The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime".
        """
        return pulumi.get(self, "tolerating_response_time")


@pulumi.output_type
class GetConfigsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name of the metric. This must be a known metric name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


