# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVantagePointsResult',
    'AwaitableGetVantagePointsResult',
    'get_vantage_points',
    'get_vantage_points_output',
]

@pulumi.output_type
class GetVantagePointsResult:
    """
    A collection of values returned by getVantagePoints.
    """
    def __init__(__self__, apm_domain_id=None, display_name=None, filters=None, id=None, name=None, public_vantage_point_collections=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_vantage_point_collections and not isinstance(public_vantage_point_collections, list):
            raise TypeError("Expected argument 'public_vantage_point_collections' to be a list")
        pulumi.set(__self__, "public_vantage_point_collections", public_vantage_point_collections)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVantagePointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Unique permanent name of the vantage point.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicVantagePointCollections")
    def public_vantage_point_collections(self) -> Sequence['outputs.GetVantagePointsPublicVantagePointCollectionResult']:
        """
        The list of public_vantage_point_collection.
        """
        return pulumi.get(self, "public_vantage_point_collections")


class AwaitableGetVantagePointsResult(GetVantagePointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVantagePointsResult(
            apm_domain_id=self.apm_domain_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            name=self.name,
            public_vantage_point_collections=self.public_vantage_point_collections)


def get_vantage_points(apm_domain_id: Optional[builtins.str] = None,
                       display_name: Optional[builtins.str] = None,
                       filters: Optional[Sequence[Union['GetVantagePointsFilterArgs', 'GetVantagePointsFilterArgsDict']]] = None,
                       name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVantagePointsResult:
    """
    This data source provides the list of Public Vantage Points in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Returns a list of public vantage points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_vantage_points = oci.ApmSynthetics.get_vantage_points(apm_domain_id=test_apm_domain["id"],
        display_name=public_vantage_point_display_name,
        name=public_vantage_point_name)
    ```


    :param builtins.str apm_domain_id: The APM domain ID the request is intended for.
    :param builtins.str display_name: A filter to return only the resources that match the entire display name.
    :param builtins.str name: A filter to return only the resources that match the entire name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getVantagePoints:getVantagePoints', __args__, opts=opts, typ=GetVantagePointsResult).value

    return AwaitableGetVantagePointsResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        public_vantage_point_collections=pulumi.get(__ret__, 'public_vantage_point_collections'))
def get_vantage_points_output(apm_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                              display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVantagePointsFilterArgs', 'GetVantagePointsFilterArgsDict']]]]] = None,
                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVantagePointsResult]:
    """
    This data source provides the list of Public Vantage Points in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Returns a list of public vantage points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_vantage_points = oci.ApmSynthetics.get_vantage_points(apm_domain_id=test_apm_domain["id"],
        display_name=public_vantage_point_display_name,
        name=public_vantage_point_name)
    ```


    :param builtins.str apm_domain_id: The APM domain ID the request is intended for.
    :param builtins.str display_name: A filter to return only the resources that match the entire display name.
    :param builtins.str name: A filter to return only the resources that match the entire name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmSynthetics/getVantagePoints:getVantagePoints', __args__, opts=opts, typ=GetVantagePointsResult)
    return __ret__.apply(lambda __response__: GetVantagePointsResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        public_vantage_point_collections=pulumi.get(__response__, 'public_vantage_point_collections')))
