# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstancesResult',
    'AwaitableGetBdsInstancesResult',
    'get_bds_instances',
    'get_bds_instances_output',
]

@pulumi.output_type
class GetBdsInstancesResult:
    """
    A collection of values returned by getBdsInstances.
    """
    def __init__(__self__, bds_instances=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if bds_instances and not isinstance(bds_instances, list):
            raise TypeError("Expected argument 'bds_instances' to be a list")
        pulumi.set(__self__, "bds_instances", bds_instances)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="bdsInstances")
    def bds_instances(self) -> Sequence['outputs.GetBdsInstancesBdsInstanceResult']:
        """
        The list of bds_instances.
        """
        return pulumi.get(self, "bds_instances")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The name of the node.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the cluster.
        """
        return pulumi.get(self, "state")


class AwaitableGetBdsInstancesResult(GetBdsInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstancesResult(
            bds_instances=self.bds_instances,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_bds_instances(compartment_id: Optional[builtins.str] = None,
                      display_name: Optional[builtins.str] = None,
                      filters: Optional[Sequence[Union['GetBdsInstancesFilterArgs', 'GetBdsInstancesFilterArgsDict']]] = None,
                      state: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstancesResult:
    """
    This data source provides the list of Bds Instances in Oracle Cloud Infrastructure Big Data Service service.

    Returns a list of all Big Data Service clusters in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instances = oci.BigDataService.get_bds_instances(compartment_id=compartment_id,
        display_name=bds_instance_display_name,
        state=bds_instance_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: The state of the cluster.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstances:getBdsInstances', __args__, opts=opts, typ=GetBdsInstancesResult).value

    return AwaitableGetBdsInstancesResult(
        bds_instances=pulumi.get(__ret__, 'bds_instances'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_bds_instances_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBdsInstancesFilterArgs', 'GetBdsInstancesFilterArgsDict']]]]] = None,
                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstancesResult]:
    """
    This data source provides the list of Bds Instances in Oracle Cloud Infrastructure Big Data Service service.

    Returns a list of all Big Data Service clusters in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instances = oci.BigDataService.get_bds_instances(compartment_id=compartment_id,
        display_name=bds_instance_display_name,
        state=bds_instance_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: The state of the cluster.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstances:getBdsInstances', __args__, opts=opts, typ=GetBdsInstancesResult)
    return __ret__.apply(lambda __response__: GetBdsInstancesResult(
        bds_instances=pulumi.get(__response__, 'bds_instances'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
