# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BlockchainPlatformComponentDetail',
    'BlockchainPlatformComponentDetailOsn',
    'BlockchainPlatformComponentDetailOsnOcpuAllocationParam',
    'BlockchainPlatformComponentDetailPeer',
    'BlockchainPlatformComponentDetailPeerOcpuAllocationParam',
    'BlockchainPlatformHostOcpuUtilizationInfo',
    'BlockchainPlatformReplicas',
    'OsnOcpuAllocationParam',
    'PeerOcpuAllocationParam',
    'GetBlockchainPlatformComponentDetailResult',
    'GetBlockchainPlatformComponentDetailOsnResult',
    'GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult',
    'GetBlockchainPlatformComponentDetailPeerResult',
    'GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult',
    'GetBlockchainPlatformHostOcpuUtilizationInfoResult',
    'GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionResult',
    'GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult',
    'GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult',
    'GetBlockchainPlatformPatchesFilterResult',
    'GetBlockchainPlatformReplicaResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult',
    'GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult',
    'GetBlockchainPlatformsFilterResult',
    'GetOsnOcpuAllocationParamResult',
    'GetOsnsFilterResult',
    'GetOsnsOsnCollectionResult',
    'GetOsnsOsnCollectionItemResult',
    'GetOsnsOsnCollectionItemOcpuAllocationParamResult',
    'GetPeerOcpuAllocationParamResult',
    'GetPeersFilterResult',
    'GetPeersPeerCollectionResult',
    'GetPeersPeerCollectionItemResult',
    'GetPeersPeerCollectionItemOcpuAllocationParamResult',
]

@pulumi.output_type
class BlockchainPlatformComponentDetail(dict):
    def __init__(__self__, *,
                 osns: Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsn']] = None,
                 peers: Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeer']] = None):
        """
        :param Sequence['BlockchainPlatformComponentDetailOsnArgs'] osns: List of OSNs
        :param Sequence['BlockchainPlatformComponentDetailPeerArgs'] peers: List of Peers
        """
        if osns is not None:
            pulumi.set(__self__, "osns", osns)
        if peers is not None:
            pulumi.set(__self__, "peers", peers)

    @property
    @pulumi.getter
    def osns(self) -> Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsn']]:
        """
        List of OSNs
        """
        return pulumi.get(self, "osns")

    @property
    @pulumi.getter
    def peers(self) -> Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeer']]:
        """
        List of Peers
        """
        return pulumi.get(self, "peers")


@pulumi.output_type
class BlockchainPlatformComponentDetailOsn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationParams":
            suggest = "ocpu_allocation_params"
        elif key == "osnKey":
            suggest = "osn_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformComponentDetailOsn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformComponentDetailOsn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformComponentDetailOsn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad: Optional[builtins.str] = None,
                 ocpu_allocation_params: Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsnOcpuAllocationParam']] = None,
                 osn_key: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str ad: Availability Domain of peer
        :param Sequence['BlockchainPlatformComponentDetailOsnOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param builtins.str osn_key: OSN identifier
        :param builtins.str state: The current state of the Platform Instance.
        """
        if ad is not None:
            pulumi.set(__self__, "ad", ad)
        if ocpu_allocation_params is not None:
            pulumi.set(__self__, "ocpu_allocation_params", ocpu_allocation_params)
        if osn_key is not None:
            pulumi.set(__self__, "osn_key", osn_key)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> Optional[builtins.str]:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Optional[Sequence['outputs.BlockchainPlatformComponentDetailOsnOcpuAllocationParam']]:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> Optional[builtins.str]:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BlockchainPlatformComponentDetailOsnOcpuAllocationParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationNumber":
            suggest = "ocpu_allocation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformComponentDetailOsnOcpuAllocationParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformComponentDetailOsnOcpuAllocationParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformComponentDetailOsnOcpuAllocationParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpu_allocation_number: Optional[builtins.float] = None):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        if ocpu_allocation_number is not None:
            pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> Optional[builtins.float]:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class BlockchainPlatformComponentDetailPeer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationParams":
            suggest = "ocpu_allocation_params"
        elif key == "peerKey":
            suggest = "peer_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformComponentDetailPeer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformComponentDetailPeer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformComponentDetailPeer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad: Optional[builtins.str] = None,
                 alias: Optional[builtins.str] = None,
                 host: Optional[builtins.str] = None,
                 ocpu_allocation_params: Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeerOcpuAllocationParam']] = None,
                 peer_key: Optional[builtins.str] = None,
                 role: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str ad: Availability Domain of peer
        :param builtins.str alias: peer alias
        :param builtins.str host: Host name of VM
        :param Sequence['BlockchainPlatformComponentDetailPeerOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param builtins.str peer_key: peer identifier
        :param builtins.str role: Peer role
        :param builtins.str state: The current state of the Platform Instance.
        """
        if ad is not None:
            pulumi.set(__self__, "ad", ad)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ocpu_allocation_params is not None:
            pulumi.set(__self__, "ocpu_allocation_params", ocpu_allocation_params)
        if peer_key is not None:
            pulumi.set(__self__, "peer_key", peer_key)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> Optional[builtins.str]:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter
    def alias(self) -> Optional[builtins.str]:
        """
        peer alias
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Optional[Sequence['outputs.BlockchainPlatformComponentDetailPeerOcpuAllocationParam']]:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="peerKey")
    def peer_key(self) -> Optional[builtins.str]:
        """
        peer identifier
        """
        return pulumi.get(self, "peer_key")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        Peer role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BlockchainPlatformComponentDetailPeerOcpuAllocationParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationNumber":
            suggest = "ocpu_allocation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformComponentDetailPeerOcpuAllocationParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformComponentDetailPeerOcpuAllocationParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformComponentDetailPeerOcpuAllocationParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpu_allocation_number: Optional[builtins.float] = None):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        if ocpu_allocation_number is not None:
            pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> Optional[builtins.float]:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class BlockchainPlatformHostOcpuUtilizationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuCapacityNumber":
            suggest = "ocpu_capacity_number"
        elif key == "ocpuUtilizationNumber":
            suggest = "ocpu_utilization_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformHostOcpuUtilizationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformHostOcpuUtilizationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformHostOcpuUtilizationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Optional[builtins.str] = None,
                 ocpu_capacity_number: Optional[builtins.float] = None,
                 ocpu_utilization_number: Optional[builtins.float] = None):
        """
        :param builtins.str host: Host name of VM
        :param builtins.float ocpu_capacity_number: Number of total OCPU capacity on the host
        :param builtins.float ocpu_utilization_number: Number of OCPU utilized
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ocpu_capacity_number is not None:
            pulumi.set(__self__, "ocpu_capacity_number", ocpu_capacity_number)
        if ocpu_utilization_number is not None:
            pulumi.set(__self__, "ocpu_utilization_number", ocpu_utilization_number)

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuCapacityNumber")
    def ocpu_capacity_number(self) -> Optional[builtins.float]:
        """
        Number of total OCPU capacity on the host
        """
        return pulumi.get(self, "ocpu_capacity_number")

    @property
    @pulumi.getter(name="ocpuUtilizationNumber")
    def ocpu_utilization_number(self) -> Optional[builtins.float]:
        """
        Number of OCPU utilized
        """
        return pulumi.get(self, "ocpu_utilization_number")


@pulumi.output_type
class BlockchainPlatformReplicas(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCount":
            suggest = "ca_count"
        elif key == "consoleCount":
            suggest = "console_count"
        elif key == "proxyCount":
            suggest = "proxy_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainPlatformReplicas. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainPlatformReplicas.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainPlatformReplicas.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_count: Optional[builtins.int] = None,
                 console_count: Optional[builtins.int] = None,
                 proxy_count: Optional[builtins.int] = None):
        """
        :param builtins.int ca_count: Number of CA replicas
        :param builtins.int console_count: Number of console replicas
        :param builtins.int proxy_count: Number of REST proxy replicas
        """
        if ca_count is not None:
            pulumi.set(__self__, "ca_count", ca_count)
        if console_count is not None:
            pulumi.set(__self__, "console_count", console_count)
        if proxy_count is not None:
            pulumi.set(__self__, "proxy_count", proxy_count)

    @property
    @pulumi.getter(name="caCount")
    def ca_count(self) -> Optional[builtins.int]:
        """
        Number of CA replicas
        """
        return pulumi.get(self, "ca_count")

    @property
    @pulumi.getter(name="consoleCount")
    def console_count(self) -> Optional[builtins.int]:
        """
        Number of console replicas
        """
        return pulumi.get(self, "console_count")

    @property
    @pulumi.getter(name="proxyCount")
    def proxy_count(self) -> Optional[builtins.int]:
        """
        Number of REST proxy replicas
        """
        return pulumi.get(self, "proxy_count")


@pulumi.output_type
class OsnOcpuAllocationParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationNumber":
            suggest = "ocpu_allocation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsnOcpuAllocationParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsnOcpuAllocationParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsnOcpuAllocationParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: (Updatable) Number of OCPU allocation
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        (Updatable) Number of OCPU allocation


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class PeerOcpuAllocationParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocpuAllocationNumber":
            suggest = "ocpu_allocation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PeerOcpuAllocationParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PeerOcpuAllocationParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PeerOcpuAllocationParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: (Updatable) Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        (Updatable) Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailResult(dict):
    def __init__(__self__, *,
                 osns: Sequence['outputs.GetBlockchainPlatformComponentDetailOsnResult'],
                 peers: Sequence['outputs.GetBlockchainPlatformComponentDetailPeerResult']):
        """
        :param Sequence['GetBlockchainPlatformComponentDetailOsnArgs'] osns: List of OSNs
        :param Sequence['GetBlockchainPlatformComponentDetailPeerArgs'] peers: List of Peers
        """
        pulumi.set(__self__, "osns", osns)
        pulumi.set(__self__, "peers", peers)

    @property
    @pulumi.getter
    def osns(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailOsnResult']:
        """
        List of OSNs
        """
        return pulumi.get(self, "osns")

    @property
    @pulumi.getter
    def peers(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailPeerResult']:
        """
        List of Peers
        """
        return pulumi.get(self, "peers")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailOsnResult(dict):
    def __init__(__self__, *,
                 ad: builtins.str,
                 ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult'],
                 osn_key: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str ad: Availability Domain of peer
        :param Sequence['GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param builtins.str osn_key: OSN identifier
        :param builtins.str state: The current state of the Platform Instance.
        """
        pulumi.set(__self__, "ad", ad)
        pulumi.set(__self__, "ocpu_allocation_params", ocpu_allocation_params)
        pulumi.set(__self__, "osn_key", osn_key)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> builtins.str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> builtins.str:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailOsnOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailPeerResult(dict):
    def __init__(__self__, *,
                 ad: builtins.str,
                 alias: builtins.str,
                 host: builtins.str,
                 ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult'],
                 peer_key: builtins.str,
                 role: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str ad: Availability Domain of peer
        :param builtins.str alias: peer alias
        :param builtins.str host: Host name of VM
        :param Sequence['GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param builtins.str peer_key: peer identifier
        :param builtins.str role: Peer role
        :param builtins.str state: The current state of the Platform Instance.
        """
        pulumi.set(__self__, "ad", ad)
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ocpu_allocation_params", ocpu_allocation_params)
        pulumi.set(__self__, "peer_key", peer_key)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> builtins.str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        peer alias
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="peerKey")
    def peer_key(self) -> builtins.str:
        """
        peer identifier
        """
        return pulumi.get(self, "peer_key")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Peer role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBlockchainPlatformComponentDetailPeerOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformHostOcpuUtilizationInfoResult(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 ocpu_capacity_number: builtins.float,
                 ocpu_utilization_number: builtins.float):
        """
        :param builtins.str host: Host name of VM
        :param builtins.float ocpu_capacity_number: Number of total OCPU capacity on the host
        :param builtins.float ocpu_utilization_number: Number of OCPU utilized
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ocpu_capacity_number", ocpu_capacity_number)
        pulumi.set(__self__, "ocpu_utilization_number", ocpu_utilization_number)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuCapacityNumber")
    def ocpu_capacity_number(self) -> builtins.float:
        """
        Number of total OCPU capacity on the host
        """
        return pulumi.get(self, "ocpu_capacity_number")

    @property
    @pulumi.getter(name="ocpuUtilizationNumber")
    def ocpu_utilization_number(self) -> builtins.float:
        """
        Number of OCPU utilized
        """
        return pulumi.get(self, "ocpu_utilization_number")


@pulumi.output_type
class GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult']):
        """
        :param Sequence['GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemArgs'] items: Collection of PatchSummary
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult']:
        """
        Collection of PatchSummary
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult']):
        """
        :param Sequence['GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemArgs'] items: Collection of PatchSummary
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult']:
        """
        Collection of PatchSummary
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 patch_info_url: builtins.str,
                 service_version: builtins.str,
                 time_patch_due: builtins.str):
        """
        :param builtins.str id: patch id
        :param builtins.str patch_info_url: A URL for the patch specific documentation
        :param builtins.str service_version: patch service version
        :param builtins.str time_patch_due: patch due date for customer initiated patching
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "patch_info_url", patch_info_url)
        pulumi.set(__self__, "service_version", service_version)
        pulumi.set(__self__, "time_patch_due", time_patch_due)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        patch id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="patchInfoUrl")
    def patch_info_url(self) -> builtins.str:
        """
        A URL for the patch specific documentation
        """
        return pulumi.get(self, "patch_info_url")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> builtins.str:
        """
        patch service version
        """
        return pulumi.get(self, "service_version")

    @property
    @pulumi.getter(name="timePatchDue")
    def time_patch_due(self) -> builtins.str:
        """
        patch due date for customer initiated patching
        """
        return pulumi.get(self, "time_patch_due")


@pulumi.output_type
class GetBlockchainPlatformPatchesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetBlockchainPlatformReplicaResult(dict):
    def __init__(__self__, *,
                 ca_count: builtins.int,
                 console_count: builtins.int,
                 proxy_count: builtins.int):
        """
        :param builtins.int ca_count: Number of CA replicas
        :param builtins.int console_count: Number of console replicas
        :param builtins.int proxy_count: Number of REST proxy replicas
        """
        pulumi.set(__self__, "ca_count", ca_count)
        pulumi.set(__self__, "console_count", console_count)
        pulumi.set(__self__, "proxy_count", proxy_count)

    @property
    @pulumi.getter(name="caCount")
    def ca_count(self) -> builtins.int:
        """
        Number of CA replicas
        """
        return pulumi.get(self, "ca_count")

    @property
    @pulumi.getter(name="consoleCount")
    def console_count(self) -> builtins.int:
        """
        Number of console replicas
        """
        return pulumi.get(self, "console_count")

    @property
    @pulumi.getter(name="proxyCount")
    def proxy_count(self) -> builtins.int:
        """
        Number of REST proxy replicas
        """
        return pulumi.get(self, "proxy_count")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemResult(dict):
    def __init__(__self__, *,
                 ca_cert_archive_text: builtins.str,
                 compartment_id: builtins.str,
                 component_details: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult'],
                 compute_shape: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 federated_user_id: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 host_ocpu_utilization_infos: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult'],
                 id: builtins.str,
                 idcs_access_token: builtins.str,
                 is_byol: builtins.bool,
                 is_multi_ad: builtins.bool,
                 lifecycle_details: builtins.str,
                 load_balancer_shape: builtins.str,
                 platform_role: builtins.str,
                 platform_shape_type: builtins.str,
                 platform_version: builtins.str,
                 replicas: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult'],
                 service_endpoint: builtins.str,
                 service_version: builtins.str,
                 state: builtins.str,
                 storage_size_in_tbs: builtins.float,
                 storage_used_in_tbs: builtins.float,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 total_ocpu_capacity: builtins.int):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailArgs'] component_details: Blockchain Platform component details.
        :param builtins.str compute_shape: Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE or ENTERPRISE_CUSTOM or DIGITAL_ASSETS_MEDIUM or DIGITAL_ASSETS_LARGE or DIGITAL_ASSETS_EXTRA_LARGE
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: Platform Instance Description
        :param builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Example: `My new resource`
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoArgs'] host_ocpu_utilization_infos: List of OcpuUtilization for all hosts
        :param builtins.str id: unique identifier that is immutable on creation
        :param builtins.bool is_byol: Bring your own license
        :param builtins.bool is_multi_ad: True for multi-AD blockchain plaforms, false for single-AD
        :param builtins.str lifecycle_details: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.str load_balancer_shape: Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
        :param builtins.str platform_role: Role of platform - FOUNDER or PARTICIPANT
        :param builtins.str platform_shape_type: Type of Platform shape - DEFAULT or CUSTOM
        :param builtins.str platform_version: Platform Version
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaArgs'] replicas: Number of replicas of service components like Rest Proxy, CA and Console
        :param builtins.str service_endpoint: Service endpoint URL, valid post-provisioning
        :param builtins.str service_version: The version of the Platform Instance.
        :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        :param builtins.float storage_size_in_tbs: Storage size in TBs
        :param builtins.float storage_used_in_tbs: Storage used in TBs
        :param builtins.str time_created: The time the the Platform Instance was created. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Platform Instance was updated. An RFC3339 formatted datetime string
        :param builtins.int total_ocpu_capacity: Number of total OCPUs allocated to the platform cluster
        """
        pulumi.set(__self__, "ca_cert_archive_text", ca_cert_archive_text)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "component_details", component_details)
        pulumi.set(__self__, "compute_shape", compute_shape)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "federated_user_id", federated_user_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "host_ocpu_utilization_infos", host_ocpu_utilization_infos)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        pulumi.set(__self__, "is_byol", is_byol)
        pulumi.set(__self__, "is_multi_ad", is_multi_ad)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "load_balancer_shape", load_balancer_shape)
        pulumi.set(__self__, "platform_role", platform_role)
        pulumi.set(__self__, "platform_shape_type", platform_shape_type)
        pulumi.set(__self__, "platform_version", platform_version)
        pulumi.set(__self__, "replicas", replicas)
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        pulumi.set(__self__, "service_version", service_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "storage_size_in_tbs", storage_size_in_tbs)
        pulumi.set(__self__, "storage_used_in_tbs", storage_used_in_tbs)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "total_ocpu_capacity", total_ocpu_capacity)

    @property
    @pulumi.getter(name="caCertArchiveText")
    def ca_cert_archive_text(self) -> builtins.str:
        return pulumi.get(self, "ca_cert_archive_text")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentDetails")
    def component_details(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult']:
        """
        Blockchain Platform component details.
        """
        return pulumi.get(self, "component_details")

    @property
    @pulumi.getter(name="computeShape")
    def compute_shape(self) -> builtins.str:
        """
        Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE or ENTERPRISE_CUSTOM or DIGITAL_ASSETS_MEDIUM or DIGITAL_ASSETS_LARGE or DIGITAL_ASSETS_EXTRA_LARGE
        """
        return pulumi.get(self, "compute_shape")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Platform Instance Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="federatedUserId")
    def federated_user_id(self) -> builtins.str:
        return pulumi.get(self, "federated_user_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostOcpuUtilizationInfos")
    def host_ocpu_utilization_infos(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult']:
        """
        List of OcpuUtilization for all hosts
        """
        return pulumi.get(self, "host_ocpu_utilization_infos")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> builtins.str:
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> builtins.bool:
        """
        Bring your own license
        """
        return pulumi.get(self, "is_byol")

    @property
    @pulumi.getter(name="isMultiAd")
    def is_multi_ad(self) -> builtins.bool:
        """
        True for multi-AD blockchain plaforms, false for single-AD
        """
        return pulumi.get(self, "is_multi_ad")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="loadBalancerShape")
    def load_balancer_shape(self) -> builtins.str:
        """
        Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
        """
        return pulumi.get(self, "load_balancer_shape")

    @property
    @pulumi.getter(name="platformRole")
    def platform_role(self) -> builtins.str:
        """
        Role of platform - FOUNDER or PARTICIPANT
        """
        return pulumi.get(self, "platform_role")

    @property
    @pulumi.getter(name="platformShapeType")
    def platform_shape_type(self) -> builtins.str:
        """
        Type of Platform shape - DEFAULT or CUSTOM
        """
        return pulumi.get(self, "platform_shape_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> builtins.str:
        """
        Platform Version
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult']:
        """
        Number of replicas of service components like Rest Proxy, CA and Console
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> builtins.str:
        """
        Service endpoint URL, valid post-provisioning
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> builtins.str:
        """
        The version of the Platform Instance.
        """
        return pulumi.get(self, "service_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageSizeInTbs")
    def storage_size_in_tbs(self) -> builtins.float:
        """
        Storage size in TBs
        """
        return pulumi.get(self, "storage_size_in_tbs")

    @property
    @pulumi.getter(name="storageUsedInTbs")
    def storage_used_in_tbs(self) -> builtins.float:
        """
        Storage used in TBs
        """
        return pulumi.get(self, "storage_used_in_tbs")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the Platform Instance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Platform Instance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalOcpuCapacity")
    def total_ocpu_capacity(self) -> builtins.int:
        """
        Number of total OCPUs allocated to the platform cluster
        """
        return pulumi.get(self, "total_ocpu_capacity")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailResult(dict):
    def __init__(__self__, *,
                 osns: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult'],
                 peers: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult']):
        """
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnArgs'] osns: List of OSNs
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerArgs'] peers: List of Peers
        """
        pulumi.set(__self__, "osns", osns)
        pulumi.set(__self__, "peers", peers)

    @property
    @pulumi.getter
    def osns(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult']:
        """
        List of OSNs
        """
        return pulumi.get(self, "osns")

    @property
    @pulumi.getter
    def peers(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult']:
        """
        List of Peers
        """
        return pulumi.get(self, "peers")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnResult(dict):
    def __init__(__self__, *,
                 ad: builtins.str,
                 ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult'],
                 osn_key: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str ad: Availability Domain of peer
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param builtins.str osn_key: OSN identifier
        :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        pulumi.set(__self__, "ad", ad)
        pulumi.set(__self__, "ocpu_allocation_params", ocpu_allocation_params)
        pulumi.set(__self__, "osn_key", osn_key)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> builtins.str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> builtins.str:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailOsnOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerResult(dict):
    def __init__(__self__, *,
                 ad: builtins.str,
                 alias: builtins.str,
                 host: builtins.str,
                 ocpu_allocation_params: Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult'],
                 peer_key: builtins.str,
                 role: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str ad: Availability Domain of peer
        :param builtins.str alias: peer alias
        :param builtins.str host: Host name of VM
        :param Sequence['GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamArgs'] ocpu_allocation_params: OCPU allocation parameter
        :param builtins.str peer_key: peer identifier
        :param builtins.str role: Peer role
        :param builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        pulumi.set(__self__, "ad", ad)
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ocpu_allocation_params", ocpu_allocation_params)
        pulumi.set(__self__, "peer_key", peer_key)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> builtins.str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        peer alias
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuAllocationParams")
    def ocpu_allocation_params(self) -> Sequence['outputs.GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult']:
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_params")

    @property
    @pulumi.getter(name="peerKey")
    def peer_key(self) -> builtins.str:
        """
        peer identifier
        """
        return pulumi.get(self, "peer_key")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Peer role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemComponentDetailPeerOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemHostOcpuUtilizationInfoResult(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 ocpu_capacity_number: builtins.float,
                 ocpu_utilization_number: builtins.float):
        """
        :param builtins.str host: Host name of VM
        :param builtins.float ocpu_capacity_number: Number of total OCPU capacity on the host
        :param builtins.float ocpu_utilization_number: Number of OCPU utilized
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ocpu_capacity_number", ocpu_capacity_number)
        pulumi.set(__self__, "ocpu_utilization_number", ocpu_utilization_number)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Host name of VM
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuCapacityNumber")
    def ocpu_capacity_number(self) -> builtins.float:
        """
        Number of total OCPU capacity on the host
        """
        return pulumi.get(self, "ocpu_capacity_number")

    @property
    @pulumi.getter(name="ocpuUtilizationNumber")
    def ocpu_utilization_number(self) -> builtins.float:
        """
        Number of OCPU utilized
        """
        return pulumi.get(self, "ocpu_utilization_number")


@pulumi.output_type
class GetBlockchainPlatformsBlockchainPlatformCollectionItemReplicaResult(dict):
    def __init__(__self__, *,
                 ca_count: builtins.int,
                 console_count: builtins.int,
                 proxy_count: builtins.int):
        """
        :param builtins.int ca_count: Number of CA replicas
        :param builtins.int console_count: Number of console replicas
        :param builtins.int proxy_count: Number of REST proxy replicas
        """
        pulumi.set(__self__, "ca_count", ca_count)
        pulumi.set(__self__, "console_count", console_count)
        pulumi.set(__self__, "proxy_count", proxy_count)

    @property
    @pulumi.getter(name="caCount")
    def ca_count(self) -> builtins.int:
        """
        Number of CA replicas
        """
        return pulumi.get(self, "ca_count")

    @property
    @pulumi.getter(name="consoleCount")
    def console_count(self) -> builtins.int:
        """
        Number of console replicas
        """
        return pulumi.get(self, "console_count")

    @property
    @pulumi.getter(name="proxyCount")
    def proxy_count(self) -> builtins.int:
        """
        Number of REST proxy replicas
        """
        return pulumi.get(self, "proxy_count")


@pulumi.output_type
class GetBlockchainPlatformsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOsnOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetOsnsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOsnsOsnCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOsnsOsnCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOsnsOsnCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOsnsOsnCollectionItemResult(dict):
    def __init__(__self__, *,
                 ad: builtins.str,
                 blockchain_platform_id: builtins.str,
                 ocpu_allocation_param: 'outputs.GetOsnsOsnCollectionItemOcpuAllocationParamResult',
                 osn_key: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str ad: Availability Domain of OSN
        :param builtins.str blockchain_platform_id: Unique service identifier.
        :param 'GetOsnsOsnCollectionItemOcpuAllocationParamArgs' ocpu_allocation_param: OCPU allocation parameter
        :param builtins.str osn_key: OSN identifier
        :param builtins.str state: The current state of the OSN.
        """
        pulumi.set(__self__, "ad", ad)
        pulumi.set(__self__, "blockchain_platform_id", blockchain_platform_id)
        pulumi.set(__self__, "ocpu_allocation_param", ocpu_allocation_param)
        pulumi.set(__self__, "osn_key", osn_key)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> builtins.str:
        """
        Availability Domain of OSN
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> builtins.str:
        """
        Unique service identifier.
        """
        return pulumi.get(self, "blockchain_platform_id")

    @property
    @pulumi.getter(name="ocpuAllocationParam")
    def ocpu_allocation_param(self) -> 'outputs.GetOsnsOsnCollectionItemOcpuAllocationParamResult':
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_param")

    @property
    @pulumi.getter(name="osnKey")
    def osn_key(self) -> builtins.str:
        """
        OSN identifier
        """
        return pulumi.get(self, "osn_key")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the OSN.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetOsnsOsnCollectionItemOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetPeerOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


@pulumi.output_type
class GetPeersFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPeersPeerCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPeersPeerCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPeersPeerCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPeersPeerCollectionItemResult(dict):
    def __init__(__self__, *,
                 ad: builtins.str,
                 alias: builtins.str,
                 blockchain_platform_id: builtins.str,
                 host: builtins.str,
                 ocpu_allocation_param: 'outputs.GetPeersPeerCollectionItemOcpuAllocationParamResult',
                 peer_key: builtins.str,
                 role: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str ad: Availability Domain of peer
        :param builtins.str alias: peer alias
        :param builtins.str blockchain_platform_id: Unique service identifier.
        :param builtins.str host: Host on which the Peer exists
        :param 'GetPeersPeerCollectionItemOcpuAllocationParamArgs' ocpu_allocation_param: OCPU allocation parameter
        :param builtins.str peer_key: peer identifier
        :param builtins.str role: Peer role
        :param builtins.str state: The current state of the peer.
        """
        pulumi.set(__self__, "ad", ad)
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "blockchain_platform_id", blockchain_platform_id)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ocpu_allocation_param", ocpu_allocation_param)
        pulumi.set(__self__, "peer_key", peer_key)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> builtins.str:
        """
        Availability Domain of peer
        """
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        peer alias
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> builtins.str:
        """
        Unique service identifier.
        """
        return pulumi.get(self, "blockchain_platform_id")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Host on which the Peer exists
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ocpuAllocationParam")
    def ocpu_allocation_param(self) -> 'outputs.GetPeersPeerCollectionItemOcpuAllocationParamResult':
        """
        OCPU allocation parameter
        """
        return pulumi.get(self, "ocpu_allocation_param")

    @property
    @pulumi.getter(name="peerKey")
    def peer_key(self) -> builtins.str:
        """
        peer identifier
        """
        return pulumi.get(self, "peer_key")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Peer role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the peer.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetPeersPeerCollectionItemOcpuAllocationParamResult(dict):
    def __init__(__self__, *,
                 ocpu_allocation_number: builtins.float):
        """
        :param builtins.float ocpu_allocation_number: Number of OCPU allocation
        """
        pulumi.set(__self__, "ocpu_allocation_number", ocpu_allocation_number)

    @property
    @pulumi.getter(name="ocpuAllocationNumber")
    def ocpu_allocation_number(self) -> builtins.float:
        """
        Number of OCPU allocation
        """
        return pulumi.get(self, "ocpu_allocation_number")


