# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AgentDependencyArgs', 'AgentDependency']

@pulumi.input_type
class AgentDependencyArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 dependency_name: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 namespace: pulumi.Input[builtins.str],
                 object: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 dependency_version: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AgentDependency resource.
        :param pulumi.Input[builtins.str] bucket: (Updatable) Object storage bucket where the dependency is uploaded.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment identifier.
        :param pulumi.Input[builtins.str] dependency_name: (Updatable) Name of the dependency type. This should match the whitelisted enum of dependency names.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Display name of the Agent dependency.
        :param pulumi.Input[builtins.str] namespace: (Updatable) Object storage namespace associated with the customer's tenancy.
        :param pulumi.Input[builtins.str] object: (Updatable) Name of the dependency object uploaded by the customer.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] dependency_version: (Updatable) Version of the Agent dependency.
        :param pulumi.Input[builtins.str] description: (Updatable) Description about the Agent dependency.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "dependency_name", dependency_name)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dependency_version is not None:
            pulumi.set(__self__, "dependency_version", dependency_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Object storage bucket where the dependency is uploaded.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dependencyName")
    def dependency_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Name of the dependency type. This should match the whitelisted enum of dependency names.
        """
        return pulumi.get(self, "dependency_name")

    @dependency_name.setter
    def dependency_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dependency_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Display name of the Agent dependency.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Object storage namespace associated with the customer's tenancy.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Name of the dependency object uploaded by the customer.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="dependencyVersion")
    def dependency_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Version of the Agent dependency.
        """
        return pulumi.get(self, "dependency_version")

    @dependency_version.setter
    def dependency_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dependency_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Description about the Agent dependency.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _AgentDependencyState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 checksum: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 dependency_name: Optional[pulumi.Input[builtins.str]] = None,
                 dependency_version: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 e_tag: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentDependency resources.
        :param pulumi.Input[builtins.str] bucket: (Updatable) Object storage bucket where the dependency is uploaded.
        :param pulumi.Input[builtins.str] checksum: The checksum associated with the dependency object returned by Object Storage.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] dependency_name: (Updatable) Name of the dependency type. This should match the whitelisted enum of dependency names.
        :param pulumi.Input[builtins.str] dependency_version: (Updatable) Version of the Agent dependency.
        :param pulumi.Input[builtins.str] description: (Updatable) Description about the Agent dependency.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Display name of the Agent dependency.
        :param pulumi.Input[builtins.str] e_tag: The eTag associated with the dependency object returned by Object Storage.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[builtins.str] namespace: (Updatable) Object storage namespace associated with the customer's tenancy.
        :param pulumi.Input[builtins.str] object: (Updatable) Name of the dependency object uploaded by the customer.
        :param pulumi.Input[builtins.str] state: The current state of AgentDependency.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The time when the AgentDependency was created. An RFC3339 formatted datetime string.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dependency_name is not None:
            pulumi.set(__self__, "dependency_name", dependency_name)
        if dependency_version is not None:
            pulumi.set(__self__, "dependency_version", dependency_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Object storage bucket where the dependency is uploaded.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The checksum associated with the dependency object returned by Object Storage.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="dependencyName")
    def dependency_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the dependency type. This should match the whitelisted enum of dependency names.
        """
        return pulumi.get(self, "dependency_name")

    @dependency_name.setter
    def dependency_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dependency_name", value)

    @property
    @pulumi.getter(name="dependencyVersion")
    def dependency_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Version of the Agent dependency.
        """
        return pulumi.get(self, "dependency_version")

    @dependency_version.setter
    def dependency_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dependency_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Description about the Agent dependency.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Display name of the Agent dependency.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The eTag associated with the dependency object returned by Object Storage.
        """
        return pulumi.get(self, "e_tag")

    @e_tag.setter
    def e_tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "e_tag", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Object storage namespace associated with the customer's tenancy.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the dependency object uploaded by the customer.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of AgentDependency.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the AgentDependency was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


class AgentDependency(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 dependency_name: Optional[pulumi.Input[builtins.str]] = None,
                 dependency_version: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Agent Dependency resource in Oracle Cloud Infrastructure Cloud Bridge service.

        Creates an AgentDependency.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_agent_dependency = oci.cloud_bridge.AgentDependency("test_agent_dependency",
            bucket=agent_dependency_bucket,
            compartment_id=compartment_id,
            dependency_name=agent_dependency_dependency_name,
            display_name=agent_dependency_display_name,
            namespace=agent_dependency_namespace,
            object=agent_dependency_object,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            dependency_version=agent_dependency_dependency_version,
            description=agent_dependency_description,
            freeform_tags={
                "Department": "Finance",
            },
            system_tags=agent_dependency_system_tags)
        ```

        ## Import

        AgentDependencies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudBridge/agentDependency:AgentDependency test_agent_dependency "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket: (Updatable) Object storage bucket where the dependency is uploaded.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] dependency_name: (Updatable) Name of the dependency type. This should match the whitelisted enum of dependency names.
        :param pulumi.Input[builtins.str] dependency_version: (Updatable) Version of the Agent dependency.
        :param pulumi.Input[builtins.str] description: (Updatable) Description about the Agent dependency.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Display name of the Agent dependency.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] namespace: (Updatable) Object storage namespace associated with the customer's tenancy.
        :param pulumi.Input[builtins.str] object: (Updatable) Name of the dependency object uploaded by the customer.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentDependencyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Agent Dependency resource in Oracle Cloud Infrastructure Cloud Bridge service.

        Creates an AgentDependency.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_agent_dependency = oci.cloud_bridge.AgentDependency("test_agent_dependency",
            bucket=agent_dependency_bucket,
            compartment_id=compartment_id,
            dependency_name=agent_dependency_dependency_name,
            display_name=agent_dependency_display_name,
            namespace=agent_dependency_namespace,
            object=agent_dependency_object,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            dependency_version=agent_dependency_dependency_version,
            description=agent_dependency_description,
            freeform_tags={
                "Department": "Finance",
            },
            system_tags=agent_dependency_system_tags)
        ```

        ## Import

        AgentDependencies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudBridge/agentDependency:AgentDependency test_agent_dependency "id"
        ```

        :param str resource_name: The name of the resource.
        :param AgentDependencyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentDependencyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 dependency_name: Optional[pulumi.Input[builtins.str]] = None,
                 dependency_version: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentDependencyArgs.__new__(AgentDependencyArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if dependency_name is None and not opts.urn:
                raise TypeError("Missing required property 'dependency_name'")
            __props__.__dict__["dependency_name"] = dependency_name
            __props__.__dict__["dependency_version"] = dependency_version
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if object is None and not opts.urn:
                raise TypeError("Missing required property 'object'")
            __props__.__dict__["object"] = object
            __props__.__dict__["system_tags"] = system_tags
            __props__.__dict__["checksum"] = None
            __props__.__dict__["e_tag"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(AgentDependency, __self__).__init__(
            'oci:CloudBridge/agentDependency:AgentDependency',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[builtins.str]] = None,
            checksum: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            dependency_name: Optional[pulumi.Input[builtins.str]] = None,
            dependency_version: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            e_tag: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            object: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'AgentDependency':
        """
        Get an existing AgentDependency resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket: (Updatable) Object storage bucket where the dependency is uploaded.
        :param pulumi.Input[builtins.str] checksum: The checksum associated with the dependency object returned by Object Storage.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] dependency_name: (Updatable) Name of the dependency type. This should match the whitelisted enum of dependency names.
        :param pulumi.Input[builtins.str] dependency_version: (Updatable) Version of the Agent dependency.
        :param pulumi.Input[builtins.str] description: (Updatable) Description about the Agent dependency.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Display name of the Agent dependency.
        :param pulumi.Input[builtins.str] e_tag: The eTag associated with the dependency object returned by Object Storage.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[builtins.str] namespace: (Updatable) Object storage namespace associated with the customer's tenancy.
        :param pulumi.Input[builtins.str] object: (Updatable) Name of the dependency object uploaded by the customer.
        :param pulumi.Input[builtins.str] state: The current state of AgentDependency.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The time when the AgentDependency was created. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentDependencyState.__new__(_AgentDependencyState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["dependency_name"] = dependency_name
        __props__.__dict__["dependency_version"] = dependency_version
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["e_tag"] = e_tag
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["object"] = object
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        return AgentDependency(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Object storage bucket where the dependency is uploaded.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def checksum(self) -> pulumi.Output[builtins.str]:
        """
        The checksum associated with the dependency object returned by Object Storage.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="dependencyName")
    def dependency_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Name of the dependency type. This should match the whitelisted enum of dependency names.
        """
        return pulumi.get(self, "dependency_name")

    @property
    @pulumi.getter(name="dependencyVersion")
    def dependency_version(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Version of the Agent dependency.
        """
        return pulumi.get(self, "dependency_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Description about the Agent dependency.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Display name of the Agent dependency.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> pulumi.Output[builtins.str]:
        """
        The eTag associated with the dependency object returned by Object Storage.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Object storage namespace associated with the customer's tenancy.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Name of the dependency object uploaded by the customer.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of AgentDependency.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time when the AgentDependency was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

