# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAdhocQueryResult',
    'AwaitableGetAdhocQueryResult',
    'get_adhoc_query',
    'get_adhoc_query_output',
]

@pulumi.output_type
class GetAdhocQueryResult:
    """
    A collection of values returned by getAdhocQuery.
    """
    def __init__(__self__, adhoc_query_details=None, adhoc_query_id=None, adhoc_query_regional_details=None, compartment_id=None, defined_tags=None, error_message=None, freeform_tags=None, id=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None):
        if adhoc_query_details and not isinstance(adhoc_query_details, list):
            raise TypeError("Expected argument 'adhoc_query_details' to be a list")
        pulumi.set(__self__, "adhoc_query_details", adhoc_query_details)
        if adhoc_query_id and not isinstance(adhoc_query_id, str):
            raise TypeError("Expected argument 'adhoc_query_id' to be a str")
        pulumi.set(__self__, "adhoc_query_id", adhoc_query_id)
        if adhoc_query_regional_details and not isinstance(adhoc_query_regional_details, list):
            raise TypeError("Expected argument 'adhoc_query_regional_details' to be a list")
        pulumi.set(__self__, "adhoc_query_regional_details", adhoc_query_regional_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adhocQueryDetails")
    def adhoc_query_details(self) -> Sequence['outputs.GetAdhocQueryAdhocQueryDetailResult']:
        """
        Detailed information about the adhoc query.
        """
        return pulumi.get(self, "adhoc_query_details")

    @property
    @pulumi.getter(name="adhocQueryId")
    def adhoc_query_id(self) -> builtins.str:
        return pulumi.get(self, "adhoc_query_id")

    @property
    @pulumi.getter(name="adhocQueryRegionalDetails")
    def adhoc_query_regional_details(self) -> Sequence['outputs.GetAdhocQueryAdhocQueryRegionalDetailResult']:
        """
        Instance level status for each region
        """
        return pulumi.get(self, "adhoc_query_regional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID of the adhoc query
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> builtins.str:
        """
        Error message to show on UI in case of failure
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        OCID for the adhoc query
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the adhoc query
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the adhoc query was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the adhoc query was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAdhocQueryResult(GetAdhocQueryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAdhocQueryResult(
            adhoc_query_details=self.adhoc_query_details,
            adhoc_query_id=self.adhoc_query_id,
            adhoc_query_regional_details=self.adhoc_query_regional_details,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            error_message=self.error_message,
            freeform_tags=self.freeform_tags,
            id=self.id,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_adhoc_query(adhoc_query_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAdhocQueryResult:
    """
    This data source provides details about a specific Adhoc Query resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns an adhoc query identified by adhocQueryId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_adhoc_query = oci.CloudGuard.get_adhoc_query(adhoc_query_id=test_adhoc_query_oci_cloud_guard_adhoc_query["id"])
    ```


    :param builtins.str adhoc_query_id: Adhoc query OCID.
    """
    __args__ = dict()
    __args__['adhocQueryId'] = adhoc_query_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getAdhocQuery:getAdhocQuery', __args__, opts=opts, typ=GetAdhocQueryResult).value

    return AwaitableGetAdhocQueryResult(
        adhoc_query_details=pulumi.get(__ret__, 'adhoc_query_details'),
        adhoc_query_id=pulumi.get(__ret__, 'adhoc_query_id'),
        adhoc_query_regional_details=pulumi.get(__ret__, 'adhoc_query_regional_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        error_message=pulumi.get(__ret__, 'error_message'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_adhoc_query_output(adhoc_query_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAdhocQueryResult]:
    """
    This data source provides details about a specific Adhoc Query resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns an adhoc query identified by adhocQueryId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_adhoc_query = oci.CloudGuard.get_adhoc_query(adhoc_query_id=test_adhoc_query_oci_cloud_guard_adhoc_query["id"])
    ```


    :param builtins.str adhoc_query_id: Adhoc query OCID.
    """
    __args__ = dict()
    __args__['adhocQueryId'] = adhoc_query_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getAdhocQuery:getAdhocQuery', __args__, opts=opts, typ=GetAdhocQueryResult)
    return __ret__.apply(lambda __response__: GetAdhocQueryResult(
        adhoc_query_details=pulumi.get(__response__, 'adhoc_query_details'),
        adhoc_query_id=pulumi.get(__response__, 'adhoc_query_id'),
        adhoc_query_regional_details=pulumi.get(__response__, 'adhoc_query_regional_details'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        error_message=pulumi.get(__response__, 'error_message'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
