# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWlpAgentsResult',
    'AwaitableGetWlpAgentsResult',
    'get_wlp_agents',
    'get_wlp_agents_output',
]

@pulumi.output_type
class GetWlpAgentsResult:
    """
    A collection of values returned by getWlpAgents.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, wlp_agent_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if wlp_agent_collections and not isinstance(wlp_agent_collections, list):
            raise TypeError("Expected argument 'wlp_agent_collections' to be a list")
        pulumi.set(__self__, "wlp_agent_collections", wlp_agent_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID of WlpAgent.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWlpAgentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="wlpAgentCollections")
    def wlp_agent_collections(self) -> Sequence['outputs.GetWlpAgentsWlpAgentCollectionResult']:
        """
        The list of wlp_agent_collection.
        """
        return pulumi.get(self, "wlp_agent_collections")


class AwaitableGetWlpAgentsResult(GetWlpAgentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlpAgentsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            wlp_agent_collections=self.wlp_agent_collections)


def get_wlp_agents(compartment_id: Optional[builtins.str] = None,
                   filters: Optional[Sequence[Union['GetWlpAgentsFilterArgs', 'GetWlpAgentsFilterArgsDict']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlpAgentsResult:
    """
    This data source provides the list of Wlp Agents in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of WLP agents in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wlp_agents = oci.CloudGuard.get_wlp_agents(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The OCID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getWlpAgents:getWlpAgents', __args__, opts=opts, typ=GetWlpAgentsResult).value

    return AwaitableGetWlpAgentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        wlp_agent_collections=pulumi.get(__ret__, 'wlp_agent_collections'))
def get_wlp_agents_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWlpAgentsFilterArgs', 'GetWlpAgentsFilterArgsDict']]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlpAgentsResult]:
    """
    This data source provides the list of Wlp Agents in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of WLP agents in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wlp_agents = oci.CloudGuard.get_wlp_agents(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The OCID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getWlpAgents:getWlpAgents', __args__, opts=opts, typ=GetWlpAgentsResult)
    return __ret__.apply(lambda __response__: GetWlpAgentsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        wlp_agent_collections=pulumi.get(__response__, 'wlp_agent_collections')))
