# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPodShapesResult',
    'AwaitableGetPodShapesResult',
    'get_pod_shapes',
    'get_pod_shapes_output',
]

@pulumi.output_type
class GetPodShapesResult:
    """
    A collection of values returned by getPodShapes.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, id=None, name=None, pod_shapes=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pod_shapes and not isinstance(pod_shapes, list):
            raise TypeError("Expected argument 'pod_shapes' to be a list")
        pulumi.set(__self__, "pod_shapes", pod_shapes)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPodShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the identifying shape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="podShapes")
    def pod_shapes(self) -> Sequence['outputs.GetPodShapesPodShapeResult']:
        """
        The list of pod_shapes.
        """
        return pulumi.get(self, "pod_shapes")


class AwaitableGetPodShapesResult(GetPodShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPodShapesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            pod_shapes=self.pod_shapes)


def get_pod_shapes(availability_domain: Optional[builtins.str] = None,
                   compartment_id: Optional[builtins.str] = None,
                   filters: Optional[Sequence[Union['GetPodShapesFilterArgs', 'GetPodShapesFilterArgsDict']]] = None,
                   name: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPodShapesResult:
    """
    This data source provides the list of Pod Shapes in Oracle Cloud Infrastructure Container Engine service.

    List all the Pod Shapes in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pod_shapes = oci.ContainerEngine.get_pod_shapes(compartment_id=compartment_id,
        availability_domain=pod_shape_availability_domain,
        name=pod_shape_name)
    ```


    :param builtins.str availability_domain: The availability domain of the pod shape.
    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str name: The name to filter on.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getPodShapes:getPodShapes', __args__, opts=opts, typ=GetPodShapesResult).value

    return AwaitableGetPodShapesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        pod_shapes=pulumi.get(__ret__, 'pod_shapes'))
def get_pod_shapes_output(availability_domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPodShapesFilterArgs', 'GetPodShapesFilterArgsDict']]]]] = None,
                          name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPodShapesResult]:
    """
    This data source provides the list of Pod Shapes in Oracle Cloud Infrastructure Container Engine service.

    List all the Pod Shapes in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pod_shapes = oci.ContainerEngine.get_pod_shapes(compartment_id=compartment_id,
        availability_domain=pod_shape_availability_domain,
        name=pod_shape_name)
    ```


    :param builtins.str availability_domain: The availability domain of the pod shape.
    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str name: The name to filter on.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getPodShapes:getPodShapes', __args__, opts=opts, typ=GetPodShapesResult)
    return __ret__.apply(lambda __response__: GetPodShapesResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        pod_shapes=pulumi.get(__response__, 'pod_shapes')))
